(provide 'snd-peak-phases.scm)
(load "primes.scm")

;;; multiply these phases by pi before use as initial-phases (and use sin, not cos -- see tstall below)


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

#(1  1.0    #(0))
#(2  1.76   #(0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots (vct -2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works for small n
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the 1st min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0 [this argument assumes the peak loc is not jumping around randomly]
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 global mins
;;   so it's messier.


;; there's always an equivalent point found by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
#(3  2.1949383250709 #(0 0 1)

     1.9798054823226 #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
     1.9798054823222 #(0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
     1.9798054823226 #(0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
     1.9798054823222 #(0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)

     ;; :(tstall '#(0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for #(0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 #(0.0 0.41022177723939 1.6832780274654)
     1.979716725384 #(0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 #(0.0 1.4102202429311 1.6832728267862)
     )


;;; 4 all --------------------------------------------------------------------------------
#(4  2.2962718935302 #(0 1 1 1)

     2.040  #(0 33/35 67/50 10/9)               ;#(0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 #(0.000 0.072 0.674 1.912)
     2.04012799263 #(0.000 0.928 1.326 1.088)
     2.04012799263 #(0.000 1.072 0.674 0.912)
     2.04012799263 #(0.000 1.928 1.326 0.088)

     2.0392323180235 #(0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 #(0.000000 0.944585 1.341508 1.115059)
     2.038954 #(0.000000 1.055406 0.658486 0.884929)
     2.038954 #(0.000000 0.055405 0.658485 1.884926)
     2.038954 #(0.000000 1.944593 1.341515 0.115071)
     )

;;; 5 all -------------------------------------------------------------------------------- ; 2.23
#(5  2.5405211753511 #(0 1 0 0 0)

     2.3434929847717 #(0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 #(0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 #(0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 #(0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 #(0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 #(0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 #(0.000000 0.154687 0.335490 1.579647 0.406677)
     2.343508 #(0.000000 1.845332 1.664532 0.420369 1.593338)
     )

;;; 6 all -------------------------------------------------------------------------------- ; 2.4494
#(6  2.8200183503167 #(0 0 0 0 1 0) 

     2.5598928928375 #(0.0 0.91140931844711 0.34124284982681 1.3568490743637 1.4451304674149 1.2563138008118)
     2.5509102344513 #(0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 #(0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 #(0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 #(0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 #(0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 #(0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     2.549360 #(0.000000 0.886491 0.264319 1.300337 1.330828 1.157371)
     )

;;; 7 all -------------------------------------------------------------------------------- ; 2.64575
#(7  3.072141248417 #(0 0 0 1 1 0 1)

     2.639426 #(0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 #(0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 #(0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 #(0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; 2.8284
#(8  3.5725696916739 #(0 1 0 0 0 0 1 1)
     3.4905790371793 #(0 1 0 0 1 1 1 0)

     2.795099 #(0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794973 #(0.000000 0.666912 0.808057 1.605873 0.837778 0.045418 0.145384 -0.125627)
     2.794748 #(0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 #(0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 #(0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     )

;;; 9 all --------------------------------------------------------------------------------
#(9  3.7118878501776 #(0 0 0 0 1 0 0 0 1)
     3.5954569026984 #(0 1 1 0 1 0 1 1 1)

     2.962087 #(0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 #(0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 #(0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 #(0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 #(0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)
     )

;;; 10 all -------------------------------------------------------------------------------- ; 3.162
#(10 3.8132503352626 #(0 1 0 1 0 0 0 0 0 1)
     3.7726427002737 #(0 1 1 0 0 0 0 1 0 1)
     3.7587492407668 #(0 1 1 0 1 1 1 0 0 0)
     3.7587492407668 #(0 0 1 1 1 0 1 1 0 1)

     3.102964 #(0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 #(0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 #(0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 #(0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102729 #(0.000000 -0.072172 1.602638 1.494434 -0.054524 1.785698 0.940876 0.169981 0.895530 1.495531)
     3.102679 #(0.000000 -0.071505 1.603768 1.495148 -0.052966 1.786780 0.942656 0.171631 0.897221 1.498092)
     )

;;; 11 all -------------------------------------------------------------------------------- ; 3.31662
#(11 4.0969838225299 #(0 0 1 1 0 0 0 0 1 0 1)
     4.0506916989601 #(0 0 0 1 1 1 1 0 1 1 0)
     3.8018732822274 #(0 1 0 0 1 0 0 0 1 1 1)
     3.8018732822274 #(0 0 0 1 1 1 0 1 1 0 1)

     3.218779 #(0.000000 1.481192 0.090871 1.382649 0.458289 0.338680 0.056042 0.328676 0.834049 1.786486 1.800056)
     3.218745  #(0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     3.218587 #(0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 #(0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)
     3.218444 #(0.000000 0.482127 0.090769 0.383093 0.459045 1.339823 0.056682 1.328792 0.834826 0.787716 -0.199032)
     )

;;; 12 all -------------------------------------------------------------------------------- ; 3.464
#(12 3.761           #(0 0 1 1 0 0 0 0 0 1 0 1)
     3.7616552322386 #(0 1 1 0 0 1 0 1 0 0 0 0)

     3.390214 #(0.000000 1.090729 0.365806 1.643109 0.802167 1.224244 0.152508 0.190760 1.518783 1.662203 1.561813 -0.056814)
     3.389584 #(0.000000 0.081158 0.353056 0.623087 0.775861 0.199327 0.127597 1.160276 1.479330 0.612404 1.515935 0.889377)
     3.389586 #(0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 #(0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389430 #(0.000000 1.081078 0.354514 1.624157 0.776410 1.200581 0.129241 0.162495 1.480822 1.614178 1.518801 1.892528)
     3.389128 #(0.000000 1.076659 0.348730 1.615059 0.764020 1.188577 0.117561 0.148053 1.462454 1.591386 1.497945 1.868055)
     )

;;; 13 all -------------------------------------------------------------------------------- ; 3.6055
#(13 4.2969298731102 #(0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.1211657406183 #(0 0 0 0 0 0 1 1 0 0 1 0 1) 

     3.525309 #(0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 #(0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 #(0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 #(0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)

     3.525038 #(0.000000 0.946517 1.827042 0.361916 1.539603 0.484426 0.141403 0.938505 0.992273 1.893878 -0.015423 1.830018 1.372777)
     3.524879 #(0.000000 0.948502 1.829668 0.364984 1.544240 0.488687 0.147763 0.945396 1.000061 1.903153 -0.004551 1.840699 1.384079)
     )

;;; 14 all -------------------------------------------------------------------------------- ; 3.7416
#(14 4.3488449994701 #(0 0 1 1 0 1 0 1 1 0 0 0 0 0)
     4.1603193984251 #(0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     3.615056 #(0.000000 -0.014234 1.497005 1.525139 0.510798 0.632906 1.943720 0.571193 0.639383 0.229407 1.337049 0.146893 1.848962 0.407090)
     3.613339 #(0.000000 1.024769 1.581138 0.589649 0.616118 1.792590 0.082043 1.743552 0.858157 1.441060 1.566137 1.409695 0.151752 1.740508)
     3.613280 #(0.000000 0.028982 0.530538 0.496734 -0.474935 -0.580078 0.104750 1.488617 -0.565757 -0.157842 -1.258035 -0.057079 0.253472 -0.294346)
     3.613121 #(0.000000 0.028974 0.530453 0.496128 -0.475742 -0.580534 0.104588 -0.512201 1.433649 1.841085 0.741103 -0.058374 0.252301 -0.295482)
     )

;;; 15 all -------------------------------------------------------------------------------- ; 3.8729
#(15 4.4060654286219 #(0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; 3.87298 (3.8729833462074)

     3.769174 #(0.000000 0.861484 1.066267 1.645788 0.266828 0.280266 1.728769 1.041069 0.986580 -0.030711 1.080503 1.645587 1.174768 1.625077 1.375877)
     3.768991 #(0.000000 0.863434 1.069349 1.651266 0.272078 0.287377 1.735528 1.050008 0.997192 -0.020076 1.092043 1.658049 1.188297 1.641481 1.391589)
     )

;;; 16 all --------------------------------------------------------------------------------
#(16 4.6832396970099 #(0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)
     4.5445760745314 #(0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.880044 #(0.000000 1.305525 1.470275 0.177035 0.840097 1.175803 -0.045240 1.607574 1.078362 0.676837 1.296177 0.358482 1.543390 0.161953 0.029701 -1.946850)
     3.875293 #(0.000000 0.731415 0.678125 1.193317 1.630455 1.274923 -0.010275 1.463125 0.520861 0.201904 -0.170540 -0.119593 1.314021 1.618273 0.238721 1.406287)
     3.875080 #(0.000000 0.730612 0.678979 1.195144 1.632126 1.276744 -0.008560 1.467028 0.525375 0.204869 -0.166129 -0.115302 1.317856 1.622654 0.244306 1.412402)
     )

;;; 17 all -------------------------------------------------------------------------------- ; 4.1231
#(17 4.7478643837553 #(0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1)
     4.7478643837553 #(0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1)
     4.7654988506492 #(0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)
     4.7654988506492 #(0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1)

     4.014837 #(0.000000 1.466046 1.041812 -0.108499 1.356223 0.981589 1.262667 0.715209 0.388569 1.081759 1.825430 0.656039 1.178209 0.785251 1.435495 -0.342701 -0.159210)
     4.009869 #(0.000000 1.659692 0.153864 0.208373 0.465377 0.801497 0.333865 -0.306619 0.133983 0.553164 0.090623 1.393118 -0.083771 1.035016 -1.047840 0.020577 0.849233)
     3.981459 #(0.000000 0.520484 1.429480 0.505816 -0.891395 0.114390 0.146335 0.416197 0.938893 0.898753 0.507264 0.650687 -0.081499 -0.607990 0.213218 -0.096782 -0.652476)
     )

;;; 18 all -------------------------------------------------------------------------------- ; 4.24264
#(18 4.9109328272248 #(0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0)
     4.8247395547715 #(0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0)
     4.795  #(0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.160068 #(0.000000 1.247966 0.634845 0.085105 1.281747 1.591288 0.560708 1.554818 0.532041 1.253325 0.973787 0.305025 0.369962 0.426191 -0.060193 0.478556 0.689072 1.025864)
     4.149424 #(0.000000 0.783719 1.424772 -0.028969 0.797469 0.495441 1.555906 0.574291 1.602121 0.919568 1.186181 1.878000 1.832983 1.781966 0.287268 1.741363 1.571076 1.265215)
     4.145376 #(0.000000 0.815970 1.442468 0.022437 0.838057 0.561089 1.647234 0.678944 1.711039 1.021597 1.327383 0.016884 -0.030470 1.937927 0.480054 1.947188 1.779952 1.482341)
     )

;;; 19 all -------------------------------------------------------------------------------- ; 4.35889
#(19 5.0964118877766 #(0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 0 0 0 1)
     5.0269187181249 #(0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0)
     5.0140104455275 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0)
     4.957  #(0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.256823 #(0.000000 0.950552 1.078946 1.827333 0.322429 0.515165 1.448194 1.262486 0.963019 0.265994 0.371763 0.920917 0.630954 0.586208 1.035067 0.365945 1.213903 0.045859 1.507359)
     4.236757 #(0.000000 1.035424 1.317375 0.882321 0.748630 1.392844 1.209695 0.917957 1.063517 0.320073 1.579879 0.456384 1.606003 -0.204593 -1.100470 0.700110 1.199787 1.220259 -0.044138)
     4.223666 #(0.000000 0.962025 0.721631 1.138738 1.342295 0.675056 0.848936 1.157044 1.060853 -0.213787 0.531124 1.684505 0.561245 0.375645 1.309393 -0.531388 0.959835 0.983902 0.285296)
     )

;;; 20 all -------------------------------------------------------------------------------- ; 4.4721
#(20 5.2602326468873 #(0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1)
     5.2536671092168 #(0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1) 
     5.2516581503036 #(0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1)
     5.2027356749364 #(0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0) 
     5.202707605727 #(0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)

     4.290058 #(0.000000 1.287568 1.468290 -0.170532 1.858695 0.280488 0.217365 -0.031942 0.876344 1.219692 0.026561 0.381289 1.735799 1.508060 1.291588 0.006572 1.225731 0.645841 1.236621 0.419452)
     )

;;; 21 all -------------------------------------------------------------------------------- ; 4.5825
#(21 5.3651112556805 #(0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1)
     5.3503630356826 #(0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1)
     5.3430035169068 #(0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1)
     5.3468859417495 #(0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1)
     5.3164971341632 #(0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 0) 
     5.3164971341632 #(0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     4.484397 #(0.000000 1.399581 1.230490 1.289720 -0.005391 1.417174 -0.222099 1.544621 0.160786 1.057475 0.320522 1.788712 1.040114 0.988797 1.529192 0.536731 0.600787 0.298519 0.720851 1.592406 -0.083584)
     )

;;; 22 all -------------------------------------------------------------------------------- ; 4.6904
#(22 5.3384906472168 #(0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     5.3118962410791 #(0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0)
     5.29249935509144 #(0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1) 
     5.292244006282 #(0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     4.622803 #(0.000000 1.340373 0.970954 1.002159 0.880275 1.416080 1.819200 1.007752 0.255081 0.347189 0.600359 0.574629 0.015990 0.999438 1.635477 0.619917 0.631959 1.121023 0.599154 1.883352 0.740818 1.129065)
     4.588140 #(0.000000 -0.096778 1.080722 0.593207 -0.254680 1.023732 0.716557 1.901465 -0.019583 0.278478 1.160188 0.996330 1.054608 1.061984 1.434750 0.905801 0.882108 1.425520 0.362314 1.555862 0.347441 1.064021)
     )

;;; 23 all -------------------------------------------------------------------------------- ; 4.7958
#(23 5.5572876930237 #(0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0)
     5.35928895203514 #(0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1) 
     5.3592889520338 #(0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.607681 #(0.000000 0.689399 -0.223358 0.265838 1.213936 0.913933 0.191373 1.489050 1.370717 0.847890 0.362722 0.592331 0.586381 0.000455 1.084840 1.698411 1.578127 0.043618 0.291463 1.342365 0.078224 -0.076344 0.195753)
     )

;;; 24 all -------------------------------------------------------------------------------- ; 4.89897
#(24 5.7082858085632 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0)
     5.6697635650635 #(0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     5.6446962356567 #(0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0)
     5.635  #(0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1) 
     5.6358969066981 #(0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.730847 #(0.000000 1.860054 1.365565 1.300661 0.304467 0.364421 -0.013175 0.287107 1.148150 1.732528 0.305694 1.054141 0.959139 0.689514 0.150812 0.767232 0.724213 0.359240 1.442900 0.475499 1.678401 0.330818 0.144568 0.751992)
     )

;;; 25 all -------------------------------------------------------------------------------- ; 5
#(25 5.7284736633301 #(0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0)
     5.7190117835999 #(0 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1)
     5.6488965032573 #(0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0) 
     5.6488965032573 #(0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.855641 #(0.000000 0.229926 1.726904 0.449778 0.015484 0.016859 0.462379 0.871412 0.609322 0.654662 0.062760 0.825989 0.576895 -0.081196 -0.112104 1.739215 0.575276 0.891044 1.388407 0.667892 1.843741 1.342090 1.776343 0.652054 1.004535)
     )

;;; 26 all -------------------------------------------------------------------------------- ; 5.0990
#(26 5.8922033309937 #(0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0)
     5.8206262588501 #(0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0)
     5.78661186695166 #(0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1) 
     5.7865648269653 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     5.023346 #(0.000000 0.471497 0.419434 0.860585 1.369474 -0.146335 1.642121 0.161223 1.825222 0.594228 1.689539 0.413066 1.098262 1.472516 1.249094 1.170567 0.839656 0.942436 0.149512 -0.243079 1.269486 1.068124 -0.150509 1.648862 0.945727 1.703664)
     5.008256 #(0.000000 0.356007 0.611393 0.800030 0.608139 -0.552559 0.276762 0.954695 0.541230 0.391873 0.749201 -0.287679 0.663114 1.822966 -0.042535 -0.215786 1.534399 0.896769 0.284021 0.968921 0.944615 0.005656 -0.473527 0.937503 1.376587 0.108845)
     )

;;; 27 all -------------------------------------------------------------------------------- ; 5.1961
#(27 5.980658531189 #(0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     5.8753982451551 #(0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0) 
     5.8753981590271 #(0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.066453 #(0.000000 1.180887 1.012981 -0.037241 0.953126 0.743204 0.046304 -0.010627 1.594368 1.830120 1.926912 0.836044 0.497153 0.820806 0.580883 1.308790 0.813677 0.203614 0.448890 0.870192 1.163708 0.319673 0.498880 -0.075386 0.820143 1.666968 0.421343)
     )

;;; 28 all -------------------------------------------------------------------------------- ; 5.2915
#(28 6.1332263946533 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0)
     6.107029914856 #(0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     6.0962085723877 #(0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0) 
     6.0962085723877 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.201582 #(0.000000 -0.594236 0.471372 -0.239106 0.026372 1.367317 -1.367383 0.475651 -0.077031 -1.126466 0.500322 -0.840077 0.289150 0.017573 1.087716 1.066819 1.177512 0.077022 0.675500 0.393911 1.002792 0.832733 0.902383 1.149342 0.256199 0.532177 1.776896 0.135269)
     5.161016 #(0.000000 0.609398 -0.031546 0.163654 1.750544 0.009072 1.168722 1.319687 0.754527 1.449905 0.404768 1.387397 -0.443377 1.700390 0.448442 1.105795 0.302344 0.108046 0.813277 -1.223453 0.735575 -0.228080 1.376959 0.772459 0.355021 0.857861 0.747767 -0.540969)
     )

;;; 29 all -------------------------------------------------------------------------------- ; 5.38516
#(29 6.2162199020386 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     6.2025485038757 #(0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1)
     6.1994609975558 #(0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 0)
     6.168496131897 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1) 
     6.168496131897 #(0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.244731 #(0.000000 1.423197 1.434334 0.954277 0.877662 1.948724 1.591838 0.966340 0.952717 1.429672 0.787029 0.555356 0.405697 0.817643 1.603999 0.138279 0.926533 1.343354 1.048968 1.281826 1.347978 1.753988 1.784362 0.779861 0.066133 1.166301 0.329314 1.131806 1.874060)
     )

;;; 30 all -------------------------------------------------------------------------------- ; 5.4772
#(30 6.3668465614319 #(0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1) 
     6.3080444335938 #(0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1)
     6.2868418693542 #(0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1)
     6.257221698761 #(0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.396180 #(0.000000 1.520615 0.225616 0.287942 1.352721 1.627968 0.463888 1.771367 0.587849 1.027773 -0.033501 -0.102620 0.226920 1.922043 0.200259 0.023109 0.666954 1.058135 0.756098 1.607795 0.775242 0.535327 1.831042 0.484415 1.540370 1.001150 0.363611 0.315720 1.783111 -0.093791)
     5.366694 #(0.000000 1.367293 0.678335 1.056059 -0.506652 0.354228 0.103786 0.546097 0.755979 0.321279 -0.471933 -0.199299 0.505109 0.194951 -0.044195 1.645993 0.866175 1.019312 1.251553 0.153557 0.520073 -0.271182 0.225402 -0.451939 0.517701 0.215495 0.989027 0.341703 0.791872 0.749094)
     )

;;; 31 all -------------------------------------------------------------------------------- ; 5.56776
#(31 6.4472563825087 #(0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1) 
     6.3776631355286 #(0 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1)
     6.3353910446167 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)
     6.3243918418884 #(0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

     5.483548 #(0.000000 1.716513 0.734155 1.284407 0.002926 1.138357 1.651222 0.840380 0.862951 0.362868 -0.011541 1.508984 0.900956 1.004294 1.662373 0.522900 0.542553 0.647212 1.649604 0.938574 0.006447 1.743627 0.420681 1.628282 0.676409 0.803864 1.141938 1.155986 0.676801 1.099313 1.174563)
     )

;;; 32 all -------------------------------------------------------------------------------- ; 5.65685
#(32 6.5261273384094 #(0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0)
     6.4710988998413 #(0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0)
     6.4692246308309 #(0 0 1 1 0 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0)
     6.4519599479542 #(0 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1)
     6.4451498985291 #(0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.529767 #(0.000000 -0.357496 1.295472 -0.244166 0.378862 0.343677 0.387655 0.125795 0.157477 1.354195 0.239429 0.278240 0.142338 1.318038 1.716131 1.194338 1.731815 1.633958 0.445551 0.658322 0.932928 0.324708 1.907298 1.327700 0.501470 1.391423 1.750708 0.386360 0.706755 0.076956 0.832906 -0.015253)
     )

;;; 33 all -------------------------------------------------------------------------------- ; 5.74456
#(33 6.678719997406 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 0) 
     6.6342549324036 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1)
     6.6147227287292 #(0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0)
     6.5579299926758 #(0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.635107 #(0.000000 0.096917 0.534048 0.844232 0.664210 0.830370 1.909422 0.035015 0.156012 0.327754 1.408862 -0.022849 0.930596 1.245585 0.370155 0.652349 -0.062548 1.851506 0.444607 0.245493 0.778912 0.461144 -0.163445 0.929749 0.597185 1.314796 1.697920 1.195133 0.256759 1.266343 1.688596 1.108980 0.567202)
     )

;;; 34 all -------------------------------------------------------------------------------- ; 5.8309518
#(34 6.7310481071472 #(0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
     6.7281470298767 #(0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.7141165733337 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0)
     6.6820402145386 #(0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 0)
     6.6788883209229 #(0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0)
     6.6782836914062 #(0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.721275 #(0.000000 1.537213 0.239671 0.278042 1.094883 0.274881 0.871861 1.496857 1.521795 0.761213 1.656084 0.025131 1.235452 0.206266 1.321622 0.722819 0.794646 1.810454 1.109962 1.456186 1.070438 0.656560 1.724659 1.407688 -0.522881 1.349622 1.540863 1.488043 0.627895 0.673112 0.878488 -0.129260 -0.021006 0.554817)
     )

;;; 35 all -------------------------------------------------------------------------------- ; 5.9160
#(35 6.8652677536011 #(0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)
     6.8216953277588 #(0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     6.7839112281799 #(0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0)
     6.7759642601013 #(0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     6.7637429237366 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.769511 #(0.000000 0.102697 1.401830 0.818397 1.461851 0.154032 1.618494 1.534460 1.543814 0.875127 1.319240 1.294792 1.413591 0.147300 1.056367 0.647379 1.391041 1.070554 0.137544 0.362172 1.848827 1.486280 0.790850 1.754258 0.990175 1.205429 0.198438 -0.165833 0.163564 -0.016866 0.359072 0.684081 1.633963 0.564667 0.903834)
     )

;;; 36 all -------------------------------------------------------------------------------- ; 6
#(36 6.9388113021851 #(0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 0)
     6.934184551239 #(0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0)
     6.9237461090088 #(0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0)
     6.9208335876465 #(0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1)
     6.8763957023621 #(0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0)
     6.8008880615234 #(0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     5.931449 #(0.000000 1.020268 0.677676 0.141480 0.933164 0.775943 0.190974 1.852375 0.763224 0.240685 0.277882 0.163474 1.552588 0.007697 0.283092 1.674709 -0.345165 0.591058 0.945716 0.824253 0.043245 -0.089554 0.231180 1.353274 0.983801 0.173104 0.583544 0.693163 1.001038 0.832122 1.162817 1.689517 0.636045 1.729156 0.451707 1.432502)
     )

;;; 37 all -------------------------------------------------------------------------------- ; 6.0827
#(37 7.1209874153137 #(0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0)
     7.1156206130981 #(0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0)
     7.1152505874634 #(0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0)
     7.1046371459961 #(0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0)
     7.0939922332764 #(0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0588836669922 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0)
     7.0475845336914 #(0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0)
     7.0251078605652 #(0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     5.933969 #(0.000000 1.357580 1.821190 0.294387 1.750925 1.845472 1.054143 1.356098 0.293620 0.391313 1.778601 1.534928 0.426019 0.315757 -0.095725 0.216499 0.999813 1.634650 1.366520 0.730349 0.391123 1.330014 0.106679 1.912375 0.325125 0.431168 1.541075 0.670579 0.023629 0.320519 1.802217 0.442394 1.635271 1.059117 1.341290 1.420508 1.824162)
     )

;;; 38 all -------------------------------------------------------------------------------- ; 6.1644
#(38 7.1993880271912 #(0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0)
     7.1926069259644 #(0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 0)
     7.1880865097046 #(0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0)
     7.1807923316956 #(0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0)
     7.1668581962585 #(0 0 1 0 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0)
     7.1260185241699 #(0 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0)
     7.1221342086792 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.0688242912292 #(0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.141081 #(0.000000 0.476359 1.183611 1.424660 0.720669 0.084602 1.874771 1.422499 0.404825 0.949357 0.682500 1.709551 1.802453 0.795775 1.088809 0.144361 1.364027 0.520155 0.230721 0.817258 1.067794 1.407900 0.308825 1.598206 1.778867 1.700646 -0.474543 1.394960 1.012106 1.341722 0.530505 1.592235 0.510888 0.855540 1.374812 1.298891 0.989427 1.632520)
     )

;;; 39 all -------------------------------------------------------------------------------- ; 6.2449
#(39 7.3091864585876 #(0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0)
     7.2959136962891 #(0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0)
     7.2940211296082 #(0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0)
     7.2713379859924 #(0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0)
     7.2698922157288 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 0 0)
     7.2519464492798 #(0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0)
     7.2313327789307 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0)
     7.1506487936623 #(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.130953 #(0.000000 0.038461 0.171605 1.637522 1.177657 0.764596 -0.121999 0.532157 0.566373 -0.107168 -0.131067 0.222564 0.601164 1.033230 1.720725 1.942372 1.261330 -0.012481 1.519629 1.204483 0.906347 1.595016 1.659825 1.493185 0.901436 0.172939 0.594674 1.531973 0.100311 1.415234 0.766685 -0.148692 1.282135 1.608493 1.559674 0.288962 1.494453 0.151064 0.429304)
     )

;;; 40 all -------------------------------------------------------------------------------- ; 6.3245
#(40 7.4570450782776 #(0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0)
     7.448447227478 #(0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.4427533149719 #(0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.4250183105469 #(0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.4126052856445 #(0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)
     7.4104852676392 #(0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1)
     7.4014959335327 #(0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0)
     7.3913831710815 #(0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.328818 #(0.000000 -0.185771 1.608833 0.118847 0.817687 1.353844 1.415394 1.577468 -0.167919 0.452879 0.750506 1.135243 -0.091923 0.422968 0.015288 1.927628 -0.209142 0.433543 0.464803 0.118398 0.065517 0.879942 0.906211 1.106392 0.447050 1.638584 0.371725 1.545148 0.220166 -0.139773 1.376317 0.506218 1.939479 1.290399 0.482924 -0.145636 -0.030130 1.377304 1.794185 0.858100)
     6.299043 #(0.000000 1.472809 1.342339 0.246263 0.991856 1.364904 1.647208 1.737556 -0.043009 0.433781 0.542673 1.274446 0.327101 0.080827 -0.005060 1.722843 -0.348703 -0.102392 0.020851 0.163683 -0.163807 1.232757 0.806939 0.869455 0.520612 1.473286 0.172075 1.061287 1.508730 1.814241 1.251176 0.573394 1.417654 1.686745 0.620310 -0.108344 1.534180 0.355574 1.249840 0.714009)
     )

;;; 41 all -------------------------------------------------------------------------------- ; 6.4031
#(41 7.5969347953796 #(0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0)
     7.5873513221741 #(0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0)
     7.5666546821594 #(0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.5657444000244 #(0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0)
     7.544189453125 #(0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.4959030151367 #(0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.4493231773376 #(0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.4106826782227 #(0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

     6.336362 #(0.000000 1.136564 1.769039 -0.302528 1.219485 1.077066 0.499384 0.459848 1.421023 1.898005 0.403090 0.295010 -1.896917 1.896083 1.647995 1.178305 0.666829 1.680796 0.463075 0.545628 1.334683 0.394364 -0.085600 0.753986 0.467752 0.515771 0.824057 0.897722 1.181114 -0.015790 0.947115 1.655981 0.729980 0.146814 0.128215 0.219239 0.873463 0.080337 1.491244 0.201806 0.413100)
     )

;;; 42 all -------------------------------------------------------------------------------- ; 6.4807
#(42 7.8644123077393 #(0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8588690757751 #(0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1)
     7.8527493476868 #(0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8154973983765 #(0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0)
     7.7903428077698 #(0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 0)
     7.7545323371887 #(0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1)
     7.6252284049988 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.465842 #(0.000000 1.779554 1.370344 1.882962 1.433363 1.459567 0.063273 0.108009 1.657492 0.288844 1.687713 1.025902 0.674182 0.201834 0.765952 0.917744 1.874499 -0.184507 1.137962 1.738171 0.305979 1.845120 1.388633 1.189195 0.515261 0.441835 0.939748 1.211754 1.571391 0.721535 1.540322 0.682875 1.729853 0.826543 0.708253 0.660516 1.076207 -0.047500 0.062738 0.510039 0.045388 0.837011)
     )

;;; 43 all -------------------------------------------------------------------------------- ; 6.5574
#(43 7.8286972045898 #(0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.824122428894 #(0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1)
     7.8140468597412 #(0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.8020606040955 #(0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7842569351196 #(0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)
     7.7697319984436 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1)
     7.7580170631409 #(0 0 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7244353294373 #(0 1 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1)
     7.6866073608398 #(0 1 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0)
     7.6619415283203 #(0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

     6.482409 #(0.000000 1.144559 1.691771 1.153951 0.716239 0.646091 1.063134 0.342868 0.213241 1.376155 0.672100 0.425584 0.173096 0.110029 0.015293 0.460666 1.796149 1.444048 0.314197 0.012835 0.819748 0.119031 0.582195 0.100074 0.621426 0.361508 1.290142 0.942275 1.772437 0.174260 1.102162 1.335380 1.397832 0.481081 1.799028 0.225127 0.933833 0.257264 0.672894 1.297185 1.465653 -0.223387 0.778846)
     )

;;; 44 all -------------------------------------------------------------------------------- ; 6.6332
#(44 8.0920171737671 #(0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0)
     7.9767818450928 #(0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     6.552505 #(0.000000 0.516530 0.224688 0.526733 -0.270777 1.917868 -0.031145 -0.157428 0.072119 1.708014 1.778556 0.463152 0.275914 0.508605 1.163702 0.356039 -1.719404 0.466987 0.149273 1.208679 1.406203 0.743516 1.669343 1.404167 0.072628 0.264489 0.573670 0.758686 -0.024977 1.581357 0.913109 1.310679 0.226713 0.685141 1.566700 0.432175 -0.042399 1.284123 0.875160 0.466218 1.017090 0.066147 1.376720 0.160417)
     )

;;; 45 all -------------------------------------------------------------------------------- ; 6.7082
#(45 8.197151904921 #(0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1)
     8.1777801513672 #(0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

     6.703069 #(0.000000 1.072698 -0.071857 -0.315201 1.289632 0.049576 0.550574 0.936882 1.274552 -0.137730 1.176138 1.942981 1.857508 0.917101 1.838948 0.103561 0.380280 0.254574 1.230670 0.649004 1.266031 0.090864 0.066401 0.507493 0.032763 -0.178855 -0.002723 0.628256 1.522968 0.368551 -0.048869 0.031008 1.094372 1.686721 1.156790 0.976242 1.078178 -0.079430 1.396731 0.951285 0.527926 -0.211141 -0.089011 1.504966 -0.078161)
     )

;;; 46 all -------------------------------------------------------------------------------- ; 6.7823
#(46 8.4391345977783 #(0 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0)
     8.22203540802 #(0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     6.699675 #(0.000000 1.448795 1.081717 1.923365 0.599093 0.110602 0.062986 0.201393 1.127916 0.800992 0.134374 1.541686 0.425230 0.988970 1.044715 0.905011 0.394025 1.877303 1.779770 0.103636 0.810901 1.462019 1.298360 0.506301 0.690905 0.079943 0.741252 1.295527 0.922954 1.948031 1.523204 1.191425 1.863021 1.502798 -0.017565 0.925811 1.378082 1.110394 1.347775 1.468163 0.886624 1.241739 -0.114390 0.646794 0.156750 0.998631)
     )

;;; 47 all -------------------------------------------------------------------------------- ; 6.8556
#(47 8.4154777526855 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0)
     8.3755550384521 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0)
     8.3640232086182 #(0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0)
     8.3221893310547 #(0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     6.839431 #(0.000000 1.707000 0.885271 0.233907 0.651927 -0.011748 0.217674 -0.026454 1.211428 0.349699 0.457067 0.222525 0.948014 1.342792 -0.049850 0.652055 0.968625 1.464418 0.749553 1.222877 0.635210 1.480624 1.915233 -0.202765 1.474975 0.776193 1.112445 1.266123 1.809237 0.658024 0.102958 1.290639 1.006124 1.030838 1.151617 0.307178 1.475376 1.085280 0.368954 1.771707 0.262040 0.332089 0.325281 1.173936 1.776791 1.092991 1.334125)
     )

;;; 48 all -------------------------------------------------------------------------------- ; 6.9282
#(48 8.6921081542969 #(0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1)
     8.5232070520636 #(0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1)
     8.4671268463135 #(0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

     6.871100 #(0.000000 0.601479 1.243488 1.031934 1.049235 0.596883 1.662432 1.332867 0.654168 1.789395 1.338287 0.008569 0.383718 1.918449 0.167686 0.199365 1.570673 1.514426 0.642526 0.516053 0.941786 -0.405198 1.600367 0.834398 0.797046 0.741498 0.174574 0.975068 0.363528 0.473179 1.257141 0.662389 1.164668 0.895449 1.707104 0.726409 0.457854 0.350294 0.207246 0.807488 1.129362 1.480839 0.314066 1.583313 0.357468 0.760120 1.603578 0.627828)
     )

;;; 49 all -------------------------------------------------------------------------------- ; 7
#(49 8.7310771942139 #(0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0)
     8.6587047576904 #(0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0)
     8.7183141708374 #(0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1)
     8.5157623291016 #(0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

     6.921571 #(0.000000 1.428159 -0.117715 -0.216673 1.072814 1.015693 0.650701 1.622259 0.539828 0.421480 1.870093 1.161169 0.985539 1.720420 0.365388 0.060714 0.531355 1.517179 1.463949 0.724994 0.961176 1.538829 1.564877 1.431255 0.933914 1.183544 1.508100 -0.167102 1.668032 0.675482 0.243270 0.673725 0.266636 1.083568 0.367176 -0.139144 -0.047776 1.096102 1.977531 0.481511 1.201649 0.171345 0.858647 0.506382 1.643450 0.142346 0.246748 1.854181 0.300891)
     )

;;; 50 all -------------------------------------------------------------------------------- ; 7.071
#(50 8.8124130871436 #(0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1)
     8.8096923828125 #(0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1)
     8.7809114456177 #(0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

     7.040654 #(0.000000 1.534715 0.617340 1.307733 -0.048813 1.530143 0.432374 1.792718 1.159103 0.892119 0.938624 1.101215 -0.189442 0.811760 0.606724 1.584279 -0.422867 -0.153620 1.003191 1.075961 1.293779 0.459341 0.571239 0.205442 0.704022 0.671327 0.610569 0.405468 1.273636 1.501675 0.957497 -0.180772 0.356690 1.399403 -0.501431 1.059546 1.439824 0.309427 1.328508 0.920498 -0.334116 1.442566 1.153151 1.668063 0.274295 0.643666 0.138231 -0.341992 0.857237 1.514377)
     )

;;; 51 all -------------------------------------------------------------------------------- ; 7.141
#(51 8.8691492080688 #(0 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)
     8.8213935921978 #(0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     7.128861 #(0.000000 1.288807 1.261290 1.708806 -0.041696 0.975112 -0.056845 0.549562 0.520162 0.023559 1.539942 0.320201 0.546541 1.768068 0.944171 1.305590 0.560013 1.101341 0.562523 0.705470 0.630407 0.539298 1.702627 1.682385 1.700139 -0.209021 0.092135 0.662010 -0.115432 0.126860 -0.054516 0.902405 1.344882 1.473202 1.481174 0.301017 -0.049155 1.425283 1.248844 0.361137 1.429243 0.127083 1.892631 0.920088 0.040963 0.937366 0.092836 -0.028756 1.185042 1.386223 0.167497)
     )

;;; 52 all -------------------------------------------------------------------------------- ; 7.211
#(52 9.1133499145508 #(0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1)
     9.109245300293 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0)
     8.9920463562012 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

     7.149737 #(0.000000 0.631718 1.446098 1.478773 0.119348 1.347186 0.570275 0.537178 1.768074 0.400579 1.752143 0.527996 1.397343 1.240563 1.338275 1.021738 0.936626 1.568260 0.516819 0.308476 0.482402 1.096064 -0.060160 0.259483 0.398962 1.253846 1.878522 1.121548 1.717764 -0.134371 0.224256 1.122775 0.533335 1.223694 0.258831 -0.099257 1.272598 0.870492 0.890684 0.687746 0.677480 1.098395 1.397497 1.045901 1.346856 0.415368 1.577769 0.869637 0.539653 1.425636 1.250370 0.816634)
     )

;;; 53 all -------------------------------------------------------------------------------- ; 7.280
#(53 9.171422958374 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 1 1 0)
     9.0914754867554 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

     7.211402 #(0.000000 0.616516 0.846689 1.603746 1.161970 1.711662 0.514826 -0.046593 0.307026 0.319518 1.005929 1.378198 1.088439 1.754482 1.597324 0.155392 0.927857 -0.374215 0.834281 1.641395 0.751477 1.007227 0.872774 0.298992 0.171911 0.882242 1.761522 0.889562 -0.029460 0.079990 0.274506 1.592029 0.319770 1.894422 1.397662 1.118695 0.715594 0.355740 1.347351 1.817486 0.553207 1.398165 1.814722 1.638043 1.670484 -0.112799 1.641090 0.885500 0.184635 1.804143 0.327137 0.103994 1.699875)
     )

;;; 54 all -------------------------------------------------------------------------------- ; 7.348
#(54 9.2755253455568 #(0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1)
     9.1825122833252 #(0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

     7.337187 #(0.000000 1.556812 -0.133768 1.398398 -0.053398 1.159474 0.122400 0.434564 1.175898 -0.273546 0.103530 0.017448 0.221098 1.000971 -0.184384 0.823630 1.597924 0.423379 0.648174 0.965898 1.037923 0.341282 0.414742 0.145014 1.495445 -0.119993 1.573849 1.165373 1.039813 -0.006045 1.587706 1.014348 0.006027 1.393163 0.698587 0.635727 1.250910 0.631558 1.335542 0.497901 0.493836 0.926372 1.220493 0.681591 1.051914 1.695971 1.617858 0.769169 0.296002 0.427696 -0.016587 1.180303 0.589227 0.946379)
     )

;;; 55 all -------------------------------------------------------------------------------- ; 7.416
#(55 9.2178440093994 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0)
     9.0889595835043 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     7.362111 #(0.000000 0.885530 0.401367 1.717163 1.124947 1.126574 -0.191821 1.027733 0.992438 1.700984 0.430796 0.836783 1.619177 0.985112 1.045116 1.005917 1.389033 1.474269 -0.243032 1.504873 1.672866 0.981265 0.916358 1.357743 0.433494 0.397275 1.319998 0.021765 1.474037 0.089745 0.967695 1.009066 1.302918 0.891780 1.429735 0.645002 1.632259 0.331674 0.431487 -0.162153 1.022976 0.347564 0.232172 -0.004453 1.637392 0.781912 0.428442 1.356111 1.774852 -0.210024 -0.222540 0.890122 1.236139 0.615141 1.528929)
     )

;;; 56 all -------------------------------------------------------------------------------- ; 7.483
#(56 9.4667987823486 #(0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0)
     9.3902807235718 #(0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1)
     9.1394176483154 #(0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

     7.371868 #(0.000000 1.572725 1.521995 -0.242193 1.522182 0.087697 1.235193 1.318418 0.303751 1.612110 -0.256007 0.062812 0.007785 1.604800 1.564793 0.577827 0.538414 1.147603 0.084367 0.075947 1.175327 0.118793 1.324996 1.057006 1.840175 1.728376 0.725240 0.681818 0.981640 1.490971 1.254152 1.560648 1.799707 1.244403 -0.013317 0.633080 1.615071 1.174977 0.583467 0.718803 0.924516 0.317835 0.698183 0.247550 0.703436 -0.233591 1.549224 0.583010 1.269996 0.023940 1.805836 1.915516 1.065576 0.571400 1.127566 -1.914815)
     )

;;; 57 all -------------------------------------------------------------------------------- ; 7.5498
#(57 9.650218963623 #(0 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0)
     9.616 #(0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1)
     9.370246887207 #(0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

     7.520679 #(0.000000 0.434294 0.845950 0.842308 1.695683 0.220894 0.397920 0.144752 1.817140 1.209654 1.062453 1.027438 0.202316 0.671718 1.533565 1.295334 1.811921 0.062499 1.548311 1.557995 0.127885 0.318033 0.125151 1.422462 0.471021 0.753247 1.666903 1.090152 1.159402 1.477128 1.769995 0.852448 0.998214 1.346725 0.812116 0.583570 1.681157 0.512662 1.545484 1.616182 0.957299 1.804231 1.474004 0.349918 1.341089 0.589556 1.304638 1.365528 0.259796 1.531042 0.119965 0.908086 0.243855 1.566686 1.212055 1.465069 1.474980)
     )

;;; 58 all -------------------------------------------------------------------------------- ; 7.6157
#(58 9.623 #(0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1)
     9.6140956878662 #(0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1)
     9.4419231414795 #(0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     7.614594 #(0.000000 0.987958 1.506228 0.850726 0.380897 0.509265 -0.052538 0.094181 1.248365 1.144646 0.168627 1.085892 1.762339 -0.125454 0.565413 1.558021 0.687489 1.590845 1.492717 1.041358 1.278589 0.775079 1.350583 0.616523 0.184568 0.648144 1.037061 -0.198583 0.283778 -0.043684 0.359373 -0.158682 1.827455 0.904627 1.167598 -0.302517 0.012199 0.162117 -0.046657 1.984002 0.036411 0.417016 -0.026748 0.788079 0.414878 0.204426 1.495981 0.773810 1.351203 0.703045 -0.156641 1.867897 0.828634 0.340743 1.675484 1.308778 1.594071 0.197036)
     )

;;; 59 all -------------------------------------------------------------------------------- ; 7.6811
#(59 9.9013983722749 #(0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1)
     9.4819116592407 #(0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

     7.674817 #(0.000000 0.018517 0.358695 1.385949 1.461232 0.264126 0.966469 0.697430 1.506529 0.264217 1.233066 -0.422313 -0.114097 1.544334 0.198775 1.244501 0.107992 0.668216 0.312414 0.290513 0.022046 0.684867 0.986337 1.224846 0.476492 0.627953 0.949269 0.452772 1.392841 1.180357 0.633197 0.263889 0.620308 1.346266 0.548958 1.562315 0.909309 0.537784 0.837910 0.590670 -1.757389 1.673166 0.198430 0.513936 0.261081 1.780499 1.270897 1.345053 0.209762 1.437916 1.721067 0.289046 0.777234 0.788249 0.492237 1.200359 1.922726 1.369656 0.462461)
     )

;;; 60 all -------------------------------------------------------------------------------- ; 7.7459
#(60 9.783 #(0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)
     9.575254043103 #(0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     7.619502 #(0.000000 0.402320 0.240149 0.846641 0.693406 -0.677370 0.001624 1.944472 1.143504 0.426368 0.860481 1.347488 0.090527 -0.304211 1.364881 1.059011 0.742961 0.076710 1.522401 0.047644 1.285109 1.496233 1.604585 0.780472 -0.235054 1.010739 0.757677 0.078992 1.613082 1.197103 0.678700 0.879778 0.140312 0.325237 0.626668 0.139166 0.123748 0.154613 -0.168022 0.559782 0.329302 1.235963 0.791401 0.754815 0.916761 1.170795 -0.235739 0.018036 0.529511 -0.312991 0.095216 0.717299 0.269441 0.968523 1.750563 0.662030 0.098981 0.813196 0.081039 0.368795)
     )

;;; 61 all -------------------------------------------------------------------------------- ; 7.8102
#(61 10.140303840769 #(0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0 1)
     9.9175914844707 #(0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     7.786797 #(0.000000 0.479365 1.325597 -0.008216 0.497879 1.950705 -0.008644 0.984944 0.006815 0.533256 0.021971 0.556114 0.567754 -0.162267 0.684181 1.445682 0.682984 1.023942 1.268790 0.524818 0.655237 1.370199 -0.008920 0.924971 0.759242 0.946189 0.642344 0.008230 1.239177 0.463060 1.105504 -0.050618 1.557294 0.142237 0.701652 0.233379 1.809524 0.210102 0.677919 1.960815 1.543024 1.104351 -0.286290 1.415179 1.048047 1.715261 1.081197 0.289286 0.172557 0.076057 0.772217 1.470306 1.397916 -0.056368 0.274819 0.183634 1.614281 1.094203 0.773274 1.332013 1.480061)
     )

;;; 62 all -------------------------------------------------------------------------------- ; 7.8740
#(62 10.281167984009 #(0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0)
     9.9292116165161 #(0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

     7.867687 #(0.000000 0.712778 1.676017 0.246844 1.656097 1.428520 1.829255 1.013884 0.031332 0.606223 1.867187 1.311811 1.377034 -0.032234 1.689363 0.088000 1.027705 0.008990 1.012020 1.179857 0.606252 0.582295 0.019864 1.670998 0.116916 1.143991 0.399068 0.225588 0.727972 0.510771 0.289954 1.584178 1.516566 1.729886 0.285500 1.619304 1.092962 0.710964 1.283837 1.418411 0.070754 0.941077 1.259732 1.195002 0.450871 1.663832 1.507943 1.715520 1.837497 0.647269 1.684433 1.566868 0.724332 0.751690 0.936294 1.116625 0.171934 1.223209 0.807982 0.666927 1.291168 1.547340)
     )

;;; 63 all -------------------------------------------------------------------------------- ; 7.9372
#(63 10.265982627869 #(0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9866892843745 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9555234909058 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     7.921801 #(0.000000 0.142718 0.118610 0.583313 1.534648 0.239524 -0.238709 1.282132 0.133458 0.207889 1.501653 0.097281 1.891492 1.168327 1.945945 0.325567 1.274429 0.867531 1.492235 1.217784 0.148043 1.775676 0.945888 0.994144 1.174855 1.032613 1.304584 1.169802 0.353681 1.013972 0.171608 1.815373 1.492883 1.323277 -0.041232 1.329356 1.654292 1.251598 1.289589 0.390684 0.890799 1.804944 1.430243 0.271409 1.555380 0.406815 0.819576 0.470424 -0.016235 1.561170 1.171048 1.055486 0.179958 0.974818 1.455548 -0.128339 -0.156807 -0.006719 1.063115 1.741340 0.215767 0.667652 0.637400)
     )

;;; 64 all -------------------------------------------------------------------------------- ; 8
#(64 10.1628899603246 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1)
     9.957244923706 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

     7.986229 #(0.000000 0.047387 0.225806 1.950536 0.379367 1.205927 1.437187 0.571120 0.594961 1.231237 1.344812 -0.237176 1.832664 1.620827 0.306079 -0.198967 1.798610 1.301086 1.832222 0.727963 0.857502 1.557835 0.425216 0.570091 1.083689 1.464541 -1.744883 1.272284 0.500144 1.193371 1.255011 0.220666 -0.052812 1.584453 1.835476 1.693864 1.173518 1.035527 0.332085 -0.084828 -0.259646 1.053683 0.249366 0.611687 0.481086 1.336321 0.646537 1.409012 0.061840 0.168726 1.065432 0.421138 1.207294 0.515130 1.466023 1.035042 0.804961 0.377940 1.038729 0.444007 0.760689 1.718518 0.849620 0.946875)
     )

;;; 65 all -------------------------------------------------------------------------------- ; 8.0622
#(65 10.598279953003 #(0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0)
     10.18968963623 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0)
     10.157649040222 #(0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     8.057018 #(0.000000 -0.464113 1.156968 1.259995 1.444354 1.860947 1.635230 -0.205306 0.992448 1.842589 1.027769 1.611073 0.670223 0.919820 1.411143 1.467440 1.716813 0.114100 0.671029 1.788456 -0.024006 1.126477 0.877343 1.143834 1.730949 0.858302 1.487504 0.173270 0.877104 0.597502 1.379684 0.169023 1.753218 0.447902 1.131769 0.491721 0.437659 1.451204 1.675490 0.505813 -0.188295 0.457471 0.283905 1.417309 1.872297 0.244174 0.700109 0.171762 0.905374 0.174388 1.480701 1.080429 1.161835 1.294409 1.197333 0.954084 0.912195 0.100914 0.019559 1.424227 1.050357 0.074828 1.353644 0.536519 0.254680)
     )

;;; 66 all -------------------------------------------------------------------------------- ; 8.1240
#(66 10.450973400896 #(0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0)
     10.26798183746 #(0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1)
     10.208241079264 #(0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

     8.111796 #(0.000000 1.095044 1.971480 0.495809 1.669854 1.695553 1.690769 0.992574 0.658744 -0.307192 0.718928 0.862872 0.727787 1.276331 0.262343 0.329210 1.115168 0.340255 1.908658 0.186768 0.958903 1.597859 -0.242502 0.607601 -0.008356 1.387457 1.397068 1.203878 0.209050 0.421653 0.091178 1.651767 1.138553 1.088038 0.802029 0.953054 1.286262 0.267135 0.296174 1.484793 0.310661 1.205720 1.631639 1.569689 0.250821 0.384663 0.963124 0.262172 1.072746 0.289875 1.607486 0.683109 0.585198 1.943271 0.951175 0.119466 0.915585 0.051143 0.540878 0.689771 0.092468 0.068150 0.627519 0.282595 0.609447 0.782814)
     )

;;; 67 all -------------------------------------------------------------------------------- ; 8.1853
#(67 10.780866622925 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     10.514228551195 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.445269388021 #(0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.422191619873 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.171159 #(0.000000 0.833028 1.687710 1.206556 0.086498 0.923602 1.807309 1.058637 0.261723 1.472963 0.161430 0.020009 0.094154 0.806756 0.877917 0.392701 1.102137 0.935044 1.379076 1.649736 0.811305 -0.172711 1.690622 1.819474 -0.124717 1.776326 0.386953 1.425407 0.988974 -0.024270 0.605002 -0.060983 -0.112337 0.015102 -0.070516 1.065122 0.463133 -0.464979 1.310845 0.085302 0.860922 1.573822 1.528535 1.752601 0.851644 1.157462 0.992983 1.045906 -0.088076 1.424333 0.720348 0.614425 0.618796 1.159685 1.542862 0.334337 1.723725 -0.143373 0.935326 1.693606 0.135261 1.235601 1.543482 1.045513 0.667727 0.036386 1.812164)
     )

;;; 68 all -------------------------------------------------------------------------------- ; 8.2462
#(68 10.585594177246 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1)
     10.460547747753 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

     8.197641 #(0.000000 0.331478 1.852498 1.054398 0.777200 0.937337 0.730244 0.726443 0.370454 0.195895 0.474792 0.067610 1.509491 0.919487 0.825906 0.940345 0.808546 1.078537 1.225150 1.049414 0.736445 1.737698 0.058020 1.765818 1.417551 0.217434 0.089861 -0.022853 0.527925 0.671334 1.318190 0.126947 1.525948 1.536065 0.046756 0.228156 1.770087 1.007179 1.313900 1.416181 0.118708 1.243392 0.727368 0.050354 1.437178 1.091859 0.751746 1.478906 0.375119 1.294680 0.553303 1.463022 1.224389 0.167046 0.463856 1.162121 -0.019044 1.448763 0.187766 1.129299 -0.143402 0.687347 1.461100 -0.235374 0.546990 0.683693 0.973453 1.528821)
     )

;;; 69 all -------------------------------------------------------------------------------- ; 8.3066
#(69 10.631803698099 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.544771744298 #(0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.495518383865 #(0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

     8.289844 #(0.000000 0.513585 0.177479 -0.176888 0.623783 1.745401 0.873250 -0.173141 1.596123 0.753018 -0.230814 1.441081 0.705435 0.505271 1.366748 0.558604 0.140712 0.699849 0.362073 -0.111867 1.322811 1.446154 0.437920 -0.004880 0.636812 0.132544 1.613260 0.126691 1.024863 1.218542 1.684056 1.053127 0.272250 0.553128 0.296391 -0.119714 1.708317 1.024886 0.325200 0.493314 1.349317 1.057246 1.659956 0.046289 0.374425 0.519480 0.314406 0.268202 1.430527 0.044485 -0.747002 1.651671 0.338001 0.130617 1.387118 1.539222 0.360122 0.465635 1.448451 0.389965 1.070962 0.131507 1.008142 0.867151 0.967360 1.085348 1.255863 1.090665 1.273123)
     )

;;; 70 all -------------------------------------------------------------------------------- ; 8.3666
#(70 10.957886695862 #(0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0)
     10.651799201965 #(0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0)
     10.635682482778 #(0 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)
     10.532930374146 #(0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

     8.346754 #(0.000000 0.655484 1.374896 0.289576 0.973706 1.109131 0.854187 1.260047 1.360067 -0.018132 0.674424 1.659490 0.490887 0.913232 1.137634 1.302746 0.987696 1.880807 1.061263 -0.042700 0.329365 1.188950 1.933106 0.970966 0.030974 0.288697 0.661329 -0.073707 0.185857 0.108498 0.256148 1.450247 0.165058 1.651421 0.570093 1.711124 1.184567 -0.086459 1.770960 1.950244 1.451278 0.292741 0.567049 0.753713 0.690306 0.057026 0.466415 0.230363 0.074574 1.359738 1.119809 1.847194 -0.169831 0.594006 1.381831 0.790494 0.195665 1.724791 1.394772 0.590353 0.319079 1.802913 -0.103344 -0.103646 0.896174 1.232397 0.803435 0.456945 0.085191 1.243103)
     )

;;; 71 all -------------------------------------------------------------------------------- ; 8.4261
#(71 10.922951698303 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0)
     10.610488331633 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.424513 #(0.000000 0.194051 -0.078724 1.284071 0.120713 0.175960 1.077763 1.335359 0.105452 1.486620 0.366448 1.097868 -0.165525 0.767475 0.428357 0.941941 1.042033 0.869520 0.740147 0.605784 0.770924 0.404261 0.477537 1.116209 0.421449 1.249007 1.045637 1.018411 1.198920 0.812317 -0.428993 0.539055 0.835631 0.384704 0.141836 1.627811 -0.062780 0.726026 0.983545 -0.049691 1.257296 0.036439 0.689288 0.375627 1.715474 1.295745 0.741353 0.061183 0.821121 1.119652 1.477292 1.774965 -0.097064 1.380315 -0.060642 0.385233 0.881453 1.019289 0.438567 0.211146 1.480994 0.240063 0.818842 1.034585 0.906648 0.104241 1.629037 0.292724 1.525743 0.583397 0.232352)
     )

;;; 72 all -------------------------------------------------------------------------------- ; 8.4853
#(72 11.061260849739 #(0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
     10.908146369485 #(0 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0)
     10.800657366855 #(0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     8.509295 #(0.000000 -0.109482 0.850217 0.653010 0.050693 1.185668 -0.189008 0.592350 0.602513 1.378281 1.765296 1.052677 1.217338 0.256452 0.397169 1.560562 0.157322 0.864563 0.314629 1.495363 0.987451 1.347990 0.023710 0.069127 -0.046288 0.272003 0.317696 0.865722 0.645013 0.246417 0.101694 0.455991 0.762055 0.592234 0.859140 0.382549 1.784540 1.445197 0.137622 1.231953 1.159845 1.086835 0.416787 0.612377 0.000031 0.590764 0.187426 0.541490 1.701444 -0.349958 0.385149 1.457944 1.415258 0.195118 0.231137 1.667747 1.072145 1.733966 1.010881 0.631834 1.608455 1.085410 1.617413 -0.023438 0.665293 1.364662 0.709312 1.513048 0.424392 1.105246 0.130599 -0.150134)
     )

;;; 73 all -------------------------------------------------------------------------------- ; 8.5440
#(73 10.9493838342178 #(0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.889594078064 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.876985549927 #(0 0 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0)
     10.773231506348 #(0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

     8.527919 #(0.000000 -1.813709 0.156885 1.589892 0.591209 0.961424 0.858587 0.075042 1.246874 0.014860 1.163736 -0.365694 1.064413 0.917286 1.197963 -0.034882 1.143315 -1.744418 0.153601 0.919804 1.618724 1.026629 -0.117197 1.866866 0.324983 1.632404 0.882484 0.929992 1.108045 1.855616 0.448539 0.254830 1.923958 1.661709 0.281723 0.261319 0.065501 1.122822 0.526010 0.703541 1.320276 -0.094587 0.269492 -0.044672 1.894648 -0.071066 -0.036016 1.532575 0.394280 1.627918 0.126396 1.818584 0.414729 1.131341 1.839299 0.583593 1.147069 0.826976 0.466296 1.610692 1.339702 0.545569 0.411319 1.088690 1.822262 -0.278996 1.090216 0.377301 1.347288 1.896787 0.198928 1.634945 0.662314)
     )

;;; 74 all -------------------------------------------------------------------------------- ; 8.6023
#(74 11.023842939777 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0)
     10.97177028656 #(0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0)
     10.70422077179 #(0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0)
     10.684138298035 #(0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     8.572496 #(0.000000 1.331968 0.174892 1.622467 1.046242 0.065798 1.097889 0.637789 0.105184 0.855226 0.182384 0.737302 1.773794 -0.003788 1.300225 0.140699 1.076013 1.503236 0.162375 0.573920 1.517583 0.086219 -0.074447 1.073906 1.129989 -0.144815 0.979567 0.810942 0.066706 1.606315 0.466289 -0.521197 1.767442 1.669772 0.059653 0.024619 1.416912 -0.007247 1.340297 0.242365 0.136591 1.664419 1.599163 1.143946 0.778100 1.279223 1.568661 -0.526031 0.356418 1.115808 1.335558 0.665761 -0.011853 0.079010 0.327368 0.643907 -0.041596 0.175817 1.189629 0.907793 0.865933 1.050720 -0.193365 0.385382 0.048009 0.758977 0.359361 0.894035 1.313677 1.088902 -0.060866 -0.338111 1.475049 1.241921)
     )

;;; 75 all -------------------------------------------------------------------------------- ; 8.6603
#(75 11.477107048035 #(0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0)
     10.935811368418 #(0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

     8.684925 #(0.000000 1.777575 1.258056 1.343954 0.138736 0.922441 1.201674 0.122033 0.193361 1.385573 0.909802 1.293088 1.618696 0.370302 0.387502 1.671242 1.638638 0.928577 1.845670 1.043729 1.210524 1.240744 1.328904 1.180249 1.380654 1.551199 0.733795 0.617408 0.202463 1.042182 1.227347 0.555253 0.082580 1.169648 1.437694 0.330093 0.873217 1.937073 0.548854 0.677720 0.642629 1.147644 1.311448 0.155002 1.248769 0.361167 1.311915 1.501043 1.476557 1.634994 1.646429 0.056421 1.172285 0.123643 1.280223 0.544180 -0.076439 1.466372 0.140479 1.349446 0.862128 0.494136 0.307021 1.475259 1.732145 -0.010450 -0.113764 0.251873 1.586539 0.795206 1.269789 0.358391 0.702952 0.559137 1.663165)
     )

;;; 76 all -------------------------------------------------------------------------------- ; 8.7178
#(76 11.329963225913 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0)
     11.208243370056 #(0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0)
     10.689208030701 #(0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

     8.675548 #(0.000000 0.395449 -0.221652 1.508912 1.295673 0.225142 0.745185 1.835132 0.696172 1.499982 0.898863 -0.141132 1.224041 1.571359 0.370821 0.413663 1.573949 0.668236 1.248394 0.813796 1.731666 0.540922 1.496927 1.867687 1.275577 0.612159 0.880593 0.878186 0.758700 1.493715 -0.225764 0.619891 1.417171 -0.090012 0.865382 0.650445 0.855134 0.245796 0.357615 0.380467 0.792165 -0.196281 0.536105 0.207395 1.118128 0.877987 1.338340 0.082944 0.308384 0.015781 1.798508 1.072546 0.315979 -0.093624 0.132136 0.181172 1.087870 0.781548 1.187502 1.065952 0.696709 1.124799 0.171193 0.800027 0.790065 0.238454 1.188888 0.881236 -0.120900 1.608859 0.934182 0.682489 1.491805 1.664595 1.660453 1.075790)
     )

;;; 77 all -------------------------------------------------------------------------------- ; 8.7750
#(77 11.25105381012 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0)
     11.114716461811 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

     8.731162 #(0.000000 0.348676 0.476377 0.606944 1.387256 1.768549 0.128473 0.260518 0.936568 0.358886 0.618317 0.280418 1.076704 0.186339 0.253960 0.776508 1.415471 1.590913 0.546179 0.076687 -0.256531 0.340311 0.112669 -0.148999 0.753233 0.052743 -0.044103 0.824890 0.752198 1.684593 0.714352 1.250265 -0.090239 1.560152 0.669337 -0.059070 -0.080355 1.629461 1.446609 0.729659 -0.052531 1.270090 0.841483 0.483368 0.495715 0.314144 1.657576 0.557726 0.561425 0.975115 0.690361 1.125970 0.725027 -0.046759 0.347806 0.174137 0.676572 1.478198 0.720342 0.799677 1.510275 1.619276 1.506849 1.740348 0.921395 1.343963 0.582947 -0.631428 1.853084 0.942657 1.014466 0.289120 0.506940 0.058495 1.321113 -0.071385 1.294695)
     )

;;; 78 all -------------------------------------------------------------------------------- ; 8.8318
#(78 11.559678967298 #(0 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1)
     11.541502084124 #(0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)
     11.471938943963 #(0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

     8.794117 #(0.000000 1.282102 1.240015 0.017847 0.220140 1.725512 0.535654 1.852526 1.539563 -0.097808 1.392291 1.857206 1.353378 0.834032 0.387900 1.109453 0.981795 1.560899 0.453225 0.511918 0.840637 1.888309 0.781021 1.533489 0.910642 0.589260 1.543961 0.308835 1.253077 1.545209 0.851990 1.811551 1.652706 1.332577 1.464031 0.607707 1.200927 1.525331 1.366128 0.477575 0.769976 1.396647 -0.102003 0.702279 0.563845 1.281107 1.662601 1.095721 1.552502 0.346884 0.849929 1.298623 0.896092 1.861554 0.989388 0.126963 0.572164 0.003751 -0.034407 1.549877 1.964346 1.606783 0.513154 0.319400 0.062595 0.030600 0.179109 1.017830 0.910238 0.867600 1.472571 1.560119 0.318146 -0.061019 1.718368 0.205299 1.874891 1.066065)
     )

;;; 79 all -------------------------------------------------------------------------------- ; 8.8882
#(79 11.431832400958 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.407577489438 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.334476470947 #(0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     8.876967 #(0.000000 1.217017 1.181770 1.293132 0.793316 0.614833 1.385824 1.899700 0.136304 0.765571 0.089227 -0.058049 0.088341 0.966166 0.731551 1.911162 0.396604 -0.041731 1.141711 0.806277 0.403151 0.110752 0.951079 0.551071 0.944648 0.132252 1.199763 0.682201 0.039510 0.406439 0.198195 0.531418 0.682132 0.658893 0.548542 1.393714 1.084636 0.423055 1.758654 1.394376 1.487027 0.072074 1.813052 0.631991 0.040199 1.623285 1.827695 1.384625 1.320552 0.483220 1.671889 0.474795 0.542482 1.181491 1.612736 1.231528 0.072888 0.450538 1.041375 0.841794 0.687693 1.208493 0.061646 0.144702 1.470642 1.623387 1.645158 0.867468 1.870571 0.447174 1.258774 0.120549 1.533480 0.220588 0.906061 0.003645 0.640845 1.436270 1.649416)
     )

;;; 80 all -------------------------------------------------------------------------------- ; 8.9443
#(80 11.828915596008 #(0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1)
     11.745326966911 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.438133302082 #(0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.30185508728 #(0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

     8.898612 #(0.000000 0.696344 0.764272 0.667623 1.036200 1.569339 1.719645 1.664608 1.737251 1.373199 0.729338 0.103458 0.713452 0.558464 0.239859 0.522820 1.209300 0.488208 1.718956 1.187125 0.165889 0.543174 0.415833 1.205810 0.215989 1.691709 1.889656 -0.003553 0.463179 -0.105942 1.484731 0.258248 1.411140 1.300827 0.706613 -0.322679 0.907206 0.421827 0.686941 0.907107 0.624179 1.628249 -0.008342 0.587875 -0.221324 0.618900 1.403357 -0.010860 0.562476 1.295151 0.538929 0.281784 0.631814 0.805536 1.761922 0.286840 0.509143 1.152376 0.740817 0.438429 0.587306 0.718295 1.484159 1.511374 1.221318 0.726713 0.331055 -0.095789 1.175482 1.583274 0.778218 0.195221 1.270534 -0.221414 0.392972 1.858049 1.882084 1.679266 0.843118 -0.126486)
     )

;;; 81 all -------------------------------------------------------------------------------- ; 9
#(81 11.712129592896 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0)
     11.501712958685 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0)
     11.22668050284 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     8.993998 #(0.000000 0.636751 0.920048 0.365669 0.477946 1.336017 0.669352 1.785557 1.130216 1.416644 0.440922 0.231515 1.127604 0.041463 1.332258 1.780894 1.274713 0.771704 1.126971 0.033094 1.582754 0.067812 1.914158 0.026056 0.878856 0.825850 1.296875 1.383602 1.029910 0.157395 0.976012 1.176464 0.253993 1.535453 1.831173 0.584953 1.391904 0.718067 0.654959 1.713218 1.009768 1.792700 -0.124016 -0.041074 0.778948 1.687788 0.400387 0.505095 0.708859 0.724321 -0.181066 0.483060 0.363237 0.028143 -0.187444 0.935593 -0.616832 1.674274 1.763223 1.371173 1.160874 0.352512 1.928192 0.230330 1.192677 0.944215 0.381375 -0.023299 0.342451 0.111811 1.055875 -0.041760 1.167875 0.356968 -0.077068 -0.226964 0.289050 1.605427 0.129811 0.151778 -0.130837)
     )

;;; 82 all -------------------------------------------------------------------------------- ; 9.0554
#(82 11.697486877441 #(0 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0)
     11.601468306037 #(0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     9.106335 #(0.000000 1.635110 0.134122 0.955568 0.605293 1.866996 0.602372 0.051334 1.118640 0.519993 0.430666 0.338483 -0.277133 1.680756 0.962953 0.488467 1.332439 -0.156459 1.133822 1.031707 0.620236 1.651530 0.323341 1.885535 0.324186 0.283866 1.067860 1.671449 0.411556 0.220637 0.876317 1.337407 1.797584 0.997694 0.204785 -0.045110 0.154212 1.522900 1.171269 0.660128 1.402084 1.636973 0.163298 0.369411 0.239040 1.018040 1.631639 0.670455 -0.008159 -0.429827 1.046648 1.419070 1.559671 0.805038 1.538371 0.048562 0.376216 1.629488 1.806392 0.961856 0.290088 0.923482 0.872955 0.476815 0.134510 0.579073 0.811479 1.861918 0.666137 0.719527 0.280499 -1.873563 0.489984 0.305357 0.361463 1.357121 1.009920 0.882431 1.506602 1.129874 1.786131 0.481211)
     )

;;; 83 all -------------------------------------------------------------------------------- ; 9.1104
#(83 12.009690094281 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0)
     11.868338980165 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0)
     11.429935034332 #(0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     9.149199 #(0.000000 0.558442 0.032325 1.000378 0.091821 0.888236 0.238919 1.196759 -0.077267 1.758050 1.664988 1.103502 1.363132 -0.078233 1.283890 0.260074 1.730465 0.021462 1.712636 -0.037376 1.617531 0.521840 0.706647 1.601150 -0.074412 -0.034377 1.719579 0.543292 0.880717 0.636260 0.865807 0.806464 0.739261 0.404966 0.168758 0.289709 0.865672 0.019882 0.213400 1.073128 0.497548 1.721821 1.610239 0.665141 0.285361 0.086268 1.511177 1.106670 0.222874 0.738883 0.615437 1.351199 0.697034 0.215373 0.514192 1.580044 1.845920 0.943467 0.176006 1.221412 0.030091 1.803889 1.103698 -0.050748 0.270659 0.198099 0.431130 -0.125048 0.336535 1.174321 1.339391 0.692584 1.533725 -0.291939 0.581653 1.418615 1.091406 0.415334 -0.012719 0.013539 0.237409 0.876604 1.358320)
     )

;;; 84 all -------------------------------------------------------------------------------- ; 9.1652
#(84 12.073565240583 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.956374168396 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 1 0)
     11.944072619199 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.81104850769 #(0 0 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.774056434631 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

     9.049585 #(0.000000 0.158856 -0.212744 0.193684 1.190883 0.512976 0.196563 1.423546 1.596909 0.075603 0.595901 0.502376 1.884029 1.301361 1.391815 1.011468 1.557590 1.086542 0.594807 1.181278 0.184928 0.621781 0.444991 1.759352 0.214532 -0.174162 1.504541 1.962216 0.137462 0.851089 1.250599 1.294318 -0.296723 0.449954 -0.223886 -0.363573 1.214491 0.997756 1.642970 1.473193 0.239779 -0.169500 0.754651 1.697938 0.960372 0.363829 0.142444 1.134417 0.472866 0.956284 0.615634 1.336872 0.784259 0.714737 0.560874 1.449779 1.045026 0.749576 0.695604 1.031781 -0.001431 0.085914 1.731538 0.709966 0.854696 1.266563 1.324543 0.616336 1.012379 1.505650 0.090964 1.479692 -0.038939 0.925095 0.277363 0.771215 -0.226000 0.707301 0.784892 1.579217 1.078895 1.196283 1.596407 0.574671)
     )

;;; 85 all -------------------------------------------------------------------------------- ; 9.2195
#(85 12.387479800774 #(0 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1)
     12.285636929325 #(0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0)
     11.953980403239 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1)
     11.927130699158 #(0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

     9.206495 #(0.000000 0.454294 -0.006778 1.405024 0.435345 1.180265 0.729061 -0.167606 -0.414377 0.622801 1.397590 1.745859 0.580538 1.369588 0.708392 1.745766 1.501891 0.357658 0.749761 0.470769 0.266733 1.037590 0.874498 1.736222 0.004264 0.668144 0.970831 -0.055600 1.693281 1.843913 1.101654 0.045034 1.436150 0.408743 0.391619 0.757017 0.622827 1.480180 1.565855 0.400913 0.972856 1.254371 0.947327 0.668234 1.287300 0.329811 0.330070 0.314091 1.562459 0.066784 0.834398 1.696859 0.841687 0.935500 0.675823 1.598347 1.318536 1.314650 0.150970 0.836407 0.640954 0.819952 0.623171 1.294750 0.745024 1.356839 0.939237 1.198437 0.340920 1.557885 1.350507 0.684458 1.090164 0.608579 1.330718 -0.253728 0.735970 0.353223 0.089358 0.219355 -0.145713 1.750455 0.563666 0.486954 0.088866)
     )

;;; 86 all -------------------------------------------------------------------------------- ; 9.2736
#(86 11.942325532619 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0)
     11.819784750357 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)
     11.780031204224 #(0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.239690 #(0.000000 -0.324968 0.928427 -0.137032 1.083109 0.081783 0.857088 -0.020624 1.468359 1.303767 0.425809 0.298661 1.668565 0.492912 1.697066 1.176197 0.797614 0.981725 0.972043 1.040105 1.806321 1.476594 1.863863 1.497767 1.907281 0.472454 1.695504 0.631304 0.965743 -0.158278 0.827998 1.034622 0.903844 0.728905 0.175881 1.650357 1.194665 1.525407 0.823707 1.187813 0.843973 0.846807 1.524637 1.514477 0.390252 0.383046 0.799952 0.820872 1.188032 1.754800 0.258172 0.584353 0.367515 1.538483 0.799071 0.708324 1.017484 0.704498 -0.020439 0.956780 0.177360 0.385855 1.635844 0.251629 0.924367 1.339205 1.422273 0.593531 1.512268 -0.661331 1.667758 0.985898 1.452684 1.452826 1.291036 1.207700 0.642522 0.315614 1.769551 0.769238 1.524058 0.224449 0.124287 1.139993 -0.355161 0.089127)
     )

;;; 87 all -------------------------------------------------------------------------------- ; 9.3274
#(87 12.170317807503 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1)
     12.065419665482 #(0 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1)
     11.76194265333 #(0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.383866 #(0.000000 0.909346 -0.306404 0.677999 -0.207801 0.583210 1.880851 -0.005726 0.274642 0.286373 0.498662 1.396686 0.420254 1.127436 0.239458 0.849718 0.099387 0.606469 1.008506 1.450396 0.162515 1.499988 0.835078 0.138373 1.663419 1.305089 1.074625 0.241861 1.206537 -0.155895 0.038952 1.033442 -0.126726 0.553959 0.769872 -0.063718 0.692984 1.270243 0.894707 1.209919 0.571081 1.759312 1.249625 0.298038 0.153264 1.258371 1.563399 1.246092 1.260806 0.349340 0.275284 0.767390 0.806167 0.376935 0.971951 1.678476 1.627913 -0.036875 0.324266 -0.304923 1.905838 -0.224330 0.483634 -0.250296 1.026188 0.497857 1.463616 1.171237 0.363193 0.625081 0.759786 1.582577 0.461964 0.152623 0.559833 0.605320 0.637224 1.685478 0.086754 1.179718 0.731899 0.493419 0.287105 0.419741 0.322876 1.281159 1.733279)
     )

;;; 88 all -------------------------------------------------------------------------------- ; 9.3808
#(88 12.085149765015 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.991882324219 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.638312339783 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     9.391266 #(0.000000 0.951919 0.349780 1.431129 0.882757 1.645123 0.119849 0.231009 0.321553 1.287603 0.883367 1.709760 1.327737 1.482146 1.765489 1.475588 0.024170 0.662054 0.271062 0.577817 0.292748 1.146971 0.373798 0.074173 0.517135 0.103556 0.405735 1.591867 -0.344596 1.357476 0.249961 0.244986 1.364060 0.982833 0.884415 0.627339 0.609179 1.403375 -0.066691 0.162680 0.801953 0.746754 0.041970 0.438098 1.756161 0.828956 0.592865 1.673585 0.747983 1.638153 1.205490 0.167645 0.464929 -0.154792 1.359667 -0.190578 0.214425 1.475987 1.295971 0.956028 1.058690 0.124000 1.060900 1.804021 1.861617 1.346355 1.268512 1.265870 1.274101 1.074875 0.092864 0.042365 0.970234 0.881333 -0.108882 0.764256 0.099451 0.647276 1.526433 0.513606 1.251535 1.222421 0.625559 0.711235 1.507493 1.808233 0.543792 1.368756)
     )

;;; 89 all -------------------------------------------------------------------------------- ; 9.4340
#(89 12.644 #(0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1)
     12.148494905477 #(0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

     9.461881 #(0.000000 0.084461 0.884952 1.028579 0.082552 0.276705 0.412831 0.452460 0.987085 0.507195 0.447031 0.479959 1.460545 0.766630 1.808656 0.351854 0.643956 1.482079 0.246230 0.462078 0.063513 -0.002333 0.279560 -0.289357 0.883442 0.603785 1.423461 0.914115 1.403642 0.457514 -0.293240 -0.078798 1.884957 1.074545 1.557440 1.496287 0.812513 0.796135 0.255086 0.775044 0.687163 1.348583 1.008106 0.656706 -0.040294 0.579258 1.184441 0.717577 0.614354 1.615308 1.458286 1.076062 -0.566840 1.284869 1.256068 1.068316 0.104987 0.143645 1.432954 0.829044 0.097915 0.701265 0.137331 -0.058120 1.781856 -0.304666 0.234614 1.230159 0.484030 0.714374 -0.357246 1.194496 -0.072194 0.355900 1.207846 1.497575 -1.580552 0.026797 0.996965 0.418706 1.316984 0.854406 -0.608121 0.194206 0.515815 0.143003 0.931363 1.826741 0.885933)
     )

;;; 90 all -------------------------------------------------------------------------------- ; 9.4868
#(90 12.524876494276 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1)
     12.364291918726 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0)
     12.299262768523 #(0 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0)
     12.059710502625 #(0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

     9.479133 #(0.000000 0.822048 1.068030 0.245103 0.203813 1.337163 1.028331 0.059571 1.115220 0.098101 0.397397 1.570543 1.598034 1.289018 0.259921 0.045157 1.242626 1.542433 0.015545 0.760564 0.737915 1.271979 -0.019075 0.363900 0.382471 1.216250 1.794431 0.424508 -0.347932 -0.047968 1.264050 -0.245556 0.265542 1.169267 0.248290 0.226799 0.976877 0.046568 0.592976 0.245442 1.039617 1.304587 0.935439 1.123390 1.494419 1.082327 1.025358 0.842932 0.879477 0.065387 1.168085 0.338837 1.888400 0.716047 0.479689 1.733020 0.809078 0.946940 -0.078437 1.324866 0.061389 0.689578 0.267649 0.703261 1.824143 1.659706 0.524310 0.572907 0.479618 0.745116 0.577835 -0.344556 1.911060 1.814292 1.628569 0.729576 -0.246475 0.646149 0.216374 0.717722 0.156295 1.374775 1.335769 1.171186 0.323834 0.268945 0.525905 0.778827 0.723760 0.452553)
     )

;;; 91 all -------------------------------------------------------------------------------- ; 9.5394
#(91 12.389336585999 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0)
     12.363633155823 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0)
     12.335505485535 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 1 0)
     12.130150794983 #(0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

     9.528947 #(0.000000 0.481655 1.594439 1.568902 0.697073 1.408460 1.707303 1.224860 0.612341 1.080428 0.880549 1.734112 0.982775 1.127349 0.542673 1.278938 1.245839 0.259013 0.026700 1.730319 1.718641 0.127782 0.350321 1.499262 -0.045960 0.661905 0.491583 0.650691 1.529351 0.348327 1.850119 0.053248 1.564181 1.855067 -0.100690 -0.046751 1.512155 0.331287 0.375579 0.070846 0.530999 1.696360 1.469014 0.538915 1.146418 0.023700 0.842729 -0.119479 1.151201 0.438075 1.568174 0.639290 0.856401 1.661287 0.307628 0.426892 -0.123879 1.724105 -0.224579 0.942282 1.637726 0.293382 0.106322 0.270710 1.076945 1.053470 1.411125 1.497123 0.340993 1.799885 0.724628 1.007280 1.020833 0.419771 1.154723 1.181398 1.725955 -0.054491 0.131589 1.260162 0.429345 -0.095145 1.444416 0.053690 1.369364 1.065391 0.957845 0.105299 1.588168 1.926962 0.805879)
     )

;;; 92 all -------------------------------------------------------------------------------- ; 9.5917
#(92 12.627931418696 #(0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1)
     12.009957507951 #(0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

     9.651881 #(0.000000 0.085125 0.557634 -0.181561 0.230572 -0.077740 0.019042 1.407845 1.142936 -0.001215 1.020973 0.394037 0.578597 0.937383 0.796977 0.394731 1.037703 0.716127 1.881984 0.719400 0.360421 0.572904 0.749223 0.028818 1.781664 1.651790 -0.194881 0.247122 1.817630 0.972324 0.091096 1.227364 0.656860 1.781440 0.339572 1.792881 -0.282940 0.354949 1.519462 1.400841 0.923895 0.998982 0.459242 1.020171 1.479317 0.201387 0.448358 1.116991 0.888825 0.320405 0.681924 1.080853 1.018843 1.204201 1.277967 1.058166 -0.092625 1.857660 1.158976 1.090417 0.391320 0.172509 0.473524 1.092227 1.360915 -0.168150 1.086160 1.439352 0.814291 0.870669 -0.349009 1.852552 1.376498 0.519500 1.933541 0.611237 1.239845 0.023372 1.706017 0.274708 0.894395 1.887235 0.884679 1.570192 0.728126 0.102446 0.491875 -0.033971 1.601242 0.792074 0.941474 -0.204926)
     )

;;; 93 all -------------------------------------------------------------------------------- ; 9.6437
#(93 12.624432854783 #(0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1)
     12.125471062226 #(0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     9.703831 #(0.000000 1.516050 1.734847 1.813169 -0.105899 0.481182 0.510023 -0.182647 1.945564 1.305558 0.126574 0.996967 1.682607 0.947402 0.884884 1.365471 1.702460 0.888961 1.100639 1.393874 0.338603 0.546178 0.314508 0.659604 0.192654 0.436951 1.156866 0.121482 0.268899 -0.204085 0.511015 -0.044204 0.266428 1.174160 0.988455 0.526130 0.019860 1.858881 1.115630 0.583368 0.429626 1.036602 1.520239 1.860722 1.659196 1.393464 1.683916 1.144605 1.571413 -0.021336 0.818154 0.857800 1.600648 -0.152887 1.574661 -0.293045 1.441731 1.443098 0.226926 0.935884 0.173234 0.628242 0.300674 -0.334920 1.526390 1.498612 0.342326 1.550562 0.881319 -0.147092 1.462093 0.189243 0.677942 1.359930 0.548757 0.528263 1.535511 1.256459 1.816784 1.375696 0.172911 0.121927 1.240072 1.514902 1.212390 0.413849 1.827908 1.395322 0.406554 1.472932 0.667453 1.743675 0.551960)
     )

;;; 94 all -------------------------------------------------------------------------------- ; 9.6954
#(94 12.840441703796 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)
     12.510846178591 #(0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

     9.937893 #(0.000000 0.277465 0.942051 0.747666 0.047310 0.962484 1.112319 -0.021199 1.294734 1.119831 -0.017026 0.624531 0.769202 0.980029 -0.113461 0.140834 1.460990 0.729809 0.861578 0.284196 0.941989 0.440574 0.548608 0.866803 0.746748 0.542556 1.097861 0.635432 1.893525 -0.129051 0.904690 0.362954 1.409432 1.108289 -0.261731 1.629874 0.823446 1.573578 0.380042 0.023538 1.761750 1.380694 1.767039 1.304152 1.598379 1.391791 1.169189 0.279418 1.464095 0.999247 1.035181 1.020398 -0.258100 0.208168 0.170157 0.449230 0.224408 1.465909 0.225155 1.215674 1.045153 1.275865 0.419617 1.425043 1.358996 -0.084717 0.130724 0.939266 1.507725 0.783594 0.494515 0.688870 0.830557 1.428706 1.134696 0.264853 0.942059 1.836366 1.400537 -0.133765 1.275671 1.019097 0.553805 0.733790 1.596025 0.075502 1.094153 0.112654 0.490292 1.114202 1.370172 0.939815 0.656789 0.027302)
     )

;;; 95 all -------------------------------------------------------------------------------- ; 9.7468
#(95 12.744465939438 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.706251144409 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.448801040649 #(0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.431831359863 #(0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     9.844058 #(0.000000 1.344050 1.005098 1.162729 0.845175 0.571686 -0.027564 1.104167 0.863277 -0.064148 1.590025 0.124290 -0.014685 1.747068 1.448698 1.540642 0.920160 -0.075846 0.778164 1.148536 0.406936 1.624113 1.060272 0.853312 0.359751 1.489578 1.125525 0.898122 1.753379 1.701193 1.372747 1.381202 1.083954 0.757263 1.742437 0.186167 0.654507 0.823932 1.476194 1.302410 0.835283 0.352932 0.736691 0.726520 0.739484 1.583628 0.237763 0.510659 1.159842 0.005372 0.713335 -0.138488 -0.037290 1.943937 0.872122 1.708578 1.072936 -0.228546 1.013274 1.014061 -0.001886 1.816607 0.146371 0.722794 1.425374 0.273251 0.602039 1.143792 0.826671 1.194256 0.785136 0.396142 1.293451 0.056061 1.678336 1.156136 1.628290 1.215089 0.007653 1.094305 0.316911 1.036032 1.274918 1.587515 1.314100 1.571549 -0.082927 1.679856 0.137905 1.327217 0.762216 0.854192 -0.311686 0.160405 1.842773)
     )

;;; 96 all -------------------------------------------------------------------------------- ; 9.7980
#(96 12.828451411951 #(0 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1)
     12.705632891559 #(0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1)
     12.682573318481 #(0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1)
     12.586637130548 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

     9.845584 #(0.000000 1.647742 0.310572 0.301496 0.016507 1.546026 1.262166 1.474340 1.929552 0.741903 0.806694 1.729114 0.038715 -0.365978 0.050321 0.005795 0.023737 0.968350 1.453110 1.432556 1.602780 1.038420 0.693000 0.566187 -0.101544 1.470140 -0.274936 0.561500 0.631764 1.109415 0.511379 0.600035 0.045792 0.830962 1.666802 0.955463 1.150589 0.564228 0.723673 -0.477524 0.574849 0.620632 1.759475 1.738382 0.440983 1.262407 0.786037 1.085868 0.207045 1.523599 1.269832 0.753237 1.230330 -0.446900 1.095209 -0.335095 0.933271 1.674219 1.440613 -0.077887 0.624534 1.035443 -0.015418 0.157409 0.724367 1.934850 0.833043 0.825043 0.033130 0.996301 0.013849 1.403144 1.163425 0.658310 1.797851 1.159071 1.175853 1.151790 1.010891 -0.250895 0.227599 0.815855 0.792348 1.589851 0.992884 0.246460 1.311567 0.054593 -0.283545 0.175455 0.362426 0.825718 -0.000494 1.335213 0.933249 1.516657)
     )

;;; 97 all -------------------------------------------------------------------------------- ; 9.8489
#(97 13.438 #(0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0)
     12.872588157654 #(0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     12.585 #(0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
     9.893709 #(0.000000 1.554771 0.937691 0.107253 1.348826 1.369619 1.555110 0.726878 0.806368 0.984615 0.564036 1.850901 1.316445 0.720154 0.080322 1.473966 1.778234 -0.107051 -0.190972 -0.016781 0.271373 0.754269 1.672021 0.125303 1.481616 0.619056 1.221190 1.248441 1.459723 0.778322 0.897014 0.194547 1.354525 0.507250 0.474628 1.479252 0.157806 1.409509 1.160421 1.449484 0.927078 1.758283 0.100656 1.433266 1.380713 0.838665 -0.137924 -0.004995 0.105022 0.950957 0.457169 -0.451088 0.057296 1.644440 1.022251 1.820805 1.111880 0.698807 -1.937796 1.661575 1.946096 -0.109704 1.491055 0.841201 1.410935 1.061826 1.369956 -0.020542 1.931642 0.486819 0.575853 0.803189 1.320194 0.509048 0.842233 1.491823 0.207453 1.335914 1.270844 0.600927 0.394468 0.822040 1.507993 0.381442 1.010540 0.194383 0.671291 0.265198 0.433820 0.547122 1.820973 0.655966 1.311413 0.775817 0.005875 0.658500 1.194795)
     )

;;; 98 all -------------------------------------------------------------------------------- ; 9.8995
#(98 13.163645755645 #(0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1)
     13.161917686462 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1)
     12.724907890996 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

     9.816357 #(0.000000 -0.148460 0.679981 1.142506 -0.147845 1.656387 0.345155 0.479038 0.167025 0.705760 1.696635 0.356402 1.032342 0.538373 0.342390 1.567430 0.944381 0.926671 -0.115394 1.634399 1.642385 0.065401 1.882478 1.193921 1.290380 1.243741 0.015321 0.407853 1.200940 1.646677 -0.140446 0.257082 1.267422 1.673203 1.134641 0.909036 1.120636 1.463714 0.837390 0.444951 0.784365 -0.394187 1.872820 1.726400 -0.237933 0.757251 0.583044 0.615008 0.208779 -0.010693 1.514708 -0.044529 0.599771 0.011962 0.486920 0.531955 -0.064352 1.280390 1.327909 0.039617 0.274209 -0.198351 0.620436 0.477741 0.810833 0.011544 0.599225 1.211252 0.837062 1.231370 0.675467 1.637382 0.322601 1.861993 0.721981 0.079932 1.549764 0.194251 1.462469 0.313013 0.139534 1.549062 1.224767 0.500976 1.419479 0.863486 0.038209 1.480017 0.625455 0.260588 0.561787 0.302218 1.798458 0.257145 1.152665 -0.091103 0.164202 1.195184)
     )

;;; 99 all -------------------------------------------------------------------------------- ; 9.9499
#(99 13.236550650051 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1)
     13.002375571256 #(0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

     9.906340 #(0.000000 0.598193 1.111553 -0.010149 1.703360 0.211191 1.020566 1.562681 1.634142 1.144106 0.755728 0.764005 -0.124718 0.313538 0.657222 1.668828 -0.445718 -0.155196 1.644254 1.801280 1.042034 0.090314 0.452720 1.626373 0.466828 1.630660 0.063446 1.524994 1.472574 0.816475 1.263051 1.600720 1.167636 0.416678 1.322511 0.629826 0.681919 0.492136 1.220983 0.320167 0.082878 -0.205228 0.784104 0.452318 1.584898 -0.064865 1.693548 1.803515 0.360135 0.516002 0.053316 1.446767 0.855848 1.144718 -0.045736 0.200417 0.037646 1.805130 0.062566 0.045204 0.099898 0.332026 1.263196 1.034018 0.047477 1.478233 0.054102 0.183489 0.800256 -0.311586 0.784371 0.564831 1.762603 0.423143 1.375830 0.867807 1.063036 1.666325 0.701829 0.867742 1.687776 -0.464002 1.474279 1.218540 0.444898 0.284682 1.439562 1.793562 0.242794 1.844931 0.905435 1.794664 1.046412 0.542675 1.533252 0.775693 1.222967 1.590224 1.265381)
     )

;;; 100 all -------------------------------------------------------------------------------- ; 10
#(100 13.230233676417 #(0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0)
      12.998435541498 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

      10.224867 #(0.000000 1.970117 1.167809 1.882699 1.303902 1.033548 0.266090 1.426377 0.032255 1.275670 0.142429 0.258571 1.665757 -0.399870 0.989213 0.281513 1.660318 0.603731 0.826073 0.667391 0.674077 0.933864 1.543005 -0.161620 1.221160 -0.080410 1.893538 0.019075 0.606503 -0.230921 1.662747 1.338575 1.721866 0.981426 -0.039072 1.437132 0.756301 0.857596 0.462056 1.307796 1.333504 0.467979 1.596079 1.802237 0.152329 1.845194 -0.061722 0.344192 1.535797 0.102104 0.602329 1.671265 1.321975 0.240136 0.579666 0.837482 1.880109 0.218567 0.411640 1.857201 1.200191 0.636452 0.164328 1.029409 1.284437 0.774560 0.898772 -0.111553 0.081417 0.063611 1.405789 1.294340 0.158374 1.289334 0.136597 1.053020 1.747663 1.513721 0.493256 1.103869 0.926103 1.459660 0.093725 1.607775 1.512566 1.266996 1.011150 1.268929 1.563078 1.003557 0.257770 0.863913 0.728354 1.244521 1.534416 1.156027 0.083947 0.500566 0.766731 1.661430)
      )

;;; 101 all -------------------------------------------------------------------------------- ; 10.0499
#(101 14.018204689026 #(0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0)
      13.645306283587 #(0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 0)
      13.268 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)
      13.219774246216 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

      10.222326 #(0.000000 1.511340 0.307007 -0.101990 1.669288 1.450369 1.255707 0.352003 0.354773 0.222907 -0.297897 0.618930 1.659147 0.781398 0.648885 -0.011787 1.616042 0.045203 1.469990 -0.384484 0.711829 1.493248 0.762568 0.386853 0.265981 1.580490 0.830950 1.390633 0.475060 0.183610 0.981837 1.316376 0.671956 0.766275 0.973627 0.495198 1.562258 1.222539 -0.126413 -0.000376 0.017674 1.775142 0.655924 0.009658 1.445521 0.961719 1.661668 0.415713 0.480033 -0.209104 0.576231 0.488478 0.765240 1.580352 1.872481 1.098733 1.169426 0.166992 -0.502029 1.572009 0.990606 0.184543 1.122702 1.630818 0.637588 1.709028 1.250265 0.847591 0.078595 0.735935 1.731677 1.780951 1.666286 1.407491 1.801757 1.347989 1.547196 0.539384 0.816326 1.230273 0.720886 1.258285 1.311626 1.061269 1.676801 0.976569 1.220667 1.094809 0.112143 1.294124 0.158725 0.125812 0.412883 1.024418 1.168911 1.599401 1.618174 0.359827 0.776253 1.645653 -0.113651)
      )

;;; 102 all -------------------------------------------------------------------------------- ; 10.0995
#(102 13.521512151222 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0)
      13.497511863708 #(0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1)
      13.300039088203 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)
      13.194128990173 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      10.258601 #(0.000000 0.112995 0.476137 0.342739 0.801140 0.927907 -0.197682 -0.037213 0.084752 1.673083 1.385505 1.294607 0.737751 0.712118 0.785526 0.423747 1.612431 0.393738 0.451135 -0.496704 0.730224 1.364423 1.501517 0.561328 1.834629 1.839582 0.877534 0.217256 0.545886 1.477387 1.712360 0.504495 1.471856 1.122461 0.829453 -0.219416 0.004943 1.899052 0.640082 -0.070621 1.250418 0.587154 0.242636 0.612317 0.416451 0.537471 1.082279 1.812566 0.500011 -0.011388 0.566559 0.267777 1.677343 0.096339 0.871989 0.953350 1.854853 1.597924 1.031704 1.015147 0.720465 0.353189 0.094984 1.691932 0.665736 -0.268389 1.105588 1.875184 0.225688 0.131946 0.212729 0.343564 0.842191 0.406459 0.139847 0.742979 1.947866 0.641704 0.119899 1.257118 0.071742 0.701629 -0.357087 0.959946 1.311480 0.667025 1.680822 1.598498 -0.295913 0.252788 0.862100 -0.382709 0.231599 0.994707 1.050017 1.186935 0.355210 1.092185 1.267868 0.951887 0.839932 1.858749)
      )

;;; 103 all -------------------------------------------------------------------------------- ; 10.1489
#(103 13.720711052869 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.673172572795 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.435972213745 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

      10.363056 #(0.000000 0.761017 0.774720 0.600901 0.288873 -0.071070 0.774041 1.524736 0.353677 0.863169 0.295170 0.619112 0.240730 0.148717 0.246262 1.886459 1.674206 1.069235 1.738095 0.073984 -0.077494 1.658422 0.668148 1.564746 1.243374 -0.210242 0.480459 1.123439 1.181456 1.237757 0.162689 0.498592 0.955813 1.036959 0.403468 0.253398 -0.210023 1.214469 0.989462 1.272997 0.324820 -0.383531 0.492925 0.899475 1.249765 0.623735 0.025388 1.046901 0.230396 1.568527 1.414344 1.329686 1.494535 1.229123 0.112931 0.940031 1.215343 0.517457 1.132908 0.231647 1.495768 0.562911 1.157367 1.588298 1.380100 1.052242 1.927277 0.983655 -0.022396 1.537754 0.864818 1.491165 -0.009397 1.541430 0.582026 0.104249 -0.136203 0.695567 0.217961 1.674357 0.839835 -0.255416 0.042248 0.191656 0.893903 0.657431 0.748551 0.718148 1.351486 1.423092 1.242628 1.535775 0.442474 1.801999 0.886228 1.290236 0.213409 0.278385 1.078491 0.256112 0.175795 1.208709 1.281774)
      )

;;; 104 all -------------------------------------------------------------------------------- ; 10.1980
#(104 14.242193222046 #(0 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.682311361591 #(0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.330215043333 #(0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

      10.188148 #(0.000000 1.530511 1.654647 0.852195 1.504195 1.049830 0.096455 1.246616 1.500932 0.837265 1.484588 -0.180145 1.124927 1.243393 0.858707 0.170526 0.866914 0.395310 0.411743 0.928903 1.593894 0.727391 1.570169 0.845150 0.354634 0.528849 1.650999 0.012487 0.788922 0.043018 0.542951 0.086082 1.762995 0.134307 0.887464 0.506944 -0.165663 1.633791 1.507747 0.705773 0.776452 0.071616 0.887916 0.177118 -0.229958 0.864649 -0.044023 0.700818 1.525519 0.032733 1.887230 0.735838 0.540508 0.663700 0.344925 0.385988 0.598969 1.443690 1.541127 1.495296 0.261203 1.065542 0.392949 0.030537 0.627081 0.095609 1.642821 1.272383 0.050512 0.321322 0.364873 1.365131 1.383970 0.606154 0.951825 1.661958 0.995351 0.910714 1.766385 1.618682 0.478271 0.481183 1.230751 0.021572 0.475093 1.563609 -0.038195 -0.261374 0.290013 1.521032 1.531332 -0.424704 -0.055461 0.020475 0.269512 0.549719 0.629888 0.701417 0.209342 1.527979 0.607184 0.359118 1.544484 0.707679)
      )

;;; 105 all -------------------------------------------------------------------------------- ; 10.2470
#(105 14.418999645918 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)
      13.595993876506 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

      10.231088 #(0.000000 0.625574 0.201269 1.326538 1.367665 -0.356999 0.508530 0.636597 0.288691 1.054890 -0.132526 -0.048328 1.240775 1.723143 1.099267 1.499243 0.056926 1.025202 -0.012266 1.930481 1.512462 0.800397 0.412570 1.428037 0.152103 -0.235613 0.145326 0.495494 1.140930 1.148623 1.047264 1.271730 0.947046 1.928143 1.139069 1.559823 0.344279 1.453446 1.951859 1.288933 -0.026338 1.376109 1.305408 1.007592 0.496782 0.481295 1.059274 0.469291 0.609489 1.576559 0.572414 1.363658 1.177108 0.232943 0.256078 0.563266 0.662845 0.886259 0.811296 -0.151844 1.511117 1.284141 0.270272 0.137980 1.714484 1.579526 1.906108 1.621311 0.401667 0.143004 1.306697 1.635000 1.149955 0.879745 1.213925 0.346287 -0.198139 0.152693 0.143118 0.860152 -0.036895 0.543163 0.334055 -0.051679 1.606700 0.450838 0.167730 0.397211 -0.267527 0.705635 0.229274 1.078232 1.076773 -0.022538 0.598378 0.654427 1.088360 0.011236 0.559751 -0.176410 1.683065 0.318170 0.700365 1.698039 1.327443)
      10.226878 #(0.000000 0.629256 0.198658 1.321908 1.369825 -0.356164 0.507615 0.637841 0.290389 1.053374 -0.130321 -0.049713 1.242936 1.724732 1.099606 1.496994 0.057854 1.024807 -0.010829 1.930157 1.515302 0.801794 0.413193 1.431368 0.151728 -0.235805 0.143319 0.499331 1.140979 1.148132 1.046869 1.270165 0.946826 1.928882 1.144541 1.560433 0.344734 1.449686 1.947933 1.287702 -0.027775 1.373849 1.304127 1.008319 0.497086 0.481786 1.060175 0.469316 0.609384 1.581398 0.569989 1.363816 1.176386 0.233412 0.256849 0.564662 0.665567 0.890141 0.811987 -0.149684 1.510136 1.288134 0.271329 0.136991 1.716353 1.580326 1.907366 1.616904 0.398961 0.144782 1.303268 1.632982 1.150702 0.880366 1.208390 0.347761 -0.197226 0.155975 0.138032 0.860304 -0.030222 0.546225 0.333954 -0.052274 1.607125 0.453048 0.166754 0.397644 -0.270405 0.703549 0.232865 1.076605 1.078723 -0.025070 0.599438 0.656352 1.092692 0.010873 0.562469 -0.174093 1.683070 0.317462 0.700578 1.696159 1.326756)
      )

;;; 106 all -------------------------------------------------------------------------------- ; 10.2956
#(106 14.299785614014 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.811582734804 #(0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.421741504769 #(0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0)
      13.200031373463 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      10.394865 #(0.000000 0.053213 0.080547 1.276536 1.076917 0.877915 -0.109063 0.534427 0.789639 1.001355 1.558069 1.047615 1.317636 0.117332 0.091282 -0.260487 1.200794 0.904796 0.412197 0.044113 0.316251 0.680078 1.444764 0.065700 0.821362 0.225133 0.519586 0.205046 1.215642 1.209968 -0.150845 0.473881 1.254031 0.009507 1.052686 0.525893 0.052625 0.976770 -0.071745 0.030853 1.277478 0.657686 1.436669 0.783909 1.444070 -0.036042 1.084983 0.366442 1.720891 0.373645 1.418115 0.974785 0.758283 0.884965 0.652257 0.618107 1.245824 1.723833 0.642367 1.518152 0.286384 1.120950 1.077855 1.577056 1.398604 0.208505 1.439310 1.093423 0.096413 0.488499 0.097908 1.780658 0.146417 -0.282502 0.351823 0.066776 -0.399454 1.029174 0.071235 0.010902 1.722692 1.267456 0.599928 1.168400 0.912330 -0.167723 0.144122 0.047377 0.209509 0.441739 1.944848 0.392506 1.092205 0.584168 1.441180 1.780611 0.265971 0.352806 1.494605 -0.323564 0.280681 1.691921 1.508991 1.357041 -0.147753 1.239841)
      )

;;; 107 all -------------------------------------------------------------------------------- ; 10.3441
#(107 13.927956268954 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1)
      13.912716531306 #(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0)
      13.624429092956 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)
      13.224366750161 #(0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      10.509723 #(0.000000 1.245646 0.597397 1.761809 1.863030 0.529021 0.084134 0.585386 1.594901 0.734250 0.547442 -0.041332 0.358840 1.325735 1.370924 0.634083 1.153129 0.134289 0.287516 1.032572 -0.199022 1.749931 1.061378 0.296885 0.022865 1.645581 1.320963 1.862332 0.609536 0.132901 0.439954 1.889202 1.569803 0.250436 1.344828 1.129371 0.103345 1.153616 0.173360 1.009598 1.491663 0.302014 -0.017385 0.293936 1.465088 1.515908 1.864762 0.425681 0.062365 1.007121 0.618860 1.067812 1.345047 1.723637 1.187258 0.552255 0.950015 1.292533 0.997296 1.353669 0.162073 1.175736 1.435300 0.198459 1.913550 1.278865 1.575872 1.242843 1.528557 1.365254 0.518098 1.361045 1.070391 1.436357 0.538787 1.434357 0.167419 -0.065492 0.770829 0.392656 0.085257 1.775495 0.186464 1.084185 0.813517 0.595097 0.006188 1.398940 1.819096 -0.012876 1.894230 1.463597 1.617757 0.249038 0.490647 0.994520 -0.354368 1.626774 1.379109 1.543355 1.444981 0.614982 0.055505 1.077654 0.419835 0.735585 1.649319)
      )

;;; 108 all -------------------------------------------------------------------------------- ; 10.3923
#(108 14.009567264777 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0)
      13.998919339781 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0)
      13.694299006963 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1)
      13.534 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

      10.543357 #(0.000000 1.402747 0.622010 1.807740 1.084340 0.790125 1.320303 1.620102 0.490131 1.765484 1.074825 0.142640 0.488185 -0.011765 0.464977 0.235926 0.835162 0.710086 0.813454 -0.210862 1.257909 1.680089 0.622386 0.197483 0.879514 1.054011 -0.028207 -0.275727 0.704175 0.187452 0.918057 1.468566 0.727604 1.101418 1.579293 1.002747 1.892325 -0.090618 0.533879 0.783135 0.765331 1.558966 0.325124 0.742413 1.758657 0.820769 1.821463 0.012614 0.592984 0.251440 0.496853 0.325838 1.567883 1.010715 0.408180 1.706279 0.004205 1.830026 1.011159 1.233304 0.895308 0.432094 0.651781 1.265685 1.179331 0.749291 0.403725 0.921722 0.169744 0.794285 0.286072 1.738669 1.390921 0.143333 0.315035 0.739224 1.202977 0.548873 -0.264270 0.396975 0.993423 1.055739 0.348132 0.852241 1.275945 1.680136 0.561998 1.392169 1.857298 1.038454 0.212491 1.737653 1.693735 1.592150 1.368268 -0.152064 1.548290 -0.064388 1.090628 0.404743 0.647758 0.011058 1.894132 1.383257 1.648239 1.075805 1.324359 0.994517)
      )

;;; 109 all -------------------------------------------------------------------------------- ; 10.4403
#(109 13.820175866598 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)
      13.496821304096 #(0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      10.708543 #(0.000000 0.371106 0.470203 0.239003 1.012961 0.129927 1.335363 -0.029381 0.006645 1.533429 1.162957 0.082548 1.474064 1.765598 1.903120 1.798532 -0.303830 1.052279 0.123670 0.276123 1.021894 1.653170 1.255939 1.506088 -0.227044 1.705939 1.649613 0.557253 1.032918 0.928799 1.294648 0.993658 1.887581 -0.127503 1.695253 1.321081 0.812581 0.498744 0.006208 1.570845 -0.002794 1.400353 0.306663 1.463284 1.738958 1.517418 1.701378 0.754943 -0.104189 0.982859 0.619499 0.995150 0.362960 1.469254 1.051047 0.964370 0.499393 1.216927 1.801154 -0.092442 0.014621 1.727291 1.303317 0.006540 0.294231 0.876519 1.690182 0.335380 -0.010161 0.803444 1.345767 0.551736 0.896544 0.901009 0.159505 1.730609 -0.175613 0.489310 0.772393 1.230645 0.693678 0.352660 1.003829 0.851550 0.700109 1.005924 0.039140 1.676203 0.343021 0.995339 1.348977 1.865300 1.179025 1.101625 1.089879 0.728468 1.381045 0.282021 0.357441 1.312131 -0.048052 1.229064 0.069444 0.119271 1.328440 0.842242 0.077966 0.203249 1.188297)
      )

;;; 110 all -------------------------------------------------------------------------------- ; 10.4881
#(110 13.885513312292 #(0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0)
      13.64278793335 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)
      13.592092514038 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      10.739090 #(0.000000 1.156282 -0.287659 0.671868 0.016349 0.141141 1.314200 1.378376 0.745508 1.502881 0.428178 1.624259 -0.002906 1.725453 0.434132 0.638339 1.120126 0.921796 1.343557 0.117805 0.906679 1.185773 0.888195 0.502140 0.288921 1.017681 0.810817 1.104031 0.966142 1.064285 0.309628 0.557648 0.802417 0.271693 1.940373 0.091489 0.907542 0.454318 0.870055 0.181110 1.814256 0.100468 1.066253 0.233949 0.272882 1.339976 1.467081 0.680247 1.609198 0.145242 0.599627 0.673463 0.229785 0.169881 0.495581 0.862615 1.428791 1.806616 0.753886 0.984216 0.573874 1.194402 1.163492 1.049031 0.989019 0.700068 1.794268 1.342048 0.409380 0.365945 1.797274 -0.010034 1.903031 1.046556 1.326641 0.773217 0.885631 0.348422 1.371059 0.711162 1.614065 0.997785 1.317350 -0.016300 0.313659 1.749519 0.499507 1.119921 0.951889 -0.189027 1.129542 -0.034033 1.822479 0.590383 -0.280380 1.566555 -0.016838 -0.101813 1.196110 0.316133 0.731239 0.430072 1.155495 0.072031 1.694327 0.899239 0.865048 1.876592 1.200502 0.510936)
      )

;;; 111 all -------------------------------------------------------------------------------- ; 10.5357
#(111 14.436 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)
      14.359505653381 #(0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0)
      13.80813938144 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

      10.627327 #(0.000000 1.378376 1.040811 -0.200345 1.865443 0.175638 1.815760 1.398729 0.353312 1.532464 -0.112514 1.338746 0.100690 1.221434 1.352756 -0.012325 1.368152 0.486106 0.534577 0.058996 0.661620 0.511417 1.057814 1.433311 0.249248 0.094678 1.000464 -0.045006 0.770639 1.348293 -0.203611 0.895080 1.632205 0.684869 1.444904 1.372922 1.284243 1.074774 0.570188 1.240080 -0.341803 0.370280 0.913216 1.314257 1.477371 1.418605 0.081101 0.557683 -0.017787 1.330401 1.113310 1.260856 1.361928 1.134453 0.075131 0.562865 1.816255 -0.116782 1.733359 1.157096 1.568730 0.745454 0.895487 1.009557 0.733045 0.373773 1.354392 0.955279 1.052502 1.581079 1.626303 -0.046242 0.783561 0.677552 1.562626 0.738597 0.009014 0.176334 -0.172077 0.273163 0.047490 0.130726 0.559438 0.291652 0.315085 1.594876 1.203086 0.818936 1.550355 0.181030 1.871042 1.202748 1.581630 0.528291 0.478774 1.639277 0.339781 1.642247 1.650500 0.958958 0.386046 1.271452 -0.362653 1.449462 0.665294 0.298708 1.243070 0.125123 0.281755 0.794855 0.221503)
      )

;;; 112 all -------------------------------------------------------------------------------- ; 10.5830
#(112 14.387 #(0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.250584755219 #(0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.059637729172 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1)
      13.719 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      10.669476 #(0.000000 -0.115927 1.480602 1.003194 0.609644 0.973531 0.775599 0.913985 1.188006 0.349080 -0.294548 0.851453 0.277406 1.542537 1.159683 0.722392 1.201938 0.975781 0.380676 1.927000 1.584338 0.369527 0.504040 0.549515 0.813799 0.752781 1.373472 0.294166 0.291932 0.586148 1.746917 1.809952 0.792813 0.306313 0.164694 0.309571 0.813127 0.167280 1.658517 1.520724 1.439227 -0.005206 0.569538 1.554350 1.622259 0.004096 0.324039 0.313587 0.313931 0.351048 0.773704 0.032142 -0.000638 -0.232135 0.568530 0.669231 1.500293 -0.071934 0.587478 0.833637 0.873289 -0.231860 0.442228 0.929466 0.621790 0.686272 0.830861 0.311257 0.013921 1.648800 1.405256 1.147937 -0.065489 1.787644 0.487982 1.096410 -0.234131 0.133403 1.253568 1.990381 0.775508 1.184870 0.434147 1.305468 1.234114 1.393775 1.014630 0.369631 0.517633 -0.131991 1.217047 0.179100 1.038640 1.832353 1.133503 0.211387 0.260324 0.921873 0.390875 0.737460 1.724116 0.455583 -0.193133 0.839298 1.583047 1.253334 1.198925 1.324328 1.260571 0.081014 1.312703 0.442679)
      )

;;; 113 all -------------------------------------------------------------------------------- ; 10.6301
#(113 14.501041453443 #(0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1)
      14.027848738379 #(0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      10.823463 #(0.000000 0.835504 1.045796 0.055731 0.333861 0.961764 1.484522 1.801423 0.155701 0.482925 1.383575 1.266895 0.163729 0.566786 0.311997 0.424348 1.786709 1.129727 -0.010887 1.223532 -0.037472 -0.041890 0.642823 0.699857 0.027489 -0.699762 0.588003 0.372917 1.883299 0.393040 0.094028 1.419367 0.664727 1.480132 1.487791 0.535931 0.515211 0.512990 0.476407 1.748607 1.777557 0.002923 1.168562 0.459414 0.726028 1.334565 0.336794 0.265239 1.229568 1.377214 1.004423 0.217551 -0.136043 1.200489 1.384402 -0.079931 0.081188 0.019276 1.744156 0.626585 0.841138 0.011336 1.011543 -0.201792 0.519659 -0.027177 0.781645 0.488491 0.461901 1.247506 1.026927 1.110988 0.955157 1.190158 -0.022946 1.334306 0.056859 1.617327 0.738682 0.955054 1.118735 0.207948 0.830794 0.064198 1.101640 0.956965 0.530340 -0.289707 1.292669 0.768867 1.453283 0.409912 0.925595 0.666844 0.262774 0.747452 0.647702 0.079949 0.891712 1.775582 0.452232 0.319362 -0.031635 1.522910 1.568498 1.146812 1.613187 1.854049 0.710335 1.563147 0.991356 1.276810 0.650177)
      )

;;; 114 all -------------------------------------------------------------------------------- ; 10.6771
#(114 14.119774267447 #(0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1)
      13.847382931726 #(0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      10.834372 #(0.000000 0.647458 0.884834 0.789469 0.943620 0.173117 1.642010 0.894797 1.754491 1.144258 -0.711535 0.160582 0.017340 1.100624 -0.197580 0.369836 1.656584 1.791631 1.651184 -0.602759 0.119961 0.874705 0.656157 0.359640 0.574830 1.260369 0.459233 1.017924 1.608773 0.988063 0.465045 0.835669 0.179715 1.570729 -0.023942 0.140483 0.197289 0.144416 -0.253201 1.567238 0.940119 -0.128288 1.286672 1.136577 1.569716 1.560972 0.911410 0.019828 1.433973 1.234941 1.697560 0.670616 1.244947 0.661817 0.409249 1.306353 1.448433 1.124470 0.270331 1.658856 1.739289 1.491354 0.640699 0.788062 1.224290 1.101571 0.348888 1.073887 1.122818 0.071690 0.802717 0.548724 -0.052226 0.478764 1.033813 1.327515 1.366750 1.171242 0.254427 1.327028 0.753435 1.098242 0.215343 0.549749 1.046690 -0.423054 1.501972 0.890944 1.887403 -0.372900 1.766096 1.051649 -0.303656 1.524429 1.454146 0.658552 0.365659 0.771959 1.615529 -0.266420 1.433222 0.058598 1.166187 0.321542 0.107538 1.034250 -0.030507 1.279442 -0.019697 0.408747 0.953491 0.320782 1.267647 -0.178859)
      )

;;; 115 all -------------------------------------------------------------------------------- ; 10.7238
#(115 15.196797370911 #(0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0)
      14.359978160099 #(0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

      10.936834 #(0.000000 0.117113 0.418268 1.018284 -0.225295 1.690675 0.321975 0.364232 1.382813 1.684813 0.504425 -0.225693 0.932449 1.141180 0.112526 0.708909 0.367000 1.065298 -0.223996 1.135386 0.113367 0.984366 0.622849 1.170112 1.306611 1.162359 0.098081 1.635576 -0.065859 0.592693 1.346558 0.918818 -0.007975 0.690462 1.402813 0.055781 0.132473 0.479454 0.830774 0.011132 0.319221 0.899674 1.672888 1.557425 1.192330 1.286929 1.354504 1.481715 0.733358 1.494691 0.295194 1.515279 1.412695 0.405048 1.420816 0.024077 0.715176 0.381691 0.228730 0.923073 1.716090 0.341284 -0.069729 0.222796 0.173749 1.098770 1.358532 0.803328 0.192477 0.003841 0.078668 1.702300 -0.026134 1.247187 0.628320 0.580333 0.686856 1.036717 -0.335193 1.120780 0.616407 0.829463 1.468634 0.884023 0.296707 1.693060 0.578179 0.232270 1.031449 0.107766 1.383234 1.257396 0.338524 1.081066 0.820478 1.747208 0.708556 0.776050 0.160627 0.397607 0.046231 0.309141 0.107422 0.706536 0.579733 0.158914 0.837752 1.178852 0.545793 0.347030 -0.192749 1.555557 0.570452 0.304451 0.290891)
      )

;;; 116 all -------------------------------------------------------------------------------- ; 10.7703
#(116 14.830805621528 #(0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1)
      14.175787507646 #(0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

      10.896008 #(0.000000 0.781375 0.035823 1.129371 0.440955 1.744662 1.461808 0.881245 0.021244 0.672381 1.008692 0.172427 1.355647 1.177432 0.536994 1.305905 0.006992 0.439957 1.389395 1.926374 1.789203 0.986767 1.838494 0.957412 0.245673 0.230888 0.982926 0.372432 0.314299 1.329171 1.152596 1.564133 0.575067 0.217517 0.875229 0.135910 -0.012897 1.264497 -0.471578 1.018353 0.416938 1.160676 0.937643 0.202111 1.171286 -0.365535 1.209921 1.497064 1.745156 0.144706 1.609539 0.072998 1.124418 1.174663 1.384526 1.235404 -0.264021 1.884353 1.638552 0.573307 0.892047 0.260383 1.479205 1.808362 1.364568 0.248416 1.190124 1.003788 1.396471 0.106587 1.285522 0.683664 0.724122 1.033758 1.069165 -0.119963 1.191128 1.049510 0.272284 1.597648 1.832582 1.289507 0.561115 0.890798 1.727166 1.481027 0.907227 0.419500 1.020158 0.330877 0.473096 1.783430 0.008903 0.247030 1.146386 1.288801 1.679260 0.530699 1.289472 -0.126557 1.572558 1.425496 -0.022265 1.334026 -0.376128 -0.390978 0.054397 0.897087 0.929914 0.593144 0.374114 0.498843 0.812897 0.948609 -0.073957 0.265159)
      )

;;; 117 all -------------------------------------------------------------------------------- ; 10.8167
#(117 14.857519237248 #(0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0)
      14.522986412048 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)
      14.136 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

      10.961158 #(0.000000 1.458583 1.208021 1.566600 -0.019226 1.590111 1.213860 -0.356402 0.030039 0.798920 0.106860 -0.401527 0.348276 1.855779 0.404768 1.166127 1.571209 0.365978 0.435645 1.016790 0.020645 1.281288 1.439875 1.796927 -0.219511 0.853762 1.609541 1.150125 0.895822 1.477092 -0.396206 0.262922 1.625811 0.938533 -0.305607 1.476434 0.241572 0.614333 0.521967 0.128226 0.118780 0.137886 0.081493 1.852749 1.886536 0.265648 1.513034 0.542774 0.146691 1.755490 1.411807 1.302729 1.686132 0.258077 0.899674 0.727503 0.610001 -0.148311 1.607877 0.770464 -0.261098 1.863300 0.096720 1.137760 0.265682 1.315994 0.616464 1.437295 1.055367 0.960027 0.703569 0.853641 1.657730 0.443313 1.628826 1.625440 1.196841 1.208035 1.651584 0.482949 1.774534 1.125636 1.597681 0.856794 0.032199 1.970635 0.351446 1.671319 1.109907 1.099483 0.638728 1.100368 1.320291 1.300883 -0.185228 0.940765 0.050179 -0.004169 0.929296 0.097740 0.732227 1.330802 0.561306 1.560738 0.399521 0.772326 0.685918 1.855697 -0.165801 1.362574 0.635972 0.321182 -0.077478 0.816474 1.354290 0.251899 0.968938)
      )

;;; 118 all -------------------------------------------------------------------------------- ; 10.8628
#(118 15.151820108516 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0)
      14.496 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1)
      14.207115029287 #(0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

      11.054130 #(0.000000 -0.332133 -0.102618 0.174619 0.228040 0.855938 -0.091421 1.682894 0.370397 1.285303 0.891615 1.847229 0.741604 0.198794 1.092635 0.734048 0.358691 0.595895 1.635045 -0.506931 1.174552 0.225098 0.775549 0.456772 1.736532 1.550627 1.395929 1.189785 0.539674 1.529851 1.775185 -0.044671 0.741003 0.278457 0.331696 0.670482 0.873006 0.272616 0.394572 1.877037 1.415373 1.345011 1.633134 -0.586167 1.049276 -0.174129 1.081495 0.773864 1.412443 0.256538 1.637893 1.145539 1.179434 1.088579 1.435601 0.026556 1.127291 1.062778 0.149201 1.221989 0.870327 0.520691 1.016033 0.613093 -0.174864 1.450251 1.189791 0.133395 1.548916 0.965434 0.972198 0.779978 0.183661 0.858995 1.109065 0.692716 -0.126375 0.975139 1.240874 0.153331 0.847571 1.029318 1.778654 1.633627 1.825491 0.919039 1.640887 1.586866 1.193866 1.620183 0.645421 1.485034 -0.161428 0.332287 -0.263531 0.352435 1.105493 0.934213 1.204803 0.110707 1.367263 0.172973 0.695810 -0.067532 0.764023 0.153359 0.964041 -0.226645 1.885084 0.230907 0.649538 0.752392 0.293046 0.955674 1.644760 0.053926 0.877309 1.109100)
      )

;;; 119 all -------------------------------------------------------------------------------- ; 10.9087
#(119 15.63721370697 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.803846337507 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.502624011553 #(0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      11.118182 #(0.000000 0.665863 0.819922 1.239018 0.429377 1.735824 0.385981 1.289624 0.983332 1.609088 0.931020 0.584076 0.891094 1.655893 1.704522 0.466315 0.210054 0.196477 0.477716 0.335011 1.767931 -0.646341 1.181508 0.227252 -0.307379 0.024090 0.728566 1.146819 -0.267668 1.347521 0.039257 0.040538 0.305394 0.945588 0.329448 0.363201 1.165975 0.344102 1.678900 1.950969 0.914613 0.934036 0.772338 0.967197 -0.053029 0.502890 0.087134 0.631754 1.619663 0.597036 -0.190757 0.512318 -0.114194 1.918714 1.142599 1.668225 1.348744 0.311939 0.155914 1.377427 1.418464 0.194460 0.964545 0.544917 0.851638 0.798084 0.210416 0.527857 1.140699 -0.187998 1.461176 0.789969 0.131336 0.417191 0.501603 1.859184 0.758752 -0.043783 -0.089433 0.268891 1.454141 1.613991 0.121136 0.734815 0.194010 0.243399 0.616336 0.836206 0.130213 0.339309 0.113811 1.068942 0.067583 0.192555 1.773091 0.018037 1.022706 0.770688 0.895236 1.369385 1.204457 0.894849 -0.048521 -0.148711 1.152253 1.754096 1.312370 1.460315 0.496577 0.963956 0.751118 0.177983 1.766830 0.882617 1.048318 0.166253 1.035173 0.970007 1.626140)
      )

;;; 120 all -------------------------------------------------------------------------------- ; 10.9545
#(120 14.761 #(0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1)
      14.534638752286 #(0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

      11.001260 #(0.000000 1.628418 1.324050 0.627144 0.050994 0.645025 1.321375 0.548161 0.047364 1.754848 0.936834 0.341606 0.087885 1.869975 0.190947 0.720136 1.676135 0.215591 0.294561 1.296455 0.115845 0.540200 -0.345793 -0.178503 0.408279 1.503318 -0.172528 0.283529 -0.389961 1.654959 0.842373 0.979104 1.648915 1.283500 1.378190 0.328945 1.353254 0.131593 0.707429 0.054174 -0.188920 1.275793 -0.022489 1.673958 0.335989 -0.118265 1.440268 1.697279 1.273991 0.593959 1.860765 -0.048466 0.002214 0.698806 1.585570 0.477068 1.134043 0.621624 1.294736 0.725349 0.373726 0.450448 0.097482 0.787316 0.383155 0.289405 0.966014 -0.095773 -0.163332 1.187611 1.192502 0.965390 0.240076 0.727857 1.544436 -0.311110 -0.124155 0.660828 0.124775 1.369479 0.448099 -0.183493 1.346505 1.735715 1.592965 1.214154 0.209427 0.244200 1.563349 0.670422 1.530625 0.629709 0.932140 1.418825 1.040245 0.936049 1.286139 0.003842 -0.191364 0.134545 1.431979 1.125678 1.787562 1.687456 0.274491 0.353238 0.622957 -0.139942 0.037241 0.089733 0.666554 1.049216 1.009497 -0.118209 1.106734 -0.125548 0.063822 -0.196912 0.478842 1.405480)
      )

;;; 121 all -------------------------------------------------------------------------------- ; 11
#(121 14.765577345045 #(0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0)
      14.619540214539 #(0 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.286643427331 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.184466362 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      11.242723 #(0.000000 1.051223 1.226654 0.784745 0.342900 0.402994 0.342405 1.273523 1.037878 -0.023459 1.583926 1.245333 0.476411 1.338040 1.382319 0.244668 1.435405 1.284463 0.422727 1.728660 0.969414 0.615501 0.354228 0.745141 0.170442 1.879491 1.621701 0.598763 -0.366936 1.659818 1.246694 1.383952 0.333008 1.436975 1.323954 0.893398 0.368904 0.068309 0.432824 0.773078 1.242831 0.459826 1.049837 1.639776 0.139686 1.757537 1.782306 0.789855 0.513893 1.202725 1.367920 1.594984 0.107005 1.668759 1.377314 0.488228 1.137623 0.181686 -0.213385 1.767634 -0.269985 1.479847 0.320400 0.552651 0.518063 0.148500 0.270384 0.284453 0.340019 0.724815 0.965478 1.238256 0.867518 0.128521 0.865636 0.984628 -0.194290 0.705287 0.105815 1.739411 0.628255 1.950283 1.140789 0.009299 0.954978 1.321679 0.565201 0.902215 1.078996 1.623235 0.746957 -0.104004 0.469254 1.287040 0.942872 1.788593 0.928002 0.631896 1.065172 1.750427 0.915121 1.065384 0.650683 1.927883 0.360788 0.642006 1.318410 0.789311 0.558514 0.870027 1.639546 0.869476 0.226934 0.707660 -0.069226 0.191320 0.073570 0.196202 0.982067 0.248065 0.527334)
      )

;;; 122 all -------------------------------------------------------------------------------- ; 11.0454
#(122 14.800878258504 #(0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0)
      14.536 #(0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

      11.185266 #(0.000000 1.829696 0.019213 0.812736 1.158542 1.312114 -0.205640 0.380438 1.271260 1.458933 0.626310 1.309053 1.676297 0.167378 1.017949 0.989455 1.589425 1.514191 0.998704 1.423880 1.811097 0.854624 0.376900 1.598432 0.142466 1.280315 0.945690 0.551746 0.995865 1.650233 1.579291 0.606297 0.872652 0.287046 1.292231 0.822944 0.151578 0.381394 1.177090 0.470342 1.232176 0.351215 0.858499 1.571764 0.347510 1.071181 0.256361 1.474693 1.680240 -0.445105 0.567671 1.697184 -0.015883 1.190187 0.548542 0.887560 1.543331 1.880385 1.865690 0.869909 0.425986 -0.062177 1.296197 0.184510 0.444697 0.729908 0.916718 1.117436 1.374430 0.832407 1.349849 1.184262 1.717579 0.184128 1.013025 0.658082 0.431891 0.401342 1.412107 0.437119 1.126560 0.439793 0.095865 0.952763 1.722789 0.565588 1.212482 1.243749 1.625732 1.879096 1.463459 1.192866 1.117169 1.186799 1.105427 0.826581 -0.265285 0.335710 0.003989 0.359311 1.192710 1.836371 1.548892 1.442056 -0.250205 -0.751219 0.275449 0.184303 0.281086 1.735658 1.553852 0.618821 1.675259 0.868894 0.266289 -0.160750 1.626150 -0.484774 0.803695 -0.175707 1.102859 0.940662)
      )

;;; 123 all -------------------------------------------------------------------------------- ; 11.0905
#(123 15.175 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.041822824398 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.006 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.80501968131 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.67458183944 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      11.255107 #(0.000000 -0.037655 0.448883 0.789233 1.319818 0.005692 -0.149828 1.207597 0.712558 -0.355824 1.064979 0.136497 0.293518 0.207603 1.205174 1.816526 1.235509 1.209767 0.902291 1.877987 0.104526 0.218897 0.752276 1.268915 0.179725 -0.009489 1.262283 0.942491 0.786129 -0.387124 -0.120044 -0.229889 1.639323 1.041089 1.133744 0.266895 0.531197 1.887026 0.034924 0.589119 1.564512 1.364027 0.775012 -0.255218 1.537246 0.689690 0.895303 0.111225 -0.094698 1.102052 0.867503 1.122796 1.764357 0.005431 1.010895 0.646293 1.810318 0.117484 0.685563 0.339246 -0.062886 1.396307 1.383007 0.037368 1.547717 0.472433 0.077027 0.433642 0.520046 -0.145158 -0.060319 0.234572 1.119244 0.186687 -0.164261 1.762673 1.248953 1.523965 1.301753 1.081280 -0.012460 1.184370 1.820044 -0.045043 1.140720 0.153035 1.304436 0.401747 0.674145 -0.219824 1.756937 0.573231 0.204319 0.597422 0.197584 0.727924 1.787158 1.217823 0.396556 0.270743 1.050905 0.035678 1.044766 1.375741 1.280885 1.528275 0.746349 1.482168 0.874679 0.293462 1.029099 1.780593 0.864215 -0.168132 0.134705 0.856341 1.410623 1.117614 1.231768 1.407192 1.403969 -0.138063 -0.223379)
      )

;;; 124 all -------------------------------------------------------------------------------- ; 11.1355
#(124 15.808239936829 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      15.141 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      14.607 #(0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

      11.315853 #(0.000000 0.157339 1.717168 0.826720 1.019072 0.802473 0.468867 0.370550 1.579840 0.259667 0.176246 0.109817 0.054843 1.067503 1.075875 0.175495 0.444620 0.986131 1.479203 0.762306 0.203368 1.312370 0.183677 1.868931 0.984081 0.452189 1.372539 0.685862 1.436642 -0.579918 1.664641 0.747790 0.475493 0.386782 0.194231 1.369923 -0.343163 1.124550 1.100356 1.365540 0.524339 0.649561 0.410936 0.227784 0.714047 0.820935 0.526212 0.372587 1.427253 0.313532 1.453966 1.243676 0.941124 -0.144852 0.926753 1.747844 0.041044 0.183089 0.466059 0.713564 1.500331 0.849273 1.730209 1.311275 0.026721 0.178809 -0.201529 1.391341 0.008121 1.690506 0.759580 1.102019 -0.106094 0.826047 1.152807 0.539480 1.242705 0.358399 0.667632 -0.389834 1.443769 1.595530 1.316491 0.577146 1.315268 1.856790 -0.458504 -0.457329 0.623727 1.633793 1.714300 0.888713 1.101645 1.937736 0.505158 -0.233308 0.925295 0.485153 1.279018 1.527294 0.342685 0.735580 0.564654 1.225084 -0.157627 0.231800 0.145929 1.631693 0.495942 0.105911 -0.291031 0.974468 0.567311 0.282459 0.796426 1.418218 0.671441 0.753158 0.883837 1.205463 0.693335 1.239960 0.524797 0.548632)
      )

;;; 125 all -------------------------------------------------------------------------------- ; 11.1803
#(125 15.546414800183 #(0 0 0 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0)
      14.985 #(0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      11.420352 #(0.000000 1.199592 1.290707 1.486482 0.506978 0.021468 0.650471 0.293588 0.374684 1.092360 1.152957 0.050447 1.489460 0.985245 1.675162 0.956229 1.793109 1.595752 1.684060 0.539517 -0.652254 0.699376 -0.110672 0.889753 0.126441 1.753976 0.194648 1.702302 0.008897 -0.016843 0.389746 0.143448 0.189930 0.310330 0.047562 1.264052 -0.206601 1.438503 1.005154 1.685831 -0.148743 0.824557 0.010612 1.871249 1.741299 0.307006 0.325265 1.424075 0.969293 1.213102 1.542277 1.480431 1.605831 1.173792 0.786110 0.908626 0.027583 0.491596 1.166538 0.417870 -0.458450 0.143903 0.303113 0.064208 1.176182 0.783632 0.853278 0.526847 1.021178 1.274967 1.376727 0.778518 0.372244 1.394301 0.884311 0.003856 1.230298 1.422039 1.588466 0.463395 0.873535 1.094678 -0.043721 0.439165 -0.209719 1.156594 0.083532 1.388328 1.895887 1.023057 1.289266 1.830753 0.411128 0.479855 -0.547531 0.936661 0.847288 1.772796 0.279231 1.053738 1.093826 0.944025 0.074198 0.224206 0.453485 1.738309 -0.020668 1.175484 1.748459 0.720764 1.381752 0.519698 -0.141202 1.491217 0.989817 0.134561 0.557768 1.049790 1.241394 0.908287 1.553249 1.932765 1.303490 0.740673 0.800440)
      )

;;; 126 all -------------------------------------------------------------------------------- ; 11.2250
#(126 15.477880483871 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.898634217167 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.722991453869 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)
      14.67419786533 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.311282 #(0.000000 0.807783 0.314068 1.245640 0.816518 0.985544 1.697308 1.794955 1.896523 0.794408 -0.053318 1.758710 0.352820 0.761778 -0.214960 0.081716 0.944465 0.988008 1.233505 0.487699 1.498470 0.629898 0.773117 0.148649 0.537318 0.997188 0.799158 0.091763 -0.005723 0.024563 0.476460 1.734278 1.260407 1.095807 0.945211 0.922545 0.643602 0.465981 1.247392 1.046263 0.162092 0.691696 0.503144 1.135351 0.918905 0.730614 1.344530 1.127789 0.134882 1.211483 0.563406 0.304171 0.910673 0.139123 0.344415 1.499807 1.515192 1.193821 1.007174 0.604564 1.270157 1.046122 1.220894 0.667491 1.747035 1.236878 1.298399 1.423120 0.226372 0.450960 0.411551 0.557487 1.784232 0.076839 0.915405 0.099943 -0.080836 0.343468 0.849596 0.063454 0.508535 0.763261 0.228612 0.532288 1.382686 1.695523 0.446483 0.133803 1.201137 1.104488 -0.090571 1.779232 1.780339 0.261698 0.959162 1.555363 0.955114 1.667262 1.476692 -0.580889 0.301007 1.837531 0.449560 -0.214256 0.971832 1.107159 0.687844 0.088666 0.943917 0.243851 1.480674 0.269259 1.263523 -0.019614 0.714099 1.216548 0.021555 1.741076 0.719849 0.763679 1.028153 0.466827 -0.090363 0.104097 1.163451 0.814638)
      )

;;; 127 all -------------------------------------------------------------------------------- ; 11.2694
#(127 15.59486896452 #(0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0)
      14.859080656941 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0)
      14.851 #(0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      11.457936 #(0.000000 0.853237 1.232359 0.255318 1.201026 0.274096 1.740213 0.119358 1.334801 1.226706 0.004055 1.872732 1.516753 1.587398 1.081393 -0.355730 0.139160 1.532223 0.224275 1.677360 1.224952 1.568774 1.240374 0.486048 0.542055 0.187174 0.394113 -0.106267 0.124381 1.180866 0.158879 0.613316 0.074367 1.212290 0.233117 1.782739 0.777502 -0.105694 0.567312 1.164314 0.067357 0.692590 1.854104 1.402452 0.639727 0.749724 0.260594 1.788960 0.887315 1.326313 0.917455 0.165986 0.864267 1.790545 1.010700 1.750799 0.270480 0.505983 0.497477 1.347130 1.200755 1.199819 0.175577 0.229919 1.886410 0.948629 1.757151 -0.083413 -0.366919 0.805953 0.584350 1.390219 0.325378 0.573549 0.608007 0.466714 0.095984 0.011137 0.939287 -0.022555 0.165302 1.696704 1.682010 -0.050885 0.200252 0.358757 0.318105 0.943232 0.690443 1.083408 1.060737 1.327715 -0.130623 0.184266 0.735674 1.790990 1.680652 1.614877 1.286203 0.341164 -0.064309 1.521035 0.586395 -0.006112 1.374584 0.661567 1.651078 0.173970 0.507091 1.055672 1.823127 0.506737 0.875884 1.384750 1.405187 1.648362 0.664422 0.560251 -0.103622 0.064112 0.147238 1.606886 0.399651 1.383159 1.514052 0.363128 1.636473)
      )

;;; 128 all -------------------------------------------------------------------------------- ; 11.3137
#(128 15.689241428851 #(0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1)
      15.287684641887 #(0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1)
      15.249417304993 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1)
      15.138 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      11.573528 #(0.000000 1.358622 0.052815 1.525342 1.078254 1.277467 0.851644 0.993773 0.270527 0.666892 0.214715 0.561881 1.486305 0.897301 0.663907 1.464915 1.458940 0.073985 0.227716 0.240977 -0.118121 -0.240614 1.129165 0.562949 0.104761 1.512942 1.850497 -0.150893 1.132547 1.479629 0.454176 1.177070 1.243333 0.052388 0.587923 1.838013 0.100181 0.948655 0.323787 0.826841 0.229639 0.441532 1.219126 0.983808 0.782016 0.761902 0.566556 1.268485 0.018509 0.263246 -0.384569 1.394812 1.372861 0.446364 1.200217 1.335900 0.036123 0.561092 -0.095607 0.396696 0.119690 -0.125962 0.586149 0.613171 1.411972 1.000998 1.395219 1.079869 1.383076 0.460730 1.650881 -0.061949 1.452576 1.251142 0.849189 0.416834 1.306581 1.183581 0.090160 1.263584 1.323055 1.014591 0.198802 0.170910 0.985123 1.132470 0.684690 -0.159944 0.394404 0.148159 0.775584 0.814835 1.415542 1.113548 1.363351 0.271326 0.750728 0.663523 1.188110 0.784207 0.491110 0.586774 0.532456 0.358822 1.296022 0.846135 0.234995 1.116767 -0.154526 1.037932 0.290091 1.320389 0.871439 1.212979 1.564010 0.656220 1.789912 0.666737 1.027019 0.134831 0.399150 0.881457 1.220367 1.794516 -0.015901 1.390136 0.114371 1.152434)
      )

;;; 256 all --------------------------------------------------------------------------------
#(256 23.353 #(0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

      19.419887 #(0.000000 1.716123 1.732087 -1.159217 -1.111520 -0.968808 -1.435400 -0.980823 -1.916807 -0.777076 -0.006575 -1.146768 -1.413466 -0.191988 -0.866295 -1.754753 -1.834771 -1.414461 -0.004612 -0.668272 -0.899105 -1.045292 -1.394965 0.031304 -1.790029 -0.414595 -0.628926 -0.793341 -0.055059 -1.758819 -1.799745 -0.999573 0.034849 -0.438143 -0.082246 -1.718822 -1.067223 -1.726228 -1.738785 -0.419090 -0.072253 -0.101418 -0.158940 -0.227475 -0.805306 0.102396 -1.029779 -0.944501 -1.627544 -0.240643 -0.800061 -1.852822 -0.736694 -0.374906 -0.992797 -1.321129 -1.165724 -0.132383 -0.296684 0.074652 -0.170663 -1.021946 -0.249235 -0.014896 -1.684156 -0.101483 -1.472567 -1.065248 -0.193000 -1.821851 -1.577478 -0.971415 -1.706313 -0.460547 -0.802154 -1.066096 -0.465880 -1.780964 -0.317180 -1.128696 -1.243327 -1.545720 -0.981842 -1.941220 -1.430454 -0.739300 -0.401708 -0.807818 -0.139664 -1.670340 -0.370514 -0.908540 -1.051026 -0.655448 -0.201175 -1.447197 -1.020563 -0.461820 -0.563775 -0.492581 -1.123348 -0.019694 -0.284015 -0.493247 -1.800533 -0.026879 -1.684265 -0.072889 -1.236206 -1.605481 -0.854278 -0.780460 -1.556451 -0.100281 -1.481863 -1.785235 -0.054386 -1.322733 -1.272196 -0.484418 -0.487202 -0.934744 -0.351935 0.001840 -1.361830 -1.761915 -0.791484 -1.765946 -0.130275 -0.078233 -1.712033 -1.491273 -1.447810 -1.802668 -1.915196 -0.812291 0.020535 -0.059922 -0.115027 -1.741334 -1.716313 -0.574287 -1.796141 -1.411787 -0.352083 -0.219272 -0.492707 -1.281724 -0.237492 -0.661764 -0.251830 -1.447982 -0.928988 -0.834556 -1.105051 -1.600594 -0.610828 -0.521753 -1.538844 -1.739439 -0.438630 0.200255 -1.495825 -0.208613 -1.899242 -0.565203 -0.701498 -0.013982 -0.268393 -0.851043 -1.316608 -1.311782 -1.571398 -0.868046 -0.450718 -1.523921 -1.175122 -1.013090 -0.336313 -0.297343 -0.710311 -0.121169 -0.855768 -0.583293 -1.278840 -1.685639 -0.237176 -1.113655 -0.038017 -0.925030 -0.002618 -1.084014 -0.914850 -1.109784 -1.951680 -0.258074 -1.242904 -1.747165 -1.546773 -0.010135 -0.293716 -0.365165 -0.380179 -1.009365 -0.199175 -0.107143 -0.355342 0.056494 -1.740548 -0.797850 -1.195468 -1.012191 -0.519448 -1.741712 -1.728278 -1.202843 -0.439103 0.018019 -0.505945 -0.712019 -0.888461 -0.466715 -1.884487 -1.110926 -1.377129 -1.412918 -0.283507 -1.736733 -0.423668 -1.180448 -0.750304 -0.826461 -0.252142 -0.607448 -0.795197 -1.729275 -1.937314 -1.775060 0.018302 -1.136763 0.041039 -1.517119 -0.102466 -0.808497 -0.452532 -1.777418 -1.448279 -0.170123 -0.689274 -1.668514 -0.718568 -1.461386 -0.741628 -0.144206 -0.275574 0.275344)
      )

;;; 512 all --------------------------------------------------------------------------------
#(512 34.212551772691 #(0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      31.391244 #(0.000000 0.536490 0.982156 1.426326 -0.129626 1.732808 0.654778 -0.037467 0.717993 0.534761 1.425863 1.198865 1.682980 1.546213 -0.071047 1.401448 0.937782 0.982596 0.016895 0.072103 0.569596 0.486124 -0.097286 1.158349 0.918371 1.039216 -0.251432 0.819547 0.575793 0.544080 0.369375 -0.184848 0.368901 0.803569 1.569591 0.698176 0.192969 0.724313 0.149571 1.805778 1.481586 1.290110 0.699094 1.248324 0.394364 0.244421 1.636448 0.053830 1.021639 0.391890 0.621807 0.669918 0.722984 1.661047 -0.053982 1.184501 1.452118 -0.038748 0.079581 -0.157031 0.040992 1.236847 1.450072 0.167693 1.624681 -0.088284 1.086971 0.793397 0.916304 0.324493 0.532068 0.802293 0.153202 1.762480 0.101252 1.207328 -0.129231 0.230528 1.030310 1.154258 1.508591 0.616033 0.882311 1.661175 1.953694 1.099650 0.966354 0.501383 1.007682 0.222557 1.610959 1.720178 1.247885 0.606186 0.834708 1.558361 -0.017869 1.310156 1.008083 0.659261 0.131563 1.937703 0.412195 0.236592 1.603060 1.101767 0.827617 0.591143 0.816380 1.263921 0.148742 0.104597 0.053092 1.950756 0.641813 0.585000 1.924936 1.150271 1.393796 1.729921 0.941614 1.154412 0.016709 0.693894 0.725621 1.812021 0.151548 0.913871 1.847999 1.447775 0.154900 1.383798 1.268622 1.684293 0.167755 0.064703 1.097955 1.093726 0.462700 1.179880 -0.028079 1.477485 1.219357 0.751030 -0.060337 1.210332 0.214512 -0.561537 0.631221 0.866225 0.505200 1.649399 0.763462 -0.177460 -0.124321 0.301932 1.215601 1.531126 1.037628 1.084693 0.882199 1.071766 -0.102511 1.933157 0.994409 1.327775 0.857160 0.274823 0.564669 -0.099448 1.183881 1.389926 0.212160 0.718775 0.317581 0.924967 0.405513 1.649930 1.527277 0.183790 1.201712 0.469506 -0.155659 0.854295 0.612216 0.966494 0.705453 0.102052 0.675180 1.609733 0.239829 1.243022 1.279694 0.667433 0.574003 0.556613 0.553333 0.600770 0.751871 0.860635 1.492204 1.208264 1.697379 1.870484 0.648885 0.791931 0.713354 1.230332 0.984751 0.006536 1.150837 1.690631 -0.027051 0.380760 1.276448 0.938348 0.619960 1.881157 0.864399 0.721671 0.604021 0.280855 1.903049 1.689084 0.993376 0.147486 0.728308 1.043826 -0.093977 0.201345 0.211713 0.591694 1.563665 0.629162 0.028541 1.220537 0.848678 1.673148 1.269501 1.423564 1.256969 0.563220 1.571156 1.255956 0.182322 0.799277 0.912648 0.801445 0.560308 0.589828 0.497125 0.933069 0.424475 0.705311 1.598444 -0.187983 0.441238 0.761108 -0.025473 1.486361 1.415485 -0.420955 -0.301161 0.451074 1.599095 0.958690 0.764750 1.826910 0.763259 1.565082 0.482133 0.634148 0.689109 0.870842 0.258187 1.307766 -0.061122 1.322321 0.737932 1.331468 0.501857 1.012652 0.853045 1.281963 0.626236 1.018208 0.355320 1.778787 -0.216416 0.289103 1.466104 0.834557 1.495024 1.347843 0.915718 0.019062 0.109237 0.935987 0.642501 1.116001 0.102778 1.044616 0.401839 0.000557 1.388259 1.103344 0.236147 1.095986 1.490085 0.811184 1.620642 0.447193 -0.162667 0.472053 0.254521 -0.249527 1.201426 0.405149 1.876543 0.266187 0.130139 1.907565 0.661173 1.806986 1.714549 -0.045649 0.161300 1.867579 0.410807 0.692661 0.164446 1.373170 0.784111 1.624643 1.842397 0.851982 0.372586 -0.153180 0.163399 0.937623 1.029810 0.577761 1.885373 0.257007 1.919724 0.221390 0.992752 0.799199 0.726916 0.499383 0.847904 1.435092 1.516436 1.415791 0.718336 0.775042 0.214479 0.693437 1.416323 0.376686 -0.088726 1.305444 0.236013 1.760923 0.882461 0.966026 -0.039945 1.586889 0.146351 1.058484 -0.153465 0.874027 1.562558 0.221053 0.700956 0.490493 0.224584 0.721736 0.907632 1.824769 1.463914 1.787340 0.284520 0.447051 0.015084 0.421417 0.946031 1.985021 0.625260 1.706503 0.181495 0.118414 1.205197 1.823047 1.191165 1.046795 1.286118 -0.026177 0.916951 1.695990 1.490318 1.309732 1.464060 1.688925 0.463066 0.812221 1.691121 0.060699 1.771571 0.651609 0.701067 0.994197 1.863648 1.878055 0.461586 1.225301 1.689333 0.585832 0.163978 -0.087727 0.814512 1.996254 0.412873 -0.094955 0.264337 0.270751 1.142549 -0.024966 0.070370 0.161447 0.009507 0.773710 1.826772 0.919015 0.469842 1.605350 0.130163 0.372875 0.706787 0.275237 -0.485192 0.934255 0.076963 1.578025 1.319281 -0.268275 1.006626 1.518212 0.244270 0.393465 0.362653 0.762951 0.101773 0.641925 -0.044830 -0.086144 0.912315 0.865131 0.751696 0.355646 1.669420 0.959146 1.402229 0.790946 1.375834 1.946560 0.829893 1.038967 0.415598 0.605293 0.953370 1.545858 0.816660 0.535574 0.545621 1.444071 1.427861 0.317581 1.324961 0.709073 0.233889 1.997939 0.837353 0.714659 0.502688 1.282277 0.578831 -0.367027 0.456635 0.005356 0.566115 1.015260 0.456787 1.559690 0.821948 0.873735 -0.125757 1.347975 1.234391 0.394165 1.313322 1.674955 1.957471 0.199796 -0.216128 1.145281 0.020796 -0.033417 1.546313 0.684777 0.721518 1.014713)
      )

;;; 1024 all --------------------------------------------------------------------------------
#(1024 54.490282136658 #(0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       49.867216 #(0.000000 0.327463 1.836047 0.835169 1.252076 1.674070 0.220548 1.042475 1.509095 1.579464 0.895304 1.247426 1.151972 1.490500 0.157542 1.123668 0.047756 0.787232 0.294584 1.733356 0.107736 1.156565 0.757337 0.396950 1.528176 1.246645 0.358019 1.104207 0.205112 -0.175155 1.961979 0.116865 1.705056 1.224069 1.280180 1.615850 -0.006555 1.362186 1.094292 -0.132951 0.689557 -0.034245 1.478824 0.731044 0.924965 0.400017 0.459628 0.386074 -0.101383 1.148365 0.704241 0.744738 -0.052844 0.067315 0.369521 0.758466 1.902583 1.899586 1.598319 1.737623 1.540374 1.696560 1.697499 0.487205 1.085963 1.880631 1.477181 1.668863 0.024424 1.517648 0.365516 0.200991 1.320714 0.186157 0.388617 1.467282 1.382441 0.897334 0.626981 0.319121 1.447908 0.616025 1.804381 1.745575 1.813291 0.789135 0.051659 1.904341 0.503423 1.476255 0.310011 0.604315 1.774089 1.349431 0.552058 0.129885 0.768054 -0.042991 0.438904 1.716492 1.079908 0.082240 1.637563 1.782814 1.167399 1.555367 1.493576 1.678716 -0.108181 1.820002 0.874064 1.607670 0.305117 1.407464 1.406799 0.699493 1.582569 1.388350 0.152096 1.215999 0.220403 0.345901 0.015759 0.103791 1.475118 1.377921 1.679643 0.718421 0.305952 1.129388 0.650190 1.214505 0.313791 1.900895 -0.280859 0.827104 0.966094 0.952334 0.465933 0.582045 1.202693 0.486327 0.130731 1.189722 1.845737 0.943304 1.846468 0.736959 0.494820 0.406920 0.444435 1.414861 1.519794 0.691958 1.296671 0.239996 1.370349 1.087196 0.317189 1.730290 0.211314 0.381111 1.011776 0.833783 0.304407 0.204684 0.592149 1.184369 1.190663 0.322231 1.702889 0.256307 1.071017 0.840867 -0.242520 0.479950 0.584840 -0.105808 1.448894 0.833770 1.887925 0.447183 0.314914 0.590005 0.817397 1.520556 1.737874 0.323699 0.068906 0.069837 1.455903 1.768167 1.147201 1.651376 0.903538 0.404965 0.830838 1.574402 1.302241 0.460573 0.902816 1.351294 1.845320 -0.081248 0.117244 1.311180 1.295830 0.026240 1.722593 0.293615 0.016937 -0.020631 1.563094 0.366968 0.499012 0.343554 0.941646 1.842772 0.263412 0.928044 0.666097 0.965699 0.095392 0.386295 0.685342 1.098466 0.314857 0.096187 1.378947 1.725601 1.638174 1.066852 0.324141 0.309496 0.903826 1.884009 0.246373 1.446212 0.826576 0.056908 0.590948 1.115228 0.881198 1.458300 0.734711 1.242163 1.780534 0.853455 1.667872 0.196825 1.537188 1.607676 1.937251 1.074072 1.633616 0.370489 0.008710 0.036175 1.429420 1.071794 1.840602 1.451692 1.243956 1.431107 0.691835 0.914980 1.199410 0.181293 1.253487 1.088758 1.075474 0.108051 -0.045571 0.503001 0.028741 1.519924 0.162181 0.231314 1.014758 0.853208 1.665684 1.803304 1.068408 1.146822 1.117985 0.847058 0.807390 1.300311 0.358831 -0.176058 1.632353 0.793462 1.223895 1.408096 0.574718 1.116086 1.528188 1.863540 0.148438 1.178815 1.094527 1.806614 -0.012374 0.398182 0.065034 0.201600 1.678653 1.635712 1.101239 1.677879 1.376663 0.893127 0.765563 1.312772 0.394500 0.623281 1.386574 1.609733 1.397744 0.447440 0.193906 0.667070 1.098978 1.496626 1.415310 0.148141 0.472594 0.260368 0.383833 1.628233 0.220327 0.047597 1.174267 1.122635 0.357754 1.987414 0.602071 0.303888 1.036218 0.431162 1.929514 1.164116 1.448233 0.387663 1.542441 0.132675 1.507592 0.773415 1.237768 1.176487 0.709116 1.107050 1.826342 1.282624 0.165318 1.688758 1.353368 1.369182 0.103481 0.492312 0.148528 0.820568 0.043996 1.646622 0.840124 0.753421 0.628590 0.827439 0.938395 1.158874 1.692810 0.816126 1.584484 0.133035 0.633441 1.856698 0.223451 1.094007 1.265750 1.192640 0.395952 1.640962 1.917364 1.688116 1.442386 0.211922 0.568924 0.069021 0.337714 0.057686 1.444757 0.805875 1.387495 1.241537 1.258564 -0.138313 0.232318 1.082810 0.919288 0.672564 0.858948 1.226057 0.513353 0.916746 0.480683 0.371996 1.820855 1.467856 -0.009218 -0.283047 -0.004140 0.307827 1.551706 1.336385 0.311540 -0.227376 1.460075 1.374821 1.644972 0.942584 -0.008731 1.230541 -0.050886 0.756145 1.492824 0.234443 1.038831 0.415396 0.259582 0.094433 1.743809 1.773181 1.193767 1.144637 1.107278 1.073467 0.192765 1.121611 1.358143 0.256730 -0.001826 0.319586 0.785692 0.371007 0.790865 0.733080 1.010016 0.365066 -0.098482 0.630804 0.165791 1.416869 0.881841 1.014309 0.992919 0.234901 1.418323 1.609100 1.112565 1.226695 1.306198 -0.096032 1.659930 1.253925 1.468504 1.649207 0.667054 0.642219 0.816619 1.780578 1.068621 1.659145 0.823854 0.791623 0.343295 1.504822 1.385473 1.019994 1.644651 0.766151 1.645632 0.537825 0.398247 1.293204 0.059160 0.178873 1.447287 0.527125 0.387974 0.131115 0.312785 1.604447 1.506949 1.620066 1.861402 0.145250 0.285949 -0.076877 1.710147 1.391166 0.304424 1.033493 1.242586 0.544670 1.096730 0.523155 -0.189246 1.481005 1.033398 0.768935 0.023972 1.612024 1.483055 0.518798 0.299824 0.004960 0.939759 0.174131 0.190042 1.122756 0.636602 1.584671 0.313933 1.551720 0.904685 -0.060326 0.005540 -0.025426 1.183830 1.574816 0.451159 0.567990 0.636937 1.946081 0.103934 1.024172 0.668272 0.598832 0.942076 0.803712 0.025316 0.279283 0.860683 1.108376 0.495592 -0.216459 0.511102 0.839492 0.325629 0.423941 0.964281 1.869174 1.376322 0.695771 0.307933 0.728584 0.258248 1.021908 0.522105 1.443610 0.699209 1.445438 0.129220 0.656902 0.367233 1.583887 1.284330 0.304291 1.225496 0.476577 -0.012778 1.769867 1.304421 1.416331 1.394685 1.657958 0.575537 1.154454 1.482178 0.502570 1.130768 0.623558 1.451860 1.828731 1.028878 -0.009475 0.876872 0.279098 0.766784 1.311330 0.735794 0.541035 1.842543 0.936643 1.574537 1.396428 1.299258 0.148915 0.106232 1.382409 0.363703 1.437792 0.458828 0.697511 0.377860 0.415873 0.707742 0.076333 0.899058 1.164566 0.519739 1.494067 0.722474 0.267706 0.170213 0.062507 1.608638 1.572808 0.586666 0.770343 0.501734 1.095273 0.909347 1.158611 1.763224 0.928306 1.155477 -0.094050 1.234292 1.636569 0.857401 1.601954 1.562867 0.898006 0.745695 1.244420 1.045502 0.037133 1.054100 0.435628 -0.045614 1.310834 1.323179 1.515436 0.396760 1.549668 0.626053 0.262609 1.128936 -0.206617 0.519603 -0.070276 0.368711 0.384606 -0.046953 0.004776 1.132741 0.208440 1.125384 0.279383 0.206414 1.581812 0.366788 1.631341 0.047828 0.984452 0.695910 0.001831 0.818618 -0.063551 1.509031 1.770858 1.145267 0.218736 0.163266 0.304181 0.524463 -0.107417 0.636073 0.319627 0.873046 1.806848 0.905657 1.431126 1.307693 0.411432 1.050612 0.383394 0.297520 1.470377 1.512342 1.119568 -0.164563 1.409877 1.369612 0.893616 0.187194 1.160112 -0.426584 1.472282 1.524100 0.642913 0.291994 1.439671 0.405710 0.699882 0.685768 1.837220 -0.135020 0.618382 1.538502 1.936925 1.869902 1.304847 1.204678 1.245764 0.849343 0.077370 1.376208 0.128986 0.683191 1.168443 0.773303 0.918277 0.361282 1.325992 0.182420 0.557109 0.856130 0.916468 1.073525 -0.056735 0.457839 1.415303 1.493321 0.837421 1.245510 0.324402 1.072023 1.495966 0.779674 1.792871 0.438686 1.400304 -0.029656 0.771387 1.191604 0.497478 0.949389 0.583656 1.568371 0.818618 0.376624 1.922430 1.597926 1.106025 1.349123 1.097987 1.226814 0.449548 0.978715 1.149809 0.090419 1.181951 0.196841 0.169854 1.157525 0.672195 -0.013396 1.381930 0.763467 1.101984 1.081354 1.745447 0.052582 0.434851 0.710038 0.252432 1.547955 1.291922 0.243233 0.084185 1.718412 0.754270 1.712834 -0.113817 -0.185231 0.645607 0.602242 0.698745 1.484932 0.708616 0.806637 1.321352 0.822224 0.486883 0.890968 0.415997 0.868384 0.439809 0.369575 0.155202 0.890177 0.736148 1.282829 0.496635 0.179507 0.581791 0.861737 1.329786 0.952408 1.311372 0.616676 1.793129 0.198151 0.583196 0.014657 0.736984 0.943676 1.304757 0.104216 1.131163 0.886646 1.431121 0.607723 1.834661 0.350032 1.233992 0.553257 1.415608 1.339899 -0.021117 1.320488 0.646222 1.478825 0.253185 1.344375 0.782507 0.242220 1.348393 1.611945 1.891346 0.403449 0.420262 1.560522 0.492852 1.786347 0.954743 0.927910 1.007730 0.966809 1.183914 0.132915 0.235582 1.182222 0.510621 0.119231 1.400333 1.559546 0.434169 0.106340 1.159731 1.145452 1.403938 0.593410 0.423464 1.214964 0.097415 0.659427 1.330465 0.265373 0.978681 -0.241303 1.410817 0.374681 0.982607 0.620477 1.028389 1.023993 0.703520 1.277773 0.757705 1.040223 0.694910 0.158208 1.192658 1.103184 1.154745 0.138529 0.659537 1.567368 0.955008 -0.008595 1.044148 0.615600 0.596413 1.600428 -0.130936 0.209722 0.597264 0.214794 0.424799 0.791647 0.212593 1.490120 0.029575 0.222065 1.056546 0.514551 1.117830 0.080900 0.698795 0.825148 0.128150 -1.946314 1.296496 1.764967 -0.109275 0.619906 1.046853 -0.050885 1.414055 0.243491 0.805047 0.478126 0.210018 0.383272 1.147815 -0.142393 0.254600 0.974724 1.253165 0.759822 0.390277 1.900341 0.600527 0.913172 1.508819 0.838474 0.842307 0.052699 0.015556 0.443439 0.953984 0.747720 -0.054054 0.972040 -0.241904 1.438074 0.685282 0.673901 0.604914 0.601935 0.592279 0.658902 1.125537 0.853760 1.677094 1.268821 0.909583 0.771236 0.955089 1.189800 0.847715 0.318412 1.928436 1.740119 0.412900 1.589818 1.013917 1.215481 -0.014813 1.247880 0.223321 0.897915 0.951870 0.304753 1.763894 1.166419 1.525081 1.491253 1.646299 0.047929 0.453022 0.624295 -0.345040 0.250292 1.322349 1.263984 0.481892 1.819190 1.498516 0.274084 0.915689 1.490261 0.159303 1.347132 1.407289 -0.117297 1.828899 1.616281 0.092870 0.390260 -0.086407 1.668212 0.707778 -0.125709 -0.068702 -0.008020 1.483304 1.668166 0.205490 0.775194 1.173496 1.068329 -0.181766 1.426966 1.728307 1.644513 0.798234 0.762223 -0.195164 0.527024 1.036420)
       )

;;; 2048 all --------------------------------------------------------------------------------
#(2048 89.570060996356 #(0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       77.350213 #(0.000000 0.555539 0.501262 1.044749 0.287771 1.412682 1.651595 0.929560 0.549846 1.324740 1.935869 1.135478 1.476903 0.201893 1.072368 1.469797 1.856304 1.710124 0.155645 1.734478 1.438672 1.662318 0.369149 1.305539 1.380565 0.760274 1.791213 0.758033 1.460302 0.314773 1.273350 1.445081 1.922068 1.981608 0.787530 0.220848 0.749937 0.852506 1.079197 1.596357 0.533643 1.661423 1.309207 0.570204 0.799186 0.806331 0.147029 1.886462 -0.011055 1.620080 0.764653 1.039822 1.399443 0.540383 1.263941 1.520079 0.955253 1.475051 0.569591 1.021593 1.696488 1.384568 0.888621 1.246065 0.141108 1.760633 0.530062 0.078663 -0.052280 1.231263 1.886752 1.022966 0.731660 1.519866 0.815188 1.842595 0.428998 0.982542 0.268300 0.449940 0.825066 0.093779 1.541877 1.530942 -0.044025 1.404789 1.172967 1.495494 0.986869 1.354411 0.977699 1.323218 0.290527 0.642299 1.141685 0.305403 0.116047 1.498648 0.363158 1.133291 1.021968 1.050915 0.004007 0.316776 -0.008246 1.753451 1.448398 0.727763 0.491974 0.467132 0.349093 0.846144 -0.057302 0.451593 -0.185527 0.954499 -0.017687 1.738336 1.132264 1.277860 1.255149 0.644067 1.787009 0.975542 0.787661 1.834522 0.750059 0.165831 1.781394 0.656243 0.189155 0.885417 1.864367 1.861898 0.835353 1.925872 0.784282 0.149366 0.389909 1.891355 0.667211 1.629093 -0.156731 0.686377 -0.046381 1.379719 0.174257 1.815414 1.782186 1.460458 1.225364 0.215276 0.433813 0.778669 0.770455 0.591200 1.467950 1.402450 1.237374 1.213320 1.107618 1.577857 0.153528 1.496479 1.690453 0.757018 1.164466 1.863222 1.556344 0.411893 0.045128 -0.148474 0.690145 1.255681 1.262642 1.053606 0.652441 1.807011 1.212250 1.298870 1.843582 0.679071 1.071529 1.212117 0.457856 0.037265 0.056807 0.289533 1.340623 0.191271 0.023689 0.079151 1.691347 0.427278 0.798824 0.971986 0.219384 1.510317 1.755539 0.020056 -0.108987 1.920829 0.654279 1.269937 0.625973 1.626210 1.557939 0.060795 1.054050 0.688441 1.815486 1.547017 1.227524 0.184287 0.725676 1.529612 0.145770 1.961037 0.740800 1.404065 0.938756 0.807687 1.820918 0.792546 -0.054241 0.457527 1.314210 1.386331 1.330133 1.364743 0.425434 0.805132 0.601427 1.151039 0.181880 0.588421 1.746772 0.525817 -0.062391 0.174995 -0.229241 1.865325 0.777080 0.576100 1.157737 1.173633 1.108300 0.620180 0.679835 1.829428 1.415691 1.510131 0.278064 0.869124 1.774022 1.810644 -0.249575 -0.122332 0.003232 1.632364 1.298768 0.233819 0.326577 0.745415 0.803076 1.768981 0.251203 0.915819 1.691281 0.742817 0.546973 0.218234 1.629248 1.253580 1.354290 0.528862 1.813762 0.263825 0.781654 1.287354 0.093701 0.698575 0.887912 1.137370 1.529613 1.518332 0.469199 1.225525 0.065649 0.280063 0.033222 0.909971 0.563943 1.914227 -0.065120 1.804400 0.103014 0.719986 1.951068 0.757568 0.217891 0.598460 1.177422 0.353950 1.684496 1.079766 1.303468 0.083664 -0.101540 0.424187 1.703711 0.337732 0.080405 0.592311 1.778334 1.635999 0.889894 1.617811 -0.035024 0.001647 0.924071 0.404662 1.353001 0.748591 1.771296 1.263408 -0.089484 0.221854 0.796659 -0.134496 0.228028 -0.006122 0.001128 1.259921 0.408335 1.472770 1.057188 1.208943 0.859616 0.951961 0.715820 0.286498 1.182115 0.918625 1.616017 1.001494 1.156487 0.467273 0.762620 1.416134 1.041549 1.777524 1.975901 1.424345 1.013724 1.528658 0.546749 1.515054 0.722119 1.165674 -0.188903 1.095713 0.017814 1.713209 0.808498 0.510307 0.811778 0.118225 0.831248 -0.024877 0.111979 0.001521 0.995340 -0.029678 0.290675 0.273513 0.805748 0.398880 0.215141 1.450122 1.736611 1.571552 1.456815 1.117397 1.312031 1.124964 0.952301 0.371672 1.874636 1.681841 0.351506 1.462640 0.011383 0.220945 0.998689 1.953549 -0.140064 0.559134 1.277572 1.812283 0.159287 1.701742 0.028876 0.066961 1.832832 1.596575 1.021889 0.172947 -0.123165 1.617572 0.738832 0.135822 0.899103 0.675147 0.590566 1.141705 0.619940 1.835079 1.810902 0.002593 0.085103 0.459750 1.324431 0.679980 1.499886 1.342828 0.113834 0.419635 0.474996 1.341851 0.784830 0.644960 1.049676 0.463071 -0.083825 0.357307 1.521176 1.668760 1.414541 0.331217 0.933878 0.750349 -0.094259 1.512555 0.057719 1.957253 1.855659 0.525060 0.191371 0.086135 0.778769 1.177665 1.138710 0.469141 0.550747 1.927353 0.597089 0.788555 -0.049972 0.972408 0.774953 0.590333 0.590142 1.188901 0.464196 0.937929 0.701475 1.283776 1.839285 0.195083 1.905586 1.378602 0.369590 0.773647 1.495702 1.010798 1.832039 1.743886 1.062461 1.551722 0.161056 0.247843 0.963386 -0.138497 0.113261 1.624467 1.660928 0.708473 1.847610 1.082010 1.479425 0.325611 0.661837 0.996064 1.316217 0.550535 0.354734 1.792945 0.587728 0.521299 1.867430 0.374452 1.069128 1.359185 1.163695 0.951998 1.554486 0.652597 0.335947 -0.007622 0.361202 1.522520 0.972243 1.090924 1.066404 1.473604 0.640795 1.326138 1.634896 0.633935 0.819042 0.374617 0.068108 0.899846 0.802853 1.002802 0.759373 0.912908 1.407252 1.871269 1.750381 1.651341 0.745903 0.461669 0.010571 1.287847 0.966184 0.583195 0.846835 0.694802 0.418880 1.389707 0.135708 0.155010 1.328469 0.737490 1.774328 0.368667 1.177429 1.152407 0.410099 1.383384 1.321282 1.568075 1.554693 1.238949 1.708897 0.117567 1.335460 1.803251 1.767886 0.012287 0.229862 0.355011 1.249238 1.512803 0.578011 1.451312 1.246621 -0.119738 1.826298 1.173428 0.117885 1.168928 0.345406 1.476069 -0.166920 1.034463 0.382725 0.245749 0.326820 0.118853 -0.057706 0.849665 0.007921 0.613571 0.734308 1.134450 0.749676 1.890959 0.378518 1.752809 1.108432 1.225504 0.442657 0.756270 1.860343 0.369036 1.527507 0.444954 0.930412 1.102519 1.878509 0.479922 1.150077 1.602579 0.058713 0.962265 0.328221 1.661628 0.457747 0.271408 1.870263 1.306306 0.335093 0.169626 0.654033 1.444649 0.614644 1.787700 0.114577 0.749670 0.270604 1.159625 0.989586 0.567069 1.072818 1.888945 -0.085294 0.121997 0.763024 0.984919 0.155703 -0.016260 0.191743 0.212740 0.115788 0.830523 1.683788 0.348500 0.124881 0.670456 0.678523 1.096574 0.897665 1.161154 0.986261 0.052581 0.418547 1.926610 1.527221 0.733566 1.720164 0.588071 0.718754 0.656306 1.222241 0.299541 1.655932 1.738610 0.208473 1.377056 1.640789 0.933028 0.500950 0.266025 0.202787 1.158416 1.726212 1.606686 0.645745 1.477768 1.448364 1.953745 0.028736 0.535783 0.762769 0.101338 1.101876 0.758538 0.004060 1.805216 1.598025 1.230557 0.047096 1.594085 0.215135 0.853051 1.296541 1.417117 0.235968 0.643987 1.405340 1.661579 0.911175 0.443065 1.589884 0.446420 1.073318 0.341514 0.657629 1.701362 1.726879 1.038635 1.625078 0.744561 0.038576 0.786606 0.041993 1.298454 0.218073 0.832914 0.079816 1.047928 0.782023 1.638485 1.342287 1.936893 0.724752 -0.015138 0.922139 1.148652 1.670824 0.337136 0.637705 1.001048 -0.228216 1.495036 0.605922 1.410177 1.011580 0.373865 -0.050306 -0.030282 1.482241 1.182296 0.616043 1.884674 1.514223 0.449114 1.217143 1.156828 0.699730 0.102999 0.250137 -0.031123 1.355748 1.655393 1.161987 1.872025 1.869860 1.112928 1.115924 0.563079 0.100168 1.165211 0.614544 1.264233 1.208279 0.960027 1.628427 1.610521 0.459497 0.403669 1.211322 0.657728 0.590534 1.175789 1.353568 1.427489 1.516217 1.243310 0.036331 1.415204 1.335414 0.312401 0.846162 1.692827 0.881253 1.673563 1.476773 0.491668 0.078271 1.772063 0.429881 0.829599 1.510362 1.324221 0.970839 1.031818 1.605683 0.417137 0.539905 1.124071 1.428885 0.758991 1.336089 0.469378 0.968420 1.462076 0.079466 1.439924 1.447561 1.037226 0.032416 -0.028897 0.368902 0.151743 1.133019 1.512185 1.860937 1.628533 0.118447 1.427979 0.445947 0.232361 0.041062 1.774814 -0.000513 0.970153 0.175939 -0.114292 0.214713 0.557618 0.732536 1.302739 0.889277 1.136665 1.083674 0.654661 1.702739 0.901405 1.509089 0.547946 0.795351 1.387886 0.101319 1.071538 0.300259 1.362963 1.449746 1.621519 0.648860 1.238117 0.385683 0.777458 1.582777 0.090560 1.423196 0.518231 0.129612 0.369422 1.062708 1.137679 1.093619 0.410051 -0.028865 0.764992 0.842311 0.311702 1.830111 0.825103 0.859872 1.362654 0.443486 0.796728 0.015052 1.894804 0.178369 1.350106 1.080421 0.074839 1.798439 1.439047 0.543832 1.787518 1.095677 1.399291 1.218684 1.329215 0.024198 1.277854 1.781214 1.897330 0.663755 0.933197 1.460518 0.015174 0.890021 0.299191 0.591948 0.637994 0.192189 1.518365 0.789317 0.221733 1.393516 1.452171 1.164045 1.425340 1.211899 0.133999 1.809860 1.760137 0.786782 0.058488 1.033658 1.696528 0.115067 1.775639 1.843275 1.658795 1.102731 0.033810 1.518485 0.287243 0.872813 1.110274 1.284147 1.409632 0.002816 1.287616 1.920460 1.545101 0.357241 0.586921 0.250178 0.941329 0.683970 1.816670 1.249502 0.715161 1.288352 1.693684 -0.049681 0.500555 0.738239 0.766636 1.371281 0.427733 1.686588 1.002051 0.758627 0.719945 0.772296 0.797069 1.369126 1.077561 0.114153 1.255930 1.134835 0.290465 1.528414 1.156214 1.255893 0.569904 0.306550 1.578306 -0.027271 0.175993 0.505511 1.123829 1.257104 0.836799 0.957553 0.983670 0.264465 1.266100 0.704111 0.184087 1.468253 0.982413 -0.018410 0.765235 0.844886 0.194386 0.957304 0.466408 0.358006 1.273348 0.958858 0.192485 1.537449 0.762105 1.953919 0.360697 1.896891 0.771484 1.562116 0.477611 0.862940 1.057378 1.667997 0.072578 0.987503 0.634043 1.564453 1.444159 1.122332 0.573990 -0.026527 0.262861 0.694100 1.056833 0.776423 1.948071 1.715568 1.887729 0.174970 -0.171751 1.467195 1.339357 1.881230 0.084291 1.864481 1.857912 0.659248 0.423773 -0.012834 1.278787 1.236726 0.247062 0.279965 1.858545 1.197597 0.522526 0.880799 0.648553 0.790672 1.467274 -0.136872 0.250201 0.665615 0.060502 0.639605 0.387814 0.576618 0.316508 1.567811 0.098866 0.141794 1.102771 0.799866 0.345332 1.009816 0.888907 1.440320 1.300171 1.855403 0.546924 0.083787 1.421153 1.562621 0.072527 0.037440 0.573282 1.293324 1.351032 1.399589 0.771864 1.155326 0.219484 0.989074 0.912196 1.752766 1.745645 1.137247 0.591051 0.105617 0.254271 0.434891 -0.094733 0.689956 1.337531 0.526193 0.871788 1.523712 1.319939 -0.014173 0.862280 0.823385 0.054355 0.629683 0.514687 1.439869 0.563628 0.106880 0.266513 0.239968 1.239315 1.205902 1.537987 1.098124 0.859805 0.863555 0.449285 1.422210 0.199768 1.541420 0.165019 0.357841 1.333702 0.780552 1.817421 1.326090 1.556642 0.158090 0.988718 0.674445 1.749600 0.960378 0.084288 0.655024 1.656664 0.587799 0.266345 1.475692 0.355335 1.516077 0.871619 0.114120 0.528946 -0.021508 1.566964 0.763272 -0.041987 1.595826 0.231857 1.599241 1.621312 1.104850 1.046262 0.120831 0.746877 0.255028 1.065960 1.308573 1.030611 0.412491 1.820905 0.676300 0.872818 1.288694 1.324473 0.222472 -0.042336 0.351502 0.979300 0.592070 1.751901 1.130980 0.635238 1.762905 1.273495 1.080044 0.919480 1.179593 1.820413 -0.178963 1.488909 1.547676 1.413473 0.037220 0.540918 0.498348 0.519105 1.466716 1.160558 1.879868 1.779510 0.227415 1.843328 0.973617 1.469836 0.661373 0.789077 1.686318 1.083096 0.731552 0.631974 0.625195 0.518437 0.775161 0.599994 1.433824 1.546850 0.244876 1.235352 1.089325 0.745382 0.631062 0.172135 1.346869 0.691421 0.557946 0.547526 0.910145 1.806512 0.841829 0.035993 0.164089 0.876851 0.419736 1.447045 0.857337 1.449753 0.335596 1.526369 1.237708 0.224164 0.915030 1.895158 0.321894 0.243163 0.253147 0.767202 1.294104 1.921776 0.626583 0.519179 1.368603 1.836644 0.124415 0.786054 0.509813 0.419967 1.197343 1.868597 0.775064 0.252892 0.318984 0.927666 1.932340 1.673779 0.940320 1.012894 1.522815 1.848921 1.524047 0.876052 0.835068 0.202396 0.794377 1.439611 0.074539 -0.075361 1.885112 0.757920 0.329423 1.361749 0.638054 1.833880 1.623912 1.949599 1.140473 0.640646 1.616862 1.093454 0.364866 1.044146 1.776136 1.508751 1.419919 0.732729 1.039208 1.607877 1.063599 1.218045 1.039226 0.726168 0.417832 1.530379 1.814359 0.766578 1.503198 0.394050 1.486705 1.297175 1.401889 -0.082990 1.629865 0.667706 -0.397919 1.071902 1.710567 1.259419 0.488686 0.774842 0.495281 0.690810 -0.138360 0.995138 0.649084 1.726986 1.822386 1.675677 0.871295 0.552178 0.176435 1.151023 1.706719 1.714074 1.232741 1.305463 1.102357 1.338847 1.735865 0.353156 0.053635 1.854965 0.082734 1.117492 1.602812 0.202797 0.527913 1.196926 0.224179 0.259190 1.607857 0.393217 0.665176 0.698877 1.498248 0.402702 0.734968 0.030220 0.717933 0.287575 0.263201 1.292487 0.766597 1.392089 1.702156 0.928571 0.132747 0.718224 -0.022519 0.695395 0.961009 0.836784 0.544693 0.008738 0.733264 1.627723 1.340817 1.883794 0.273239 0.966759 -0.014448 1.703981 0.745520 0.782103 1.349896 0.309738 1.248191 0.900551 0.446724 1.461235 1.068695 1.874609 0.429643 0.991606 0.853954 0.549724 0.691665 0.919866 1.355260 0.399310 1.207242 1.036111 0.331131 1.923340 1.034344 1.785499 1.692182 1.469165 1.114091 0.784790 1.244341 1.215443 0.532863 1.669624 1.876519 0.370732 1.081205 0.630715 0.067840 0.069610 0.360604 0.248517 0.996373 0.072779 1.278622 0.558082 0.871795 0.006302 -0.080693 0.699858 0.670774 0.036839 0.792313 1.053054 0.373523 0.895965 0.219529 0.603841 1.529929 1.571200 1.572745 1.371021 0.483877 0.339338 0.252508 1.449230 0.776954 -0.037096 1.490924 0.862926 -0.010051 1.492206 0.908991 0.850959 0.799315 1.197209 1.798803 1.906307 0.600800 1.929103 1.773167 1.595466 1.116230 1.849141 -0.138473 1.401561 1.089434 1.454707 1.516034 0.405189 0.364581 0.477576 1.238788 1.699265 1.225421 1.132382 0.818130 0.342357 -0.093965 0.277981 1.214872 1.234457 1.644311 0.791369 1.302431 1.793582 0.731030 1.184737 1.815189 0.836787 1.397548 0.795514 1.731490 1.978947 1.699272 -0.087754 1.229538 0.342806 1.370505 1.915848 0.745665 -0.007586 0.973025 0.820357 0.688041 1.687190 0.295857 1.467741 0.510938 1.446447 0.725517 0.934034 0.280828 0.016119 0.464653 0.039176 0.699325 0.325100 0.107226 0.235540 -0.001189 1.374634 0.697151 1.094635 0.813547 1.004845 0.482350 0.999131 0.106594 0.262632 1.035519 1.040389 1.543929 1.111148 0.589803 0.294786 0.739019 0.976084 0.242874 1.533302 1.797675 0.710897 0.037253 1.540031 -0.138585 0.099110 0.002289 0.351043 1.535626 1.094114 1.596706 1.760672 0.111407 1.067403 0.300312 1.066585 1.479561 0.664804 1.829358 -0.133782 0.959441 1.032728 1.396513 1.674422 1.797836 1.031267 1.515695 1.300521 1.221482 1.135268 1.060354 0.280176 0.099445 0.768971 1.623602 1.175004 0.859700 0.318892 1.048016 1.141598 0.451777 0.809913 1.805898 -0.088147 0.408319 0.962852 0.001868 0.190438 -0.086998 1.638471 0.448879 1.897520 0.102606 1.398992 0.552579 1.630596 1.779521 1.459921 1.806379 -0.015856 0.522021 1.606515 0.866415 1.424116 0.555575 1.948281 1.030085 1.522586 1.487448 0.345793 0.419242 0.262081 -0.137605 0.615015 1.404327 0.444728 1.303330 1.429523 1.612489 0.842585 0.811464 1.213611 1.776209 0.851089 0.965962 0.450547 1.048746 0.577828 0.621931 1.428382 1.449142 0.237328 1.159246 1.621752 1.046157 1.746994 0.219170 0.418162 1.636099 1.220316 1.860240 1.104417 0.911381 -0.221721 0.477919 0.648802 1.465706 1.034322 0.722603 0.484344 0.507547 1.362755 0.260305 0.012258 1.063129 0.125427 0.731236 1.951972 1.460277 1.336222 1.327980 0.292992 1.466729 0.979436 1.525635 1.525911 0.335487 0.473741 -0.076837 0.875218 0.622684 0.081840 0.662885 1.733616 0.541135 0.388849 0.020387 1.077932 1.301097 1.479384 0.696331 1.842813 0.869590 1.665039 0.472033 0.087064 0.068769 0.055497 0.502784 1.571676 1.461867 1.681430 0.147791 1.648422 1.206459 -0.037747 0.322247 1.620310 0.330283 0.874529 1.548328 0.082016 0.899640 0.252738 1.639547 1.115960 0.718372 1.473943 0.699136 1.736238 1.746811 1.089863 0.308838 1.120907 1.649835 0.230940 0.599980 0.596666 1.447764 0.198200 1.696185 0.270568 -0.052189 1.459685 1.889516 0.973187 0.172200 1.005083 0.140394 -0.325498 0.227479 1.423139 0.675559 1.625686 1.773134 1.707271 0.913240 1.631036 0.019460 -0.103583 0.286102 0.291320 0.171705 1.446563 0.484585 0.563140 1.120302 1.858354 -0.041253 1.012849 1.296992 1.301978 0.760269 1.753296 0.283422 0.885422 1.492344 1.329990 0.612597 1.921560 0.200214 0.943390 0.512296 1.447564 1.846183 1.707477 0.147308 1.193487 0.573805 0.940372 0.256928 1.884388 0.083286 0.452700 0.291224 0.183037 0.545393 0.513289 1.568504 0.086795 1.616080 0.313708 1.244178 1.366657 0.283715 0.918206 0.203207 1.448705 1.446830 1.040873 1.730698 1.611476 0.946093 0.666703 0.615895 -0.026318 1.856548 1.350941 0.160944 1.170338 0.103712 1.306411 1.265492 0.066769 0.766652 0.588182 1.233682 0.122447 1.681384 0.412335 0.178479 1.660841 1.811596 0.064779 1.196947 0.102828 1.177751 1.680742 0.449282 0.904230 1.612891 0.610492 1.241968 1.399466 0.400447 1.883535 1.261774 1.133011 0.954793 1.391021 0.070613 1.790155 0.647170 1.538113 0.897498 1.281308 0.839515 0.299338 1.976000 1.258249 1.677501 0.492876 0.811265 1.486293 1.219526 0.118255 0.198524 0.778925 0.559223 0.356595 0.911936 0.224097 0.843920 0.757074 1.245721 1.201767 1.503895 1.262673 1.087280 1.841884 0.809693 0.271807 0.201811 0.731278 1.725985 1.815260 0.626935 0.345144 1.819499 0.455162 1.284539 0.586586 -0.039343 1.180043 1.600481 1.257565 1.070955 1.769321 1.284756 0.544339 0.946351 1.252154 1.036230 1.576752 1.153164 0.375443 1.727961 1.571085 -0.025115 1.130257 1.617683 0.962908 1.778427 0.723156 0.083418 0.399245 1.317049 1.776371 1.599518 1.205637 0.260734 1.602902 0.159849 0.015420 1.100020 1.095699 0.079940 0.912501 0.640796 0.462014 0.677260 1.211741 1.516331 1.260972 0.602754 1.418955 1.106479 1.705887 -0.011794 -0.109286 0.655006 0.832139 0.926535 1.469372 0.543237 -0.034228 1.638292 1.960348 1.105376 1.332042 1.230009 0.928482 0.888952 0.046935 0.000507 1.314819 0.300831 0.937048 1.256196 0.493401 1.660853 0.728526 -0.110992 1.233577 0.930248 0.678472 -0.188603 1.218183 0.336483 1.191586 0.137376 1.533100 0.065052 0.981398 0.031577 0.994203 0.870125 0.262473 0.406748 0.511844 0.815002 0.421443 1.909838 1.226523 0.209198 0.929653 1.101747 0.799872 -0.201492 0.710339 1.291323 0.977953 1.379452 1.641037 0.096914 1.857579 -0.096609 0.337720 0.155086 0.269412 1.616182 0.568248 0.498010 1.652758 1.650958 0.244174 0.661813 1.505931 0.002924 0.107270 1.744250 -0.050778 1.467242 1.623260 0.801762 0.194925 0.642578 1.510339 1.586904 0.355100 0.041208 0.186780 1.201510 0.782417 -0.071305 1.709116 1.537271 1.490599 0.543263 -0.128944 1.746343 1.737663 -0.131604 0.721233 -0.033503 0.381659 0.516023 0.468830 0.968358 1.682010 1.574023 1.572387 0.110095 0.087750 1.339801 0.879220 0.721407 1.874303 0.700889 0.258858 1.621111 0.253234 1.424104 1.511284 0.981212 0.722846 0.700750 1.110812 0.395794 1.195186 0.912389 1.340990 0.476183 1.514745 1.613236 0.410309 0.055535 0.162381 0.534469 0.793452 1.780666 0.700207 1.016778 0.157602 0.161820 1.110015 0.882580 0.709147 1.213415 -0.036555 1.633111 1.171847 0.640753 0.205253 1.266074 1.492664 0.580884 0.765533 1.322154 0.370372 1.440758 0.830815 1.501849 1.539966 1.852372 0.365379 1.004282 1.053251 0.251083 0.118197)
       )

;;; 4096 155.67;     (expt 4096 .6) is 147
;;; 65536 704.86! [.59 = 697, .5 = 256]

))


;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.539 #(0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
#(3  1.7548747062683 #(0 1 1)

     1.7393749801561 #(0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 #(0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 #(0.0 0.79018270969391 0.69699490070343)

     1.738745 #(0.000000 1.209826 1.303017)
     1.738744 #(0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
#(4  2.19460272789 #(0 1 0 0)

     2.050 #(0 39/25 26/29 27/22)
     2.048743724823 #(0 111/256 281/256 195/256)
     2.0466175079346 #(0 223/512 563/512 49/64)

     2.045218 #(0.000000 1.563819 0.899661 1.233860)
     2.045217 #(0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; 2.2360679
#(5  2.7317879199982 #(0 1 1 0 0)

     2.3731805734023 #(0 7/16 7/4 5/8 7/16)

     2.307252 #(0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 #(0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; 2.44948
#(6  2.8638670444489 #(0 0 0 0 1 0)

     2.522759 #(0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 #(0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; 2.64575
#(7  2.9204399585724 #(0 0 0 1 1 0 1)

     2.618497 #(0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 #(0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; 2.828427
#(8  3.2507002353668 #(0 1 1 0 1 1 1 0)

     2.8071956634521 #(0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.791000 #(0.000000 1.197326 0.326760 1.111456 1.318751 0.231304 1.994192 1.872649)
     2.790858 #(0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 #(0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; 3
#(9  3.5549147642153 #(0 1 0 1 1 0 0 0 0)
     3.46973755015 #(0 1 1 0 1 0 0 0 1)
     3.4140722751617 #(0 0 1 1 1 1 0 1 0)

     2.886575 #(0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 #(0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; 3.162277
#(10 3.5391488075256 #(0 0 1 1 0 1 0 0 0 0)

     3.054055 #(0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 #(0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 #(0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 #(0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 #(0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; 3.31662
#(11 3.6182308197021 #(0 0 0 1 1 1 0 1 1 0 1) ; 3.31662

     3.177383 #(0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 #(0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 #(0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 #(0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 #(0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; 3.464101
#(12 4.0877377663658 #(0 0 0 0 1 0 1 0 0 1 1 0)
     4.0507665657231 #(0 1 0 1 0 0 1 1 0 0 0 0)
     4.0 #(0 0 1 1 0 0 0 0 0 1 0 1)
     4.0 #(0 1 1 0 1 0 0 0 1 0 0 0)
     4.0 #(0 1 0 1 0 0 1 0 0 1 1 1)
     4.0 #(0 1 0 1 1 0 0 1 0 0 0 0)

     3.364341 #(0.000000 -0.081820 1.399778 1.018584 0.994103 1.854492 0.464370 0.769854 0.179932 0.999593 0.618367 1.331545)
     3.363698 #(0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362737 #(0.000000 -0.077029 1.405769 1.027930 1.006574 1.870564 0.481680 0.791450 0.202834 1.026360 0.648485 1.363973)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; 3.60555
#(13 3.9482246631869 #(0 0 0 0 0 0 1 1 0 0 1 0 1)
     3.8778836727142 #(0 0 1 1 0 0 1 0 1 0 0 0 0) 

     3.531897 #(0.000000 0.670162 -0.095257 0.537542 -0.014805 0.385445 0.484518 1.431811 0.066607 0.001633 1.257240 0.820923 0.574587)
     3.476053 #(0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475486 #(0.000000 1.620375 1.040657 1.650169 1.557159 1.039441 1.466014 -0.165746 0.075570 1.032228 0.496820 0.937529 0.047188)
     3.475452 #(0.000000 1.620672 1.042066 1.652912 1.561748 1.044454 1.472771 -0.159565 0.082334 1.041828 0.507070 0.948164 0.058404)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; 3.741657
#(14 4.2126383781433 #(0 0 0 0 0 1 1 0 0 1 0 1 0 0)
     4.2575645446777 #(0 1 0 0 1 0 0 1 0 0 0 1 1 1)
     4.2842662512094 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.6206462 #(0.000000 1.058317 0.285078 1.806037 0.777548 1.158566 0.154927 1.434637 1.675813 0.358961 0.394684 0.549621 0.067593 0.064796)
     3.606512 #(0.000000 0.785150 1.482463 -0.077041 0.773052 0.357080 1.202237 -0.069790 1.584889 0.769902 0.652503 0.409520 0.740393 0.675317)
     3.600425 #(0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599409 #(0.000000 0.851134 1.636505 0.091221 1.006010 0.744090 1.678264 0.418648 -0.048848 1.351639 1.174737 1.143087 1.519418 1.448182)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; 3.872983
#(15 4.4701427567987 #(0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)
     4.4776539802551 #(0 0 1 0 1 0 0 1 0 0 0 1 1 1 1)
     4.5555243492126 #(0 1 0 0 1 0 1 0 0 1 1 0 0 0 0)

     3.759718 #(0.000000 -0.397665 0.806430 -0.136442 1.561904 0.158128 0.655585 -0.218498 0.035467 0.628496 0.322341 0.470757 -0.271280 1.477753 1.665977)
     3.754132 #(0.000000 0.903767 1.420933 1.923281 1.041289 0.252052 0.873412 0.620154 1.578503 0.111918 0.212810 -0.101363 1.630440 0.487026 0.384094)
     3.753088 #(0.000000 1.135982 0.074052 1.463569 1.541245 1.092705 1.157015 0.490295 1.413226 1.335648 0.694560 1.273492 1.624971 0.104821 0.184801)
     3.739752 #(0.000000 1.191367 0.176518 1.591145 1.710423 1.309889 1.422724 0.785426 1.754948 1.707551 1.122738 1.744847 0.127913 0.663567 0.776627)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; 4
#(16 4.5778832343715 #(0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)
     4.5854911804199 #(0 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0)
     4.6032500267029 #(0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0)
     4.6629304885864 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1)
     4.6691436767578 #(0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1)

     3.863264 #(0.000000 0.212739 0.823601 0.183475 0.522013 1.322798 0.144924 -0.004654 0.283110 0.829370 -0.006329 1.351573 0.889059 1.066540 0.816406 -0.008936)
     3.858242 #(0.000000 0.144652 0.676444 0.017002 0.269119 1.012194 1.772841 1.585260 1.809100 0.289620 1.399960 0.670537 0.175237 0.296937 -0.017357 1.108803)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; 4.12310
#(17 4.5790815353394 #(0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)
     4.6202440261841 #(0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1)
     4.8765740394592 #(0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 0)

     3.97646324 #(0.000000 0.753931 1.605116 -0.013833 0.719484 1.221266 1.149453 -0.016400 0.682620 0.271202 0.759215 0.509449 0.934281 0.751176 0.303242 1.755965 1.144501)
     3.927805 #(0.000000 0.618908 0.864629 1.180783 1.677629 1.929621 0.580975 1.820904 0.468136 1.289907 0.485211 0.029658 1.160895 0.856998 0.644358 0.814931 0.296558)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; 4.2426406
#(18 4.801501750946 #(0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)
     4.857753276825 #(0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     4.86248254776 #(0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0)
     5.0418791770935 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0)
     5.0524249076843 #(0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)
     5.0652704238892 #(0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0)
     5.0697374343872 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0)
     5.0979032516479 #(0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0)

     4.18242582 #(0.000000 1.136222 0.770438 0.400169 1.826042 1.428576 1.017726 1.528217 0.877622 1.606644 0.825490 0.569790 0.688245 0.883189 1.302521 1.639646 0.475959 1.347778)
     4.130024 #(0.000000 1.754352 1.775885 0.648861 0.498465 0.100092 0.902120 1.526431 0.475472 1.473007 0.551653 0.202011 1.209083 1.439412 1.702576 1.066652 0.934229 1.195458)
     4.071185 #(0.000000 0.956640 1.083713 0.493342 0.797185 0.138960 0.613585 0.388904 -0.007616 0.968034 0.616152 1.753096 0.351362 1.174080 1.220111 1.511627 0.186455 1.775153)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; 4.358898
#(19 5.0520766258263 #(0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0)
     5.0155117084604 #(0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0)
     4.9927339414282 #(0 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1)
     4.9885946763115 #(0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0)
     4.9724504091175 #(0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1)
     4.9609222566765 #(0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     4.8924918279945 #(0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.341600 #(0.000000 1.579328 0.343104 1.375842 0.353081 0.423388 1.240118 1.912826 1.194961 1.293193 0.615240 0.016197 0.673856 0.516664 0.391481 1.727303 0.190251 0.501442 0.668027)
     4.195254 #(0.000000 0.791760 0.603530 1.420197 0.161131 1.375504 1.353582 1.630311 0.304896 0.430904 0.181997 0.875060 1.590045 0.702894 0.531692 0.132476 0.893747 0.532901 0.172031)
     4.173923 #(0.000000 0.329738 1.407540 1.252167 0.448297 0.551162 1.341659 1.859617 1.357020 0.222879 0.553639 1.254187 0.641694 -0.208417 1.489583 1.646436 1.391179 1.758274 1.299312)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; 4.472135
#(20 5.136606875959 #(0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0)
     5.104093841111 #(0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0 0)
     5.043 #(0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.360063 #(0.000000 0.073521 -0.009620 0.184167 -0.090618 0.682702 1.090680 1.616612 1.399432 0.352373 1.094838 -0.499526 0.947850 -0.319867 1.410866 0.829866 -0.654620 0.294523 -0.287091 1.405089)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; 4.5825756
#(21 5.2726634376804 #(0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0)
     5.2359894831295 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1)
     5.2142992491192 #(0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1)
     5.2105652502144 #(0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0)
     5.1372244578347 #(0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.450399 #(0.000000 1.232888 0.090626 0.908626 0.292628 1.789632 -0.064521 1.337231 1.077653 0.742032 1.053479 1.212396 1.464307 0.813375 1.503599 1.665799 0.652080 0.032818 1.058665 1.235482 -0.037282)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; 4.6904157
#(22 5.5119525535942 #(0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0)
     5.473 #(0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1)
     5.1805551751198 #(0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.582778 #(0.000000 0.181219 0.413695 1.937138 0.354645 0.584330 1.521156 1.778203 1.534204 1.337940 -0.034924 1.699942 0.807878 0.347955 1.849970 -0.102930 0.038171 0.664785 1.395334 0.513333 1.628189 0.471554)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; 4.7958315
#(23 5.5374279022217 #(0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0)
     5.4125407453101 #(0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.663897 #(0.000000 0.403435 0.142748 -0.306349 -0.210666 0.795999 1.004771 1.283072 1.566950 0.563329 0.340321 0.292952 1.204762 0.724980 0.539830 0.518629 0.906326 0.187293 1.164337 0.997077 -1.862047 1.042851 -0.124041)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; 4.89897948
#(24 5.6568542494923 #(0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0)
     5.6584029055795 #(0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0)
     5.62041703818643 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)
     5.6193280144865 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.789073 #(0.000000 0.498962 1.192122 1.399568 0.478175 1.498537 -0.058937 0.823036 0.009630 0.862968 0.052440 1.055798 0.997888 1.799698 -0.043449 0.198517 0.646569 0.269929 0.032678 0.156758 0.040928 -0.117138 1.174336 0.689332)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; 5
#(25 5.7861609458923 #(0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1)
     5.7734115151023 #(0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1)
     5.7220960914079 #(0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.889151 #(0.000000 -0.128293 0.647012 0.790395 -0.286222 0.142942 1.157912 1.181898 -0.008090 -0.239858 1.215092 0.277126 0.697826 1.108639 0.614409 1.458730 0.405980 0.119432 0.178568 -0.086880 1.056419 0.142726 0.542932 0.376693 0.306796)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; 5.0990
#(26 5.8912210464478 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0)
     5.8572101593018 #(0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0)
     5.8545204896237 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0)
     5.8537594936002 #(0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     5.008456 #(0.000000 1.693298 1.368284 1.373891 0.627805 0.749201 1.218581 1.690405 1.084549 0.650173 -0.133773 1.086196 0.314357 0.195942 0.717774 1.230001 1.543258 -0.160224 1.426853 1.764971 0.866097 1.848572 0.672503 -0.114245 0.170724 0.146283)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; 5.196152
#(27 5.9741146989154 #(0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0)
     5.968769496567 #(0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1)
     5.9206547737122 #(0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0)
     5.8637111082051 #(0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.091597 #(0.000000 0.108433 1.216643 1.164927 0.973412 -0.021700 0.035052 -0.150680 0.575434 1.005110 1.378469 0.117668 0.956832 1.742119 0.131354 -0.244103 0.873574 0.514283 1.810072 0.920776 0.162873 1.223342 1.596642 1.233515 1.209783 1.332933 1.299893)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; 5.291502
#(28 6.0999548630948 #(0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0)
     6.0720555632906 #(0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1)
     6.057788848877 #(0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0)
     6.0276107788086 #(0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.092585 #(0.000000 1.695440 -0.043623 0.222052 0.119988 0.906658 0.748492 0.144655 -0.170479 0.199068 0.623366 -0.017877 1.188512 1.804895 0.527591 0.257090 0.180945 1.672974 1.633662 0.481970 1.385001 1.687455 0.368286 1.304198 0.926301 0.205231 0.776507 0.352984)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; 5.385164
#(29 6.2191140571712 #(0 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1)
     6.1821198011886 #(0 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0)
     6.1290216445923 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0)
     6.1179310275088 #(0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1)
     6.0348020511367 #(0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.267374 #(0.000000 0.150950 0.558525 0.734122 1.367984 -0.010939 1.646605 0.436638 1.718320 1.202816 0.978274 1.009951 0.702458 1.591440 0.711769 0.372772 0.283792 1.401587 0.653090 0.959946 0.846748 0.832705 0.047894 1.107158 1.102787 1.831833 0.612394 1.520781 0.108517)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; 5.4772255
#(30 6.2854590415955 #(0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0)
     6.2697563171387 #(0 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1)
     6.2528157234192 #(0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1)
     6.2357559204102 #(0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.356917 #(0.000000 -0.272403 0.779609 0.427831 1.743491 0.813040 1.826167 0.242297 0.800154 0.444205 0.599989 1.282484 -0.036742 0.801786 0.590077 1.134322 0.784392 1.820310 1.361582 1.648573 1.057728 0.274607 0.187893 0.071940 0.646543 1.513903 1.900196 1.697822 1.289117 1.535078)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; 5.56776
#(31 6.3631281852722 #(0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1)
     6.3062944412231 #(0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1)
     6.269211769104 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0)
     6.1342258453369 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.423494 #(0.000000 1.386303 -0.055734 1.470363 1.133289 0.301867 1.278872 0.118563 0.785226 0.165360 0.277066 1.264913 0.806911 0.592449 0.252572 0.349148 0.668297 0.601505 0.393268 1.237828 -0.182749 1.792953 1.685727 0.766750 0.385388 1.093159 0.147275 0.340746 0.884734 1.109480 0.159614)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; 5.65685
#(32 6.5067925453186 #(0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 0)
     6.5040426254272 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
     6.4926128387451 #(0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1)
     6.4840421676636 #(0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1)
     6.4720740318298 #(0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1)
     6.3532226957365 #(0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.567572 #(0.000000 0.861612 1.209352 0.519940 1.052688 1.500206 0.176574 1.932012 0.476025 1.248486 1.078099 0.961526 1.430505 1.363781 0.301762 1.949580 1.401541 1.767835 1.762773 0.053035 1.192812 0.032127 1.950646 1.510242 1.125351 1.064249 0.897680 1.674417 0.357268 1.272658 0.844033 1.936450)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; 5.74456
#(33 6.6069865226746 #(0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0)
     6.6028137207031 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1)
     6.5531010627747 #(0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0)
     6.5466594696045 #(0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1)
     6.5448527336121 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1)
     6.4944429397583 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.606985 #(0.000000 1.601250 1.154201 1.251204 1.484471 0.841351 0.331138 1.775294 1.322346 1.205337 1.309192 0.894341 0.780080 0.993837 1.545031 0.197628 0.378099 0.791105 1.808947 1.068283 0.948274 1.605477 1.762770 1.528242 1.622190 0.602603 1.560229 -0.275479 0.725028 1.892782 0.568803 -0.062637 0.716748)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; 5.8309518
#(34 6.7313859392731 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0)
     6.7289090156555 #(0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0)
     6.7241077423096 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0)
     6.6926617622375 #(0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0)
     6.6887402534485 #(0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0)
     6.67742395401 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0)
     6.5771403312683 #(0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.745149 #(0.000000 1.128000 0.272515 -0.039342 0.299166 0.551340 0.311135 0.243296 0.298010 -0.034808 1.017937 0.346637 1.523918 0.449629 1.252707 0.940022 0.532163 0.349046 1.187598 0.382385 0.597063 -0.156613 1.373428 0.579016 1.245233 1.475704 0.214408 0.059071 0.148707 1.076050 1.407267 0.860377 1.325750 0.147798)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; 5.9160
#(35 6.8717794418335 #(0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0)
     6.8709630966187 #(0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0)
     6.8534955978394 #(0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0)
     6.8080215454102 #(0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0)
     6.7822489738464 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0)
     6.7593507766724 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0)
     6.7392678260803 #(0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     5.838235 #(0.000000 0.446999 1.593042 1.667453 0.393874 0.928772 1.354904 1.466772 0.226754 1.215249 0.009860 0.231727 1.867304 1.148536 1.079686 1.602019 0.201717 1.367553 -0.043267 1.213451 0.401906 0.197087 1.726905 1.537420 -0.145221 -0.105823 1.452971 0.350421 1.134485 0.211013 1.683797 0.967568 0.587830 1.050198 0.967015)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; 6
#(36 6.9997129440308 #(0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 0)
     6.9918489456177 #(0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     6.9864625930786 #(0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0)
     6.9756178855896 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0)
     6.9730844497681 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0)
     6.9310870170593 #(0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0)
     6.838840007782 #(0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     6.8277182579041 #(0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     6.000647 #(0.000000 1.912912 1.511457 1.005676 0.475902 1.042301 1.534958 1.687657 1.633883 0.696422 0.109719 0.960671 1.460953 -0.086125 0.280953 1.392145 0.637062 0.548998 1.855535 0.910709 0.899814 1.218376 1.194522 1.403477 0.001627 1.122460 1.703316 1.347718 0.823811 0.867627 1.120797 0.336394 0.652737 0.037688 1.489642 0.050669)
     6.000197 #(0.000000 1.917527 1.510073 1.005131 0.453926 1.063640 1.559823 1.682537 1.623280 0.681308 0.086236 0.947887 1.480950 -0.074836 0.321662 1.405263 0.630112 0.513122 1.845839 0.897702 0.896538 1.245466 1.226396 1.436138 0.029365 1.162940 1.689733 1.372435 0.854198 0.883700 1.124489 0.382194 0.683834 0.036818 1.474548 0.083108)

     5.996066 #(0.000000 1.923294 1.509187 1.003577 0.456660 1.062378 1.555540 1.683067 1.621530 0.683932 0.087670 0.954147 1.484751 -0.073402 0.320903 1.403802 0.626357 0.507563 1.850435 0.892520 0.896703 1.243983 1.224037 1.439495 0.031850 1.163064 1.686561 1.366983 0.859861 0.891355 1.129464 0.385910 0.687566 0.036704 1.476995 0.083963)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; 6.0827
#(37 7.1364183425903 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0)
     7.1333456039429 #(0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0)
     7.1091394424438 #(0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0)
     7.1067843437195 #(0 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0)
     7.0880541801453 #(0 1 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.0842223167419 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.0678915977478 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.0 #(0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     6.024853 #(0.000000 1.197998 1.847287 0.935006 1.782937 0.496617 0.026869 0.302955 1.087642 1.074685 1.005491 1.377595 0.273425 1.653861 0.070205 0.494353 1.198438 -0.081973 0.936958 0.883593 1.529878 0.426603 0.218858 1.480597 1.569766 1.445696 0.463800 0.267438 1.385323 0.811147 0.214359 0.106300 0.522104 0.380804 0.177813 0.326019 -0.015506)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; 6.1644
#(38 7.1993670463562 #(0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0)
     7.1947164535522 #(0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 1)
     7.1848387718201 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0)
     7.1674456596375 #(0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     7.0878057479858 #(0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0)
     7.027690410614 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.150178 #(0.000000 0.458381 0.980410 1.182584 1.502374 1.305302 0.863491 1.146667 1.407357 1.061564 0.795229 1.420865 1.626108 0.940678 1.765120 -0.200782 0.758841 1.330656 0.859416 0.934009 0.734086 -0.018706 1.390826 0.222287 1.806876 0.258169 -0.107351 1.180819 1.133567 0.286545 1.542814 0.215728 1.086918 1.359138 1.067734 1.591630 0.412893 0.246316)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; 6.2449
#(39 7.3710842132568 #(0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.3583292961121 #(0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.3438787460327 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0)
     7.3397698402405 #(0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.3336853981018 #(0 0 0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.3038640022278 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0)
     7.2819819450378 #(0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.2700448036194 #(0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0)
     7.2362656593323 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.187454 #(0.000000 0.388618 1.432653 1.784425 0.371935 0.650011 0.589744 1.419632 1.232381 1.275218 1.031193 0.648549 1.314783 1.550413 0.796967 0.829675 0.920444 0.286140 1.176611 0.777335 1.481467 -0.170605 1.810857 0.590069 1.604413 0.287254 1.659794 1.308709 0.893762 0.025955 0.915239 0.336227 0.586243 1.686232 1.285404 1.206990 1.759017 1.037935 0.925206)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; 6.3245
#(40 7.6328768730164 #(0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 1 1)
     7.5038495063782 #(0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.277925 #(0.000000 1.286847 1.056558 1.064552 0.386122 0.823982 0.120665 1.715364 1.070368 1.544864 0.375054 1.038193 0.380390 0.305991 1.429156 0.150341 0.742273 -1.907886 0.495478 -0.131302 1.454190 1.544371 0.424550 1.222035 1.334261 1.409069 0.400912 1.070887 1.396403 -0.550278 0.327917 1.771458 0.927243 0.552970 1.392666 1.183354 1.462584 1.291648 1.910305 1.576805)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; 6.4031
#(41 7.86743174872036 #(0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0)
     7.7093445316966 #(0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.327577 #(0.000000 0.582814 1.286033 1.434762 0.968648 0.414373 0.202678 -0.084375 1.012441 1.216240 0.698275 0.906119 0.006115 0.289651 0.751619 0.181944 1.916605 0.830850 0.905938 0.268842 -0.060925 0.318843 0.592034 1.698481 1.912304 1.683298 0.193210 0.459818 0.828474 1.122554 0.525807 1.056723 0.751455 0.901980 -0.077116 0.957355 -0.093347 1.453165 0.349371 1.538528 1.034674)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; 6.4807
#(42 7.9323644638062 #(0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0)
     7.8349797520917 #(0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1)
     7.77445936203 #(0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.408479 #(0.000000 0.615414 1.470843 0.696787 0.198900 1.065083 0.258615 1.498581 1.009578 1.330852 -0.125534 0.667854 -0.151832 1.235447 1.351733 1.833745 1.621535 1.576927 0.386650 1.123212 1.738064 0.185423 -0.092954 -0.362850 1.267803 0.809007 0.146693 0.174438 0.940048 0.098849 1.557978 1.898566 1.061904 1.399143 1.502843 -0.309744 1.594046 1.048117 0.348277 0.500199 0.501915 1.050638)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; 6.5574
#(43 7.8550543785095 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     7.8274940102143 #(0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0)
     7.7573688953539 #(0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.480896 #(0.000000 0.162445 0.869999 0.643054 0.499615 0.316081 0.502954 0.136590 0.117083 1.312132 1.258206 1.002617 1.668339 0.653729 0.901112 0.185217 1.792525 1.096541 0.881150 0.351883 0.533560 1.402531 1.721250 -0.341462 0.698820 1.678458 1.686345 1.303828 -0.030019 0.457569 1.242075 0.589258 1.726081 0.987456 0.169302 1.113924 0.233149 0.477401 1.064623 1.025028 1.388482 1.105104 1.814053)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; 6.6332
#(44 8.20137867697624 #(0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0)
     7.9338580613871 #(0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.604847 #(0.000000 0.351044 1.306542 1.465763 1.320249 0.565440 0.399940 -0.237398 1.055407 0.418613 0.685395 1.680568 1.845447 1.017355 1.471092 1.618392 0.598714 0.202675 1.546748 0.895775 1.499434 -0.449664 0.958870 0.671637 0.465436 0.361895 0.743954 0.800411 1.320233 0.704441 1.101784 1.234656 0.652603 1.451040 0.413040 1.111137 0.556088 1.736681 0.344377 0.023949 0.937837 1.223467 1.558214 1.345712)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; 6.7082
#(45 8.1525803340105 #(0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1)
     8.1351366043091 #(0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     6.631015 #(0.000000 1.007271 0.477966 1.144428 0.405377 0.709562 0.591098 0.023922 1.174211 1.114679 1.631206 1.257380 1.314198 0.342822 0.579809 1.458996 0.840637 0.297374 1.352000 1.645616 1.557736 1.966797 0.747895 1.349386 0.523533 0.276675 1.146356 1.736290 1.157329 1.019943 0.469399 1.677619 1.797739 1.624789 1.799637 0.670741 1.546255 1.428852 1.094569 0.113612 0.742588 1.142278 0.965770 1.246971 0.979825)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; 6.7823
#(46 8.2970391011104 #(0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0)
     8.1455316543579 #(0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     6.716722 #(0.000000 0.589157 0.764149 0.948916 0.779538 1.268976 0.079906 -0.380388 0.448649 1.688367 0.584830 0.606310 0.913828 1.245805 0.098838 0.459100 0.785114 0.012839 0.855902 1.034909 1.254775 0.506944 1.208460 0.513427 0.740531 1.441441 0.587365 1.582678 0.642329 1.527431 1.201228 0.845885 0.317234 0.031593 0.892897 0.339503 -0.008048 1.585731 0.008559 0.333144 0.349434 -0.214088 -0.070758 1.486266 0.987125 0.864350)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; 6.8556
#(47 8.4595276184949 #(0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1)
     8.336971282959  #(0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     6.793437 #(0.000000 0.899395 0.699139 0.822602 0.369563 0.538099 0.016185 1.556790 1.551639 1.250469 -0.202952 1.763170 0.028017 0.112846 -0.039936 0.661519 0.095443 1.286970 1.353214 0.225122 0.058009 1.649322 -0.090812 0.524816 1.307299 -0.085913 0.352297 1.754603 1.303478 0.680448 0.691624 0.498042 1.007138 1.659354 0.432424 0.069410 0.584615 1.128677 1.938358 0.151391 1.459330 0.723424 1.430080 0.763673 1.799518 1.483215 0.487535)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
#(48 8.35563071219336 #(0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     6.915278 #(0.000000 0.983076 1.015620 0.063842 1.494106 -0.005972 1.695997 1.678942 0.358953 1.057343 0.527209 1.428031 0.645552 1.494269 1.067870 1.497755 0.247545 0.757125 0.451247 1.449833 0.075956 1.020230 1.426922 1.629153 0.243356 1.483650 1.142286 1.674642 1.408206 1.680090 0.120730 0.539714 1.132654 0.585944 0.600580 0.199581 0.412146 0.506536 1.718622 1.360266 0.869834 0.354663 0.260398 1.244798 0.248387 0.541562 0.248243 1.958786)
     )

;;; 49 odd -------------------------------------------------------------------------------- ; 7
#(49 8.57458718352971 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

     6.997932 #(0.000000 -0.164932 0.062543 1.158715 1.337678 0.224375 0.048734 -0.092163 1.331151 1.726668 0.869593 0.492681 0.773739 1.547901 0.177653 0.783886 1.699317 1.314118 1.727115 1.406752 1.010538 0.644469 1.163474 0.987306 1.315592 -0.176138 0.077515 1.241145 1.483011 1.781204 0.940989 0.041761 -0.011584 1.150594 0.905660 1.772957 1.156521 1.425270 0.817709 1.841119 0.475148 1.453704 0.759985 0.412258 1.319758 0.058409 0.262995 0.090380 0.205050)
     )

;;; 50 odd -------------------------------------------------------------------------------- ; 7.07
#(50 8.7349090576172 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 1 0 1)
     8.7194833755493 #(0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1)
     8.711 #(0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     6.955341 #(0.000000 1.361678 1.058811 0.255280 1.370961 1.849509 -0.002708 1.051990 0.138785 0.680633 0.885054 1.004997 1.663130 1.665701 1.471149 1.691478 0.092552 0.824520 1.755358 1.033319 0.055803 1.509243 0.690460 1.232103 0.639211 1.442515 1.557836 1.909825 0.175467 1.577584 1.679153 1.359609 1.558171 1.882842 1.134585 1.054710 0.137527 1.900435 0.058225 0.972013 1.379097 0.844996 0.356897 0.497540 1.235873 0.734577 0.652916 0.243110 1.084307 -0.045442)
     )

;;; 51 odd -------------------------------------------------------------------------------- ; 7.141
#(51 8.7549686431885 #(0 1 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 0 0)
     8.5829010009766 #(0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.102448 #(0.000000 0.874846 0.874020 0.383400 1.888250 0.756017 0.077335 0.335823 0.069116 -0.025940 1.275212 -0.078764 1.078041 1.479295 0.805292 1.256350 0.745203 1.018548 1.380234 0.724702 0.624764 1.775180 1.216776 0.734076 1.029524 -0.060703 0.737883 1.483175 1.588250 0.541946 0.847349 -0.125391 1.213407 0.539383 1.054778 0.894488 -0.105971 0.339852 0.361281 1.377967 1.208041 1.701540 0.349199 0.207973 0.510160 0.390055 0.277980 1.424992 0.939638 0.580019 0.935273)
     )

;;; 52 odd -------------------------------------------------------------------------------- ; 7.211
#(52 9.0527429580688 #(0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0)
     8.8599758148193 #(0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.087457 #(0.000000 0.217695 0.815228 0.652105 0.472210 0.034513 -0.067645 0.661251 0.580253 0.051364 1.785056 0.529546 0.204393 -0.248113 1.238820 0.097387 0.952805 0.167446 0.758512 1.718336 0.161942 1.593107 0.882652 0.246677 1.208436 0.995914 0.028887 0.487573 1.153005 0.362942 0.720923 0.863427 0.090963 0.015179 0.082123 0.995009 1.057407 1.708206 0.745582 -0.334290 1.156564 0.740724 0.619550 1.021238 1.501400 1.347681 1.370305 1.480905 0.364029 1.829054 0.147181 0.425026)
     )

;;; 53 odd -------------------------------------------------------------------------------- ; 7.280
#(53 9.2427225112915 #(0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1)
     9.1345848658318 #(0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1)
     9.127 #(0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0)
     9.037 #(0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.271553 #(0.000000 1.343135 0.103283 0.287007 -0.102113 -0.119135 -0.299440 0.306934 1.564192 0.708532 -0.127587 1.101288 1.599644 1.082570 0.030040 0.754816 0.434230 0.785436 1.626496 1.210693 1.232434 -0.132579 0.255945 0.230787 0.708125 0.164488 0.610014 0.688544 1.945948 -0.058700 0.591940 1.336609 -0.071792 1.322368 1.176977 0.357916 0.384133 -0.143441 0.029700 1.235899 0.047215 -0.009258 1.321575 0.549885 1.411465 -0.234445 0.035711 -0.088922 1.047606 1.600927 -0.199308 0.525150 0.312914)
     )

;;; 54 odd -------------------------------------------------------------------------------- ; 7.348
#(54 9.3444428264144 #(0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1)   
     9.025 #(0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.341731 #(0.000000 0.356465 1.378320 0.098833 1.596818 -0.023654 1.218823 1.251692 0.691288 0.972560 0.161978 1.045118 0.521354 0.003562 0.307317 -0.097314 1.234937 -0.099161 0.226221 0.415364 1.740269 0.091970 0.079470 1.547113 1.226610 1.398885 0.336150 0.678460 1.841150 1.662881 0.519475 1.400656 0.391672 0.592116 1.898122 0.666766 0.533527 1.098876 0.624484 -0.028163 1.280801 0.610596 0.821449 1.798883 1.252672 0.438494 0.835603 1.353298 1.199447 1.791275 -0.116097 0.078485 0.587033 0.360167)
     )

;;; 55 odd -------------------------------------------------------------------------------- ; 7.416
#(55 9.3425494397445 #(0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 1 0)
     9.2039985656738 #(0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.380864 #(0.000000 0.378551 -0.175193 1.300624 0.762558 1.175276 1.564939 -0.074547 1.588074 0.235386 1.476865 0.556896 -0.066849 0.320111 0.097192 0.478953 1.683244 1.161925 1.270025 1.102513 0.235436 -0.031016 0.191299 0.221952 1.599370 0.162880 0.467467 1.233359 1.633245 0.699500 0.616427 0.003933 0.396463 0.543856 1.099953 0.961829 1.677585 0.593150 -0.332782 1.122442 1.143751 0.006167 1.059002 1.097752 0.656783 1.507140 0.168776 0.709153 0.425304 0.531258 0.118299 1.654258 0.491202 0.377929 -0.088468)
     )

;;; 56 odd -------------------------------------------------------------------------------- ; 7.483
#(56 9.5274312814935 #(0 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0)
     9.3816785812378 #(0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     7.438757 #(0.000000 0.399584 1.080682 1.282815 0.754797 1.304787 1.824143 1.790693 0.691286 0.987316 0.360583 0.349008 0.752988 1.116013 0.562702 1.074532 0.850688 0.844939 1.444388 1.530941 0.255231 1.863387 1.106579 1.310141 1.836783 -0.005007 0.360656 1.658990 1.588332 -0.013412 1.425619 1.827389 0.425917 1.713960 1.019636 1.345889 1.564516 1.246321 1.028804 0.474895 0.129090 0.228469 1.190499 0.208117 1.372797 1.554651 -0.150304 1.292293 0.381212 1.275332 0.867023 1.563695 0.615073 1.736449 1.595570 1.057393)
     )

;;; 57 odd -------------------------------------------------------------------------------- ; 7.549
#(57 9.5457010269165 #(0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0)
     9.543363571167 #(0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1)
     9.3903837203979 #(0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     7.498232 #(0.000000 -0.129172 1.380361 0.700320 0.780441 0.090360 1.662756 0.878900 1.570440 1.307072 1.212448 0.971480 0.736973 1.472139 1.503004 1.321091 -0.333336 0.652738 1.407756 0.559265 0.970311 0.614385 1.441684 0.387567 1.768917 0.697588 -0.175161 0.102601 0.178290 1.528309 0.468873 0.084595 0.063505 0.298061 0.525085 0.923933 1.286889 1.429105 0.333843 1.303850 0.808595 0.285713 0.098774 1.284736 0.038814 0.328707 1.274912 0.350159 1.518973 1.572017 0.226187 0.841753 0.707945 0.437563 0.618742 0.866615 1.853272)
     )

;;; 58 odd -------------------------------------------------------------------------------- ; 7.6157
#(58 9.7054271697998 #(0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.6265433375878 #(0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.5893135070801 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     7.600558 #(0.000000 0.520739 -0.135944 1.323686 0.400915 0.909904 0.533857 1.060902 1.237556 1.269869 1.780318 1.589139 0.543975 1.422673 1.606043 0.380912 0.893798 1.363714 1.916308 1.467556 0.484343 0.035905 1.362512 1.052674 0.701216 1.227654 0.054331 0.336647 0.485517 1.190925 1.006530 0.883787 0.199084 0.210890 1.799500 1.041239 -0.101762 1.809564 1.478560 -0.155244 1.422988 0.562288 -0.223688 0.441421 1.097613 0.463947 0.279884 1.513750 0.404962 1.608757 -0.053634 1.500664 -0.269655 0.342883 0.921060 0.214677 1.886658 -0.040125)
     )

;;; 59 odd -------------------------------------------------------------------------------- ; 7.681
#(59 9.955 #(0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0)
     9.6750946044922 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1)
     9.5173864364624 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     7.643378 #(0.000000 1.756964 0.515006 1.343849 0.363765 0.378549 0.312840 0.835322 1.267171 0.687404 0.005918 1.887716 1.613832 1.301738 0.410797 1.416006 0.747219 1.294673 1.478405 1.859201 1.711376 0.584699 0.070707 1.974769 0.292569 1.523774 0.763544 0.102772 0.215383 1.156123 0.808543 1.393270 1.010094 1.412165 0.836472 0.254670 0.922440 0.933923 -0.075272 0.189433 1.079606 0.702089 1.223734 1.404309 0.456849 1.626797 1.979675 1.029592 1.497623 1.325369 0.651798 1.380466 0.242519 0.739915 1.552026 1.160547 0.760069 0.930698 1.441945)
     )

;;; 60 odd -------------------------------------------------------------------------------- ; 7.7459
#(60 9.8824768066406 #(0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 0)
     9.6560277938843 #(0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     7.715763 #(0.000000 -0.042788 0.602795 1.680148 0.721955 0.364027 0.894513 0.761479 0.236381 0.801451 0.176852 0.981725 -0.083622 1.720521 1.748351 -0.096212 1.639998 0.247099 1.225553 -0.461897 1.486616 0.276795 0.759617 1.138466 1.798696 0.004884 -0.171091 1.515113 0.231143 1.285422 1.222896 0.402531 0.319870 1.799104 0.412826 0.132684 1.801011 1.618575 0.483378 0.284155 0.129012 0.861247 1.811542 0.663827 1.221591 1.622984 1.428996 0.559001 0.101540 0.992031 -0.090308 1.103974 1.349687 0.436834 -0.074972 1.609682 0.062500 0.865222 0.678405 0.566972)
     )

;;; 61 odd -------------------------------------------------------------------------------- ; 7.8102
#(61 9.9989261627197 #(0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1)
     9.9643812179565 #(0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1)
     9.8069976254571 #(0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0)
     9.6689287776524 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     7.785940 #(0.000000 -0.344035 0.780624 1.808341 0.250309 0.511377 0.080614 1.156775 0.820476 0.392090 -0.519581 1.679294 0.562126 0.124871 0.037611 1.745936 1.825676 1.086555 1.688053 0.704340 0.270700 1.402108 1.232848 0.487597 1.474823 -0.284646 0.795967 1.369438 0.657817 0.974474 1.000398 0.177017 1.023875 0.864966 0.405700 0.718453 0.072830 1.456422 -0.479406 0.735547 1.217599 0.812412 1.022836 0.830688 1.510230 1.175223 1.640030 0.780812 -0.009698 1.223518 -0.208985 0.133118 0.651112 1.217323 -0.447806 0.092414 -0.063668 0.675161 0.911236 0.947342 0.780516)
     )

;;; 62 odd -------------------------------------------------------------------------------- ; 7.8740
#(62 10.200 #(0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     10.048614501953 #(0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1)
     9.8772821666628 #(0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     9.7982149124146 #(0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     7.891149 #(0.000000 1.929331 -0.207575 0.209516 0.624559 0.267198 1.321555 1.068265 1.407681 0.778581 0.099066 0.009343 0.067733 1.329605 0.739347 0.477321 0.224418 0.312823 0.694599 0.223703 -1.576068 1.876628 0.230800 0.021252 -0.011217 0.439086 0.854765 0.242757 1.218830 0.336949 1.261716 1.233291 1.276732 0.841813 0.687844 1.202436 1.463589 0.087940 0.164344 0.101904 1.216907 1.443441 0.202264 0.609456 1.327615 0.491272 0.968046 1.334730 -0.148011 0.779857 0.507964 1.546633 0.230827 1.481722 1.399818 0.885287 0.030673 0.974490 0.947480 0.430643 1.592583 0.855830)
     )

;;; 63 odd -------------------------------------------------------------------------------- ; 7.9372
#(63 10.203475952148 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     10.191082449969 #(0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     9.8550319671631 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     7.922612 #(0.000000 1.542207 0.163798 0.899691 0.637697 0.564752 0.365357 0.716048 0.996810 0.982500 1.731288 -0.005293 -0.038408 0.478090 1.213103 0.363702 0.362237 1.295278 0.318722 1.028975 1.826409 0.464993 1.857240 0.877690 0.875154 1.527304 0.964893 0.056771 0.647930 0.623841 0.899321 0.141916 0.661435 1.535736 -0.126261 1.889924 1.092416 1.583640 1.493200 1.613142 1.801427 1.485352 0.831148 0.156522 1.814154 0.038239 1.842321 1.003502 1.461179 0.605234 0.807007 1.230316 0.117303 -0.111077 1.332244 1.156262 0.885634 0.161495 1.406960 0.709890 0.438698 -0.048522 0.645487)
     )

;;; 64 odd -------------------------------------------------------------------------------- ; 8
#(64 10.559404013831 #(0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0)
     10.301 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1)
     10.113667488098 #(0 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1)
     10.022200584412 #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1)
     10.0 #(0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     8.063789 #(0.000000 1.101099 0.602034 0.782491 0.697303 0.953568 1.029560 0.116167 0.534482 0.056839 1.177875 1.130699 1.283612 -0.059984 0.623810 0.344036 0.995635 0.096315 1.454462 0.914478 0.627848 0.663044 0.895985 0.021578 0.525686 -0.656147 0.794994 0.316795 1.350578 0.539610 1.703530 0.953234 0.770323 0.217282 1.058758 1.203159 1.048775 0.409086 1.090816 1.638682 0.456816 -0.128952 -0.103400 0.536416 1.625188 0.267460 0.387143 0.504877 0.640085 1.600063 -0.276082 -0.015244 -0.472943 1.570136 0.279373 0.427984 1.349728 1.459025 0.789425 1.021546 0.125635 1.434044 0.285470 0.750018)
     )

;;; 65 odd -------------------------------------------------------------------------------- ; 8.0622
#(65 10.517309434908 #(0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)
     10.169842720032 #(0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.061048 #(0.000000 1.508366 1.430332 1.699997 1.492723 1.176678 -0.085967 1.274172 0.252364 1.458142 1.108682 0.407453 0.080074 0.496489 0.796128 1.695778 -0.024250 0.136111 0.279253 0.562551 1.904848 0.035828 1.644128 1.089601 1.406543 1.599810 0.546631 1.597232 0.711357 1.188022 1.733134 0.232973 -0.310849 0.361620 1.811066 1.255443 1.605577 1.266241 1.411137 0.031757 1.063067 0.020623 0.112262 0.128705 0.833962 1.225198 1.258067 0.834653 0.935979 1.724930 0.173648 0.946577 1.523757 1.316491 0.467143 -0.022456 1.779196 1.023992 0.492639 1.783633 0.195480 1.246721 0.547188 0.921084 0.839249)
     8.059555 #(0.000000 1.506567 1.430936 1.699229 1.496412 1.174160 -0.086636 1.274193 0.254991 1.455692 1.109951 0.404660 0.079171 0.495352 0.793321 1.692007 -0.020656 0.132730 0.276631 0.565072 1.907673 0.037340 1.637792 1.095073 1.406227 1.599508 0.540633 1.593653 0.708129 1.189301 1.730239 0.237382 -0.311086 0.358755 1.802391 1.255894 1.611295 1.273693 1.409701 0.035467 1.060410 0.021861 0.109116 0.128215 0.833936 1.223711 1.263019 0.834715 0.935782 1.725644 0.176908 0.941274 1.521408 1.313570 0.469092 -0.024611 1.773309 1.028050 0.492225 1.788475 0.198096 1.243240 0.549821 0.918484 0.842906)

     )

;;; 66 odd -------------------------------------------------------------------------------- ; 8.1240
#(66 10.212840820553 #(0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.153566 #(0.000000 0.869363 -0.091533 0.941432 0.986052 1.125426 -0.057409 0.795399 1.400184 1.711406 0.186956 1.498003 0.080539 -0.059865 0.773910 -0.178187 1.504301 0.926681 0.548657 0.720005 -0.223604 0.799073 0.020366 1.147082 0.188046 1.463937 1.584567 0.471877 1.676180 1.384702 0.721730 0.822471 0.304001 0.063614 1.522924 1.462853 1.672767 0.273243 0.286304 0.101390 0.983166 -0.051074 1.170127 0.350541 0.652766 1.150995 0.633838 0.968498 1.926492 0.004016 1.503618 0.092218 0.784126 1.110639 1.155405 1.697458 1.830947 1.302364 1.335117 1.729380 1.610064 1.132735 0.884437 1.254040 1.523894 0.972972)
     )

;;; 67 odd -------------------------------------------------------------------------------- ; 8.1853
#(67 10.718281745911 #(0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1)
     10.287303318203 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 1)
     10.209677696228 #(0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     8.189482 #(0.000000 0.223835 0.709563 0.361631 1.551719 0.569710 0.892711 0.412471 -0.122532 1.384928 0.920338 0.229931 1.448943 0.172890 0.823530 0.990828 1.509979 1.338332 1.208846 0.787460 0.061898 0.478875 0.981296 1.272732 0.373155 1.666130 0.172923 0.490908 1.701260 -0.223436 -0.153385 -0.210376 1.754388 0.900377 0.534928 0.735691 -0.024560 1.844372 0.982693 1.901761 0.736388 0.462828 1.348703 0.713521 0.867221 1.154715 1.565263 -0.077256 1.621203 0.799836 1.222303 0.052403 0.526227 0.481968 0.153640 0.955669 0.588080 -0.054516 0.786535 0.593333 1.327174 -0.007899 0.946668 0.129005 0.631564 0.210690 0.355805)
     )

;;; 68 odd -------------------------------------------------------------------------------- ; 8.24621
#(68 10.698028101377 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1)
     10.359804316765 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     8.281859 #(0.000000 0.258667 1.620874 0.995118 0.676139 0.308417 0.272343 0.147405 0.836435 -0.152839 1.426611 0.937133 0.927752 0.924166 0.182892 1.731034 0.348417 0.753629 0.667752 0.794299 1.614483 1.223547 0.464712 0.657833 0.939275 0.647460 1.228364 0.002474 0.223717 0.421852 -0.012520 0.736344 0.401353 0.910747 0.379741 0.389654 1.331939 1.742991 0.697652 1.451290 -0.105555 0.555256 1.630142 0.862676 -0.018948 1.443013 1.399971 1.101246 1.406124 0.923276 1.729179 0.371654 0.256503 1.299125 -0.130973 0.633468 0.022940 1.506254 1.740835 0.021646 0.340195 1.772413 1.080203 0.429734 0.920479 1.371571 0.594032 0.309882)
     )

;;; 69 odd -------------------------------------------------------------------------------- ; 8.3066
#(69 11.012202262878 #(0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1)
     10.744618415833 #(0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1)
     10.636575441359 #(0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1)
     10.452348709106 #(0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.286822 #(0.000000 1.788409 1.282257 -0.243275 0.144332 0.147372 0.582588 1.352720 0.820670 0.189941 1.414000 0.749482 1.059640 1.185143 1.094489 1.016383 0.161516 0.036696 0.497605 0.199194 1.710632 0.158778 0.616819 1.421634 1.168175 0.254077 1.519069 -0.175539 0.581179 0.194080 0.931559 -0.335790 0.288181 1.495548 0.038347 1.508309 0.993101 1.383618 1.230992 0.720738 1.621197 1.080692 0.185939 0.155063 0.909757 1.202469 1.049902 1.890071 0.429591 0.699293 -0.158546 0.279706 1.502937 0.567855 0.587581 0.684816 -0.246769 0.661087 0.986565 1.105766 0.572827 0.606959 -0.158508 0.926574 1.112685 0.938932 0.623827 1.346926 0.670541)
     )

;;; 70 odd -------------------------------------------------------------------------------- ; 8.3666
#(70 11.087729454041 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1)
     10.431521047498 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     8.399369 #(0.000000 1.041809 0.558998 -0.356095 0.410185 0.900684 1.065151 0.079886 1.674079 1.324525 1.821960 -0.126729 -0.122480 0.934871 -0.019438 -0.259186 0.281052 0.398346 0.793651 -0.106925 0.074709 0.543314 0.801611 0.974564 0.830604 -0.322194 1.089920 0.719797 0.373809 -0.416539 0.459879 0.707878 0.458655 1.815417 1.450694 1.417860 -0.172227 1.250917 0.620934 0.936718 1.279287 0.582055 1.291883 1.822360 0.417697 1.819451 0.644713 1.510927 0.229612 1.474653 0.670958 0.275604 1.324073 1.274402 0.946809 1.379872 -0.425068 -0.128081 1.162357 1.062375 0.760342 0.799273 0.040479 0.941652 1.525445 1.141700 0.969630 1.236806 0.049996 0.718550)
     )

;;; 71 odd -------------------------------------------------------------------------------- ; 8.4261
#(71 11.111848131381 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1)
     11.002258540604 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0)
     10.642364501953 #(0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

     8.541593 #(0.000000 1.150800 0.819749 1.817260 0.048338 0.091544 -0.104801 1.666739 0.337108 0.760948 1.048973 0.847544 0.906590 0.771904 -0.232669 0.326183 1.055043 0.431547 1.555969 1.151006 1.042602 1.490831 1.782314 1.814895 1.491400 1.633261 0.545374 1.434019 0.824792 0.377083 1.083599 1.663544 -0.095491 0.732024 -0.127172 1.133691 1.569703 1.866951 0.031424 1.044088 0.967606 0.316881 0.979726 1.371063 1.794211 1.959673 1.163907 1.055961 1.222295 1.332223 0.763739 1.076291 1.208215 0.508678 1.406338 0.467600 1.108826 -0.198739 0.881260 0.164423 -0.064009 0.940984 1.242573 0.691971 1.904269 0.266421 1.896901 1.532336 1.394545 0.440274 1.833757)
     )

;;; 72 odd -------------------------------------------------------------------------------- ; 8.4853
#(72 11.026193997702 #(0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.912703440154 #(0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.880306243896 #(0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     8.408665 #(0.000000 1.541809 0.629466 0.212985 0.788394 1.625797 1.036747 1.209372 0.183595 1.196021 0.197911 0.833169 1.863044 0.788232 1.448495 1.754541 1.046127 0.264356 1.619024 0.031528 0.337193 0.817939 0.442935 0.629571 0.945778 1.180796 0.877750 1.938366 1.458576 1.071268 0.686001 0.018154 1.664772 0.012857 0.408420 1.581115 0.681135 0.503304 1.109810 1.445383 0.022700 0.742039 0.894786 0.312744 0.806903 0.783433 0.095851 1.109687 1.972334 1.053198 0.829046 1.341612 0.404192 1.343656 0.826348 1.067777 1.088739 1.006309 0.614392 0.295571 0.715215 1.330283 -0.010606 0.246451 -0.008320 1.326299 1.019504 -0.529600 0.313140 0.270857 0.028147 1.879938)
     )

;;; 73 odd -------------------------------------------------------------------------------- ; 8.5440
#(73 11.087996391987 #(0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1)
     10.907942771912 #(0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     8.577606 #(0.000000 1.468120 0.399577 -0.018267 1.129749 1.540112 0.080443 -0.225521 0.984350 1.318256 1.725963 -0.015940 0.240457 1.585666 0.066646 0.456005 0.751053 1.114533 0.580701 1.657836 0.496435 0.433822 1.298768 0.600415 -0.190098 0.064658 0.103847 1.339139 1.507511 0.087123 1.469545 1.406973 0.042591 0.416789 0.070338 0.413098 0.972952 0.584179 1.008661 1.214009 0.655088 0.742369 0.248321 0.571683 -0.200036 0.424291 0.202007 1.422478 0.685909 1.132358 0.366535 0.103301 0.284148 1.188052 1.256745 0.599482 0.119285 -0.134695 -0.000187 0.303508 1.738552 0.317055 0.701322 -0.250651 1.419996 1.135309 0.264805 1.507796 0.275630 0.983246 0.282234 1.603893 0.010492)
     )

;;; 74 odd -------------------------------------------------------------------------------- ; 8.6023
#(74 11.4198214166449 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0)
     11.288741871055 #(0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0)
     11.262331896     #(0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     8.505770 #(0.000000 0.271959 0.303263 0.871130 0.904134 -0.104703 1.438323 1.380312 0.153606 0.874000 1.112738 -0.381121 1.128821 1.800391 0.271558 0.179924 1.245144 0.340659 0.429014 0.985023 0.709222 1.205236 1.196024 0.193210 0.875814 1.373206 -0.208581 0.550691 0.133632 0.785455 -0.009102 0.272459 0.666791 1.782681 1.718095 1.685691 -0.371908 1.897876 1.085596 1.690614 0.839009 1.371639 0.648809 -0.333122 0.227967 1.542904 0.506314 0.141899 1.120242 1.221884 1.118539 0.201184 1.273447 0.940438 0.135993 1.603620 1.099885 1.279633 1.766033 1.155852 1.376417 1.081428 0.676161 0.039331 1.365221 -0.352489 1.294597 1.006846 0.055171 0.246691 -0.270644 0.094155 1.572455 0.920094)
     )

;;; 75 odd -------------------------------------------------------------------------------- ; 8.6603
#(75 11.202813597023 #(0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1)
     11.190553665161 #(0 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1)
     10.942812919617 #(0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     8.680714 #(0.000000 1.126601 1.812577 -0.049283 0.880856 0.104294 0.936448 0.187889 1.807387 0.806501 1.692539 0.225733 0.931111 -0.039055 0.072619 1.455113 -0.520390 1.351633 1.348783 0.919521 0.090424 0.958242 1.681923 0.026052 0.307171 1.060890 -0.015559 -0.054714 0.350468 -0.001459 0.483274 0.288778 0.923468 0.551417 0.935323 0.561880 0.449271 0.109706 1.826772 0.167464 1.590542 0.787036 1.702119 0.147722 0.973422 1.743575 1.478513 0.022355 0.086239 0.313946 0.874175 1.082332 1.227802 0.298008 1.809070 0.263482 1.603211 1.915129 0.777065 1.751432 0.098876 -0.024717 0.979204 0.775157 0.240589 1.634357 1.242907 0.865232 -0.290454 1.535688 1.411996 0.569355 0.736760 0.957638 0.019325)
     )

;;; 76 odd -------------------------------------------------------------------------------- ; 8.7178
#(76 11.511628975629 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0)
     11.446428749262 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0)
     11.21743106842 #(0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     8.691930 #(0.000000 0.227276 0.852463 0.798261 1.206049 0.469874 1.014414 1.056681 1.488890 0.859453 1.672754 0.409646 1.266606 0.221296 1.159074 1.002170 0.608039 0.458947 1.540083 0.022303 0.493105 0.973576 0.879272 0.834550 0.404380 0.486092 0.947824 1.355887 0.257317 0.846067 0.109915 1.425777 0.555724 0.041354 1.723813 1.397993 0.430583 0.879698 0.485460 0.867599 0.227712 0.037324 1.528474 0.162632 1.848376 1.951430 0.307077 1.592204 0.961903 0.990102 0.524891 0.905010 -0.015454 1.132349 0.700305 0.574546 1.532296 1.008896 0.469612 0.935083 1.895638 0.275404 0.376082 1.374586 0.447984 1.724017 1.362390 0.115529 0.873605 0.708290 1.589815 1.522961 1.650538 1.546135 0.099896 0.795639)
     )

;;; 77 odd -------------------------------------------------------------------------------- ; 8.7750
#(77 11.623893901139 #(0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.38523739395 #(0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1)
     11.302083969116 #(0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.192246437073 #(0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     8.738911 #(0.000000 1.735390 1.596183 1.688158 0.936460 1.171580 0.505377 0.087525 1.862148 1.431401 0.594847 0.469813 0.196922 0.535307 0.536063 0.953652 1.327262 1.042995 -0.239454 1.283974 0.373825 -0.231495 0.842073 1.180351 -0.200754 1.452179 0.278091 1.438428 0.651650 0.579116 1.359926 1.185874 0.646945 0.889845 1.929037 0.820540 -1.753498 0.788440 0.134659 -0.052264 0.029418 0.734290 -0.032548 0.116885 1.060915 1.618492 0.727618 -0.211968 1.156442 -0.079189 0.326736 0.907689 -0.005226 0.152753 0.054647 1.883310 1.223284 -0.341320 -0.253047 0.094276 0.965735 0.643481 0.075505 0.256644 -0.263207 1.005258 0.117913 1.054554 1.077316 1.857353 0.229976 0.488605 0.099240 0.563812 1.742434 0.311603 0.824202)
     )

;;; 78 odd -------------------------------------------------------------------------------- ; 8.8318
#(78 11.455265310659 #(0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     8.802318 #(0.000000 1.670624 0.812122 0.146846 0.294174 0.693556 0.587537 0.634781 1.067651 0.436186 1.879310 1.122795 0.875431 1.177280 0.081581 -0.171779 0.307696 -0.040349 1.123589 0.453417 0.838454 0.781236 0.260980 0.086805 -0.163582 0.675514 0.678636 0.987481 0.002829 -0.141018 0.519002 0.397540 0.841714 1.116573 -0.056209 0.665263 0.588230 0.601360 1.262779 0.489363 0.951797 1.844032 1.183466 1.520023 0.226265 1.028907 1.744367 1.798831 0.850890 1.303993 1.629043 0.218880 -0.013397 0.760540 0.223307 0.242187 0.497769 1.705174 -0.220494 1.417201 1.258808 -0.026975 1.662089 1.392477 1.011251 0.392762 1.200206 -0.223742 1.247356 0.076980 1.596406 0.650646 1.163958 0.226439 1.049893 0.648772 0.668638 0.239788)
     )

;;; 79 odd -------------------------------------------------------------------------------- ; 8.8882
#(79 11.710210993982 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)
     11.54291004024 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     9.019300 #(0.000000 0.161159 0.069766 1.245082 -1.663996 1.132454 0.793379 0.236735 0.199520 0.768958 0.690238 1.070772 1.318977 1.196527 0.174596 1.494555 0.315415 0.025691 1.304467 1.618472 0.201499 1.335994 0.229519 0.715032 0.631996 0.002248 1.222420 1.376248 1.054293 0.790825 1.192140 1.232103 -0.120973 0.966026 1.061828 1.346696 0.759767 1.112226 0.017812 0.267345 1.182142 0.834654 1.669569 0.189431 1.572185 1.413667 -0.121426 0.959040 0.405245 1.021485 0.075605 0.638948 1.449329 1.313878 1.374454 1.847087 0.376677 0.367060 1.346860 0.315156 0.360571 0.056967 1.209722 1.397062 1.155088 0.087380 1.151101 1.112584 0.549660 1.007032 0.610121 0.708874 -0.071285 0.985505 1.339651 0.986339 0.354263 1.605654 1.163052)
     )

;;; 80 odd -------------------------------------------------------------------------------- ; 8.9443
#(80 12.0 #(0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 0 1 0)
     11.963202476501 #(0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1)
     11.681501776885 #(0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1)
     11.501195907593 #(0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1)
     11.122416496277 #(0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     8.975296 #(0.000000 0.661832 0.582609 1.535343 0.368813 1.442670 0.288143 1.720507 1.159325 1.205434 0.363832 1.135859 0.398801 0.780442 0.109059 -0.233851 -0.014242 0.866814 1.170313 0.571895 1.728338 1.048867 0.573378 0.186444 0.762977 -0.042956 0.166725 1.469320 0.668773 1.299568 0.889649 0.040495 1.240631 1.108944 0.129800 0.721144 1.067299 -0.108522 0.942423 0.143182 0.363181 1.503391 0.483014 0.839084 -0.130151 0.311957 0.853400 1.290713 1.419147 0.872778 0.357362 1.159105 0.470178 0.822707 0.086509 1.527850 1.188547 0.499837 0.491618 0.911131 1.381265 1.436439 0.098022 0.967860 0.602227 0.287322 0.505081 0.825983 1.366303 1.496619 1.659715 1.944169 -0.046671 -0.166435 1.699946 0.102851 -0.189778 0.020478 -0.353821 1.052153)
     )

;;; 81 odd -------------------------------------------------------------------------------- ; 9
#(81 11.757609887857 #(0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     11.553661099057 #(0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.381307601929 #(0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.372210502625 #(0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     8.978751 #(0.000000 0.133442 -0.323272 0.060725 1.114679 1.473804 0.089264 1.010184 0.354571 0.798241 0.627718 0.594956 1.616426 -0.067445 0.370170 1.433443 0.999941 0.878691 0.506811 0.816927 0.341781 0.470013 1.141387 0.832036 -0.171466 0.461911 0.937434 1.074597 0.837015 1.318765 0.967657 1.380005 1.862128 0.913359 0.586701 1.759303 0.626415 0.695822 -0.190484 1.006634 1.203431 1.266834 1.197949 1.077990 -0.267729 0.380595 1.150154 0.478725 0.254873 0.362966 0.458333 1.811543 0.623044 0.209843 0.719689 -0.056221 -0.112031 1.630512 1.109177 0.215435 1.027013 0.440511 1.281860 1.500481 1.406261 0.066775 0.100497 1.059738 1.020731 0.214321 0.289590 1.768407 1.382768 0.561941 1.958539 0.543300 0.720294 1.004120 -0.043334 1.455233 0.853445)
     8.971173 #(0.000000 0.165964 -0.332368 0.095032 1.113835 1.477554 0.048470 0.968877 0.356615 0.800883 0.559051 0.628419 1.655588 -0.060876 0.399064 1.427436 0.993697 0.889604 0.491602 0.829035 0.277560 0.479197 1.156812 0.791521 -0.182754 0.472938 1.044843 1.030947 0.834547 1.320463 0.962333 1.341133 1.827974 0.900057 0.567890 1.763823 0.595134 0.726953 -0.173747 1.026065 1.173955 1.251663 1.162843 1.098519 -0.231364 0.339211 1.117788 0.483642 0.235268 0.349440 0.417766 1.840309 0.597943 0.230220 0.759085 -0.031860 -0.083280 1.606657 1.102498 0.182912 1.023705 0.395602 1.226548 1.515585 1.411521 0.032873 0.125577 1.047541 0.968752 0.206700 0.324817 1.716705 1.376237 0.541299 1.922109 0.489264 0.716228 0.988114 -0.002797 1.468316 0.877334)
     8.965146 #(0.000000 0.157785 -0.337569 0.096082 1.113781 1.481130 0.050315 0.964830 0.361216 0.799333 0.564109 0.631996 1.649820 -0.058859 0.397625 1.431965 1.000146 0.890385 0.496135 0.828876 0.277506 0.473809 1.158894 0.793359 -0.186463 0.471469 1.044774 1.030059 0.838220 1.319150 0.971449 1.337313 1.828530 0.902746 0.567640 1.760111 0.598321 0.727176 -0.172927 1.023308 1.177523 1.260867 1.159511 1.096029 -0.231904 0.343809 1.114711 0.485790 0.235817 0.347667 0.419033 1.841228 0.604892 0.224864 0.759150 -0.038129 -0.082169 1.601239 1.102395 0.182980 1.014301 0.398467 1.216854 1.512488 1.412349 0.031091 0.125166 1.047132 0.965134 0.198968 0.325467 1.717291 1.372625 0.540616 1.927737 0.491565 0.717616 0.985970 -0.006426 1.465646 0.877033)
     )

;;; 82 odd -------------------------------------------------------------------------------- ; 9.0554
#(82 11.815696616621 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0)
     11.662058134504 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     8.933115 #(0.000000 1.655107 0.927329 0.700795 0.457132 1.597872 1.395917 1.102981 0.596990 -0.016731 1.092179 0.627854 1.701854 0.497355 1.600745 1.504817 0.495291 1.318902 0.045404 0.439554 0.214034 1.553649 0.387340 0.180328 0.040236 -0.037259 1.860370 -0.113122 1.129908 0.256707 0.501339 0.490075 1.737864 0.156328 -0.060599 1.880493 0.094243 0.914901 1.035747 -0.249487 -0.261922 0.194073 1.531862 0.598732 0.595561 1.065045 -0.109930 1.766348 0.894342 0.107102 0.929672 1.741212 0.707310 1.316903 0.785406 1.149732 0.365654 1.226668 1.759193 0.569366 0.694260 1.400840 0.193799 1.827338 0.067882 1.572894 1.496590 0.077974 0.264873 0.871791 0.550972 -0.351950 0.923610 0.854268 1.029357 1.471117 1.058594 -0.125090 0.289083 0.507228 0.301881 -0.036184)
     )

;;; 83 odd -------------------------------------------------------------------------------- ; 9.1104
#(83 12.05688291879 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.795211509729 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.732900669843 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     9.098442 #(0.000000 0.839572 1.074098 0.324921 0.180873 1.518224 1.071608 0.572848 1.544103 0.208707 0.988181 0.862080 0.497301 0.425505 1.602983 1.012766 0.625086 1.316448 1.725429 1.471562 0.661237 -0.273288 0.850910 0.216989 0.065921 -0.124476 0.473030 0.376843 1.370353 0.617187 1.623533 0.049665 1.611932 1.386692 1.955490 0.505504 1.447189 0.240009 -0.006708 0.166903 -0.255242 1.834944 0.654286 1.229426 0.040813 0.641985 -0.009213 1.031854 0.749665 0.718158 1.006079 0.824983 0.065384 1.285071 1.646733 0.911415 1.196057 0.818339 0.060266 0.752603 0.606354 0.685039 0.915633 -0.158850 1.743393 0.020574 0.625319 0.683486 1.837454 0.549326 0.109589 1.286323 1.331894 0.025378 0.994511 0.565370 1.200207 0.756063 0.841852 0.838865 0.818311 1.724021 0.197827)
     )

;;; 84 odd -------------------------------------------------------------------------------- ; 9.1652
#(84 12.003616535189 #(0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.724502770898 #(0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.626023292542 #(0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     9.245308 #(0.000000 -0.022386 -0.034020 1.193790 1.856689 0.854072 0.609652 1.884327 1.829708 0.113960 0.487663 0.956243 -0.022811 1.040095 1.801723 1.236395 1.099749 0.829399 0.586688 0.423356 0.575383 1.305429 1.598561 -0.469272 0.806756 1.756472 1.565013 0.492062 0.454835 0.881162 1.611034 0.291762 1.836746 1.897946 0.859434 0.225589 1.134259 1.550560 0.957476 1.242614 1.010885 1.738761 1.513009 1.043021 0.785256 0.640362 0.038521 0.653287 0.491770 0.893103 0.093490 1.078712 0.305494 0.539580 0.250907 0.067448 0.931355 0.460356 1.125480 1.040505 0.731210 0.971446 0.282669 0.305820 0.966683 0.069620 -0.452859 0.515153 0.545253 0.309687 1.254442 0.901368 1.434540 1.402385 0.238670 1.111178 1.265517 0.167381 1.409177 1.880033 0.342066 1.131503 1.390013 0.428253)
     )

;;; 85 odd -------------------------------------------------------------------------------- ; 9.2195
#(85 12.48290348053 #(0 1 1 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     12.309050256429 #(0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     11.829360154975 #(0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     9.353589 #(0.000000 1.062584 1.974507 0.608443 0.359786 0.411786 1.661456 -0.028715 0.210937 0.873240 -0.059884 1.657858 1.581829 1.238215 0.536159 1.437517 -0.031102 1.293736 1.866925 0.834699 -0.375618 1.277667 0.903381 1.153848 1.876213 -0.444848 0.884017 0.277843 0.770722 1.710188 1.570201 0.627960 0.896388 1.326751 1.064012 0.342962 1.448176 0.981887 1.749804 0.392723 -0.401994 1.686496 1.545365 0.549190 1.373092 1.132788 0.680954 1.375558 0.681657 0.407214 0.845644 0.198826 1.051408 1.109983 -0.149865 0.022369 1.355476 1.413985 0.178634 1.766333 0.534910 1.614543 -0.059502 1.003867 0.316441 0.599270 1.040099 0.395452 0.092270 0.153942 0.548461 0.755956 1.371414 1.087311 0.323880 0.319537 0.299601 -1.847088 1.101468 1.070178 1.120305 0.670136 1.280313 1.530576 0.114287)
     )

;;; 86 odd -------------------------------------------------------------------------------- ; 9.2736
#(86 12.300269991896 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.274354058598 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.140432277993 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     9.369202 #(0.000000 0.690847 0.435567 1.661993 0.032663 0.687180 0.812094 1.173851 0.708541 0.222602 -0.090265 0.404572 0.661039 0.503125 0.785276 -0.086765 1.769265 -0.445888 0.442740 0.295442 1.355114 1.682798 1.397603 0.358491 0.511162 1.716320 0.570354 0.943485 0.812222 -0.037500 0.810940 0.989531 1.427548 0.211543 1.498144 0.834814 0.338673 0.566457 0.202699 0.332424 1.905436 1.143331 1.692301 1.710199 -0.289017 1.271773 0.422650 0.957156 1.397220 0.660571 1.217798 -0.185502 1.075987 0.771979 -0.081937 1.593388 1.957178 0.885990 1.455217 1.184440 -0.052777 0.583620 1.280412 1.804729 1.627707 0.435368 0.098188 0.378794 0.862840 0.203180 0.406522 0.833475 0.276690 0.563495 0.151099 1.703940 0.891087 1.258246 1.221573 0.560354 1.896594 0.705409 0.064671 -0.028632 1.074778 0.585543)
     )

;;; 87 odd -------------------------------------------------------------------------------- ; 9.3274
#(87 12.733045578003 #(0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 1)
     12.481803894043 #(0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1)
     11.937030388359 #(0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

     9.401467 #(0.000000 1.284004 0.784369 1.387463 0.594585 1.403798 0.619627 1.084772 0.963852 0.814530 0.106339 0.227008 1.231747 0.842795 0.694052 -0.291296 0.405925 0.569187 0.767739 1.358815 1.825672 0.200551 1.132871 0.480291 0.800280 0.608803 1.553239 1.365053 0.722494 0.856576 0.946966 1.591187 -0.059040 1.033606 0.474244 0.412313 0.136109 0.759312 1.576754 1.677523 1.162569 0.892982 0.713765 0.359716 0.651517 0.358747 -0.064433 0.133454 1.080119 0.154469 0.831139 1.144518 -0.565948 1.287001 0.300469 -0.328174 1.225022 0.501021 -0.039512 1.576506 0.418970 1.984225 0.200258 1.748909 0.768382 1.405825 0.669027 -0.283931 -0.075376 -0.636660 1.585905 0.363904 0.579985 1.231522 0.359706 1.078442 0.091968 0.210537 0.891673 0.243248 0.318340 0.696129 0.838218 1.272772 0.628451 -0.269209 1.151461)
     )

;;; 88 odd -------------------------------------------------------------------------------- ; 9.3808
#(88 12.652858832418 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.592202186584 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.128922775356 #(0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     9.362779 #(0.000000 0.681645 1.163660 1.604653 0.926177 1.494322 1.667665 0.428912 1.245419 1.083493 0.646306 0.142474 0.695823 0.361247 1.314223 0.429959 1.041853 0.018046 -0.263056 1.388308 0.213024 -0.052374 1.027779 1.541942 0.920197 0.494462 0.928151 1.251070 0.659378 1.829797 1.647098 0.605452 0.536814 0.584307 1.958467 1.325241 -0.036330 0.607110 0.312494 1.499524 0.798528 0.764225 1.809708 1.849122 0.055449 0.205015 1.423975 0.832908 1.772103 0.171243 0.248262 1.402249 -0.207218 1.623431 0.971277 0.947412 1.582890 1.199284 -0.469197 1.516955 0.460100 0.124993 0.397229 1.341536 0.129319 1.139501 1.017161 0.476992 1.346307 0.692740 1.368201 -0.028836 0.987126 1.183889 1.342213 1.888932 1.448133 1.459984 1.545166 -0.483435 0.120724 0.464878 -0.027124 1.001637 -0.052796 -0.082513 1.673331 1.656979)
     9.357807 #(0.000000 0.682501 1.162196 1.607243 0.923368 1.500790 1.665167 0.423783 1.241977 1.082832 0.652346 0.139065 0.693780 0.361655 1.314060 0.429686 1.044727 0.018416 -0.262062 1.385861 0.213081 -0.050710 1.023438 1.537391 0.917202 0.500967 0.929020 1.252568 0.661156 1.827682 1.649011 0.609423 0.533363 0.588363 1.956856 1.323611 -0.037346 0.605867 0.312292 1.499308 0.801905 0.768883 1.816103 1.847427 0.052104 0.199567 1.425165 0.836947 1.772849 0.174547 0.247998 1.403683 -0.203154 1.623312 0.976149 0.949488 1.586650 1.202295 -0.465206 1.517399 0.464953 0.126637 0.404041 1.338772 0.127160 1.140423 1.017419 0.475091 1.341124 0.692778 1.366883 -0.028308 0.989471 1.186861 1.344455 1.891134 1.447018 1.465865 1.546134 -0.476967 0.121049 0.468526 -0.025194 0.998472 -0.059019 -0.082577 1.674035 1.662826)
     )

;;; 89 odd -------------------------------------------------------------------------------- ; 9.4340
#(89 13.0 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.521632157997 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.4725522995 #(0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0)
     12.362 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     9.371039 #(0.000000 0.052164 0.791440 0.153379 0.457421 0.764709 0.344095 1.215170 0.137176 0.742700 0.617685 -0.056848 0.488425 1.545640 1.033296 0.283781 0.299253 1.173589 1.493969 1.312730 1.238620 1.201371 -0.197907 1.624142 1.448707 1.190661 1.141197 0.513138 1.257808 1.460974 0.166714 1.416680 0.515026 0.549608 0.194228 1.862359 0.901748 -0.041184 0.410307 1.194993 0.672775 1.767488 1.077215 -0.001345 0.910027 1.041064 1.431436 0.572648 -0.148853 1.292321 1.130730 1.285407 1.421754 0.316865 0.362127 0.804375 1.047206 1.727521 1.701721 0.926233 1.327986 0.341603 0.624870 0.318612 1.064166 1.482489 -0.729185 1.289717 0.615903 1.202415 -0.295196 0.390003 0.523490 -0.106831 0.122810 1.150151 0.781113 1.924964 1.300023 0.917810 0.906373 0.873599 1.111591 1.620163 0.842905 -0.090907 0.304747 -0.203133 0.472158)
     9.363759 #(0.000000 0.050284 0.788811 0.148028 0.461869 0.762546 0.341199 1.215651 0.136929 0.744292 0.617197 -0.057988 0.482788 1.546439 1.035153 0.281226 0.300316 1.179529 1.491748 1.311672 1.235945 1.202031 -0.193742 1.626401 1.449336 1.190453 1.141346 0.513921 1.261914 1.457953 0.166064 1.416523 0.513217 0.549082 0.198012 1.862676 0.901609 -0.042948 0.406153 1.195130 0.670863 1.768180 1.075024 0.002503 0.904856 1.039857 1.429290 0.573621 -0.147210 1.289936 1.125767 1.281270 1.414173 0.316542 0.365392 0.804339 1.044929 1.729141 1.700692 0.922853 1.328440 0.343083 0.626768 0.313483 1.065022 1.484925 -0.727305 1.288553 0.614756 1.199377 -0.291196 0.393887 0.524004 -0.108760 0.125606 1.147217 0.777554 1.930087 1.298401 0.918716 0.899163 0.873822 1.115630 1.614793 0.847146 -0.094237 0.305571 -0.200497 0.468935)
     )

;;; 90 odd -------------------------------------------------------------------------------- ; 9.4868
#(90 13.064256668091 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 1)
     12.44910044225 #(0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1)
     12.309 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     9.510523 #(0.000000 0.758042 -0.054694 0.811880 0.761526 1.962723 -0.083244 1.053429 1.104472 -0.109216 0.937640 1.934646 0.897694 -0.126299 0.506296 0.359410 1.053820 0.091346 0.762136 0.742704 1.389725 0.618145 -0.219023 1.630783 0.754322 0.266215 1.441909 0.620122 0.234893 0.616837 0.660831 1.498764 0.998798 1.035328 1.113532 0.821990 -0.270132 0.795919 1.445665 0.244993 0.731299 0.815056 0.735003 0.920760 1.770960 1.628052 1.555348 1.090727 1.750098 1.453904 1.038033 0.772409 1.025806 1.301509 1.506752 0.390104 0.632396 0.358268 0.682164 0.608589 0.147662 1.018801 1.379351 0.167187 0.413327 0.954108 0.835458 1.961105 1.093313 0.141085 0.089670 0.098091 1.305209 1.482012 1.810606 0.378853 0.174115 1.905916 0.832232 0.069140 0.579561 0.064074 1.474377 1.386413 0.673245 0.953543 1.240323 0.412327 0.521503 -0.323035)
     )

;;; 91 odd -------------------------------------------------------------------------------- ; 9.5394
#(91 13.107619285583 #(0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.7095674403 #(0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.351367950439 #(0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     9.498124 #(0.000000 0.118934 0.976382 0.956629 1.780105 -0.107456 1.019361 0.175914 0.741140 0.251416 0.790076 0.044608 0.014574 0.966507 1.078247 0.142810 1.331883 1.293944 0.056077 1.701154 0.759816 0.115830 0.013540 0.241465 1.237122 0.575869 1.490284 1.467118 1.675070 1.533483 -0.029528 0.597987 1.208289 1.748374 0.671710 0.278157 1.027836 1.553754 0.987408 0.705593 0.994368 0.814594 -0.100347 1.577161 0.998568 1.354213 1.548636 0.647426 0.469848 1.058319 1.214054 0.322619 0.307766 0.073965 0.545128 0.857572 0.850667 -0.138224 1.397563 1.226412 0.886276 0.689613 0.513251 0.964828 0.771369 1.747221 0.993690 1.414120 0.483867 0.952219 -0.051091 1.852698 1.054403 -0.194321 0.696073 1.144048 1.170117 1.664198 1.342898 0.816425 -0.188791 1.188138 1.716658 1.046739 1.176059 0.630993 1.599971 0.434169 0.259980 0.374898 0.167772)
     )

;;; 92 odd -------------------------------------------------------------------------------- ; 9.5917
#(92 12.42142723142 #(0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1)
     12.280749613899 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     9.613561 #(0.000000 1.195059 1.362395 0.986366 0.469363 1.849732 0.290819 1.690089 0.555921 0.939760 0.652949 0.353178 -0.160197 0.872041 1.529798 0.986887 0.337479 1.912491 0.646959 1.345115 0.151452 1.693405 0.190200 -0.325263 0.688990 0.842862 0.815658 0.501892 1.048134 1.222943 0.504398 1.155413 1.134376 0.068018 0.267625 1.680937 0.740675 0.018949 1.456261 0.787843 0.429982 1.185607 0.284832 1.274080 0.986734 0.731814 1.599552 1.438673 1.027205 0.617832 0.038555 1.319619 0.610444 0.872406 1.036168 1.608077 0.072070 0.653754 1.669643 -0.057939 0.341627 1.099607 1.495806 0.822784 1.445625 1.098296 1.015431 0.673892 0.597742 1.230627 1.594110 0.893882 1.277317 0.819111 0.857476 -0.102787 0.908854 1.709922 1.624293 1.835198 0.323291 0.514053 0.799858 1.413987 0.514276 0.385889 0.129801 0.506999 0.082078 -0.052444 1.883975 0.626354)
     )

;;; 93 odd -------------------------------------------------------------------------------- ; 9.6437
#(93 13.111316272074 #(0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1)
     13.078753471375 #(0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0)
     12.587555885315 #(0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1)
     12.403578299298 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     9.810287 #(0.000000 1.382668 1.243353 0.636666 -0.151107 -0.123410 1.012632 1.312932 0.928141 1.060906 0.383502 0.947029 0.779837 1.837824 1.490236 1.464059 0.494745 1.219370 1.705329 1.081833 1.577099 0.181115 -0.193863 1.527972 0.808998 1.193860 0.513458 0.492047 0.187339 1.385386 1.515433 -0.351631 -0.075836 0.224044 -0.130670 0.950228 -0.122472 0.505185 0.220758 0.150082 -0.030986 0.913370 0.253451 1.722138 1.593770 -0.106682 -0.269173 0.696003 1.901164 -0.023873 1.855193 0.750524 -0.159070 0.680441 0.962047 1.362624 0.340514 1.240511 1.644448 0.444047 0.761721 1.163434 1.745395 1.835743 1.246482 1.443121 0.887046 1.757683 0.717973 1.442810 0.333846 0.080834 1.051159 0.429623 0.193637 0.669194 -0.202474 1.426352 0.096096 0.086347 0.882197 0.952706 1.632119 0.880258 1.335484 1.138581 1.570907 1.752019 0.811544 0.189400 1.275926 1.342454 0.928862)
     )

;;; 94 odd -------------------------------------------------------------------------------- ; 9.6954
#(94 12.792093608509 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)
     12.789479876738 #(0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     9.914588 #(0.000000 1.404079 0.868486 0.903366 0.647440 0.613857 1.105620 0.388893 0.925199 0.321097 0.786415 0.523127 1.451463 1.693706 0.651392 -0.380909 1.409388 0.690612 0.938269 0.060945 1.092352 -1.834885 0.446355 1.611961 0.172263 0.109544 0.647103 1.315760 0.049100 0.421276 1.541181 0.248393 -0.121462 0.585171 1.247169 0.130262 0.554817 0.433063 1.288062 1.031498 0.904607 0.816196 0.784263 0.849636 0.993527 0.839632 0.055463 -0.089672 1.159332 0.237630 0.758283 0.378928 -0.099545 0.421969 1.323635 0.046332 0.242762 0.825323 0.668596 0.121355 1.641007 1.348688 0.655775 1.371453 -0.038818 1.427391 0.566096 1.070549 1.128903 1.892132 0.143892 1.663685 -0.128715 1.593448 0.371091 0.372388 0.877098 1.512461 1.109588 -1.925750 1.807295 1.333356 -0.076069 1.296738 1.508460 -0.001619 0.929748 0.715531 0.578474 1.131416 -0.127307 1.675263 1.505844 0.766245)
     )

;;; 95 odd -------------------------------------------------------------------------------- ; 9.7468
#(95 13.132 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.981590594561 #(0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.858592033386 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.575266058635 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     9.759032 #(0.000000 1.309098 0.071180 -0.377583 1.646652 1.511271 0.880558 1.131678 1.484648 0.347506 1.016090 1.375391 1.791469 1.152164 0.640668 0.984507 0.288748 0.282607 0.357342 1.199975 0.158823 1.656561 1.087584 0.337190 0.734922 0.206711 0.111368 0.847865 1.407362 1.303035 0.617484 0.219901 0.330128 1.758324 0.867133 1.048814 0.109266 0.597755 1.437489 1.198999 0.827527 1.785798 1.134349 0.847789 0.773323 0.404679 1.701846 1.238288 1.056568 1.457949 0.146495 0.634327 0.742044 1.074979 0.854002 1.618767 -0.122548 0.085939 -0.363818 1.696344 1.000094 -0.195199 1.100203 -0.106685 1.148562 0.037459 0.871241 1.501971 0.077203 0.087676 1.193774 0.997578 0.261330 0.965766 0.659686 0.879158 0.746089 1.138613 1.366118 1.541178 0.064597 1.433977 1.914626 1.180824 -0.171280 -0.302879 1.288160 0.460012 1.360169 1.185586 0.551817 -0.071056 0.992264 1.032411 0.088431)
     )

;;; 96 odd -------------------------------------------------------------------------------- ; 9.7980
#(96 13.232 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     13.00986051659 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     12.956554412842 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)
     12.803173065186 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     9.820715 #(0.000000 0.523402 1.532142 0.243801 0.106164 0.275832 1.007943 0.196524 0.358416 -0.030625 0.563895 1.923854 0.674503 0.982579 1.345472 0.147180 0.332839 0.432304 0.754948 0.011158 0.848272 -0.116697 0.603260 -0.144270 0.326162 1.291107 1.498801 0.338545 0.634648 0.184095 0.342570 1.336318 1.813433 1.547124 1.223931 0.683517 0.796739 0.148679 1.030366 -0.148649 1.701962 1.839480 0.117646 0.371954 0.472104 -0.054507 0.733671 0.839252 1.754926 0.788456 0.612000 0.619025 1.405484 1.139749 1.783870 0.836052 1.745250 1.268802 0.625661 0.680997 0.998985 1.070941 0.594900 0.099003 0.318424 -0.354265 1.227268 0.479697 0.660932 0.578298 1.423659 0.939467 1.271898 0.179075 0.234790 1.215588 1.775984 -0.031035 0.725830 0.222841 1.456295 -0.328575 1.458991 1.431981 1.490232 1.251257 0.033480 1.539365 0.858449 0.480209 1.732804 0.845738 0.316573 1.841290 0.219410 0.925612)
     )

;;; 97 odd -------------------------------------------------------------------------------- ; 9.8489
#(97 13.340280990563 #(0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.954301727663 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.837450993031 #(0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     9.908417 #(0.000000 0.431077 1.515482 0.054320 -0.083060 1.485605 0.284339 1.278973 1.578470 0.517197 1.647412 0.190782 0.762927 0.965430 1.916437 0.969768 0.720572 -0.331541 0.044205 0.743759 0.293286 0.923233 0.598354 0.782102 0.583413 0.678205 0.319384 0.637984 1.466597 0.130734 -0.141766 1.616943 1.791399 0.410783 1.370469 1.176646 0.197182 0.372771 0.580596 0.537403 1.359190 -0.196138 -0.323700 1.708294 0.219663 1.704787 0.532203 1.850438 -0.114427 -0.188949 1.638869 0.545226 1.457448 1.226960 0.724808 1.940971 1.667443 0.960042 -0.004518 0.107150 0.277340 0.648929 1.149626 -0.049493 0.215509 1.729136 0.662507 -0.010818 0.665784 0.560313 0.538803 0.867756 1.720020 1.653110 0.990133 0.727693 0.128193 -0.155102 1.199834 1.697761 0.636433 0.309768 1.364956 1.791368 1.621481 0.886892 0.411810 0.752734 -0.001318 0.587080 0.572992 1.025564 1.526296 0.844584 1.070604 0.597584 -0.110638)
     )

;;; 98 odd -------------------------------------------------------------------------------- ; 9.8995
#(98 13.53905582428 #(0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.128762135265 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.062 #(0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0)
     12.972 #(0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     10.041603 #(0.000000 1.081951 0.822630 -0.045978 -0.256881 0.976452 1.712734 0.884845 0.581899 -0.176025 0.022020 1.701752 -0.036061 1.388371 0.731055 1.602331 0.458696 0.729181 1.545164 -0.123101 1.014594 1.556143 1.119676 0.549522 0.010363 1.665103 1.647772 1.564544 1.540723 0.671888 0.100539 1.209262 1.202402 1.198564 1.275535 -0.138844 0.834634 -0.087258 0.775755 1.032037 0.291503 1.394642 1.041705 0.132007 1.180888 0.351946 0.751443 0.900146 0.441935 0.637009 0.990149 1.283683 1.517584 0.345385 -0.231388 0.130309 -0.397039 1.542670 0.182385 -0.012664 0.118632 0.932819 1.073089 0.714960 0.910068 0.685325 1.708155 0.366179 0.367843 0.740304 1.342496 1.438555 0.680162 0.415164 1.030089 1.216253 0.752964 0.131560 -0.253153 1.122509 1.526881 0.614186 1.361597 1.180983 0.580253 0.708237 1.236459 0.044048 0.833144 0.243361 1.377357 1.611426 1.486604 1.791281 1.790226 0.227751 1.038879 1.572361)
     )

;;; 99 odd -------------------------------------------------------------------------------- ; 9.9499
#(99 13.792359352112 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1)
     13.577017376954 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1)
     13.046126365662 #(0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     13.000000000002 #(0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     10.092286 #(0.000000 0.478281 0.071899 1.466384 1.293247 1.013588 1.134524 0.136028 1.093009 0.660683 1.406627 1.622349 1.493038 1.500850 1.829383 0.427797 0.360839 1.185557 1.004862 0.125271 0.787638 -0.638520 1.078946 1.429592 1.319727 0.009359 1.368205 1.211209 0.452925 1.475569 1.771129 0.129972 0.731886 -0.202610 0.653214 1.384549 0.104576 1.174222 0.977821 -0.078428 1.503237 0.538511 0.568964 1.368289 1.592325 0.470941 1.109048 0.583883 0.421035 0.194300 0.863109 -0.232314 0.420210 1.235521 0.122678 1.303993 0.281066 -0.206093 0.732419 0.479909 1.124997 1.004284 1.060228 0.858490 0.295403 0.877086 0.563444 0.270268 0.755884 0.677990 -0.192462 -0.199938 1.811657 1.269162 0.470777 -0.040567 1.907029 1.288653 0.584616 -0.045785 0.433424 0.275071 1.412706 -0.339970 1.137706 1.667309 0.167725 0.552286 0.982101 1.172020 0.975012 0.705352 1.189605 0.540246 1.371211 0.079893 1.150301 1.261158 1.095127)
     )

;;; 100 odd -------------------------------------------------------------------------------- ; 10
#(100 13.916926312979 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0)
      13.24493912033 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0)
      13.117680368039 #(0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      10.218388 #(0.000000 1.004328 0.934134 0.691719 0.474060 1.501339 0.496869 1.084930 1.778751 0.508960 1.383925 0.717997 -0.326936 0.509935 0.794706 1.092306 0.128059 0.103025 1.331678 0.008200 0.760218 1.409058 0.102986 0.107406 0.260142 1.211600 0.655023 0.315756 1.844393 1.097666 0.991539 1.072912 0.419663 0.076457 1.485956 0.006569 1.579852 1.777597 -0.150626 1.807256 0.811274 1.452141 0.675910 1.672352 0.347506 0.813039 0.282219 0.093444 0.351567 -0.142730 0.660492 0.131541 0.823400 1.126494 0.225258 0.927740 0.341767 -0.408800 1.899861 0.431813 0.462225 0.425497 0.718096 -0.089958 0.772462 0.547483 1.693686 1.169443 0.458210 -0.177463 1.196394 1.585739 0.388665 0.519332 1.271026 1.370879 1.311007 0.153528 0.216137 0.335216 0.347202 0.314124 1.256117 1.725870 -0.176322 1.024264 1.869205 0.485363 -0.143222 1.344068 0.215008 1.412032 1.191158 1.037356 0.203685 -0.404710 0.798948 1.037116 1.001884 1.111465)
      )

;;; 101 odd -------------------------------------------------------------------------------- ; 10.0499
#(101 13.462674500314 #(0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1)
      13.28250751675 #(0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      9.990273 #(0.000000 -0.103261 1.551689 -0.106365 0.982709 0.641488 1.374974 0.404901 1.419395 1.381273 0.692730 0.170389 0.163315 0.873466 1.021006 0.419164 1.505185 1.198052 0.500229 0.921687 0.402096 0.918041 1.123883 0.571960 1.893612 1.736056 1.719711 1.549107 0.391084 0.225297 0.411403 1.533444 0.820553 0.733262 0.456509 -0.060734 0.873892 1.777713 1.694072 -0.437061 1.636225 -0.024301 0.930406 -0.402962 1.873950 0.101804 -0.071018 0.651149 1.235664 0.344657 0.543747 1.848278 1.187686 1.784786 0.537188 1.010839 0.216202 0.270360 0.978834 1.621905 1.366680 1.012803 0.809752 1.350005 1.264731 0.274186 0.305176 -0.106456 -0.465317 0.469683 1.535517 1.800710 1.014885 -0.286733 1.486075 -0.015447 -0.000524 1.292544 1.638650 1.408795 0.692338 1.154279 0.593364 1.477675 -0.054927 -0.093958 0.675613 0.371872 1.539091 0.661045 0.277231 1.435201 0.092819 0.740928 1.890046 1.344568 -0.208154 1.843774 -0.156548 0.415849 1.386195)
      9.989795 #(0.000000 -0.070722 1.535626 -0.104870 0.952627 0.662325 1.365269 0.391624 1.426142 1.378307 0.706596 0.192014 0.162593 0.881877 1.051674 0.389485 1.508005 1.206890 0.501209 0.911088 0.386063 0.957014 1.110784 0.558546 1.901942 1.759647 1.762963 1.550793 0.406939 0.254044 0.390443 1.632628 0.837905 0.744743 0.456675 -0.083245 0.890078 1.875433 1.778729 -0.413214 1.634738 -0.022049 0.898515 -0.413626 1.922224 0.199965 -0.086307 0.652307 1.186320 0.341829 0.587248 1.810670 1.208306 1.787129 0.564906 0.992717 0.242594 0.280488 1.005344 1.619867 1.366338 1.017104 0.835951 1.325652 1.264238 0.328277 0.335368 -0.070287 -0.458023 0.490655 1.518053 1.802485 1.014912 -0.298568 1.572490 0.014962 -0.001575 1.286854 1.669552 1.440280 0.654420 1.144844 0.645595 1.460093 -0.064454 -0.028338 0.724447 0.451116 1.486089 0.767731 0.285618 1.422001 0.083172 0.753388 1.836217 1.338920 -0.180505 1.915817 -0.161174 0.395129 1.458653)
      9.985099 #(0.000000 -0.072627 1.535521 -0.101847 0.950897 0.663252 1.375709 0.390384 1.430461 1.384292 0.702118 0.190696 0.164623 0.880313 1.054375 0.381579 1.515055 1.203592 0.503942 0.921663 0.390915 0.949061 1.113873 0.554967 1.896911 1.768183 1.765553 1.550914 0.401415 0.254973 0.395217 1.626419 0.832367 0.745106 0.451082 -0.082581 0.892195 1.874747 1.780790 -0.418618 1.635795 -0.023847 0.902053 -0.412136 1.924156 0.195136 -0.086886 0.652704 1.188561 0.342199 0.582997 1.814716 1.208918 1.789413 0.551249 0.992722 0.259236 0.282908 1.010342 1.612902 1.372768 1.012575 0.839258 1.333554 1.263810 0.326001 0.342496 -0.075811 -0.460356 0.487733 1.512656 1.808194 1.012232 -0.304359 1.576224 0.026261 0.002529 1.291458 1.659163 1.439279 0.653889 1.151439 0.651564 1.475574 -0.055097 -0.024371 0.728138 0.455477 1.496913 0.764086 0.286904 1.427124 0.078348 0.749738 1.836073 1.338623 -0.186453 1.925511 -0.153296 0.400406 1.448704)
      )

;;; 102 odd -------------------------------------------------------------------------------- ; 10.0995
#(102 13.701085090637 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)
      13.159336831147 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      10.109135 #(0.000000 -0.228419 0.164715 0.127829 1.779719 1.511339 0.687096 0.544233 0.471514 1.141217 0.588124 1.630591 0.573119 0.479632 1.722836 0.928242 0.707455 1.283621 1.889806 0.256502 -0.272279 1.324303 0.679433 0.662415 1.004894 0.526532 1.783001 1.143679 0.051593 0.318413 1.049218 1.355488 1.299640 1.383765 0.548244 0.285439 0.181852 1.425242 1.688919 0.373790 0.143347 0.785001 0.266762 0.784085 1.026097 1.037583 1.624555 0.851495 1.391264 1.035798 0.139352 1.259357 0.550301 0.795815 -0.153512 1.261979 1.406122 -0.117957 1.063413 -0.050047 1.538127 1.641001 0.903326 0.970349 0.530570 -0.177625 0.289952 0.438953 1.335647 -0.029451 0.909108 0.949805 0.594062 0.736985 -0.322280 0.074952 0.686688 0.561398 0.752642 -0.014156 0.431058 0.204656 0.471025 0.141183 0.586111 0.670936 0.136405 1.781260 -0.108073 1.007650 1.658879 0.039367 0.924063 1.004836 0.498965 1.585671 0.917343 0.555805 1.123204 1.951536 1.621535 0.576983)
      )

;;; 103 odd -------------------------------------------------------------------------------- ; 10.1489
#(103 13.551587266363 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)
      13.142812158651 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      10.165542 #(0.000000 1.394645 0.403105 1.512532 1.293473 1.174002 0.712529 1.126577 0.539269 1.492379 1.428624 0.067956 1.554991 0.392668 0.251652 -0.038085 1.670255 0.341747 1.352954 0.229987 -0.217641 0.868672 0.258303 1.167326 1.771278 1.240130 0.896687 0.161740 0.398142 0.524847 0.049711 0.835927 1.312209 0.955264 0.649090 0.123319 1.587332 0.539146 0.860042 1.835236 0.263254 1.067680 1.129766 -0.045373 1.205556 -0.102281 0.660729 0.491082 1.064017 0.662131 1.784508 0.317300 0.772039 0.520714 0.933726 0.102204 1.085656 1.183306 1.292447 -0.044191 1.045700 -0.230658 1.332960 1.022979 0.495925 0.549497 0.390920 0.836502 1.824141 1.595368 -0.239519 1.246329 1.440996 0.288843 -0.528591 1.326441 0.602548 0.627654 1.526793 1.217398 1.835193 0.923844 0.867954 0.233106 1.497938 0.977366 1.053137 0.136562 0.913554 0.784650 0.495365 1.429694 0.207603 0.673941 0.761042 0.912078 1.129541 0.564814 0.912947 1.130924 0.019405 -0.065880 1.798290)
      )

;;; 104 odd -------------------------------------------------------------------------------- ; 10.1980
#(104 13.622 #(0 0 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.301904678345 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.214084551284 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.176067352295 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      10.475946 #(0.000000 1.034264 -0.120029 1.262694 1.368873 1.300536 0.054042 1.817693 -0.056800 -0.180350 0.483603 1.303103 1.522845 0.299207 1.072152 0.191353 0.819941 1.591426 -0.005969 1.216579 0.132209 0.790814 0.634302 0.937402 -0.324582 0.537853 1.500007 0.747718 0.685856 1.183303 0.655624 1.325389 0.781541 0.870379 0.863653 1.283311 0.867947 1.048089 0.688819 1.790352 -0.011129 1.080550 0.759160 0.775928 0.383127 0.984140 1.193758 0.011420 0.248008 1.044386 1.716602 0.380584 0.981620 1.533101 1.033426 0.209011 -0.012617 0.260827 -0.037006 0.862634 1.945689 0.758958 0.913390 1.519516 1.373001 1.144957 1.412838 1.512255 1.343577 1.124987 0.831931 0.983327 1.911909 0.478600 -0.024278 1.141464 0.071413 0.672771 0.088945 -0.138390 1.383770 0.315274 0.171961 1.195759 1.119445 0.258603 1.574629 0.855465 0.791216 1.391318 0.787759 0.233799 1.583542 1.589038 1.534872 1.781760 0.761360 0.525572 0.693136 1.450937 1.681966 0.492576 0.574320 -0.210512)
      )

;;; 105 odd -------------------------------------------------------------------------------- ; 10.2470
#(105 14.179738044739 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0)
      13.491228801467 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      10.185854 #(0.000000 0.093493 1.367470 1.114732 0.648160 0.929233 0.666165 0.715549 1.487026 1.590825 0.436570 1.428060 1.596732 0.717386 0.633183 0.879857 1.497267 1.864915 0.404696 1.977615 1.659457 1.565997 0.516096 1.123800 -0.457796 1.588387 0.778976 1.313893 -0.221341 1.373369 1.372917 0.561122 0.857410 -0.299818 1.213215 1.349733 0.943605 0.423422 0.626389 1.646607 0.860816 1.070054 1.480392 1.377944 1.646905 0.212604 1.337835 -0.173436 -0.248368 0.269937 1.635979 1.495623 0.615114 -0.091985 1.148987 0.014482 -0.297965 0.738031 0.144584 0.496703 1.184836 0.969243 -0.150833 0.757103 1.266330 1.193310 0.262524 1.410453 -0.098915 1.756789 0.951076 0.192183 0.658011 0.719037 1.171218 -0.223459 1.348123 0.773888 0.509660 1.193893 0.969141 0.725257 0.001780 0.516952 1.455006 0.164659 1.561022 0.361741 0.233936 0.962858 1.657614 1.756173 1.424859 0.406635 1.180276 0.321571 1.257149 -0.096605 0.415534 0.191849 0.328683 0.225693 0.404237 -0.144376 1.252905)
      10.175924 #(0.000000 0.052934 1.360811 1.087019 0.668570 0.956670 0.668803 0.723650 1.507568 1.560016 0.464911 1.500164 1.600687 0.707352 0.628860 0.854502 1.564800 1.844413 0.360623 1.968042 1.585247 1.519333 0.487096 1.142145 -0.425652 1.657246 0.791400 1.343612 -0.238459 1.372379 1.396232 0.564351 0.921543 -0.302378 1.217391 1.329321 0.982963 0.361196 0.653569 1.607276 0.835684 1.065858 1.434041 1.377341 1.610936 0.270205 1.322550 -0.172326 -0.194234 0.268519 1.660532 1.492810 0.690726 -0.081338 1.151457 0.031448 -0.282535 0.772839 0.134677 0.551314 1.245680 0.930423 -0.083232 0.759167 1.252528 1.227315 0.251564 1.441045 -0.104004 1.808395 1.015490 0.231444 0.621517 0.711162 1.190943 -0.232078 1.356965 0.801416 0.533094 1.185429 0.984972 0.757261 -0.004087 0.511403 1.517693 0.209323 1.579113 0.361866 0.243978 1.027465 1.650479 1.735811 1.464466 0.425359 1.211219 0.331259 1.298620 -0.111115 0.387617 0.181031 0.363928 0.252962 0.410200 -0.141839 1.295756)
      10.171787 #(0.000000 0.053115 1.358856 1.089870 0.668137 0.955503 0.666638 0.723868 1.508944 1.558664 0.463834 1.499096 1.600303 0.706195 0.626079 0.856684 1.564541 1.847960 0.360619 1.967725 1.586305 1.520760 0.486432 1.143724 -0.427157 1.659041 0.791769 1.344535 -0.235258 1.374943 1.395955 0.563891 0.919545 -0.305013 1.219986 1.329688 0.982121 0.365633 0.651545 1.607936 0.834310 1.067352 1.435119 1.378997 1.605822 0.268274 1.324963 -0.168331 -0.191250 0.268900 1.656548 1.493204 0.691155 -0.078805 1.150799 0.032893 -0.279209 0.775114 0.136222 0.552080 1.244466 0.925336 -0.080325 0.756610 1.249185 1.229293 0.252595 1.443857 -0.105649 1.807063 1.013016 0.228405 0.622851 0.708833 1.190223 -0.229598 1.357493 0.801917 0.534456 1.183970 0.983171 0.752717 -0.003371 0.515755 1.521917 0.205259 1.580122 0.361029 0.243460 1.025437 1.649899 1.737645 1.469882 0.421259 1.207975 0.328558 1.296907 -0.109235 0.392071 0.182579 0.362884 0.252147 0.413501 -0.145361 1.301863)
      )

;;; 106 odd -------------------------------------------------------------------------------- ; 10.2956
#(106 13.492804348903 #(0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1)
      13.091135978699 #(0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      10.270846 #(0.000000 0.819165 1.068752 0.583908 0.193268 1.246632 1.680630 1.168493 0.681515 1.119941 -0.103583 1.005783 0.671557 0.715469 1.521683 0.100050 0.103928 1.177788 1.706211 0.520642 0.487117 1.315232 -0.310270 1.727651 0.907859 0.195037 1.229054 1.119869 1.152686 0.282011 -0.224722 1.796458 -0.080301 0.980885 0.424151 1.117927 1.730879 1.450803 0.340809 1.313348 0.310943 0.257235 0.336745 1.188642 0.362171 0.886119 0.364003 0.651269 0.876388 0.956443 1.044360 0.139906 0.683371 0.764369 -0.035602 -0.032529 1.711134 -0.057775 1.401260 -0.006722 1.765680 0.094171 1.006063 1.119062 0.319911 1.233788 1.580745 1.758932 1.294949 1.619289 1.547561 0.246759 0.578580 0.715653 0.029566 1.719637 1.377564 0.331648 1.662851 1.367436 1.299842 0.341815 1.905510 1.149747 0.921856 1.715496 1.152941 -0.067907 0.075487 1.389444 -0.225447 1.044800 1.457795 0.003916 1.820320 0.642746 0.023596 1.383278 1.227376 0.196685 0.853371 0.087277 0.264363 1.394060 0.210839 1.646463)
      )

;;; 107 odd -------------------------------------------------------------------------------- ; 10.3441
#(107 13.864 #(0 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1)
      13.762476921082 #(0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1)
      13.722554538648 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1)
      13.537808159641 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      10.538854 #(0.000000 1.480169 1.634538 0.067950 0.670792 1.477142 0.215370 1.763514 0.228436 1.496291 1.412917 0.154106 1.490571 1.633018 0.138517 1.638601 0.153346 1.277433 -0.201813 0.188322 0.811084 0.141453 1.515537 0.715701 0.891523 0.323557 1.173378 0.468471 0.025702 -0.038382 0.242462 1.600989 0.662326 0.104253 0.042285 0.907934 0.886875 0.851837 0.306424 0.897519 -0.144207 0.902848 1.980804 1.723648 1.325541 1.472012 1.555117 1.875787 1.397333 0.469086 0.481973 1.085774 0.318334 0.055597 0.412485 0.404702 1.441236 -0.180643 0.436025 0.354709 0.004225 1.051076 0.822956 1.804736 0.984529 0.713217 1.581942 -0.205322 0.887409 1.205014 0.774434 -0.208445 0.363931 0.472098 1.937971 0.580216 0.890847 0.568066 1.682238 -0.112353 1.754877 0.439136 0.339812 0.347759 -0.013473 0.842180 1.803092 1.098463 1.596505 -0.043611 -0.238765 0.638492 0.732231 0.086997 1.819209 -0.013676 1.444016 0.193916 1.125175 1.003715 1.801748 0.386319 1.897290 1.910803 1.499456 1.066366 1.470809)
      )

;;; 108 odd -------------------------------------------------------------------------------- ; 10.3923
#(108 13.775 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0)
      13.751863479614 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.584542754139 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.472808406168 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      10.345448 #(0.000000 1.824498 0.146944 1.351241 0.605374 1.020043 -0.416076 1.030875 -1.282286 0.791432 -0.178718 1.595715 1.015029 1.797055 0.636153 -0.223346 0.480133 1.087227 1.534310 -0.180328 1.509531 0.417631 0.141018 0.871479 -0.466106 0.545429 0.912552 1.635842 0.341227 1.454786 -0.129584 -1.880889 0.384961 0.266947 0.463757 1.990119 1.781940 1.329302 1.593554 0.323693 0.446203 0.259530 0.856066 1.867463 -0.324997 1.894011 1.022739 0.724937 0.738368 0.317331 0.872632 1.388208 0.843395 0.494099 -0.375472 0.479263 -0.482434 1.085054 1.091827 1.658634 0.298128 -0.421830 0.957243 0.539801 0.926446 0.631769 0.774686 1.173270 0.980681 0.445255 0.524758 1.073588 1.908213 0.145625 0.163884 0.439900 0.931187 0.472449 0.326756 1.461022 0.914201 -0.004603 1.081102 1.147399 1.224899 0.285684 0.632441 1.581990 0.637203 1.976096 1.524724 1.666698 0.423502 1.229142 1.419615 0.173445 0.252491 0.717287 -1.373318 0.514085 0.201722 0.528562 0.258255 1.373691 1.022141 0.316675 1.432688 0.108160)
      )

;;; 109 odd -------------------------------------------------------------------------------- ; 10.4403
#(109 13.889015913621 #(0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
      13.798 #(0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      10.655068 #(0.000000 -0.216044 1.774758 0.424206 0.484819 1.873300 1.065106 1.289470 0.607788 1.277892 1.284177 1.290865 1.816090 0.102602 0.988178 1.574726 1.028525 0.829881 0.584430 0.849468 0.077201 1.542794 1.233217 0.340587 0.485475 1.357284 0.366985 0.335316 1.246289 1.034653 0.994173 0.527807 0.536916 1.401955 1.164628 1.097135 1.185965 0.351056 1.223634 -1.526433 1.274554 0.291207 -0.053159 1.010365 1.102202 0.568764 1.451458 0.748688 0.447525 0.350323 1.293257 0.788634 1.661345 0.389914 0.826561 1.473407 1.410124 1.100601 1.244116 0.574221 1.507335 0.944899 -0.044295 1.377098 0.605980 0.025217 0.914560 1.822477 0.506602 0.542893 0.150325 0.259562 1.363237 -0.377267 1.625229 0.079670 1.703127 0.920989 0.589351 0.040561 0.229953 1.555764 -0.129066 0.592870 0.779545 0.959997 1.560261 0.746942 1.298739 1.089103 1.179414 1.884715 1.189762 0.484337 1.061983 -0.107724 0.455611 1.255475 1.271600 -0.435027 0.518873 1.058950 0.405207 0.833061 0.740946 1.795908 -0.244689 -0.059628 0.105152)
      )

;;; 110 odd -------------------------------------------------------------------------------- ; 10.4881
#(110 13.816418806615 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.75 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.576010454591 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      10.453590 #(0.000000 1.603119 1.140036 0.901971 0.399260 0.101879 0.676310 1.217987 1.657397 1.410656 -0.308134 -0.092710 1.641274 1.207210 1.358527 0.042018 0.032736 0.623564 1.599272 1.236292 1.437144 1.410548 1.055039 1.190675 1.405292 -0.339647 -0.191305 -0.256353 0.349335 0.192156 1.930998 1.195596 -0.386155 0.482024 1.187879 1.521989 1.539349 0.963153 -0.053667 0.770227 1.344490 1.538890 0.825361 0.515677 0.783209 1.837714 0.198361 0.707683 0.964301 0.155246 0.407928 -0.013813 1.470234 0.540242 0.474061 0.874755 0.006479 0.619527 1.456291 1.117184 1.468804 0.798350 0.800331 0.208222 1.163385 0.060107 1.142614 1.472906 1.640772 1.753692 0.521155 0.256588 1.709748 0.515274 1.400468 0.525072 1.002240 -0.623020 0.832477 0.328561 0.403576 0.155522 0.074177 1.138297 1.487062 0.705766 -0.110698 1.362023 0.307108 1.124950 -0.064279 0.971024 0.041387 1.742458 0.430210 -0.002309 -0.610185 0.995906 1.659963 -0.233801 1.767917 0.873936 0.431106 1.305054 0.867343 0.820524 1.235517 0.148542 0.087164 0.732036)
      )

;;; 111 odd -------------------------------------------------------------------------------- ; 10.5357
#(111 14.376 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0)
      14.114 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)
      13.709900383304 #(0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      10.706926 #(0.000000 0.061875 0.397989 -0.144662 0.557681 -0.106239 1.114440 0.911387 -0.331115 0.078640 1.583233 0.014655 -0.047399 0.918827 0.888663 1.874354 1.474690 1.301488 1.511467 1.646293 0.136549 0.267571 1.957911 0.926052 -0.078395 1.638090 0.704843 1.825046 1.492976 -0.058997 0.913704 0.870986 0.557202 0.547575 0.070643 1.586480 0.829607 0.866682 1.222577 0.666205 0.334146 0.865159 0.333048 0.051439 0.568078 0.072509 0.940531 1.188601 0.165766 1.298967 1.313795 0.109766 0.909888 1.702862 1.590200 0.425391 1.437553 -0.182804 1.728746 0.603013 0.143642 0.161199 0.123802 0.988186 0.696595 0.468927 0.426097 0.363838 1.726729 1.379896 -0.235008 0.046851 1.425945 1.466027 -0.106864 0.421495 -0.009249 0.643024 1.392736 1.913771 0.775136 -0.034587 -0.065666 1.642139 1.767288 0.409867 1.544938 0.686857 1.544277 0.529076 1.255817 0.320781 0.508603 0.874253 1.206557 -0.097165 -0.067888 0.061964 0.329536 1.687111 1.247926 1.199691 0.065184 -0.176759 0.560442 1.091173 0.162705 1.258456 1.543257 0.792801 0.446572)
      )

;;; 112 odd -------------------------------------------------------------------------------- ; 10.5830
#(112 14.528804585299 #(0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      14.383410482601 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      13.92684841156 #(0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      10.773591 #(0.000000 0.427461 0.130453 0.825708 0.324144 0.801265 1.424262 0.272476 1.474087 0.714366 1.192440 1.003860 -0.002398 1.745701 0.267708 0.845644 0.740712 1.596980 1.263985 1.284123 0.955404 -0.087145 1.729374 1.631941 1.317331 0.623339 0.435761 0.368390 1.134176 0.986764 0.306565 -0.006660 0.044338 1.600597 0.766334 1.641432 0.527668 0.945675 0.552052 0.399274 0.120517 0.542548 1.926990 1.702033 0.190351 1.206381 0.888301 0.581102 1.673183 0.887355 0.086239 1.105399 1.010436 -0.004234 0.630920 1.025869 -0.334905 1.493609 0.214025 0.430526 0.385304 0.913587 1.028859 1.266259 0.475612 0.845664 0.295776 -0.344602 0.384028 1.333251 0.484632 0.318237 0.139070 0.281080 0.531679 0.350158 0.597710 1.145294 -0.210764 0.575295 1.154546 -0.095760 1.131091 0.798873 1.435050 1.559616 1.176932 0.465150 0.265388 1.414549 0.136365 0.330664 1.535409 1.136030 0.224315 0.277407 1.540549 0.067474 -0.098586 1.048696 1.135295 1.405666 0.776727 1.564452 1.152254 1.420253 1.668640 0.833735 1.273819 0.663472 1.275442 -0.043081)
      )

;;; 113 odd -------------------------------------------------------------------------------- ; 10.6301
#(113 14.292 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      14.00348588593 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      13.825498858186 #(0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      10.713470 #(0.000000 0.813441 0.364192 1.218061 0.283846 1.326945 0.351186 -0.164435 0.821977 1.807459 1.026490 1.842337 1.340940 -0.345913 0.073658 1.637554 -0.195629 0.604578 0.689255 1.093042 0.868678 1.539199 1.719529 1.409790 1.706328 0.825554 1.773364 0.827646 1.161073 0.667416 0.776199 0.910506 1.864145 1.312518 1.467080 1.207873 0.468811 0.335691 1.145705 0.691828 0.497690 0.897377 0.433511 0.636256 0.483925 1.362738 0.451083 0.471524 1.349378 1.361941 1.356141 0.896595 0.409928 1.866604 0.428461 1.678741 -0.000676 1.676397 0.638270 0.706824 0.877123 1.564325 0.791290 0.835894 0.239160 1.513117 0.508650 1.034749 0.304762 1.878525 1.633451 0.725262 0.128979 0.683821 0.995846 1.757152 1.474223 0.198247 0.326990 1.439187 0.832635 0.530416 0.021699 -0.046821 0.054021 1.364768 1.701762 0.526821 1.057751 0.281472 0.938489 1.080254 0.319042 0.810991 0.894005 0.485943 0.439330 0.956689 0.816412 1.108688 1.868915 0.518673 1.442774 1.602521 1.530921 0.764057 1.263112 1.082938 -0.007458 -0.121607 0.825997 0.618033 1.307143)
      )

;;; 114 odd -------------------------------------------------------------------------------- ; 10.6771
#(114 14.507795639854 #(0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 1)
      14.388 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0)
      13.974405288696 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0)
      13.920305720092 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      10.743452 #(0.000000 -0.191887 0.544701 0.334130 0.891545 1.663049 0.733248 0.690863 1.017827 1.546179 0.378391 0.141782 1.764990 0.143717 1.175687 -0.507695 1.476591 1.078127 0.677899 1.617113 0.406681 1.168174 0.492647 0.488828 0.866505 0.776102 0.917715 1.604791 0.452532 0.954347 0.497288 1.851319 0.705441 1.521855 0.903704 0.759740 1.302437 0.356777 1.725135 1.108925 0.216579 1.181304 0.004954 0.483643 1.844750 1.410017 1.743799 1.246412 0.679557 1.579843 1.671510 1.581300 1.003091 -0.645520 1.594818 1.103344 -0.213542 0.225840 0.228869 1.890571 0.826540 0.021828 0.496902 0.793886 0.599438 1.813433 0.607065 1.847479 1.453941 1.021770 0.061220 1.819952 0.083827 -0.017300 1.087916 0.458097 0.744661 1.653854 1.152389 1.163980 0.619293 0.014022 0.391234 1.490380 0.161523 0.274029 1.365027 1.590656 1.484828 -0.179345 1.771257 0.781638 1.976767 1.391993 1.455129 0.312731 1.661586 0.233918 0.721427 1.221486 1.391741 1.904549 1.509472 1.329503 0.980271 0.451186 0.630961 1.297834 0.327408 1.721019 1.694724 0.826690 1.304157 1.697493)
      )

;;; 115 odd -------------------------------------------------------------------------------- ; 10.7238
#(115 14.773869138996 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1)
      14.449532208006 #(0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0)
      14.20306968689 #(0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      10.875264 #(0.000000 0.851821 -0.301396 0.041155 0.668513 0.674512 0.255602 0.843540 1.111070 0.452119 0.921418 0.427186 0.280031 1.154286 0.870936 0.110451 1.526263 1.372276 0.272219 0.183748 1.552148 0.982904 1.568311 0.009146 0.200235 0.146374 0.800889 1.038645 0.185162 1.327124 -0.301328 0.239517 1.635437 1.094834 1.104434 0.455957 1.232660 0.817491 1.160561 0.669923 0.266462 0.845665 1.379425 -0.004632 0.046005 1.740287 0.185680 1.825550 1.209438 0.126773 -0.150412 0.249867 0.240012 0.289703 0.095947 0.070681 0.332783 0.816629 0.278895 -0.010189 -0.394266 0.024736 1.318522 0.250423 -0.346614 1.329200 0.582766 0.076133 0.949379 0.301581 1.076589 1.118115 -0.013901 0.022472 0.022067 1.562320 0.913023 0.782957 0.709272 0.023430 0.344441 1.579001 1.566477 1.310206 1.452555 0.278227 -0.619853 0.806804 1.464069 -0.042686 0.480374 0.576463 1.754421 0.579269 0.813469 0.793207 1.825483 1.198673 1.744188 0.375474 -0.032495 0.949984 0.029549 0.436611 0.495318 0.989069 1.533911 1.759474 1.047970 0.648817 1.007118 0.302598 0.815113 0.974680 0.303590)
      )

;;; 116 odd -------------------------------------------------------------------------------- ; 10.7703
#(116 14.661133289609 #(0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0)
      14.619069099426 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)
      13.887789451571 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      10.990832 #(0.000000 0.483308 1.870123 1.135804 0.881776 1.543776 0.925742 0.959800 1.206557 0.157522 0.765275 1.305527 0.179590 1.753652 -0.142120 0.825137 0.368838 1.576888 0.742503 1.655416 0.221411 0.173082 1.172117 0.090774 0.294153 0.772403 0.191147 0.548875 -0.120934 0.296752 1.776133 0.206215 1.630176 0.905938 1.526007 0.119822 0.974283 1.532681 1.684339 -0.206959 0.636301 1.456178 0.190032 0.704702 0.488949 0.923296 0.893836 1.578122 1.778414 0.044662 1.318758 1.179643 0.003013 0.985236 0.727650 1.230497 0.502470 0.957220 0.705947 1.540165 1.726261 1.640448 0.129576 0.851087 -0.046779 1.440963 1.097736 1.455777 0.291127 1.238446 1.034565 1.081555 1.456873 1.924640 1.261044 1.237561 0.479763 1.499119 0.343522 1.627329 -0.085516 0.727681 1.731229 0.043013 0.750403 0.701056 0.158874 -0.233570 1.702514 0.279862 -0.068752 1.247258 1.671759 1.508737 1.263823 0.481625 -0.144337 0.295030 0.306982 1.522546 0.906287 0.764511 0.463967 1.755991 1.403214 0.018778 1.300239 0.705304 0.843053 1.543715 1.630033 1.679997 -0.174261 0.000270 1.536367 1.152539)
      )

;;; 117 odd -------------------------------------------------------------------------------- ; 10.8167
#(117 14.63381513714 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)
      14.427604264985 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      10.998333 #(0.000000 0.091967 0.625019 0.157165 1.096843 1.032202 0.766519 1.545078 1.662545 0.651490 1.233025 0.735104 1.720793 -0.251409 1.377002 0.917698 1.349295 0.349982 0.866823 0.014384 0.610764 0.801190 1.449162 1.475063 1.143534 0.779660 0.103294 0.950250 1.241934 -0.038118 0.424664 1.583310 1.688657 1.207956 1.746682 0.423128 0.285351 0.049524 0.008138 1.406836 1.653531 0.172315 -0.009513 1.050100 0.585342 1.696858 0.793815 1.144590 -0.334679 0.538899 1.244976 0.879314 0.775112 1.223243 1.589043 1.467598 0.135288 1.708491 1.070891 0.568326 1.202213 0.504005 1.420612 0.868186 0.804842 1.434448 0.845983 0.200884 0.104094 1.799821 -0.080089 1.838813 1.525935 1.199834 0.368515 0.388865 0.303907 0.868623 -0.034818 0.735606 0.702901 1.801622 0.053158 1.423101 0.127606 1.710010 0.428160 0.670493 0.336277 1.866768 1.239749 0.102760 1.686163 1.811030 1.497648 0.346065 0.491588 1.042402 1.647187 1.258948 0.311360 0.801250 0.220603 1.376377 0.081760 0.104349 0.182127 0.811339 -0.006594 0.225372 0.233260 1.154706 1.730077 0.363119 1.920980 1.194888 1.314701)
      )

;;; 118 odd -------------------------------------------------------------------------------- ; 10.8628
#(118 14.922 #(0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0)
      14.72793006897 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)
      14.399567650824 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      10.961787 #(0.000000 1.470940 1.795420 1.285026 0.664696 1.037360 0.373607 0.198325 0.376090 1.816162 0.545255 1.465863 -0.422069 1.006950 1.076198 0.569139 0.392238 0.426236 0.275255 0.813117 1.396104 0.369452 1.477737 0.827308 1.502759 0.262898 -0.313147 -0.152652 0.339271 1.015187 0.594055 -0.385151 -0.010887 1.816134 0.601806 0.399043 1.966556 0.756577 1.444397 1.283154 1.752677 1.795738 0.636248 1.702217 0.047028 0.232499 0.466364 0.944111 -0.116343 0.899768 1.368097 1.447150 1.599455 -0.314923 0.524232 1.558251 1.360595 -0.511150 1.545707 0.676072 0.383751 0.980356 1.360864 0.986746 0.069545 1.109172 1.702378 0.626612 1.542992 1.000221 0.593801 0.525189 1.102142 1.814381 0.020168 0.272404 1.978861 0.700344 1.311255 0.286576 -0.024163 1.387544 0.556904 1.275065 1.409040 1.105560 1.125692 1.184544 0.200201 1.465477 1.012196 0.550151 0.942773 0.052691 0.194945 -0.400871 1.157346 0.939460 0.089254 1.310023 1.008811 1.781258 1.358458 1.454381 0.711599 0.872402 1.508707 1.608469 0.958108 -0.238875 1.589945 0.410922 1.528093 -0.198896 0.188748 -0.092843 1.202404 1.836213)
      )

;;; 119 odd -------------------------------------------------------------------------------- ; 10.9087
#(119 15.03294064107 #(0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.647579104049 #(0 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.464 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

      11.199950 #(0.000000 1.418532 -0.012427 0.580224 0.871689 0.692343 1.374035 1.732633 1.579903 0.041622 1.641780 1.594062 0.734330 1.606843 0.240648 1.481149 0.919814 0.739142 0.286851 -0.268877 0.391705 0.556624 0.475232 -0.194254 1.569449 0.383292 1.625224 1.510188 0.019036 0.734174 0.092803 0.099043 1.694381 0.121856 0.689681 1.293486 1.005613 0.149747 -0.129775 0.456364 -0.195169 1.000180 1.644202 0.600746 1.118096 0.125254 0.001905 0.143853 0.260205 1.444234 1.303086 1.452085 0.295160 0.863393 1.497943 0.559903 1.465846 1.687192 0.787159 1.229343 -0.076033 0.691314 0.945957 1.006818 0.817148 1.809135 0.923739 -0.100478 1.941627 0.853611 1.297405 1.449729 1.281981 1.254625 1.220045 1.730089 1.253847 1.875134 1.223176 0.186047 -0.153176 0.008681 0.895362 1.427233 0.951932 0.187085 1.379607 1.351520 0.650895 0.443811 1.393743 0.252459 0.409241 0.544367 0.808426 0.897731 -0.061735 1.152858 0.757903 1.795863 0.213278 1.598409 -0.216946 0.112901 1.174935 0.751470 1.705178 1.705104 0.932558 0.052389 1.089425 0.740427 1.464321 1.735810 1.503061 1.006605 1.279572 0.643471 1.784529)
      )

;;; 120 odd -------------------------------------------------------------------------------- ; 10.9545
#(120 14.701 #(0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.672351088208 #(0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.578378677368 #(0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1)
      14.530112637252 #(0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      11.077366 #(0.000000 1.597786 1.359841 1.215360 0.321862 1.552565 0.107892 0.145955 0.966674 1.200371 0.919071 1.597948 1.655922 0.817584 1.246169 0.678982 0.644828 1.158636 1.049459 1.212929 0.236997 0.606954 1.429660 1.295452 1.906568 0.712948 0.904163 1.460358 1.859988 0.069126 0.471626 -0.167119 0.289793 -0.240752 0.284693 1.010237 0.603519 0.147679 0.939872 0.212107 1.489382 0.194582 0.520614 1.408193 0.421506 1.061090 1.966770 1.495802 0.606463 0.467884 1.263955 1.235367 0.794634 -0.053097 1.196604 1.481953 0.073349 0.014207 1.335678 0.665472 0.839766 1.322461 0.537742 1.163188 0.620339 0.176876 1.176200 1.712308 0.365966 -0.026461 0.473207 1.858980 0.205145 1.523358 0.739056 1.072419 0.551573 0.248060 1.927267 0.887100 1.432519 0.985494 1.685575 0.092511 -0.000145 0.975642 1.644416 1.604629 1.053962 0.213605 0.319638 0.245058 1.689377 0.983583 0.220524 0.705769 0.427621 0.976221 0.604557 0.694370 -0.071301 1.826590 1.872493 0.363863 0.498916 1.902915 0.683345 0.448255 -0.007713 1.747120 0.517841 1.303139 1.261309 0.309510 1.016090 0.986943 0.425627 0.876225 0.653795 0.017840)
      )

;;; 121 odd -------------------------------------------------------------------------------- ; 11
#(121 15.185772112492 #(0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0)
      14.673 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)
      14.355115628334 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

      11.219978 #(0.000000 0.604634 1.104649 0.412405 1.763747 0.254472 1.618362 0.827156 0.362435 1.205506 1.377046 1.591753 0.490968 1.222942 1.245711 0.873477 0.847794 0.939146 1.180902 0.604962 1.904631 0.113139 1.422360 0.969230 1.302050 0.289625 0.088711 1.098717 1.805867 1.687126 0.397912 0.701875 0.370323 1.564355 0.138272 1.749558 0.582008 0.044175 0.451202 0.113609 1.273911 1.546220 1.254961 -0.074240 0.338782 0.199226 0.483590 -0.010856 0.522552 -0.004049 0.601093 0.088418 0.574059 0.626301 1.702318 0.676004 0.795342 -0.026847 0.557305 -0.249809 -0.025975 1.410185 -0.216353 1.807363 1.068395 0.263393 0.768079 1.452653 1.028124 0.877010 0.118853 0.379780 0.507291 1.188696 1.768402 0.180606 0.197471 1.868459 0.758465 0.385189 1.797516 0.595797 0.417825 0.627066 1.197644 -0.058630 0.917532 0.236038 0.985105 -0.232934 1.491217 1.346428 0.505002 -0.170229 0.233005 1.150387 1.225990 -0.188147 1.529448 1.125233 1.794203 1.381709 0.509422 0.311300 0.080371 1.314856 0.294672 0.968673 1.067482 1.613784 1.155524 0.802800 -0.152265 0.505093 0.661567 1.730354 0.821232 0.963274 0.228806 -0.037696 1.415048)
      )

;;; 122 odd -------------------------------------------------------------------------------- ; 11.0454
#(122 15.079724293912 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0)
      14.561 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1)
      14.266534958875 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

      11.236480 #(0.000000 1.241560 1.190087 1.534647 1.115967 -0.004320 1.308172 -0.084069 -0.026297 0.382054 1.556069 0.128232 1.235329 0.141213 1.411811 1.815278 1.402626 1.379630 1.690275 1.159924 1.553423 0.022824 1.538883 0.217325 1.304445 0.423630 0.457201 1.239473 1.144409 0.000521 1.296901 1.527961 1.490983 0.342205 0.187720 -0.511743 0.541838 -0.004151 1.370982 0.746134 0.212228 1.612820 0.706248 0.625864 1.509376 0.552512 1.286962 -0.058441 1.667676 1.627860 0.491038 1.556687 0.251420 1.223586 0.527466 -0.346016 -0.250967 -0.567149 0.909498 0.824042 0.027142 0.938375 0.875315 1.293754 0.249081 1.498182 0.857941 1.750635 -0.197773 0.480115 1.153471 0.764049 0.923475 0.755879 0.735614 0.509775 1.706604 0.287325 0.996487 0.172372 0.457018 1.426996 -0.206490 0.599565 0.673921 1.231203 0.583987 1.085376 -0.119264 0.261025 0.023073 1.540866 1.000423 0.971240 0.977660 1.305446 1.683831 -0.094919 0.401960 0.410152 1.499002 1.418186 -0.124594 0.507778 0.333976 0.002737 0.109138 -0.279168 -0.052077 1.758275 0.653491 0.486098 -0.066203 1.680630 1.262809 0.589433 0.963718 0.924116 1.509572 1.607248 0.779800 0.831581)
      )

;;; 123 odd -------------------------------------------------------------------------------- ; 11.0905
#(123 15.249 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0)
      15.019962594276 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0)
      14.795100232697 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

      11.384759 #(0.000000 1.250375 1.638093 1.086966 0.658382 0.846843 0.405161 0.615402 0.386733 -0.026369 1.721995 1.026231 0.061451 1.882944 -0.005338 0.402508 0.515210 1.186359 1.545807 0.853467 1.488045 0.367485 0.714167 0.051067 0.100578 1.087377 0.496844 0.942943 1.185225 -0.331715 0.124691 0.014727 0.950346 0.956943 1.070854 0.316490 0.741272 0.896410 0.874612 1.578197 0.233741 0.304034 1.733987 0.347933 1.383002 -0.137449 0.832731 0.070192 0.448378 1.013829 0.339511 0.950333 0.291005 1.514992 1.299699 0.818996 1.241667 1.454117 1.752918 0.561735 0.387893 0.621071 0.813016 0.433006 1.548487 1.640182 0.410180 1.072599 1.236529 1.246118 -0.089532 0.986450 1.846205 1.519808 0.469451 0.479186 1.863532 1.521196 1.544448 0.280134 0.470877 0.336639 0.103598 -0.090484 0.814306 0.082853 1.086843 0.176162 0.755825 0.730478 1.554684 0.342884 1.398871 1.469353 0.439863 1.427253 0.989932 0.245396 0.941740 1.150852 0.002136 0.092133 1.736549 -0.389764 -0.108687 0.793881 -0.496038 0.499635 -0.113663 1.260419 -0.585550 1.184958 0.700767 1.656396 1.241261 1.545065 1.199595 0.651157 1.436004 1.574158 0.859605 0.387712 1.229129)
      )

;;; 124 odd -------------------------------------------------------------------------------- ; 11.1355
#(124 15.930208950198 #(0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0)
      14.82254124518 #(0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

      11.391702 #(0.000000 0.715958 0.173730 1.204028 0.409151 0.818501 -0.057157 1.046972 0.459348 -0.634646 0.097937 -0.054316 0.907390 0.720738 0.499196 1.683348 0.051165 0.318547 0.691253 1.411422 -0.398199 0.231076 1.120582 0.496582 1.394824 0.204288 0.191889 1.190138 1.778856 0.710400 0.601419 0.054017 -0.183580 0.687070 0.364253 1.700994 0.597805 1.486650 1.379098 0.318085 1.426060 0.011843 0.022428 0.945147 1.679502 0.515706 0.020688 0.012914 1.042124 0.008791 -0.343069 0.698476 0.291358 0.670737 0.679790 1.005625 1.631077 0.034364 0.438079 0.397540 0.992841 0.632914 0.580485 0.158866 -0.437141 0.980218 0.584457 1.153836 1.138338 0.947842 1.087147 1.778913 0.836673 -0.506409 1.663299 1.218651 0.120028 1.336714 1.783550 0.667931 0.153146 0.671978 1.227562 1.362240 0.524189 0.520177 0.899564 0.587825 0.802877 0.152192 -0.211598 -0.351842 0.163764 -0.431861 -0.274674 0.734183 0.203822 0.931374 -0.140739 1.377738 1.593095 -0.220379 1.309111 0.153462 0.288314 1.232656 1.383425 0.680582 0.809216 0.533364 1.754413 1.435277 1.313699 -0.499920 1.418229 0.020763 1.385216 1.616050 0.618918 0.998764 0.971812 0.791743 0.509575 -0.176372)
      )

;;; 125 odd -------------------------------------------------------------------------------- ; 11.1803
#(125 15.409635839002 #(0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0)
      14.833 #(0 0 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0)
      14.82163143158 #(0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      11.446183 #(0.000000 0.934376 0.033198 0.617926 0.478648 1.789780 1.296190 0.533253 1.030247 0.316198 0.702011 1.713924 1.659574 1.192285 1.296369 -0.069647 0.411663 1.251379 0.408702 1.010137 0.298276 0.497685 0.799227 1.058952 -0.039018 0.206047 0.699568 1.393552 0.433116 0.998501 0.714934 -0.199623 1.922914 0.644087 -0.444081 1.000163 1.872559 0.943911 -0.167331 0.333147 0.674794 1.710421 1.040630 1.730551 -0.005127 1.406494 1.369938 1.899997 1.262298 0.005779 0.036626 0.065095 0.278280 -0.053490 0.146859 0.304841 0.225336 1.361685 0.887310 0.010509 1.276524 1.255929 -0.199302 -0.202689 0.005181 0.018453 0.383446 1.644387 1.375104 1.102615 1.044102 0.023366 0.340039 0.322147 0.907626 1.792110 0.071029 1.615714 0.021087 0.594816 1.217996 0.329062 -0.135817 1.479135 1.133165 1.159912 0.738809 0.075956 0.612865 0.298622 0.500443 1.694370 1.369294 0.170444 1.257329 -0.182689 1.849539 1.085381 0.540941 -0.016569 1.427097 1.076392 1.198249 1.711532 0.030075 1.080243 0.001501 1.070187 0.323157 0.374758 1.054561 0.988508 0.209710 1.566608 0.367746 1.119938 0.453001 -0.094972 0.355763 0.498554 0.095395 1.396716 0.918527 0.183758 0.383321)
      )

;;; 126 odd -------------------------------------------------------------------------------- ; 11.2250
#(126 15.556811374771 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1)
      14.961482935205 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

      11.470740 #(0.000000 1.267706 1.907105 -0.371187 0.824689 -0.519885 1.116364 1.372587 1.176175 1.696463 0.898087 0.966910 1.053059 0.895409 1.128246 -0.185437 -0.403917 0.451060 1.494357 0.600648 -0.010674 0.233410 0.153987 1.508237 0.085025 0.727635 1.276519 1.664284 0.609549 -0.207221 0.085636 0.457351 0.008887 0.793278 -0.274520 -0.132984 -0.137498 1.196263 0.853400 1.258616 0.900843 1.846651 0.083731 1.470348 0.496978 0.861612 1.652157 1.526868 0.194212 0.078839 0.070644 1.910471 -0.146931 -0.033679 0.858346 0.886019 1.715787 1.436493 1.019178 1.961929 0.351754 0.376642 0.338329 0.012730 -0.098247 0.756431 -0.109729 0.631319 1.066235 0.095478 0.416378 1.276395 1.173411 0.853477 -0.013075 1.601623 0.373692 1.085416 1.105186 1.225109 1.492049 0.858997 1.341802 1.880101 0.408902 0.348337 -0.003183 1.450932 0.405010 1.628487 1.332116 0.657921 0.908486 -0.306376 1.431179 1.296728 1.003301 0.855280 1.656745 1.570618 0.231239 0.253029 1.712429 1.508293 0.967890 0.381475 0.827596 0.422574 1.421244 -0.119452 0.666679 -0.215098 0.956581 -0.054306 0.471752 1.064369 0.739651 1.117395 -1.749801 1.751343 1.141752 1.894662 0.627082 0.725030 0.002876 1.169017)
      )

;;; 127 odd -------------------------------------------------------------------------------- ; 11.2694
#(127 15.055509004493 #(0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0)
      15.018874168396 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
      14.695912364919 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

      11.492145 #(0.000000 0.554266 0.844517 0.430109 -0.132090 1.291683 0.958012 0.507769 1.296710 0.315890 -0.093357 1.380396 1.473585 0.388101 0.232585 -0.283719 0.303829 0.530769 1.244189 0.839818 0.320682 1.149668 1.300997 0.228306 0.948295 1.105845 0.198080 0.977357 0.909757 1.859897 0.648311 0.123706 1.593191 1.161779 0.134156 0.694282 -0.060449 1.871529 1.611038 -0.040665 1.281701 0.671114 0.995411 0.585071 1.303837 0.982036 1.188756 1.610862 1.124554 1.635101 -0.171803 0.381944 0.872235 1.265422 0.890352 0.360229 0.634428 0.938198 1.504872 1.758148 0.578422 1.034626 -0.267107 1.645523 1.239112 -0.208762 0.919665 1.575076 1.117408 1.083307 1.140460 1.214525 0.860039 1.685128 1.789633 1.369451 1.389681 0.586526 1.421271 1.203475 0.627436 -0.150066 0.063168 0.024406 0.076785 1.431008 0.333567 0.977587 0.748084 1.129141 0.367110 0.669885 0.511027 0.073490 1.180062 0.466688 0.602566 0.485056 0.013010 1.313245 1.727797 0.804570 0.168422 1.596542 1.012128 1.823498 0.187899 -0.300337 0.790106 0.907598 0.941820 1.705088 1.698974 1.949142 0.365467 -0.060423 0.808437 1.346730 1.266781 1.373118 0.431360 0.867050 1.118259 0.249501 1.090264 -0.109273 1.072981)
      )

;;; 128 odd -------------------------------------------------------------------------------- ; 11.3137
#(128 15.527 #(0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1)
      15.003612518311 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)
      14.876242756695 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      11.521594 #(0.000000 0.110336 0.640657 0.950128 0.438118 0.717263 0.900153 1.012666 1.689558 1.094639 0.603177 0.592307 0.880624 -0.000155 0.742149 -0.025331 0.223470 -0.427986 0.971482 0.243367 0.436872 1.403576 0.609274 0.483296 1.094065 -0.277632 0.401255 0.162638 0.866207 1.313773 1.608630 -0.114354 0.133548 1.530672 0.858872 0.361615 1.038853 0.696031 0.793837 0.981947 0.220132 0.103820 1.064172 0.685992 1.529728 0.533374 0.891878 0.713917 1.287984 -0.104490 0.899911 -0.022470 0.995570 -0.308428 0.751548 1.504619 0.941692 0.625823 1.334154 0.711622 0.612737 1.351847 1.338069 1.300135 0.216660 0.129260 1.047705 0.876608 1.378796 1.449967 0.708969 1.964920 0.642002 0.398878 1.931425 0.438713 0.199501 0.248290 0.502491 1.492695 0.214260 1.370950 0.253782 -0.163793 1.916880 0.228096 1.660601 1.269841 0.731494 0.911228 1.433533 -0.060287 0.612046 0.598600 0.055982 0.020945 1.342052 1.645113 1.447922 0.423094 1.854653 0.340740 0.044706 1.083000 -0.127529 0.672798 0.932416 0.226724 0.476709 1.288728 1.246754 0.838176 0.333938 1.097775 0.919784 1.453833 0.336087 1.889025 1.504745 0.490277 1.033434 0.391858 0.289904 -0.116089 1.477105 1.079994 1.651492 1.542606)
      )

;;; 256 odd --------------------------------------------------------------------------------
#(256 22.546259712247 #(0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
      19.779971 #(0.000000 0.287166 1.811728 0.003647 1.563327 -0.199797 1.748861 -0.027658 1.491523 0.358283 1.786152 0.407453 1.895896 1.702005 0.820432 1.443342 0.126567 0.528978 1.062681 0.144427 1.060071 0.368932 1.288502 1.669328 0.601969 1.609873 0.009521 0.796369 0.509981 1.904275 0.044862 0.614773 1.710675 1.495519 1.692276 1.250582 1.156222 1.594534 0.298597 1.684540 0.924734 0.804943 0.689590 1.177326 0.902799 0.909396 0.954254 0.261017 1.169485 0.938560 0.019866 1.334679 1.574350 0.442405 0.413355 1.552164 0.377894 1.422514 0.243015 0.559434 1.800624 1.468365 1.592498 0.584550 0.034812 0.293061 0.193868 1.089628 1.551790 0.037622 1.190818 0.318859 0.819004 1.851057 0.518624 0.663998 0.448473 0.066841 0.121442 0.912629 1.902379 1.968342 0.338155 1.260192 0.187056 1.823089 0.529718 0.076074 1.893909 1.177725 0.252346 0.193078 1.743428 1.843296 1.581080 0.130352 0.411188 0.552704 1.459730 -0.190870 1.185873 1.213912 1.881537 1.413927 0.390691 0.406250 1.645390 0.152258 0.066573 1.047526 0.945901 1.029638 1.224255 1.274278 1.742960 0.466865 1.882173 1.585879 1.499684 1.765278 0.688359 1.510365 0.729048 1.561332 0.482075 1.161051 0.635742 0.621496 0.237812 1.429801 1.538338 1.807873 0.866385 0.985705 0.165602 0.760224 1.891478 1.496052 0.933548 1.722668 0.466509 0.099331 0.101735 0.991972 1.628542 1.607529 1.751580 1.265628 0.234833 0.306012 1.365655 1.492678 1.262225 1.708575 1.110893 1.962624 1.207292 1.779446 0.254648 1.807960 1.406200 0.343366 1.203432 0.955798 0.389970 1.528111 1.208576 0.010439 0.869974 0.035552 1.208552 0.683287 0.473739 0.683814 1.317711 0.374975 1.738225 0.120217 -0.175098 1.582996 0.867052 0.692109 0.493305 1.718047 1.208498 1.811081 1.821705 0.654337 0.217531 -0.099005 1.010084 0.259226 1.288077 1.708184 0.570772 0.336605 0.604351 0.689981 1.178933 -0.158272 0.131307 -0.014422 0.959472 1.490474 1.313114 0.053727 0.366844 0.481538 1.929683 0.975977 1.124109 1.896357 0.758496 0.888582 0.159146 0.818597 1.655710 0.590078 1.621154 1.243084 0.695850 0.941639 0.608910 -0.136277 0.932800 1.416731 0.412678 0.218232 0.303734 0.129337 1.481931 0.515983 0.719833 1.705010 0.804065 1.067955 0.475270 0.737429 1.074355 1.333884 0.284629 1.317930 1.349354 1.980213 0.481352 1.075718 1.302558 1.547761 1.722849 1.882200 1.571505 0.804632 1.874854 -0.081974 1.014450 0.864487)
      )

;;; 512 odd --------------------------------------------------------------------------------
#(512 35.541 #(0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      31.627573 #(0.000000 0.641971 0.823435 1.073329 0.539150 1.644256 0.942410 0.791472 1.064522 0.907704 1.428794 0.001231 1.342358 1.365932 0.655059 1.273217 0.387305 1.151713 0.464556 0.040873 1.211746 0.565890 0.572488 0.447248 1.881382 0.212994 1.677831 1.225395 1.627225 1.565389 0.526112 0.810610 1.095356 0.987163 1.475014 0.670579 0.628158 0.893664 1.170671 1.124505 0.755854 0.300778 0.869316 0.919963 0.365823 1.723706 1.014851 0.498120 0.637194 0.352754 1.176211 0.866662 0.273392 -0.100029 0.834522 1.417914 0.163216 0.001094 0.094626 0.941186 0.740318 1.686733 0.919502 0.781344 1.668460 1.372868 1.926722 -0.013075 1.859527 0.808579 1.050819 1.202535 -0.065064 1.005084 0.221611 0.092920 0.014314 -0.126624 1.411892 0.640148 1.726499 1.132514 0.613199 0.879500 1.336432 1.600858 0.194537 1.580641 0.936076 1.506791 0.812228 0.638475 1.187229 1.635303 1.915488 0.799069 0.160834 0.881635 0.830638 -0.237466 1.203243 0.069071 1.015759 1.594863 0.741846 0.396797 1.024115 1.576269 0.297798 0.159265 1.736938 1.305428 -0.180384 0.324437 1.638834 1.298223 1.545155 1.094452 0.373838 1.545743 1.267383 0.175106 0.836172 0.339434 1.641107 0.308164 0.618412 0.020865 1.493642 1.738528 0.223837 1.728277 -0.001512 0.572589 0.109109 1.031926 0.299462 0.994195 1.218696 0.638982 0.509796 1.559371 0.148304 0.598851 1.007413 1.005303 1.318366 0.405786 1.262346 1.267264 0.506932 1.133813 0.475700 1.880509 0.789002 0.453480 0.239026 0.227558 1.059055 0.767671 0.566336 0.870093 0.650822 1.420300 0.752287 0.068587 0.289154 0.589494 0.967799 0.716662 -0.136748 0.894624 1.762980 0.374462 0.652941 0.795161 0.405835 0.987008 1.149128 0.792408 1.814055 0.946290 1.372088 1.420931 0.766271 1.803197 0.048647 0.842236 1.000451 1.426188 0.472345 1.886308 0.733469 0.500330 1.201671 0.533436 0.047414 0.185851 0.012020 0.210052 0.058992 0.149168 0.225954 1.275422 1.600178 0.027805 0.734000 1.142974 0.760770 1.247212 1.162280 1.726486 0.314615 0.098353 1.326208 1.035621 0.171545 0.304654 0.998041 1.758815 1.437338 0.710766 0.526788 0.043168 0.406921 0.608124 1.606403 0.893683 0.477997 0.000670 0.488634 -0.069036 -0.061680 0.112820 1.036929 1.548689 0.075054 1.741209 1.196178 0.352973 1.109566 -0.088309 0.774755 0.401376 0.242119 1.087618 0.068851 0.857888 1.221587 -0.019816 1.439372 1.169566 1.554426 1.678997 1.788747 0.784626 0.497675 1.010605 0.845773 1.777904 0.686256 1.393740 1.509084 1.190820 0.403592 1.261550 1.103977 0.536027 1.461863 1.261457 0.063297 0.362984 1.275933 0.945974 -0.109974 -0.203292 0.297974 1.745096 1.406757 0.680111 1.145314 0.780465 1.423008 -0.110897 0.521349 0.893654 1.653106 1.409408 1.732378 1.643879 1.021437 0.297832 0.198983 1.426222 1.445222 0.925063 0.860053 1.108162 1.379936 1.207276 1.543307 0.381530 -0.226848 -0.264262 0.012490 0.992932 0.864424 1.492055 0.915972 1.732040 0.817003 0.307476 1.352170 0.423888 1.329013 1.399071 0.992404 1.355255 1.651646 0.309776 1.671406 1.043917 1.869139 1.594136 -0.005031 1.744908 0.655800 1.327847 1.409992 -0.103359 0.063715 0.768347 -0.043384 1.369031 0.587208 1.037146 1.074892 1.093514 0.744290 0.053865 0.348258 1.204096 1.167382 -0.131176 0.694914 -0.167478 0.848484 1.882004 0.096415 1.570844 0.993590 -0.020994 0.913612 1.588955 0.704219 1.085327 1.546526 0.651243 0.540599 0.940847 0.628133 0.081446 1.846942 0.928486 0.107920 0.007586 -0.062816 1.188460 1.236358 1.495043 0.028409 1.657622 1.712531 1.879651 0.801929 0.276453 0.178559 0.124729 0.356095 1.077818 1.274958 -0.171551 0.461760 0.426529 0.303303 0.286626 1.048164 1.799901 1.036822 1.694543 0.305443 1.309533 1.256076 0.827871 0.345051 1.259048 0.783575 0.662862 0.523535 0.764332 1.439512 1.490591 1.277727 1.771280 0.968938 1.828813 0.616693 0.026985 0.630998 1.165842 1.604957 0.506658 1.643773 -0.010849 1.199100 -0.097492 1.070350 1.825319 1.071090 -0.091097 0.476000 0.246988 0.001741 1.570443 0.157951 1.654163 0.256397 0.418448 0.401357 1.115814 -0.163746 0.006042 1.620231 1.476353 0.625221 1.336783 1.237377 1.107035 -0.011244 0.501244 0.937261 0.874984 1.284656 0.415597 0.001246 0.170531 1.295187 1.042093 1.554322 0.772877 1.325785 1.217688 0.441610 -1.899803 0.043140 1.813774 0.405185 1.057689 0.374283 1.706719 1.083516 0.941168 1.031645 1.166947 0.663039 1.808751 0.239071 1.846075 0.787534 1.538073 1.752155 0.737674 0.162097 1.744119 0.626675 1.785334 0.656878 1.530504 1.882550 -0.066498 0.448671 1.407281 0.142294 0.329252 0.502527 1.533283 1.717776 1.422026 0.012518 1.271419 1.775104 0.652861 0.652894 0.475309 1.835944 1.609988 -0.142017 0.251089 0.591652 0.158013 0.883469 1.255936 0.571626 0.204126 1.716678 1.066841 0.807994 1.069000 0.686395 1.517494 1.291233 1.140441)
      )

;;; 1024 odd --------------------------------------------------------------------------------
#(1024 52.508 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       48.812539 #(0.000000 1.519639 1.650443 1.195998 1.376729 1.899699 1.970244 0.812566 0.904608 0.600090 1.324454 0.983250 1.017466 0.767844 0.473656 1.362846 0.411668 1.143136 1.709002 1.799336 1.634334 1.127351 -0.096953 1.054946 0.631221 1.250117 1.431825 1.462402 0.392219 1.150149 0.361692 -0.007895 1.410301 -0.155259 1.559313 1.025404 0.848567 0.413175 1.206342 0.941843 1.655170 1.899345 -0.179528 1.520982 0.422331 1.843755 0.338626 0.259524 1.219677 0.928668 0.359292 -0.035002 0.292293 1.153387 1.456000 -0.123570 1.766526 1.738248 0.524497 0.103671 1.368994 0.239364 0.976560 1.227616 0.548531 0.854823 0.785093 -0.197237 1.336605 1.539099 0.835663 1.511255 0.962715 0.529653 1.142525 1.602263 1.389138 0.657746 1.560084 0.537641 1.281309 1.646253 0.540975 0.972241 -0.100372 0.678740 1.332669 1.561545 0.551248 1.375355 0.212979 1.193149 1.549790 0.906638 1.351033 1.793558 1.975586 1.399301 1.183386 0.721803 1.068055 0.343392 -0.284674 0.637779 0.099731 1.080489 1.644659 1.671862 0.243661 1.739989 0.343292 0.666143 1.387914 0.983866 0.682169 1.307094 0.441588 -0.079958 1.574357 0.516534 0.821922 0.946185 1.676179 1.618357 1.436315 1.560073 0.444652 1.752148 1.545784 1.140653 1.762060 0.454780 1.132888 1.286946 0.909353 0.217248 1.608014 0.408949 0.982308 0.842400 -0.210310 0.264674 0.498652 0.910983 1.178934 -0.004034 0.340697 0.615753 -0.136166 1.321752 0.263196 1.709158 0.839955 1.174310 0.322353 0.297043 1.553360 1.401766 1.007148 1.677521 0.741845 0.907691 1.276494 0.432523 1.605921 1.143725 1.756996 0.320225 1.288530 0.332776 -0.196583 0.603381 1.336746 0.086445 1.672621 0.890109 0.463938 1.357177 0.922958 0.697499 0.299459 1.219213 1.829846 1.943642 0.749969 0.829949 0.653853 0.398390 0.727336 1.275356 0.674723 0.748253 0.256595 0.201768 1.419157 0.468013 -0.030328 1.410807 0.229406 1.979323 1.794527 -0.016365 1.616308 1.369367 0.712107 1.706465 1.848255 0.226421 1.849134 0.380595 1.411511 0.299912 0.108735 1.186805 0.457520 0.271926 -0.067552 1.609142 1.431855 0.868110 1.197096 1.629939 0.035468 1.862078 0.753638 0.605706 1.277352 1.735611 1.272105 0.935222 1.246256 1.571576 1.870573 0.025272 1.040066 0.940302 1.227315 1.882565 1.396880 0.843794 1.345301 0.792983 1.395248 0.706526 1.661413 0.446114 0.907125 -0.062988 1.049496 1.071169 1.136989 1.421889 0.905366 0.518945 1.552620 0.983677 -0.059829 1.561292 1.006026 0.133199 1.906396 0.441897 1.763764 1.574203 1.360252 1.738862 -0.148160 1.201349 0.701943 1.000967 1.904072 1.310693 -0.020100 0.178949 0.724875 0.252065 0.310697 1.382325 1.227708 0.408125 0.958815 0.649841 -0.077987 1.301784 0.826432 1.474625 0.805014 1.200874 0.124273 0.639817 0.336398 0.230644 0.675556 0.205384 1.219305 0.297402 0.896968 0.099148 1.180783 0.995222 1.801650 1.005890 1.669304 1.555321 0.893841 0.076777 0.821684 0.103460 1.274312 1.641740 0.108476 0.474745 0.106818 1.121379 0.259728 1.241445 0.558062 0.844266 0.902584 1.679800 1.962091 1.160123 1.751210 1.564581 1.787630 0.017232 0.526177 0.946544 1.537788 0.162595 0.274043 -0.044734 0.870207 1.061828 1.973221 0.316719 1.874725 1.919981 0.798782 -0.079217 1.207291 0.982608 0.779931 0.543867 1.919099 1.476795 0.646670 0.139511 1.457573 1.694085 0.629716 1.716191 0.131491 0.664390 0.787058 0.586046 0.644992 -0.006434 1.389868 1.461697 1.509464 1.325643 1.325259 1.204176 1.780741 0.818762 0.535146 0.040136 1.734284 1.577489 0.131655 0.306406 1.644914 1.594499 1.639871 1.971222 1.349697 0.012654 -0.129510 1.611419 0.072394 1.749559 1.734331 0.117738 1.641966 0.797545 0.365172 0.268189 0.523823 1.624812 0.594331 1.509286 0.660606 0.244640 1.683550 0.574769 0.691397 0.958587 1.980250 -0.055636 0.626289 0.244708 1.483613 1.349865 0.598110 1.383298 0.003756 0.637659 -0.080158 0.676783 0.636104 1.458856 0.713675 0.532894 1.606586 0.019165 -0.068957 1.679326 1.139161 0.032928 0.191688 1.041482 0.050956 0.579658 -0.086398 0.011405 1.881689 0.667973 1.016102 0.664665 0.937454 1.751825 1.316685 0.124775 1.792093 0.746284 1.794429 0.643490 0.622783 0.556543 0.160050 0.107300 0.132343 0.640078 1.177660 1.821213 1.816797 0.766212 0.843537 1.824573 0.062901 1.724824 1.075620 -0.018658 1.030264 1.530522 1.314744 1.689721 0.324854 0.383385 1.535095 1.312333 0.745413 1.612902 0.986807 0.028575 0.527696 0.022035 1.685790 0.049529 0.258771 0.934595 1.292434 1.410893 0.805550 0.379555 1.953132 1.889999 0.256214 1.738588 -0.077133 1.023294 0.169218 0.252723 1.382993 1.154004 0.545944 1.321628 0.996409 1.398047 0.279943 0.403421 0.999037 1.888683 1.595423 1.628037 0.559370 1.693110 0.686705 0.382186 0.172950 1.892951 0.773946 0.976296 1.321030 0.111411 1.621968 0.153825 0.547817 1.789581 1.033120 1.189280 1.377718 0.724048 1.497776 0.211222 1.135220 0.266237 -0.119750 1.227078 1.763611 1.286882 0.019319 0.217713 1.199864 0.139524 1.574282 1.464184 1.150806 0.500220 0.119072 0.741896 0.924713 0.317970 0.222493 1.640251 0.523108 0.481320 0.822623 1.781413 0.213174 0.526517 0.784168 0.325984 1.630501 0.652451 0.316042 0.853892 0.706219 0.007041 1.327154 1.456855 1.828532 0.975735 0.357055 1.857690 1.354029 -0.002919 1.867148 0.775657 1.449311 0.258681 1.761863 0.655676 1.286698 0.401581 1.805723 0.089138 1.750159 -0.068260 1.189680 0.106126 0.502482 -0.049569 0.188084 0.806860 1.767305 0.783989 0.042035 -0.089529 1.620846 1.742942 1.638746 1.719033 0.620464 0.165571 1.198973 1.674614 1.772405 0.539545 0.054570 1.607511 1.487697 0.667428 0.150144 1.328158 1.098030 0.732064 1.431842 1.088525 0.593456 1.151458 1.172287 0.425020 1.182693 0.220969 1.859578 1.566433 0.923298 0.977581 0.362573 0.127506 1.222420 1.575324 1.416319 0.704553 0.751691 0.764554 1.478321 0.276418 0.260139 1.048863 1.597529 1.209535 1.071833 1.356900 1.823221 0.498971 0.746938 0.652020 1.900459 0.028526 1.481411 0.327912 1.079162 1.904872 0.898093 0.576127 1.484575 1.189478 1.135242 0.137399 1.126530 0.274352 0.797920 1.009056 0.338346 1.610297 -0.226829 1.631574 0.959330 1.320781 1.954762 1.442338 0.384065 0.746277 0.250366 1.096580 1.790088 0.003760 0.999329 1.147548 0.586431 0.599300 1.667488 1.279694 1.378872 0.759814 0.286225 0.889077 1.344080 1.453847 0.842622 0.487144 1.759146 -0.021070 1.741457 0.255220 -0.087000 0.379022 1.406398 1.296095 1.573207 0.547077 0.266035 1.220016 0.967606 1.841949 1.059298 0.545929 1.503344 0.057557 1.865376 0.175297 0.023235 -0.129818 0.081379 0.343826 0.309096 1.178139 1.234620 0.401212 0.247771 1.242728 0.215679 1.555335 0.391381 0.215626 1.318046 1.403085 1.109228 1.784926 -0.059823 0.366344 1.472272 0.134227 0.905526 0.317002 1.705593 0.778299 1.488104 1.866262 0.311398 1.071911 0.626873 0.238504 -0.012674 1.321815 0.134023 0.680665 0.878893 0.847214 0.978909 1.839554 0.440437 1.381565 0.402718 0.001953 0.405290 1.118864 1.625751 0.595378 1.714297 1.740414 0.774178 1.699347 1.192736 0.295696 1.260521 0.701036 1.140521 0.356675 0.978455 1.370680 1.420406 0.130293 1.653114 -0.018893 0.205569 1.517424 0.446663 1.261641 1.895881 1.784830 1.763404 1.312276 1.486071 1.216977 1.956752 0.167875 1.476998 0.857182 0.633043 1.109241 0.002331 0.823632 0.871605 0.377286 0.698788 0.438774 1.153781 1.232744 0.574432 -0.020814 0.677651 1.865215 0.654114 0.735767 1.621349 1.517040 1.717531 1.731811 -0.054153 1.877084 0.317175 0.457941 0.096350 1.311998 0.489681 1.413648 0.564409 1.706366 0.164517 0.790116 0.629520 1.107932 0.148285 0.249165 0.506282 0.500732 0.232053 1.264683 0.554141 0.156996 0.326906 1.494430 0.478989 0.922682 -0.195313 1.587851 1.760958 0.894217 0.283230 0.952266 0.740249 1.100321 0.880764 1.505061 0.604270 0.704770 -0.047172 0.511816 1.807854 0.422215 1.522333 0.963650 1.304077 1.666527 1.502872 0.589480 1.376377 1.698090 1.158540 0.370463 0.811208 0.347224 0.006019 0.975977 1.784091 1.823852 0.346739 0.110648 0.819458 0.262966 -0.022950 0.321824 0.959696 0.889141 0.219784 1.217523 1.828829 1.188780 0.642719 1.233994 1.041576 0.808517 0.545278 0.807380 -0.100107 1.389803 1.807516 0.153430 1.534635 1.483870 1.199173 0.558907 1.363742 1.066229 0.228446 0.249453 0.894989 0.990075 0.432789 1.489101 -0.125393 1.049266 -0.060522 0.592996 1.108054 0.556959 -0.010652 -0.122495 1.192843 1.419502 1.033551 1.312986 1.654147 1.925127 0.570975 0.668912 0.596661 0.829670 0.124816 1.442843 0.029297 1.031269 1.673783 0.961837 1.711478 0.674847 0.749091 0.236244 0.804937 1.696901 0.928621 0.764829 1.715576 1.230534 0.889448 0.986091 0.837907 1.573717 0.972857 0.317330 0.783659 1.499296 1.172750 0.024671 0.919212 1.526316 1.664955 0.823036 1.671347 0.781608 1.212905 0.794665 1.831645 0.704887 0.663996 1.716970 1.335391 0.027250 0.914860 1.219676 1.163079 1.499094 1.582351 1.784156 1.039722 0.794989 0.345994 0.696063 0.060440 -0.034531 -0.014465 0.729209 1.532895 0.872457 0.952792 1.406826 1.546432 0.813457 0.051863 -0.057923 1.613237 0.606250 0.434442 1.717713 0.718646 1.651523 1.780966 1.568871 1.319644 -0.013301 0.004435 0.210102 0.085420 1.825764 0.539987 0.842744 1.405067 0.388233 0.609273 1.790490 0.014141 1.051512 0.713006 1.582000 1.973531 0.351609 0.656460 -0.024499 1.169279 0.458410 1.325534 0.274793 0.654578 0.624672 0.130134 0.295107 0.020848 0.076070 0.118378 0.940751 1.186130 0.553624 1.471068 1.866328 1.822359 1.955424 1.788350 1.554351 0.750241 0.632195 1.295917 -0.114335 1.180616 -0.008546 1.109797 1.348653 1.327862 1.845807 0.705358 0.002658)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
#(2048 83.108 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       78.937441 #(0.000000 1.689846 1.018490 1.611502 0.639207 -0.082787 1.592906 0.601026 0.457537 0.853588 0.246480 0.384884 1.166407 1.518233 1.610776 0.682841 1.354812 1.022675 1.260499 -0.112300 0.069724 0.538233 1.350546 1.731710 1.788711 0.798385 1.720292 0.552885 1.914312 0.083341 1.189678 1.001287 -0.016752 0.082208 1.635077 1.097941 -0.211066 1.915710 0.755430 0.377368 0.141690 1.508951 -0.063008 0.455045 0.203452 0.898819 1.541895 0.734814 1.350906 1.164589 0.953740 1.385840 0.788728 1.463142 1.354194 0.191281 0.579789 1.257225 0.559072 1.122363 1.468759 0.308060 0.535123 0.171149 -0.035758 0.383213 1.313251 0.349952 1.270535 1.135458 1.334934 1.890883 0.201654 1.594547 1.903186 1.646471 0.951539 1.635073 1.622014 1.631851 1.367584 1.552595 1.728701 0.503153 -0.095067 1.062992 1.535287 0.428952 -0.115113 0.904825 1.834421 1.316028 0.139571 1.862408 1.474241 0.357211 1.399016 0.565894 0.914744 1.336730 -0.021306 0.427360 0.982944 0.246389 1.520693 1.429115 1.795578 1.639579 0.993318 1.397084 1.476412 0.372916 0.127072 0.078109 1.452725 1.376697 1.742105 0.223687 0.910528 1.065049 1.633967 1.318213 0.850379 1.824021 0.982950 1.747574 1.683992 0.758363 0.534234 0.648109 1.761061 1.684306 0.998762 0.599534 0.636315 1.560104 -0.085181 0.292286 0.687333 1.315914 1.968365 0.498146 0.872936 0.750372 1.064806 0.913607 -0.281292 1.049262 1.431464 0.630016 0.070509 0.782794 0.040723 1.266929 0.098300 0.871494 1.325216 0.428614 -0.023960 -0.257052 1.568632 1.612023 0.370339 0.462301 0.888796 -0.048313 0.277648 1.743637 1.021040 1.635300 0.468648 -0.299562 1.640302 0.579774 0.064992 0.038520 0.939604 1.190498 0.120304 0.541286 0.541673 1.009244 1.560773 1.452497 0.646789 1.167337 0.164892 1.045596 1.183654 1.504427 0.689198 0.507543 0.474697 0.285834 0.591708 1.250029 0.879318 1.605841 0.233841 0.888556 0.769118 0.609719 0.005003 1.165066 1.500099 0.895021 0.312884 -0.181818 -0.210240 0.557941 0.168915 1.201735 1.729684 0.438679 0.710349 0.066805 1.172545 1.217293 1.790687 0.425805 0.600925 1.609051 1.095530 0.709253 0.066051 1.122549 0.360681 0.504521 1.391375 1.336403 0.056554 0.787635 0.366142 1.100069 -0.145467 0.490070 0.750042 0.057074 0.500767 1.115333 1.323101 1.500424 1.652321 1.578052 1.424819 1.991538 1.503509 1.341974 0.124773 0.286553 1.512043 1.195123 0.116467 1.495999 0.150475 0.027458 1.256602 1.914178 1.348946 0.392902 1.287852 0.230423 0.958003 0.103199 0.114147 1.300265 1.337726 1.960234 0.875466 1.375678 0.887083 1.091556 1.629083 0.517975 0.251541 0.586015 0.521301 0.456918 1.797111 0.628470 0.222309 1.874302 0.151586 1.270942 0.496347 1.704067 1.347411 0.882141 1.354015 0.482906 0.856096 1.842757 1.198720 0.849675 1.254644 0.826368 1.421665 1.565656 1.849673 0.296163 1.321414 1.594984 0.087468 1.904057 1.770304 0.793373 1.811382 1.738248 0.462200 0.809299 0.173428 1.173632 0.144430 0.424475 1.053220 0.438286 1.053618 1.341106 0.601239 0.987605 0.470342 -0.084584 1.657004 0.844639 0.225215 0.485905 0.210184 0.877181 0.051768 0.365625 0.433545 0.746015 1.265726 1.261056 0.846870 0.380347 1.777246 0.734969 1.263058 1.188062 1.231298 0.176469 0.633541 0.141868 0.355117 1.292107 0.788635 0.283102 1.491545 0.163836 1.840225 0.320653 0.924229 1.684915 0.457135 0.366316 0.874699 0.332267 0.811181 0.009053 1.707102 1.224700 0.647231 0.470735 0.285938 1.249680 0.848736 0.154419 1.302189 0.895984 0.384598 1.149654 1.339615 0.657930 0.197967 1.099859 0.240221 -0.153442 0.545081 0.929453 1.706713 1.972300 1.409127 1.618121 0.006566 0.576765 0.166203 0.440455 0.587109 0.296341 1.125394 1.573122 0.397018 0.779058 0.971743 0.402398 1.799594 0.038208 1.672239 0.269341 0.945851 0.650314 1.220807 0.761092 1.240143 1.289371 1.635050 1.213648 1.046902 1.318709 1.036745 0.879976 -0.197862 1.091013 0.799716 0.415004 0.529374 0.637845 0.383399 0.463124 1.542566 0.699920 1.623643 1.293281 1.800152 -0.015788 0.322487 1.117097 0.956307 0.996452 1.172323 1.326188 1.147377 1.113843 0.785183 1.575362 0.649795 0.523062 1.860141 0.223472 -0.063293 1.909246 1.736574 0.279197 1.477865 0.554212 1.260388 0.277292 1.918266 0.649419 1.792368 0.946606 1.286217 1.246372 1.179007 1.168477 1.733196 0.040035 1.869694 0.417707 -0.156793 -0.001456 0.649687 1.705122 1.327413 -0.139936 1.559127 -0.059925 0.722765 0.854277 -0.012595 0.185935 0.880412 0.884245 1.159530 1.868145 1.721058 1.444300 1.726310 1.551803 1.792034 1.663910 1.037587 0.549667 0.246300 1.919241 0.898305 0.864542 0.391918 1.169414 1.044794 0.943499 -0.018653 0.086991 1.211404 -0.409634 1.709608 1.558102 1.500905 0.023446 0.566640 1.586175 -0.075684 0.457930 0.590761 1.012075 0.155814 1.237055 1.774284 1.163196 1.795167 1.756188 0.853326 0.344718 1.331156 1.207746 1.380685 0.825802 -0.204853 0.528726 1.294224 0.820804 1.714428 1.655171 0.596704 0.807545 0.528328 0.170826 1.360744 1.164118 1.534691 1.959252 0.988720 1.825915 0.954587 1.225160 1.067375 0.648538 0.689203 0.574944 0.228763 0.739069 1.338497 1.522466 1.148973 0.666870 0.301196 1.345073 0.515258 0.304323 1.626868 0.573854 0.770224 0.922824 0.986235 0.208474 0.534145 1.448620 0.464703 0.329886 0.435022 1.080056 1.761027 1.393992 0.840270 0.262735 0.545578 0.566577 1.039111 1.013874 0.439128 1.378553 1.474475 0.078150 0.097586 0.430367 1.040096 0.267498 1.407214 0.720580 1.398352 1.906690 1.573703 0.691050 -0.001253 1.087465 0.916375 1.561718 1.104275 -0.024568 1.743167 0.657410 0.043592 -0.071737 1.277783 1.669473 1.445207 1.805207 1.084871 0.357552 0.482975 -0.129299 0.222610 0.964868 1.674946 1.111144 0.811232 1.444958 0.936872 0.630285 0.291784 0.547889 1.274707 0.491720 1.178913 1.597362 1.417560 0.905568 0.064594 -0.006279 0.681924 0.572009 0.510396 0.882066 1.337806 0.824705 0.900296 0.161452 1.480708 0.429205 0.998680 0.862028 0.872584 1.079492 0.049996 -0.061398 0.641068 1.223042 0.895426 0.016166 1.705578 0.370580 1.235064 -0.076644 0.016159 1.553502 0.272781 1.680527 1.735360 1.216306 0.022477 1.458031 0.335270 1.029615 1.390275 -0.072170 0.673519 0.918164 0.172376 1.873272 0.143937 0.143151 1.946490 1.050878 1.389078 1.718545 0.761876 1.584491 0.076813 0.426127 1.157282 1.665873 1.282022 0.297428 1.612887 1.525788 0.109507 0.850433 1.541619 1.906604 1.351349 0.712067 0.032909 1.741764 1.603154 0.331176 1.967791 -0.047457 0.458334 0.650869 1.822431 1.699982 0.392443 0.889921 0.738170 1.855018 1.469024 1.304174 0.145973 0.241900 0.483690 0.610548 0.244614 0.690385 0.625302 1.254416 1.724031 1.813264 0.692617 0.895372 1.588647 1.665977 1.093177 1.780833 0.040080 0.147953 0.452095 1.815039 0.610101 1.499230 0.418529 1.527535 1.809753 1.780717 1.208619 1.087756 0.044489 1.396951 1.008861 1.166751 -0.015608 1.040863 1.011715 -0.389544 1.669576 1.727841 0.409541 1.391926 1.267091 1.816381 1.266583 1.292674 1.538488 0.792896 1.144202 0.190028 1.168753 0.058544 1.008912 -0.033880 0.982838 1.145292 1.408490 1.218427 1.723407 1.907386 0.024240 0.720236 0.415344 1.872643 1.418392 0.399808 1.547256 0.227670 0.450452 1.674352 0.768133 1.757588 0.207193 1.366841 0.954998 0.102805 1.840467 1.672033 0.946903 0.828078 1.755832 0.884133 0.608293 1.688522 1.454057 -0.091730 -0.218085 1.430139 1.876307 1.361689 0.162513 0.428011 0.099895 1.496198 0.017040 1.527240 1.600076 0.702599 1.227307 0.445765 0.991653 0.193662 0.653609 0.032302 -0.082556 -0.076239 1.247906 1.725657 0.098284 0.458830 0.585844 0.788715 0.476530 1.571552 0.062623 1.411266 1.153636 1.113152 0.388102 1.666505 -0.010299 0.608357 0.002597 0.400810 0.236498 1.574672 1.024283 1.142883 0.739700 1.197592 1.569635 1.120229 0.086709 0.760356 1.446372 0.526550 0.983182 0.898425 1.210298 0.777244 1.126512 0.150391 1.780786 0.777891 1.141635 0.546798 1.666439 1.352269 0.900695 1.494562 0.579397 0.725360 0.320734 0.768538 -0.104320 1.309681 1.358290 0.178735 1.223322 0.916266 0.737696 0.608325 -0.024323 0.252577 0.022089 0.625930 1.055275 1.732884 0.450856 1.338871 0.564340 0.408611 1.468491 1.325711 0.758030 0.859666 0.600947 1.793976 0.169648 1.263140 0.822255 0.174901 0.291032 1.213018 1.398540 1.120993 1.022251 -0.023604 1.740733 1.244085 0.970147 0.777177 1.692535 0.188452 1.351635 1.161318 1.256602 1.751087 0.013196 -0.020020 1.265055 1.092603 1.917020 0.602027 0.227003 1.388828 1.812699 0.448303 0.993327 1.552104 0.642990 0.227204 0.536533 -0.171320 -0.037833 0.286305 1.107339 1.082198 1.823262 -0.118176 1.508469 0.574280 0.745998 0.151052 0.343717 0.754622 0.850362 0.188574 1.308237 0.557021 1.622333 0.740050 -0.106173 -0.036187 0.929924 1.028599 0.128394 0.655953 0.554832 0.478155 1.700954 1.480740 0.692557 0.784791 0.538025 1.181506 1.027617 1.061888 0.554753 1.885562 0.427859 0.878171 1.705383 1.731963 1.584336 0.604257 1.269572 1.224752 0.395571 1.377190 0.473402 1.037091 1.321103 0.241379 0.536589 1.212185 0.436461 1.328625 1.400157 1.301094 0.177789 0.219838 -0.214149 1.529232 0.144458 1.192349 1.282177 1.056078 1.550038 -0.173016 0.100030 0.265853 0.645390 0.923329 0.085731 1.043286 1.818031 1.237997 1.530902 0.423281 0.255900 0.058007 1.501958 0.593022 0.868580 1.054524 0.798523 1.892550 1.536475 1.470470 1.466108 0.333749 0.753592 0.381069 0.805574 -0.083849 0.230417 0.524273 1.576543 0.796882 1.326149 1.468547 0.883022 1.145331 1.129588 0.767485 0.714530 -0.051568 0.381323 0.900830 0.938250 1.115005 0.803678 0.478197 0.102689 1.790473 0.186175 1.138002 0.407343 0.081624 -0.078497 1.907566 0.568199 0.206528 0.698892 1.618703 1.116152 1.630912 0.735694 1.657675 -0.029995 0.597313 -0.074403 1.651119 0.671345 0.428239 0.340794 0.303227 1.221853 0.149125 1.845223 0.690593 1.519544 0.570921 0.378247 1.959188 -0.007756 0.533438 1.355284 0.385166 0.748448 0.519275 0.121959 0.127587 1.048075 1.696453 0.957310 1.509362 1.558839 0.717115 0.377524 0.867385 0.483117 1.383031 -0.097048 1.840125 1.664936 1.781564 0.631422 -0.103132 0.403964 1.771127 0.746246 0.918520 1.169435 0.737263 1.212805 1.178431 0.492576 0.605805 0.341944 1.377818 0.931836 0.529464 1.388507 1.052530 0.254824 -0.081377 0.937911 1.308701 1.681287 1.041637 0.101439 0.808291 0.144335 0.199211 0.907294 1.556385 1.606147 0.993618 0.565487 1.805140 0.626057 0.297878 0.108579 0.333362 0.383693 0.664077 0.780133 1.818635 1.485239 1.804957 1.845173 0.759440 0.296443 1.827938 0.708014 1.691701 0.097561 1.790460 0.002644 1.363152 1.554413 0.128835 0.088458 1.075820 1.662939 0.305822 0.097597 0.951771 0.612277 0.927043 1.564098 1.633525 1.149458 0.821430 0.621419 0.295695 -0.035046 0.526376 1.760242 0.054878 0.643260 1.248458 0.803343 1.623275 0.668091 0.657572 1.121589 1.524828 1.183610 1.417931 1.405314 0.536478 0.777992 1.514447 1.406728 1.296213 0.977414 1.302449 0.188034 0.494615 0.604689 1.593324 0.321907 1.433822 0.820379 0.896724 1.841162 0.648542 0.849222 1.488341 1.646264 0.422691 1.202526 1.552600 1.286227 0.205148 0.977204 0.071457 0.072226 0.854723 1.474934 0.490317 0.994710 1.695319 0.149264 1.945845 -0.050080 1.100174 1.428384 0.392919 1.388543 1.470599 1.687390 -0.209425 0.981376 1.820625 1.486939 1.163029 0.254903 1.663587 0.173397 1.158270 0.008252 1.527331 0.957022 1.565874 0.399190 1.405211 1.610452 0.517417 0.017736 1.604007 0.441982 -0.117242 1.540578 1.122133 0.783699 1.475956 0.425079 0.061031 1.809454 0.020958 1.791601 0.082641 1.232839 0.787976 0.330191 1.079316 0.726671 1.154152 0.664516 0.651535 0.733283 0.178061 1.170989 1.021345 1.431385 1.099593 1.694602 0.959398 1.896463 1.048918 0.980361 1.074828 1.193343 0.231910 1.142775 1.514885 0.820666 1.664680 1.082302 1.454204 1.588263 1.689028 1.772394 1.918052 0.740639 0.483110 0.712257 0.069489 0.905804 1.535153 0.363147 1.835617 0.006427 0.899992 0.380714 1.396011 0.685106 1.823151 0.493868 1.604512 0.224912 0.847624 1.141404 1.562281 1.012902 0.067857 0.682509 1.253834 1.124161 0.614664 0.283374 1.613595 1.434018 0.305996 1.201243 1.266871 0.838092 0.076908 1.420109 1.146620 0.622686 1.115452 0.924323 0.974351 0.825545 1.439257 1.047256 0.983947 -0.023433 0.739378 0.058896 1.009265 0.099088 0.208031 0.584839 1.555592 0.199829 1.098928 1.389603 0.203500 1.217365 0.487433 0.522761 1.901220 0.024564 0.335503 1.627773 0.511258 0.181775 1.136641 0.858910 1.135934 1.389248 1.254197 1.570636 0.887318 1.421787 1.619915 1.382710 0.324584 1.154740 1.550762 0.651293 0.306905 1.355501 0.026583 1.261312 0.455843 1.440013 1.036724 1.152275 0.920599 0.682892 0.672700 1.070057 1.453899 1.087117 1.098307 1.315810 1.292233 0.819280 0.701348 0.997834 1.209758 1.168699 0.077635 0.868252 1.083290 1.930890 0.353494 1.250223 0.310608 1.253033 1.727092 -1.975097 0.941442 0.539454 1.355973 1.005988 0.701618 1.813894 1.775295 0.242359 1.510528 0.986700 1.547890 -0.012287 1.356305 1.522370 0.878012 1.294380 0.155478 1.042814 0.348062 1.188096 1.135315 1.520515 0.878021 0.622847 1.073612 0.317276 1.370638 0.685988 0.992102 1.497485 1.458836 1.101655 0.035966 1.192860 0.380699 1.178862 0.618449 0.213396 0.559044 1.830349 1.447613 0.780973 0.149827 0.000783 1.578653 0.246629 0.619069 0.870396 1.009880 0.007773 1.529581 1.531002 1.437893 1.160448 0.240842 0.009787 1.814160 1.271699 0.449839 0.395650 -0.113986 -0.067771 0.643784 0.033350 0.664053 1.167828 1.330358 0.974541 1.039259 1.278764 0.649775 1.807600 1.456944 1.297261 1.733868 0.415873 -0.032983 0.865685 0.984468 1.747983 1.754950 1.624645 0.955834 0.669497 0.707638 0.496434 0.214751 0.573953 1.537258 1.920697 1.147869 0.279585 1.887307 1.463413 0.319350 0.444741 1.008618 1.021958 0.435657 0.185043 1.371241 0.855151 0.505792 0.741886 0.871680 0.370576 1.264162 1.034020 1.020442 -0.032455 0.151317 0.930427 1.250914 0.457365 1.711895 1.622588 1.474334 0.727044 0.158372 0.547219 1.964062 0.960274 -0.043104 1.429620 1.502524 1.799005 1.879995 0.965812 1.601466 -0.115173 1.786859 -0.082629 1.571997 0.151759 0.116636 -0.138644 1.220180 1.544541 0.711250 1.337424 1.122127 1.265975 1.641180 0.369341 0.941194 1.756270 1.554377 0.421053 0.367857 1.468897 0.120653 1.868696 1.648081 0.013217 0.546092 1.094144 0.662116 1.286971 1.508045 0.588153 1.236472 0.589536 0.744566 -0.014088 1.541068 1.703645 1.335776 0.751643 1.645108 1.835447 -0.004121 1.225363 0.415798 1.680503 0.651280 0.657478 1.380731 1.366587 0.360555 1.416929 0.218857 1.003629 0.196413 0.458188 0.219018 0.371207 0.792944 0.732561 1.096142 1.517356 0.544260 0.244358 1.027194 0.914613 -0.264228 1.386405 0.399853 0.192045 -0.056645 0.448320 1.168258 0.216500 1.282546 0.378607 0.437151 0.271768 0.227147 0.947933 1.169574 1.692082 0.352268 1.556365 0.430126 1.874195 1.391513 1.410537 0.937927 -0.099725 1.350224 0.198315 0.235114 1.785468 1.268030 1.467114 1.142498 0.972180 1.325000 0.953697 1.637360 1.870641 0.094691 0.308883 0.051680 0.986847 0.571862 0.079983 1.563896 0.588847 0.287709 0.038406 0.213414 0.278655 1.462399 0.910186 0.949603 0.231716 0.110559 0.750252 1.849528 -0.017336 1.351536 1.030800 0.135700 1.350730 1.752152 1.144277 0.825775 0.482093 0.451732 0.553985 0.050941 1.589921 1.226160 0.121789 1.892118 1.514707 1.947830 1.899008 0.106199 0.095068 1.481495 0.637728 0.793037 1.046402 0.656131 0.981478 1.645677 1.692830 1.201035 1.580738 0.862287 1.857116 0.752617 1.140952 0.535734 1.166873 1.813586 1.358043 1.562120 0.887429 0.453656 0.808900 1.329005 1.880473 1.667600 0.168656 0.082993 0.554744 0.113094 0.184322 1.116499 1.257143 1.463536 0.845188 0.753503 0.545217 0.808865 0.734823 0.010412 0.637141 0.721788 1.206453 1.725305 0.835897 0.641933 0.849589 1.122095 1.122129 0.082734 1.852811 0.736282 0.466664 0.727515 1.164618 0.912293 0.714009 1.682613 0.400246 0.931132 1.423104 0.690233 0.402124 0.519093 0.013658 1.495360 0.513651 1.911956 1.531564 0.638779 1.926638 0.085423 1.244383 1.405098 0.240999 1.024934 0.085108 1.136585 1.354954 0.694244 0.147529 1.114749 0.327110 0.099190 0.519456 1.197549 1.441452 0.985099 0.496182 0.344015 0.311060 0.341567 1.223570 0.104840 1.555720 0.310844 1.427243 0.253303 1.861208 0.751524 1.176798 0.011549 1.520196 0.725046 1.248869 1.766864 1.132848 0.788957 0.794897 0.471681 1.719229 1.386139 1.274509 -0.039519 1.527659 0.844650 1.774762 0.707953 1.216432 1.474809 0.078357 0.551012 1.506891 1.599422 0.243091 0.153408 0.457904 0.924834 1.678234 0.096402 0.949920 1.821400 0.824671 1.452500 1.524634 1.003177 1.464511 1.816518 1.713961 0.863097 0.517152 0.758012 0.136979 0.120142 0.690421 0.223639 1.498008 1.562219 1.678837 1.627798 0.839019 1.132131 1.535145 1.518018 0.297419 0.203623 0.546133 1.052566 0.784445 1.055616 0.148830 1.720326 0.140740 0.266692 1.425404 0.783229 0.124041 1.494743 0.644046 1.644611 0.750264 1.828214 1.787737 0.538946 0.550047 1.183492 1.041592 0.959210 0.270846 -0.035403 1.739175 0.534984 1.624026 1.611428 1.579430 1.022286 0.855608 1.828514 0.038338 1.291444 0.134507 1.254891 0.596733 0.399162 -0.114539 -0.055887 1.938324 1.170327 1.087488 1.697423 0.478833 0.757412 0.171117 1.059573 0.635458 -0.161792 1.015750 1.708417 0.270384 0.660484 1.333092 -0.030724 1.713327 0.151431 -0.174953 -0.041691 0.300599 0.725691 1.065660 0.588839 0.723013 1.086514 1.665008 0.904689 0.943094 1.548079 1.780577 1.098286 1.413405 0.080554 0.679165 0.451513 1.625382 0.791710 0.263149 -0.161505 1.192182 0.992099 0.009485 1.008730 1.535096 1.036929 1.297483 1.822460 0.975063 -0.085459 1.420746 0.376603 0.192391 -0.220597 0.389186 1.323278 0.098973 0.116023 0.308756 0.430429 1.250750 1.912196 0.463174 0.133615 1.184156 0.919106 1.188101 0.221491 0.139415 1.695088 1.043669 0.180492 0.167037 0.186236 1.544480 0.189182 1.816467 0.395217 1.129900 0.056081 1.599691 0.956415 1.935582 1.752012 1.235924 0.567385 1.236629 1.378551 -0.032682 0.967778 1.161775 0.439121 0.146630 0.210634 0.838256 0.256489 1.849426 1.034341 0.180033 0.002728 0.460610 -0.059008 1.026499 0.239384 0.014096 0.253629 1.317847 1.430188 0.739864 1.356334 0.501333 1.570755 0.964145 1.279445 0.064247 0.367146 1.924309 0.038641 1.441898 1.500527 0.252632 0.522914 1.127721 0.149886 0.482652 0.742163 0.866292 0.415201 0.038035 0.581754 1.410195 1.305935 1.399564 -0.002591 1.315112 0.506490 0.634606 0.712693 1.491569 0.763732 1.133934 1.646626 1.199255 1.255783 0.793887 0.463719 1.274033 0.646579 1.299227 0.074139 1.517832 0.680066 0.556593 0.198377 0.731884 1.265722 0.273535 0.174173 1.643091 0.233723 0.835886 0.331656 0.841667 1.950204 1.700806 1.493564 1.992014 1.047484 0.056101 0.246552 1.178977 1.446793 0.909130 0.666524 1.743752 -0.065462 0.647845 1.528075 -0.027380 0.892732 1.060713 0.961817 0.819512 0.522143 0.761281 0.549432 0.374579 0.281346 0.405971 1.961061 0.861053 0.951913 0.894288 0.120547 1.199477 1.578494 0.905148 0.153248 0.867220 0.425392 0.982660 0.841154 1.540130 1.454289 1.585546 1.708407 0.786107 0.741469)
       )
))



;;; ---------------------------------------- prime-numbered harmonics (and 1st) ----------------------------------------

(define primoid-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.76  #(0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
#(3  2.1949384212494 #(0 0 1)
     1.980 #(0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 #(0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 #(0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
#(4  2.5978584289551 #(0 0 1 1)
     
     ;2.2039985204158 #(0 0 12 4) / 20
     2.1930510997772 #(0.000 0.996 0.596 0.217)
     2.1930510997772 #(0.000 1.996 0.596 0.217)
     2.1930510997772 #(0.000 0.004 1.404 1.783)

     2.1927945613861 #(0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 #(0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 #(0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
#(5  2.7172040939331 #(0 0 1 0 0)

     2.476848 #(0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 #(0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
#(6  3.1241359710693 #(0 0 0 1 0 0)

     2.805574 #(0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 #(0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     )

;;; 7 prime --------------------------------------------------------------------------------
#(7  3.5358893688327 #(0 0 0 0 0 1 0)
     3.4886319637299 #(0 1 1 0 0 0 0)

     3.061861 #(0.000000 0.715739 0.261422 0.169339 0.062479 1.180650 0.330190)
     )

;;; 8 prime --------------------------------------------------------------------------------
#(8  3.8668605608975 #(0 1 0 1 1 1 0 0)
     3.7088719446694 #(0 1 0 0 0 0 1 0)
     3.7088720798492 #(0 0 0 0 0 0 1 0)

     3.263115 #(0.000000 0.207652 0.035023 1.752163 0.064249 0.346105 1.403170 0.065734)
     3.262977 #(0.000000 0.792550 1.965637 0.248661 1.936840 1.655647 0.598935 1.936915)
     )

;;; 9 prime --------------------------------------------------------------------------------
#(9  4.0320072303689 #(0 1 1 0 1 0 0 0 0)
     3.915482117267 #(0 1 0 1 1 1 0 0 0)
     3.9154822826385 #(0 0 0 1 1 1 0 0 0)

     3.382645 #(0.000000 0.562589 0.520940 1.521127 1.682374 0.721497 0.805534 1.254209 0.726847)
     3.382399 #(0.000000 1.437745 1.479554 0.480268 0.319088 1.280870 1.197460 0.749784 1.277141)
     )

;;; 10 prime --------------------------------------------------------------------------------
#(10 4.1794095733027 #(0 0 1 0 0 1 1 1 1 1)
     4.1718228801521 #(0 0 0 0 0 1 0 0 1 0)
     4.1209712028503 #(0 0 1 0 0 0 1 0 0 0)

     3.602714 #(0.000000 0.594153 1.304664 1.610566 1.241680 0.148124 1.920208 0.972526 1.622030 0.768137)
     3.602602 #(0.000000 1.405079 0.694565 0.388252 0.756491 1.849937 0.076683 1.023761 0.374165 1.226329)
     3.602329 #(0.000000 0.594431 1.305346 1.611464 1.243212 0.149889 1.922392 0.975619 1.625276 0.772405)
     )

;;; 11 prime --------------------------------------------------------------------------------
#(11 4.56653492525 #(0 0 1 0 1 1 1 0 0 0 0)
     4.487418596136 #(0 0 0 0 0 0 1 1 0 1 1)
     4.4176635742188 #(0 0 1 0 0 0 0 0 0 1 0)

     3.779310 #(0.000000 0.795034 0.550625 0.191200 0.209037 0.086985 0.729229 1.230323 0.721250 -0.058459 1.262582)
     3.779046 #(0.000000 0.211414 1.453486 1.827574 1.811694 1.949216 1.313595 0.823256 1.334141 0.127849 0.824659)
     )

;;; 12 prime --------------------------------------------------------------------------------
#(12 4.7299025085604 #(0 0 1 0 1 1 1 1 0 1 0 0)
     4.6850221453825 #(0 0 1 0 1 0 1 1 1 0 0 0)
     4.3595271110535 #(0 0 0 0 0 0 1 0 1 1 0 1)

     3.936657 #(0.000000 0.367346 0.997085 1.763425 1.295636 0.140826 0.757652 1.565853 1.284651 0.304758 0.331248 0.325474)
     3.936584 #(0.000000 0.366730 0.995852 1.762390 1.293763 0.137304 0.753397 1.560313 1.278944 0.297723 0.322472 0.315856)
     )

;;; 13 prime --------------------------------------------------------------------------------
#(13 5.06212613641 #(0 1 0 0 1 0 1 0 1 1 0 0 0)
     4.9963458682976 #(0 1 0 0 1 1 1 1 1 1 1 0 1)
     4.9494566649932 #(0 1 0 0 1 1 0 0 0 0 1 1 1)
     4.8980793952942 #(0 0 0 1 0 0 1 1 1 1 1 1 0)

     4.180492 #(0.000000 1.772215 1.337771 1.572723 0.985677 1.717413 1.821689 0.986759 1.151868 0.637061 0.595788 1.561353 1.695959)
     4.155503 #(0.000000 1.115751 0.463368 0.110540 0.613302 1.581997 1.394002 -0.005270 1.724217 0.023531 1.743892 0.616897 0.124222)
     4.155104 #(0.000000 0.888606 1.516761 -0.128988 1.376524 0.383262 0.572385 -0.041726 0.228441 1.918487 0.187862 1.304384 1.779710)
     )

;;; 14 prime --------------------------------------------------------------------------------
#(14 4.827317237854 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.328845 #(0.000000 1.631608 0.105786 1.732589 0.749692 0.105117 0.626364 1.395811 1.430614 0.705052 0.780338 1.582470 1.046721 0.950090)
     4.326087 #(0.000000 0.362120 1.888454 0.251240 1.230086 1.854603 1.332783 0.548088 0.507657 1.215301 1.123713 0.312281 0.829297 0.910443)
     4.325356 #(0.000000 0.359558 1.885647 0.244632 1.221244 1.839379 1.316045 0.525308 0.483244 1.183590 1.084986 0.271051 0.780356 0.855105)
     )

;;; 15 prime --------------------------------------------------------------------------------
#(15 5.2087744996197 #(0 0 0 0 1 0 0 0 1 1 1 0 1 1 1)
     5.1680134390775 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 1)
     5.116711139679 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.482073 #(0.000000 0.430607 1.010272 0.810816 1.103409 1.274070 0.728190 1.576850 0.465054 1.582164 0.985518 1.441214 0.149277 1.211260 1.202522)
     4.468487 #(0.000000 -0.170894 1.166594 0.261941 0.795313 -0.037553 0.002464 1.693993 1.753074 1.644706 -0.070294 0.671844 1.070595 0.053777 -0.250027)
     4.467959 #(0.000000 1.165302 0.822381 1.719844 1.177673 0.000074 -0.047034 0.249259 0.174863 0.272306 -0.034377 1.204925 0.800910 1.798882 0.085175)
     )

;;; 16 prime --------------------------------------------------------------------------------
#(16 5.3690811579971 #(0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1)
     5.2829658956774 #(0 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0)
     5.2015118598938 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.662724 #(0.000000 0.254861 1.684311 0.497899 0.656871 1.722503 0.329340 1.047910 0.635053 1.158523 0.448629 0.050078 1.573549 1.470622 1.991728 1.975781)
     4.607704 #(0.000000 0.863393 1.574552 1.705278 1.569228 0.102457 0.353917 0.651931 1.696462 1.761383 0.072955 1.294632 -0.307040 1.072928 1.543936 0.777891)
     4.602871 #(0.000000 0.062093 0.362233 0.127394 0.197994 1.532775 1.215275 0.817953 1.672076 1.484960 0.991530 1.690500 1.074819 1.570572 1.070642 1.684336)
     4.602505 #(0.000000 0.065822 0.364277 0.133567 0.202441 1.541212 1.225002 0.832999 1.687176 1.503245 1.015565 1.715739 1.103351 1.602678 1.102870 1.723542)
     )

;;; 17 prime --------------------------------------------------------------------------------
#(17 5.6171013426079 #(0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1)
     5.5776449751108 #(0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1)
     5.5725093120778 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0)
     5.5318970680237 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.732840 #(0.000000 1.594259 1.537383 1.654009 0.059827 1.456178 1.640619 0.725632 -0.052840 0.741210 1.485914 1.399005 0.596215 1.791931 0.887057 0.720499 0.037113)
     4.720335 #(0.000000 0.741764 1.745798 1.858232 0.394387 0.086105 0.379819 1.692029 1.022315 0.008990 1.069411 1.241786 0.653220 0.028583 1.334535 1.358902 0.976814)
     )

;;; 18 prime --------------------------------------------------------------------------------
#(18 5.6380511040237 #(0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0)
     5.518 #(0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.881625 #(0.000000 1.688958 1.279188 1.177293 -0.318361 0.802007 0.250184 -0.270074 -0.003800 1.870180 1.633808 0.442468 -0.114869 0.906870 1.252354 1.245762 -0.107436 0.786324)
     4.856709 #(0.000000 0.761349 1.398941 1.387382 -0.020892 1.258976 0.808017 0.461939 0.840319 0.868659 0.861865 1.748851 1.411948 0.655653 1.051244 1.278422 0.114546 1.310974)
     )

;;; 19 prime --------------------------------------------------------------------------------
#(19 5.9841752522819 #(0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0)
     5.707 #(0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)
     5.7069295560724 #(0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     5.050598 #(0.000000 0.718637 1.798883 1.579536 0.015456 1.806520 0.208708 1.353434 1.112089 1.766036 0.720549 1.107314 0.509279 -0.117956 1.148417 0.726527 0.254889 1.769009 0.642150)
     5.016706 #(0.000000 1.615592 1.626110 1.313424 1.625675 1.187140 1.457241 0.377999 -0.071449 0.474555 0.996594 1.284924 0.372672 1.499744 0.593870 0.033098 1.161407 0.320243 1.064382)
     )

;;; 20 prime --------------------------------------------------------------------------------
#(20 5.9970674135126 #(0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1)
     5.9696664680177 #(0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     5.931 #(0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0)
     5.8879864574703 #(0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.219761 #(0.000000 1.154818 1.816853 1.891880 -0.032202 0.197019 1.018732 1.639212 0.953425 0.695031 0.577021 1.061687 0.455312 0.907081 0.481515 1.400124 0.806615 1.262883 0.187894 1.041939)
     5.214980 #(0.000000 0.840843 0.870934 -1.936784 0.124790 0.037596 1.842854 1.506881 0.243469 1.454635 0.781572 1.020004 -0.209275 1.345639 1.356003 1.554666 0.375592 1.561439 1.206468 1.818047)
     5.190073 #(0.000000 1.305012 0.829288 0.733488 0.022101 1.272217 1.780612 0.000702 1.609711 0.398599 0.056785 1.250942 0.237528 0.553904 0.013636 0.751667 1.626948 0.622700 1.016243 0.075548)
     )

;;; 21 prime --------------------------------------------------------------------------------
#(21 6.1566464314438 #(0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0)
     6.1375694270894 #(0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0)
     6.1138607493652 #(0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.486939 #(0.000000 1.054487 0.664992 0.221211 0.326872 1.588195 1.592726 1.336003 -0.011408 0.242484 1.885446 1.030420 0.900483 1.377784 1.752653 1.724134 1.420616 1.866623 1.449894 1.955882 0.634259)
     5.329864 #(0.000000 0.272438 0.199162 0.592353 1.763983 0.854454 0.508802 0.394659 -0.117248 0.409584 1.672133 1.498039 0.065454 0.630259 0.862041 1.058228 0.978442 1.314381 0.056427 1.089844 1.751788)
     )

;;; 22 prime --------------------------------------------------------------------------------
#(22 6.389194775669 #(0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1)
     6.3868380259357 #(0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1)
     6.33751039349071 #(0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)
     6.3374844973589 #(0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.446875 #(0.000000 1.499440 1.283938 1.144681 0.719116 0.527122 0.660420 1.925016 0.467488 0.510019 0.651972 0.189033 1.100881 0.083261 0.858169 -0.068443 1.057677 1.751471 1.463218 0.262023 0.956227 1.595986)
     )

;;; 23 prime --------------------------------------------------------------------------------
#(23 6.540168762207 #(0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1)
     6.5358400344849 #(0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1)
     6.5309901747782 #(0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.685285 #(0.000000 0.254600 -0.012994 0.113546 0.539539 1.037398 1.757854 1.055458 0.272297 -0.046061 0.094856 0.510270 0.402511 -1.992644 1.761629 0.351312 0.348956 1.246604 0.787427 1.083729 1.586582 0.611927 0.184053)
     5.567379 #(0.000000 0.276519 0.590196 0.226039 1.171867 1.340464 0.217215 0.993714 0.638313 1.635401 0.478131 0.411698 0.177712 0.474576 0.294538 0.736543 1.282025 1.529047 0.619437 0.150444 1.091367 1.495687 1.461734)
     )

;;; 24 prime --------------------------------------------------------------------------------
#(24 6.6087727546692 #(0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0)
     6.5951228141785 #(0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     6.5623834870329 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.949920 #(0.000000 0.128611 0.694957 0.658206 0.886509 0.768948 1.233345 -0.189112 1.759586 0.197333 1.393597 1.021426 0.619470 0.959617 0.232166 0.499447 1.419100 0.526324 0.173261 0.228559 1.292462 0.139965 0.391749 1.913935)
     5.650520 #(0.000000 0.857557 1.842675 1.202065 1.234674 0.492676 -0.102075 -0.239685 1.781251 1.389180 0.305730 1.687909 -0.302137 1.101152 1.813988 1.401012 1.339875 0.431908 0.908768 0.169122 0.275926 0.743300 1.184128 1.445914)
     )

;;; 25 prime --------------------------------------------------------------------------------
#(25 6.84773846418216 #(0 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0)
     6.8138422966003 #(0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1 1 1 1)
     6.6733964421745 #(0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0)
     6.635721206665 #(0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.988895 #(0.000000 0.958244 1.345633 0.953582 0.394970 1.901749 1.046106 1.586016 1.673907 1.504535 0.855726 1.185762 0.711920 0.273710 0.138584 1.350736 -0.012172 1.001100 -0.022766 1.615113 1.538010 -0.061672 0.033456 -0.153052 0.855356)
     5.817801 #(0.000000 0.565115 1.218582 1.332443 1.457356 0.307620 -0.086640 1.159236 1.303142 0.191122 1.559887 0.364215 -0.020320 1.538774 -0.224345 1.038168 1.392305 1.023305 1.898968 0.543144 1.617259 0.873326 1.477436 0.455001 0.528076)
     )

;;; 26 prime --------------------------------------------------------------------------------
#(26 6.9502968788147 #(0 1 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1)
     6.9264550209045 #(0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.9264546836564 #(0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.8401503562927 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.114195 #(0.000000 0.487946 1.509453 0.656427 -0.061099 1.024534 1.764200 0.719985 0.845113 1.416156 0.999041 1.502717 1.217362 0.470360 0.781338 0.378324 1.225888 1.318663 1.531597 0.037759 1.356653 1.047908 -0.226597 0.213201 0.995851 0.546112)
     6.065277 #(0.000000 1.952952 1.987242 0.420412 0.992066 0.834479 -0.019176 1.658533 0.252187 0.140726 1.394199 0.402324 0.268800 0.242479 -0.131235 1.784926 -0.095062 0.379551 1.355690 0.747495 0.652914 0.431680 0.652519 1.167388 1.821792 0.276656)
     )

;;; 27 prime --------------------------------------------------------------------------------
#(27 7.0658421516418 #(0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0)
     6.9657588005066 #(0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1)
     6.949148677349 #(0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)
     6.9491486549377 #(0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.306082 #(0.000000 1.014487 0.044686 1.244051 0.504595 0.487037 0.595344 0.942363 1.421788 1.271617 1.672410 0.919810 -0.088188 -0.004921 0.389662 1.276380 1.315062 0.969929 1.267761 0.826017 0.908595 0.237755 0.772601 0.772305 0.470772 1.354427 0.868884)
     6.208117 #(0.000000 1.512045 0.359682 0.506255 0.085924 1.805313 1.736555 1.032065 0.043760 1.546411 0.703269 1.873342 1.194067 0.033337 0.973932 0.070491 1.492023 0.364381 0.350403 1.174480 1.292443 1.655361 -0.178682 1.921343 1.907984 1.669334 0.318176)
     )

;;; 28 prime --------------------------------------------------------------------------------
#(28 7.2303333282471 #(0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0)
     7.2299618721008 #(0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     7.2240290641785 #(0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1)
     7.1576952692751 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)
     7.1576952934265 #(0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.266481 #(0.000000 0.464977 0.954351 0.843190 1.125317 0.010507 1.072665 0.506420 0.334117 -0.002274 0.804342 1.777515 0.702462 1.533180 1.276804 0.055155 0.922788 0.985869 0.597230 0.416958 0.876178 1.168420 0.578974 1.494226 1.590875 0.468961 1.546102 0.116359)
     6.196485 #(0.000000 0.458944 0.985055 0.811841 1.148693 -0.005212 1.062478 0.554335 0.356816 -0.025801 0.767531 1.763049 0.823656 1.563708 1.227984 0.170565 0.942617 0.969630 0.568960 0.481321 0.845313 1.114047 0.660943 1.585424 1.609223 0.526033 1.503429 0.092184)
     )

;;; 29 prime --------------------------------------------------------------------------------
#(29 7.2895045280457 #(0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     7.24235304747816 #(0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)
     7.2415904369233 #(0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.372077 #(0.000000 0.906700 0.020499 1.650846 0.580089 0.578369 1.397436 1.003048 -0.081655 0.050050 1.763555 1.526930 0.976916 1.568543 -0.090164 0.995351 1.487167 1.249980 0.097075 -0.067935 0.669015 0.440346 0.565400 1.317269 1.160383 1.242277 0.930720 0.791130 0.517575)
     )

;;; 30 prime --------------------------------------------------------------------------------
#(30 7.5369029045105 #(0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0)
     7.5239403940776 #(0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1)
     7.5096759796143 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1)
     7.4977698326111 #(0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1)
     7.1189651489258 #(0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.658580 #(0.000000 1.477513 0.548175 1.347892 0.733820 0.121555 -0.032344 0.713938 0.819135 1.370527 1.738632 0.698418 0.364253 0.441036 -0.035716 0.516534 0.740702 0.984618 1.142869 0.406938 1.301988 0.810169 0.504070 1.569824 0.496394 0.536230 1.606405 0.027724 1.473284 1.742612)
     6.456773 #(0.000000 1.682298 0.804525 0.935259 0.852365 1.701892 1.279341 1.476692 1.214874 1.902003 0.957590 1.784524 1.954155 1.382964 0.111155 0.106883 1.261078 1.571988 0.412759 0.387649 1.591012 0.972707 0.057129 0.913450 1.666840 1.659204 1.092741 1.343541 0.655401 0.866116)
     )

;;; 31 prime --------------------------------------------------------------------------------
#(31 7.5859903003103 #(0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1)
     7.5834159851074 #(0 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0)
     7.5718903541565 #(0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1)
     7.4906754493713 #(0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.715110 #(0.000000 0.725211 0.683580 0.750597 1.391109 0.559370 0.384624 1.051186 1.685491 0.785928 1.483000 1.124375 1.692462 1.314818 0.611419 1.753370 1.283488 0.879908 0.233025 0.968221 0.809905 0.782282 0.050986 1.316304 1.849362 0.837962 0.668673 1.033563 0.899101 1.872927 0.388541)
     )

;;; 32 prime --------------------------------------------------------------------------------
#(32 7.7375974655151 #(0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0)
     7.719434261322 #(0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0)
     7.6655950546265 #(0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1)
     7.6567826271057 #(0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0)
     7.6309351921082 #(0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     6.945565 #(0.000000 0.046495 0.496817 0.680238 1.009260 1.131116 1.092336 0.893510 1.099114 0.815014 -0.083387 0.117703 1.618006 0.348695 1.351638 1.392799 1.435601 1.178568 0.246956 1.532146 1.530973 0.353380 1.008482 1.228068 1.716716 1.252232 0.794560 0.240630 1.365270 1.163613 1.530387 0.931563)
     6.868423 #(0.000000 0.299978 0.514058 0.053964 0.542128 0.122705 0.887974 1.276625 1.025220 1.346655 0.784384 0.686179 0.263848 0.933113 0.840397 1.726479 0.051412 1.939447 0.278912 -0.081005 1.403209 0.883998 -0.014454 1.586441 1.411201 -0.042922 0.306515 0.996493 1.744986 1.056448 0.331918 1.402460)
     )

;;; 33 prime --------------------------------------------------------------------------------
#(33 7.9869227409363 #(0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
     7.8325562477112 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0)
     7.7895503044128 #(0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1)
     7.7389698028564 #(0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     6.914355 #(0.000000 1.554709 1.222325 0.792367 1.049103 0.742138 0.876199 0.536015 1.040981 1.003315 1.121035 0.437391 1.438037 0.339961 0.862777 0.435682 0.463584 1.436555 -0.045105 1.031626 0.326208 1.844769 1.009536 -0.070087 0.434222 0.877722 1.762874 0.343356 1.717990 1.467251 0.647507 1.860696 0.603647)
     )

;;; 34 prime --------------------------------------------------------------------------------
#(34 8.0215682983398 #(0 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     7.9724597930908 #(0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0)
     7.9716167449951 #(0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9716163031165 #(0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9624452590942 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     7.053846 #(0.000000 1.757683 0.219567 1.742969 0.309832 0.883629 0.426015 0.611588 1.959158 1.190735 1.283537 -1.865210 1.403648 0.671456 1.570826 -0.354368 1.603689 1.234174 1.053732 0.638777 0.718266 1.165709 0.665924 0.035389 1.384529 1.140937 0.571096 0.091813 0.800454 1.433826 1.237339 0.510342 1.562376 0.400741)
     )

;;; 35 prime --------------------------------------------------------------------------------
#(35 8.2040424346924 #(0 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0)
     8.1993579864502 #(0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0)
     8.1756086349487 #(0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1)
     8.1555442810059 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0)
     8.1336851119995 #(0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 0 0)
     8.1317510604858 #(0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 0 1 0 0 0 0)
     8.0019035339355 #(0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.229111 #(0.000000 1.231983 0.486040 0.577601 -0.012197 0.838851 1.162661 1.750225 1.480975 0.857238 0.974172 1.385849 0.196467 1.743568 1.401858 0.748455 0.103496 1.441526 0.391075 0.230401 0.991860 1.528312 0.473115 0.562470 0.294655 0.049385 0.675186 0.327022 0.697676 0.555997 1.391450 0.187347 0.223156 0.168209 1.110493)
     )

;;; 36 prime --------------------------------------------------------------------------------
#(36 8.4211139678955 #(0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     8.4162702560425 #(0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0)
     8.4114933013916 #(0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     8.3864717483521 #(0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0)
     8.3820142745972 #(0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0)
     8.3783054351807 #(0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0)
     8.3031883239746 #(0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.404178 #(0.000000 0.349597 1.716038 0.690553 0.687639 0.221012 0.695126 0.411892 0.166628 1.193809 0.529764 1.092664 0.874871 0.839078 1.019423 0.026393 0.456310 -0.081007 1.374823 0.044332 1.771459 1.642610 0.600080 1.318849 1.746532 0.618120 0.686859 1.495821 0.653764 1.669378 -0.037137 0.363138 0.574791 1.309700 1.649377 -0.147887)
     )

;;; 37 prime --------------------------------------------------------------------------------
#(37 8.6493539810181 #(0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0)
     8.5117635726929 #(0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0)
     8.4779825210571 #(0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)
     8.4775905609131 #(0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.355103 #(0.000000 1.297016 1.085901 1.270940 0.623129 1.068545 0.632645 1.726241 1.127554 0.020035 1.494836 0.203468 1.597125 0.155391 1.228219 1.087730 0.701184 0.157445 1.802225 0.997757 -0.003140 0.049293 0.881400 0.756950 1.400671 0.203737 0.778794 0.564982 1.042535 0.081237 0.525257 -0.076745 1.241541 1.383181 1.882417 1.280355 1.618429)
     )

;;; 38 prime --------------------------------------------------------------------------------
#(38 8.6871099472046 #(0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0)
     8.67653465271 #(0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0)
     8.6688671112061 #(0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0)
     8.6612920761108 #(0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0)
     8.6306476593018 #(0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0)
     8.6206035614014 #(0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0)
     8.5991640090942 #(0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0)
     8.5527725219727 #(0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

     7.573586 #(0.000000 0.248408 1.278089 -0.086094 0.371944 0.914090 1.962709 0.609285 0.192338 0.761292 1.612434 1.666337 0.435003 1.022096 1.329415 -0.364564 0.275582 0.234433 1.188155 -0.245500 1.737331 0.470040 -0.111115 0.712031 1.921176 0.905594 0.314595 0.610337 0.729598 0.532701 0.521500 1.366396 0.213289 0.296348 -0.150930 1.317939 0.614995 0.099802)
     )

;;; 39 prime --------------------------------------------------------------------------------
#(39 8.9125862121582 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 0)
     8.8173857964668 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.634012 #(0.000000 0.042681 1.027751 0.102947 1.472368 1.405094 0.905971 0.337563 0.018822 1.097136 0.902141 1.409376 0.342976 0.454238 1.346778 1.662894 0.033674 0.984603 1.391594 1.387653 1.108578 1.295792 0.968019 0.586814 0.529142 0.621100 1.251114 0.957131 1.042381 0.912972 1.461099 0.129751 1.322284 1.822587 1.556607 0.052453 0.499121 1.268853 1.378747)
     )

;;; 40 prime --------------------------------------------------------------------------------
#(40 9.0681540417544 #(0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1)
     8.9134502410889 #(0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     7.811677 #(0.000000 1.606372 1.708650 1.164091 0.070664 0.438284 0.925625 0.653761 0.285719 1.310341 1.566530 0.551547 1.266693 0.294219 0.676875 1.139287 0.658980 0.410301 1.703919 0.461543 1.687469 0.224294 0.449290 1.886059 1.752414 1.267174 0.602352 0.275341 1.397959 0.579675 0.636600 1.552175 0.598055 1.436111 1.770487 0.639434 1.383003 -0.039689 1.433201 1.442039)
     )

;;; 41 prime --------------------------------------------------------------------------------
#(41 9.295313835144 #(0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     9.1567583084106 #(0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     7.896724 #(0.000000 0.611471 -0.038036 1.228898 0.385347 0.040518 -0.205041 -0.141688 0.136159 -0.044044 1.496521 0.492978 1.520705 1.941823 1.343851 0.777914 0.012500 1.486257 1.079901 0.410520 0.519316 0.764307 1.292590 0.530463 1.697495 0.689827 0.613289 0.973484 0.945034 0.811200 1.709230 1.319255 0.589344 0.205769 0.678197 1.574715 0.274661 0.815107 0.362836 1.351584 0.690213)
     )

;;; 42 prime --------------------------------------------------------------------------------
#(42 9.3096771240234 #(0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0)
     9.2193641662598 #(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

     8.016184 #(0.000000 -0.291512 -0.100016 1.534256 0.920647 1.277050 1.312375 1.720782 0.392198 1.456934 1.082943 1.212166 0.294325 0.004793 0.762919 0.516225 1.618765 0.489047 1.228725 0.837576 1.953801 1.540962 0.776034 0.326776 0.251790 1.766810 0.533914 1.043314 1.124539 0.745273 1.176358 0.321088 0.153090 0.527726 1.123364 1.312058 0.328806 0.204066 1.404972 0.911502 0.894116 0.772235)
     )

;;; 43 prime --------------------------------------------------------------------------------
#(43 9.4925568571597 #(0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     9.4329051971436 #(0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     8.117380 #(0.000000 1.842087 0.240000 0.005942 1.205212 0.146893 0.110616 1.679117 0.700643 0.796349 0.948554 1.740978 0.483293 0.385560 1.153672 1.554812 0.060414 1.933818 0.200326 1.493279 1.446128 1.411565 0.092756 1.174802 1.892478 0.087790 1.133558 0.218843 0.029965 0.134713 -0.134121 0.719584 0.768232 1.613737 1.410761 0.297493 1.702758 1.215832 0.830435 0.020807 1.765772 0.226708 1.490764)
     )

;;; 44 prime --------------------------------------------------------------------------------
#(44 9.6622378996026 #(0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     9.6263332366943 #(0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

     8.215317 #(0.000000 1.318160 0.197729 0.803473 1.004322 0.886728 0.515874 0.795863 0.293865 0.795663 0.112448 0.806048 1.766879 0.052205 0.210621 1.814594 1.845717 0.972716 1.444914 0.287591 0.558596 0.184601 1.290546 1.309210 0.651282 0.234753 1.110353 1.301404 0.549284 -0.043084 0.372597 -0.011711 0.585949 0.978766 1.300105 1.502709 1.058925 -0.263301 0.235962 1.064019 0.870735 1.508524 0.916606 1.878285)
     )

;;; 45 prime --------------------------------------------------------------------------------
#(45 9.8476276594031 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1)
     9.7923860549927 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.326119 #(0.000000 0.615534 0.786808 1.463577 0.302019 0.572091 0.243502 1.524952 1.154508 0.327857 1.312145 1.313026 0.949294 0.781999 0.312781 0.886116 1.325416 1.542244 1.265398 0.192906 1.601553 1.432439 0.524971 0.978226 1.459196 1.894745 0.965588 1.805077 0.714599 1.729128 0.478069 0.037499 1.222079 1.346949 1.229158 1.575769 -0.047226 1.222618 0.785747 1.328347 0.458307 0.555124 0.709305 -0.098620 0.742388)
     )

;;; 46 prime --------------------------------------------------------------------------------
#(46 9.928765296936 #(0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0)
     9.8914480209351 #(0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)
     9.7220277786255 #(0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.388195 #(0.000000 0.341399 0.073766 1.441221 0.964981 0.723168 0.793927 0.409368 -0.012034 1.722063 0.073566 1.384487 1.221381 -0.209197 1.242466 0.619383 0.404177 1.051852 1.658824 0.621661 1.026108 0.237692 0.647377 1.189008 0.930807 0.163838 0.991847 1.522371 1.886735 0.052868 -0.337804 0.524642 1.369977 0.937413 1.089298 0.852838 0.013817 1.606451 0.689174 1.067406 1.206902 1.163092 1.326614 0.660474 0.602437 1.119066)
     )

;;; 47 prime --------------------------------------------------------------------------------
#(47 10.097447395325 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     10.0            #(0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     8.496667 #(0.000000 1.151517 0.189498 0.013781 0.945422 0.165356 1.213007 1.579839 1.070307 1.030655 1.286981 0.618317 -0.305344 0.920514 0.375348 1.737515 1.808712 0.165928 1.021635 0.358213 0.410242 1.648572 1.036397 1.774765 1.549977 1.826003 0.623620 1.348277 1.019149 1.205025 1.343082 1.000649 1.208319 1.279188 1.894045 1.245705 0.007883 1.289943 1.181721 1.205084 -0.184564 1.113608 1.470585 0.241726 0.036454 0.580900 0.228296)
     )

;;; 48 prime --------------------------------------------------------------------------------
#(48 10.298553466797 #(0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0)
     10.248653411865 #(0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0)
     10.073040962219 #(0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.604461 #(0.000000 0.306203 1.667769 1.680415 0.428100 0.559237 0.820987 1.781776 -0.001529 0.107037 1.002614 0.977037 0.536281 1.124314 0.776388 0.403581 1.067061 0.469432 1.806294 0.567358 0.004000 0.612561 1.600977 1.219969 1.664782 -0.100684 0.985158 1.276297 1.305389 0.716428 1.608092 1.275434 -0.028608 0.642270 1.748536 0.849084 1.287227 0.773784 0.595312 1.018597 1.388126 1.074577 1.874473 1.172345 0.675567 0.990745 0.329066 -0.172689)
     )

;;; 49 prime --------------------------------------------------------------------------------
#(49 10.28332063912 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0)
     10.207101821899 #(0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 0 0)
     10.209 #(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     8.721727 #(0.000000 1.499026 0.320811 1.012405 0.965354 0.238586 -0.062636 0.816989 0.799934 1.565103 1.180433 1.616783 1.191686 1.753034 0.326889 1.457085 0.129444 1.740509 0.413310 0.047595 1.160271 1.020068 0.609400 1.770818 0.009382 0.128358 -0.009560 0.510302 1.223153 1.135703 1.635406 1.940126 1.813497 0.002140 1.210441 0.688281 -0.121560 1.807460 1.698233 1.538374 0.855067 1.667660 0.945316 -0.069390 0.328337 0.889780 0.563232 1.817766 1.256732)
     )

;;; 50 prime --------------------------------------------------------------------------------
#(50 10.669495582581 #(0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1)
     10.402973175049 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     8.698816 #(0.000000 1.484777 1.088926 1.020064 1.347675 1.055405 0.560314 1.688912 1.249576 1.209396 1.226523 1.429666 0.837134 1.808991 0.071307 0.700038 -0.100589 0.062265 1.078496 1.917410 1.162420 0.994992 0.947585 0.198830 0.740457 0.446782 0.918367 0.122761 0.837213 0.056895 1.295449 1.238670 1.926003 0.868891 0.442390 -0.213250 0.810476 1.014028 0.114921 1.518697 0.818511 1.330636 0.888278 1.413279 -0.001982 1.586011 0.586157 1.277906 0.034523 1.187727)
     )

;;; 51 prime --------------------------------------------------------------------------------
#(51 10.5841327092253 #(0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     8.805015 #(0.000000 0.539973 1.555252 0.814573 0.453988 -0.004906 1.087602 1.343043 0.843771 0.098192 -0.265161 1.563033 0.801463 -0.168911 1.833601 0.442514 1.200853 0.877153 0.989126 1.024179 -0.061071 0.011869 0.286293 0.879863 0.602071 0.797164 0.295490 1.396754 0.507117 0.424387 0.410578 1.735741 0.436422 0.246191 1.055064 0.393157 0.246676 0.479976 0.834408 0.328859 1.197324 1.185085 1.910551 1.626711 1.757691 1.204866 1.035406 0.687687 0.204443 -0.083877 0.599236)
     )

;;; 52 prime --------------------------------------------------------------------------------
#(52 10.767134666443 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0)
     10.737469673157 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1)
     10.64324760437 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     9.037908 #(0.000000 0.258676 0.085364 0.269316 1.792440 1.695660 1.754235 0.570365 1.345382 0.685811 0.376499 -0.068359 1.102238 1.628337 0.018979 0.256896 1.399966 0.450366 1.380123 0.058452 1.303262 0.491376 -0.060279 1.471446 0.121811 1.381052 0.065406 0.529831 0.765545 0.256384 0.709690 0.778739 0.998882 1.449813 0.684843 1.760110 0.027686 1.838691 1.056877 1.660123 1.622804 0.865755 0.860272 1.110810 0.290132 1.262879 0.496774 1.492458 0.676634 0.836150 1.137608 1.015006)
     )

;;; 53 prime --------------------------------------------------------------------------------
#(53 10.969209228042 #(0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
     10.959488868713 #(0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.950836181641 #(0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0)
     10.851609230042 #(0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.848851203918 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     10.678050692694 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     9.185722 #(0.000000 0.743263 1.192720 0.398340 0.241251 0.069790 0.881619 1.794739 1.197970 1.736767 1.822395 0.316728 1.547089 -0.159447 0.462774 1.881863 0.627909 0.505724 0.788391 1.787601 0.948842 0.177025 0.569590 -0.213235 1.627508 0.511607 1.233894 1.539622 1.302983 1.077375 0.795886 0.592300 1.683804 0.558517 0.355999 0.835711 0.800297 0.612392 1.785568 1.952077 0.872005 1.387916 0.797751 1.873289 0.247170 1.216640 1.088446 0.925218 1.176888 0.661397 1.138383 0.890807 1.728090)
     )

;;; 54 prime --------------------------------------------------------------------------------
#(54 11.062943458557 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1)
     11.050 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1)
     10.781757504258 #(0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1)
     10.582709312439 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     9.215414 #(0.000000 1.358117 1.640818 1.724813 1.142410 1.097880 0.419190 1.313319 1.127393 1.569103 1.715267 0.231328 1.332343 0.564847 0.652586 1.735011 1.266139 0.673952 0.187090 0.230731 -0.038445 -0.015014 1.486649 0.782149 0.819414 1.613686 0.229438 0.327177 1.119806 -0.033707 -0.103160 1.309205 1.367680 1.395692 0.075574 0.854077 1.595090 0.108962 0.599577 1.715162 1.871743 0.361101 1.100268 1.772462 0.928532 1.327810 0.949600 1.487634 1.828513 0.155421 0.989476 1.636329 0.174122 0.301666)
     )

;;; 55 prime --------------------------------------------------------------------------------
#(55 11.142364777492 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1)
     10.806410031758 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.416471 #(0.000000 0.939762 1.095604 0.002058 0.698261 0.722202 1.034891 1.419498 0.541046 0.642157 1.381123 0.082566 0.710434 1.651900 1.656332 1.277775 1.416631 0.088826 1.275920 1.112425 0.626140 0.844060 0.442173 -0.099225 1.436532 1.243724 -1.745460 0.355207 0.184253 1.394922 -0.369803 1.201182 1.246353 1.368518 1.225460 0.646617 0.111113 0.699775 1.188050 0.465177 1.362471 0.645415 0.273212 0.081410 1.578279 0.121389 1.202381 1.739853 0.283128 1.646038 1.605669 0.016016 1.877359 0.181773 -0.173203)
     )

;;; 56 prime --------------------------------------------------------------------------------
#(56 11.365570068359 #(0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1)
     11.143131256104 #(0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1)
     10.976176261902 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

     9.556903 #(0.000000 0.092677 0.698654 1.690057 1.135083 0.285202 1.663806 0.389734 1.599317 -0.100174 0.448864 1.233771 1.472929 1.431111 1.609840 1.097307 -0.048612 1.385703 0.005091 1.947470 1.888750 0.354918 0.178436 0.312399 0.461564 1.608476 -0.132027 0.203970 0.474229 0.683938 1.576508 1.610470 -0.058703 1.589555 0.244091 0.669541 1.034274 0.711629 -0.263106 -0.300927 1.428732 0.723721 0.025859 0.248828 1.469785 1.772536 1.057739 0.271128 0.736099 -0.156958 0.028038 0.536760 1.550032 1.278461 1.551897 1.302803)
     )

;;; 57 prime --------------------------------------------------------------------------------
#(57 11.484163284302 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1)
     11.352762647901 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)
     11.247724533081 #(0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

     9.651722 #(0.000000 -0.083693 1.766898 1.550772 0.014845 1.737384 0.416868 0.763797 1.295771 1.698995 1.681591 0.737563 0.337138 -0.040593 1.011833 1.612121 1.200241 -0.033878 1.184048 1.793920 1.306802 1.145178 0.707479 0.644199 1.153906 -0.140671 1.699721 0.799365 1.368808 0.807275 0.272582 0.057352 0.136097 0.176796 -0.029190 1.403528 1.890407 1.299529 0.090420 1.517479 0.544332 0.760497 0.850328 0.468060 1.191829 0.682096 1.728606 0.628906 0.825008 1.184144 1.331178 1.044960 0.625399 1.467489 0.298799 1.510599 0.955318)
     )

;;; 58 prime --------------------------------------------------------------------------------
#(58 11.564489172529 #(0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)
     11.261419321863 #(0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

     9.692161 #(0.000000 1.991913 0.438064 0.421523 0.281998 0.917241 0.040339 0.079477 0.577155 1.630183 1.011517 1.538678 0.758536 0.769392 1.200675 1.116076 0.746566 1.431122 0.485865 1.262107 1.145160 1.097017 0.098426 0.075023 -0.180105 0.082560 0.722297 0.926234 1.567525 0.538129 1.016051 1.365482 1.224458 1.512399 0.719473 0.135513 0.310184 1.264303 0.979924 1.050954 1.906006 0.638645 1.108521 1.258311 0.869043 0.943531 1.700765 0.596378 0.159146 0.917639 0.251012 1.162069 1.183513 0.063631 0.334178 0.195685 0.513084 1.599208)
     )

;;; 59 prime --------------------------------------------------------------------------------
#(59 11.677247047424 #(0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0)
     11.650652430228 #(0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0)
     11.523194313049 #(0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1)
     11.34253692627 #(0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     9.588297 #(0.000000 1.036635 1.252797 0.393709 0.941001 0.289643 0.221427 1.653864 1.898801 0.037244 1.391779 0.013128 1.296783 1.180326 0.928061 0.822326 1.343584 -0.120529 1.590336 1.539808 -0.196635 1.589293 0.475360 1.852687 0.794865 0.908591 0.350835 1.546472 1.908488 0.745148 1.102399 1.103840 0.602980 1.170248 1.294223 -0.084880 0.278291 0.821092 1.412892 1.591251 0.626561 -0.009036 1.045060 1.158156 0.638069 1.133336 1.675645 0.547567 0.369815 1.827912 0.972435 0.075210 0.457357 1.695742 0.139805 0.005764 0.028464 0.399412 0.883274)
     )

;;; 60 prime --------------------------------------------------------------------------------
#(60 11.705318182776 #(0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0)
     11.579921722412 #(0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0)
     11.512454032898 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     9.759110 #(0.000000 1.446642 1.657485 0.940805 -0.104635 1.424740 0.095135 1.410898 1.136645 0.854509 0.171933 1.537982 1.306166 0.496033 0.046360 0.968561 1.548539 0.434157 1.665089 0.224963 0.978510 0.355066 0.765341 0.925084 1.116028 1.851129 0.624633 0.780213 1.738750 0.768829 0.568430 1.111388 1.649464 1.517104 1.214873 1.790060 0.222210 0.373911 1.747530 0.638438 0.072388 0.620207 0.922723 -0.250381 -0.128313 1.280293 1.860441 1.336931 -0.047623 0.414745 1.216120 1.751910 0.106666 0.494895 1.725411 0.902702 0.016593 1.774689 0.162571 0.829897)
     )

;;; 61 prime --------------------------------------------------------------------------------
#(61 11.989195823669 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0)
     11.915099143982 #(0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0)
     11.850807189941 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     10.017467 #(0.000000 0.450935 1.542015 1.240340 1.647669 1.185039 0.199665 1.113713 0.937016 1.204424 0.479267 0.782250 0.089521 0.662900 1.664233 1.140851 0.478528 0.032796 0.267165 0.611592 1.136397 0.830853 0.074423 1.033599 0.836315 0.215772 0.258353 1.953032 0.638813 1.419807 1.590449 0.735954 0.053795 0.167420 1.433058 0.979665 1.179588 0.277234 1.124977 0.657527 1.668945 0.105355 0.889739 0.521413 1.725582 0.973012 0.800655 1.050005 -0.243935 1.284303 0.636216 1.297895 1.275417 1.766212 1.855540 0.510343 0.614102 -0.081619 0.878443 1.724342 0.576007)
     )

;;; 62 prime --------------------------------------------------------------------------------
#(62 12.4221113188342 #(0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0)
     11.929849152918 #(0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0)
     11.709966659546 #(0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

     10.100970 #(0.000000 0.251241 0.396330 0.222414 1.783719 0.060621 1.082036 0.443766 1.669393 0.163894 0.034407 0.515114 1.114731 1.170971 1.065161 1.210069 0.434333 0.062872 0.435438 0.791197 0.370619 1.372040 -0.579658 0.328369 1.521804 -0.316819 0.482901 1.713261 0.521907 1.641006 0.971652 0.154573 0.988374 0.087450 0.200015 0.163492 1.605425 0.698963 1.275627 1.187047 0.274025 1.686939 1.067818 0.659648 0.998493 1.643927 1.200426 0.769081 0.114406 0.803258 0.502118 0.340643 1.900377 0.577747 0.609401 0.062045 0.689144 1.460296 0.566802 1.260678 1.797881 0.108849)
     )

;;; 63 prime --------------------------------------------------------------------------------
#(63 12.219760894775 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     12.000000000004 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     11.975765228271 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     9.936658 #(0.000000 -0.172976 0.053117 0.193207 1.582039 0.279041 1.154298 0.645558 1.180892 0.466938 0.752179 -0.091238 0.242467 0.005372 -0.091444 1.301269 0.218170 1.438113 0.989258 0.756959 1.749924 1.438965 1.263101 1.471579 1.677287 0.336900 0.648660 0.846226 0.598351 1.720861 -0.130696 1.894805 0.612663 0.697210 1.483336 0.948180 0.417612 1.420734 1.619973 0.681741 0.843955 0.678963 0.288608 1.963969 0.802151 0.530457 1.429951 0.417925 -0.190943 0.355155 0.446542 1.791712 0.509038 1.523929 0.040420 1.421476 0.205217 0.565373 0.549874 0.099518 0.264580 1.036675 0.377782)
     )

;;; 64 prime --------------------------------------------------------------------------------
#(64 12.176999092102 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)
     11.932915769505 #(0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     10.106995 #(0.000000 -0.063786 0.218932 1.549285 0.316559 0.467049 1.108931 0.948407 0.439032 0.017318 1.474997 0.570791 1.013800 1.438037 0.462311 0.821580 0.934570 0.365646 0.025331 -0.028046 1.922597 0.262447 0.824213 1.433397 0.136043 0.586982 1.650390 0.598252 1.562708 1.380258 0.093719 0.742849 0.363422 1.226150 0.292171 0.287053 0.595187 1.406373 0.868337 1.299867 1.328363 1.604654 0.527922 0.495719 1.122469 1.544990 0.382773 -0.153970 0.063327 1.359669 0.634892 0.549861 -0.034913 1.643545 0.954787 0.689729 0.843625 1.173833 1.524848 0.938292 0.553651 0.675880 0.224714 0.510194)
     )

;;; 65 prime --------------------------------------------------------------------------------
#(65 12.496994018555 #(0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 0)
     12.264873504639 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

     10.474157 #(0.000000 1.273082 -0.108748 0.002171 0.221568 0.298934 0.620223 1.795584 0.009754 1.449682 1.110502 1.681545 1.418284 0.589352 0.145387 1.276013 0.728335 0.082043 0.956326 0.079416 0.257929 0.397685 1.325636 1.057434 1.124161 0.969295 0.681901 1.820279 0.064926 0.123739 1.169622 1.044837 0.523695 1.894276 1.861180 0.109117 0.631163 0.642180 1.303103 0.827956 1.333076 1.148451 0.129643 1.437061 0.141904 1.458851 0.150246 0.234687 0.214824 0.871574 0.140300 -0.039724 1.494791 1.298930 1.834425 -0.037572 1.554111 0.323365 -0.158908 1.063261 0.185935 1.420761 1.515474 1.895882 0.194772)
     )

;;; 66 prime --------------------------------------------------------------------------------
#(66 12.564531326294 #(0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0)
     12.359117360586 #(0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0)
     12.347700119019 #(0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0)
     12.090668678284 #(0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.556190 #(0.000000 -0.097410 0.466528 1.308208 0.089559 0.411734 1.120474 0.896344 0.382486 0.160205 0.491699 1.107105 1.297836 0.115885 1.221218 1.995276 1.682799 1.126891 -0.240986 0.085971 1.931944 1.169230 0.261608 0.424403 0.869078 0.602102 1.700036 0.236859 0.614581 0.141426 0.284138 0.093545 0.350527 0.910054 0.678764 0.048839 0.277789 0.707343 1.196932 1.405096 0.791701 1.953311 1.198877 1.176208 0.815496 1.679594 0.643402 1.661119 -0.178075 0.973553 0.506388 1.914033 1.162835 0.568432 1.168914 1.270541 1.157177 0.255981 0.624529 0.129369 0.665529 0.244705 1.465881 0.519362 0.023394 0.339325)
     )

;;; 67 prime --------------------------------------------------------------------------------
#(67 12.65784740448 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1)
     12.20425496356 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

     10.548870 #(0.000000 -0.090470 1.285858 1.883442 0.628501 0.073784 1.323940 1.075641 0.049603 0.274005 0.320800 0.667656 0.164957 0.114796 0.756507 0.174762 1.581460 1.561145 1.514403 0.732542 0.872410 0.966478 1.593815 0.938832 0.444737 0.882006 0.648639 0.950035 0.376566 0.690365 1.057734 1.537733 1.430833 0.953945 1.368865 0.849178 0.019499 1.383576 1.700967 0.040155 1.509674 1.112533 0.870563 1.381018 1.059651 1.845667 0.970247 0.577069 0.965240 1.053062 1.367131 0.971382 1.428853 0.422239 0.001277 1.592744 0.691079 0.418683 0.599436 1.560980 1.196877 0.761136 0.232014 -0.089189 0.948608 0.345004 0.601538)
     )

;;; 68 prime --------------------------------------------------------------------------------
#(68 12.551372528076 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1)
     12.501034736633 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1)
     12.466281890869 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

     10.692181 #(0.000000 0.160992 1.670151 -0.032752 1.125438 1.816792 0.134967 0.948462 0.004882 1.213856 -0.158463 1.824966 1.525159 1.935532 0.134622 0.791181 0.233909 1.349193 0.979140 0.292243 0.051319 0.836471 0.015026 1.439303 1.082337 0.487288 -0.111585 1.299924 1.260731 1.979344 0.032276 -0.032787 0.653119 -0.369577 1.006835 1.330359 1.931848 1.776156 0.696444 0.432833 -0.182891 1.180915 0.074824 0.258276 1.331393 1.788205 1.781506 1.641605 0.759944 0.940918 1.268084 1.236164 0.813942 0.772363 0.319672 1.861579 1.551981 1.465513 0.541387 0.556417 0.037051 0.668245 0.048594 1.275290 1.530979 1.723000 0.284872 1.482839)
     )

;;; 69 prime --------------------------------------------------------------------------------
#(69 12.88109067433 #(0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     12.549396894774 #(0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1)
     12.336643218994 #(0 0 1 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1)
     12.29846572876 #(0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     10.763634 #(0.000000 1.753520 1.357588 1.349359 1.210221 0.223202 1.616367 1.551867 0.795698 0.663015 1.855602 1.296520 1.111189 0.836249 0.242252 0.311343 0.146391 0.002260 1.429232 0.891762 1.921451 0.270087 0.766162 0.347999 0.440657 0.842536 1.884912 -0.289951 1.825709 1.643856 0.696483 1.776219 1.027783 1.698935 0.462354 0.911005 1.177298 1.522980 1.613608 1.149327 1.612005 1.723442 1.155985 -0.119464 0.831590 0.611851 0.812450 -0.161761 -0.035119 0.717943 1.403965 1.026422 0.295489 1.021151 1.207599 1.201595 1.979504 1.039141 0.816797 1.072647 1.088019 0.486815 1.736794 -0.122594 0.865409 0.359528 1.288615 1.273472 0.770874)
     )

;;; 70 prime --------------------------------------------------------------------------------
#(70 13.072455719834 #(0 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0)
     12.851739571463 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0)
     12.797727584839 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     12.669577598572 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)
     12.665026664734 #(0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     10.698743 #(0.000000 0.917657 0.123444 -0.097777 0.409283 0.930340 0.256683 1.613682 1.088572 1.577497 0.869528 1.139879 1.003839 0.832060 0.516889 0.190919 0.024640 0.686993 0.802303 0.473356 1.111103 1.660306 0.953037 0.027468 1.873261 1.712852 1.756612 0.779990 1.031228 1.868799 1.363995 0.354652 -0.042712 0.517563 0.176572 0.067269 1.147898 -0.152266 0.463278 1.757448 1.531505 0.505005 0.273214 0.601439 1.433153 1.307425 1.416402 1.626800 1.415407 1.755430 0.283343 1.669748 0.123397 0.161843 1.062569 -0.118134 1.505597 0.660921 1.250885 0.668895 0.436236 0.786729 1.605519 0.854474 0.156990 1.138298 0.102255 0.999860 0.760478 0.166668)
     )

;;; 71 prime --------------------------------------------------------------------------------
#(71 13.189444031428 #(0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0)
     13.116391136133 #(0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
     13.027417182922 #(0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0)
     12.702159881592 #(0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0)
     12.609085083008 #(0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     10.884054 #(0.000000 0.700486 0.853924 0.989945 1.689407 0.918740 0.744315 1.057189 0.483826 0.768038 0.761188 0.884357 1.632170 0.673515 0.789651 0.498739 1.014446 1.184214 1.216849 1.423179 0.401067 0.233366 0.798127 0.617673 0.664167 1.522969 0.107288 0.236985 0.074207 1.190683 0.813119 1.326250 1.086336 -0.046935 0.500346 1.719498 1.602767 0.905568 -0.024416 0.605887 1.109109 0.246011 1.414593 0.615444 0.901041 1.772998 1.286792 0.236649 1.611391 0.926675 0.981132 0.273330 1.010399 0.017578 1.305678 0.227278 1.205339 1.137628 0.233969 0.266322 1.861144 1.026408 1.529998 1.514863 0.404514 0.107001 0.310359 0.858560 0.683476 1.420264 1.428305)
     )

;;; 72 prime --------------------------------------------------------------------------------
#(72 13.268 #(0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0)
     13.043850898743 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1)
     12.841200828552 #(0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0)
     12.708446502686 #(0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     11.036202 #(0.000000 1.555837 1.025791 -0.187849 1.682176 0.956874 1.304511 0.926585 1.500981 1.422966 0.071885 0.038414 1.600046 0.019298 1.593547 1.335251 1.733701 0.347665 1.826757 1.107160 -0.062540 1.807220 1.113454 0.015090 0.575244 0.269891 1.412969 0.180691 0.653291 0.186951 0.556191 1.679837 1.484269 -0.124820 1.793095 1.094361 1.230862 0.269486 1.298574 1.379857 1.440590 -0.049442 1.107503 0.634906 1.016408 0.105408 1.342113 0.599832 1.022758 1.976131 0.720148 1.210875 0.180060 1.717250 0.988749 0.749358 1.654285 0.540438 0.670766 0.750538 0.177837 0.813033 1.194317 0.072315 1.534461 1.358219 1.974172 0.240556 0.224253 0.816651 1.055865 0.158297)
     )

;;; 73 prime --------------------------------------------------------------------------------
#(73 13.602198600769 #(0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 0 0 1 1)
     13.40486240387 #(0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0)
     12.986406962349 #(0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0)
     12.877750118249 #(0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     11.118679 #(0.000000 0.434501 0.333216 0.719468 1.458550 0.451221 0.939800 1.736607 1.517449 0.423585 0.554421 0.367915 1.426098 0.667101 0.520957 0.289323 1.675424 0.329151 0.266985 0.885520 0.251753 1.517916 1.196999 1.480591 1.369799 0.350043 -0.079333 0.284003 1.710049 1.137288 1.145704 1.494724 1.244751 1.394959 1.506704 1.488724 0.084836 0.057033 0.706312 0.088758 0.608104 0.160927 0.040245 0.242943 1.035648 0.946944 1.543643 0.645944 1.262427 1.252289 0.315223 1.286484 0.997853 0.282003 0.175037 -0.035960 0.936933 1.816070 0.439689 1.047663 1.457949 0.512868 1.886309 0.641958 1.427687 0.612058 1.562598 0.841326 1.613817 0.254045 0.441391 0.200222 1.598683)
     )

;;; 74 prime --------------------------------------------------------------------------------
#(74 13.442555427551 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.395832061768 #(0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1)
     13.261976242065 #(0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.115156173706 #(0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     11.143587 #(0.000000 0.223354 1.297732 0.690294 0.430385 0.263640 -0.000352 0.171266 0.689208 1.537350 0.634841 1.144467 0.184863 1.148024 0.960496 0.930781 0.289972 0.839713 -0.221555 1.705567 0.092382 1.111238 1.119112 1.544807 1.908028 1.134536 -0.092828 1.476457 0.074742 1.142977 1.070901 0.211990 0.096295 -0.038108 -0.035757 -0.208502 0.613663 0.142985 1.212992 0.039257 0.172057 0.009624 -0.084753 1.626470 1.382426 1.139975 1.877900 1.703467 0.176346 0.636074 0.498859 0.902619 1.381147 1.672351 0.888918 1.860899 1.800433 0.017469 -0.109214 1.254427 0.550313 0.119931 1.615840 1.675114 0.536367 0.684312 1.012642 -0.010625 1.136293 1.144114 -0.063852 0.984962 -0.037460 0.325008)
     )

;;; 75 prime --------------------------------------------------------------------------------
#(75 13.676464080811 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1)
     13.618774108319 #(0 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0)
     13.357945520561 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)
     13.254356384277 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     11.256054 #(0.000000 0.381655 1.033561 1.415017 1.262343 1.145383 1.461399 -0.060049 0.741321 1.771985 0.892627 1.389406 1.944436 1.069766 0.112067 1.378147 0.803500 1.090366 1.191732 1.179956 0.662808 1.195478 0.415344 1.614436 1.658955 0.252101 1.357739 0.248581 1.665508 1.312384 0.042090 1.818294 0.664742 0.981456 0.935826 0.853087 1.228400 1.704388 1.321483 1.684956 1.746245 1.353541 1.427954 1.574369 1.695422 0.245862 0.615121 0.877734 1.656741 1.787665 1.664886 0.482302 0.433966 0.511882 1.921395 0.634727 0.722862 0.218401 1.012773 0.962796 0.263415 -0.125167 1.756777 1.045617 0.925910 0.409731 1.774654 1.571995 0.929924 0.857474 0.033493 0.173762 0.978908 0.029818 1.437907)
     )

;;; 76 prime --------------------------------------------------------------------------------
#(76 13.691219362758 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0)
     13.288178191792 #(0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     11.299403 #(0.000000 1.241495 0.999479 0.964904 1.838997 0.522125 1.222791 1.279289 0.882294 0.132471 0.977891 0.742621 0.938716 1.611221 0.602686 1.284526 0.392724 -0.171664 0.713380 0.598817 0.518470 0.396219 1.818132 0.187349 0.895660 1.612149 1.236258 -0.045504 0.739878 1.813611 0.440468 -0.245870 0.612876 1.137698 1.827779 0.633777 0.901279 1.807544 0.023310 0.221511 0.430111 0.194415 1.609028 0.853130 1.801377 1.022800 0.532060 0.068653 0.709012 1.539447 1.220525 0.103244 0.410303 0.074064 1.078201 1.115672 1.201014 0.374624 0.815839 1.453531 0.640044 0.629945 1.568741 1.330625 0.048198 0.928694 1.224285 1.891436 0.625319 0.183677 0.585615 0.389148 -0.111707 1.866034 0.702952 0.571396)
     )

;;; 77 prime --------------------------------------------------------------------------------
#(77 14.029663085938 #(0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1)
     13.845010757446 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0)
     13.330450043717 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1)
     13.158900260925 #(0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     11.239864 #(0.000000 1.109621 0.890720 1.863634 0.134879 1.644549 1.817765 0.480887 0.969833 0.546584 0.713110 1.218674 1.808239 -0.071246 0.280540 0.135188 1.320442 0.275620 0.596746 0.251612 1.443239 0.551624 1.129987 1.096342 0.309075 1.305569 1.150699 0.524859 1.027640 -0.005707 0.848125 0.083280 0.451110 0.402089 0.573143 0.977593 0.391596 -0.086082 0.958365 0.825219 -0.128403 -0.035252 0.320221 0.001786 0.309046 1.509392 0.192510 1.927761 0.561747 0.632578 0.154824 1.672061 0.617582 0.285347 1.718501 1.246786 1.227906 0.851849 0.794182 1.908346 0.672980 0.322095 0.554457 0.637541 1.508116 1.300005 0.136564 1.239918 1.133282 0.396450 1.562246 0.739157 1.281788 1.069054 -0.148058 1.643111 0.030518)
     )

;;; 78 prime --------------------------------------------------------------------------------
#(78 13.920186042786 #(0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.683882347187 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.498236182018 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     11.639300 #(0.000000 1.444740 1.330418 1.228692 1.557311 1.886873 0.995250 1.605060 0.146579 0.383570 0.838826 1.385863 1.700528 1.067474 0.939476 0.250724 0.010874 1.095024 1.577274 1.581792 0.900002 0.965555 0.517227 1.776338 1.793449 0.470719 1.762490 0.750045 0.040104 -0.038553 1.061092 -0.171106 -0.005245 0.239462 1.109468 -0.185231 1.657940 1.411404 0.316343 1.038738 0.771111 0.592423 1.587574 1.478494 -0.248962 -0.078133 -0.053091 1.569874 0.094895 0.455466 1.286336 0.154083 0.963308 0.353958 1.415946 0.229199 0.123859 0.095481 -0.102981 1.289160 0.762350 -0.088173 0.866346 0.549633 -0.109149 1.492669 0.382902 1.023349 1.079868 -0.275265 0.951262 0.916281 1.417148 1.504252 0.571734 1.791701 1.117613 1.483546)
     )

;;; 79 prime --------------------------------------------------------------------------------
#(79 14.000000000005 #(0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0)
     13.77695274353 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0)
     13.178678233398 #(0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     11.822309 #(0.000000 1.287834 1.482178 1.225615 0.377335 0.987336 0.854630 1.119063 0.579927 1.694615 1.696355 0.954657 0.578915 1.699769 1.918381 0.402669 1.692082 0.093979 0.683596 1.265664 1.852374 1.452670 0.605715 0.323950 1.114435 1.077825 1.850615 0.376783 0.249026 0.582006 0.924428 1.263835 0.369729 0.899371 1.573830 1.601979 1.533407 0.475399 1.370329 0.046108 1.473031 1.222650 1.735396 -0.061803 1.413475 0.612188 0.893376 0.535710 0.071805 1.072960 1.591368 1.760374 0.555545 0.172784 0.095049 0.398064 1.084636 0.935731 -0.119359 -0.027653 -0.114990 1.496204 0.198897 1.361297 0.028404 0.834063 1.883012 0.422217 1.381685 1.475074 1.881618 1.812030 1.621278 1.645626 1.160226 1.702831 1.740155 1.376602 1.022833)
     )

;;; 80 prime --------------------------------------------------------------------------------
#(80 14.309369414534 #(0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0)
     14.119678497314 #(0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1)
     13.563344594765 #(0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0)
     13.547472953796 #(0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     11.850996 #(0.000000 1.923753 0.207464 0.106551 0.052573 1.185030 0.585776 0.530437 0.400860 0.604131 1.402735 0.877646 1.474500 1.459669 0.124363 0.225126 -0.082702 0.470808 1.252222 1.782389 0.573241 1.488777 0.648072 1.098672 1.397661 1.005371 0.482778 0.775387 0.323520 -0.054461 1.787321 0.425380 1.109768 1.720601 0.008270 1.783768 0.462057 1.475670 0.388588 1.856675 0.324432 0.000032 0.401085 1.101134 1.465674 0.811806 0.160773 1.177489 0.702036 1.253724 1.079275 0.789570 0.319269 1.064353 0.568766 1.090129 0.506116 0.246433 0.752833 1.897920 1.751946 1.367062 1.059717 0.627555 1.303947 0.339922 0.648486 0.078103 1.162853 0.125846 1.197362 0.652326 1.581347 0.917897 1.372245 1.382548 1.347964 1.692676 1.401581 1.663786)
     )

;;; 81 prime --------------------------------------------------------------------------------
#(81 14.317508929282 #(0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0)
     14.256287400004 #(0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1)
     13.652944564819 #(0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     11.685857 #(0.000000 -0.040391 1.131311 0.019069 -0.037458 1.353503 0.148279 0.224472 0.311463 0.524761 0.168723 0.260394 0.791519 0.332435 0.741557 1.238699 0.473804 0.677736 0.568135 1.767246 0.074862 1.364437 1.247670 1.601182 1.752298 0.887626 1.413716 0.060632 1.627882 1.473798 1.035145 0.573759 0.093034 0.630049 1.254752 1.122726 -0.289866 0.164029 1.815696 -0.037242 1.749053 0.895509 0.951675 0.058817 1.597293 1.240331 1.438622 -0.044412 0.777350 0.757925 1.448836 0.102016 0.153065 0.531193 -0.101505 0.537232 -0.137195 0.778521 0.684756 0.540993 1.875908 0.021696 1.286286 1.290897 0.104490 0.883543 0.911221 1.330125 -0.249724 1.479590 0.629937 0.605166 0.948781 1.530031 0.215407 0.452406 0.559695 1.333624 0.104992 1.221576 0.471772)
     )

;;; 82 prime --------------------------------------------------------------------------------
#(82 14.492313651671 #(0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)
     14.126787045134 #(0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     11.793913 #(0.000000 1.170349 -0.097255 1.488841 0.017345 1.364978 0.461705 1.727372 0.840293 0.054901 0.997486 0.323991 1.551969 0.141358 0.229977 1.365159 1.193638 1.002416 0.156161 0.227249 1.918915 0.252739 1.494449 1.946944 0.107423 1.228288 0.347901 1.092938 0.070295 0.369466 0.036890 0.021648 0.743776 0.503837 1.396482 0.203930 0.913320 0.172275 0.195615 0.116574 0.368468 1.178622 0.517182 1.549983 1.439848 0.172758 1.651794 0.396402 0.720403 0.645746 0.165501 0.171553 0.431707 -0.011481 0.140885 0.475134 1.287334 1.342788 1.305448 -0.049168 0.822490 1.483831 1.714022 -0.063970 0.640560 1.220804 1.731432 1.410055 0.654261 0.302038 1.015069 1.234688 0.697108 1.668639 0.527685 1.136551 0.839111 0.160152 0.026120 0.544483 0.663823 0.085128)
     )

;;; 83 prime --------------------------------------------------------------------------------
#(83 14.249828726851 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)
     14.019070339131 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     11.781927 #(0.000000 0.530341 1.462561 0.792280 0.894542 1.667883 1.244382 0.182770 1.363983 1.783346 1.218239 1.712844 1.488441 1.507912 0.327828 1.691918 1.871686 1.520428 0.686325 0.485910 0.105318 1.820285 0.676625 1.334245 0.330571 0.586894 0.050602 0.636315 0.942987 1.350991 -0.161344 1.647640 0.213664 1.715449 0.981739 1.633688 0.787265 1.815226 0.909485 1.319231 1.798180 0.703953 1.113935 0.133946 1.066183 0.544998 1.257395 0.559915 1.632454 0.803147 0.286591 0.274266 0.301649 0.618040 1.440041 1.608840 0.918621 1.531779 1.536820 0.481949 -0.082803 0.686537 0.684744 0.181267 1.926122 0.440091 0.393218 1.498843 1.583768 0.440312 1.781636 0.822340 0.745293 0.543583 1.876210 1.259398 0.246035 1.623192 1.482278 0.145790 0.640657 1.435786 0.301700)
     )

;;; 84 prime --------------------------------------------------------------------------------
#(84 14.422843763275 #(0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)
     14.299305314276 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.264351844788 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.024940956301 #(0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     12.004509 #(0.000000 1.277509 1.189592 1.446784 1.053877 1.331731 0.905086 -0.324632 -0.414553 0.466868 0.808486 0.989202 0.871063 0.707718 0.942488 -0.202099 1.911154 1.330897 0.707097 1.079185 1.314532 1.409379 -0.313856 1.410196 0.490850 0.345208 1.059653 0.367735 0.764355 0.269834 1.122760 0.148507 1.796443 0.661215 0.478102 0.328019 1.203103 0.699161 0.614278 0.799993 0.522522 1.333019 0.059328 1.362159 -0.108220 0.288238 0.966131 0.592853 1.073228 1.341413 0.082539 1.136860 -0.048696 1.100377 0.364296 -0.516615 0.656912 0.662283 1.741784 0.470812 1.160452 0.651716 0.538545 1.119000 0.523460 0.980785 -0.367373 1.335729 -0.044907 0.638042 0.865138 0.183679 -0.209664 1.279064 1.428596 0.695890 0.531733 1.198948 0.124891 0.995194 1.537150 0.855236 0.017794 0.679676)
     )

;;; 85 prime --------------------------------------------------------------------------------
#(85 14.721940394615 #(0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1)
     14.400919537796 #(0 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)
     14.253310943921 #(0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     12.039301 #(0.000000 0.149657 0.168518 1.773141 0.538506 1.625616 1.072180 1.321021 1.055680 1.727304 0.540394 1.695622 0.798492 0.770518 1.163725 -0.065875 1.311492 1.390917 1.389698 1.265307 1.586608 0.776281 0.428607 1.238289 0.038149 0.126323 0.046653 1.153154 1.073400 1.400608 0.740725 0.450922 0.614097 1.925040 1.177843 1.209951 0.917891 1.069069 1.105236 1.458497 0.609869 0.102141 0.538918 1.490561 0.193033 1.913814 0.035299 1.312357 0.675572 1.514172 0.931182 0.913987 0.112454 0.838766 -0.069918 0.814992 0.249891 1.253838 1.675524 1.790600 1.558739 -0.379214 1.760864 1.443013 1.677219 -0.390056 0.800589 1.781779 1.295915 1.256057 -0.056767 0.818539 1.000559 -0.026975 1.774770 0.332170 -0.108745 0.752305 0.477748 0.182615 1.194757 1.490663 0.572421 -0.106723 -0.159562)
     )

;;; 86 prime --------------------------------------------------------------------------------
#(86 14.993455205117 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1)
     14.394402956102 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1)
     14.017106967247 #(0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

     11.840326 #(0.000000 1.245722 0.828003 1.708429 1.063770 1.069235 1.168816 0.968148 1.757909 0.722838 0.259673 0.587983 1.075019 0.244887 0.711027 0.351768 0.547579 1.242458 0.885462 0.363198 0.762477 0.413777 0.102231 1.673876 0.229266 1.573827 0.131656 1.849326 0.442221 1.142077 1.793307 0.358676 1.624291 0.368933 0.260608 1.521706 0.921970 1.227777 0.523225 0.076505 1.513864 1.635909 1.833596 1.644361 1.122009 0.722632 0.590190 -0.119164 0.988147 0.934217 0.148785 1.776617 1.320398 0.797478 1.762137 0.720651 0.834263 1.652184 1.312187 0.821513 1.889830 0.489234 1.017541 0.848079 1.479264 1.503801 -0.079078 0.579380 -0.011220 0.294908 0.801151 1.672624 0.234183 1.377348 0.594402 1.461213 1.836654 0.542457 1.520245 0.732249 0.741348 0.487670 1.197161 1.215874 1.847161 1.441704)
     )

;;; 87 prime --------------------------------------------------------------------------------
#(87 14.798576861642 #(0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0)
     14.519235937355 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)
     13.98394199918 #(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

     12.228939 #(0.000000 0.434264 1.220721 1.294564 0.028441 1.743677 1.120539 1.425745 1.694263 0.704028 -0.070950 1.262505 -0.072170 0.133186 0.714455 1.023390 0.470085 0.133371 1.636719 1.775299 -0.098825 0.245012 0.896507 1.434648 0.976460 1.805130 0.717629 0.090824 1.120442 0.128163 1.076687 0.054660 1.500948 0.853096 1.416011 0.575911 0.974762 1.849991 0.583563 1.236348 1.200156 0.397406 0.184943 1.130315 0.537367 1.600571 1.077595 0.811068 1.358042 0.729273 1.691180 0.677059 1.730847 1.554644 0.262580 0.047485 0.903916 1.900582 0.489963 1.508961 0.519992 1.202559 1.517209 1.877363 0.408473 1.396558 1.590353 0.858989 1.284346 0.011696 0.508803 1.744531 1.369867 0.851870 1.645724 1.535279 0.834103 0.332451 1.935643 0.344676 0.884808 1.626958 1.587560 1.368659 1.694240 1.854289 1.698540)
     )

;;; 88 prime --------------------------------------------------------------------------------
#(88 15.158827781677 #(0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1)
     14.908 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0)
     14.84298551254 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.837036132812 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.825139803345 #(0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     12.267925 #(0.000000 0.754460 0.652788 -0.033735 0.216378 0.368348 0.713363 0.924529 0.547182 0.524683 1.283563 0.812515 1.390031 1.389931 1.051739 0.796371 0.316181 0.756561 0.446962 0.390794 0.332449 1.186846 1.026512 0.865814 0.311668 1.528157 -0.105637 -0.032159 0.936438 1.732794 0.733784 0.064966 0.487154 0.490956 0.956031 0.105321 1.334677 0.642384 1.552601 0.113089 0.543796 1.179294 0.724583 0.296678 1.864205 1.607135 1.707671 1.557779 1.667891 1.212015 1.656287 0.872714 1.722735 0.302166 1.164200 1.785858 0.746105 1.293976 0.673090 0.164975 0.940912 1.010588 0.563849 0.297045 1.739515 0.364008 1.749362 1.937720 1.196475 0.218009 0.815956 0.778317 1.134642 -0.346215 1.899577 0.745130 1.064204 0.943983 1.710673 0.698309 1.669642 1.750405 1.326278 0.581812 0.893851 0.300904 1.316352 0.740312)
     )

;;; 89 prime --------------------------------------------------------------------------------
#(89 15.157893052401 #(0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1)
     14.69031483888 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

     12.617907 #(0.000000 0.397984 1.349247 0.109396 0.736813 1.361930 0.994335 1.244465 0.030397 -0.194555 0.471698 1.656609 1.902942 -0.114891 1.729889 0.359496 0.605013 -0.325821 0.066910 1.206692 1.243742 0.984197 -0.115900 1.260230 0.156631 0.667067 0.942764 1.481336 -1.846720 0.530840 1.631524 1.177155 0.156498 0.942935 0.770369 1.716862 1.165998 0.284684 -0.117613 0.453842 0.351030 0.991288 1.107891 1.156213 1.685306 1.298697 1.549340 1.119937 1.496765 1.674780 0.441738 0.008732 0.342947 1.688739 0.458881 1.779175 0.369142 0.731008 0.094976 1.559369 1.533941 1.625198 1.258356 0.007612 0.186472 1.460020 0.637039 -0.173821 -0.062172 1.187583 1.577466 1.592441 -0.451432 0.790656 1.414836 0.987625 1.583464 1.150411 0.501521 1.354953 0.802534 0.374628 0.087567 1.327586 1.278696 0.889150 0.278549 1.625150 0.263574)
     )

;;; 90 prime --------------------------------------------------------------------------------
#(90 15.253639451837 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.917379556641 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.831111851861 #(0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     12.578275 #(0.000000 0.352853 1.776583 1.006669 1.230317 0.463070 0.333844 0.626069 0.645700 0.367359 0.379690 -0.171225 0.144022 0.927449 1.818760 1.174975 1.429937 1.581624 0.414658 1.819385 0.163889 1.853150 -0.272025 0.564434 1.466496 1.124176 0.612306 0.068344 0.249396 0.696224 1.559513 1.967924 0.189973 1.308010 0.018644 -0.393229 1.173932 1.630189 1.389419 0.415176 0.053722 1.840251 0.883656 1.102177 0.248822 1.065762 0.083677 0.596246 0.702770 1.102675 -0.161312 0.497115 1.459369 0.468208 1.658864 1.182907 1.337511 -0.094214 0.809584 1.208696 1.478172 1.502669 0.852172 0.154069 1.195031 1.691869 0.306220 1.565424 1.171824 1.217510 0.921889 0.088021 1.494758 0.225219 0.442189 1.345095 0.331248 1.767593 0.389567 0.923971 0.853385 1.038999 -0.117295 -0.294579 1.673740 0.571394 0.725540 -0.171347 1.178060 1.069325)
     )

;;; 91 prime --------------------------------------------------------------------------------
#(91 15.264 #(0 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0)
     14.775403022766 #(0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0)
     14.702056847646 #(0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     12.629576 #(0.000000 1.679240 0.654985 0.776518 1.547019 1.159878 -0.068081 1.172938 1.021768 1.809376 1.141874 1.358206 0.728796 1.768509 1.637295 0.889668 1.068659 1.299650 1.780210 -0.034723 1.744365 1.210389 1.563365 0.610598 0.844614 0.656048 1.724491 1.682362 1.538038 1.266915 0.905536 0.358275 0.304424 0.682976 0.355716 1.314345 1.820261 1.763058 0.591130 0.643209 -0.331434 -0.012008 0.586484 0.541365 0.793949 0.204461 1.566304 1.095366 0.023427 0.699966 0.935116 0.681367 0.664912 -1.674827 0.728626 1.336879 0.404289 0.548549 1.394881 1.631360 0.524503 0.476542 1.712185 0.135718 -0.114241 1.441882 1.096389 1.775230 0.672996 1.443928 0.368348 1.545666 0.590401 0.727335 0.429758 1.014322 1.489869 0.902604 1.552226 0.652601 -0.019285 1.045323 1.807951 0.355588 0.401540 0.581587 0.726943 0.783052 1.308264 -0.010893 0.403544)
     )

;;; 92 prime --------------------------------------------------------------------------------
#(92 15.373 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     15.307026596891 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     14.9424 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)
     14.556435035882 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     12.531982 #(0.000000 1.197630 1.286524 1.134488 1.687179 1.331282 0.423861 0.229597 1.341267 0.641466 1.644844 0.346189 0.931973 0.940738 1.498691 0.162354 0.581651 -0.535354 0.064798 0.250870 1.786906 0.407749 0.302417 1.250585 1.687763 0.769284 -0.419091 0.904445 1.470606 0.441817 0.647582 0.860484 1.045901 1.752163 1.201123 1.924536 0.063187 1.109556 0.669731 1.249843 0.479142 0.224540 0.475146 -0.046664 1.463038 1.156496 0.799478 1.867400 0.601784 1.202337 1.730280 0.809457 1.646588 1.634621 1.339264 0.031345 1.297349 0.079275 0.056181 0.599928 0.485525 1.063617 1.212654 1.359354 0.890919 1.457699 0.184004 1.396460 1.057016 1.480759 0.729965 1.622920 1.273612 -0.133136 1.493449 1.201381 0.873388 1.693488 1.000367 1.975718 -0.289631 1.156916 1.260537 1.502312 0.530260 0.756128 0.694658 0.478037 0.168640 0.999282 0.734376 1.195628)
     )

;;; 93 prime --------------------------------------------------------------------------------
#(93 15.814494404587 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     15.072628413546 #(0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1)
     14.994668960571 #(0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     12.740920 #(0.000000 0.188043 1.250705 -0.000151 1.228016 -0.193061 0.162121 1.280943 1.006184 1.384922 -0.409434 0.098067 1.797771 -0.148143 1.763714 0.086220 0.037436 1.743021 -0.039108 1.051706 1.390078 1.372962 0.674078 1.052485 0.649269 1.756623 0.123223 0.377072 0.831176 0.312538 1.829401 1.413709 0.513972 0.114445 1.619219 1.310546 0.782819 -0.161318 1.823344 1.884581 0.931950 1.118936 0.120509 0.392247 1.584774 0.336701 0.969706 -0.295968 0.407316 1.508201 0.525923 0.147302 1.138294 1.309043 1.176706 1.169358 1.400554 0.272430 0.264573 0.372944 0.887675 0.444991 0.794783 0.347072 0.448518 0.681926 1.421566 1.117338 1.185835 0.616689 1.950590 1.666723 0.377147 -0.194421 0.320546 0.480874 0.042091 0.774658 0.185282 1.458199 0.139066 1.034689 1.737673 0.372517 0.385303 -0.008946 1.597156 0.699801 0.038969 1.129397 1.490356 0.165484 1.258360)
     )

;;; 94 prime --------------------------------------------------------------------------------
#(94 15.835750579834 #(0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     15.441287870957 #(0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)
     14.811392756555 #(0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     12.750939 #(0.000000 0.411806 0.932107 0.620165 0.690812 0.078780 0.207637 1.355914 1.428537 1.008014 0.163175 -0.040811 0.574537 1.489363 0.614312 1.194371 0.935368 1.005805 0.928318 0.370350 -0.065244 0.435006 1.441155 1.395062 1.621190 0.021982 0.013473 1.227189 1.566996 1.720462 0.409641 1.816058 0.717818 1.188239 0.348420 1.488145 -0.204496 0.768563 1.723000 0.656714 0.746940 1.143901 0.283060 0.314007 1.380832 1.686174 1.708777 1.265056 1.438127 0.011357 1.011067 0.933857 0.061587 0.441761 0.692061 1.431374 1.644647 1.236298 1.428838 0.828837 1.716444 1.264772 0.205713 -0.192299 1.315354 0.747254 0.888175 0.332702 0.710146 0.094558 1.628910 0.414220 0.853669 0.773296 1.067344 0.189408 0.529961 0.799169 1.427935 0.528594 1.063577 1.008261 1.850893 0.082046 0.297715 1.142832 1.438558 0.590975 0.337215 0.929215 -0.054223 1.059628 0.837326 1.297742)
     )

;;; 95 prime --------------------------------------------------------------------------------
#(95 15.827 #(0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.616318215916 #(0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.240 #(0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     13.142269 #(0.000000 0.446688 0.943416 0.420303 1.262593 1.481551 1.816759 1.602944 1.335361 0.232664 1.151008 -0.271285 1.095303 1.115766 0.807686 0.853009 0.833502 1.638512 1.799897 1.539482 1.210974 0.251853 1.140131 0.074874 0.330599 0.975283 0.196529 0.497575 1.108776 0.454628 0.099328 0.206635 0.429721 0.767821 0.776883 0.241734 1.086834 1.177070 0.648981 0.385316 1.435368 1.745089 1.820420 0.447206 0.305271 0.314686 1.406340 0.245081 0.379705 1.727534 0.485952 0.138705 0.256316 1.115237 1.593934 0.143114 0.862360 0.700441 0.802048 1.455463 0.924965 0.639165 0.663868 0.248541 1.349485 0.397723 0.076215 1.824268 -0.142783 0.500073 -0.174686 0.657917 1.428001 1.143254 1.721062 1.414540 0.572450 0.100496 0.158099 1.989891 0.400767 0.722835 0.589185 1.822999 0.245200 1.420401 0.615495 1.234701 0.314335 1.000579 0.095663 0.630419 -0.246846 1.810582 0.891630)
     )

;;; 96 prime --------------------------------------------------------------------------------
#(96 16.039880627473 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.648203810823 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.281 #(0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)
     15.135 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

     13.204725 #(0.000000 1.076776 1.347926 1.525387 1.703093 0.146409 1.317966 1.859505 0.707164 0.830831 0.443644 0.827604 0.209278 0.749602 0.059328 1.266240 1.293110 1.093154 0.211555 0.428549 0.234880 1.309308 1.849895 0.556242 1.146080 1.112880 0.255098 0.697511 0.976003 0.447974 -0.060853 0.989003 0.981427 1.357143 -0.108507 0.508258 1.350016 1.370815 0.706419 1.417351 0.130302 -0.164616 0.121236 0.899029 1.704503 1.010661 0.546214 0.056403 -0.018220 0.776486 1.737256 -0.288192 0.433604 0.009935 1.911131 -0.011896 0.429002 1.681473 1.443604 1.443566 1.122321 0.851995 1.174060 1.043964 1.121883 1.576569 1.220681 1.062173 1.465088 1.469385 0.007614 0.689833 1.413660 1.426225 0.669850 1.847272 1.185576 0.967159 0.585257 1.342471 0.036719 1.434241 0.611492 1.555664 1.306827 1.708606 1.324519 0.822315 0.043925 -0.223593 1.382941 1.347398 -0.049609 1.255274 0.199951 0.735570)
     )

;;; 97 prime --------------------------------------------------------------------------------
#(97 15.972457232959 #(0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.726 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.685384750366 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)
     15.404807595571 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

     13.130301 #(0.000000 1.135539 0.220794 0.501697 0.344944 0.755439 0.145509 0.410232 -0.069275 0.590695 1.315603 0.498558 0.367854 0.758084 1.750221 1.169065 1.563732 0.376182 1.614424 1.432746 0.401221 0.948428 0.164632 0.245083 0.882567 0.851738 0.460102 1.561468 0.587073 1.409750 1.205538 0.791857 1.107094 -0.019229 1.649686 1.725724 1.387495 1.675489 0.316317 1.218656 1.514383 -0.251456 0.140774 0.306294 0.782155 1.061756 1.669052 1.881173 0.577275 0.454949 0.395989 0.432079 1.150703 0.455565 0.073468 -0.034277 -0.116020 1.243542 1.455278 0.818342 1.963380 0.647866 1.701929 1.360171 0.710187 1.751986 0.222756 0.275196 0.862379 0.351462 0.384630 -0.050442 1.402016 0.933288 0.004450 1.443734 0.717086 0.049513 0.145930 0.282718 1.270029 -0.172234 0.514496 1.445399 0.031963 1.327775 1.602313 0.542788 1.757408 0.829093 0.848058 -0.074176 0.289279 1.318336 0.872820 0.817913 1.039671)
     )

;;; 98 prime --------------------------------------------------------------------------------
#(98 16.082024156883 #(0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.695913722267 #(0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.435913738557 #(0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

     13.248109 #(0.000000 0.806557 0.262881 1.867756 1.016904 1.114474 1.460983 1.144977 0.448064 0.564776 1.309806 1.407660 0.456039 0.241507 1.599983 1.315170 1.685695 -0.046356 0.667947 0.978005 0.565613 1.400774 0.028675 1.910738 0.601055 0.692619 1.788011 0.339211 0.756386 1.704737 0.206648 1.489324 1.126591 1.063848 1.933635 1.364613 0.820200 1.412620 0.711578 1.806407 1.151760 1.451559 0.613411 1.775502 1.528788 0.601964 0.555366 0.404114 0.239432 1.363959 1.526932 1.485087 0.640645 1.353945 0.021482 0.454975 0.710329 0.785540 0.581148 0.546960 1.392598 0.381629 1.529397 0.167858 1.862416 0.867406 0.913261 1.620342 1.571704 1.174026 0.693710 0.486823 0.941496 1.086163 -0.040154 -0.028709 -0.350031 1.360503 1.509944 0.465076 1.731316 1.903022 0.000146 0.055909 1.763235 1.211515 1.381084 1.828342 1.857280 1.390634 1.624002 1.283691 1.528542 1.941368 -0.211128 0.514289 -0.192757 0.769871)
     )

;;; 99 prime --------------------------------------------------------------------------------
#(99 16.078 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0)
     15.391923904419 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

     13.417088 #(0.000000 1.559945 0.679892 0.674962 1.756398 1.695903 0.401813 0.005080 1.029154 0.671775 1.171238 0.285684 0.630452 0.755517 0.815868 1.357683 0.610223 1.143563 1.614983 1.595505 1.069498 0.796386 1.119027 0.834828 0.740210 1.949991 0.061002 0.953336 1.230924 0.958287 1.371388 1.564298 0.261222 -0.010390 0.773606 0.940706 0.956031 0.810858 0.887419 1.164018 -0.115594 1.559292 0.579724 0.991116 1.439472 1.418994 1.216858 0.729381 0.540029 0.156547 1.728180 0.684488 0.509670 1.038439 1.050519 0.045074 1.132486 0.551763 0.844086 -0.039091 0.477565 0.399046 0.989335 0.707601 1.907892 1.929551 0.370973 -0.067772 -0.350270 0.633308 1.462355 0.124279 1.017802 0.790201 1.200371 0.099750 1.422687 1.061369 1.436887 0.911376 0.081101 0.334191 1.262800 0.349036 0.319207 1.279195 0.066768 0.784048 0.689953 -0.085822 1.130693 1.794484 0.390554 1.520836 0.796991 1.632885 0.940490 0.541288 1.233197)
     )

;;; 100 prime --------------------------------------------------------------------------------
#(100 16.360503791276 #(0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0)
      15.909478013087 #(0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0)
      15.637986183167 #(0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

      13.350323 #(0.000000 1.347291 1.335295 1.559511 1.513041 0.420091 1.446150 0.936304 0.968825 0.471476 0.229477 1.490924 1.146614 0.849935 0.272878 1.543067 0.347814 -0.183964 1.192151 -0.000406 1.244043 0.510242 0.312847 0.704933 0.429063 -0.195030 0.012066 0.364912 1.415345 0.499942 0.823523 1.178868 0.020705 1.397189 1.198130 0.051001 1.467040 1.323921 1.208960 0.128077 0.136646 0.425231 0.308165 1.120807 1.593734 1.046358 -0.090457 0.819613 1.336156 0.159520 1.565179 1.640817 0.820969 0.025706 0.585067 1.097878 0.806226 1.779178 1.936539 1.231978 1.727892 -0.025632 -0.199731 1.298209 1.651621 1.113488 1.644500 1.253673 0.566898 1.212925 0.163316 1.648533 0.338483 1.505009 1.463799 1.930395 1.037162 1.275538 -0.138791 0.123191 1.494724 0.659895 1.078520 0.561220 1.267316 1.542507 0.599513 0.706521 1.538514 1.921392 0.977027 0.964494 1.829239 1.658676 0.623196 0.410435 0.630435 0.208433 1.515059 1.199698)
      )

;;; 101 prime --------------------------------------------------------------------------------
#(101 15.994265071036 #(0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0)
      15.74836063385 #(0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
      15.735968313601 #(0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

      13.367912 #(0.000000 0.654247 -0.091498 1.529566 0.905510 0.063118 0.360987 1.604033 0.336155 0.141129 0.328458 1.562039 0.273322 1.796364 1.134065 1.496218 -0.147314 1.491008 0.375911 1.079236 0.689347 1.311013 0.300978 1.275996 1.814558 0.081484 0.406729 0.712703 -0.356399 -0.038969 0.024023 1.429284 0.887421 1.037849 0.501236 1.174085 1.046310 0.104379 0.585085 0.083337 1.911528 0.153750 1.390828 1.121544 0.607100 0.513995 0.179122 1.607381 1.463256 1.114189 0.457923 1.704870 0.126489 1.289546 -0.023958 1.001482 0.366164 0.161977 0.543713 0.947266 0.809842 0.062521 1.247137 0.150843 0.714702 -0.062568 0.692229 -0.259662 0.911269 1.122622 1.204335 -0.089709 1.207972 0.102285 1.714895 0.827832 1.052186 1.303130 0.534419 1.551686 0.717385 0.094388 0.534082 1.213040 0.565091 0.858818 0.204472 0.410718 0.986172 0.643377 0.318661 0.346982 0.842806 0.272745 0.132947 0.372491 1.102802 0.886143 0.185439 0.509936 0.596354)
      )

;;; 102 prime --------------------------------------------------------------------------------
#(102 16.342473246951 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1)
      15.374809992584 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

      13.734776 #(0.000000 0.221877 1.243121 0.124249 0.534786 1.740095 0.309831 0.472160 0.913336 1.586492 1.542612 0.127636 1.695775 -0.249305 0.474613 1.165661 1.540073 0.214973 0.496311 1.279505 1.164011 0.006533 1.566821 -1.776331 1.272407 1.234801 0.842033 1.662228 0.023604 1.862499 1.249007 1.372462 0.763687 1.466331 0.268718 1.112790 0.942525 0.201331 0.255182 0.847207 0.448221 0.205017 1.535718 0.821255 1.392787 1.591272 1.418683 0.550308 0.502008 0.891037 1.292234 1.497745 1.636601 1.314780 0.241229 1.735772 1.046111 1.516883 1.505525 1.125668 1.191540 1.024114 1.722574 1.218940 1.628030 0.993848 1.509907 0.258484 0.875189 0.582090 0.563444 1.700417 0.435370 1.333991 0.876028 1.270626 1.365904 0.451492 -0.076741 1.558101 0.002255 0.605875 0.745534 0.526966 1.785687 0.643974 0.605130 0.715142 0.306563 1.460811 0.757927 1.268627 0.072038 1.421838 1.348002 0.106015 1.197327 0.298970 1.442966 0.917147 -0.204056 -0.006923)
      )

;;; 103 prime --------------------------------------------------------------------------------
#(103 16.7018587939366 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)
      16.296298498866 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

      13.772705 #(0.000000 0.238354 0.536558 0.324929 0.704065 0.507699 1.507532 1.517100 0.638503 1.444394 0.431866 0.840836 0.265987 0.223329 -0.020791 1.664785 0.769555 0.180190 1.719330 0.271487 0.974353 1.134294 -0.055623 0.638430 0.946376 0.202208 0.781306 0.139141 1.445604 1.331632 1.326980 0.618119 0.040494 1.345823 0.380539 1.247570 0.485588 0.077155 1.900221 0.559785 0.028733 1.556634 1.873143 0.584114 -0.004187 0.970645 0.481924 0.856825 0.182393 0.681554 0.438141 0.522591 0.830257 1.834920 1.657443 1.318948 1.258636 1.781056 0.372371 -0.068325 0.738084 -0.067199 0.666146 0.378842 1.473734 1.566571 0.336762 1.070138 1.335755 0.258751 0.922542 -0.100712 1.927664 1.600578 0.511452 1.293875 1.594452 0.415793 0.952708 0.779595 1.753124 1.503190 0.875825 0.615630 1.312943 0.645958 1.194518 1.043613 0.195353 0.359734 1.643154 1.907836 0.852858 1.602648 0.618506 1.343838 0.398837 1.157758 1.729708 1.187759 0.597997 0.494442 0.872763)
      )

;;; 104 prime --------------------------------------------------------------------------------
#(104 16.659368297545 #(0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      16.473171464163 #(0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      15.919013023376 #(0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

      13.798755 #(0.000000 0.158208 1.100815 -0.149578 -0.331795 1.586577 0.086540 1.230227 1.397764 1.202456 1.027955 0.150168 0.001322 1.491319 0.993032 1.321883 1.130725 0.939476 0.949499 0.346466 0.151062 1.790475 0.455541 0.397950 0.697306 0.905876 0.435187 1.325595 0.518208 0.689537 0.597667 0.057017 0.584662 1.618757 1.266989 1.343689 1.421971 1.305282 0.494843 1.356514 0.586401 0.905545 1.687101 0.665092 0.482878 1.466711 1.119877 1.397606 1.582428 0.155027 1.757973 1.792727 1.496985 0.859516 1.051373 0.758813 1.720110 0.331775 1.857007 1.293664 -0.033909 0.450984 1.206132 1.431541 1.435665 -0.120562 1.691849 1.447731 1.195636 -0.096714 1.597617 0.065317 0.637852 0.385566 0.691807 1.459954 1.927414 -0.365938 0.054375 1.428127 1.188020 0.890550 0.341087 0.575758 1.306142 1.629895 0.356272 1.371701 1.160231 1.183657 0.113366 0.274006 0.948805 0.176391 0.265958 1.054493 0.279910 0.685234 1.267222 0.825521 1.489879 0.762077 1.253461 -0.184227)
      )

;;; 105 prime --------------------------------------------------------------------------------
#(105 17.115185731735 #(0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1)
      16.038356734428 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

      13.733954 #(0.000000 -0.057207 0.202276 0.185274 0.126702 1.487775 0.560354 0.488858 0.081591 0.774343 0.419146 1.541621 0.626389 0.577437 1.705918 1.726068 1.196291 0.123183 1.327598 -0.045578 1.150621 -0.174194 1.592878 1.091598 1.240179 0.131065 1.475428 1.316258 1.197934 1.545057 1.801324 1.347733 0.056423 0.115307 0.847007 1.363723 1.354264 1.498486 0.645884 1.029424 0.523531 -0.033214 0.180910 0.329707 1.466191 1.722143 1.650013 0.316790 -0.161566 0.572711 1.144891 1.283886 -0.041891 0.869680 1.505028 -0.165390 1.363371 1.758632 0.561180 0.853593 1.967762 0.390348 0.298768 1.512178 1.124543 0.800175 -0.187913 0.095403 0.949442 0.124104 0.949703 1.501429 1.387851 -0.086070 1.226796 -0.059413 1.752856 0.787439 1.427513 0.416599 0.652411 0.790945 0.816452 0.432856 1.499300 1.805749 1.136543 1.428011 1.551056 1.666298 1.285181 0.042618 -0.046349 1.093249 1.456235 0.069290 0.885411 1.876144 0.497724 1.131476 0.118694 1.851809 0.657571 1.286536 1.789641)
      )

;;; 106 prime --------------------------------------------------------------------------------
#(106 16.130035426315 #(0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1)
      15.730461834714 #(0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

      14.044266 #(0.000000 1.168391 1.688412 0.804848 -0.304384 0.906747 0.058327 1.644042 0.624335 0.494527 0.615524 0.622222 1.409697 1.718821 0.350090 1.389658 1.209032 0.180248 0.931190 1.365269 0.343767 1.812733 1.237468 -0.512139 1.118740 1.498549 1.056374 0.761146 1.886816 1.170955 1.402087 1.845065 0.433271 -0.138902 0.762070 1.059789 1.337425 1.329490 0.401868 1.103406 1.162577 0.636318 1.490876 1.313403 1.297553 0.262629 0.635850 0.096304 1.031049 0.294039 1.009510 0.909412 -0.062032 1.017405 1.112563 1.191585 1.517058 0.331334 0.462812 0.001922 0.181448 1.035009 0.663188 1.733732 0.727981 0.679770 1.097288 0.999696 1.115074 0.544753 1.258146 1.004226 0.521647 0.271801 1.681253 0.778102 0.311500 1.911441 0.342980 0.381079 -0.044874 -0.067470 1.286002 0.427334 1.371015 1.419744 0.996442 1.589182 1.047697 0.858619 -0.306462 0.283883 1.146414 1.672801 1.730907 1.769098 0.878023 1.247921 0.092427 0.447693 -0.050116 0.332543 1.335542 0.821866 0.773028 1.070814)
      )

;;; 107 prime --------------------------------------------------------------------------------
#(107 16.541004232936 #(0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1)
      16.328491210938 #(0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.264743804932 #(0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.2013 #(0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

      14.118279 #(0.000000 0.309578 0.433032 1.201941 0.702272 1.695979 1.040730 -0.021916 1.688469 0.128463 1.509670 1.460615 1.534028 0.801508 0.194107 0.873256 0.455218 0.689835 0.385046 -0.015583 1.277196 0.930713 0.664839 1.077093 1.870296 0.768058 0.314184 1.584528 0.341102 1.634370 0.402593 0.739632 0.027738 1.006818 1.307907 -0.050412 1.142453 0.876470 1.243777 1.120053 -0.001249 1.331518 1.456581 1.097026 1.225886 0.815335 1.403207 0.120641 1.510594 1.433979 1.525469 1.766478 0.770608 0.353099 1.569449 0.752264 0.301105 1.277781 0.614478 1.051196 0.783966 0.540327 0.280075 0.560022 1.372883 1.373512 0.534535 0.770166 0.124949 0.184874 0.641705 0.429014 1.865665 0.933858 0.212224 0.623596 0.843016 0.341843 0.985754 1.179071 0.844780 1.728357 0.033317 0.842639 0.364646 0.568863 1.660410 0.621760 1.534506 0.481556 1.691609 1.550537 1.223125 0.698850 0.362714 1.164226 1.004211 0.575552 0.226514 0.097768 0.697810 1.563454 1.172327 1.297605 0.621703 -0.068260 1.166413)
      )

;;; 108 prime --------------------------------------------------------------------------------
#(108 17.139458240072 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1)
      16.664336486859 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1)
      16.517358779907 #(0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

      14.222145 #(0.000000 0.599318 0.638584 1.288517 0.293646 1.540621 -0.178150 1.476100 1.098450 1.640201 -0.015230 0.111038 1.199095 0.664050 1.667587 0.303470 1.744176 1.682686 1.309820 0.745518 0.857420 1.060908 0.537889 0.981349 0.025491 1.766826 0.230263 0.176099 1.629897 1.807307 0.596113 0.968111 0.206805 0.433488 1.214545 0.791476 0.529768 1.272767 0.103127 0.379186 0.512906 1.130058 1.037583 -0.204777 0.670791 0.236406 0.442510 1.744854 0.583293 1.737013 0.648648 1.837082 1.658988 -0.110766 1.254309 0.018486 0.745459 1.607560 0.769936 1.465605 0.801145 0.489387 0.669714 0.599173 0.489382 0.345900 1.804959 1.312825 0.175844 0.276952 0.884274 0.761508 1.873498 0.835047 0.282611 1.452564 1.686154 0.143142 0.037846 0.673694 1.027602 1.066025 0.202472 0.000487 1.522137 0.112020 0.917102 0.279099 0.300973 0.703228 1.494839 0.481807 0.482812 1.503146 0.968238 0.538350 1.074987 1.670845 0.562804 1.840202 1.382023 1.801281 0.215956 0.003567 1.659404 -0.099932 -0.311447 1.693331)
      )

;;; 109 prime --------------------------------------------------------------------------------
#(109 17.4553 #(0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)
      17.086888321276 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.93954489715 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.726722717285 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

      14.419214 #(0.000000 1.300790 -0.006926 0.773327 0.708801 1.015725 0.035532 0.226004 0.945952 0.534916 0.402579 1.073290 1.498778 0.238919 1.619468 1.320496 1.535472 1.053367 1.812064 0.391906 0.180223 0.796572 0.139915 1.539512 0.578652 1.362616 -0.069406 1.593469 0.408819 0.979317 0.890705 1.681394 0.756783 0.210938 1.458372 0.943836 1.251372 0.867572 0.896799 1.216196 1.576241 1.567004 0.739566 0.625992 1.253050 0.032154 1.484322 0.353187 0.889775 -0.048650 1.593411 0.310678 1.308218 0.831486 0.840779 0.241462 0.716517 0.756137 0.891262 0.964786 0.804902 1.545584 0.888058 1.558892 0.454797 0.717132 1.507170 0.938320 1.473778 1.190394 -0.131379 0.932203 0.180487 0.236346 1.344305 0.601074 0.471478 1.421418 0.318443 1.634065 1.168984 1.473262 0.405938 0.455669 0.277548 0.089718 -0.105955 0.766990 1.673855 0.459974 0.539123 0.351769 0.772969 0.029607 1.566211 1.894868 0.434534 0.473609 1.869304 1.490013 0.507535 0.153474 1.266197 1.236000 1.126231 0.766448 0.762158 1.207849 0.416779)
      )

;;; 110 prime --------------------------------------------------------------------------------
#(110 17.014086078381 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1)
      16.799713998439 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1)
      16.455888332339 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

      14.426873 #(0.000000 1.039166 0.514619 1.450796 0.140005 1.064093 0.944980 0.913520 0.213750 0.095845 1.051913 -0.038085 1.842847 0.522460 1.705237 0.392511 0.249279 0.652200 0.691180 0.727147 0.221881 0.819418 1.615676 1.183390 1.720363 1.197507 -0.004953 1.333453 1.376768 0.132674 0.516867 1.048115 0.004219 1.067702 1.422479 0.459724 0.135972 1.513600 0.409821 1.783523 1.707333 0.086960 1.140839 0.367325 0.444879 1.408237 0.386379 1.926705 1.751398 0.327167 1.768948 0.640168 0.131968 0.092947 1.726434 -0.017572 1.921486 1.620687 0.713713 1.721261 0.978353 1.401084 0.686441 1.364529 -0.001337 0.407102 0.608210 1.206334 -0.152870 0.356790 -0.009919 -0.090009 0.618983 1.639555 -0.128631 1.754325 1.659546 0.826274 -0.152067 1.637028 1.908577 1.491225 0.848067 0.847922 0.199798 1.624607 1.714322 1.382941 1.553981 0.443838 0.744395 -0.070181 1.564362 0.835583 0.621513 1.817217 0.286471 1.282179 -0.003312 0.585323 1.207241 -0.055570 0.191386 0.560983 0.852781 0.471364 0.476339 0.453849 1.587045 0.346710)
      )

;;; 111 prime --------------------------------------------------------------------------------
#(111 16.941944255543 #(0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1)
      16.783880166046 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)
      16.6662 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

      14.358766 #(0.000000 0.659407 0.547971 0.601549 -0.028974 1.373525 1.798721 1.198662 0.979211 0.662947 0.136636 0.342132 0.325957 1.176519 1.386220 1.347916 0.957115 -0.052670 1.458363 1.168401 1.018063 1.690943 1.300300 0.497557 1.164762 -0.000129 0.856057 0.508065 1.494447 1.393105 0.983196 0.937358 1.434769 0.876672 1.837136 0.562990 1.433507 0.706022 0.129804 1.923902 1.693111 0.839175 0.891579 1.624837 0.186684 0.832938 0.717215 1.558207 1.159672 -0.048943 1.011181 -0.046400 1.762824 1.165196 0.135140 0.655628 -0.132993 0.282647 1.730818 1.624686 0.107364 0.340237 0.557052 1.595467 1.278033 1.713650 1.840910 1.637383 1.589750 1.070182 0.876249 1.416170 1.058428 1.101365 1.542914 1.141893 0.037098 0.314337 0.552063 0.033999 -0.197783 1.674368 0.784119 0.933804 0.958217 0.033527 0.308507 1.150017 1.084754 1.432294 1.174488 -0.130959 0.308899 -0.209192 1.123864 -0.270016 1.557410 0.064706 0.086060 0.152416 1.469301 1.455282 0.684911 1.591490 0.825123 0.306192 1.519915 0.070585 -0.139883 0.415905 1.100580)
      )

;;; 112 prime --------------------------------------------------------------------------------
#(112 17.423562009124 #(0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)
      16.697049415765 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

      14.512239 #(0.000000 0.823904 -0.026523 1.191200 1.738972 0.777179 0.946076 1.347166 0.791446 1.746648 1.170600 0.743502 1.370829 0.626619 0.802756 1.911766 0.191174 0.743365 0.082081 0.609440 0.538666 1.301472 1.192544 1.517308 0.632716 1.434155 1.371011 -0.348053 0.705356 0.034351 1.432956 1.954948 0.002890 1.410013 1.192581 0.613872 1.618336 0.870312 0.270214 1.778357 0.277457 -0.070267 1.753390 0.765589 0.372362 0.266454 1.739881 0.812017 0.529720 0.110219 0.141460 0.351444 -0.031122 0.241114 1.021806 1.913743 0.594823 1.268346 0.094330 0.142220 0.762310 1.769818 0.865720 1.256483 1.201361 0.342471 1.874103 1.390767 0.737992 1.871024 0.285992 1.299653 1.099243 1.782183 0.406719 0.880075 1.744972 1.925984 0.299195 1.450742 0.260394 0.509957 0.596303 0.957482 0.640024 0.108720 1.711047 1.197895 0.633768 1.204059 1.926061 1.519598 0.046797 1.457380 1.114454 0.803559 -0.112607 1.230066 0.586343 0.005752 1.144948 0.815816 0.368985 0.911106 0.726444 0.904422 0.281286 0.533560 0.562610 1.062592 -0.032279 0.343720)
      )

;;; 113 prime --------------------------------------------------------------------------------
#(113 17.29593895793 #(0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0)
      16.7898 #(0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1)
      16.203890830538 #(0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

      14.786014 #(0.000000 0.788373 -0.358172 1.128706 1.623176 1.037114 1.488254 0.899659 1.429510 1.518287 0.698778 -0.131251 0.628924 0.324429 1.157348 0.646091 1.144403 1.057406 0.233292 0.139601 0.996627 1.712925 1.329768 0.154083 0.543528 0.775271 1.674670 0.294816 0.842786 1.183472 0.462813 0.441326 -0.073156 0.931105 1.875955 1.707066 0.124343 1.399632 1.788492 0.149571 0.671145 1.230967 0.589257 1.384336 1.231158 1.501441 1.320324 0.007033 1.500650 0.482075 0.533416 1.011762 0.355345 1.285008 1.214893 0.007796 1.262646 -0.091463 1.528651 1.637271 -0.035028 -0.107942 0.074131 1.809202 1.065455 -0.035082 0.133037 0.765301 -0.022712 1.074905 0.438038 0.655216 1.706208 0.696533 0.278876 0.483443 1.798921 0.271167 0.446037 0.050000 1.106320 1.041730 1.589234 1.504740 0.264765 1.902703 0.855665 1.279842 0.558551 0.103286 -0.007444 0.513057 0.184740 1.129864 0.281098 1.037482 1.241272 0.344156 1.449324 1.817232 1.626209 1.278025 1.041896 0.690845 0.492841 1.850950 1.460211 1.831747 0.689224 1.278534 1.090858 0.968413 0.106950)
      )

;;; 114 prime --------------------------------------------------------------------------------
#(114 17.592388063856 #(0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1)
      16.769464540605 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)
      16.442732865586 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

      14.948891 #(0.000000 0.978978 0.726730 1.128308 -0.147953 1.932326 1.165075 1.257746 1.485226 1.487200 1.904894 1.564821 0.905982 1.393084 0.335668 1.582710 0.079030 0.864439 1.776450 1.115845 1.271879 0.252132 1.799846 1.372890 1.402315 0.757744 0.243702 1.292339 -0.151615 0.648808 1.088920 1.386682 1.674450 -0.071733 1.553538 0.355673 0.432627 1.309699 1.755264 0.623021 0.902501 1.501949 0.220334 0.493978 0.443102 0.641838 1.707412 0.277483 1.804339 0.372677 0.923711 0.712884 0.336069 0.493459 1.847191 1.923149 1.818283 1.185702 1.534563 1.897698 1.843882 1.473773 0.047793 1.662878 1.344406 0.646665 -0.050595 1.500280 1.356185 0.810597 1.259955 1.388231 0.001823 0.189353 0.606286 1.122536 0.942480 0.506064 0.248304 0.437235 1.278690 -0.030877 0.019077 1.653080 1.191210 0.271344 1.257047 0.913483 0.870597 1.502525 1.413387 1.204756 1.454413 1.875837 0.214780 0.352315 0.240268 -0.235823 1.773094 0.935520 1.003721 0.550964 1.815067 1.131293 1.318912 0.993374 -0.001400 0.023449 1.685309 1.309732 1.104725 0.087360 0.351955 0.408322)
      )

;;; 115 prime --------------------------------------------------------------------------------
#(115 17.480941944057 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0)
      17.1559 #(0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 0)
      16.774665887963 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

      15.003644 #(0.000000 1.521334 0.324519 1.180852 0.342269 0.799302 0.349376 1.490931 0.461994 0.698235 0.579424 1.296593 1.551890 0.452325 0.217462 0.161273 -0.263563 0.956767 0.750000 1.429229 0.470176 1.026787 0.676033 0.015889 0.669290 0.514550 1.203210 1.474618 0.116623 1.599761 0.832043 0.391929 1.811585 -0.186016 0.596675 1.440842 0.238095 1.569401 -0.423337 0.600943 1.439827 -0.143576 1.625588 0.165713 0.566686 0.533658 1.562619 1.024286 0.034242 1.690241 1.281311 0.484921 -0.036568 0.925811 1.107110 1.281428 0.216351 1.800838 -0.096038 1.733824 1.486645 1.311669 1.257184 1.903842 0.557251 0.576529 1.289752 1.230487 -0.150515 0.081905 0.138898 1.491903 1.176713 0.368194 0.324368 1.579634 1.402010 1.024846 1.811072 0.737444 0.054879 1.462170 0.847652 1.907709 0.716463 1.461904 0.745498 1.491129 1.371845 0.343171 1.726105 0.464200 0.947454 -0.011851 0.982635 0.639355 1.679065 1.269789 1.067392 0.202943 1.476740 0.202140 0.215580 1.430039 -0.209059 0.429796 1.367410 1.450978 1.482926 1.700384 1.312799 1.134148 0.137432 0.038835 0.318001)
      )

;;; 116 prime --------------------------------------------------------------------------------
#(116 17.885190963745 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)
      16.812931137234 #(0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

      15.011954 #(0.000000 0.895324 1.080605 0.871194 1.797176 1.105444 0.141707 1.190261 0.403795 1.729571 0.049956 0.504870 0.545034 -0.101924 1.313643 1.122682 1.939962 0.576047 1.591576 0.535609 -0.274074 1.950945 0.037173 0.708883 1.705509 1.183891 1.092194 0.791868 0.976740 1.179337 0.678557 0.975956 0.069461 1.494859 1.877908 0.693246 0.403791 0.047075 0.283252 -0.260045 0.791025 1.034602 -0.095147 -0.262920 0.184872 1.038335 0.794040 0.782470 0.304109 1.038061 0.305982 0.340481 0.329622 1.880763 1.696321 0.521828 0.116953 1.196068 0.071045 0.174418 0.458747 0.232042 0.699656 0.962657 1.750888 0.309965 0.563911 0.966881 0.849440 0.518210 0.854257 1.721865 0.585776 -0.186606 0.882232 0.423530 1.875517 0.218284 1.325349 0.770654 0.212122 0.808292 1.579496 1.718136 0.917651 1.247202 1.489896 0.001213 1.364685 1.555169 0.087023 0.568778 1.223376 1.743216 1.543960 1.501413 0.566670 0.473943 1.556665 -0.074547 0.874418 0.289601 0.445176 0.445437 1.538487 1.514579 0.999137 1.845443 0.806883 1.711935 1.054836 1.338621 1.240568 1.080716 0.255118 0.746953)
      )

;;; 117 prime --------------------------------------------------------------------------------
#(117 18.290939331055 #(0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1)
      17.710553146299 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)
      17.5997 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

      15.181137 #(0.000000 0.224326 0.902631 0.098790 1.246900 1.132017 0.263523 1.802895 0.410163 0.651502 -0.032932 0.275146 0.231115 1.705593 0.193145 1.394253 1.160095 1.556795 1.409713 1.698549 0.222818 1.224692 1.482602 1.008240 0.447499 0.668317 1.291378 0.125445 0.526746 0.411943 0.661584 0.684465 0.867579 1.542711 1.766719 1.856037 0.034681 0.769718 0.615133 0.270093 1.502362 0.658587 0.351858 1.045320 1.606480 0.503217 0.216940 0.927440 0.951638 0.551856 0.923275 1.233812 0.914086 0.052408 1.082047 1.165229 1.552389 1.657101 1.541823 0.625354 0.821943 0.556658 0.796364 0.453163 1.274677 1.905624 1.496862 0.312540 1.745685 0.090040 -1.808337 0.317480 1.953635 1.873567 0.799413 0.164165 0.439839 0.678006 1.128292 1.582973 1.243713 0.414201 -0.068000 1.713160 1.069002 1.215011 1.501450 1.332542 1.135367 0.379693 0.475116 -0.004746 1.266495 1.808843 0.473021 1.186028 0.294930 1.465918 0.162180 0.067922 0.341282 1.143951 1.647384 0.637389 1.506229 0.104698 0.601344 0.016105 0.317574 1.056534 1.595644 0.169081 1.484584 -0.018875 0.613216 1.870010 0.690378)
      )

;;; 118 prime --------------------------------------------------------------------------------
#(118 17.985612869263 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0)
      17.181785583496 #(0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

      15.137914 #(0.000000 1.640867 0.780433 1.712049 -0.161474 0.670901 0.482006 1.274545 0.718991 0.776086 0.087845 0.784701 0.310767 1.284980 0.329700 0.902815 1.431718 0.280755 0.937443 1.383084 0.206523 0.249923 0.611057 1.751128 0.601768 0.540698 1.208920 0.885189 0.365543 0.076717 1.678156 0.205674 0.398901 1.038445 -0.239758 1.002600 -0.128405 1.497866 0.348459 1.742440 -0.032207 0.514131 0.594141 0.821487 -0.349981 0.127128 0.898444 1.468461 0.790779 0.963758 0.675344 1.328450 1.633111 0.779342 1.601078 1.436455 0.767272 0.104581 -0.024251 0.738506 0.767227 0.548637 0.638639 1.621830 0.703380 0.343527 0.738198 0.297744 0.016986 -0.062415 0.111411 1.380676 1.165187 1.654255 0.283420 1.215198 0.899737 1.027485 1.246882 0.985765 0.650806 1.656022 0.396593 1.725728 -0.311149 -0.065736 0.223937 1.765199 1.106971 1.715064 1.729307 1.291860 0.646123 0.220546 0.098962 0.882825 1.827312 1.379151 0.628209 1.099082 1.443062 0.296102 0.282024 0.448389 1.639202 0.802788 0.019072 1.267381 0.258817 0.201743 0.559132 0.132762 0.024619 -0.169620 0.491008 0.700473 0.984826 0.652372)
      )

;;; 119 prime --------------------------------------------------------------------------------
#(119 18.0781 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1)
      17.500297546387 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1)
      17.167841346875 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

      15.006433 #(0.000000 1.475939 1.123284 1.217534 0.457017 1.038768 0.337429 1.846941 0.008807 1.248583 1.522239 0.765931 1.002081 0.409814 0.253950 0.835367 1.015371 1.751106 0.710231 0.568312 1.319752 0.141815 1.196235 0.639907 0.871170 1.792801 0.730665 0.086541 0.153688 1.247847 1.485341 1.064472 0.186015 1.167339 1.197413 1.395887 0.951346 1.026541 0.092748 0.402047 0.746467 -0.119835 0.755914 0.966587 1.626902 0.355745 1.706765 1.706105 -0.178878 1.107956 0.887626 0.882426 1.114356 1.183371 1.594317 1.563553 1.403894 1.879219 1.301287 1.955893 1.139745 1.117362 1.196405 1.315510 1.707315 1.602587 0.536065 -0.132992 0.701073 0.364695 1.249668 0.735326 0.319717 0.649877 1.765869 0.879341 0.301771 1.268152 0.190542 0.115418 0.747571 0.410138 1.055035 1.737366 0.769813 1.098021 1.675956 1.868067 0.272785 0.575001 1.076302 1.488183 0.429886 -0.065214 1.371255 0.984994 1.160495 1.078925 -0.143781 -0.056876 0.389900 1.389681 0.922026 0.621552 0.601439 1.811232 0.755350 0.015226 1.412040 1.726424 0.560160 -0.017879 1.926528 0.068931 -0.026802 1.450687 0.873770 1.851103 0.659471)
      )

;;; 120 prime --------------------------------------------------------------------------------
#(120 17.635260884038 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.540792728815 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.067 #(0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

      15.084399 #(0.000000 1.349066 0.768199 1.282160 0.151448 0.057492 1.275033 0.868343 0.970863 1.165031 0.355439 1.047473 0.890245 0.004268 1.207689 0.906997 0.687406 1.716710 0.063995 0.164498 1.218806 0.370186 0.229937 0.684438 1.049243 -0.069305 1.225417 1.870263 1.727722 0.855450 0.901835 1.105697 1.095301 0.884888 0.368718 0.133367 0.065377 1.691901 0.288391 1.479203 0.805942 0.969171 0.544722 0.802658 0.975270 -0.116149 0.337768 0.140628 0.517871 1.283843 1.640142 0.916929 0.472678 0.841827 1.346003 1.443199 1.799617 0.548457 0.511672 1.414072 0.024533 1.448374 0.136517 1.461599 0.582979 0.547236 0.244988 0.299588 1.233362 1.599276 1.389252 0.319888 0.484755 0.446634 1.717476 1.218275 1.383662 1.404694 1.752398 0.954416 -0.160690 0.558077 1.913004 1.511770 0.243355 0.515690 0.169042 0.632460 1.004272 1.508841 1.170444 1.093613 0.018730 1.165413 0.222669 0.317562 0.762711 0.058141 0.050477 -0.086056 0.651531 1.417697 0.366672 1.342366 0.536916 1.080350 0.574676 1.636129 0.980795 0.982020 0.669241 1.081458 0.552138 0.096992 0.809534 0.701964 0.940725 0.630392 1.556548 -0.027099)
      )

;;; 121 prime --------------------------------------------------------------------------------
#(121 18.236074758398 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0)
      17.782977183017 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

      15.321142 #(0.000000 -0.117048 1.681886 -0.034157 0.225788 1.515039 1.746260 -0.361587 0.271444 0.364637 1.216716 1.740918 1.255047 0.161901 0.377525 0.067654 0.444454 0.089529 1.116581 -0.164087 0.549881 1.296717 1.130027 0.737692 0.420493 0.306057 1.703841 -0.241283 0.014144 -0.042929 1.083474 1.331645 0.456784 1.153886 1.139634 0.719368 1.311440 0.673175 0.572299 0.493146 0.535932 1.267344 0.428965 0.843055 0.236023 0.100384 1.628865 1.069575 -0.114976 1.655901 0.230393 1.406226 1.167086 1.340029 0.023328 0.567314 1.545825 -0.091466 1.100500 0.665367 1.393909 0.955962 0.747700 1.613044 1.414513 1.616236 0.486696 0.472358 -0.362768 0.661889 1.099914 1.260910 -0.062308 0.950824 0.967612 -0.070390 1.832823 1.539255 0.625869 -0.025886 1.441267 0.421970 -0.042297 1.418393 0.743352 1.713872 0.175422 0.393203 1.628652 1.428473 0.482139 1.261226 0.223537 0.335134 -0.033516 1.237988 0.035917 1.133045 1.691934 0.649236 0.849955 0.948864 0.799503 0.773480 1.344895 1.167544 -0.106063 0.368291 0.541651 0.639455 1.666884 1.052653 0.331419 0.987203 1.661517 -0.033688 1.087222 0.390595 0.051978 1.036687 0.290769)
      )

;;; 122 prime --------------------------------------------------------------------------------
#(122 18.225525517344 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)
      17.876078447724 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

      15.251945 #(0.000000 0.688640 1.859461 1.521603 1.751725 0.890215 0.607749 1.822219 1.759114 1.753233 1.002949 0.424696 -0.242252 1.240468 1.841921 0.141445 0.029510 1.651913 0.939693 0.925739 1.181659 1.209588 0.383831 0.594499 1.431393 0.421305 -0.116674 0.309796 0.492167 1.817431 1.265813 0.166139 1.896007 1.705249 0.288531 0.559129 -0.320142 1.305505 1.737860 1.044038 1.006098 1.054456 1.813879 1.611474 -0.094076 0.853754 0.317075 0.744886 1.601425 1.482001 0.813213 0.049856 0.964439 1.240553 0.093776 0.228662 -0.016452 0.919376 0.110556 0.386383 -0.041016 0.734648 0.585427 1.723694 1.208069 1.392730 0.806464 1.111013 0.332968 1.764866 1.112561 0.100228 1.309941 1.508438 0.273999 0.017261 1.680330 1.626417 1.469436 0.418360 1.364687 0.766702 0.799923 1.314216 1.632121 0.435944 1.004142 0.236168 1.051523 0.106850 1.298839 1.511274 0.609419 -0.126038 1.435764 -0.093554 0.065428 0.789329 0.264103 0.323049 1.624746 -0.145949 0.735821 0.317636 0.975902 -0.066972 0.328774 0.094732 1.533190 1.437178 1.857223 1.371419 0.337989 1.841120 1.001122 0.884530 1.438326 0.044550 1.523065 0.000571 1.159134 1.898655)
      )

;;; 123 prime --------------------------------------------------------------------------------
#(123 18.144585330068 #(0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1)
      17.389867782593 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)
      17.273 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

      15.220702 #(0.000000 0.076094 0.614190 1.001322 0.947202 0.431033 0.148046 0.299184 1.811943 0.347146 1.879843 0.387433 -0.025914 1.489931 0.836928 1.645797 1.536374 0.958547 0.479540 0.659108 -0.232723 1.843698 1.592907 0.169237 -0.092707 0.970875 1.319865 1.606724 0.267371 1.550300 1.775031 0.525360 0.688239 0.983173 1.473141 1.781249 0.276902 0.663709 0.902158 0.780325 -0.138588 0.750443 1.188222 0.310526 0.132130 0.041814 1.183662 0.955834 1.458813 1.162684 1.689943 1.801563 1.439708 1.245899 0.268778 0.340879 1.023210 1.053583 0.729792 1.114146 1.510925 0.742922 0.525444 0.185928 1.404096 0.462257 0.747687 1.536339 1.105558 0.520130 0.720767 0.248423 -0.130095 1.004970 -0.021858 1.079084 0.565894 1.445069 0.204753 0.421702 0.525875 0.449502 -0.166936 0.900054 1.353947 1.713061 1.406081 0.471150 -0.370299 0.937904 0.323081 -0.138824 0.619482 -0.060088 0.635970 0.908129 0.528311 0.971996 0.700009 -0.047913 0.059198 0.855309 0.415952 0.633834 1.064882 0.445029 1.350947 0.880060 0.821460 0.366689 1.088147 1.574185 0.510625 0.976690 1.549354 1.536031 1.798626 0.761267 -0.040229 1.704702 1.463949 0.078192 0.531566)
      )

;;; 124 prime --------------------------------------------------------------------------------
#(124 18.115 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
      17.868420183527 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

      15.502017 #(0.000000 1.193186 1.105384 1.168210 1.302565 1.987072 1.176984 1.373041 0.482442 0.239171 0.553136 1.162720 0.274018 0.780589 1.304728 1.543394 0.670315 0.065709 1.638389 0.809842 1.414719 1.016044 0.420568 0.063103 1.711117 0.742378 -0.118676 0.603357 -0.083128 1.159509 1.597563 0.654236 1.149182 0.664466 0.761734 1.401662 0.020718 1.315909 0.011383 0.202718 0.861802 0.919277 0.956789 1.451024 0.862675 1.132586 0.630757 0.667359 1.139675 0.183690 1.184219 0.838335 1.608127 1.235364 0.142312 0.166595 1.156359 0.697979 1.413414 0.003272 1.350799 1.387273 1.007962 1.064155 0.036344 1.694998 0.546800 0.407778 1.537836 0.442987 0.527392 1.287569 1.552883 0.161655 0.600297 0.702449 0.917282 0.617505 0.516205 0.174696 0.768900 1.435781 0.434876 1.495192 1.606586 1.180141 0.588863 1.300608 0.287162 1.684867 1.772471 1.329819 1.769942 1.903205 0.945326 1.726694 0.130541 1.902462 0.975081 1.031120 0.686555 1.362909 1.235972 0.205733 1.288031 -0.001134 1.545322 0.816919 0.918578 0.301358 0.957377 1.573069 1.778899 1.870019 1.945117 -0.109873 0.089421 0.674217 1.955078 1.064884 1.143856 1.720063 1.077344 1.244831)
      )

;;; 125 prime --------------------------------------------------------------------------------
#(125 18.072 #(0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1)
      17.637776156888 #(0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

      15.362448 #(0.000000 1.654918 0.720556 0.684643 1.709943 0.652844 0.631424 1.917287 -0.233197 -0.112682 0.988906 0.271155 0.511579 0.658025 0.112073 1.046208 0.660085 0.486493 1.025100 1.192677 0.530423 1.353432 1.197801 1.063185 1.235353 1.180145 0.165405 0.042759 -0.417545 1.119972 0.133205 0.479940 1.037093 -0.225334 0.705207 0.100943 0.209029 1.868183 0.062819 0.351250 0.853666 0.709486 0.176903 -0.114001 1.578748 1.248181 0.747113 0.764470 0.840062 1.803154 0.936251 0.907981 1.269213 0.370148 1.462391 0.405455 1.206449 0.074874 1.939105 1.123635 0.652890 0.679214 0.069371 0.623402 0.295628 0.301653 0.503425 -0.066810 1.152252 1.416505 0.242059 0.091715 1.327333 1.290367 1.310794 1.271543 0.574527 0.649270 0.039244 0.034992 1.451171 -0.029592 1.619078 0.626239 0.963385 1.668878 0.741597 1.867663 0.682986 0.827351 0.704187 -0.040316 1.143270 1.494232 -0.028913 0.540397 0.601378 0.760909 0.172475 0.705596 0.388340 1.046330 0.369936 0.055605 1.208938 0.958396 0.278936 -0.121301 0.200190 1.791690 0.677243 1.418077 1.353727 -0.014837 0.196793 0.935015 0.703204 1.733907 1.184366 0.209569 -0.226600 1.285465 1.457423 0.390204 1.939354)
      )

;;; 126 prime --------------------------------------------------------------------------------
#(126 19.269804000854 #(0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1)
      18.284595039843 #(0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

      15.535587 #(0.000000 1.440007 0.535311 0.784644 1.709874 0.199632 0.903980 1.404063 1.486411 1.314036 -0.166500 1.312270 0.007419 1.239495 -0.058995 1.417472 0.767443 -0.009963 0.483705 0.381887 0.824647 1.331920 0.240301 -0.383342 -0.046978 1.566543 1.732035 1.841683 0.512023 1.330894 -0.059741 1.503898 1.031487 1.398704 1.625505 0.223186 0.908584 0.702414 1.260332 1.798861 0.779851 1.468086 1.451696 1.650555 0.637286 1.166135 1.298032 0.676642 1.229931 1.664120 0.246939 0.985628 0.693218 0.117867 1.523461 0.260653 0.375127 0.624345 0.535898 0.851013 1.196258 0.254310 0.701350 0.863227 0.841520 0.182376 0.203451 1.144976 1.292560 0.658763 0.420240 1.618674 0.868637 0.486460 1.220653 0.892339 1.566554 0.848412 -0.167138 0.118069 0.636638 1.565761 1.297982 1.414404 0.320744 0.266353 1.457003 1.087643 0.928316 1.475438 1.085669 -0.385090 0.581401 1.609668 1.164729 1.530074 0.500076 0.513999 0.124385 0.485108 0.444518 1.264176 0.997350 1.077053 0.222489 0.024891 1.502145 0.111301 1.012023 -0.093828 1.399469 1.065889 1.763257 0.828977 0.916362 1.867140 1.033813 -0.067123 -0.010455 1.392517 0.540790 0.190873 1.379682 0.626017 0.760619 0.400514)
      )

;;; 127 prime --------------------------------------------------------------------------------
#(127 19.129140790802 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)
      18.198689419357 #(0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

      15.423949 #(0.000000 -0.068229 0.267688 0.575691 0.591258 1.632677 1.777805 1.169958 1.800941 0.107565 0.683242 1.259603 -0.242478 0.425680 0.876706 0.630510 1.865862 0.998362 0.105690 0.807726 1.059385 0.326149 1.101475 0.799923 1.002494 0.413507 0.742211 1.154543 0.714087 1.406898 0.078656 1.268647 0.812276 1.772963 0.408524 0.931640 1.674739 0.805382 1.364353 -0.215538 1.194779 1.798259 0.668526 0.267624 1.757023 0.795779 1.752988 0.407965 0.318453 1.335940 1.262505 1.369480 1.171166 0.782644 1.277960 1.848536 0.788292 0.858543 0.355767 0.991551 0.550350 -0.029673 1.021708 0.992889 0.247588 1.787875 0.216754 0.080255 -0.436436 1.884775 0.639373 1.733017 -0.089457 0.951211 0.762325 1.151384 1.564490 1.546516 0.576219 0.650196 0.972414 0.160430 1.194341 0.264746 1.112508 1.269578 1.198527 0.717220 0.301604 1.627012 0.908117 0.090997 1.251716 1.282557 1.387603 0.963555 0.314566 0.698657 1.243513 0.899135 0.170171 0.112056 0.849981 0.167081 1.467325 0.653224 0.241637 1.719437 1.908013 0.877879 0.941773 0.587039 1.567096 1.213344 0.942158 1.737165 0.840726 0.245156 0.412159 0.203869 0.101863 0.423622 0.965750 0.885603 0.781999 1.336122 0.823527)
      )

;;; 128 prime --------------------------------------------------------------------------------
#(128 18.871676504971 #(0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1)
      18.306106723228 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)
      18.276384353638 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

      15.686779 #(0.000000 0.979651 1.537016 1.181726 1.862616 0.174626 1.819718 0.733293 -0.095941 0.216225 1.363778 0.865687 1.435754 -0.075491 0.899025 1.109137 0.947837 1.495148 0.926234 0.701109 1.735827 0.370019 0.878408 1.821532 0.885518 0.909199 1.488364 1.581318 1.336424 1.673582 1.850812 -0.257866 -0.016581 0.020435 0.093834 0.331827 0.174171 1.391198 0.544307 -0.016343 0.657815 1.833354 0.425262 1.761253 0.309422 1.931132 1.532811 0.633160 0.202740 -0.131869 0.348352 1.764851 0.643102 1.210746 -0.178354 1.034409 0.335541 1.550093 1.915689 0.635516 1.332592 1.325235 0.989694 1.308152 1.599277 0.251584 0.416791 1.069196 0.547375 0.148300 0.666663 1.686635 1.786636 1.153302 1.952982 1.374036 1.081645 1.042714 1.633467 -0.229743 0.917544 1.284479 1.900045 1.717268 1.283712 1.441808 0.618335 0.849974 -0.019614 -0.074100 0.861441 0.684155 0.626783 1.989703 1.817180 1.284678 0.683762 0.410896 -0.067566 1.147659 0.994150 0.590098 0.447205 1.697644 1.765019 0.891012 1.840350 1.385415 0.409455 1.214262 0.770241 0.687793 0.528441 0.897142 0.794231 1.512882 1.201444 0.356692 1.650858 0.804883 0.729351 0.568769 1.642450 1.152032 0.092117 0.519293 1.182557 0.774254)
      )

;;; 256 prime --------------------------------------------------------------------------------
#(256 27.740 #(0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      25.419292 #(0.000000 1.139929 1.102745 1.741314 0.362270 1.867278 -0.105796 0.818148 1.710527 1.852271 1.124318 1.670890 1.153503 0.195801 1.002124 0.467505 1.049937 0.142894 0.085485 1.658937 0.491728 1.241311 1.322988 0.765513 1.862684 0.158048 0.184902 0.364251 0.607460 0.160072 1.059841 1.058104 1.188210 1.281788 0.605768 0.044404 0.063311 0.674089 0.592930 0.211703 0.030582 0.160150 1.609868 1.314862 1.540462 0.499958 0.255349 1.385713 1.225596 1.323240 1.907235 1.512131 0.755403 0.859403 1.645985 1.326003 0.062908 0.441796 0.954669 0.168027 0.516707 0.922222 0.189230 0.272544 0.472239 0.553957 1.434892 0.429635 1.400931 0.255779 0.446915 -0.097364 0.010974 0.185385 1.838088 0.722158 0.636251 0.319610 0.900579 0.585282 1.916411 0.284763 1.647549 0.469510 0.056494 1.051937 0.839561 0.491974 1.028802 1.773079 0.399350 1.305864 1.439648 1.938862 1.794159 0.371223 1.096547 0.742554 0.816016 1.210775 0.917874 0.861164 0.505923 1.824144 1.685486 0.860715 1.263824 1.850040 0.906459 1.245640 1.446237 0.478492 0.330388 0.240550 0.475287 0.333923 0.461789 0.887379 0.765592 1.453119 0.159768 1.029570 1.310462 0.743877 0.659014 0.156047 1.339711 1.733763 1.914764 1.783195 0.311674 0.523974 1.009176 1.284070 0.814963 1.982550 1.654619 1.786557 0.152975 0.552534 1.941831 1.909265 0.024048 1.982739 0.172030 0.361974 1.716273 -0.145229 0.059166 0.923627 1.369358 0.259568 0.603591 1.244786 1.772948 1.455451 0.278943 1.396699 0.483204 0.706810 0.610680 1.017552 0.504030 1.246537 0.695997 1.710753 0.064401 0.966739 0.486122 1.103392 1.069961 1.199883 0.173924 1.605015 1.493330 1.468259 0.224231 1.356642 0.799457 0.943289 1.443695 0.483173 1.340693 0.391180 1.005750 1.024557 0.693691 0.750249 0.307649 0.380108 1.914054 0.115308 0.520112 0.000006 0.467400 1.333649 0.446022 0.351018 1.570672 1.024307 0.066464 0.462119 0.177876 0.365882 0.903910 0.056543 1.482436 0.056456 1.134537 0.787030 0.268455 0.834182 -0.004538 1.625912 1.079081 1.485660 0.837184 0.498066 1.823166 1.225371 1.040093 0.129168 0.924645 0.160099 1.780342 0.192620 1.690804 0.751720 1.760030 1.260828 0.448859 1.138104 0.090032 0.250034 -0.145296 1.040075 1.391702 0.079881 0.515861 0.385145 1.779559 0.214107 0.743183 1.112600 0.419711 1.838072 1.427776 0.925752 1.817873 0.317608 0.532205 1.862275 0.506156 1.710729 1.157460 0.942925)
      )

;;; 512 prime --------------------------------------------------------------------------------
#(512 43.486 #(0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      40.250883 #(0.000000 1.067513 1.698501 0.882175 0.731347 0.396065 0.813755 0.963760 0.557013 0.330055 0.624000 1.141499 1.802667 1.147883 0.326439 1.700018 0.473901 -1.947004 0.102662 0.379112 0.161997 0.698965 0.728968 1.831300 1.279360 0.816655 0.480698 0.093700 1.500681 0.898464 0.536091 0.756778 0.355391 1.392086 1.233289 1.645259 1.641894 1.615256 0.190786 0.267903 -0.286330 -0.089039 0.457097 0.658540 1.669825 0.917012 -0.042627 1.298688 0.946526 1.789310 0.083576 1.102187 0.738679 1.390586 0.999921 1.312093 1.826088 0.412733 1.685728 0.303259 1.268988 0.900854 0.694405 1.727172 1.988661 1.867458 0.705458 0.724026 0.979505 0.018063 1.080148 0.984039 0.301365 0.996085 0.485066 1.698333 0.099220 0.144439 1.014550 -0.046011 0.199879 0.463422 1.340837 0.783213 1.151598 0.929237 1.727193 1.863491 1.325152 0.546479 0.970852 1.131669 1.594581 0.745485 0.269563 0.379861 0.913425 1.716346 0.963726 0.148826 -0.018344 0.857745 0.892045 1.081944 0.100251 1.000912 0.257282 0.111202 -0.008496 0.039287 1.417113 0.640192 0.675981 0.443529 0.868295 0.738861 0.820750 0.210774 0.082349 0.151630 0.783391 -0.180922 -0.106637 1.765370 0.742155 1.145606 1.368009 0.515346 0.436263 0.531741 0.802011 1.255309 1.894160 0.809353 1.813552 0.281020 0.025004 0.747411 0.889253 1.421629 1.808561 1.930509 0.839043 0.610805 0.811512 0.326999 1.060202 0.726316 0.486908 1.524130 1.740371 0.854892 1.794712 0.054857 0.374885 0.689897 0.804719 0.518621 0.778791 0.586676 1.098197 0.585149 1.186102 0.137320 -0.004366 0.332212 1.070131 1.845537 1.823307 0.557314 0.209620 0.792755 1.166951 0.717837 0.512510 0.629260 0.191128 1.302358 -0.197581 1.489802 0.982325 1.740676 -0.076574 1.688248 0.129965 0.784432 1.177913 1.102657 0.962095 0.929165 0.113690 1.498481 0.501354 0.386777 1.808656 0.189192 1.582104 0.598519 1.088596 1.677954 0.635479 0.886732 1.765869 1.721541 1.323683 -0.029727 1.928583 1.600246 0.279454 1.267423 0.990704 0.156419 0.680659 1.338166 1.787057 1.240138 0.302495 0.331931 0.199416 0.603149 0.714679 0.722359 1.555137 0.579030 0.968070 0.619479 1.564829 -0.173450 0.479277 1.582690 1.625073 -0.082864 1.364367 0.506113 1.020073 0.013031 0.901348 0.115571 1.654832 1.160506 1.382047 1.813620 1.803032 1.458055 0.157051 0.295770 -0.207462 1.435226 1.701103 0.634436 0.784529 0.075139 0.479500 1.222882 1.537827 0.905886 1.390016 0.322620 1.008572 0.815478 1.829604 0.684699 0.623092 1.869009 1.370361 1.545318 0.088302 -0.093316 0.065215 1.068848 0.441787 1.694437 0.956069 0.531992 0.195136 0.288213 1.080005 0.403178 0.327435 0.601585 0.419989 0.803862 0.624187 0.121109 -0.032458 1.233677 1.888075 0.416680 0.921255 -0.123147 1.100991 0.523132 1.866156 1.580633 1.521367 0.834357 0.017950 1.945026 1.112936 0.074866 0.578255 1.851390 0.917212 0.470515 1.494667 1.926605 0.420451 1.685173 1.321757 0.252699 0.908983 0.451996 1.280635 1.347889 1.101279 0.819891 0.717237 1.824992 0.064816 1.741467 0.171609 0.367474 1.450054 1.791245 0.070692 1.882472 0.030173 1.297571 1.480154 1.019678 0.718667 0.009196 0.641561 1.714326 1.179383 0.407542 1.176762 0.501786 1.884444 1.476017 1.294272 0.449015 0.628767 1.217169 0.537140 1.715118 1.505923 0.199813 1.524782 1.165141 1.676667 1.223004 0.016727 0.463878 1.136164 -0.053033 -0.084847 1.208615 1.445901 1.497341 0.161310 1.250596 0.942847 0.829403 0.387769 0.719178 1.738210 0.958532 0.472944 0.434584 0.253559 0.806841 0.948416 1.626398 1.745251 1.181118 0.900461 0.328407 0.004865 0.656956 1.561263 0.493976 0.215685 1.621837 0.977926 0.157229 0.368698 0.411012 0.533672 1.014733 0.265047 1.919729 1.249631 0.505841 0.810354 0.808424 1.184479 0.057215 0.275118 1.014035 1.475267 0.761434 1.193820 1.598491 0.134348 1.906886 0.063865 0.360892 1.182738 1.769838 0.652317 0.819564 0.835923 0.873375 0.958236 1.235262 -0.217562 0.548985 0.580422 0.773421 0.815778 0.094611 0.051274 0.456619 1.003721 0.560851 1.398235 1.328115 1.445608 1.526814 0.276018 1.944863 1.629687 0.184749 1.510383 0.270380 1.027430 1.256674 0.015870 0.564502 0.718165 1.794438 1.735884 0.904383 1.655901 1.675424 0.066250 1.899808 0.176362 1.550287 1.717784 0.905738 1.345949 1.001299 1.577679 0.550037 1.204039 1.754941 0.899017 0.959777 1.948798 0.199359 1.227196 1.454662 0.390714 1.580219 0.079875 1.186840 0.105451 0.922283 1.889599 1.204774 0.367870 0.720431 1.167140 1.635057 1.070144 -0.105934 0.316941 1.460835 1.680478 0.253545 1.791164 1.507054 0.456342 0.357901 1.697439 0.953658 0.592291 1.033133 1.478020 1.576280 1.358444 0.415789 -0.015554 1.241819 0.088719 1.636832 1.709484 0.595426 1.748375 1.690569 1.694795 1.541541 0.654394 0.467730 0.368448 1.418385 1.025035 0.300805 -0.128955 1.867573)
      )

;;; 1024 prime --------------------------------------------------------------------------------
#(1024 70.140 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)
       )

;;; 2048 prime --------------------------------------------------------------------------------
#(2048 102.619 #(0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

#(1 1.0 #(0)
    )

#(2 1.7601724863052 #(0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
#(3 2.2325525283813 #(0 0 0)
    2.0235652605711 #(0 33/64 63/128)

    2.0214650630951 #(0.0 0.52414411306381 0.48787820339203)
    2.021465 #(0.000000 0.475854 0.512123)
    2.021465 #(0.000000 0.524145 0.487877)
    2.021465 #(0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
#(4 2.8359191417694 #(0 0 0 0)
    2.450505601523 #(0 3/16 21/32 15/32)

    ;2.434727537119 #(0 37 52 46) / 31

    2.4311048984528 #(0.000 0.191 0.672 0.479)
    2.4311048984528 #(0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 #(0 0 0 0))
    2.4308773660653 #(0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 #(0 3/16 21/32 15/32))
    2.430877366065 #(0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 #(0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
#(5 2.816308259964 #(0 1 0 0 0)

    2.6048328876495 #(0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)

    2.604848 #(0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
#(6 2.9795869831363 #(0 0 1 0 0 0)
    2.9795892238617 #(0 1 0 1 1 1)

    2.8369779013614 #(0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 #(0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 #(0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 #(0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 #(0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 #(0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    )

;;; 7 even --------------------------------------------------------------------------------
#(7 3.4936672673663 #(0 0 0 0 1 0 0)
    3.3825581073761 #(0 0 0 0 0 1 0)

    3.0470769405365 #(0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 #(0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    )

;;; 8 even --------------------------------------------------------------------------------
#(8 3.7968969947382 #(0 0 1 1 0 0 0 0)
    3.7706393073421 #(0 1 0 1 1 0 0 0)
    3.611234664917 #(0 0 0 0 0 1 0 0)

    3.197691 #(0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 #(0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 #(0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 #(0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    )

;;; 9 even --------------------------------------------------------------------------------
#(9 4.1871630323114 #(0 1 1 0 0 0 0 1 0)
    4.1397546805979 #(0 0 1 0 0 0 1 1 1)
    4.0601739883423 #(0 0 0 0 0 0 1 1 0)

    3.454235 #(0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 #(0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 #(0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    3.454104 #(0.000000 1.619789 1.457225 1.896592 1.905347 0.244468 1.356940 1.495046 0.907280)
    )

;;; 10 even --------------------------------------------------------------------------------
#(10 4.1456241150012 #(0 0 0 1 1 0 0 0 0 0)
     4.0054845809937 #(0 1 1 0 0 0 0 0 1 0)

     3.559069 #(0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 #(0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 #(0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     )

;;; 11 even --------------------------------------------------------------------------------
#(11 4.2814919726737 #(0 1 1 1 0 1 1 0 1 1 1)
     4.8058149616573 #(0 0 0 1 0 1 0 0 0 0 0)
     4.2754249521261 #(0 1 0 1 0 0 1 1 1 1 1)
     4.2368197441101 #(0 0 1 1 0 1 1 1 0 0 0)

     3.656997 #(0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 #(0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 #(0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 #(0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     )

;;; 12 even --------------------------------------------------------------------------------
#(12 4.5077774785482 #(0 1 0 1 1 0 1 1 1 0 0 0)
     4.4722682088655 #(0 1 0 0 1 0 0 0 0 1 1 1)
     4.4100483425078 #(0 0 0 1 1 0 1 0 0 0 0 0)

     3.788546 #(0.000000 1.556167 0.360103 0.557527 1.272879 -0.160667 1.208794 0.416499 0.207991 0.153798 0.406432 0.105283)
     3.788220 #(0.000000 0.550342 1.343009 1.534780 0.244087 0.805462 0.167902 1.368575 1.154099 1.090872 1.336846 1.030125)
     3.787893 #(0.000000 0.448349 1.651266 1.457646 0.745846 0.182779 0.817835 1.614340 -0.173074 -0.112402 -0.361602 -0.056645)
     3.787770 #(0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 #(0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 #(0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     )

;;; 13 even --------------------------------------------------------------------------------
#(13 4.7678911684727 #(0 1 1 0 0 1 0 1 0 0 0 0 0)
     4.4552875568415 #(0 1 0 0 1 1 0 1 0 1 1 1 1)
     4.4076361656189 #(0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973640 #(0.000000 0.230119 1.573121 1.035418 0.607827 0.004639 0.570316 1.864444 0.017841 1.712936 0.049649 0.243649 0.758519)
     3.973518 #(0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 #(0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     3.973148 #(0.000000 0.225623 1.564256 1.022022 0.590378 -0.019884 0.539658 -0.171656 -0.022033 1.670109 0.001495 0.190555 0.699291)
     3.973041 #(0.000000 0.226214 1.565751 1.024299 0.592784 -0.015292 0.545848 -0.164098 -0.014254 1.677783 0.010954 0.201582 0.710821)
     )

;;; 14 even --------------------------------------------------------------------------------
#(14 4.6162051765776 #(0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.5770673751831 #(0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.099610 #(0.000000 -0.080758 -0.027479 0.199399 0.386347 0.449299 0.202554 1.784429 1.717900 0.329527 0.954548 -0.264053 0.856281 0.353663)
     4.099044 #(0.000000 0.064712 0.002392 1.758239 1.562496 1.488613 1.718784 0.123849 0.177636 1.552432 0.915397 0.118052 0.982785 1.477200)
     4.098933 #(0.000000 1.064573 1.002412 0.758783 0.562663 0.489006 0.720164 1.124184 1.179525 0.554249 1.917231 1.120737 -0.014393 0.478996)
     4.098145 #(0.000000 1.929164 -0.010969 0.226671 0.421687 0.490908 0.253400 1.847703 1.785923 0.405487 1.039797 -0.170604 0.960326 0.465294)
     4.097747 #(0.000000 0.927497 0.986240 1.222647 1.417439 1.485272 1.245695 0.840056 0.775783 1.393795 0.027626 0.815063 1.945062 1.449403)
     )

;;; 15 even --------------------------------------------------------------------------------
#(15 4.949674522378 #(0 1 1 1 0 0 0 0 1 0 0 0 1 0 0)
     4.8773546682689 #(0 1 1 0 0 0 1 1 0 1 0 0 0 0 0)
     4.7838921546936 #(0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.199573 #(0.000000 0.504296 0.613533 0.293607 0.288557 1.021780 0.287132 0.744077 -0.060941 1.352372 0.993154 1.256681 1.521460 0.388861 0.364865)
     4.197351 #(0.000000 0.630844 0.628794 1.068650 1.167425 0.572395 1.431155 1.077518 0.027658 0.719923 1.211198 1.055057 0.880835 0.189555 0.316525)
     4.193772 #(0.000000 1.675587 1.705815 0.187561 0.316258 1.764366 0.667280 0.345731 1.343497 0.068095 0.602689 0.479768 0.335628 1.703907 1.864339)
     4.193545 #(0.000000 1.673990 1.704095 0.184742 0.312157 1.759699 0.661838 0.338558 1.336129 0.060082 0.592895 0.470075 0.323799 1.690560 1.851587)
     4.193539 #(0.000000 1.674972 1.705674 0.187574 0.315997 1.764079 0.667192 0.344813 1.343115 0.068186 0.601740 0.479341 0.334140 1.702389 1.863580)
     )

;;; 16 even --------------------------------------------------------------------------------
#(16 5.1845584915919 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0)
     5.1708735549117 #(0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1)
     5.1363370276686 #(0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1)
     5.0737318992615 #(0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.396519 #(0.000000 1.090547 1.139126 -0.009529 0.458824 0.778347 -0.106183 1.308832 1.218737 0.200208 0.290540 0.016830 0.423513 0.112582 0.603363 0.004222)
     4.353701 #(0.000000 0.561831 0.989050 1.195832 1.557580 0.017410 0.685599 1.728228 0.371692 0.005402 0.173541 0.126093 1.783105 1.542090 0.769507 0.225043)
     4.328579 #(0.000000 -0.050344 1.847492 1.547825 1.358460 0.943178 0.995171 1.405548 1.304846 1.241639 0.001478 0.213619 1.127944 0.266623 1.638359 0.274327)
     4.326872 #(0.000000 0.955614 0.859979 0.567169 0.385493 -0.026738 0.033152 0.450270 0.355426 0.300069 1.068503 1.286708 0.206676 1.350539 0.730076 1.370356)
     4.326467 #(0.000000 0.954646 0.857741 0.564427 0.380619 -0.030405 0.027220 0.443651 0.347240 0.290827 1.057423 1.274647 0.193509 1.337335 0.715554 1.355809)
     4.326323 #(0.000000 0.953094 0.856111 0.562335 0.378555 -0.035716 0.021343 0.437774 0.341052 0.283988 1.049334 1.266917 0.184364 1.326298 0.704383 1.343207)
     )

;;; 17 even --------------------------------------------------------------------------------
#(17 5.2972948285536 #(0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1)
     5.2612584721964 #(0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 1)
     5.2483402924188 #(0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1)
     5.2332563400269 #(0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.494270 #(0.000000 1.690932 1.377703 -0.129164 -0.024726 0.145784 0.623192 0.601419 1.696617 1.062285 0.338962 0.425431 0.203410 -0.198553 0.017368 0.919786 1.663170)
     4.479510 #(0.000000 1.466836 1.017287 1.287212 1.239798 1.196077 1.475713 1.252884 0.088143 1.339107 0.374990 0.334947 -0.053319 1.236824 1.357721 0.013234 0.581999)
     4.464269 #(0.000000 1.476895 1.019325 1.288655 1.217216 1.181033 1.470508 1.274331 0.076928 1.335513 0.388067 0.349071 -0.061964 1.248056 1.367096 0.016797 0.585932)
     4.464096 #(0.000000 1.478399 1.021179 1.293532 1.222041 1.188322 1.479616 1.284032 0.091138 1.349289 0.401522 0.364537 -0.044880 1.268488 1.386805 0.039323 0.607489)
     )

;;; 18 even --------------------------------------------------------------------------------
#(18 5.4135673169319 #(0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0)
     5.3738845938103 #(0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1)
     5.3310880661011 #(0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.589734 #(0.000000 0.128904 0.791112 1.176829 1.319456 -0.047760 0.250141 1.390995 0.366355 1.103698 0.393661 -0.024093 1.112970 0.986605 0.815414 0.987317 0.858855 0.551348)
     4.580164 #(0.000000 0.088065 1.683756 0.348660 0.864971 1.361146 1.224199 0.124257 0.574705 0.001082 1.664767 0.723022 1.280851 0.880081 1.007566 1.375306 1.095774 0.962641)
     4.570825 #(0.000000 1.014207 0.576401 1.182722 1.623809 0.037366 -0.106276 0.719945 1.088940 0.493703 0.074031 1.074477 1.595481 1.109120 1.197779 1.498819 1.161324 0.997523)
     )

;;; 19 even --------------------------------------------------------------------------------
#(19 5.4721938266519 #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0)
     5.4619059562683 #(0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.760423 #(0.000000 0.078500 -0.009665 0.445299 0.326637 1.124753 0.889843 1.345388 1.144621 0.990641 0.735224 1.219841 0.734403 1.676249 0.197585 1.008479 1.250738 0.438525 0.297651)
     4.747536 #(0.000000 1.217706 0.673412 0.449616 1.339090 1.249452 0.119748 -0.159813 -0.067080 0.446567 1.155275 1.187059 0.684859 0.863274 0.563311 1.197365 0.360905 0.957607 0.891096)
     4.743668 #(0.000000 1.219811 0.663388 0.442999 1.326759 1.245187 0.104481 -0.172642 -0.076545 0.433008 1.136268 1.162596 0.675108 0.838538 0.550324 1.176777 0.324581 0.937881 0.863149)
     4.743457 #(0.000000 1.217893 0.656820 0.434930 1.318439 1.234525 0.095173 -0.185206 -0.086731 0.407144 1.121209 1.131725 0.654678 0.822361 0.535204 1.154897 0.288114 0.908839 0.830917)
     )

;;; 20 even --------------------------------------------------------------------------------
#(20 5.670516977407 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0)
     5.5380347270104 #(0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0)
     5.5266017913818 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.841326 #(0.000000 0.883035 0.097875 0.018453 1.302230 0.272330 1.409446 1.703194 0.582507 1.044653 0.993417 1.668381 0.672273 0.285918 0.289609 0.363572 1.035594 0.801569 0.774777 0.509188)
     )

;;; 21 even --------------------------------------------------------------------------------
#(21 5.7292241651627 #(0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0)
     5.6852540969849 #(0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1)
     5.6849967470046 #(0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.921985 #(0.000000 -0.018937 1.375553 1.496177 -0.139325 1.937047 0.317759 0.213913 0.072638 0.935832 1.306093 0.124717 0.468826 1.814956 1.578619 1.412244 0.051100 1.297844 0.783258 1.334465 0.605216)
     )

;;; 22 even --------------------------------------------------------------------------------
#(22 5.9318449080552 #(0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1)
     5.9259635937391 #(0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0)
     5.8572781078687 #(0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.057619 #(0.000000 -1.549052 1.840561 0.899352 0.955243 0.675735 1.388002 0.130931 1.230411 1.016199 1.248642 1.548860 -1.869404 1.414806 -0.062473 -0.077279 1.209336 1.129629 0.911002 1.328778 1.284364 0.506500)
     )

;;; 23 even --------------------------------------------------------------------------------
#(23 5.9574251174927 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
     5.9548940658569 #(0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1)
     5.9208135892745 #(0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.150197 #(0.000000 0.491565 0.619397 0.387291 -0.214520 1.136551 0.632100 0.890158 1.398097 0.878024 0.675567 0.944519 0.610269 -0.181328 0.353190 1.383289 1.649469 0.413950 0.150962 0.559863 0.266346 1.101816 1.465450)
     )

;;; 24 even --------------------------------------------------------------------------------
#(24 6.119236946106 #(0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 0)
     6.0757751464844 #(0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1)
     6.0318420391191 #(0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1)
     6.0318420391191 #(0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.255682 #(0.000000 0.045474 0.639735 -0.206951 0.266882 1.229094 0.912231 0.212812 1.489192 1.359872 0.864819 0.404719 0.603383 0.597438 0.068739 1.051236 1.659277 1.626118 0.036193 0.246242 1.406697 0.040503 -0.053562 0.164493)
     )

;;; 25 even --------------------------------------------------------------------------------
#(25 6.2507610321045 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     6.2422542572021 #(0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1)
     6.152729668872 #(0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0)
     6.1513186981755 #(0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.405563 #(0.000000 0.044827 1.794775 1.405349 1.248426 0.256712 0.428860 -0.020263 0.210400 1.157456 1.741591 0.245940 1.005440 0.948100 0.615139 0.227320 0.746752 0.771990 0.270736 1.529920 0.384512 1.822551 0.327748 0.151266 0.690608)
     )

;;; 26 even --------------------------------------------------------------------------------
#(26 6.3358421325684 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0)
     6.3140621185303 #(0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1)
     6.2921685546228 #(0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1)
     6.2921685546205 #(0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.454886 #(0.000000 0.050016 0.205870 1.808742 0.405651 -0.024060 0.116196 0.407889 0.823937 0.626331 0.635265 0.067838 0.842405 0.576072 -0.127322 -0.089535 1.707122 0.545902 0.984830 1.260435 0.630088 1.784744 1.306613 1.809592 0.666905 0.989508)
     )

;;; 27 even --------------------------------------------------------------------------------
#(27 6.4054713249207 #(0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0)
     6.243681443715 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)
     6.2436904245852 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.623706 #(0.000000 -0.020576 0.519707 0.371551 0.864699 1.334512 -0.208181 1.688257 0.033386 1.773592 0.573873 1.617213 0.354916 1.095283 1.392347 1.239659 1.112991 0.853261 0.890503 0.160590 -0.311451 1.252818 1.081249 -0.272186 1.565173 0.964482 1.599914)
     )

;;; 28 even --------------------------------------------------------------------------------
#(28 6.6246975836201 #(0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1)
     6.6145820617676 #(0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0)
     6.5361909866333 #(0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.735312 #(0.000000 1.446564 1.395795 0.794943 1.296122 1.464047 1.535520 1.775478 1.012087 0.704121 0.624490 1.243648 1.360898 0.181612 0.804675 1.270828 0.567656 1.780076 -0.124407 1.351868 -0.223622 1.763371 0.154008 1.296854 0.775406 0.203491 0.802273 0.102755)
     )

;;; 29 even --------------------------------------------------------------------------------
#(29 6.7166719436646 #(0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 0 0)
     6.7148699760437 #(0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0)
     6.6767044067383 #(0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.770226 #(0.000000 1.752583 1.827320 1.103585 0.682546 0.650877 0.531929 0.078102 0.175544 1.355580 1.450164 1.046064 1.724627 1.604828 0.350175 0.848881 0.374945 1.131460 1.003712 0.972516 0.411587 0.914857 1.010043 0.192283 0.966189 0.663343 1.289531 1.532023 0.429197)
     )

;;; 30 even --------------------------------------------------------------------------------
#(30 6.8207087516785 #(0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0)
     6.8207082748413 #(0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1)
     6.799307346344 #(0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0)
     6.6998701095581 #(0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.910618 #(0.000000 0.908807 1.373286 1.277087 -0.177124 0.095893 0.332228 0.128921 0.398841 0.946104 1.403293 0.557346 0.656008 1.276507 0.062453 -0.049983 1.902438 1.755902 1.437139 1.947315 1.608205 1.117016 0.415452 1.614229 1.733504 1.087788 0.099823 0.781893 -0.003344 1.852877)
     )

;;; 31 even --------------------------------------------------------------------------------
#(31 6.9357690811157 #(0 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1)
     6.9057178497314 #(0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     6.9018726284795 #(0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0)
     6.8986349105835 #(0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.8660564422607 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     5.991553 #(0.000000 1.294060 1.380565 1.150714 1.133080 1.031322 1.467952 1.316738 1.560524 1.149380 1.426520 0.309986 0.093879 -0.092838 1.618876 0.386127 1.276099 0.768874 0.092478 1.372697 0.935849 0.029991 0.353204 1.817033 0.371684 0.700369 1.341168 1.538111 1.331703 0.301405 0.818032)
     )

;;; 32 even --------------------------------------------------------------------------------
#(32 7.1377140468569 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 0 0)
     7.0221180915833 #(0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     7.011866569519 #(0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 1 1)
     7.003 #(0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1)
     6.9974670410156 #(0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.065521 #(0.000000 0.285485 1.824991 0.361483 1.113714 0.962272 1.152452 1.837244 0.183331 1.504654 0.432023 1.106977 0.465457 1.357599 1.532977 1.672348 0.833050 1.852805 -0.259910 1.830866 0.240364 0.782902 0.068331 1.705348 0.669695 -0.000853 1.835622 1.185939 1.464578 1.660632 0.971966 1.137154)
     )

;;; 33 even --------------------------------------------------------------------------------
#(33 7.1199560165405 #(0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1)
     7.0745658874512 #(0 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0716042518616 #(0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1)
     7.0670447349548 #(0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     6.978609085083  #(0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.167745 #(0.000000 -0.096128 -0.403532 1.394302 -0.306153 0.366725 0.336897 0.377486 0.129520 0.155758 1.349437 0.237012 0.252758 0.242534 1.430701 1.663672 1.235952 1.670554 1.653037 0.461736 0.694770 0.916622 0.353714 1.885227 1.308226 0.583336 1.382051 1.789584 0.399779 0.760162 0.153822 0.882572 0.072583)
     )

;;; 34 even --------------------------------------------------------------------------------
#(34 7.3321795463562 #(0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0)
     7.3251795768738 #(0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     7.3184022903442 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0)
     7.314661026001 #(0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1)
     7.3119759559631 #(0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0)
     7.2703185081482 #(0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0)
     7.2649097442627 #(0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0)
     7.2615523338318 #(0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.227370 #(0.000000 -0.031608 0.094260 0.501322 0.851565 0.574319 0.752579 1.914315 -0.024136 0.146123 0.293598 1.382749 -0.007303 0.943173 1.233826 0.413289 0.585905 -0.053959 1.840331 0.251300 0.156183 0.682280 0.409304 -0.127609 0.821531 0.505162 1.230500 1.450862 1.154797 0.222977 1.121593 1.588896 1.074815 0.528460)
     )

;;; 35 even --------------------------------------------------------------------------------
#(35 7.3807096481323 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 0)
     7.3793916702271 #(0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0)
     7.3590030670166 #(0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0)
     7.3509883880615 #(0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0)
     7.3254580497742 #(0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 0 0)
     7.3159041404724 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.3109955787659 #(0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0)
     7.2921919822693 #(0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.367846 #(0.000000 -0.108669 1.553997 0.219946 0.239914 1.171916 0.131219 0.808334 1.471028 1.403743 0.917976 1.560929 -0.099551 1.196249 0.221190 1.203335 0.775814 0.877451 1.783091 1.125640 1.421280 0.952331 0.640445 1.820580 1.425829 -0.517287 1.350976 1.568319 1.481991 0.524429 0.575358 0.865798 -0.127600 -0.103963 0.426994)
     )

;;; 36 even --------------------------------------------------------------------------------
#(36 7.5039777755737 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.497097492218 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0)
     7.4732356071472 #(0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     7.4679698944092 #(0 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0)
     7.466917514801 #(0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0)
     7.4267778396606 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.4214091300964 #(0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0)
     7.3326554298401 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.437336 #(0.000000 0.003662 0.086859 1.388832 0.898267 1.459432 0.131070 1.657729 1.521867 1.471295 0.951271 1.325100 1.241786 1.395425 0.150709 1.064708 0.651806 1.427047 1.086410 0.098846 0.328758 1.795857 1.461283 0.857023 1.694299 1.032403 1.245628 0.175004 -0.134353 0.154319 -0.012838 0.387005 0.719800 1.603900 0.574577 0.835322)
     )

;;; 37 even --------------------------------------------------------------------------------
#(37 7.6800961494446 #(0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0)
     7.6781373023987 #(0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.6548581123352 #(0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.6323590278625 #(0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0)
     7.6028599739075 #(0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0)
     7.5926213264465 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0)
     7.5687103271484 #(0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0)
     7.4919209480286 #(0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

     6.585942 #(0.000000 0.011008 1.017324 0.696121 0.135367 0.854814 0.790621 0.128903 1.849684 0.689318 0.247068 0.205586 0.157375 1.585384 0.005616 0.200081 1.745306 -0.359483 0.556626 0.875435 0.785801 0.017784 -0.119678 0.200337 1.347510 1.017941 0.160604 0.559071 0.649488 0.969395 0.727879 1.097195 1.685669 0.610572 1.758498 0.446671 1.384812)
     )

;;; 38 even --------------------------------------------------------------------------------
#(38 7.7734541893005 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0)
     7.7677249908447 #(0 0 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0)
     7.7656890155417 #(0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)
     7.7583861351013 #(0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.735631942749 #(0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.669114112854 #(0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.542358 #(0.000000 -0.020303 1.378297 1.768113 0.243867 1.765618 1.779113 1.045484 1.285905 0.293978 0.321881 1.722391 1.560756 0.401328 0.335125 -0.059127 0.231619 0.961929 1.594001 1.401091 0.650439 0.412010 1.330120 0.099600 1.940222 0.267803 0.404762 1.515814 0.579493 0.002405 0.261785 1.800376 0.421241 1.617996 1.112239 1.305682 1.421552 1.716025)
     )

;;; 39 even --------------------------------------------------------------------------------
#(39 8.060715675354 #(0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1)
     8.0530862808228 #(0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1)
     8.0486888885498 #(0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0)
     8.0062685830938 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.689415 #(0.000000 1.090879 0.284125 0.241210 1.659863 1.656905 0.222034 1.551984 0.232558 0.327126 1.766842 0.510226 0.574252 0.683911 0.355310 1.005185 0.649101 0.443898 1.695983 0.328207 -0.210284 0.337823 -0.053929 -0.119928 0.552242 1.088498 0.035109 1.385052 0.803815 1.342122 0.005138 0.412028 0.488966 1.360603 1.310078 1.490626 1.367238 0.635929 0.517776)
     )

;;; 40 even --------------------------------------------------------------------------------
#(40 8.1045722961426 #(0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0)
     8.0884717473459 #(0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1)
     8.0304555793911 #(0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.754190 #(0.000000 0.030689 0.021651 0.135013 1.638872 1.202950 0.744852 -0.149854 0.506001 0.559979 -0.083923 -0.079271 0.148915 0.575333 1.046460 1.733620 1.932979 1.304210 -0.056648 1.483655 1.130988 0.869014 1.564354 1.665797 1.479270 0.851691 0.124355 0.568510 1.545462 0.061018 1.378168 0.738977 -0.238425 1.303931 1.521189 1.551704 0.223877 1.494780 0.103303 0.386809)
     )

;;; 41 even --------------------------------------------------------------------------------
#(41 8.3439186011904 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1)
     8.2169809341431 #(0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     6.888023 #(0.000000 0.132293 0.436495 -0.019389 0.596393 -0.300033 0.298472 -0.292644 -0.125140 1.381000 1.229842 1.013511 0.995283 0.164958 0.060220 -0.313757 -0.409293 1.322245 -0.216145 0.007023 1.718164 0.636734 0.521917 0.976140 1.418046 -0.764769 1.376202 0.287197 1.475195 1.361945 0.552126 -0.329835 1.190849 0.378384 1.221061 1.703825 0.053486 0.665254 1.564834 1.322188 0.167849)
     )

;;; 42 even --------------------------------------------------------------------------------
#(42 8.3791161021838 #(0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1)
     8.3605623245239 #(0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     6.948397 #(0.000000 -0.007339 1.287350 1.753651 -0.276891 1.209769 0.996221 0.480828 0.607235 1.419822 -0.000709 0.317258 0.225037 -1.793291 -0.086501 1.622229 1.142325 0.611823 1.710932 0.371635 0.494214 1.156812 0.719031 -0.061120 0.895633 0.558250 0.567694 0.672932 0.964437 1.131724 0.010306 1.066049 1.756944 0.686461 0.165683 0.031441 0.191341 0.815827 0.403781 1.294123 0.159190 0.487681)
     )

;;; 43 even --------------------------------------------------------------------------------
#(43 8.4720001220703 #(0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0)
     8.3471550144283 #(0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.062412 #(0.000000 0.046908 1.659577 1.618765 1.902264 1.535486 1.519626 0.139930 -0.012902 1.735111 0.123544 1.727779 0.967940 0.859038 0.315797 0.782736 0.749803 1.792431 -0.192146 1.214122 1.594925 0.300529 1.829726 1.397155 1.088683 0.460810 0.319455 0.888779 1.307574 1.599385 0.871439 1.625985 0.871091 1.802349 0.868457 0.618949 0.931384 0.967603 1.701292 0.258625 0.614612 0.031982 0.804445)
     )

;;; 44 even --------------------------------------------------------------------------------
#(44 8.6881771087646 #(0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0)
     8.4271850585938 #(0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.055563 #(0.000000 -0.024015 1.041720 1.707562 0.914041 0.669112 0.789560 1.059559 0.488432 0.357805 1.448313 0.555623 0.559130 0.048231 0.102520 0.263359 0.561881 1.755219 1.446041 0.607585 0.096985 0.549129 0.219734 0.642077 0.109144 0.624921 0.657627 1.176276 0.894190 1.899421 0.047806 1.098963 1.393880 1.434065 0.525071 1.590040 -0.110027 0.804330 0.329083 0.620757 1.471398 1.416441 -0.298035 1.020172)
     )

;;; 45 even --------------------------------------------------------------------------------
#(45 8.7060899734497 #(0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0)
     8.6457691192627 #(0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0)
     8.6353975051189 #(0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.172161 #(0.000000 0.101498 0.426622 0.244232 0.443289 -0.379389 1.941134 -0.101819 -0.134059 -0.026489 1.677318 1.774566 0.505995 0.350819 0.551918 1.094009 0.285748 -1.617536 0.539781 0.211542 1.155256 1.345841 0.803207 1.612221 1.393169 0.188531 0.473935 0.608660 0.585919 -0.043409 1.515586 0.919322 1.090840 0.246850 0.593361 1.531904 0.320109 0.049249 1.141222 0.865337 0.301002 0.987530 -0.104296 1.339941 0.196512)
     )

;;; 46 even --------------------------------------------------------------------------------
#(46 8.9638475105267 #(0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1)
     8.7939519711145 #(0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.283836 #(0.000000 -0.055294 1.032465 -0.131124 -0.261982 1.225591 0.253197 0.556799 0.758684 1.480325 -0.140977 1.184141 0.012987 1.777237 0.881307 1.883681 0.221385 0.298513 0.448373 1.172682 0.679429 1.341106 0.082236 -0.085300 0.762657 -0.028259 -0.366493 0.048043 1.038936 1.414741 0.227153 -0.059599 -0.203781 1.201131 1.632451 1.204796 1.219257 1.182306 -0.060741 1.268698 0.937497 0.490204 -0.178774 0.027075 1.489257 0.058590)
     )

;;; 47 even --------------------------------------------------------------------------------
#(47 8.8732557296753 #(0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 0 1)
     8.8477687835693 #(0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0)
     8.7835607528687 #(0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.300155 #(0.000000 -0.062087 1.442299 1.057982 1.926248 0.607546 0.093639 0.058585 0.177259 1.141590 0.824553 0.142675 1.542633 0.438343 0.942871 1.070786 0.908755 0.331664 1.825700 1.744345 0.079324 0.779871 1.377975 1.290627 0.478990 0.650707 0.040656 0.753740 1.194367 0.872339 1.816695 1.466374 1.199563 1.733606 1.529491 -0.102253 0.906285 1.309295 1.098734 1.239606 1.394675 0.876282 1.145540 -0.144929 0.593485 0.074352 0.938482)
     )

;;; 48 even --------------------------------------------------------------------------------
#(48 9.12184715271 #(0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1)
     8.9965600967407 #(0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

     7.474126 #(0.000000 0.070239 1.074215 1.157299 0.848479 0.448148 -0.110880 0.924571 0.710266 1.666944 0.400870 1.406229 0.367270 1.104874 1.804893 0.695592 1.381898 1.018859 1.130033 1.207390 1.370288 -0.147581 1.774211 0.266088 0.501427 0.569425 1.484913 0.428415 0.102395 0.025162 1.539625 1.143271 1.439041 1.212210 0.834073 0.105112 1.296692 1.351195 1.645674 0.836913 1.239133 1.467542 1.752822 0.800139 1.353522 0.848769 0.297705 1.379071)
     )

;;; 49 even --------------------------------------------------------------------------------
#(49 9.2634744644165 #(0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
     9.1650037765503 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

     7.595465 #(0.000000 0.096228 0.646975 1.135300 1.032407 1.068612 0.694071 1.559702 1.241199 0.633754 1.823358 1.544526 0.043334 0.212821 1.418008 0.385473 0.114976 1.352558 1.573053 0.802379 0.455562 0.930772 -0.250760 1.748793 0.472363 0.477583 0.785309 -0.169564 1.197253 -0.047526 0.415040 1.391034 0.587182 0.903292 1.083562 1.248043 0.910107 0.958295 0.364336 -0.018809 0.788873 1.142100 1.114430 0.785847 1.052977 0.538413 0.677669 1.683487 0.311019)
     )

;;; 50 even --------------------------------------------------------------------------------
#(50 9.348 #(0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0) ; symmetric??
     9.1582123370176 #(0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

     7.634853 #(0.000000 -0.073262 1.329547 1.689497 -0.208512 0.904302 0.763147 0.564642 1.561297 0.220177 0.280134 1.597267 1.118962 0.656777 1.363397 -0.134281 -0.040349 0.297958 1.028754 1.174847 0.826158 0.430282 0.961670 1.378999 0.789896 0.520972 1.244819 1.529392 -0.576885 1.370111 0.512465 0.192224 0.964053 0.103716 0.415540 0.400648 1.557858 1.732143 1.180765 1.808436 1.698289 0.964760 1.904617 0.970531 -0.126069 1.110386 -0.514837 -0.268389 1.511968 -0.004316)
     )

;;; 51 even --------------------------------------------------------------------------------
#(51 9.5728101730347 #(0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0)
     9.3615226745605 #(0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

     7.664780 #(0.000000 -0.067000 1.655981 0.778706 1.201327 -0.045250 1.620269 0.299073 1.488064 1.082398 1.037600 0.820490 1.261726 -0.314397 0.779061 0.619479 1.621815 -0.279094 -0.308080 0.868922 1.117436 1.327898 0.801019 0.828416 0.425529 0.627035 0.776674 0.863586 0.342066 1.077403 1.501263 1.074929 -0.102954 0.351087 1.325633 -0.204553 1.486163 1.236719 0.323743 1.438906 0.832747 -0.230409 1.486983 1.328479 1.417319 0.080973 0.543762 0.175302 0.129537 0.877631 1.441092)
     )

;;; 52 even --------------------------------------------------------------------------------
#(52 9.5426025390625 #(0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 0)
     9.449512348335 #(0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     7.797983 #(0.000000 0.070404 1.261786 1.210563 1.679359 0.171002 0.804989 -0.033485 0.633023 0.479897 1.626645 1.596007 0.242502 0.485924 1.589149 0.714386 1.309396 0.769689 1.211524 0.777335 0.674827 0.594253 0.459214 1.729032 1.635423 1.785277 1.821459 -0.077887 0.704853 1.810083 -0.065143 -0.148023 0.458972 1.660063 1.598958 1.703207 0.229702 0.202583 1.259806 0.933220 0.214647 1.332946 -0.212512 1.800366 0.949400 0.045705 0.396820 0.036913 -0.077546 0.815455 1.112791 0.383570)
     )

;;; 53 even --------------------------------------------------------------------------------
#(53 9.7638588738802 #(0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1)
     9.627 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0)
     9.6159172058105 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     7.771777 #(0.000000 -0.026049 0.587358 1.414415 1.483194 0.175630 1.360700 0.606540 0.512714 -0.003597 0.376960 1.827098 0.546287 1.429511 1.305449 1.318984 1.065274 0.983520 1.612074 0.537735 0.176790 0.429459 1.170452 -0.124553 0.240679 0.472898 1.212387 1.797443 1.089671 1.791136 -0.007627 0.152277 1.089270 0.577584 1.158156 0.164865 -0.168031 1.213897 0.861813 0.882597 0.751163 0.754511 1.165451 1.319831 1.122555 1.302093 0.492178 1.404274 0.734020 0.511984 1.416158 1.174316 0.681259)
     )

;;; 54 even --------------------------------------------------------------------------------
#(54 9.7764141549279 #(0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1)
     9.748743057251 #(0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0)
     9.5190944671631 #(0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     7.854095 #(0.000000 0.062488 0.633437 0.842494 1.608684 1.150014 1.709447 0.507907 -0.043400 0.310180 0.314489 0.986855 1.351202 1.064597 1.712618 1.603616 0.131731 0.925223 -0.380693 0.855290 1.637618 0.812568 1.014166 0.863245 0.326993 0.192017 0.895991 1.735139 0.874569 -0.001502 0.106127 0.213661 1.657346 0.274265 1.906934 1.436908 1.086335 0.701403 0.410548 1.401909 1.873393 0.558789 1.402185 1.776574 1.632491 1.672455 -0.088196 1.646633 0.861507 0.136745 1.829002 0.307423 0.084108 1.710760)
     )

;;; 55 even --------------------------------------------------------------------------------
#(55 10.131931993478 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)
     9.9292899584938 #(0 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1)
     9.7848987579346 #(0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1)
     9.6719217300415 #(0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

     8.027801 #(0.000000 -0.024474 1.644265 -0.127850 1.570132 0.257970 1.163570 0.037724 0.298926 0.668611 0.112675 1.905921 0.088548 0.179737 0.750563 0.237572 0.547896 1.726504 0.049179 0.327310 0.577243 1.415480 0.050631 -0.132918 0.127324 1.035054 -0.050556 1.676172 1.243177 0.574148 1.377222 1.223731 0.601159 1.577134 0.689684 0.512080 0.379205 0.133490 -0.161660 1.161464 -0.066621 0.271571 0.673863 0.916929 0.414661 1.159439 1.469539 1.059693 0.142718 -0.027001 0.203378 1.456640 0.780355 0.054107 0.477761)
     )

;;; 56 even --------------------------------------------------------------------------------
#(56 10.014793395996 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1)
     9.9184818267822 #(0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     9.7564358364052 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 1)
     9.6809562784664 #(0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     8.078839 #(0.000000 -0.059023 0.947115 0.432829 1.722150 1.100576 1.096224 -0.288482 1.244367 1.048380 1.721528 0.403703 0.679103 1.523341 1.085545 1.269359 1.095520 1.628877 1.630639 -0.107879 1.597478 1.684169 0.756783 0.770702 1.191191 0.379526 0.552563 1.325850 -0.133048 1.405150 -0.252802 1.090348 1.378311 1.431590 0.655614 1.275913 0.426353 1.639745 0.450940 0.397864 0.020764 0.818810 0.631314 0.456993 -0.023946 1.736973 0.615241 0.419517 1.118907 1.795301 -0.172490 -0.191980 0.759507 1.152686 0.571402 1.572912)
     )

;;; 57 even --------------------------------------------------------------------------------
#(57 10.246812120784 #(0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0)
     10.116240908787 #(0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0)
     9.9813938140869 #(0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     9.8992366790771 #(0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

     8.134924 #(0.000000 -0.040794 1.626779 1.606785 -0.187249 1.379484 0.259703 1.080689 1.360374 0.153415 1.696285 -0.073057 0.296061 0.091976 1.551271 1.560563 0.331202 0.376831 1.177512 0.139574 -0.004686 1.203949 0.034926 1.319845 1.031696 1.750052 1.731302 0.601220 0.737009 1.163551 1.443139 1.187331 1.315629 1.757048 1.425039 0.063436 0.474886 1.585296 1.223212 0.558397 0.560456 0.740525 0.254167 0.847282 0.077493 0.730944 -0.221091 1.592708 0.493318 1.245898 -0.020556 1.638851 1.574668 1.016845 0.426086 0.775242 -1.938873)
     )

;;; 58 even --------------------------------------------------------------------------------
#(58 10.486150288901 #(0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1)
     10.185283647732 #(0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1)
     10.040289878845 #(0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1)
     9.8761510848999 #(0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.115392 #(0.000000 0.022682 0.340436 0.711409 0.909044 1.651107 0.224782 0.466192 0.106600 1.939332 1.209262 1.107872 1.064433 0.356359 0.786088 1.469822 1.231407 1.770792 0.076439 1.562167 1.753141 0.140291 0.222362 0.056340 1.451333 0.338222 0.685137 1.796877 1.226121 1.311709 1.615871 1.657844 0.990128 1.196743 1.288080 0.840181 0.528071 1.483677 0.536184 1.441779 1.532104 0.924635 1.869249 1.518192 0.405424 1.282339 0.587898 1.414708 1.372635 0.227090 1.541848 0.124505 0.619754 0.285956 1.712334 1.401633 1.454964 1.574048)
     )

;;; 59 even --------------------------------------------------------------------------------
#(59 10.306503751934 #(0 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.305177937827 #(0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.237511634827 #(0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.094394683838 #(0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.206211 #(0.000000 0.192267 1.071483 1.403715 0.670414 0.442112 0.450207 -0.029995 0.109094 1.237408 1.298749 0.264402 0.897869 1.623261 -0.079934 0.801223 1.683847 0.763348 1.630046 1.279260 1.010926 1.289692 0.623010 1.166319 0.630846 0.083111 0.823670 1.210967 -0.060606 0.202273 0.185140 0.442140 -0.095346 1.817017 1.117998 1.280565 -0.271247 1.870631 0.179143 0.082588 0.033619 0.254701 0.382262 0.161124 1.007050 0.336938 0.088495 1.498420 0.845058 1.424037 0.793161 -0.102471 1.898478 0.871802 0.289689 1.499674 1.604902 1.612992 0.303790)
     )

;;; 60 even --------------------------------------------------------------------------------
#(60 10.491376876831 #(0 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     10.333255371943 #(0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.322204 #(0.000000 0.015783 0.100597 0.396118 1.343582 1.502599 0.249341 0.971362 0.737130 1.560772 0.263689 1.239822 -0.429148 -0.121752 1.529765 0.191904 1.270541 0.100979 0.618053 0.287175 0.310753 0.121755 0.646005 0.952035 1.140590 0.456121 0.631616 0.921737 0.397838 1.354393 1.176485 0.515773 0.170935 0.662300 1.320281 0.506584 1.564968 0.875496 0.530902 0.783473 0.470802 -1.818435 1.656522 0.207883 0.414360 0.204568 1.748953 1.237007 1.335573 0.084493 1.468792 1.666177 0.266453 0.650277 0.639484 0.431640 1.172232 1.862712 1.376133 0.482405)
     )

;;; 61 even --------------------------------------------------------------------------------
#(61 10.587104797363 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0)
     10.557340621948 #(0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1)
     10.209 #(0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0)
     10.120587847566 #(0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     8.415213 #(0.000000 1.245932 -0.253239 -0.271386 1.589942 1.141036 0.170645 -0.079368 1.658372 1.140170 0.617025 0.347674 0.190050 1.529293 1.017482 1.671639 0.187702 0.775354 1.394335 0.301338 0.467293 0.341240 0.777985 1.811123 0.036364 1.179405 0.043509 0.779357 0.489329 0.769484 0.221945 1.822977 1.398619 1.323036 0.156021 -0.237874 0.343858 0.185169 0.540461 1.265478 1.467896 0.162381 -0.082405 0.941903 0.163321 1.470964 1.390079 0.311191 0.911575 0.333589 0.660449 0.437136 1.195923 0.340704 1.575216 1.853150 0.154636 1.674626 1.628835 1.928363 -0.215038)
     )

;;; 62 even --------------------------------------------------------------------------------
#(62 10.800075218392 #(0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0)
     10.501984943687 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1)
     10.318392753601 #(0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     8.407998 #(0.000000 0.861874 -0.066891 0.499950 0.135321 0.180224 0.415059 -0.084100 -0.007749 1.436175 1.531277 1.072485 1.091997 -0.429789 0.414802 1.691963 1.542302 0.815975 0.057559 1.201254 0.325151 0.845449 0.758012 1.051880 0.064865 0.907753 0.988999 -0.425007 1.230885 1.426824 0.608893 1.309141 0.637279 1.801004 1.880703 0.681693 1.140617 0.664375 -0.007843 0.059210 1.187174 1.362185 0.709681 0.706658 1.184175 0.368744 0.517829 0.598407 0.810780 1.213931 1.439849 1.484969 0.297782 -0.395490 0.659726 0.802835 1.062434 1.544659 0.956778 0.737228 -0.015066 1.758424)
     )

;;; 63 even --------------------------------------------------------------------------------
#(63 10.855396270752 #(0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1)
     10.68339442069 #(0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.562 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.45694065094 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     8.423739 #(0.000000 0.009618 0.821970 1.791486 0.181797 1.698882 1.457656 1.781295 1.048149 0.064354 0.657063 -0.016828 1.426542 1.490520 0.019540 1.749210 0.167274 0.935034 0.018191 0.949896 1.164924 0.695576 0.666858 0.087167 1.619921 0.168429 1.102017 0.391291 0.229536 0.703529 0.621279 0.344319 1.518995 1.513271 1.627483 0.238304 1.445712 1.071970 0.772616 1.186586 1.488906 -0.089969 0.947360 1.288821 1.143896 0.328817 1.580654 1.515556 1.753428 1.826180 0.654622 1.606246 1.482414 0.742232 0.684914 0.938228 1.078022 0.077160 1.128623 0.769036 0.655262 1.252793 1.466376)
     )

;;; 64 even --------------------------------------------------------------------------------
#(64 10.952004432678 #(0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1)
     10.532917976379 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1)
     10.487 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.512385 #(0.000000 -0.110754 0.249857 0.149417 0.514398 1.677895 0.265155 -0.315774 1.498146 0.140554 0.185175 1.528237 0.120203 1.686389 0.953932 -0.023542 0.164300 1.227136 0.962589 1.524469 1.273301 0.226619 1.800745 0.924233 0.998297 1.132444 0.900003 1.312417 1.257517 0.315344 0.960224 0.129824 1.838324 1.343294 1.405498 -0.196246 1.345767 1.528828 1.104987 1.366045 0.333076 0.799427 1.820589 1.483543 0.157721 1.493460 0.235478 0.802019 0.519507 0.100765 1.525078 1.282116 0.912484 0.125048 1.025027 1.368245 -0.190011 -0.110966 -0.167948 0.996236 1.719904 0.183516 0.510990 0.490578)
     )

;;; 65 even --------------------------------------------------------------------------------
#(65 10.903659606228 #(0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 0)
     10.842938423157 #(0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0)
     10.593795776367 #(0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

     8.702716 #(0.000000 0.117080 0.011416 0.102686 1.912150 0.408085 1.672737 1.382888 0.369471 0.422894 0.989944 1.334010 -0.214858 1.393017 1.288844 0.192225 -0.135463 1.531641 1.190385 1.911553 0.855456 0.652011 1.750970 0.510261 0.660137 1.259786 1.450943 -1.901739 1.631989 0.753984 0.887196 1.447708 0.197024 -0.123329 1.646917 1.787174 1.472699 1.282563 1.105394 0.207247 -1.856279 -0.024936 1.016992 0.387197 0.259948 0.772727 1.405798 0.677367 1.546352 1.766692 0.522382 1.125909 0.680152 1.150493 0.925336 1.219331 1.301709 0.936123 0.039071 0.904568 0.170972 0.968118 1.807701 0.891473 0.987033)
     )

;;; 66 even --------------------------------------------------------------------------------
#(66 10.77367179842 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

     8.799366 #(0.000000 -0.014395 -0.211419 1.169286 1.337584 1.506185 1.885597 1.598243 -0.258294 1.183748 1.754926 1.247969 1.532529 0.548658 1.027952 1.486636 1.400997 1.702806 0.283297 0.531743 1.870180 0.304413 1.155394 0.925034 1.186396 1.647498 1.057593 1.590457 0.176134 0.865548 0.473047 1.271810 0.220521 1.752634 0.517779 1.111649 0.302139 0.434945 1.226109 1.540830 0.442567 -0.053090 0.264778 0.081318 1.267112 1.770573 0.232639 0.658189 0.311954 1.097741 0.114330 1.352209 1.086998 1.442904 1.153963 1.033661 1.052229 0.785886 0.006427 -0.179805 1.223672 0.824798 -0.068289 1.357482 0.407712 0.096444)
     )

;;; 67 even --------------------------------------------------------------------------------
#(67 11.373999595642 #(0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1)
     11.240343093872 #(0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0)
     10.668939590454 #(0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

     8.900865 #(0.000000 0.013520 1.052927 1.823408 0.520963 1.569942 1.622335 1.717466 0.889859 0.635582 -0.055597 0.661018 0.857104 0.747596 1.116247 0.126117 0.264825 1.201059 0.188028 1.877809 0.231913 1.037663 1.444490 -0.297934 0.617038 -0.022105 1.301833 1.513297 1.118480 0.187504 0.428846 -0.033530 1.367576 0.975758 1.013408 0.794089 0.849644 1.471742 0.137752 0.288046 1.275412 0.182181 1.131211 1.698753 1.596832 0.029525 0.376990 0.855858 0.252218 0.917587 0.546123 1.569105 0.632633 0.579073 1.874750 0.925390 0.254379 0.514536 0.129395 0.504989 0.636243 -0.021431 -0.251461 0.751273 0.436408 0.588782 0.768257)
     )

;;; 68 even --------------------------------------------------------------------------------
#(68 11.328473091125 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0)
     10.834321813096 #(0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

     8.830913 #(0.000000 -0.195741 0.814556 1.574715 1.058068 -0.122200 1.093176 1.661655 1.070617 0.138374 1.651974 0.182696 -0.114189 1.737530 1.008840 0.767690 0.508635 1.229239 1.018532 1.220418 1.378920 0.923197 1.919983 1.878202 1.614142 -0.270961 1.606286 0.758035 1.402325 1.321860 0.095462 0.483770 -0.182348 -0.077084 -0.005097 0.021607 1.207216 0.311537 -0.192827 1.457155 -0.022797 0.958642 1.405791 1.467403 1.750973 0.492817 1.003776 0.932069 1.080105 0.125078 1.397937 0.568047 0.372812 0.576210 0.914655 1.433276 0.633011 1.955009 0.063724 0.945156 1.650961 0.473195 1.018826 1.396975 0.974124 0.707776 0.047460 1.848086)
     )

;;; 69 even --------------------------------------------------------------------------------
#(69 11.439030647278 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0)
     11.237507249543 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0)
     11.164121627808 #(0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     8.891900 #(0.000000 0.005609 0.087587 1.749639 1.177079 0.851680 0.848837 0.731028 0.637767 0.229953 0.067095 0.298553 -0.054234 1.667999 0.930281 0.956046 1.079010 0.798720 1.105774 1.348553 0.975960 0.841437 1.676434 0.045696 1.900490 1.580728 0.094402 0.045764 -0.095327 0.413246 0.544137 1.556707 -0.102247 1.608415 1.568692 -0.070556 0.124372 1.734151 1.037133 1.493529 1.520747 0.194132 1.274168 0.555778 0.272089 1.640634 1.082579 0.663352 1.473530 0.207430 1.321075 0.518456 1.595552 1.296048 0.251646 0.508365 1.271389 -0.004296 1.306239 0.034587 0.994731 -0.015770 0.691523 1.578394 -0.113685 0.596997 0.605342 1.004492 1.725714)
     )

;;; 70 even --------------------------------------------------------------------------------
#(70 11.561226844788 #(0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1)
     11.405939102173 #(0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 1)
     11.188811302185 #(0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

     9.018823 #(0.000000 0.140100 0.594527 0.193069 -0.168745 0.540299 1.658119 0.692453 0.111106 1.457206 0.842144 -0.394198 1.335381 0.680547 0.489106 1.193464 0.446143 0.314535 0.896891 0.518881 -0.050734 1.134745 1.692400 0.273108 0.353573 0.860514 0.125709 1.623924 0.398841 1.127815 1.422098 1.543326 1.003468 0.364110 0.589416 0.554608 -0.036181 1.893333 0.992116 0.131528 0.688376 1.334538 0.940389 1.783025 0.057921 0.323495 0.581967 0.212136 0.405333 1.366711 0.029008 -0.445976 1.946024 0.512000 -0.049373 1.507141 1.499934 0.646244 0.517802 1.795664 0.442901 1.279172 0.544461 0.935178 0.893033 1.143045 1.091362 1.336832 1.330046 1.201120)
     )

;;; 71 even --------------------------------------------------------------------------------
#(71 11.438183906719 #(0 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.28450554254 #(0 1 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.146488189697 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

     9.121079 #(0.000000 0.078146 0.607281 1.271351 0.515875 1.074657 1.096988 0.905074 1.136121 1.415174 1.985618 0.784368 1.741697 0.454592 0.954639 1.170815 1.300755 0.971365 1.832570 1.201285 -0.078685 0.351860 1.356203 1.773177 0.746339 0.225615 0.285446 0.647013 0.126824 0.211654 0.231869 0.306759 1.476386 0.222164 1.607048 0.386544 1.547949 1.054532 -0.090596 1.676343 1.751201 1.406626 0.045753 0.520438 0.698536 0.572431 -0.006817 0.221727 0.186138 0.227178 1.303579 1.047172 -0.098778 -0.230484 0.438528 1.403489 0.511949 0.499438 1.785408 1.388136 0.566800 0.128862 1.590149 -0.036110 -0.176285 1.014885 1.051411 0.650355 0.369359 0.125520 1.209203)
     )

;;; 72 even --------------------------------------------------------------------------------
#(72 11.543568607158 #(0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0)
     11.492732978803 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1)
     11.323646371629 #(0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     9.004400 #(0.000000 -0.129584 0.250722 -0.147550 1.246185 0.220593 0.102589 0.997455 1.285112 0.196648 1.574127 0.408631 1.035849 -0.197936 0.595316 0.630945 1.002992 1.217798 0.876817 0.891239 0.587468 0.842059 0.473048 0.527018 1.077624 0.563204 1.205130 1.180505 1.033410 1.270530 0.673582 -0.430408 0.487293 0.774809 0.430195 0.088052 1.685491 -0.146077 0.751073 1.097678 -0.157691 1.173388 0.116259 0.699259 0.530693 1.674845 1.316337 0.705323 0.048799 0.739767 1.080603 1.526331 1.861543 -0.167173 1.580738 -0.036539 0.369362 1.076921 0.938615 0.519710 0.366981 1.538123 0.342319 0.867893 1.015636 0.849212 0.370268 1.602398 0.202911 1.454649 0.582227 0.235769)
     )

;;; 73 even --------------------------------------------------------------------------------
#(73 11.708482477396 #(0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.567651928526 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.416394233704 #(0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

     9.173211 #(0.000000 0.026931 1.901549 0.868511 0.647540 0.077472 1.155920 -0.019917 0.517365 0.616412 1.388394 1.521405 1.173142 1.149732 0.333154 0.392798 1.620884 0.186114 0.977691 0.373139 1.548567 1.129525 1.464743 -0.104222 0.005842 0.038335 0.391928 0.425433 0.819755 0.701894 0.292217 0.070286 0.577383 0.675639 0.714009 0.871963 0.472933 1.695281 1.421418 0.023555 1.158610 1.177981 0.998322 0.330393 0.619100 0.124091 0.703210 0.123850 0.616158 1.673754 -0.285766 0.254546 1.422185 1.558015 0.228600 0.264599 1.727004 1.336216 1.778170 1.199873 0.637494 1.730410 1.218642 1.737207 -0.025321 0.920527 1.364456 0.696315 1.619992 0.362395 1.172036 0.183705 -0.057535)
     )

;;; 74 even --------------------------------------------------------------------------------
#(74 11.869382858276 #(0 0 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1)
     11.749699425492 #(0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1)
     11.47264289856 #(0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

     9.267903 #(0.000000 -0.063345 -1.889659 1.813852 1.389626 0.814545 0.856529 0.721820 0.105980 1.291032 0.034820 1.150542 -0.199625 1.087165 0.903776 1.153246 1.883814 1.295673 -1.764104 0.155251 0.774279 1.814379 1.131746 -0.168875 1.918800 0.238041 1.673956 0.944610 1.095936 1.262166 1.640151 0.233596 0.033554 1.855080 1.672721 0.231034 0.483362 1.723262 1.286771 0.788859 0.865067 1.321961 -0.164392 0.363777 -0.019006 1.830205 0.017647 0.118844 1.541930 0.198999 1.642222 1.943941 1.776533 0.438871 1.343760 1.606356 0.398663 1.227234 0.929960 0.666799 1.569692 1.114569 0.691848 0.653316 1.246311 1.623371 -0.353381 1.007717 0.132839 1.125167 1.670943 0.222458 1.291101 0.573515)
     )

;;; 75 even --------------------------------------------------------------------------------
#(75 12.015588177241 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1)
     11.787453747993 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1)
     11.599789619446 #(0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1)
     11.479255355845 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     9.221262 #(0.000000 0.085310 1.363467 0.177935 1.633734 1.010267 0.073480 1.094419 0.754314 0.141480 0.840213 0.080469 0.755348 1.735854 0.012281 1.279064 0.142632 1.016730 1.483377 0.042178 0.531843 1.485182 0.064705 -0.031285 1.192319 1.198950 -0.183826 0.922535 0.855495 0.104223 1.560153 0.494815 -0.611634 1.766462 1.656204 -0.040687 -0.011161 1.318226 -0.124427 1.445070 0.197683 0.029322 1.681516 1.556816 1.182411 0.923080 1.218502 1.571140 -0.485027 0.228759 1.000954 1.228682 0.723477 -0.001381 0.005096 0.223274 0.622246 0.014663 0.003370 1.251942 0.962389 0.692357 0.931822 -0.201767 0.436886 0.014560 0.745095 0.368142 0.804882 1.305211 1.114881 -0.150527 -0.350656 1.448480 1.333461)
     )

;;; 76 even --------------------------------------------------------------------------------
#(76 11.890932162956 #(0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1)
     11.477294510597 #(0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

     9.424939 #(0.000000 0.058466 1.762657 1.382636 1.265809 0.330048 0.946917 1.058030 0.131606 0.057002 1.429276 1.131359 1.278867 1.681954 0.275686 0.393542 1.700457 1.580523 0.802089 1.923727 1.221651 1.267072 1.303955 1.411406 1.026291 1.387253 1.389502 0.845801 0.736252 0.371062 1.015442 1.252356 0.435672 0.148763 1.186169 1.473114 0.407573 0.820583 1.782478 0.649469 0.421514 0.507963 1.033127 1.246876 0.538180 1.079864 0.379286 1.205754 1.539936 1.420149 1.571561 1.527809 0.000439 1.247645 0.048679 1.216264 0.623373 -0.109453 1.429926 0.005087 1.531652 0.664011 0.549888 0.621067 1.369868 1.679537 0.042582 -0.138794 0.164668 1.717959 0.842106 1.317281 0.193568 0.930393 0.613731 1.636582)
     )

;;; 77 even --------------------------------------------------------------------------------
#(77 11.909692733602 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1)
     11.875939332637 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1)
     11.594018936157 #(0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

     9.392714 #(0.000000 0.124090 -0.149279 -0.112974 1.480426 1.458126 0.462673 0.761047 1.304505 0.620292 1.413841 0.994489 -0.056349 1.211469 1.697598 0.166483 0.331827 1.444533 0.800948 1.154368 0.978443 1.500071 0.470880 1.456848 1.863739 1.289327 0.700409 0.544251 1.120888 0.644330 1.327320 -0.113584 0.793754 1.386736 0.171155 0.902904 0.807927 0.847089 0.158689 0.071052 0.584112 0.989583 0.054490 0.728159 0.173649 0.810865 0.731884 1.234644 1.918527 0.318330 0.031742 1.751128 1.009568 0.228041 1.828998 0.117775 1.898217 1.113355 0.771593 0.863730 0.835593 1.032231 0.869137 0.327747 0.793530 1.077017 0.538557 1.206493 1.166692 1.816891 1.736739 0.804369 0.575346 1.426081 1.845408 1.360017 1.006197)
     )

;;; 78 even --------------------------------------------------------------------------------
#(78 11.940728787203 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     9.350215 #(0.000000 1.406014 1.136271 0.627748 0.129558 0.271741 0.003626 1.739436 1.296042 1.387540 0.096579 1.822272 0.846050 1.039368 1.481252 0.895833 0.826019 0.840770 0.430659 0.718741 1.652426 0.733196 0.670625 1.833755 0.965666 1.267942 1.851534 1.170087 1.403059 0.720722 1.055697 1.444328 1.322020 1.350596 0.414838 0.929643 1.496792 0.894908 0.004237 1.201066 1.802474 0.448098 1.139997 0.075691 1.121063 0.477457 1.722933 0.403110 0.668388 0.045861 1.846300 0.961184 0.765234 1.815305 0.327684 0.120655 1.324253 1.238351 1.405422 -0.005822 1.465722 1.535894 1.050642 0.249749 1.956000 0.420863 0.290249 0.855379 1.032136 0.874983 1.340023 0.850930 1.473229 1.079667 -0.020851 0.624995 0.620989 1.381542)
     )

;;; 79 even --------------------------------------------------------------------------------
#(79 12.421415328979 #(0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)
     11.878196632448 #(0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

     9.565924 #(0.000000 -0.008404 1.024338 1.373210 -0.128242 0.214464 1.844298 0.283377 1.806927 1.382800 -0.171799 1.567287 1.720368 1.198830 0.970077 0.304294 1.060068 0.965717 1.649781 0.318302 0.564616 0.891309 1.381706 0.747341 1.379030 0.650849 0.552201 1.548313 0.427412 1.151168 1.576420 0.877135 1.765270 1.550391 1.195420 1.122665 0.694124 1.139878 1.707438 0.926934 0.284761 1.086790 1.273129 1.911240 0.644198 0.680196 1.173864 1.928022 1.294756 1.370867 0.552611 0.700967 1.495710 1.093832 1.438110 0.728873 0.030902 0.513512 -0.097703 1.967594 1.605323 1.709944 1.268485 0.249601 -0.041915 -0.139350 0.293585 0.305424 1.004525 0.929552 0.864261 1.389366 1.414586 0.299937 -0.199042 1.665274 1.914892 1.565020 0.790227)
     )

;;; 80 even --------------------------------------------------------------------------------
#(80 12.739060401917 #(0 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0)
     12.228775030303 #(0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0)
     12.095606803894 #(0 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0)
     11.989325523376 #(0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

     9.585355 #(0.000000 -0.039146 1.216169 1.225365 1.242533 0.818969 0.655292 1.434718 1.825294 0.130365 0.732123 0.083564 -0.059370 0.114759 0.972611 0.734896 1.804356 0.300148 -0.033557 1.070717 0.858001 0.391759 0.076209 0.834812 0.440125 0.971715 0.084740 1.110756 0.695731 -0.024363 0.373284 0.155801 0.457440 0.650163 0.689883 0.616476 1.259421 0.961835 0.347576 1.689242 1.430389 1.505142 -0.051868 1.544675 0.698547 -0.005959 1.648048 1.945381 1.352187 1.279772 0.341034 1.498563 0.550061 0.646332 1.181791 1.523968 1.148035 -0.004915 0.440435 1.030887 0.880410 0.775578 1.057170 0.071435 0.159064 1.514715 1.504461 1.567920 0.970909 1.642713 0.548673 1.183900 0.135892 1.599137 0.248413 0.887335 1.861195 0.609355 1.379313 1.460968)
     )

;;; 81 even --------------------------------------------------------------------------------
#(81 12.189952580352 #(0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1)
     12.039585160315 #(0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)
     11.979215621948 #(0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

     9.559248 #(0.000000 0.470823 1.698146 0.269751 0.606272 1.524948 0.530324 1.207717 1.612669 0.188300 0.340121 0.230899 0.088588 1.188445 1.494241 1.768081 0.444724 1.629764 1.419238 1.114074 1.146556 0.597168 1.449804 1.836781 1.083278 0.719973 0.692810 1.358606 -0.032950 0.879678 0.696083 0.887892 0.122893 1.897790 0.195993 0.078636 1.606142 1.306467 1.352205 0.105586 0.837802 1.045653 0.505379 1.491771 0.549887 0.191934 1.480217 0.815164 1.903537 0.936976 0.173253 -0.072434 0.119949 0.995382 1.809811 1.170915 0.248402 0.799373 0.107546 0.134134 0.311045 0.951883 1.529567 0.900663 1.400559 1.648986 1.706161 1.787391 1.822621 1.618901 0.389677 0.192347 0.023833 1.630650 0.658697 1.726501 1.704237 0.181498 0.490783 0.139950 1.751052)
     )

;;; 82 even --------------------------------------------------------------------------------
#(82 12.307968522655 #(0 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0)
     12.071621513807 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0)
     11.74796962738 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

     9.794609 #(0.000000 0.070078 0.784535 0.907976 0.381439 0.647939 1.217841 0.676172 1.715049 1.352729 1.665146 0.479847 0.247611 1.158122 0.046094 1.296860 1.667098 1.202952 0.862459 1.147443 0.106511 1.564918 0.142303 0.009034 -0.014482 0.808020 0.810216 1.342060 1.506348 1.072066 0.088605 0.884412 1.032007 0.490543 1.586152 1.694872 0.869876 1.572286 0.636201 0.682580 1.855748 0.876525 1.840614 -0.017236 1.884937 0.914602 1.613638 0.274586 0.330458 0.823632 0.847432 -0.155007 0.480279 0.389356 -0.096258 -0.104373 0.882588 -0.324274 -0.088060 1.809393 1.424875 1.059809 0.206762 1.919525 0.401433 1.178180 0.997552 0.531801 -0.106812 0.371565 0.300714 1.008336 1.848171 1.108327 0.418584 -0.107498 -0.186018 0.076952 1.713017 0.200197 0.117397 -0.070814)
     )

;;; 83 even --------------------------------------------------------------------------------
#(83 12.587569236755 #(0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1)
     11.931811297539 #(0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

     9.777231 #(0.000000 0.124885 1.635505 0.124358 1.154428 0.605583 1.672872 0.756249 -0.047871 1.176131 0.629089 0.674863 0.342920 -0.255407 1.896608 1.082256 0.247245 1.537456 0.009195 1.671688 1.088681 0.276080 1.660689 0.321450 0.036300 0.272843 0.392800 1.120746 1.805336 0.415551 0.378838 0.797980 1.199184 1.959243 0.942143 0.073176 -0.073073 0.004083 1.443895 1.471298 0.539103 1.645421 1.550407 0.115507 0.354825 0.202532 1.160696 1.744851 0.303439 0.023724 -0.198547 1.351927 1.386242 1.607201 0.614042 1.641804 -0.098613 0.267865 1.456224 1.506240 0.835916 0.377770 0.811372 0.794532 0.316097 1.742837 0.515387 0.791039 1.465689 0.758201 0.616191 -0.029902 -1.914381 0.564361 0.307073 0.453828 1.232233 1.197586 1.052272 1.723742 1.325366 1.781089 0.235738)
     )

;;; 84 even --------------------------------------------------------------------------------
#(84 12.747644424438 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.50866273996 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.426499838032 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     9.762438 #(0.000000 0.170282 0.576303 -0.028262 0.857580 0.181501 1.167275 0.416604 1.111665 1.830794 1.714984 1.578546 1.004949 1.288581 -0.155265 1.230425 0.391598 1.776116 -0.161591 1.713755 -0.009300 1.768477 0.694671 0.955358 1.707974 0.082630 -0.144038 1.830923 0.648687 0.673119 0.900932 0.924933 0.753181 0.521052 0.553218 0.251970 0.297192 0.979614 0.081335 0.246258 1.012609 0.415006 1.585513 1.693158 0.623901 0.300362 0.076026 1.554457 1.135844 0.208029 0.730335 0.734464 1.411513 0.671231 0.323124 0.462103 1.559065 1.855419 1.139721 0.307307 1.252819 0.089907 1.772043 1.227994 -0.058027 0.062417 0.183164 0.525045 -0.003979 0.123434 1.311344 1.293550 0.827692 1.680378 1.705851 0.824636 1.429784 1.481225 0.431774 0.059063 0.183554 0.155092 0.953216 1.394917)
     )

;;; 85 even --------------------------------------------------------------------------------
#(85 12.635076593197 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1)
     12.624737923152 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1)
     12.270205061432 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     9.711278 #(0.000000 0.194605 0.491462 0.330258 0.886222 0.027890 1.545925 1.385084 0.810944 1.115692 1.799895 0.488140 0.525391 0.075197 1.724362 1.943515 1.781197 0.422406 0.176365 1.829013 0.570296 1.784049 0.347336 0.330639 1.890499 0.438632 0.259437 0.144537 0.780176 1.104317 1.977961 0.560997 0.767166 1.341637 0.252850 1.775505 1.742391 1.552872 1.473504 0.299281 0.272093 1.210075 1.003274 0.129974 1.177045 0.699003 0.199764 0.177937 1.330648 0.854701 1.512774 1.332124 0.220221 1.811124 1.934998 1.938072 1.044479 0.748919 0.644390 0.780212 1.268627 0.440152 0.665985 0.453315 1.690313 1.972614 0.503844 0.756853 0.239851 0.786126 1.470882 0.186946 1.795609 0.380133 1.568824 1.093296 1.712037 0.903804 0.045566 0.285573 1.219484 0.952633 1.198002 1.741547 0.901756)
     )

;;; 86 even --------------------------------------------------------------------------------
#(86 13.114136440046 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)
     12.791990425787 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     9.828529 #(0.000000 0.134333 0.319376 0.011950 1.489837 0.507962 1.231134 0.945776 -0.125182 -0.288344 0.644691 1.328409 1.734034 0.569909 1.355869 0.706980 1.806518 1.467772 0.379949 0.700116 0.543160 0.306698 1.045838 0.875122 1.788791 0.104731 0.633691 0.992391 -0.047887 1.723404 1.834367 1.160377 0.041042 1.524428 0.505464 0.462024 0.779406 0.619203 1.668530 1.492437 0.476377 1.090587 1.298809 1.115437 0.606659 1.230790 0.348342 0.416250 0.339139 1.714085 0.136124 0.815663 1.700915 0.897407 0.803940 0.770611 1.415783 1.317762 1.266737 0.261637 0.783369 0.663178 0.898398 0.686108 1.284668 0.793914 1.423323 1.039818 1.197534 0.333560 1.582131 1.437434 0.599474 1.067310 0.535866 1.321696 -0.196262 0.719828 0.389276 0.037787 0.269073 -0.034014 1.698850 0.559669 0.674059 0.162186)
     )

;;; 87 even --------------------------------------------------------------------------------
#(87 13.008953483644 #(0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.872 #(0 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.669403362513 #(0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1)
     12.625063286678 #(0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.895977 #(0.000000 0.413919 0.618611 0.373444 1.730954 1.369493 0.824143 0.179529 1.749663 1.584147 1.867972 1.479215 1.842781 1.578027 0.932530 0.575036 0.586230 0.697983 1.184959 1.735101 0.239111 1.534645 1.471219 0.464912 0.607921 1.325874 0.496152 0.035088 1.508412 0.363907 1.608712 1.089878 1.638540 0.000303 0.298447 0.313660 0.190627 0.271598 0.964040 0.816907 1.586713 1.673695 0.030849 1.368887 1.828916 1.171352 1.524615 0.383607 0.912332 1.824277 0.777910 1.741261 0.536161 0.713768 0.392477 0.167302 0.493661 1.190201 1.389806 1.121677 0.552236 0.209647 0.929175 0.660566 1.798792 0.862425 1.767641 0.292066 1.886453 1.325176 1.590998 0.205295 0.147680 1.079484 1.485651 1.860913 0.209929 0.162563 0.231636 0.126583 1.641521 0.633297 -0.027822 0.359812 1.833523 0.836489 1.689831)
     )

;;; 88 even --------------------------------------------------------------------------------
#(88 13.132745742798 #(0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.908752771202 #(0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.675436588537 #(0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.661032846106 #(0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.985227 #(0.000000 -0.195259 0.928053 -0.292283 0.584057 -0.149967 0.591128 0.048126 0.051233 0.248069 0.311772 0.576847 1.256819 0.527030 1.119960 0.264342 0.758124 0.238658 0.643483 1.021167 1.449185 0.311990 1.449910 0.825718 0.189023 1.720698 1.301125 1.118974 0.313888 1.080049 -0.080693 -0.032715 1.113363 -0.003125 0.625187 0.819159 -0.239347 0.717022 1.191190 0.942095 1.227820 0.688837 1.844425 1.402994 0.155516 0.077664 1.279311 1.497574 1.259789 1.239143 0.491317 0.402464 0.704984 0.884044 0.450318 1.033394 1.710707 1.614840 0.007338 0.439090 -0.139656 1.951320 -0.174028 0.665816 -0.213601 1.142397 0.504238 1.417630 1.151942 0.374883 0.425585 0.856138 1.472242 0.633109 0.162544 0.811725 0.755637 0.720456 1.610670 0.130216 1.210835 0.776625 0.450880 0.273532 0.430261 0.505815 1.244479 1.585310)
     )

;;; 89 even --------------------------------------------------------------------------------
#(89 13.321250915527 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0)
     13.191189069613 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1)
     12.707793861614 #(0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1)
     12.335865540187 #(0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     10.125982 #(0.000000 -0.047754 0.911062 0.377192 1.405152 0.900905 1.692898 0.140019 0.279601 0.353264 1.319666 0.832036 1.685683 1.264629 1.495300 1.733677 1.394797 -0.027832 0.675920 0.212046 0.528573 0.273765 1.091602 0.381557 0.091066 0.479049 0.092041 0.434438 1.648188 -0.303141 1.638082 0.242163 0.248187 1.327376 0.903210 0.808594 0.669216 0.691955 1.387089 -0.010681 0.132515 0.727890 0.782250 0.083840 0.429422 1.733826 0.782731 0.588050 1.687325 0.848787 1.634783 1.184449 0.229129 0.461092 -0.165276 1.451843 -0.261586 0.212298 1.512449 1.391008 1.012684 0.980934 0.167914 1.101654 1.768264 1.849416 1.334910 1.235432 1.310415 1.418266 1.076905 0.040513 0.083987 0.990582 0.879402 -0.090717 0.777554 0.143505 0.476823 1.647364 0.497925 1.096780 1.074405 0.565138 0.657633 1.471647 1.710440 0.587946 1.328452)
     )

;;; 90 even --------------------------------------------------------------------------------
#(90 13.53812119512 #(0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1)
     13.016282120103 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0)
     12.781593429563 #(0 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0)
     12.716424196959 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

     10.260480 #(0.000000 0.008531 0.004733 1.081624 0.921636 0.328029 0.204319 0.516144 0.371838 0.992718 0.492585 0.397749 0.905860 1.108604 0.580780 1.962452 0.405499 0.332115 1.627922 0.258377 0.320653 -0.061929 -0.069513 0.211535 -0.038203 0.709537 0.914613 1.227813 0.664582 1.477280 0.509794 -0.156263 -0.112362 1.682863 1.135941 1.304855 1.187165 0.713701 0.627341 0.243146 0.712070 0.606445 1.405757 0.922327 0.585872 0.075359 0.369894 1.263608 0.655375 0.598882 1.354076 1.169248 1.109896 -0.426652 1.123662 1.197053 1.030544 0.164461 0.117728 1.615544 0.690501 -0.045818 0.923608 -0.023011 1.921148 1.637807 -0.079760 0.349130 1.267680 0.226817 0.856173 -0.228741 1.301260 0.148459 0.714391 1.272386 1.780295 -1.611198 0.400250 1.041309 0.494122 1.399812 1.302515 -0.202155 0.259699 0.723343 0.141103 1.241204 1.798921 0.767065)
     )

;;; 91 even --------------------------------------------------------------------------------
#(91 13.63089466095 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     13.263186228373 #(0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     12.853587071592 #(0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

     10.213408 #(0.000000 -0.125090 0.778629 1.009367 0.291509 0.180974 1.215873 1.133798 0.114372 1.006850 -0.028462 0.262862 1.473426 1.540164 1.355523 0.171176 1.959299 1.333069 1.567491 -0.021283 0.871141 0.535654 1.261744 -0.118915 0.484206 0.407729 1.089329 1.781574 0.389779 -0.215606 0.146260 1.555199 -0.137522 0.236744 1.332033 0.244319 0.245128 1.127797 0.191624 0.782004 0.510354 0.985271 1.097974 1.012808 0.979519 1.590424 1.029792 1.008409 0.712015 1.155501 0.270485 1.006547 0.412305 0.036328 0.694590 0.506881 0.054226 0.823355 0.855679 -0.013334 1.357880 -0.127975 0.671309 0.563207 0.790367 1.855374 1.709947 0.727143 0.579511 0.587743 1.112357 0.345269 -0.173565 1.647061 1.877927 1.546876 0.896510 -0.179105 0.651148 0.436801 0.672254 0.292270 1.565900 1.514867 1.267753 0.262818 0.254476 0.433711 0.905094 0.720800 0.529408)
     )

;;; 92 even --------------------------------------------------------------------------------
#(92 13.355320111641 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0)
     12.754180011349 #(0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

     10.418319 #(0.000000 -0.110328 0.255333 1.893615 1.564168 0.865427 1.347764 1.684212 1.175175 0.610092 0.998320 0.806865 1.761764 0.896632 1.447645 0.529947 1.122677 1.101743 0.425339 -0.123933 1.746515 1.661514 0.208612 0.400711 1.362229 0.154352 0.687066 0.577556 0.617285 1.414614 0.447013 1.513564 0.055422 1.622632 1.762060 0.069999 0.152047 1.341584 0.791170 0.454704 0.082433 0.689837 1.855744 1.655443 0.292765 1.251678 -0.027926 0.759844 -0.033087 0.884983 0.531074 1.559675 0.525151 0.874355 1.645844 0.194476 0.549744 -0.300354 1.764876 -0.223500 1.038046 1.459782 0.187202 0.043927 0.223366 0.968735 1.126463 1.358031 1.309428 0.549005 1.454965 0.848752 1.021209 0.773781 0.579298 1.217362 1.141107 1.730175 1.917798 -0.012098 1.243749 0.688167 -0.033857 1.403068 -0.046668 1.484084 1.219976 0.799072 0.089752 1.556013 1.802464 0.800164)
     )

;;; 93 even --------------------------------------------------------------------------------
#(93 13.783703804016 #(0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0)
     13.143995954461 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0)
     12.876626968384 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     10.186155 #(0.000000 -0.023119 0.067152 0.407500 -0.257222 -0.002779 0.206916 -0.157789 1.447447 1.069957 1.943401 0.866847 0.433318 0.611306 1.013198 1.010628 0.657575 0.944883 0.528054 1.686746 0.627827 0.222983 0.655819 0.664025 -0.031260 1.896381 1.662755 -0.135373 0.312594 1.826937 0.739391 0.060919 1.072991 0.674225 1.676373 0.498270 1.903192 -0.280328 0.158462 1.324727 1.362024 0.992342 0.996068 0.407597 0.848545 1.438416 0.268973 0.318002 1.163066 0.823857 0.286781 0.687547 1.048814 0.795891 1.074596 1.121189 0.927963 1.667200 1.928684 1.162628 0.925449 0.466812 0.148965 0.569930 1.134254 1.141344 -0.266620 1.469810 1.211751 0.737737 0.829732 -0.451531 0.018621 1.451153 0.285447 0.051597 0.643486 1.030300 0.120944 1.605677 0.320257 0.891431 0.009073 0.896065 1.418099 0.547504 0.051018 0.615577 -0.075718 1.705327 0.761116 1.042358 -0.023507)
     )

;;; 94 even --------------------------------------------------------------------------------
#(94 13.381710407562 #(0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0)
     12.991560374803 #(0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     10.512625 #(0.000000 0.018964 1.572502 1.655296 1.784230 -0.049971 0.507412 0.466184 -0.170612 1.789538 1.349910 0.208330 1.096105 1.689235 0.854257 0.894615 1.441221 1.712765 0.985955 1.161061 1.253907 0.443631 0.645990 0.424256 0.689661 0.173653 0.472908 1.210298 0.049248 0.175148 -0.131320 0.349306 1.889473 0.060115 1.191588 0.879969 0.448834 0.094997 1.912750 1.122514 0.548962 0.625538 0.977447 1.604754 1.797444 1.700956 1.399212 1.692860 1.290189 1.617971 -0.094160 0.803651 0.781929 1.496745 -0.045842 1.674405 -0.341256 1.508222 1.426120 0.088584 1.042432 0.397563 0.723663 0.202937 -0.187017 1.251006 1.635591 0.172087 1.491435 0.751442 -0.079511 1.563660 0.159083 0.560650 1.361161 0.593542 0.596346 1.491262 1.059681 1.637675 1.290346 0.097000 0.113329 1.103894 1.396230 1.051520 0.222991 1.673954 1.534047 0.352937 1.468794 0.753306 1.622641 0.729965)
     )

;;; 95 even --------------------------------------------------------------------------------
#(95 13.458537482645 #(0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0)
     12.939489078295 #(0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

     10.511456 #(0.000000 -0.045722 0.285958 1.111187 0.780702 -0.044261 0.859588 0.838915 -0.027125 0.951668 1.176229 0.139645 0.284393 0.643706 0.891202 -0.072013 0.231963 1.625607 0.881699 1.116015 0.448097 1.180690 0.779585 0.328750 1.105877 0.835362 0.977992 1.019893 0.271289 1.763579 -0.013720 1.261751 0.569094 1.347404 1.102083 -0.076765 1.380346 0.644770 1.513900 0.614876 0.149191 1.824815 1.268846 1.801592 0.964180 1.440974 1.201976 1.195369 0.199797 1.630691 0.997102 0.962229 1.105494 0.027083 0.070415 0.033396 0.282399 0.149425 1.634628 0.189898 1.106755 0.884689 1.104492 0.063847 1.575733 1.529645 1.814015 0.203251 1.098747 1.065468 0.921697 0.868053 0.585294 0.939158 1.366892 1.279428 0.695607 1.289181 1.299470 1.441296 0.076911 1.189305 0.849479 0.359793 0.702214 1.570940 0.265646 1.385055 0.104459 0.439033 0.609324 1.096379 0.838301 0.550490 -0.218145)
     )

;;; 96 even --------------------------------------------------------------------------------
#(96 13.465419214875 #(0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.179516746745 #(0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.077001047978 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     10.566355 #(0.000000 0.153702 1.472942 1.120012 1.160647 0.821651 0.587258 0.167937 1.237041 0.827124 -0.057223 1.536062 -0.118884 0.274562 1.893550 1.286204 1.478143 0.868564 0.058468 0.687528 1.013586 0.329615 1.906635 0.947418 0.701871 0.385093 1.808729 1.328542 0.677135 1.662741 1.726910 1.295260 1.481724 1.136467 0.546764 1.751302 0.078093 0.792005 0.823189 1.491124 1.353118 0.334517 0.446559 0.644701 0.864084 0.815324 1.379101 0.182756 0.668352 1.139161 0.088039 0.542020 -0.156458 -0.131708 1.823097 0.847242 0.071484 0.952017 -0.065685 1.613440 0.884356 1.807679 1.636664 1.838638 0.543128 1.360802 -0.051400 0.563283 1.558762 0.784395 1.080952 0.974305 0.736801 0.974386 -0.161382 1.496357 1.628419 1.347955 1.450295 -0.115816 1.158280 0.634373 1.227982 0.999131 1.675731 1.365219 1.653642 -0.118219 1.360090 -0.079777 1.183942 0.786810 1.103793 -0.124899 0.090712 1.897254)
     )

;;; 97 even --------------------------------------------------------------------------------
#(97 13.449318349909 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)
     12.969611395004 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

     10.523856 #(0.000000 0.310132 1.837414 0.229067 0.156727 0.033695 1.832689 1.474269 1.451645 1.635365 0.749286 0.729961 1.767053 0.110211 -0.138873 -0.043491 -0.173185 -0.123668 0.553952 1.674454 1.441699 1.702763 1.000567 0.893068 0.590141 0.012862 1.698308 -0.416760 0.702152 0.722691 1.041081 0.391493 0.508118 -0.015214 0.953052 1.797598 1.211572 1.494506 0.519613 0.523095 -0.540550 0.600442 0.783764 1.820888 1.549437 0.221552 1.062240 0.781192 1.078083 -0.188196 1.735533 1.537623 0.692415 1.344426 -0.443780 1.398600 -0.399427 1.015216 1.909871 1.632689 0.162424 0.570878 1.040380 0.225828 0.216002 0.730370 1.787655 0.769850 1.115483 -0.214735 1.104294 0.018110 1.590460 1.288072 0.899166 1.912777 1.339375 1.123936 1.238579 0.918997 -0.182785 0.023108 0.888520 0.592887 1.611692 1.355676 0.337698 1.404106 -0.029694 -0.267518 0.243964 0.187288 0.895828 -0.064675 0.921080 1.156611 1.623092)
     )

;;; 98 even --------------------------------------------------------------------------------
#(98 13.942760654268 #(0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1)
     13.490633234777 #(0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1)
     13.468658765207 #(0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

     10.556695 #(0.000000 0.313701 0.188877 1.835342 1.263310 0.865552 1.095569 1.595581 1.156859 1.480524 1.946966 1.869240 1.400477 1.230714 0.903303 0.553394 0.279264 0.898077 1.282796 1.483784 1.951351 0.559393 1.354982 0.530333 1.260689 0.944841 0.412936 1.295360 1.600858 0.084481 1.783121 0.141936 1.745220 1.237545 0.660466 0.907066 0.273312 1.202194 0.707537 0.777610 1.334926 1.147670 0.289773 0.877201 0.508459 0.798923 0.640115 1.915015 0.361805 0.656254 1.887666 1.630128 1.058612 1.837971 1.731519 1.446680 0.476683 0.108769 -0.045086 1.641247 1.511418 0.130154 0.341548 0.251774 1.917949 0.787643 0.751264 1.384819 0.277478 0.461491 1.362291 1.724811 0.294706 1.058612 0.534436 1.189555 0.138667 1.122503 0.657579 0.772646 0.441989 0.482064 1.257051 0.219109 1.427208 0.336583 1.895375 0.571899 0.470485 0.939053 1.323479 0.917884 0.071084 1.027772 0.797255 0.388073 1.214921 0.118364)
     )

;;; 99 even --------------------------------------------------------------------------------
#(99 14.049349722487 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.942 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.341398779709 #(0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

     10.431646 #(0.000000 0.712626 1.280622 0.927914 0.134401 1.557090 0.117397 1.599339 0.492335 0.900536 0.192494 1.933455 1.385730 0.734570 0.986506 1.561643 1.511796 1.637570 0.383135 0.075813 0.540085 1.371029 0.484785 1.006528 1.151293 1.973027 0.610135 0.187717 1.291526 0.846895 0.073478 0.991946 0.162545 1.930318 1.073213 1.297219 1.795085 0.743156 1.868126 0.001223 0.349274 1.408134 0.962302 0.007963 0.633723 1.377865 1.109961 1.629463 0.476572 0.825028 1.404324 1.579633 0.789657 0.218962 0.390171 1.592294 0.360579 0.569380 0.576632 1.380182 0.889776 1.826504 0.051762 1.721803 0.270943 1.359491 1.295938 0.621549 0.011756 0.403752 1.517491 1.690115 1.416933 0.835985 1.164116 0.776207 0.842565 1.007295 0.525006 0.446413 0.141635 0.622198 0.817299 1.146512 1.215448 0.934836 1.081989 1.030911 1.230731 1.092156 1.434121 0.539787 0.953714 1.254034 0.477191 0.159449 1.646301 0.621600 0.431289)
     )

;;; 100 even --------------------------------------------------------------------------------
#(100 14.500160217285 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1)
      13.694382146343 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
      13.512077331543 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      10.544772 #(0.000000 -0.060358 0.574158 1.210837 -0.004935 1.776505 0.242124 1.084979 1.485454 1.623332 1.105320 0.677061 0.651941 -0.224857 0.244964 0.728613 1.742448 -0.484462 -0.157843 1.671144 1.723798 0.940284 0.087869 0.301632 1.751064 0.491683 1.518041 -0.081269 1.581763 1.504322 0.959001 1.280330 1.567237 1.245778 0.536515 1.265941 0.750382 0.672059 0.433543 1.229853 0.126333 0.179107 -0.175215 0.708966 0.475211 1.625847 -0.185400 1.720518 1.840254 0.328114 0.428991 0.109352 1.503925 0.898712 1.121214 0.007881 0.080780 0.079837 1.813161 0.092610 -0.025619 0.113843 0.299390 1.183180 1.006098 0.292277 1.534813 0.104861 0.142247 0.778799 -0.344094 0.702559 0.513447 1.740749 0.475148 1.303870 0.936428 1.010437 1.723699 0.781553 1.095424 1.795880 -0.450622 1.487526 1.217548 0.508867 0.228848 1.498505 1.774615 0.240936 1.838526 0.875648 1.810170 1.116568 0.540401 1.544998 0.741127 1.252612 1.721487 1.366278)
      )

;;; 101 even --------------------------------------------------------------------------------
#(101 14.704120635986 #(0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
      14.20509180893 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)
      13.916260357992 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

      10.913005 #(0.000000 -0.059113 1.982341 1.194467 1.857065 1.333202 1.114363 0.317069 1.348122 0.028107 1.318562 0.060991 0.299603 1.573758 -0.295364 0.999912 0.298059 1.720976 0.574391 0.684312 0.681820 0.629333 0.902646 1.392027 -0.161935 1.338650 -0.012969 1.825815 0.149318 0.516873 -0.229155 1.632110 1.421396 1.641525 1.026994 -0.065209 1.449969 0.753289 1.019630 0.470875 1.287767 1.308835 0.636469 1.524949 1.798123 -0.018595 1.846871 0.077084 0.263190 1.509491 0.030034 0.569316 1.790947 1.445805 0.069876 0.482243 0.783413 1.936534 0.186304 0.124333 1.879548 1.104879 0.580871 0.179160 1.084893 1.207615 0.589294 0.768754 -0.054338 0.021308 0.050997 1.472670 1.333181 0.051788 1.379329 0.298368 0.804882 1.700803 1.569439 0.412575 1.093175 0.730154 1.526477 0.140856 1.725325 1.421307 1.209621 0.922768 1.393012 1.594498 1.044966 0.232682 0.894902 0.882597 1.285036 1.453029 1.020092 0.005077 0.760569 0.725300 1.584861)
      )

;;; 102 even --------------------------------------------------------------------------------
#(102 14.246722674125 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1)
      13.955191612177 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1)
      13.554303556646 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

      10.893997 #(0.000000 0.054942 1.487192 0.201203 -0.050696 1.679133 1.433556 1.251070 0.220969 0.310797 0.151660 -0.248775 0.510165 1.574799 0.867668 0.807883 0.032122 1.724828 -0.016390 1.457438 -0.430282 0.736878 1.594100 0.841409 0.475218 0.288623 1.671989 0.677280 1.420903 0.606822 0.122845 1.065706 1.373891 0.539020 0.915029 0.924017 0.671829 1.579758 1.319391 -0.185607 -0.032652 0.137415 -0.006169 0.452803 -0.013524 1.445771 1.158638 1.773564 0.345252 0.435588 -0.292967 0.452757 0.524692 0.788845 1.638293 1.901316 1.275411 1.079765 0.353681 -0.379618 1.593868 1.065996 0.187190 1.144300 1.770343 0.659638 1.695917 1.095520 0.744651 -0.004356 0.734913 1.786730 1.819057 1.687863 1.479724 1.679967 1.238143 1.430475 0.536702 0.915212 1.259731 0.715836 1.153127 1.189812 0.981112 1.656320 0.952780 1.300796 1.003309 0.054575 1.416219 0.132912 0.152889 0.567298 1.153445 1.333077 1.600623 1.740584 0.547964 0.905701 1.661656 -0.072032)
      )

;;; 103 even --------------------------------------------------------------------------------
#(103 14.267168699654 #(0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      14.260 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      13.923377530893 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

      10.864125 #(0.000000 1.239599 0.637258 0.249002 1.366288 1.080915 0.468710 0.570356 0.051294 1.343431 0.249863 1.180741 0.347496 1.220468 0.312049 1.606808 0.537085 0.995551 1.083266 0.356665 0.728344 1.184276 0.956090 0.462763 0.737200 1.244829 0.573136 0.852271 1.495668 1.014089 1.154283 0.679415 0.730274 1.020803 1.758823 0.837540 0.986535 0.586178 1.757002 1.702286 0.238252 0.795993 1.381978 0.321025 -0.007683 1.059961 0.356835 0.240531 0.224924 0.096694 0.886540 0.736722 1.719440 0.356627 0.114445 0.122524 1.363343 1.537031 0.603886 1.271918 0.467327 1.380697 0.351526 1.317914 0.179400 0.514347 0.871085 1.318071 1.403452 0.969706 0.105245 1.586404 0.928256 0.766646 1.480592 0.424557 0.388402 0.794413 0.746579 1.528993 1.817285 1.956626 1.963515 0.034027 0.639334 0.328515 0.920463 1.043172 0.304864 1.630049 1.490596 1.437880 1.331672 1.314508 1.223489 0.581252 1.909288 0.378378 0.374421 1.916111 0.695044 1.940199 0.152158)
      )

;;; 104 even --------------------------------------------------------------------------------
#(104 14.290776635081 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)
      14.080453047533 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

      10.825134 #(0.000000 0.884092 0.464338 1.567061 0.113151 0.700540 1.125831 0.795296 0.549428 0.242764 1.689582 1.881856 1.259084 1.557653 0.410098 1.461507 1.950174 0.550357 0.928654 0.401312 1.640865 0.511571 0.925510 1.027080 0.623020 1.287561 0.718379 0.232049 1.753916 0.590183 1.541022 1.248543 0.572663 -0.003329 0.769272 1.213327 1.940018 0.202614 0.702159 1.192867 0.322077 0.411076 0.456261 0.275280 1.688172 0.880381 1.023148 1.317297 1.148495 1.333344 1.481152 0.366130 0.955553 -0.029017 0.579185 0.458298 0.231507 1.354632 1.547816 0.984427 0.911687 1.125467 1.049001 0.545493 1.913779 0.569583 0.836916 0.874018 0.786969 0.631403 0.885625 1.209648 0.680681 0.062379 0.530415 0.579056 0.918725 1.481051 1.349744 1.602712 1.937962 0.066294 1.799832 1.019351 0.079678 1.463637 0.221544 1.179806 0.063730 1.373013 0.460580 1.241715 0.269008 0.140572 0.259502 0.262047 1.699396 1.372146 0.348726 0.107157 0.007414 0.962481 0.843976 1.654016)
      )

;;; 105 even --------------------------------------------------------------------------------
#(105 14.699862480164 #(0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0)
      14.062 #(0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)
      14.023490699521 #(0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

      10.975496 #(0.000000 -0.171158 1.410251 1.676254 0.966094 1.518572 1.024130 0.229076 1.336007 1.568224 0.706832 1.342728 -0.147033 0.915375 1.217310 0.940983 0.063243 0.858112 0.442716 0.217694 0.960162 1.588339 0.616003 1.691788 0.792222 0.289016 0.389329 1.732911 -0.110699 0.807579 0.415174 0.578225 0.060008 1.754389 0.302558 0.795169 0.348353 -0.190063 1.678712 1.525630 0.494208 1.156006 1.829104 0.782872 -0.019963 -0.210744 0.704974 0.055328 0.433023 1.441243 -0.004631 1.627203 0.696712 0.604513 0.979185 0.267783 0.404147 0.544882 1.509758 1.545378 1.547015 0.043042 0.917173 0.351333 1.958397 0.443237 0.020210 1.803869 1.273626 0.074265 0.209036 0.236865 1.378020 1.274052 0.755093 1.136980 1.404752 0.905607 1.004021 1.565998 1.737592 0.392117 0.352321 1.211764 0.077292 0.264817 1.433093 1.872108 -0.449138 0.353731 1.562714 1.598825 -0.216312 -0.163910 -0.000957 0.085006 0.623936 0.728230 0.848940 0.017005 1.401887 0.334340 0.287025 1.265837 0.525782)
      )

;;; 106 even --------------------------------------------------------------------------------
#(106 14.783208847046 #(0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.160224278203 #(0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.077123010357 #(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

      10.948035 #(0.000000 -0.016631 0.600650 0.229212 1.217565 1.397128 -0.368119 0.364258 0.663508 0.332595 0.949076 -0.173944 -0.034512 1.262606 1.752743 1.065509 1.460221 -0.017458 0.934898 -0.015219 1.909485 1.532916 0.838007 0.364605 1.462756 0.139362 -0.183807 0.169448 0.482236 1.127966 1.153821 1.022696 1.290926 0.959492 1.858732 1.285799 1.501342 0.394349 1.486222 1.903237 1.357864 -0.010890 1.395068 1.354174 1.038544 0.563609 0.476646 1.096516 0.519932 0.693916 1.537921 0.532942 1.315922 1.214180 0.234365 0.271257 0.522460 0.732525 0.926442 0.738580 -0.106035 1.484543 1.339338 0.337838 0.273716 1.796494 1.687072 1.887181 1.569063 0.257303 0.221784 1.300942 1.586004 1.267348 0.845830 1.117108 0.214245 -0.137989 0.184199 0.147785 0.814298 0.010586 0.597939 0.467566 0.017801 1.668835 0.369174 0.290830 0.425842 -0.220521 0.718986 0.258299 1.141118 0.994582 -0.024829 0.737672 0.690161 1.005911 0.031563 0.640552 0.021751 1.693072 0.327644 0.720447 1.769859 1.318012)
      )

;;; 107 even --------------------------------------------------------------------------------
#(107 14.355038210217 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 1)
      13.979104817741 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      11.117917 #(0.000000 -0.097053 0.072370 0.191338 1.474106 1.078004 0.836504 0.069454 0.637422 0.783070 1.014772 1.402925 1.010763 1.340900 0.045822 0.166386 -0.347503 1.275410 0.829099 0.497147 -0.037201 0.217515 0.631743 1.550170 1.836784 0.795332 0.224521 0.459047 0.208632 1.416874 1.186684 0.054590 0.373944 1.282841 0.010458 1.040366 0.524038 0.073075 0.859338 -0.160299 -0.098939 1.344453 0.698564 1.590316 0.831922 1.325489 0.026098 1.117408 0.320184 1.563069 0.266395 1.383520 0.832761 0.768807 0.720084 0.570839 0.637314 1.078616 1.684528 0.605963 1.307847 0.397957 0.954726 1.218884 1.562142 1.228771 0.159716 1.416484 0.954903 0.100999 0.606274 0.038901 1.814364 0.018868 -0.349060 0.326117 0.194373 -0.353986 1.300034 -0.136775 0.005426 1.740874 1.368934 0.871064 1.233009 0.878290 -0.248942 -0.012436 -0.123107 0.178386 0.506247 1.831986 0.228827 1.029849 0.634263 1.417932 1.812721 0.355106 0.462394 1.444855 -0.217541 0.216675 1.552464 1.575227 1.333861 -0.182908 1.265811)
      )

;;; 108 even --------------------------------------------------------------------------------
#(108 14.418597227362 #(0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0)
      14.367991447449 #(0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1)
      14.247987286758 #(0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1)
      14.201394892821 #(0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      11.208795 #(0.000000 0.064890 1.283780 0.574942 1.761806 1.822500 0.467920 0.057882 0.598712 1.582011 0.697284 0.590215 0.038105 0.394020 1.321320 1.380519 0.610969 1.152275 0.092957 0.283421 1.074652 -0.134313 1.700209 1.074319 0.299835 0.016436 1.631220 1.384040 1.854057 0.575527 0.162440 0.441510 1.892684 1.616958 0.190231 1.376424 1.122892 0.103040 1.107395 0.206226 0.996567 1.464827 0.355420 -0.080633 0.299293 1.501150 1.592683 1.881031 0.320956 0.132254 0.976788 0.641689 1.114133 1.350406 1.764871 1.195727 0.591927 0.935100 1.276684 0.984096 1.349216 0.171937 1.175737 1.465998 0.184300 1.879748 1.324816 1.532411 1.304428 1.551489 1.300616 0.525450 1.360035 1.146121 1.367228 0.559171 1.464097 0.178646 -0.085171 0.753158 0.453270 0.050101 1.876765 0.199986 1.161353 0.826862 0.550568 0.002280 1.429426 1.876988 -0.012102 1.877641 1.436738 1.609632 0.235222 0.586355 0.984658 -0.331091 1.734954 1.420296 1.579884 1.507524 0.625955 0.023455 1.136287 0.423071 0.825282 1.711062)
      )

;;; 109 even --------------------------------------------------------------------------------
#(109 14.988188773557 #(0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0)
      14.476561866583 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

      11.222036 #(0.000000 0.001652 1.352502 0.493065 1.788067 1.215156 0.988314 1.426196 1.698716 0.487996 1.580559 1.039023 0.184621 0.410872 0.024217 0.439874 0.122392 0.616991 0.750708 0.890136 -0.254248 1.335580 1.627660 0.655371 0.062212 0.679836 0.926251 -0.135329 -0.137121 0.704514 0.286251 0.795871 1.267156 0.952655 1.067998 1.406967 1.071350 1.783670 -0.100753 0.499535 0.684705 0.765895 1.696133 0.459413 0.900664 1.751840 0.908180 1.782561 0.100485 0.752613 -0.065813 0.420098 0.334088 1.502920 1.013084 0.229949 1.716642 0.077782 1.687776 0.991980 1.290815 1.021644 0.460810 0.758193 1.161113 1.124505 0.990013 0.213256 0.649231 0.291999 1.033608 0.051628 1.701991 1.434994 0.005215 0.038839 0.669691 1.292204 0.339327 -0.166667 0.462586 0.944313 0.859584 0.245687 0.547588 1.238257 1.487549 0.523690 1.412546 1.678659 0.998013 0.262540 1.703635 1.743303 1.482407 1.250991 -0.229330 1.472678 -0.341620 1.118339 0.360827 0.704053 -0.144013 1.821184 1.459715 1.498234 1.034488 1.350365 0.841569)
      )

;;; 110 even --------------------------------------------------------------------------------
#(110 14.433 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.401108392424 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.141825477743 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      11.349002 #(0.000000 0.018984 0.373111 0.406423 0.177191 1.052803 0.059877 1.252232 -0.067711 -0.066727 1.676071 1.259017 0.049396 1.472467 1.693228 1.840261 1.785618 -0.184840 0.993470 0.266432 0.149006 1.166003 1.237863 1.372260 1.204229 -0.286288 1.760439 1.534523 0.454220 1.026055 1.039660 1.381189 1.134372 1.744681 -0.109291 1.814532 1.295415 0.703915 0.301849 0.341080 1.721536 -0.237918 1.194811 0.388848 1.295347 1.608775 1.547912 1.571364 0.963538 0.093901 1.072371 0.456487 1.125363 0.218236 1.369138 1.043123 0.908893 0.499171 1.249948 1.845701 -0.032790 0.092340 1.729827 1.451462 0.177069 0.309055 0.823668 1.610778 0.223336 1.972784 0.966755 1.055050 0.442821 0.780476 0.812601 0.084890 1.763677 -0.157168 0.326540 0.804925 1.222470 0.747457 0.494863 0.626615 0.719127 0.619244 0.857950 -0.169497 1.740328 0.326614 1.086402 1.201988 1.844176 1.120282 0.922327 1.435049 0.679770 1.233170 0.062289 0.489718 1.351568 0.096562 1.227322 0.403981 0.053237 1.588580 0.742178 -0.121874 0.280119 1.381029)
      )

;;; 111 even --------------------------------------------------------------------------------
#(111 14.983455708572 #(0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.470418444168 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.043108609984 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

      11.450459 #(0.000000 0.059581 1.344066 -0.131536 0.729597 -0.005346 0.196885 1.377015 1.525696 0.668560 1.433518 0.243916 1.669100 -0.052986 1.555195 0.240184 0.799233 1.236153 0.885350 1.310850 0.045026 0.809037 0.983589 0.858482 0.539809 0.393910 0.998124 1.007659 1.243854 0.938110 1.055754 0.115615 0.626592 0.852933 0.325487 1.788994 0.069680 0.994171 0.474979 1.000676 0.020805 1.942044 0.196110 1.228030 0.358301 0.439538 1.296804 1.574526 0.780889 1.651546 0.173075 0.607120 0.783547 0.153723 0.065682 0.482397 1.031941 1.446912 1.755450 0.990729 1.155862 0.702558 1.298064 1.186681 0.929207 1.074021 0.734549 1.749429 1.454964 0.256364 0.397564 1.754756 -0.137031 1.961722 1.148758 1.288879 0.559273 0.984062 0.235270 1.289360 0.982455 1.503223 1.224650 1.367409 0.004928 0.193502 1.820503 0.657122 1.290432 0.807128 -0.184932 1.217397 0.051473 1.830054 0.424295 -0.272877 1.569981 -0.058797 -0.027968 1.272936 0.547114 0.732868 0.463593 1.373109 0.331726 1.745538 1.149578 0.806663 1.829553 1.367010 0.502833)
      )

;;; 112 even --------------------------------------------------------------------------------
#(112 14.939 #(0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0)
      14.53456401825 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

      11.314435 #(0.000000 0.057121 1.424415 0.822362 -0.221842 1.874881 0.133450 1.740759 1.552228 0.287524 1.667947 -0.236388 1.315384 0.167194 1.257784 1.295473 -0.000133 1.233503 0.483386 0.461042 0.117344 0.365942 0.614125 1.103163 1.388214 0.025561 0.057731 0.993699 0.057152 0.792757 1.256498 -0.276462 0.893093 1.571782 0.836124 1.447680 1.376643 1.309239 1.022132 0.550310 1.183579 -0.235645 0.475806 0.958260 1.282279 1.429647 1.338344 0.048664 0.488235 -0.160930 1.186519 1.090250 1.313954 1.372112 1.018895 0.128676 0.535046 1.710818 -0.163187 1.612911 1.123855 1.429323 0.701967 0.954554 0.935842 0.782061 0.241939 1.336725 0.949948 1.013344 1.435963 1.498066 -0.131480 0.722682 0.868595 1.590781 0.782808 1.951598 0.100039 -0.192944 0.383220 0.005627 0.099669 0.574208 0.147706 0.331114 1.546993 1.026506 0.846574 1.510640 1.854501 1.815689 1.177591 1.594487 0.636800 0.433344 1.692827 0.343470 1.604283 1.594350 0.887024 0.273325 1.290550 -0.414147 1.418083 0.594219 0.331737 1.346249 0.191105 0.217056 0.697288 0.162811)
      )

;;; 113 even --------------------------------------------------------------------------------
#(113 15.33184168793 #(0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.840950350147 #(0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.699631659332 #(0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      11.304804 #(0.000000 -0.087843 -0.170363 1.480836 1.020986 0.524265 1.122461 0.779356 0.854869 1.142447 0.283570 -0.218218 0.857520 0.339768 1.392251 1.171738 0.753663 1.238929 1.015059 0.417092 -0.064921 1.509125 0.348129 0.614591 0.582485 0.917781 0.680475 1.449515 0.322261 0.345489 0.645235 1.845940 1.792222 0.760265 0.277853 0.300302 0.266469 0.775805 0.237854 1.661001 1.457899 1.497575 0.010324 0.583280 1.575648 1.647169 -0.015704 0.392172 0.398061 0.417415 0.314885 0.836250 0.050598 0.061879 -0.179245 0.510861 0.717315 1.569741 -0.074995 0.668474 0.843800 0.777031 -0.216477 0.375659 0.761257 0.823559 0.689254 0.693777 0.369569 0.079551 1.642946 1.383541 1.267684 0.097686 1.838431 0.445129 1.199955 -0.245773 0.215582 1.245250 -0.014694 0.584055 1.188553 0.432132 1.375040 1.219883 1.560311 1.045218 0.515045 0.523345 0.023724 1.291570 0.169781 0.901397 1.797229 1.142730 0.230516 0.392411 1.061971 0.493510 0.718963 1.793892 0.465569 -0.134769 0.879759 1.492720 1.359571 1.264200 1.406177 1.335554 0.095212 1.318466 0.450909)
      )

;;; 114 even --------------------------------------------------------------------------------
#(114 14.84645338611 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.794 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.492 #(0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

      11.451858 #(0.000000 0.964251 0.805180 0.031766 -0.004162 1.241336 0.994150 0.493658 1.760236 1.146253 0.429085 0.392216 1.194663 1.059942 0.513900 1.191308 0.342650 0.732043 1.061166 0.930124 1.129182 0.870651 1.881952 1.592443 0.596357 0.931139 1.227645 1.456280 0.305624 0.817919 0.397504 0.970828 1.288249 1.558177 1.315055 0.325629 0.394380 1.358142 0.355117 1.374071 1.568512 0.563816 1.857089 0.002773 0.272548 1.545829 1.224763 1.175918 0.045986 0.033959 1.142741 1.871591 -0.017874 0.655012 1.017391 0.136517 1.730007 0.861502 1.812032 0.527039 0.408080 1.642118 1.724989 1.793254 1.573300 1.308631 1.799271 1.502980 0.243819 1.208341 0.979484 1.730835 0.837025 1.640461 0.889297 0.705373 0.992068 0.842662 1.271672 1.390933 0.632106 1.843376 1.841199 1.476112 1.765304 1.737441 0.642691 1.171489 1.387039 1.924720 0.375515 0.114302 -0.003454 1.555531 0.298527 0.916154 0.375235 1.262505 1.669455 1.472822 1.411629 1.054016 1.891962 0.528938 1.087319 0.187666 0.659920 0.219871 1.423075 1.291468 1.149468 1.534935 0.839104 1.167210)
      )

;;; 115 even --------------------------------------------------------------------------------
#(115 14.597 #(0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)
      14.568 #(0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

      11.459688 #(0.000000 0.139616 0.803243 0.774559 0.923192 0.820149 0.270482 1.621179 0.924129 1.637243 1.149757 -0.673501 0.187571 -0.001400 1.058784 -0.262457 0.271676 1.635057 1.770116 1.659544 -0.544966 0.221715 0.966091 0.619588 0.386808 0.482765 1.354372 0.451809 0.976198 1.426602 0.928924 0.509656 0.847765 0.273170 1.634575 0.028905 0.065672 0.109198 0.256478 -0.160278 1.666463 0.916248 -0.133403 1.171788 1.291817 1.563756 1.606883 0.930657 -0.101925 1.639639 1.228155 1.670861 0.781254 1.218940 0.714424 0.388503 1.168232 1.654488 1.016430 0.215203 1.903769 1.658310 1.542232 0.799490 0.821427 1.029156 1.117972 0.511869 1.066306 1.193945 0.163949 0.872298 0.775998 -0.113806 0.341070 0.921430 1.399713 1.339675 1.108566 0.453421 1.317011 1.006948 1.146592 0.164226 0.600168 0.907912 -0.465537 1.374176 1.009356 1.890729 -0.342185 1.801853 0.944128 -0.195036 1.615797 1.483236 0.784233 0.487629 0.909825 1.543373 -0.213767 1.577235 0.151908 1.143620 0.570684 -0.028028 1.093239 -0.086970 1.338010 0.000857 0.339404 0.887443 0.314112 1.090399 -0.247601)
      )

;;; 116 even --------------------------------------------------------------------------------
#(116 15.190026349904 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)
      15.016979484255 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

      11.604524 #(0.000000 -0.066052 0.197513 0.278970 0.963431 -0.227460 1.533913 0.282303 0.385518 1.463419 1.649597 0.485716 -0.261088 1.107200 1.084855 0.143130 0.677008 0.430743 1.000125 -0.131480 1.147395 0.114614 0.916894 0.529401 1.186716 1.349897 1.144728 0.017523 1.690619 -0.128099 0.790518 1.365703 0.782224 0.142154 0.629090 1.425358 0.048062 0.225381 0.551690 0.792839 -0.032716 0.333975 1.000507 1.697982 1.524879 1.219570 1.387164 1.306671 1.579827 0.684628 1.571255 0.190859 1.566362 1.384615 0.608537 1.430591 0.250490 0.722825 0.452884 0.302924 1.082672 1.713545 0.312562 -0.053662 0.174633 0.247034 1.061735 1.400411 0.800019 0.091094 0.081767 0.105049 1.714699 0.031067 1.384442 0.718944 0.521947 0.862958 1.075884 -0.253794 1.083344 0.861981 0.892509 1.560230 0.939639 0.302147 1.759751 0.583949 0.282243 1.128593 0.116411 1.448233 1.311442 0.433544 1.086262 0.791436 0.018192 0.633147 0.827423 0.084706 0.417410 0.098471 0.276659 0.176785 0.739657 0.649957 0.303070 0.901727 1.085322 0.538842 0.552917 -0.105445 1.647072 0.568705 0.274733 0.298709)
      )

;;; 117 even --------------------------------------------------------------------------------
#(117 15.56056534994 #(0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0)
      15.070538411179 #(0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)
      14.875072951405 #(0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

      11.595737 #(0.000000 0.010503 0.926544 0.024010 1.305173 0.487248 1.632206 1.541413 0.878544 -0.027338 0.904714 1.017810 0.001193 1.478693 1.231452 0.515599 1.271662 0.092509 0.589923 1.381737 1.811454 1.820716 0.982771 1.909786 1.088920 0.215883 0.407714 0.855513 0.446667 0.333424 1.194783 1.128706 1.690977 0.329225 0.209856 0.813920 0.278081 0.057765 1.198931 -0.398463 0.920532 0.378749 1.177456 0.857096 0.153767 1.200223 -0.354445 1.377734 1.462289 1.632308 0.100003 1.605538 0.044992 1.184720 1.289667 1.385764 1.241891 -0.128708 1.750604 1.491583 0.630152 0.912556 0.070873 1.379040 1.667138 1.551947 0.129399 1.218376 1.059797 1.579854 0.238838 1.505493 0.708097 0.737601 0.906714 1.085487 -0.140483 1.276328 1.106070 0.198203 1.590018 1.818817 1.359245 0.519017 0.943291 1.703657 1.577270 1.018879 0.460881 0.941236 0.522843 0.338239 0.001585 -0.090785 0.322489 1.228735 1.275364 1.579130 0.506222 1.161633 -0.015332 1.500860 1.339490 -0.088398 1.438595 -0.538467 -0.213403 0.082084 0.987602 0.863105 0.552655 0.328881 0.504971 0.643724 0.840119 -0.052627 0.269658)
      )

;;; 118 even --------------------------------------------------------------------------------
#(118 15.425480892646 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1)
      14.841081077183 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1)
      14.774983755641 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

      11.627254 #(0.000000 0.246281 0.090665 0.113970 0.738643 1.427007 1.311775 1.220207 1.943899 0.678310 1.657078 1.247129 0.998701 0.133435 1.803295 0.730001 1.787074 0.473230 1.535915 1.879724 0.792699 0.039705 1.509578 0.046410 0.717759 0.945723 0.323416 1.317371 1.123010 1.230367 0.078331 0.506913 1.337609 1.077776 0.717335 1.670489 1.733622 0.924231 1.540961 1.683987 1.538926 1.904563 0.190618 0.433466 0.438559 0.815043 1.382921 0.958419 0.241136 0.111878 0.093554 0.066498 0.204154 0.836130 1.692253 0.684624 0.771154 0.915953 0.452807 0.415386 -0.040173 1.137162 1.636250 0.208878 1.467062 0.858293 0.178908 1.779257 0.976422 0.825311 0.975817 0.991512 1.515860 0.541027 1.595442 1.123225 1.281990 1.266418 1.546512 0.201762 1.367865 1.005159 0.580457 1.339747 0.860655 0.475044 0.607357 1.192044 0.919191 0.574125 0.839846 0.755667 1.493052 1.965224 0.198434 1.026651 0.373417 1.706851 -0.063460 1.187127 0.759999 1.632985 0.496544 0.000412 1.252352 0.538533 1.113996 1.345762 0.813605 1.087684 0.861950 0.393901 0.359266 0.203344 1.452336 0.195047 1.467526 0.438117)
      )

;;; 119 even --------------------------------------------------------------------------------
#(119 15.519069915733 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
      14.971 #(0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

      11.659484 #(0.000000 0.526185 0.743767 1.450967 0.233767 0.797154 1.911582 1.495994 1.751585 0.996945 0.489835 0.548529 -0.032389 1.393426 1.369534 0.784532 0.937715 1.122117 1.839906 1.362633 1.722814 -0.026811 1.547429 0.592061 0.791627 0.609724 0.917461 1.238574 1.555683 1.429090 0.962799 1.716480 0.436305 1.696991 1.752956 0.303313 1.180740 1.880713 1.861642 0.471008 0.461609 0.516108 0.934313 1.735405 0.056323 0.183206 1.473798 1.270020 1.449324 0.621325 0.009409 1.891980 1.872797 0.395024 0.861835 1.691290 0.778023 0.449075 0.845767 0.471701 0.112007 0.231861 0.372971 1.371750 1.479913 1.257612 1.352760 1.617074 1.030869 1.025539 0.960066 1.487727 1.799117 1.673732 0.924768 1.663658 1.753219 1.513730 1.084174 1.780916 1.287687 0.545167 1.117297 0.472692 0.800351 1.524056 1.056018 0.348352 0.834752 0.941088 1.910096 1.425317 0.739197 1.648865 0.602577 0.581934 1.648437 1.016365 1.331696 0.039237 1.492091 1.259538 0.631206 1.656367 1.386666 0.768584 0.652196 -0.042787 1.314887 1.916561 0.803339 1.723695 0.310372 0.376986 1.566264 0.807756 1.655909 1.006276 1.735929)
      )

;;; 120 even --------------------------------------------------------------------------------
#(120 15.824793168635 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.350 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.153992567168 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

      11.758263 #(0.000000 1.173763 0.978708 0.254226 1.898355 0.226234 0.659204 0.443159 0.500553 1.379403 1.130640 1.625499 0.395035 1.856019 1.729331 1.045022 0.942888 1.826603 0.937392 0.404347 1.356248 1.930392 0.761014 1.710259 1.884475 0.456478 -0.042150 1.807863 1.400154 1.098681 1.909052 1.774090 0.937588 0.292861 0.101412 0.629338 1.874695 1.793106 0.130418 0.555749 0.078467 0.206491 1.344719 0.355189 1.658580 1.837396 1.474323 0.210482 1.908539 -0.009035 0.179754 0.525920 0.377757 0.924535 0.127046 0.491666 0.213300 0.974113 1.076900 0.116775 0.472586 1.711915 1.609019 1.569406 0.189387 1.797854 0.838290 1.394206 0.911134 0.567985 0.468003 1.317848 1.753839 0.265784 1.716787 0.952564 1.395961 1.506013 1.792116 0.918374 0.409188 0.729485 0.113867 1.689011 1.469932 0.093628 1.366534 0.839130 0.247104 0.623447 0.003308 0.896702 1.086102 1.251593 0.522148 1.250161 0.708107 0.793246 1.624905 0.977061 0.667512 1.560114 0.444676 0.640373 1.702103 0.136553 1.940225 0.531302 1.893226 0.110346 1.690456 0.668546 1.252961 -0.027756 0.208216 1.596483 1.778560 1.897302 0.924106 0.717145)
      )

;;; 121 even --------------------------------------------------------------------------------
#(121 15.507 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      15.168510014453 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      14.652157793709 #(0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

      11.614192 #(0.000000 0.078084 1.836283 1.627492 0.986304 0.488474 1.142758 1.912131 1.246950 0.826545 0.616881 1.885255 1.320176 1.225042 1.088670 1.487209 0.066329 1.150497 1.760558 1.917764 0.989115 1.901495 0.395142 1.687981 1.914769 0.508039 1.715446 0.111071 0.718516 0.092858 0.210124 1.551299 1.733544 0.490231 0.240583 0.314830 1.380008 0.537655 1.367966 0.013886 1.447269 1.318351 0.849061 1.651704 1.443552 0.163478 1.819589 1.505863 1.811029 1.435226 0.895885 0.238770 0.390268 0.483627 1.331819 0.257619 1.279280 0.021347 1.584861 0.326177 1.834844 1.556605 1.747276 1.562703 0.229045 1.937204 1.949687 0.669274 1.636973 1.720592 1.210468 1.253176 1.168628 0.527886 1.011259 1.941434 0.203857 0.431895 1.322635 0.799019 0.191571 1.356312 0.806072 0.442313 0.884188 0.820132 0.517030 1.657155 1.752304 1.143031 0.334786 1.265890 0.540733 0.907736 1.466781 1.141097 1.166921 1.541865 0.358757 0.303602 0.634656 0.068593 1.906936 0.561717 0.600492 1.243778 1.489970 1.755187 1.101771 1.363773 1.442641 0.152507 0.597378 0.667648 1.601562 0.921132 1.793927 0.038066 1.909543 0.617188 1.610942)
      )

;;; 122 even --------------------------------------------------------------------------------
#(122 16.162 #(0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.305 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.057187309653 #(0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      11.844342 #(0.000000 0.196920 1.489656 1.807246 1.620877 1.426914 1.746555 1.880904 1.015504 1.008968 0.172892 0.084443 1.879414 1.352228 0.385717 0.659668 1.799293 1.136441 1.263707 0.574658 0.127916 1.561786 1.467433 1.444709 1.915432 1.688575 1.573814 1.495675 0.710586 -0.029277 0.191106 0.034776 0.350485 1.578666 0.919609 1.011309 0.702487 0.460166 0.406296 0.986510 1.540896 0.249457 1.662948 0.471920 1.255225 0.013873 1.873119 0.098952 1.323110 1.283432 0.082875 0.533706 1.003721 1.708934 1.525211 1.438043 0.833017 1.622555 0.851958 0.764479 0.883583 1.063485 1.105784 0.092173 0.578064 0.774297 0.643523 0.969851 1.167856 1.436355 0.068857 0.513756 0.921206 0.811621 0.258795 1.204290 1.546528 0.725966 1.785411 1.366428 1.248721 0.366036 1.831860 1.273710 0.365638 1.629627 0.118370 1.636094 0.114510 0.475419 1.289399 0.738294 0.021660 0.775425 1.834098 1.688940 0.811350 0.131294 0.088527 0.648849 1.658982 1.085773 1.324995 1.132951 0.698319 1.328875 1.863513 0.722533 0.476173 0.441235 0.900773 1.955421 1.420841 0.965837 1.607117 1.131920 1.611379 1.694144 -0.031301 1.011423 0.514666 1.020927)
      )

;;; 123 even --------------------------------------------------------------------------------
#(123 15.443287674437 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.448 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.332496766406 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.156582832336 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

      11.823468 #(0.000000 0.096013 -0.052105 -0.016162 0.978570 1.254160 1.335461 -0.295225 0.369163 1.228142 1.666359 0.638458 1.321951 1.737766 0.306573 0.942865 1.093354 1.551506 1.534458 1.116666 1.330367 1.705465 0.959380 0.269621 1.396223 0.047854 1.313199 0.875344 0.329069 1.051893 1.592099 1.313516 0.450200 0.733580 0.441948 1.287601 0.768918 0.340406 0.332014 1.115709 0.590033 1.155695 0.515518 0.827815 1.455781 0.348884 1.104306 0.192991 1.546142 1.941800 -0.259164 0.432751 1.640440 -0.073800 0.916260 0.403986 0.714159 1.803394 1.823717 1.737460 0.855764 0.483292 -0.107711 1.192239 0.224496 0.276490 0.662189 1.034442 1.265250 1.469552 0.878861 1.318393 1.114760 1.639870 0.215518 1.057113 0.708623 0.405092 0.391860 1.367191 0.560928 0.972566 0.495112 0.284459 0.939320 1.763782 0.549638 1.334850 1.313424 1.639671 1.869619 1.507820 1.278224 1.043917 1.210329 1.219052 0.749137 -0.226431 0.386494 0.172008 0.668761 0.894683 1.619783 1.436134 1.422218 -0.255401 -0.764179 0.135224 0.177062 0.095125 1.706245 1.351937 0.538781 1.926316 0.772632 0.193763 -0.057016 1.492910 -0.433357 0.577309 -0.304846 0.993491 0.960121)
      )

;;; 124 even --------------------------------------------------------------------------------
#(124 15.877207326383 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
      15.402028019163 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)
      15.192802705519 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

      11.966653 #(0.000000 -0.045794 -0.113802 0.387766 0.794563 1.204728 -0.195246 -0.021815 1.256034 0.845474 -0.368797 1.010306 0.123811 0.300805 0.267813 1.269466 1.744957 1.211573 1.225945 1.061622 1.888310 -0.053102 0.118051 0.672436 1.059344 0.116183 0.018594 1.118849 0.919646 0.738744 -0.469943 -0.255802 -0.192714 1.621781 0.980878 1.211901 0.253321 0.556024 1.977369 -0.096703 0.573456 1.606584 1.437168 0.882530 -0.235417 1.554639 0.647223 0.788000 0.092483 -0.117754 1.028132 0.739653 1.087784 1.698128 0.049113 0.939382 0.609358 1.777290 0.164741 0.720028 0.310457 -0.027957 1.420394 1.356339 -0.091148 1.522834 0.186932 0.214782 0.438435 0.280343 -0.031417 -0.122748 0.143447 1.063331 0.232386 -0.122678 1.712188 1.248007 1.644939 1.180491 1.130390 -0.088776 1.058320 1.779666 -0.096655 1.143269 0.066197 1.380329 0.385739 0.655599 -0.119394 1.671065 0.322675 0.249148 0.487487 0.185320 0.611000 1.844082 1.246387 0.378307 0.164367 0.913828 -0.100488 0.990264 1.429078 1.368306 1.418067 0.512206 1.359386 0.793544 0.358107 0.748043 1.627362 0.749724 -0.293483 0.005016 0.715326 1.458547 1.125908 1.335656 1.258475 1.551986 -0.214781 -0.287934)
      )

;;; 125 even --------------------------------------------------------------------------------
#(125 15.874541816027 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.743360519409 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.340427254326 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

      11.902580 #(0.000000 0.173192 0.550377 0.336389 1.658108 0.022698 0.017568 1.902690 -0.017980 1.439012 0.324405 0.313956 0.578574 0.684988 1.848685 0.124963 1.458848 1.877017 0.707783 1.305737 0.892122 0.582747 1.840462 0.861700 0.761978 0.119779 1.708757 0.873152 0.335700 1.338262 1.479511 -0.025447 1.273211 1.206508 1.249260 1.258575 0.747029 1.174392 0.828130 1.088011 1.455198 0.866650 1.207571 1.129908 1.173131 1.878390 0.209602 0.199728 0.147514 1.465296 0.543797 1.932506 1.731685 1.784043 0.821033 0.144136 1.152094 1.648315 0.045331 0.503139 0.884529 -0.025636 1.520940 0.604840 0.350051 1.318103 1.515290 1.498827 1.275962 0.129302 1.923788 1.271258 1.819611 0.728727 1.923365 0.415768 0.077493 0.942803 0.238906 0.691173 1.900323 1.917388 0.288010 0.201660 1.692783 0.558503 1.390009 1.229594 1.439649 0.845896 0.065704 0.184484 1.648170 0.062842 1.243407 1.820776 1.402294 0.651240 0.520942 1.430324 1.872106 0.913448 1.442076 1.539270 0.412825 1.254711 1.848487 1.875283 1.672447 0.722551 0.492541 0.259629 1.732537 1.552683 1.521978 0.213499 1.023618 0.402097 0.828728 1.091077 1.558389 1.402303 0.064023 1.605424 1.783462)
      )

;;; 126 even --------------------------------------------------------------------------------
#(126 15.964 #(0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.680 #(0 1 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.28212621738 #(0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

      12.026426 #(0.000000 1.764582 0.801984 0.617771 0.565988 1.307109 0.707736 1.058513 0.468146 0.312083 0.843992 0.695744 1.322053 0.463944 1.828430 0.272100 1.326713 -0.131736 1.524119 1.349756 -0.008015 0.566406 1.701267 0.666200 1.416786 0.475444 1.797743 -0.001209 1.339885 1.389457 1.159986 1.299315 0.949750 0.680027 0.619729 0.152290 1.158407 1.424930 0.773391 0.168960 0.628345 0.604875 1.322877 0.211365 1.840067 1.571473 1.893022 1.596802 0.537093 1.870913 1.802282 -0.071272 1.690601 1.566471 0.895962 0.394664 0.182297 1.097885 1.329631 1.792750 0.871875 1.767236 0.128920 -0.022095 1.519838 0.505194 1.823558 1.618924 1.104226 1.401869 1.428648 1.254048 0.469629 1.856803 0.626029 1.838528 0.716332 1.801155 1.747390 1.721457 0.323578 0.531881 0.542865 1.154776 1.427208 0.535293 1.731602 0.394503 1.427305 1.716740 0.622497 0.727420 0.917832 1.264248 1.188202 1.990820 1.061381 0.931151 1.573390 1.886799 0.397620 0.180735 1.902236 0.681964 0.626700 0.695504 1.712172 1.724473 0.738233 1.041231 1.842110 0.231221 1.143366 0.179220 1.666546 0.902044 1.837572 -0.005057 0.327329 0.186153 1.811191 0.156224 0.198904 1.472345 0.634019 0.503219)
      )

;;; 127 even --------------------------------------------------------------------------------
#(127 15.859804776319 #(0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.609939955803 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.237931718393 #(0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.928233 #(0.000000 0.466644 1.711675 1.665289 1.012483 0.998409 1.587790 0.775875 1.316030 1.813102 1.197738 0.812121 1.007123 0.076062 0.929153 0.387208 1.081775 0.411496 0.909685 1.572024 1.275095 0.729603 0.307931 0.860584 0.731932 1.562556 0.412338 0.626589 0.427271 0.754901 1.242250 0.064908 1.795523 1.726161 0.045144 0.338344 0.750066 0.933030 1.125542 0.385725 0.573227 0.184155 1.146261 1.394887 0.484040 0.685435 0.943054 0.001135 0.204384 1.626424 1.224436 0.970419 1.134570 0.248625 1.901169 0.502273 0.141989 0.544635 0.641145 0.884297 0.960208 0.067095 0.292300 0.872890 0.737247 0.277911 0.257483 0.772390 1.290446 0.565855 1.209844 1.572395 0.150006 1.863310 0.556381 1.867107 1.488760 1.716936 0.603579 1.539114 1.183034 0.108999 0.766820 0.699059 1.399815 0.728656 1.459253 0.676165 0.760878 0.321462 0.634906 1.930277 0.108011 0.625580 1.530305 0.727800 1.729164 1.555162 0.718943 0.962661 1.359184 0.661587 0.665751 1.650542 1.422468 1.123318 1.654172 1.677246 1.494699 0.747580 0.581078 0.203212 1.481664 0.884820 0.080762 1.250993 0.141888 1.380880 1.560275 0.968167 1.512649 0.151311 0.089972 1.937043 0.539468 0.082272 0.107398)
      )

;;; 128 even --------------------------------------------------------------------------------
#(128 16.159544533014 #(0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0)
      15.889096531102 #(0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0)
      15.651492555885 #(0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      12.001744 #(0.000000 0.107794 1.314632 1.808368 1.095140 0.193695 1.396335 1.128690 1.646816 0.982112 1.117438 0.049487 0.094532 0.048929 0.137072 1.888155 0.651609 1.210533 0.792817 1.710993 1.341723 1.155757 1.539558 1.523157 1.035360 1.207666 1.094037 1.421939 1.203185 1.508234 0.752102 1.973699 0.431565 0.251191 1.490213 0.816858 0.485061 1.676792 0.900807 1.783510 0.534603 1.751370 0.519755 1.844354 1.562540 1.085475 1.228678 1.032184 0.743770 -0.041911 0.626960 0.378047 1.790817 0.674205 1.885576 1.219053 0.133642 0.790484 1.311492 1.509603 0.517246 0.544564 0.610822 1.856548 0.031118 0.052836 1.178365 0.211066 0.490655 0.432412 1.849713 1.586898 0.761477 1.817235 0.356132 0.461787 0.622644 0.319960 0.514636 1.677142 0.811772 1.144578 0.944641 1.034694 1.546204 0.015597 0.332613 0.430573 1.237149 1.250130 1.794010 1.976233 0.361427 1.128789 1.589254 0.313656 1.512386 1.594183 1.823839 1.686380 0.957142 0.713104 0.455096 1.677685 1.288318 0.919170 0.347526 1.576711 0.258818 0.660388 1.449711 0.350910 1.293948 1.769908 0.583656 0.657526 1.174490 0.363231 0.497538 0.040123 0.456845 0.621466 0.260742 1.194091 0.313542 0.671216 1.694556 1.345650)
      )

;;; 256 even --------------------------------------------------------------------------------
#(256 24.434719362486 #(0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

      21.147051 #(0.000000 0.013043 0.920117 0.211418 0.668306 1.385627 1.906635 0.858012 -0.025540 1.212427 1.778724 0.580100 0.439691 1.356157 -0.119063 0.434266 0.154352 0.442955 -0.005968 1.535794 1.403556 0.183703 0.719695 0.808134 0.717026 -0.004795 0.750023 0.510510 -0.111539 0.030727 1.471914 0.702448 0.847566 0.053362 -0.108798 1.030415 0.581323 1.534487 0.340353 1.468027 1.258297 0.652253 -0.177908 1.046447 0.259688 1.647334 1.350135 0.131395 0.878222 0.018247 1.361793 1.595723 -0.194803 1.278955 0.422974 0.308531 1.680151 0.819388 0.650454 1.170154 0.982131 0.916385 0.251795 0.614215 0.058138 0.237243 0.480617 0.078361 0.274005 1.104676 -0.049561 0.890974 0.285114 1.560285 -0.042858 1.287080 0.986201 0.225144 1.911656 0.412797 1.906001 1.113150 0.002975 0.378566 0.185842 0.978524 0.886147 1.174987 1.402841 1.532148 0.452840 1.653473 1.368866 1.142209 0.399142 -0.053477 1.387350 1.063119 1.101594 0.660387 0.318690 -0.075495 1.596588 1.423152 0.699488 1.066220 0.932593 0.726316 0.721243 0.616117 1.231920 1.204386 0.280095 0.737486 0.246794 1.225672 1.938762 1.669744 1.911752 0.028184 0.352670 1.169110 1.138933 0.911609 1.153860 1.295188 1.451568 1.222645 1.836765 0.315515 1.661130 0.665886 1.423539 -0.027924 1.624245 0.211892 0.318464 1.015468 1.652245 0.240743 1.150550 1.257988 1.368042 0.690738 1.931274 -0.034743 0.771903 1.856503 0.683190 0.957751 0.409827 0.925581 0.140171 0.602555 0.465835 0.338671 1.281554 0.705219 1.397775 1.170389 0.382381 0.242999 0.668790 0.700098 1.973505 0.627343 0.670404 0.886476 0.982946 0.759522 0.694097 0.252884 0.859515 1.570045 1.546775 0.284098 0.314092 0.168123 1.469812 1.098694 0.268268 1.420670 1.272723 0.382719 0.671480 1.435402 -0.110241 0.561019 1.353828 1.506014 0.931446 1.044498 1.647818 0.262634 1.666668 0.124893 0.309225 1.239534 0.520530 1.500534 0.061664 1.274884 -0.244216 1.650214 0.424051 0.892559 0.202169 0.442374 0.683088 1.684786 1.219867 0.391490 1.016231 1.491883 1.765165 1.764702 1.283017 0.934137 0.230333 1.283241 -0.045685 1.411918 1.307833 1.725023 0.245397 0.538120 1.457284 0.616433 0.168907 0.521502 0.384247 0.974783 0.364292 0.076939 -0.235106 1.283357 1.428764 1.664927 0.374574 1.099794 0.852722 1.803641 0.274149 1.335009 1.914350 -0.207888 0.073165 1.428393 1.365955 1.849232 0.634655 0.268387 -0.166276 0.397839 0.357434 0.489122)
      )

;;; 512 even --------------------------------------------------------------------------------
#(512 35.776 #(0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      31.628149 #(0.000000 0.193458 0.879636 1.705304 0.490370 0.075082 0.075683 1.300845 1.564891 0.673316 0.757185 0.241756 0.594649 0.885118 0.323693 1.454812 0.908273 1.351061 1.781313 0.564771 0.183286 0.637926 0.622421 1.045142 0.517278 0.296784 1.410403 0.602065 0.772561 1.389650 0.527960 1.708369 0.033642 1.830155 1.178018 1.593299 0.764263 1.671821 0.206173 1.235732 1.402783 1.788135 0.201137 0.539609 -0.025782 0.918770 0.935892 0.891239 1.913603 1.292613 -0.101151 0.722659 0.055747 -0.088554 0.598806 0.380559 1.211892 1.546048 0.916625 1.399887 1.565523 0.904754 1.010130 1.643551 1.461234 0.875915 0.213846 0.357475 1.186241 1.381267 0.754949 1.779095 1.006740 1.311595 1.737320 1.086140 0.608280 1.768795 1.226748 0.139423 0.844731 1.174543 0.052337 0.835236 0.709458 1.432591 0.165398 0.442884 0.896570 1.597184 1.133267 1.895467 1.175626 0.109893 1.094502 1.928908 -0.087649 1.565508 0.274473 0.027155 1.554166 1.239019 1.373234 1.458458 1.546571 0.031108 1.855623 1.647770 1.494922 1.630144 0.041700 1.725269 0.114205 1.279109 0.713125 1.361675 1.293302 0.370706 1.155957 0.160127 1.306020 1.564145 0.329533 1.577490 0.426179 0.865540 0.506954 0.836528 1.895468 1.155187 1.524271 1.949386 0.062295 1.616901 0.556622 0.305661 1.919946 1.844259 0.313013 0.024129 1.635243 1.597075 1.722121 0.294542 1.002701 1.459972 1.504069 0.899408 0.331782 0.396363 1.663102 1.290621 1.116303 1.021895 0.255551 1.181969 0.645937 1.543659 1.606428 0.192360 0.894664 -0.002504 0.398536 1.481294 0.918465 0.074277 0.749762 0.689678 0.975924 0.653357 1.294427 1.063153 0.441398 0.872255 0.882166 0.959648 1.175046 1.530354 0.796278 0.915558 0.628151 0.260515 1.245714 1.010362 -0.030800 0.853342 0.047830 1.010196 1.020267 0.045034 1.849312 1.096281 0.221294 1.343819 1.249551 0.337281 0.664846 1.064716 1.335370 1.464875 0.181615 -0.072256 0.046603 1.522391 0.275503 0.681141 1.127342 0.430827 1.110432 1.803612 0.451171 0.807526 0.146612 0.741306 0.879652 0.538416 0.789395 0.835580 0.727230 1.500085 1.242144 0.634364 1.803171 1.822514 0.007316 0.582259 1.098006 1.111451 1.052686 0.268482 1.292779 0.408770 0.900978 1.129338 1.119845 0.000211 0.183560 0.409985 1.130318 0.154686 0.903140 1.250848 0.304084 0.291391 0.665312 0.134932 1.031483 1.180817 0.740031 0.591860 0.493782 0.623373 1.760510 1.738938 0.012331 1.868767 0.485398 0.081272 0.744972 1.162890 1.398893 0.348679 1.033764 1.570188 1.891519 0.983723 -0.050025 1.963561 0.683179 1.444931 1.720623 1.922344 1.346126 0.185147 0.425063 0.833788 1.212862 -0.059036 0.979852 1.030316 0.907000 1.585882 1.726983 1.272771 0.520458 -0.246594 0.841441 0.243286 0.398740 1.568681 0.966791 0.492237 1.295293 0.553432 1.719542 1.511716 0.828907 1.018781 1.032010 1.199895 1.666214 1.226917 1.062734 1.392689 0.232672 1.537926 0.453832 1.574299 1.015965 1.273439 -0.120286 1.196312 0.890951 0.947130 0.079812 0.887578 0.233129 0.272637 1.660534 0.099048 0.112940 0.379953 0.313779 0.871859 0.259424 0.974751 0.544740 0.642333 0.302637 -1.970061 0.729276 1.344147 1.146828 0.710229 0.621069 1.365003 1.840156 1.310442 1.151197 1.477337 0.559900 0.108648 0.736983 0.902099 0.115156 1.417090 0.059287 0.355397 1.408677 1.265478 0.852907 -0.030095 0.935670 1.092577 1.649094 -0.066605 0.057334 0.214826 0.920179 1.511506 0.311621 1.288626 0.990573 1.623492 -0.026333 0.306924 1.579035 1.170370 1.732023 1.379262 1.454543 0.891698 0.314877 1.693038 1.768550 0.910599 1.712155 0.945812 0.118254 1.453481 1.939489 0.720326 0.426107 1.203759 1.574972 0.592306 0.975781 0.305093 -0.166629 0.079805 0.409358 0.854323 0.437473 1.528093 0.769890 0.423876 1.508832 1.226392 -1.878260 -0.092214 1.155334 0.010793 1.006280 1.091219 0.386780 0.322578 0.667815 0.434221 1.551779 1.471623 0.419732 1.605348 0.905476 0.713039 0.202928 1.354968 1.929707 0.296628 1.021984 1.535443 0.083646 0.013591 1.615944 -0.015945 1.228774 1.545535 0.273210 1.194157 1.343078 1.185077 1.122175 0.433956 0.758581 0.690958 0.339400 1.730253 0.001977 1.448248 0.615799 0.047214 0.859970 0.772423 1.342656 0.293016 -1.937301 1.859989 1.689477 1.784597 1.602245 0.845767 1.643665 -0.004067 0.091824 1.211465 0.680110 0.230715 0.070609 1.607121 1.378560 0.381059 0.163719 0.922614 0.053089 0.596216 0.562829 1.081319 -0.048350 0.527026 1.238211 0.277364 1.357698 1.757117 1.384714 1.522857 1.368884 0.056972 0.225257 0.823227 0.584976 -1.935447 0.491177 0.763213 1.717924 0.488438 1.535602 0.456160 0.375383 0.517346 1.517261 0.749545 1.085532 0.050128 1.339560 1.741740 1.301265 1.630336 1.618351 1.672383 1.593969 0.959235 0.695771 0.230646 1.678169 0.693007 1.099661 1.490070 0.420988 1.438392 0.212033 1.272969 1.845317 1.413990)
      )

;;; 1024 even --------------------------------------------------------------------------------
#(1024 51.895 #(0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)

       51.627202 #(0.000000 1.029633 -0.012293 0.012880 0.026980 0.979853 0.999814 -0.000026 0.008393 -0.008618 -0.022589 0.994746 0.002832 1.008481 0.003050 0.997875 0.996213 1.012876 0.966656 0.015767 1.000358 -0.002088 0.014429 0.990790 0.013957 1.001392 -0.004078 0.967774 1.013049 1.007123 0.985283 0.013699 0.971495 0.995694 1.026385 0.974549 0.984726 0.014450 1.020521 1.057512 -0.000030 1.035989 1.011331 -0.003193 -0.024617 1.040479 0.999058 0.999748 1.023188 0.015959 0.999918 -0.018936 0.999973 -0.023246 -0.020062 1.051671 0.022658 0.002794 0.974167 0.991086 1.010851 -0.001529 1.001922 1.036863 0.021006 0.005011 1.000699 0.000936 1.014853 0.987112 0.961076 -0.027263 -0.000447 0.965279 -0.006262 -0.009089 0.013976 0.015081 0.978343 0.998354 -0.031203 0.998879 0.993033 0.003160 1.007951 -0.029531 0.037120 0.015294 -0.004457 0.999168 0.006669 0.003518 -0.020636 0.989249 1.037455 0.983981 1.009819 0.041730 1.025735 0.004988 1.017361 0.003502 1.042945 0.015924 1.024463 0.960856 0.011509 0.010562 0.988670 0.024436 0.966800 -0.002597 -0.016676 0.022567 -0.028052 0.946179 -0.017664 1.028163 1.003919 0.001928 1.027279 -0.018987 0.026212 1.037909 0.988421 0.989442 0.020639 0.966655 1.036646 0.002339 0.008427 -0.005614 0.995024 0.983470 0.983405 0.042460 0.974342 0.994593 0.956085 0.009439 0.014059 0.004228 -0.019889 0.026260 0.974355 0.992867 -0.012583 0.984210 0.977740 1.012509 0.987531 0.000750 1.019558 0.026047 1.016442 1.035160 0.993711 -0.030273 1.002476 -0.005058 1.000699 -0.013934 0.956348 1.046660 -0.027964 0.032912 0.003031 0.977465 0.004538 0.989628 0.963685 1.010626 -0.012712 1.018052 -0.017753 1.015077 0.998898 -0.009983 0.997626 0.017615 -0.000785 0.002492 -0.012174 0.002126 -0.016138 1.012447 0.997926 0.966007 -0.013935 1.029393 -0.013026 -0.007371 1.016575 1.007787 1.056292 0.973143 -0.033484 0.035206 0.014191 -0.029943 -0.028705 0.008654 1.000375 -0.021321 0.995735 0.005904 -0.005691 0.957727 0.987992 -0.036335 0.960456 -0.001191 1.023020 0.989914 0.968869 0.041460 0.977261 -0.011659 1.009737 -0.021828 1.008003 -0.001250 0.022942 -0.048050 -0.009089 1.009767 1.043325 1.003191 0.971106 -0.021518 1.028051 -0.011409 1.025024 0.979361 1.044646 1.011438 1.010722 0.031823 -0.028157 0.983741 -0.020268 1.009392 -0.007202 0.998145 -0.026679 1.026788 -0.081497 1.010086 0.018136 -0.018995 -0.001939 0.022706 -0.023740 -0.007240 -0.012899 -0.018640 1.038529 1.020417 0.968369 0.994357 1.027397 0.000794 -0.000991 0.991696 0.031240 0.998445 1.044540 0.970462 0.026110 1.010814 1.020783 0.015899 1.018002 -0.031991 0.007949 0.001502 -0.012758 1.001363 0.004017 -0.007267 0.010560 0.013211 -0.009000 0.009694 1.014273 0.018818 -0.034834 1.028054 -0.003934 1.000986 1.002141 0.992753 -0.028723 1.028360 0.987299 -0.013088 0.996655 1.026438 1.006617 -0.029586 0.003482 0.997825 0.977397 -0.001844 0.989263 0.017137 -0.018305 -0.000071 0.035462 -0.000083 0.020862 0.961786 1.014986 -0.009066 0.004347 0.961092 0.991390 1.004558 0.027069 0.984372 -0.023434 0.988090 0.035406 -0.013962 1.041369 0.024094 0.005763 -0.024629 0.999857 0.043759 0.025275 0.984999 0.997705 0.974194 0.991177 1.004969 0.984649 0.030149 0.982526 0.026091 0.008305 0.993917 0.948422 -0.015968 0.018284 1.030583 0.048958 1.046400 0.020097 -0.041524 0.961135 0.980055 1.003964 1.036523 -0.038536 0.993082 -0.008009 0.037197 0.005452 0.985760 1.009046 0.989319 -0.023085 0.000904 0.027545 -0.000386 1.003513 -0.003653 0.001093 1.022776 0.997472 1.001837 0.009261 0.012077 0.942776 -0.005592 0.975448 0.004766 0.991773 0.016776 0.978178 -0.007370 0.982051 0.960966 1.011421 -0.023355 0.980278 0.973420 0.045377 -0.005290 0.956521 0.992809 0.027688 0.025117 -0.022656 -0.030804 -0.015162 1.036309 -0.026387 0.983041 -0.021172 0.035189 -0.027150 1.004452 0.027891 0.011484 0.034644 0.978769 0.023693 0.998483 0.986597 0.987475 0.010519 0.029762 1.001533 0.993668 -0.016914 1.024557 1.048005 0.011502 1.011339 0.994209 1.017864 0.992986 0.014354 -0.013499 0.992949 -0.060393 -0.016525 1.005615 0.984517 0.995298 0.015187 1.030776 -0.033503 0.000253 0.037666 1.025964 1.007485 0.988947 0.022461 0.006082 -0.020616 1.004962 0.012512 0.962994 -0.004937 1.011421 1.041467 1.008283 0.995643 0.971042 0.987471 0.001468 -0.007697 0.991715 1.049958 1.012746 1.035164 -0.032069 1.013038 0.006264 1.006054 0.035898 0.032052 0.963860 1.014151 0.949502 0.999608 0.009928 0.001465 1.029049 1.025787 1.026326 -0.043190 -0.007875 0.009982 0.011519 0.983107 0.005975 1.006135 -0.001058 -0.024465 1.034626 0.978896 1.011989 1.027524 1.041145 -0.025044 0.018773 0.023996 -0.011560 1.024837 -0.013806 1.002818 0.015362 1.050348 0.022866 0.962501 0.984475 0.010984 -0.010308 0.952987 0.024839 -0.026681 1.012307 1.001104 0.036619 -0.025891 0.014527 0.990542 0.011253 0.024178 1.008209 0.016545 -0.034511 0.036489 -0.014980 1.008478 0.989790 0.976929 1.025218 0.995142 0.987581 0.028634 0.033934 0.019969 -0.021838 1.028720 -0.028955 1.015472 -0.006441 -0.020510 -0.018391 0.978147 0.015688 -0.021362 0.952391 0.029016 0.001211 -0.008983 1.017301 0.981964 -0.001380 0.985470 0.022753 -0.004467 1.038918 -0.047590 1.013576 0.992650 1.023843 0.035368 0.026779 0.037419 1.014741 0.995189 0.997746 -0.034357 0.995854 0.003107 0.951826 -0.014409 0.013970 1.057036 -0.046316 0.969485 1.013522 -0.031630 0.992596 0.019914 -0.030536 0.998738 1.009072 0.042841 0.007827 -0.040331 0.996280 0.005153 0.977472 1.017287 -0.007443 1.023492 1.008942 0.976506 0.991476 0.021767 0.994859 -0.020314 0.017953 0.030219 -0.014664 1.027291 0.995978 0.994587 0.009074 0.983176 0.979563 0.026420 -0.010245 0.972168 1.035690 0.001320 0.993513 -0.006353 0.993098 1.018795 1.026884 1.026658 0.970022 0.999193 1.016983 0.979543 -0.022890 0.020692 -0.040886 1.018579 -0.011065 0.055122 0.983881 0.025346 -0.040047 1.013370 0.955646 1.036308 0.991315 0.033330 -0.025327 0.016975 0.995791 0.981244 0.961974 1.008112 1.057891 -0.001461 0.987480 0.009720 -0.026757 0.013022 0.980104 0.999666 -0.012002 -0.002490 1.031008 -0.036579 -0.019712 -0.012903 0.988206 0.016822 0.004518 1.021480 1.018658 0.022505 -0.040063 0.965796 0.967095 -0.030506 0.986755 0.009185 -0.029252 0.027913 -0.001038 0.005149 1.030725 -0.022649 -0.050486 0.985861 1.023283 -0.035330 -0.003861 -0.024807 -0.017869 1.007192 0.991993 -0.037209 -0.015099 1.024263 0.988398 1.000630 -0.011148 1.011225 1.003859 1.000624 0.027737 1.030697 -0.007960 0.015120 0.030404 1.063288 -0.015487 0.009610 0.997903 -0.014983 0.009095 0.001637 0.028463 -0.017241 0.980929 1.031302 0.957184 1.006390 -0.000930 0.026429 -0.035760 -0.008466 0.002222 1.003563 0.029085 0.031352 0.955169 0.956096 1.049753 1.023909 0.993320 1.004337 0.981836 0.009217 0.959911 0.028388 0.983865 -0.035427 -0.010471 -0.031064 -0.002590 0.956357 0.036784 -0.009809 0.991834 -0.034104 -0.018459 0.012906 0.991005 0.022404 1.021742 0.004101 -0.003005 0.999319 0.002777 0.970118 0.020836 -0.025284 1.027935 -0.012000 -0.004879 -0.034122 0.007932 1.021494 0.992149 1.020224 0.016422 1.035923 1.005921 0.970291 1.017378 1.005947 -0.036189 -0.030483 0.001790 0.032815 1.014774 0.983789 0.988084 0.023220 -0.019774 0.971264 -0.028081 -0.029889 0.992294 1.005999 0.977060 1.014232 -0.021160 -0.010988 0.959821 0.005604 0.021718 -0.021955 1.054722 -0.016545 0.964984 0.985050 0.984349 1.031167 0.974286 0.002534 0.035348 -0.012068 -0.013231 1.015785 0.023828 1.015996 -0.031622 1.005232 -0.009273 -0.019787 1.025036 -0.026464 0.006101 0.967905 1.014269 0.979093 -0.029265 -0.021119 1.021888 0.954078 0.000085 0.002622 0.994485 1.000089 0.999748 0.998280 0.023211 0.988740 -0.018255 0.960366 0.045586 -0.019498 0.008522 1.020829 1.008354 0.006514 1.022643 0.015185 0.000755 0.018782 1.014301 0.027370 -0.012785 1.014767 0.991316 1.003698 1.039078 0.005598 0.005237 1.002700 1.029163 0.004849 -0.028907 -0.023045 1.017953 0.020296 0.006471 1.017652 -0.022322 1.034186 1.027202 -0.016734 1.002485 0.047223 0.040688 0.006990 0.990955 0.022236 1.031053 -0.003084 1.020609 0.017659 0.020197 0.011235 0.962757 0.001996 1.044123 0.976238 -0.019950 1.030412 0.011057 1.017582 0.014033 0.025446 1.004206 -0.003240 0.027075 -0.007050 -0.035685 0.992859 1.011519 0.014202 0.981388 1.005139 1.004029 1.006912 1.005778 1.021140 0.983053 -0.016137 -0.014145 1.000304 0.997530 1.003746 1.049578 0.959733 0.000454 -0.009718 -0.026521 0.029837 0.007222 1.010987 0.005317 -0.030318 1.007035 -0.032687 -0.011029 0.989009 1.041889 0.982391 -0.018390 0.038156 1.006608 0.000964 0.020590 0.018089 1.004892 1.001298 0.040112 1.005506 1.015600 -0.009035 0.940825 0.000076 0.006269 0.006741 -0.012462 -0.037129 0.010208 -0.024410 -0.019642 -0.014977 -0.024707 0.990616 0.038768 0.010238 1.040880 -0.006119 -0.047665 0.986770 -0.011567 1.004318 -0.029971 1.013665 -0.022161 1.002074 0.010501 0.960155 0.984224 1.026497 -0.016095 1.010019 0.031642 0.999133 0.979670 0.000233 -0.007173 1.008576 0.977465 0.974203 0.962648 1.001036 0.999199 1.006937 1.008107 1.030886 0.032255 0.013490 1.006674 1.009720 -0.000453 0.030604 1.006832 1.002142 1.011386 -0.032413 -0.010262 1.028395 1.007678 0.997719 1.024479 0.960010 -0.004909 0.994707 -0.013372 0.977065 0.994209 0.973989 0.007180 -0.027035 0.985703 -0.005303 -0.038704 0.037271 1.004149 0.966830 1.029492 -0.024194 -0.015545 1.038917 1.042772 1.001889 0.998939 0.955875 -0.005453 0.980182 -0.007532 0.998567 0.983303 0.017570 -0.020865 -0.013117 1.027734 0.984047 0.038060 -0.007684 1.009226 -0.024667 1.000606 1.016532 0.981910 -0.010374 0.007713 1.032539 0.989510 1.024116 1.001067 0.024989 -0.020873)
       )

;;; 2048 even --------------------------------------------------------------------------------
#(2048 87.471149563312 #(0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       78.079325 #(0.000000 1.036212 -0.043685 0.331976 0.639530 1.127516 1.095152 1.508236 0.077934 1.337557 0.072113 -0.092944 0.796909 1.784824 0.440076 0.246196 1.387524 0.190896 1.640182 0.925143 0.346541 1.367537 0.178172 0.900392 1.703536 1.678208 1.753849 0.425105 0.187619 1.751892 1.898170 0.616148 1.276449 1.748534 0.146310 1.804887 0.286781 -0.064076 1.520935 0.166848 1.246710 0.087250 0.943537 1.755401 0.334485 0.490353 1.501725 1.277784 1.245080 0.471353 0.764254 1.697034 1.056331 1.736214 0.463227 0.796303 1.150866 -0.021932 0.234603 0.080694 1.745115 0.716674 0.093762 0.744119 1.143077 1.540437 1.841607 1.711093 0.867517 1.296036 1.315314 1.006884 0.239668 1.666083 1.671147 1.716928 -0.027459 1.906723 0.073560 1.255469 1.796692 0.526703 0.076840 0.934228 0.293278 0.367456 0.305891 1.422085 1.299849 1.951249 1.462008 1.040367 1.853366 0.810937 0.603550 0.848743 0.268307 1.173776 1.919876 1.102197 1.660214 1.762553 1.781211 0.633437 0.456915 0.254253 0.486765 0.536153 1.493176 0.945749 1.791455 0.934973 0.284784 1.433744 0.425334 0.064742 0.690643 1.925513 1.755950 0.618329 1.632172 -0.059593 1.375330 0.869966 1.487228 1.414963 0.333672 0.780241 1.330677 0.484533 0.218933 0.162630 0.710074 0.419557 -0.032680 0.883965 1.717277 0.430915 0.263252 1.360127 0.169506 1.343179 1.234460 1.750884 0.164361 0.378299 1.460882 0.897871 0.213904 0.128719 0.360447 0.555828 1.579900 1.051631 1.398250 1.313610 0.220306 0.871110 1.178519 1.513441 1.303728 0.802201 0.242388 1.900778 1.477677 0.067540 0.652996 0.103896 0.687602 0.914043 0.697581 0.105317 1.825200 0.024458 0.235192 0.433521 0.312835 0.809192 1.808814 0.468703 0.865854 1.628971 1.590464 1.720208 0.790391 0.109924 1.554973 -0.023990 1.192392 0.712254 -0.008308 1.166932 0.323937 0.599507 1.428804 1.009547 0.297463 1.703546 1.729917 1.681205 0.524857 1.697748 0.256667 1.120927 0.047187 1.189398 0.820638 0.699302 0.002442 1.121649 1.667851 0.869163 1.641192 0.656529 0.841409 0.057676 -0.196215 1.453792 1.886624 0.125107 0.602688 0.239635 0.436713 1.300259 1.239844 0.261666 1.553825 0.240232 0.801341 0.507041 1.560623 1.566831 1.253461 -0.062284 1.669509 1.095250 0.027748 1.068831 0.602783 1.174264 1.815938 0.796036 0.386048 1.233720 1.401215 0.759974 0.913111 1.179032 1.213203 0.938878 1.696577 0.360595 1.305400 0.044128 1.743675 1.440756 1.459247 0.623194 1.508843 1.421417 1.629960 0.477983 0.835293 -0.070334 0.708287 1.142955 0.932387 1.813043 1.382192 0.381127 0.190410 0.729845 0.321732 0.824558 -0.020023 1.607442 0.200267 0.318647 0.044651 1.768240 0.643757 1.206201 1.468765 0.601437 1.706259 0.495261 0.956913 0.394710 1.176569 0.800067 1.886558 1.605179 1.122676 1.144265 1.561625 0.181947 1.309849 1.577300 0.495188 1.655610 1.180832 1.194001 0.875913 0.228611 1.639141 0.550083 1.839287 0.580971 -0.197365 0.327613 1.901067 0.522438 1.020637 1.267341 1.342859 0.445176 0.112095 0.457659 0.120276 0.250883 1.204237 1.402798 1.271260 1.255292 0.578618 1.686129 0.490946 1.771289 1.121957 0.127348 0.581481 0.812819 1.448200 -0.003892 -0.044962 0.952367 1.033247 -0.085086 0.150310 0.057854 1.842500 0.716853 0.935519 0.269127 1.299626 0.388259 0.164338 1.057650 1.178504 1.241059 0.565924 1.615325 0.390452 0.686889 1.489199 0.183366 1.767188 1.365040 1.248231 1.196393 0.220573 0.358798 0.163202 1.499695 1.793435 -0.212597 0.677471 0.562186 1.706417 0.638842 0.138384 1.541313 1.495553 1.825920 1.099565 0.289989 1.936921 0.388891 1.617689 0.315048 0.242499 1.724502 0.758918 0.479832 0.306301 1.154626 1.015534 1.286300 0.819723 0.897789 1.897385 0.811133 1.198870 -0.023538 1.581550 1.752737 0.752872 1.653243 1.098279 0.913859 0.290667 0.391090 0.448864 1.747363 1.628653 1.296395 1.685456 0.410609 0.613612 0.229500 1.978170 0.563390 1.684018 1.175413 1.421149 0.835252 1.423949 1.519247 0.020578 0.410433 0.532037 1.105479 1.305389 0.747326 0.273148 1.468421 1.561328 1.045465 0.300840 1.851806 1.623959 -0.020047 0.551127 0.952587 1.750489 0.425896 1.297055 1.252366 0.774082 0.008302 0.830022 0.354751 1.630433 0.527393 0.320074 0.992472 1.329100 0.937461 -0.124987 0.528489 0.860443 1.777412 -0.179698 1.649835 1.523675 0.255615 0.752546 1.044250 1.061394 1.473542 1.559139 1.750843 0.228407 0.244978 0.318506 0.214338 -0.127687 0.016065 1.683527 1.059087 1.084321 1.209844 1.162599 1.700206 1.028836 1.111259 0.965422 1.349098 0.449160 1.236238 1.152610 1.241247 0.441411 1.200500 1.575948 0.056337 0.109621 0.678763 1.605571 1.462870 0.670350 1.160814 0.178948 1.776617 0.814727 1.471143 0.666341 0.666497 0.003085 0.367263 1.764549 1.817682 0.565043 0.256262 0.744401 0.069362 0.856509 1.798907 0.484543 1.036560 1.448462 1.009617 0.983445 0.719152 0.713983 1.197878 0.928722 0.442562 0.632379 1.311255 1.163303 1.389071 0.013803 1.283658 0.183551 0.216748 0.742490 0.246195 0.580366 1.004491 0.032852 1.729133 1.159382 1.701779 0.944042 1.827589 0.917849 1.400392 1.223004 1.113159 0.052572 0.168081 1.615230 1.221824 1.526728 1.850771 -0.240328 1.487522 1.159816 1.866293 1.698164 0.013835 -0.093167 0.180008 0.018965 1.603158 1.613742 1.313466 1.035280 1.492647 0.815996 0.391557 1.242014 0.993247 1.401424 0.488225 0.393455 0.894952 0.309407 0.321448 0.558471 0.718740 1.467551 0.500281 0.439320 1.869730 1.364530 1.553036 0.969732 1.636285 1.798396 1.363995 0.920638 0.126592 0.286258 1.696296 0.331371 0.356812 0.490460 1.101761 0.373647 0.097306 0.453078 1.827015 0.179707 -0.019918 -0.106312 0.084833 1.193623 0.408083 0.143266 0.206533 1.082562 0.158416 0.854906 0.878107 0.339914 0.457130 0.154799 0.176600 0.085438 0.131041 0.453107 0.593969 0.303633 0.916178 1.161798 1.896318 0.930094 0.986481 1.688216 0.819416 1.265892 0.011344 0.265144 0.267354 1.189048 0.659992 1.171202 1.786897 0.902370 -0.041938 0.785186 0.246222 1.558295 1.890657 1.369584 1.616357 1.670144 1.849685 1.342838 1.757000 1.172827 0.103451 0.032886 1.109693 0.659929 0.371860 1.404352 1.477883 1.155474 0.555608 0.969331 0.650971 1.813202 1.603915 0.999884 1.494172 1.882922 1.689689 1.690194 0.705259 1.560645 1.081311 0.825846 1.685601 0.689103 0.269731 0.147349 0.167554 0.803327 0.198449 1.282138 1.170132 0.901085 1.709183 0.934868 1.972921 0.385259 1.488122 0.118213 1.387825 0.546603 0.472410 0.223942 0.792440 1.272964 0.539143 1.056110 0.965279 1.256909 0.069278 0.438772 0.688522 1.474529 1.518833 0.647516 1.850584 -0.061940 1.420599 1.301753 0.184502 0.147262 0.261775 0.575331 1.308330 1.224554 0.672189 0.758277 1.191895 1.228368 0.130276 0.482407 1.350231 1.750711 0.397622 1.713381 1.011249 0.522822 1.072918 1.821285 0.965512 0.063639 0.566385 1.807346 1.175784 1.223074 1.591887 -0.168041 0.271021 1.529439 0.521842 0.823001 0.940921 1.684294 0.286489 1.242930 1.937690 0.607200 0.275302 1.790606 0.491021 1.035487 -0.045868 0.085148 1.238065 1.129382 -0.053312 1.545108 0.434470 0.810550 1.100562 0.221267 1.037507 1.624758 1.555603 1.062386 0.144378 0.886916 0.149410 -0.066826 1.113563 0.490079 0.634885 0.842660 0.061321 1.725263 1.823881 0.115290 1.146242 0.979557 1.530480 0.067327 0.568197 0.897626 0.771983 0.563170 1.194766 0.655189 1.549104 1.322518 0.483177 0.760693 1.010138 0.534980 0.223935 1.152460 1.731132 1.519096 0.446488 1.420973 1.696386 1.157486 1.211136 1.546897 1.232762 1.175520 0.355595 1.525833 -0.042267 1.352048 0.992497 -0.093673 0.742530 0.634885 -0.089066 0.868194 0.573537 1.674126 0.329153 1.158907 1.178480 0.551158 1.486852 -0.071558 0.725909 1.395015 1.209212 0.379942 0.747225 0.444854 0.946742 1.211242 1.139390 1.010957 1.097783 0.203142 1.127162 1.614090 1.772287 0.331896 1.598023 1.816077 0.662803 1.330979 0.944114 1.383701 0.797215 1.196402 1.084443 1.184444 1.682543 1.168272 1.958979 -0.058496 0.841894 1.219141 1.365510 0.769766 1.232995 0.960628 1.742029 1.659964 0.361424 0.247996 1.622047 1.491439 1.012850 0.556413 0.070470 1.055118 0.709469 1.227676 1.050289 1.817507 1.250045 0.044881 -0.105998 0.360108 0.510639 -0.000754 0.913624 0.014253 0.869683 0.815496 -0.043945 1.463465 1.037174 0.323537 0.584260 1.687824 0.186494 1.408948 0.905638 1.501561 1.450375 1.647727 1.343515 0.997551 0.097973 0.620795 0.473197 0.975124 1.453483 0.888388 0.452833 1.689714 0.696728 0.633683 0.509294 1.106199 0.373384 1.699003 1.169996 0.082561 0.289835 0.757159 1.514061 1.528786 0.435419 0.161517 0.726914 1.380867 1.654754 0.604942 0.070114 0.541874 1.167294 1.310511 1.570194 0.673809 1.267196 0.489289 1.272471 1.573227 1.458789 0.530304 0.456318 1.679920 1.109017 0.240982 1.697797 0.777016 0.870109 1.599744 1.746059 0.193197 0.572600 1.617885 0.423393 0.264299 1.931463 0.929567 1.333438 0.553075 0.123102 0.783267 1.986789 1.667679 1.525086 1.102518 0.117178 0.013899 0.476557 1.428021 1.781881 0.479378 1.440749 0.433516 0.176847 1.747379 1.328355 0.058455 1.628266 1.215447 1.600718 0.965239 1.219616 1.227710 0.034900 1.335400 0.576945 0.169250 1.234608 1.110724 1.740429 1.656377 0.259109 1.608270 0.156542 0.335333 0.895697 -0.078619 0.093744 0.937474 0.090269 0.752748 0.885184 1.935435 1.556700 1.833155 0.379459 1.439350 0.281834 1.377687 1.469181 0.560304 0.350829 0.370361 0.413143 1.546821 1.107825 0.763796 1.687563 0.219324 0.055037 -0.020128 1.641061 1.731840 1.877911 1.717828 1.356597 1.730658 0.588868 0.835297 0.297291 0.088419 0.412212 1.415406 1.017343 1.423175 0.375775 1.302219 0.953702 0.678804 1.572374 1.727477 0.254556 1.094641 1.162163 0.143319 0.854688 1.063038 0.441476 1.282254 1.589355 0.648429 0.822071 1.490818 0.276396 1.213776 0.318534 1.167492 0.713979 0.593799 1.038818 1.843043 0.450884 1.098196 1.002340 1.751110 1.258344 0.802075 0.796882 0.068028 0.990778 1.404822 0.767441 0.258966 0.014912 0.397819 1.169281 0.671758 0.828982 0.684022 1.483627 0.060148 0.140681 0.965311 1.046164 1.448760 0.937335 0.043049 1.426389 0.175311 0.942467 1.289194 0.705897 0.195736 1.367220 0.481110 1.117710 0.026294 1.480040 1.701576 0.741539 0.129438 1.793396 0.216626 0.338432 1.293825 1.852766 0.567380 0.675267 1.660257 1.295361 0.379806 0.115345 0.037783 0.635233 0.390593 0.891898 1.623418 1.141114 0.967319 0.436616 1.163548 1.438313 1.028606 1.507879 0.276194 1.126750 1.086763 0.657033 -0.091488 1.327256 1.184128 1.357378 0.116523 1.532550 0.455893 1.613945 0.808970 0.183575 0.288911 -0.057175 0.416408 1.883558 1.036690 -0.004024 1.155543 0.908210 0.958228 0.735059 -0.149409 -0.109242 1.993416 0.061976 0.994397 0.312822 0.358556 0.357396 0.166228 1.906441 1.936369 1.954589 1.571014 0.719233 0.153949 0.028336 1.320995 1.240948 0.545995 1.805452 1.619213 0.231489 1.707803 0.618275 0.642514 1.471382 1.348917 1.095451 0.221991 0.792513 0.689445 1.882995 1.365514 1.063222 1.950163 0.465549 0.519653 0.736476 1.311946 1.452773 1.442715 1.517899 0.924450 -0.258534 0.766737 0.924843 0.502570 1.115330 1.657088 0.120016 1.780444 1.686548 0.035927 0.449644 0.309346 1.622740 0.581408 0.299807 1.408994 0.611973 0.764394 0.604130 1.299785 1.686040 1.006944 0.701090 1.243781 0.213973 0.887207 1.233295 1.666529 0.235283 1.402144 1.228392 0.531790 0.502582 1.344011 1.047300 1.113632 0.075538 1.422393 1.570034 1.313722 0.186419 0.938804 1.688331 0.356313 1.160071 1.677615 0.597077 0.892649 1.278418 1.866713 0.634605 1.131045 1.247527 0.323580 1.122900 0.478811 0.712857 0.778489 0.733910 0.492143 1.681476 0.182306 0.475863 1.491278 0.187728 0.437657 0.198048 1.236439 0.268664 0.149327 0.934080 1.438262 1.896760 0.457386 0.548858 1.210218 1.289090 1.057745 0.668857 1.173530 0.693912 1.373334 0.504490 1.774419 1.309479 0.081305 1.710946 1.383983 0.433639 0.367597 0.598191 0.968980 0.477561 1.759027 0.625170 1.727969 1.718828 0.634164 0.574901 1.059254 0.056017 0.516804 0.253417 0.694276 1.806842 1.251926 1.330344 0.582436 0.789520 1.835852 0.867891 1.822064 1.359273 0.296168 0.365411 0.131864 0.093576 0.901545 1.224841 -0.103847 0.409143 1.472189 1.522564 0.937037 0.936778 0.858129 0.405727 0.803283 0.405592 1.621314 0.477697 1.071232 1.490250 0.210905 0.388916 0.148961 0.484107 0.248858 0.677626 1.216797 1.366933 0.495657 1.673293 0.762780 1.143691 1.830348 0.353612 0.038958 1.687620 0.671154 0.712933 1.807885 1.122232 1.188992 1.701760 0.242220 1.603391 0.699724 1.054033 0.076868 1.632921 1.612600 0.087130 0.365903 0.458822 1.024159 1.354588 0.392699 1.423641 1.204423 1.164681 1.649578 1.256031 1.243822 1.042854 0.005560 1.024514 0.604398 0.680137 1.912453 0.670310 0.213643 0.446770 1.090682 1.474974 1.806865 0.764624 1.563431 0.473634 0.510617 1.001005 1.364194 0.537668 -0.014680 0.885588 -0.005747 1.738242 1.410596 1.602084 0.734862 1.493989 1.349989 0.406916 1.170482 -0.017990 1.034213 0.634019 1.456131 0.974789 -0.144669 1.737158 -0.037172 1.400515 1.623550 0.499450 1.479595 0.507050 1.358218 0.582744 1.475859 0.513808 1.600273 1.836597 1.059912 -0.072725 1.290524 -0.073595 1.937918 0.300206 0.119306 1.027133 -0.093444 0.011477 1.127890 1.399417 1.853798 1.657887 0.145866 0.588742 0.873359 0.762305 1.639168 0.778598 0.019634 1.817733 0.156595 0.169164 1.530459 1.438248 0.803585 -0.094272 0.468694 0.847016 0.311870 0.299559 0.551763 0.793044 1.160950 0.697742 1.837771 0.754430 1.758952 0.505686 1.737258 0.020417 1.293145 1.675271 0.394950 0.929538 0.720083 0.978614 0.784199 0.905034 0.921702 0.937761 1.562150 1.166453 1.603212 0.260741 0.602140 1.673881 0.673664 1.946860 1.010728 1.288978 1.297659 1.198620 0.504487 1.420515 1.576870 0.975311 1.683510 1.543454 1.716402 0.940588 1.162463 1.651787 0.589731 0.285012 0.638073 1.089187 1.489366 0.491525 1.435921 1.014411 1.601370 0.949407 1.694644 0.959875 -0.062780 -0.004119 1.163389 0.589582 1.149178 1.817933 0.849953 1.802695 1.461496 1.665429 1.837845 0.976053 0.862346 0.530923 0.811633 0.503788 -0.027013 1.611602 0.057407 0.611054 1.824034 0.259920 0.148035 0.105941 -0.021158 1.835611 1.319838 1.754236 1.193537 1.357026 0.094401 1.491186 0.366416 1.555586 1.669437 0.823707 1.243186 0.432020 1.052515 0.858115 1.022105 0.954847 1.455406 1.318994 0.283690 1.211015 0.710161 0.270613 1.714336 1.101135 0.235311 1.092475 1.008566 0.447003 0.602655 0.757184 0.009064 0.530056 1.724465 0.607925 1.121575 1.099024 0.882158 0.934761 0.125447 0.972944 0.967420 1.343086 0.315752 1.165505 1.109567 1.918061 1.478347 0.850704 0.940172 0.696083 0.793045 1.211155 0.866708 0.135821 0.480730 1.058685 0.463469 0.583533 1.522858 0.588384 0.353159 1.576867 1.754930 0.850029 1.919190 1.543405 0.995776 0.821301 1.793940 1.151072 -0.047846 1.508846 1.746284 0.877808 0.214307 0.787802 -0.003151 1.141139 1.698635 0.232169 1.093325 1.515191 0.901564 1.506350 0.135967 1.384636 -0.242650 0.302616 1.608186 0.459148 0.023364 0.249132 1.086552 0.992569 1.132819 0.061330 1.433907 1.539244 0.001712 1.876374 1.299743 1.030055 0.164439 0.092647 0.881217 1.088556 1.351722 -0.088421 0.062334 -0.051555 1.260415 0.983686 0.258617 0.860731 0.793959 0.416831 1.721077 0.095305 0.351122 0.421061 1.074247 -0.008811 1.438063 1.858745 1.305784 0.273960 1.682787 1.279785 0.274409 1.389220 0.882641 1.632991 1.590305 0.893791 0.055411 1.041678 1.451974 0.782716 0.213219 0.208404 1.139321 0.013312 0.073161 1.595535 1.686000 1.590328 0.023294 0.960934 0.758890 0.838775 1.710621 1.483697 1.281650 1.870804 0.139547 0.420537 0.308122 0.843944 0.520105 0.603303 -0.123864 1.234056 1.586800 0.927689 1.817960 1.506645 1.174470 0.276079 0.650528 0.932391 1.014056 0.664840 1.016866 1.426511 0.276789 0.219182 -0.115031 -0.164867 0.961712 0.416951 1.540063 0.375102 1.075987 1.313615 1.096641 0.764154 1.064504 0.355545 1.636517 0.212986 0.487153 0.606986 0.525136 0.094256 1.722629 0.854306 0.459009 1.050404 0.099495 1.863554 1.019865 1.702596 1.229915 1.749507 0.590639 0.164343 1.868513 1.170840 1.017598 0.404087 1.088319 0.595386 0.693810 1.531079 -0.137773 0.882791 1.035974 1.610308 1.572178 1.281505 1.448052 1.385965 0.085841 0.156089 1.020082 1.499413 1.367482 1.202166 -0.310324 1.093902 0.466865 0.481107 0.055940 1.626791 0.579934 0.932207 0.524863 0.771645 1.410464 1.781815 0.875062 1.565260 0.492144 0.931433 0.731301 0.464124 0.688570 0.033927 0.659049 -0.144339 1.390582 0.216364 1.564810 1.784761 0.542130 1.644616 0.892364 0.103014 1.151370 0.406893 0.685594 0.203695 0.116843 1.116841 0.017775 1.255535 0.180776 1.604852 1.357176 0.844518 1.917543 0.710840 0.586218 -0.084711 0.326304 0.583894 0.000981 1.527582 0.764193 0.691981 1.254365 0.042940 0.799959 1.234613 0.912676 1.261576 1.804612 1.772885 1.638278 1.452687 1.856363 1.017673 1.335012 1.093288 1.791716 0.240760 1.583614 0.215117 1.054497 1.759230 1.720795 1.725051 0.719870 1.536084 0.793019 0.072407 1.612325 0.603805 0.749790 0.930307 1.444787 0.076331 0.716031 0.751130 1.730048 1.119736 1.740692 1.642864 1.211815 0.613767 1.280443 0.196315 0.724783 0.377146 1.066938 1.497331 1.166708 1.287064 1.948271 1.408327 0.113842 -0.199587 0.630400 0.343945 1.153303 0.303357 -0.235653 1.575467 1.304018 0.481724 0.321926 1.036142 1.030288 0.337553 0.573686 1.834042 0.718673 0.182114 0.139978 0.253556 1.503381 0.215937 1.358417 0.238777 1.828073 0.206519 0.338254 0.358048 1.340274 1.144155 0.382861 -0.237688 1.081990 0.287210 0.604778 0.308728 1.486981 0.684669 1.827156 0.478181 1.795964 1.220849 1.367205 0.507990 0.995111 0.581857 0.196941 1.401782 0.618658 0.678201 1.941176 0.922033 0.346514 1.451221 1.191571 0.812039 0.176868 0.358644 0.856782 1.053754 0.172649 -0.008915 0.891004 1.275467 1.965871 1.446554 1.059213 1.698536 0.639863 1.290197 1.301277 0.460338 0.904108 1.206822 1.204141 0.172712 1.004515 0.611142 0.640455 1.099407 0.564655 0.577778 1.778285 0.167018 0.507458 0.762661 0.259884 0.066707 0.947613 0.965715 0.752844 0.822051 1.036867 1.496747 1.109711 1.909353 0.600886 1.668852 1.668992 -0.160977 0.189295 1.475624 0.412875 0.557318 1.130005 0.439886 1.255571 1.411751 0.901388 0.499673 1.791033 0.684314 -0.123345 1.518751 0.858235 1.779307 0.897544 1.242344 1.789823 1.117474 0.471404 0.148429 0.200067 1.627870 1.184473 1.258861 1.514572 1.105948 0.122797 0.601905 0.937069 0.692200 1.745527 1.038032 0.377653 0.204106 1.113841 0.997556 1.126370 0.095557 1.147967 0.559979 1.673772 1.556295 0.142426 1.654656 0.686755 0.114523 1.891052 1.870233 0.340505 0.325592 1.788001 1.691946 1.832371 0.254110 -0.056957 0.552635 0.359382 1.244098 0.331889 0.956126 1.636252 0.526733 1.070660 0.740225 1.503924 0.042864 0.662653 0.013249 0.159303 0.325720 0.297550 0.820869 1.730514 0.000052 0.161939 0.357257 0.877505 1.576861 1.847738 0.044951 0.597694 1.584933 -0.105788 1.430351 0.083180 1.563544 1.130148 1.599446 1.171509 0.524299 0.631284 0.480371 1.906399 0.915214 1.139324 0.334117 1.299283 0.373882 0.383787 0.345985 1.171992 0.720625 1.314793 1.338926)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


#|
  (with-sound (:channels 2 :clipped #f)
    (let* ((n 24)
	   (c-phases (vct 1/2 1/2 1/2 1/2 1/2 3/2 1/2 1/2 1/2 3/2 1/2 1/2 1/2 3/2 3/2 3/2 3/2 3/2 1/2 3/2 1/2 1/2 3/2 1/2))
	   (s-phases (vct 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1))
	   
	   ;; n amp phase

	   (cos-phases (make-vct 72))
	   (sin-phases (make-vct 72)))

      (do ((i 0 (+ i 3))
	   (j 0 (+ j 1)))
	  ((= i 72))
	(set! (cos-phases i) (+ j 1))
	(set! (sin-phases i) (+ j 1))
	(set! (cos-phases (+ i 1)) 1.0)
	(set! (sin-phases (+ i 1)) 1.0)
	(set! (cos-phases (+ i 2)) (* pi (c-phases j)))
	(set! (sin-phases (+ i 2)) (* pi (s-phases j))))

      (let ((gen1 (make-polyoid 100.0 cos-phases))
	    (gen2 (make-polyoid 100.0 sin-phases)))
	(run 
          (do ((i 0 (+ 1 i)))
              ((= i 88200))
	    (outa i (polyoid gen1 0.0))
	    (outb i (polyoid gen2 0.0)))))))

(set! (mus-rand-seed) (current-time))
(set! (print-length) 1000000)

(define (vector-find-if func vect)
  (let ((len (vector-length vect))
	(result #f))
    (do ((i 0 (+ i 1)))
	((or (= i len)
	     result)
	 result)
      (set! result (func (vect i))))))

(define low-primes (vector 1
       2       3       5       7      11      13      17      19      23 
      29      31      37      41      43      47      53      59      61 
      67      71      73      79      83      89      97     101     103 
     107     109     113     127     131     137     139     149     151 
     157     163     167     173     179     181     191     193     197 
     199     211     223     227     229     233     239     241     251 
     257     263     269     271     277     281     283     293     307 
     311     313     317     331     337     347     349     353     359 
     367     373     379     383     389     397     401     409     419 
     421     431     433     439     443     449     457     461     463 
     467     479     487     491     499     503     509     521     523 
     541     547     557     563     569     571     577     587     593 
     599     601     607     613     617     619     631     641     643 
     647     653     659     661     673     677     683     691     701 
     709     719     727     733     739     743     751     757     761 
     769     773     787     797     809     811     821     823     827 
     829     839     853     857     859     863     877     881     883 
     887     907     911     919     929     937     941     947     953 
     967     971     977     983     991     997    1009    1013    1019 
    1021    1031    1033    1039    1049    1051    1061    1063    1069 
    1087    1091    1093    1097    1103    1109    1117    1123    1129 
    1151    1153    1163    1171    1181    1187    1193    1201    1213 
    1217    1223    1229    1231    1237    1249    1259    1277    1279 
    1283    1289    1291    1297    1301    1303    1307    1319    1321 
    1327    1361    1367    1373    1381    1399    1409    1423    1427 
    1429    1433    1439    1447    1451    1453    1459    1471    1481 
    1483    1487    1489    1493    1499    1511    1523    1531    1543 
    1549    1553    1559    1567    1571    1579    1583    1597    1601 
    1607    1609    1613    1619    1621    1627    1637    1657    1663 
    1667    1669    1693    1697    1699    1709    1721    1723    1733))

(define (get-fft-size choice n1)
  (let ((n (if (eq? choice :all) n1
	       (if (not (eq? choice :prime)) (* 2 n1)
		   (low-primes n1)))))
    (min (expt 2 16) 
	 (expt 2 (ceiling (/ (log (* n 64)) (log 2)))))))

(define (random n)
  (if (rational? n)
      (mus-irandom n)
      (mus-frandom n)))

(define pi2 (/ pi 2))
(define data-file "test.data")

(define (save-case n choice peak phases)
  (let ((fd (open-output-file data-file "a")))
    (format fd "~%;~A: ~A ~A #(" n choice peak)
    (do ((m 0 (+ 1 m)))
	((= m n))
      (if (zero? (phases m))
	  (format fd "0")
	  (format fd "1"))
      (if (< m (- n 1))
	  (format fd " ")))
    (format fd ")~%")
    (close-output-port fd)))

(define (try-any)
  (let ((choice (let ((v (random 4)))
		  (case v
		    ((0) :all)
		    ((1) :even)
		    ((2) :odd)
		    (else :prime))))
	(n (+ 24 (random 104))))
    (let* ((size (get-fft-size choice n))
	   (tries (if (not (eq? choice :prime)) 2500000 500000))
	   (fft-rl (make-vct size))
	   (fft-im (make-vct size)))

      (format #t ";~D ~A~%" n choice)

      (let* ((cur-min 1000.0)
	     (phases (make-vct n 0.0)))
	(let ((min-val (vector-find-if (lambda (val)
					 (and val
					      (vector? val)
					      (= (val 0) n)
					      (let ((a-val (val 1))
						    (a-len (vector-length val)))
						(do ((k 2 (+ 1 k)))
						    ((= k a-len))
						  (if (and (number? (val k))
							   (< (val k) a-val))
						      (set! a-val (val k))))
						a-val)))
				       (if (eq? choice :all)
					   noid-min-peak-phases
					   (if (eq? choice :odd)
					       nodd-min-peak-phases
					       (if (eq? choice :even)
						   neven-min-peak-phases
						   primoid-min-peak-phases))))))
	  (if (and (number? min-val)
		   (< min-val cur-min))
	      (set! cur-min min-val)))

	(let ((nc (if (eq? choice :all) 0
		      (if (eq? choice :odd) 1
			  (if (eq? choice :even) 2 3)))))

	  (run 
	   (lambda ()

	     (do ((try 0 (+ 1 try)))
		 ((= try tries))
	       (do ((i 1 (+ 1 i)))
		   ((= i n))
		 (if (> (random 1.0) 0.5)
		     (set! (phases i) pi)
		     (set! (phases i) 0.0)))
	       (clear-array fft-rl)
	       (clear-array fft-im)
	       
	       (do ((k 0 (+ k 1)))
		   ((= k n))
		 (let ((phi (+ (phases k) pi2))
		       (bin (if (= nc 0) (+ k 1)
				(if (= nc 1) (+ 1 (* k 2))
				    (if (= nc 2) (max 1 (* k 2))
					(low-primes k))))))
		   (set! (fft-rl bin) (cos phi))
		   (set! (fft-im bin) (sin phi))))
	       
	       (let ((peak (vct-peak (mus-fft fft-rl fft-im size -1))))
		 (if (< peak cur-min)
		     (begin
		       (save-case n choice peak phases)
		       (format #t ";~A: ~A ~A #(" n choice peak)
		       (do ((m 0 (+ 1 m)))
			   ((= m n))
			 (if (zero? (phases m))
			     (format #t "0")
			     (format #t "1"))
			 (if (< m (- n 1))
			     (format #t " ")))
		       (format #t ")~%")
		       (set! cur-min peak))))
	       )))))))

  (set! (mus-rand-seed) (current-time))
  (try-any))

(define* (try-all (num-threads 2) (data "test.data"))
  (set! data-file data)
  (let ((threads '()))
    (do ((i 0 (+ i 1)))
	((= i num-threads))
      (set! threads (cons (make-thread try-any) threads)))
    (for-each 
     (lambda (thread) 
       (join-thread thread))
     threads)))

;;; then once a new local minimum is found,
(define (optit choice n)
  (let* ((size (get-fft-size choice n))
	 (fft-rl (make-vct size))
	 (fft-im (make-vct size)))

      (let* ((phases (make-vct n 0.0))
	     (min-phase 0.0)
	     (min-phases (make-vector n 0)))
	(let* ((min-val (vector-find-if (lambda (val)
					  (and val
					       (vector? val)
					       (= (val 0) n)
					       (let ((a-val (val 1))
						     (a-len (vector-length val))
						     (a-data (val 2)))
						 (do ((k 3 (+ 1 k)))
						     ((= k a-len))
						   (if (and (number? (val k))
							    (< (val k) a-val))
						       (begin
							 (set! a-val (val k))
							 (set! a-data (val (+ k 1))))))
						 (list a-val a-data))))
					(if (eq? choice :all)
					    noid-min-peak-phases
					    (if (eq? choice :odd)
						nodd-min-peak-phases
						(if (eq? choice :even)
						    neven-min-peak-phases
						    primoid-min-peak-phases)))))
	       (cur-min (car min-val))
	       (cur-phases (cadr min-val)))

	  (set! min-phase cur-min)
	  ;(format #t "~A ~A: ~A~%" choice n cur-min)

	  (let ((nc (if (eq? choice :all) 0
			(if (eq? choice :odd) 1
			    (if (eq? choice :even) 2 3))))
		(inc 1))

	    (do ()
		((> inc 1))

	      (do ((i 1 (+ i 1)))
		  ((= i n))
		(let ((old-val (cur-phases i)))
		  (do ((k 0 (+ k 1)))
		      ((> k inc))
		    (if (not (= old-val (/ k inc)))
			(begin
			  (set! (cur-phases i) (/ k inc))

			  (clear-array fft-rl)
			  (clear-array fft-im)
	       
			  (do ((m 0 (+ m 1)))
			      ((= m n))
			    (let ((phi (+ (* pi (cur-phases m)) pi2))
				  (bin (if (= nc 0) (+ m 1)
					   (if (= nc 1) (+ 1 (* m 2))
					       (if (= nc 2) (max 1 (* m 2))
						   (low-primes m))))))
			      (set! (fft-rl bin) (cos phi))
			      (set! (fft-im bin) (sin phi))))
	       
			  (let ((peak (vct-peak (mus-fft fft-rl fft-im size -1))))
			    (if (< peak min-phase)
				(begin
				  (do ((m 0 (+ 1 m)))
				      ((= m n))
				    (set! (min-phases m) (cur-phases m)))
				  (set! min-phase peak))))

			  (set! (cur-phases i) old-val))))))

	      ;(format #t "~D: ~A~%" inc min-phase)

	      (if (< min-phase (- cur-min .001))
		  (begin
		    (do ((m 0 (+ m 1)))
			((= m n))
		      (set! (cur-phases m) (min-phases m)))
		    (set! cur-min min-phase)
		    (if (= inc 1)
			(format #t ";~A: ~A ~A ~A~%" n choice cur-min cur-phases)))
		  (begin
		    (set! inc (* inc 2))))))


	  ;(format #t ";~A: ~A ~A ~A~%" n choice cur-min cur-phases)
	  ))))
|#



(define (tstodd phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 2)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstoddderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 2)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (tstall phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallf mult phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (if (= k (- len 1))
	      (set! val (+ val (* mult (sin (+ (* j x) (* pi (phs k)))))))
	      (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tsteven phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstprime phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (primes k) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 1)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (get-best choice n)

  (define (vector-find-if func vect)
    (let ((len (vector-length vect))
	  (result #f))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       result)
	   result)
	(set! result (func (vect i))))))

  (vector-find-if (lambda (val)
		    (and val
			 (vector? val)
			 (= (val 0) n)
			 (let ((a-val (val 1))
			       (a-len (vector-length val))
			       (a-data (val 2)))
			   (do ((k 3 (+ 1 k)))
			       ((= k a-len))
			     (if (and (number? (val k))
				      (< (val k) a-val))
				 (begin
				   (set! a-val (val k))
				   (set! a-data (val (+ k 1))))))
			   (list a-val a-data))))
		  (if (eq? choice :all)
		      noid-min-peak-phases
		      (if (eq? choice :odd)
			  nodd-min-peak-phases
			  (if (eq? choice :even)
			      neven-min-peak-phases
			      primoid-min-peak-phases)))))

(define (get-worst-overall choice choices)
  (let ((diffs (make-vector 116))
	(total 0.0)
	(this 0.0)
	(last 0.0)
	(next 0.0)
	(choice-list '())
	(first (car (get-best choice 11))))
    (set! this first)
    (set! next (car (get-best choice 12)))
    (do ((i 12 (+ i 1)))
	((= i 128))
      (set! last this)
      (set! this next)
      (set! next (car (get-best choice (+ i 1))))
      (set! (diffs (- i 12)) (cons i (+ (- this last) (- this next))))
      (set! total (+ total (abs (- this last)))))
    (sort! diffs (lambda (a b)
		   (> (cdr a) (cdr b))))
    (do ((i (- choices 1) (- i 1)))
	((< i 0))
      (let ((c (diffs i)))
	(set! choice-list (cons (diffs i) choice-list))))

    (list choice-list (- (+ total first) this)))) ; first to this would be a straight line



(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results '()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall #(0.0 0.1 0.2 0.3))) #(0.0 0.1 0.2 0.3))
;;; 3.49630991 #(0.0 1.1 0.2 1.3)
;;; 3.49630680 #(0.0 1.9 1.8 1.7)
;;; 3.49630979 #(0.0 0.9 1.8 0.7)

(set! (print-length) 123123)

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadr (car other-mins)))
	    (pk3 (cadr (cadr other-mins)))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (car (car other-mins)) (car data))) .001)
		(> (abs (- (car (cadr other-mins)) (car data))) .001)
		(> (abs (- (car (caddr other-mins)) (car data))) .001))
	    (format #t "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (a 1) (b 1))))))
	  (format #t "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (car data)
		  (list-ref phases 0)
		  (list-ref phases 1)
		  (list-ref phases 2)
		  (list-ref phases 3)
		  ))))))

;; (09)
;; 1 Mar 5446.42,  0.576  
;; 1 Apr 5405.890, 0.575
;; 1 May 5138.261, 0.562
;; 1 Jun 5061.829, 0.558
;; 1 Jul 4669.101, 0.540
;; 1 Aug 4633.454, 0.539
;; 1 Sep 4616.517, 0.538
;; 1 Oct 4592.994, 0.537
;; 1 Nov 4560.903, 0.536
;; 1 Dec 4541.710, 0.535
;; (10)
;; 1 Jan 4360.644, 0.527
;; 1 Feb 4292.451, 0.524
;; 1 Mar 4280.782, 0.524
;; 1 Apr 4272.964, 0.523
;; 1 May 4267.719, 0.523
;; 1 Jun 4261.356, 0.523
;; 1 Jul 4244.312, 0.5223, sqrts: 82 74 0 0

;    all 0.4861 (20) to 0.5076 (94), dist: 6.3076
;    odd 0.4821 (11) to 0.5092 (125), dist: 12.0591
;    even 0.5158 (64) to 0.5244 (22), dist: 86.9326
;    prime 0.5449 (24) to 0.5712 (117), dist: 288.4718

;    all 0.4861 (20) to 0.5070 (94), dist: 5.6759
;    odd 0.4821 (11) to 0.5061 (119), dist: 7.2783
;    even 0.5158 (64) to 0.5244 (22), dist: 86.5343
;    prime 0.5449 (24) to 0.5712 (117), dist: 288.4718

;    all 0.4861 (20) to 0.5054 (94), dist: 5.4534
;    odd 0.4821 (11) to 0.5058 (104), dist: 6.1241
;    even 0.5103 (99) to 0.5244 (22), dist: 71.2569
;    prime 0.5449 (24) to 0.5712 (117), dist: 288.3946


;(test-all-phases #f) in test-phases.scm

;all peaks... Mon 31-May-2010 04:17
;all 512: peak-phases value: 31.391244, current: 31.393507890848, diff: 0.0022638908477184
;all 1024: peak-phases value: 49.867216, current: 49.863543040531, diff: -0.0036729594690925
;odd peaks... Mon 31-May-2010 05:20
;odd 2048: peak-phases value: 78.937441, current: 78.931916185936, diff: -0.0055248140642448
;even peaks... Mon 31-May-2010 06:17
;even 256: peak-phases value: 21.147051, current: 21.149844044205, diff: 0.0027930442051805
;even 512: peak-phases value: 31.628149, current: 31.625265493922, diff: -0.0028835060781311
;even 1024: peak-phases value: 51.627202, current: 51.61731817532, diff: -0.0098838246798678
;even 2048: peak-phases value: 78.079325, current: 78.055349684919, diff: -0.023975315080548
;prime peaks... Mon 31-May-2010 07:15
;prime 256: peak-phases value: 25.419292, current: 25.416395401039, diff: -0.0028965989614846
;all done! Mon 31-May-2010 07:51

;; same on 15-Jun

;;; gad161: clean-up-evens
;;; t139.scm: show-circles
