(provide 'snd-peak-phases.scm)

;;; multiply these phases by pi before use as initial-phases (assuming sin, not cos)


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

#(1  1.0    #(0))
#(2  1.76   #(0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots (vct -2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works at least up to n=25, but as n increases, it gets slower than the fft method
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the 1st min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 globals mins (?)
;;   so it's messier.


;; there's always an equivalent point made by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are always 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
#(3  2.1949383250709 #(0 0 1)
     1.980  #(0 23/39 6/19) #(0 16/39 32/19) #(0 62/39 6/19) #(0 55/39 32/19) #(0 31/22 37/22) #(0 62/39 13/41)
     ; 1.9813625706774 #(0 13 7) / 22 and  #(0 35 7) / 22
     
     1.9802151918411 #(0.000 0.410 1.684)
     1.9802151918411 #(0.000 1.410 1.684)

     1.9798054823226 #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
					;23/39 off by 1.8477e-5, 19/60 off by -9.0266e-7
					;peak at 0.17147 where the derivative is -4.6267285455666e-5

     1.9798054823222 #(0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
					;16/39 off by -1.8477e-5, 101/60? off by 9.0266e-7
					;peak at 2.97013 == (pi - 0.17147), derivative -4.4812555616459e-5

     1.9798054823226 #(0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
					;peak at 3.31306 == (pi + 0.17147), derivative 1.3368429443e-5

     1.9798054823222 #(0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)
					;peak at 6.1117199 == (2*pi - .17147), derivative 1.19129036e-5

     ;; :(tstall '#(0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for #(0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 #(0.0 0.41022177723939 1.6832780274654)
     1.979716725384 #(0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 #(0.0 1.4102202429311 1.6832728267862)

     ;; (tstall #(0.0 1.4102202429311 1.6832728267862))
     ;; (1.979895962058785337822509972532849883204E0 3.8715000000037)
     ;; so our fft is at its accuracy limit
     )


;;; 4 all --------------------------------------------------------------------------------
#(4  2.2962718935302 #(0 1 1 1)

     2.040  #(0 33/35 67/50 10/9)               ;#(0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 #(0.000 0.072 0.674 1.912)
     2.04012799263 #(0.000 0.928 1.326 1.088)
     2.04012799263 #(0.000 1.072 0.674 0.912)
     2.04012799263 #(0.000 1.928 1.326 0.088)

     2.0392323180235 #(0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 #(0.000000 0.944585 1.341508 1.115059)
     2.038954 #(0.000000 1.055406 0.658486 0.884929)
     2.038954 #(0.000000 0.055405 0.658485 1.884926)
     2.038954 #(0.000000 1.944593 1.341515 0.115071)
     )

;;; 5 all -------------------------------------------------------------------------------- ; sqrt 2.23
#(5  2.5405211753511 #(0 1 0 0 0)

     2.376853465095 #(0 15/16 119/64 19/128 0)
     2.3743295205821 #(0 121/128 15/8 11/64 3/128)

     2.3434929847717 #(0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 #(0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 #(0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 #(0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 #(0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 #(0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 #(0.000000 0.154687 0.335490 1.579647 0.406677)
     )

;;; 6 all -------------------------------------------------------------------------------- ; sqrt 2.4494
#(6  2.8200183503167 #(0 0 0 0 1 0) 

     2.6405220031738 #(0 5/32 15/8 59/32 15/16 1/16)
     2.6112613677979 #(0 17/128 239/128 235/128 59/64 5/128) ; inc=128 2.604 after optit
     2.557  #(0 55/62 9/35 57/44 29/22 38/33)

     2.5598928928375 #(0.0 0.91140931844711 0.34124284982681 1.3568490743637 1.4451304674149 1.2563138008118)
     2.5509102344513 #(0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 #(0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 #(0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 #(0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 #(0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 #(0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     )

;;; 7 all -------------------------------------------------------------------------------- ; sqrt is 2.64575
#(7  3.072141248417 #(0 0 0 1 1 0 1)

     2.639426 #(0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 #(0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 #(0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 #(0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; sqrt is 2.8284
#(8  3.5725696916739 #(0 1 0 0 0 0 1 1)
     3.4905790371793 #(0 1 0 0 1 1 1 0)

     2.795099 #(0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794973 #(0.000000 0.666912 0.808057 1.605873 0.837778 0.045418 0.145384 -0.125627)
     2.794748 #(0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 #(0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 #(0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     )

;;; 9 all --------------------------------------------------------------------------------
#(9  3.7118878501776 #(0 0 0 0 1 0 0 0 1)
     3.5954569026984 #(0 1 1 0 1 0 1 1 1)

     3.1710622310638 #(0.0 0.375 0.5 0.75 1.875 0.625 1.625 1.375 0.875)
     3.1656680107117 #(0.0 0.125 0.625 0.625 0.125 0.125 1.0 1.875 1.125)

     2.962087 #(0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 #(0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 #(0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 #(0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 #(0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)

     ;; path: 3.0087241829757 #(0.0 0.77295770138686 1.1137612131151 0.0092274358540839 1.4396553239915 0.47716799765798 0.36807992765151 0.44487578109891 0.066114145077038)
     )

;;; 10 all -------------------------------------------------------------------------------- ; sqrt is 3.162
#(10 3.8132503352626 #(0 1 0 1 0 0 0 0 0 1)
     3.7726427002737 #(0 1 1 0 0 0 0 1 0 1)
     3.7587492407668 #(0 1 1 0 1 1 1 0 0 0)
     3.7587492407668 #(0 0 1 1 1 0 1 1 0 1)

     3.3037643432617 #(0.0 0.0 0.25 0.375 1.875 0.0 0.75 1.5 0.75 0.125) ; 4(2)

     3.102964 #(0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 #(0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 #(0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 #(0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102729 #(0.000000 -0.072172 1.602638 1.494434 -0.054524 1.785698 0.940876 0.169981 0.895530 1.495531)
     )

;;; 11 all -------------------------------------------------------------------------------- ; sqrt is 3.31662
#(11 4.0969838225299 #(0 0 1 1 0 0 0 0 1 0 1)
     4.0506916989601 #(0 0 0 1 1 1 1 0 1 1 0)
     3.8018732822274 #(0 1 0 0 1 0 0 0 1 1 1)
     3.8018732822274 #(0 0 0 1 1 1 0 1 1 0 1)

     3.2642121315002 #(0 21/16 123/64 9/8 9/64 1/64 27/16 127/64 1/4 75/64 77/64)
     3.2556438446045 #(0 21/16 123/64 9/8 9/64 1/64 217/128 127/64 33/128 75/64 39/32)

     3.218779 #(0.000000 1.481192 0.090871 1.382649 0.458289 0.338680 0.056042 0.328676 0.834049 1.786486 1.800056)
     3.218587 #(0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 #(0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)

     ;; tstall:
     3.218745  #(0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     )

;;; 12 all -------------------------------------------------------------------------------- ; sqrt 3.464
#(12 3.761           #(0 0 1 1 0 0 0 0 0 1 0 1)
     3.7616552322386 #(0 1 1 0 0 1 0 1 0 0 0 0)

     3.6464369297028 #(0 15/8 15/16 7/8 29/16 0 1/16 31/16 0 1 1/16 1) 
     3.5718913078308 #(0 15/8 15/16 13/16 29/16 0 1/8 61/32 1/32 1 1/32 1)
     3.5329611301422 #(0 61/32 29/32 97/128 239/128 1/32 5/32 121/64 1/32 31/32 1/32 63/64)

     3.390214 #(0.000000 1.090729 0.365806 1.643109 0.802167 1.224244 0.152508 0.190760 1.518783 1.662203 1.561813 -0.056814)
     3.389584 #(0.000000 0.081158 0.353056 0.623087 0.775861 0.199327 0.127597 1.160276 1.479330 0.612404 1.515935 0.889377)
     3.389586 #(0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 #(0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389445 #(0.000000 1.081147 0.353060 1.623322 0.776726 1.200314 0.128521 0.161048 1.479959 1.613277 1.517191 1.889839)
     )

;;; 13 all -------------------------------------------------------------------------------- ; sqrt 3.6055
#(13 4.2969298731102 #(0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.1211657406183 #(0 0 0 0 0 0 1 1 0 0 1 0 1) 

     4.019  #(0 1/28 135/86 56/37 107/54 1/17 37/55 10/69 61/33 25/28 17/11 3/8 82/53)

     3.5426704 #(0.000000 1.884492 1.746295 1.269047 1.431366 1.353118 -0.047229 1.765818 0.773088 0.649022 1.690846 0.531435 1.066736)
     3.525309 #(0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 #(0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 #(0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 #(0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)
     )

;;; 14 all -------------------------------------------------------------------------------- ; sqrt 3.7416
#(14 4.3461865728938 #(0 0 1 1 0 1 0 1 1 0 0 0 0 0)
     4.1603193984251 #(0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     4.1130089759827 #(0 1 1/8 1 17/16 0 15/16 0 0 0 1 0 0 0)
     4.0361981391907 #(0 1 1/8 37/32 19/16 1/32 7/8 1/16 1/32 1/16 1 1/16 1/32 0)

     3.615056 #(0.000000 -0.014234 1.497005 1.525139 0.510798 0.632906 1.943720 0.571193 0.639383 0.229407 1.337049 0.146893 1.848962 0.407090)
     3.614834 #(0.000000 1.020766 1.572890 0.581134 0.603538 1.774599 0.065414 1.723556 0.833691 1.415522 1.539294 1.378756 0.117184 1.703181)
     3.614395 #(0.000000 1.020574 1.571934 0.581086 0.602938 1.774086 0.065638 1.724213 0.833365 1.415404 1.539595 1.379505 0.117705 1.702518)
     )

;;; 15 all -------------------------------------------------------------------------------- ; sqrt 3.8729
#(15 4.4060654286219 #(0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; sqrt 3.87298 (3.8729833462074)

     3.8280912 #(0.000000 1.291329 1.191272 0.601514 0.260378 0.201206 0.939117 1.629230 -0.151581 0.978580 -0.006025 1.462117 -1.984689 1.582123 -0.088546)
     3.770652 #(0.000000 0.856688 1.057943 1.629743 0.251217 0.260201 1.709080 1.015131 0.955058 -0.061779 1.043563 1.608751 1.135828 1.575732 1.328957)
     )

;;; 16 all --------------------------------------------------------------------------------
#(16 4.6832396970099 #(0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)
     4.5445760745314 #(0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.880044 #(0.000000 1.305525 1.470275 0.177035 0.840097 1.175803 -0.045240 1.607574 1.078362 0.676837 1.296177 0.358482 1.543390 0.161953 0.029701 -1.946850)
     3.876898 #(0.000000 0.734988 0.689889 1.209151 1.647343 1.292049 0.008798 1.495359 0.553434 0.233079 -0.130165 -0.076890 1.356540 1.664124 0.292572 1.458028)
     3.876341 #(0.000000 0.735074 0.689531 1.208604 1.647605 1.292213 0.008225 1.494898 0.553708 0.233224 -0.129832 -0.076586 1.356224 1.663920 0.291742 1.458176)
     )

;;; 17 all -------------------------------------------------------------------------------- ; sqrt 4.1231
#(17 4.7478643837553 #(0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1)
     4.7478643837553 #(0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1)
     4.7654988506492 #(0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)
     4.7654988506492 #(0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1)

     4.042218 #(0.000000 1.195245 1.847767 0.807893 1.771163 0.686263 0.384018 0.222746 0.065845 0.751171 0.175055 0.107773 0.968939 1.308336 1.526357 0.336423 0.094154)
     4.029589 #(0.000000 1.390548 0.919347 1.765666 1.162578 0.778237 1.059194 0.502728 0.167163 0.780385 1.497520 0.340206 0.770821 0.381212 0.966250 1.199209 1.322634)
     4.017899 #(0.000000 1.479970 1.057622 -0.085800 1.384872 1.017795 1.307011 0.757174 0.439788 1.138570 1.890560 0.727755 1.257431 0.860567 1.517231 -0.248976 -0.059672)
     4.017711 #(0.000000 1.479345 1.057587 -0.086152 1.384196 1.018294 1.306858 0.756770 0.439258 1.138409 1.890306 0.728188 1.256651 0.860567 1.517128 -0.249565 -0.060066)
     )

;;; 18 all -------------------------------------------------------------------------------- ; sqrt 4.24264
#(18 4.9109328272248 #(0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0)
     4.8247395547715 #(0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0)
     4.795  #(0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.181072 #(0.000000 0.733865 1.755150 -0.039048 1.400407 1.137000 -0.062504 1.403348 1.122213 0.924200 1.871024 0.635965 1.614137 1.365947 1.630714 0.017679 0.536900 0.251135)
     4.160068 #(0.000000 1.247966 0.634845 0.085105 1.281747 1.591288 0.560708 1.554818 0.532041 1.253325 0.973787 0.305025 0.369962 0.426191 -0.060193 0.478556 0.689072 1.025864)
     4.159534 #(0.000000 0.770318 1.379876 -0.058303 0.759899 0.446188 1.503325 0.518439 1.548719 0.824444 1.108988 1.787903 1.708197 1.681675 0.181913 1.635102 1.446906 1.120460)
     4.158657 #(0.000000 0.770550 1.380268 -0.059022 0.759528 0.445699 1.502507 0.518175 1.547659 0.823381 1.109484 1.787736 1.708000 1.680837 0.182214 1.634604 1.446996 1.120287)
     )

;;; 19 all -------------------------------------------------------------------------------- ; sqrt 4.35889
#(19 5.0964118877766 #(0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 0 0 0 1)
     5.0269187181249 #(0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0)
     5.0140104455275 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0)
     4.957  #(0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.272792 #(0.000000 0.528850 1.104907 0.786742 1.698800 1.643330 0.403916 0.572722 1.831151 0.901802 0.711706 1.370304 0.255803 1.697269 1.579317 1.383837 1.486610 0.855160 1.543014)
     4.271408 #(0.000000 0.980833 1.119247 1.843928 0.333756 0.545165 1.491444 1.292732 0.996055 0.300697 0.430517 0.997795 0.740513 0.655436 1.157955 0.447167 1.357422 0.125011 1.657077)
     4.270700 #(0.000000 0.980515 1.118986 1.844045 0.333641 0.545802 1.491563 1.292475 0.996666 0.301136 0.431052 0.997512 0.740017 0.656039 1.158018 0.447519 1.356537 0.125806 1.656450)
     )

;;; 20 all -------------------------------------------------------------------------------- ; sqrt 4.4721
#(20 5.2602326468873 #(0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1)
     5.2536671092168 #(0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1) 
     5.2516581503036 #(0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1)
     5.2027356749364 #(0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0) 
     5.202707605727 #(0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)
     5.182  #(0 31/36 16/11 36/35 48/43 3/22 46/29 14/17 97/63 24/37 48/25 31/94 18/35 3/19 5/22 119/95 32/35 1/40 18/55 10/17)
     4.9199514389038 #(0 1/16 5/16 1/16 9/8 1 3/16 13/16 0 0 1 0 1 15/16 17/16 1/8 17/16 1 17/16 0)

     4.297247 #(0.000000 1.260509 1.478091 -0.190590 1.858221 0.288517 0.174235 -0.025277 0.859625 1.179709 0.011397 0.366301 1.688940 1.449201 1.217601 -0.054086 1.150844 0.602775 1.168795 0.359804)
     4.294128 #(0.000000 1.259973 1.472393 -0.196164 1.849135 0.277908 0.175747 -0.038528 0.857321 1.180070 0.008736 0.358344 1.681666 1.447220 1.224459 -0.058329 1.158421 0.599628 1.170245 0.349978)
     4.292383 #(0.000000 1.279021 1.463542 -0.184603 1.844129 0.259705 0.193110 -0.049933 0.853883 1.192503 -0.000582 0.351845 1.699723 1.469815 1.245719 -0.040796 1.182535 0.595179 1.185477 0.362308)
     )

;;; 21 all -------------------------------------------------------------------------------- ; sqrt 4.5825
#(21 5.3651112556805 #(0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1)
     5.3503630356826 #(0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1)
     5.3430035169068 #(0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1)
     5.3468859417495 #(0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1)
     5.3164971341632 #(0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 0) 
     5.3164971341632 #(0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     4.502463 #(0.000000 1.403052 1.255480 1.307876 -0.000285 1.470554 -0.213424 1.608180 0.222059 1.114300 0.369365 1.844087 1.125963 1.022420 1.573231 0.604368 0.683620 0.387557 0.810080 1.652087 0.004804)
     4.491591 #(0.000000 1.403287 1.257329 1.319102 0.002521 1.468531 -0.205450 1.588790 0.209415 1.101797 0.368252 1.838138 1.108179 1.040778 1.583528 0.603918 0.687287 0.380505 0.816420 1.657265 0.005570)
     )

;;; 22 all -------------------------------------------------------------------------------- ; sqrt 4.6904
#(22 5.3384906472168 #(0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     5.3118962410791 #(0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0)
     5.29249935509144 #(0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1) 
     5.292244006282 #(0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     4.622803 #(0.000000 1.340373 0.970954 1.002159 0.880275 1.416080 1.819200 1.007752 0.255081 0.347189 0.600359 0.574629 0.015990 0.999438 1.635477 0.619917 0.631959 1.121023 0.599154 1.883352 0.740818 1.129065)
     4.595560 #(0.000000 -0.078095 1.091185 0.606152 -0.217468 1.052185 0.751097 1.956091 0.022781 0.329329 1.216040 1.065645 1.133116 1.132504 1.517540 0.989263 0.974365 1.531213 0.464543 1.655862 0.463640 1.174495)
     4.591982 #(0.000000 -0.086851 1.094579 0.612847 -0.225564 1.052241 0.748697 1.954229 0.023159 0.332205 1.213921 1.064392 1.125288 1.130676 1.516743 0.987296 0.975094 1.525802 0.462206 1.659880 0.468915 1.177291)
     )

;;; 23 all -------------------------------------------------------------------------------- ; sqrt 4.7958
#(23 5.5572876930237 #(0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0)
     5.35928895203514 #(0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1) 
     5.3592889520338 #(0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.625696 #(0.000000 0.671135 -0.214297 0.258444 1.216101 0.901738 0.160505 1.484022 1.379069 0.829978 0.350531 0.609142 0.578677 -0.009954 1.031616 1.661844 1.545884 0.031485 0.259930 1.310637 0.037362 -0.114212 0.110243)
     4.613277 #(0.000000 0.668983 -0.208470 0.254349 1.217866 0.914011 0.163047 1.477792 1.369464 0.833712 0.351294 0.598607 0.574330 -0.009251 1.047992 1.662129 1.550991 0.040281 0.262513 1.321685 0.044892 -0.113023 0.128555)
     )

;;; 24 all -------------------------------------------------------------------------------- ; sqrt 4.89897
#(24 5.7082858085632 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0)
     5.6697635650635 #(0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     5.6446962356567 #(0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0)
     5.635  #(0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1) 
     5.6358969066981 #(0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.898310 #(0.000000 0.289908 1.243053 1.316260 0.981048 -0.015828 0.087983 -0.141851 0.850507 1.125166 0.207133 1.191771 1.184999 -0.031777 0.021164 1.511848 0.441664 1.474001 0.734003 0.462184 0.869525 0.377835 0.501468 0.555313)
     4.801023 #(0.000000 1.831695 1.320777 1.197748 0.233237 0.367738 -0.002029 0.193745 1.146112 1.719131 0.299954 1.023025 0.925835 0.702485 0.169264 0.790783 0.786532 0.343760 1.444803 0.532865 1.747331 0.369772 0.150730 0.745265)
     4.753639 #(0.000000 1.843887 1.339328 1.246130 0.253074 0.373645 -0.000750 0.230110 1.128370 1.734640 0.309459 1.044439 0.960759 0.694789 0.162108 0.791878 0.758111 0.357004 1.451796 0.511430 1.736859 0.362143 0.148207 0.764704)
     )

;;; 25 all -------------------------------------------------------------------------------- ; sqrt 5
#(25 5.7284736633301 #(0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0)
     5.7190117835999 #(0 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1)
     5.646619352206 #(0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0) 
     5.646619352206 #(0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.948398 #(0.000000 1.686765 1.762710 1.532195 0.085851 0.266079 1.489375 0.115086 0.757502 0.552909 0.292603 1.861685 0.311415 1.400027 1.667706 1.732975 1.674925 0.489022 0.298773 1.259968 1.553419 0.784088 1.716599 1.134221 0.281750)
     4.948133 #(0.000000 1.017449 0.206814 1.069041 1.478866 -0.395547 1.342461 -0.005382 1.343012 1.463276 1.395370 1.627041 1.911452 0.743332 0.784726 1.590023 0.492977 1.010516 1.941282 1.678821 0.191562 1.647820 0.872032 0.853004 0.403096)
     4.926905 #(0.000000 0.355954 1.212496 1.402938 1.466374 1.630894 0.210471 1.061533 1.091242 1.129379 0.833926 0.982335 1.701199 0.187178 1.388909 1.608424 1.095499 0.130794 0.020607 1.528740 0.434794 0.092721 1.110061 -0.157890 1.038455)
     4.909833 #(0.000000 0.187589 1.768578 0.501542 0.009167 0.037917 0.364211 0.868264 0.590722 0.727787 0.060334 0.804275 0.551751 -0.078031 -0.058109 1.656481 0.518721 0.858245 1.392346 0.648581 1.847905 1.307763 1.744318 0.564847 0.992149)
     4.884758 #(0.000000 0.200204 1.764079 0.493998 0.017747 0.017726 0.387590 0.857472 0.587655 0.710100 0.049044 0.813205 0.543754 -0.082659 -0.071049 1.663133 0.533326 0.861598 1.394024 0.647222 1.829506 1.311469 1.747264 0.585833 0.979137)
     )

;;; 26 all -------------------------------------------------------------------------------- ; sqrt 5.0990
#(26 5.8922033309937 #(0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0)
     5.8206262588501 #(0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0)
     5.78661186695166 #(0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1) 
     5.7865648269653 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     5.110649 #(0.000000 0.774777 0.723600 0.351434 0.506245 1.753401 -0.041710 0.654578 0.924416 0.592060 0.124977 1.725460 0.568638 0.292303 -0.029411 0.650921 1.229026 1.335950 1.218484 1.435408 0.895624 1.655178 0.450508 1.542149 0.782878 -0.005138)
     5.026535 #(0.000000 0.473345 0.419439 0.856181 1.363957 -0.141403 1.638549 0.164154 1.829869 0.591599 1.694690 0.411050 1.100290 1.468792 1.239268 1.168617 0.829414 0.936272 0.139582 -0.244904 1.260854 1.063564 -0.149522 1.648159 0.947857 1.702598)
     )

;;; 27 all -------------------------------------------------------------------------------- ; sqrt 5.1961
#(27 5.980658531189 #(0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     5.8753982451551 #(0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0) 
     5.8753981590271 #(0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.198693 #(0.000000 1.168670 0.246753 0.527351 1.555827 0.930074 0.702478 1.853770 0.731175 -0.145926 0.842011 0.634271 1.628409 1.399866 1.392022 1.357129 0.254987 0.567359 0.102270 0.542512 1.655944 1.537226 -0.001419 0.809036 1.555787 1.627118 1.879787)
     5.110510 #(0.000000 1.291889 0.644395 1.565548 0.436498 1.638155 1.141915 1.621861 1.159339 1.037283 1.551398 1.339013 0.604588 0.645654 1.822460 0.785756 0.610847 1.087568 1.524494 1.923690 1.578188 -0.032880 0.902907 1.386491 0.188433 0.154041 1.758936)
     5.082429 #(0.000000 1.190278 1.025779 -0.047540 0.942516 0.744088 0.037094 1.957935 1.582013 1.825836 1.922424 0.836322 0.487507 0.838188 0.545549 1.298803 0.793631 0.194333 0.413652 0.869353 1.151257 0.322086 0.467254 -0.082977 0.822061 1.639198 0.391390)
     5.071183 #(0.000000 1.189500 1.026464 -0.036198 0.943928 0.732298 0.040792 1.974405 1.572553 1.827324 1.918915 0.832445 0.488648 0.823731 0.558370 1.295814 0.803616 0.194478 0.410693 0.860464 1.150784 0.318382 0.472876 -0.084968 0.821892 1.640779 0.398969)
     )

;;; 28 all -------------------------------------------------------------------------------- ; sqrt 5.2915
#(28 6.1332263946533 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0)
     6.107029914856 #(0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     6.0962085723877 #(0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0) 
     6.0962085723877 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.272050 #(0.000000 0.837544 1.410175 1.495461 1.388617 0.228694 1.626211 0.304595 1.137637 1.604062 0.850263 0.891215 1.332759 1.857470 1.787330 1.710329 1.167422 1.316390 1.695411 0.680144 -0.154530 0.670048 0.528432 0.665364 0.034760 1.556133 0.659738 0.408156)
     5.264384 #(0.000000 0.833836 1.413443 1.497697 1.382920 0.225655 1.629056 0.300515 1.138867 1.604066 0.853911 0.894916 1.327645 1.859762 1.792286 1.715812 1.172040 1.312170 1.698662 0.675047 -0.159026 0.668427 0.532512 0.665631 0.039066 1.554813 0.657182 0.409686)
     5.247652 #(0.000000 0.825294 1.424476 1.495266 1.382409 0.227970 1.638970 0.289347 1.143773 1.605666 0.850500 0.896473 1.317689 1.872245 1.803082 1.720053 1.176409 1.298159 1.705092 0.662817 -0.150583 0.669357 0.538089 0.667879 0.052674 1.549436 0.656014 0.402852)
     )

;;; 29 all -------------------------------------------------------------------------------- ; sqrt 5.38516
#(29 6.2162199020386 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     6.2025485038757 #(0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1)
     6.1965684890747 #(0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 0)
     6.168496131897 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1) 
     6.168496131897 #(0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.409604 #(0.000000 1.767809 1.217983 0.979089 0.430325 0.036278 0.441581 1.665511 1.189460 -0.128887 1.502875 0.745628 1.601608 0.517181 0.036357 0.457912 1.349424 -0.001642 1.719071 1.724643 0.429053 0.537167 1.475607 0.844455 1.078000 1.577367 0.986387 0.817760 1.202290)
     5.335399 #(0.000000 1.166831 1.326181 0.919326 0.904875 0.391920 0.155640 -0.046408 1.779143 0.349492 0.995949 1.657018 0.720402 1.387534 1.260805 0.099824 1.772823 0.827227 1.512989 0.623469 0.428224 0.975285 0.951945 0.774234 -0.049109 0.844150 0.853893 0.775309 1.317984)
     5.331571 #(0.000000 1.447372 1.406300 0.964471 0.900657 1.774270 1.591565 0.871902 0.941047 1.363367 0.726694 0.412992 0.362570 0.927822 1.624265 0.167869 1.017481 1.306903 0.925643 1.403341 1.461822 1.615657 1.819289 0.791180 1.985077 1.031310 0.291987 1.299500 1.910864)
     5.305711 #(0.000000 1.457379 1.415809 0.960561 0.897253 1.785682 1.590778 0.887299 0.945975 1.354389 0.729204 0.427280 0.355836 0.914251 1.606150 0.176166 1.008381 1.318323 0.932158 1.405390 1.458184 1.629865 1.829883 0.789230 1.989464 1.044442 0.298988 1.273409 1.904716)
     )

;;; 30 all -------------------------------------------------------------------------------- ; sqrt 5.4772
#(30 6.3668465614319 #(0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1) 
     6.3080444335938 #(0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1)
     6.2868418693542 #(0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1)
     6.257221698761 #(0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.450819 #(0.000000 1.473053 0.322102 0.375752 1.336894 1.601170 0.409485 1.762080 0.600632 0.983962 -0.069966 -0.081038 0.273027 1.952099 0.168083 0.063430 0.600709 1.049974 0.748398 1.540249 0.834526 0.520591 1.809641 0.501165 1.506313 0.911989 0.317614 0.342477 1.700348 -0.102570)
     5.439028 #(0.000000 1.485251 0.312498 0.363253 1.339602 1.605442 0.408204 1.767719 0.594781 0.993646 -0.070384 -0.087463 0.258952 1.950022 0.170275 0.052950 0.604164 1.052906 0.741938 1.539997 0.825678 0.524404 1.800947 0.492785 1.505616 0.922883 0.319115 0.332449 1.714353 -0.104091)
     )

;;; 31 all -------------------------------------------------------------------------------- ; sqrt 5.56776
#(31 6.4448771476746 #(0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1) 
     6.3776631355286 #(0 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1)
     6.3353910446167 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)
     6.3243918418884 #(0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

     5.522815 #(0.000000 1.681463 0.832891 1.227707 0.035343 1.078452 1.648114 0.866097 0.981123 0.319148 -0.056896 1.450959 0.865942 1.106440 1.507971 0.449063 0.459103 0.602165 1.673007 0.981207 -0.004757 1.743067 0.328189 1.591804 0.507296 0.839131 1.104214 1.118795 0.606030 1.065738 1.174262)
     5.509022 #(0.000000 1.674828 0.832782 1.225411 0.026133 1.080144 1.652457 0.866537 0.980121 0.321568 -0.059307 1.464935 0.875048 1.095178 1.515797 0.453979 0.463252 0.597367 1.676260 0.971442 -0.007961 1.746112 0.329802 1.597855 0.516747 0.823799 1.106743 1.115924 0.605005 1.071565 1.165055)
     )

;;; 32 all -------------------------------------------------------------------------------- ; sqrt 5.65685
#(32 6.5261273384094 #(0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0)
     6.4710988998413 #(0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0)
     6.4671835899353 #(0 0 1 1 0 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0)
     6.4519599479542 #(0 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1)
     6.4451498985291 #(0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.651906 #(0.000000 1.406861 1.718396 0.095829 0.042486 0.036663 1.624234 1.050334 0.888959 0.603272 0.814136 1.450600 0.995853 1.289701 0.354180 0.750872 0.684781 0.539118 1.333288 0.156949 1.147049 0.722982 1.640783 0.526025 1.015492 0.937127 1.886652 0.044300 0.973937 0.157497 1.368313 1.138888)
     5.618040 #(0.000000 -0.384222 1.253587 -0.243804 0.445281 0.321640 0.406651 0.164636 0.221047 1.357651 0.232713 0.301462 0.129780 1.291567 1.823180 1.211024 1.740305 1.642979 0.450747 0.602190 0.919179 0.270509 1.815195 1.327938 0.543500 1.396755 1.810579 0.421634 0.686753 0.173629 0.830301 0.003461)
     5.579104 #(0.000000 -0.375307 1.256176 -0.247945 0.439871 0.333249 0.397334 0.152080 0.223166 1.367236 0.244480 0.303315 0.126466 1.296007 1.798980 1.207093 1.738816 1.673053 0.444943 0.628098 0.939370 0.291315 1.827774 1.352074 0.544598 1.389525 1.813194 0.440022 0.692972 0.153599 0.825050 0.002185)
     )

;;; 33 all -------------------------------------------------------------------------------- ; sqrt 5.74456
#(33 6.678719997406 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 0) 
     6.6342549324036 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1)
     6.6147227287292 #(0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0)
     6.5579299926758 #(0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.696526 #(0.000000 0.064180 0.462965 0.897385 0.563673 0.769660 1.885497 0.054977 0.095165 0.348596 1.490034 -0.009270 0.903689 1.279743 0.419149 0.673563 -0.018088 1.798522 0.448703 0.259713 0.763439 0.499255 -0.115570 0.834915 0.614178 1.278346 1.627105 1.180831 0.212487 1.315591 1.641309 1.130103 0.551918)
     5.683085 #(0.000000 0.062927 0.475256 0.896612 0.568851 0.774079 1.896984 0.051557 0.095458 0.351349 1.480240 -0.008232 0.913817 1.279988 0.414060 0.677439 -0.028746 1.805949 0.427064 0.254073 0.768612 0.491917 -0.119814 0.847251 0.614802 1.279408 1.617037 1.170667 0.223012 1.307567 1.651871 1.123439 0.558797)
     )

;;; 34 all -------------------------------------------------------------------------------- ; sqrt 5.8309518
#(34 6.7310481071472 #(0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
     6.7281470298767 #(0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.7141165733337 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0)
     6.6820402145386 #(0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 0)
     6.6788883209229 #(0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0)
     6.6782836914062 #(0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.887016 #(0.000000 1.785978 1.797747 0.207822 0.006914 0.541728 1.369425 0.218043 1.615429 0.591670 1.535256 1.970861 -0.188437 1.001256 1.023083 0.654598 0.352727 0.680541 0.368665 -0.186542 0.617717 0.127992 1.206315 0.952780 0.108961 1.766747 -0.067624 0.627672 0.810640 0.017241 0.611465 1.694301 0.028689 0.490363)
     5.811741 #(0.000000 1.540671 0.245655 0.252498 1.027917 0.304151 0.922762 1.522093 1.526736 0.752216 1.666078 0.121834 1.196597 0.231178 1.370571 0.667531 0.771243 1.805250 1.063659 1.315893 1.055642 0.617009 1.702629 1.387731 -0.593478 1.311751 1.459695 1.394024 0.599388 0.616472 0.914091 -0.135298 -0.077227 0.572280)

    ;; #(0.0 0.459329 1.754345 1.747502 0.972083 1.695849 1.077238 0.477907 0.473264 1.247784 0.333922 1.878166 0.803403 1.768822 0.629429 1.332469 1.228757 0.19475 0.936341 0.684107 0.944358 1.382991 0.297371 0.612269 0.593478 0.688249 0.540305 0.605976 1.400612 1.383528 1.085909 0.135298 0.077227 1.42772)
    ;; #(0.0 0.540671 0.245655 1.252498 1.027917 1.304151 0.922762 0.522093 1.526736 1.752216 1.666078 1.121834 1.196597 1.231178 1.370571 1.667531 0.771243 0.80525 1.063659 0.315893 1.055642 1.617009 1.702629 0.387731 -0.593478 0.311751 1.459695 0.394024 0.599388 1.616472 0.914091 0.864702 -0.077227 1.57228)
    ;; #(0.0 1.459329 1.754345 0.747502 0.972083 0.695849 1.077238 1.477907 0.473264 0.247784 0.333922 0.878166 0.803403 0.768822 0.629429 0.332469 1.228757 1.19475 0.936341 1.684107 0.944358 0.382991 0.297371 1.612269 0.593478 1.688249 0.540305 1.605976 1.400612 0.383528 1.085909 1.135298 0.077227 0.42772)
    ;; #(0.0 1.540671 0.245655 0.252498 1.027917 0.304151 0.922762 1.522093 1.526736 0.752216 1.666078 0.121834 1.196597 0.231178 1.370571 0.667531 0.771243 1.80525 1.063659 1.315893 1.055642 0.617009 1.702629 1.387731 -0.593478 1.311751 1.459695 1.394024 0.599388 0.616472 0.914091 -0.135298 -0.077227 0.57228)

     5.798297 #(0.000000 1.547139 0.250135 0.253956 1.034887 0.294403 0.921915 1.518234 1.521713 0.753601 1.656725 0.109964 1.203255 0.226115 1.358114 0.677931 0.773654 1.798499 1.067818 1.335045 1.053173 0.621909 1.698092 1.389346 -0.587371 1.326355 1.467536 1.405976 0.597497 0.629594 0.915202 -0.134796 -0.076541 0.571256)
     )

;;; 35 all -------------------------------------------------------------------------------- ; sqrt 5.9160
#(35 6.8652677536011 #(0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)
     6.8216953277588 #(0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     6.7839112281799 #(0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0)
     6.7759642601013 #(0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     6.7637429237366 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.954156 #(0.000000 1.278258 -0.083592 0.214172 1.000642 0.109910 0.696834 0.495585 0.264419 0.507196 0.939075 0.413387 1.318947 0.514672 0.603685 0.569579 1.474509 0.132115 0.142013 1.055283 1.264318 0.374088 0.909465 0.565617 0.520683 1.755363 1.338683 1.724323 0.320433 -0.005536 1.815986 1.018399 1.308282 1.047656 1.838668)
     5.950283 #(0.000000 1.456471 1.035866 0.679741 0.310570 0.414222 1.556091 1.541397 0.229424 1.261390 0.918613 0.546988 -0.234730 0.466522 1.572643 1.341942 0.310426 1.380498 0.299012 0.745576 1.139186 1.408960 0.570121 0.469553 1.054355 0.495741 0.689322 0.105212 0.727994 0.486055 0.672274 1.162218 0.793791 1.539967 1.676702)

     5.946662 #(0.000000 0.493254 1.581728 1.241056 0.206479 0.577842 0.313268 0.849444 1.273433 1.408925 0.356668 1.054844 0.950274 1.763185 1.230410 1.551386 1.610206 0.260692 0.196905 1.196274 0.621434 -0.069557 1.243162 1.365265 0.741193 -0.151205 0.317827 1.506730 -0.053577 1.044484 1.384738 1.412282 1.296086 1.194698 0.781853)
     5.936113 #(0.000000 -0.020401 1.443101 0.789341 1.367835 0.284974 1.706306 1.642265 1.711494 0.877215 1.377445 1.334806 1.438959 0.075464 1.275771 0.725927 1.325841 1.201466 0.074023 0.523649 1.617774 1.617589 0.654686 1.732159 1.072231 1.262483 0.296332 -0.140533 0.127401 -0.032763 0.406846 0.648656 1.513743 0.716901 0.928728)

     5.927873 #(0.000000 0.261575 1.751555 1.767887 1.104109 1.879882 1.136177 0.510108 0.499459 1.309979 0.469156 1.926451 1.022490 1.955768 0.747176 1.294262 1.362357 0.316284 1.071265 0.810637 1.030312 1.587720 0.457447 0.734471 0.663757 0.687319 0.657758 0.771113 1.611243 1.418590 1.104966 0.194145 0.285015 1.648807 1.155581)
     5.916472 #(0.000000 0.256649 1.744066 1.770409 1.103528 1.879423 1.128555 0.516293 0.495653 1.313889 0.476369 1.926429 1.022025 1.956829 0.741527 1.285585 1.376741 0.313461 1.065811 0.813113 1.031655 1.591106 0.461162 0.729262 0.666075 0.694506 0.660771 0.776693 1.621134 1.427687 1.097577 0.195500 0.284544 1.650043 1.158069)

     5.880578 #(0.000000 -0.006114 1.417819 0.813084 1.386955 0.277349 1.701059 1.619158 1.719884 0.866888 1.378868 1.334114 1.428313 0.049135 1.247319 0.698046 1.323835 1.166628 0.083368 0.518044 1.643395 1.588698 0.681525 1.740161 1.071876 1.225580 0.269893 -0.172681 0.129412 -0.045918 0.409419 0.635175 1.523496 0.673659 0.920231)
     5.879728 #(0.000000 -0.004043 1.417415 0.812890 1.387640 0.277451 1.699713 1.617845 1.720202 0.866999 1.377557 1.335614 1.428714 0.048522 1.248105 0.699654 1.322129 1.166517 0.083425 0.516277 1.643964 1.586757 0.681457 1.740335 1.071039 1.224717 0.269795 -0.172800 0.129311 -0.044894 0.407740 0.635681 1.523709 0.672259 0.920395)

     )

;;; 36 all -------------------------------------------------------------------------------- ; sqrt 6
#(36 6.9388113021851 #(0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 0)
     6.934184551239 #(0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0)
     6.9237461090088 #(0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0)
     6.9208335876465 #(0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1)
     6.8763957023621 #(0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0)
     6.8008880615234 #(0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     6.079976 #(0.000000 0.485646 1.596985 0.466616 0.896554 0.427555 0.820635 0.284672 0.253614 0.673322 1.121298 0.382951 1.301510 -0.091582 0.212857 1.860640 1.133192 1.529859 1.848028 1.704717 0.074358 0.632735 1.414172 0.573290 0.517663 0.674529 1.705508 1.776694 1.317631 0.677628 0.049721 1.148240 0.581401 0.940173 0.624068 1.824362)

     6.054052 #(0.000000 1.101064 0.670122 0.152199 0.856557 0.829760 0.161103 1.785709 0.729803 0.323458 0.324991 0.254657 1.460593 -0.023478 0.329200 1.704018 -0.239167 0.558579 1.023686 0.822672 0.025337 0.024907 0.208766 1.438564 1.096352 0.168789 0.640979 0.678914 0.955770 0.815464 1.042470 1.521904 0.664168 1.647293 0.345537 1.488122)
     6.013730 #(0.000000 1.085946 0.666669 0.161058 0.863429 0.824750 0.163969 1.792324 0.724151 0.320357 0.309525 0.239578 1.465585 -0.010251 0.312302 1.712646 -0.250300 0.541368 1.016840 0.830558 0.024229 0.022994 0.193662 1.439271 1.083390 0.149339 0.627000 0.682282 0.962326 0.803057 1.048877 1.550863 0.662021 1.643992 0.362212 1.477483)

     5.983119 #(0.000000 1.071562 0.658442 0.161534 0.867865 0.820449 0.173048 1.816224 0.729285 0.292702 0.318500 0.204340 1.478147 0.000801 0.304883 1.732739 -0.271769 0.524419 1.000525 0.824270 0.024115 0.006467 0.174768 1.416969 1.059259 0.131995 0.628886 0.685413 0.968187 0.785157 1.081847 1.591098 0.675402 1.664356 0.375430 1.455277)
     )

;;; 37 all -------------------------------------------------------------------------------- ; sqrt 6.0827
#(37 7.1209874153137 #(0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0)
     7.1156206130981 #(0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0)
     7.1152505874634 #(0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0)
     7.1046371459961 #(0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0)
     7.0939922332764 #(0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0588836669922 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0)
     7.0475845336914 #(0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0)
     7.0251078605652 #(0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     6.197751 #(0.000000 1.767044 0.368055 1.162794 -0.018784 1.487338 1.864218 1.056062 0.424689 0.750157 0.915212 0.035334 0.265318 1.518376 0.533492 1.043268 0.567126 1.561121 1.474787 1.068744 1.236196 -0.252481 1.172124 1.252810 1.445963 0.953156 1.295904 0.219585 0.181683 0.973492 0.665016 1.635257 1.193879 0.655032 1.171858 1.766653 0.071611)

     6.027017 #(0.000000 1.428023 1.740298 0.219667 1.766847 1.848285 1.078656 1.439834 0.319718 0.414699 1.720969 1.560330 0.370121 0.459710 -0.046110 0.271650 0.920506 1.663175 1.272314 0.767297 0.376424 1.247123 0.034469 1.855806 0.394149 0.304342 1.566236 0.648308 1.925563 0.310525 1.772463 0.421781 1.738491 1.023243 1.295592 1.345534 1.817571)
     )

;;; 38 all -------------------------------------------------------------------------------- ; sqrt 6.1644
#(38 7.1993880271912 #(0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0)
     7.1926069259644 #(0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 0)
     7.1880865097046 #(0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0)
     7.1807923316956 #(0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0)
     7.1668581962585 #(0 0 1 0 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0)
     7.1260185241699 #(0 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0)
     7.1221342086792 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.0688242912292 #(0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.343461 #(0.000000 0.220518 0.760021 0.840870 0.739726 0.133281 0.928434 0.978120 1.751452 1.407788 0.158470 0.451670 0.617876 1.208062 1.147858 0.631512 1.216709 0.304533 -0.061187 1.254802 1.092157 0.047512 1.795349 1.505216 0.759154 1.328467 0.763049 0.765594 1.006621 0.129836 0.563766 1.734234 0.769099 1.818978 0.782058 0.611599 0.190336 0.219061)
     6.304996 #(0.000000 1.589153 1.495770 0.227098 1.756124 1.096343 1.861290 1.409284 0.555741 1.394336 0.007092 1.639803 0.925155 0.172500 1.696025 1.544289 0.175502 0.142950 0.498549 1.331513 1.534539 0.713795 0.696503 1.505086 0.648611 1.625305 1.485719 1.328350 0.731235 0.876742 0.582453 1.162387 -0.114395 0.606706 1.616260 0.092158 0.196919 0.303189)
     6.284749 #(0.000000 0.450624 1.155276 1.358713 0.642464 0.051459 1.859201 1.338873 0.371745 0.921181 0.726185 1.774156 1.733998 0.792467 1.063743 0.111659 1.348639 0.577931 0.186033 0.812390 1.046561 1.413312 0.316583 1.734665 1.695787 1.679560 -0.425639 1.414846 1.018162 1.449443 0.557603 1.629242 0.465857 0.902571 1.284970 1.359421 1.007609 1.622996)

     6.243489 #(0.000000 0.456049 1.170146 1.373541 0.654541 0.054727 1.858658 1.367234 0.382796 0.927771 0.722072 1.768890 1.748475 0.783036 1.070669 0.120712 1.348933 0.560109 0.203404 0.811903 1.057825 1.418462 0.326521 1.709327 1.696963 1.683222 -0.453461 1.407982 1.007057 1.431765 0.553783 1.627705 0.476863 0.900740 1.294375 1.353587 0.994970 1.627554)
     6.203617 #(0.000000 0.462224 1.177953 1.396612 0.687532 0.063228 1.881560 1.393463 0.389626 0.945030 0.691511 1.739109 1.770118 0.782361 1.073241 0.141416 1.355568 0.541723 0.224129 0.799326 1.079461 1.411265 0.339997 1.675262 1.730145 1.688212 -0.481286 1.429156 1.018512 1.384520 0.545964 1.634021 0.500648 0.876024 1.340598 1.336686 0.992703 1.628835)
     )

;;; 39 all -------------------------------------------------------------------------------- ; sqrt 6.2449
#(39 7.3091864585876 #(0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0)
     7.2959136962891 #(0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0)
     7.2940211296082 #(0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0)
     7.2713379859924 #(0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0)
     7.2698922157288 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 0 0)
     7.2519464492798 #(0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0)
     7.2313327789307 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0)
     7.1506487936623 #(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.436461 #(0.000000 1.189440 0.832144 0.107226 1.321837 1.100415 0.377423 1.690022 0.539358 0.726135 0.694422 -0.035141 1.674789 1.729115 0.859268 1.305156 1.697214 0.539826 0.872548 1.654600 0.606121 1.473393 1.096266 0.030642 0.150090 0.343731 -0.021201 1.838966 1.689545 0.098784 0.434451 0.331369 0.219684 1.105323 0.270989 0.900060 -0.087787 1.618387 1.759966)
     6.426675 #(0.000000 1.818137 1.342569 0.142832 1.026106 0.707254 -0.143789 1.634201 1.159772 0.712817 0.664790 1.509263 1.138778 0.334743 0.519331 0.912494 0.940500 1.759106 0.390588 -0.064689 -0.019349 0.549107 0.302561 1.663475 0.378628 1.471952 1.645422 1.095122 0.073958 0.511787 0.539325 0.127101 0.536831 -0.082605 0.780542 1.607220 0.655670 0.670877 0.980323)
     6.320198 #(0.000000 0.115670 0.176075 1.622226 1.248247 0.612553 0.000356 0.508227 0.541306 -0.042309 0.113241 0.180555 0.544847 0.981765 1.777405 1.883745 1.300594 0.096512 1.420066 1.208805 0.847082 1.560534 1.600559 1.576082 0.896267 0.072211 0.603027 1.729988 0.262606 1.385380 0.654788 0.067329 1.180462 1.494547 1.595623 0.463305 1.555632 0.099178 0.339859)
     )

;;; 40 all -------------------------------------------------------------------------------- ; sqrt 6.3245
#(40 7.4570450782776 #(0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0)
     7.448447227478 #(0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.4427533149719 #(0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.4250183105469 #(0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.4126052856445 #(0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)
     7.4104852676392 #(0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1)
     7.4014959335327 #(0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0)
     7.3913831710815 #(0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.454572 #(0.000000 1.653194 1.404277 0.186154 1.133719 1.350320 1.556073 1.590992 0.145896 0.490865 0.441020 1.274292 0.367589 0.094832 -0.119062 1.448560 -0.268867 -0.049664 0.008971 0.339226 1.902276 1.292017 0.671617 0.754186 0.245273 1.468064 0.252596 1.283067 1.466947 1.837418 1.253999 0.689949 1.519170 1.709695 0.720407 -0.262621 1.624996 0.677240 1.255812 0.624744)
     )

;;; 41 all -------------------------------------------------------------------------------- ; sqrt 6.4031
#(41 7.5969347953796 #(0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0)
     7.5873513221741 #(0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0)
     7.5666546821594 #(0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.5657444000244 #(0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0)
     7.544189453125 #(0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.4959030151367 #(0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.4493231773376 #(0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.4106826782227 #(0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

     6.522248 #(0.000000 1.186429 1.604473 -0.290863 1.176132 1.016913 0.481851 0.472793 1.351266 1.908721 0.404526 0.318834 -1.823636 1.787799 1.663391 1.047284 0.464865 1.635079 0.539393 0.473624 1.321041 0.538675 0.054164 0.760540 0.508566 0.495673 0.629577 0.960614 1.127728 -0.142184 0.960460 1.621160 0.630485 0.070424 0.096402 0.264158 0.934196 0.137890 1.350449 0.067243 0.526025)
     )

;;; 42 all -------------------------------------------------------------------------------- ; sqrt 6.4807
#(42 7.8644123077393 #(0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8588690757751 #(0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1)
     7.8527493476868 #(0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8154973983765 #(0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0)
     7.7903428077698 #(0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 0)
     7.7545323371887 #(0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1)
     7.6252284049988 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.663220 #(0.000000 1.749524 1.543926 1.899112 1.541872 1.545314 0.024746 0.065681 1.499617 0.234020 1.762814 0.988975 0.798828 0.255604 0.629398 1.100034 1.814759 -0.005724 1.192497 1.664257 0.370034 1.791865 1.495721 1.258288 0.821845 0.498691 0.930617 1.169263 1.734433 0.702398 1.635742 0.685494 1.671133 0.654537 0.736990 0.816132 1.061004 1.901586 0.102868 0.518997 -0.029324 0.962370)
     )

;;; 43 all -------------------------------------------------------------------------------- ; sqrt 6.5574
#(43 7.8286972045898 #(0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.824122428894 #(0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1)
     7.8140468597412 #(0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.8020606040955 #(0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7842569351196 #(0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)
     7.7697319984436 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1)
     7.7580170631409 #(0 0 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7244353294373 #(0 1 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1)
     7.6866073608398 #(0 1 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0)
     7.6619415283203 #(0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

     6.793860 #(0.000000 1.792016 1.583872 1.588004 0.915246 0.825218 0.838133 -0.149037 1.385335 -0.198164 1.515036 1.174746 0.151165 1.030301 1.190770 1.061118 0.608692 1.084363 0.587203 1.551244 1.753734 0.324619 0.365220 1.189319 1.515566 1.507524 0.573568 1.154172 0.379865 1.197988 1.264889 1.070415 -0.125194 1.692084 1.278358 0.010536 0.616412 1.936418 1.523538 0.429937 0.082347 1.799134 0.547566)
     6.700796 #(0.000000 1.187880 1.575586 1.077506 0.777298 0.625537 1.128142 0.593277 0.079003 1.219345 0.826169 0.419160 0.244926 1.890647 0.032386 0.586562 1.675153 1.323604 0.332283 0.130032 0.751664 -0.100330 0.518328 0.307019 0.591954 0.316762 1.090504 0.775000 1.830474 0.260931 1.045201 1.380123 1.181501 0.609513 1.901977 0.248217 0.948281 0.184289 0.742909 1.402500 1.449649 -0.319055 0.640592)
     )

;;; 44 all -------------------------------------------------------------------------------- ; sqrt 6.6332
#(44 8.0920171737671 #(0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0)
     7.9767818450928 #(0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     6.835002 #(0.000000 0.015000 1.247084 1.307018 1.667645 1.811831 0.841525 0.845296 1.539718 -1.787159 -1.968731 1.138482 0.424321 -0.080971 0.006825 1.398089 0.456626 0.537874 0.628768 0.288217 1.644188 0.473676 0.414194 1.024647 0.386560 0.878209 1.946721 1.157046 1.733986 0.801698 1.645672 1.304310 0.758199 0.184675 0.209361 0.473188 0.384697 0.471454 0.796809 1.516060 0.335237 1.825604 1.673828 0.310688)
     6.752138 #(0.000000 0.456510 0.100210 0.535690 -0.280213 1.791938 0.100748 -0.023413 0.099409 1.657576 1.733927 0.378001 0.277958 0.559692 1.165847 0.192926 -1.779998 0.556008 0.215320 1.173535 1.351893 0.740920 1.670449 1.466406 0.149002 0.455764 0.610167 0.744409 0.011380 1.534424 0.830586 1.232521 0.168074 0.611087 1.566995 0.267416 -0.079057 1.132554 0.932665 0.368725 0.895844 -0.014941 1.245476 0.265177)
     )

;;; 45 all -------------------------------------------------------------------------------- ; sqrt 6.7082
#(45 8.197151904921 #(0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1)
     8.1777801513672 #(0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

     7.089405 #(0.000000 0.702395 1.613825 1.357823 0.648228 0.071359 1.034132 0.925605 0.019903 0.785319 0.794290 0.059919 0.667965 1.099745 0.620429 1.045045 0.645268 0.495359 0.943383 0.402505 0.556132 0.243775 0.009110 1.476267 -0.597520 1.081756 1.957202 0.907757 0.101905 0.472870 0.948955 1.016228 1.482660 0.608399 1.352335 0.404535 -0.303022 1.653384 1.835470 0.559062 0.400382 1.565503 1.823442 0.556895 0.193715)
     6.996247 #(0.000000 1.460743 0.209887 1.008492 0.782367 0.475740 1.085849 0.220646 0.863722 -0.270402 0.714842 1.508604 0.388633 0.311181 0.588442 0.222393 0.495641 1.437910 0.516774 0.007439 0.091864 1.628016 1.131874 0.118129 1.607205 0.061686 0.246253 0.683564 1.305458 0.916629 0.445436 1.131543 0.379997 0.412455 0.957828 1.261534 -0.107829 1.369108 1.367335 1.345397 1.248574 0.330782 0.381156 1.241772 1.284021)

     6.937843 #(0.000000 1.094652 -0.085476 -0.298103 1.313901 0.125050 0.653195 1.020319 1.404453 -0.094950 1.231260 1.949054 1.804828 1.003684 1.804510 0.171243 0.507553 0.241483 1.102939 0.659151 1.345848 0.148662 0.031167 0.650852 0.081986 0.061923 0.145799 0.734313 1.581155 0.335075 0.093273 -0.059624 1.051306 1.844872 1.008792 1.254064 1.081678 -0.017755 1.438619 1.040683 0.447860 -0.025726 1.914681 1.579300 1.904522)
     )

;;; 46 all -------------------------------------------------------------------------------- ; sqrt 6.7823
#(46 8.4391345977783 #(0 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0)
     8.22203540802 #(0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     7.068004 #(0.000000 0.406360 1.088021 -0.078049 0.335638 0.031296 1.493806 0.598331 1.714709 0.859865 0.480592 0.241095 0.547695 1.648638 0.212679 1.209408 1.484019 1.704259 1.205614 0.879939 0.138274 1.556016 0.257091 1.546474 1.563114 1.390350 0.046591 0.339339 1.048982 1.088403 1.078631 1.419086 1.412366 0.419734 0.462611 1.570301 -1.962993 1.269135 0.285260 0.714758 1.892846 1.595096 1.692969 1.241304 1.808408 1.724608)
     6.950253 #(0.000000 1.409215 0.928831 1.770426 0.714012 0.205628 0.006185 0.178005 1.037678 0.821238 -0.014025 1.534284 0.311767 1.113694 0.988720 1.071691 0.480331 1.908778 1.692269 0.023174 0.790394 1.420698 1.345293 0.615694 0.716321 0.125960 0.873662 1.345271 0.839950 1.744649 1.541986 1.207598 1.653924 1.477083 1.924378 0.987088 1.462096 0.922505 1.390299 1.485212 0.919586 1.204135 -0.080942 0.455387 0.256306 0.916708)
     6.905954 #(0.000000 1.417612 0.938193 1.758943 0.715374 0.215931 -0.007669 0.199443 1.043120 0.817607 0.004654 1.533896 0.311274 1.106610 0.987087 1.053415 0.477733 1.919421 1.686703 0.034975 0.766640 1.414612 1.344216 0.594791 0.711622 0.124027 0.862708 1.343317 0.843554 1.752895 1.543252 1.208805 1.657868 1.471008 1.943816 0.992937 1.462206 0.930944 1.390260 1.484039 0.913622 1.197983 -0.102898 0.476030 0.262384 0.921218)
     )

;;; 47 all -------------------------------------------------------------------------------- ; sqrt 6.8556
#(47 8.4154777526855 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0)
     8.3755550384521 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0)
     8.3640232086182 #(0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0)
     8.3221893310547 #(0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     7.216830 #(0.000000 1.672112 0.417912 0.850481 -0.047344 0.924892 1.485237 0.412503 1.392861 1.796022 0.400137 0.189962 0.249181 0.530104 1.876632 0.327512 0.420971 0.555449 1.244910 1.237571 1.065906 0.100499 1.355250 0.654823 0.311650 0.646120 1.166139 1.830961 0.922860 0.180606 1.258159 0.898916 1.570356 0.634763 0.578007 0.831309 0.082246 0.565623 0.126431 1.645290 0.363677 0.895286 1.053584 0.366741 0.156906 1.615534 1.444383)
     7.180804 #(0.000000 1.685749 0.939738 0.175401 0.734915 1.865352 0.181481 -0.064697 0.960644 0.109930 0.227378 0.288721 0.902910 1.431435 0.158090 0.466405 0.875537 1.496993 0.921849 1.324543 0.611733 1.492424 1.804840 -0.161371 1.421817 1.186058 0.760082 1.278410 1.611726 0.369062 0.180248 1.368528 1.017593 0.990403 1.217286 0.180697 1.474753 0.753458 0.011349 1.821265 0.169305 -0.137247 0.383205 1.308256 1.615986 1.223586 1.469462)
     7.150732 #(0.000000 1.683383 0.921871 0.149877 0.748333 1.866760 0.175703 -0.075848 0.977608 0.120211 0.211446 0.287852 0.901597 1.445317 0.151992 0.453945 0.874418 1.510782 0.920845 1.332000 0.625896 1.479659 1.807766 -0.164181 1.423580 1.181188 0.753177 1.279087 1.607567 0.367322 0.160418 1.370785 1.011394 0.994985 1.208622 0.169850 1.472843 0.752733 0.021454 1.810845 0.164547 -0.145106 0.380305 1.321061 1.595812 1.217743 1.461575)
     )

;;; 48 all -------------------------------------------------------------------------------- ; sqrt 6.9282
#(48 8.6921081542969 #(0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1)
     8.5232070520636 #(0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1)
     8.4671268463135 #(0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

     7.273239 #(0.000000 1.052392 -0.051338 1.768504 1.225282 0.281890 0.387577 0.601096 1.015974 1.227296 1.585266 0.376906 0.516230 1.544072 1.291265 1.561996 0.016320 0.401177 1.391331 0.229574 0.595388 1.795921 1.065516 0.906801 0.541948 -0.225930 1.359255 -0.292334 1.502377 0.297845 1.296874 0.365326 1.606757 1.444801 -0.347001 -0.125819 1.583314 0.022374 -0.288512 1.872500 0.588548 1.478510 1.674905 1.295051 0.835916 0.981215 0.281219 0.556265)
     7.227543 #(0.000000 0.566109 1.030287 1.013996 1.007303 0.474593 1.473696 1.210849 0.775488 1.832936 1.552427 1.970333 0.340032 1.503267 0.389700 0.290737 1.347195 1.733818 0.773717 0.505832 1.134042 -0.259574 1.844122 0.555566 0.630996 0.765981 -0.085243 0.988684 -0.125202 0.417603 1.406870 0.548783 0.970485 1.170979 1.270979 1.081679 0.918105 0.362398 0.023708 0.804596 1.269477 1.156272 0.663883 1.170867 0.666680 0.491237 1.641196 0.399338)
     )

;;; 49 all --------------------------------------------------------------------------------
#(49 8.7310771942139 #(0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0)
     8.6587047576904 #(0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0)
     8.7183141708374 #(0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1)
     8.5157623291016 #(0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

     7.381330 #(0.000000 1.430968 1.481533 1.515637 1.248297 1.494786 1.281566 0.521712 0.835547 0.443385 1.213954 0.862204 0.682513 1.492167 0.450678 0.835488 0.567887 0.948391 1.761860 1.557935 1.501270 1.526671 -0.029014 0.686912 1.122036 0.064345 1.468308 1.076314 0.361385 0.358255 0.092010 0.074457 1.035300 -0.000291 1.124183 0.470653 0.487761 1.388712 1.156242 0.071088 0.006174 0.560069 1.126964 0.090915 0.756582 0.206499 1.048765 0.801704 1.395113)
     )

;;; 50 all --------------------------------------------------------------------------------
#(50 8.8124130871436 #(0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1)
     8.8096923828125 #(0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1)
     8.7809114456177 #(0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

     7.512821 #(0.000000 1.513804 0.793821 1.406754 1.785342 1.477285 0.287986 1.717808 1.016096 0.894434 0.983639 1.080614 0.065942 0.893367 0.706345 1.341870 0.217964 -0.177028 0.762610 1.057772 1.397792 0.792368 0.498364 0.249738 0.761165 0.630764 0.659416 0.426023 1.377071 1.447085 0.909307 -0.086282 0.319313 1.290096 -0.263913 1.141555 1.443484 0.430451 1.294681 0.919736 -0.020424 1.179143 1.368672 1.531415 0.440217 0.565889 0.093051 0.231974 0.818465 1.664840)
     )

;;; 51 all --------------------------------------------------------------------------------
#(51 8.8691492080688 #(0 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)
     8.8213935921978 #(0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     7.605343 #(0.000000 1.534932 1.490031 1.645905 0.319767 1.009302 0.100120 0.299442 0.596680 1.478904 1.809115 -0.055080 0.448106 1.675056 0.787203 1.157226 0.536346 1.166258 0.639933 0.485248 0.443632 0.563411 1.310649 1.842642 1.729406 1.923470 -0.094966 0.710275 1.891992 -1.923210 1.772040 0.490817 1.873594 1.679458 1.523600 0.428755 0.335782 1.353765 0.987475 0.023193 1.269869 -0.045404 1.769588 1.021489 0.046728 0.521812 0.207087 1.951793 1.051372 1.220760 0.267583)
     )

;;; 52 all --------------------------------------------------------------------------------
#(52 9.1133499145508 #(0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1)
     9.109245300293 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0)
     8.9920463562012 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

     7.674718 #(0.000000 0.781804 1.576119 1.624987 0.186178 1.244207 0.496366 0.436778 1.770704 0.551212 1.742132 0.340742 1.347903 1.105303 1.455106 1.133128 0.866641 1.585660 0.574508 0.225588 0.441172 0.971183 0.054053 0.417234 0.470508 1.203111 1.769270 1.324362 1.786001 -0.174446 0.150541 1.100328 0.380317 1.185133 0.350632 -0.020940 1.215466 1.370612 1.089164 0.730258 0.484203 0.925442 1.356703 1.068437 1.248546 0.337604 1.513577 1.051640 0.558926 1.385251 1.395726 0.897866)
     7.519717 #(0.000000 0.789558 1.566402 1.598554 0.204648 1.246273 0.482116 0.445282 1.753619 0.533630 1.745499 0.358095 1.364369 1.098291 1.449605 1.160303 0.890118 1.564624 0.585437 0.230225 0.442291 1.015111 0.030209 0.400522 0.471403 1.224808 1.783938 1.341269 1.774437 -0.196146 0.176811 1.103806 0.411969 1.164790 0.355247 -0.048443 1.208879 1.313227 1.078215 0.718402 0.495052 0.968409 1.359616 1.065480 1.267965 0.363669 1.496967 1.018786 0.538772 1.368909 1.379801 0.876299)
     )

;;; 53 all --------------------------------------------------------------------------------
#(53 9.171422958374 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 1 1 0)
     9.0914754867554 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

     7.659568 #(0.000000 0.590396 0.757813 1.645915 1.223857 1.694559 0.507946 1.856775 0.139932 0.225483 0.984601 1.350956 1.051830 1.748201 1.685580 1.839777 0.857615 -0.097896 0.627816 1.520230 0.779958 0.902813 0.791103 0.334117 0.229821 0.930439 1.862078 1.017949 0.005508 0.142375 0.418304 1.587210 0.199357 1.889479 1.245953 0.965316 0.841073 0.456792 1.379393 1.898260 0.492910 1.504537 1.849536 1.584031 1.705770 0.016850 1.672132 0.965872 1.981458 1.773893 0.410282 0.103114 1.638679)
     )

;;; 54 all --------------------------------------------------------------------------------
#(54 9.2755253455568 #(0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1)
     9.1825122833252 #(0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

     7.812464 #(0.000000 1.437496 0.132365 1.418862 0.176063 1.061499 1.813761 0.370736 0.797744 1.770795 1.810685 0.094919 1.915654 0.783071 0.158404 0.579416 1.410860 0.044891 0.476496 0.717331 1.033383 0.150698 -0.000926 0.406275 0.957541 0.030324 1.623914 1.146961 0.675632 1.339164 1.262446 0.533183 1.489744 0.743890 0.508446 0.605056 0.416152 0.073538 0.891467 -0.019048 0.398198 0.610328 1.046842 0.496849 1.073112 1.670390 1.364851 0.296873 1.921441 0.141204 1.465901 0.991281 0.339565 0.459349)
     7.799933 #(0.000000 1.436675 0.131711 1.418640 0.175690 1.063868 1.813731 0.367454 0.797274 1.775187 1.812452 0.095527 1.917572 0.784922 0.155469 0.583163 1.413545 0.048704 0.479618 0.711658 1.035551 0.149895 -0.003766 0.411447 0.957536 0.028200 1.620231 1.147514 0.677958 1.341090 1.260666 0.536172 1.488399 0.752353 0.511273 0.612043 0.416537 0.070058 0.892736 -0.013399 0.396548 0.611702 1.047192 0.501939 1.072576 1.673177 1.369255 0.291478 1.925154 0.139786 1.465102 0.992796 0.337206 0.457337)
     )

;;; 55 all --------------------------------------------------------------------------------
#(55 9.2178440093994 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0)
     9.0889595835043 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     7.984924 #(0.000000 0.614780 -0.228557 0.903292 0.573890 1.941558 1.233621 0.481086 1.271802 0.660609 1.375701 1.698922 1.952884 0.514120 0.395806 0.083681 1.622771 0.230629 0.632433 1.166537 0.881380 0.030806 0.889897 1.096320 0.008002 1.499712 1.627836 1.669304 0.238964 0.318806 1.113627 1.839718 0.846627 1.721351 1.679421 0.511507 0.391991 0.432979 1.847709 0.269509 1.433950 0.730903 0.316354 0.172958 1.841347 0.305292 1.583303 0.001441 0.849453 1.160060 0.851504 1.349197 1.222348 0.784407 0.384950)
     7.877039 #(0.000000 0.951577 0.315848 1.652198 1.018982 1.229357 -0.244672 1.013980 1.187526 1.681563 0.466049 0.580818 1.473556 1.031437 1.119226 1.142080 1.586549 1.709659 -0.297860 1.382620 1.840901 0.844338 0.610699 1.198571 0.264848 0.474547 1.397421 0.038216 1.208317 -0.115610 1.188691 1.245408 1.352408 0.614201 1.360416 0.576557 1.631041 0.345180 0.243474 0.083638 1.037528 0.417002 0.449572 0.098327 1.718398 0.665635 0.333158 1.279568 1.682723 -0.171432 0.079788 0.923390 1.057568 0.645543 1.715461)
     )

;;; 56 all --------------------------------------------------------------------------------
#(56 9.4667987823486 #(0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0)
     9.3902807235718 #(0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1)
     9.1394176483154 #(0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

     7.914078 #(0.000000 1.652572 1.698664 -0.013477 1.279719 0.407366 1.328369 1.502486 0.165778 1.620986 0.033212 0.318076 0.278183 1.376175 1.424808 0.416562 0.285526 1.130499 0.140114 -0.034868 1.401513 0.078463 1.350783 0.897978 1.632033 1.453903 0.584998 0.768610 0.910074 1.292704 1.067008 1.144852 1.853889 1.286976 0.223808 0.492053 1.764221 1.276703 0.486053 0.620120 0.676917 0.420710 1.039694 0.155428 0.825874 -0.312848 1.780037 0.656014 1.132556 0.320398 1.516354 1.389231 1.215505 0.366287 0.876503 -1.811576)
     )

;;; 57 all --------------------------------------------------------------------------------
#(57 9.650218963623 #(0 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0)
     9.616 #(0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1)
     9.370246887207 #(0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

     8.014130 #(0.000000 0.373290 1.052259 0.975399 1.731831 0.205823 0.540818 0.192853 1.752560 1.271616 0.988481 0.958542 0.289783 0.676291 1.626508 1.279855 1.548323 0.087903 1.512292 1.648776 0.170164 0.182182 0.376071 1.428691 0.381741 0.823249 1.719441 1.171133 1.108411 1.371319 1.658218 0.898780 0.915261 1.183346 0.751818 0.629734 1.649269 0.471078 1.687828 1.705356 1.006321 1.720931 1.606850 0.350931 1.486344 0.508764 1.480375 1.379364 0.115981 1.514663 0.096949 0.964767 0.248743 1.683367 1.125873 1.405759 1.544983)
     8.010027 #(0.000000 0.372569 1.051805 0.974807 1.731323 0.205732 0.539738 0.192202 1.751681 1.270744 0.989778 0.958606 0.289372 0.676335 1.625043 1.280804 1.548985 0.088657 1.512660 1.649123 0.170132 0.181910 0.376179 1.428920 0.381081 0.823145 1.719297 1.170672 1.110262 1.372146 1.659283 0.899327 0.915647 1.183714 0.752175 0.628350 1.649929 0.472195 1.688277 1.705086 1.005853 1.720040 1.606926 0.351107 1.485844 0.508848 1.481155 1.380113 0.116232 1.515387 0.095386 0.964622 0.248886 1.683584 1.125284 1.405647 1.545470)
     )

;;; 58 all --------------------------------------------------------------------------------
#(58 9.623 #(0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1)
     9.6140956878662 #(0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1)
     9.4419231414795 #(0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     8.061125 #(0.000000 1.100108 1.373910 0.690236 0.507479 0.136457 0.148963 0.155132 1.218509 1.326649 0.259100 1.202636 1.693429 -0.126564 0.934132 1.739678 0.878446 1.757180 1.470320 0.953120 1.288641 0.486329 1.124727 0.508902 0.249403 0.917256 1.131629 -0.211587 0.080267 0.048889 0.182267 0.006420 1.773883 0.818370 1.149092 -0.022294 1.876251 0.149968 0.170351 1.584649 0.185725 0.480157 0.108204 0.783801 0.254238 0.317742 1.532217 0.775290 1.341397 0.713380 -0.025274 1.813022 1.020952 0.327764 1.475619 1.520240 1.736346 0.389853)
     )

;;; 59 all --------------------------------------------------------------------------------
#(59 9.9013983722749 #(0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1)
     9.4819116592407 #(0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

     8.269716 #(0.000000 1.844744 0.346396 1.428284 1.347226 0.137238 1.053601 0.661035 1.511786 0.396734 1.302532 -0.024782 -0.243351 1.557044 0.319227 1.188287 0.130541 0.556163 0.192594 0.353530 0.148629 0.738495 1.028169 1.099923 0.604140 0.812189 1.007651 0.243146 1.244965 1.063139 0.507254 0.293287 0.514036 1.448007 0.660549 1.378000 0.858151 0.197757 0.652032 0.654364 -1.663244 1.615740 0.134255 0.556967 0.259052 1.701674 1.318331 1.249115 0.296311 1.519634 1.631965 0.367570 0.790903 0.551038 0.545497 1.009375 1.706240 1.433899 0.390587)
     )

;;; 60 all --------------------------------------------------------------------------------
#(60 9.783 #(0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)
     9.575254043103 #(0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     8.343616 #(0.000000 0.395614 0.281839 0.909322 0.555847 -0.037949 0.234808 1.723388 1.076971 0.678913 0.880705 1.287576 0.143529 0.033290 1.140378 1.297121 0.771383 0.057450 1.426588 1.814850 1.291643 0.984731 1.357501 0.564756 1.678510 0.891518 0.688232 1.701948 1.687391 0.985338 0.660461 1.096448 -0.020540 0.110195 0.706130 0.197908 0.541092 1.900853 0.130728 0.867714 0.344706 0.847245 0.845789 0.278831 0.853212 1.444279 -0.076482 1.694805 0.410261 -0.135555 0.704410 1.170691 0.072089 1.140486 1.675766 0.520303 0.214357 0.624558 0.153798 0.384604)
     )

;;; 61 all --------------------------------------------------------------------------------
#(61 10.138124465942 #(0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0 1)
     9.9151945114136 #(0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     8.445875 #(0.000000 0.260576 1.280384 1.800897 0.533423 1.733606 1.652106 1.182816 -0.199000 0.510739 -0.084800 0.420430 0.728964 -0.000958 0.518540 1.292515 0.685581 0.860950 0.958447 0.280026 0.147795 1.254346 -0.170113 1.089060 0.603646 0.990248 0.845898 0.187788 1.165292 -0.011928 1.441760 -0.061749 1.525814 -0.384632 0.873049 0.041157 1.423421 0.285819 0.535056 1.397381 1.111899 0.627046 -0.067013 1.524138 1.072858 1.529268 0.946724 1.845070 -0.109760 0.248069 0.787955 1.566548 1.439628 -0.091320 -0.078782 0.232886 1.564008 1.160401 0.609445 1.054577 1.259708)
     )

;;; 62 all --------------------------------------------------------------------------------
#(62 10.281167984009 #(0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0)
     9.9292116165161 #(0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

     8.531800 #(0.000000 0.649217 1.573743 0.253776 1.531625 1.456769 1.922760 0.787110 1.880375 0.375540 1.713164 1.083091 1.429249 1.954561 1.521521 0.126133 1.173176 1.912216 1.081064 1.248413 0.482337 0.582631 0.051130 1.589460 0.045301 1.150370 0.535170 0.314919 0.664534 0.310360 0.281230 1.586332 1.650603 1.814222 0.101529 1.614996 0.958826 0.465693 1.339934 1.406671 0.169134 0.649894 1.440227 1.229302 0.511506 1.824298 1.235402 1.618852 1.643338 0.446234 1.824986 1.679048 0.842437 0.828483 0.918792 1.245565 -0.007659 1.271927 0.816486 0.959134 1.162077 1.619829)
     )

;;; 63 all --------------------------------------------------------------------------------
#(63 10.265982627869 #(0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9846226693403 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9555234909058 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     8.492186 #(0.000000 0.090059 -0.031581 0.351709 1.358682 0.193420 -0.038421 1.145573 0.152491 0.175399 1.674301 0.100894 1.856714 0.998993 1.707102 0.295464 1.254491 0.806072 1.482891 1.221821 0.017880 1.715563 1.099007 0.668860 1.245157 0.962769 1.253863 1.217119 0.274429 0.815107 0.058858 1.771169 1.451111 1.352696 1.880030 1.465446 1.701072 1.538902 1.169277 0.492391 0.931882 1.882005 1.244756 0.144928 1.638647 0.175341 0.730722 0.296655 0.223421 1.645888 1.121149 0.999335 0.165688 0.988123 1.428906 -0.074094 0.102104 -0.114716 1.105031 1.634488 0.232538 0.622559 0.400029)
     )

;;; 64 all --------------------------------------------------------------------------------
#(64 10.1628899603246 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1)
     9.957244923706 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

     8.570097 #(0.000000 1.815783 0.054524 1.924238 0.454005 1.407282 1.325047 0.379579 0.337571 1.035971 1.103938 -0.079311 1.384663 1.463853 0.139658 -0.062864 1.563717 1.069519 1.689248 0.836713 0.686546 1.645642 0.367917 0.737116 1.231606 1.418528 -1.919807 1.545511 0.565319 1.060471 1.561948 -0.007692 0.054505 1.725986 1.634669 1.392116 1.233450 0.947475 0.250913 -1.735650 -0.014750 1.085905 0.378340 0.331540 0.580723 1.497158 0.738747 1.482461 1.879027 0.160306 1.141517 0.739757 1.255061 0.736443 1.386232 1.173207 1.004736 0.044732 1.230240 0.293726 0.970137 1.751886 0.884773 0.964561)
     )

;;; 65 all --------------------------------------------------------------------------------
#(65 10.598279953003 #(0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0)
     10.18968963623 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0)
     10.157649040222 #(0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     8.664213 #(0.000000 -0.219045 1.080972 1.224430 1.325296 1.687801 1.630697 -0.121485 1.152313 1.790386 1.071279 1.470807 0.456098 0.912368 1.348232 1.283124 1.697875 0.250001 0.689896 1.893157 0.272106 1.098864 0.931644 1.332792 1.704552 1.079383 1.474875 0.221795 1.000960 0.466163 1.170565 0.372989 1.846161 0.504322 1.166466 0.387156 0.457654 1.316611 1.601451 0.514222 -0.035464 0.450149 0.219464 1.209245 1.705511 0.328646 0.714153 0.173870 1.177736 0.272680 1.337930 1.197571 1.287144 1.324785 1.145289 0.862800 0.787371 -0.061033 -0.043287 1.422279 0.880408 0.004548 1.350853 0.499844 0.002604)
     )

;;; 66 all --------------------------------------------------------------------------------
#(66 10.450973400896 #(0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0)
     10.26798183746 #(0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1)
     10.208241079264 #(0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

     8.802281 #(0.000000 0.913135 1.760561 0.707264 1.527941 1.589601 1.787648 1.041322 0.628377 0.070811 0.501767 0.733521 0.753105 1.369319 0.273891 0.409182 1.458410 0.368030 1.701340 0.312618 1.039367 1.348277 -0.072732 0.644971 0.005401 1.315366 1.577240 0.938177 -0.068469 0.496071 -0.077288 1.427705 0.932068 1.066276 1.003655 0.637440 1.734370 0.053991 0.243521 1.381526 0.231569 1.349052 1.611682 1.628817 0.237748 0.547382 0.943868 0.331162 0.994087 0.600971 1.541482 0.655612 0.511246 1.822169 1.005229 0.412872 0.532770 0.087202 0.659527 0.632515 1.875063 -0.101654 0.666331 0.555422 0.555187 0.775234)
     )

;;; 67 all --------------------------------------------------------------------------------
#(67 10.780866622925 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     10.514228551195 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.445269388021 #(0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.422191619873 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.832366 #(0.000000 0.818600 1.464386 1.025486 1.883711 0.936109 1.581052 1.076819 0.195738 1.502353 0.203848 -0.044233 1.785842 0.749335 0.645762 0.564000 1.203806 1.000068 1.123867 1.500855 0.856769 1.971580 1.649083 1.604492 -0.211258 1.471939 0.639018 1.406246 1.102216 0.110168 0.520830 -0.061391 0.022321 -0.029692 0.138053 1.010900 0.399834 -0.184515 1.410460 0.146913 1.022270 1.328304 1.364565 1.743283 0.600157 1.097135 0.964586 1.175991 0.025960 1.345082 0.820397 0.399668 0.727920 1.094954 1.402124 0.697796 1.693577 0.121486 0.897129 1.478758 0.441393 1.128518 1.205577 1.105721 0.618460 0.149391 1.770900)
     )

;;; 68 all --------------------------------------------------------------------------------
#(68 10.585594177246 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1)
     10.460547747753 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

     8.952229 #(0.000000 0.347151 1.764545 0.893575 0.746661 0.886917 0.515480 0.704892 0.235280 -0.030137 0.235192 0.042987 1.578288 0.882851 1.021828 1.100842 0.767592 1.258953 1.193753 1.207552 0.810439 1.679584 1.869796 1.850480 1.625413 0.264301 1.916221 1.822544 0.283840 0.571013 1.136425 1.884862 1.652198 1.541933 0.020432 0.118195 1.563792 0.997011 1.261897 1.394719 0.117761 1.159465 0.440790 0.194567 1.353507 1.221561 0.684079 1.383432 0.198129 1.172173 0.438725 1.524336 1.217075 0.279001 0.269682 1.221378 0.035125 1.218209 -0.042830 1.057305 0.140573 0.724143 1.647843 -0.023118 0.494918 0.811812 0.917160 1.831516)
     )

;;; 69 all --------------------------------------------------------------------------------
#(69 10.631803698099 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.544771744298 #(0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.495518383865 #(0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

     9.029083 #(0.000000 0.504134 0.121415 -0.272463 0.689897 1.870499 0.657448 0.087247 1.444151 0.727192 -0.023121 1.381351 0.558123 0.706757 1.022403 0.457203 0.342143 0.959037 0.531693 0.171338 1.093387 1.555542 0.053420 0.568439 0.710640 0.156128 1.599632 0.420314 0.955560 1.617010 1.245358 1.010934 0.631087 0.496822 0.783999 -0.025528 1.812386 1.161501 0.274755 0.793785 1.322944 0.876366 1.683123 0.170665 0.481612 0.597750 1.966338 0.402631 1.439295 1.938328 -0.239515 1.809544 0.618934 -0.080042 1.375205 1.653921 0.860594 0.348566 1.654932 0.159086 1.351931 0.326343 0.735129 0.835636 1.063120 1.302689 1.436293 1.451884 1.119273)
     )

;;; 70 all --------------------------------------------------------------------------------
#(70 10.957886695862 #(0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0)
     10.651799201965 #(0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0)
     10.635682482778 #(0 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)
     10.532930374146 #(0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

     8.985770 #(0.000000 0.447292 1.208672 0.548261 1.039473 1.490183 0.755632 1.382194 1.596186 1.843101 0.802012 1.636016 0.385628 1.131800 1.313829 1.247561 0.964287 1.622249 1.123751 -0.056713 0.186984 1.305851 1.814123 0.905530 0.127084 0.164671 0.621452 0.132300 0.412967 0.000083 0.356778 1.278479 0.230373 1.654028 0.456854 1.430995 0.843584 0.057246 1.394729 1.768732 1.469849 0.058189 0.431367 0.756190 0.618375 0.237867 0.146340 0.014249 0.142030 1.234347 1.239033 1.792745 -0.223459 0.652139 1.586436 0.663848 0.448118 1.664004 1.371369 0.696424 0.026670 1.655817 0.047593 -0.056977 1.072990 1.065888 0.735508 0.176959 -0.068688 1.024272)
     )

;;; 71 all --------------------------------------------------------------------------------
#(71 10.922951698303 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0)
     10.610488331633 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     9.027005 #(0.000000 0.357375 1.985715 1.230413 0.048161 0.063521 1.301836 1.342940 0.191330 1.579818 0.441857 1.000456 -0.159994 0.912745 0.624164 0.883999 0.903686 0.828802 0.840986 0.736395 0.771433 0.308695 0.538880 1.066355 0.228279 1.258439 0.945917 1.010853 1.329487 0.501986 -0.146768 0.579221 0.922087 0.259502 0.024107 1.668743 0.001814 0.789468 0.942044 1.928967 1.221153 0.040736 0.482976 0.318362 1.872844 1.080063 0.784819 1.710127 0.947428 1.104505 1.616541 1.842881 -0.043650 1.052572 0.001931 0.455768 0.872104 0.763179 0.337805 0.182216 1.585747 0.161007 1.031350 1.048077 0.892360 0.027800 1.675459 0.328389 1.515213 0.573597 0.096113)
     )

;;; 72 all --------------------------------------------------------------------------------
#(72 11.061260849739 #(0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
     10.908146369485 #(0 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0)
     10.800657366855 #(0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     9.222929 #(0.000000 1.841525 0.690331 0.638384 1.873815 1.247211 0.079642 0.474336 0.852915 1.281051 1.602523 1.254240 1.045075 0.247432 0.570262 1.522048 0.313855 1.027286 0.418154 1.417941 1.225351 1.301020 0.009124 0.262216 0.065510 0.315645 0.520801 0.911198 0.575190 0.266558 0.156337 0.673079 0.673482 0.758282 0.978988 0.503999 1.863812 1.515700 -0.001491 1.247727 1.186778 1.011743 0.252328 0.546375 -0.000119 0.575343 0.179580 0.811618 1.604362 -0.089012 0.163372 1.390908 1.539532 0.301730 0.409256 1.681349 1.014627 1.818148 0.936099 0.276971 1.567811 1.009563 1.807283 0.271563 0.953377 1.274815 0.542605 1.465243 0.344159 0.888671 0.157479 0.051695)
     )

;;; 73 all --------------------------------------------------------------------------------
#(73 10.9493838342178 #(0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.889594078064 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.876985549927 #(0 0 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0)
     10.773231506348 #(0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

     9.256225 #(0.000000 -1.875797 1.954357 1.312027 0.722561 0.642471 0.658371 0.018139 1.089808 0.085730 1.049056 -0.232772 1.014010 1.050906 1.258478 1.782511 1.305057 -1.875444 0.193697 0.746650 1.827197 1.325844 -0.081348 1.726790 0.226101 1.449506 0.870513 0.980854 1.185914 1.420523 0.218845 0.080981 1.844212 1.520313 0.262817 0.670247 1.661110 1.092500 0.810020 0.802511 1.487091 -0.095367 0.145607 -0.050226 1.707408 0.161223 0.195039 1.504219 0.184532 1.614133 1.805964 1.542169 0.415607 1.329377 1.560951 0.592265 1.258420 0.915138 0.473381 1.621523 1.224109 0.717898 0.458503 1.207725 1.668266 -0.181728 0.924300 0.213287 1.218007 1.626925 0.148183 1.074182 0.498143)
     )

;;; 74 all --------------------------------------------------------------------------------
#(74 11.023842939777 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0)
     10.97177028656 #(0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0)
     10.70422077179 #(0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0)
     10.684138298035 #(0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     9.384074 #(0.000000 1.173104 0.403180 1.571001 1.090604 0.053330 1.159405 0.720474 1.991605 1.018091 0.203472 0.917948 1.826693 0.141774 1.277065 0.244451 1.041126 1.528962 -0.098180 0.487118 1.299410 -0.038048 0.049054 1.301876 1.423285 -0.116424 0.955718 0.473749 0.202811 1.420439 0.614365 -0.211921 1.898139 1.629164 0.083338 -0.278716 1.537272 -0.043444 1.530625 0.313282 0.027362 1.583848 1.460314 0.893768 0.865879 1.143483 1.676608 -0.274536 0.119735 1.058612 1.322984 0.947493 -0.052583 1.908270 0.191369 0.427895 0.023305 0.148237 1.303910 0.582390 0.849256 0.923276 -0.179359 0.385629 1.925848 0.825662 0.241336 0.469287 1.209384 1.185187 -0.204905 -0.577457 1.357375 1.061885)
     )

;;; 75 all --------------------------------------------------------------------------------
#(75 11.477107048035 #(0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0)
     10.935811368418 #(0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

     9.335296 #(0.000000 1.847606 1.390562 1.356060 0.317947 1.148240 1.092831 0.106201 -0.024230 1.265427 1.092198 1.023347 1.762076 0.333063 0.395391 1.762733 1.618213 0.689277 1.843560 1.069665 1.142883 1.283916 1.269162 1.245040 1.388868 1.296134 0.730210 0.757023 0.318947 0.848291 1.286406 0.406774 0.182645 1.132075 1.415069 0.398646 0.833196 1.684923 0.635577 0.340232 0.684521 0.875480 1.297355 0.452294 0.935247 0.104322 1.259567 1.542135 1.704304 1.602515 1.425429 0.114879 1.191172 0.119592 1.119372 0.531854 -0.043972 1.525000 -0.053687 1.228272 0.582644 0.672785 0.764555 1.235382 1.464566 0.154180 0.135929 0.105446 1.657107 0.846552 1.339267 0.095652 0.928221 0.674279 1.535099)
     )

;;; 76 all --------------------------------------------------------------------------------
#(76 11.327380277947 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0)
     11.208243370056 #(0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0)
     10.689208030701 #(0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

     9.527426 #(0.000000 -0.123416 -0.040364 1.524703 1.227803 0.418728 0.815866 1.668159 0.723494 1.409913 1.027218 0.028445 1.304481 1.689210 0.179915 0.267312 1.336250 0.571667 1.068661 0.714748 1.530394 0.150338 1.399456 1.910688 1.390134 0.736151 0.776903 0.961359 0.899015 1.475198 -0.053993 0.594542 1.353192 1.950285 1.030542 0.907718 0.885866 0.104395 0.161211 0.638882 1.025746 0.045937 0.761275 0.121930 0.719483 0.490791 1.281427 1.641441 0.036148 0.082756 1.691197 1.029273 0.044463 1.581632 0.437834 1.779180 0.907714 0.861264 0.964523 1.062767 0.795078 0.830339 0.071309 0.965764 1.113693 0.375063 1.486815 1.062934 1.630363 1.607890 0.936510 0.623638 1.080745 1.682496 1.361643 1.038150)
     )

;;; 77 all --------------------------------------------------------------------------------
#(77 11.25105381012 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0)
     11.114716461811 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

     9.557742 #(0.000000 0.310118 0.714558 0.386403 1.192654 1.773337 0.239499 0.075337 0.894931 0.623593 0.401623 0.440634 1.039027 0.345574 0.295702 0.483895 1.381674 1.322422 0.610157 1.923628 0.054934 0.343229 0.296187 0.000184 0.535116 0.005807 -0.104894 0.814555 1.182856 1.592163 0.742365 1.268210 -0.177083 1.343740 0.551570 1.685436 0.007094 1.191470 1.016608 0.707707 1.665888 1.137849 0.898092 -0.003091 0.421768 -0.065630 1.710477 0.300653 0.610312 1.118451 0.603209 1.303471 0.822215 1.965058 0.648670 0.505868 0.670960 1.148010 0.305112 0.998070 1.574722 1.449212 1.716689 1.752824 0.809231 1.253214 0.449726 -0.392325 1.675163 1.053607 0.996508 0.329047 0.585205 0.000009 1.525674 0.078474 1.330304)
     )

;;; 78 all --------------------------------------------------------------------------------
#(78 11.559678967298 #(0 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1)
     11.541502084124 #(0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)
     11.471938943963 #(0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

     9.641959 #(0.000000 1.020290 1.408291 -0.048162 0.671620 1.627590 0.071129 1.746906 1.078642 -0.228570 1.562670 1.826550 0.911949 0.876362 0.548776 1.317498 0.712257 1.668407 0.524678 0.273165 0.887358 1.382633 0.467676 1.365760 0.884857 0.329101 1.697658 0.391326 1.080410 1.742570 1.193854 1.733986 1.717120 1.196025 1.144571 0.754170 1.266889 1.513345 0.832489 0.483448 0.997478 1.234727 1.809411 0.748853 0.610847 1.240143 1.799508 1.051929 1.146276 0.802440 0.751994 1.436083 1.083235 1.549903 0.780207 0.143390 0.470747 0.045865 1.572341 1.539329 1.740309 1.175560 0.185362 0.029751 0.055537 0.420487 0.247579 1.077592 1.075809 0.663668 1.329440 1.367827 0.360196 0.074419 1.968884 1.538382 1.475354 0.284074)
     )

;;; 79 all --------------------------------------------------------------------------------
#(79 11.431832400958 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.407577489438 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.334476470947 #(0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     9.812041 #(0.000000 0.948891 1.218571 1.472572 0.938762 0.146204 1.391742 1.665618 0.098393 0.732461 -0.001965 0.197002 0.191424 1.160562 0.800919 1.813359 0.181256 0.134301 0.912891 0.995358 -0.011168 1.895830 0.509715 0.183792 0.861464 0.186325 1.377336 0.644678 1.687197 0.190927 0.052969 0.499664 0.685412 0.655855 0.514732 1.221426 1.049824 0.318402 1.694186 1.565642 1.452987 -0.046164 1.512952 0.900432 -0.062482 1.576268 1.788010 1.410369 1.384286 0.621769 1.647279 0.488560 0.559511 0.886642 1.538167 1.127114 0.054321 0.570811 1.283126 0.968544 0.546376 0.920163 0.036456 1.915627 1.440112 1.400289 1.409591 0.987901 1.371714 0.418161 0.957435 0.266907 1.275042 0.222459 0.851656 1.813647 0.261046 1.470522 1.568943)
     )

;;; 80 all --------------------------------------------------------------------------------
#(80 11.828915596008 #(0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1)
     11.745326966911 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.438133302082 #(0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.30185508728 #(0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

     9.761224 #(0.000000 0.849953 0.700623 0.414164 1.169747 1.689282 1.824071 1.900141 1.477251 1.465562 0.804678 0.127393 0.517419 0.521018 0.290512 0.304586 1.243153 0.448253 1.413541 1.219998 1.994137 0.399306 0.561255 1.062889 0.493345 1.394299 1.792105 1.987805 0.510562 0.131280 1.504350 0.194580 1.800738 1.320851 0.826285 -0.109713 0.825329 0.428056 0.481668 0.785468 0.704096 1.576130 0.104234 1.185258 0.108241 0.311529 1.223618 0.138917 0.897319 1.465521 0.782511 0.247096 0.939400 0.991608 1.753673 0.394639 0.787392 1.020744 0.912098 0.677994 0.395644 0.532459 1.581656 1.853113 1.406436 0.804991 0.124373 0.159754 1.388314 1.628022 0.867818 0.204371 1.592017 1.888348 0.531406 1.909049 1.710844 1.857131 0.775440 0.178483)
     )

;;; 81 all --------------------------------------------------------------------------------
#(81 11.712129592896 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0)
     11.501712958685 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0)
     11.224431991577 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     9.889576 #(0.000000 0.906401 0.709945 0.525016 0.561753 1.164413 0.602511 1.666068 1.469385 1.455921 0.542166 -0.098258 0.842256 0.114717 1.160749 1.613398 1.162095 1.233921 0.944188 1.963019 1.658251 0.277644 1.792303 0.153246 0.924791 1.053199 1.294175 1.526268 0.773974 0.327623 1.080197 1.145281 0.660939 1.504576 1.799415 0.960210 1.636026 0.576167 0.624871 1.743463 0.869964 1.580933 1.889034 1.804392 0.773427 1.781404 0.283380 0.228309 0.654352 0.778015 0.055175 0.513314 0.504316 -0.013902 -0.012507 1.034868 -0.114413 1.724466 1.884686 1.312031 1.175295 0.403152 1.718040 0.379254 1.287955 0.947535 0.171075 0.259138 0.482536 0.287145 0.835792 1.636773 1.108294 0.613265 -0.066832 -0.007049 0.298984 1.370314 1.780134 0.109597 0.222812)
     )

;;; 82 all --------------------------------------------------------------------------------
#(82 11.697486877441 #(0 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0)
     11.601468306037 #(0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     9.941500 #(0.000000 1.710108 0.015223 0.940796 0.287308 1.637487 0.792121 -0.057650 1.213813 0.448324 0.472167 0.529062 -0.211284 1.755138 0.915526 0.288970 1.169557 -0.064692 1.367660 1.151696 0.535554 1.533013 0.569017 1.753501 0.329299 0.412914 1.006323 1.749602 0.326284 0.281702 0.779654 1.298743 1.924193 0.881947 0.003152 0.151780 0.046001 1.437827 1.250498 0.544797 1.458581 1.565345 1.896542 0.330875 0.169395 1.212970 1.612564 0.483125 1.858039 -0.031546 1.277646 1.393645 1.655736 0.729192 1.681962 -0.046010 0.453247 1.381636 1.703146 1.039152 0.383219 1.012513 0.850010 0.360953 1.731427 0.502588 1.057400 1.517964 0.728327 0.816161 0.098820 -1.844028 0.453610 0.440880 0.631148 1.316615 1.231378 0.995998 1.497170 1.175468 1.485843 0.373721)
     )

;;; 83 all --------------------------------------------------------------------------------
#(83 12.007675490238 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0)
     11.868338980165 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0)
     11.429935034332 #(0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     10.025739 #(0.000000 1.157488 1.225063 1.438714 -0.270810 0.181225 1.665842 1.123376 0.941395 1.731665 -0.209117 0.047899 0.497292 1.230276 0.671948 1.243683 1.553285 0.373764 1.798506 1.515557 0.876497 1.367221 1.284189 0.326216 1.658319 1.399417 0.439282 1.177138 1.495556 1.126354 0.901543 0.458825 -0.309490 -0.186101 -0.081862 -0.145367 0.537585 1.220959 1.571928 0.367684 0.127558 0.025614 0.864465 0.374095 0.473896 0.445742 0.733937 1.519796 0.286262 0.583782 0.595515 0.214430 0.184063 1.670166 1.307690 1.363599 1.038012 0.026539 1.348082 0.172156 0.830310 0.257637 1.107791 -0.045937 1.262256 -0.208948 1.028649 0.997697 -0.000948 0.872851 0.534115 1.008525 0.433624 1.116805 0.810341 1.793505 1.776984 0.452313 1.661565 1.700320 -0.025786 0.726365 0.304708)
     )

;;; 84 all --------------------------------------------------------------------------------
#(84 12.073565240583 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.956374168396 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 1 0)
     11.944072619199 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.81104850769 #(0 0 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.774056434631 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

     10.052154 #(0.000000 0.087410 0.139805 0.162699 1.343558 0.389176 0.455143 1.440056 1.352772 -0.003825 0.362731 0.432135 1.583583 1.355606 1.581392 0.948824 1.451740 1.089294 0.539515 1.517438 1.946813 0.796816 0.490626 1.939978 0.078163 -0.196509 1.597176 1.739305 1.917508 0.978528 0.848651 1.528628 -0.068883 0.445481 -0.479790 -0.228701 1.334930 1.014921 1.347962 1.462051 1.881244 -0.188405 0.705931 1.795163 1.092620 0.383174 0.066986 0.896615 0.657039 0.754600 0.521054 1.193159 1.263670 0.739689 0.555321 1.330379 0.608618 0.981124 0.716262 1.227783 -0.126850 0.198545 1.556264 0.889897 0.388899 1.333434 1.596897 0.735665 1.088769 1.366217 0.320950 1.715652 0.009340 1.307047 0.196494 1.112787 -0.306815 0.695501 0.585720 1.757460 1.094425 1.079023 1.424335 0.695440)
     )

;;; 85 all --------------------------------------------------------------------------------
#(85 12.385174751282 #(0 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1)
     12.285636929325 #(0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0)
     11.951689163871 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1)
     11.927130699158 #(0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

     10.228645 #(0.000000 0.153108 0.226054 1.553221 0.493164 1.110710 0.908515 0.006895 -0.201807 0.626947 1.343747 1.489944 0.508760 1.464461 0.550831 1.762749 1.480159 0.746360 0.889427 0.320173 0.433936 1.051588 1.021038 1.640520 -0.138022 0.624551 0.980605 -0.041903 1.753064 1.845455 1.108015 0.229840 1.718496 0.596174 0.593161 1.039100 0.526870 1.612467 1.478504 0.300644 1.198562 1.402989 1.018406 0.480029 1.252996 0.264704 0.164897 0.411218 1.733932 0.276146 0.661169 1.665737 0.499599 0.880211 0.526259 1.321818 0.842416 1.467438 0.204174 0.882719 0.566826 0.748859 0.903895 1.160461 0.629426 1.544149 1.064376 1.030299 0.330546 1.600532 1.407456 0.725589 1.194701 0.776005 1.076118 0.048473 0.837958 0.446050 0.163854 0.175350 0.007746 1.671127 0.620783 0.793736 0.132264)
     )

;;; 86 all --------------------------------------------------------------------------------
#(86 11.942325532619 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0)
     11.819784750357 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)
     11.780031204224 #(0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     10.363999 #(0.000000 1.856232 0.877405 -0.064257 1.256892 0.035154 1.215916 -0.036316 1.624975 0.982219 0.413673 0.316319 1.627324 0.516075 1.730038 0.897425 0.939870 1.046516 1.146116 1.024494 1.587554 1.559501 1.771000 1.179228 1.784178 0.600816 1.719642 0.705723 0.919747 0.013736 0.808051 0.827790 0.930616 0.997103 1.932991 1.796923 0.991896 1.347433 0.908172 1.308738 0.525056 0.740793 1.428784 1.602136 0.494441 0.359599 0.940275 0.671804 1.266351 1.584056 0.042363 0.298165 0.361754 1.309076 0.726890 0.723373 0.932340 0.466291 0.023439 1.301500 -0.147604 0.524396 1.695175 0.545484 0.699264 1.339287 1.177559 0.424255 1.559697 -0.157189 1.383967 1.284354 1.462479 1.556816 1.203814 1.048983 0.562862 1.829828 1.617731 0.973189 1.361604 0.134186 0.363934 1.209715 -0.020551 1.897001)
     )

;;; 87 all --------------------------------------------------------------------------------
#(87 12.170317807503 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1)
     12.06236076355 #(0 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1)
     11.759829521179 #(0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     10.358711 #(0.000000 0.768161 -0.003076 0.432657 -0.234323 0.363371 1.689514 0.030308 0.311039 0.178210 0.778720 1.359875 0.375640 1.154506 0.280475 0.737858 0.085776 0.632350 1.154015 1.562213 0.257362 1.733152 0.847641 0.038913 1.317961 1.145629 1.164150 0.037070 0.969966 -0.029612 0.042241 0.872711 0.017921 0.689995 0.735127 -0.038644 0.716037 1.321066 0.987810 0.874104 0.501982 1.676353 1.219696 1.920240 -0.008343 1.429768 1.395984 1.106315 1.032918 0.287088 0.086542 0.827486 1.016535 0.175176 1.070624 1.450719 1.527537 0.150201 0.444186 -0.109587 1.675999 -0.042017 0.571938 -0.070084 1.132521 0.578789 1.515869 1.270576 0.658548 0.285186 0.825016 1.674663 1.030745 0.268825 0.723380 0.661256 1.029717 1.488121 0.104529 0.977169 0.649367 0.336081 0.234870 0.403739 0.387650 1.170649 1.631411)
     )

;;; 88 all --------------------------------------------------------------------------------
#(88 12.085149765015 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.991882324219 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.638312339783 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     10.448739 #(0.000000 0.916685 0.652816 1.334803 0.570236 1.693352 0.269588 0.552033 0.524003 1.399032 0.829796 1.611474 1.049108 1.501404 1.836793 1.161566 1.891156 0.603617 0.338094 0.621754 0.312712 1.185787 0.348757 0.295456 0.463308 0.140534 0.499036 1.450051 -0.018273 1.495733 -0.013044 0.483347 1.037652 0.800652 0.613745 0.583588 0.822842 1.379263 0.012733 -0.067148 0.963134 0.680160 0.169402 0.671589 1.547592 0.848959 0.454257 1.557770 1.022106 1.485048 1.059534 0.089451 0.462878 -0.150192 1.233551 -0.171040 0.244180 1.808147 1.346292 1.213608 1.338268 0.118525 0.948224 1.722497 1.639468 1.164943 1.255568 1.233493 1.623826 1.190270 0.054452 0.112383 1.107013 1.056747 -0.003100 0.690824 0.171862 0.379380 1.604982 0.479407 1.330397 1.084354 0.672716 0.320765 1.395330 1.347919 0.688109 1.472757)
     )

;;; 89 all --------------------------------------------------------------------------------
#(89 12.644 #(0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1)
     12.148494905477 #(0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

     10.623097 #(0.000000 0.050384 0.899485 1.053476 0.197036 0.020739 0.338330 0.301960 1.183979 0.625280 0.440290 0.972926 0.999030 0.755116 1.797354 0.065816 0.318159 1.389027 0.337026 0.286822 -0.144090 0.131523 0.571022 0.169731 0.777338 0.516952 1.169034 0.694027 1.424848 0.733027 0.078494 -0.084986 1.817027 1.263214 1.149089 1.204669 0.852032 0.671640 0.478392 0.778916 0.637107 1.466060 0.888702 0.343515 0.003434 0.332155 1.336733 0.883200 0.534673 1.247565 0.929992 0.982394 -0.244039 0.754471 1.510726 0.911300 -0.050778 0.188216 1.647939 0.532340 -0.114221 0.977225 0.171387 1.782511 1.572707 -0.018920 0.533911 1.425743 0.132506 0.928861 -0.239345 1.011760 -0.008727 0.594865 1.264533 1.884249 -1.826100 0.304876 1.024442 0.186949 1.473023 1.211969 -0.272275 0.117110 0.544865 0.183809 1.391393 1.421932 0.967999)
     )

;;; 90 all --------------------------------------------------------------------------------
#(90 12.524876494276 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1)
     12.364291918726 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0)
     12.297218118816 #(0 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0)
     12.059710502625 #(0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

     10.577205 #(0.000000 0.781756 0.794029 0.194172 0.294485 1.486413 0.926888 0.155703 1.241899 -1.935567 0.242076 1.352701 1.768446 1.436662 0.043630 1.771233 1.522601 1.431913 -0.049538 0.895786 0.566760 1.325493 -0.030862 0.257438 0.342818 1.104179 1.718788 0.351444 -0.067688 0.094434 1.511802 0.000905 0.385430 1.171477 0.120650 0.428008 1.159145 0.021066 0.547775 0.112096 0.891948 1.120262 1.327416 0.815006 1.468981 0.935083 1.085970 0.876774 1.220654 0.103570 1.168731 0.229941 1.718399 0.584695 0.524762 1.616146 0.631541 0.620658 1.807100 1.502900 0.140181 0.712728 1.063544 0.575908 1.510769 1.636251 0.567777 0.353056 0.744132 0.986679 0.467823 -0.171297 1.631863 1.782458 1.378258 0.629682 -0.114773 0.702925 0.470095 0.510606 0.222893 1.264363 1.531938 1.162099 0.194188 0.054612 0.633371 0.708299 1.034720 0.444507)
     )

;;; 91 all --------------------------------------------------------------------------------
#(91 12.389336585999 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0)
     12.363633155823 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0)
     12.335505485535 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 1 0)
     12.130150794983 #(0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

     10.739166 #(0.000000 0.362419 1.819267 1.212711 0.856080 1.692009 1.895095 1.059157 0.687298 1.198592 0.574490 1.815789 0.919126 1.496217 0.353070 1.280736 1.096577 0.412150 0.124962 1.686459 1.692912 0.137975 0.296721 1.543716 0.038489 0.719394 0.661397 0.549201 1.508606 0.552920 1.767183 0.088947 1.481531 1.826902 -0.033013 0.089620 1.273503 0.820555 0.475977 -0.048085 0.594249 1.851299 1.603805 0.723288 1.211646 1.760533 0.596168 -0.002933 0.620024 0.594900 1.723321 0.876505 0.880267 1.685946 0.381291 0.387496 0.040765 1.642748 -0.068756 1.073904 1.548321 0.446870 -0.011703 0.057488 0.747982 1.191965 1.348495 1.300203 0.655091 1.353646 1.085821 1.130729 0.864302 0.715618 1.443377 1.090370 1.901558 1.753276 0.110589 1.553991 0.449365 0.014071 1.286666 0.022354 1.374371 1.305915 0.656554 0.346316 1.465240 1.892183 0.534102)
     )

;;; 92 all --------------------------------------------------------------------------------
#(92 12.627931418696 #(0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1)
     12.009957507951 #(0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

     10.851639 #(0.000000 -0.124665 0.540028 -0.223488 0.061621 0.136316 0.147473 1.532116 1.334068 1.630788 0.843900 0.291365 0.552776 1.006430 0.957406 0.696804 0.959222 0.453576 1.681306 0.612316 0.369840 0.781754 0.954883 0.022651 1.798548 1.570198 -0.005545 0.143692 1.750922 0.982556 0.140016 1.341078 0.810838 1.754932 0.296220 1.744618 -0.045877 0.082435 1.447489 1.221832 0.943566 0.835153 0.429072 0.938831 1.518127 -0.066975 0.659557 1.152827 0.525985 0.565610 0.798762 1.122827 0.875988 1.357508 1.125152 1.037635 1.873953 1.812330 0.989765 1.196715 0.208971 0.223283 0.441737 1.093835 1.046411 -0.089302 1.434937 1.363894 0.770289 0.952845 -0.320175 1.478739 1.479164 0.526813 1.819446 0.491633 1.213984 -0.000137 1.813316 0.319324 1.006065 1.662755 0.951400 1.450591 0.663407 0.036155 0.771504 0.072108 1.741727 0.571900 1.397830 1.943036)
     )

;;; 93 all --------------------------------------------------------------------------------
#(93 12.624432854783 #(0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1)
     12.125471062226 #(0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     10.882088 #(0.000000 1.533513 1.760793 1.611317 0.052020 0.311766 0.522578 0.275251 1.710755 1.507081 0.308786 0.688227 1.500372 0.824800 0.786615 1.314073 1.576436 0.941718 1.137382 1.292153 0.382941 0.650187 0.420205 0.533791 0.164908 0.378179 1.206328 0.084520 0.232500 -0.016903 0.148905 1.620743 0.097710 1.342885 0.930415 0.534077 -0.025663 1.798584 1.375180 0.495723 0.641837 0.831443 1.566083 1.927213 1.694046 1.510360 1.851520 1.172547 1.447774 -0.065488 0.731656 0.777035 1.616957 0.207126 1.636083 -0.273595 1.582187 1.464845 0.139141 0.977303 0.253157 0.697859 0.117572 0.050848 1.179099 1.529549 0.330796 1.410067 0.847397 -0.154534 1.801777 0.223870 0.533892 1.322466 0.682903 0.450681 1.464194 1.074925 1.602698 1.283110 0.254173 0.149563 1.060496 1.451484 1.021163 0.298529 1.853157 1.607963 0.734463 1.578050 0.566992 1.609072 0.751059)
     )

;;; 94 all --------------------------------------------------------------------------------
#(94 12.840441703796 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)
     12.510846178591 #(0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

     10.812999 #(0.000000 0.206128 1.159660 0.718743 0.054211 0.994320 1.000582 -0.092064 1.039650 1.184581 0.164013 0.485563 0.719431 0.871801 -0.013160 0.143105 1.588813 0.707480 1.061863 0.322396 1.042973 0.430708 0.249517 0.979501 0.813314 0.597770 0.973811 0.255023 1.938386 -0.022057 0.886932 0.355440 1.697252 0.985046 0.021211 1.456571 0.834736 1.884401 0.523534 0.242431 1.691133 1.214516 1.832061 0.895163 1.468975 1.245912 1.179946 0.435476 1.770325 0.945107 1.043981 1.109360 -0.177952 0.152518 1.908670 0.451591 0.141025 1.484840 0.290972 1.091803 1.007323 1.288424 0.313520 1.749678 1.463173 1.923435 0.227209 1.061404 1.491546 0.808803 0.770451 0.727133 1.146850 1.449044 1.142901 0.759861 1.222930 1.751586 1.396908 0.063561 1.219961 0.937370 0.326792 0.663166 1.672899 0.148714 1.603317 -0.053772 0.408988 0.845283 1.063644 1.115951 0.654390 -0.013132)
     )

;;; 95 all --------------------------------------------------------------------------------
#(95 12.744465939438 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.706251144409 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.448801040649 #(0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.431831359863 #(0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     10.876935 #(0.000000 1.356203 1.072473 1.166461 0.969189 0.542669 0.057633 1.081330 0.583064 0.166899 1.379559 1.881580 0.057047 1.826484 1.064874 1.560332 1.000782 -0.024033 0.723209 1.444982 0.587343 1.713734 0.983475 1.154048 0.421545 1.789030 1.165495 0.802218 1.558711 1.627786 1.356582 1.216647 1.096492 0.575232 1.433372 -0.016780 0.675982 0.822926 1.551497 1.508872 0.263373 0.541831 0.988781 0.622619 0.707988 1.610575 0.087545 0.507636 1.036351 0.067968 0.442204 -0.025688 -0.111763 1.486471 0.841486 1.851155 0.943573 0.210362 1.487301 0.870860 1.595899 1.598896 1.804450 0.969956 1.433376 0.232679 0.382745 1.225749 0.683478 1.444103 0.769263 0.522615 0.863050 0.027448 1.453084 1.630567 1.342493 1.357123 0.073235 0.981186 0.660844 1.135368 1.261909 1.736700 1.275451 1.550467 -0.077388 1.528802 0.103015 1.392994 0.686097 0.823112 -0.023759 0.110550 1.536490)
     )

;;; 96 all --------------------------------------------------------------------------------
#(96 12.828451411951 #(0 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1)
     12.703108787537 #(0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1)
     12.682573318481 #(0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1)
     12.584561347961 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

     11.065539 #(0.000000 1.697634 0.064880 0.179015 0.136938 1.680912 1.576238 1.311387 1.594050 0.683134 0.636774 1.321591 0.052349 -0.449735 0.008835 -0.002075 -0.212326 0.460952 1.532054 1.523199 1.775447 0.886011 0.957329 0.365374 0.118800 1.519942 -0.213903 0.824693 0.766004 1.098761 0.586163 0.410604 -0.186495 0.852191 1.580385 1.525884 1.154474 0.248763 0.526602 -0.431574 0.837576 0.646786 1.774122 1.578752 0.456502 1.079052 0.956393 1.291636 0.254731 1.560716 1.376016 0.446479 1.304240 -0.251962 1.305187 -0.359561 0.658781 1.717913 1.562691 -0.031583 0.478009 0.947631 0.257417 0.386774 0.762040 1.635698 0.934786 1.091998 0.202548 1.181360 0.124202 1.331965 1.133768 1.077511 1.812388 1.439159 1.049071 1.271465 0.996655 0.012862 0.188581 0.700222 0.725173 1.665121 1.435384 0.276342 1.254784 1.835322 -0.077048 0.090210 0.456987 0.855085 0.008460 1.431789 0.760618 1.521507)
     )

;;; 97 all --------------------------------------------------------------------------------
#(97 13.438 #(0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0)
     12.872588157654 #(0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     12.585 #(0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
     11.076815 #(0.000000 1.571906 0.766615 1.739047 1.640128 1.368473 1.782854 0.794255 0.918899 0.996909 0.415574 1.812445 1.282632 0.522840 0.178584 1.444752 1.861672 -0.032328 0.044947 0.133555 0.515690 0.796813 1.749662 0.081377 1.526443 0.833498 1.371683 1.049461 1.495291 0.913116 1.088962 0.112394 1.038227 0.739374 0.543904 1.451791 1.601522 1.790137 1.625170 1.571406 0.572653 1.581470 0.098163 1.492998 1.283816 0.483533 0.042069 1.874448 -0.091482 0.805504 0.192961 -0.270323 0.194928 1.785818 1.206648 1.706837 1.089790 0.480128 -1.879217 1.788795 1.798286 0.024995 1.383995 0.738030 1.552823 1.058896 1.162065 1.901346 1.822984 0.452689 0.943367 0.656137 1.206873 0.510615 1.009722 1.294532 0.302696 1.168607 1.395761 0.456200 0.399441 1.132074 1.456659 0.312723 0.960419 0.321106 0.666658 0.135805 0.611892 0.548711 1.529725 0.973224 1.415044 0.662806 1.680175 0.609479 1.039451)
     )

;;; 98 all --------------------------------------------------------------------------------
#(98 13.163645755645 #(0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1)
     13.161917686462 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1)
     12.721995353699 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

     11.186027 #(0.000000 -0.077624 0.861993 1.320973 1.818012 1.540613 0.781040 0.641601 1.825201 0.560814 1.613359 0.086804 1.047097 0.582824 0.312072 1.851604 0.919145 0.591286 0.375927 1.313003 1.764240 0.067034 1.760731 1.236228 1.136010 1.184924 0.067069 0.293209 1.183713 1.648967 -0.017027 0.313832 1.300038 1.790919 1.191438 0.795408 1.052878 1.386822 0.977300 0.536250 0.887598 0.039736 1.719758 1.743961 1.778888 0.822553 0.429806 0.667062 0.046849 0.016982 1.085776 1.751460 0.288251 0.158673 0.447630 0.549810 1.764901 1.474440 1.601172 0.128493 0.259702 -0.103332 0.393855 0.562620 1.071429 0.070691 0.782166 1.366312 0.736445 1.374909 0.637022 1.927866 0.142313 1.866364 0.568147 0.066000 1.583166 0.245622 1.444012 0.389841 1.836182 1.453109 1.070869 0.458205 1.508069 0.458587 0.173754 1.273508 0.327101 0.496992 0.977771 0.222245 1.572481 0.006605 1.383849 1.961030 1.915181 1.573849)
     )

;;; 99 all --------------------------------------------------------------------------------
#(99 13.236550650051 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1)
     13.002375571256 #(0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

     11.087340 #(0.000000 0.608588 1.059326 0.160907 1.478992 0.214043 1.000042 1.610570 1.731365 1.098932 0.417370 0.682120 -0.183612 0.298789 0.604825 1.272207 -0.025117 0.152652 1.442047 1.718295 1.246399 0.235389 0.507520 1.564082 1.997745 1.496701 -0.186130 1.505787 1.457289 0.851794 1.127672 1.619598 1.286147 0.427190 1.089245 0.342621 0.698183 0.491797 1.486205 0.402585 1.829992 -0.210552 0.603285 0.456324 1.550589 -0.143957 1.820878 1.723442 0.368208 0.584288 0.129773 1.378626 0.696214 1.085783 0.015262 -0.016748 1.912427 1.615219 0.126478 -0.045194 0.221073 0.639474 1.355733 0.793240 1.954081 1.336452 0.075133 0.149647 0.660606 -0.083939 0.711498 0.289469 1.658335 0.804410 1.237783 0.912730 0.994286 1.889721 0.582987 1.060766 1.455451 -0.305872 1.556884 1.009429 0.495063 0.080213 1.507431 1.877916 0.402253 1.825999 0.975967 1.609872 1.075734 0.523494 1.223749 0.784664 0.937883 1.654855 1.113287)
     )

;;; 100 all --------------------------------------------------------------------------------
#(100 13.230233676417 #(0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0)
      12.998435541498 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

      11.205446 #(0.000000 1.868593 0.851485 1.760446 1.342459 1.221213 0.440680 1.393137 0.135429 1.285244 0.145042 0.393039 1.703732 -0.306320 1.112312 0.315938 1.563077 0.295464 0.838863 0.460188 0.723830 0.914537 1.434923 -0.012086 1.519110 -0.171332 1.648598 0.200539 0.448719 -0.141816 1.722334 1.542375 1.776828 0.745516 1.899770 1.228522 0.767396 1.081819 0.391641 1.209180 1.272183 0.887861 1.400908 1.902692 1.930680 1.631547 -0.072971 0.313741 1.274167 0.121794 0.344816 1.639842 1.335601 -0.069415 0.397939 0.911684 1.757510 0.070806 1.992014 1.637483 1.031473 0.674400 0.218831 0.938513 1.145259 0.830933 0.663624 -0.137555 0.200257 -1.941672 1.461305 1.096221 0.178940 1.322018 0.542151 0.935555 1.718290 1.400544 0.245612 0.960009 0.684863 1.357981 0.338288 1.768923 1.391246 1.233399 1.072238 1.295203 1.402312 0.819804 0.022408 0.781051 0.756893 1.453183 1.355780 1.045567 -0.073902 0.848615 0.523315 1.451244)
      )

;;; 101 all --------------------------------------------------------------------------------
#(101 14.018204689026 #(0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0)
      13.645306283587 #(0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 0)
      13.268 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)
      13.219774246216 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

      11.226427 #(0.000000 1.338792 0.314879 0.003450 1.814658 1.485117 1.203857 0.371644 0.384755 0.196942 -0.168746 0.628280 1.632154 0.844396 0.794163 0.147969 1.663198 0.060604 1.521172 -0.164019 0.669802 1.697367 0.941281 0.608986 0.103841 1.466676 0.809237 1.503566 0.670664 0.179238 1.017881 1.506260 0.625203 0.975782 1.028890 0.555292 1.699349 0.995758 0.003181 0.049256 -0.016780 1.876129 0.740718 1.881276 1.367875 1.204923 1.674578 0.208786 0.622245 -0.421034 0.588526 0.526205 0.747091 1.715588 1.786029 1.185195 1.125664 0.302729 -0.521214 1.523950 0.995021 0.258025 1.285242 1.755401 0.623287 1.639740 1.253924 0.732653 0.009039 0.901366 1.564386 1.657735 1.659112 1.361065 1.819964 1.005645 1.441926 0.551622 0.786897 1.354051 0.640250 1.145705 1.274098 1.024148 1.495515 0.964221 1.343172 1.016082 1.818737 1.429317 0.120977 0.047801 0.396629 0.957480 1.292235 1.588975 1.766400 0.295645 0.641042 1.781417 -0.197238)
      )

;;; 102 all --------------------------------------------------------------------------------
#(102 13.521512151222 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0)
      13.497511863708 #(0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1)
      13.300039088203 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)
      13.194128990173 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      11.353440 #(0.000000 0.033506 0.813657 0.426885 0.739145 0.863386 1.991692 1.985685 0.327979 1.834481 1.466581 1.288067 0.471177 0.457400 0.660569 0.498005 1.682761 0.310118 0.381718 -0.344000 0.434556 1.519084 1.335110 0.618088 1.605526 1.619214 0.768566 0.337117 0.538031 1.768289 1.681477 0.741073 1.366096 1.143853 1.004972 -0.099909 0.003445 1.869089 0.423649 -0.039422 1.074468 0.532916 0.432567 0.451045 0.363312 0.324539 1.167081 1.736427 0.542473 -0.195238 0.764847 0.123432 1.495339 0.228971 0.629736 1.184132 1.899303 1.798583 1.072620 0.805499 0.788349 0.172718 0.144097 1.480979 0.627329 -0.160932 0.968110 1.745686 0.318612 0.009760 0.480607 0.538111 0.981784 0.161247 0.455220 0.587784 1.542385 0.603745 0.166545 0.970270 1.829676 0.920592 -0.118136 0.890450 1.274305 0.678939 1.404733 1.463757 -0.333130 0.075449 0.894931 -0.130480 0.179151 1.037620 1.277398 1.156215 0.227128 1.275983 1.123210 1.054072 0.834296 1.653702)
      )

;;; 103 all --------------------------------------------------------------------------------
#(103 13.720711052869 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.67035285163 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.435972213745 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

      11.503919 #(0.000000 0.642438 0.624481 0.731329 0.037418 0.215821 0.719212 1.666060 0.629840 1.096115 0.383816 0.781814 -0.025059 0.140444 0.252806 1.791023 1.783360 1.108352 1.854126 1.936053 -0.160538 1.731384 0.665929 1.710024 1.309978 -0.108312 0.455098 1.339514 1.370493 1.395558 0.329394 0.785393 1.244549 1.002456 0.600102 0.199540 -0.144180 0.929905 1.138464 1.107803 0.413804 0.034098 0.852181 0.864870 1.561903 0.835432 1.741259 1.220587 1.804669 1.758251 1.345996 1.220725 1.657039 0.902004 0.000401 0.886435 1.315232 0.351465 1.071256 -0.004775 1.622453 0.297264 1.222579 1.531817 1.291788 1.223101 1.819299 0.909248 1.814598 1.420611 0.767842 1.878198 0.135785 1.490476 0.663319 -0.006452 0.172180 0.884840 0.005122 1.692218 0.694947 -0.123575 1.776887 0.244576 0.876581 0.506796 0.704305 0.725657 1.372007 1.220722 1.425514 1.376369 0.300206 1.777638 1.030218 1.161170 0.090849 0.273511 0.601445 0.303634 0.213328 1.294694 1.378693)
      )

;;; 104 all --------------------------------------------------------------------------------
#(104 14.242193222046 #(0 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.682311361591 #(0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.330215043333 #(0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

      11.629931 #(0.000000 1.324434 1.802615 0.914308 1.569483 0.916157 0.525362 1.290282 1.647480 0.746799 1.322097 -0.069326 0.674362 1.212515 1.081106 0.183307 1.019836 0.252486 0.409388 0.819798 1.638687 0.676800 1.476326 0.652611 0.087255 0.472853 1.458381 -0.004669 0.643053 0.207174 0.804671 0.165020 1.670848 0.219159 0.632773 0.322325 1.935931 1.762931 1.603391 0.467545 0.983352 1.820759 0.764305 0.399853 -0.001712 0.741446 0.033460 0.565964 1.642179 -0.098218 1.623251 0.875931 0.518073 1.039761 0.494728 0.264300 0.710620 1.429730 1.732920 1.409778 0.019348 1.108088 0.275017 1.791441 0.483102 0.080286 1.393637 1.273902 0.267424 -0.079934 -0.022137 1.385186 1.230465 0.620352 1.234591 1.219911 0.978614 1.053520 1.679539 1.859175 0.214899 0.542207 0.882286 0.180068 0.205903 1.408136 1.720835 -0.161152 0.210637 1.525363 1.478270 -0.102306 -0.018462 1.843101 0.115511 0.455952 0.753797 0.914717 0.386738 1.193268 0.459976 -0.032498 1.205857 0.836879)
      )

;;; 105 all --------------------------------------------------------------------------------
#(105 14.418999645918 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)
      13.595993876506 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

      11.237963 #(0.000000 0.745554 0.350212 1.315584 1.292101 -0.151270 0.374368 0.672030 0.264031 0.763110 -0.316162 -0.069774 1.248638 1.670850 0.934227 1.460352 0.032024 0.877710 0.121585 1.760599 1.373658 0.849092 0.329102 1.427403 -0.058526 -0.108055 0.457658 0.588804 1.296164 1.243452 1.136114 1.121189 1.091487 1.757186 1.270512 1.636400 0.649233 1.422491 1.901784 1.356085 0.293192 1.606058 1.172021 0.904989 0.874654 0.403954 1.195402 0.528213 0.711280 1.539204 0.521491 1.421442 1.285541 0.310063 0.203823 0.801529 0.598313 0.778814 0.763321 0.092009 1.357195 1.341502 0.328775 0.201725 1.498419 1.826902 1.767186 1.481519 0.401354 0.066075 1.323172 1.537666 1.345473 0.847330 1.122819 0.271825 -0.118512 1.893924 0.154604 0.811826 0.035863 0.876884 0.448125 0.103174 1.709026 0.339461 0.027066 0.390857 -0.242782 0.782991 0.161195 0.829440 1.183344 1.882349 0.660766 0.570526 1.044544 -0.076488 0.450075 1.927583 1.573354 0.296297 0.734191 1.716046 1.291267)
      )

;;; 106 all --------------------------------------------------------------------------------
#(106 14.299785614014 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.811582734804 #(0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.421741504769 #(0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0)
      13.200031373463 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      11.551845 #(0.000000 0.154939 0.494837 1.232988 1.011967 0.667455 1.939025 0.672963 0.830828 0.926002 1.466047 1.218314 1.422563 0.101738 0.223454 -0.045159 1.351828 0.705686 0.254135 -0.063453 0.552405 0.570565 1.572808 1.823808 0.995299 0.279648 0.572441 0.321493 1.451435 1.144853 -0.049794 0.179106 1.251848 1.850906 1.183788 0.475992 0.129237 0.904448 -0.123841 0.213797 1.277603 0.697856 1.511196 0.966165 1.289721 0.023200 0.988667 0.324529 1.406046 0.225529 1.577540 0.675953 0.734479 1.005351 0.474357 0.617242 1.239401 1.699346 0.512615 1.371469 0.550539 0.932951 1.301520 1.619003 1.102642 0.096569 1.584029 0.921243 0.376471 0.781641 -0.206877 1.675369 0.106790 -0.213302 0.203158 1.804057 -0.098797 1.185521 0.018385 -0.011774 1.741316 1.489157 0.925403 0.952262 0.902719 -0.155280 0.221954 -0.031365 -0.075811 0.564677 1.809727 0.454784 1.079270 0.364947 1.281031 1.912901 0.367028 0.433443 1.745669 0.043126 0.265973 1.547786 1.652240 1.213929 -0.074558 1.384415)
      )

;;; 107 all --------------------------------------------------------------------------------
#(107 13.927956268954 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1)
      13.912716531306 #(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0)
      13.624429092956 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)
      13.224366750161 #(0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      11.672138 #(0.000000 1.273332 0.605859 1.517230 1.681313 0.261227 0.281791 0.764373 1.400455 0.617004 0.760051 0.299318 0.713055 1.355757 1.267192 0.566218 1.320397 -0.011041 0.269239 0.975480 0.100449 1.842247 1.179836 0.390834 0.064449 1.446034 1.342752 1.756804 0.463167 1.886062 0.407512 1.806029 1.506255 0.056666 1.423248 0.990839 1.849867 1.076471 0.146892 0.723614 1.326621 0.268317 0.149281 0.115087 1.365084 1.485189 1.633582 0.325606 0.182408 1.024421 0.791480 1.246252 1.452683 1.713358 0.964680 0.676814 0.705788 1.293945 1.123113 1.219919 0.101291 0.970832 1.540385 0.437722 1.906593 1.290537 1.663886 1.178447 1.493521 1.198636 0.428726 1.546724 1.149287 1.436803 0.605484 1.381882 0.164141 0.119607 1.045131 0.752297 0.198365 1.747961 0.414002 1.270170 0.848257 0.747684 0.172435 1.498347 1.643628 1.815666 1.763759 1.684907 1.429983 0.159056 0.337212 1.074908 -0.130430 1.766271 1.540301 1.639339 1.789242 0.757550 0.114031 1.116091 0.242801 0.713601 1.708778)
      )

;;; 108 all --------------------------------------------------------------------------------
#(108 14.009567264777 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0)
      13.998919339781 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0)
      13.694299006963 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1)
      13.534 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

      11.766817 #(0.000000 1.199355 0.464263 1.735078 1.335044 1.227298 1.276769 1.431161 0.322493 1.323403 1.026299 0.154198 0.249880 0.054026 0.615821 0.464020 0.948814 0.500081 0.588273 -0.323593 1.389523 1.346058 0.713123 0.108051 0.809822 0.677424 -0.069003 -0.304873 0.788605 0.224715 0.905113 1.379121 0.690799 1.084078 1.724654 0.992438 1.867124 0.109860 0.690233 0.719425 1.045101 1.616467 0.625616 0.781868 1.753941 0.758536 1.550663 0.022188 0.832630 0.236765 0.507933 0.469621 1.346460 1.137901 0.249932 1.602189 0.133673 1.624337 1.058547 1.205580 1.075794 0.610036 0.772932 1.048076 1.288097 0.627513 0.144955 0.670662 0.221747 0.961249 0.254335 1.608190 1.628685 0.254751 -0.046907 0.670936 1.216036 0.343172 0.045792 0.654638 1.210942 1.134667 0.266329 0.599235 1.313478 1.342538 0.573063 1.369521 1.527081 0.859405 0.038307 1.776319 1.521895 1.679454 1.106763 -0.045726 1.523197 -0.130397 1.053416 0.050753 0.494348 0.300980 1.384145 1.460064 1.599581 0.931942 1.477854 0.675824)
      )

;;; 109 all --------------------------------------------------------------------------------
#(109 13.820175866598 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)
      13.496821304096 #(0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      11.837220 #(0.000000 0.108677 0.522646 -0.034030 1.185217 0.303335 1.143072 -0.166781 0.029268 1.704710 1.106903 -0.035379 1.458675 1.803844 1.775271 1.553035 -0.175448 0.983651 0.234080 0.414798 1.048620 1.607296 1.249600 1.254342 -0.119842 1.550868 1.582109 0.432851 0.981641 0.707891 1.400726 0.951488 1.739159 -0.128191 1.799484 1.356613 0.801940 0.284379 0.047535 1.633938 1.897509 1.380843 0.340298 1.088085 1.824244 1.427412 1.529281 0.820266 -0.063518 0.808197 0.398917 0.934217 0.102700 1.479345 1.086338 0.963412 0.532074 1.336804 1.713076 0.433535 0.154603 1.737381 1.314728 0.179368 0.443618 0.799491 1.586887 0.087102 1.803519 1.177157 1.205477 0.817652 0.918115 1.072858 0.306310 1.753580 0.152089 0.309190 0.586906 1.271002 0.580909 0.553534 0.902876 0.795989 0.564247 0.863521 0.030376 1.473444 0.527495 0.826118 1.515672 1.911836 0.813147 1.154967 1.378708 0.542514 1.298997 0.367079 0.499190 1.098268 0.087576 1.438361 0.132632 0.056788 1.471277 0.684938 -0.086900 0.175413 1.174559)
      )

;;; 110 all --------------------------------------------------------------------------------
#(110 13.885513312292 #(0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0)
      13.64278793335 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)
      13.592092514038 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      11.909439 #(0.000000 1.268211 0.028058 0.705304 1.938246 0.294521 1.252144 1.358396 0.584424 1.269077 0.442773 1.756351 0.014042 1.415206 0.517132 0.824358 1.182239 0.982304 1.136229 0.004899 0.831559 1.112787 0.798666 0.554750 0.452747 1.037564 0.984801 1.261593 1.101959 0.861396 0.322760 0.625541 0.944567 0.312404 1.604795 -0.067717 0.889878 0.246074 0.891262 0.075451 1.731800 0.037333 1.523683 0.490460 0.782009 1.106095 1.519391 0.582620 1.706990 0.485748 0.321223 0.781802 0.172535 -0.075150 0.729409 0.994662 1.386562 1.806334 0.579669 1.236679 0.506167 1.165890 1.294532 0.841385 1.179729 0.931941 1.872152 1.262849 0.338990 0.478177 1.744884 -0.000313 1.822205 1.359935 1.212150 0.760045 0.987588 0.428973 1.346561 0.658919 1.521563 1.350497 1.491548 0.168429 0.418897 1.581078 0.502297 1.134048 1.001486 0.095834 1.354031 1.769051 1.864888 0.572228 -0.057025 1.653986 1.945685 0.212462 1.293241 0.407531 0.677611 0.412527 1.082960 0.569539 1.785506 0.960651 0.713488 1.769381 1.309850 0.264743)
      )

;;; 111 all --------------------------------------------------------------------------------
#(111 14.436 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)
      14.359505653381 #(0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0)
      13.80813938144 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

      11.934187 #(0.000000 1.271720 0.927869 0.036107 1.885902 0.016357 1.728824 1.528828 0.341679 1.388164 -0.005587 1.121558 0.209312 1.265554 1.039733 0.186125 1.378156 0.638636 0.556764 1.887205 0.326411 0.588233 1.053519 1.263717 0.224772 0.030513 0.860727 0.339447 0.906024 1.002152 0.093827 0.870421 1.731491 0.666741 1.278714 1.477189 1.409698 0.806517 0.247599 1.236019 -0.057760 0.460409 0.946961 1.321665 1.656591 1.620073 0.346065 0.611741 0.004191 1.246150 1.104838 1.167979 1.167605 1.047397 0.237937 0.468414 1.528743 0.194701 1.571301 0.980407 1.467221 0.943805 0.859207 0.858724 0.398695 0.518071 1.267996 0.945316 0.786899 1.739741 1.328510 -0.025134 0.780698 0.554107 1.591855 0.738575 1.856656 0.157092 -0.120708 0.480286 1.719192 0.107955 0.772534 0.185501 0.225530 1.364882 0.923505 0.851746 1.611588 1.799682 1.830186 1.210342 1.728743 0.632146 0.504922 1.837774 0.377777 1.444570 1.575887 1.009171 0.337760 1.219472 -0.179325 1.626301 0.501114 0.309848 1.722955 0.328430 0.278255 0.652840 0.150053)
      )

;;; 112 all --------------------------------------------------------------------------------
#(112 14.387 #(0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.250584755219 #(0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.059637729172 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1)
      13.719 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      12.100818 #(0.000000 -0.120886 1.196394 0.747422 0.429369 1.235874 1.060811 0.783894 1.073007 0.471712 -0.146924 1.036155 0.235017 1.522789 1.234016 0.625248 1.109723 0.695519 0.380635 1.645883 1.795323 0.307836 0.447065 0.529222 0.726232 0.571096 1.241043 0.703677 0.217969 0.763665 1.767227 1.882979 0.728467 0.421902 0.204712 0.358803 0.743508 0.183715 1.702810 1.578865 1.771524 1.909155 0.495908 1.548011 1.640252 1.767712 0.371657 0.436132 0.342175 0.548371 0.814661 1.805210 0.140691 -0.036828 0.601490 0.826751 1.598103 -0.054712 0.550031 0.878137 0.916583 -0.013532 0.497593 1.168003 0.613303 0.624134 0.754079 0.327371 1.894242 1.654396 1.521902 1.200647 -0.013146 1.879351 0.342434 1.158380 -0.208593 0.504035 1.035217 1.757111 0.613013 1.582067 0.573931 1.402280 1.176092 1.515996 1.290131 0.600610 0.464734 0.113785 1.286160 0.243936 0.527428 1.486164 1.224712 0.297987 0.078482 1.025275 0.586206 0.981384 1.946520 0.804135 -0.043856 0.912266 1.558613 1.384185 1.145540 1.284572 1.318819 0.383864 1.230875 0.433262)
      )

;;; 113 all --------------------------------------------------------------------------------
#(113 14.501041453443 #(0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1)
      14.027848738379 #(0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      12.245106 #(0.000000 1.103939 0.973632 0.065308 0.284961 0.786358 1.003815 1.680688 -0.082137 0.342698 1.258535 1.425826 0.006615 0.484268 0.501303 0.119246 1.876535 1.033031 1.718890 1.359854 0.082390 1.835536 0.528915 0.686012 0.157046 -0.411203 0.735856 0.396615 1.489755 0.411270 -0.112913 1.627314 0.432900 1.436230 1.292568 0.539699 0.578831 0.518331 0.485521 1.619843 1.614311 -0.083460 0.966062 0.538120 0.585329 0.748888 0.496373 0.365949 0.945210 1.446355 0.807332 0.118732 -0.136180 0.991513 1.157152 -0.112518 -0.003976 0.013596 1.796194 0.482479 0.605848 0.310812 0.940372 -0.165711 0.745567 1.801120 0.754389 0.326313 0.714448 1.529039 0.883206 1.403191 0.837520 1.268241 0.038793 1.323254 -0.234951 1.781548 0.830261 0.893719 1.447270 0.149508 1.011813 0.271339 0.902975 0.956970 0.427918 -0.215568 1.471648 0.555875 1.495950 0.499397 0.703943 0.657471 0.110875 0.728256 0.524874 0.064041 0.979702 1.231060 0.449524 0.164723 0.043050 1.376984 1.528553 0.996656 1.491110 1.760620 0.854197 1.410067 0.737956 1.164800 0.586595)
      )

;;; 114 all --------------------------------------------------------------------------------
#(114 14.119774267447 #(0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1)
      13.847382931726 #(0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      12.288015 #(0.000000 0.500540 1.019924 0.976104 0.981215 0.207763 1.836828 0.876167 1.683051 1.095502 -0.600389 0.228981 0.140533 1.290423 0.082859 0.649201 1.446298 1.551118 1.436129 -0.642346 0.509515 0.981654 0.675710 0.311719 0.850727 1.405493 0.799289 0.791356 1.487966 1.095212 0.374319 0.916271 0.182581 1.846820 1.883249 -0.083563 0.054203 0.017259 -0.061136 1.399032 0.797845 0.144907 1.117177 1.271567 1.612170 1.714513 0.985121 -0.221173 1.399781 1.348299 1.644228 0.629481 1.021117 0.545934 0.481084 1.303104 1.468560 1.226267 0.171933 1.776156 1.558005 1.539863 0.647089 0.742419 1.095817 0.951286 0.192959 1.125382 1.158645 0.103850 1.150763 0.584375 -0.127645 0.229182 0.794434 1.517871 1.133999 1.247411 0.291525 1.456542 0.780637 1.071900 0.046852 0.457507 0.873513 -0.342021 1.619257 0.870908 1.784563 -0.121623 1.608213 1.159906 -0.291342 1.736203 1.499701 0.609802 0.477199 0.733100 1.601106 0.079890 1.511853 0.046022 1.328610 0.517034 0.033699 0.860822 1.909963 1.445642 0.032877 0.187570 0.992277 0.244055 1.114042 0.037041)
      )

;;; 115 all --------------------------------------------------------------------------------
#(115 15.196797370911 #(0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0)
      14.357827171854 #(0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

      12.380998 #(0.000000 0.198086 0.289482 1.014084 -0.014776 1.666798 0.053972 0.507944 1.384979 1.821740 0.413563 -0.102378 0.947184 1.213262 0.268982 0.624420 0.196481 1.018690 0.019217 1.401002 0.161430 0.811143 0.756566 1.258692 1.422819 1.176856 -0.001991 1.541447 0.160741 0.636255 1.553080 0.661610 1.836630 0.761282 1.258540 0.059793 0.176618 0.514167 0.667605 -0.015600 0.273514 0.975377 1.527971 1.539902 1.005297 1.396226 1.340616 1.315146 0.662168 1.776806 0.375609 1.534161 1.277423 0.703018 1.355228 0.256993 0.726076 0.371796 0.342633 1.169496 1.491731 0.504601 1.924870 0.214720 0.272989 1.103260 1.566822 0.888179 0.020365 -0.047244 0.148626 1.638744 -0.104941 1.545369 0.608384 0.485210 0.729896 0.941755 1.994614 1.174567 0.946549 0.854798 1.582070 0.854743 0.305492 1.715433 0.527199 0.241854 1.133672 -0.009987 1.409992 0.928014 0.580916 1.303375 0.801318 1.690851 0.573771 1.142211 0.377676 0.254326 1.897579 0.046329 1.940447 0.755233 0.506529 0.037756 0.601119 1.025291 0.616410 0.623686 -0.047155 1.691025 0.523023 0.197232 0.272089)
      )

;;; 116 all --------------------------------------------------------------------------------
#(116 14.827812113225 #(0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1)
      14.175787507646 #(0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

      12.360202 #(0.000000 0.897694 0.067480 1.231395 0.499332 1.556017 1.560318 0.980419 0.279021 0.916791 0.985606 -0.058163 1.697955 0.803740 0.502698 1.269603 0.173599 0.750217 1.420338 1.773155 1.738094 1.136057 1.728175 0.779439 0.341249 0.110409 0.976597 0.398577 0.191228 1.340262 1.069852 1.555855 0.573874 1.886544 0.751984 0.263879 1.862301 1.069324 -0.265917 1.048823 0.387346 1.176471 0.880174 0.272931 1.515367 -0.184389 1.386405 1.649195 1.465810 0.077166 1.791759 -0.055353 1.257265 1.336708 1.430742 1.113685 0.004500 1.575019 1.468284 0.716329 0.586055 0.345884 1.145183 1.695153 1.388220 1.832703 0.993875 0.893922 1.738917 0.304159 1.486135 0.515567 0.809002 1.180717 0.906158 0.006322 1.262581 0.868401 0.365775 1.721752 1.578263 1.399258 0.233956 1.076207 1.677829 1.720775 1.005460 0.343548 0.930915 0.303925 0.576610 1.628103 -0.100829 0.176694 1.310002 1.411529 1.458148 0.662166 1.396507 0.136147 1.509284 1.231095 -0.024487 1.297615 -0.356486 0.008398 0.115960 0.750315 0.751453 0.556300 0.309519 0.477273 0.506761 0.917787 -0.052778 0.458572)
      )

;;; 117 all --------------------------------------------------------------------------------
#(117 14.857519237248 #(0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0)
      14.522986412048 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)
      14.136 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

      12.294123 #(0.000000 1.411673 0.709266 1.608873 0.151122 1.587702 1.511041 -0.436216 0.043664 0.706536 -0.000592 -0.030192 0.113192 1.758728 0.356164 1.319296 1.559228 0.215455 -0.083207 0.820166 0.103873 1.281647 1.012249 1.673347 -0.171928 0.839173 1.737150 1.127261 0.916494 1.490143 -0.267658 -0.000101 1.616555 0.989814 -0.039935 1.332685 0.023128 0.620975 0.328569 0.427746 0.133907 0.060760 1.744782 1.618305 1.884240 0.254044 1.337915 0.589761 0.407218 1.742806 1.352466 1.317196 1.590578 0.059583 0.877327 0.642263 0.675565 0.184743 1.611529 0.895176 -0.110727 1.846665 0.167949 1.197241 0.144425 1.116672 0.368531 1.523402 0.856745 1.066477 0.641440 0.737210 1.680770 0.432626 1.562605 1.502861 1.315316 1.477321 1.617354 0.730156 1.529241 1.423764 1.873632 0.836031 0.180376 1.870067 0.360390 1.351110 1.358292 0.715661 0.678100 1.295583 1.354127 1.547789 -0.007568 0.889848 -0.000067 1.786073 0.887590 -0.049135 0.779899 1.111370 0.911974 1.885862 0.711038 1.008055 0.885660 1.783206 0.094656 1.396929 0.536035 0.405379 0.100643 0.779618 1.428826 0.126675 1.364167)
      )

;;; 118 all --------------------------------------------------------------------------------
#(118 15.151820108516 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0)
      14.496 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1)
      14.207115029287 #(0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

      12.546590 #(0.000000 -0.091116 -0.024302 0.184686 0.071363 0.689812 0.119097 1.906846 0.449217 1.459426 0.966109 1.922899 0.620095 0.268239 1.183044 1.057063 -0.010028 0.498275 1.415582 -0.355229 1.346084 0.127844 0.769024 0.469918 1.653248 1.863339 1.412298 1.287822 0.482286 1.864868 1.673639 0.019381 0.785074 0.258807 0.243806 0.172621 0.849110 0.326794 0.226846 1.656261 1.345740 1.286758 1.604256 -0.466633 1.029224 0.120318 0.938695 0.589264 1.177953 0.129192 1.460322 1.263609 0.983175 1.133898 1.385786 0.473504 0.867138 1.121704 0.237198 0.955930 0.691964 0.614747 1.004321 0.916498 -0.063450 1.354042 0.894127 0.162087 1.628106 1.087530 1.051115 0.856470 0.140401 0.680003 0.814048 0.735917 -0.347759 0.781731 1.210680 0.141657 0.917633 0.669383 1.611219 1.406657 1.822562 1.188525 1.473883 1.400863 1.028711 1.534565 0.748507 1.653461 0.013037 0.514321 -0.185747 0.319164 1.178268 1.060960 0.926520 0.232936 1.361883 -0.101888 0.417759 -0.237705 0.605009 0.498965 1.120658 -0.211730 1.739993 0.533026 1.004932 0.799585 0.253934 0.767989 1.278913 0.327493 1.191041 1.144850)
      )

;;; 119 all --------------------------------------------------------------------------------
#(119 15.63721370697 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.803846337507 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.502624011553 #(0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      12.691331 #(0.000000 0.668119 1.029573 1.291248 0.389351 1.586897 0.278481 1.912570 0.975533 1.660767 0.689147 0.557839 0.691754 1.563827 1.801832 0.650329 0.091893 0.553986 0.666732 0.338706 1.677831 -0.377327 1.211836 0.294250 -0.078658 1.720829 0.833463 1.096874 0.067307 1.470068 -1.953991 0.120657 0.769402 0.899979 0.216349 0.498652 1.230949 0.368353 1.795579 1.685721 0.857300 0.889138 1.001283 1.051498 -0.214434 0.166192 0.012779 0.310866 1.583387 0.273874 -0.014109 0.404806 -0.173385 1.718740 1.148442 1.527503 1.337129 0.245733 0.219964 1.391092 1.576852 -0.037133 0.996611 0.604965 0.720824 0.592424 0.169094 0.504370 0.951965 0.076639 1.558650 0.519992 -0.129837 0.266140 0.420462 1.638337 0.613710 0.037431 -0.207216 0.480291 1.497393 1.605107 1.770977 0.620707 0.179006 0.088819 0.663358 0.639366 1.729497 0.256496 0.085332 0.921509 1.881464 0.247408 1.857931 -0.042786 1.076874 0.883464 0.916663 1.222914 1.244688 0.873335 0.077992 -0.194817 0.627469 1.614029 1.228647 1.699540 0.604442 0.934913 0.729135 0.451717 1.486532 0.777007 1.110335 -0.095917 0.865879 1.086363 1.547137)
      )

;;; 120 all --------------------------------------------------------------------------------
#(120 14.761 #(0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1)
      14.534638752286 #(0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

      12.588831 #(0.000000 1.644074 1.060692 0.686124 -0.056225 0.725540 1.371624 0.384384 0.400925 1.890016 0.775898 0.358332 1.793280 1.328305 0.299398 0.484030 1.590263 0.079759 0.584829 1.436720 0.120848 0.431922 -0.140308 -0.150413 0.411228 1.400974 0.058285 0.291916 -0.412136 1.794872 0.573114 1.011248 1.550369 1.229455 1.561685 0.500335 1.193261 0.109053 0.606577 0.134923 1.789684 1.261898 0.022856 1.756839 0.476419 -0.152734 1.765831 1.414170 1.294114 0.551826 1.749699 0.108708 1.969999 0.112475 1.564110 0.373758 1.273918 0.877979 1.297544 0.648479 0.192923 0.261624 0.063435 0.984018 0.105288 0.333208 0.892861 0.398357 -0.101587 1.076541 1.091862 1.195156 0.297431 0.978954 1.638614 -0.163671 -0.101608 0.849750 0.000769 1.425993 0.181004 -0.388944 1.442944 1.391068 1.509862 1.439090 -0.009790 0.551871 1.420915 0.544233 1.583291 0.720826 0.701949 1.599795 1.019893 1.282200 1.206180 0.131822 -0.073669 0.152613 1.654633 0.878879 1.784375 1.333891 0.140816 0.618038 0.676821 -0.051210 0.001860 0.173355 0.629401 0.964878 0.855242 -0.084179 1.387594 0.225804 0.167770 1.973399 0.497659 1.773925)
      )

;;; 121 all --------------------------------------------------------------------------------
#(121 14.765577345045 #(0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0)
      14.619540214539 #(0 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.284549346494 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.184466362 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      12.780886 #(0.000000 0.921607 1.334075 0.624263 0.465731 0.068908 0.633342 1.285097 0.930866 1.713419 1.429899 1.539533 0.357428 1.247801 1.366784 0.424691 1.459139 1.362552 0.503567 1.837263 1.327415 1.064397 0.335918 0.774165 0.135008 1.690894 1.492949 0.604986 -0.041359 1.590097 0.894693 1.414205 0.425148 1.395459 1.219398 0.661493 0.232102 0.376217 0.197018 0.855667 1.315834 0.548457 1.358990 1.678569 0.018381 1.806603 1.739434 1.016803 0.719929 1.022353 1.435968 1.373173 0.383408 1.627997 1.402754 0.617521 1.271459 0.178806 -0.021781 1.659858 -0.148446 1.550044 0.403993 0.607800 0.611815 0.205534 0.425596 0.268539 0.112582 0.648879 0.733162 1.031861 1.219921 1.828930 0.382309 0.869126 0.053703 1.050649 0.182557 1.665150 0.662213 1.740009 1.002030 1.845984 0.949621 1.407760 0.642802 0.743544 1.106994 1.449709 0.889328 -0.084080 0.479426 1.138540 0.997389 1.793954 0.788354 0.680615 1.218558 1.595447 1.063816 1.068849 0.543900 1.821396 0.170528 0.685083 1.201308 0.916507 0.801130 1.149604 1.750293 1.007936 0.521938 0.658933 -0.040451 0.334688 0.018511 1.991617 0.962237 0.362572 0.471698)
      )

;;; 122 all --------------------------------------------------------------------------------
#(122 14.800878258504 #(0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0)
      14.536 #(0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

      12.752643 #(0.000000 1.692806 1.875725 0.748813 1.153361 1.326923 -0.185043 0.181177 1.046209 1.414550 0.331511 1.331542 1.868375 0.221829 1.046333 1.213271 1.177159 1.598918 1.192007 1.600782 1.680855 0.707651 0.139046 1.243119 -0.053652 1.477642 0.576765 0.392856 1.099683 1.772377 1.071577 0.660196 0.731118 0.188911 1.344378 0.793303 0.518461 0.483954 1.112245 0.609469 1.392308 0.335082 0.888215 1.483300 0.667019 1.178748 0.164218 1.693634 1.401725 -0.294579 0.695176 1.679237 0.164380 1.004706 -0.005602 0.869507 1.617295 1.863852 1.653416 0.863780 0.195217 -0.027013 1.405428 0.189480 0.332535 0.761845 1.077014 1.300609 1.219293 0.900976 1.080629 1.111447 1.426706 0.212480 1.265048 0.742358 0.268230 0.340647 1.455004 0.464030 1.119925 0.525204 0.143826 1.196382 1.636684 0.291589 1.390829 1.142294 1.696490 1.805371 1.410472 1.266990 1.015672 1.094951 1.100550 0.547119 -0.074347 0.244448 0.213644 0.323551 0.960673 1.532917 1.469089 1.505398 -0.390326 -0.205259 0.180754 0.283347 0.111835 1.628254 1.400497 0.487478 1.889223 0.836312 0.084681 -0.065014 1.351806 -0.260958 1.003602 0.040683 1.340175 0.895559)
      )

;;; 123 all --------------------------------------------------------------------------------
#(123 15.175 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.041822824398 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.006 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.80501968131 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.67458183944 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      12.544777 #(0.000000 0.072592 0.361716 0.808266 1.587909 -0.110056 -0.168163 1.463149 0.597961 -0.132517 0.961379 1.834150 -0.027956 0.160219 1.061024 1.826703 0.983466 1.184096 1.197243 1.750333 0.113029 0.012173 0.626358 1.036501 0.126739 0.155943 0.949869 1.031230 0.846789 -0.267840 -0.191075 -0.034428 1.539534 0.904484 1.191888 0.112683 0.554914 1.534297 -0.042405 0.424300 1.762941 1.441586 0.522775 -0.103453 1.438082 0.782133 0.937759 0.200255 -0.099179 0.810392 0.864263 1.014185 1.884355 0.165964 1.113024 0.704746 1.821410 0.284540 0.612239 0.041038 0.044396 1.396180 1.294069 0.110071 1.267682 0.467194 0.199274 0.236132 0.221817 0.028849 -0.073334 0.071926 0.943744 0.392059 -0.154692 1.731575 1.112914 1.887396 1.198463 0.975841 0.130015 1.189040 1.765375 0.070362 1.302600 0.080165 1.383764 0.422391 0.805871 0.074446 1.533318 0.299520 0.258833 0.498608 -0.006555 0.770415 1.786135 1.199547 0.171151 0.498708 1.018274 0.004210 0.939486 1.465940 1.393415 1.367295 0.607958 1.373269 0.765949 0.145466 0.881134 1.613256 0.746265 -0.003664 0.048103 1.011183 1.263707 1.189834 1.230287 1.359011 1.255249 -0.292743 -0.422467)
      )

;;; 124 all --------------------------------------------------------------------------------
#(124 15.808239936829 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      15.141 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      14.607 #(0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

      12.965947 #(0.000000 0.120938 1.793207 0.828066 0.980329 0.627232 0.266377 0.224967 1.489277 -0.092090 0.267033 0.477872 -0.152367 1.418739 0.989821 0.377252 0.327891 0.857206 1.494956 0.800019 0.032311 1.365883 0.253681 1.755494 0.830490 0.255852 1.125338 0.913419 1.634565 -0.197778 1.357298 1.011276 0.523567 0.404933 0.210904 1.378425 -0.096159 1.204585 0.833162 1.563959 0.474853 0.697957 0.337720 0.314862 0.908477 0.906314 0.462678 0.610874 1.403157 0.264057 1.434646 1.269731 0.936191 0.051332 0.839843 1.813575 0.206251 0.236440 0.641994 0.496971 1.490911 1.188735 1.911534 1.331577 -0.005211 0.140376 -0.273218 1.405953 -0.158980 1.841427 0.493126 0.988545 1.785374 0.804953 1.123062 0.773221 1.134851 0.592693 0.987823 -0.166575 1.328787 1.653612 1.237815 0.817788 1.446221 1.758438 -0.369905 -0.514390 0.700776 1.402740 1.663752 0.760348 1.119015 1.743647 0.230220 0.107139 1.013208 0.480884 1.242257 1.519743 0.430756 1.051690 0.510527 1.229396 1.877041 0.187609 0.215659 1.552529 0.598323 0.215943 -0.104730 1.019493 0.397001 0.146085 0.982408 1.644580 0.898655 0.577865 1.026322 1.011806 0.702857 0.827909 0.505024 0.665868)
      )

;;; 125 all --------------------------------------------------------------------------------
#(125 15.543356407337 #(0 0 0 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0)
      14.985 #(0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      12.970970 #(0.000000 1.411208 1.481980 1.427698 0.601480 1.946483 0.469516 0.407581 0.822350 0.970563 1.016573 1.844089 1.477265 0.513656 1.583760 0.943294 1.360746 1.712570 1.630120 0.405004 -0.583792 0.874355 -0.201973 0.875065 0.288278 1.754325 0.062730 1.691206 0.078345 0.043898 0.171812 0.239604 0.405894 0.163954 0.069877 1.348283 -0.227889 1.456252 0.902264 1.594167 -0.041274 0.991321 -0.011699 1.612911 1.829371 0.076728 0.445331 1.359500 0.711566 1.313573 1.616381 1.461936 1.687751 0.955562 0.781311 0.766095 -0.003075 0.589261 1.267798 0.653000 -0.114349 0.098191 0.278955 0.227545 1.224305 0.706551 0.775697 0.681909 1.002558 1.207502 1.362567 0.714845 0.344457 1.369108 0.781608 0.262969 1.279856 1.407468 1.468158 0.528073 0.801655 1.065990 0.139333 0.520467 0.077445 1.064304 -0.014053 1.408642 1.896180 1.218346 1.105301 1.698841 0.399514 0.519873 -0.453022 0.560491 0.729015 1.866137 0.206587 1.025187 1.025937 0.984978 0.114127 0.179817 0.457109 1.430718 0.216371 1.381632 1.890981 0.564691 1.663887 0.661096 1.969951 1.428511 1.030528 0.048012 0.504044 1.354605 1.126947 0.766294 1.821164 1.525241 1.078757 0.538416 0.807053)
      )

;;; 126 all --------------------------------------------------------------------------------
#(126 15.477880483871 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.896559087188 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.722991453869 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)
      14.67419786533 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      13.086707 #(0.000000 0.675695 0.458769 1.451595 0.693879 1.144484 1.692068 1.925644 1.777671 0.654289 0.111184 1.541426 0.643597 0.534706 -0.176703 1.982786 1.175116 1.078716 1.054474 0.744390 1.437688 0.375282 1.082433 0.358971 0.418414 1.081249 0.616760 0.196182 0.207817 1.661470 0.397190 1.384009 1.387404 0.981549 1.041990 0.626395 0.836565 0.527328 0.963878 1.178744 0.243964 1.013242 0.783243 1.271180 0.718927 0.447323 1.313790 1.007929 0.431045 1.244478 0.584517 0.162665 0.942628 0.356250 0.368708 1.680692 1.276350 1.319032 1.148600 0.436707 1.420277 0.823253 1.276336 0.658652 1.494503 1.226968 1.375227 1.164687 0.221745 0.448901 0.391948 0.299776 1.467615 0.022472 0.810125 1.818420 1.761485 0.429397 0.732483 0.308428 0.745611 0.759250 0.273586 0.586167 1.205895 1.582494 0.296965 0.290302 1.203899 0.911895 0.250944 1.678529 1.602155 0.321453 1.175495 1.497585 1.063826 1.707918 1.868223 -0.287322 0.456364 1.821723 0.405909 -0.046431 1.125195 1.215747 0.720735 -0.074509 0.489106 0.062938 1.548271 0.397754 0.961158 1.856255 0.749841 1.010941 -0.169942 1.430758 0.574055 0.869505 0.960702 0.017980 0.001214 0.190883 0.969128 0.826313)
      )

;;; 127 all --------------------------------------------------------------------------------
#(127 15.59486896452 #(0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0)
      14.859080656941 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0)
      14.851 #(0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      13.027883 #(0.000000 0.819233 1.266809 0.078750 1.063584 0.399300 1.620198 0.322251 1.332303 1.633665 0.223576 1.799756 1.338797 1.538556 1.046236 -0.220810 0.196327 1.322751 0.023186 1.528970 1.348013 1.584795 1.350450 0.676898 0.659090 0.146501 0.589971 -1.960260 0.029415 1.357476 0.297367 0.807420 0.010575 1.423026 0.175065 1.763904 0.740138 0.221695 0.782138 1.549753 0.177825 0.712260 1.708858 1.188407 0.898256 0.402051 0.574937 1.729836 1.050605 1.295224 0.883772 0.263126 0.915697 1.381590 0.936414 1.777452 0.068479 0.731819 0.756657 1.351630 1.035167 0.949035 0.439060 0.018708 1.596747 1.276506 1.698127 0.046247 -0.079800 0.585580 0.732002 0.978028 0.535066 0.748317 0.498489 0.641890 0.145425 0.256269 0.678012 0.224433 0.246288 1.435524 1.558218 0.128412 0.201609 0.312752 0.383963 0.635049 0.678576 1.109797 1.068008 1.249751 0.124139 0.249186 0.531623 1.667042 1.658913 1.655417 1.204551 0.357690 0.026841 1.425882 0.665532 0.010767 1.275606 0.682813 1.602880 0.104307 0.578568 0.966893 1.378306 0.660961 0.584186 1.286999 0.973008 1.646680 0.943841 0.849259 0.088539 1.604084 0.336457 1.761967 0.387073 1.711224 1.505667 0.485733 1.285267)
      )

;;; 128 all --------------------------------------------------------------------------------
#(128 15.689241428851 #(0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1)
      15.287684641887 #(0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1)
      15.249417304993 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1)
      15.138 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      13.156245 #(0.000000 1.185853 0.043993 1.425667 1.019649 1.111140 1.051465 1.127870 0.453108 0.976001 0.216759 0.732667 1.232944 0.726456 0.690920 1.512665 1.736189 0.177570 0.221729 0.296049 0.053891 -0.299656 0.783404 0.725396 -0.034704 1.588729 1.773637 -0.087725 0.997917 1.261800 0.587964 1.278465 1.105737 1.867818 0.662397 1.619569 0.308209 1.210874 0.599997 0.933769 0.515616 0.255976 1.142490 1.228147 1.165591 0.871497 0.472622 1.332063 -0.127067 0.485745 -0.111590 1.586625 1.617660 0.323022 0.982609 1.366331 -0.091256 0.664768 0.192929 0.388706 0.216870 0.074957 0.514896 0.657549 1.173111 0.860904 1.396813 0.882123 1.558736 0.062590 1.847179 -0.042521 1.442989 1.371949 0.812850 0.382882 1.388177 0.837848 0.038857 1.357969 1.499800 1.271650 0.252791 0.458503 0.615765 1.243349 0.729893 0.140092 0.384825 0.264056 0.518034 0.907713 1.467196 1.068921 1.108222 -0.065640 0.801272 0.857040 0.963404 0.714492 0.573108 0.409924 0.646801 0.160301 1.248583 0.679321 0.316465 1.186152 -0.026006 1.069542 0.415533 1.082838 0.809802 1.094864 1.565611 0.528002 1.620393 0.718455 1.116996 1.713908 0.606688 0.542643 1.326810 1.606952 0.206340 1.505608 1.756820 0.792034)
      )

;;; 256 all --------------------------------------------------------------------------------
#(256 23.353 #(0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

      20.377604 #(0.000000 1.645544 1.743216 -1.169589 -1.153034 -0.994168 -1.340580 -1.000850 -1.885204 -0.776338 0.025953 -1.116917 -1.376560 -0.242909 -0.887205 -1.772569 -1.828906 -1.393104 -1.978170 -0.680489 -0.879225 -1.088104 -1.388828 0.002369 -1.802562 -0.410304 -0.615445 -0.740107 -0.048715 -1.817429 -1.799043 -1.000372 -0.004242 -0.465465 -0.052988 -1.715294 -1.039761 -1.757088 -1.711828 -0.387707 -0.087848 -0.051099 -0.188283 -0.236672 -0.823355 0.127339 -1.015669 -0.937046 -1.629727 -0.271269 -0.802168 -1.876226 -0.787053 -0.396061 -1.042568 -1.327297 -1.151937 -0.167917 -0.304700 0.076772 -0.137741 -1.059160 -0.265621 -0.033131 -1.615648 -0.078827 -1.423648 -1.022986 -0.136738 -1.857656 -1.590253 -0.951567 -1.728164 -0.535758 -0.854563 -1.132102 -0.445125 -1.767543 -0.298467 -1.100584 -1.299658 -1.602543 -0.980110 -1.887693 -1.468967 -0.742937 -0.419432 -0.794699 -0.096348 -1.691113 -0.326963 -0.933090 -1.055407 -0.682889 -0.216853 -1.484236 -1.047148 -0.515166 -0.557275 -0.487581 -1.075122 -1.988156 -0.303861 -0.434725 -1.759673 -0.023173 -1.693325 -0.081160 -1.266048 -1.583991 -0.887024 -0.811530 -1.522124 -0.094363 -1.445208 -1.727061 -1.985715 -1.352176 -1.283955 -0.574508 -0.511959 -0.909799 -0.311023 -0.028734 -1.429367 -1.690787 -0.804743 -1.809549 -0.128697 -0.093052 -1.703404 -1.510003 -1.487349 -1.832869 -1.939780 -0.792497 0.029215 -0.003209 -0.106210 -1.735547 -1.719988 -0.598679 -1.840690 -1.381863 -0.352896 -0.248763 -0.558665 -1.344961 -0.271269 -0.683132 -0.193572 -1.411550 -0.848449 -0.820254 -1.095689 -1.613471 -0.620656 -0.509917 -1.554980 -1.791108 -0.387126 0.136260 -1.496626 -0.194762 -1.929767 -0.530660 -0.722987 0.023462 -0.277591 -0.850660 -1.315883 -1.244972 -1.615497 -0.853807 -0.524074 -1.514403 -1.228515 -0.980433 -0.396115 -0.327603 -0.733488 -0.153147 -0.892359 -0.570188 -1.257519 -1.679072 -0.241460 -1.166183 -0.026706 -0.945060 0.022864 -1.042476 -0.896394 -1.092452 -1.936722 -0.233082 -1.215687 -1.721455 -1.588712 0.017160 -0.286463 -0.401257 -0.372394 -1.037362 -0.162014 -0.091253 -0.344683 0.092746 -1.704408 -0.777489 -1.147636 -0.936770 -0.552705 -1.709142 -1.728536 -1.139186 -0.409130 0.027304 -0.526563 -0.722101 -0.901154 -0.467668 -1.900709 -1.147236 -1.401088 -1.387750 -0.353578 -1.738782 -0.399729 -1.192278 -0.676225 -0.824862 -0.277703 -0.616850 -0.794173 -1.758921 -1.914518 -1.756321 0.010858 -1.074127 0.023184 -1.474949 -0.177998 -0.757108 -0.404818 -1.781549 -1.519195 -0.233227 -0.700935 -1.651827 -0.760531 -1.457174 -0.794033 -0.160345 -0.263276 0.224304)
      )

;;; 512 all --------------------------------------------------------------------------------
#(512 34.209987205783 #(0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      32.424602 #(0.000000 0.514386 0.959859 1.498888 -0.108652 1.691249 0.638454 -0.049158 0.746813 0.546361 1.433695 1.228595 1.688994 1.573449 -0.034643 1.419171 0.901138 0.983512 0.006169 0.064239 0.600693 0.481597 -0.043083 1.153567 0.923376 1.027003 -0.198599 0.836313 0.599486 0.504755 0.369581 -0.178921 0.364234 0.802300 1.588998 0.722464 0.236078 0.705669 0.168291 1.781373 1.488502 1.289651 0.680210 1.308014 0.401217 0.248599 1.642371 0.047417 0.989575 0.384842 0.632605 0.635285 0.708578 1.698628 -0.037223 1.180645 1.450121 -0.020070 0.105266 -0.129208 0.007289 1.242638 1.479033 0.141592 1.628364 -0.051677 1.078175 0.804841 0.894767 0.336051 0.509806 0.803091 0.197111 1.769786 0.141458 1.218368 -0.116525 0.229152 1.040945 1.194999 1.477905 0.625451 0.874042 1.635061 1.921554 1.153700 0.933390 0.487482 1.053546 0.227188 1.609768 1.741866 1.212052 0.605460 0.853991 1.539388 -0.052148 1.285396 1.003174 0.676768 0.159229 1.961992 0.436995 0.248135 1.621115 1.079562 0.855523 0.545356 0.806469 1.246164 0.140943 0.122331 0.026117 1.932588 0.605477 0.619548 1.903144 1.180215 1.357323 1.731067 0.911913 1.165550 -0.007181 0.695117 0.709659 1.803718 0.156076 0.939132 1.809268 1.436033 0.129479 1.344899 1.239413 1.658313 0.184432 0.076179 1.102720 1.119695 0.461550 1.186668 -0.101567 1.441090 1.179440 0.758970 -0.090065 1.196871 0.215596 -0.558152 0.590507 0.819794 0.525109 1.648025 0.731288 -0.161678 -0.104081 0.317108 1.188787 1.516243 1.045804 1.097883 0.888058 1.056087 -0.062928 1.909607 0.940848 1.311230 0.851847 0.236673 0.549439 -0.116299 1.179308 1.370681 0.266265 0.733187 0.348271 0.918455 0.410427 1.645439 1.533901 0.165824 1.227098 0.449107 -0.129880 0.878135 0.572595 0.902715 0.743965 0.092284 0.697719 1.595627 0.246971 1.265456 1.285239 0.634177 0.561901 0.617545 0.577597 0.561820 0.792696 0.831241 1.475245 1.262699 1.681635 1.858569 0.639913 0.822590 0.755874 1.238542 1.014495 0.032752 1.148650 1.672078 0.007929 0.380241 1.223381 0.894426 0.566843 1.841192 0.883869 0.677712 0.596573 0.300226 1.917765 1.680632 0.975489 0.129273 0.691625 1.039156 -0.130603 0.223541 0.224467 0.589455 1.573761 0.634878 0.008190 1.177248 0.812716 1.699055 1.284002 1.451138 1.266737 0.579830 1.551845 1.308471 0.179058 0.799302 0.920142 0.817808 0.568088 0.591012 0.523479 0.971522 0.386275 0.725294 1.598763 -0.144569 0.448156 0.752922 0.021060 1.487178 1.435090 -0.405091 -0.290367 0.464164 1.612398 0.964619 0.791093 1.858040 0.740713 1.539045 0.452175 0.622154 0.692671 0.872534 0.278872 1.324691 -0.021032 1.313531 0.765498 1.333004 0.471582 0.986195 0.855230 1.271666 0.626387 0.982145 0.395047 1.773857 -0.208493 0.304473 1.478578 0.824750 1.451749 1.373379 0.914830 1.978310 0.076668 0.906230 0.626615 1.082607 0.051428 1.067014 0.402476 0.029688 1.398544 1.095279 0.216310 1.114026 1.514507 0.827743 1.554622 0.484081 -0.199350 0.461611 0.288247 -0.259150 1.222330 0.425258 1.859435 0.230975 0.109332 1.922357 0.684480 1.817503 1.700040 -0.061171 0.142806 1.883180 0.430362 0.691916 0.217477 1.407022 0.832094 1.688012 1.833074 0.819864 0.346081 -0.170016 0.185165 0.960712 1.071152 0.596514 1.845387 0.237149 1.892891 0.218320 0.979780 0.799397 0.747348 0.507088 0.851783 1.412042 1.480498 1.427677 0.680133 0.744543 0.214434 0.666886 1.409247 0.406607 -0.064827 1.329092 0.233114 1.765106 0.894030 0.944308 -0.061178 1.583855 0.124181 1.084833 -0.157261 0.789912 1.559155 0.236842 0.720046 0.536007 0.225987 0.719195 0.863134 1.818859 1.447820 1.762751 0.269284 0.434891 0.062402 0.425014 0.943207 1.969305 0.650830 1.731918 0.189987 0.144036 1.234263 1.852578 1.200909 1.066311 1.283795 -0.047271 0.915318 1.699528 1.484395 1.294563 1.446597 1.676051 0.444866 0.802502 1.734950 0.031856 1.789865 0.664941 0.693128 0.987855 1.874533 1.893496 0.461992 1.251218 1.696338 0.619990 0.193112 -0.116327 0.762011 1.953616 0.402818 -0.089055 0.268280 0.275983 1.138570 -0.027356 0.071426 0.168640 0.006562 0.796598 1.811166 0.933671 0.430670 1.602175 0.142659 0.412481 0.709313 0.307247 -0.499038 0.902462 0.096552 1.571874 1.305497 -0.298824 0.985774 1.504936 0.303141 0.393988 0.401169 0.793241 0.116287 0.644426 -0.043299 -0.113626 0.900186 0.872247 0.771829 0.399486 1.679301 0.955464 1.396706 0.799520 1.367031 1.937797 0.816662 1.057319 0.430824 0.594800 0.979578 1.527498 0.854372 0.553084 0.551051 1.445099 1.412515 0.342890 1.296012 0.682965 0.245016 1.947237 0.854041 0.764203 0.479714 1.298055 0.594877 -0.356834 0.411063 0.028827 0.521665 0.984347 0.444819 1.493077 0.790467 0.860417 -0.143852 1.337305 1.194931 0.390994 1.271303 1.687933 1.929197 0.222704 -0.228746 1.116605 0.028875 -0.055152 1.588257 0.698352 0.813923 1.015553)
      )

;;; 1024 all --------------------------------------------------------------------------------
#(1024 54.444 #(0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       50.555109 #(0.000000 0.329594 1.835688 0.818800 1.251923 1.670548 0.230246 1.040759 1.511027 1.599934 0.901964 1.250213 1.147244 1.494767 0.149186 1.135727 0.048119 0.794525 0.275684 1.740504 0.108709 1.139053 0.745058 0.410557 1.552271 1.249587 0.352226 1.101290 0.188309 -0.172701 1.968676 0.112298 1.692422 1.233096 1.282962 1.612221 -0.013209 1.376794 1.094790 -0.147389 0.703552 -0.037029 1.469385 0.735358 0.929748 0.403799 0.472721 0.377359 -0.091566 1.162736 0.699207 0.752275 -0.055975 0.063239 0.389342 0.766144 1.887621 1.919956 1.604472 1.727325 1.526050 1.677311 1.699301 0.479486 1.067993 1.887336 1.475629 1.656525 0.018369 1.521410 0.368314 0.203160 1.319415 0.185797 0.379164 1.470603 1.381147 0.893075 0.639764 0.328550 1.444410 0.600953 1.800442 1.727175 1.802285 0.801744 0.053062 1.904516 0.504037 1.481810 0.294743 0.611897 1.781118 1.356317 0.543461 0.125059 0.753628 -0.029984 0.459120 1.719852 1.084731 0.067054 1.626542 1.770022 1.154582 1.555630 1.491250 1.687557 -0.108968 1.822524 0.866753 1.596551 0.304550 1.406929 1.416796 0.692773 1.577445 1.411603 0.153030 1.221287 0.233575 0.344672 0.028820 0.097980 1.473317 1.375179 1.679031 0.717289 0.301012 1.141405 0.635756 1.227789 0.310199 1.904019 -0.276573 0.831332 0.957858 0.960825 0.472038 0.570440 1.190976 0.488301 0.121520 1.190261 1.846469 0.928649 1.825463 0.737374 0.476967 0.407924 0.437538 1.421335 1.524866 0.688228 1.288137 0.244215 1.353512 1.100495 0.311296 1.737636 0.204336 0.394516 1.003215 0.827589 0.314633 0.197661 0.592538 1.198624 1.190322 0.323748 1.707722 0.246817 1.070997 0.842720 -0.259318 0.469276 0.575288 -0.110524 1.444615 0.828479 1.881000 0.455259 0.329414 0.612000 0.819254 1.513267 1.722615 0.318901 0.080546 0.074504 1.453663 1.779086 1.157507 1.645766 0.905543 0.395134 0.814998 1.589289 1.313215 0.479526 0.895200 1.349059 1.829884 -0.087074 0.120326 1.300611 1.293249 0.010505 1.719787 0.308446 0.001660 -0.016296 1.579985 0.365405 0.499220 0.347328 0.929398 1.839193 0.264780 0.916959 0.657312 0.952279 0.106996 0.377950 0.682002 1.083786 0.316245 0.087248 1.386793 1.729531 1.624789 1.074283 0.315942 0.321014 0.891311 1.873166 0.232384 1.432038 0.848424 0.051774 0.588888 1.120201 0.900094 1.452083 0.736124 1.254647 1.785740 0.852565 1.672778 0.213358 1.558244 1.605151 1.934711 1.091227 1.629805 0.360710 0.003382 0.038756 1.447104 1.073976 1.829365 1.454930 1.242931 1.418395 0.674914 0.919692 1.219047 0.181686 1.244240 1.080205 1.076825 0.127624 -0.048216 0.503172 0.039595 1.523254 0.165615 0.234216 1.010788 0.852438 1.674181 1.827785 1.058588 1.150211 1.117328 0.852775 0.819029 1.308506 0.371574 -0.170264 1.633355 0.794596 1.236247 1.394570 0.575586 1.116857 1.528563 1.875273 0.130315 1.173883 1.101462 1.815560 -0.013354 0.399666 0.071125 0.210076 1.683347 1.657527 1.093635 1.675358 1.379517 0.907728 0.784669 1.307349 0.393154 0.616812 1.381202 1.604721 1.399565 0.434951 0.205505 0.661852 1.111269 1.467613 1.431951 0.144969 0.477303 0.251261 0.404324 1.630725 0.199812 0.045705 1.179687 1.113610 0.353956 1.972263 0.598145 0.309488 1.036567 0.448057 1.935377 1.175674 1.479812 0.381189 1.541472 0.126535 1.501069 0.765367 1.251664 1.180809 0.700600 1.101852 1.829039 1.293201 0.155641 1.698371 1.348404 1.362876 0.109677 0.502379 0.145722 0.815017 0.035761 1.645841 0.852864 0.758035 0.629121 0.824782 0.947701 1.157334 1.676599 0.829180 1.584993 0.147175 0.633748 1.856111 0.217976 1.095085 1.265881 1.196153 0.393289 1.641312 1.911924 1.676404 1.460633 0.183215 0.555818 0.063672 0.344334 0.052432 1.455553 0.815823 1.387614 1.236571 1.258970 -0.133803 0.241453 1.071979 0.914612 0.676664 0.853109 1.229176 0.513896 0.921690 0.470898 0.361928 1.821419 1.449553 0.003643 -0.284407 -0.025637 0.302774 1.543508 1.319864 0.318937 -0.219663 1.462266 1.383586 1.641714 0.933059 0.006300 1.210973 -0.048139 0.758220 1.497063 0.244121 1.042996 0.422535 0.267110 0.080202 1.745038 1.762674 1.205492 1.138115 1.096712 1.080844 0.194137 1.107981 1.370829 0.262618 0.002771 0.305749 0.781264 0.363137 0.802333 0.730609 1.010283 0.374751 -0.098696 0.644430 0.188703 1.413554 0.876112 1.006162 0.983563 0.256474 1.404818 1.614824 1.104627 1.247885 1.308323 -0.086314 1.662306 1.257700 1.486143 1.661624 0.665616 0.614643 0.810270 1.771037 1.069379 1.653115 0.816024 0.795295 0.345502 1.517573 1.398908 1.008546 1.647716 0.752682 1.645928 0.542282 0.410777 1.306903 0.060356 0.166210 1.436108 0.512720 0.397744 0.139823 0.322205 1.598534 1.502062 1.621664 1.858674 0.150927 0.286098 -0.074332 1.714288 1.372358 0.305261 1.023526 1.248039 0.543026 1.093783 0.523657 -0.195948 1.488225 1.025062 0.775513 0.030490 1.608010 1.493662 0.508294 0.301753 0.016580 0.944875 0.159756 0.188745 1.121083 0.635060 1.593485 0.309514 1.550986 0.901195 -0.062763 1.999525 -0.027567 1.175599 1.574281 0.445224 0.572408 0.635757 1.928494 0.120225 1.029098 0.670233 0.591599 0.939699 0.789926 0.045689 0.266616 0.870363 1.108830 0.489097 -0.210815 0.513785 0.839886 0.321156 0.427233 0.971235 1.863044 1.373501 0.694642 0.310834 0.727032 0.257450 1.024791 0.530415 1.452098 0.707770 1.440392 0.128298 0.660334 0.370772 1.582357 1.279362 0.295645 1.218473 0.470856 -0.004477 1.764985 1.318345 1.394991 1.387390 1.663166 0.590207 1.158090 1.470823 0.503709 1.150783 0.620625 1.452058 1.828541 1.027514 -0.017040 0.883077 0.265996 0.771741 1.314103 0.735886 0.545437 1.842473 0.956138 1.586830 1.397396 1.297963 0.138957 0.114550 1.375075 0.342649 1.438806 0.461475 0.682674 0.367233 0.418923 0.715009 0.085312 0.901155 1.171100 0.515883 1.482629 0.715355 0.269621 0.164766 0.062774 1.610852 1.566746 0.595199 0.765013 0.503541 1.087529 0.916554 1.160611 1.752680 0.935706 1.156269 -0.092243 1.225661 1.637051 0.851498 1.595830 1.572458 0.900709 0.743917 1.243538 1.029969 0.060091 1.044275 0.453577 -0.057967 1.315067 1.337655 1.524061 0.396827 1.552695 0.618281 0.273914 1.146976 -0.197926 0.507370 -0.065624 0.341479 0.397263 -0.041375 -0.003688 1.128854 0.196525 1.118486 0.288423 0.214709 1.582517 0.361679 1.636352 0.061883 0.988357 0.684793 -0.012546 0.829289 -0.055654 1.514580 1.776315 1.146562 0.213507 0.166107 0.310180 0.522013 -0.119652 0.631632 0.316542 0.873524 1.811323 0.913998 1.429416 1.306914 0.417914 1.049996 0.361835 0.308359 1.466358 1.528730 1.114461 -0.150253 1.422848 1.372822 0.890933 0.189909 1.161220 -0.420762 1.486564 1.527280 0.646407 0.283226 1.439960 0.390497 0.715670 0.705690 1.845687 -0.123839 0.625883 1.538049 1.926307 1.867371 1.298037 1.220941 1.252558 0.854190 0.078931 1.391202 0.116563 0.687802 1.154989 0.788112 0.893809 0.366613 1.314262 0.190903 0.550994 0.840558 0.900040 1.077354 -0.059573 0.460980 1.406639 1.491760 0.841864 1.260348 0.331380 1.067481 1.503091 0.786998 1.783742 0.438326 1.411077 -0.030143 0.760141 1.203532 0.496818 0.947584 0.586330 1.559547 0.829027 0.370195 1.903197 1.601057 1.110542 1.337403 1.101081 1.215422 0.447575 0.971587 1.158207 0.074174 1.187986 0.194105 0.165660 1.161669 0.678508 -0.009533 1.359316 0.759073 1.101700 1.081561 1.739501 0.074230 0.441824 0.715817 0.263638 1.555728 1.300506 0.249344 0.095061 1.706863 0.743296 1.709993 -0.108856 -0.189729 0.652412 0.607261 0.725402 1.494010 0.696254 0.800159 1.309726 0.811978 0.492091 0.886931 0.416274 0.865994 0.436850 0.375530 0.148229 0.905724 0.723018 1.284725 0.486264 0.177069 0.570542 0.861216 1.316324 0.955009 1.301530 0.621347 1.781503 0.194202 0.569628 0.019956 0.741272 0.941117 1.292036 0.119860 1.143916 0.879600 1.416145 0.606915 1.834969 0.336026 1.246031 0.550412 1.427481 1.341416 -0.028130 1.331729 0.635951 1.486034 0.256160 1.339958 0.791620 0.232097 1.342332 1.600396 1.883775 0.401461 0.406443 1.538398 0.506628 1.784609 0.946469 0.927113 1.020542 0.971063 1.184039 0.128231 0.249694 1.172283 0.494571 0.129069 1.390142 1.549704 0.453340 0.117847 1.177085 1.151642 1.419119 0.599464 0.420126 1.208760 0.105732 0.661939 1.332399 0.257454 0.973370 -0.218828 1.413201 0.379644 0.953524 0.615390 1.021100 1.021375 0.703050 1.269755 0.751810 1.037767 0.701985 0.150418 1.197633 1.115951 1.158912 0.152979 0.654074 1.566074 0.968672 0.011698 1.045054 0.614782 0.602676 1.587351 -0.136737 0.215863 0.596058 0.214631 0.428116 0.805204 0.224965 1.492951 0.033743 0.236143 1.049463 0.517436 1.120959 0.082105 0.681296 0.826538 0.138551 -1.970720 1.295522 1.766560 -0.107000 0.613824 1.058355 -0.043304 1.415857 0.248231 0.817651 0.472922 0.218618 0.376804 1.135099 -0.136494 0.257986 0.973823 1.258230 0.768246 0.385763 1.884923 0.595174 0.927311 1.515339 0.841749 0.841934 0.050341 0.002107 0.427520 0.973230 0.748938 -0.062239 0.977967 -0.234320 1.442087 0.687637 0.674428 0.596830 0.602528 0.594640 0.664110 1.123347 0.848694 1.674332 1.261944 0.910845 0.779938 0.957722 1.190690 0.828641 0.308004 1.924683 1.747638 0.410823 1.589277 1.006840 1.208727 -0.010234 1.238598 0.223456 0.906313 0.941883 0.325170 1.752126 1.186835 1.502018 1.486724 1.636734 0.020986 0.438291 0.613563 -0.355079 0.237536 1.311649 1.259707 0.484698 1.818577 1.498097 0.280321 0.925539 1.484958 0.142594 1.336727 1.425315 -0.109761 1.832020 1.609880 0.086751 0.387928 -0.087985 1.689455 0.714967 -0.118654 -0.071464 0.003283 1.491955 1.676206 0.211826 0.774795 1.177987 1.058625 -0.185225 1.440979 1.732083 1.642727 0.815308 0.777380 -0.182554 0.512425 1.026265)
       )

;;; 2048 all --------------------------------------------------------------------------------
#(2048 89.538 #(0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       79.258751 #(0.000000 0.516309 0.439576 1.131785 0.298061 1.450464 1.647400 1.071481 0.526850 1.356965 1.883198 1.155178 1.402507 0.198321 1.011053 1.541413 1.890815 1.779880 0.137415 1.745208 1.417883 1.666729 0.416772 1.282941 1.429663 0.721002 1.791812 0.750888 1.482179 0.304984 1.292686 1.462489 1.899050 1.981998 0.838558 0.286250 0.728457 0.877766 1.059301 1.572084 0.504616 1.603688 1.296766 0.614143 0.838670 0.791493 0.132755 1.880820 0.026522 1.653441 0.716636 1.094877 1.349520 0.459208 1.290146 1.536479 0.948894 1.500354 0.528632 1.065051 1.685393 1.412836 0.884273 1.248986 0.059697 1.755715 0.502327 0.084704 -0.109183 1.169780 1.827638 1.022085 0.760314 1.493852 0.816981 1.844013 0.385437 0.975747 0.156820 0.510378 0.778766 0.060315 1.478452 1.495330 -0.084702 1.424354 1.133895 1.501155 0.988620 1.354092 1.002198 1.295769 0.246528 0.583556 1.109827 0.249747 0.014897 1.569203 0.321792 1.136498 1.076699 1.065044 0.019333 0.366658 0.030899 1.730267 1.415392 0.740746 0.533587 0.528953 0.397306 0.936772 -0.033798 0.447556 -0.181462 0.970913 -0.071904 1.745044 1.074797 1.276851 1.218542 0.645936 1.717882 0.980735 0.781621 1.756481 0.785293 0.171667 1.793496 0.743745 0.243406 0.885719 1.853331 1.818041 0.804806 1.968549 0.838278 0.149293 0.387765 1.851924 0.664242 1.589370 -0.152982 0.694771 -0.096803 1.302222 0.090116 1.834090 1.860346 1.489632 1.331825 0.269704 0.450810 0.837894 0.781143 0.670460 1.446186 1.440109 1.271536 1.254919 1.118297 1.567426 0.072207 1.546209 1.728418 0.841856 1.141192 1.859650 1.597889 0.424094 0.041034 -0.048647 0.609123 1.286466 1.259364 1.059133 0.635029 1.881263 1.247702 1.355011 1.906834 0.580035 1.087998 1.160143 0.477632 0.024750 0.079093 0.226733 1.361441 0.082672 0.045715 0.059447 1.737694 0.428718 0.749227 0.972862 0.162888 1.583476 1.790908 1.930335 -0.072347 1.865065 0.659347 1.242023 0.592363 1.614990 1.569060 0.049042 1.057261 0.719002 1.904755 1.569238 1.258580 0.201486 0.751909 1.480236 0.194542 1.937750 0.792742 1.370224 0.956785 0.888875 1.732865 0.732129 -0.074097 0.464528 1.197407 1.413560 1.308123 1.383997 0.496149 0.766898 0.641273 1.211861 0.101888 0.600394 1.765170 0.547075 -0.078303 0.231430 -0.207481 1.831727 0.741399 0.525957 1.132700 1.243483 1.204573 0.646453 0.671791 1.767649 1.304225 1.499422 0.304184 0.799065 1.761929 1.829416 -0.172753 -0.095029 0.016330 1.576273 1.427562 0.180578 0.256923 0.753038 0.735196 1.729448 0.188998 0.911719 1.749771 0.768760 0.490741 0.283750 1.640842 1.302517 1.334707 0.569669 1.844684 0.311413 0.747149 1.296607 0.047359 0.612289 0.863746 1.115825 1.511773 1.547992 0.487970 1.179581 0.040960 0.302965 -0.019078 0.970199 0.578974 1.827919 -0.064133 1.808146 0.052515 0.750732 1.904682 0.710475 0.211830 0.559888 1.156297 0.413656 1.622690 1.060243 1.294732 0.072390 -1.982665 0.466292 1.678591 0.342440 0.028763 0.552291 1.844904 1.685023 0.895899 1.609678 -0.040743 -0.041266 0.826039 0.447378 1.302258 0.786169 1.788949 1.330651 -0.069061 0.280369 0.775270 -0.111358 0.272230 -0.063142 0.109347 1.276970 0.394606 1.443608 0.989620 1.231756 0.830768 0.990717 0.600473 0.302122 1.233928 0.959251 1.682203 1.035438 1.165305 0.443893 0.776941 1.419832 1.029467 1.749945 1.902301 1.446196 1.043261 1.514596 0.548384 1.481158 0.701552 1.129870 -0.099410 1.071434 1.947152 1.723630 0.832705 0.447539 0.804228 0.102686 0.855304 -1.990743 0.181107 0.039464 1.070858 -0.070103 0.287804 0.313340 0.827627 0.353590 0.217647 1.491550 1.761051 1.587561 1.358603 1.075515 1.317251 1.136602 0.935944 0.242819 1.938291 1.702718 0.334152 1.485092 0.039369 0.219593 1.003865 1.856524 -0.156788 0.562013 1.143461 1.771528 0.067606 1.744126 0.094466 0.109675 1.821966 1.592465 1.028818 0.077383 -0.103914 1.659448 0.755989 0.133607 0.968244 0.740150 0.550011 1.261024 0.707077 1.866605 1.831346 -0.059819 0.123179 0.379169 1.297029 0.700952 1.487674 1.317224 0.043919 0.377736 0.513360 1.351263 0.781937 0.741313 1.042726 0.418067 -0.028027 0.387675 1.582429 1.702315 1.417887 0.343025 0.910023 0.776310 -0.044638 1.451564 0.053773 1.898790 1.934557 0.590917 0.183152 0.166211 0.831601 1.233021 1.167063 0.458699 0.593863 1.955081 0.622696 0.806256 -0.097669 1.024620 0.773776 0.592160 0.586789 1.224415 0.540533 0.960402 0.662337 1.262778 1.945018 0.158705 1.851043 1.350985 0.397829 0.782756 1.430515 1.018370 1.806125 1.805643 1.070946 1.545518 0.137031 0.235638 0.890655 -0.118451 0.110242 1.579630 1.649257 0.631829 1.846473 1.178365 1.495621 0.427692 0.703526 1.017884 1.267545 0.568753 0.350973 1.812496 0.569306 0.493334 1.849443 0.426032 1.122983 1.370122 1.064753 0.856477 1.550064 0.541317 0.390078 1.904740 0.378335 1.470302 0.968718 1.082753 1.068102 1.531311 0.591045 1.326927 1.576941 0.657382 0.918626 0.341920 0.038673 0.907932 0.772015 0.935755 0.711317 0.943048 1.431286 1.871083 1.804073 1.655464 0.812931 0.540715 -0.080574 1.214539 0.997952 0.655067 0.931506 0.749717 0.458180 1.339849 0.071210 0.145870 1.357117 0.659435 1.643954 0.413348 1.154607 1.111947 0.482015 1.407867 1.330723 1.578397 1.537148 1.213946 1.765818 0.123547 1.329557 1.712427 1.709382 1.941736 0.241537 0.384105 1.294612 1.606936 0.517462 1.462880 1.212905 -0.117303 1.812430 1.176943 0.094072 1.099403 0.369218 1.485926 -0.172221 1.047437 0.348733 0.284966 0.386945 0.091839 -0.077727 0.820867 1.928169 0.658027 0.694423 1.171543 0.796877 1.889165 0.351741 1.752694 1.113378 1.198476 0.438893 0.777070 1.906720 0.405744 1.557256 0.474024 0.992704 1.016588 1.875278 0.542902 1.133157 1.558947 0.087589 0.954812 0.391596 1.598614 0.489924 0.245546 1.826369 1.329100 0.322064 0.132371 0.757983 1.451074 0.554894 1.757492 0.066807 0.736744 0.204682 1.239152 1.042295 0.519241 1.058144 1.858712 -0.024687 0.192600 0.738717 0.969069 0.181143 0.046574 0.233304 0.213946 0.142548 0.817825 1.637785 0.288689 0.153386 0.682330 0.803154 1.078202 0.898935 1.105120 0.889281 0.067198 0.435342 1.899322 1.520556 0.770804 1.656883 0.644233 0.741673 0.550003 1.262270 0.374335 1.688889 1.750742 0.322796 1.398530 1.625181 0.882333 0.541571 0.292427 0.277854 1.174969 1.735448 1.584213 0.683315 1.487808 1.377238 1.903280 -0.045031 0.478723 0.829262 0.065556 1.135418 0.781984 0.039019 1.814535 1.552719 1.256097 0.082070 1.561989 0.189920 0.763548 1.296619 1.428915 0.274539 0.616063 1.372142 1.691532 0.806799 0.414198 1.626062 0.451298 1.098927 0.408752 0.651026 1.697775 1.661194 1.010569 1.654468 0.736818 -0.014106 0.735126 0.007252 1.357992 0.149984 0.799741 0.007005 1.077943 0.792800 1.657296 1.306998 1.907068 0.758790 1.937722 0.967975 1.182722 1.643881 0.443816 0.627083 1.029885 -0.212829 1.575930 0.559825 1.412962 1.010252 0.405690 -0.053700 0.027760 1.526479 1.199891 0.566603 1.870139 1.559855 0.489549 1.277183 1.252350 0.741556 0.009513 0.223867 -0.010841 1.327612 1.621961 1.081123 1.893683 1.887535 1.065274 1.083154 0.655287 0.163700 1.222641 0.571014 1.282837 1.222794 0.897663 1.543932 1.616363 0.446730 0.432029 1.297037 0.631287 0.633154 1.137363 1.345999 1.408753 1.541871 1.199309 0.042931 1.443711 1.329402 0.340825 0.850077 1.751903 0.875823 1.671939 1.431331 0.399742 0.094095 1.768944 0.482462 0.800628 1.540203 1.261794 0.925427 1.109252 1.547327 0.436888 0.550708 1.173999 1.539434 0.811275 1.298719 0.431607 1.005624 1.474853 0.085032 1.392590 1.496216 1.090525 -0.006233 0.037319 0.347954 0.154681 1.118062 1.564304 1.832320 1.618583 0.125082 1.454088 0.439185 0.347898 0.071164 1.839076 1.887661 1.020181 0.142331 -0.085950 0.275105 0.511125 0.685124 1.357924 0.875679 1.192645 1.108716 0.612478 1.660615 0.800688 1.529812 0.613972 0.806504 1.369761 0.024851 1.011391 0.325188 1.395314 1.465366 1.664996 0.664966 1.171470 0.437952 0.818759 1.680536 0.130507 1.419214 0.557130 0.156359 0.440187 1.082443 1.126225 1.101340 0.405257 -0.003101 0.762353 0.874842 0.259041 1.767705 0.801907 0.861221 1.353002 0.471465 0.850227 0.069284 1.928235 0.160824 1.450644 1.063604 0.115285 1.765154 1.470850 0.536615 1.817314 1.047520 1.418720 1.268221 1.395731 0.041717 1.281631 1.776049 1.901232 0.710077 0.954163 1.432665 0.051107 0.865989 0.350711 0.622136 0.641506 0.286808 1.438467 0.772684 0.221447 1.401214 1.429944 1.164856 1.354116 1.291562 0.128918 1.870582 1.742982 0.767648 -0.036750 1.026700 1.671293 0.043941 1.763646 1.799681 1.694425 1.078934 -0.017216 1.589766 0.268823 0.862251 1.094319 1.304438 1.327717 0.086183 1.341703 1.853861 1.549213 0.351928 0.639876 0.339503 1.013265 0.675731 1.828640 1.272443 0.703378 1.273549 1.713752 -0.065170 0.499252 0.792052 0.807048 1.351990 0.450760 1.615125 1.025537 0.753797 0.708112 0.857120 0.861818 1.355820 0.989172 0.196898 1.201527 1.165447 0.285969 1.491005 1.160969 1.275908 0.545101 0.317594 1.551458 -0.008979 0.180636 0.519918 1.112979 1.208124 0.878329 1.023728 0.986225 0.299685 1.264979 0.706012 0.182954 1.478740 0.965650 0.067362 0.762353 0.859698 0.262318 0.971904 0.447337 0.343064 1.214022 0.972776 0.191619 1.485672 0.793969 1.903334 0.372176 1.882745 0.790921 1.617207 0.428032 0.783701 0.989932 1.672880 0.044317 1.033347 0.613568 1.562244 1.404116 1.162231 0.670380 -0.011185 0.324757 0.720662 1.108567 0.780932 1.917966 1.667422 1.917740 0.166905 -0.148754 1.425649 1.373055 1.923432 0.076996 1.836311 1.857883 0.658019 0.389235 -0.002043 1.275188 1.230530 0.271799 0.290891 1.879628 1.313846 0.543152 0.888452 0.695768 0.839473 1.446816 -0.206607 0.220159 0.649980 0.114725 0.612094 0.443380 0.621621 0.346330 1.681721 0.128012 0.134176 1.108087 0.784710 0.330032 1.109337 0.883276 1.373618 1.324662 1.812602 0.462484 0.018487 1.499087 1.507487 0.061742 0.002937 0.582368 1.351349 1.412175 1.406511 0.810342 1.144927 0.246711 0.986906 0.922887 1.734154 1.750756 1.205318 0.613575 0.166182 0.238519 0.465609 -0.063680 0.680907 1.334479 0.532102 0.866902 1.637264 1.254778 -0.042233 0.875018 0.763218 0.112188 0.588952 0.568747 1.401932 0.454929 0.135470 0.370752 0.241766 1.232656 1.135051 1.566706 1.181503 0.885455 0.901066 0.434415 1.439184 0.183478 1.546987 0.026456 0.379178 1.383533 0.789566 1.863614 1.402655 1.620721 0.195593 0.935473 0.727536 1.677180 0.965217 0.138031 0.708723 1.584240 0.601596 0.212291 1.440982 0.355522 1.545516 0.879978 0.120754 0.506993 -0.027976 1.648338 0.662884 -0.057828 1.672107 0.205878 1.597161 1.631982 1.111711 1.044409 0.085527 0.811263 0.211460 0.983012 1.257884 1.063000 0.447520 1.900896 0.662996 0.838564 1.300037 1.306159 0.290916 -0.013277 0.354608 0.919568 0.640851 1.723779 1.203143 0.775931 1.784048 1.247672 1.107495 0.855197 1.186396 1.839902 -0.210513 1.488276 1.597154 1.460862 0.004851 0.513185 0.441436 0.436173 1.524178 1.112643 1.793603 1.833484 0.237973 1.828770 1.080196 1.463603 0.655674 0.768824 1.715953 1.066890 0.777681 0.576349 0.625897 0.492241 0.779574 0.563433 1.388459 1.524942 0.228706 1.230699 1.149749 0.728606 0.613272 0.221006 1.288937 0.728488 0.501416 0.580759 0.913448 1.759946 0.786424 0.073339 0.150841 0.964265 0.377870 1.477343 0.824650 1.394646 0.272340 1.526047 1.293740 0.199292 0.967750 1.886735 0.360585 0.188587 0.337563 0.737640 1.293094 1.886017 0.629861 0.540523 1.356320 1.819377 0.062238 0.819319 0.547052 0.413775 1.179748 1.896986 0.766249 0.238070 0.238145 0.952012 1.909316 1.691218 0.942149 1.028978 1.571434 1.791845 1.517704 0.845106 0.881350 0.175553 0.832038 1.533432 0.077609 -0.085901 1.906189 0.816032 0.430345 1.409415 0.647294 1.789553 1.660547 1.864316 1.097416 0.634959 1.626223 1.109375 0.340120 1.016596 1.754920 1.457679 1.411500 0.785442 1.090683 1.580312 1.041631 1.201535 1.065128 0.770248 0.394212 1.512423 1.887650 0.767561 1.502358 0.365517 1.456362 1.272060 1.453495 -0.118154 1.707831 0.615318 -0.343591 1.006966 1.800091 1.183167 0.500705 0.751184 0.433490 0.733481 -0.108795 1.044167 0.668198 1.643298 1.776416 1.605946 0.853401 0.514056 0.260348 1.228293 1.784632 1.645328 1.205614 1.269064 1.169755 1.370215 1.812520 0.358577 0.044305 1.920397 0.150954 1.168951 1.724030 0.163912 0.498788 1.168145 0.332914 0.334129 1.601525 0.446708 0.597631 0.644669 1.525106 0.359414 0.738677 0.053167 0.747243 0.253221 0.335478 1.271612 0.797037 1.310506 1.674595 0.983541 0.198272 0.760080 -0.003396 0.730129 0.954943 0.901561 0.581665 0.033511 0.763891 1.671982 1.356641 1.820017 0.204333 1.016655 0.033904 1.641496 0.758811 0.774372 1.370298 0.344245 1.276039 0.950223 0.475855 1.472904 1.083136 1.805290 0.440105 1.032490 0.927508 0.526951 0.622953 0.960829 1.401076 0.404715 1.142811 0.987854 0.365765 1.885788 1.089381 1.894376 1.664218 1.481271 1.091280 0.851730 1.215290 1.161265 0.521524 1.654133 1.826569 0.409136 1.067001 0.525863 0.110990 0.050854 0.287929 0.245824 1.001923 0.106071 1.372248 0.535914 0.956095 -0.040075 -0.016714 0.729090 0.689713 -0.015974 0.817872 1.048752 0.356180 0.903739 0.253642 0.566932 1.505831 1.535490 1.585815 1.347981 0.582110 0.338416 0.184152 1.366868 0.794013 1.978949 1.434308 0.899365 1.953685 1.542102 0.827217 0.877031 0.874742 1.193609 1.853492 1.884228 0.665974 1.868404 1.712348 1.664384 1.180439 1.846541 -0.162046 1.401272 1.088451 1.384682 1.475931 0.365933 0.386222 0.564285 1.177141 1.765069 1.276397 1.107741 0.781786 0.434587 -0.042682 0.317848 1.256286 1.293495 1.580228 0.799181 1.273323 1.731888 0.772562 1.254483 1.808444 0.796963 1.437797 0.877150 1.736304 1.945859 1.730347 0.036756 1.202703 0.385985 1.373673 1.954088 0.821567 -0.029524 1.018386 0.898851 0.615750 1.619482 0.313229 1.444793 0.550041 1.407813 0.805218 0.921178 0.212333 0.029939 0.452865 0.124311 0.749340 0.419458 0.174475 0.276165 -1.953310 1.445970 0.754332 1.003487 0.830686 1.011900 0.462691 1.013659 0.069533 0.261707 1.073739 1.104034 1.612010 1.125964 0.581843 0.341814 0.737170 0.951133 0.226391 1.440480 1.848236 0.683384 -0.028125 1.582761 -0.119992 0.070190 -0.005539 0.278095 1.525493 1.109175 1.658271 1.832696 0.153870 1.091412 0.396806 1.052767 1.444089 0.679194 1.805538 -0.074157 0.918075 1.026362 1.392743 1.714563 1.706803 0.978262 1.465988 1.261728 1.151980 1.142174 1.119797 0.255036 0.009511 0.816882 1.579371 1.169069 0.868517 0.301179 1.029627 1.141393 0.488542 0.736437 1.783719 -0.004095 0.417469 1.044146 0.048999 0.250967 -0.075809 1.597347 0.446751 1.913123 0.135532 1.449369 0.484276 1.630667 1.709925 1.471011 1.781590 0.041247 0.542972 1.546080 0.879976 1.425271 0.622303 1.938423 1.141138 1.581827 1.593177 0.325094 0.472166 0.241870 -0.079036 0.711418 1.337234 0.446666 1.327122 1.464036 1.609205 0.819548 0.727123 1.235905 1.796475 0.880076 1.018975 0.480123 1.034313 0.551514 0.661596 1.514925 1.392187 0.145327 1.118928 1.628283 1.067288 1.682980 0.270674 0.493585 1.607037 1.317052 1.900282 1.165826 0.989906 -0.149320 0.508402 0.696137 1.414531 1.107950 0.696892 0.408450 0.520544 1.295201 0.183939 0.054875 0.966891 0.220501 0.791453 1.979686 1.492747 1.356022 1.316773 0.264114 1.448069 0.964569 1.583307 1.533018 0.257901 0.420090 -0.071793 0.861751 0.590637 0.133655 0.691036 1.733628 0.458535 0.503378 -0.077654 1.059098 1.222861 1.395932 0.767097 1.756007 0.820295 1.699931 0.463501 0.117893 0.085684 -0.007737 0.528223 1.635646 1.420935 1.612454 0.092898 1.642668 1.186215 -0.012207 0.218835 1.592341 0.300657 0.936704 1.483518 1.985596 0.954652 0.278247 1.683185 1.087074 0.804024 1.453214 0.675116 1.673581 1.743850 1.101862 0.311583 1.150433 1.671851 0.279955 0.581313 0.566325 1.430718 0.253594 1.741662 0.248004 -0.029524 1.455218 1.834381 0.946725 0.141157 1.036080 0.169572 -0.246023 0.254469 1.380242 0.728530 1.693583 1.857068 1.711276 0.834869 1.576495 0.000933 -0.088209 0.328117 0.258073 0.195541 1.420219 0.446996 0.533560 1.213911 1.859057 -0.043928 0.977084 1.330744 1.292047 0.749312 1.725125 0.356374 0.830003 1.484155 1.300185 0.639333 1.862477 0.139808 0.864177 0.569229 1.448584 1.813770 1.797318 0.126568 1.196718 0.570007 0.958738 0.253124 1.909534 0.160929 0.474146 0.361615 0.190754 0.519635 0.564105 1.518267 0.092706 1.626476 0.236638 1.222027 1.354050 0.266709 0.894600 0.235317 1.375009 1.496506 1.068789 1.754746 1.601774 0.957112 0.629847 0.623795 0.039493 1.933248 1.389133 0.179313 1.096470 0.067035 1.245648 1.342554 0.108747 0.821113 0.601396 1.240915 0.082374 1.676676 0.362757 0.207371 1.639562 1.800114 0.086028 1.183483 0.065733 1.085709 1.639745 0.434997 0.971394 1.654201 0.651208 1.188307 1.347505 0.374675 1.951609 1.282794 1.201360 1.040124 1.403549 0.032232 1.794609 0.621022 1.510203 0.828686 1.379670 0.830385 0.339148 1.852087 1.257539 1.709102 0.488245 0.714776 1.587770 1.203031 0.088776 0.203872 0.857413 0.534268 0.316862 0.987936 0.275155 0.908512 0.753153 1.183862 1.151887 1.511930 1.220581 1.037468 1.771495 0.875148 0.198227 0.162056 0.667145 1.764385 1.779559 0.572532 0.348778 1.714572 0.437458 1.279439 0.636857 -0.092184 1.241730 1.595510 1.261402 1.113612 1.758654 1.231514 0.568519 0.926945 1.300800 0.976804 1.595552 1.195759 0.403057 1.641457 1.531429 -0.004711 1.210636 1.617776 0.990702 1.785512 0.741659 0.089791 0.435057 1.311253 1.755996 1.601187 1.213888 0.347515 1.581423 0.137476 0.044446 1.024481 1.059742 0.111489 0.982336 0.706379 0.456266 0.734806 1.274270 1.577790 1.279049 0.599245 1.479340 1.147988 1.715586 -0.011077 -0.090702 0.532553 0.797665 0.912825 1.525832 0.570452 0.067002 1.631986 1.976804 1.123810 1.347775 1.218875 0.981365 0.832682 0.084846 -0.027654 1.392679 0.345404 0.906317 1.249837 0.479386 1.683172 0.702943 -0.154398 1.204176 0.902161 0.649178 -0.182768 1.233024 0.365048 1.205166 0.157442 1.578705 0.041077 0.939866 0.030591 1.034723 0.849810 0.227606 0.414542 0.530588 0.752583 0.453950 1.816120 1.133747 0.104048 0.937007 1.171945 0.823178 -0.119439 0.702212 1.291955 0.981090 1.332991 1.676203 0.110062 1.905486 -0.129102 0.384753 0.194881 0.158424 1.564232 0.512474 0.566461 1.681498 1.667768 0.295615 0.664757 1.493191 -0.000617 0.095199 1.772918 -0.092664 1.502405 1.650707 0.830552 0.224107 0.572636 1.494958 1.687429 0.336904 1.901186 0.163400 1.233078 0.781570 -0.082391 1.721504 1.542215 1.490750 0.491851 -0.088861 1.656639 1.720721 -0.114809 0.697238 -0.000584 0.329236 0.526126 0.523297 0.921011 1.742888 1.594651 1.539018 0.058306 0.072321 1.335169 0.886192 0.737377 1.815154 0.669134 0.356011 1.547788 0.229975 1.366485 1.495598 1.013554 0.692118 0.639991 1.152895 0.332395 1.094703 0.926387 1.315876 0.450175 1.556365 1.559236 0.407471 0.102498 0.147657 0.575734 0.764216 1.809766 0.691139 0.931675 0.110327 0.172605 1.085152 0.934546 0.721788 1.239567 0.011608 1.647872 1.225487 0.643580 0.143626 1.231083 1.462963 0.569080 0.754201 1.329599 0.417834 1.468453 0.870884 1.478402 1.606451 1.830462 0.339051 1.051773 1.091947 0.248501 0.029626)
       )

;;; 4096 155.67;     (expt 4096 .6) is 147
;;; 65536 704.86! [.59 = 697, .5 = 256]

))


;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.539 #(0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
#(3  1.7548747062683 #(0 1 1)

     1.7393749801561 #(0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 #(0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 #(0.0 0.79018270969391 0.69699490070343)

     1.738745 #(0.000000 1.209826 1.303017)
     1.738744 #(0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
#(4  2.19460272789 #(0 1 0 0)

     2.050 #(0 39/25 26/29 27/22)
     2.048743724823 #(0 111/256 281/256 195/256)
     2.0466175079346 #(0 223/512 563/512 49/64)

     2.045218 #(0.000000 1.563819 0.899661 1.233860)
     2.045217 #(0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; sqrt=2.2360679
#(5  2.7317879199982 #(0 1 1 0 0)

     2.3731805734023 #(0 7/16 7/4 5/8 7/16)

     2.307252 #(0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 #(0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; sqrt=2.44948
#(6  2.8638670444489 #(0 0 0 0 1 0)

     2.576 #(0 8/7 15/22 65/163 17/24 19/15)
     2.5618824804417 #(0 1/4 5/4 9/8 13/8 5/4)
     2.5493278192418 #(0 33/128 81/64 145/128 105/64 163/128)

     2.522759 #(0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 #(0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; sqrt=2.64575
#(7  2.9204399585724 #(0 0 0 1 1 0 1)

     2.618497 #(0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 #(0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; sqrt=2.828427
#(8  3.2507002353668 #(0 1 1 0 1 1 1 0)

     3.0216138696515 #(0 0 1 3/4 7/4 1/4 7/4 0)
     2.8503303527832 #(0 27/32 7/4 1 13/16 61/32 3/16 11/32)
     2.815753698349 #(0 27/32 7/4 1 13/16 123/64 11/64 21/64) ; inc=128
     2.8071956634521 #(0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.791000 #(0.000000 1.197326 0.326760 1.111456 1.318751 0.231304 1.994192 1.872649)
     2.790858 #(0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 #(0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; sqrt=3
#(9  3.5549147642153 #(0 1 0 1 1 0 0 0 0)
     3.46973755015 #(0 1 1 0 1 0 0 0 1)
     3.4140722751617 #(0 0 1 1 1 1 0 1 0)

     2.886575 #(0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 #(0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; sqrt=3.162277
#(10 3.5391488075256 #(0 0 1 1 0 1 0 0 0 0)

     3.3031034469604 #(0 7/4 1/2 1/8 3/2 3/2 3/2 3/8 11/8 0)
     3.1529483795166 #(0 29/16 7/16 1/8 3/2 3/2 3/2 13/32 23/16 0)
     3.141804933548 #(0 29/16 7/16 5/32 49/32 3/2 47/32 13/32 23/16 0)
     3.1399011611938 #(0 57/32 13/32 5/32 3/2 3/2 3/2 7/16 23/16 0)

     3.054055 #(0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 #(0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 #(0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 #(0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 #(0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; sqrt=3.31662
#(11 3.6182308197021 #(0 0 0 1 1 1 0 1 1 0 1) ; sqrt is 3.31662

     3.4408876895905 #(0 31/16 1/16 1 15/16 1 5/16 1 17/16 1/4 19/16)
     3.397385597229 #(0 63/32 1/16 1 15/16 1 9/32 33/32 17/16 1/4 19/16)
     3.3892302513123 #(0 31/16 1/32 1 15/16 1 9/32 33/32 17/16 9/32 19/16)

     3.177383 #(0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 #(0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 #(0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 #(0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 #(0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; sqrt=3.464101
#(12 4.0877377663658 #(0 0 0 0 1 0 1 0 0 1 1 0)
     4.0507665657231 #(0 1 0 1 0 0 1 1 0 0 0 0)
     4.0 #(0 0 1 1 0 0 0 0 0 1 0 1)
     4.0 #(0 1 1 0 1 0 0 0 1 0 0 0)
     4.0 #(0 1 0 1 0 0 1 0 0 1 1 1)
     4.0 #(0 1 0 1 1 0 0 1 0 0 0 0)

     3.364341 #(0.000000 -0.081820 1.399778 1.018584 0.994103 1.854492 0.464370 0.769854 0.179932 0.999593 0.618367 1.331545)
     3.363698 #(0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362771 #(0.000000 -0.075979 1.408592 1.032388 1.012527 1.876369 0.488516 0.799446 0.212183 1.037314 0.659512 1.376640)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; sqrt=3.60555
#(13 3.9482246631869 #(0 0 0 0 0 0 1 1 0 0 1 0 1)
     3.8778836727142 #(0 0 1 1 0 0 1 0 1 0 0 0 0) 
     3.8192620277405 #(0 5/32 1 1 31/16 61/32 35/32 0 1 0 0 0 15/8)

     3.531897 #(0.000000 0.670162 -0.095257 0.537542 -0.014805 0.385445 0.484518 1.431811 0.066607 0.001633 1.257240 0.820923 0.574587)
     3.476053 #(0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475837 #(0.000000 1.619564 1.039514 1.647371 1.554490 1.036034 1.462185 -0.170348 0.070618 1.025887 0.489635 0.930545 0.039564)
     3.475735 #(0.000000 1.619382 1.038809 1.647668 1.554327 1.036302 1.462199 -0.170331 0.070303 1.026188 0.490144 0.930234 0.039322)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; sqrt=3.741657
#(14 4.2126383781433 #(0 0 0 0 0 1 1 0 0 1 0 1 0 0)
     4.2575645446777 #(0 1 0 0 1 0 0 1 0 0 0 1 1 1)
     4.2819647789001 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.6206462 #(0.000000 1.058317 0.285078 1.806037 0.777548 1.158566 0.154927 1.434637 1.675813 0.358961 0.394684 0.549621 0.067593 0.064796)
     3.606512 #(0.000000 0.785150 1.482463 -0.077041 0.773052 0.357080 1.202237 -0.069790 1.584889 0.769902 0.652503 0.409520 0.740393 0.675317)
     3.600425 #(0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599801 #(0.000000 0.848755 1.634120 0.084584 1.000575 0.742168 1.674370 0.411388 -0.056298 1.339797 1.164462 1.135305 1.509202 1.430450)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; sqrt=3.872983
#(15 4.4680814743042 #(0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)
     4.4776539802551 #(0 0 1 0 1 0 0 1 0 0 0 1 1 1 1)
     4.5555243492126 #(0 1 0 0 1 0 1 0 0 1 1 0 0 0 0)

     3.759718 #(0.000000 -0.397665 0.806430 -0.136442 1.561904 0.158128 0.655585 -0.218498 0.035467 0.628496 0.322341 0.470757 -0.271280 1.477753 1.665977)
     3.754132 #(0.000000 0.903767 1.420933 1.923281 1.041289 0.252052 0.873412 0.620154 1.578503 0.111918 0.212810 -0.101363 1.630440 0.487026 0.384094)
     3.753088 #(0.000000 1.135982 0.074052 1.463569 1.541245 1.092705 1.157015 0.490295 1.413226 1.335648 0.694560 1.273492 1.624971 0.104821 0.184801)
     3.741772 #(0.000000 1.199869 0.202029 1.625314 1.750084 1.359984 1.478577 0.852391 1.828043 1.790168 1.217368 1.845266 0.235163 0.788710 0.894948)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; sqrt=4
#(16 4.5755343437195 #(0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)
     4.5854911804199 #(0 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0)
     4.6032500267029 #(0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0)
     4.6629304885864 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1)
     4.6691436767578 #(0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1)

     3.863264 #(0.000000 0.212739 0.823601 0.183475 0.522013 1.322798 0.144924 -0.004654 0.283110 0.829370 -0.006329 1.351573 0.889059 1.066540 0.816406 -0.008936)
     3.860090 #(0.000000 0.140361 0.687826 0.031302 0.285540 1.041416 1.802932 1.622140 1.858744 0.341220 1.444371 0.703291 0.233240 0.359715 0.034873 1.176817)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; sqrt=4.12310
#(17 4.5790815353394 #(0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)
     4.6202440261841 #(0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1)
     4.8765740394592 #(0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 0)

     3.97646324 #(0.000000 0.753931 1.605116 -0.013833 0.719484 1.221266 1.149453 -0.016400 0.682620 0.271202 0.759215 0.509449 0.934281 0.751176 0.303242 1.755965 1.144501)
     3.955089 #(0.000000 0.631476 0.862836 1.146812 1.642068 1.883793 0.557919 1.741293 0.422903 1.211834 0.490614 -0.006408 1.087325 0.816118 0.553477 0.736752 0.221837)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; sqrt=4.2426406
#(18 4.801501750946 #(0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)
     4.857753276825 #(0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     4.86248254776 #(0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0)
     5.0418791770935 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0)
     5.0524249076843 #(0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)
     5.0652704238892 #(0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0)
     5.0697374343872 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0)
     5.0979032516479 #(0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0)

     4.18242582 #(0.000000 1.136222 0.770438 0.400169 1.826042 1.428576 1.017726 1.528217 0.877622 1.606644 0.825490 0.569790 0.688245 0.883189 1.302521 1.639646 0.475959 1.347778)
     4.130024 #(0.000000 1.754352 1.775885 0.648861 0.498465 0.100092 0.902120 1.526431 0.475472 1.473007 0.551653 0.202011 1.209083 1.439412 1.702576 1.066652 0.934229 1.195458)
     4.078671 #(0.000000 0.969744 1.085924 0.506836 0.813444 0.152985 0.641410 0.417771 0.045280 1.016368 0.672305 1.801890 0.408199 1.243926 1.302682 1.584496 0.279107 1.857248)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; sqrt=4.358898
#(19 5.0520766258263 #(0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0)
     5.0155117084604 #(0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0)
     4.9927339414282 #(0 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1)
     4.9885946763115 #(0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0)
     4.9724504091175 #(0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1)
     4.9609222566765 #(0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     4.8924918279945 #(0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.341600 #(0.000000 1.579328 0.343104 1.375842 0.353081 0.423388 1.240118 1.912826 1.194961 1.293193 0.615240 0.016197 0.673856 0.516664 0.391481 1.727303 0.190251 0.501442 0.668027)
     4.195254 #(0.000000 0.791760 0.603530 1.420197 0.161131 1.375504 1.353582 1.630311 0.304896 0.430904 0.181997 0.875060 1.590045 0.702894 0.531692 0.132476 0.893747 0.532901 0.172031)
     4.192585 #(0.000000 0.334667 1.420715 1.229662 0.439270 0.509244 1.301905 1.823228 1.326149 0.184676 0.526501 1.223923 0.591639 -0.267702 1.457325 1.595982 1.335076 1.705792 1.227062)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; sqrt=4.472135
#(20 5.136606875959 #(0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0)
     5.104093841111 #(0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0 0)
     5.043 #(0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.463104 #(0.000000 0.761800 1.236823 0.024313 0.590123 1.505373 1.550313 -0.073442 0.241861 0.856525 0.795787 0.538896 1.584914 1.104127 1.007262 0.563390 0.997438 0.457495 1.344824 0.646695)
     4.375228 #(0.000000 0.120264 0.058549 0.278364 0.018634 0.826725 1.250736 1.815417 1.622638 0.590108 1.367652 -0.199000 1.281005 0.029737 1.792402 1.224285 -0.227452 0.740815 0.207694 1.917626)
     4.370636 #(0.000000 0.115728 0.061243 0.266695 0.023060 0.827128 1.260623 1.816144 1.627382 0.603746 1.364656 -0.191740 1.275171 0.025695 1.779265 1.224123 -0.229797 0.740104 0.201962 1.904574)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; sqrt=4.5825756
#(21 5.2726634376804 #(0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0)
     5.2359894831295 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1)
     5.2142992491192 #(0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1)
     5.2105652502144 #(0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0)
     5.1372244578347 #(0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.461169 #(0.000000 1.242994 0.095443 0.910807 0.287429 1.765367 -0.086732 1.316511 1.094842 0.768427 1.093908 1.200257 1.516331 0.758890 1.527686 1.733988 0.589920 1.981336 1.152781 1.233721 1.940908)
     4.456993 #(0.000000 1.252841 0.086637 0.914881 0.293400 1.758589 -0.082804 1.309367 1.082916 0.773964 1.102601 1.194344 1.512023 0.748678 1.538574 1.737305 0.591052 1.973588 1.152844 1.241997 1.948948)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; sqrt=4.6904157
#(22 5.5119525535942 #(0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0)
     5.473 #(0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1)
     5.1805551751198 #(0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.607266 #(0.000000 0.222782 0.421798 1.926910 0.376255 0.619348 1.547456 1.792530 1.569236 1.345588 0.046219 1.736426 0.873767 0.373190 1.864434 -0.051434 0.078473 0.789957 1.485951 0.602220 1.765598 0.489670)
     4.590141 #(0.000000 0.209737 0.431451 1.939545 0.382924 0.609925 1.541919 1.807076 1.559885 1.355220 0.026059 1.738962 0.877273 0.384229 1.866444 -0.042108 0.085258 0.779049 1.487176 0.601177 1.738461 0.508904)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; sqrt=4.7958315
#(23 5.5374279022217 #(0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0)
     5.4125407453101 #(0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.741374 #(0.000000 1.417840 0.390887 0.393143 0.931382 1.527723 1.231278 -0.079525 0.379399 0.985968 1.831893 0.216680 1.240120 0.937466 0.688538 0.037994 1.326128 1.731497 1.304440 1.516775 1.413045 1.592375 0.968750)
     4.723452 #(0.000000 0.386129 0.165946 -0.245217 -0.161090 0.736806 0.965691 1.298897 1.507789 0.452195 0.189203 0.235652 1.197560 0.725754 0.461806 0.424127 0.849770 0.154607 1.047971 0.905540 -1.880841 1.023827 -0.197119)
     4.695836 #(0.000000 0.388781 0.156203 -0.263065 -0.154168 0.762436 0.957067 1.307545 1.502806 0.440648 0.202332 0.232016 1.186799 0.724970 0.480902 0.450048 0.840704 0.144517 1.061488 0.902749 -1.898167 1.008055 -0.169002)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; sqrt=4.89897948
#(24 5.6568542494923 #(0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0)
     5.6584029055795 #(0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0)
     5.62041703818643 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)
     5.6193280144865 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.806995 #(0.000000 0.496421 1.179048 1.436158 0.456954 1.449354 -0.055485 0.790933 0.033919 0.903143 0.035676 1.027399 0.988506 1.773724 -0.059353 0.163832 0.594174 0.300685 0.005827 0.116352 0.062331 -0.101488 1.183924 0.684546)
     4.800695 #(0.000000 0.505360 1.188263 1.431389 0.466768 1.458826 -0.056932 0.789474 0.026211 0.904291 0.036809 1.031019 0.997873 1.774274 -0.055048 0.171621 0.607068 0.289539 0.006354 0.116796 0.063593 -0.102334 1.183706 0.691091)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; sqrt=5
#(25 5.7861609458923 #(0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1)
     5.7734115151023 #(0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1)
     5.7220960914079 #(0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.952389 #(0.000000 0.649552 0.146968 0.137592 1.920162 1.770908 1.877396 0.502509 -0.092100 0.572738 1.615288 0.866122 0.452803 0.426754 0.428242 1.480905 0.907148 -0.281654 1.752124 0.802190 0.517608 1.888063 0.273561 0.653670 1.328454)
     4.940301 #(0.000000 0.068941 0.280987 0.744123 1.665761 1.640509 1.200511 1.123563 1.696266 0.637874 0.883209 0.025382 1.721216 0.451503 0.071096 0.292264 0.770874 0.241249 0.692111 0.321227 -0.116766 1.144162 -0.149523 0.630713 0.076503)
     4.926836 #(0.000000 -0.099540 0.657446 0.808309 -0.281592 0.132990 1.153927 1.197681 0.006132 -0.239091 1.182721 0.314406 0.741058 1.168893 0.581218 1.492737 0.443100 0.072750 0.121485 -0.029194 1.043143 0.229002 0.560739 0.349499 0.274824)
     4.914701 #(0.000000 -0.096740 0.662167 0.811523 -0.279533 0.135523 1.152430 1.203220 0.008297 -0.242062 1.190417 0.308097 0.733696 1.161616 0.583348 1.479950 0.434586 0.086541 0.140377 -0.040374 1.054970 0.215969 0.561254 0.360667 0.283815)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; sqrt=5.0990
#(26 5.8912210464478 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0)
     5.8572101593018 #(0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0)
     5.8545204896237 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0)
     5.8537594936002 #(0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     5.058191 #(0.000000 0.963510 1.600122 1.739679 0.398231 -0.057796 1.231026 1.438488 0.378841 -0.000542 1.855780 0.773155 0.905183 0.022318 0.216751 0.538533 -0.159436 0.757975 0.682881 0.713783 1.058188 0.165324 1.772365 0.277114 1.781621 -0.007420)
     5.057251 #(0.000000 1.849117 1.623228 0.410350 1.086047 1.754775 1.282418 0.304298 0.522261 1.225401 1.575910 1.232337 1.744190 1.291250 1.802121 -0.126717 1.839627 1.168366 0.199625 1.201215 1.359646 0.045055 1.105661 0.810206 0.231847 0.508269)
     5.055923 #(0.000000 1.850899 1.623230 0.411901 1.085371 1.752389 1.281766 0.304190 0.520004 1.225336 1.575826 1.230455 1.745219 1.292940 1.802108 -0.127313 1.840563 1.168270 0.199407 1.202404 1.359182 0.043186 1.106369 0.811094 0.231058 0.510109)
     5.053527 #(0.000000 0.944025 1.245710 0.093194 0.306137 1.114440 1.444316 1.823154 0.610370 0.729077 -0.014396 1.183732 1.663139 0.726593 1.907293 0.624400 0.516512 1.574612 1.429517 1.489610 1.512613 -0.418034 1.459880 1.393958 0.677536 1.872369)
     5.048508 #(0.000000 1.644193 1.358251 1.393615 0.649269 0.727876 1.252981 1.594204 1.025046 0.616653 -0.145103 1.039138 0.281826 0.133348 0.707707 1.147033 1.525733 -0.215165 1.384123 1.684103 0.824070 1.760417 0.670682 -0.191019 0.046525 0.099898)
     5.036549 #(0.000000 1.648474 1.356160 1.391618 0.645448 0.732825 1.249658 1.596266 1.029440 0.616916 -0.159137 1.033505 0.276988 0.131279 0.717345 1.158768 1.517445 -0.204978 1.374460 1.696096 0.814748 1.756815 0.666843 -0.182144 0.058624 0.100389)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; sqrt=5.196152
#(27 5.9741146989154 #(0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0)
     5.9665498733521 #(0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1)
     5.9206547737122 #(0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0)
     5.8637111082051 #(0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.159976 #(0.000000 0.060824 1.210207 1.106404 0.924969 -0.022790 0.023912 -0.183868 0.515526 0.968425 1.378371 0.126703 1.003394 1.684154 0.187692 -0.104012 0.879975 0.487286 1.825016 1.033078 0.155452 1.194679 1.635355 1.210386 1.229222 1.367651 1.379503)
     5.138964 #(0.000000 0.069640 1.207074 1.106607 0.938155 -0.022961 0.022014 -0.175641 0.524055 0.965847 1.374681 0.134317 1.000265 1.686374 0.177984 -0.113132 0.885633 0.500219 1.826760 1.031403 0.156253 1.185539 1.634678 1.214504 1.237698 1.370969 1.376422)
     5.127649 #(0.000000 0.075935 1.194633 1.100459 0.935783 -0.017045 0.029468 -0.170958 0.536465 0.968122 1.366429 0.152232 0.989620 1.697608 0.172767 -0.120765 0.894958 0.517376 1.820543 1.025047 0.164641 1.179970 1.629877 1.210394 1.240904 1.368192 1.368181)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; sqrt=5.291502
#(28 6.0977354049683 #(0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0)
     6.0720555632906 #(0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1)
     6.057788848877 #(0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0)
     6.0276107788086 #(0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.227814 #(0.000000 1.598220 -0.034761 0.157135 0.076356 0.857747 0.795001 0.207843 -0.212308 0.221481 0.631644 -0.052827 1.149380 1.782268 0.524943 0.274524 0.140955 1.711570 1.605287 0.356580 1.284685 1.710224 0.241605 1.255224 0.964895 0.202315 0.724011 0.349143)
     5.196119 #(0.000000 1.617095 -0.026795 0.178392 0.089613 0.876768 0.787211 0.188963 -0.197181 0.222419 0.631291 -0.053606 1.158407 1.786022 0.515505 0.265637 0.142039 1.706825 1.596251 0.377743 1.307602 1.707567 0.263771 1.257314 0.954368 0.197747 0.718393 0.338293)
     5.181387 #(0.000000 1.624203 -0.028425 0.187056 0.091547 0.882303 0.783936 0.183786 -0.191070 0.222441 0.633930 -0.050126 1.156242 1.785069 0.518535 0.261623 0.138007 1.703927 1.592659 0.384084 1.322331 1.713161 0.269368 1.251650 0.946311 0.192317 0.718552 0.333567)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; sqrt=5.385164
#(29 6.2191140571712 #(0 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1)
     6.1799840927124 #(0 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0)
     6.1290216445923 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0)
     6.1179310275088 #(0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1)
     6.0321998596191 #(0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.408434 #(0.000000 1.230326 1.005338 1.568513 0.576466 1.768004 0.800504 0.140541 0.719371 1.353662 0.186415 1.632586 1.491027 1.607986 0.311591 1.880869 1.593879 0.776334 0.744436 0.853178 0.849473 -0.101925 0.610882 0.902989 1.474353 1.175276 0.765416 0.379647 0.892498)
     5.315721 #(0.000000 0.079365 0.503581 0.697134 1.304651 -0.047589 1.609701 0.405141 1.707779 1.204808 1.009818 1.031377 0.730804 1.532058 0.678067 0.440445 0.307115 1.430580 0.635582 0.940852 0.932138 0.809257 -0.046879 1.135572 1.140637 1.804019 0.524748 1.432991 0.106858)
     5.309917 #(0.000000 0.086475 0.507888 0.696653 1.300551 -0.051066 1.617872 0.395210 1.709382 1.209107 1.001180 1.022007 0.732068 1.537796 0.678572 0.427961 0.301094 1.424088 0.636813 0.934060 0.929325 0.808933 -0.048521 1.121954 1.131637 1.802247 0.527138 1.433020 0.096399)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; sqrt=5.4772255
#(30 6.2854590415955 #(0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0)
     6.2697563171387 #(0 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1)
     6.2528157234192 #(0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1)
     6.2357559204102 #(0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.555741 #(0.000000 0.440437 0.547330 0.415184 1.387308 1.812823 0.105595 0.253652 1.773552 1.111459 0.099032 0.174668 1.454910 0.731376 -0.387293 0.833427 1.738667 1.583378 1.784819 0.419743 0.472096 1.815315 0.081606 1.690766 1.343988 -0.054973 0.554467 0.734783 0.203950 0.719585)
     5.513413 #(0.000000 1.699709 0.335515 1.213665 1.173165 0.712606 1.332346 0.661773 1.151588 1.282957 0.915551 1.580851 0.407690 0.015142 0.608461 0.692936 0.435513 1.553569 1.342559 0.745177 1.768811 1.155092 0.969923 1.188309 0.450077 0.987363 1.749350 1.705283 0.542005 1.184319)
     5.492249 #(0.000000 0.563551 1.671520 0.867866 1.418934 0.888205 1.760307 0.156746 0.075068 1.405354 0.475017 0.935741 0.137021 0.435531 1.006673 1.290807 0.884129 1.856283 1.482983 0.709540 0.436947 1.406909 1.323650 -0.251610 1.118569 1.335084 1.334543 0.672636 0.762099 0.969101)
     5.441986 #(0.000000 -0.246641 0.729358 0.371863 1.827684 0.949034 1.803907 0.206892 0.840865 0.383521 0.699810 1.222735 -0.040694 0.846309 0.556491 1.130711 0.620937 1.765872 1.449394 1.643089 1.007177 0.172161 0.108523 0.057681 0.734669 1.486192 1.827997 1.591565 1.315231 1.459761)
     5.419259 #(0.000000 -0.249665 0.727414 0.366135 1.817772 0.940168 1.787102 0.206317 0.847534 0.384839 0.694162 1.216814 -0.047247 0.838631 0.559036 1.134307 0.626947 1.755320 1.448216 1.640963 1.009930 0.170067 0.110324 0.041227 0.711962 1.489497 1.843963 1.593878 1.308983 1.459788)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; sqrt 5.56776
#(31 6.3631281852722 #(0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1)
     6.3062944412231 #(0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1)
     6.269211769104 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0)
     6.1342258453369 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.614499 #(0.000000 1.057256 0.771211 1.692016 1.270992 0.219098 1.680191 0.736741 0.722604 0.077997 1.236137 1.356933 0.499227 0.145448 0.536830 1.669975 1.026571 1.731919 0.405892 1.552979 1.655350 0.117425 1.560581 0.172129 0.615040 0.346847 0.133285 0.186681 0.303421 1.326259 1.673642)
     5.551742 #(0.000000 1.460654 -0.071927 1.460547 1.132529 0.355432 1.336140 0.149511 0.744330 0.166997 0.293108 1.251333 0.750975 0.596146 0.186944 0.371668 0.669228 0.558849 0.295221 1.061142 -0.229044 1.762882 1.675782 0.837132 0.271753 1.024898 0.145663 0.326550 0.848897 1.034731 0.033259)
     5.473154 #(0.000000 1.426955 -0.083224 1.471968 1.139607 0.332711 1.293309 0.133745 0.769126 0.158797 0.275458 1.244096 0.780845 0.595354 0.190164 0.344657 0.643824 0.561503 0.322095 1.096846 -0.226503 1.766478 1.679717 0.808974 0.291310 1.038450 0.139597 0.291074 0.828692 1.045031 0.068678)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; sqrt 5.65685
#(32 6.5067925453186 #(0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 0)
     6.5040426254272 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
     6.4926128387451 #(0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1)
     6.4840421676636 #(0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1)
     6.4720740318298 #(0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1)
     6.350724697113 #(0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.737898 #(0.000000 1.505411 1.032925 1.272107 1.948264 0.535387 1.256291 1.374580 0.197145 -0.062144 -0.227457 0.725228 1.801557 1.715862 0.056005 1.135273 1.599180 1.263509 -0.001405 1.615917 0.681908 0.665842 0.435477 0.755601 1.495256 1.125605 1.363942 0.840006 0.784951 0.030466 0.994065 -0.231434)
     5.715647 #(0.000000 0.410274 0.975561 1.602942 0.063060 0.072541 1.838816 -0.096294 1.663893 0.802756 0.594757 1.369695 0.800505 0.835361 1.017235 0.138821 1.593083 1.278450 0.935340 0.980912 1.470845 0.493496 0.245307 0.978711 0.840784 1.228750 0.330939 1.204178 0.236628 1.099369 1.618449 0.878276)

     5.606837 #(0.000000 0.857834 1.235854 0.541690 1.053374 1.464299 0.205210 1.860904 0.502430 1.244452 1.076625 0.924803 1.383174 1.294955 0.304311 1.870581 1.338746 1.846834 1.733595 0.037846 1.118973 0.050248 1.921853 1.479249 1.134164 1.079718 0.869444 1.656513 0.348359 1.185706 0.868017 1.857100)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; sqrt 5.74456
#(33 6.6069865226746 #(0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0)
     6.6028137207031 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1)
     6.5531010627747 #(0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0)
     6.5466594696045 #(0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1)
     6.5448527336121 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1)
     6.4944429397583 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.758270 #(0.000000 0.113404 1.120017 1.701330 0.197542 0.687920 1.778466 0.838895 1.080380 1.571697 0.746577 0.404086 0.231382 1.453934 0.000732 0.041420 1.256944 0.560894 0.913938 0.742759 1.225738 1.056488 0.349734 1.000449 0.767247 1.067291 0.568479 0.890173 1.741165 1.253922 -0.065271 0.637751 0.190859)
     5.688193 #(0.000000 1.524199 1.156032 1.298099 1.541803 0.880008 0.379485 1.701229 1.383525 1.125875 1.358696 0.841803 0.838106 1.015621 1.651453 0.180172 0.336830 0.732093 1.715011 1.117320 0.844935 1.683230 1.734220 1.439061 1.699603 0.590990 1.534100 -0.289055 0.614957 1.814358 0.538002 -0.020086 0.660601)
     5.658971 #(0.000000 1.522758 1.158601 1.296307 1.531645 0.874131 0.398789 1.709357 1.373490 1.133375 1.352763 0.843739 0.834551 1.009921 1.638274 0.183462 0.329851 0.735129 1.724799 1.138678 0.852794 1.673046 1.732859 1.438889 1.677579 0.593140 1.515211 -0.291894 0.622593 1.824296 0.542684 -0.015192 0.649078)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; sqrt 5.8309518
#(34 6.7313859392731 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0)
     6.7289090156555 #(0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0)
     6.7241077423096 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0)
     6.6926617622375 #(0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0)
     6.6887402534485 #(0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0)
     6.67742395401 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0)
     6.5771403312683 #(0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.886165 #(0.000000 1.745057 1.504386 -0.023968 0.205090 1.069486 -0.047234 -0.063358 1.013504 1.050064 1.684875 1.021832 1.166236 0.938115 1.431988 0.555525 1.405223 0.917281 1.215195 0.669468 0.053688 0.024930 1.643093 1.423509 0.223624 1.512856 0.695528 0.899790 1.529750 0.050412 1.716725 0.262916 0.290650 1.510059)
     5.839478 #(0.000000 1.077567 0.246449 0.066969 0.318374 0.562472 0.300162 0.284136 0.411567 -0.020399 1.219454 0.270019 1.522953 0.513677 1.223260 1.013061 0.431117 0.338529 1.237793 0.497738 0.580028 -0.075760 1.487399 0.638100 1.210373 1.405820 0.223755 0.099999 0.180390 1.071946 1.507801 0.907555 1.312123 0.150270)

     5.816833 #(0.000000 1.157345 0.256038 0.835407 -0.111435 1.474980 0.935665 0.608453 0.782889 0.016890 0.469694 0.073778 1.600833 0.868989 1.311955 0.083246 0.787037 0.915296 0.599183 1.680447 0.714292 0.577515 0.989293 0.528274 0.073313 0.898937 0.826996 0.257335 0.989154 1.326012 1.464130 -0.048931 0.064501 -0.019809)

     5.808111 #(0.000000 1.089013 0.260373 0.064087 0.317557 0.547079 0.313042 0.290104 0.395684 -0.020670 1.196564 0.272647 1.515701 0.511511 1.214193 1.004389 0.438002 0.332974 1.248869 0.493327 0.595802 -0.085601 1.484196 0.639060 1.221049 1.397543 0.212570 0.093126 0.151437 1.073931 1.483158 0.893929 1.319583 0.157255)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; sqrt 5.9160
#(35 6.8717794418335 #(0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0)
     6.8709630966187 #(0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0)
     6.8534955978394 #(0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0)
     6.8080215454102 #(0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0)
     6.7822489738464 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0)
     6.7593507766724 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0)
     6.7392678260803 #(0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     6.019745 #(0.000000 1.737129 1.447005 0.192023 0.352390 1.109469 1.141770 0.792931 1.332317 1.747510 0.049345 0.538993 1.123913 1.631468 1.604207 0.569597 1.151844 0.643054 1.428529 0.806422 1.446482 0.982775 1.718698 1.359816 1.027004 0.088993 1.023736 -0.089824 0.151136 1.196612 0.522589 0.421171 0.192329 0.077722 1.755938)
     5.948037 #(0.000000 1.888333 0.202222 1.459883 1.899590 0.077015 0.184626 0.842418 0.183084 0.790336 0.161822 1.118884 1.465652 0.054107 0.126784 0.159971 1.756298 1.301912 1.390376 1.485580 0.832130 1.913961 0.739868 1.697090 1.715452 0.577852 0.520050 -0.044341 1.434851 0.673531 1.907051 -0.198499 0.468800 1.485794 -0.010059)

     5.904167 #(0.000000 0.467316 1.539906 1.650784 0.389505 0.949316 1.400834 1.489350 0.271573 1.222139 0.050732 0.322362 1.913843 1.086016 1.089287 1.635665 0.198516 1.406384 -0.028077 1.242981 0.439339 0.199045 1.786508 1.609822 -0.139475 -0.074767 1.560108 0.386925 1.130946 0.296937 1.644159 1.037989 0.647756 1.104520 1.004190)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; sqrt 6
#(36 6.9997129440308 #(0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 0)
     6.9918489456177 #(0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     6.9864625930786 #(0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0)
     6.9756178855896 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0)
     6.9730844497681 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0)
     6.9310870170593 #(0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0)
     6.838840007782 #(0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     6.8277182579041 #(0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     6.104999 #(0.000000 1.752837 1.478507 1.030358 0.542949 1.150752 1.406409 1.628306 1.434529 0.479758 0.002634 0.911576 1.383993 -0.102666 0.349338 1.583590 0.591440 0.477767 1.641508 0.699772 0.604507 1.198450 1.127226 1.313060 0.124747 1.197769 1.691888 1.408777 0.796362 0.816210 0.996479 0.378214 0.535476 1.799163 1.275608 -0.072063)
     6.099892 #(0.000000 1.361377 0.202438 0.314999 0.779494 1.393777 1.913562 0.025829 1.339151 -0.043380 1.671171 1.100351 -0.055501 1.240865 0.568669 1.249382 1.470228 1.378432 1.688402 1.085009 0.463836 0.866522 1.785170 0.115926 1.223568 1.687751 1.149252 -0.013129 -0.098900 1.491222 1.091598 0.347575 0.045474 0.438897 0.881415 0.357110)

     6.068055 #(0.000000 1.025020 1.676115 0.686856 1.307395 0.441435 0.951387 -0.095921 0.367471 1.508209 1.157956 0.837240 0.923151 0.176010 0.792906 1.251670 0.642869 0.304140 0.490069 0.095945 0.885765 -0.021213 1.568862 0.597559 0.973346 1.305863 1.819866 0.853639 0.683049 1.609296 1.149128 1.182786 1.544361 1.670403 0.233606 0.140762)
     6.052782 #(0.000000 1.750264 1.509727 1.000089 0.545336 1.160906 1.428382 1.609229 1.481339 0.489735 0.010770 0.951463 1.391963 -0.095818 0.365276 1.591882 0.594876 0.467694 1.644238 0.672835 0.585145 1.216413 1.166425 1.327660 0.114015 1.218808 1.700020 1.406578 0.796425 0.844819 0.992481 0.383736 0.549984 1.830025 1.268489 -0.088831)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; sqrt 6.0827
#(37 7.1364183425903 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0)
     7.1333456039429 #(0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0)
     7.1091394424438 #(0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0)
     7.1067843437195 #(0 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0)
     7.0880541801453 #(0 1 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.0842223167419 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.0678915977478 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.0 #(0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     6.273110 #(0.000000 1.414826 0.628930 0.813312 1.065302 1.100961 0.750318 0.560248 1.131956 0.792537 0.929293 1.615968 0.180268 0.893844 0.600559 1.653420 0.991917 1.641041 0.200192 1.603679 0.411579 -0.041896 0.607810 0.660238 1.020969 0.955364 0.021152 0.677987 1.049195 0.130855 0.151263 1.871387 1.407878 1.188185 0.378601 0.736505 0.234494)
     6.272789 #(0.000000 1.133035 1.392613 0.042242 0.488169 1.067855 0.466900 1.009724 1.297296 -0.020264 0.213550 1.161597 0.220645 1.302691 0.561728 1.363189 1.429844 1.006096 1.302650 1.283239 0.704952 0.925881 0.857679 0.228013 0.085843 0.496374 1.252893 0.798642 1.265720 0.745828 0.734376 1.709904 1.738836 1.195157 0.487100 1.694337 -0.109364)
     6.205245 #(0.000000 0.973455 0.067952 1.631066 0.105736 1.409417 0.684112 1.635983 1.602936 0.626723 0.866310 -0.012808 0.155843 0.626732 0.517908 -0.107239 1.545697 0.183872 0.667015 1.763764 0.826021 1.158866 0.080222 0.789108 0.408351 1.615962 1.198377 0.806113 1.179983 0.470821 0.379434 1.796735 0.048950 0.205433 0.338357 0.477912 0.732359)
     6.188054 #(0.000000 0.968224 0.070327 1.632986 0.105613 1.411809 0.684391 1.642900 1.605862 0.625871 0.869592 -0.009040 0.146251 0.619250 0.523405 -0.104175 1.545106 0.182479 0.670963 1.750521 0.809958 1.155189 0.083130 0.801919 0.424481 1.619941 1.204745 0.810053 1.159940 0.480371 0.377627 1.784864 0.052817 0.212958 0.341438 0.490002 0.733538)

     6.176294 #(0.000000 1.205749 1.906971 0.906409 1.768879 0.608649 1.930965 0.297742 1.048545 0.914836 1.017621 1.385936 0.328478 1.685887 1.979137 0.459864 1.128727 0.093608 0.947273 0.836666 1.671806 0.484676 0.182913 1.423597 1.578951 1.469951 0.381280 0.340470 1.595982 0.929298 0.458827 0.029965 0.476700 0.403300 0.248558 0.232562 0.193971)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; sqrt 6.1644
#(38 7.1993670463562 #(0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0)
     7.1947164535522 #(0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 1)
     7.1848387718201 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0)
     7.1674456596375 #(0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     7.0878057479858 #(0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0)
     7.027690410614 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.498837 #(0.000000 1.801604 0.138566 0.402561 1.435184 0.824436 1.269325 1.272347 -0.296668 0.873783 1.019759 -0.253123 0.411596 1.052152 0.142907 1.757835 0.523367 1.303252 0.183203 1.272231 0.367459 0.107509 1.443922 0.519098 0.955865 1.626394 -0.190019 1.189288 0.505993 0.657608 0.052303 1.900451 0.696608 0.586186 0.959641 0.544372 0.416611 0.524010)
     6.452596 #(0.000000 0.115497 -0.060036 0.317068 1.634984 0.036767 -0.086413 -0.083780 1.247181 0.433227 0.414209 1.132978 1.207160 1.490715 0.172103 0.712944 1.197801 1.103764 0.120056 1.101450 1.893411 0.654044 0.808558 1.430306 0.689174 1.160631 1.173076 0.697867 1.637022 0.354978 1.732659 0.883715 0.917374 1.137078 0.886037 0.623492 1.838209 1.361251)
     6.348056 #(0.000000 1.247565 0.994689 1.551099 0.488888 1.542772 0.366143 0.747116 1.870909 0.581972 1.763898 0.325382 1.522317 1.667152 -0.036519 0.152144 1.656849 0.839732 1.484584 1.607022 1.778165 0.443653 1.638816 0.121838 0.586642 0.676378 1.844632 1.364308 1.088233 0.948975 0.777379 0.438270 1.909125 1.267138 0.242669 -0.098927 0.720866 1.048624)

     6.280111 #(0.000000 0.520747 1.421577 0.176661 1.056916 1.397646 0.252339 1.633162 1.155547 0.398512 0.384452 0.956132 1.738361 1.431549 0.851601 0.235269 1.686534 1.104337 1.254740 -0.006588 0.459936 0.747650 0.874175 1.780060 1.617026 1.126483 1.676998 1.184412 0.040788 0.783302 0.108500 1.217910 0.360146 0.692188 0.518792 0.448666 0.423525 0.516280)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; sqrt 6.2449
#(39 7.3710842132568 #(0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.3583292961121 #(0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.3438787460327 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0)
     7.3397698402405 #(0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.3336853981018 #(0 0 0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.3038640022278 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0)
     7.2819819450378 #(0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.2700448036194 #(0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0)
     7.2362656593323 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.462067 #(0.000000 1.795459 1.784017 0.483619 0.568729 0.941472 1.832033 1.448092 1.077620 0.034685 0.883125 1.873724 1.497965 0.975006 1.176788 0.239320 0.676185 1.023431 1.786560 0.716448 0.526115 1.006061 0.473787 0.024751 0.022319 1.546096 1.828681 1.145327 0.004278 0.198717 0.660662 0.477926 0.443146 -0.193443 0.487446 0.769045 0.138291 1.289855 0.649880)

     6.337389 #(0.000000 0.112240 1.438602 1.676292 0.429304 0.672757 0.638085 1.346634 1.132771 1.402658 1.054458 0.635301 1.142229 1.519817 0.692745 0.970300 0.854503 0.230415 1.181627 0.829746 1.510105 -0.025161 1.952828 0.632464 1.418465 0.356526 1.679032 1.231337 0.757837 0.202480 0.926980 0.313435 0.648617 1.576145 1.329115 1.199417 1.762227 0.914164 0.893262)
     6.319448 #(0.000000 0.123734 1.453067 1.682025 0.412131 0.677969 0.632682 1.352382 1.130906 1.397507 1.059073 0.643382 1.148682 1.518561 0.702716 0.963355 0.857570 0.235976 1.181550 0.829109 1.509619 -0.032198 1.951373 0.637432 1.410100 0.361622 1.684750 1.232439 0.757376 0.185826 0.923139 0.302696 0.657360 1.594936 1.325923 1.207204 1.761185 0.911368 0.903488)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; sqrt 6.3245
#(40 7.6328768730164 #(0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 1 1)
     7.5038495063782 #(0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.566332 #(0.000000 1.470543 0.181367 -0.174348 1.253649 0.045015 1.458341 0.025983 1.650285 1.425566 1.345927 1.560550 0.947286 1.019090 1.238103 1.329600 1.716150 1.638998 0.294274 0.775921 0.004181 0.678946 1.664987 1.624679 0.621322 1.196080 0.254744 0.487358 0.248968 1.045168 -0.056900 0.286198 0.992952 0.885599 1.692674 1.234112 0.792550 0.251953 -0.025761 1.457484)
     6.387231 #(0.000000 1.332417 1.088044 1.100488 0.380531 0.838578 0.106130 1.655912 1.074956 1.477288 0.394665 1.022551 0.403585 0.341079 1.513453 0.217057 0.696663 -1.888463 0.484068 -0.023261 1.421464 1.548340 0.445141 1.250260 1.252341 1.411605 0.374796 1.088113 1.366024 -0.484483 0.296126 1.835198 0.848699 0.565323 1.463092 1.201147 1.420233 1.263077 1.900436 1.506022)
     6.349036 #(0.000000 1.322879 1.074832 1.090808 0.376951 0.829887 0.106302 1.666321 1.082941 1.483415 0.395557 1.030298 0.404283 0.331255 1.489799 0.212450 0.690690 -1.884968 0.471761 -0.039410 1.427315 1.553966 0.441358 1.255753 1.256480 1.406541 0.368362 1.082114 1.380896 -0.501678 0.308909 1.835256 0.866957 0.565134 1.452956 1.203643 1.436367 1.278010 1.897258 1.513744)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; sqrt 6.4031
#(41 7.86743174872036 #(0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0)
     7.7093445316966 #(0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.646317 #(0.000000 0.747575 1.360301 1.402138 0.921921 0.386756 0.070484 0.084889 1.024028 1.136457 0.684045 0.788881 0.070869 0.331341 0.686160 0.313395 1.779955 0.515374 1.000202 0.393943 -0.021731 0.307554 0.663667 1.717923 1.931965 1.750661 0.144975 0.513941 0.985055 0.912315 0.498894 1.169735 0.692154 0.870588 1.864910 1.021265 1.853132 1.645619 0.404114 1.594410 1.232672)
     6.600207 #(0.000000 0.741349 1.379955 1.419037 0.919554 0.403428 0.085327 0.082644 1.023472 1.135289 0.677002 0.782029 0.061387 0.351639 0.675836 0.316710 1.793533 0.533608 1.003987 0.417625 -0.014733 0.309104 0.669735 1.696094 1.921260 1.755256 0.151770 0.504542 0.986733 0.910327 0.486936 1.157855 0.689964 0.878370 1.876163 1.028656 1.864512 1.636941 0.398681 1.585714 1.226836)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; sqrt 6.4807
#(42 7.9323644638062 #(0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0)
     7.8349797520917 #(0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1)
     7.77445936203 #(0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.706991 #(0.000000 0.518280 0.007019 0.810804 -0.045818 1.526626 0.644856 0.631395 0.485435 1.019089 0.402578 1.150719 0.326239 0.265745 0.382157 0.440449 1.620707 1.807620 -0.005004 0.395513 0.938809 0.797445 1.144817 0.615661 1.254448 1.493647 1.598220 1.437204 0.340637 1.361556 1.144528 0.162157 0.958689 1.721553 0.024995 1.132719 1.393181 0.429404 0.164365 1.054389 0.976105 0.267729)
     6.684033 #(0.000000 0.525437 0.011411 0.817575 -0.043990 1.528164 0.640334 0.636232 0.488862 1.015113 0.396715 1.154024 0.328981 0.264696 0.374376 0.443557 1.624162 1.809252 -0.004918 0.392220 0.940610 0.796778 1.155857 0.620475 1.249282 1.490550 1.601375 1.427170 0.338569 1.351786 1.140470 0.155804 0.949175 1.725245 0.023294 1.133357 1.386899 0.420227 0.161540 1.053674 0.973652 0.268093)
     6.671248 #(0.000000 0.683638 1.455005 0.487274 0.195650 0.937902 0.184591 1.538655 1.051620 1.448306 -0.013379 0.769351 -0.136719 1.254861 1.444925 1.754426 1.610883 1.575545 0.303918 1.082030 1.567087 1.908601 0.067169 -0.214046 1.137551 0.871241 0.163442 0.157706 0.743307 0.180848 1.420525 1.930444 1.154559 1.371811 1.530148 -0.213780 1.693108 1.103336 0.553073 0.696540 0.299769 1.233084)
     6.605191 #(0.000000 0.665340 1.466571 0.491840 0.201698 0.947379 0.197760 1.525199 1.056912 1.440651 -0.015812 0.754816 -0.131041 1.242773 1.459035 1.747032 1.606147 1.574331 0.312936 1.063108 1.587844 1.942742 0.037846 -0.219439 1.153070 0.874516 0.177739 0.138001 0.765842 0.184117 1.435891 1.935880 1.128883 1.395893 1.533883 -0.242256 1.673293 1.087111 0.535738 0.686069 0.292537 1.217477)
     6.537585 #(0.000000 0.659880 1.459923 0.502324 0.207055 0.950133 0.199814 1.521519 1.063230 1.430836 -0.024460 0.741564 -0.136613 1.236933 1.459047 1.751421 1.601904 1.579260 0.319417 1.062213 1.599559 1.977582 0.010630 -0.220221 1.161328 0.878573 0.185711 0.122848 0.779658 0.198848 1.461105 1.950446 1.112520 1.416486 1.540631 -0.264328 1.675898 1.080730 0.512711 0.685313 0.292249 1.196221)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; sqrt 6.5574
#(43 7.8550543785095 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     7.8274940102143 #(0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0)
     7.7573688953539 #(0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.820518 #(0.000000 0.946114 1.877677 0.723197 0.725132 1.297441 0.312494 1.248349 1.827086 0.656010 0.730435 1.197964 -0.053499 0.512828 0.829605 0.410572 0.310633 0.359026 0.179249 1.314896 1.669338 0.527022 0.969277 0.409984 1.179725 1.028799 0.880097 1.924964 0.214159 -0.097459 0.914438 0.686393 0.041508 1.071215 0.397214 1.419020 1.608047 1.556428 1.740781 -0.228589 0.944234 0.106788 1.730937)
     6.782479 #(0.000000 0.314123 0.893087 0.695351 0.409184 0.217515 0.504707 0.163930 0.167981 1.373456 1.190707 1.145083 1.639580 0.738700 0.848129 0.312544 1.947445 1.050346 0.741204 0.260449 0.725210 1.467645 1.772609 0.021819 0.566564 1.837136 1.496495 1.161009 -0.001385 0.407314 1.586137 0.455866 1.743739 0.873072 0.277270 1.189010 0.136766 0.514016 1.210625 0.924072 1.357727 1.194882 1.817577)
     6.713978 #(0.000000 0.324136 0.899651 0.665103 0.395302 0.212561 0.495827 0.172512 0.181571 1.386518 1.204789 1.141610 1.644520 0.722629 0.831081 0.322850 1.958208 1.033598 0.770319 0.260134 0.701674 1.459068 1.782076 0.018527 0.604978 1.838596 1.516179 1.173337 0.016439 0.384451 1.598267 0.468358 1.762835 0.879300 0.275183 1.216138 0.127362 0.510238 1.207613 0.913037 1.362717 1.190656 1.825549)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; sqrt 6.6332
#(44 8.20137867697624 #(0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0)
     7.9338580613871 #(0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.948605 #(0.000000 1.282417 1.848828 0.482134 1.123482 0.162578 0.878259 1.430483 1.224322 1.763162 1.482121 1.659199 1.627592 -0.088177 0.849972 0.234361 1.010931 0.292866 1.224433 1.225527 1.243469 0.799808 1.243736 0.910691 0.810712 1.105316 0.349723 1.681266 1.218477 0.381110 1.869161 0.038098 0.908002 1.259616 1.569472 1.634082 0.309876 0.326070 1.382178 1.371085 0.343309 1.261477 0.345941 0.161500)
     6.938574 #(0.000000 0.494918 1.307077 1.486115 1.446778 0.528206 0.443607 -0.126870 1.057297 0.374317 0.655793 1.738250 1.886260 1.166132 1.471840 1.382437 0.487545 0.156366 1.613976 1.107682 1.312704 -0.185245 1.172546 0.714872 0.510705 0.457888 0.706370 1.080271 1.377429 0.698938 1.092530 1.420037 0.854464 1.367402 0.349499 1.109099 0.617860 1.617782 0.425749 0.064629 1.039153 1.363482 1.517363 1.561193)
     6.907515 #(0.000000 0.493952 1.314789 1.470240 1.438642 0.535237 0.438835 -0.142442 1.057575 0.377652 0.653965 1.731054 1.890756 1.150468 1.472588 1.402833 0.480698 0.148510 1.619302 1.105213 1.330276 -0.210500 1.151769 0.711354 0.504583 0.457253 0.710641 1.079030 1.378759 0.688713 1.092512 1.415381 0.845127 1.366237 0.361182 1.107367 0.607537 1.631024 0.428317 0.051481 1.042375 1.370631 1.521857 1.550032)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; sqrt 6.7082
#(45 8.1525803340105 #(0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1)
     8.1351366043091 #(0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     7.014550 #(0.000000 1.549820 1.727819 0.947378 0.202649 0.128108 1.845552 0.989769 1.385432 0.774466 1.562304 1.791925 0.994094 0.351909 1.681951 0.720260 1.571855 1.622106 1.386850 -0.198958 0.204647 0.483002 0.056720 0.712129 0.333500 1.341493 0.578522 0.993324 0.454692 0.578053 0.974240 0.388626 1.746814 0.438852 0.578490 0.087252 0.189583 1.329407 -0.180755 1.569434 0.723657 0.922447 1.443666 0.001943 0.207990)
     6.979832 #(0.000000 0.911146 0.440714 1.255454 0.497298 0.711629 0.696436 -0.097445 1.195347 1.407286 1.662950 1.206531 1.198048 0.182847 0.550596 1.356131 0.836275 0.438164 1.000274 1.641813 1.419751 1.889954 0.726837 1.331775 0.103515 1.904545 0.984163 1.726841 1.234783 1.065842 0.323830 1.478871 1.890882 1.741689 1.699695 0.526939 1.468630 1.487722 1.204860 0.033936 0.404950 1.209025 0.928975 1.166571 0.951037)
     6.944207 #(0.000000 0.920579 0.452707 1.240876 0.499135 0.697832 0.684659 -0.087771 1.197543 1.416396 1.668008 1.191853 1.207223 0.188561 0.556223 1.356141 0.817189 0.449379 1.011416 1.645856 1.433683 1.879498 0.732017 1.342510 0.104122 1.909571 0.984383 1.730891 1.247164 1.074595 0.318371 1.491736 1.879552 1.727429 1.712053 0.543578 1.462606 1.470618 1.194373 0.030170 0.415244 1.211404 0.935061 1.181182 0.951995)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; sqrt 6.7823
#(46 8.2970391011104 #(0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0)
     8.1455316543579 #(0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     7.105251 #(0.000000 1.353994 0.413905 0.999377 1.057068 0.709675 0.615860 0.113982 1.576267 0.179678 1.426822 0.981541 -0.162204 0.434777 1.205347 1.524673 1.000438 0.303430 0.718528 1.199417 0.734265 0.168285 1.707809 1.461986 0.687343 1.450258 0.999465 -0.087951 1.790205 0.193916 1.555009 1.838407 0.970275 1.651515 1.399755 1.688215 1.322336 0.182176 0.028034 1.214377 1.744514 0.477277 0.913755 0.573956 1.002048 1.301328)
     7.055138 #(0.000000 0.733103 0.806231 0.952954 0.725909 1.387841 0.114193 -0.146457 0.545410 1.742840 0.624185 0.426819 1.039217 1.172116 0.024410 0.729554 0.667626 0.002466 0.817086 1.019928 1.627785 0.418636 0.924915 0.463978 0.952578 1.509621 0.622377 1.301657 0.674035 1.467622 1.018421 0.830168 0.203096 1.877261 0.778034 0.266159 0.015894 1.559157 1.959092 0.437188 0.345487 -0.219486 -0.011925 1.627241 1.039073 0.811953)
     7.020408 #(0.000000 0.741050 0.793676 0.954833 0.723080 1.372279 0.100357 -0.163889 0.525177 1.751306 0.629286 0.423593 1.042638 1.158840 0.021745 0.744212 0.645538 -0.011329 0.804634 1.030294 1.619291 0.417666 0.931262 0.459672 0.937345 1.521062 0.614937 1.304723 0.675889 1.473901 1.021078 0.835859 0.206203 1.869463 0.774349 0.262929 0.016355 1.568586 1.965653 0.430126 0.353767 -0.220174 -0.014694 1.626401 1.037468 0.808183)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; sqrt 6.8556
#(47 8.4595276184949 #(0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1)
     8.336971282959  #(0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     7.210873 #(0.000000 1.566854 1.559342 1.445736 1.743531 1.716836 1.127417 0.668001 1.528054 0.174443 0.272253 -0.014976 1.790296 1.376529 0.342231 1.723531 1.448614 0.625536 0.532794 1.251120 1.472450 0.700758 1.236925 0.393791 1.737381 1.495383 1.315233 0.281691 0.613711 0.576631 0.821529 1.851651 1.045857 0.247443 0.699845 0.467117 -0.093990 0.590323 1.217594 -0.076570 1.358863 1.779697 -0.068622 0.698093 0.197578 1.317204 0.013950)
     7.151089 #(0.000000 0.802179 0.479058 0.995523 0.330857 0.787309 0.018849 1.290389 1.543898 1.286376 -0.065478 1.873807 -0.075856 0.095059 0.185679 0.108381 -0.027830 1.343002 1.233320 0.229301 -0.024179 1.606192 1.729972 0.404980 1.302085 -0.066593 0.370262 1.688240 1.178420 0.850625 0.340801 0.893433 0.609800 1.585127 0.279230 0.047129 0.667544 0.832286 1.860982 1.887130 1.497861 0.520610 1.514135 0.766858 1.202981 1.515261 0.342115)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
#(48 8.35563071219336 #(0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     7.246462 #(0.000000 1.356698 -0.062399 0.419335 0.018912 0.019469 1.086834 1.375876 0.814929 1.060293 1.712420 0.396926 0.730832 0.467653 0.801802 1.172900 0.374224 1.608410 1.858565 -0.107371 0.553667 1.618892 -0.030210 1.701272 0.760689 0.150761 -0.015109 0.877602 1.005512 1.608485 1.126036 1.486738 0.755311 1.289597 1.205930 0.058019 1.997882 1.013411 1.721191 1.269691 1.807633 1.364924 1.101733 0.778774 1.718707 1.730713 -0.031059 1.492536)
     7.208597 #(0.000000 1.237786 1.016918 -0.009567 1.613205 0.162287 1.880479 1.780426 0.301880 0.874514 0.490620 1.501849 0.682691 1.619168 0.967932 1.703056 0.162830 0.873905 0.406192 1.110879 0.195345 0.969691 1.318815 1.834296 0.174727 1.541086 1.050589 1.907489 1.185228 1.825802 0.281013 0.537450 0.952557 0.763734 0.544912 0.171646 0.166408 0.374909 1.623496 1.498652 0.549437 0.200991 0.274116 1.330253 0.205626 0.539603 0.162525 1.779500)
     )

;;; 49 odd --------------------------------------------------------------------------------
#(49 8.57458718352971 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

     7.434920 #(0.000000 1.125898 0.150074 1.046158 0.962446 1.306626 0.103665 0.653682 1.788801 0.037785 1.543260 0.755454 1.626361 0.904741 -0.121968 1.522476 -0.211749 0.009130 0.232027 0.865627 0.510112 1.776874 1.854081 -0.068569 1.679078 -0.260736 0.476878 1.267880 0.914970 1.402339 1.212345 0.456306 1.109712 1.090381 0.135938 1.900427 1.411989 0.728803 0.602931 0.285995 1.442410 0.612579 0.888404 1.459891 0.396330 1.364427 1.371237 1.163607 1.483597)
     7.331901 #(0.000000 -0.060748 -0.051246 1.098496 1.517879 0.281300 -0.038960 -0.040114 1.310417 1.674211 0.798244 0.574534 0.814930 1.443570 0.201006 0.822614 1.684704 1.480120 1.879506 1.500216 1.050687 0.662741 1.062510 1.008098 1.364623 -0.048640 0.054305 1.253128 1.488240 1.695301 1.263575 0.221657 1.933573 1.071990 0.764020 1.629694 1.136321 1.325025 0.753190 1.876201 0.476066 1.531167 0.609249 0.314878 1.354084 0.120420 0.523074 -0.012200 0.201853)
     )

;;; 50 odd --------------------------------------------------------------------------------
#(50 8.7349090576172 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 1 0 1)
     8.7194833755493 #(0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1)
     8.711 #(0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     7.519331 #(0.000000 0.293426 0.360224 0.076166 0.939479 0.623387 0.941058 0.905040 1.028452 0.321975 0.758001 0.061474 1.120108 0.847094 -0.157186 0.649910 1.783136 0.552384 1.451250 0.436900 0.941433 1.015998 0.132368 -0.236041 1.927183 1.298731 1.635014 1.757997 1.907563 1.590912 1.245579 0.572586 1.287736 0.654530 1.656919 0.751059 0.616771 0.064328 1.125030 0.995342 0.911824 -0.002450 1.258100 0.020071 -0.104777 1.108824 1.195184 -0.077440 0.466585 1.031158)
     7.402824 #(0.000000 1.268920 1.223801 0.230427 1.359701 1.741882 1.956826 0.938227 0.274600 0.948188 1.008551 0.933850 1.732935 1.523539 1.206939 1.749317 0.092837 0.750137 1.594612 1.069498 0.045122 1.456296 0.497114 1.041062 0.668132 1.329099 1.719051 1.784736 0.160829 1.737093 1.894892 1.567318 1.572858 1.868876 1.132538 0.857664 0.311118 1.740965 1.866357 0.741713 1.388450 0.748994 0.279885 0.716043 1.323280 0.703842 0.587755 0.020035 1.116783 1.962308)
     )

;;; 51 odd --------------------------------------------------------------------------------
#(51 8.7549686431885 #(0 1 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 0 0)
     8.5829010009766 #(0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.517092 #(0.000000 0.896944 1.151842 0.525028 1.787180 0.761493 0.090987 0.208783 0.275073 0.275517 1.188620 -0.015038 1.003295 1.310220 0.826285 1.033871 0.795839 0.692864 1.031050 0.770844 0.760416 1.694438 1.195864 0.434548 1.074427 -0.082372 0.670606 1.205088 1.748388 0.331633 0.426799 0.039210 1.383537 0.381055 1.031545 0.721045 0.134319 0.215087 0.126331 1.233099 1.280225 1.725641 0.034393 -0.019845 0.669770 0.323424 0.270922 1.464363 1.025975 0.392120 1.110631)
     )

;;; 52 odd --------------------------------------------------------------------------------
#(52 9.0527429580688 #(0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0)
     8.8599758148193 #(0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.682637 #(0.000000 -0.043655 0.911335 0.731033 0.506944 -0.101955 -0.062441 0.730189 0.821289 1.938292 1.628803 0.462375 0.416428 -0.135129 1.138001 0.223534 0.992270 0.174533 0.444929 1.601486 1.839063 1.355008 0.827051 0.548603 1.323296 0.981430 0.134622 0.585840 0.981865 0.308232 0.581171 1.014624 0.109262 -0.008922 0.244369 1.105186 0.887633 1.619763 0.828552 -0.055851 0.794405 0.784596 0.461835 1.081011 1.674111 1.490474 1.484268 1.720189 0.348967 1.920303 1.866488 0.228300)
     )

;;; 53 odd --------------------------------------------------------------------------------
#(53 9.2427225112915 #(0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1)
     9.1345848658318 #(0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1)
     9.127 #(0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0)
     9.037 #(0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.834630 #(0.000000 1.360462 1.392837 1.543932 1.283103 0.249470 1.601785 1.803543 1.826099 0.107735 0.087229 1.015075 0.712334 -0.022305 1.658595 1.262305 0.311766 0.022270 1.578199 0.564494 1.066978 0.743752 1.114000 1.567511 0.205262 1.788122 1.987955 1.361881 1.689935 1.109428 0.524184 1.741065 1.840446 0.523134 1.134719 0.847779 1.290054 1.848262 1.333341 0.832564 1.522739 0.819513 1.488442 0.392568 0.715382 0.352190 0.189198 0.393049 1.369737 -0.171228 0.176508 0.814655 1.690536)
     7.713435 #(0.000000 1.178959 0.067806 0.502157 -0.026648 -0.031410 0.058427 0.457485 1.473761 0.926626 -0.074314 1.125416 1.627519 1.148429 0.069298 0.544750 0.676168 1.007830 1.661671 1.300009 0.988492 -0.039123 0.408883 0.254918 0.892108 0.253352 0.550758 0.542154 1.954538 -0.323248 0.812312 1.336536 0.067335 1.273545 1.346577 0.411381 0.541955 0.135632 1.758557 1.360932 0.006985 -0.011929 1.272238 0.527847 1.634777 -0.294481 1.728841 -0.150329 1.014958 1.692520 0.039509 0.629910 0.132426)
     7.689580 #(0.000000 0.990251 0.867937 1.244600 0.208911 1.279344 0.616629 1.044762 0.279156 0.735539 0.115579 0.649409 1.405164 0.122059 0.385224 0.128271 0.384911 1.629693 1.176172 1.330417 0.696337 0.288869 1.852715 0.563725 1.219992 1.291522 0.104688 0.970235 1.076785 1.566071 0.074323 0.336871 1.666760 0.891367 1.214496 1.391365 0.874530 -0.036273 1.203800 0.538264 1.918580 0.007888 0.719040 0.112102 0.157491 0.954765 0.781931 0.740961 0.943684 1.724332 0.611499 0.551186 0.477470)
     )

;;; 54 odd --------------------------------------------------------------------------------
#(54 9.3444428264144 #(0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1)   
     9.025 #(0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.909090 #(0.000000 0.575533 1.650151 0.442556 0.029264 0.242895 0.117160 -0.111650 1.927840 1.609010 0.829413 1.641295 1.878284 1.641225 1.374209 0.651875 0.060303 1.987995 0.046630 1.746432 0.065020 0.428144 1.371651 0.374446 1.283114 0.053469 1.525505 0.164243 0.140917 0.591320 1.313132 0.228674 0.710780 0.492877 1.177965 1.365714 1.974894 1.575443 1.278166 1.422311 0.656210 0.444247 1.188187 0.234190 1.759073 1.576591 0.214001 0.367049 1.366017 0.498172 0.155327 1.301384 1.645971 0.576034)
     7.798340 #(0.000000 0.369150 1.513529 0.082942 1.789172 0.097471 1.290113 1.401434 0.619870 1.009121 0.204336 1.145587 0.405131 0.108622 0.108445 -0.018343 1.368958 0.075617 0.232426 0.550400 1.800691 0.078602 1.929016 1.538974 1.366845 1.264477 0.329007 1.032469 1.929959 1.623550 0.567283 1.336113 0.274450 0.699206 1.827868 0.882880 0.533758 1.170659 0.722641 0.085742 1.483678 0.880607 0.825646 1.805215 1.466636 0.620141 1.006481 1.375457 1.483774 1.631414 1.921871 0.149365 0.682194 0.457984)
     )

;;; 55 odd --------------------------------------------------------------------------------
#(55 9.3425494397445 #(0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 1 0)
     9.2039985656738 #(0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.967501 #(0.000000 0.114824 0.754288 1.568503 -0.000073 1.845111 1.401789 0.385564 1.306605 1.187419 0.409546 0.220689 1.197884 0.775952 1.483899 1.169252 0.288456 0.795382 1.958528 0.303768 1.126547 1.730406 1.573922 1.385950 0.233854 0.712846 0.724411 0.479079 0.401210 -0.031541 0.746591 -0.037899 0.684571 0.243932 1.210741 1.203812 0.743919 1.623134 1.380966 1.398503 0.030757 0.075035 1.453219 1.009474 1.271799 0.511996 1.141909 1.582994 1.116151 1.177404 0.919157 1.729440 0.212386 1.989862 1.150567)
     7.906425 #(0.000000 0.303952 0.284916 1.364360 0.562420 1.124241 1.267620 0.036958 1.359090 0.301303 1.826083 0.709550 0.134838 1.852292 0.064210 0.542219 1.676359 1.013692 1.306873 1.273312 -0.095616 1.901121 0.188634 0.172644 1.598746 0.151905 0.256190 1.505731 1.429952 0.546210 0.657956 0.308010 0.059913 0.344425 1.131606 0.911610 1.497666 0.281294 -0.016088 1.088509 1.015652 -0.069609 1.380369 1.306796 0.663457 1.284467 0.199430 0.717592 0.313701 0.534990 0.204868 1.429939 0.364894 0.603470 1.857080)
     )

;;; 56 odd --------------------------------------------------------------------------------
#(56 9.5248985290527 #(0 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0)
     9.3816785812378 #(0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     8.014360 #(0.000000 1.797743 1.790929 -0.063244 1.399761 0.825467 1.042878 0.871116 0.660103 0.792084 1.323592 1.775920 0.351764 0.773747 0.912164 0.801864 1.136307 0.033185 1.586113 0.536880 -0.077324 0.430168 0.174323 0.399851 1.429710 0.251935 -0.137558 0.679380 0.477708 1.540522 0.662388 1.519768 -0.242728 -0.073217 1.093520 0.871057 0.321485 0.164858 0.286317 0.927138 0.308282 0.236823 0.640929 -0.015174 -0.119175 1.253268 0.209654 0.781356 1.431116 0.571652 0.052428 0.983550 0.980338 0.561459 0.703409 1.606571)
     7.938712 #(0.000000 0.398446 0.923787 1.370687 0.474513 1.512124 1.836648 1.675730 0.662982 0.910146 0.406888 0.280460 0.930743 0.882485 0.576908 1.027832 1.093424 0.802764 1.445730 1.412375 0.061892 1.881226 1.315258 1.374663 1.654078 0.250926 0.587919 1.631358 1.242844 -0.134307 1.504610 1.607906 0.373135 1.588130 0.997187 1.226509 1.459703 1.061631 1.019665 0.243831 0.359597 0.002891 1.041917 0.247145 1.058143 1.393763 -0.010811 1.214368 0.428813 1.217360 1.113211 1.852395 0.663285 1.735710 1.436988 1.061403)
     )

;;; 57 odd --------------------------------------------------------------------------------
#(57 9.5457010269165 #(0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0)
     9.543363571167 #(0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1)
     9.3903837203979 #(0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     8.153561 #(0.000000 1.684511 0.395320 1.559500 0.099704 0.379289 0.037223 0.916346 0.377018 0.527812 0.616527 0.712142 1.804818 0.189502 1.126051 -0.056602 1.721419 0.847869 1.633289 1.342478 0.627159 1.355924 1.769068 0.758602 1.158468 0.123753 1.706511 1.276749 1.451713 1.194448 1.565933 0.473307 1.535506 0.764639 0.424671 1.801553 0.643764 1.175661 0.792978 1.153771 0.427617 0.169094 0.235485 1.603950 1.281174 1.713134 0.235119 0.879894 0.719225 1.264748 1.587799 1.288087 0.479907 0.239266 1.664803 0.719998 0.903985)
     8.101129 #(0.000000 0.084141 1.298632 0.689329 0.668897 0.007139 1.693526 0.959778 1.670625 1.308471 1.046444 1.074921 0.562204 1.387144 1.553328 0.977090 -0.125950 0.799193 1.519579 0.711553 0.909386 0.647693 1.524859 0.130158 1.802963 0.558724 -0.085391 1.980487 0.199875 1.477940 0.415419 0.093680 -0.018093 0.454996 0.409679 0.915780 1.309664 1.421015 0.460452 1.200684 0.691653 0.015745 1.917467 1.561822 0.284497 0.310031 1.134023 0.405953 1.393499 1.441258 0.309271 0.860366 0.729197 0.431665 0.355042 0.781152 1.880475)
     )

;;; 58 odd --------------------------------------------------------------------------------
#(58 9.7054271697998 #(0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.6265433375878 #(0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.5893135070801 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     8.111595 #(0.000000 0.114015 0.556241 0.741930 1.407205 1.027319 0.685372 1.279761 1.198109 0.093106 -0.492978 0.290524 0.836910 1.383532 0.394064 1.818496 1.814179 1.180940 1.646749 1.363393 0.601153 1.348309 0.800538 0.558880 1.187430 0.268125 1.172620 0.378465 0.606149 1.894903 1.882951 0.719611 1.441954 1.576337 1.384013 0.845091 0.225454 1.741272 0.957008 1.475760 -0.019393 1.501759 0.900295 0.881454 1.057711 1.385935 -0.033557 1.470713 0.659316 1.526338 0.368676 1.208865 1.282096 0.755442 0.746082 0.835197 -0.213420 1.560142)
     8.100582 #(0.000000 0.549234 0.087145 1.264889 0.466587 0.765130 0.520970 1.007596 1.046374 1.053457 1.739632 1.567989 0.642563 1.420450 1.769253 0.367054 0.922793 1.407937 1.900932 1.486044 0.253497 1.898294 1.469214 1.326468 0.546837 1.440613 0.147606 0.157635 0.719109 1.156565 1.123249 0.867987 0.109050 0.254212 1.907040 1.157367 -0.027980 1.957240 1.617104 -0.069823 1.441395 0.594711 0.014112 0.642878 1.085538 0.587530 0.448379 1.675420 0.417987 1.616348 1.961726 1.227856 -0.166913 0.385256 0.886237 0.210802 1.756041 0.003336)
     )

;;; 59 odd --------------------------------------------------------------------------------
#(59 9.955 #(0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0)
     9.6750946044922 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1)
     9.5173864364624 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     8.161418 #(0.000000 1.333321 0.505391 1.084170 0.404634 0.347363 0.092509 0.711329 1.332337 0.476244 -0.203004 1.949851 1.300907 1.250102 0.479638 1.293236 0.668816 1.599089 1.760865 1.884572 1.706751 0.278772 0.032763 1.533515 0.340271 1.322303 0.913987 -0.070984 0.275684 1.000174 0.915668 1.456247 0.804542 1.257801 0.583877 0.275638 0.936324 0.749819 -0.022089 0.010769 1.176176 0.737252 1.244013 1.405869 0.199125 1.684550 1.622470 0.882994 1.241705 1.287343 0.493800 1.245390 0.428488 0.726116 1.535415 1.087613 0.834624 1.251174 1.565530)
     )

;;; 60 odd --------------------------------------------------------------------------------
#(60 9.8824768066406 #(0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 0)
     9.6560277938843 #(0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     8.317339 #(0.000000 0.317806 0.606795 1.664404 1.168997 0.118160 1.044163 0.822238 0.477262 1.218638 0.071405 1.392847 -0.138405 1.537589 1.310749 -0.135302 1.403099 0.296339 0.949443 -0.317675 1.148963 0.205823 0.904342 1.195105 1.874018 0.061364 0.017499 1.858769 0.443848 1.496992 1.572098 0.123926 1.918179 1.704858 0.560198 0.275793 1.516760 1.381010 0.518017 0.049893 0.227152 1.236288 1.604829 0.118576 1.536713 1.500649 1.148137 0.575976 -0.040473 0.797609 1.520366 1.003416 1.286463 0.461885 -0.139780 1.605172 0.033069 0.839984 0.885458 0.592349)
     )

;;; 61 odd --------------------------------------------------------------------------------
#(61 9.9989261627197 #(0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1)
     9.9643812179565 #(0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1)
     9.8069976254571 #(0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0)
     9.6665821075439 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.469815 #(0.000000 -0.079911 1.086262 1.842075 0.167177 0.429735 -0.114039 0.971070 0.781347 0.348514 -0.605451 1.756034 0.654148 0.285810 1.823960 1.689357 1.710731 1.260972 1.559575 0.520610 1.909229 1.500782 1.396279 0.631727 1.650258 -0.135927 0.676259 1.615386 0.619730 1.142506 1.002871 0.395146 1.086375 0.779652 0.537524 0.472778 0.324491 1.583262 -0.482020 0.560371 1.120342 0.981025 0.882113 1.042510 1.520842 1.096779 1.841944 0.945388 0.249731 1.084316 -0.229499 0.373357 0.766648 1.189808 -0.388479 0.110386 -0.173426 0.746150 1.113845 1.068163 0.896044)
     )

;;; 62 odd --------------------------------------------------------------------------------
#(62 10.200 #(0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     10.048614501953 #(0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1)
     9.8772821666628 #(0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     9.7982149124146 #(0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     8.460654 #(0.000000 1.832640 -0.170370 0.233285 0.681182 0.187354 1.496750 1.178176 1.483692 0.832870 0.292431 0.278444 0.109484 1.336036 0.731622 0.747613 0.381038 0.357211 0.613207 0.266071 -1.842751 1.673389 0.243196 1.764182 0.125303 0.428135 0.759384 0.184504 1.430579 0.513582 1.441032 1.493168 1.255571 0.793496 0.813952 1.300297 1.507259 0.159288 0.453838 0.233620 1.141470 1.570258 0.249228 0.737964 1.356224 0.728901 1.040047 1.238948 -0.135762 0.830270 0.646987 1.618604 0.422231 1.425821 1.562763 0.918023 0.012539 1.104240 0.985253 0.417711 1.573628 0.789245)
     )

;;; 63 odd --------------------------------------------------------------------------------
#(63 10.203475952148 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     10.191082449969 #(0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     9.8550319671631 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     8.460755 #(0.000000 1.639292 0.176233 0.916229 0.641025 0.525167 0.535945 1.083769 1.144226 1.066865 1.795430 0.061627 -0.286391 0.684001 1.464117 0.339137 0.152513 1.294002 0.318708 0.979688 1.623882 0.333727 1.774740 0.933490 1.130231 1.621426 0.832979 1.914393 0.513784 0.835219 0.587734 0.105476 0.610508 1.620250 0.021508 1.697842 1.300977 1.506050 1.537375 1.610695 1.651772 1.486161 0.820440 0.246301 1.654201 0.067330 1.680503 1.063456 1.415942 0.585214 0.820905 1.338127 0.161170 -0.051331 1.299294 1.125447 0.953663 0.280187 1.445152 0.831049 0.207146 1.988868 0.831390)
     )

;;; 64 odd --------------------------------------------------------------------------------
#(64 10.559404013831 #(0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0)
     10.301 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1)
     10.113667488098 #(0 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1)
     10.022200584412 #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1)
     10.0 #(0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     8.556224 #(0.000000 1.003744 0.731363 0.766660 0.485218 0.941603 1.011757 0.134838 0.728962 0.030502 1.292100 1.257487 1.201918 0.020298 0.711953 0.340836 1.069477 -0.005116 1.495906 0.824537 0.573352 0.917142 0.946748 1.806816 0.505255 -0.563909 0.774916 0.512729 1.223463 0.574638 1.724708 1.163253 0.775498 0.256584 1.021859 1.046676 1.269040 0.411499 1.213900 1.741006 0.730506 0.120895 0.103157 0.597352 1.979924 0.049131 0.367899 0.609277 0.661859 1.429276 -0.161692 0.150928 -0.317350 1.546589 0.310544 0.414811 1.402921 1.479464 0.883471 1.085172 0.392052 1.595490 0.390014 0.696688)
     )

;;; 65 odd --------------------------------------------------------------------------------
#(65 10.517309434908 #(0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)
     10.169842720032 #(0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.718151 #(0.000000 1.600540 1.317058 1.736539 1.514367 1.054149 0.016899 1.181483 0.075813 1.547879 1.248646 0.496669 0.131433 0.466684 0.564650 1.585576 1.740222 1.946894 0.515908 0.485700 1.898747 -0.001421 1.640587 1.124779 1.380012 1.496139 0.404441 1.525283 0.676454 1.247620 1.970065 -0.023254 -0.205380 0.338411 1.598936 1.545011 1.334056 1.359307 1.534335 1.929437 1.075500 0.322198 0.329587 0.064261 0.774691 1.008562 1.158318 0.828332 0.945159 1.607654 0.125357 0.819775 1.652241 1.415146 0.809011 1.902126 1.938102 0.850236 0.501303 1.572520 0.155689 1.221422 0.433346 1.074674 0.763486)
     )

;;; 66 odd --------------------------------------------------------------------------------
#(66 10.212840820553 #(0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.818083 #(0.000000 0.892187 -0.146460 1.115438 1.098398 1.061158 -0.047919 1.038908 1.248599 1.676237 0.136451 1.352192 -0.090267 0.076447 0.660130 -0.090883 1.545226 0.871833 0.386265 0.780474 0.023982 0.704827 0.299277 1.223293 0.200824 1.711085 1.514450 0.416922 1.558330 1.121638 0.359692 0.885591 0.070808 0.023818 1.406315 1.385524 1.476209 0.166870 0.035356 1.832258 1.004793 -0.043039 1.137749 0.120634 0.744820 1.220302 0.707918 0.824160 1.686631 0.097536 1.705834 0.083039 0.469763 0.888652 0.993641 1.593969 1.773129 1.141953 1.139169 1.718658 1.509289 1.171520 0.877438 1.246152 1.569207 0.971627)
     )

;;; 67 odd --------------------------------------------------------------------------------
#(67 10.718281745911 #(0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1)
     10.287303318203 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 1)
     10.209677696228 #(0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     9.037560 #(0.000000 0.399945 0.888012 0.642166 1.521769 0.481523 0.779936 0.214576 -0.234029 1.401037 0.914470 0.138763 1.442274 0.016954 0.866833 1.194652 1.318944 1.101815 1.034905 0.863234 1.763858 0.524351 1.096825 1.248651 0.235129 1.643410 1.850820 0.598952 1.328344 -0.025668 0.052311 -0.104086 1.809401 1.064287 0.703949 0.711563 1.907801 1.190232 1.285796 1.683568 0.744856 0.507500 1.035712 0.808301 0.658284 1.622300 1.471006 0.149122 1.521163 0.922261 1.449365 0.134239 0.891434 0.667904 0.479963 0.664780 0.351447 0.079659 0.678471 1.012523 1.137521 -0.131810 0.854900 0.169147 0.455238 -0.051052 0.689984)
     )

;;; 68 odd --------------------------------------------------------------------------------
#(68 10.698028101377 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1)
     10.359804316765 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     9.037047 #(0.000000 0.256284 1.816668 0.977057 0.689836 0.369745 0.161286 0.091713 0.783724 -0.043351 1.538972 0.867228 0.560580 0.795614 0.090170 1.569096 0.106055 0.615706 0.679075 0.807355 1.525256 1.413193 0.511384 0.585524 0.908378 0.777947 0.895077 -0.186931 0.330116 0.254327 0.050766 0.592045 0.316522 0.793287 0.207108 0.529469 1.541495 1.733695 0.932046 1.498268 -0.126048 0.859106 1.593707 0.910225 0.190311 1.415932 1.681993 1.077741 1.388597 1.133497 1.536343 0.226665 1.971858 1.406687 -0.145683 0.534419 -0.011245 1.037726 1.396634 1.826967 0.505682 1.708816 1.209425 0.247601 0.683238 1.200371 0.850642 0.133500)
     )

;;; 69 odd --------------------------------------------------------------------------------
#(69 11.012202262878 #(0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1)
     10.744618415833 #(0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1)
     10.636575441359 #(0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1)
     10.452348709106 #(0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.968883 #(0.000000 1.673496 1.523485 0.007287 0.171302 0.473747 0.683465 1.333337 0.981720 0.100030 1.647188 0.617282 1.150903 1.261565 1.143270 1.000422 0.294007 0.183636 0.336228 0.148010 1.823220 0.177454 0.713756 1.600356 0.863222 0.527960 1.413471 1.765623 0.818723 0.285238 1.292676 -0.054440 0.394081 1.450903 1.995427 1.545600 1.114425 1.469540 1.387927 0.373034 1.570064 0.888101 0.217276 0.083735 0.808897 1.009471 0.884329 1.857603 0.567631 0.867504 0.020526 0.114027 1.424830 0.570467 0.871690 0.966437 -0.035976 0.654950 1.348777 1.045671 0.736412 0.572491 -0.073660 0.907793 1.212384 0.767884 0.605340 1.119910 0.721177)
     )

;;; 70 odd --------------------------------------------------------------------------------
#(70 11.087729454041 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1)
     10.431521047498 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     9.063070 #(0.000000 1.049673 0.475640 -0.284361 0.288138 0.903305 1.167055 -0.042721 1.679535 1.376218 1.516452 0.071578 -0.055477 1.035124 0.002301 -0.256448 0.418640 0.205192 0.847097 -0.018969 -0.003256 0.503833 0.758774 0.983169 0.865401 -0.483133 0.972821 0.578021 0.549652 -0.435246 0.365580 0.637962 0.292985 1.560704 1.382857 1.358941 -0.213364 1.154759 0.517054 0.631805 1.333993 0.894917 1.411802 1.747848 0.405321 1.660360 0.475471 1.326536 0.069383 1.217537 0.594781 0.235880 1.139694 1.241873 0.843062 1.458571 -0.548275 -0.305211 1.225759 0.983779 0.733245 0.764363 -0.020526 1.029843 1.337858 0.959771 1.022593 1.223213 0.211818 0.616212)
     )

;;; 71 odd --------------------------------------------------------------------------------
#(71 11.111848131381 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1)
     11.002258540604 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0)
     10.642364501953 #(0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

     9.253409 #(0.000000 0.912005 0.692877 1.921000 0.169416 -0.173407 -0.171356 1.582459 0.426049 0.851093 1.098785 0.836379 0.525110 0.790925 -0.091946 0.235715 0.947112 0.300555 1.481077 0.986486 1.235556 1.234773 1.897765 1.870760 1.398281 1.470329 0.505928 1.480878 0.646939 0.579740 1.159797 1.590284 -0.081025 0.871018 -0.041739 1.099598 1.407276 1.710878 0.011097 0.966115 0.720663 0.098577 0.945253 1.039828 1.487202 1.639390 1.111409 0.911299 0.761665 1.175358 0.544225 0.773787 1.364872 0.255496 1.596459 0.441760 0.699950 -0.179841 0.839764 0.189282 -0.270071 0.643474 1.189010 0.653916 1.717086 -0.333719 1.624417 1.486830 1.292116 0.450193 1.539540)
     )

;;; 72 odd --------------------------------------------------------------------------------
#(72 11.026193997702 #(0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.912703440154 #(0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.880306243896 #(0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     9.354708 #(0.000000 1.537010 0.316412 0.438223 0.745483 1.500969 0.973595 1.560329 0.217057 1.185539 0.509323 0.770025 1.659901 0.821844 1.253393 1.523047 1.181788 0.404961 1.666674 0.208686 0.702028 0.579453 0.849437 0.656711 0.939816 1.594296 0.900064 1.667644 1.122564 1.270831 0.360240 0.415028 1.634526 0.161327 0.480790 1.578178 0.764459 0.304884 1.259576 1.352148 0.467810 1.073956 0.913123 0.139638 0.546669 0.666526 1.867575 1.330492 1.701738 0.786362 1.076089 1.408082 0.421929 1.139826 0.631240 1.459418 0.998796 0.946766 0.635722 0.181344 1.004657 1.140725 0.045775 0.060758 1.939056 1.274665 0.974610 -0.043369 0.114328 0.168328 -0.028319 1.764050)
     )

;;; 73 odd --------------------------------------------------------------------------------
#(73 11.087996391987 #(0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1)
     10.907942771912 #(0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     9.445813 #(0.000000 1.397538 0.407754 1.802328 1.251176 1.475384 0.110518 -0.093291 1.122074 1.429685 1.604293 0.091655 0.266977 1.574505 1.924083 0.681378 0.575844 1.254781 0.437160 1.643583 0.304692 0.401651 0.974599 0.940375 -0.003075 1.897595 1.877825 1.526235 1.441827 0.252749 1.086695 1.600411 -0.002466 0.578033 0.128986 0.419108 0.707013 0.101350 1.169149 1.224246 0.365757 0.824641 0.041794 0.747312 -0.241555 0.522105 0.274225 1.158153 0.891091 0.973881 0.823251 0.345356 0.371137 0.978606 1.644063 0.271955 -0.012947 0.058941 1.804679 0.419407 1.490331 0.440467 0.616011 -0.091605 1.434451 0.808635 -0.043994 1.670703 0.357639 0.830927 0.079813 1.630494 1.685658)
     )

;;; 74 odd --------------------------------------------------------------------------------
#(74 11.4198214166449 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0)
     11.288741871055 #(0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0)
     11.262331896     #(0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     9.354411 #(0.000000 0.298593 0.506130 1.238027 0.817072 0.092008 1.163107 1.286336 0.272292 0.936799 1.279665 -0.038909 0.951674 1.449397 0.384959 0.061607 1.259543 0.144777 0.690030 1.083121 0.767952 1.244620 1.152491 0.032716 0.777433 1.410269 -0.190518 0.423223 -0.108662 0.784774 -0.158795 0.202683 0.778329 1.621736 1.226959 1.759259 -0.243629 1.779909 1.042525 1.679241 0.751212 1.294113 0.573888 -0.177350 0.187217 1.800244 0.229684 1.900746 1.161579 1.345865 1.295695 -0.052076 1.340517 0.737474 0.105113 1.474047 0.906555 1.114156 1.653086 1.137997 1.389547 0.976760 0.891743 1.950320 1.454563 -0.385653 1.107435 0.966800 -0.007872 0.124625 -0.155386 0.154105 1.504444 0.817577)
     )

;;; 75 odd --------------------------------------------------------------------------------
#(75 11.202813597023 #(0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1)
     11.190553665161 #(0 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1)
     10.942812919617 #(0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     9.548728 #(0.000000 0.919282 1.857535 0.271266 0.724941 1.854037 1.163292 0.080110 1.692977 0.868711 1.442453 0.044618 1.189380 1.487659 1.922282 1.492095 -0.124712 1.552431 1.640230 0.633255 0.281137 0.928494 1.879551 0.337242 0.444075 1.342682 -0.059767 1.698160 1.847940 -0.019489 0.769425 0.378350 0.896222 0.323001 0.680976 0.428865 0.618550 0.029375 1.704824 0.367427 1.577509 0.908428 1.407034 0.181900 1.254495 1.764375 1.597032 -0.001876 0.314084 0.404817 0.884541 1.557516 1.238720 0.197173 1.751355 0.596072 1.556417 1.791734 0.887437 1.458301 -0.049085 1.919750 1.330695 1.271804 1.960604 1.617588 1.199437 0.599718 0.071841 1.749658 1.582254 0.771839 0.920445 0.797876 0.108815)
     )

;;; 76 odd --------------------------------------------------------------------------------
#(76 11.511628975629 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0)
     11.446428749262 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0)
     11.21743106842 #(0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     9.504686 #(0.000000 0.527127 0.888911 0.795380 1.310137 0.444073 0.876103 0.858597 1.159595 0.813084 1.607610 0.294537 1.297511 0.542553 1.145872 1.066976 1.169468 0.539737 1.632132 0.073383 0.295048 0.831817 0.657982 0.736902 0.404340 0.490349 0.841019 1.406424 0.318460 1.086715 0.151616 1.713356 0.477847 0.569636 1.597859 1.683070 0.517356 0.804469 0.423595 0.690858 0.036475 0.207247 1.379105 0.079952 1.948565 1.625867 0.400697 1.437545 1.334918 1.063038 0.542292 0.786423 0.194995 1.180814 0.797356 0.484140 1.699894 1.187720 0.611266 0.937655 1.798058 0.342592 0.362001 1.461267 0.196751 1.728491 1.206467 0.072992 1.062224 0.675300 1.635472 1.543249 1.815074 1.368773 0.128705 0.899742)
     )

;;; 77 odd --------------------------------------------------------------------------------
#(77 11.623893901139 #(0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.38523739395 #(0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1)
     11.302083969116 #(0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.192246437073 #(0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     9.740064 #(0.000000 1.582623 1.606078 1.800623 0.778080 0.786671 0.560402 1.741465 1.877432 1.512431 0.853267 0.575227 0.084790 0.306848 0.373158 0.952424 1.205615 1.259483 -0.351678 1.046447 0.241044 -0.123341 0.605295 1.294209 -0.011410 1.385333 0.150053 1.375452 0.709473 0.689958 1.335283 1.215680 0.801072 0.916579 1.764170 1.152864 -1.952153 0.708530 -0.033762 0.022067 -0.004235 0.608213 0.048011 0.091825 1.078476 1.662086 0.817960 0.080887 0.881943 -0.050437 0.338472 0.737728 -0.024839 0.271518 -0.110017 1.718464 1.382000 -0.181664 -0.057095 1.884654 1.178099 0.449116 1.698060 0.314397 -0.230417 1.327861 -0.007992 0.875566 1.093707 1.759341 0.267427 0.515417 0.155507 0.672339 1.709940 0.298719 0.919843)
     )

;;; 78 odd --------------------------------------------------------------------------------
#(78 11.455265310659 #(0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     9.684944 #(0.000000 1.628586 0.876835 0.051948 0.225446 0.957682 0.399816 0.835219 0.960881 0.610075 1.870085 1.067593 0.929443 1.114752 1.918079 -0.075624 0.363686 0.026688 1.070954 0.505946 0.654008 0.535327 0.135465 0.179306 -0.041660 0.818114 0.294244 0.974372 1.950323 0.126988 0.257954 0.292923 0.589657 1.063885 0.017472 0.665923 0.682337 0.516258 1.096580 0.513461 0.744503 1.736089 1.358168 1.619440 0.329913 1.030859 1.626812 1.607634 0.822899 1.270674 1.453325 0.115904 -0.025894 0.760601 0.498142 0.313656 0.637412 1.569662 0.073732 1.154138 1.488106 -0.036369 1.622715 1.335329 0.912805 0.322870 1.219850 -0.083683 1.414009 0.070751 1.710370 0.944133 1.111559 -0.027334 1.042167 0.726781 0.822450 0.289732)
     )

;;; 79 odd --------------------------------------------------------------------------------
#(79 11.710210993982 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)
     11.54291004024 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     9.897466 #(0.000000 0.258198 0.144624 1.109600 -1.973087 0.965122 0.879701 0.183752 0.341259 0.586965 0.763119 1.034777 1.113506 1.274885 0.176090 1.258061 0.223606 0.010659 1.483572 1.861964 0.323413 1.468005 0.399341 0.902945 0.573498 0.220899 1.187479 1.205109 1.033963 0.600105 1.180800 1.142798 0.089930 1.099801 0.932956 1.157604 0.851713 1.269024 0.120365 0.385883 1.179845 0.519337 1.720962 0.145987 1.593445 1.441431 -0.022464 0.906997 -0.044342 1.106511 0.317358 0.563014 1.596044 1.107173 1.416729 1.670363 0.374626 0.440306 1.549438 0.279954 0.361321 0.017109 1.101416 1.487700 1.195189 0.145544 1.175192 1.053981 0.600940 0.911019 0.729179 0.226640 0.017423 0.964490 1.165943 0.987828 0.399156 1.559343 1.428338)
     )

;;; 80 odd --------------------------------------------------------------------------------
#(80 12.0 #(0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 0 1 0)
     11.963202476501 #(0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1)
     11.681501776885 #(0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1)
     11.501195907593 #(0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1)
     11.122416496277 #(0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     9.839038 #(0.000000 0.557632 0.612112 1.493501 0.236573 1.596851 0.188255 1.605763 1.332184 0.854812 0.405788 1.222516 0.416859 0.756791 0.233468 -0.080687 0.161620 0.943166 1.015839 0.776547 1.773413 0.978271 0.447728 0.277025 0.829561 1.885292 0.377535 1.330238 0.637627 0.927721 0.839577 0.046426 1.244388 1.025940 0.165521 0.648212 0.892377 -0.092263 0.953723 0.146157 0.401058 1.541466 0.602995 0.880459 0.029203 0.434535 0.725535 1.288140 1.541178 0.902310 0.322571 1.297606 0.132432 0.890452 -0.224214 1.505327 1.128561 0.415246 0.618277 0.947345 1.499994 1.131948 0.150795 1.115265 0.630659 0.144229 0.448260 0.747473 1.178787 1.703751 1.677842 1.889735 -0.000419 0.115316 1.579144 0.220267 -0.056031 0.164625 -0.335925 0.884826)
     )

;;; 81 odd --------------------------------------------------------------------------------
#(81 11.757609887857 #(0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     11.551496540317 #(0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.381307601929 #(0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.372210502625 #(0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     9.857316 #(0.000000 0.077217 -0.052603 0.067198 0.882267 1.259422 0.264613 1.113581 0.360857 0.687163 0.614995 0.774045 1.699708 -0.090959 0.371747 1.417261 1.067481 0.830283 0.482104 0.826610 0.427488 0.253118 1.506019 0.811968 -0.016419 0.360650 1.069899 1.401397 0.522233 1.287511 1.029994 1.145709 1.766115 1.153007 0.326710 1.627820 0.353482 0.323058 0.160011 1.049669 1.352002 0.928266 1.492204 1.025978 -0.035087 0.660051 1.295294 0.257693 0.192929 0.437831 0.299765 1.839851 0.540261 0.422877 0.435903 1.885211 -0.228862 1.729293 1.083049 0.403583 1.415957 0.293540 1.565490 1.371943 1.471631 1.962955 -0.012966 1.085166 0.970827 -0.049501 0.187063 1.630248 1.597317 0.522487 1.889580 0.326461 0.382392 1.097176 0.065018 1.324647 0.991792)
     )

;;; 82 odd --------------------------------------------------------------------------------
#(82 11.815696616621 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0)
     11.662058134504 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     9.946913 #(0.000000 1.723534 0.924124 0.824201 0.651105 1.566203 1.440851 1.159858 0.910623 0.103228 1.214642 0.798177 1.747879 0.634624 1.478003 1.626584 0.455679 1.110513 0.306235 0.391871 0.042966 1.730582 0.158373 0.196215 0.365344 -0.052757 1.486313 0.060847 1.092824 0.051296 0.713151 0.527731 1.905043 0.177247 1.979354 1.944182 0.153646 1.080464 1.123281 -0.198404 -0.117766 0.462610 1.514906 0.751002 0.265991 1.525548 -0.154579 1.796965 0.677759 0.133224 0.724095 1.629727 0.702440 1.247499 0.681212 1.321928 0.344149 1.313343 1.907447 0.633181 0.861093 1.556526 0.198693 1.660104 0.194772 1.491172 1.644077 0.173552 -0.076502 1.097994 0.838617 -0.143812 0.765046 0.923700 1.573475 1.544071 1.223952 0.207887 0.346417 0.337761 0.343559 0.237239)
     )

;;; 83 odd --------------------------------------------------------------------------------
#(83 12.05688291879 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.795211509729 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.730722255301 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     10.087885 #(0.000000 0.730702 1.297756 0.107400 0.204091 1.911702 1.072431 0.657447 1.414949 0.133810 0.950968 0.929453 0.414592 0.490315 1.766504 0.681019 0.747339 1.033546 1.857214 1.620081 0.956907 -0.119344 0.460473 0.253567 1.816131 -0.075521 0.596916 0.257658 1.467177 0.352319 1.584601 0.230368 1.739861 1.205888 1.750153 0.629182 1.330234 0.259085 -0.101300 0.052446 -0.125797 1.788033 0.596425 1.168771 0.133630 0.649065 0.153891 0.831573 0.524812 0.769455 0.896865 0.868016 -0.012829 1.412314 1.075578 0.554150 1.407875 0.984867 0.002446 0.685867 0.585294 1.017588 0.898880 -0.095936 1.600583 1.822556 0.736517 0.651074 1.711524 0.537040 -0.108495 1.338320 1.374263 0.214061 0.901958 0.823979 1.265821 0.686393 0.897865 0.614728 0.882638 1.876167 0.155072)
     )

;;; 84 odd --------------------------------------------------------------------------------
#(84 12.003616535189 #(0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.724502770898 #(0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.626023292542 #(0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     10.328441 #(0.000000 0.081091 1.731770 1.074207 1.788393 0.894745 0.394394 1.885342 1.906361 0.164659 0.200892 1.314165 1.853854 0.973596 1.785572 1.319197 0.575084 0.643184 0.556507 0.818796 0.688866 1.041694 1.793147 -0.355071 0.768907 1.617687 1.467732 0.635237 0.404996 0.811578 1.799980 0.360875 1.832511 1.732277 0.655674 0.090091 1.137397 1.761379 1.035662 1.326646 1.290824 1.742143 1.489763 0.888151 0.713684 0.597690 0.102563 0.811456 0.770511 0.820553 0.149751 0.873454 0.099281 0.755322 0.276282 0.225695 0.953009 0.457551 1.024697 1.265384 0.719267 0.892649 0.297084 0.622018 1.000576 -0.068785 -0.003551 0.220369 0.745445 0.295068 0.968876 0.616700 1.525887 1.461349 0.322408 1.170496 0.981645 0.230808 1.700417 1.496372 0.848401 0.944796 1.534602 0.169962)
     )

;;; 85 odd --------------------------------------------------------------------------------
#(85 12.48290348053 #(0 1 1 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     12.309050256429 #(0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     11.829360154975 #(0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     10.106415 #(0.000000 0.863565 1.813422 0.926864 0.641920 0.464584 1.444279 1.670388 0.049460 0.839580 0.242224 1.540152 1.787145 1.566084 0.358543 1.249084 -0.048461 1.466967 1.803319 1.105092 -0.296150 1.558222 0.958216 1.328013 1.722732 -0.281656 0.809949 0.544571 0.862192 1.817168 1.569187 0.899226 0.945163 1.409589 1.135548 0.429883 1.667033 1.119401 1.623002 0.668139 0.010797 1.569949 1.467092 0.754074 1.195479 1.606662 0.779690 1.530649 0.370850 0.230159 0.999558 0.215810 0.804853 1.291028 -0.131180 0.033214 1.411985 1.563539 0.131645 1.563188 0.613560 1.469511 -0.025892 0.868366 0.438359 0.394141 0.826240 0.351204 -0.085853 -0.105900 0.391480 0.859738 1.336489 0.887975 0.349010 0.467662 0.215242 -1.875154 0.882788 1.235510 1.114899 0.594519 1.713397 1.384624 0.064229)
     )

;;; 86 odd --------------------------------------------------------------------------------
#(86 12.300269991896 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.274354058598 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.138233978686 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     10.365895 #(0.000000 0.674177 0.513020 1.628220 0.138111 0.642703 0.660506 1.294238 0.588329 0.386791 0.278473 0.242815 0.376081 0.314318 0.662469 -0.061241 1.555143 -0.463957 0.347166 0.234064 1.313918 1.608939 1.543194 0.206535 0.480020 1.565043 0.653923 0.875858 0.621746 1.981938 1.076745 1.092748 1.363893 0.266401 1.598038 0.711629 0.301437 0.532620 0.429015 0.421144 1.865894 1.024388 1.709916 1.851523 0.087012 1.128669 0.379186 0.955515 1.496400 0.616290 1.131864 -0.022917 0.999012 0.724535 0.060432 1.567987 1.711550 0.850315 1.355001 1.196274 1.951862 0.836877 1.320106 1.729373 1.619662 0.566085 -0.057612 0.379618 0.881540 0.121133 0.135746 0.775716 0.183558 0.456555 0.229479 1.474222 0.802827 1.170757 1.097871 0.532518 1.772327 0.934702 -0.052746 1.820739 1.048760 0.618666)
     )

;;; 87 odd --------------------------------------------------------------------------------
#(87 12.733045578003 #(0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 1)
     12.481803894043 #(0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1)
     11.937030388359 #(0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

     10.439028 #(0.000000 1.293615 0.891704 1.310178 0.871892 1.631519 0.507524 0.964303 0.961820 0.711555 0.037453 1.967779 1.529327 0.387875 0.670026 1.904543 0.413125 0.578546 0.668035 1.233649 1.799148 0.114053 1.171211 0.678512 0.931544 0.886139 1.134985 1.133850 0.582366 0.582940 0.804177 1.516606 1.773452 0.852295 0.771255 0.593571 0.354837 0.923077 1.483111 1.333483 1.304276 1.312691 0.426333 0.336748 0.396992 0.256279 0.125269 0.243969 1.152832 -0.033606 0.743325 1.315396 -0.218859 1.229602 0.321005 -0.151540 0.792293 0.827770 -0.045338 1.389821 0.049496 1.637654 0.274655 1.545970 1.076448 1.381528 0.486593 -0.337101 0.320744 -0.436795 1.281696 0.465798 0.367231 1.264912 0.484598 1.097006 -0.005951 0.479046 0.749733 0.340439 0.002468 0.652540 1.320867 0.869974 0.560586 -0.166505 0.992855)
     )

;;; 88 odd --------------------------------------------------------------------------------
#(88 12.652858832418 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.592202186584 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.128922775356 #(0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     10.620653 #(0.000000 0.559181 1.400712 1.609705 1.093303 1.390279 1.607810 0.754626 1.098590 1.276335 0.776397 0.280044 0.538441 0.353786 1.589989 0.590879 0.988904 -0.257189 0.096443 1.073351 0.164649 0.357727 0.885083 1.432438 0.934475 0.517312 0.766468 1.363282 0.468979 1.703263 1.630253 0.828765 0.504610 0.211826 1.658879 1.117808 -1.908559 0.616491 0.575018 1.617448 0.824262 0.830032 1.826003 1.834373 0.089024 0.169986 1.262683 1.381558 1.539287 1.974993 -0.021204 1.244864 -0.030358 1.818828 1.094487 0.830164 1.767796 1.268194 1.954430 1.349857 0.232781 0.233594 0.446270 1.394448 1.778269 1.380254 0.667208 0.675457 1.522788 0.476076 1.386293 0.139586 1.090971 1.044130 1.229890 1.779438 1.782202 1.621867 1.558108 -0.103644 -0.122525 0.494496 -0.056995 0.986200 0.023687 -0.046173 1.638640 1.338184)
     )

;;; 89 odd --------------------------------------------------------------------------------
#(89 13.0 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.521632157997 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.4725522995 #(0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0)
     12.362 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     10.564040 #(0.000000 0.222671 0.720613 -0.034480 0.227017 1.071976 0.485700 1.323661 0.202655 0.730327 0.347008 0.027552 0.503120 1.683398 0.787677 0.074207 0.054899 1.346473 1.430831 1.163184 1.190780 1.138336 0.020209 1.429712 1.467695 1.280923 1.219256 0.641409 1.257009 1.405872 0.371889 1.604636 0.164997 0.600689 0.437261 1.651974 0.816125 -0.138714 0.159856 1.034493 0.760757 1.755811 1.164651 1.804257 0.741946 0.916337 1.564083 0.334413 0.132176 1.291498 1.123100 1.116512 1.550394 0.672812 0.266520 1.055925 1.172674 1.105082 1.600737 0.929586 1.241857 0.222957 0.785082 0.101553 1.214804 1.481638 -0.375678 0.976110 0.461230 1.054758 -0.212694 0.777014 0.772746 -0.224492 0.080641 1.095388 1.027431 1.904950 1.609911 0.923230 0.956550 0.759552 1.159764 1.641245 1.049825 -0.152379 0.147566 0.190222 0.508490)
     )

;;; 90 odd --------------------------------------------------------------------------------
#(90 13.064256668091 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 1)
     12.44910044225 #(0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1)
     12.309 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     10.565897 #(0.000000 0.323336 0.160997 0.737976 0.991783 1.746178 0.204615 0.973350 1.325582 -0.000496 0.936849 1.569311 0.713776 0.000170 0.589250 0.440874 1.199211 0.125809 1.024730 0.829524 1.151850 0.525749 -0.112451 1.698366 0.721305 0.391788 1.502375 0.495336 0.008265 0.486362 0.473226 1.304754 1.119101 1.108647 1.085071 0.792759 -0.257844 0.639466 1.377610 0.513265 0.648699 0.618170 0.614280 1.257451 1.539835 1.673272 1.316922 1.001913 1.863150 1.359210 1.105139 1.100157 1.272833 1.192402 1.701496 0.517431 0.673234 0.369522 0.799548 0.585801 0.046079 1.066906 1.202041 0.142710 0.692510 0.460924 0.996741 1.853951 0.885033 0.227117 0.084145 0.013504 1.212499 1.591553 1.755651 0.346105 0.298673 1.838366 0.549442 0.290810 0.562135 0.000038 1.369412 1.095152 0.312535 1.162805 1.204780 0.497142 0.558399 1.960120)
     )

;;; 91 odd --------------------------------------------------------------------------------
#(91 13.107619285583 #(0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.706615204918 #(0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.351367950439 #(0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     10.580820 #(0.000000 -0.066594 0.753106 0.892230 1.672729 0.104584 0.874579 0.210329 0.287912 0.184300 1.069784 0.022315 -0.097980 1.166013 1.136168 0.223258 1.343119 1.568772 0.076270 1.687896 0.877138 0.257618 -0.071795 0.219340 1.101818 0.458001 1.333827 1.506289 1.352524 1.340131 0.231231 0.297806 1.473018 1.891024 0.776740 0.628977 1.105932 1.493035 1.077683 0.432311 0.900280 1.174027 -0.042938 1.202385 0.775424 1.366973 1.667197 0.641918 0.041936 0.757387 1.309760 0.363591 0.436450 0.199575 0.354296 0.653682 0.898497 1.936370 1.059953 1.136607 0.339573 0.840568 0.291329 1.078675 0.897876 1.460148 0.799434 0.987401 0.608927 1.040581 0.162655 1.471239 0.679281 0.175232 0.680155 0.813337 1.264396 1.801863 1.296172 0.612758 -0.175218 1.146096 1.683573 1.198581 1.503967 0.971127 1.484566 0.563556 0.586642 0.292128 0.156623)
     )

;;; 92 odd --------------------------------------------------------------------------------
#(92 12.42142723142 #(0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1)
     12.280749613899 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     10.756788 #(0.000000 1.369624 1.194830 0.936388 0.730850 1.719298 0.115781 1.462115 0.905402 0.690913 0.692908 0.521187 -0.124344 0.868603 1.301740 0.800554 0.430489 1.863631 0.719072 1.453268 1.815453 1.740997 0.189565 -0.207008 0.716236 0.878748 0.930789 0.457524 0.969004 1.428430 0.617593 1.426864 1.149099 0.252519 0.411738 1.516481 0.910568 0.014985 1.454858 1.046423 0.299082 1.202909 0.125253 1.256958 0.675773 0.719849 1.521494 1.680690 0.966184 0.641960 0.175610 1.581800 0.873941 0.587347 1.353829 1.343228 -0.073549 0.553785 1.317742 -0.074566 0.338371 1.010093 0.778368 0.981084 1.396990 0.993938 1.183193 0.686244 0.710707 0.951535 1.476970 0.986287 1.561601 0.752894 0.874991 -0.006380 0.852235 1.725409 1.689722 1.621415 0.102046 0.792477 0.874880 1.373766 0.605784 0.209690 0.091484 0.394417 -0.009282 1.936427 1.821816 0.821170)
     )

;;; 93 odd --------------------------------------------------------------------------------
#(93 13.111316272074 #(0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1)
     13.078753471375 #(0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0)
     12.587555885315 #(0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1)
     12.403578299298 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     10.790036 #(0.000000 1.428716 1.534161 0.695509 0.042606 -0.034105 1.000023 1.003681 0.781846 1.025568 0.433459 1.083836 0.800592 1.662645 1.563993 1.239176 0.555756 1.387054 1.630283 0.818717 1.705123 0.006075 -0.074162 1.632432 0.760238 1.056975 0.377989 0.515155 0.063396 1.539671 1.644172 -0.292127 -0.128413 0.214058 0.188640 0.781653 -0.070210 0.738140 1.851744 0.039564 -0.105263 1.243425 0.506869 1.782242 1.306734 0.295709 0.151933 0.774659 1.767039 -0.043429 1.770942 0.995164 1.972024 0.467155 0.971801 1.559315 0.349733 1.267330 1.730486 0.656269 0.719055 1.178003 1.503849 1.638208 0.939314 1.474745 0.841719 1.714976 0.770617 1.164675 0.430358 0.097535 1.301246 0.392113 0.155952 0.835459 -0.027759 1.654074 1.892687 0.354465 1.127666 0.916536 1.569304 0.892919 1.292494 1.328663 1.179349 1.837000 0.761736 0.275710 1.394123 1.427320 1.098857)
     )

;;; 94 odd --------------------------------------------------------------------------------
#(94 12.792093608509 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)
     12.789479876738 #(0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     10.927037 #(0.000000 1.626681 0.829955 1.010240 0.664233 0.913758 1.199948 0.669622 0.911576 0.259289 0.848829 0.822136 1.437096 1.738789 0.413383 -0.035194 1.563514 0.979262 1.063426 0.126656 0.733692 -1.898723 0.344570 1.516033 0.158815 0.175468 0.573142 1.060297 0.042863 0.512772 1.486408 0.295766 -0.101212 0.211587 1.188376 0.105685 0.365886 0.437671 1.109089 1.231399 0.744266 0.716316 0.605478 0.802168 0.994077 0.708959 -1.950755 1.997536 1.055776 0.315707 0.643181 0.342210 -0.003827 0.557681 1.151801 1.658103 0.266280 0.754642 0.704155 0.529302 1.629191 1.224676 0.606829 1.410588 0.261171 1.635301 0.540253 0.865018 1.139969 1.690426 0.273032 1.557577 0.053894 1.446345 0.443237 0.226192 0.805316 1.773939 1.143493 -1.891950 1.600920 1.484406 1.708430 1.245949 1.651862 1.868318 0.776505 0.619191 0.436541 1.276281 0.248634 1.664335 1.266079 0.783779)
     )

;;; 95 odd --------------------------------------------------------------------------------
#(95 13.132 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.981590594561 #(0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.858592033386 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.572603216801 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     10.972495 #(0.000000 1.449667 0.060926 -0.201380 1.548663 1.519600 0.938214 1.062175 1.174870 0.333416 0.837318 1.560838 1.862954 1.267192 0.849868 0.883271 0.202595 0.388073 0.431413 1.076586 0.244615 1.747160 1.058538 0.596873 0.837670 0.328242 0.269596 0.787857 1.674013 1.117617 0.562113 0.268180 0.293670 1.739946 1.123177 1.219836 0.147953 0.825012 1.173554 1.149466 0.853192 1.867305 1.353842 0.897875 0.650134 0.414983 1.484702 1.546801 1.245132 1.289257 1.794113 0.590642 0.981862 1.025381 0.917183 1.351881 1.793049 0.461111 -0.072467 1.657938 1.136680 -0.167321 1.165874 -0.028616 1.100971 -0.064408 1.098503 1.375066 0.146380 0.173094 1.088926 1.186393 0.299888 0.954291 0.700657 0.702286 0.835918 0.879818 1.362486 1.554878 -0.125935 1.565773 1.929243 1.044577 -0.266372 -0.057867 1.088814 0.481040 1.320370 0.941781 0.270422 0.071074 0.886342 0.900115 0.257131)
     )

;;; 96 odd --------------------------------------------------------------------------------
#(96 13.232 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     13.00986051659 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     12.956554412842 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)
     12.803173065186 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     11.140087 #(0.000000 0.720511 1.849696 0.548540 0.143796 0.078198 0.835480 0.384414 0.185614 1.851906 0.430241 1.852469 0.534407 0.994680 1.375499 -0.078235 0.070487 0.591624 0.880047 -0.014769 1.267384 1.842603 0.562108 0.144174 0.265852 1.189020 1.450300 0.429659 0.673228 0.234813 0.259067 1.466644 1.843161 1.581585 1.342633 0.502261 1.077399 0.032607 0.911237 -0.004185 1.797194 1.776370 0.399052 0.161414 0.768447 -0.023151 0.828511 0.672222 1.599699 0.536698 0.513080 0.826097 1.415517 0.971226 1.810764 0.729398 1.857311 1.461757 0.779080 0.601347 0.969872 0.982185 0.732540 0.077400 -0.020651 -0.113889 1.208673 0.329500 0.403819 0.634653 1.445351 0.809636 1.210871 -0.022473 0.439332 1.271404 1.331084 1.824241 0.721355 0.106316 1.474991 1.863621 1.615775 1.583783 1.390145 1.610829 0.153352 1.409737 0.804622 0.680587 1.449995 0.668246 0.253857 1.791837 -0.027206 0.531015)
     )

;;; 97 odd --------------------------------------------------------------------------------
#(97 13.340280990563 #(0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.954301727663 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.837450993031 #(0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     11.129065 #(0.000000 0.391638 1.397251 0.059474 -0.003984 1.009518 0.295558 1.020808 1.772427 0.349600 1.746596 -0.019077 0.892020 1.179208 1.850047 0.949823 0.747024 -0.150098 -0.020144 0.663226 0.391076 1.161653 0.795084 0.920878 0.516866 0.478439 0.535293 0.648296 1.637184 0.023111 0.044246 1.694369 1.723603 0.093219 1.289971 1.254319 0.414532 0.441098 0.614154 0.470788 1.386868 -0.002737 -0.167602 1.609205 0.118880 1.466136 0.247694 1.675665 0.093967 -0.171758 1.477110 0.367213 1.592963 1.181484 0.602228 1.894065 1.727926 1.291872 0.166832 0.046692 0.330546 0.634031 0.879474 0.068371 0.139552 1.528548 0.514363 0.087226 0.739782 0.513773 0.476194 0.742685 1.650986 1.219445 0.892868 0.738374 -0.036494 0.022052 1.348505 1.591990 0.597794 0.438896 1.336989 1.622952 1.737401 0.697317 0.120705 0.605116 1.789182 0.559765 0.520980 1.254439 1.706187 0.989308 1.054695 0.909155 1.896635)
     )

;;; 98 odd --------------------------------------------------------------------------------
#(98 13.53905582428 #(0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.128762135265 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.062 #(0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0)
     12.972 #(0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     11.295189 #(0.000000 1.165284 0.484687 1.931485 0.003427 1.284492 1.448411 1.133707 0.514768 -0.091135 -0.001747 1.657215 -0.096680 1.501032 0.900187 1.324388 0.309946 0.886660 1.557092 -0.016077 1.152818 1.820075 1.039020 0.982080 0.189762 1.793633 1.639967 1.547479 1.315758 0.671196 0.175779 0.968379 1.298688 1.232366 1.326546 0.049781 0.960791 -0.265540 1.023018 0.895537 0.405631 1.274216 1.334580 0.115640 1.253876 0.499290 0.614136 0.600690 0.685145 0.706661 0.738320 1.534235 1.323905 0.264269 -0.106941 0.036532 -0.236106 1.645639 0.394870 0.054909 0.246912 0.719744 1.361150 0.686115 1.062002 0.262331 1.674189 0.464010 0.379609 0.890224 1.170277 1.590934 0.672343 0.688687 1.044690 1.116890 0.695761 0.023985 -0.063602 1.068860 1.575133 0.490497 1.572282 1.150457 0.622263 0.688098 1.221464 -0.003167 0.671853 0.301664 1.291303 1.748770 1.340035 1.541488 1.620235 0.218023 1.058080 1.588213)
     )

;;; 99 odd --------------------------------------------------------------------------------
#(99 13.792359352112 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1)
     13.577017376954 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1)
     13.046126365662 #(0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     13.000000000002 #(0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     11.345669 #(0.000000 0.454564 1.994924 1.510381 1.241869 1.057206 1.329731 0.028501 0.985527 0.742650 1.330343 1.917590 1.429702 1.469962 1.725955 0.473656 0.220453 1.309614 0.961727 0.324110 0.981659 -0.520371 1.185169 1.403275 1.335942 1.914374 1.324474 1.382530 0.767723 1.208649 1.751792 0.106270 0.755250 -0.022000 0.953715 1.427546 0.085459 1.448027 0.979824 0.354179 1.645092 0.455304 0.736395 1.509603 1.538206 0.682457 0.969990 0.386579 0.225475 0.254880 0.773361 -0.296914 0.670619 1.061337 -0.016894 1.296346 0.294942 -0.325290 0.493031 0.102019 1.138266 0.889818 1.155955 0.436097 0.144471 0.827628 0.522461 0.218062 0.765965 0.410673 -0.246044 -0.032147 1.763806 1.252853 0.447580 -0.035967 1.925022 1.320824 0.533630 1.655725 0.210843 0.685289 1.422701 -0.239847 1.277699 1.721905 0.232911 0.730321 0.890214 0.855077 0.578903 0.837600 0.745413 0.456235 1.237180 0.265549 1.124309 1.410122 1.141199)
     )

;;; 100 odd --------------------------------------------------------------------------------
#(100 13.914 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0)
      13.24493912033 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0)
      13.117680368039 #(0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      11.196081 #(0.000000 0.796414 0.781705 0.712482 0.278708 1.578975 0.559318 1.112999 1.673196 0.595213 1.315391 0.674721 -0.265795 0.264189 0.828898 0.888829 1.898506 -0.024589 1.079602 0.220846 0.626026 1.479974 1.992741 0.204960 0.558175 1.472544 0.577462 0.420843 1.702717 1.288585 1.223599 1.076535 0.367912 1.960872 1.538625 0.128329 1.729600 1.815771 0.129084 1.714658 1.025730 1.427542 0.829608 1.497572 0.388988 0.570635 0.326955 0.076283 0.196276 -0.238239 0.681242 0.201610 0.642219 1.352314 0.432217 1.074321 0.223713 -0.191773 1.776005 0.696503 0.556671 0.383270 0.616917 -0.136292 0.824118 0.577900 1.847649 1.134821 0.727411 -0.277347 1.046244 1.523155 0.561998 0.281090 1.127487 1.565297 1.602089 0.132884 0.141252 0.218607 0.248314 0.218176 1.099054 1.898173 -0.224042 1.062239 1.585309 0.454473 -0.024732 1.292403 0.199242 1.348560 1.260786 1.141367 0.130481 -0.183089 0.663188 0.870374 0.960196 1.100008)
      )

;;; 101 odd --------------------------------------------------------------------------------
#(101 13.462674500314 #(0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1)
      13.279868125916 #(0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      11.409126 #(0.000000 0.154217 1.741105 0.023007 1.097647 0.429254 1.206973 0.321434 1.578737 1.131854 0.446540 0.346019 0.047493 0.952195 0.831953 0.265777 1.456860 1.238682 0.548067 0.919990 0.448211 1.065687 1.157078 0.398867 1.772028 1.636755 1.856964 1.583019 0.124215 0.351462 0.181831 1.807070 1.178102 0.684350 0.144316 -0.027521 0.933318 1.800350 1.648162 -0.193380 1.647042 0.022062 0.912945 0.018117 1.738383 -0.026097 -0.081483 0.696493 1.374451 0.083542 0.716238 1.659703 1.382962 1.538156 0.396181 0.694637 0.019262 0.283730 0.993783 1.524302 1.376991 1.020377 1.090943 1.274927 1.419138 0.212063 0.224329 -0.183473 -0.167044 0.452404 1.525772 1.559983 1.206307 -0.253551 1.662975 0.393549 -0.002714 1.312608 1.500051 1.145934 0.536246 0.723495 0.370144 1.435046 -0.127316 0.005983 0.700938 0.524640 1.461604 0.632127 0.352088 1.165366 0.178865 0.686390 1.885132 1.118194 0.100097 1.816128 -0.054786 0.368761 1.412075)
      )

;;; 102 odd --------------------------------------------------------------------------------
#(102 13.701085090637 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)
      13.159336831147 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      11.368618 #(0.000000 1.872282 0.313052 0.445090 1.590355 1.598083 0.853204 0.504213 0.322446 1.108005 0.564441 1.514591 0.396272 0.654269 1.823374 1.104274 0.907198 1.147369 1.817252 0.223623 -0.064608 1.107518 0.578174 0.773539 1.129365 0.535265 1.652763 1.107007 0.006274 0.336207 1.213800 1.509323 1.388850 1.196842 0.503310 0.172576 0.140080 1.321160 1.692902 0.226879 0.323368 0.932257 0.317342 0.716477 0.769016 0.763162 1.516137 0.776386 1.324429 1.120906 1.857534 1.141392 0.334266 0.748765 -0.001463 1.011983 1.459458 0.145681 1.110146 1.672343 1.773970 1.556955 0.884809 1.168102 0.456636 -0.090263 0.330975 0.592877 1.019183 0.261688 0.923998 1.002380 0.454059 0.633890 -0.135837 0.191436 0.868758 0.690538 0.645214 1.790776 0.433841 0.212842 0.459203 0.284696 0.738821 0.496551 0.193441 1.727503 -0.038614 1.275224 1.486007 -0.071217 0.910826 0.887661 0.198865 1.461310 0.849254 0.354336 1.197851 1.753257 1.635106 0.416256)
      )

;;; 103 odd --------------------------------------------------------------------------------
#(103 13.551587266363 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)
      13.142812158651 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      11.534387 #(0.000000 1.496874 -0.008287 1.577425 1.549680 1.183866 0.715895 1.192786 0.313300 1.667262 1.579135 1.835228 1.590627 0.450371 0.272790 -0.278018 1.477856 0.791529 1.380383 0.313584 -0.256592 0.965257 0.336286 0.842998 1.753795 0.883388 0.890084 0.151316 0.294798 0.382750 -0.028933 0.842488 1.346453 1.128710 0.606551 0.064543 1.284155 0.281268 0.783937 1.611801 0.239594 0.897929 1.158717 0.040713 1.125432 0.076025 0.880671 0.556367 0.993915 0.684358 1.786181 0.251902 0.612358 0.522608 1.119899 1.795162 0.914341 1.177505 1.370034 0.155946 0.987376 0.311232 1.663281 0.974303 0.500817 0.645917 0.367513 0.777534 1.804572 1.632896 -0.072231 1.295056 1.596829 -0.019324 -0.337815 1.748462 0.430896 0.647929 1.701444 1.145851 1.726737 0.977037 1.210626 0.063198 1.606235 0.890127 0.940340 0.104958 1.032041 0.757566 0.548658 1.597558 0.135913 0.872801 0.792606 1.311790 1.137983 0.397452 1.154780 1.051497 0.003283 1.819714 1.660335)
      )

;;; 104 odd --------------------------------------------------------------------------------
#(104 13.622 #(0 0 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.301904678345 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.214084551284 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.176067352295 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      11.656865 #(0.000000 1.026916 0.005090 1.225997 1.410747 1.313050 1.849815 1.848857 -0.130987 -0.016727 0.341401 1.638429 1.576358 0.500055 0.889257 0.387027 0.755944 1.696795 1.880174 1.391718 0.148907 0.913753 0.871967 0.876819 -0.166476 0.618070 1.711671 0.928677 0.547165 1.238552 0.957342 1.572223 0.879102 0.778609 0.902093 1.353997 0.868778 0.948939 0.750839 1.601639 -0.013253 0.977449 0.927680 0.398794 0.452431 0.804719 0.997393 -0.059500 0.496935 0.920885 1.576236 0.283747 1.018146 1.569860 0.971737 0.344267 1.768216 0.322107 -0.085082 0.950865 1.927922 0.757204 0.774987 1.737738 1.561809 0.962613 1.128360 1.507335 1.165970 1.344196 1.116169 0.799262 1.890981 0.416395 0.035318 1.200754 -0.002817 0.753018 -0.020726 -0.062045 1.159760 0.102193 0.063754 1.089206 1.045084 0.260610 1.579030 0.848595 0.730467 1.502246 1.288921 0.073189 1.289083 1.760949 1.489547 1.626197 0.785804 0.713584 0.668877 1.792779 1.744729 0.263347 0.489061 -0.148773)
      )

;;; 105 odd --------------------------------------------------------------------------------
#(105 14.179738044739 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0)
      13.491228801467 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      11.659995 #(0.000000 1.715636 1.479996 1.084090 0.591018 0.890650 0.808660 0.648001 1.767371 1.495915 0.152797 1.400088 1.267278 0.732786 0.521765 0.872061 1.741117 1.896093 0.694217 1.872429 1.774811 1.401343 0.588691 1.220995 -0.073399 1.886137 1.096821 1.486615 0.063186 0.843386 1.105387 0.544756 0.958403 -0.250151 1.445002 1.128567 0.696027 0.323571 1.159613 1.536733 1.032811 1.028761 1.378442 1.261417 1.360695 -0.092879 0.987788 -0.007078 -0.272763 0.312018 1.393921 1.334383 0.639872 -0.169684 0.935913 1.672624 0.094139 1.041148 0.239420 1.022618 1.481554 1.115101 0.223650 0.461935 1.089359 1.581313 0.015010 1.652752 -0.018161 1.777688 1.044294 0.341636 0.767003 0.700244 1.262799 0.148696 1.151844 0.758122 0.465621 1.278727 0.997371 0.615766 0.096183 0.436807 1.658864 0.275455 1.739735 0.312437 0.373347 1.110980 1.804411 1.655998 1.347323 1.951413 0.942743 -0.151043 1.480701 0.014713 0.164018 0.271478 0.138357 0.302161 0.607648 -0.371500 1.421635)
      )

;;; 106 odd --------------------------------------------------------------------------------
#(106 13.492804348903 #(0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1)
      13.091135978699 #(0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      11.830185 #(0.000000 0.745887 1.129623 0.209788 1.870856 1.032498 1.565202 1.001311 0.475730 0.879287 1.968776 0.885754 0.510767 0.785493 1.236756 0.093613 0.120239 0.958868 1.822261 0.264632 0.577469 1.392312 -0.257210 1.601662 0.575756 0.329964 1.139762 1.011977 1.136093 0.403863 -0.174592 1.725392 1.817293 0.854357 0.699573 0.667409 1.522109 1.332229 0.610776 1.460291 0.331906 0.182656 0.135695 0.903549 0.311599 0.901971 0.199924 0.451810 0.663349 0.781897 0.853472 0.381375 0.605671 0.829713 0.210857 1.930678 1.640506 1.840063 1.116401 -0.223753 1.643567 0.148406 1.006138 1.308603 0.429942 1.312601 1.337189 1.573972 1.016519 1.439552 1.506910 -0.040040 0.518690 0.165698 0.176610 1.791124 1.161163 0.158343 1.525952 1.106715 1.289839 0.268988 1.838068 1.051339 0.757913 1.447426 1.174844 -0.077495 0.272277 1.561728 -0.068883 1.060914 1.378123 0.142891 1.775286 0.440214 0.049293 1.380038 1.471877 0.191036 0.722545 0.291459 0.373956 1.454671 0.106192 1.475178)
      )

;;; 107 odd --------------------------------------------------------------------------------
#(107 13.864 #(0 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1)
      13.762476921082 #(0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1)
      13.722554538648 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1)
      13.537808159641 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      11.928522 #(0.000000 1.616441 1.946545 1.987105 0.541189 1.462823 0.229655 1.831231 0.310210 1.745245 1.338007 0.113735 1.632398 1.513641 0.308193 1.659585 1.850675 1.248080 0.137843 1.703540 0.590428 1.697899 1.418344 0.523384 0.853048 0.230880 1.055717 0.695494 0.065837 0.067417 0.284479 1.336112 0.742306 1.775083 0.056276 1.160204 1.022331 0.970744 0.002633 0.568407 -0.135111 0.736171 1.786567 1.816435 1.345288 1.806516 1.389855 1.758825 1.617508 0.292442 0.123256 0.746738 0.433714 0.128628 0.745867 0.307137 1.374554 -0.054053 0.283478 0.456384 1.915649 0.804017 1.047872 1.548682 1.179996 0.602732 1.765581 0.157348 0.662146 1.235337 0.529644 0.072680 0.437819 0.452076 1.774461 0.437668 1.182882 0.429765 1.815059 -0.108144 1.439852 0.720416 0.205510 0.348744 1.740323 0.902413 1.557911 1.093431 1.390683 0.154522 0.082946 0.559386 0.623759 1.817346 1.908949 0.071774 1.256498 1.784653 0.827005 1.214030 1.788126 0.341705 1.607647 1.876116 1.290182 1.316097 1.500987)
      )

;;; 108 odd --------------------------------------------------------------------------------
#(108 13.775 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0)
      13.751863479614 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.584542754139 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.472808406168 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      11.968724 #(0.000000 1.546783 0.483237 1.300183 0.547497 1.009374 -0.437091 1.160987 -1.563740 0.870453 -1.814660 1.633239 1.051937 1.781729 0.730197 -0.160956 0.639416 0.691501 1.327140 -0.077289 1.789665 0.309006 0.004045 0.787513 -0.258520 0.687337 0.913587 1.787990 0.128066 1.502940 -0.088614 -1.767968 0.648962 0.074256 0.207044 1.662522 1.497766 1.313736 1.749451 0.617960 0.369556 0.150871 0.627346 1.798172 -0.161894 1.605524 0.971127 0.960281 0.659098 0.670018 0.749178 1.290219 0.542772 0.443799 -0.106977 0.380301 -0.191739 1.257604 1.288986 1.971287 0.275803 -0.504536 1.045357 0.761801 1.032342 0.790060 0.615400 1.402500 0.781953 0.459307 0.610103 1.005279 1.902394 0.365060 0.213899 0.593504 1.167752 0.525391 0.337412 1.173037 0.823492 0.085083 1.253618 1.000085 1.475897 0.362620 0.767462 1.481636 0.778070 1.843256 1.555677 1.212867 0.652463 1.476622 1.498438 0.274377 0.131755 0.142200 -1.580852 0.945246 0.222826 0.549795 0.459810 1.107287 0.827960 0.559660 1.696882 0.128853)
      )

;;; 109 odd --------------------------------------------------------------------------------
#(109 13.88663482666 #(0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
      13.798 #(0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      12.013782 #(0.000000 0.061086 1.468665 0.451207 0.535321 1.555298 1.055792 0.976020 0.342194 1.761611 1.381013 1.456387 1.625596 -0.122539 0.921570 1.271250 0.770247 0.369081 0.657881 0.739537 0.178240 1.523128 1.154124 0.372167 0.885319 1.257607 0.594901 0.082628 1.439964 0.932878 1.163287 0.541700 0.415256 1.533168 1.105661 1.304665 1.165653 0.428600 1.089722 -1.751996 1.090956 1.884763 0.252509 1.117966 1.317922 0.537754 1.385348 0.852433 0.570495 0.421467 1.297749 0.675341 1.838893 0.451388 0.889460 1.552987 1.524925 1.163043 1.645606 0.792785 1.475669 0.958086 0.011099 1.161431 0.832939 0.096035 0.761329 1.346894 0.342735 0.219377 0.248537 1.993212 1.307737 -0.043199 1.501713 0.408338 1.630114 0.858157 0.907167 1.790409 1.946259 1.360302 -0.098380 0.684721 0.783034 1.153065 1.450988 0.925559 1.121801 1.066730 1.203169 1.894353 1.492960 0.718943 1.111065 -0.091677 0.697753 1.672781 1.151837 0.028545 0.487493 0.936191 0.431878 0.932908 0.721365 1.483363 -0.161630 1.872909 0.519773)
      )

;;; 110 odd --------------------------------------------------------------------------------
#(110 13.816418806615 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.75 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.576010454591 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      12.076746 #(0.000000 1.587476 1.022738 0.911081 0.423707 0.299340 0.467960 1.236252 1.743630 1.212092 -0.131920 -0.098435 1.562185 1.127371 1.297359 0.156355 0.108751 0.836424 1.426857 1.388096 1.456408 1.383101 1.247416 1.256847 1.238566 -0.154266 -0.050287 -0.115862 0.004633 0.631510 1.887624 1.096193 -0.214760 0.587331 1.088696 1.381472 1.402513 1.292808 0.049139 0.838940 1.345661 1.503758 0.817517 0.510362 0.757280 1.848711 -0.053383 0.633784 1.089259 0.163069 0.597666 0.054863 1.507281 0.453484 0.504801 1.445727 1.836368 0.507504 1.685683 1.022851 1.418964 0.789853 0.782763 0.200917 1.236047 -0.006814 1.162998 1.365930 1.483811 1.736291 0.765781 0.274801 1.621435 0.780418 1.425414 0.475164 1.042429 -0.280681 0.492648 0.302886 -0.049710 0.328831 0.325846 1.126507 1.353854 0.997074 0.289140 1.784935 0.198948 1.029971 0.052379 1.030963 0.072608 1.697055 0.219159 0.106106 -0.406315 0.935390 1.475623 -0.060415 1.806214 0.834506 0.408642 1.149495 0.751853 0.530462 1.174683 0.134816 0.238119 0.424285)
      )

;;; 111 odd --------------------------------------------------------------------------------
#(111 14.376 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0)
      14.114 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)
      13.709900383304 #(0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      12.201863 #(0.000000 0.201647 0.364518 -0.054422 0.672801 0.137142 1.115879 1.129482 -0.169088 0.159700 1.628319 1.905246 0.099363 0.642675 0.621726 1.805687 1.291390 1.219104 1.425287 1.621038 0.075052 0.218537 1.651905 1.031181 -0.253289 1.509448 0.573724 1.695100 1.648615 1.878656 1.073384 0.781235 0.464833 0.180606 0.222637 1.472174 0.913421 0.945030 0.844825 0.756449 0.231021 0.958162 -0.160739 0.218425 0.377861 -0.168016 0.927557 1.123748 0.111269 1.238653 1.074529 0.155341 0.910420 1.586325 1.430617 0.617680 1.580198 0.083869 1.671418 0.577882 -0.005746 0.153250 0.047244 1.133703 0.567804 0.566131 0.273622 0.276972 1.799350 1.427609 1.922924 0.119208 1.456180 1.278193 -0.192469 0.337258 0.025326 0.574343 1.384216 1.725635 1.013769 0.095541 0.064353 1.550596 1.765741 0.460655 1.371587 0.700373 1.807569 0.601038 1.255479 0.241681 0.325687 0.952737 1.197361 1.968565 -0.010778 1.867192 0.311193 1.619464 1.534571 1.187737 0.073514 -0.225625 0.449392 1.289821 0.409710 1.437026 1.771264 0.884385 0.329006)
      )

;;; 112 odd --------------------------------------------------------------------------------
#(112 14.528804585299 #(0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      14.380474204396 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      13.92684841156 #(0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      12.288716 #(0.000000 0.908166 1.359494 1.841275 1.701822 0.424174 0.278468 0.769372 0.097833 1.406260 0.660416 0.409833 1.935384 1.862436 0.515698 1.634752 1.575261 1.344362 1.860721 0.094776 1.227018 0.044208 1.571436 1.037787 0.362315 1.307628 0.520838 0.498213 1.853994 0.991554 1.733617 0.738773 1.719220 0.286103 1.431075 0.339414 1.565445 0.818957 1.825643 1.319799 0.807406 1.131747 -0.177541 0.964502 0.638918 0.581709 0.395782 1.616332 0.567652 1.090790 0.754018 1.375546 1.707974 0.834442 1.005473 0.820584 1.872600 1.177423 0.697933 1.691111 0.640532 -0.008007 0.959888 1.510358 0.093407 0.739659 0.952425 1.212605 1.414766 1.370064 0.172120 -0.038453 1.352764 0.937545 0.387177 0.497477 1.041921 1.294576 1.695543 1.479173 1.797597 1.585963 0.268388 1.320324 0.948476 0.729141 0.571288 0.001088 1.659403 0.444451 1.040395 0.691940 -0.083442 0.202651 0.923229 0.663496 0.039038 0.511047 0.072330 0.467748 1.278234 1.315102 0.679574 1.070236 1.707094 0.041315 1.234606 1.481047 1.464949 1.468614 1.144848 1.675853)
      )

;;; 113 odd --------------------------------------------------------------------------------
#(113 14.292 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      14.00348588593 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      13.825498858186 #(0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      12.241704 #(0.000000 0.595073 0.701762 0.825483 0.354595 1.217541 0.260784 -0.024584 0.652566 1.756603 1.115615 1.588113 1.343200 -0.054482 0.045305 1.763259 1.942169 0.696423 1.000665 0.923031 0.632688 1.250450 1.783485 1.231324 1.638876 0.606425 1.635032 0.818061 0.913691 0.485751 0.586540 1.047698 1.799717 1.297923 1.465667 1.253055 0.495888 0.399082 1.148086 0.850192 0.538609 0.863029 0.388249 0.545422 0.368665 1.365033 0.669854 0.205657 1.258859 1.443104 1.184599 1.034509 0.615940 1.784823 0.488335 1.602546 1.862645 1.731050 0.851032 0.633455 0.992145 1.657115 0.717335 0.812453 1.915602 1.289098 0.443606 1.162634 0.057043 1.840665 1.550407 0.762600 -0.001418 0.420438 1.248383 1.718276 1.573755 0.247471 0.158544 1.377580 0.979520 0.700858 -0.061365 0.050997 1.841003 1.431928 1.618974 0.276666 1.012993 0.432919 1.057472 0.875319 0.033668 0.719362 1.180395 0.491802 0.228607 1.160261 0.852869 1.343380 1.635614 0.730798 1.373067 1.791453 1.415194 0.881181 1.281087 1.074655 1.736326 0.160865 0.755561 0.603196 1.262053)
      )

;;; 114 odd --------------------------------------------------------------------------------
#(114 14.507795639854 #(0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 1)
      14.388 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0)
      13.974405288696 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0)
      13.920305720092 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      12.388669 #(0.000000 0.358609 0.413824 0.747446 0.688480 1.506856 0.560069 -0.340240 0.947024 1.012871 0.508172 1.694502 1.080262 0.596204 0.854793 0.902354 0.060291 -0.165510 0.834789 1.695480 1.241683 0.595147 0.371558 0.144247 0.313006 0.256535 0.122917 1.097127 1.117218 0.511442 0.458892 0.097925 1.324730 0.129827 0.562367 1.013766 0.186532 1.384907 0.890518 0.157632 1.523736 0.650731 0.167048 0.962161 1.094955 1.208423 1.642492 1.917213 1.293331 1.578709 1.785577 1.268736 0.734298 0.560897 0.584557 0.466809 1.219087 0.869652 1.688899 1.928548 -0.015148 1.678039 0.495703 0.257989 1.246837 1.728332 0.522903 0.073925 1.444096 -0.037987 0.074235 0.680867 1.644537 0.035013 1.784037 1.455480 0.145848 0.754392 1.112048 0.979614 0.859109 0.006173 1.351620 0.889613 0.614880 0.227617 0.726160 1.251960 0.334472 1.338027 -0.111228 0.522146 1.427297 1.653741 1.723083 0.690356 -0.060035 0.524334 1.258910 1.024747 1.041406 0.596899 1.009506 0.471848 1.257670 0.826740 1.275093 -0.117186 1.729528 1.671262 0.932447 1.226189 -0.237934 0.416179)
      12.321518 #(0.000000 -0.057507 0.611054 0.228974 0.995609 1.470380 0.687986 0.585786 1.132001 1.639099 0.313679 0.369485 1.438605 -0.027079 0.866445 -0.280867 1.715380 1.095211 0.701793 1.589006 0.274034 1.212102 0.597822 0.371681 0.728905 0.793691 1.099989 1.354078 0.614712 0.895237 0.651200 1.690344 0.716163 1.504440 0.898571 0.841659 1.281383 0.280613 1.639840 1.166997 0.294313 1.276983 -0.048925 0.594644 1.568530 1.402705 1.654452 1.633613 0.881882 1.769217 1.877221 1.585187 0.879139 -0.329544 1.675105 0.977403 0.042356 0.012203 0.179971 1.717167 0.693649 -0.083524 0.562602 0.753264 0.799499 1.686635 0.688278 1.873020 1.298781 1.095358 1.750762 1.883482 1.735318 0.021951 1.237576 0.871963 0.528769 1.871442 1.268756 1.135392 0.759699 0.173043 0.331337 1.467568 0.142004 0.243712 1.536900 1.563055 1.450508 -0.053076 1.781785 1.001242 1.486377 1.392102 1.412935 0.290520 1.441510 0.446482 0.655870 1.214594 1.456628 1.731767 1.283163 1.515113 1.201380 0.552336 0.555384 0.958896 0.080771 1.542365 1.660658 0.633506 1.228703 1.418629)
      )

;;; 115 odd --------------------------------------------------------------------------------
#(115 14.773869138996 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1)
      14.449532208006 #(0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0)
      14.20306968689 #(0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      12.538797 #(0.000000 1.300586 -0.117211 0.033020 0.960820 0.663469 0.300619 0.857257 1.239652 0.394232 0.837009 0.492483 0.535493 1.158024 0.862197 -0.018223 1.649145 1.090481 0.113719 0.172890 1.548187 0.802097 1.483097 -0.011375 0.150505 0.289098 0.768549 1.244939 0.240776 1.515628 -0.021202 0.329811 1.640334 1.265372 1.059459 0.667218 1.125505 1.027076 1.109570 0.796382 0.083571 0.893198 1.503207 1.662552 1.806945 1.675301 0.367862 1.651787 1.135405 0.044107 -0.119267 0.110256 0.352210 0.177994 0.153678 1.867577 0.688392 0.697229 0.388143 -0.033700 -0.194726 1.749495 1.271910 0.361018 0.201894 1.383495 0.411847 0.136891 0.683647 0.041103 1.560077 1.164438 -0.066712 1.700877 -0.015909 1.301498 1.032225 0.998655 0.619711 0.057952 0.098597 1.463802 1.246845 1.381836 1.480862 0.427770 -0.275759 0.654568 1.194589 1.732011 0.717178 0.611916 1.682781 0.613950 1.045334 0.741979 1.759434 1.156693 1.764108 0.273267 1.906160 0.762186 1.963027 0.097873 0.596821 1.106618 1.143840 1.711415 0.904970 0.800004 1.136513 0.199818 0.697253 1.057170 0.338038)
      )

;;; 116 odd --------------------------------------------------------------------------------
#(116 14.661133289609 #(0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0)
      14.619069099426 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)
      13.887789451571 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      12.349982 #(0.000000 0.288583 0.535138 0.880768 1.229071 1.032005 0.741958 1.506708 0.988664 1.510035 0.570634 0.600887 0.452407 1.277540 0.653028 1.338519 1.734821 1.492629 1.238052 1.348061 0.485825 0.001527 1.680203 0.630277 0.333625 0.581166 0.749384 0.237252 1.744972 1.764540 1.733139 0.187989 0.862514 0.528253 0.734898 1.736887 -0.065491 0.619951 0.626077 0.119446 0.438557 0.245278 1.215483 0.366169 1.836234 0.967914 1.255476 1.661987 1.937937 1.269810 1.176079 0.233419 1.830674 0.981834 1.763676 0.423164 0.368218 0.598144 1.363542 0.254169 1.030372 1.802236 1.420231 1.009244 1.916283 0.654820 1.382282 1.209232 1.496643 0.007139 1.266446 1.888309 1.959907 1.205159 0.947575 0.625503 1.535791 -0.117561 1.018192 0.098235 1.173764 0.149329 1.928529 0.900726 1.292077 0.452718 1.773053 -0.121555 -0.023669 1.146036 0.069891 1.643518 0.479017 0.061079 0.465229 1.783719 1.691515 0.273950 1.789736 1.156460 1.325619 1.757362 1.362908 0.125379 0.277670 1.695830 0.840351 1.620085 1.330755 0.465762 0.646757 0.996525 0.155600 0.674032 -0.087677 0.157608)
      )

;;; 117 odd --------------------------------------------------------------------------------
#(117 14.63381513714 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)
      14.427604264985 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      12.497617 #(0.000000 0.166520 0.957411 0.308331 1.351678 1.303710 0.836827 1.538965 1.691156 0.512024 1.153466 0.685935 1.784638 -0.353842 1.227688 0.889689 1.314784 0.235196 1.056757 0.099728 0.779671 0.784996 1.708986 1.279798 1.123779 1.066116 0.365235 0.904939 1.499625 0.186355 0.655800 1.406347 1.788857 0.947000 1.428645 0.555043 0.174063 -0.066957 -0.116488 1.274585 1.922966 -0.007277 0.344091 1.247861 0.440997 1.273082 0.971109 0.891894 -0.062492 0.415203 1.184321 0.896707 0.808739 1.435355 1.863505 1.389292 0.042455 1.620299 0.723699 0.767067 1.454222 1.012288 1.475240 0.712413 1.069841 1.267805 0.955908 0.246237 -0.058970 1.648496 1.658859 1.773828 1.535381 1.355973 0.168327 0.494959 0.169698 0.991743 0.516868 0.594289 0.845027 1.845315 -0.032532 1.425598 0.256037 1.747354 0.725173 0.585490 0.364051 1.723179 1.315691 0.047923 1.389148 1.849128 1.628291 0.315640 0.718911 1.142223 1.818430 1.606227 0.460678 0.630370 0.494106 1.327938 1.934943 0.056963 0.115917 1.054843 0.088747 0.070887 0.315974 1.402763 1.827289 0.420130 1.763238 1.527373 1.244000)
      )

;;; 118 odd --------------------------------------------------------------------------------
#(118 14.922 #(0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0)
      14.72793006897 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)
      14.39733490263 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      12.524034 #(0.000000 1.271849 1.677257 1.388762 0.699801 1.195351 0.220802 0.268059 0.208614 1.648690 0.431135 1.488118 -0.405543 0.905582 1.076854 0.437501 0.412656 0.558180 0.176994 0.783364 0.922069 0.142442 1.400630 0.752426 1.684258 1.854134 -0.240920 -0.285342 0.412111 0.867288 0.574014 -0.094145 1.589960 1.667067 0.634923 0.261401 1.522602 0.835944 1.426042 0.979727 1.742038 1.790938 0.643251 1.566950 0.519633 0.170385 0.517981 0.985084 -0.170326 0.950707 0.814111 1.222019 1.904227 -0.264523 0.693821 1.379373 1.414055 -0.357299 1.486139 0.596468 0.635693 0.974031 1.404880 1.340263 1.764523 1.350096 1.704295 0.507341 1.515284 1.378014 0.629167 0.707718 0.865467 1.655578 -0.031689 0.197848 1.718434 1.038014 1.389329 0.385890 1.722159 1.637240 0.806319 1.339839 0.952318 1.022967 0.996094 1.272134 0.410349 1.346430 1.002769 0.543213 1.103475 0.305670 0.260014 -0.087781 1.067697 0.932583 0.074883 1.028646 1.124903 1.885937 0.848622 1.538989 0.684500 0.921251 1.435175 1.598231 1.047353 -0.174464 1.581058 0.403341 1.662760 -0.153424 1.885529 0.106540 1.073780 1.744887)
      )

;;; 119 odd --------------------------------------------------------------------------------
#(119 15.03294064107 #(0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.647579104049 #(0 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.464 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

      12.625590 #(0.000000 1.290380 1.974282 0.503453 0.972565 0.617951 1.477984 1.593722 1.575363 1.969454 1.713486 1.424368 0.887686 1.636609 0.118894 1.757695 0.905221 0.719402 0.310050 -0.041914 0.324978 0.606422 0.446900 -0.073006 1.489602 -0.028975 1.414273 1.459625 1.578483 0.780419 0.123110 -0.185615 1.829392 0.005865 0.455632 1.208385 1.134893 0.171382 1.780281 0.379740 -0.103058 1.320189 1.752847 0.654908 1.386964 0.368240 1.855635 0.232059 0.363622 1.519013 0.920646 1.583665 0.278893 0.918955 1.651703 0.521842 1.732961 1.597921 1.040556 1.633183 -0.123093 0.519090 1.085534 0.938654 0.571804 1.779326 0.860897 -0.060596 1.894771 0.724959 1.308085 1.606923 0.960916 0.804239 1.274902 1.770417 1.160363 1.754334 1.278754 0.080367 -0.218197 -0.157900 0.905084 1.350471 1.025624 0.181951 1.466991 1.528815 0.940504 0.429527 1.484590 0.307516 0.492570 0.465505 0.465863 0.895606 0.171562 0.924109 0.955767 1.789961 0.017905 1.429850 0.074028 0.139497 1.137019 0.676207 1.719651 1.553067 1.181662 0.086361 0.961933 0.769032 1.383638 1.929047 1.541463 1.092374 1.384053 0.762786 1.670247)
      )

;;; 120 odd --------------------------------------------------------------------------------
#(120 14.701 #(0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.672351088208 #(0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.578378677368 #(0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1)
      14.530112637252 #(0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      12.585068 #(0.000000 1.642250 1.457417 1.137459 0.094311 1.416472 0.051282 0.105963 0.987263 1.291373 1.093738 1.548015 1.476225 1.074911 1.473417 0.709403 0.808324 1.195288 1.048758 1.590347 1.889082 0.265007 1.181398 1.223972 1.811257 0.570424 0.883768 1.231716 1.699272 -0.057335 0.249750 -0.009343 0.092588 0.128880 0.160015 0.968242 0.540629 0.204369 1.043865 0.267028 1.282318 1.849967 0.623854 1.367800 0.117666 1.146794 1.671849 1.471918 0.588542 0.392693 1.595203 1.521711 0.798477 0.118198 0.987527 1.488329 0.086316 1.839698 1.292409 0.733240 0.885498 1.354614 0.630153 1.260240 1.003308 0.450419 1.178182 1.499186 0.446567 0.121946 0.462482 1.602362 -0.114613 1.387267 0.608384 1.093599 0.611716 0.179167 1.799724 1.169899 1.667167 0.926542 1.639331 0.149824 0.053003 1.009009 1.601654 1.707890 1.098182 0.100185 0.323759 0.340948 1.693424 0.972998 0.305147 0.751780 0.408203 0.916858 0.640088 0.799791 0.214855 1.733068 1.823671 0.300407 0.729747 1.825355 0.855384 0.607414 0.221708 1.477901 0.356681 1.587645 1.219766 0.165086 0.583414 1.179385 0.511447 1.124888 0.320373 -0.028868)
      )

;;; 121 odd --------------------------------------------------------------------------------
#(121 15.185772112492 #(0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0)
      14.673 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)
      14.355115628334 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

      12.877056 #(0.000000 0.450624 1.230124 0.451043 1.886494 -0.024923 1.567646 0.692471 0.177506 1.308214 1.321590 1.416836 0.621907 1.208416 1.273374 0.810354 0.909914 0.763963 1.113137 0.498995 1.673380 0.041249 1.154501 0.827421 1.096354 0.355493 0.158941 1.149878 1.758956 1.518525 0.658491 1.073269 0.340912 1.311600 -1.975242 1.681958 0.594261 -0.175655 0.289521 0.040276 1.453643 1.639388 1.411948 0.060863 0.650016 0.014595 0.526676 0.044452 0.424961 1.969488 0.650994 0.049913 0.471630 0.403296 1.676843 0.662795 1.193450 -0.071268 0.692158 0.047795 0.081080 1.647048 0.054086 1.884855 0.842158 0.412436 1.172269 1.185830 1.030810 1.393024 0.189364 0.118316 0.495084 1.032104 1.487051 0.010360 0.184695 1.787529 0.907263 0.242216 1.801038 0.675656 0.185656 0.732794 0.721190 1.883546 0.878490 0.150324 0.790699 -0.025587 1.722457 0.985979 0.547850 0.002567 0.102941 1.172218 1.186375 -0.029715 1.353207 1.150792 1.708789 1.571946 0.224070 0.383572 1.646221 1.550044 0.454984 0.745840 1.178109 1.428266 1.031842 1.078412 -0.012699 0.540532 0.634268 1.514926 0.808811 0.937365 0.178259 0.149334 1.348416)
      )

;;; 122 odd --------------------------------------------------------------------------------
#(122 15.079724293912 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0)
      14.561 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1)
      14.266534958875 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

      12.815441 #(0.000000 1.403115 1.625705 1.231427 1.790515 1.591033 0.124021 0.370248 0.534702 1.422778 0.673865 0.697808 1.112133 0.682960 0.351576 0.248301 0.805611 -0.006266 0.079244 -0.058595 1.327301 0.581316 0.247099 0.225227 0.567168 0.439945 1.323339 -0.225444 1.558727 0.224297 0.997055 0.942245 1.102596 1.732740 1.749095 1.656464 0.659021 1.524851 1.701892 0.589835 1.352980 0.419743 0.032194 0.059526 0.429417 1.021254 0.773585 0.461483 1.737779 0.791729 0.777319 1.611089 0.499694 1.856029 1.815732 0.466409 1.191392 0.494791 1.485462 1.408098 1.811573 1.522265 0.496542 0.429625 1.778677 0.481515 0.736872 0.359528 1.879869 0.517308 1.765667 1.803898 0.751937 0.075838 0.591217 0.258517 -0.035025 1.675291 1.141862 -0.036822 0.447686 1.413477 1.594291 1.212812 0.265402 1.872004 0.413002 0.401680 0.000918 0.406341 0.708410 1.706799 0.327908 1.423175 1.712794 1.519990 1.552302 0.608404 1.042683 0.810825 -0.174289 0.381719 0.854980 1.361184 0.685809 1.330281 0.847044 1.965474 1.127139 1.211992 0.913155 0.079627 1.246664 1.834610 0.289051 0.907660 1.390649 1.130752 0.784486 0.724056 1.665417 1.374574)
      )

;;; 123 odd --------------------------------------------------------------------------------
#(123 15.249 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0)
      15.019962594276 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0)
      14.795100232697 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

      13.011739 #(0.000000 1.270831 1.390117 1.343131 0.290733 0.774362 0.438248 0.518740 0.375214 -0.086565 1.865393 0.914481 0.140930 1.549233 0.011695 0.508550 0.457073 1.491605 1.580265 0.842899 1.610671 0.097680 0.748724 0.234627 0.094494 1.382100 0.544332 0.918208 1.113103 -0.158865 0.100591 1.881170 1.209847 0.864105 0.872636 0.434589 1.039963 1.036855 1.014096 1.473344 0.363678 0.395883 1.786197 0.564823 1.350177 0.111177 1.203946 0.031690 0.804937 1.066722 0.573905 1.199822 0.083837 1.416293 1.161712 0.799785 1.185613 1.383528 1.756560 0.645390 0.391332 0.812529 0.841775 0.467316 1.535976 1.635412 0.168664 1.289118 1.237575 1.201858 0.000492 1.019459 1.809351 1.646838 0.338073 0.663437 1.805930 1.584188 1.395094 0.658473 0.375608 0.130466 -0.201128 -0.075112 1.165574 0.083507 1.174429 -0.042711 0.686797 0.462186 1.595198 0.124139 1.296852 1.192894 0.465487 1.271487 1.002755 0.363938 1.085223 1.207026 1.911620 1.741013 1.692879 -0.165593 -0.109796 0.291887 -0.096010 0.361861 1.841827 1.267818 -0.134674 1.284156 0.558428 1.843219 1.075857 1.660531 1.086799 0.724122 1.194885 1.725055 0.923397 0.317384 1.253548)
      )

;;; 124 odd --------------------------------------------------------------------------------
#(124 15.930208950198 #(0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0)
      14.82254124518 #(0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

      13.049986 #(0.000000 0.689926 1.905320 0.973014 0.574556 1.017560 -0.020213 0.934776 0.567372 -0.603509 -0.102759 -0.108485 0.836521 0.591485 0.388177 1.730331 0.177885 0.140244 0.926407 1.603798 -0.251300 0.269140 1.141337 0.214954 1.363090 0.077705 0.319273 1.137542 1.569722 0.926478 0.468543 -0.070207 -0.148189 0.825451 0.554203 1.714756 0.510553 1.320078 1.321596 0.042298 1.563350 0.137732 0.023706 0.849784 1.743307 0.664503 0.259382 1.658816 0.838970 0.118133 -0.009055 0.835196 0.106933 0.554759 1.082608 1.074364 1.899655 -0.015771 0.303658 0.409136 0.841585 0.784635 0.411031 0.300886 0.049481 0.980225 0.318248 0.903666 1.235486 0.828671 1.131305 1.722491 0.772913 -0.297562 1.414101 1.274713 0.025837 1.282982 1.766959 0.564972 0.103712 0.485099 1.420691 1.198807 0.488585 0.437298 0.977923 0.623804 0.782654 0.064636 -0.020879 -0.148228 0.147209 -0.273674 -0.502609 0.379845 0.309088 0.893845 0.002244 1.478419 1.298541 1.784652 1.549456 0.261979 0.002012 1.411288 1.325004 0.685419 0.593775 0.323887 1.773849 1.498911 1.306696 -0.278799 1.470169 1.851883 1.206934 1.722537 0.641040 0.692393 1.223682 0.617241 0.557473 -0.025320)
      )

;;; 125 odd --------------------------------------------------------------------------------
#(125 15.409635839002 #(0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0)
      14.833 #(0 0 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0)
      14.82163143158 #(0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      13.069565 #(0.000000 0.806329 1.820718 0.710116 0.537939 1.516013 1.281131 0.399606 0.963852 0.477282 0.523912 1.713023 1.203912 1.300350 1.415929 0.114333 0.305103 1.357092 0.194541 0.812320 0.513820 0.851811 0.762924 1.024077 0.116391 0.106763 1.022493 1.037521 0.443182 0.928998 0.609993 0.005847 1.865292 0.656626 -0.208558 0.878421 1.771361 0.905611 0.103716 0.187788 0.807934 1.654519 0.919933 1.482596 0.009004 1.230310 1.436172 1.703868 1.273090 0.015738 -0.152958 0.251595 0.631761 0.042442 0.014812 0.109814 0.012970 1.389088 1.244378 -0.130286 1.175932 1.348493 0.232828 -0.142041 1.779673 0.278775 0.355180 1.166958 1.387057 1.291355 0.957543 1.752890 0.623975 0.208619 1.127074 1.622018 0.212204 1.678947 0.041395 0.502006 1.247290 0.125349 -0.017298 1.582443 1.377659 0.835197 0.656146 -0.006634 0.819061 0.269880 0.511151 1.631755 1.416138 0.220020 1.168572 -0.193176 1.554846 1.425567 0.304431 1.711634 1.208919 1.034873 1.150446 1.811164 1.868895 0.938628 1.895277 0.808842 0.125477 0.829799 1.349324 1.037255 0.300457 1.706559 0.452733 1.119939 0.353154 0.212340 0.151736 0.696009 1.929655 1.580007 0.605127 0.285405 0.006038)
      )

;;; 126 odd --------------------------------------------------------------------------------
#(126 15.556811374771 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1)
      14.961482935205 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

      13.250538 #(0.000000 1.162062 1.772969 -0.056549 0.913770 -0.288690 0.818539 1.550214 1.242276 1.730985 1.237567 0.955275 0.970163 1.372752 1.034742 -0.152966 -0.115290 0.523671 1.259447 0.610945 0.033439 0.483099 0.279912 1.325871 0.165105 0.467000 1.124882 1.602402 0.578025 0.066216 0.106159 0.609562 1.691827 0.842480 -0.292760 -0.008012 -0.005727 0.904444 0.854421 1.362000 1.143477 1.572727 1.891524 1.455790 0.624443 0.645696 1.557970 1.455103 0.172921 0.274644 0.417475 1.816849 -0.125977 -0.112706 0.738919 0.740104 1.661927 1.368115 0.552904 1.828238 0.567369 0.473127 0.387547 0.112106 -0.047665 0.755689 1.881607 0.764308 1.308467 0.339941 0.273739 1.240680 1.143921 0.637299 0.037102 1.355660 0.445990 0.858672 1.238886 1.332053 1.437889 0.929628 1.388662 1.934496 0.456316 0.518687 0.177187 1.641883 0.321437 1.607102 1.053562 0.607278 1.119966 -0.118980 0.988577 1.276193 1.055845 0.893019 1.669306 1.434278 0.317087 0.214588 1.673980 1.245566 1.186306 0.534977 0.873369 0.394522 1.403575 0.034643 0.685768 -0.064633 0.663919 -1.934469 0.657095 1.027211 0.738638 1.189471 -1.892923 1.702553 1.362451 1.917772 0.650041 0.930493 -1.883243 0.993992)
      )

;;; 127 odd --------------------------------------------------------------------------------
#(127 15.055509004493 #(0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0)
      15.018874168396 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
      14.695912364919 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

      13.272808 #(0.000000 0.644355 0.927224 0.507120 -0.012481 1.255984 0.616778 0.429305 1.214889 0.080886 -0.063119 1.444212 1.467377 0.506826 0.188031 -0.088354 0.417959 0.662535 1.054597 0.842356 0.169880 0.896296 1.229448 1.856081 0.821431 1.205263 0.238422 0.990879 0.722387 1.767353 0.656560 -0.012883 1.657533 0.981021 0.104394 0.795282 -0.009004 1.776467 1.425682 0.423203 1.423548 0.983864 0.420382 0.391148 1.309760 0.859461 1.282043 1.611999 1.079743 1.549712 0.099648 0.342831 0.865411 1.454532 0.826482 0.182838 0.737282 1.140306 1.513431 1.544157 0.553639 1.142825 -0.195876 1.632209 1.095565 0.073744 1.083591 1.459297 1.200117 1.187571 0.995828 1.110124 0.801146 1.508742 1.716449 1.611984 1.495256 0.662195 1.343884 1.318432 0.426636 -0.007294 -0.027365 -0.156722 1.705608 1.030256 0.332183 1.177639 0.960771 0.864056 0.544247 0.314974 0.724016 0.355258 1.152126 0.439404 0.290295 0.479276 0.099264 1.127919 1.564131 1.123504 0.409223 1.547686 1.237288 1.725771 0.435143 -0.184917 0.843734 0.973726 0.868303 1.407937 1.537970 1.840863 0.518793 1.782543 0.531354 1.046306 1.114791 1.217452 0.526080 0.680369 1.114583 0.369963 0.931999 0.071693 1.316644)
      )

;;; 128 odd --------------------------------------------------------------------------------
#(128 15.527 #(0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1)
      15.003612518311 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)
      14.876242756695 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      13.295580 #(0.000000 1.932372 0.814844 1.135822 0.334165 1.002423 0.676595 0.592529 1.413369 1.300117 0.789664 0.653979 0.789182 1.728416 0.812392 0.031421 0.204548 -0.080921 0.750446 0.142219 0.462987 1.432256 0.585931 0.629443 1.322482 -0.001987 0.428434 0.233467 1.108001 1.079004 1.463201 -0.076862 0.280786 1.330540 0.857067 0.133073 0.991427 0.801972 0.948219 1.221368 0.325362 -0.030131 1.252365 0.538123 1.452257 0.809959 0.885069 0.952317 1.519451 0.215094 0.610370 1.612627 1.003728 -0.238468 0.833839 1.474060 0.684936 0.250224 1.270401 0.886470 0.705982 1.350143 1.130022 1.331693 0.053854 0.202548 0.900638 0.920788 1.584951 1.420718 0.794342 1.507624 0.676455 0.648687 1.589682 0.439493 0.162635 0.382256 0.470534 1.566956 0.145470 1.386472 0.224793 -0.135214 1.695671 0.396462 1.643127 0.951883 0.865577 0.832237 1.416012 0.037002 0.579062 0.215373 0.367533 0.161970 1.452549 1.624086 1.494542 0.326693 1.668190 0.107753 -0.016927 1.089574 -0.123401 0.547056 0.749877 0.569982 0.637231 1.225599 1.313975 0.892549 0.052792 0.997670 1.075474 1.523019 0.235240 1.758059 1.422452 0.681678 0.931777 0.390338 -0.040032 -0.263198 1.262270 0.745928 1.548790 1.379080)
      )

;;; 256 odd --------------------------------------------------------------------------------
#(256 22.546259712247 #(0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
      20.538261 #(0.000000 0.272889 1.778769 0.030967 1.593584 -0.156089 1.691613 -0.011734 1.415852 0.367481 1.789082 0.401388 1.866971 1.666929 0.819081 1.467893 0.146121 0.557866 1.090825 0.141857 1.030076 0.369300 1.268680 1.646719 0.574097 1.584981 -0.023631 0.806792 0.521545 1.903980 0.033814 0.643051 1.686268 1.471927 1.695518 1.211602 1.162050 1.582687 0.323121 1.660328 0.860454 0.822833 0.675181 1.203397 0.892488 0.926742 0.920069 0.307485 1.199156 0.944395 0.050569 1.348344 1.581019 0.466873 0.460372 1.564569 0.356519 1.411446 0.234539 0.544372 1.796447 1.420865 1.541281 0.553019 0.035036 0.301550 0.198288 1.087811 1.510906 0.048779 1.185101 0.342671 0.776066 1.839874 0.501578 0.672094 0.418330 0.075584 0.148104 0.942149 1.886312 1.932956 0.350754 1.238743 0.215471 1.818436 0.525427 0.145769 1.901993 1.157652 0.288534 0.183124 1.754402 1.830403 1.601910 0.141387 0.405725 0.595425 1.430880 -0.161107 1.180637 1.203632 1.878709 1.401133 0.405050 0.455206 1.647563 0.182909 0.019855 1.078895 0.942655 1.045295 1.172630 1.285736 1.713659 0.519136 1.856181 1.588529 1.500652 1.704524 0.668290 1.446880 0.757422 1.551941 0.471224 1.194767 0.605203 0.601783 0.213882 1.441882 1.504403 1.766276 0.890296 0.969441 0.188532 0.741899 1.887602 1.479262 0.906811 1.720353 0.478860 0.069125 0.145297 0.991730 1.606271 1.618275 1.768087 1.327011 0.161937 0.303896 1.387980 1.475731 1.304815 1.660642 1.062295 1.945784 1.225941 1.811044 0.240279 1.802803 1.407750 0.361823 1.171677 0.977299 0.399409 1.522484 1.210021 0.033856 0.871445 0.101417 1.215328 0.684777 0.461050 0.679741 1.357845 0.363204 1.701430 0.119127 -0.160307 1.604465 0.885857 0.676623 0.479812 1.680229 1.192876 1.812974 1.814897 0.651446 0.216711 -0.015843 1.000707 0.243445 1.317402 1.693848 0.528782 0.284705 0.581688 0.708470 1.186913 -0.112097 0.154883 -0.010075 0.945515 1.496756 1.306887 0.035687 0.365269 0.481390 1.872369 0.981375 1.147497 1.956320 0.764911 0.910673 0.202515 0.814410 1.691726 0.557338 1.631392 1.269859 0.713665 0.925596 0.587556 -0.095376 0.964079 1.410809 0.409565 0.194512 0.264862 0.098841 1.486375 0.516496 0.697590 1.673947 0.812171 1.076503 0.533280 0.740481 1.049141 1.355196 0.272213 1.246626 1.332406 1.932431 0.488170 1.060888 1.316737 1.523815 1.727182 1.887168 1.598230 0.781322 1.868790 -0.070394 1.003618 0.832997)
      )

;;; 512 odd --------------------------------------------------------------------------------
#(512 35.541 #(0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      32.503493 #(0.000000 0.679412 0.809237 1.066615 0.548324 1.628776 0.941414 0.769740 1.029750 0.896961 1.421259 0.002179 1.339313 1.358909 0.628749 1.277896 0.379479 1.137571 0.474593 0.039830 1.205360 0.545719 0.590881 0.434073 1.873138 0.200972 1.655091 1.242097 1.652255 1.569195 0.528746 0.785327 1.124074 0.995370 1.487557 0.677142 0.625466 0.897605 1.153890 1.127021 0.760421 0.296504 0.871868 0.921035 0.377158 1.750225 0.988692 0.505392 0.634645 0.325469 1.159004 0.854892 0.254871 -0.116033 0.858820 1.419185 0.146458 -0.005864 0.124247 0.937549 0.745187 1.672580 0.907490 0.796624 1.677186 1.370454 1.929724 0.008804 1.831977 0.810046 1.048145 1.219355 -0.053406 1.026846 0.223994 0.075263 0.016013 -0.125581 1.400031 0.623622 1.706089 1.122996 0.619718 0.883175 1.321273 1.588549 0.202103 1.565659 0.942493 1.525690 0.790427 0.633216 1.174762 1.620809 1.909703 0.793423 0.162566 0.862037 0.825158 -0.209576 1.184857 0.068694 1.025003 1.605360 0.760824 0.420006 1.022864 1.554782 0.280606 0.168797 1.720534 1.319911 -0.196005 0.345206 1.620856 1.296162 1.534763 1.100352 0.381694 1.544756 1.264805 0.171639 0.833251 0.343792 1.656969 0.340247 0.605053 0.028078 1.527535 1.753703 0.220888 1.721972 -0.014515 0.597355 0.101013 1.039747 0.300384 0.973035 1.213655 0.643812 0.502086 1.570691 0.151513 0.574285 0.981364 1.023741 1.322018 0.393931 1.283578 1.255204 0.501198 1.129955 0.485714 1.864730 0.802278 0.466095 0.265473 0.232057 1.069382 0.779956 0.563809 0.871179 0.662227 1.411243 0.743545 0.062056 0.270035 0.622595 0.967823 0.720025 -0.121588 0.893300 1.751443 0.372694 0.669472 0.792414 0.418681 0.992553 1.135363 0.798665 1.823495 0.958873 1.351729 1.421915 0.741905 1.820588 0.057004 0.826246 1.021904 1.423703 0.462006 1.892559 0.731092 0.503856 1.208434 0.513154 0.070868 0.166480 0.034766 0.195292 0.071458 0.146382 0.250755 1.279455 1.607915 0.002711 0.729902 1.137061 0.754906 1.256442 1.175198 1.716023 0.327046 0.087013 1.341237 1.043708 0.156105 0.300686 0.996832 1.724575 1.448183 0.711387 0.522091 0.045199 0.407390 0.638475 1.599413 0.911511 0.484786 -0.004920 0.484210 -0.042146 -0.038564 0.117833 1.036642 1.557603 0.079479 1.746104 1.195581 0.353674 1.111301 -0.104914 0.790788 0.423874 0.229730 1.087925 0.056416 0.866145 1.203006 0.009367 1.434052 1.155547 1.556295 1.690324 1.822350 0.797891 0.495021 1.011782 0.844274 1.773314 0.692176 1.418663 1.494635 1.186803 0.405932 1.282873 1.103735 0.537268 1.446763 1.268687 0.077012 0.348370 1.262330 0.942791 -0.110671 -0.204302 0.309011 1.734463 1.397747 0.666179 1.155069 0.802291 1.425857 -0.087638 0.486956 0.929752 1.651012 1.402509 1.730485 1.648871 1.038299 0.285915 0.212211 1.434005 1.457453 0.924468 0.847575 1.125105 1.374853 1.210111 1.534002 0.375785 -0.181628 -0.299413 0.000626 0.978258 0.875368 1.505462 0.927863 1.729821 0.807697 0.318995 1.364023 0.428411 1.338258 1.410759 0.980643 1.354574 1.657838 0.298608 1.652033 1.073666 1.888442 1.602881 -0.004937 1.725862 0.650257 1.328504 1.421702 -0.127511 0.055031 0.780918 -0.044425 1.353563 0.567325 1.041729 1.067199 1.104630 0.746025 0.063094 0.337045 1.200676 1.183969 -0.127518 0.684565 -0.157959 0.862704 1.908495 0.091821 1.564884 0.973193 -0.009563 0.902018 1.603876 0.720977 1.097974 1.530876 0.635424 0.557942 0.951593 0.604792 0.096250 1.850747 0.927902 0.101609 0.016017 -0.055576 1.178340 1.244133 1.483481 0.030257 1.673563 1.712417 1.895657 0.804158 0.284388 0.186228 0.115592 0.345551 1.067451 1.266168 -0.166620 0.462150 0.434233 0.314337 0.267796 1.048871 1.774918 1.058398 1.710687 0.302054 1.306832 1.274040 0.802406 0.344367 1.255489 0.758856 0.662853 0.515720 0.750605 1.441790 1.447306 1.258926 1.781105 0.951579 1.830323 0.602932 0.012292 0.629192 1.161514 1.584519 0.512187 1.623868 0.011995 1.189620 -0.117491 1.072949 1.816290 1.072713 -0.110451 0.482660 0.247038 0.018810 1.575293 0.177126 1.664719 0.255603 0.402715 0.380357 1.135020 -0.157363 0.005896 1.617115 1.483205 0.598996 1.342460 1.255997 1.133337 -0.020480 0.502666 0.933241 0.871879 1.276232 0.407344 0.003813 0.173443 1.306013 1.058188 1.556833 0.752099 1.348533 1.229824 0.437326 -1.900001 0.037489 1.825433 0.390192 1.039835 0.381888 1.696682 1.095663 0.938256 1.014208 1.162364 0.651126 1.830745 0.241634 1.857248 0.779587 1.524196 1.754351 0.739230 0.133693 1.724692 0.610130 1.768182 0.670295 1.533058 1.884824 -0.055705 0.453010 1.417400 0.140669 0.314344 0.493746 1.570750 1.716798 1.415537 0.001217 1.273893 1.774138 0.660847 0.663845 0.455063 1.856273 1.591822 -0.144666 0.232403 0.584326 0.148068 0.891260 1.252693 0.568983 0.203742 1.707956 1.046843 0.815807 1.082555 0.677334 1.528644 1.273297 1.120976)
      )

;;; 1024 odd --------------------------------------------------------------------------------
#(1024 52.508 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       49.917747 #(0.000000 1.538718 1.673453 1.170805 1.359133 1.908376 1.996331 0.797005 0.894370 0.589653 1.325886 0.933855 0.980838 0.836513 0.500420 1.338727 0.447775 1.156265 1.734351 1.812171 1.641441 1.116064 -0.103226 1.035119 0.633950 1.272170 1.435951 1.447510 0.429110 1.130962 0.328732 -0.002087 1.393707 -0.119000 1.581385 1.028232 0.876240 0.426232 1.217167 0.985070 1.654555 1.926974 -0.202040 1.521498 0.430775 1.807764 0.374060 0.256278 1.247952 0.962957 0.333800 -0.003539 0.273071 1.181833 1.487259 -0.093975 1.738006 1.735086 0.525119 0.084233 1.359315 0.177187 0.943973 1.194748 0.527778 0.867902 0.817228 -0.186512 1.339132 1.551494 0.843719 1.466863 0.902899 0.541881 1.153290 1.622094 1.373660 0.678997 1.573578 0.544673 1.266479 1.602941 0.546330 0.989293 -0.067994 0.647585 1.300110 1.514573 0.571905 1.358883 0.206093 1.184934 1.521021 0.880741 1.367056 1.788831 1.948494 1.370363 1.140516 0.716407 1.050295 0.354485 -0.296287 0.661276 0.131290 1.053318 1.687445 1.667561 0.214107 1.734753 0.363141 0.665010 1.372144 1.007738 0.683663 1.299293 0.415834 -0.061858 1.576065 0.476145 0.807546 0.957773 1.697912 1.638598 1.424334 1.559075 0.468335 1.772613 1.543208 1.138206 1.750653 0.437399 1.146881 1.300421 0.934756 0.220147 1.626653 0.413646 0.962300 0.840552 -0.190640 0.237209 0.489388 0.961530 1.179991 1.978534 0.344456 0.633529 -0.099360 1.348822 0.258153 1.701323 0.814976 1.183920 0.331141 0.267929 1.521084 1.420577 0.971363 1.688325 0.739714 0.944208 1.306464 0.419784 1.583516 1.098152 1.722870 0.285577 1.325725 0.335897 -0.189466 0.611056 1.303669 0.094110 1.683154 0.898510 0.504590 1.375147 0.910814 0.684539 0.325852 1.190884 1.833117 1.913872 0.747712 0.792427 0.694550 0.356286 0.741411 1.263077 0.676914 0.777321 0.285274 0.187950 1.423854 0.487302 0.029914 1.392850 0.211156 1.939576 1.813644 -0.024537 1.621275 1.358140 0.760259 1.692371 1.873313 0.263796 1.849726 0.382488 1.394880 0.341959 0.103293 1.149742 0.478329 0.259601 -0.058533 1.607482 1.436110 0.888238 1.218430 1.637317 0.042267 1.876608 0.719472 0.576144 1.268764 1.747253 1.243516 0.931356 1.242900 1.608775 1.880086 0.025365 1.090458 0.937916 1.258646 1.853438 1.456749 0.877274 1.353161 0.763781 1.369966 0.704756 1.697017 0.449923 0.877873 -0.035397 0.987295 1.121737 1.085135 1.453828 0.883323 0.527567 1.543968 0.999017 -0.067914 1.545674 1.025500 0.092428 1.920962 0.472766 1.740162 1.598195 1.383824 1.762336 -0.164575 1.198370 0.676795 0.983396 1.917387 1.320466 -0.079958 0.180092 0.740050 0.229224 0.265965 1.351148 1.230245 0.442417 0.928552 0.661027 -0.046630 1.316227 0.829789 1.458035 0.820976 1.194758 0.135181 0.621568 0.322580 0.246307 0.698051 0.211806 1.212736 0.313608 0.927303 0.154345 1.184265 1.010322 1.784525 0.972213 1.670573 1.567389 0.910363 0.068950 0.812276 0.094311 1.291542 1.653470 0.080928 0.440721 0.130283 1.144019 0.283970 1.202403 0.580108 0.855265 0.949102 1.666738 1.957784 1.114690 1.774701 1.596751 1.770552 0.010833 0.526721 0.954103 1.507522 0.198883 0.254643 -0.028915 0.910776 1.065761 1.917372 0.333991 1.858192 1.897788 0.832130 -0.077712 1.175786 0.935216 0.758104 0.501547 1.915493 1.492255 0.620947 0.119487 1.446596 1.690272 0.612090 1.678853 0.159492 0.644091 0.789285 0.633346 0.621274 1.976048 1.397494 1.513719 1.507292 1.311749 1.315985 1.232071 1.767199 0.817480 0.534287 0.014567 1.720034 1.583440 0.162972 0.324888 1.642114 1.575404 1.668592 1.954637 1.356403 0.017159 -0.156138 1.529208 0.071726 1.733802 1.751833 0.107963 1.679616 0.828919 0.407130 0.249317 0.524324 1.639325 0.580945 1.486456 0.631537 0.215183 1.697902 0.589438 0.713226 0.911234 1.926756 -0.073203 0.632186 0.267297 1.462174 1.395280 0.606996 1.436094 0.068123 0.660220 -0.101417 0.674887 0.676142 1.449723 0.715377 0.507057 1.596687 -0.009828 -0.084831 1.691062 1.154527 0.081573 0.142519 1.091313 0.015673 0.546875 -0.066135 0.020865 1.893947 0.657531 1.023647 0.623604 0.962746 1.727459 1.319711 0.139936 1.802051 0.761255 1.799457 0.668192 0.636953 0.557118 0.129957 0.108099 0.153127 0.628833 1.170685 1.829410 1.809593 0.715985 0.838449 1.766310 0.053898 1.752953 1.086390 0.018483 1.062957 1.491248 1.304418 1.650149 0.353298 0.371065 1.563611 1.350570 0.768585 1.616251 0.988588 0.021238 0.553913 0.014938 1.673355 0.054242 0.308791 0.918205 1.288445 1.424848 0.798214 0.415061 1.948153 1.881338 0.303812 1.769120 -0.072420 1.037934 0.163144 0.223426 1.428543 1.171751 0.531729 1.320576 1.000052 1.400005 0.288627 0.387419 0.990513 1.871013 1.632329 1.642593 0.592328 1.701298 0.694222 0.391748 0.218750 1.908702 0.771610 0.920063 1.239514 0.055738 1.634091 0.159501 0.513851 1.812285 1.040458 1.165857 1.421263 0.722806 1.487979 0.215466 1.121320 0.240567 -0.106603 1.227501 1.766342 1.304502 0.013636 0.178489 1.178445 0.175773 1.570370 1.498041 1.132800 0.507567 0.108960 0.718484 0.952164 0.311672 0.217439 1.642520 0.470698 0.493314 0.826744 1.751538 0.247767 0.532651 0.748558 0.316839 1.669380 0.647337 0.340542 0.839836 0.706536 0.010018 1.353405 1.417075 1.871682 1.003518 0.363437 1.864347 1.321796 -0.019171 1.844210 0.786510 1.437958 0.250679 1.791458 0.654765 1.293024 0.420605 1.771227 0.064886 1.746996 -0.059467 1.183013 0.083772 0.509871 -0.018262 0.185458 0.762622 1.765536 0.790375 0.069803 -0.057147 1.642953 1.703039 1.680127 1.706822 0.582851 0.186555 1.246479 1.643732 1.804666 0.575734 0.046279 1.592722 1.498570 0.623198 0.129449 1.277347 1.112301 0.681389 1.395493 1.081335 0.585292 1.170237 1.170525 0.451039 1.157711 0.207917 1.846771 1.553874 0.924567 1.016520 0.350104 0.152766 1.245423 1.590899 1.437191 0.698175 0.732665 0.783183 1.480607 0.278060 0.271243 1.021704 1.581846 1.168143 1.087762 1.409784 1.821386 0.485270 0.768498 0.647623 1.916746 0.049589 1.529712 0.307692 1.120742 1.883356 0.949123 0.595901 1.488037 1.149880 1.154746 0.104842 1.103203 0.227633 0.811685 1.004520 0.385175 1.620155 -0.238898 1.601397 0.979863 1.332672 1.939692 1.494173 0.386161 0.715534 0.253441 1.075470 1.790439 0.048570 0.976103 1.152028 0.602698 0.599216 1.624172 1.260535 1.429403 0.766635 0.259238 0.861647 1.333370 1.459329 0.852277 0.522911 1.741632 -0.029368 1.736002 0.280554 -0.105878 0.356199 1.394345 1.278089 1.568584 0.525803 0.219138 1.195649 0.935728 1.885098 1.024077 0.536298 1.500177 0.042464 1.866297 0.121877 0.009302 -0.093563 0.102584 0.277689 0.335886 1.179059 1.151437 0.406205 0.276857 1.277935 0.261262 1.540227 0.412430 0.187554 1.340723 1.378443 1.085797 1.804181 -0.057875 0.391205 1.525590 0.115877 0.890801 0.291287 1.737986 0.716051 1.521189 1.855614 0.287690 1.068422 0.622803 0.240462 0.041725 1.339422 0.123643 0.638937 0.859718 0.873174 1.000222 1.827840 0.401645 1.350832 0.399512 -0.005145 0.394027 1.138432 1.598235 0.629733 1.737282 1.726544 0.733443 1.701485 1.194854 0.280657 1.240213 0.696102 1.114009 0.343354 0.985076 1.371980 1.418927 0.149158 1.654854 0.002838 0.253861 1.546716 0.499053 1.292841 1.870539 1.773440 1.750547 1.288328 1.474927 1.160890 1.928999 0.181544 1.476941 0.833815 0.647440 1.100081 0.052404 0.786167 0.887022 0.366601 0.717052 0.396698 1.127214 1.254992 0.527962 0.014015 0.655528 1.831507 0.663755 0.685914 1.607977 1.530969 1.767200 1.718284 -0.036525 1.869307 0.308184 0.505558 0.078784 1.261876 0.521580 1.407277 0.569269 1.726882 0.165684 0.763531 0.628910 1.098747 0.158761 0.226373 0.514445 0.525279 0.218965 1.247774 0.525370 0.135368 0.350902 1.477683 0.480785 0.938538 -0.195160 1.585838 1.764096 0.838547 0.282443 0.923434 0.751077 1.058915 0.858567 1.528998 0.657600 0.648910 -0.061095 0.492716 1.793090 0.428821 1.549191 0.984910 1.314701 1.644637 1.518519 0.568293 1.387323 1.675950 1.185423 0.405225 0.754681 0.366358 -0.012536 0.985231 1.809058 1.802200 0.336000 0.067752 0.861299 0.234375 -0.045847 0.281854 0.976139 0.937817 0.187818 1.252600 1.838592 1.217731 0.648890 1.210154 1.054122 0.794211 0.510442 0.812912 -0.087284 1.380226 1.848354 0.168680 1.559596 1.470578 1.184711 0.527144 1.346592 1.063547 0.217368 0.224605 0.919283 1.021527 0.452847 1.479221 -0.149202 1.044395 -0.029261 0.624714 1.064160 0.546017 -0.006669 -0.069616 1.165967 1.449815 1.030899 1.321948 1.653545 1.896190 0.584806 0.681802 0.616186 0.795972 0.119729 1.476546 0.040709 1.059441 1.659860 0.965275 1.692842 0.661980 0.746322 0.228606 0.843614 1.733833 0.961236 0.756965 1.692145 1.242326 0.899479 0.947054 0.871777 1.535702 0.956181 0.349349 0.772900 1.490193 1.104050 -0.018757 0.955891 1.513314 1.654909 0.829702 1.652256 0.813856 1.207703 0.774522 1.809662 0.708776 0.712684 1.720461 1.362333 0.033018 0.906961 1.186722 1.168286 1.511307 1.545521 1.775486 1.094047 0.797341 0.330392 0.735597 0.052074 -0.018423 -0.012268 0.713989 1.515364 0.899401 0.980474 1.470208 1.596712 0.828388 0.068321 -0.071921 1.628581 0.652993 0.431677 1.695077 0.676972 1.673770 1.758153 1.579301 1.315721 -0.017745 -0.019040 0.246526 0.077512 1.843249 0.546020 0.775438 1.389556 0.425204 0.605997 1.801725 0.014294 1.045023 0.707213 1.599479 1.980346 0.365745 0.656642 0.005984 1.190805 0.479537 1.327628 0.291758 0.641163 0.649276 0.102381 0.281639 1.973399 0.071051 0.156820 0.923432 1.198058 0.557809 1.489840 1.827811 1.854522 1.940413 1.824872 1.541449 0.707432 0.620870 1.331305 -0.126617 1.204142 -0.006039 1.135342 1.337189 1.335699 1.824816 0.706564 0.025969)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
#(2048 83.108 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       81.700532 #(0.000000 1.630929 1.094114 1.640623 0.612338 -0.059005 1.654502 0.659967 0.540782 0.843991 0.198997 0.381211 1.238114 1.541898 1.645566 0.661162 1.316765 1.012522 1.290433 -0.103846 0.019030 0.550416 1.333852 1.715120 1.789997 0.713559 1.669068 0.631917 1.914659 0.091509 1.181696 1.005514 -0.042336 0.121364 1.686991 1.078677 -0.128321 1.868763 0.747493 0.375654 0.095756 1.449260 -0.134380 0.391690 0.199444 0.913108 1.582071 0.673265 1.412480 1.199030 1.024220 1.364721 0.848475 1.419300 1.303610 0.131980 0.586724 1.268872 0.564806 1.135716 1.469442 0.337595 0.619328 0.223539 -0.007130 0.342614 1.279713 0.361215 1.353084 1.094727 1.301241 1.836434 0.149577 1.553289 1.934554 1.606837 0.997711 1.637359 1.637726 1.628953 1.379378 1.543773 1.724834 0.525547 -0.102571 1.070867 1.533275 0.415840 -0.068967 0.905563 1.776656 1.254573 0.092019 1.871393 1.539616 0.312045 1.423351 0.614918 0.876285 1.324117 -0.041440 0.443743 1.054641 0.176946 1.555581 1.380618 1.793223 1.703308 0.989913 1.439045 1.417437 0.382647 0.117999 0.074079 1.374609 1.428129 1.686161 0.298638 0.858901 1.096533 1.564905 1.306728 0.759712 1.795099 0.971214 1.702994 1.694526 0.680164 0.600559 0.692653 1.765458 1.653545 0.991041 0.684205 0.637049 1.532444 -0.102600 0.254314 0.737323 1.244189 1.946716 0.469489 0.918673 0.793238 1.087745 0.867964 -0.255897 0.973486 1.488496 0.587706 0.076546 0.750282 0.016453 1.197331 0.171174 0.863953 1.359074 0.438547 -0.088671 -0.306907 1.583003 1.600689 0.451981 0.491408 0.893925 -0.035878 0.258865 1.694671 1.028807 1.680382 0.489833 -0.259849 1.651744 0.547516 0.061358 -0.018316 0.963975 1.114485 0.057255 0.489485 0.537191 0.952962 1.531187 1.493653 0.703095 1.149282 0.192510 1.040006 1.179561 1.507457 0.687848 0.547980 0.520191 0.344116 0.583355 1.174183 0.821009 1.635756 0.206032 0.938873 0.735832 0.666759 0.013316 1.225636 1.443276 0.895741 0.303782 -0.125355 -0.261447 0.623182 0.138976 1.268481 1.667701 0.434140 0.738956 -0.006473 1.156134 1.211193 1.755215 0.367921 0.607385 1.628475 1.073414 0.805913 0.077049 1.088986 0.334748 0.522757 1.377719 1.257952 0.108146 0.798936 0.320567 1.190473 -0.092444 0.436188 0.744731 0.112748 0.496204 1.127554 1.246254 1.538893 1.626897 1.591108 1.453157 1.938860 1.549259 1.366376 0.091569 0.332055 1.512399 1.145967 0.111076 1.493580 0.144286 0.005536 1.292629 1.854819 1.337100 0.427326 1.308061 0.153716 0.951465 0.056113 0.128937 1.287462 1.290439 1.900915 0.956272 1.402134 0.922671 1.151574 1.631816 0.472200 0.290549 0.591879 0.461212 0.446451 1.790179 0.630352 0.215887 1.809012 0.111084 1.371588 0.510165 1.686845 1.401699 0.830502 1.368701 0.470171 0.880080 1.882586 1.215540 0.812956 1.275327 0.867155 1.413061 1.516625 1.842839 0.299013 1.290297 1.554837 0.004296 1.922030 1.715971 0.745671 1.834833 1.685188 0.459546 0.852753 0.222708 1.234686 0.066818 0.408757 1.014860 0.439007 1.014639 1.260840 0.655777 0.991649 0.527294 -0.041261 1.711591 0.847940 0.179268 0.465383 0.194523 0.899065 0.071528 0.418693 0.418103 0.732361 1.297546 1.256178 0.846633 0.392737 1.820891 0.713707 1.291834 1.210356 1.275578 0.200742 0.613096 0.139169 0.341529 1.296228 0.763760 0.313638 1.595900 0.194525 1.833744 0.352448 0.889375 1.676171 0.501212 0.331975 0.885351 0.345396 0.880101 0.007208 1.738210 1.269611 0.672678 0.421691 0.263085 1.316376 0.794111 0.154712 1.289873 0.890304 0.432099 1.197318 1.278859 0.612746 0.130591 1.065268 0.189717 -0.135565 0.506017 0.967909 1.703954 1.930673 1.452673 1.567695 -0.014515 0.625969 0.201367 0.452228 0.652907 0.293525 1.112909 1.642972 0.431389 0.797765 0.977773 0.358388 1.874632 0.037684 1.652601 0.303906 0.914574 0.633176 1.249397 0.773101 1.208696 1.286408 1.666054 1.256075 1.140119 1.311614 0.991953 0.863871 -0.136979 1.089162 0.835943 0.466134 0.479027 0.703219 0.333846 0.397370 1.617390 0.728484 1.673126 1.282363 1.797707 -0.044128 0.353277 1.045390 0.972154 1.054862 1.120394 1.304780 1.060875 1.168615 0.742265 1.546111 0.650969 0.446651 1.786706 0.166953 -0.069741 1.867821 1.793996 0.260793 1.465915 0.551938 1.304116 0.277393 1.851218 0.699626 1.809329 0.914075 1.247352 1.311319 1.108855 1.188673 1.705050 0.073568 1.834587 0.391872 -0.137874 0.006661 0.675483 1.697564 1.225504 -0.108845 1.634825 -0.049004 0.706364 0.938834 0.058626 0.190676 0.902727 0.846414 1.174571 1.916067 1.690762 1.471187 1.627049 1.498812 1.715189 1.703943 1.092997 0.538489 0.298876 1.949290 0.953680 0.842257 0.422108 1.219498 1.049814 0.877677 -0.053929 0.129455 1.261563 -0.345280 1.763678 1.501178 1.463688 0.011614 0.549141 1.533902 -0.065444 0.411369 0.555053 0.985704 0.138752 1.219213 1.827050 1.260185 1.876681 1.787899 0.785190 0.388294 1.318712 1.220823 1.384594 0.877816 -0.202000 0.503826 1.271523 0.806115 1.686481 1.709962 0.560468 0.739745 0.528231 0.224899 1.285780 1.243486 1.503994 1.906018 0.997974 1.815865 0.898806 1.242726 1.032340 0.614666 0.605411 0.649847 0.268270 0.752001 1.361427 1.508250 1.224032 0.692505 0.299695 1.444192 0.537379 0.269797 1.645860 0.546597 0.764695 0.914880 0.954918 0.195452 0.555182 1.484763 0.427836 0.357606 0.451366 1.118370 1.769388 1.341533 0.815540 0.316978 0.596852 0.589007 1.048427 0.919308 0.449421 1.368847 1.409050 0.024999 0.062853 0.469688 0.962197 0.271776 1.332264 0.694575 1.469416 1.866061 1.557680 0.715433 0.046946 1.014977 0.913078 1.607646 1.173762 -0.012120 1.643768 0.759323 1.996128 -0.050977 1.294074 1.589835 1.394156 1.777285 1.117698 0.369220 0.522149 -0.117438 0.209492 0.990844 1.690964 1.137822 0.751663 1.378934 0.939631 0.627559 0.271292 0.581045 1.315228 0.505507 1.261125 1.577008 1.483078 0.878615 0.078757 0.053956 0.668896 0.592883 0.511379 0.928320 1.355265 0.753869 0.818102 0.187930 1.375758 0.446576 1.056231 0.810924 0.891131 1.146618 0.009020 -0.006166 0.657618 1.195953 0.870824 -0.007337 1.706863 0.310118 1.268391 -0.027332 0.014551 1.453128 0.226953 1.703132 1.777566 1.229981 -0.016380 1.438802 0.376965 1.033157 1.462338 -0.066424 0.703203 0.906360 0.124367 1.942462 0.125306 0.162789 1.909445 1.021899 1.308871 1.785865 0.782564 1.613587 0.080444 0.458384 1.124723 1.619622 1.299011 0.353847 1.595309 1.472322 0.107586 0.860123 1.560561 1.848675 1.409213 0.741772 0.071391 1.666612 1.640711 0.293948 1.934368 0.009827 0.425785 0.685438 1.794520 1.769536 0.369308 0.895015 0.723213 1.887784 1.434394 1.306825 0.101117 0.228391 0.403564 0.621907 0.306610 0.731693 0.686899 1.189478 1.683636 1.813732 0.697024 0.821081 1.530430 1.616582 1.087175 1.838005 0.049156 0.145369 0.466399 1.824828 0.580552 1.430482 0.388672 1.484642 1.824113 1.825254 1.225263 1.115072 -0.039172 1.329297 1.032701 1.184710 1.967539 1.030190 1.069197 -0.315706 1.638073 1.756641 0.369998 1.371255 1.322663 1.809504 1.204624 1.360516 1.560017 0.728786 1.198141 0.205090 1.160044 0.123788 1.055389 0.000606 1.053192 1.151477 1.373542 1.265186 1.724798 1.886742 0.005357 0.765937 0.357094 1.883191 1.413956 0.425519 1.541890 0.228828 0.444569 1.731242 0.758135 1.694845 0.235575 1.375622 0.966774 0.064210 1.818181 1.701152 0.939885 0.869690 1.721261 0.903745 0.572776 1.613709 1.429967 -0.204365 -0.159847 1.411098 1.849827 1.332361 0.123284 0.471584 0.124263 1.548507 0.037436 1.450427 1.608213 0.751526 1.251800 0.449356 0.995685 0.168581 0.578596 -0.008301 -0.108588 -0.051841 1.255443 1.717525 0.066269 0.462219 0.617376 0.732084 0.457786 1.648457 0.084351 1.425839 1.132695 1.075568 0.426124 1.683785 -0.026802 0.659449 1.976438 0.327653 0.176478 1.519385 0.950918 1.117125 0.681302 1.220378 1.564197 1.081199 0.035168 0.774191 1.423020 0.542872 1.005906 0.925064 1.222361 0.709077 1.232009 0.175848 1.766418 0.768157 1.120193 0.595285 1.601960 1.422274 0.916402 1.448116 0.640237 0.643692 0.251324 0.741667 -0.143977 1.397369 1.463541 0.154011 1.310131 0.932001 0.753147 0.647945 1.983809 0.331356 0.039426 0.675089 1.044512 1.749427 0.466421 1.329106 0.614988 0.427666 1.438464 1.323273 0.710947 0.849134 0.666531 1.817634 0.140362 1.325895 0.771077 0.075639 0.215751 1.234804 1.390106 1.182646 1.003854 0.013770 1.827076 1.287194 0.957362 0.727601 1.710334 0.146925 1.363164 1.235333 1.207632 1.759338 0.000776 0.001067 1.292928 1.073254 1.890373 0.606827 0.181623 1.422096 1.818391 0.491047 0.947882 1.522891 0.622651 0.231882 0.552506 -0.214757 -0.053201 0.304820 1.072877 1.169681 1.901575 -0.092557 1.464238 0.530517 0.760214 0.184567 0.354900 0.763822 0.875569 0.244640 1.314029 0.587594 1.619930 0.698392 -0.181363 0.024190 0.931927 1.045769 0.079044 0.719967 0.551470 0.460989 1.721308 1.512101 0.729903 0.832498 0.501992 1.146729 1.023131 1.011971 0.564333 1.875893 0.486515 0.918728 1.673893 1.790532 1.544474 0.647989 1.273184 1.130883 0.440570 1.323044 0.382668 1.042155 1.285675 0.211456 0.502048 1.189816 0.534034 1.407641 1.396625 1.348606 0.205338 0.169613 -0.251785 1.520873 0.112457 1.155081 1.283677 1.090786 1.526686 -0.115764 0.068967 0.239760 0.596159 0.948975 0.049865 1.012595 1.804858 1.292393 1.484553 0.425388 0.321439 0.063327 1.428852 0.582776 0.833098 1.051708 0.774444 1.876183 1.535729 1.461779 1.473666 0.303086 0.720744 0.374541 0.755229 -0.055643 0.188433 0.498668 1.597273 0.766659 1.321301 1.495768 0.819036 1.138608 1.159473 0.761863 0.670979 -0.098153 0.448910 0.939632 0.922536 1.106894 0.720136 0.429535 0.121384 1.794329 0.127746 1.172651 0.399136 0.133453 -0.165391 1.916043 0.540311 0.212827 0.683252 1.623311 1.138221 1.630690 0.756739 1.664517 -0.028629 0.616701 -0.155817 1.562563 0.655621 0.469385 0.284323 0.346021 1.210168 0.185069 1.861215 0.681268 1.510357 0.613663 0.376371 1.912091 0.054078 0.489070 1.286420 0.425791 0.742853 0.578076 0.160000 0.163093 1.019223 1.661548 1.024647 1.576844 1.595196 0.752288 0.366969 0.867927 0.361642 1.395106 -0.034080 1.835172 1.691725 1.801541 0.654914 -0.041273 0.328990 1.768449 0.795101 0.997312 1.195282 0.781554 1.151484 1.191750 0.477387 0.553091 0.366634 1.426276 0.923195 0.519343 1.370423 1.105417 0.254981 -0.021406 0.870643 1.281654 1.699929 1.096017 0.153801 0.813486 0.155964 0.167265 0.906116 1.600814 1.546916 1.009804 0.580677 1.831690 0.621781 0.269422 0.068023 0.375118 0.392483 0.645346 0.726257 1.866670 1.438871 1.819957 1.876558 0.805047 0.268251 1.873954 0.724392 1.724914 0.061731 1.758237 0.049363 1.338298 1.592725 0.110822 0.070554 1.080204 1.660994 0.323601 0.066554 0.935522 0.625000 0.948577 1.536436 1.569960 1.250499 0.840977 0.618873 0.326876 0.016957 0.553092 1.742929 0.033075 0.705283 1.317553 0.857354 1.570911 0.666923 0.699337 1.072114 1.490230 1.152199 1.457229 1.446920 0.535560 0.840597 1.553697 1.432581 1.225356 0.983635 1.341505 0.184996 0.542601 0.591029 1.546770 0.354289 1.474863 0.800221 0.842475 1.758179 0.637846 0.778074 1.479088 1.621038 0.384223 1.279410 1.604567 1.299460 0.212084 0.922044 0.089352 0.048483 0.818589 1.426555 0.418824 1.005097 1.686282 0.134313 1.851577 -0.066031 1.100005 1.405115 0.347333 1.397633 1.437795 1.651533 -0.238059 1.032263 1.804189 1.525625 1.200245 0.325330 1.630091 0.183877 1.134113 0.039761 1.489778 0.963327 1.587820 0.343193 1.487904 1.560897 0.506776 -0.028556 1.639374 0.489331 -0.120847 1.486097 1.113385 0.818559 1.458254 0.379312 0.103127 1.764014 0.045134 1.857665 0.074990 1.252619 0.764720 0.274340 1.041679 0.736801 1.109047 0.633472 0.616452 0.701812 0.259074 1.220492 0.990225 1.469215 1.122294 1.691573 1.007128 1.914729 1.046027 0.960188 1.052492 1.263789 0.256791 1.082266 1.564876 0.767580 1.665671 1.120116 1.476337 1.656355 1.697957 1.779212 1.899439 0.704596 0.478737 0.639105 0.056120 0.934412 1.562426 0.295572 1.797791 0.012179 0.859778 0.373190 1.413334 0.662523 1.795260 0.540434 1.550712 0.295331 0.789514 1.104423 1.606744 1.027104 0.104342 0.714491 1.258853 1.087852 0.605032 0.317064 1.553622 1.415202 0.270208 1.144114 1.311076 0.793202 0.032702 1.383318 1.158686 0.646710 1.115656 0.964201 0.942657 0.799390 1.486686 1.086567 1.038546 0.055309 0.741162 0.086784 1.038227 0.094432 0.207456 0.626876 1.517393 0.127161 1.068240 1.442156 0.273590 1.284737 0.477934 0.473085 1.942640 0.062778 0.243140 1.632289 0.511216 0.151255 1.197956 0.776004 1.112350 1.385013 1.196290 1.658894 0.897830 1.458073 1.581040 1.354446 0.335038 1.160037 1.586889 0.653957 0.295992 1.385754 0.095788 1.319550 0.425803 1.460134 1.078479 1.125803 0.932132 0.667512 0.629981 1.087063 1.449613 1.075382 1.088690 1.239380 1.305439 0.869954 0.692212 1.065130 1.219586 1.111215 0.089192 0.836221 1.138355 1.945019 0.296229 1.186500 0.342130 1.232618 1.710282 1.986021 0.950320 0.495020 1.401488 0.976052 0.679239 1.853418 1.720813 0.223308 1.389019 0.941208 1.661414 -0.012657 1.283710 1.487429 0.823783 1.360182 0.177313 1.052477 0.432488 1.199655 1.143938 1.514324 0.877808 0.650891 1.043137 0.325729 1.299690 0.729208 1.021757 1.526267 1.469028 1.081560 0.071050 1.202749 0.374817 1.153580 0.568680 0.162383 0.505291 1.851347 1.412587 0.819201 0.097817 1.973576 1.568679 0.224658 0.601107 0.842611 1.040590 0.035672 1.474388 1.543181 1.448033 1.083332 0.228181 0.052902 1.797137 1.310910 0.495990 0.383665 -0.086138 -0.094189 0.729327 0.051485 0.669810 1.073596 1.313582 0.939163 1.082077 1.201117 0.624420 1.824142 1.492310 1.257313 1.701444 0.479923 1.983507 0.832439 0.912729 1.762346 1.715092 1.655982 0.954559 0.613332 0.692469 0.537613 0.286034 0.515639 1.488961 1.861358 1.127184 0.251114 1.847182 1.445373 0.313099 0.422195 1.034094 1.024292 0.412421 0.159320 1.310858 0.899619 0.476523 0.769707 0.878341 0.305843 1.276970 1.032700 1.009946 -0.069853 0.146832 0.911001 1.250154 0.454603 1.761483 1.726389 1.474818 0.733881 0.147590 0.552453 1.912088 1.004706 -0.102653 1.473088 1.468754 1.772940 1.879832 0.971078 1.615059 -0.115166 1.739167 -0.002023 1.569220 0.180507 0.198087 -0.134233 1.275981 1.606464 0.714902 1.304672 1.105521 1.240017 1.535617 0.319181 0.918684 1.743778 1.558601 0.338631 0.399170 1.432489 0.112576 1.886436 1.562142 -0.024108 0.598197 1.036296 0.588486 1.319704 1.523359 0.543659 1.195335 0.601039 0.764233 -0.077083 1.501171 1.695061 1.321697 0.695092 1.633198 1.883887 -0.024737 1.279944 0.414434 1.631632 0.643374 0.610497 1.355265 1.307675 0.326636 1.389259 0.191833 1.021876 0.187621 0.456069 0.228919 0.379028 0.760297 0.757632 1.142513 1.537731 0.600440 0.265685 0.932773 0.913509 -0.200060 1.377976 0.439405 0.217117 -0.073503 0.501370 1.122413 0.175827 1.246033 0.387894 0.404290 0.320875 0.196271 1.008346 1.119913 1.655881 0.396755 1.492684 0.480400 1.842793 1.443282 1.395858 0.970655 -0.009975 1.414204 0.202723 0.188203 1.777759 1.363710 1.432199 1.159443 0.976227 1.255006 0.908198 1.620066 1.916071 0.097593 0.328901 0.067608 1.004743 0.585298 0.074380 1.595189 0.660523 0.338864 0.091261 0.239667 0.326231 1.482832 0.921071 0.891452 0.254766 0.039582 0.785938 1.873909 0.002978 1.347910 1.051314 0.067288 1.386345 1.757919 1.171580 0.783862 0.439741 0.461515 0.485647 0.029094 1.573455 1.246301 0.201551 1.942214 1.416732 1.928033 1.928840 0.187017 0.076688 1.436638 0.591098 0.845717 1.050410 0.618795 0.979503 1.596239 1.753497 1.295340 1.598782 0.868787 1.904322 0.873015 1.151254 0.528900 1.177379 1.799925 1.343422 1.550074 0.821416 0.379389 0.852728 1.309077 1.893498 1.650137 0.204429 0.016089 0.580561 0.094042 0.138503 1.120888 1.190249 1.402953 0.818838 0.843544 0.476039 0.818557 0.772026 0.020762 0.591849 0.714850 1.168245 1.799409 0.865955 0.677000 0.821752 1.056095 1.142529 0.087996 1.850212 0.780206 0.458059 0.696792 1.149724 0.994532 0.671757 1.707878 0.385934 0.870416 1.459651 0.659678 0.327530 0.458572 0.008146 1.512192 0.567770 1.870562 1.527804 0.578037 1.856490 0.141902 1.231135 1.392547 0.270148 1.068155 0.023390 1.159102 1.362068 0.727755 0.094182 1.064016 0.337791 0.117156 0.539198 1.211991 1.451911 1.021603 0.491286 0.293551 0.371801 0.284474 1.165006 0.137262 1.479375 0.287365 1.459300 0.281980 1.904086 0.734313 1.195385 0.046091 1.557977 0.728796 1.301848 1.743558 1.143585 0.788219 0.759209 0.509926 1.796707 1.368720 1.286657 -0.062087 1.526534 0.878678 1.812008 0.707789 1.190134 1.514280 0.047575 0.563531 1.543542 1.606308 0.151694 0.109509 0.499422 0.889672 1.652796 0.102759 0.908231 1.742743 0.834000 1.428919 1.525945 1.008232 1.505940 1.858825 1.750446 0.845554 0.601147 0.827081 0.205832 0.080833 0.713952 0.249859 1.423129 1.619076 1.700349 1.685235 0.921690 1.168774 1.615059 1.444049 0.221349 0.217084 0.482003 1.021496 0.841911 1.021914 0.196904 1.665027 0.166506 0.224034 1.413453 0.832441 0.056767 1.534361 0.614422 1.632902 0.682076 1.866906 1.771477 0.565935 0.574907 1.191693 1.039149 0.897034 0.292820 -0.048727 1.767884 0.476460 1.607964 1.541032 1.623282 1.078563 0.872967 1.848588 0.042590 1.339678 0.165623 1.272406 0.620460 0.369626 -0.112649 -0.088659 1.856203 1.143713 1.093267 1.746104 0.489089 0.717101 0.225880 1.043382 0.622450 -0.150497 0.983630 1.751518 0.266414 0.637518 1.279067 -0.031861 1.724106 0.109340 -0.116276 -0.047884 0.319897 0.670495 1.078008 0.639371 0.801576 1.083869 1.621119 0.889823 0.930122 1.575123 1.867559 1.029674 1.465560 0.117367 0.627982 0.487635 1.663071 0.771107 0.222146 -0.127571 1.150692 0.991701 0.025807 1.042588 1.542589 1.071272 1.225186 1.833225 0.975210 -0.077186 1.418656 0.429973 0.228562 -0.160882 0.348927 1.284798 0.070139 0.131564 0.294090 0.449645 1.260139 1.853688 0.464997 0.105448 1.130884 0.859086 1.143562 0.174115 0.101670 1.754841 1.093365 0.158871 0.155271 0.223536 1.562860 0.135431 1.828754 0.380708 1.121628 0.085322 1.573346 0.967432 1.891542 1.702359 1.257171 0.533161 1.255176 1.375597 -0.078684 0.881799 1.250021 0.435607 0.160869 0.258410 0.812452 0.253444 1.792255 1.074924 0.220601 0.029721 0.477966 -0.078696 1.023634 0.204468 0.016608 0.246772 1.341919 1.384069 0.744538 1.364802 0.518863 1.650722 0.993983 1.267762 0.034870 0.414694 1.899845 -0.010726 1.463904 1.575453 0.231887 0.544576 1.033090 0.085019 0.507967 0.772132 0.877929 0.404390 -1.948076 0.632160 1.440882 1.300264 1.433784 0.066197 1.347971 0.473919 0.663321 0.627873 1.468796 0.811124 1.215371 1.558794 1.086172 1.257824 0.856167 0.458127 1.283692 0.630254 1.346541 0.003750 1.487384 0.642198 0.552044 0.252638 0.693926 1.283405 0.336547 0.178117 1.701054 0.198419 0.879596 0.339342 0.872446 1.977245 1.711070 1.473033 1.907844 1.030056 0.003757 0.217575 1.155605 1.430836 0.912025 0.685322 1.695148 -0.093333 0.650928 1.540781 0.033695 0.899947 1.056397 0.888523 0.797001 0.574074 0.714735 0.595830 0.346684 0.317866 0.409902 1.946172 0.977527 0.967141 0.849284 0.067462 1.230601 1.513986 0.866081 0.160429 0.826036 0.465825 0.975601 0.812619 1.565109 1.422901 1.573749 1.812609 0.821048 0.748877)
       )
))



;;; ---------------------------------------- prime-numbered harmonics (and 1st) ----------------------------------------

(define primoid-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.76  #(0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
#(3  2.1949384212494 #(0 0 1)
     1.980 #(0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 #(0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 #(0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
#(4  2.5978584289551 #(0 0 1 1)
     2.194 #(0 177/176 38/27 34/19)
     
     ;2.2039985204158 #(0 0 12 4) / 20
     2.1930510997772 #(0.000 0.996 0.596 0.217)
     2.1930510997772 #(0.000 1.996 0.596 0.217)
     2.1930510997772 #(0.000 0.004 1.404 1.783)

     2.1927945613861 #(0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 #(0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 #(0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
#(5  2.7172040939331 #(0 0 1 0 0)
     2.492 #(0 13/30 39/25 19/29 13/15)
     2.5134075548154 #(0 11/8 3/2 1/2 11/16)

     2.476848 #(0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 #(0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
#(6  3.1241359710693 #(0 0 0 1 0 0)

     2.842 #(0 80/57 27/14 17/20 61/60 47/44)
     2.9283351754192 #(0 1/2 0 1 1 1)

     2.805574 #(0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 #(0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     )

;;; 7 prime --------------------------------------------------------------------------------
#(7  3.5358893688327 #(0 0 0 0 0 1 0)
     3.4886319637299 #(0 1 1 0 0 0 0)

     3.145 #(0 37/21 2/21 109/67 183/103 8/55 27/22)
     3.1492093077352 #(0 0 1/2 0 1/2 1 1/2)

     3.061912 #(0.000000 0.714759 0.260578 0.166208 0.059602 1.174495 0.323635)
     3.061861 #(0.000000 0.715739 0.261422 0.169339 0.062479 1.180650 0.330190)
     )

;;; 8 prime --------------------------------------------------------------------------------
#(8  3.8668605608975 #(0 1 0 1 1 1 0 0)
     3.7088719446694 #(0 1 0 0 0 0 1 0)
     3.7088720798492 #(0 0 0 0 0 0 1 0)

     3.425 #(0 167/94 1/38 3/8 4/31 103/54 26/29 7/22)

     3.263480 #(0.000000 1.792783 -0.032826 0.250009 -0.061235 1.659318 0.603596 -0.057373)
     3.263115 #(0.000000 0.207652 0.035023 1.752163 0.064249 0.346105 1.403170 0.065734)
     3.263026 #(0.000000 0.792560 -0.034573 0.248474 1.936538 1.655196 0.598263 1.936131)
     3.262977 #(0.000000 0.792550 1.965637 0.248661 1.936840 1.655647 0.598935 1.936915)
     )

;;; 9 prime --------------------------------------------------------------------------------
#(9  4.0320072303689 #(0 1 1 0 1 0 0 0 0)
     3.915482117267 #(0 1 0 1 1 1 0 0 0)
     3.9154822826385 #(0 0 0 1 1 1 0 0 0)

     3.382645 #(0.000000 0.562589 0.520940 1.521127 1.682374 0.721497 0.805534 1.254209 0.726847)
     3.382399 #(0.000000 1.437745 1.479554 0.480268 0.319088 1.280870 1.197460 0.749784 1.277141)
     )

;;; 10 prime --------------------------------------------------------------------------------
#(10 4.1794095733027 #(0 0 1 0 0 1 1 1 1 1)
     4.1718228801521 #(0 0 0 0 0 1 0 0 1 0)
     4.1209712028503 #(0 0 1 0 0 0 1 0 0 0)

     3.602714 #(0.000000 0.594153 1.304664 1.610566 1.241680 0.148124 1.920208 0.972526 1.622030 0.768137)
     3.602602 #(0.000000 1.405079 0.694565 0.388252 0.756491 1.849937 0.076683 1.023761 0.374165 1.226329)
     3.602329 #(0.000000 0.594431 1.305346 1.611464 1.243212 0.149889 1.922392 0.975619 1.625276 0.772405)
     )

;;; 11 prime --------------------------------------------------------------------------------
#(11 4.56653492525 #(0 0 1 0 1 1 1 0 0 0 0)
     4.487418596136 #(0 0 0 0 0 0 1 1 0 1 1)
     4.4176635742188 #(0 0 1 0 0 0 0 0 0 1 0)

     3.779310 #(0.000000 0.795034 0.550625 0.191200 0.209037 0.086985 0.729229 1.230323 0.721250 -0.058459 1.262582)
     3.779046 #(0.000000 0.211414 1.453486 1.827574 1.811694 1.949216 1.313595 0.823256 1.334141 0.127849 0.824659)
     )

;;; 12 prime --------------------------------------------------------------------------------
#(12 4.7299025085604 #(0 0 1 0 1 1 1 1 0 1 0 0)
     4.6850221453825 #(0 0 1 0 1 0 1 1 1 0 0 0)
     4.3595271110535 #(0 0 0 0 0 0 1 0 1 1 0 1)

     3.936657 #(0.000000 0.367346 0.997085 1.763425 1.295636 0.140826 0.757652 1.565853 1.284651 0.304758 0.331248 0.325474)
     )

;;; 13 prime --------------------------------------------------------------------------------
#(13 5.06212613641 #(0 1 0 0 1 0 1 0 1 1 0 0 0)
     4.9963458682976 #(0 1 0 0 1 1 1 1 1 1 1 0 1)
     4.9494566649932 #(0 1 0 0 1 1 0 0 0 0 1 1 1)
     4.8980793952942 #(0 0 0 1 0 0 1 1 1 1 1 1 0)
     4.650 #(0 29/28 39/25 2/33 28/139 47/28 23/15 113/94 58/31 401/229 93/65 27/107 18/17)

     4.180492 #(0.000000 1.772215 1.337771 1.572723 0.985677 1.717413 1.821689 0.986759 1.151868 0.637061 0.595788 1.561353 1.695959)
     4.155503 #(0.000000 1.115751 0.463368 0.110540 0.613302 1.581997 1.394002 -0.005270 1.724217 0.023531 1.743892 0.616897 0.124222)
     4.155447 #(0.000000 0.888617 1.517807 -0.126164 1.379365 0.386974 0.577265 -0.035993 0.235237 1.925386 0.197791 1.315578 1.792037)
     
     4.155397 #(0.000000 0.889095 1.516866 -0.126190 1.379921 0.387624 0.577311 -0.035814 0.235894 1.925264 0.197860 1.315963 1.792333)
     )

;;; 14 prime --------------------------------------------------------------------------------
#(14 4.827317237854 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.328845 #(0.000000 1.631608 0.105786 1.732589 0.749692 0.105117 0.626364 1.395811 1.430614 0.705052 0.780338 1.582470 1.046721 0.950090)
     4.326976 #(0.000000 0.364582 1.890353 0.257084 1.236968 1.870081 1.347397 0.568508 0.530480 1.244349 1.158504 0.351458 0.874868 0.961576)
     )

;;; 15 prime --------------------------------------------------------------------------------
#(15 5.2087744996197 #(0 0 0 0 1 0 0 0 1 1 1 0 1 1 1)
     5.1680134390775 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 1)
     5.116711139679 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.482073 #(0.000000 0.430607 1.010272 0.810816 1.103409 1.274070 0.728190 1.576850 0.465054 1.582164 0.985518 1.441214 0.149277 1.211260 1.202522)
     4.468487 #(0.000000 -0.170894 1.166594 0.261941 0.795313 -0.037553 0.002464 1.693993 1.753074 1.644706 -0.070294 0.671844 1.070595 0.053777 -0.250027)
     4.468456 #(0.000000 1.163642 0.822265 1.719160 1.174671 -0.001630 -0.050625 0.246910 0.168123 0.266790 -0.043714 1.191768 0.791421 1.787408 0.068509)

     4.468227 #(0.000000 1.163360 0.821825 1.719236 1.176172 -0.001579 -0.049058 0.246791 0.169303 0.265483 -0.043935 1.191333 0.791982 1.786817 0.068461)
     )

;;; 16 prime --------------------------------------------------------------------------------
#(16 5.3690811579971 #(0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1)
     5.2829658956774 #(0 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0)
     5.2015118598938 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.662724 #(0.000000 0.254861 1.684311 0.497899 0.656871 1.722503 0.329340 1.047910 0.635053 1.158523 0.448629 0.050078 1.573549 1.470622 1.991728 1.975781)
     4.607704 #(0.000000 0.863393 1.574552 1.705278 1.569228 0.102457 0.353917 0.651931 1.696462 1.761383 0.072955 1.294632 -0.307040 1.072928 1.543936 0.777891)
     4.606477 #(0.000000 0.063715 0.365372 0.117043 0.193143 1.512895 1.195495 0.797456 1.646578 1.458347 0.946115 1.646531 1.022197 1.509568 1.014563 1.618704)

     4.605936 #(0.000000 0.062783 0.365100 0.116854 0.191641 1.514695 1.196399 0.797535 1.646767 1.458340 0.947574 1.647179 1.022766 1.510456 1.014996 1.620517)
     4.603563 #(0.000000 0.058279 0.360249 0.118870 0.188733 1.520196 1.197587 0.796110 1.647952 1.455743 0.954899 1.650113 1.028040 1.516864 1.018349 1.626281)
     )

;;; 17 prime --------------------------------------------------------------------------------
#(17 5.6171013426079 #(0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1)
     5.5776449751108 #(0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1)
     5.5725093120778 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0)
     5.5318970680237 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.732840 #(0.000000 1.594259 1.537383 1.654009 0.059827 1.456178 1.640619 0.725632 -0.052840 0.741210 1.485914 1.399005 0.596215 1.791931 0.887057 0.720499 0.037113)
     4.722267 #(0.000000 0.745012 1.746720 1.857322 0.395619 0.089137 0.377160 1.693046 1.022690 0.006860 1.068984 1.241035 0.656572 0.031366 1.331142 1.361315 0.976051)

     4.721823 #(0.000000 0.743855 1.746189 1.857446 0.396581 0.088714 0.378562 1.692782 1.022551 0.007089 1.069256 1.241125 0.656507 0.031115 1.331252 1.360795 0.977429)
     4.720335 #(0.000000 0.741764 1.745798 1.858232 0.394387 0.086105 0.379819 1.692029 1.022315 0.008990 1.069411 1.241786 0.653220 0.028583 1.334535 1.358902 0.976814)
     )

;;; 18 prime --------------------------------------------------------------------------------
#(18 5.6380511040237 #(0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0)
     5.518 #(0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.881625 #(0.000000 1.688958 1.279188 1.177293 -0.318361 0.802007 0.250184 -0.270074 -0.003800 1.870180 1.633808 0.442468 -0.114869 0.906870 1.252354 1.245762 -0.107436 0.786324)
     4.873983 #(0.000000 1.294215 0.677028 0.767080 0.216703 1.053732 1.558920 0.021622 1.718601 1.799683 -0.043454 1.131408 1.619627 0.529888 0.161043 0.076136 1.380515 0.372909)
     4.861048 #(0.000000 0.759594 1.400352 1.380791 -0.021867 1.257810 0.804917 0.457473 0.843250 0.862198 0.848370 1.729218 1.383618 0.634141 1.026759 1.274916 0.088715 1.295112)

     4.860375 #(0.000000 0.758984 1.399757 1.380903 -0.022289 1.257398 0.804273 0.457932 0.842771 0.862126 0.848667 1.730206 1.384282 0.633731 1.027661 1.274988 0.089709 1.295851)
     4.857460 #(0.000000 0.760733 1.399738 1.384312 -0.023901 1.256074 0.802674 0.456628 0.836375 0.859214 0.851397 1.732270 1.392917 0.637205 1.030677 1.267425 0.093843 1.291693)
     )

;;; 19 prime --------------------------------------------------------------------------------
#(19 5.9841752522819 #(0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0)
     5.707 #(0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)
     5.7069295560724 #(0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     5.050598 #(0.000000 0.718637 1.798883 1.579536 0.015456 1.806520 0.208708 1.353434 1.112089 1.766036 0.720549 1.107314 0.509279 -0.117956 1.148417 0.726527 0.254889 1.769009 0.642150)
     5.021091 #(0.000000 1.619333 1.632600 1.311158 1.621931 1.174349 1.448853 0.362928 -0.088824 0.458062 0.974263 1.262388 0.348296 1.476078 0.556767 0.005450 1.132051 0.282051 1.020436)
     5.017269 #(0.000000 1.615189 1.624600 1.310534 1.621918 1.182157 1.449569 0.369086 -0.084792 0.459555 0.978427 1.263962 0.347956 1.473899 0.566448 0.004230 1.129771 0.283684 1.025677)
     )

;;; 20 prime --------------------------------------------------------------------------------
#(20 5.9970674135126 #(0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1)
     5.9696664680177 #(0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     5.931 #(0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0)
     5.8879864574703 #(0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.219761 #(0.000000 1.154818 1.816853 1.891880 -0.032202 0.197019 1.018732 1.639212 0.953425 0.695031 0.577021 1.061687 0.455312 0.907081 0.481515 1.400124 0.806615 1.262883 0.187894 1.041939)
     5.214980 #(0.000000 0.840843 0.870934 -1.936784 0.124790 0.037596 1.842854 1.506881 0.243469 1.454635 0.781572 1.020004 -0.209275 1.345639 1.356003 1.554666 0.375592 1.561439 1.206468 1.818047)
     5.195592 #(0.000000 1.308286 0.836717 0.721652 0.014336 1.269342 1.770967 0.018944 1.620000 0.391358 0.060240 1.245410 0.211221 0.564481 1.999654 0.758548 1.620945 0.639625 1.010870 0.092874)
     5.191776 #(0.000000 1.304053 0.834086 0.729580 0.020033 1.269830 1.771149 0.008816 1.613452 0.393606 0.060535 1.247418 0.223146 0.557325 0.007610 0.755009 1.618223 0.629304 1.012960 0.083475)
     )

;;; 21 prime --------------------------------------------------------------------------------
#(21 6.1566464314438 #(0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0)
     6.1375694270894 #(0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0)
     6.1138607493652 #(0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.486939 #(0.000000 1.054487 0.664992 0.221211 0.326872 1.588195 1.592726 1.336003 -0.011408 0.242484 1.885446 1.030420 0.900483 1.377784 1.752653 1.724134 1.420616 1.866623 1.449894 1.955882 0.634259)
     5.364729 #(0.000000 0.126645 0.205400 0.493396 1.819656 0.793652 0.531707 0.451172 -0.086061 0.428806 1.709444 1.530708 0.012548 0.546834 0.923593 0.972076 0.905563 1.194666 0.049961 1.147910 1.708241)
     5.350241 #(0.000000 0.135627 0.209129 0.486013 1.823739 0.799888 0.529447 0.448581 -0.074800 0.435949 1.711871 1.519432 0.006798 0.559492 0.905602 0.974049 0.909432 1.209651 0.045420 1.145955 1.721134)
     )

;;; 22 prime --------------------------------------------------------------------------------
#(22 6.389194775669 #(0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1)
     6.3868380259357 #(0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1)
     6.33751039349071 #(0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)
     6.3374844973589 #(0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.508496 #(0.000000 1.554868 1.261041 1.228936 0.711722 0.501029 0.621002 1.942233 0.506831 0.465521 0.558205 0.278591 1.040235 0.094908 0.869978 -0.081825 1.044210 1.751433 1.433134 0.293388 0.957115 1.634297)
     5.481313 #(0.000000 1.526342 1.256451 1.198981 0.714321 0.494762 0.639483 1.931115 0.504494 0.469001 0.568616 0.286258 1.044659 0.083908 0.869021 -0.080230 1.035514 1.762909 1.435139 0.299975 0.958202 1.638702)
     5.471307 #(0.000000 1.515121 1.259203 1.191078 0.705493 0.502933 0.649117 1.930320 0.486105 0.475368 0.585449 0.283100 1.047369 0.089192 0.864052 -0.079225 1.038793 1.773949 1.432236 0.302611 0.966283 1.631998)
     )

;;; 23 prime --------------------------------------------------------------------------------
#(23 6.540168762207 #(0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1)
     6.5358400344849 #(0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1)
     6.5309901747782 #(0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.685285 #(0.000000 0.254600 -0.012994 0.113546 0.539539 1.037398 1.757854 1.055458 0.272297 -0.046061 0.094856 0.510270 0.402511 -1.992644 1.761629 0.351312 0.348956 1.246604 0.787427 1.083729 1.586582 0.611927 0.184053)
     5.624319 #(0.000000 0.111340 0.718028 0.223542 1.146734 1.272778 0.293503 0.944368 0.616128 1.612738 0.413214 0.453242 0.182667 0.460745 0.409053 0.607774 1.238915 1.551280 0.588763 0.165014 1.035923 1.463808 1.485878)
     5.620354 #(0.000000 0.117997 0.708610 0.228851 1.149295 1.276123 0.290952 0.945834 0.609919 1.611171 0.415218 0.454302 0.181258 0.458880 0.395016 0.611309 1.239117 1.552809 0.590981 0.161246 1.037321 1.465866 1.486062)
     )

;;; 24 prime --------------------------------------------------------------------------------
#(24 6.6087727546692 #(0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0)
     6.5951228141785 #(0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     6.5623834870329 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.949920 #(0.000000 0.128611 0.694957 0.658206 0.886509 0.768948 1.233345 -0.189112 1.759586 0.197333 1.393597 1.021426 0.619470 0.959617 0.232166 0.499447 1.419100 0.526324 0.173261 0.228559 1.292462 0.139965 0.391749 1.913935)
     5.713005 #(0.000000 0.906076 1.837577 1.208891 1.231380 0.500589 -0.081845 -0.290081 1.733614 1.438418 0.350697 1.657899 -0.225835 1.063682 1.800005 1.417046 1.288216 0.451237 0.858447 0.189950 0.290432 0.722411 1.224710 1.469471)
     5.665525 #(0.000000 0.898041 1.824693 1.202797 1.212468 0.497469 -0.114979 -0.258514 1.754040 1.426218 0.311486 1.652943 -0.270641 1.054523 1.825010 1.402802 1.291879 0.451230 0.867557 0.167813 0.285420 0.748149 1.225765 1.464488)
     )

;;; 25 prime --------------------------------------------------------------------------------
#(25 6.84773846418216 #(0 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0)
     6.8138422966003 #(0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1 1 1 1)
     6.6733964421745 #(0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0)
     6.635721206665 #(0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.988895 #(0.000000 0.958244 1.345633 0.953582 0.394970 1.901749 1.046106 1.586016 1.673907 1.504535 0.855726 1.185762 0.711920 0.273710 0.138584 1.350736 -0.012172 1.001100 -0.022766 1.615113 1.538010 -0.061672 0.033456 -0.153052 0.855356)
     5.929625 #(0.000000 0.560320 1.421714 1.301451 1.598466 0.354996 0.019090 1.111634 1.211711 0.212102 1.525555 0.365810 0.082554 1.521220 -0.261960 1.082739 1.506918 1.061178 1.821977 0.383824 1.717752 0.818966 1.432949 0.533424 0.536656)
     5.921707 #(0.000000 0.561128 1.422129 1.288359 1.598038 0.352917 0.032596 1.100373 1.220188 0.222201 1.528108 0.364694 0.070690 1.512349 -0.271359 1.080088 1.502830 1.057859 1.813653 0.381762 1.699723 0.815937 1.422647 0.546858 0.545714)
     )

;;; 26 prime --------------------------------------------------------------------------------
#(26 6.9502968788147 #(0 1 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1)
     6.9264550209045 #(0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.9264546836564 #(0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.8401503562927 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.114195 #(0.000000 0.487946 1.509453 0.656427 -0.061099 1.024534 1.764200 0.719985 0.845113 1.416156 0.999041 1.502717 1.217362 0.470360 0.781338 0.378324 1.225888 1.318663 1.531597 0.037759 1.356653 1.047908 -0.226597 0.213201 0.995851 0.546112)
     6.074530 #(0.000000 1.943057 1.974964 0.423204 0.990989 0.826039 -0.012086 1.652156 0.214423 0.118240 1.353424 0.391258 0.284181 0.188910 -0.169487 1.727524 -0.096788 0.333269 1.304541 0.718448 0.601774 0.390976 0.594076 1.101120 1.773566 0.196210)
     )

;;; 27 prime --------------------------------------------------------------------------------
#(27 7.0658421516418 #(0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0)
     6.9657588005066 #(0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1)
     6.949148677349 #(0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)
     6.9491486549377 #(0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.306082 #(0.000000 1.014487 0.044686 1.244051 0.504595 0.487037 0.595344 0.942363 1.421788 1.271617 1.672410 0.919810 -0.088188 -0.004921 0.389662 1.276380 1.315062 0.969929 1.267761 0.826017 0.908595 0.237755 0.772601 0.772305 0.470772 1.354427 0.868884)
     6.250703 #(0.000000 1.417695 0.379863 0.574075 0.026310 1.854097 1.799270 1.048756 0.017719 1.590423 0.709941 1.873537 1.208517 0.024528 0.975026 0.008370 1.420162 0.290841 0.325800 1.168479 1.245685 1.563863 -0.217899 1.934168 1.859690 1.621341 0.313314)
     )

;;; 28 prime --------------------------------------------------------------------------------
#(28 7.2303333282471 #(0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0)
     7.2299618721008 #(0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     7.2240290641785 #(0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1)
     7.1576952692751 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)
     7.1576952934265 #(0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.266481 #(0.000000 0.464977 0.954351 0.843190 1.125317 0.010507 1.072665 0.506420 0.334117 -0.002274 0.804342 1.777515 0.702462 1.533180 1.276804 0.055155 0.922788 0.985869 0.597230 0.416958 0.876178 1.168420 0.578974 1.494226 1.590875 0.468961 1.546102 0.116359)
     )

;;; 29 prime --------------------------------------------------------------------------------
#(29 7.2895045280457 #(0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     7.24235304747816 #(0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)
     7.2415904369233 #(0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.436508 #(0.000000 0.959665 0.070142 1.613727 0.570027 0.616169 1.479500 1.067280 -0.043135 0.088604 1.767056 1.562744 1.044755 1.611902 -0.049034 0.923286 1.476347 1.274732 0.064816 -0.008450 0.585605 0.472018 0.570671 1.306333 1.107434 1.186437 0.932748 0.765902 0.489942)
     )

;;; 30 prime --------------------------------------------------------------------------------
#(30 7.5369029045105 #(0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0)
     7.5239403940776 #(0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1)
     7.5096759796143 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1)
     7.4977698326111 #(0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1)
     7.1189651489258 #(0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.658580 #(0.000000 1.477513 0.548175 1.347892 0.733820 0.121555 -0.032344 0.713938 0.819135 1.370527 1.738632 0.698418 0.364253 0.441036 -0.035716 0.516534 0.740702 0.984618 1.142869 0.406938 1.301988 0.810169 0.504070 1.569824 0.496394 0.536230 1.606405 0.027724 1.473284 1.742612)
     6.468710 #(0.000000 1.680776 0.826899 0.932817 0.846474 1.688126 1.301582 1.469487 1.223335 1.896950 0.951231 1.784064 1.941924 1.374093 0.106784 0.089904 1.256719 1.559531 0.403622 0.363629 1.577609 0.977925 0.034372 0.880337 1.659463 1.658654 1.057897 1.350247 0.616124 0.852509)
     )

;;; 31 prime --------------------------------------------------------------------------------
#(31 7.5859903003103 #(0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1)
     7.5834159851074 #(0 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0)
     7.5718903541565 #(0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1)
     7.4906754493713 #(0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.754243 #(0.000000 0.758454 0.750304 0.747571 1.376074 0.589849 0.377034 1.102662 1.662809 0.839547 1.508248 1.126251 1.672003 1.346432 0.641709 1.803564 1.248769 0.898642 0.284303 0.999928 0.751064 0.745306 0.090089 1.349771 1.823758 0.877530 0.670997 1.068561 0.919734 1.833873 0.415089)
     )

;;; 32 prime --------------------------------------------------------------------------------
#(32 7.7375974655151 #(0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0)
     7.719434261322 #(0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0)
     7.6655950546265 #(0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1)
     7.6567826271057 #(0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0)
     7.6309351921082 #(0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     6.945565 #(0.000000 0.046495 0.496817 0.680238 1.009260 1.131116 1.092336 0.893510 1.099114 0.815014 -0.083387 0.117703 1.618006 0.348695 1.351638 1.392799 1.435601 1.178568 0.246956 1.532146 1.530973 0.353380 1.008482 1.228068 1.716716 1.252232 0.794560 0.240630 1.365270 1.163613 1.530387 0.931563)
     6.906252 #(0.000000 0.275821 0.498145 0.052023 0.521184 0.089552 0.892457 1.279842 1.046869 1.315941 0.766659 0.660262 0.300595 0.894477 0.884655 1.755251 0.090926 1.876576 0.253382 -0.057814 1.381131 0.898570 -0.010539 1.541038 1.433207 -0.014565 0.236526 0.995302 1.735657 1.072516 0.338127 1.412696)
     )

;;; 33 prime --------------------------------------------------------------------------------
#(33 7.9869227409363 #(0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
     7.8325562477112 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0)
     7.7895503044128 #(0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1)
     7.7389698028564 #(0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     7.029147 #(0.000000 1.607365 1.241036 0.777600 1.074977 0.841861 0.915645 0.540343 1.045301 0.967959 1.093845 0.356485 1.386580 0.422382 0.844445 0.375365 0.464922 1.460485 0.036389 0.998476 0.305190 1.813494 0.854960 0.018926 0.508668 0.922369 1.800686 0.365762 1.762926 1.444879 0.617737 1.856296 0.538876)
     )

;;; 34 prime --------------------------------------------------------------------------------
#(34 8.0215682983398 #(0 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     7.9724597930908 #(0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0)
     7.9716167449951 #(0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9716163031165 #(0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9624452590942 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     7.183019 #(0.000000 1.712561 0.217132 1.723595 0.340284 0.843218 0.457608 0.664542 1.888630 1.161946 1.354854 -1.875365 1.436149 0.660043 1.525865 -0.196571 1.549572 1.238287 0.981797 0.656936 0.664729 1.071650 0.741907 0.077384 1.411634 1.091424 0.576948 0.026581 0.771646 1.340109 1.193689 0.593241 1.618577 0.398362)
     )

;;; 35 prime --------------------------------------------------------------------------------
#(35 8.2040424346924 #(0 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0)
     8.1993579864502 #(0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0)
     8.1756086349487 #(0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1)
     8.1555442810059 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0)
     8.1336851119995 #(0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 0 0)
     8.1317510604858 #(0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 0 1 0 0 0 0)
     8.0019035339355 #(0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.295313 #(0.000000 1.202557 0.490248 0.550847 -0.001052 0.838411 1.110504 1.732576 1.466163 0.868560 0.927867 1.453603 0.200799 1.716962 1.417541 0.711032 0.008799 1.438033 0.470770 0.268438 1.030252 1.577853 0.477618 0.538417 0.269592 -0.005718 0.647951 0.398077 0.721135 0.545658 1.390386 0.199584 0.313383 0.250740 1.138970)
     )

;;; 36 prime --------------------------------------------------------------------------------
#(36 8.4211139678955 #(0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     8.4162702560425 #(0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0)
     8.4114933013916 #(0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     8.3864717483521 #(0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0)
     8.3820142745972 #(0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0)
     8.3783054351807 #(0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0)
     8.3031883239746 #(0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.531822 #(0.000000 0.425534 1.726404 0.669940 0.799396 0.152804 0.709343 0.523206 0.212487 1.189904 0.572282 1.043446 0.907907 0.750844 1.017969 0.070588 0.414543 -0.080771 1.305782 0.144324 1.762811 1.657963 0.647698 1.261754 1.765647 0.539636 0.678629 1.528197 0.608650 1.760066 -0.044846 0.427501 0.663221 1.310085 1.692653 -0.099917)
     )

;;; 37 prime --------------------------------------------------------------------------------
#(37 8.6493539810181 #(0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0)
     8.5117635726929 #(0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0)
     8.4779825210571 #(0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)
     8.4775905609131 #(0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.556349 #(0.000000 1.196885 1.098052 1.278009 0.712601 1.073617 0.640179 1.819966 1.215007 -0.010536 1.519018 0.100525 1.669334 0.118304 1.150079 1.071494 0.819395 0.148566 1.700888 0.940967 -0.026823 0.052858 0.927003 0.782608 1.528406 0.207815 0.859866 0.539796 1.037144 0.075621 0.575538 -0.075098 1.257732 1.448616 1.796742 1.347204 1.593122)
     7.545472 #(0.000000 1.204123 1.099254 1.275408 0.714126 1.073456 0.640078 1.820880 1.216135 -0.009822 1.517987 0.103724 1.667147 0.124954 1.152909 1.070619 0.817485 0.150169 1.704050 0.943542 -0.028740 0.053886 0.920874 0.779706 1.521803 0.211973 0.856779 0.541415 1.037631 0.071105 0.576812 -0.074598 1.257536 1.445308 1.794087 1.346374 1.594078)
     )

;;; 38 prime --------------------------------------------------------------------------------
#(38 8.6871099472046 #(0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0)
     8.67653465271 #(0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0)
     8.6688671112061 #(0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0)
     8.6612920761108 #(0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0)
     8.6306476593018 #(0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0)
     8.6206035614014 #(0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0)
     8.5991640090942 #(0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0)
     8.5527725219727 #(0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

     7.691530 #(0.000000 0.347085 1.276980 -0.120799 0.319391 0.890156 1.870413 0.550245 0.133805 0.760986 1.678554 1.595853 0.397799 1.103040 1.280122 -0.311461 0.258637 0.253230 1.249455 -0.205576 1.757869 0.400070 -0.164952 0.727795 1.926033 0.892980 0.350004 0.638891 0.661022 0.495977 0.512730 1.314466 0.199324 0.342038 -0.131473 1.298390 0.538607 0.048218)
     )

;;; 39 prime --------------------------------------------------------------------------------
#(39 8.9125862121582 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 0)
     8.8173857964668 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.784208 #(0.000000 0.121590 1.054068 0.236304 1.501231 1.429532 0.901575 0.317453 0.075755 1.122544 0.920391 1.365471 0.277839 0.487471 1.279613 1.668108 0.079558 0.929452 1.317694 1.369128 1.199998 1.280488 0.961352 0.546932 0.525195 0.637238 1.255287 0.981241 0.977235 0.828059 1.476948 0.180486 1.361190 1.823437 1.568461 0.109493 0.543298 1.279489 1.260105)
     )

;;; 40 prime --------------------------------------------------------------------------------
#(40 9.0681540417544 #(0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1)
     8.9134502410889 #(0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     7.908007 #(0.000000 1.605211 1.725678 1.197642 0.024267 0.406741 0.978072 0.589347 0.291191 1.319831 1.586797 0.557257 1.308900 0.324459 0.733467 1.115604 0.707203 0.456844 1.700262 0.432756 1.684406 0.264210 0.541840 1.849304 1.781504 1.182435 0.630893 0.260626 1.401525 0.606435 0.612002 1.588581 0.566473 1.408301 1.733606 0.622198 1.374978 -0.088892 1.471935 1.465356)
     )

;;; 41 prime --------------------------------------------------------------------------------
#(41 9.295313835144 #(0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     9.1567583084106 #(0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     8.044824 #(0.000000 0.515502 -0.084474 1.160373 0.403802 -0.015369 -0.213402 -0.083458 0.138130 0.014208 1.424435 0.438729 1.502978 1.864380 1.400038 0.855110 -0.047405 1.485210 1.058086 0.399761 0.516275 0.765859 1.318239 0.465856 1.707134 0.700900 0.551921 0.932376 0.863963 0.765112 1.663905 1.234496 0.602406 0.161490 0.658622 1.504998 0.268341 0.797358 0.326539 1.332497 0.722218)
     )

;;; 42 prime --------------------------------------------------------------------------------
#(42 9.3096771240234 #(0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0)
     9.2193641662598 #(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

     8.165740 #(0.000000 -0.257769 0.019775 1.582575 0.959460 1.248780 1.388137 1.817201 0.320564 1.409523 1.174425 1.171466 0.401009 0.159933 0.867192 0.410601 1.497163 0.479908 1.251280 0.847104 1.859854 1.528865 0.771666 0.194477 0.236427 1.698266 0.450721 1.075333 1.021184 0.772835 1.121837 0.285543 0.144193 0.449708 1.045791 1.292230 0.349655 0.208499 1.359582 0.869901 0.896282 0.717770)
     )

;;; 43 prime --------------------------------------------------------------------------------
#(43 9.4925568571597 #(0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     9.4329051971436 #(0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     8.306918 #(0.000000 1.882760 0.356930 0.064466 1.191310 0.167454 0.004466 1.772005 0.818670 0.863488 0.928731 1.825306 0.540056 0.377484 1.006184 1.440567 0.040430 1.815977 0.171650 1.607075 1.479482 1.293871 0.059415 1.036121 1.756011 0.097716 1.268213 0.086678 0.085017 0.121034 -0.074207 0.583391 0.913035 1.566572 1.367626 0.329248 1.736810 1.258148 0.863654 0.033763 1.784202 0.146186 1.378117)
     )

;;; 44 prime --------------------------------------------------------------------------------
#(44 9.6622378996026 #(0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     9.6263332366943 #(0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

     8.379767 #(0.000000 1.288218 0.243907 0.777361 0.859250 0.892273 0.478398 0.790917 0.359833 0.845304 0.132499 0.810436 1.785678 0.010538 0.196291 1.805915 1.870383 1.027164 1.375086 0.218343 0.562647 0.169604 1.242948 1.386309 0.717199 0.261933 1.142376 1.313707 0.674949 -0.091263 0.494013 0.037437 0.611802 1.045213 1.357187 1.615588 1.083862 -0.278606 0.295121 1.072246 0.785769 1.519002 0.866684 1.922346)
     )

;;; 45 prime --------------------------------------------------------------------------------
#(45 9.8476276594031 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1)
     9.7923860549927 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.531010 #(0.000000 0.638362 0.815393 1.433581 0.383626 0.688923 0.170001 1.639534 1.264502 0.198252 1.371925 1.378010 1.010105 0.892142 0.226711 0.953669 1.386369 1.526407 1.153112 0.182068 1.565895 1.347055 0.486500 1.002282 1.526554 1.712315 1.056247 1.724331 0.716550 1.740613 0.382219 -0.026552 1.216630 1.307225 1.309768 1.560386 1.959163 1.203884 0.751399 1.518834 0.337855 0.621579 0.771546 -0.019855 0.737162)
     )

;;; 46 prime --------------------------------------------------------------------------------
#(46 9.928765296936 #(0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0)
     9.8914480209351 #(0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)
     9.7220277786255 #(0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.608845 #(0.000000 0.123302 0.136287 1.399817 0.898698 0.632326 0.696394 0.530391 0.071827 1.669939 0.143734 1.440190 1.067890 -0.158361 1.192695 0.689716 0.437597 0.976553 1.620342 0.651144 1.134274 0.269512 0.684534 1.273052 0.985807 0.205106 0.961262 1.456548 1.860623 0.046427 -0.191886 0.487736 1.500200 0.988025 1.011523 0.791151 0.049947 1.587455 0.634968 0.906097 1.192973 1.221528 1.305414 0.545240 0.609668 0.905043)
     )

;;; 47 prime --------------------------------------------------------------------------------
#(47 10.097447395325 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     10.0            #(0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     8.699175 #(0.000000 1.206293 0.155915 -0.034353 0.818950 0.092561 1.135145 1.488306 1.172406 1.154474 1.211140 0.691163 -0.261556 0.922892 0.514656 1.960387 1.754199 0.107388 0.949197 0.269747 0.255501 1.692498 1.098961 1.733936 1.507970 1.784327 0.722560 1.353892 0.962776 1.211670 1.428489 1.109893 1.229414 1.194678 1.833795 1.233722 0.099052 1.243706 1.121659 1.297166 -0.051864 1.158952 1.640861 0.332000 0.005617 0.602737 0.258593)
     )

;;; 48 prime --------------------------------------------------------------------------------
#(48 10.298553466797 #(0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0)
     10.248653411865 #(0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0)
     10.073040962219 #(0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.801431 #(0.000000 0.252761 1.793753 1.755406 0.548028 0.534432 0.797672 1.827535 -0.002725 0.174172 0.995556 1.129254 0.574088 1.081336 0.817151 0.396701 1.051834 0.453788 1.758786 0.574169 0.012381 0.619957 1.558581 1.205113 1.436843 -0.058121 1.167791 1.385432 1.324732 0.739054 1.639524 1.296325 -0.076764 0.579683 1.856882 0.895327 1.303867 0.783736 0.689068 1.019157 1.514361 1.130483 1.972472 1.137272 0.723545 1.098985 0.461074 -0.123889)
     )

;;; 49 prime --------------------------------------------------------------------------------
#(49 10.28332063912 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0)
     10.207101821899 #(0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 0 0)
     10.209 #(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     8.932775 #(0.000000 1.529957 0.349453 0.980933 0.996420 0.323770 -0.047523 0.746415 0.854338 1.567152 1.178413 1.645990 1.243000 1.705499 0.250151 1.505503 0.163649 1.750214 0.334987 0.154940 1.082770 1.104002 0.615361 1.734792 1.885327 0.066363 1.925400 0.351399 1.299639 0.972658 1.576041 1.780650 1.681074 0.016790 1.218604 0.674609 -0.130324 1.799726 1.730296 1.616317 0.732883 1.484031 0.904525 -0.157617 0.171826 0.846831 0.537959 1.779983 1.208575)
     )

;;; 50 prime --------------------------------------------------------------------------------
#(50 10.669495582581 #(0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1)
     10.402973175049 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     9.036344 #(0.000000 1.433027 1.161441 1.022875 1.262636 1.043409 0.580285 1.779488 1.162716 1.298823 1.318075 1.408508 0.808453 1.755892 0.222398 0.853853 -0.085893 -0.026418 1.116924 1.861051 1.394519 0.998082 0.915221 0.125074 0.760837 0.477624 0.820013 0.022345 0.776316 0.144306 1.306571 1.277599 1.867929 0.676461 0.388556 -0.116225 0.850027 0.989054 0.184164 1.421232 0.728934 1.263386 0.827640 1.393355 0.043515 1.560842 0.568752 1.385360 0.017740 1.290251)
     )

;;; 51 prime --------------------------------------------------------------------------------
#(51 10.5841327092253 #(0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     9.237356 #(0.000000 0.596984 1.567457 0.817412 0.273220 0.015491 1.263280 1.382889 0.775862 0.174564 -0.093846 1.601513 0.688261 -0.057282 1.750049 0.577290 1.131755 0.840826 0.990288 1.112107 0.003954 1.897377 0.303400 0.880265 0.674155 0.779382 0.335933 1.305644 0.598652 0.468699 0.442767 1.728632 0.563560 0.386847 1.004741 0.454936 0.207759 0.461770 0.802672 0.293732 1.241227 1.248091 1.781450 1.746411 1.807884 1.190759 1.073510 0.685967 0.282975 -0.181238 0.432292)
     )

;;; 52 prime --------------------------------------------------------------------------------
#(52 10.767134666443 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0)
     10.737469673157 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1)
     10.64324760437 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     9.406825 #(0.000000 0.425395 0.129546 0.390589 1.748778 1.792295 1.799217 0.695632 1.410156 0.843576 0.308371 -0.039802 1.132079 1.655686 0.011574 0.254508 1.384781 0.343863 1.325286 -0.087255 1.093023 0.498167 -0.029716 1.358161 0.290792 1.304323 0.015261 0.361209 0.855513 0.072920 0.627466 0.724337 1.060090 1.390017 0.757525 1.701023 -0.024828 1.725989 0.933084 1.668229 1.694294 0.863468 0.679597 1.006213 0.257742 1.258667 0.449926 1.474965 0.819494 0.702506 1.159339 1.100962)
     )

;;; 53 prime --------------------------------------------------------------------------------
#(53 10.966755867004 #(0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
     10.959488868713 #(0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.950836181641 #(0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0)
     10.851609230042 #(0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.848851203918 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     10.678050692694 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     9.536314 #(0.000000 0.733019 1.297172 0.298105 0.255310 -0.014752 0.906442 1.778799 1.351058 1.680839 1.766455 0.387231 1.470846 -0.072390 0.476809 1.759910 0.772776 0.542663 0.812935 1.811136 0.881672 0.203184 0.702794 -0.174551 1.534362 0.589602 1.205973 1.569253 1.331136 1.042778 0.879999 0.748704 1.527492 0.513824 0.467506 0.865203 0.839993 0.755695 1.671766 1.837162 0.692026 1.479028 0.827822 1.820530 -0.007848 1.286558 1.165607 1.034351 1.263634 0.629003 1.347564 0.922116 1.570030)
     )

;;; 54 prime --------------------------------------------------------------------------------
#(54 11.062943458557 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1)
     11.050 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1)
     10.779137611389 #(0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1)
     10.582709312439 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     9.531302 #(0.000000 1.229471 1.659223 1.798969 1.100323 1.157869 0.486468 1.376328 1.119235 1.590297 1.641407 0.372270 1.383812 0.453505 0.585423 1.711738 1.334013 0.716078 0.153736 0.198933 -0.041066 0.046186 1.466573 0.825573 0.797934 1.608472 0.310209 0.395721 1.082663 0.079288 -0.035061 1.436243 1.511099 1.345551 0.081016 0.993720 1.569901 0.055705 0.521700 1.622867 1.841635 0.394885 1.172818 1.659733 0.921715 1.307135 0.915170 1.649843 1.881854 0.156151 1.039486 1.666159 0.065657 0.324643)
     )

;;; 55 prime --------------------------------------------------------------------------------
#(55 11.142364777492 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1)
     10.806410031758 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.677582 #(0.000000 0.966378 1.061823 0.069776 0.746773 0.727710 1.081946 1.321911 0.475138 0.635305 1.429423 0.037292 0.823485 1.650824 1.673354 1.216659 1.390492 1.984930 1.329970 1.026006 0.604482 0.903847 0.482977 -0.065064 1.395216 1.369533 -1.950129 0.475736 0.121382 1.423926 -0.302339 1.277906 1.335248 1.375843 1.144968 0.624759 0.113584 0.633271 1.263102 0.450420 1.422859 0.721534 0.282898 0.081974 1.673958 0.182738 1.205738 1.829125 0.403452 1.693005 1.747037 1.907089 1.860545 0.134393 -0.116157)
     )

;;; 56 prime --------------------------------------------------------------------------------
#(56 11.365570068359 #(0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1)
     11.143131256104 #(0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1)
     10.976176261902 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

     9.737768 #(0.000000 0.099478 0.761517 1.632514 1.179546 0.388220 1.723313 0.372389 1.559917 -0.046537 0.482939 1.315597 1.502241 1.430009 1.696496 1.013067 -0.067203 1.335131 1.992651 1.959070 1.844027 0.401384 0.232549 0.446470 0.505530 1.602830 -0.155027 0.231565 0.574106 0.657337 1.522492 1.676753 -0.016056 1.616263 0.280431 0.616470 1.050547 0.726361 -0.099815 -0.238209 1.463922 0.700017 0.027582 0.272913 1.421820 1.688938 1.020016 0.343137 0.817272 -0.089013 0.023211 0.597580 1.502229 1.415306 1.598746 1.312283)
     )

;;; 57 prime --------------------------------------------------------------------------------
#(57 11.484163284302 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1)
     11.352762647901 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)
     11.247724533081 #(0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

     10.013414 #(0.000000 0.070593 1.685968 1.470323 0.064867 1.775133 0.352864 0.818446 1.255482 1.778065 1.536541 0.681506 0.274019 0.028598 0.977835 1.524185 1.109948 -0.099244 1.225349 1.758324 1.288159 1.186197 0.742421 0.766833 1.201917 -0.118823 1.635319 0.746550 1.473070 0.889748 0.418394 1.943330 0.230369 0.354601 -0.063973 1.453511 1.839275 1.337540 0.007384 1.759215 0.522800 0.731007 0.946932 0.465899 1.252535 0.834061 1.650958 0.823935 0.963968 1.189827 1.265240 1.051354 0.486709 1.480534 0.243553 1.523455 0.972163)
     )

;;; 58 prime --------------------------------------------------------------------------------
#(58 11.564489172529 #(0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)
     11.261419321863 #(0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

     10.107254 #(0.000000 1.924031 0.316278 0.429165 0.397228 0.707283 0.087976 0.175411 0.475671 1.739537 1.093598 1.596551 0.706563 0.672225 1.275653 1.270158 0.612039 1.416521 0.635356 1.189635 1.254349 0.990097 0.222286 0.047905 -0.008498 0.174821 0.691697 0.798831 1.787433 0.578330 1.180978 1.390276 1.378747 1.596376 0.652620 1.967050 0.271568 1.298168 0.816628 1.268506 1.949880 0.706348 1.180058 1.304064 0.885396 1.010142 1.641286 0.569073 0.018497 1.111930 0.116943 1.326485 1.215287 0.308991 0.216744 0.195205 0.595270 1.706926)
     )

;;; 59 prime --------------------------------------------------------------------------------
#(59 11.677247047424 #(0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0)
     11.650652430228 #(0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0)
     11.523194313049 #(0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1)
     11.34253692627 #(0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     10.002733 #(0.000000 1.245089 1.372842 0.430614 0.901919 0.248085 0.201814 1.710789 1.952925 0.079402 1.346254 0.043826 1.372258 1.213616 0.929709 0.899490 1.293285 -0.162664 1.502748 1.709298 -0.063540 1.586097 0.576030 1.695137 0.799196 0.946402 0.143235 1.451842 1.910664 0.775622 0.988860 1.280780 0.479927 1.247345 1.227140 -0.039096 0.329028 0.939698 1.503168 1.577495 0.497918 0.065007 0.971427 1.066561 0.594296 1.085722 1.721032 0.433890 0.511299 1.786553 0.999271 1.959328 0.462702 1.650943 0.069846 -0.106768 1.913608 0.325282 0.928528)
     )

;;; 60 prime --------------------------------------------------------------------------------
#(60 11.705318182776 #(0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0)
     11.579921722412 #(0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0)
     11.512454032898 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     10.060146 #(0.000000 1.474658 1.618338 1.044594 -0.023569 1.406104 0.098504 1.374919 1.160774 0.910892 0.164669 1.629326 1.262027 0.450737 0.012808 0.825361 1.463301 0.376393 1.693547 0.191629 0.971995 0.310852 0.725214 0.912997 1.132916 1.895966 0.554860 0.741515 1.700569 0.813858 0.565937 1.160718 1.657536 1.516713 1.104594 1.787687 0.184907 0.465506 1.716966 0.523801 0.053934 0.677590 0.858130 -0.210256 -0.039584 1.240598 1.842287 1.372591 -0.033173 0.439503 1.362428 1.686436 0.006866 0.544357 1.889275 0.951955 0.050394 1.678928 0.155296 0.856658)
     )

;;; 61 prime --------------------------------------------------------------------------------
#(61 11.989195823669 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0)
     11.915099143982 #(0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0)
     11.850807189941 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     10.388943 #(0.000000 0.541522 1.479961 1.270889 1.601052 1.254421 0.290322 1.100511 1.236330 1.121862 0.428323 0.845128 -0.130092 0.756720 1.761757 1.063185 0.611357 -0.047531 0.158706 0.843399 1.446186 0.780243 0.105639 1.078747 0.741983 0.307934 0.141818 1.743054 0.503696 1.379072 1.603968 0.715679 0.026896 0.178619 1.259249 1.051762 1.218213 0.263539 1.094658 0.561074 1.880856 0.061627 0.793225 0.600439 1.675155 0.902978 0.838890 1.074161 -0.035565 1.182771 0.616116 1.406810 1.364748 1.701839 1.753556 0.327558 0.434365 0.007694 0.939390 1.562495 0.503163)
     )

;;; 62 prime --------------------------------------------------------------------------------
#(62 12.4221113188342 #(0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0)
     11.929849152918 #(0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0)
     11.709966659546 #(0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

     10.409433 #(0.000000 0.230098 0.289970 0.179625 1.790951 -0.002840 1.031985 0.445756 1.801088 0.181518 0.091348 0.476487 0.975418 1.216309 0.977849 1.275892 0.558013 0.058639 0.390507 0.750334 0.363253 1.374209 -0.424944 0.341873 1.575985 -0.219166 0.619364 1.749057 0.460713 1.544856 0.824020 0.172588 1.075117 0.123007 0.166924 0.145926 1.647128 0.735158 1.142038 1.256308 0.206559 1.610483 1.093472 0.690759 1.247737 1.661280 0.949387 0.683832 0.119474 0.777071 0.565198 0.283464 1.924095 0.575342 0.375976 0.062971 0.692904 1.321348 0.616029 1.236790 1.782899 0.065597)
     )

;;; 63 prime --------------------------------------------------------------------------------
#(63 12.219760894775 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     12.000000000004 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     11.975765228271 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     10.494065 #(0.000000 -0.094134 -0.141971 0.276973 1.549582 0.146799 1.159650 0.615760 1.191684 0.478403 0.790831 0.093381 0.128503 1.945506 -0.005628 1.191587 0.372918 1.232968 0.916029 0.807324 1.647655 1.474748 1.279018 1.305718 1.694804 0.360342 0.484577 0.788854 0.655408 1.749809 -0.181911 1.894982 0.785921 0.685882 1.535002 0.960234 0.496049 1.403472 1.594512 0.738600 0.819941 0.808601 0.370150 1.799150 0.776514 0.582977 1.226294 0.345108 -0.042789 0.351345 0.440943 1.814915 0.546848 1.630902 0.163205 1.588859 0.173763 0.475285 0.784229 0.163690 0.297470 0.961991 0.523692)
     )

;;; 64 prime --------------------------------------------------------------------------------
#(64 12.176999092102 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)
     11.932915769505 #(0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     10.673618 #(0.000000 -0.057577 0.222106 1.573141 0.252274 0.595495 0.936458 1.040417 0.425979 1.823968 1.432886 0.563698 0.918604 1.296447 0.374043 0.855095 1.004527 0.356896 1.934601 0.180877 1.811696 0.445648 0.602606 1.466940 0.177111 0.730811 1.728271 0.543893 1.431300 1.303712 0.222585 0.859995 0.388267 1.177649 0.459404 0.249801 0.483989 1.477859 1.146169 1.162067 1.475720 1.672371 0.380635 0.596058 1.133714 1.577332 0.270931 0.009256 0.211376 1.386397 0.628160 0.657631 -0.177469 1.371378 0.901150 0.868587 0.814998 1.273990 1.479235 1.013479 0.547621 0.741249 0.281855 0.398198)
     )

;;; 65 prime --------------------------------------------------------------------------------
#(65 12.496994018555 #(0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 0)
     12.264873504639 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

     10.735011 #(0.000000 1.237889 -0.077296 -0.052305 0.359502 0.223006 0.595568 1.727253 1.967160 1.499685 1.069585 1.655809 1.434316 0.488626 0.083246 1.268928 0.730301 0.101375 0.893596 0.135562 0.203287 0.343190 1.405877 1.234959 1.083914 1.000159 0.849109 1.703685 1.939439 0.025575 1.252341 1.104601 0.627441 1.911121 1.818600 0.114026 0.526887 0.785890 1.147754 0.829276 1.148268 1.181288 0.188256 1.267042 -0.023050 1.415204 0.225620 0.164214 0.135255 0.925324 0.054171 0.019124 1.521376 1.280007 1.745556 -0.029653 1.486393 0.303975 -0.035053 1.013741 0.102426 1.276278 1.503593 1.763801 0.225695)
     )

;;; 66 prime --------------------------------------------------------------------------------
#(66 12.564531326294 #(0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0)
     12.359117360586 #(0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0)
     12.347700119019 #(0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0)
     12.090668678284 #(0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.852029 #(0.000000 0.036871 0.455889 1.423386 0.169164 0.354546 1.026437 0.882978 0.324852 0.177810 0.552193 1.185454 1.368604 0.156241 1.219999 1.877782 1.632390 1.219609 -0.215349 -0.038672 1.876473 1.131029 0.265270 0.389196 0.810392 0.702510 1.767053 0.253824 0.647346 0.109669 0.351247 0.129948 0.481348 0.966668 0.702556 -0.039900 0.300658 0.700001 1.095465 1.449991 0.747583 1.911436 1.272300 0.995322 0.867365 1.712469 0.758911 1.562381 -0.037969 0.985815 0.464261 1.914649 1.161824 0.577639 1.270582 1.247167 1.137595 0.313913 0.642949 0.096531 0.617650 0.210266 1.403526 0.445812 0.151006 0.392696)
     )

;;; 67 prime --------------------------------------------------------------------------------
#(67 12.65784740448 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1)
     12.20425496356 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

     10.973813 #(0.000000 -0.065352 1.375899 1.830527 0.709294 0.176238 1.277105 1.139243 0.002498 0.342255 0.412737 0.613220 0.195665 0.037867 0.772146 0.213495 1.529775 1.454612 1.526209 0.802411 0.782692 0.906760 1.527576 1.081005 0.453831 0.900353 0.589641 0.840366 0.407297 0.771747 1.071356 1.637770 1.340285 0.934125 1.351247 0.875028 1.988208 1.316394 1.598848 -0.002703 1.473129 0.984390 0.978493 1.428639 0.980954 1.802252 0.834869 0.506898 0.834094 1.087623 1.314287 0.961345 1.510411 0.343055 0.011178 1.568978 0.619983 0.433155 0.574569 1.616131 1.104481 0.699430 0.214381 -0.064644 0.976305 0.280998 0.664933)
     )

;;; 68 prime --------------------------------------------------------------------------------
#(68 12.551372528076 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1)
     12.501034736633 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1)
     12.466281890869 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

     11.082991 #(0.000000 0.158663 1.686630 -0.145855 1.128439 1.706545 0.174588 0.930345 1.898439 1.097688 -0.124985 1.764469 1.494171 1.840162 0.168880 0.851018 0.462852 1.357952 1.092768 0.298479 0.174837 0.836546 -0.075730 1.421055 1.251966 0.522594 -0.074207 1.258725 1.185607 1.867906 0.054928 -0.064008 0.763948 -0.220112 0.925622 1.360941 1.908145 1.785285 0.676153 0.407184 -0.081677 1.103998 -0.010108 0.271049 1.365091 1.679127 1.820257 1.599369 0.736763 0.845710 1.422094 1.253509 0.770080 0.658140 0.367612 1.933924 1.667746 1.487155 0.492193 0.513558 0.011428 0.699427 0.174640 1.275080 1.576736 1.750760 0.275862 1.591074)
     )

;;; 69 prime --------------------------------------------------------------------------------
#(69 12.88109067433 #(0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     12.547190281687 #(0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1)
     12.336643218994 #(0 0 1 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1)
     12.29846572876 #(0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     11.054718 #(0.000000 1.765666 1.324417 1.323351 1.247655 0.306508 1.750724 1.613297 0.754242 0.572438 1.797535 1.366383 1.138261 0.783459 0.263251 0.392254 0.128141 0.023200 1.466763 1.050804 1.851144 0.402350 0.705348 0.287991 0.380139 0.766781 1.919322 -0.162484 1.807886 1.678337 0.609106 1.756596 1.118838 1.608586 0.524152 0.941639 1.011369 1.457368 1.641616 1.163849 1.708854 1.756253 1.369604 -0.103329 0.756317 0.588026 0.735076 -0.050143 0.011937 0.772701 1.456304 1.069092 0.292325 1.020942 1.314619 1.141221 1.852232 1.079011 0.750843 1.040669 1.155902 0.494107 1.723371 -0.073023 0.880459 0.324565 1.302412 1.289403 0.806454)
     )

;;; 70 prime --------------------------------------------------------------------------------
#(70 13.070093154907 #(0 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0)
     12.849155290344 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0)
     12.797727584839 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     12.669577598572 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)
     12.665026664734 #(0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     11.147948 #(0.000000 0.919104 0.037724 0.031324 0.425088 1.088754 0.239817 1.518037 1.024607 1.561517 0.814568 1.169406 0.975549 0.676123 0.339172 0.112474 -0.060178 0.615982 0.787403 0.514161 1.205362 1.604068 1.012404 1.958451 1.882861 1.753448 1.728750 0.841905 0.938249 1.849485 1.385354 0.340038 0.028994 0.560800 0.084089 1.945412 1.161739 -0.101622 0.564484 1.780618 1.598925 0.413051 0.389471 0.732544 1.482046 1.382082 1.539268 1.550320 1.274381 1.607228 0.267792 1.458751 -0.044328 0.278989 1.141002 -0.076109 1.482534 0.688274 1.322847 0.827949 0.316842 0.931885 1.649833 0.714699 0.107358 0.994888 0.235134 0.824490 0.817106 0.239631)
     )

;;; 71 prime --------------------------------------------------------------------------------
#(71 13.189444031428 #(0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0)
     13.116391136133 #(0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
     13.027417182922 #(0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0)
     12.702159881592 #(0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0)
     12.609085083008 #(0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     11.197084 #(0.000000 0.921777 0.803106 0.976406 1.655030 1.047155 0.651814 1.015011 0.518239 0.823709 0.754271 0.790346 1.685284 0.575068 0.597368 0.416408 1.059341 1.184219 1.281398 1.533665 0.288981 0.307776 0.759029 0.640264 0.624490 1.486853 -0.006654 0.311699 0.054591 1.180218 0.867402 1.297030 1.006233 -0.046307 0.385240 1.750109 1.582049 0.896283 0.074937 0.580170 1.173266 0.273290 1.444714 0.704280 0.869780 1.749498 1.272218 0.208969 1.600481 1.019087 0.873073 0.197331 1.064324 -0.046231 1.350340 0.148469 1.177875 1.153157 0.282987 0.229407 1.780839 1.022097 1.547095 1.551043 0.319702 0.051807 0.260779 0.840496 0.737410 1.407947 1.329629)
     )

;;; 72 prime --------------------------------------------------------------------------------
#(72 13.268 #(0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0)
     13.043850898743 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1)
     12.841200828552 #(0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0)
     12.708446502686 #(0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     11.385956 #(0.000000 1.439211 0.920139 -0.153593 1.571592 0.954301 1.315076 0.900111 1.424065 1.369177 0.050625 0.015829 1.490353 0.034671 1.624391 1.349497 1.754751 0.383867 1.816884 1.047934 -0.068697 1.677593 1.053796 0.117311 0.584931 0.358596 1.411806 0.149367 0.571223 0.116831 0.408866 1.555361 1.552011 -0.034879 1.767138 1.048975 1.258095 0.107345 1.360719 1.322760 1.388883 -0.071045 1.011737 0.586720 0.960025 0.032890 1.370937 0.541331 0.924721 1.890763 0.666441 1.113794 0.156897 1.613821 0.902996 0.764846 1.631910 0.588153 0.705848 0.833879 0.136099 0.845036 1.252271 0.009702 1.342614 1.288340 1.836111 0.249118 0.250872 0.903792 0.967095 0.138909)
     )

;;; 73 prime --------------------------------------------------------------------------------
#(73 13.602198600769 #(0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 0 0 1 1)
     13.40486240387 #(0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0)
     12.986406962349 #(0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0)
     12.879818916321 #(0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     11.493125 #(0.000000 0.439315 0.356936 0.776510 1.347662 0.438381 0.928680 1.611610 1.374620 0.450836 0.387244 0.445669 1.319613 0.513356 0.406465 0.475466 1.554463 0.329902 0.248819 0.821569 0.323982 1.558539 1.172668 1.453303 1.342606 0.247592 0.051842 0.277267 1.688762 1.045279 1.213687 1.643748 1.259954 1.341985 1.568253 1.430961 0.345807 0.135985 0.572326 0.188072 0.676675 0.227571 0.050017 0.324958 1.109062 0.921730 1.693115 0.517354 1.242015 1.367220 0.445310 1.266987 0.958078 0.256094 0.212324 0.008743 0.859233 1.849317 0.555985 0.980671 1.459136 0.490957 1.866452 0.821408 1.520462 0.482524 1.696826 0.688069 1.627010 0.331076 0.434880 0.290712 1.616732)
     )

;;; 74 prime --------------------------------------------------------------------------------
#(74 13.442555427551 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.395832061768 #(0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1)
     13.261976242065 #(0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.115156173706 #(0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     11.443736 #(0.000000 0.201885 1.333326 0.603095 0.578767 0.130204 0.191641 0.136166 0.653894 1.550201 0.706822 1.101887 0.095307 1.066697 1.027871 0.938154 0.218263 0.900120 -0.190876 1.626843 0.208532 1.014584 1.056604 1.553413 1.877574 1.089119 -0.014944 1.533405 0.120350 1.165768 1.011018 0.183558 0.042240 -0.162242 -0.123745 -0.161580 0.608125 0.241638 1.106281 0.086915 0.162983 0.026879 -0.163794 1.669623 1.364255 1.224403 1.894724 1.620440 0.169072 0.636928 0.560332 0.971167 1.333957 1.623440 0.894032 1.830589 1.858596 1.945880 -0.100401 1.203505 0.464950 0.057006 1.607379 1.602395 0.555269 0.711132 1.060480 -0.029557 1.132639 1.065748 -0.060569 0.985362 -0.037670 0.407240)
     )

;;; 75 prime --------------------------------------------------------------------------------
#(75 13.676464080811 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1)
     13.618774108319 #(0 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0)
     13.357945520561 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)
     13.254356384277 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     11.728000 #(0.000000 0.383924 0.939684 1.398658 1.315656 1.085476 1.468342 -0.031614 0.968527 1.789035 0.752646 1.438814 1.909203 1.099384 0.107701 1.264361 0.752504 1.159465 1.383128 1.244046 0.540534 1.347105 0.393006 1.661857 1.729299 0.287533 1.231157 0.421791 1.639646 1.316516 0.102690 1.831347 0.615463 0.952210 0.947666 0.858785 1.125000 1.760338 1.286161 1.580119 1.714896 1.415563 1.280011 1.445095 1.581563 0.215701 0.733583 0.884897 1.610623 1.756881 1.723495 0.555903 0.352030 0.561040 1.887744 0.704656 0.696831 0.224996 1.094943 0.993238 0.267595 -0.134090 1.820154 1.109173 0.921732 0.366973 1.852033 1.729636 0.922165 0.907854 1.826107 0.138812 1.069656 1.971171 1.410570)
     )

;;; 76 prime --------------------------------------------------------------------------------
#(76 13.691219362758 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0)
     13.288178191792 #(0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     11.762659 #(0.000000 1.241245 1.006060 0.985803 1.809568 0.342105 1.281257 1.227385 0.782502 0.201905 1.013797 0.807064 0.956523 1.600986 0.660026 1.321784 0.303326 -0.198863 0.719017 0.490687 0.413561 0.622729 1.786598 0.200578 0.965267 1.610463 1.158126 0.000796 0.702751 1.785917 0.457551 -0.080520 0.475297 1.058316 1.748290 0.512774 0.807335 1.787572 -0.072934 0.195125 0.417809 0.094304 1.650143 0.817618 1.821075 1.045974 0.637980 -0.006370 0.763076 1.551829 1.128327 0.256835 0.385472 0.126696 0.963545 1.102578 1.166071 0.353331 0.711152 1.320488 0.579616 0.650514 1.660158 1.348924 -0.026985 0.937692 1.272395 1.898232 0.539398 0.194517 0.594443 0.362370 -0.000917 1.703207 0.563395 0.681486)
     )

;;; 77 prime --------------------------------------------------------------------------------
#(77 14.029663085938 #(0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1)
     13.845010757446 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0)
     13.330450043717 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1)
     13.158900260925 #(0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     12.038213 #(0.000000 1.164102 0.777013 1.777228 0.070721 1.579642 1.725670 0.531456 0.893822 0.559048 0.751473 1.297352 1.737775 -0.040229 0.158304 0.034380 1.321608 0.429821 0.386548 0.230888 1.434630 0.496011 1.332843 1.014005 0.321157 1.237568 1.061154 0.543568 1.086050 1.859380 0.739641 0.170987 0.520057 0.353395 0.509481 1.060017 0.322294 0.024761 0.967997 0.988712 -0.057842 0.099501 0.284068 1.860476 0.373629 1.463024 0.266264 1.766830 0.573871 0.621007 0.108252 1.642721 0.652324 0.087763 1.776821 1.239997 1.217666 0.703504 0.838988 1.799559 0.799615 0.435354 0.529789 0.617232 1.549056 1.313127 0.083805 1.151085 1.124037 0.326922 1.641779 0.799665 1.293781 1.251728 -0.092840 1.649911 0.055928)
     )

;;; 78 prime --------------------------------------------------------------------------------
#(78 13.920186042786 #(0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.683882347187 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.498236182018 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     12.167904 #(0.000000 1.349086 1.466799 1.482905 1.673416 1.874387 0.876741 1.542053 0.215354 0.370896 0.869154 1.385439 1.742862 1.085758 0.890729 0.148544 1.947977 1.209572 1.561203 1.469867 0.915185 0.984799 0.427811 1.793791 1.867744 0.385490 1.688676 0.754678 0.065514 0.083069 1.071965 -0.026629 0.006581 0.298885 1.022927 -0.043287 1.533409 1.294806 0.426841 1.120561 0.823180 0.659518 1.725671 1.585220 -0.181484 0.168095 -0.256838 1.517826 0.125018 0.550511 1.377766 0.022366 0.945340 0.494055 1.303955 0.045211 0.078052 0.178119 -0.147185 1.331147 0.675892 -0.052728 0.868700 0.500694 -0.242652 1.571492 0.361320 0.980704 1.111211 -0.330155 0.919681 1.033002 1.462062 1.410123 0.574463 1.876684 1.170530 1.387325)
     )

;;; 79 prime --------------------------------------------------------------------------------
#(79 14.000000000005 #(0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0)
     13.77695274353 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0)
     13.178678233398 #(0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     12.173032 #(0.000000 1.220065 1.448811 1.174773 0.369197 0.999425 0.745804 1.137984 0.593381 1.688448 1.727263 0.941600 0.643963 1.723009 1.808885 0.394233 1.664121 0.121420 0.673612 1.139241 1.831603 1.359170 0.571671 0.282443 1.122387 1.138228 1.823755 0.308193 0.313097 0.548342 0.985869 1.260469 0.401300 0.908536 1.586182 1.561505 1.503624 0.396532 1.347328 -0.028059 1.502800 1.162855 1.859181 -0.013072 1.432497 0.746999 0.958059 0.536146 0.059785 0.945358 1.445104 1.793115 0.408982 0.059561 0.008824 0.417090 1.129802 0.993219 -0.152126 -0.044476 0.006971 1.404072 0.176467 1.464462 0.037564 0.821375 1.803549 0.504847 1.419290 1.364066 1.863904 1.802809 1.482631 1.604507 1.231962 1.624894 1.580454 1.357188 1.041914)
     )

;;; 80 prime --------------------------------------------------------------------------------
#(80 14.307361602783 #(0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0)
     14.119678497314 #(0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1)
     13.563344594765 #(0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0)
     13.547472953796 #(0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     12.296392 #(0.000000 1.939959 0.049623 0.255753 0.079399 1.237444 0.647814 0.445544 0.403711 0.444110 1.386240 0.757661 1.499300 1.590910 0.021143 0.085778 -0.034399 0.461941 1.140821 1.747770 0.513821 1.531461 0.741277 1.172891 1.272241 0.879042 0.432243 0.842558 0.360162 -0.002595 1.835137 0.512597 1.173958 1.572691 0.018244 1.784936 0.483366 1.326265 0.309137 1.799585 0.357368 -0.095181 0.421123 1.281503 1.461775 0.878057 0.152427 1.098597 0.707162 1.392345 0.965457 0.841749 0.233308 0.993627 0.504905 1.036415 0.645531 0.296587 0.623400 1.833109 1.832488 1.247369 1.008767 0.670384 1.265091 0.376295 0.610707 0.186262 1.224258 0.143839 1.202972 0.702563 1.539182 0.956270 1.344320 1.408538 1.239195 1.775287 1.269060 1.683801)
     )

;;; 81 prime --------------------------------------------------------------------------------
#(81 14.317508929282 #(0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0)
     14.253742218018 #(0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1)
     13.652944564819 #(0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     12.282995 #(0.000000 0.039290 1.098363 0.170384 0.043454 1.360312 0.171640 0.240234 0.521966 0.501077 0.198061 0.347496 0.877054 0.375755 0.668647 1.225438 0.438671 0.411649 0.598455 1.766860 -0.042728 1.351208 1.384675 1.635652 1.578360 0.885270 1.535012 0.017317 1.689569 1.543520 1.201144 0.607056 0.108257 0.629689 1.080246 1.022676 -0.157183 0.280042 1.743230 -0.010914 1.564319 0.995055 1.069668 1.864242 1.577254 1.302895 1.380372 0.028831 0.886487 0.926505 1.525751 1.929779 0.017004 0.498464 -0.087960 0.535410 -0.155571 0.635710 0.738849 0.633557 1.851746 0.175414 1.200109 1.385225 0.080502 0.830721 0.862127 1.275617 -0.196626 1.429126 0.496857 0.604193 1.020987 1.579963 0.346706 0.456857 0.587438 1.199958 0.141841 1.277771 0.465120)
     )

;;; 82 prime --------------------------------------------------------------------------------
#(82 14.492313651671 #(0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)
     14.126787045134 #(0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     12.248508 #(0.000000 1.184614 -0.140262 1.658526 0.124873 1.367391 0.380481 1.732116 0.867899 -0.017336 1.076150 0.444376 1.572537 0.202201 0.224039 1.408218 1.283020 0.915252 0.286159 0.224109 1.793574 0.275656 1.510746 1.867911 0.220531 1.152592 0.380951 1.153960 1.895317 0.328068 1.983850 1.871605 0.611849 0.478040 1.445928 0.031079 1.103793 0.138290 0.125236 0.231943 0.387489 1.188359 0.433773 1.537111 1.511525 0.342010 1.630312 0.439409 0.624688 0.550396 0.026462 0.171311 0.463845 1.962597 0.157334 0.397015 1.189434 1.405199 1.325258 -0.034359 0.993057 1.596429 1.713167 -0.101772 0.691276 1.368396 1.730224 1.282771 0.506696 0.229349 0.913958 1.210949 0.762866 1.598390 0.478846 1.207150 0.828317 0.209451 -0.095396 0.613066 0.679687 0.096406)
     )

;;; 83 prime --------------------------------------------------------------------------------
#(83 14.249828726851 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)
     14.019070339131 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     12.526927 #(0.000000 0.480105 1.333298 0.728069 0.819784 1.770291 1.354905 0.159051 1.441141 1.755054 1.071844 1.726233 1.531243 1.510189 0.338333 1.817512 1.805371 1.526981 0.687681 0.614640 0.088649 1.699608 0.845983 1.519562 0.350203 0.571506 0.179678 0.524900 0.919248 1.182199 0.013978 1.723366 0.140720 1.704215 0.767025 1.603706 0.681964 1.823072 0.805414 1.369569 1.705369 0.844021 0.926624 0.010876 1.195922 0.558989 1.398543 0.531605 1.577453 0.857053 0.496758 0.219821 0.171544 0.806227 1.566898 1.745277 1.026983 1.416867 1.689478 0.393685 -0.071388 0.650989 0.666808 0.033332 1.868124 0.401936 0.621755 1.594924 1.561550 0.436431 1.769422 0.835995 0.642730 0.445266 1.945024 1.457345 0.126514 1.477984 1.450404 0.160739 0.552261 1.388070 0.255595)
     )

;;; 84 prime --------------------------------------------------------------------------------
#(84 14.422843763275 #(0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)
     14.299305314276 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.264351844788 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.024940956301 #(0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     12.680311 #(0.000000 1.161609 1.134248 1.467883 1.078029 1.310520 1.041039 -0.150083 -0.349230 0.450092 0.767997 0.994582 1.001122 0.741058 1.132377 -0.123378 1.892260 1.376621 0.695927 0.920258 1.367789 1.332102 -0.250357 1.365499 0.680202 0.450268 1.012341 0.495608 0.800045 0.227749 1.021622 0.225314 1.785315 0.728052 0.543515 0.325639 1.303032 0.785391 0.577530 0.690144 0.535409 1.229711 0.307578 1.233348 -0.273441 0.209985 0.922904 0.611047 0.989740 1.309514 0.095028 1.092605 1.893768 1.005364 0.280222 -0.578980 0.786915 0.635082 1.796577 0.393701 1.100973 0.824106 0.419535 1.188959 0.472517 0.965522 -0.386243 1.351303 0.055701 0.563798 0.736981 0.320324 -0.121522 1.238132 1.437169 0.766083 0.526526 1.280573 -0.054821 0.907266 1.379669 1.006911 0.240913 0.610641)
     )

;;; 85 prime --------------------------------------------------------------------------------
#(85 14.721940394615 #(0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1)
     14.400919537796 #(0 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)
     14.253310943921 #(0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     12.580818 #(0.000000 0.156669 0.223302 1.777139 0.484350 1.605580 1.023542 1.165289 1.152207 1.683624 0.424814 1.701466 0.838200 0.891056 0.995070 -0.106403 1.511315 1.502622 1.390342 1.303415 1.653097 0.725118 0.309627 1.265662 -0.094423 0.121502 0.077632 1.017653 1.173052 1.399328 0.679623 0.238940 0.596971 1.940969 1.182853 1.126000 0.848287 1.043508 0.961193 1.534927 0.697152 0.039806 0.547268 1.513401 0.052979 1.779816 0.099190 1.411342 0.676171 1.601352 1.025934 0.845984 0.098180 0.882146 -0.113798 0.878815 0.172760 1.221088 1.697600 1.728977 1.538977 -0.422900 1.645322 1.418083 1.603549 -0.197222 0.740448 1.697358 1.310641 1.162196 1.931082 0.790876 1.041178 -0.111035 1.676025 0.325037 -0.093705 0.674538 0.523497 0.350901 1.176416 1.457796 0.727103 -0.042765 -0.081880)
     )

;;; 86 prime --------------------------------------------------------------------------------
#(86 14.990488745309 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1)
     14.394402956102 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1)
     14.017106967247 #(0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

     12.374880 #(0.000000 1.215138 0.798798 1.657095 1.022979 0.971176 1.139675 0.960215 1.763704 0.641087 0.299716 0.717744 1.204160 0.213846 0.576319 0.311589 0.516364 1.203327 0.870523 0.489062 0.792033 0.312833 0.067330 1.643917 0.169539 1.649629 0.231686 1.899402 0.492362 1.288249 1.775938 0.304778 1.662075 0.302367 0.179717 1.659436 0.988245 1.157541 0.561345 0.020423 1.489570 1.569139 1.789421 1.650809 1.021867 0.618313 0.505690 0.051902 0.968868 0.987815 0.304767 1.764845 1.148402 0.703036 1.858224 0.768883 0.830609 1.661237 1.394735 0.768770 1.850958 0.612315 1.121275 0.767844 1.633089 1.634359 0.116320 0.413084 0.098248 0.224031 1.003720 1.685135 0.033212 1.352408 0.653333 1.614739 1.763891 0.493538 1.542759 0.712894 0.731267 0.273693 1.236853 1.068828 1.892635 1.355860)
     )

;;; 87 prime --------------------------------------------------------------------------------
#(87 14.798576861642 #(0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0)
     14.519235937355 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)
     13.981919502482 #(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

     12.830246 #(0.000000 0.512608 1.182356 1.271013 0.001828 1.687587 1.150670 1.508071 1.615757 0.641632 0.093017 1.348542 0.045302 0.215915 0.452494 0.949417 0.255292 0.222130 1.702042 1.772470 -0.108026 0.339827 0.688478 1.449066 0.943031 1.805287 0.776939 -0.062794 1.079055 0.190949 1.032483 0.103021 1.562375 0.851401 1.389370 0.430222 0.836487 1.806214 0.498339 1.221306 1.284313 0.258335 0.283667 1.131241 0.555445 1.705219 1.143725 0.672277 1.395658 0.716229 1.700328 0.581874 1.571143 1.538443 0.276202 1.867254 1.043116 1.904830 0.633196 1.488083 0.366185 1.260925 1.531810 1.850185 0.399226 1.161990 1.548832 0.947428 1.294927 -0.107964 0.505734 1.615092 1.314612 0.941029 1.707996 1.531926 0.902044 0.447085 1.821520 0.347599 0.741752 1.464708 1.620619 1.265647 1.594767 1.765935 1.653599)
     )

;;; 88 prime --------------------------------------------------------------------------------
#(88 15.158827781677 #(0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1)
     14.908 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0)
     14.84298551254 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.837036132812 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.822916620445 #(0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     13.061547 #(0.000000 0.881911 0.603313 1.855497 0.369091 0.307557 0.608993 0.974127 0.585407 0.451893 1.447374 0.832509 1.534060 1.472524 1.198304 0.899722 0.211902 0.591473 0.472100 0.421654 0.459357 1.265558 1.067817 0.814053 0.439311 1.573945 -0.273257 0.079297 0.926082 1.651610 0.772087 0.109289 0.606424 0.428425 0.878763 0.189833 1.283767 0.608386 1.492253 0.150230 0.559824 0.990017 0.553437 0.246331 1.985109 1.583552 1.768127 1.531881 1.634613 1.153242 1.725409 0.916846 1.684771 0.323660 1.278431 1.794002 0.757027 1.181572 0.530775 0.006476 1.028714 0.904722 0.724770 0.302368 1.736708 0.421512 1.768152 1.698319 1.300724 0.239941 0.734725 0.793169 1.049155 -0.331777 1.869040 0.545327 1.027839 0.979091 1.743471 0.678009 1.610183 1.583484 1.225192 0.603649 0.899512 0.352839 1.299620 0.685222)
     )

;;; 89 prime --------------------------------------------------------------------------------
#(89 15.157893052401 #(0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1)
     14.687564188381 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

     13.133239 #(0.000000 0.474067 1.328385 0.121610 0.556417 1.433317 0.963459 1.325589 -0.011548 -0.269612 0.478473 1.556808 1.777402 -0.058627 1.680882 0.283084 0.629908 -0.293450 0.131229 1.109815 1.410775 0.962846 -0.250610 1.170574 0.021110 0.618285 0.919928 1.580001 -1.868690 0.532416 1.682450 1.193582 0.247687 0.941183 0.730285 1.624986 0.999350 0.357592 -0.043563 0.505558 0.025429 1.069667 0.980797 1.232559 1.620747 1.325687 1.689221 1.310063 1.557919 1.565412 0.343579 0.066764 0.306331 1.825024 0.566852 1.812056 0.245357 0.893216 0.125480 1.553106 1.465912 1.517049 1.485818 1.903628 0.279777 1.582681 0.710115 -0.024021 0.014568 0.994624 1.660122 1.599362 -0.263956 0.787765 1.495238 0.886899 1.618754 1.275427 0.483203 1.359391 0.929162 0.578596 0.245157 1.327030 1.410435 0.954423 0.316289 1.661324 0.408070)
     )

;;; 90 prime --------------------------------------------------------------------------------
#(90 15.253639451837 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.914762472218 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.831111851861 #(0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     13.162857 #(0.000000 0.396435 1.693711 1.085133 1.212885 0.406261 0.333655 0.670033 0.656176 0.250835 0.493487 -0.013745 0.151044 0.917960 1.704835 1.154840 1.463578 1.618328 0.396488 1.874698 0.190051 1.733709 -0.123548 0.610448 1.485884 1.200156 0.574448 0.144903 0.142185 0.511664 1.646563 1.801856 0.257563 1.426319 -0.016926 -0.283413 1.107482 1.505059 1.518832 0.438108 -0.008538 1.866218 0.959287 0.981861 0.217725 1.060791 0.100059 0.613065 0.605526 0.946504 -0.217629 0.316020 1.468017 0.352394 1.624964 1.137433 1.374493 0.033002 0.801959 1.277408 1.553725 1.400978 0.636741 0.108001 1.064543 1.712569 0.299712 1.580555 1.049159 1.305944 0.998682 0.009358 1.474572 0.295422 0.381046 1.397743 0.390474 1.696179 0.363677 0.970514 0.835908 1.050257 -0.034975 -0.209010 1.561102 0.605212 0.605404 -0.155232 1.145004 0.907171)
     )

;;; 91 prime --------------------------------------------------------------------------------
#(91 15.264 #(0 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0)
     14.775403022766 #(0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0)
     14.702056847646 #(0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     13.011708 #(0.000000 1.654368 0.721386 0.881770 1.678631 1.246287 1.954370 1.117524 1.049359 1.821860 1.159273 1.330212 0.956121 1.669731 1.779165 0.928912 1.052879 1.396846 1.799666 -0.026073 1.770363 1.334860 1.622629 0.627669 0.872398 0.555572 1.745054 1.417163 1.622532 1.287768 0.790772 0.228944 0.261481 0.691794 0.367932 1.296541 1.794633 1.774801 0.649458 0.639680 -0.308420 0.064811 0.573057 0.663668 0.794098 0.087575 1.575774 1.174741 0.022096 0.804518 0.861807 0.528511 0.602634 -1.666337 0.907502 1.350409 0.491259 0.568720 1.447149 1.473819 0.485750 0.415904 1.768634 0.066881 -0.112940 1.447901 1.242759 1.665913 0.721532 1.434181 0.373125 1.664076 0.600200 0.773137 0.451721 1.134488 1.416125 0.850300 1.586521 0.622542 0.007845 1.112759 1.957516 0.307926 0.437152 0.594373 0.735481 0.879954 1.305285 -0.014146 0.342071)
     )

;;; 92 prime --------------------------------------------------------------------------------
#(92 15.373 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     15.307026596891 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     14.939027786255 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)
     14.556435035882 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     13.108861 #(0.000000 1.243007 1.313229 1.337865 1.673540 1.246884 0.381330 0.187843 1.442544 0.494854 1.668805 0.476930 1.028540 1.000909 1.477318 0.214706 0.532786 -0.452166 -0.013047 0.296030 1.689737 0.478125 0.309996 1.224731 1.690498 0.863358 -0.346338 0.944734 1.398653 0.501859 0.694954 0.783014 0.990800 1.738620 1.133773 1.813483 0.108703 1.077017 0.818476 1.358584 0.490943 0.199982 0.543310 0.164343 1.455859 1.056150 0.895266 1.807315 0.710778 1.081712 1.755515 0.904613 1.565441 1.714224 1.266019 0.172876 1.188097 0.104573 0.149325 0.644330 0.300365 1.132474 1.258322 1.414984 0.943533 1.256939 0.152799 1.439012 1.108868 1.552931 0.650864 1.678979 1.098795 -0.027826 1.513947 1.318686 0.867762 1.726108 0.968690 1.924834 -0.224070 1.264622 1.341739 1.486837 0.552136 0.686208 0.669058 0.654809 0.186404 0.981938 0.645983 1.122993)
     )

;;; 93 prime --------------------------------------------------------------------------------
#(93 15.814494404587 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     15.072628413546 #(0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1)
     14.994668960571 #(0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     13.255689 #(0.000000 0.278457 1.365323 0.140772 1.254488 -0.040257 0.182176 1.282214 1.035884 1.432861 -0.353305 0.043904 1.686231 -0.003789 1.857757 0.002206 0.146246 1.761838 -0.028980 1.189273 1.470954 1.322506 0.609882 1.117913 0.761215 1.736370 0.069246 0.525778 0.854129 0.241248 1.769645 1.337125 0.469777 1.908976 1.619864 1.287504 0.889268 -0.042134 1.881959 1.760449 0.932485 1.132573 0.025868 0.517288 1.722017 0.419654 1.093305 -0.188263 0.473912 1.561557 0.525112 0.227822 1.123952 1.410791 1.075436 1.202958 1.299787 0.198821 0.353545 0.320915 0.809575 0.439111 0.852596 0.385230 0.391816 0.715616 1.363489 1.235724 1.245973 0.651216 1.830463 1.728765 0.411332 -0.105063 0.348554 0.531055 0.253865 0.709039 0.158738 1.478896 0.088669 1.059939 1.672423 0.446590 0.309151 0.016987 1.533981 0.599850 0.054159 1.197912 1.508946 0.175459 1.407454)
     )

;;; 94 prime --------------------------------------------------------------------------------
#(94 15.835750579834 #(0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     15.438541412354 #(0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)
     14.811392756555 #(0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     13.366475 #(0.000000 0.415672 0.980875 0.544104 0.617230 0.246685 0.118415 1.536736 1.351230 0.900185 0.214328 -0.143707 0.578337 1.484379 0.521506 1.169376 0.797046 1.067955 1.002244 0.182614 0.006376 0.388371 1.441817 1.361397 1.526017 0.002044 0.079310 1.106067 1.470817 1.732767 0.461361 1.762313 0.684868 1.178351 0.545476 1.744247 -0.130302 0.826492 1.660158 0.621414 0.703556 1.095813 0.166153 0.287580 1.503991 1.656354 1.625364 1.263878 1.446928 0.003016 0.854038 0.921272 0.074817 0.572251 0.694519 1.399481 1.631237 1.286538 1.289871 0.909119 1.661463 1.258851 0.130576 0.023982 1.516513 0.605428 0.810103 0.491157 0.610558 0.309308 1.730523 0.438840 0.914750 0.738130 1.032205 0.154829 0.523697 0.741402 1.527563 0.442547 1.191142 0.960503 1.791222 0.246914 0.413698 1.125839 1.307812 0.681498 0.271053 1.074021 0.020652 1.060996 0.719962 1.276626)
     )

;;; 95 prime --------------------------------------------------------------------------------
#(95 15.827 #(0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.613794808095 #(0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.240 #(0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     13.661656 #(0.000000 0.489810 0.973068 0.354385 1.260128 1.496597 1.666508 1.491678 1.317221 0.279717 1.214898 -0.198746 1.054618 1.052564 0.881472 1.014637 0.872287 1.625973 1.700397 1.499853 1.097055 0.341863 1.214765 0.090743 0.279420 0.844161 0.228862 0.573339 1.110434 0.357945 0.057446 0.319392 0.519489 0.753751 0.763178 0.317479 1.207890 1.000407 0.629691 0.218212 1.466417 1.781086 1.698598 0.576384 0.408704 0.190930 1.432595 0.228098 0.424466 1.614069 0.481908 0.196452 0.147134 1.112816 1.610358 0.113060 0.871803 0.830741 0.797736 1.416616 0.863706 0.641875 0.573968 0.214155 1.242294 0.391358 1.917176 1.762177 -0.000126 0.596757 -0.200600 0.447195 1.488220 1.184619 1.753360 1.444159 0.486385 0.114316 0.001301 1.920103 0.423652 0.842335 0.564436 1.939101 0.415956 1.376373 0.556022 1.183370 0.241504 0.981332 0.098572 0.450962 -0.211538 1.681984 0.861212)
     )

;;; 96 prime --------------------------------------------------------------------------------
#(96 16.042188134982 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.648203810823 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.281 #(0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)
     15.135 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

     13.575838 #(0.000000 1.145330 1.283097 1.400139 1.729045 0.012208 1.330905 1.741431 0.796723 0.884322 0.325701 0.898093 0.231415 0.671880 0.040621 1.147776 1.291615 0.949435 0.155940 0.424073 0.215066 1.274053 1.834780 0.554023 1.172005 0.974705 0.232960 0.672401 1.033221 0.523220 0.107260 0.993639 1.096335 1.560096 -0.127448 0.456769 1.252358 1.340327 0.642230 1.494159 0.237626 -0.101811 0.217127 0.880690 1.777590 1.150203 0.528805 0.143253 0.000616 0.880618 1.801429 -0.125188 0.470157 0.181805 1.908756 0.077441 0.352566 1.599502 1.429175 1.444514 1.008276 0.836817 1.144794 1.018507 1.220951 1.754763 1.134452 1.094757 1.228623 1.470155 -0.024643 0.730873 1.412848 1.471091 0.666358 1.863641 1.183968 1.023419 0.666301 1.335020 0.109482 1.488491 0.655494 1.492357 1.337993 1.763330 1.311209 0.800288 0.049105 -0.123256 1.409361 1.390902 1.970788 1.190384 0.232873 0.733629)
     )

;;; 97 prime --------------------------------------------------------------------------------
#(97 15.972457232959 #(0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.726 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.685384750366 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)
     15.404807595571 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

     13.730655 #(0.000000 1.203347 0.161575 0.469484 0.224844 0.934601 0.148052 0.360374 1.939348 0.666887 1.142595 0.502115 0.533157 0.647743 1.734199 1.205084 1.620600 0.336202 1.447985 1.579412 0.603460 1.100355 0.200033 0.176444 0.816195 0.785842 0.476905 1.477281 0.535310 1.444910 1.106936 0.778256 0.994907 -0.016944 1.659609 1.735742 1.465796 1.514923 0.306639 1.281728 1.549419 -0.234050 0.350835 0.103811 0.837468 1.049704 1.799403 1.842979 0.595462 0.568705 0.390400 0.427182 1.295829 0.429277 -0.003135 -0.021056 -0.073191 1.169237 1.405015 0.862539 1.821944 0.542235 1.775283 1.340384 0.577464 1.610675 0.117059 0.312897 0.983533 0.387686 0.516142 -0.024508 1.496101 0.932388 -0.002428 1.615141 0.718034 0.175179 0.037242 0.321396 1.246330 -0.121332 0.437009 1.558439 0.095040 1.337900 1.527898 0.554959 1.683314 0.880538 0.943179 -0.171692 0.343130 1.392987 0.880277 0.836090 0.978610)
     )

;;; 98 prime --------------------------------------------------------------------------------
#(98 16.082024156883 #(0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.695913722267 #(0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.435913738557 #(0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

     13.883886 #(0.000000 0.711553 0.383242 1.889647 1.021709 1.265956 1.616776 1.213531 0.449991 0.533561 1.376197 1.296256 0.489223 0.118703 1.522078 1.095180 1.573754 -0.043781 0.702122 1.033748 0.385411 1.362147 0.026329 1.885701 0.680260 0.632397 1.751357 0.301125 0.804308 1.665805 0.264397 1.501955 1.251078 1.092354 1.954638 1.297341 0.826306 1.524071 0.643720 1.851482 1.217229 1.400471 0.770414 1.715410 1.538540 0.650710 0.606973 0.392989 0.182684 1.290943 1.654879 1.541518 0.558493 1.445226 0.051826 0.470140 0.835188 0.768752 0.657422 0.449927 1.402967 0.329165 1.579877 0.263200 1.865396 0.763565 0.916539 1.632604 1.526440 1.206136 0.627538 0.335091 0.976925 1.027395 0.095088 0.031759 -0.269495 1.186832 1.547667 0.551210 1.637871 1.922825 -0.007929 0.052965 1.801425 1.212017 1.448339 1.921517 1.879043 1.198692 1.738549 1.356749 1.336618 1.885300 -0.128505 0.509078 -0.166663 0.709593)
     )

;;; 99 prime --------------------------------------------------------------------------------
#(99 16.0734 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0)
     15.391923904419 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

     14.050489 #(0.000000 1.543611 0.703528 0.638617 1.747527 1.564330 0.416799 0.037985 1.138913 0.674920 1.117145 0.388682 0.662956 0.819577 0.785832 1.442802 0.584814 1.277872 1.708438 1.525178 1.187341 0.758232 1.216045 1.092326 0.848085 1.872216 0.046116 0.763932 1.225666 1.043579 1.243981 1.585858 0.333864 -0.014773 0.730490 0.833676 0.928831 0.964802 0.882589 1.013880 0.029785 1.539395 0.667681 0.803389 1.440473 1.524327 1.231740 0.734152 0.500589 -0.011928 1.654107 0.655443 0.448475 1.123634 0.811348 -0.059232 1.043667 0.509839 0.948532 0.016886 0.471424 0.352704 0.919433 0.628870 1.938645 1.820540 0.405728 -0.279208 -0.220560 0.539771 1.635668 0.251563 1.089842 0.758244 1.070885 0.079250 1.248630 1.077488 1.553214 0.895319 0.084428 0.349554 1.287461 0.441767 0.389266 1.127237 0.063844 0.562887 0.606369 -0.040592 1.163200 1.771625 0.486698 1.568648 0.833843 1.626126 0.861851 0.460495 1.338529)
     )

;;; 100 prime --------------------------------------------------------------------------------
#(100 16.360503791276 #(0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0)
      15.909478013087 #(0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0)
      15.637986183167 #(0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

      14.002412 #(0.000000 1.256653 1.362663 1.473590 1.595231 0.485974 1.448948 0.924036 1.062715 0.605104 0.257844 1.534823 1.246404 0.890429 0.409500 1.596825 0.512990 -0.169593 1.201596 -0.005623 1.150620 0.512530 0.347794 0.750875 0.507617 -0.276273 0.044508 0.316696 1.409930 0.587875 0.787904 1.181345 -0.022933 1.434672 1.289880 1.997947 1.228887 1.382534 1.248094 0.222017 0.238285 0.299695 0.368945 1.085299 1.439469 1.039329 -0.015874 0.893404 1.224791 0.206816 1.464403 1.515182 0.724083 -0.090915 0.679300 1.035196 0.901503 1.886587 1.776616 1.158610 1.650218 1.976942 -0.207631 1.323427 1.635211 1.127411 1.827732 1.166524 0.615822 1.047210 0.121697 1.632859 0.277622 1.584058 1.245159 1.888559 1.032659 1.238024 -0.081194 0.048707 1.426913 0.669027 1.161202 0.600583 1.157255 1.557904 0.513885 0.790276 1.589115 1.834860 1.038888 0.961422 1.863344 1.716525 0.609230 0.559110 0.684747 0.207299 1.487019 1.281561)
      )

;;; 101 prime --------------------------------------------------------------------------------
#(101 15.994265071036 #(0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0)
      15.74836063385 #(0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
      ;15.594883219789 #(0 1/2 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
      15.735968313601 #(0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

      14.040569 #(0.000000 0.577519 1.854665 1.532685 0.979289 0.058238 0.459093 1.545420 0.295336 0.107775 0.452294 1.370090 0.435708 1.922843 1.198961 1.463686 -0.136343 1.539762 0.571081 1.161864 0.683643 1.274928 0.224229 1.301314 1.924628 0.156612 0.402509 0.748066 -0.220815 0.119993 1.902660 1.441187 1.057216 1.105630 0.585295 1.054712 0.910817 0.127937 0.528500 0.092093 1.704506 0.190195 1.310130 0.984829 0.501491 0.553195 0.261279 1.465992 1.406337 1.040087 0.507322 1.642878 0.197535 1.389268 -0.076053 0.875653 0.197439 0.079126 0.587253 1.001471 0.848286 0.056704 1.184465 0.046151 0.633770 -0.002533 0.773212 -0.025300 0.917608 1.038205 1.362525 -0.085360 1.222037 0.074895 1.567619 0.827945 1.005208 1.280542 0.696962 1.471737 0.775768 0.221926 0.495267 1.190052 0.542810 0.840307 0.223592 0.398466 1.084527 0.640099 0.399987 0.362636 0.847244 0.312265 0.040691 0.198833 1.121826 1.121318 0.090500 0.414293 0.773925)
      )

;;; 102 prime --------------------------------------------------------------------------------
#(102 16.342473246951 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1)
      15.374809992584 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

      14.250669 #(0.000000 0.352114 1.341167 0.052218 0.429463 1.570346 0.308311 0.661694 0.894451 1.451013 1.622148 0.030847 1.739372 -0.114487 0.358586 1.173849 1.481796 0.171998 0.559143 1.284007 1.052596 1.949163 1.565518 -1.767913 1.290270 1.167943 0.823382 1.679270 0.011878 1.769068 1.245713 1.387335 0.749592 1.527214 0.346528 1.131487 0.837218 0.193640 0.321548 0.811837 0.570646 0.310673 1.517668 0.805792 1.366652 1.516603 1.488734 0.635922 0.509674 0.860491 1.255465 1.502731 1.565634 1.240160 0.261902 1.740528 1.005637 1.696061 1.551236 1.019221 1.353626 1.006277 1.643199 1.231794 1.660500 1.035823 1.472483 0.029209 0.976929 0.756754 0.521466 1.675260 0.410999 1.344006 0.751637 1.434600 1.380715 0.300090 -0.108673 1.545738 -1.998411 0.522495 0.810557 0.503050 1.714972 0.561814 0.695936 0.517631 0.315910 1.377112 0.830965 1.499712 1.893622 1.351348 1.265617 0.059428 1.237684 0.347352 1.370718 0.703584 -0.118165 1.955200)
      )

;;; 103 prime --------------------------------------------------------------------------------
#(103 16.7018587939366 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)
      16.296298498866 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

      14.383287 #(0.000000 0.274113 0.455502 0.288605 0.721951 0.489416 1.540926 1.535320 0.609731 1.596000 0.518007 0.673139 0.321993 0.056009 0.054017 1.629766 0.781607 0.063356 1.613268 0.184331 0.969015 1.161798 -0.066849 0.500322 0.911137 0.139916 0.889463 0.157680 1.380937 1.376678 1.299693 0.559134 0.098556 1.415706 0.529740 1.097133 0.426216 0.191880 1.870999 0.634119 0.039605 1.601204 1.840561 0.630651 0.051374 1.076807 0.292162 0.865778 0.115292 0.746020 0.514438 0.609818 0.810281 1.827987 1.640469 1.234046 1.317550 1.733160 0.262902 1.948992 0.882541 0.051331 0.618536 0.375497 1.372014 1.457061 0.225147 0.812012 1.333823 0.272105 1.008858 -0.144457 1.804408 1.587420 0.579213 1.324303 1.607022 0.566371 1.044276 0.784119 1.697600 1.412274 0.863758 0.605471 1.130970 0.786327 1.176125 0.925864 0.264273 0.483798 1.588133 1.821063 0.827443 1.645570 0.570427 1.299910 0.246216 1.241572 1.603559 1.193118 0.595268 0.354542 0.938643)
      )

;;; 104 prime --------------------------------------------------------------------------------
#(104 16.659368297545 #(0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      16.473171464163 #(0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      15.919013023376 #(0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

      14.462217 #(0.000000 0.184400 0.972027 -0.048262 -0.248377 1.606238 0.174924 1.287636 1.284493 1.082602 1.185148 0.255799 1.920926 1.486063 0.824238 1.328093 1.140014 1.023849 0.936295 0.331171 0.050842 1.796791 0.373754 0.190720 0.772968 0.902032 0.509311 1.263609 0.452655 0.805215 0.666940 0.166230 0.731936 1.590929 1.353127 1.388409 1.467989 1.302840 0.627828 1.381944 0.814561 0.804380 1.586160 0.727511 0.507465 1.417281 1.015315 1.232031 1.638009 0.148593 1.820997 1.759071 1.530642 0.846638 1.002321 0.721357 1.808852 0.341237 1.880623 1.304292 -0.115041 0.289553 1.276707 1.309295 1.529269 -0.138142 1.692720 1.360704 1.122564 -0.065364 1.484409 0.170222 0.839982 0.311316 0.801065 1.444322 1.819209 -0.243262 0.128617 1.421854 1.382445 0.858273 0.282217 0.626784 1.415687 1.542699 0.231439 1.362841 1.074055 1.107052 0.015933 0.342519 0.750708 0.127843 0.226976 1.241446 0.330320 0.744411 1.295498 0.844922 1.419834 0.768152 1.276729 -0.049282)
      )

;;; 105 prime --------------------------------------------------------------------------------
#(105 17.115185731735 #(0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1)
      16.038356734428 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

      14.657216 #(0.000000 -0.054397 0.349988 0.145882 0.194170 1.393811 0.646673 0.600485 1.941490 0.894229 0.317075 1.684176 0.685834 0.565385 1.733713 1.728532 1.374410 0.098123 1.607632 0.126007 1.063972 -0.116978 1.491203 1.149374 1.312246 0.222419 1.483802 1.371247 1.183769 1.574035 1.784911 1.288159 0.258398 0.085051 0.685680 1.438958 1.236322 1.561677 0.813326 1.177967 0.417050 0.091699 -0.017069 0.348013 1.453533 1.697068 1.517496 0.312183 -0.056139 0.435878 1.278716 1.280872 0.054718 0.746397 1.538366 -0.130378 1.446856 1.778208 0.681314 0.753731 1.778505 0.382849 0.197429 1.612970 1.060421 0.773380 -0.009813 0.079701 1.003943 1.901776 0.906726 1.422433 1.337479 -0.064470 1.146166 0.051160 1.811129 0.669278 1.521856 0.436891 0.650410 0.800210 1.100606 0.508123 1.468055 1.781080 1.135368 1.487805 1.487236 1.717072 1.267043 -0.080995 0.001501 1.112392 1.412994 0.030544 1.009569 1.792692 0.454764 0.984145 0.094418 1.823057 0.525108 1.343336 1.786438)
      )

;;; 106 prime --------------------------------------------------------------------------------
#(106 16.130035426315 #(0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1)
      15.730461834714 #(0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

      14.944502 #(0.000000 1.169392 1.738346 0.897998 -0.217852 0.891170 1.978395 1.616453 0.650906 0.489028 0.508928 0.493082 1.316951 1.695542 0.608260 1.429901 1.194552 0.073153 0.887378 1.373922 0.381129 1.790930 1.276194 -0.281908 0.966837 1.474760 1.112905 0.704143 1.895059 1.126070 1.499359 1.771187 0.453435 -0.014418 0.736670 0.982455 1.267892 1.387205 0.485341 1.257456 1.168797 0.683391 1.208540 1.428338 1.386055 0.172356 0.656914 0.094944 0.902503 0.308308 1.057301 0.970831 -0.162448 1.022627 1.184882 1.191743 1.359175 0.411340 0.344508 0.089800 0.302741 1.044382 0.555010 1.576562 0.648596 0.759112 1.187341 0.808403 1.067683 0.560074 1.213902 1.171248 0.485293 0.205967 1.751688 0.702270 0.282706 1.789403 0.388659 0.390708 1.908486 0.042838 1.223403 0.448965 1.279556 1.388818 0.927209 1.582044 0.864213 0.788213 -0.216894 0.233466 0.964438 1.746323 1.757220 1.813237 1.058857 1.187035 0.225932 0.508278 -0.136316 0.388853 1.244545 0.927794 0.812504 1.016927)
      )

;;; 107 prime --------------------------------------------------------------------------------
#(107 16.541004232936 #(0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1)
      16.328491210938 #(0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.264743804932 #(0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.197 #(0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

      14.958616 #(0.000000 0.337986 0.477712 1.211400 0.785512 1.657813 0.986578 1.935139 1.679015 0.143901 1.596992 1.424040 1.493126 0.793579 0.102430 0.526283 0.463608 0.746070 0.482547 0.007884 1.186392 0.946593 0.560579 1.018459 1.861677 0.646023 0.208743 1.426481 0.232236 1.640846 0.371364 0.864584 0.131291 1.008067 1.189038 0.201290 1.232363 0.908669 1.253570 1.039907 0.008447 1.280250 1.447172 1.157568 1.177416 0.761037 1.518089 1.951140 1.429724 1.287925 1.509981 1.691649 0.838196 0.448372 1.513719 0.633955 0.248084 1.334542 0.691716 1.164290 0.829138 0.488328 0.409631 0.538342 1.218657 1.375471 0.531847 0.749572 1.936940 0.157373 0.609888 0.441501 1.889711 0.902065 0.308197 0.523541 0.822547 0.401420 1.070065 1.374783 0.779035 1.646786 0.058496 0.671411 0.290739 0.536407 1.491618 0.709528 1.559973 0.474103 1.761148 1.561393 1.240461 0.863159 0.257175 1.331302 0.909821 0.449817 0.121944 0.262198 0.609158 1.519706 1.234266 1.299789 0.639872 0.089115 1.120832)
      )

;;; 108 prime --------------------------------------------------------------------------------
#(108 17.139458240072 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1)
      16.666560972988 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1)
      16.517358779907 #(0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

      15.180521 #(0.000000 0.457934 0.599783 1.248402 0.112347 1.639837 -0.102195 1.474807 1.168267 1.710383 -0.006259 0.242452 1.187052 0.730301 1.889138 0.203929 1.641633 1.752785 1.259166 0.729222 0.828398 0.936209 0.502962 1.051672 1.807966 1.642769 0.296286 0.222098 1.753644 1.801383 0.521068 0.959473 0.145960 0.315863 1.124936 0.672429 0.759957 1.119953 0.042335 0.354182 0.517415 1.009907 0.871789 -0.174704 0.734397 0.217667 0.526413 1.896713 0.614394 1.802450 0.644597 1.809650 1.750481 -0.039151 1.370288 0.102512 0.735305 1.407392 0.762382 1.356424 0.748672 0.468831 0.585614 0.521789 0.473449 0.349680 1.835075 1.358711 1.980958 0.532559 0.849908 0.736276 1.769653 0.770769 0.389697 1.576033 1.696338 0.094944 0.050586 0.661995 1.126783 0.922675 0.113700 1.949682 1.517431 0.213238 0.916183 0.204529 0.332564 0.692845 1.513266 0.544444 0.603773 1.440661 1.241760 0.591563 1.168323 1.553477 0.439811 1.781240 1.512166 1.633565 0.029458 0.108337 1.765873 0.015011 -0.375904 1.693666)
      )

;;; 109 prime --------------------------------------------------------------------------------
#(109 17.453163146973 #(0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)
      17.088904329068 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.93954489715 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.726722717285 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

      15.116144 #(0.000000 1.328016 -0.014627 0.828407 0.709438 0.969604 0.109411 0.142268 0.859426 0.627723 0.396900 1.013543 1.334113 0.236951 1.647469 1.634103 1.549699 1.067291 1.870779 0.321965 0.150511 0.825968 0.056071 1.436713 0.729978 1.258597 0.062181 1.642067 0.539325 0.877875 0.929857 1.673575 0.850272 0.048450 1.415204 0.984104 1.372867 0.744318 0.952336 1.171745 1.592504 1.471107 0.774946 0.443030 1.382441 -0.036507 1.641521 0.271323 1.002206 0.045524 1.690616 0.259979 1.362590 0.709027 0.884184 0.354633 0.680805 0.767728 0.894958 0.994852 0.799216 1.592644 0.831434 1.544499 0.482599 0.746455 1.586021 0.899663 1.447670 1.233610 -0.040682 0.865859 0.103649 0.355520 1.146127 0.724734 0.506231 1.425053 0.422570 1.600967 1.060961 1.446829 0.510052 0.432553 0.391261 0.170982 -0.006976 0.862684 1.653057 0.431448 0.548333 0.340300 0.707395 0.164920 1.538667 1.848902 0.322015 0.570827 1.713248 1.475702 0.482897 0.253137 1.151403 1.319560 1.159692 0.893035 0.741349 1.156324 0.289482)
      )

;;; 110 prime --------------------------------------------------------------------------------
#(110 17.014086078381 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1)
      16.799713998439 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1)
      16.455888332339 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

      14.980759 #(0.000000 1.074658 0.558515 1.431492 0.124283 0.999871 0.898426 1.004570 0.212835 0.143491 1.143601 0.035967 1.840367 0.436672 1.689510 0.381235 0.208193 0.731691 0.736159 0.834986 0.214302 0.770594 1.634162 1.246341 1.826200 1.253052 -0.091297 1.430864 1.362764 0.251470 0.496236 0.996690 0.004878 1.036245 1.547249 0.415263 0.066712 1.538365 0.315252 1.733144 1.703466 0.133748 1.121058 0.528822 0.464264 1.423505 0.329785 1.930708 1.581624 0.260657 1.813709 0.742775 0.256403 0.066489 1.703301 -0.029923 1.923895 1.662992 0.607315 1.668943 0.890710 1.456032 0.602640 1.318994 -0.011734 0.447459 0.635899 1.124241 -0.190853 0.398089 1.872772 -0.047321 0.660653 1.582452 -0.015802 1.748130 1.794795 0.738009 -0.071885 1.494138 1.823640 1.360336 0.932554 0.965180 0.133207 1.613385 1.795499 1.364325 1.440466 0.351398 0.785493 -0.054565 1.664085 0.738618 0.598879 1.785923 0.329069 1.161282 0.060081 0.530158 1.214843 0.062132 0.137141 0.557432 0.773011 0.523626 0.574780 0.419416 1.634577 0.277152)
      )

;;; 111 prime --------------------------------------------------------------------------------
#(111 16.941944255543 #(0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1)
      16.781625747681 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)
      16.664649284782 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

      15.054705 #(0.000000 0.578685 0.557626 0.746450 0.063028 1.312245 1.766595 1.172698 1.103627 0.536003 0.156959 0.304994 0.389296 1.196726 1.353208 1.295828 1.029931 0.061429 1.562851 1.241156 0.962517 1.740969 1.299690 0.363847 1.230622 0.081437 0.845321 0.553664 1.329890 1.442816 1.028141 1.047638 1.480709 0.929060 1.759690 0.510110 1.594238 0.680022 0.185411 1.860248 1.587071 0.825619 1.017484 1.720305 0.198529 0.811696 0.730775 1.369628 1.077710 1.882172 1.101499 0.010236 1.694600 1.153854 0.111429 0.655979 -0.049195 0.289695 1.725975 1.540496 0.049098 0.279285 0.548947 1.690742 1.153691 1.664177 1.847190 1.785625 1.562258 1.065804 0.787996 1.342498 1.221859 1.044568 1.500081 1.070830 0.213940 0.317656 0.513489 0.062776 -0.206974 1.734764 0.769968 0.886449 0.980647 0.077593 0.225418 1.289988 1.091715 1.465501 1.405988 -0.108775 0.257833 -0.159404 1.163136 -0.185515 1.520237 0.121392 -0.057595 0.251556 1.424747 1.449772 0.464053 1.556426 0.940025 0.387016 1.497174 -0.040642 -0.059096 0.487283 1.094120)
      )

;;; 112 prime --------------------------------------------------------------------------------
#(112 17.423562009124 #(0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)
      16.699782299357 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

      15.171359 #(0.000000 0.798075 1.971462 1.259537 1.736889 0.670779 1.134856 1.399236 0.680027 1.787254 1.105021 0.825728 1.298940 0.789463 0.953843 1.879588 0.190123 0.821768 0.063042 0.555030 0.431962 1.369096 1.187450 1.630275 0.611728 1.645597 1.400001 -0.172347 0.727514 0.032883 1.438442 1.993478 0.093679 1.438227 1.257037 0.616949 1.530462 0.817580 0.324952 1.757868 0.203575 0.095964 1.820093 0.620078 0.377845 0.214922 1.724242 0.989581 0.550491 0.162223 0.176956 0.347918 0.011331 0.407396 0.860244 1.783836 0.571202 1.134287 0.099378 0.042409 0.733995 1.774680 0.894040 1.301463 1.204736 0.582725 1.819564 1.427863 0.667528 1.772841 0.266419 1.319488 1.265617 1.841596 0.451958 0.765653 1.731058 1.823860 0.221559 1.393686 0.016466 0.543130 0.489841 0.890299 0.647839 0.259554 1.728028 1.144429 0.780829 1.272715 1.859561 1.446827 0.100769 1.455384 0.990409 0.749307 0.037353 1.294274 0.452558 1.965083 1.109858 0.690276 0.383572 0.659613 0.732265 0.928432 0.219208 0.513810 0.571681 1.109913 0.049343 0.368714)
      )

;;; 113 prime --------------------------------------------------------------------------------
#(113 17.29593895793 #(0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0)
      16.785 #(0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1)
      16.203890830538 #(0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

      15.337225 #(0.000000 0.864150 -0.172558 1.245379 1.674741 1.001316 1.437066 0.911506 1.371983 1.568049 0.731175 1.971175 0.562102 0.330611 1.104006 0.669788 0.998529 0.954483 0.278373 0.230295 0.962272 1.646800 1.366438 0.288808 0.590820 0.856132 1.717218 0.397290 0.748055 1.090875 0.523038 0.446742 0.026602 0.984134 1.749308 1.722589 0.006658 1.523626 1.824689 0.198404 0.643461 1.297679 0.443034 1.448218 1.198721 1.477431 1.315092 0.050041 1.497895 0.545256 0.442790 1.023949 0.378410 1.376055 1.256708 -0.069249 1.333711 0.047500 1.506527 1.495877 0.074300 -0.052613 0.010136 1.730840 1.152860 0.019325 0.316115 0.703733 -0.085791 1.097304 0.470978 0.700730 1.725261 0.759434 0.302870 0.498110 1.667029 0.489031 0.362819 0.014482 0.930550 1.044740 1.611492 1.347268 0.230762 1.858074 0.962192 1.307552 0.701538 0.055702 0.103068 0.614480 0.233971 1.173062 0.126823 0.871267 1.260234 0.371840 1.408120 1.811438 1.719108 1.100434 1.153357 0.745052 0.639232 1.748453 1.582982 1.815493 0.670912 1.291438 1.196836 0.981011 0.143228)
      )

;;; 114 prime --------------------------------------------------------------------------------
#(114 17.592388063856 #(0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1)
      16.771720224491 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)
      16.442732865586 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

      15.537487 #(0.000000 0.936889 0.684097 1.105723 0.000250 1.819562 1.170091 1.363833 1.365766 1.486205 1.936103 1.492912 0.983640 1.371991 0.269244 1.589801 0.103334 0.775574 1.932796 1.065270 1.347950 0.384990 1.722829 1.360617 1.383032 0.613065 0.175992 1.147591 -0.030480 0.657432 1.129572 1.423347 1.785839 0.042460 1.665452 0.402111 0.427015 1.282059 1.756301 0.555168 1.012125 1.578579 0.256972 0.609904 0.312734 0.590124 1.774867 0.284862 1.778551 0.417729 0.900199 0.664439 0.326624 0.402307 1.802235 1.759287 1.824592 1.208526 1.752649 1.838857 1.769643 1.458148 1.901352 1.547256 1.322491 0.634401 0.015913 1.684595 1.290365 0.832900 1.335029 1.298636 1.919512 0.244527 0.573986 1.199367 1.009586 0.405812 0.097204 0.315285 1.352165 -0.015903 0.059175 1.700763 0.984837 0.177024 1.261793 0.810986 0.875549 1.559991 1.433805 1.313082 1.325885 1.834561 0.280884 0.428642 0.158126 -0.036767 1.741094 1.036001 0.875289 0.523676 1.857346 1.106200 1.447863 0.867338 0.013292 0.032613 1.877741 1.223274 1.001294 0.016376 0.407580 0.403090)
      )

;;; 115 prime --------------------------------------------------------------------------------
#(115 17.480941944057 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0)
      17.152 #(0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 0)
      16.774665887963 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

      15.624996 #(0.000000 1.607357 0.425725 1.180669 0.495196 0.712555 0.313989 1.449283 0.519943 0.780319 0.563382 1.296213 1.417620 0.457758 0.239662 0.230743 -0.068438 1.006194 0.790361 1.320667 0.448100 1.037362 0.751270 0.052337 0.818375 0.578682 1.197520 1.438624 0.105874 1.496955 0.625355 0.457386 1.739703 -0.117861 0.544479 1.413376 0.307261 1.707576 -0.367413 0.793062 1.513751 -0.023205 1.602116 0.051026 0.580853 0.452484 1.597962 1.147144 0.058854 1.579037 1.448815 0.524016 -0.147703 0.993866 0.898685 1.344169 0.197431 1.637509 -0.158808 1.611189 1.606372 1.346677 1.185704 1.745715 0.395962 0.483746 1.376960 1.120169 -0.100695 0.120374 0.206245 1.431827 1.115991 0.408373 0.279257 1.586921 1.423808 0.927202 1.893914 0.615098 0.053564 1.480650 0.896847 1.862066 0.781215 1.324037 0.678799 1.526626 1.364655 0.376030 1.522809 0.457841 1.001175 1.878283 0.888654 0.740616 1.736581 1.513407 1.065272 0.164152 1.278842 0.219350 0.279374 1.285670 -0.077495 0.393145 1.228553 1.404471 1.597226 1.669660 1.232782 1.095371 0.237859 0.148431 0.452849)
      )

;;; 116 prime --------------------------------------------------------------------------------
#(116 17.885190963745 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)
      16.812931137234 #(0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

      15.294297 #(0.000000 0.925737 1.195052 0.868753 1.809581 1.192950 0.122553 1.220830 0.385967 1.685589 0.087666 0.550961 0.466848 0.007783 1.312388 1.114482 1.951577 0.574275 1.526373 0.466124 -0.132577 1.903724 0.022636 0.658431 1.671670 1.186016 1.095405 0.769057 0.892430 1.376833 0.691211 0.858780 0.095599 1.413726 1.822190 0.581995 0.357977 0.152812 0.301047 -0.102950 0.788026 1.190875 -0.080147 -0.229267 0.282790 1.029666 0.766811 0.739748 0.339141 0.955329 0.299674 0.257893 0.340582 1.820788 1.780301 0.511319 0.085730 1.275898 0.026657 0.163816 0.451545 0.237668 0.672787 0.947505 1.775585 0.193458 0.585845 0.848353 0.994962 0.530335 0.875659 1.731635 0.563087 -0.200936 0.889716 0.442023 1.866390 0.253016 1.157266 0.767990 0.176381 0.734098 1.622499 1.761016 0.977767 1.315569 1.460504 -0.065133 1.372712 1.640736 0.092968 0.628641 1.193839 1.687685 1.489631 1.436551 0.631279 0.467094 1.520443 -0.064168 0.821864 0.351131 0.536415 0.381941 1.428682 1.391344 1.019628 1.815050 0.831257 1.683593 1.023446 1.464197 1.137368 1.011197 0.321917 0.831363)
      )

;;; 117 prime --------------------------------------------------------------------------------
#(117 18.290939331055 #(0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1)
      17.710553146299 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)
      17.596 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

      15.727630 #(0.000000 0.212830 0.844269 0.202546 1.266663 1.017971 0.312210 1.679219 0.414735 0.452920 0.107882 0.297946 0.310844 1.627252 0.235859 1.467687 1.215316 1.637886 1.289741 1.687028 0.137732 1.383414 1.404644 1.016799 0.550563 0.615444 1.329695 0.091579 0.473317 0.409999 0.620404 0.560805 0.870285 1.552452 1.679938 1.783467 0.152968 0.734723 0.341776 0.323386 1.492811 0.744366 0.337630 0.959883 1.679900 0.541712 0.120239 1.057364 0.906251 0.432970 0.945366 1.299091 0.935160 0.079440 1.191227 1.200354 1.457473 1.768197 1.495864 0.688513 0.778730 0.367735 0.663505 0.624583 1.359046 1.864803 1.603031 0.444677 1.854427 0.048380 -1.859120 0.407202 1.917308 1.890465 0.863380 0.226576 0.386595 0.520585 1.065535 1.555955 1.374187 0.315348 -0.029799 1.740704 1.101939 1.141947 1.492141 1.383634 1.055128 0.305439 0.426722 0.070584 1.255243 1.742469 0.460274 1.154773 0.224831 1.487928 0.205006 1.922059 0.252429 1.172132 1.738665 0.715671 1.465427 0.064367 0.603899 -0.011806 0.395611 0.980710 1.591528 0.293513 1.437191 -0.007299 0.622162 1.837499 0.804044)
      )

;;; 118 prime --------------------------------------------------------------------------------
#(118 17.985612869263 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0)
      17.181785583496 #(0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

      15.797009 #(0.000000 1.501648 0.680675 1.764732 -0.107447 0.670950 0.417202 1.208587 0.585355 0.730180 0.007913 0.781664 0.347500 1.132789 0.515830 0.889299 1.371551 0.413493 0.832470 1.322290 0.180445 0.336430 0.432112 1.721273 0.638538 0.470086 1.234922 0.895845 0.432480 0.128622 1.687406 -0.006488 0.558843 1.118740 -0.033788 1.095524 -0.020732 1.555338 0.411083 1.697714 -0.067344 0.481676 0.657736 0.828056 -0.304463 0.269703 0.860612 1.547969 0.826555 0.933439 0.760723 1.373207 1.564143 0.717064 1.703658 1.490743 0.690761 0.083176 -0.029931 0.717810 0.942819 0.520749 0.793720 1.576500 0.585779 0.356166 0.811162 0.411397 0.061453 1.973725 0.020655 1.367312 1.093086 1.570506 0.191878 1.181697 0.906595 0.956717 1.287552 0.979588 0.673681 1.739571 0.419410 1.721492 -0.273828 -0.111332 0.256207 1.828092 1.204595 1.688948 1.705569 1.237040 0.750424 0.229844 0.210277 0.975307 1.657590 1.423249 0.526492 1.099384 1.437264 0.253543 0.193342 0.429257 1.648478 0.854596 0.006734 1.296215 0.379708 0.276112 0.660542 0.089198 -0.044349 -0.017416 0.597370 0.748146 0.931497 0.767468)
      )

;;; 119 prime --------------------------------------------------------------------------------
#(119 18.074548986628 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1)
      17.500297546387 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1)
      17.167841346875 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

      15.689454 #(0.000000 1.432718 0.998664 1.183832 0.341737 1.010406 0.463985 1.820725 -0.006870 1.257788 1.443939 0.601071 0.950378 0.559788 0.237823 0.822311 1.075086 1.825358 0.746543 0.551541 1.290747 0.128565 1.294328 0.494973 0.824562 1.877531 0.726072 0.025460 0.177185 1.323543 1.523485 1.124495 0.313499 1.247723 1.109958 1.325764 0.984557 0.877888 1.998149 0.350480 0.962683 -0.082356 0.801345 1.038802 1.578047 0.426830 1.734833 1.796440 -0.127977 1.061397 0.840576 0.885970 1.244183 1.226435 1.413352 1.662521 1.464103 1.925325 1.319105 1.937771 1.159990 1.226493 1.175196 1.200665 1.736980 1.629116 0.566436 -0.086416 0.771937 0.416101 1.220322 0.740317 0.343274 0.585980 1.636005 0.755227 0.265131 1.316339 0.181671 0.043371 0.754454 0.434035 0.969717 1.581566 0.829011 1.134281 1.791434 1.796760 0.286506 0.654782 1.101884 1.460839 0.406478 -0.004722 1.355050 1.021553 1.138675 0.946414 -0.010860 0.021431 0.295736 1.487582 0.962741 0.587824 0.615454 1.731393 0.722215 0.151630 1.524779 1.678384 0.356177 0.045570 1.842183 -0.043022 0.193009 1.446417 0.848066 1.845155 0.735929)
      )

;;; 120 prime --------------------------------------------------------------------------------
#(120 17.635260884038 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.540792728815 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.067 #(0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

      15.932623 #(0.000000 1.247731 0.716300 1.289492 0.122950 0.122067 1.395230 0.956313 0.929270 1.036096 0.361716 1.058958 0.808716 -0.031583 1.119203 1.011361 0.831621 1.567704 0.144177 0.157744 1.091416 0.350334 0.292312 0.695541 0.992773 0.122413 1.358726 1.933631 1.782841 0.952844 0.841629 1.078606 1.043276 0.739090 0.469665 0.198988 0.096361 1.739442 0.227967 1.573030 0.712634 1.018505 0.509328 0.643363 1.191613 -0.002503 0.339252 0.125479 0.464201 1.247439 1.567778 1.141440 0.445513 0.834081 1.361595 1.259965 1.690244 0.527373 0.611445 1.543788 1.987252 1.550413 0.071597 1.456932 0.616635 0.691617 0.310899 0.090953 1.164046 1.657199 1.254924 0.100626 0.424795 0.429501 1.734925 1.133452 1.310882 1.541616 1.736539 0.916112 -0.186514 0.571633 1.841464 1.437649 0.237673 0.654883 0.099777 0.550136 0.913461 1.522889 1.160864 1.067606 -0.082420 1.195300 0.234620 0.334632 0.735315 0.140075 0.066403 0.023575 0.790857 1.467148 0.205801 1.374244 0.595976 1.031576 0.517587 1.628032 1.133489 1.007444 0.792912 1.088075 0.480561 0.063446 0.846565 0.702875 0.814044 0.588494 1.593586 0.054713)
      )

;;; 121 prime --------------------------------------------------------------------------------
#(121 18.236074758398 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0)
      17.782977183017 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

      15.834916 #(0.000000 -0.188723 1.723753 -0.076363 0.162587 1.494996 1.794310 -0.266546 0.141463 0.278534 1.190355 1.627551 1.207380 0.268694 0.474028 0.044433 0.407072 0.212567 0.973297 -0.148422 0.441302 1.363800 1.013548 0.732070 0.391281 0.165408 1.670688 -0.104313 -0.055373 1.919338 1.179545 1.261103 0.179484 1.151983 1.023612 0.770442 1.397636 0.582184 0.466890 0.494325 0.611822 1.373206 0.418645 0.961530 0.368040 0.100673 1.640785 0.975829 -0.146636 1.614211 0.208117 1.442179 1.228929 1.360131 0.069001 0.581716 1.526170 0.056776 1.115531 0.802358 1.274970 0.863932 0.712000 1.684820 1.233992 1.521972 0.475371 0.557632 -0.392401 0.651428 1.097037 1.309999 1.928616 0.964896 0.941815 0.062477 1.910184 1.539093 0.682794 0.032368 1.540435 0.338071 -0.107497 1.526458 0.739229 1.820749 0.175265 0.579971 1.590250 1.499062 0.483652 1.219566 0.217070 0.324569 1.899459 1.305092 1.972316 1.164726 1.868917 0.722799 0.952638 0.901563 0.906748 0.753410 1.131607 1.037184 -0.253399 0.304788 0.566333 0.616091 1.655472 1.167698 0.374262 1.066554 1.711184 -0.105584 0.988918 0.422633 0.053041 1.119729 0.285551)
      )

;;; 122 prime --------------------------------------------------------------------------------
#(122 18.225525517344 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)
      17.876078447724 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

      16.110175 #(0.000000 0.739913 1.759066 1.414661 1.859805 0.933762 0.510068 1.733964 1.832155 1.811801 0.937309 0.414948 -0.125435 1.290454 1.754236 0.196315 0.042044 1.551814 0.839833 1.103492 1.188948 1.241769 0.197163 0.511137 1.376334 0.408423 0.041947 0.385291 0.360449 1.826586 1.134483 0.165476 1.900248 1.779084 0.314491 0.444525 -0.144001 1.472862 1.787770 0.809808 1.017174 1.044162 1.848231 1.512736 -0.005292 0.766249 0.246216 0.789889 1.660234 1.580294 0.862515 0.027975 0.873035 1.174493 0.179567 0.399714 1.960021 0.853991 0.151738 0.502200 0.042096 0.538085 0.430398 1.531834 1.249793 1.365106 0.674615 1.163889 0.272057 1.735597 1.316998 -0.021269 1.281189 1.523630 0.309495 0.210671 1.559666 1.675746 1.418255 0.373279 1.435529 0.744316 0.840413 1.222034 1.605678 0.409322 1.073002 0.227914 1.061596 0.087219 1.111396 1.548869 0.751438 0.051051 1.608956 -0.061276 -0.008539 0.852834 0.141824 0.185519 1.543497 -0.111022 0.737785 0.355094 1.117817 0.024387 0.378004 0.018383 1.611511 1.434960 1.887157 1.388164 0.175834 1.758681 0.933941 0.943943 1.384182 0.084684 1.470454 -0.018233 1.000932 1.936683)
      )

;;; 123 prime --------------------------------------------------------------------------------
#(123 18.144585330068 #(0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1)
      17.389867782593 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)
      17.273 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

      15.778914 #(0.000000 0.143393 0.625686 1.046023 0.983153 0.345414 0.293857 0.276893 1.833120 0.273819 1.821385 0.432462 -0.005834 1.381753 0.881643 1.557216 1.461346 0.919317 0.454980 0.664472 -0.298618 1.851108 1.466794 0.098840 -0.051074 0.850957 1.327537 1.539835 0.086282 1.496838 1.801280 0.555017 0.568385 0.872000 1.681517 1.763478 0.180660 0.629340 0.797931 0.778757 -0.187533 0.759345 1.199888 0.284611 0.141605 -0.002210 1.168471 1.062111 1.559800 1.036659 1.685210 1.719794 1.456550 1.242269 0.111521 0.413090 1.165964 1.023835 0.828500 1.152078 1.399356 0.650501 0.565478 0.189566 1.449207 0.444013 0.692121 1.413890 1.127772 0.496319 0.689893 0.210498 -0.076756 0.973437 -0.017560 1.150851 0.558786 1.566386 0.107192 0.385208 0.533924 0.439602 -0.027270 0.700165 1.360916 1.652077 1.481235 0.449713 -0.270927 0.835607 0.417327 -0.059020 0.613090 -0.087247 0.497676 1.049266 0.510587 0.986574 0.753750 -0.007878 0.119285 0.912181 0.418924 0.612131 1.148823 0.547751 1.366719 0.889045 0.765255 0.431083 1.090456 1.680331 0.458851 0.971383 1.580777 1.603075 1.780190 0.813231 0.000192 1.772592 1.394595 0.106656 0.558795)
      )

;;; 124 prime --------------------------------------------------------------------------------
#(124 18.115 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
      17.868420183527 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

      16.248013 #(0.000000 1.183478 1.165286 1.194537 1.254858 1.914402 1.240889 1.337220 0.518067 0.177783 0.550001 1.289669 0.227441 0.868230 1.469966 1.508808 0.703752 0.095615 1.746686 0.880977 1.449995 0.901398 0.442461 0.041131 1.661442 0.821047 -0.064241 0.472637 -0.031321 1.085981 1.755397 0.510339 1.177040 0.833320 0.845356 1.333189 -0.009126 1.207082 0.053241 0.328393 0.838858 1.096696 0.980977 1.488972 0.814342 1.022844 0.491243 0.551951 1.217471 0.167677 1.103674 1.011021 1.717206 1.233127 0.198588 0.189839 1.026254 0.620320 1.396449 -0.018982 1.457314 1.238323 1.070434 1.029226 -0.013190 1.646398 0.627365 0.339846 1.571247 0.588281 0.458744 1.227427 1.584696 0.096863 0.590996 0.705266 0.829331 0.537353 0.487431 0.105659 0.662702 1.502185 0.444713 1.504702 1.677933 1.040280 0.692865 1.204129 0.281987 1.651336 1.737573 1.300235 1.791236 1.837990 1.000877 1.675102 -0.005443 1.942229 1.097918 1.101847 0.864715 1.250295 1.256383 0.200765 1.384973 -0.026084 1.477566 0.832600 0.837363 0.348510 0.933261 1.527613 1.667400 1.907945 1.878247 -0.024442 0.181248 0.728757 1.859303 1.099926 1.135491 1.575083 1.036300 1.293347)
      )

;;; 125 prime --------------------------------------------------------------------------------
#(125 18.072 #(0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1)
      17.637776156888 #(0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

      16.446874 #(0.000000 1.761525 0.737052 0.757790 1.648076 0.731739 0.649534 1.841888 -0.151119 -0.038231 1.089025 0.187285 0.439469 0.687448 0.166687 1.093979 0.569087 0.439058 0.976136 1.159536 0.474998 1.359291 1.292760 0.947515 1.136247 1.198228 0.074593 0.098287 -0.306031 1.179990 0.165232 0.500711 1.013910 -0.193769 0.688421 0.266102 0.134616 1.845981 -0.082100 0.397437 0.842515 0.843841 0.210852 -0.089710 1.498642 1.196281 0.713514 0.812786 0.734802 1.816816 0.852650 1.020574 1.331306 0.297475 1.321131 0.308552 1.330144 0.164185 1.977744 1.177175 0.611649 0.617024 1.849737 0.640549 0.478325 0.237952 0.484262 0.074021 1.200463 1.457701 0.523111 0.274603 1.235624 1.192004 1.113674 1.378075 0.681515 0.597380 0.006597 0.008910 1.614608 -0.009482 1.613731 0.682441 1.059510 1.556204 0.897523 1.857720 0.754897 0.894555 0.734695 0.063486 1.224369 1.615776 0.010739 0.640512 0.659148 0.809335 -0.008143 0.534635 0.360887 1.000247 0.352702 0.119198 1.218515 0.939139 0.260714 -0.102263 0.148085 1.597090 0.772819 1.426923 1.458148 -0.010990 0.190324 1.065953 0.642402 1.639382 1.214542 0.323506 -0.334243 1.281566 1.489917 0.393720 1.881900)
      )

;;; 126 prime --------------------------------------------------------------------------------
#(126 19.269804000854 #(0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1)
      18.284595039843 #(0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

      16.485692 #(0.000000 1.393132 0.659679 0.714266 1.494788 0.331111 0.897049 1.314783 1.545624 1.556795 -0.077574 1.186629 0.072557 1.374590 -0.138031 1.538299 0.712726 -0.003998 0.490566 0.381861 0.872047 1.438657 0.084432 -0.258220 -0.077354 1.597934 1.736544 1.726227 0.474701 1.273917 -0.005659 1.699119 1.008666 1.379120 1.578428 0.142870 0.908296 0.556522 1.210060 1.628610 0.787641 1.540629 1.425205 1.559130 0.612495 1.232357 1.269357 0.546352 1.177556 1.745878 0.293296 1.043206 0.547645 0.115824 1.423495 0.207326 0.441822 0.587489 0.470953 0.737873 1.083623 0.284950 0.744700 0.810274 0.980162 0.078648 0.078978 1.256579 1.343657 0.819402 0.467126 1.574219 0.962766 0.542487 1.121350 0.866569 1.432939 0.724543 -0.158329 0.172920 0.822336 1.592824 1.287641 1.474720 0.297028 0.294866 1.256418 0.977065 0.832776 1.547442 0.851721 -0.206008 0.718651 1.548248 1.210027 1.506412 0.423156 0.501510 0.111527 0.489364 0.396455 1.265011 1.039315 1.025070 0.204807 0.113462 1.368658 0.104283 0.954973 -0.024402 1.477056 1.015433 1.647333 0.940652 0.915809 1.853310 1.146304 0.051861 -0.060644 1.350415 0.525284 0.507359 1.422151 0.412076 0.746518 0.285484)
      )

;;; 127 prime --------------------------------------------------------------------------------
#(127 19.129140790802 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)
      18.198689419357 #(0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

      16.448822 #(0.000000 -0.085807 0.199128 0.603426 0.615563 1.637749 1.823469 1.149809 1.823015 0.286527 0.617283 1.285138 -0.208128 0.639036 0.970194 0.729409 1.761844 1.117109 -0.033116 0.888131 0.968198 0.177748 1.131738 0.928416 0.936088 0.356108 0.715902 1.162235 0.774103 1.177701 0.059329 1.253967 0.928039 1.746834 0.511413 0.830103 1.726781 0.942226 1.477853 -0.156272 1.095142 1.912050 0.551004 0.359334 1.869519 0.846075 1.789696 0.347764 0.241707 1.330781 1.203328 1.136424 1.132458 0.771348 1.282194 1.902402 0.701018 0.926506 0.321435 0.770291 0.619623 1.904974 0.977039 0.969889 0.381082 1.862110 0.060195 0.037664 -0.248669 1.859257 0.582180 1.638986 -0.004135 0.904732 0.759121 1.067398 1.567847 1.416833 0.592303 0.427558 1.056939 0.189879 1.209556 0.238312 1.214601 1.468346 1.340213 0.637994 0.330494 1.648640 0.946122 1.917861 1.276412 1.256282 1.213879 0.791801 0.318273 0.666450 1.229100 0.861678 0.178641 0.252289 0.813985 0.053018 1.386558 0.542505 0.349693 1.662396 1.863561 0.880529 0.977013 0.574184 1.518813 1.422817 0.809957 1.845103 0.905411 0.313274 0.483433 0.024847 0.211145 0.414022 1.099694 0.953172 0.846953 1.316404 0.960041)
      )

;;; 128 prime --------------------------------------------------------------------------------
#(128 18.871676504971 #(0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1)
      18.306106723228 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)
      18.276384353638 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

      16.639177 #(0.000000 0.941042 1.318951 1.101078 1.757168 0.173698 1.849302 0.632173 0.131366 0.204088 1.455776 0.870788 1.487246 -0.081794 0.690424 1.043434 0.919640 1.458337 0.944693 0.635417 1.742337 0.257522 0.854055 1.837908 0.981231 0.891640 1.448246 1.580754 1.180774 1.648797 1.600549 -0.205002 -0.029486 0.141600 0.208385 0.411472 0.153804 1.392786 0.722340 0.018888 0.500661 1.761096 0.477453 1.758786 0.202927 1.821670 1.472172 0.588743 0.021950 -0.062182 0.511755 1.833910 0.523389 1.293144 -0.103720 0.861850 0.569077 1.434494 1.838000 0.536824 1.350141 1.299627 1.171458 1.401070 1.666543 0.244383 0.464725 1.163541 0.554912 0.164271 0.559859 1.692671 1.630550 1.141048 1.749818 1.252866 1.092488 1.102305 1.689028 0.129716 1.042473 1.202930 1.819876 1.802852 1.352685 1.410403 0.741185 0.674173 0.083538 0.126323 0.830601 0.697329 0.812961 1.966555 1.903987 1.354315 0.712695 0.678746 -0.038586 1.182170 1.049936 0.721465 0.479959 1.686673 1.648348 0.874362 1.717604 1.261546 0.309529 1.144165 0.772079 0.718510 0.510959 0.952239 0.818646 1.756032 1.073223 0.395434 1.752208 0.823858 0.839836 0.398785 1.619138 1.227905 0.075832 0.534803 1.242839 0.732079)
      )

;;; 256 prime --------------------------------------------------------------------------------
#(256 27.740 #(0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      25.843001 #(0.000000 1.178038 1.117189 1.700610 0.373627 1.883314 -0.150547 0.860152 1.699759 1.867276 1.133410 1.716145 1.170242 0.182940 0.967532 0.457512 1.079364 0.116068 0.106098 1.675713 0.477979 1.231493 1.322168 0.773630 1.832518 0.122290 0.180043 0.374294 0.611999 0.136932 1.013493 1.069379 1.182024 1.271294 0.642791 0.064959 0.049470 0.651081 0.559311 0.184537 0.000503 0.129980 1.636299 1.256733 1.544750 0.480981 0.250788 1.359926 1.216141 1.356184 1.946364 1.494233 0.738472 0.827066 1.640705 1.325401 0.094653 0.385835 0.932570 0.164616 0.551291 0.920921 0.187855 0.260769 0.461846 0.576571 1.464881 0.394875 1.469418 0.272246 0.425404 -0.045832 0.006251 0.190055 1.868581 0.690811 0.668857 0.346545 0.925141 0.629594 1.924916 0.291366 1.592154 0.447276 0.034691 1.030569 0.839899 0.485328 1.019363 1.791729 0.399597 1.310415 1.419525 1.909343 1.793887 0.372161 1.094536 0.769475 0.788559 1.190624 0.945126 0.882786 0.486002 1.852362 1.678052 0.866828 1.280024 1.820688 0.887248 1.227680 1.485570 0.504170 0.327568 0.198858 0.514803 0.338014 0.440694 0.872123 0.756056 1.458178 0.159454 1.067780 1.339173 0.756970 0.626382 0.176670 1.354873 1.713861 1.938450 1.803226 0.323061 0.536758 1.035309 1.264381 0.790183 1.977782 1.637094 1.831537 0.209445 0.547617 1.969417 1.918172 0.036260 1.958659 0.161282 0.339607 1.714624 -0.127708 0.080179 0.935938 1.379987 0.270026 0.612112 1.274936 1.771797 1.480656 0.249371 1.380316 0.497560 0.668029 0.601339 1.011243 0.545874 1.245228 0.700674 1.734601 0.080283 0.977900 0.441339 1.088476 1.109845 1.241483 0.158156 1.602341 1.488712 1.445422 0.224891 1.321069 0.812233 0.964559 1.429410 0.478888 1.314822 0.389337 1.003252 1.023065 0.655446 0.760771 0.319297 0.379367 1.880123 0.155238 0.521165 1.981861 0.486168 1.323709 0.478243 0.363112 1.563352 1.025353 0.028002 0.480878 0.182820 0.357272 0.875406 0.053447 1.511773 0.051995 1.096864 0.785911 0.251409 0.813921 -0.000189 1.606620 1.070229 1.474625 0.860413 0.515696 1.807586 1.238635 1.016453 0.101229 0.899740 0.208146 1.773833 0.176027 1.738141 0.792134 1.786116 1.268742 0.468739 1.116445 0.094303 0.245584 -0.111445 1.055331 1.383319 0.083561 0.463871 0.402689 1.805901 0.206440 0.734373 1.104562 0.405058 1.813865 1.447477 0.923352 1.806075 0.348988 0.517833 1.863118 0.503597 1.683658 1.162414 0.900302)
      )

;;; 512 prime --------------------------------------------------------------------------------
#(512 43.486 #(0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      41.664769 #(0.000000 1.116415 1.727298 0.845891 0.743450 0.409202 0.797033 0.974598 0.559751 0.291961 0.645471 1.090836 1.833210 1.136266 0.329328 1.750236 0.440321 -1.952179 0.067573 0.402867 0.127828 0.691992 0.722342 1.820882 1.324509 0.847627 0.479095 0.117532 1.509949 0.916106 0.505440 0.796584 0.338013 1.381993 1.214452 1.652605 1.633028 1.574092 0.200810 0.234340 -0.240723 -0.077124 0.482644 0.659074 1.668870 0.882982 -0.057775 1.287674 0.937889 1.827207 0.129452 1.090954 0.749828 1.359523 0.989511 1.332818 1.797414 0.437723 1.661275 0.290286 1.244825 0.877897 0.735063 1.777192 1.969025 1.896974 0.638657 0.763141 0.953914 -0.018972 1.071882 1.008524 0.311248 1.000132 0.483793 1.724509 0.129575 0.150087 1.010540 -0.093854 0.219565 0.431317 1.379087 0.803405 1.157079 0.926306 1.683735 1.842410 1.353077 0.559427 0.949846 1.101620 1.585497 0.752886 0.287023 0.415081 0.932815 1.731880 0.942771 0.121294 -0.002243 0.861783 0.905251 1.085791 0.105007 1.023331 0.221461 0.106715 0.029230 0.031392 1.440041 0.620348 0.734416 0.445250 0.855766 0.721974 0.822495 0.230247 0.048048 0.160125 0.755071 -0.157046 -0.084547 1.789339 0.738432 1.110753 1.400342 0.496814 0.441771 0.564855 0.811974 1.278133 1.918944 0.840614 1.795074 0.312545 0.044731 0.729901 0.868555 1.447952 1.770333 1.945017 0.865667 0.629236 0.842274 0.312879 1.060148 0.685356 0.477133 1.554039 1.738854 0.840468 1.782986 0.059777 0.361173 0.716745 0.805091 0.478910 0.751920 0.585336 1.094954 0.573916 1.196788 0.159706 1.979046 0.348955 1.016763 1.884102 1.817396 0.572600 0.236996 0.782688 1.151521 0.741278 0.474252 0.652664 0.199708 1.319269 -0.164699 1.458273 0.952285 1.741011 -0.119322 1.667507 0.149015 0.828216 1.212947 1.116625 0.960420 0.942747 0.147079 1.498908 0.477162 0.411915 1.792633 0.173615 1.580758 0.613328 1.109866 1.674147 0.655838 0.879292 1.740881 1.729977 1.349969 -0.015945 1.923054 1.581284 0.295284 1.289973 0.980779 0.189864 0.677986 1.331696 1.815310 1.234108 0.302104 0.321976 0.206846 0.567751 0.707940 0.738282 1.524650 0.595391 0.979606 0.666615 1.577245 -0.149659 0.474452 1.536368 1.601539 -0.080450 1.372093 0.492351 1.011743 0.055465 0.938579 0.098380 1.662254 1.146717 1.360680 1.794074 1.775343 1.495121 0.149575 0.319388 -0.171593 1.447699 1.674851 0.627599 0.776469 0.082189 0.505297 1.233899 1.527908 0.903555 1.378047 0.349659 0.969825 0.814736 1.846169 0.693337 0.618949 1.845432 1.378273 1.576222 0.081248 -0.093980 0.049453 1.076139 0.452869 1.721563 0.956031 0.509262 0.178007 0.260436 1.072918 0.420694 0.346588 0.581816 0.456884 0.802054 0.611930 0.110853 -0.018739 1.192373 1.827696 0.454131 0.892618 -0.119411 1.097231 0.516296 1.803486 1.557219 1.545517 0.884332 1.982311 1.953719 1.101558 0.022766 0.570410 1.847161 0.938052 0.462649 1.487668 1.922760 0.413304 1.668114 1.332979 0.260993 0.904563 0.452562 1.262068 1.322472 1.096381 0.827466 0.760844 1.823164 0.020697 1.702714 0.182933 0.413546 1.446066 1.756945 0.107099 1.892260 0.010258 1.312962 1.471008 1.033249 0.676901 0.044523 0.666409 1.723222 1.138159 0.400468 1.185590 0.453713 1.891236 1.522601 1.282240 0.447682 0.611310 1.240469 0.566160 1.744808 1.503289 0.204644 1.529084 1.144316 1.625171 1.207387 1.988021 0.472365 1.116547 -0.045885 -0.095751 1.214416 1.419215 1.482974 0.122830 1.224230 0.922843 0.866912 0.307032 0.744944 1.733186 0.983044 0.495746 0.421215 0.262346 0.815944 0.934353 1.620903 1.742861 1.193700 0.926201 0.335356 0.024179 0.707200 1.595915 0.476730 0.247552 1.657494 0.973946 0.160943 0.364081 0.405133 0.547675 1.020600 0.290755 1.914942 1.257354 0.452866 0.820262 0.773843 1.159114 0.108984 0.334173 1.043272 1.515026 0.819697 1.216991 1.596458 0.146743 1.862421 0.059147 0.331449 1.207966 1.755858 0.676951 0.807017 0.839546 0.926561 0.983399 1.254920 -0.240448 0.535379 0.524654 0.769935 0.837520 0.051843 0.027950 0.448780 0.977510 0.549107 1.372371 1.334191 1.459189 1.506794 0.270853 1.956779 1.613253 0.183880 1.504147 0.262755 1.023139 1.275822 0.017478 0.545033 0.699188 1.802312 1.763013 0.892781 1.620214 1.689582 0.077500 1.869673 0.180962 1.503231 1.674696 0.898227 1.350157 1.075897 1.627051 0.542085 1.171162 1.728735 0.887778 0.896217 1.966287 0.195863 1.207252 1.403478 0.401138 1.593448 0.077627 1.195586 0.095598 0.901884 1.885477 1.175329 0.421783 0.683983 1.168508 1.628233 1.075717 -0.035539 0.288342 1.441688 1.695034 0.244264 1.785767 1.517414 0.426283 0.378334 1.690406 0.910870 0.586972 1.003830 1.449864 1.597673 1.357741 0.435022 0.025420 1.169044 0.088912 1.609824 1.734809 0.563727 1.702053 1.706575 1.682204 1.491978 0.624473 0.471243 0.347616 1.411704 1.002050 0.329841 -0.110942 1.861702)
      )

;;; 1024 prime --------------------------------------------------------------------------------
#(1024 70.140 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)
       )

;;; 2048 prime --------------------------------------------------------------------------------
#(2048 102.619 #(0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

#(1 1.0 #(0)
    )

#(2 1.7601724863052 #(0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
#(3 2.2325525283813 #(0 0 0)
    2.0235652605711 #(0 33/64 63/128)

    2.0214650630951 #(0.0 0.52414411306381 0.48787820339203)
    2.021465 #(0.000000 0.475854 0.512123)
    2.021465 #(0.000000 0.524145 0.487877)
    2.021465 #(0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
#(4 2.8359191417694 #(0 0 0 0)
    2.450505601523 #(0 3/16 21/32 15/32)

    ;2.434727537119 #(0 37 52 46) / 31

    2.4311048984528 #(0.000 0.191 0.672 0.479)
    2.4311048984528 #(0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 #(0 0 0 0))
    2.4308773660653 #(0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 #(0 3/16 21/32 15/32))
    2.430877366065 #(0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 #(0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
#(5 2.816308259964 #(0 1 0 0 0)
    2.6458936399054 #(0 1/8 3/8 7/8 3/8)

    2.6048328876495 #(0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)

    2.604848 #(0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
#(6 2.9795869831363 #(0 0 1 0 0 0)
    2.9795892238617 #(0 1 0 1 1 1)

    2.9243438516438 #(0 3/4 11/8 7/4 13/8 5/4)

    2.8369779013614 #(0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 #(0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 #(0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 #(0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 #(0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 #(0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    )

;;; 7 even --------------------------------------------------------------------------------
#(7 3.4936672673663 #(0 0 0 0 1 0 0)
    3.3825581073761 #(0 0 0 0 0 1 0)

    3.2378379570745 #(0 1/2 1 5/4 8/5 7/6 5/7)
    3.2107788995227 #(0 1/2 7/8 1 5/4 3/4 1/4)
    3.1047971248627 #(0 15/32 27/32 15/16 19/16 5/8 3/16)

    3.0470769405365 #(0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 #(0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    )

;;; 8 even --------------------------------------------------------------------------------
#(8 3.7968969947382 #(0 0 1 1 0 0 0 0)
    3.7706393073421 #(0 1 0 1 1 0 0 0)
    3.611234664917 #(0 0 0 0 0 1 0 0)

    3.3268119973374 #(0 41/21 15/22 3/4 58/45 73/92 17/18 8/23)

    3.197691 #(0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 #(0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 #(0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 #(0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    )

;;; 9 even --------------------------------------------------------------------------------
#(9 4.1871630323114 #(0 1 1 0 0 0 0 1 0)
    4.1397546805979 #(0 0 1 0 0 0 1 1 1)
    4.0601739883423 #(0 0 0 0 0 0 1 1 0)

    3.611018626823 #(0 0 1 1/4 4/5 7/6 8/7 5/8 5/9)

    3.454235 #(0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 #(0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 #(0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    )

;;; 10 even --------------------------------------------------------------------------------
#(10 4.1456241150012 #(0 0 0 1 1 0 0 0 0 0)
     4.0054845809937 #(0 1 1 0 0 0 0 0 1 0)

     3.8737153028161 #(0 1 3/2 1/2 1 1 5/4 5/4 1/2 0)
     3.8589085043368 #(0 1/4 5/4 7/4 1 1/2 0 0 1/4 1/4)

     3.559069 #(0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 #(0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 #(0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     )

;;; 11 even --------------------------------------------------------------------------------
#(11 4.2814919726737 #(0 1 1 1 0 1 1 0 1 1 1)
     4.8058149616573 #(0 0 0 1 0 1 0 0 0 0 0)
     4.2754249521261 #(0 1 0 1 0 0 1 1 1 1 1)
     4.2368197441101 #(0 0 1 1 0 1 1 1 0 0 0)

     4.1020619790213 #(0 1 0 3/2 3/5 7/6 1/7 1/8 0 3/10 8/11)
     4.0234807074824 #(0 3/2 1/2 1/2 3/2 3/2 1/2 1/2 1/2 1/2 1/2)

     3.656997 #(0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 #(0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 #(0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 #(0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     )

;;; 12 even --------------------------------------------------------------------------------
#(12 4.5077774785482 #(0 1 0 1 1 0 1 1 1 0 0 0)
     4.4722682088655 #(0 1 0 0 1 0 0 0 0 1 1 1)
     4.4100483425078 #(0 0 0 1 1 0 1 0 0 0 0 0)

     4.3815770149231 #(0 1 1/3 1 0 5/3 6/7 1 2/9 2/5 6/11 5/12)
     4.2963300788819 #(0 1/2 3/2 3/2 3/2 3/2 1/2 1/2 3/2 1/2 1/2 1/2)

     3.788546 #(0.000000 1.556167 0.360103 0.557527 1.272879 -0.160667 1.208794 0.416499 0.207991 0.153798 0.406432 0.105283)
     3.788220 #(0.000000 0.550342 1.343009 1.534780 0.244087 0.805462 0.167902 1.368575 1.154099 1.090872 1.336846 1.030125)
     3.787893 #(0.000000 0.448349 1.651266 1.457646 0.745846 0.182779 0.817835 1.614340 -0.173074 -0.112402 -0.361602 -0.056645)
     3.787770 #(0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 #(0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 #(0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     )

;;; 13 even --------------------------------------------------------------------------------
#(13 4.7678911684727 #(0 1 1 0 0 1 0 1 0 0 0 0 0)
     4.4552875568415 #(0 1 0 0 1 1 0 1 0 1 1 1 1)
     4.4076361656189 #(0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973640 #(0.000000 0.230119 1.573121 1.035418 0.607827 0.004639 0.570316 1.864444 0.017841 1.712936 0.049649 0.243649 0.758519)
     3.973518 #(0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 #(0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     )

;;; 14 even --------------------------------------------------------------------------------
#(14 4.6162051765776 #(0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.5770673751831 #(0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.099610 #(0.000000 -0.080758 -0.027479 0.199399 0.386347 0.449299 0.202554 1.784429 1.717900 0.329527 0.954548 -0.264053 0.856281 0.353663)
     4.099044 #(0.000000 0.064712 0.002392 1.758239 1.562496 1.488613 1.718784 0.123849 0.177636 1.552432 0.915397 0.118052 0.982785 1.477200)
     4.098933 #(0.000000 1.064573 1.002412 0.758783 0.562663 0.489006 0.720164 1.124184 1.179525 0.554249 1.917231 1.120737 -0.014393 0.478996)
     4.098145 #(0.000000 1.929164 -0.010969 0.226671 0.421687 0.490908 0.253400 1.847703 1.785923 0.405487 1.039797 -0.170604 0.960326 0.465294)
     4.098085 #(0.000000 0.927965 0.986737 1.222368 1.417978 1.485804 1.245975 0.840927 0.775976 1.394042 0.027462 0.814776 1.945099 1.450413)

     4.097747 #(0.000000 0.927497 0.986240 1.222647 1.417439 1.485272 1.245695 0.840056 0.775783 1.393795 0.027626 0.815063 1.945062 1.449403)
     )

;;; 15 even --------------------------------------------------------------------------------
#(15 4.949674522378 #(0 1 1 1 0 0 0 0 1 0 0 0 1 0 0)
     4.8773546682689 #(0 1 1 0 0 0 1 1 0 1 0 0 0 0 0)
     4.7838921546936 #(0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.199573 #(0.000000 0.504296 0.613533 0.293607 0.288557 1.021780 0.287132 0.744077 -0.060941 1.352372 0.993154 1.256681 1.521460 0.388861 0.364865)
     4.197351 #(0.000000 0.630844 0.628794 1.068650 1.167425 0.572395 1.431155 1.077518 0.027658 0.719923 1.211198 1.055057 0.880835 0.189555 0.316525)
     4.193772 #(0.000000 1.675587 1.705815 0.187561 0.316258 1.764366 0.667280 0.345731 1.343497 0.068095 0.602689 0.479768 0.335628 1.703907 1.864339)
     )

;;; 16 even --------------------------------------------------------------------------------
#(16 5.1845584915919 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0)
     5.1708735549117 #(0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1)
     5.1363370276686 #(0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1)
     5.0737318992615 #(0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.396519 #(0.000000 1.090547 1.139126 -0.009529 0.458824 0.778347 -0.106183 1.308832 1.218737 0.200208 0.290540 0.016830 0.423513 0.112582 0.603363 0.004222)
     4.353701 #(0.000000 0.561831 0.989050 1.195832 1.557580 0.017410 0.685599 1.728228 0.371692 0.005402 0.173541 0.126093 1.783105 1.542090 0.769507 0.225043)
     4.328579 #(0.000000 -0.050344 1.847492 1.547825 1.358460 0.943178 0.995171 1.405548 1.304846 1.241639 0.001478 0.213619 1.127944 0.266623 1.638359 0.274327)
     4.327240 #(0.000000 0.955918 0.860292 0.568310 0.386497 -0.025631 0.034017 0.451672 0.356585 0.302382 1.070108 1.288665 0.209235 1.352882 0.732831 1.373569)

     4.327048 #(0.000000 0.956205 0.859536 0.567699 0.386584 -0.025732 0.033650 0.451266 0.357226 0.301560 1.070519 1.288474 0.208531 1.353018 0.732948 1.373096)
     4.326872 #(0.000000 0.955614 0.859979 0.567169 0.385493 -0.026738 0.033152 0.450270 0.355426 0.300069 1.068503 1.286708 0.206676 1.350539 0.730076 1.370356)
     )

;;; 17 even --------------------------------------------------------------------------------
#(17 5.2972948285536 #(0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1)
     5.2612584721964 #(0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 1)
     5.2483402924188 #(0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1)
     5.2332563400269 #(0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.494270 #(0.000000 1.690932 1.377703 -0.129164 -0.024726 0.145784 0.623192 0.601419 1.696617 1.062285 0.338962 0.425431 0.203410 -0.198553 0.017368 0.919786 1.663170)
     4.492148 #(0.000000 1.455463 1.016973 1.283695 1.263839 1.209517 1.482261 1.230970 0.098209 1.342845 0.364270 0.321411 -0.041987 1.226617 1.352117 0.009228 0.581250)
     
     4.491411 #(0.000000 1.455772 1.016990 1.284311 1.263092 1.209220 1.481223 1.231822 0.098197 1.342689 0.365145 0.322141 -0.042679 1.227674 1.352783 0.010272 0.581419)
     4.479510 #(0.000000 1.466836 1.017287 1.287212 1.239798 1.196077 1.475713 1.252884 0.088143 1.339107 0.374990 0.334947 -0.053319 1.236824 1.357721 0.013234 0.581999)
     )

;;; 18 even --------------------------------------------------------------------------------
#(18 5.4135673169319 #(0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0)
     5.3738845938103 #(0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1)
     5.3310880661011 #(0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.589734 #(0.000000 0.128904 0.791112 1.176829 1.319456 -0.047760 0.250141 1.390995 0.366355 1.103698 0.393661 -0.024093 1.112970 0.986605 0.815414 0.987317 0.858855 0.551348)
     4.580164 #(0.000000 0.088065 1.683756 0.348660 0.864971 1.361146 1.224199 0.124257 0.574705 0.001082 1.664767 0.723022 1.280851 0.880081 1.007566 1.375306 1.095774 0.962641)
     4.571590 #(0.000000 1.013908 0.576382 1.182751 1.623620 0.037627 -0.106587 0.719802 1.088671 0.493611 0.074480 1.074406 1.594362 1.108843 1.196764 1.498638 1.161057 0.996486)

     4.570825 #(0.000000 1.014207 0.576401 1.182722 1.623809 0.037366 -0.106276 0.719945 1.088940 0.493703 0.074031 1.074477 1.595481 1.109120 1.197779 1.498819 1.161324 0.997523)
     )

;;; 19 even --------------------------------------------------------------------------------
#(19 5.4721938266519 #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0)
     5.4619059562683 #(0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.760423 #(0.000000 0.078500 -0.009665 0.445299 0.326637 1.124753 0.889843 1.345388 1.144621 0.990641 0.735224 1.219841 0.734403 1.676249 0.197585 1.008479 1.250738 0.438525 0.297651)
     4.755923 #(0.000000 1.213601 0.678762 0.449947 1.346835 1.245401 0.132189 -0.154359 -0.066893 0.442509 1.163773 1.197774 0.674247 0.874256 0.559473 1.197410 0.377246 0.953845 0.897498)
     4.747536 #(0.000000 1.217706 0.673412 0.449616 1.339090 1.249452 0.119748 -0.159813 -0.067080 0.446567 1.155275 1.187059 0.684859 0.863274 0.563311 1.197365 0.360905 0.957607 0.891096)
     )

;;; 20 even --------------------------------------------------------------------------------
#(20 5.670516977407 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0)
     5.5380347270104 #(0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0)
     5.5266017913818 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.846454 #(0.000000 0.866961 0.067449 -0.000019 1.240413 0.225838 1.419930 1.691003 0.587936 0.964145 0.978852 1.597872 0.595830 0.254621 0.227541 0.264445 0.991980 0.683537 0.683353 0.455578)
     )

;;; 21 even --------------------------------------------------------------------------------
#(21 5.7292241651627 #(0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0)
     5.6852540969849 #(0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1)
     5.6849967470046 #(0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.943497 #(0.000000 0.342775 0.415657 1.508881 0.046959 0.684256 0.126740 1.848952 0.276421 1.554667 1.645636 1.338595 0.417433 0.283883 1.495013 0.129584 0.188849 0.295361 0.499544 1.388366 0.890872)
     )

;;; 22 even --------------------------------------------------------------------------------
#(22 5.9318449080552 #(0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1)
     5.9259635937391 #(0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0)
     5.8572781078687 #(0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.089246 #(0.000000 -1.563578 1.786275 0.848304 0.986180 0.742233 1.397582 0.150456 1.184136 1.027004 1.307086 1.526999 -1.829642 1.416258 0.019299 0.013748 1.296009 1.186108 0.959554 1.342244 1.336484 0.567533)
     5.086539 #(0.000000 -1.558600 1.792808 0.865415 0.986030 0.744442 1.393694 0.150878 1.201323 1.019045 1.304174 1.526136 -1.823124 1.418647 0.013143 0.008502 1.300949 1.177590 0.956163 1.348968 1.333978 0.560568)
     5.082899 #(0.000000 -1.557650 1.794784 0.867917 0.987668 0.744180 1.392438 0.153867 1.204047 1.020121 1.303836 1.523350 -1.818745 1.421097 0.012589 0.008813 1.302993 1.174472 0.955160 1.351046 1.335045 0.562128)
     )

;;; 23 even --------------------------------------------------------------------------------
#(23 5.9574251174927 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
     5.9548940658569 #(0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1)
     5.9208135892745 #(0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.209616 #(0.000000 0.536241 0.640351 0.401969 -0.144171 1.094640 0.634335 0.931880 1.319439 0.841599 0.634189 1.035522 0.686655 -0.149110 0.408260 1.445706 1.827094 0.431514 0.263936 0.624587 0.308901 1.318237 1.567945)
     5.183125 #(0.000000 0.515237 0.616505 0.388174 -0.154053 1.077504 0.634030 0.919474 1.333578 0.858192 0.639743 1.047413 0.669722 -0.134050 0.416610 1.462551 1.793352 0.450968 0.256518 0.611308 0.305992 1.305852 1.588671)
     )

;;; 24 even --------------------------------------------------------------------------------
#(24 6.119236946106 #(0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 0)
     6.0757751464844 #(0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1)
     6.0318420391191 #(0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1)
     6.0318420391191 #(0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.345459 #(0.000000 -0.095698 0.168373 0.696544 1.668124 0.213154 0.677142 -0.007245 1.780336 1.499106 0.004136 0.062231 0.031703 0.195401 1.948340 -0.765186 1.124915 0.247067 0.880131 0.374913 1.072400 0.550437 1.729077 1.781477)
     5.327954 #(0.000000 -0.085435 0.161969 0.687997 1.676104 0.230398 0.683475 -0.020602 1.783801 1.499648 -0.011720 0.043501 0.046906 0.202461 1.952448 -0.745464 1.120001 0.263114 0.870467 0.369905 1.077557 0.550898 1.736080 1.789818)
     )

;;; 25 even --------------------------------------------------------------------------------
#(25 6.2507610321045 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     6.2422542572021 #(0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1)
     6.152729668872 #(0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0)
     6.1513186981755 #(0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.460646 #(0.000000 1.331634 1.290211 1.263589 1.302441 1.064237 1.397977 0.390913 0.600857 1.449497 0.322631 1.027030 1.355214 1.547798 1.473494 0.314062 1.554652 0.847231 -0.306332 0.084000 0.041043 0.155049 1.350806 0.892133 0.510904)
     5.456300 #(0.000000 1.342872 1.289981 1.264009 1.292967 1.063194 1.393690 0.399460 0.602263 1.460963 0.329798 1.029888 1.358471 1.551238 1.465772 0.325043 1.545032 0.860443 -0.309625 0.086051 0.033264 0.158302 1.351322 0.881552 0.506991)
     )

;;; 26 even --------------------------------------------------------------------------------
#(26 6.3358421325684 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0)
     6.3140621185303 #(0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1)
     6.2899344518232 #(0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1)
     6.2899344518232 #(0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.574334 #(0.000000 1.452636 0.789265 1.198306 1.689712 0.694380 0.958593 0.147600 0.697263 1.042774 0.296938 1.727146 0.522657 -0.006099 0.346399 -0.237343 1.184734 1.176892 -0.039585 0.171492 0.276853 -0.132046 1.806205 0.321513 -1.716091 0.707320)
     5.546277 #(0.000000 1.441802 0.771659 1.202928 1.691855 0.708249 0.975195 0.157129 0.687671 1.048536 0.321024 1.733871 0.518331 -0.022894 0.357028 -0.231751 1.166176 1.172707 -0.050306 0.177247 0.272994 -0.110337 1.792647 0.332540 -1.705792 0.701656)
     )

;;; 27 even --------------------------------------------------------------------------------
#(27 6.4054713249207 #(0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0)
     6.243681443715 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)
     6.2409835764044 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.703891 #(0.000000 1.905303 1.138643 1.584089 1.180062 1.432269 1.508615 0.944552 1.396299 1.038280 0.941028 0.492897 0.347887 1.637711 1.286513 1.424777 0.165539 1.525065 0.468230 1.286669 1.543975 -0.144617 0.089958 1.237094 0.285752 0.328343 0.823211)
     5.690387 #(0.000000 1.903048 1.139994 1.590800 1.180000 1.435173 1.511010 0.946136 1.395622 1.034333 0.926651 0.493738 0.346551 1.621790 1.282972 1.425869 0.157710 1.513441 0.474924 1.288896 1.561138 -0.134639 0.079645 1.241290 0.286319 0.336575 0.832549)
     )

;;; 28 even --------------------------------------------------------------------------------
#(28 6.6246975836201 #(0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1)
     6.6145820617676 #(0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0)
     6.5361909866333 #(0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.797015 #(0.000000 1.452186 1.408714 0.750826 1.327090 1.463869 1.506751 1.762893 0.991509 0.610286 0.569539 1.273403 1.424239 0.137182 0.810929 1.241810 0.539536 1.831368 -0.144630 1.374162 -0.136518 1.724313 0.157996 1.246577 0.789824 0.268797 0.857731 0.085757)
     5.764549 #(0.000000 1.443387 1.410830 0.756935 1.329597 1.465220 1.508490 1.780908 0.986543 0.621663 0.589546 1.261201 1.419039 0.147261 0.821874 1.246816 0.530749 1.827513 -0.142596 1.366399 -0.155184 1.742593 0.146553 1.251790 0.775801 0.261260 0.829229 0.099947)
     )

;;; 29 even --------------------------------------------------------------------------------
#(29 6.7166719436646 #(0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 0 0)
     6.7148699760437 #(0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0)
     6.6767044067383 #(0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.838203 #(0.000000 1.745402 1.804305 1.163042 0.685944 0.707680 0.547490 1.961430 0.212734 1.392639 1.431945 1.123472 1.734312 1.732126 0.415628 0.805522 0.341757 1.113181 0.961607 0.928945 0.366626 0.901477 0.922976 0.167906 0.984873 0.565829 1.296589 1.589668 0.440285)
     5.806619 #(0.000000 1.765877 1.813555 1.153431 0.677522 0.688767 0.531086 1.971058 0.207237 1.392319 1.447194 1.103757 1.739956 1.708261 0.408369 0.816283 0.358739 1.107332 0.955815 0.936241 0.389149 0.892843 0.929610 0.173320 0.977815 0.581084 1.284603 1.592644 0.429639)
     )

;;; 30 even --------------------------------------------------------------------------------
#(30 6.8207087516785 #(0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0)
     6.8207082748413 #(0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1)
     6.799307346344 #(0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0)
     6.6998701095581 #(0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.989517 #(0.000000 1.031597 1.280312 1.382343 -0.090570 -0.011363 0.236769 0.141832 0.331207 0.867148 1.449854 0.551169 0.557087 1.212316 0.047944 0.004465 1.908196 1.842534 1.400809 1.960585 1.629066 1.034527 0.344661 1.544924 1.678666 1.049630 0.156310 0.781187 -0.028221 1.820263)
     5.966239 #(0.000000 1.027533 1.285236 1.372321 -0.092501 -0.010841 0.257181 0.156562 0.335621 0.884022 1.444251 0.541226 0.563607 1.221593 0.042271 0.000921 1.907909 1.845962 1.395073 1.953732 1.623037 1.032830 0.326098 1.534351 1.672127 1.033933 0.133825 0.773427 -0.012180 1.818016)
     )

;;; 31 even --------------------------------------------------------------------------------
#(31 6.9357690811157 #(0 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1)
     6.9057178497314 #(0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     6.8993330001831 #(0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0)
     6.8986349105835 #(0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.8660564422607 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     6.063667 #(0.000000 1.364903 1.316632 1.173082 1.104923 1.138518 1.537222 1.298458 1.536898 1.248918 1.398961 0.349123 0.121161 0.013180 1.559739 0.286556 1.194686 0.798167 0.081528 1.332662 0.954014 0.084998 0.414512 1.824056 0.345875 0.668464 1.295362 1.561849 1.373623 0.214668 0.827950)
     6.043580 #(0.000000 1.352234 1.326989 1.180576 1.094308 1.124433 1.532159 1.302628 1.549283 1.239874 1.403884 0.347882 0.122459 -0.006165 1.560306 0.285973 1.199329 0.799429 0.084691 1.316452 0.948009 0.082126 0.401463 1.839913 0.362736 0.671645 1.301708 1.564351 1.362176 0.222042 0.833015)
     )

;;; 32 even --------------------------------------------------------------------------------
#(32 7.1377140468569 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 0 0)
     7.0221180915833 #(0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     7.011866569519 #(0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 1 1)
     7.003 #(0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1)
     6.9974670410156 #(0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.176196 #(0.000000 0.239935 1.809061 0.288056 1.103061 0.978792 1.139143 1.885977 0.173859 1.551831 0.395339 1.105441 0.484532 1.429036 1.539186 1.672434 0.870076 1.851164 -0.218537 1.857900 0.310060 0.707773 0.077288 1.704470 0.609527 -0.015510 1.691932 1.125391 1.470916 1.605797 0.885652 1.158500)
     6.141997 #(0.000000 0.241591 1.814998 0.308120 1.113804 0.964500 1.131933 1.878048 0.172046 1.544610 0.400637 1.106928 0.472941 1.409577 1.529068 1.673063 0.861723 1.844186 -0.238383 1.853195 0.303309 0.721149 0.072715 1.703712 0.618072 -0.023597 1.719416 1.135197 1.460037 1.621181 0.892460 1.144898)
     )

;;; 33 even --------------------------------------------------------------------------------
#(33 7.1199560165405 #(0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1)
     7.0745658874512 #(0 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0716042518616 #(0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1)
     7.0670447349548 #(0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     6.978609085083  #(0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.283207 #(0.000000 1.678089 1.096801 0.575335 -0.039615 1.102954 1.096777 0.400195 1.159738 0.160093 0.103767 0.965194 0.151537 0.931958 0.184332 1.608128 1.873948 1.736558 1.478811 1.247626 0.825332 1.054280 -0.183007 1.311247 1.585925 1.842302 1.794837 1.300799 1.562422 0.021128 0.100493 0.684748 1.062694)
     6.259732 #(0.000000 1.674387 1.093299 0.580339 -0.030636 1.106925 1.106520 0.394711 1.159928 0.173454 0.110534 0.972770 0.146014 0.929453 0.178717 1.621502 1.867902 1.724190 1.479911 1.230847 0.826275 1.066293 -0.197618 1.306235 1.588947 1.848513 1.791777 1.286214 1.562705 0.038208 0.098995 0.692447 1.079488)
     )

;;; 34 even --------------------------------------------------------------------------------
#(34 7.3321795463562 #(0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0)
     7.3251795768738 #(0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     7.3184022903442 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0)
     7.314661026001 #(0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1)
     7.3119759559631 #(0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0)
     7.2703185081482 #(0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0)
     7.2649097442627 #(0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0)
     7.2615523338318 #(0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.412360 #(0.000000 0.025248 0.189605 0.493795 0.703167 0.961049 1.154655 1.801071 0.130997 0.894406 1.450458 0.042272 1.020827 1.704478 1.480189 1.477230 -0.195971 0.032136 -0.114096 1.499523 0.110755 1.234670 0.494291 1.385071 1.505382 1.282258 1.184252 0.745346 0.185958 1.693156 0.502543 -0.049028 -0.043916 1.335434)
     )

;;; 35 even --------------------------------------------------------------------------------
#(35 7.3807096481323 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 0)
     7.3793916702271 #(0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0)
     7.3590030670166 #(0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0)
     7.3509883880615 #(0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0)
     7.3254580497742 #(0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 0 0)
     7.3159041404724 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.3109955787659 #(0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0)
     7.2921919822693 #(0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.481761 #(0.000000 1.520207 1.822212 1.561041 0.825520 1.491016 1.466813 1.625489 1.271526 1.054115 1.426022 0.490306 1.455011 0.979909 -0.033193 0.077309 0.330056 0.602860 1.380000 0.483223 -0.060864 0.196600 0.950124 0.494538 0.686774 1.615626 1.562262 1.035678 1.495984 1.388827 0.639594 0.440462 0.011961 0.487944 1.182067)
     )

;;; 36 even --------------------------------------------------------------------------------
#(36 7.5039777755737 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.497097492218 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0)
     7.4732356071472 #(0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     7.4679698944092 #(0 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0)
     7.466917514801 #(0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0)
     7.4267778396606 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.4214091300964 #(0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0)
     7.3326554298401 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.569778 #(0.000000 0.979254 0.866187 0.700687 1.744189 0.119414 1.598256 0.690821 0.720880 0.567036 0.446131 1.485352 0.599553 0.020906 0.240447 -0.010951 1.137670 0.243611 0.620877 1.364271 0.434369 0.647707 0.188311 -0.119504 0.365318 0.001593 -0.017943 0.664955 0.586138 1.285034 1.129231 0.132751 1.001367 1.149581 1.266954 1.579299)
     )

;;; 37 even --------------------------------------------------------------------------------
#(37 7.6800961494446 #(0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0)
     7.6781373023987 #(0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.6548581123352 #(0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.6323590278625 #(0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0)
     7.6028599739075 #(0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0)
     7.5926213264465 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0)
     7.5687103271484 #(0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0)
     7.4919209480286 #(0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

     6.711283 #(0.000000 1.308323 1.719493 0.161364 0.298182 1.460936 0.577499 1.053310 1.080234 1.617709 0.213612 1.371631 0.931472 -0.103692 0.459554 0.482692 0.900168 1.249521 0.810950 0.424370 0.179102 0.749815 1.769559 0.741998 1.182666 0.108164 0.206323 -0.059495 0.468738 0.200837 1.529688 1.062246 0.766010 0.628564 0.344011 0.972080 0.669263)
     )

;;; 38 even --------------------------------------------------------------------------------
#(38 7.7734541893005 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0)
     7.7733459472656 #(0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0)
     7.7677249908447 #(0 0 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0)
     7.7656890155417 #(0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)
     7.7583861351013 #(0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.735631942749 #(0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.669114112854 #(0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.749404 #(0.000000 -0.004519 1.975505 0.077819 0.673766 0.538539 0.110731 -0.181820 1.764590 0.598106 0.408031 -0.026880 1.453105 1.751446 0.110222 0.118051 0.800879 0.664321 -0.109898 0.876563 0.952575 1.332952 0.810033 1.582437 0.179053 0.582981 1.240032 0.496190 0.130511 0.582691 1.780691 0.191938 1.602801 0.762519 1.188263 0.837212 0.667559 0.920435)
     )

;;; 39 even --------------------------------------------------------------------------------
#(39 8.060715675354 #(0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1)
     8.0530862808228 #(0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1)
     8.0486888885498 #(0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0)
     8.0062685830938 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.813564 #(0.000000 0.959332 0.334694 0.453757 1.787157 1.496909 0.296330 1.485442 0.326157 0.307369 1.622773 0.414223 0.673689 0.692906 0.380344 1.094307 0.628020 0.500954 1.751544 0.235690 -0.146453 0.297571 -0.052653 -0.135989 0.508222 0.941403 -0.121294 1.303117 0.741319 1.183321 0.042521 0.526286 0.424248 1.258288 1.289956 1.416972 1.435932 0.628939 0.590865)
     )

;;; 40 even --------------------------------------------------------------------------------
#(40 8.1045722961426 #(0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0)
     8.0884717473459 #(0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1)
     8.0304555793911 #(0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     7.024022 #(0.000000 1.335776 1.067641 0.988236 0.660080 0.174379 1.849595 0.765594 1.778337 0.372601 1.298909 1.237014 0.171061 1.316464 1.650050 0.910839 0.165015 0.916868 1.774038 0.438059 1.169890 0.924925 1.982890 1.686557 1.561499 1.765166 0.090401 0.246854 0.831400 1.391714 1.330583 0.777426 0.616771 1.010512 0.909790 1.361934 1.017190 0.741990 1.441905 0.694346)
     )

;;; 41 even --------------------------------------------------------------------------------
#(41 8.3439186011904 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1)
     8.2169809341431 #(0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     7.073889 #(0.000000 0.163652 0.421805 0.094256 0.604464 -0.215496 0.256713 -0.206120 -0.083433 1.495584 1.327742 1.171710 1.116398 0.243965 0.176501 -0.217268 -0.263315 1.252715 -0.167662 0.269980 1.683934 0.663494 0.637135 0.915820 1.464488 -0.687835 1.480726 0.309415 1.726657 1.459870 0.607853 -0.264632 1.295540 0.476503 1.387760 1.751793 0.033256 0.605447 1.678643 1.524832 0.153431)
     )

;;; 42 even --------------------------------------------------------------------------------
#(42 8.3791161021838 #(0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1)
     8.3605623245239 #(0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     7.195059 #(0.000000 1.846612 0.517922 -0.013799 -1.848900 0.585089 1.757576 0.465557 0.145753 1.211552 1.015608 1.792065 1.627977 1.499969 0.450073 1.206853 0.110856 1.397495 0.898617 0.786978 -0.144889 1.148458 1.586701 1.885957 0.241185 0.476605 1.751060 1.518294 1.803355 0.358521 1.800100 0.015106 0.268015 1.199413 0.756884 0.769405 0.296606 -0.021548 0.375908 1.872348 1.430707 1.447781)
     )

;;; 43 even --------------------------------------------------------------------------------
#(43 8.4720001220703 #(0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0)
     8.3471550144283 #(0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.245842 #(0.000000 0.763000 0.320126 0.154359 1.553977 1.171421 1.676069 1.551662 1.690059 1.686830 0.536225 0.474995 0.900884 0.660195 0.619062 0.356876 1.267614 0.332983 1.210466 0.046411 1.189371 0.352066 1.214579 1.208511 0.319299 1.571068 1.698235 1.659543 1.375150 1.069856 1.309104 0.365372 0.497878 1.324851 1.248970 1.186066 -0.154754 0.797979 0.879863 1.589033 0.817141 1.019522 1.650885)
     )

;;; 44 even --------------------------------------------------------------------------------
#(44 8.6881771087646 #(0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0)
     8.4271850585938 #(0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.383103 #(0.000000 1.392778 1.116907 1.163749 1.827409 1.840636 1.765722 1.400481 0.542530 -0.041712 -0.080468 1.836760 -0.078893 0.813883 1.643984 0.221264 1.680282 0.286628 0.484472 0.516843 0.984039 1.311924 1.835105 1.266991 -0.113180 1.681374 1.684192 1.024605 0.001476 1.017692 0.672026 1.503682 -0.210654 0.612670 1.017518 1.457237 1.186766 0.897314 0.413971 0.549225 1.789868 0.344790 0.502198 1.409416)
     )

;;; 45 even --------------------------------------------------------------------------------
#(45 8.7060899734497 #(0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0)
     8.6457691192627 #(0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0)
     8.6353975051189 #(0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.303861 #(0.000000 0.252336 1.219796 0.897766 -0.116149 0.227305 1.280251 1.037970 1.703750 1.611424 1.039029 0.584547 1.687902 0.611923 0.336734 1.084400 1.940950 0.530526 0.505516 1.089165 0.230553 1.800499 1.732979 0.090177 1.437594 1.049713 1.491152 0.365947 0.906503 0.165666 0.784877 1.600815 1.486010 1.329354 1.968920 0.195457 1.832815 -0.054078 0.697783 0.638499 0.153835 0.002512 1.868303 -0.014000 0.429297)
     )

;;; 46 even --------------------------------------------------------------------------------
#(46 8.9617748144774 #(0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1)
     8.7916784286499 #(0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.584968 #(0.000000 1.171648 0.465468 0.131303 1.594718 0.706318 1.718863 1.146819 0.018792 0.638644 0.910087 1.741872 0.428032 0.728768 0.023219 0.190392 1.064181 0.955397 0.263288 1.604434 0.784962 1.105780 1.086559 1.109392 0.757745 -0.156366 0.703324 1.917555 1.467012 1.548344 1.687152 0.184098 0.583572 0.961866 0.890935 0.802539 0.827849 1.290283 0.446458 1.680213 0.400808 0.800817 0.644214 0.715226 0.235801 0.153353)
     )

;;; 47 even --------------------------------------------------------------------------------
#(47 8.8732557296753 #(0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 0 1)
     8.8477687835693 #(0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0)
     8.7835607528687 #(0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.625618 #(0.000000 -0.112543 0.162193 0.262936 0.309787 0.399515 0.838951 1.318637 0.309050 0.951291 0.659018 0.515026 0.357237 0.617682 0.429201 0.617868 0.107587 0.858643 1.101438 1.560790 1.678463 1.331341 1.387467 0.658619 0.018866 0.971195 0.055851 0.053110 1.495335 0.454723 1.247481 0.773775 0.481962 1.858786 -0.068326 1.177672 1.932601 1.317601 0.273394 1.974284 0.600145 1.230350 0.863034 0.080503 0.079490 0.839700 1.188593)
     )

;;; 48 even --------------------------------------------------------------------------------
#(48 9.12184715271 #(0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1)
     8.9965600967407 #(0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

     7.636493 #(0.000000 0.028693 1.120467 1.158093 0.800024 0.446569 -0.066437 0.856174 0.735463 1.673584 0.346476 1.437859 0.349869 1.139578 1.791293 0.696810 1.421492 0.977552 1.117023 1.209765 1.442202 -0.060332 1.797833 0.233016 0.529967 0.537268 1.496349 0.490346 0.064054 1.941166 1.629953 1.119736 1.426821 1.199171 0.869994 0.068331 1.351621 1.392131 1.658897 0.920213 1.222607 1.464715 1.718834 0.780016 1.387535 0.919845 0.283132 1.489192)
     )

;;; 49 even --------------------------------------------------------------------------------
#(49 9.2634744644165 #(0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
     9.1650037765503 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

     7.829193 #(0.000000 0.323049 1.344704 0.798140 0.157147 1.681485 -0.094967 1.706010 0.562203 0.795721 0.039658 0.149670 0.832958 0.197130 0.128765 1.143458 0.513852 0.134752 0.037092 1.908488 0.726689 0.689394 0.580238 0.503605 1.350245 1.712415 1.734253 0.612999 0.566517 0.051481 0.774173 0.669055 1.617094 0.146313 1.764191 1.210644 1.186600 1.383638 1.509287 0.545472 1.614480 0.915450 1.487259 0.188305 0.712809 0.635300 0.865093 0.418211 0.884324)
     )

;;; 50 even --------------------------------------------------------------------------------
#(50 9.348 #(0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0) ; symmetric??
     9.1582123370176 #(0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

     8.061391 #(0.000000 0.848304 1.906034 0.717235 1.654989 0.350862 1.908758 1.834522 1.523890 0.651926 1.325704 0.581829 1.432577 0.897105 0.351652 0.085225 1.945629 0.205834 1.536529 1.627626 0.751888 1.902257 0.518694 0.527289 0.555603 0.878856 0.220241 1.096010 1.173082 1.194996 0.265333 -0.008645 1.106310 1.518132 1.781944 0.661768 1.030936 1.632841 1.470993 1.679277 1.723896 0.934398 1.041183 0.889820 1.879142 1.121251 1.025588 0.471632 0.840736 1.408733)
     )

;;; 51 even --------------------------------------------------------------------------------
#(51 9.5728101730347 #(0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0)
     9.3615226745605 #(0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

     8.073326 #(0.000000 1.714786 1.798056 0.010691 1.628607 0.763600 0.325637 1.588806 1.808657 1.240021 1.045091 0.169750 1.796417 0.628005 0.108291 0.700744 1.649641 0.896541 1.858034 1.628342 1.661313 1.143416 -0.005342 0.327043 0.477585 1.985806 0.132230 1.480987 0.454969 0.348094 0.815328 0.921275 0.535471 1.387692 1.940044 0.580772 1.520592 0.713211 0.170291 0.240523 1.232963 -0.053338 0.428998 0.883901 1.907781 1.807735 1.804520 0.110542 1.598981 1.571369 1.584535)
     )

;;; 52 even --------------------------------------------------------------------------------
#(52 9.5426025390625 #(0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 0)
     9.449512348335 #(0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     8.109037 #(0.000000 0.170617 0.822424 0.130317 0.512278 0.840838 0.376654 0.011826 0.847974 0.935719 1.156767 0.988491 1.212358 0.784165 0.623846 1.062101 -0.248448 0.299809 1.294866 0.811364 0.428281 0.405353 0.989549 1.482814 0.063462 1.333062 0.607212 1.151768 1.238361 0.381364 0.398903 1.927224 0.513150 0.301272 0.655721 0.286962 1.558011 1.785096 1.458107 0.428869 0.261909 0.771439 1.093062 1.890735 0.964966 -0.227288 1.132497 1.865413 -0.199040 1.603372 0.902418 0.549278)
     )

;;; 53 even --------------------------------------------------------------------------------
#(53 9.7615919113159 #(0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1)
     9.627 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0)
     9.6159172058105 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     8.332771 #(0.000000 -0.305777 0.739546 0.287019 0.873776 0.467647 0.260092 0.969699 0.230130 -0.248312 1.342773 0.953339 0.409543 0.886181 1.828162 0.815530 1.034243 1.236759 1.424969 -0.208771 1.213666 1.694961 1.013513 0.268408 0.675155 0.218350 1.343058 1.220034 0.612003 -0.024036 1.199102 -0.202108 -0.092385 1.678334 1.255389 1.310958 1.425594 0.535192 0.621180 0.813753 0.904557 0.988200 1.161547 1.771646 0.578148 0.935050 0.569713 1.586532 1.430758 0.831829 1.061309 1.872314 0.553903)
     8.331454 #(0.000000 0.064790 1.743038 0.428336 1.687525 0.916084 0.380682 0.672389 0.529534 1.402731 1.197784 0.869630 0.061996 1.517820 1.770614 0.701028 1.626810 1.046495 0.186990 0.439124 1.175071 0.998009 1.713491 1.407134 1.067634 0.719966 0.856284 1.945520 1.543390 0.459036 0.968057 1.043910 1.961608 0.707099 0.431358 0.323317 0.618539 0.687174 1.087599 1.684455 1.012081 1.338550 0.326942 0.826668 1.253275 0.986097 0.866217 1.911671 0.158840 0.189353 1.716267 0.227691 1.700951)
     )

;;; 54 even --------------------------------------------------------------------------------
#(54 9.7764141549279 #(0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1)
     9.748743057251 #(0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0)
     9.5190944671631 #(0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     8.327978 #(0.000000 0.703874 -0.045870 1.083105 0.910562 1.709224 0.752320 0.676636 1.727253 0.406956 0.628051 1.254106 0.915000 0.708380 1.350179 0.575837 0.060701 0.472172 0.431638 0.694804 0.056847 1.096627 0.958901 0.033520 0.304289 0.129086 1.839141 0.689720 0.412664 0.458828 1.793123 0.732060 0.641059 0.959950 1.216262 0.606686 1.445547 1.622833 1.050078 1.577327 0.465586 1.312214 0.490961 1.693592 0.139730 0.536821 0.865761 -0.223218 1.775855 -0.039697 0.105137 1.384381 1.367487 1.056359)
     )

;;; 55 even --------------------------------------------------------------------------------
#(55 10.131931993478 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)
     9.9292899584938 #(0 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1)
     9.7848987579346 #(0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1)
     9.6719217300415 #(0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

     8.400332 #(0.000000 0.937858 1.424299 1.491234 0.356603 0.269499 0.823051 0.140834 0.007093 1.384539 0.065171 1.179829 1.337847 0.888934 1.516583 1.086639 1.832964 0.655763 0.957739 1.447852 0.442425 -0.100624 0.763023 0.186395 1.123797 0.469482 0.964293 0.031109 0.553730 1.734865 -0.071253 1.370148 1.434247 1.615143 1.497915 -0.004439 0.269417 1.275776 1.240784 1.654731 1.538640 1.530128 -0.023186 1.869831 0.173455 0.365378 0.066757 1.669686 1.143525 0.981925 0.440908 1.891475 1.167343 1.224747 0.392931)
     )

;;; 56 even --------------------------------------------------------------------------------
#(56 10.014793395996 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1)
     9.9184818267822 #(0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     9.7536716461182 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 1)
     9.6809562784664 #(0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     8.534566 #(0.000000 1.023637 1.841901 0.204847 0.864860 0.668152 1.448235 1.595993 1.580660 1.464363 -0.040249 -0.216737 0.861056 0.474876 0.984599 0.110801 1.271443 1.273671 0.808331 0.690558 1.339079 1.752478 0.129002 1.657791 0.162633 1.137301 0.120533 1.578698 0.715771 1.357045 -0.030250 1.436148 1.123135 0.894313 1.136318 1.045472 0.841413 0.148653 0.671546 -0.198802 -0.587694 1.520026 0.192928 1.566202 0.335810 0.335233 1.321356 0.211571 0.356337 0.213403 0.306397 0.236633 1.881376 1.509611 0.348572 0.414192)
     )

;;; 57 even --------------------------------------------------------------------------------
#(57 10.246812120784 #(0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0)
     10.114218711853 #(0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0)
     9.9813938140869 #(0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     9.8992366790771 #(0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

     8.589773 #(0.000000 1.192233 0.062666 1.232903 0.255751 0.512244 0.475405 -0.396189 0.442650 0.236608 0.772144 1.154621 0.291588 0.857937 -0.119936 0.651013 0.717262 1.105353 0.738624 -0.325387 0.316363 0.600888 1.083040 -0.345384 1.073017 1.297319 1.427236 1.827233 0.881528 0.545348 0.971873 1.830310 -0.343130 -0.138251 0.267902 1.467697 0.250609 0.345727 0.244285 1.396066 1.257166 0.749805 1.638413 -0.258778 1.592715 1.415608 1.156040 0.348672 1.009987 0.636528 0.221787 1.030873 0.325749 1.616093 1.396484 0.731107 0.466853)
     )

;;; 58 even --------------------------------------------------------------------------------
#(58 10.486150288901 #(0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1)
     10.185283647732 #(0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1)
     10.040289878845 #(0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1)
     9.8761510848999 #(0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.680769 #(0.000000 1.072860 0.888272 0.238811 0.653446 0.734395 0.285852 1.155997 1.301025 1.773537 1.855956 1.051796 0.968510 0.891291 0.485483 0.311266 1.304957 1.249805 0.833314 1.762856 -0.015674 0.736950 1.126879 0.793573 1.622535 1.359978 -0.173029 1.130324 1.107187 0.421488 1.271359 0.424863 0.028853 1.580675 1.564845 0.235468 1.119196 1.504389 1.821411 1.807431 1.113468 1.153896 0.824568 0.957990 0.751188 0.995731 1.393700 1.514969 0.784317 1.458312 0.519023 1.807112 0.893783 0.481136 1.760666 0.590839 1.096607 0.219833)
     )

;;; 59 even --------------------------------------------------------------------------------
#(59 10.306503751934 #(0 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.305177937827 #(0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.237511634827 #(0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.094394683838 #(0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.761160 #(0.000000 1.447450 1.831638 1.068973 1.475970 0.999993 0.876392 -0.018362 0.644470 -0.128263 -0.133208 0.429039 1.088233 1.688951 0.035797 0.934646 1.786964 0.273442 1.238805 1.241924 1.128607 1.239139 0.390859 -0.098309 0.489073 0.773215 1.462341 1.529492 1.346421 1.299375 1.307151 -0.004017 0.224966 1.184348 1.108914 -0.038815 1.759128 1.714367 1.265375 1.192778 1.843013 1.075410 0.577470 0.267854 1.082396 1.068038 1.113663 0.015267 0.715436 1.679959 1.029183 1.926759 0.327619 -0.031990 0.486925 0.155627 0.605977 0.761897 0.294949)
     )

;;; 60 even --------------------------------------------------------------------------------
#(60 10.491376876831 #(0 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     10.333255371943 #(0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.863258 #(0.000000 0.262284 1.115915 0.211010 1.512339 0.190060 0.195810 0.057777 0.645564 1.361862 0.226343 0.181464 0.506628 0.321688 0.440203 1.931823 0.192351 0.786794 1.324633 1.686187 -0.166603 0.367010 0.060778 1.126723 1.270445 0.012980 1.422982 1.267378 1.616845 0.868158 0.320208 1.308888 0.231182 0.268964 1.060086 0.565479 0.702980 1.819983 0.876078 1.690157 1.846356 0.149193 -0.025394 1.546608 1.258724 0.257609 0.243886 1.639194 0.615079 0.626207 0.896033 0.091991 0.662157 -1.860274 1.473984 -0.306246 1.413731 1.094226 0.372908 0.308593)
     )

;;; 61 even --------------------------------------------------------------------------------
#(61 10.587104797363 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0)
     10.557340621948 #(0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1)
     10.209 #(0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0)
     10.120587847566 #(0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     8.941648 #(0.000000 1.186832 -0.103925 -0.245138 1.607497 1.102256 0.078017 -0.085760 1.589414 0.995331 0.513407 0.334309 0.316700 1.793579 1.099795 1.709646 0.081588 0.832926 1.335472 0.416473 0.434693 0.198333 0.859054 1.719419 0.038083 1.304196 0.122505 0.865023 0.317087 0.993102 0.257738 1.544496 1.447870 1.171668 0.222514 -0.146285 0.199252 0.072409 0.497503 1.239355 1.427700 0.167108 0.164700 1.147382 0.285313 1.297914 1.232196 0.231920 0.583284 0.289512 0.515254 0.310609 1.165751 0.412956 1.749929 1.797357 0.150681 1.704325 1.570898 1.629358 0.118543)
     )

;;; 62 even --------------------------------------------------------------------------------
#(62 10.800075218392 #(0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0)
     10.501984943687 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1)
     10.318392753601 #(0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     9.059195 #(0.000000 0.613104 0.050124 0.485665 0.048815 -0.055963 0.225331 -0.020835 1.848095 1.580120 1.477292 0.774210 1.061948 -0.249723 0.577003 1.863830 1.431032 0.894357 1.924718 1.302439 0.428785 1.093116 0.543830 0.902139 0.238757 0.822688 0.992472 -0.322520 0.896632 1.415835 0.796532 1.295997 0.680129 1.882417 1.596330 0.750056 0.856079 0.485605 0.070121 0.122325 0.958152 1.497519 0.362755 0.547778 1.145775 0.325693 0.504673 0.636053 0.726885 1.081630 1.254650 1.468511 0.348105 -0.121688 0.484408 0.530263 1.153408 1.456512 0.792291 0.661790 0.062458 1.508137)
     )

;;; 63 even --------------------------------------------------------------------------------
#(63 10.855396270752 #(0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1)
     10.6811876297 #(0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.562 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.45694065094 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     9.146322 #(0.000000 1.260653 0.495821 1.565425 -0.034815 1.595215 -0.110213 0.317428 0.602347 1.611730 -0.106084 1.408417 1.797326 0.002729 0.097532 0.152521 1.496997 1.630977 0.421415 0.278701 -0.058497 0.391330 1.009308 1.705103 1.214572 0.946148 0.443786 1.420417 -0.000218 1.717745 1.344525 0.947962 1.771032 0.193775 0.684462 0.355972 1.493181 1.725437 0.431727 0.763898 1.716457 1.397971 0.315205 1.664888 0.284014 0.131738 1.254268 1.837779 1.352726 1.355620 1.719024 1.311615 1.184524 0.727627 0.380843 0.630737 0.956331 0.683452 1.770865 1.337097 1.756188 1.248295 1.867866)
     )

;;; 64 even --------------------------------------------------------------------------------
#(64 10.952004432678 #(0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1)
     10.532917976379 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1)
     10.487 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     9.183306 #(0.000000 0.960773 1.387037 1.860143 1.807675 0.342388 0.442314 0.378641 1.718756 0.111924 1.649035 0.933666 1.589281 0.956105 0.705575 0.164351 0.571557 1.051206 1.157542 1.529278 -0.186012 0.910690 1.736753 0.662422 0.717289 1.660748 1.383682 1.893587 0.438369 0.904480 0.150947 1.274172 0.670990 0.938984 1.952338 1.761793 0.643026 1.311278 0.095707 1.936806 -0.149301 0.404418 0.173210 1.321409 0.722082 0.659783 1.342634 0.869239 1.111880 0.418881 0.960653 0.642249 -0.025509 0.421290 1.098679 0.696133 0.577478 1.190171 0.285967 1.312806 1.019398 0.899136 0.605475 0.551502)
     )

;;; 65 even --------------------------------------------------------------------------------
#(65 10.903659606228 #(0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 0)
     10.842938423157 #(0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0)
     10.593795776367 #(0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

     9.269099 #(0.000000 1.521014 0.030274 1.447375 0.481194 -0.103142 0.333042 0.515048 0.766335 1.205694 1.617283 0.203031 0.406562 0.560296 1.931331 1.388660 0.558731 0.719009 1.186104 0.019315 0.567180 0.334727 -0.031160 1.805253 1.093445 0.571790 0.648420 0.864092 0.466921 0.905698 0.752571 1.681538 0.540204 1.582970 1.641754 1.287764 1.975587 0.831626 1.243228 0.648557 0.705542 -0.069890 -0.020696 0.861807 0.542617 1.949169 -0.079326 0.476140 -0.233285 1.668946 0.358512 1.633633 1.815535 0.999660 0.780365 1.188003 1.352647 1.602281 1.757204 1.379097 1.022619 0.134115 1.248959 -0.086016 1.545001)
     )

;;; 66 even --------------------------------------------------------------------------------
#(66 10.77367179842 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

     9.380135 #(0.000000 1.014179 0.522691 1.602843 1.284784 1.402101 1.262686 1.755437 0.337742 0.051583 0.402397 0.273748 0.936171 0.512603 1.607992 0.018372 1.248053 1.098880 0.880657 1.525665 0.376629 1.449960 0.719680 0.603014 -0.239848 1.263814 1.603687 0.672157 0.302944 1.448728 0.368089 1.811299 1.819707 1.854605 1.716681 1.717427 1.506437 0.444652 0.802632 0.783933 0.990100 0.630975 1.746749 0.875615 0.885810 0.777435 0.867933 0.097112 1.630664 1.275816 1.081947 1.715704 0.950280 0.371433 0.550956 1.065928 1.600415 0.477266 1.124510 1.473855 1.697441 0.735638 1.218460 1.072265 1.170584 1.522780)
     )

;;; 67 even --------------------------------------------------------------------------------
#(67 11.373999595642 #(0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1)
     11.240343093872 #(0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0)
     10.668939590454 #(0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

     9.334192 #(0.000000 0.368552 0.386526 1.781223 1.388843 1.362090 0.346034 1.149326 0.636198 0.704715 1.433700 1.166218 0.320173 -0.128155 0.093285 0.161474 0.537789 1.549624 0.751253 1.453469 0.546314 1.253910 1.069653 0.803146 1.054343 1.812512 0.147176 0.336943 0.829952 0.678057 0.839038 0.220975 0.114273 0.864432 0.769942 0.344669 -0.071276 0.769076 0.355858 1.167914 -0.079007 0.717090 1.323907 0.254048 0.573355 0.397638 0.586852 0.019367 1.256105 1.137105 1.059084 0.516760 1.463555 1.202794 0.466984 1.349540 0.533707 1.320298 1.219996 -1.824382 0.308082 1.055688 1.774825 -0.020808 0.297327 1.800711 -0.077466)
     )

;;; 68 even --------------------------------------------------------------------------------
#(68 11.328473091125 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0)
     10.834321813096 #(0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

     9.655313 #(0.000000 1.941633 0.518610 1.398591 0.644514 1.387692 0.043178 0.259339 1.774161 0.821861 -0.547691 -0.090076 1.249411 1.636456 1.397059 -0.248392 0.958360 1.140734 0.401098 0.375793 0.596545 1.240361 1.543355 0.578056 0.547768 1.565797 1.185852 1.122052 0.471310 0.960201 1.717865 1.789868 -0.262495 1.815955 1.736953 0.789552 0.504824 0.885981 0.876282 0.376065 1.268158 1.264028 0.509113 0.106449 -0.049845 0.759337 0.763291 0.076126 1.230817 0.105504 1.543213 0.616153 1.332275 1.311651 0.740800 1.463251 -0.036843 0.119879 0.843013 -0.181701 1.332111 1.421865 1.520233 1.946163 1.809645 -0.362733 1.377925 1.600119)
     )

;;; 69 even --------------------------------------------------------------------------------
#(69 11.439030647278 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0)
     11.237507249543 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0)
     11.164121627808 #(0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     9.493533 #(0.000000 0.796063 0.938102 0.939895 1.369534 1.627903 1.058413 1.264945 1.286987 0.085368 0.597980 1.077100 0.407570 0.854414 1.018898 0.907941 0.342887 0.335922 1.219358 0.060354 1.903241 1.740265 1.716471 0.185226 0.009659 1.743647 1.515410 0.295112 0.717355 0.472058 0.388693 1.104075 0.040101 1.532367 0.844740 0.546684 1.474039 1.237846 1.015077 1.093879 0.503332 1.826832 0.199281 1.582101 1.356315 1.167481 1.656332 1.352567 1.024737 0.198771 0.832820 1.203717 1.176932 1.427648 1.135779 0.329781 1.134805 1.527856 0.108184 0.710059 1.390451 1.468996 1.245661 1.786719 0.618254 1.713548 1.018885 1.715955 0.912921)
     )

;;; 70 even --------------------------------------------------------------------------------
#(70 11.561226844788 #(0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1)
     11.405939102173 #(0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 1)
     11.188811302185 #(0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

     9.729815 #(0.000000 1.187674 0.007668 0.591115 0.280738 0.703145 0.848453 0.975264 1.348918 0.080132 1.137577 1.450660 0.646481 0.586921 1.135636 0.136684 1.044368 0.439673 0.933141 1.466120 0.465815 1.115152 0.314407 1.708765 0.679850 0.589495 0.614441 0.294199 1.442947 1.342781 1.236282 1.710991 1.071518 0.412932 0.951994 -0.021057 1.033997 1.519125 1.509408 0.813064 1.091901 0.611010 0.672823 0.318901 0.070819 0.153267 0.358159 0.410568 0.567500 -0.100301 1.562861 1.125548 0.317419 0.992531 1.400733 1.539746 0.048670 0.211366 0.444465 0.307988 0.037761 1.779315 0.703043 0.136869 1.224713 0.928194 0.164279 0.940652 1.228104 1.881909)
     )

;;; 71 even --------------------------------------------------------------------------------
#(71 11.438183906719 #(0 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.28450554254 #(0 1 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.146488189697 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

     9.521784 #(0.000000 0.149876 0.668787 1.502876 0.957175 1.555537 0.107725 1.538576 0.227752 0.544910 0.924127 1.988854 0.896563 1.749259 0.586797 0.884101 0.957571 0.770989 1.571572 1.147518 0.067720 0.414360 1.667689 0.234552 1.471792 0.826400 0.955036 1.475295 1.131742 1.462020 1.195046 1.651336 0.711164 1.714450 1.296704 0.178052 1.266292 0.782550 0.111382 1.595989 0.016097 1.848981 0.512479 0.997038 1.413308 1.375081 1.124465 1.124501 1.131526 1.336184 0.557339 0.658540 1.325950 1.390720 0.405055 1.432173 0.624530 0.485586 1.827783 1.645677 1.076506 0.519522 0.267900 0.726975 0.733835 1.998426 0.075489 1.855722 1.413742 1.284579 0.460141)
     )

;;; 72 even --------------------------------------------------------------------------------
#(72 11.543568607158 #(0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0)
     11.490025520325 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1)
     11.323646371629 #(0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     9.927306 #(0.000000 0.539760 0.995556 0.661574 1.486090 1.617678 1.856183 1.769657 1.699662 0.306992 -0.270017 0.992379 0.871567 0.087261 0.507897 0.635610 1.783522 1.644924 -0.152893 1.459736 -0.096708 0.602067 1.567440 0.722469 1.049108 0.100271 1.598981 1.541651 -0.049538 1.778708 1.763685 1.048735 1.144507 1.782321 0.145848 1.655600 1.806661 0.581376 0.461474 1.450753 0.836851 1.694341 1.634062 1.185455 1.142416 1.043152 0.388746 1.086654 0.884727 1.762161 0.846749 0.978239 0.477803 0.775176 1.630129 1.795939 0.420014 0.757645 1.272694 1.725621 1.782894 -0.002112 1.140320 0.118946 1.649468 1.115404 1.370550 0.663270 0.229568 1.232177 0.117679 1.213021)
     )

;;; 73 even --------------------------------------------------------------------------------
#(73 11.708482477396 #(0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.567651928526 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.416394233704 #(0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

     9.964655 #(0.000000 0.467394 0.780869 1.119676 1.525017 0.186136 -0.114294 1.683631 0.465735 0.091207 -1.963924 0.876782 1.103475 0.472079 0.365315 1.480096 1.311028 1.992139 0.309149 0.820907 1.058253 0.144963 1.934243 0.678025 1.081963 0.558483 1.166841 1.734092 1.427126 1.325415 1.491061 -0.123280 1.577140 -0.141256 1.709808 1.301362 1.255198 1.547302 0.591334 1.744750 0.867555 0.680104 0.962924 1.225569 0.568729 1.727093 1.133320 1.146370 1.013263 0.427037 1.330843 0.243245 -0.092674 0.684362 1.518794 1.489672 1.285054 0.888282 0.718744 -0.107015 0.723436 1.011923 -0.145502 0.760366 1.644019 0.049394 -0.406990 0.620745 1.617776 1.546934 1.626053 1.193696 0.870216)
     )

;;; 74 even --------------------------------------------------------------------------------
#(74 11.869382858276 #(0 0 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1)
     11.749699425492 #(0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1)
     11.47264289856 #(0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

     9.951470 #(0.000000 1.653540 1.792207 0.365209 1.702196 -0.081288 1.292797 0.648691 0.074669 1.487701 -0.139067 1.881903 0.759373 1.508138 1.684891 0.115826 0.108569 -0.115053 0.889190 0.154219 0.818914 1.157589 0.975278 0.283067 0.252957 0.310633 1.354847 1.536626 -0.037044 -0.126618 0.161358 1.687507 0.084928 1.704298 1.380353 -0.024000 0.135212 1.795345 0.850533 1.886274 1.030988 1.468697 1.599874 0.924503 0.000561 0.712560 1.508541 1.047771 0.757231 0.549151 1.495041 -0.080428 1.490913 -0.058016 0.372430 0.645258 0.966694 1.716247 0.379653 1.155248 1.642455 1.217269 0.747716 1.844052 0.736265 0.684155 0.436877 1.255792 0.037410 1.833063 1.630578 1.321663 1.131168 1.583537)
     )

;;; 75 even --------------------------------------------------------------------------------
#(75 12.015588177241 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1)
     11.787453747993 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1)
     11.599789619446 #(0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1)
     11.479255355845 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     9.857519 #(0.000000 1.316377 1.733766 1.979705 0.281173 1.330210 -0.058534 0.463912 0.663475 1.016723 0.107387 0.672078 0.800181 0.178188 1.334144 0.233851 0.974434 1.793884 0.273923 0.333767 0.274670 1.148295 0.635673 1.516304 1.573244 1.387853 1.715811 0.012739 0.728387 0.501780 1.377316 1.522039 0.075538 -0.050182 1.364915 1.735014 0.848763 1.141919 0.455360 0.781062 1.096519 0.343346 0.697117 -0.002332 0.124120 0.197403 0.591401 0.122820 0.083902 1.179844 0.759804 0.588640 0.584659 1.363052 0.855884 0.630459 0.084907 1.022440 0.513467 1.178778 0.293437 1.014089 0.621831 0.108932 1.852675 1.768110 0.607985 1.176478 0.694816 0.122041 1.903764 0.298165 1.288861 0.976071 1.131938)
     )

;;; 76 even --------------------------------------------------------------------------------
#(76 11.890932162956 #(0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1)
     11.477294510597 #(0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

     10.137292 #(0.000000 1.499933 -0.012481 0.156688 1.046334 0.830857 1.733665 1.498161 -0.085575 0.642531 1.046018 1.336924 0.882594 1.372985 0.298668 1.113657 0.047283 1.970143 0.548879 1.376679 1.264846 0.025424 1.200568 0.213191 0.328941 1.580188 1.503291 0.657777 1.124057 0.728464 1.406793 1.895013 1.704985 1.163898 1.831527 0.312985 1.686406 0.065301 1.622515 0.079317 0.642787 1.551209 1.317622 0.748117 1.480860 0.251145 1.655486 0.391689 1.879556 1.879823 1.576564 0.264389 0.937803 1.683990 0.384118 0.278765 0.583196 0.084035 1.839623 1.157509 1.671247 1.409613 0.640850 1.429016 1.303805 0.944638 1.212010 0.906741 1.137905 1.054941 1.302396 0.233516 1.761748 1.568247 0.677178 0.295346)
     )

;;; 77 even --------------------------------------------------------------------------------
#(77 11.909692733602 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1)
     11.875939332637 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1)
     11.594018936157 #(0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

     10.112364 #(0.000000 0.729556 0.211835 1.614221 0.116450 1.721151 0.941175 0.622136 1.535789 0.946560 0.236460 -0.091982 0.158372 0.017957 1.180982 1.183777 1.532430 0.490226 0.824944 1.185071 1.296236 0.986568 0.472703 0.009962 1.186739 1.141751 0.971016 -0.057234 1.911449 1.396908 1.580449 1.804522 0.657850 1.520218 0.371161 0.471971 1.712136 1.412303 1.393022 1.994688 1.844489 1.804379 1.914054 1.822955 1.240667 -0.022461 1.155932 1.052523 1.182022 1.655193 1.192218 -0.100412 0.376866 1.416802 0.218232 1.919277 0.954924 1.070724 1.630777 0.160028 1.027928 0.453464 0.853671 1.160053 1.338401 1.018703 1.816234 1.192941 0.498394 0.959341 1.809699 1.338212 0.552806 1.585835 0.058673 0.304538 0.159172)
     )

;;; 78 even --------------------------------------------------------------------------------
#(78 11.940728787203 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     10.242791 #(0.000000 0.739621 1.847987 0.379643 0.419721 1.173544 1.070574 1.157474 0.321967 1.155166 0.418347 1.081070 0.994264 0.511589 1.208329 1.421195 1.078823 1.270879 0.734368 1.617327 0.483475 1.787314 0.875438 0.761878 0.838889 1.031240 1.840532 1.396129 1.189822 0.424421 1.022570 0.467375 0.647547 -0.154952 1.229926 0.665127 0.286051 0.279655 0.339346 -0.038743 0.838733 1.530462 1.209079 1.385833 -0.094939 1.069535 0.522599 1.927649 1.524102 0.945855 0.417429 0.319937 0.540331 0.858537 0.469905 0.697362 1.637439 1.310235 -0.242589 0.790328 1.753148 1.643035 0.925374 1.365231 0.010880 0.696633 1.104992 0.255370 1.679227 0.238628 0.423295 1.081916 1.543283 0.375559 0.677881 0.748935 0.499554 0.884901)
     )

;;; 79 even --------------------------------------------------------------------------------
#(79 12.421415328979 #(0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)
     11.878196632448 #(0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

     10.347496 #(0.000000 0.257264 -0.105997 1.725915 1.358491 0.297485 0.503299 0.153580 0.879852 0.374628 1.365364 1.057729 0.490462 0.821542 1.651339 0.084733 1.207301 -0.190378 1.315802 0.805204 0.874974 1.666571 1.295835 0.843015 1.234390 1.321282 1.167321 1.622732 -0.066591 0.535349 1.341087 1.755634 0.724585 1.665600 0.598131 0.407090 1.680117 0.798575 0.024566 -0.221892 0.249898 1.351241 0.785111 0.081269 0.325874 0.190035 0.030022 0.201906 -0.246148 1.496545 0.553879 0.460513 1.774456 1.162167 0.140847 0.653369 1.216062 1.608658 1.539123 0.887497 0.315797 0.182453 0.022676 1.834405 0.151124 0.186595 0.902340 -0.256756 1.301462 1.596725 0.502582 1.734725 0.413969 0.359717 0.638679 1.211355 1.577017 -0.036129 1.699121)
     )

;;; 80 even --------------------------------------------------------------------------------
#(80 12.739060401917 #(0 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0)
     12.226613044739 #(0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0)
     12.095606803894 #(0 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0)
     11.989325523376 #(0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

     10.471341 #(0.000000 1.693155 0.601283 1.990237 0.133013 1.829045 1.776567 1.880757 0.356549 0.334952 0.891643 0.073965 0.603054 1.718295 0.794152 0.325355 0.704454 1.070969 1.201114 0.998252 -0.168378 0.294740 0.542763 0.679338 0.968501 0.582081 1.141193 -0.038128 1.597592 0.463772 1.413910 1.113620 -0.214058 1.267868 0.402866 1.576213 0.942393 0.828449 0.508268 0.187091 1.322166 1.678016 1.553500 1.536615 1.249382 0.379564 1.026064 0.371751 1.394164 1.432031 0.703915 0.884674 1.475725 1.614002 0.811092 0.425800 0.209492 0.192185 0.321862 1.658534 1.573035 0.437980 1.145628 1.889956 0.491955 1.154944 0.614300 0.115870 1.445521 0.645424 0.859825 1.666633 0.070947 0.047026 0.929506 1.459013 0.443693 0.523553 0.299992 0.717337)
     )

;;; 81 even --------------------------------------------------------------------------------
#(81 12.189952580352 #(0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1)
     12.039585160315 #(0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)
     11.979215621948 #(0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

     10.483407 #(0.000000 1.249735 0.975362 0.847899 0.832344 0.584652 1.400950 -1.674642 -0.002795 0.390213 1.376490 0.344145 0.413785 1.015170 0.348647 0.224753 0.300042 0.551451 1.455512 0.783687 -0.100780 0.702703 1.640788 1.961127 0.203959 1.087080 0.148682 -0.091618 0.887847 1.112133 0.552997 0.736071 1.367509 0.154553 0.092463 -0.069298 0.359713 0.262743 0.280177 0.522087 0.341483 0.657474 0.421663 0.783343 0.705212 0.008373 0.028581 1.253406 0.947610 0.287392 1.482933 1.738094 1.320925 1.500397 1.170691 0.953341 1.558566 0.292192 1.779328 1.902955 0.812712 0.859902 1.104675 1.563681 1.320567 0.210420 0.047452 1.331520 1.032625 1.379164 0.624244 -0.000099 1.002111 1.518627 0.134789 0.794150 0.343312 0.927380 0.982119 -0.084411 0.290972)
     )

;;; 82 even --------------------------------------------------------------------------------
#(82 12.307968522655 #(0 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0)
     12.071621513807 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0)
     11.74796962738 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

     10.636249 #(0.000000 0.178167 0.508082 0.580272 1.358957 1.278001 0.680411 0.844379 1.564224 1.384206 0.134447 1.139202 1.297433 0.028093 -0.140108 1.671616 0.920090 0.207198 0.147767 1.339948 0.448042 0.774770 1.751329 0.582191 0.691964 1.392089 0.753619 -0.133769 0.787461 0.110452 0.550568 0.043473 0.851443 1.296026 1.241980 0.961869 1.135570 0.322052 0.035102 1.384991 1.599678 0.464918 0.124153 0.055952 1.558316 1.113953 1.496483 1.140310 1.397947 1.544218 0.156043 0.574478 0.966105 0.458326 1.426433 0.062717 0.067664 0.482151 0.817060 0.191713 0.168088 0.234727 0.545713 0.302763 1.538024 1.962391 0.027763 0.872598 0.417650 0.341383 1.508407 -0.066617 1.565949 0.456540 0.287109 0.308435 0.426920 0.462178 1.663535 -0.192076 0.966426 1.732063)
     )

;;; 83 even --------------------------------------------------------------------------------
#(83 12.587569236755 #(0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1)
     11.931811297539 #(0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

     10.545310 #(0.000000 1.790258 0.818527 1.084568 1.838072 0.108875 1.346785 -0.051002 0.588635 0.792328 1.507466 1.179398 0.713964 0.739008 1.228367 1.120856 1.638453 0.321793 1.385752 0.797773 -0.193159 0.834269 0.918506 -0.133632 0.624955 0.816624 1.461448 1.106339 0.470858 0.582350 1.131742 0.461453 0.962420 0.662409 1.128744 1.506674 1.054718 1.845998 1.083392 1.298494 1.013169 0.424402 0.402304 0.772949 0.037710 0.450698 0.553710 0.370166 1.708903 1.565251 1.370939 0.709332 1.524864 1.126752 1.577595 0.027167 -0.197123 1.533881 0.782587 1.449308 0.844907 1.290377 1.595278 0.304770 0.122121 1.847861 0.632643 1.047541 0.231883 0.745611 0.151712 1.798421 0.023380 1.002933 0.439925 1.021700 0.740527 1.965988 0.609665 1.593003 0.906504 0.749868 1.765247)
     )

;;; 84 even --------------------------------------------------------------------------------
#(84 12.747644424438 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.50866273996 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.426499838032 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     10.672081 #(0.000000 0.077441 0.336805 0.777645 1.047873 1.712927 1.265391 1.639762 0.129977 0.311983 0.778355 1.037800 0.654559 -0.132671 0.285404 1.615382 0.136057 0.542155 1.084197 1.497378 0.684998 0.782706 0.843204 0.224128 0.127037 1.826277 1.307179 1.473674 0.044325 0.772209 0.076725 0.921166 0.504000 0.153706 -0.026779 1.062767 0.227646 1.156360 0.434067 0.781935 1.482260 1.440116 1.436341 0.023213 1.550406 0.034158 0.895016 0.189431 0.441260 0.751332 1.302693 -0.034792 0.165021 0.700045 0.535022 -0.187408 1.096812 0.748687 0.501849 0.814929 1.103606 0.472533 0.983337 1.075186 0.609759 1.057020 0.433318 1.701318 -0.176399 0.718399 0.888609 0.212666 1.827058 -0.263615 1.486469 1.402240 1.321304 1.623239 0.655476 1.447252 0.873726 -0.192516 1.175888 1.045263)
     )

;;; 85 even --------------------------------------------------------------------------------
#(85 12.635076593197 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1)
     12.624737923152 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1)
     12.270205061432 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     10.872428 #(0.000000 0.234336 1.618876 0.394370 0.375902 1.431031 1.713138 0.053022 1.172185 0.213155 0.147133 1.593839 0.435553 1.755758 -0.029128 0.062014 1.406473 1.150967 0.382692 0.908412 -0.255689 0.784448 1.578574 0.961131 1.197330 0.069677 1.336307 1.336836 1.658711 1.195189 0.567029 0.382869 1.297633 0.455222 1.646552 0.149756 1.759744 0.282552 0.763387 1.268508 1.356273 1.752980 1.407422 1.581304 0.692463 1.240332 1.254418 0.307672 1.373696 1.248991 0.580182 1.002335 0.065291 0.113467 0.551202 0.307617 1.901544 1.435696 1.199847 1.823257 0.473148 1.121887 0.651433 -0.137993 0.076183 0.795427 0.741877 1.674168 0.756093 0.724343 0.592862 1.563330 1.465412 0.016959 0.949692 0.338661 1.361101 0.324479 0.715091 0.577019 0.363283 0.980449 1.139204 1.217047 1.278923)
     )

;;; 86 even --------------------------------------------------------------------------------
#(86 13.114136440046 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)
     12.791990425787 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     10.884106 #(0.000000 -0.147631 0.796882 0.337635 1.428067 1.185697 -0.165977 0.860475 1.014419 0.910797 1.104827 0.549224 1.660283 1.424507 1.293725 0.145548 0.134128 1.210370 0.245762 1.414108 1.144867 1.388665 1.159918 0.548130 1.657812 0.523701 1.515391 1.120809 1.139704 0.170245 0.696491 0.890635 1.693949 1.741590 1.811794 0.600361 1.380193 0.352524 0.288545 0.330851 1.453425 0.856395 0.541037 -0.112174 0.201572 0.499449 1.446800 0.422281 1.482845 -0.056943 1.534048 1.405300 1.350935 1.491209 1.575834 0.045841 0.861401 1.515785 1.915873 0.825207 0.207358 1.910300 0.158099 0.790908 0.108454 1.048819 0.315139 1.577085 1.629624 1.173968 1.255142 0.009802 0.523071 -0.080523 0.345781 0.640184 1.470535 1.603090 1.189519 0.466765 0.883563 1.134034 0.781354 1.629362 -0.046386 1.864515)
     )

;;; 87 even --------------------------------------------------------------------------------
#(87 13.008953483644 #(0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.872 #(0 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.669403362513 #(0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1)
     12.625063286678 #(0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     11.064437 #(0.000000 0.943193 1.132742 -0.085024 0.438797 0.605867 1.753159 1.621647 1.174651 -0.041577 1.749442 0.370465 -0.037216 1.840155 0.345860 0.265743 1.787610 0.695626 0.698636 0.493601 0.857157 1.433491 1.930966 1.801188 1.215652 1.721790 0.582893 0.225837 0.050992 1.828494 0.939361 1.028991 1.654645 1.652246 0.056285 -0.004269 1.963981 0.895813 -0.187163 0.213615 0.305223 1.690724 0.659305 1.084012 0.735225 1.810907 0.722807 -0.030667 0.879695 1.351318 1.659353 1.229292 1.032504 1.651402 0.504135 1.828246 0.716439 1.533248 0.911342 1.742146 1.673285 0.718414 1.787778 0.860612 0.955301 0.278473 1.659992 1.891071 0.496654 1.149247 1.532620 1.183722 0.796537 0.204415 -0.081565 0.306829 0.122803 0.269536 0.040046 1.842755 1.726714 1.702320 1.379387 1.853348 1.841322 1.235435 0.948149)
     )

;;; 88 even --------------------------------------------------------------------------------
#(88 13.132745742798 #(0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.908752771202 #(0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.675436588537 #(0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.661032846106 #(0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     10.982749 #(0.000000 1.416232 0.323161 1.758133 1.767021 1.669225 1.187222 0.704269 0.950156 0.534770 0.809921 0.667129 1.001127 -0.051484 0.632506 1.661582 0.176313 1.770413 -0.080943 -1.856622 0.145941 1.210287 0.185763 1.746688 0.491335 0.364784 1.771849 0.353886 0.264785 0.089974 0.946082 0.056173 1.824160 0.099037 1.329649 0.697134 1.603568 1.928618 0.446696 1.524297 0.879977 0.422633 1.861879 1.613569 0.642757 0.840705 0.830819 -0.101294 1.692372 1.165889 1.523917 1.785506 0.309742 0.857697 0.563477 1.184455 0.420737 0.983432 1.364421 1.736763 0.796728 0.792140 0.306660 1.593170 0.552920 1.812912 -0.036532 1.181793 0.809981 0.492582 1.477215 1.437494 1.856243 0.306281 0.367334 0.774105 0.517645 0.239127 1.635191 0.215726 1.038498 0.721160 0.213665 0.574924 1.654195 0.809698 0.844611 1.243828)
     )

;;; 89 even --------------------------------------------------------------------------------
#(89 13.321250915527 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0)
     13.191189069613 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1)
     12.707793861614 #(0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1)
     12.335865540187 #(0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     10.879155 #(0.000000 1.189690 1.737077 0.761828 0.617912 1.218011 1.047737 1.582403 1.170897 1.054751 1.832262 0.641398 0.991498 1.574646 0.930382 0.943609 1.858109 1.821533 0.335332 0.489873 1.075664 1.224051 -0.012662 1.514654 0.660197 0.345738 0.359912 0.563718 -0.105205 1.558435 0.578729 0.893911 0.764520 -0.022623 1.520780 1.837180 1.309551 0.948329 0.798736 0.706051 1.507254 0.514482 1.920592 0.968354 0.305179 1.786125 -0.007130 0.168950 0.180248 1.064226 1.501158 0.860044 1.460562 1.241240 1.011403 1.777292 -0.112591 0.802324 0.014972 0.476153 1.728124 0.718331 0.105815 0.403565 1.037023 0.174096 0.623096 1.782507 0.367373 0.320446 0.480517 1.697023 0.230676 0.625395 0.486784 1.272561 0.658076 0.564859 0.581989 0.074429 1.494629 1.451352 0.466544 0.529713 1.454909 1.036178 0.551332 0.537112 0.154538)
     )

;;; 90 even --------------------------------------------------------------------------------
#(90 13.535882949829 #(0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1)
     13.016282120103 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0)
     12.779235839844 #(0 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0)
     12.716424196959 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

     11.133646 #(0.000000 1.168885 0.192379 0.641820 1.613861 0.710425 0.710852 1.194705 1.582515 0.272891 0.144160 -0.101668 0.332668 0.434429 1.600866 0.847220 1.274347 0.878363 1.094691 1.290298 1.467150 -0.057723 0.300169 0.118047 1.403550 0.404894 -0.555506 0.764273 1.145070 1.670145 1.476686 -0.339631 0.110804 -0.003511 1.017260 1.839823 1.132773 0.281523 1.581469 0.398233 0.699309 0.381151 -0.082455 1.127842 0.135058 1.560144 1.711622 1.458664 1.869033 1.064820 1.332671 1.413851 1.969220 -0.021525 1.281818 1.297812 0.820400 0.416738 0.187772 1.336807 1.236928 1.145386 1.320385 1.245713 0.566174 1.822588 0.252002 1.579472 0.002697 1.130431 1.731009 1.830550 0.473545 0.609993 0.555237 0.474942 -0.251026 0.654962 0.234045 0.067094 0.842647 1.829596 0.660285 0.736874 1.718031 1.983971 0.071071 1.084768 0.974233 0.169674)
     )

;;; 91 even --------------------------------------------------------------------------------
#(91 13.63089466095 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     13.263186228373 #(0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     12.853587071592 #(0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

     11.347997 #(0.000000 -0.126053 1.516321 0.137211 1.178803 0.871363 1.238270 0.018148 0.213232 1.052088 0.700930 0.438347 1.799679 0.137211 1.041348 1.907167 0.341661 1.957369 0.410479 0.570175 1.342675 1.961312 0.868547 1.120726 1.688848 1.756017 0.805852 0.776891 1.262120 1.036274 1.004241 0.144560 0.414210 0.680477 1.297869 0.355131 0.429440 1.642776 1.416012 1.525855 1.540700 0.049281 1.703596 0.701303 1.670208 0.313365 -0.050230 0.075781 0.150242 1.795202 0.935986 0.792976 0.531170 0.811845 1.775645 1.101867 0.069724 1.408008 1.087177 1.339758 1.600782 1.198985 0.699948 0.425961 0.801045 0.565369 0.533254 1.361169 0.187048 1.072189 0.581456 0.366786 -0.009518 0.647777 0.502912 0.907605 1.014578 0.562053 0.840670 0.973511 1.919646 0.196609 1.449084 0.528878 0.601166 0.378240 1.034232 1.417865 1.928682 1.033900 0.608757)
     )

;;; 92 even --------------------------------------------------------------------------------
#(92 13.355320111641 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0)
     12.754180011349 #(0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

     11.420171 #(0.000000 0.815306 -0.022044 1.354800 1.084588 0.918663 0.322861 1.581806 0.966328 1.770247 0.559652 1.565748 1.262231 0.682013 0.420329 1.193222 -0.189590 1.340523 1.358351 0.261408 1.220394 -0.066828 1.293320 1.553944 0.330037 0.660528 1.263342 0.019084 1.747314 -0.364670 1.352666 1.813454 -1.871253 1.088829 0.514939 0.165124 0.056920 0.604350 0.839878 0.350691 1.129185 1.438364 0.056930 0.665941 1.267686 0.443309 1.405432 0.959599 1.161972 1.329546 1.191670 0.361403 1.044739 -0.091533 1.257901 1.391492 1.813850 0.236759 0.163519 0.272339 0.922011 0.769828 1.658358 1.104730 1.032055 1.363011 0.076330 1.765708 0.923257 1.161396 0.654754 1.137485 0.454927 0.323560 0.353595 0.207244 0.531187 -1.889316 1.710812 0.371002 0.794297 1.432281 1.622286 1.908915 1.919139 1.246413 0.240051 -0.007498 0.574039 0.177174 1.764522 0.972986)
     )

;;; 93 even --------------------------------------------------------------------------------
#(93 13.783703804016 #(0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0)
     13.143995954461 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0)
     12.876626968384 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     11.415697 #(0.000000 0.744829 -0.547698 1.711697 0.558425 0.614716 0.595291 0.340186 0.014003 0.185842 1.020391 0.099150 -0.180011 -0.032792 0.515346 1.651970 0.338285 0.610963 0.052785 1.084316 1.303062 0.737153 0.533985 0.745328 1.672434 1.634300 1.892991 1.719808 -0.166978 1.022736 0.393076 1.623837 1.528244 1.069307 1.212631 0.502176 0.633061 1.593525 1.535164 -0.209919 1.662236 1.683938 0.336126 0.756142 -0.106383 0.001852 0.765706 0.313200 0.960258 1.007026 0.163110 0.327093 1.222026 1.197705 0.447415 1.289217 1.130720 1.290563 0.267709 1.228707 0.093465 1.792922 0.206438 1.560500 1.132655 1.873548 -0.258990 0.837446 1.459561 0.656684 1.370173 1.471002 1.730606 1.244940 0.639014 0.543849 0.719961 1.334324 1.691707 1.128393 -0.078585 1.667644 -0.108279 0.479784 0.144868 0.090473 0.040035 1.674890 1.557843 1.860274 1.614559 0.985189 0.000283)
     )

;;; 94 even --------------------------------------------------------------------------------
#(94 13.381710407562 #(0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0)
     12.991560374803 #(0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     11.415822 #(0.000000 1.497912 0.291653 0.158099 0.284570 0.194391 0.834012 1.440037 0.774075 0.537734 1.516989 1.264719 1.674986 1.783322 0.338446 0.890416 0.353401 0.105711 1.762626 0.640819 1.932144 0.462523 0.349125 0.667022 0.867923 0.503039 0.405283 0.190438 0.393238 0.666728 1.803118 0.417662 -0.198188 0.416348 1.540912 1.789220 -0.061171 1.199874 0.226999 1.080139 0.400598 1.147355 1.672684 1.525516 0.687774 0.686227 1.091742 0.832229 1.486075 1.083575 1.480031 1.527499 0.947795 0.940984 1.052204 0.124511 0.217389 0.310501 -0.194349 1.294739 0.270067 1.449087 1.042603 1.094288 1.712905 0.808220 0.630032 0.342446 0.562993 1.433319 1.698703 0.666924 0.564552 1.483529 0.719987 1.305679 -0.013829 0.025504 0.878039 1.188307 1.549506 0.920247 1.325948 0.281202 1.609882 1.304676 0.870679 0.281325 1.633001 0.652814 -0.217240 0.148263 0.490707 1.941659)
     )

;;; 95 even --------------------------------------------------------------------------------
#(95 13.458537482645 #(0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0)
     12.939489078295 #(0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

     11.543463 #(0.000000 0.144585 1.727620 1.682156 1.060898 1.625808 1.029014 1.458881 1.709187 0.756495 1.010253 0.471586 1.458705 0.680816 0.666142 1.150039 1.538759 -0.348057 1.225184 1.822325 1.690278 -0.103516 0.159710 0.740271 0.470953 0.651129 0.225706 0.601964 0.935249 0.627511 1.041400 1.469782 0.518487 0.724245 0.910938 0.662035 0.391606 1.276573 0.205030 1.618922 0.342991 0.433462 1.547132 0.959173 0.539192 -0.352328 0.173213 1.567623 1.806910 0.519300 1.179008 1.598025 0.495633 0.545219 0.866272 1.226721 0.768670 0.976069 0.271679 0.763318 0.335064 0.943085 -0.162382 1.331362 0.545948 0.497664 0.649916 0.170721 -0.337825 1.599532 1.004906 0.901494 1.200062 0.154376 0.743493 0.966619 0.876325 0.005515 1.301859 1.542780 0.061052 1.772391 0.898554 0.716062 1.391391 1.703689 1.135350 1.061678 0.127793 1.029996 0.504124 1.480899 0.544043 0.680725 1.917721)
     )

;;; 96 even --------------------------------------------------------------------------------
#(96 13.465419214875 #(0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.179516746745 #(0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.077001047978 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     11.582607 #(0.000000 0.667251 -0.097020 0.557417 1.175984 1.294020 1.241208 0.707624 1.388852 0.006609 0.492998 1.692653 1.247400 0.175793 1.538250 1.048111 0.552779 0.205433 -0.130517 1.562670 -0.482989 1.445186 1.597963 0.541707 1.727331 0.715578 0.996171 0.039970 0.329890 0.426071 0.110246 0.953104 0.810366 0.017388 1.592457 1.990738 1.263814 1.140669 0.773346 0.555969 1.544719 0.352377 0.255483 0.502354 1.715489 1.766862 0.729422 1.548361 0.661578 1.407332 0.598816 1.737157 1.012609 0.321287 0.159101 1.163321 1.160609 1.833401 -0.076478 1.194580 0.936057 1.220809 1.988136 1.920692 1.333670 -0.188761 1.311228 0.914103 1.086723 0.719609 0.874871 1.553277 0.865471 0.972690 1.006760 0.821411 1.695453 0.365040 -0.139325 0.695372 0.640135 0.314232 0.771955 1.403528 -0.475736 0.487726 1.634907 0.940507 0.591904 0.708239 0.925612 0.995328 1.361379 1.052940 1.411655 1.768375)
     )

;;; 97 even --------------------------------------------------------------------------------
#(97 13.449318349909 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)
     12.969611395004 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

     11.689133 #(0.000000 0.288152 -0.041431 1.579060 1.308080 0.126439 1.658538 1.247164 1.119564 1.905649 1.074354 0.014561 1.681946 0.119968 1.077747 0.297607 0.116908 1.630559 1.089826 -1.968743 0.583840 1.372762 1.448163 0.357921 0.744043 1.618871 1.363273 1.763797 0.028728 0.265362 0.880766 0.606613 0.786300 0.187518 0.829010 0.635374 1.616681 0.543350 1.661010 1.338785 0.325980 0.857529 1.557299 1.868251 0.055480 1.826671 1.268331 0.044212 -0.080646 1.058861 1.950822 1.730874 0.815066 0.146864 1.126860 1.382614 0.006310 1.883810 -0.019169 1.751549 0.894522 0.435481 0.840195 0.445039 0.297648 1.496604 1.771343 1.102173 1.492845 1.942931 1.638427 0.481671 1.178697 0.497139 1.182041 -0.063081 1.429901 1.397481 0.361780 0.295216 0.486297 1.409739 0.171309 1.637498 1.780926 0.336524 0.933414 1.558224 1.149775 1.169914 0.789876 0.817179 1.459274 0.785094 1.675907 1.094563 0.798428)
     )

;;; 98 even --------------------------------------------------------------------------------
#(98 13.940406967968 #(0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1)
     13.490633234777 #(0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1)
     13.468658765207 #(0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

     11.837229 #(0.000000 1.834561 0.900612 0.084730 0.858197 1.271280 1.664592 1.208084 0.808074 0.347778 0.298999 0.868702 0.503256 0.986719 0.963636 0.186959 1.635013 0.801327 1.508666 -0.171364 1.512374 1.092140 0.636473 1.352156 -0.169622 0.741114 0.453999 -0.293238 1.741300 -0.051607 0.386370 0.853371 1.121260 1.284485 0.247758 1.130018 0.307560 1.163323 0.731435 1.227338 0.476963 1.046276 0.188589 0.018608 -0.081633 1.649978 0.372033 0.371073 0.946191 1.706701 0.043438 0.618522 1.366408 0.616434 1.841084 1.573991 -1.888455 1.413189 0.507801 0.173369 0.817400 0.987503 1.693962 1.009896 0.952032 0.506895 0.669292 0.447014 0.977055 1.622180 -0.027150 0.747570 1.447357 0.259615 0.562884 0.312563 0.903930 0.298277 0.889395 0.949112 0.771181 1.876459 0.265260 1.006066 0.702915 0.660991 0.356668 0.115838 0.194598 0.435085 0.334157 1.582574 1.435180 1.120692 1.368873 0.522801 0.279288 1.652455)
     )

;;; 99 even --------------------------------------------------------------------------------
#(99 14.049349722487 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.942 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.341398779709 #(0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

     11.820647 #(0.000000 1.285679 0.177252 -0.016014 0.497060 0.184674 1.824536 0.038271 0.421635 1.354691 -0.155595 0.352830 0.188756 0.584383 0.918084 1.262780 0.659094 1.652571 1.205560 0.815899 1.486605 0.156385 0.205925 0.938917 1.280084 0.230385 1.280249 0.137247 0.973120 0.865023 0.015813 1.097763 1.354729 0.177726 -0.256171 0.619096 1.028015 1.497914 0.103010 1.935761 0.393333 1.732935 1.720883 0.231715 0.530761 0.568998 -0.082246 0.146847 -0.218664 1.501549 -0.094580 0.977707 1.907745 1.600862 1.831827 1.620012 1.338596 0.577320 0.245433 0.303344 1.278937 0.150454 -0.044427 1.632452 0.552822 0.974684 0.834871 0.928076 0.416772 1.400171 1.695021 1.174110 0.348776 1.137430 0.049915 0.835547 0.999472 0.532408 0.661612 1.577344 1.793003 1.564377 1.393709 1.295143 0.081940 1.598880 1.200334 0.508389 0.385394 0.876999 1.034286 0.425485 1.739634 0.704973 1.523508 0.652655 0.237948 1.569550 -0.032754)
     )

;;; 100 even --------------------------------------------------------------------------------
#(100 14.500160217285 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1)
      13.694382146343 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
      13.512077331543 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      11.818799 #(0.000000 1.780438 0.140937 1.687229 1.096296 1.077280 1.115122 0.119502 -0.485601 -0.142878 1.432856 1.068798 0.504428 0.539041 1.446543 1.150828 0.478983 1.035414 0.831599 1.121092 1.179681 1.121418 0.724286 1.358416 -0.517766 -0.814412 0.864005 0.044721 1.333726 1.684984 -0.099249 0.745081 1.044705 0.170980 0.507797 1.631098 0.954293 0.779236 0.696910 1.420723 0.885428 0.834530 1.714830 1.685955 1.308892 0.872776 1.671217 0.703077 1.313961 0.550241 1.824176 1.483882 0.614826 1.545700 0.494590 0.939413 1.664969 0.826778 -0.289652 0.036626 1.628137 -0.860878 -0.041439 0.401710 0.365682 1.714008 1.762554 -0.080614 1.247910 1.867757 0.621824 0.433280 1.074878 1.479709 1.788607 1.949940 0.528220 -0.196728 0.911346 0.528049 0.904974 1.287119 0.432949 1.250835 1.091665 1.317682 1.451853 1.363996 0.642902 0.526337 0.830805 0.643189 0.460110 0.258781 0.236205 -0.398217 1.599939 1.694559 1.242237 -0.179320)
      )

;;; 101 even --------------------------------------------------------------------------------
#(101 14.704120635986 #(0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
      14.20509180893 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)
      13.916260357992 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

      11.839894 #(0.000000 1.194704 0.385391 0.712681 0.403147 0.845100 1.441220 0.208132 1.798249 0.379463 0.511222 1.895870 1.345856 1.726819 1.088004 0.358351 0.853545 1.491800 0.175566 0.657864 0.389160 0.664912 1.113579 1.078650 1.076017 1.164924 0.546388 0.141684 1.482931 1.715115 -0.149747 0.586885 1.350105 0.246263 0.898940 0.793447 0.780962 1.212957 1.875900 1.656490 0.885130 1.503051 1.408221 1.662784 1.410288 1.501403 0.765313 -0.047802 1.260295 0.851021 0.081635 -0.133968 0.516501 1.664350 1.496296 0.529899 1.522520 0.540611 1.589723 0.470521 0.178354 1.163731 0.373894 0.969867 1.094633 0.613429 1.888164 0.451261 0.617786 0.623061 1.872898 1.765870 1.497924 0.888482 1.354581 -0.003863 1.722450 1.619021 1.636916 1.195858 1.221988 1.800043 0.877268 1.102664 -0.156060 1.699654 0.856960 0.758369 1.742919 1.644913 0.901317 1.598031 0.093920 1.199881 0.708612 0.465115 0.846545 1.312391 1.313363 1.586427 1.126992)
      )

;;; 102 even --------------------------------------------------------------------------------
#(102 14.246722674125 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1)
      13.955191612177 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1)
      13.554303556646 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

      11.876307 #(0.000000 0.954911 0.897658 0.064379 1.933952 1.067160 0.431000 0.787496 0.036198 0.042991 1.425219 0.261830 1.285917 0.097131 1.243963 1.622027 0.531920 1.658178 0.955802 1.059851 0.399770 0.519083 0.891572 0.838705 0.965896 0.648877 1.874581 1.834671 0.676915 1.564245 1.211582 -0.033066 0.520609 1.638395 1.212629 1.935675 0.835768 0.064973 1.508866 1.280331 1.767547 1.597714 0.677381 0.058691 0.445428 1.748515 0.074348 0.798024 -0.012181 1.475197 0.303895 0.971082 0.928727 1.833926 0.679559 1.012189 0.611196 -0.097377 1.304298 0.131688 0.970424 0.572520 0.785284 0.524847 0.033400 -0.094448 1.394035 0.364493 0.417079 0.466898 0.925495 1.760788 1.972514 0.033140 0.086967 0.636765 1.074368 0.420339 0.447867 0.792579 1.868294 0.659717 0.639893 0.012489 0.034883 0.300422 0.122102 1.565376 1.031516 0.035785 -0.252910 1.227900 0.050923 0.310595 0.283041 0.641253 0.685176 1.632599 0.667159 1.165729 1.466279 1.314687)
      )

;;; 103 even --------------------------------------------------------------------------------
#(103 14.267168699654 #(0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      14.260 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      13.923377530893 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

      12.011191 #(0.000000 0.287655 1.905823 0.341084 1.480797 0.978938 0.781985 0.378023 1.191693 -0.063938 0.881335 0.973225 0.437334 0.274334 0.986490 1.411549 0.409327 0.041425 1.521503 0.373192 0.648785 0.307101 1.143053 1.056576 0.423798 0.843790 0.689778 0.472673 0.108371 1.324641 0.233549 0.996026 -0.095312 0.692803 -0.053250 0.519846 0.152916 0.647583 0.809375 -0.120694 1.129490 1.659592 0.533649 1.613327 0.204977 0.367138 1.675652 0.581755 1.487960 1.562574 0.273504 0.926534 0.188004 1.055854 0.513817 1.684850 1.511004 1.774367 0.117483 0.395041 1.058616 1.412461 1.330620 0.193151 1.851793 1.373579 1.450147 1.510063 0.053202 0.515877 0.732069 0.024776 1.252612 0.993121 1.592847 1.081130 1.675926 1.586912 1.349443 0.084278 -0.081381 0.591400 1.367793 0.557810 0.022826 0.276162 0.240229 0.119596 0.266147 0.443873 0.602002 0.883556 1.881155 0.270627 1.732523 1.481896 1.147923 0.955238 1.267695 0.803777 0.540506 0.766623 1.186359)
      )

;;; 104 even --------------------------------------------------------------------------------
#(104 14.290776635081 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)
      14.080453047533 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

      12.162591 #(0.000000 1.385942 1.365175 -0.181832 1.833297 -0.317061 0.535635 1.677497 1.704728 0.884522 1.569220 1.253358 1.409865 1.190316 0.167596 0.672623 0.539677 1.464029 1.492207 1.812357 1.825320 1.309841 0.988935 1.453935 1.316039 1.134427 1.303902 0.817691 0.890337 0.674843 1.224194 0.897663 0.676492 1.587741 -0.179340 1.626155 0.556614 0.215948 1.282015 -0.070806 0.176448 1.084767 0.209981 0.466109 1.537425 1.510725 0.334733 1.646431 1.559866 1.572850 0.871214 1.877647 0.435220 1.290893 0.096694 1.474960 1.762574 0.303162 0.506316 1.915000 0.472154 0.276209 1.289890 1.539150 1.362343 0.851327 -0.086912 1.821582 0.302230 0.072318 0.268906 0.915931 1.567513 0.296570 0.261941 0.948840 1.052189 1.715703 0.702533 1.123244 0.664602 0.643864 0.260591 1.326258 1.385624 1.048395 0.445963 0.697351 1.278158 0.984844 -0.148439 1.005962 0.014203 0.154576 1.689024 1.548878 1.827715 0.559290 0.729001 0.152829 0.676939 1.597371 0.975481 1.486563)
      )

;;; 105 even --------------------------------------------------------------------------------
#(105 14.699862480164 #(0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0)
      14.062 #(0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)
      14.023490699521 #(0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

      12.092342 #(0.000000 1.078142 1.184871 1.887960 1.400123 0.157527 0.342646 0.317378 0.006395 1.537309 0.221957 1.036939 0.282622 1.284813 1.197950 -0.135237 1.711634 1.937632 0.797283 0.983284 1.788168 1.111760 0.919676 0.264934 0.378390 0.616942 1.342923 1.148531 0.675857 -0.200664 0.731946 0.464162 0.297786 0.387619 1.541770 1.509752 0.114142 1.571660 1.254437 0.112800 0.260513 1.825156 0.944526 0.256665 1.577890 0.491857 0.474302 0.305250 0.882483 -0.256448 0.108351 0.057998 0.314951 0.664634 0.981025 1.825378 0.650352 1.031813 0.996484 1.438278 0.526359 0.432153 1.391918 0.563546 1.558349 -0.034169 0.934568 1.009380 0.291683 0.577147 0.602738 1.849541 0.365743 0.593776 0.858066 1.055814 0.967977 0.327223 1.261228 0.151237 -0.048430 1.524114 0.142285 0.115065 1.852116 1.485915 1.656670 1.150588 1.780640 1.218538 0.107043 0.551067 0.213669 1.837197 1.777795 0.860568 1.907281 0.193893 -0.232563 -0.023437 1.040086 0.996688 0.587973 1.828004 1.707692)
      )

;;; 106 even --------------------------------------------------------------------------------
#(106 14.783208847046 #(0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.160224278203 #(0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.077123010357 #(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

      12.260782 #(0.000000 1.699252 0.255052 0.109209 0.352866 0.420181 0.561252 1.356150 1.501855 0.506597 1.784613 0.807779 -0.065510 1.899998 1.500998 0.673007 1.055021 0.335739 1.794309 -0.019932 1.180142 1.304310 1.105320 0.741663 1.706119 0.926501 0.226888 0.621386 1.454196 1.908787 0.704837 1.733269 0.843390 0.100903 0.180551 1.614394 1.486115 1.092570 0.794003 1.360146 0.749929 0.875871 0.396273 0.237797 0.244077 1.314000 -0.213671 1.555040 1.474363 1.582151 0.766234 0.800139 1.138192 1.847813 0.554958 1.557810 0.929989 1.144666 0.366369 0.711942 1.002184 1.372521 1.205081 0.542923 0.424756 1.341481 1.416043 0.120166 -0.250794 1.672994 1.366514 0.367084 1.484552 -1.978566 -0.074060 1.833422 0.859123 0.687411 1.437881 0.748330 1.690602 1.317654 0.539214 1.445899 1.708082 1.903290 0.642870 0.240740 1.224943 0.862508 0.785038 1.549253 1.427782 0.966102 1.299799 0.782749 1.357166 1.747164 1.071716 1.276650 1.624157 0.344224 0.919875 1.420585 0.356626 -0.197145)
      )

;;; 107 even --------------------------------------------------------------------------------
#(107 14.355038210217 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 1)
      13.979104817741 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      12.377435 #(0.000000 -0.356365 1.741770 0.654257 0.938877 0.636144 1.628626 1.283506 0.305421 0.414006 0.026884 1.641477 1.326701 0.626536 0.165480 1.012144 1.124173 0.122702 0.102869 0.577780 0.233033 -0.101298 1.162680 1.342329 0.711906 0.797883 0.802744 0.456194 1.126339 0.373048 0.800537 1.255867 1.422500 1.262871 1.642379 1.694628 1.710103 0.486487 0.105228 1.498223 1.527737 1.752080 1.696603 0.581346 1.266353 0.296164 0.671940 0.538677 0.155651 0.765289 0.002624 0.228464 1.267947 1.608669 -0.016400 -0.020618 0.043602 1.843555 1.186040 0.972163 1.745646 0.463974 1.637108 0.391915 1.508977 0.219747 0.124813 1.434177 1.444614 0.006335 -0.020287 0.063572 1.171482 -0.052031 0.997020 1.286227 0.230251 1.752919 0.351566 1.792566 1.718117 1.381606 -0.010333 1.160069 1.208789 -0.093156 0.090887 0.921136 1.326452 1.433518 0.524701 1.400136 0.426933 1.334862 1.102407 1.482327 0.418036 0.424939 1.765694 0.030312 0.237868 0.571033 0.681000 0.274292 0.590946 1.723066 1.512954)
      )

;;; 108 even --------------------------------------------------------------------------------
#(108 14.418597227362 #(0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0)
      14.367991447449 #(0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1)
      14.247987286758 #(0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1)
      14.201394892821 #(0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      12.575614 #(0.000000 0.705913 -0.189863 1.289812 0.805665 1.299437 0.514901 0.468348 1.202685 1.403387 0.332176 1.259041 1.785692 1.506203 0.060262 0.201724 1.287046 0.143530 1.091484 1.184140 0.705185 1.181985 -0.016499 0.235089 1.775175 1.801425 -0.306108 1.638395 0.380925 0.275806 0.952509 1.328298 0.642464 0.496491 0.471712 1.326864 -0.164320 0.059399 0.135164 0.025628 0.320184 0.276924 0.799138 0.661351 0.284412 1.200080 0.481145 1.216291 0.365285 0.355693 1.057082 1.448275 0.539254 1.427694 0.879806 -0.009441 1.355155 0.331674 0.861766 -0.066983 1.407740 0.183724 1.490485 1.400425 1.195059 1.408070 1.536509 0.991234 0.870664 0.216821 0.739487 1.605608 1.623066 0.891911 1.010727 1.220868 0.158671 0.433687 0.651755 0.964120 0.861318 1.227136 1.119209 0.696872 0.440953 1.950827 1.070095 0.885103 0.398516 -0.136342 1.766979 1.632991 0.362688 -0.178463 0.221974 0.700697 -0.203679 1.158840 0.255408 1.016147 0.565750 0.866296 1.771230 0.955576 0.794958 0.453725 0.880485 0.387061)
      )

;;; 109 even --------------------------------------------------------------------------------
#(109 14.988188773557 #(0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0)
      14.476561866583 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

      12.660218 #(0.000000 1.451807 1.259946 0.861466 0.459796 0.085386 1.142398 1.872230 0.650002 1.203106 0.845859 0.285130 0.193680 0.773172 1.533754 0.683295 0.648068 0.025894 0.735549 0.531121 0.950654 1.549443 0.865212 0.970046 0.139794 0.139195 0.296028 0.027900 0.353084 0.353405 1.649523 0.944435 0.928249 1.301666 0.293400 0.882481 0.173725 1.737676 1.824878 1.193543 1.016688 1.580251 1.962575 1.878998 0.842009 1.047261 0.449180 0.277571 1.464860 0.488788 1.380789 0.810563 0.864129 0.400304 -0.032901 1.263424 0.810983 1.214362 1.042091 0.009399 0.766807 0.815284 0.824383 0.081271 1.853565 1.169447 1.843181 1.454523 0.129723 1.535307 1.307738 1.155855 0.461230 1.056886 1.355016 0.899575 1.702211 0.205873 0.400610 0.583062 0.836778 1.490536 -0.045281 0.201022 0.165041 1.216918 0.535869 1.718648 1.543255 1.268230 1.777880 1.589170 -0.139876 1.661725 0.614482 1.723156 0.013818 0.390798 0.359498 0.741329 0.545842 1.880235 0.955230 1.139112 1.870240 0.481825 0.827913 0.234060 0.560058)
      )

;;; 110 even --------------------------------------------------------------------------------
#(110 14.433 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.401108392424 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.141825477743 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      12.623836 #(0.000000 1.366317 1.128494 0.500809 1.095552 1.415552 0.279763 1.330724 1.079399 1.868510 1.929926 0.592126 1.718533 1.048685 0.231720 0.589006 1.271011 0.468697 0.008926 0.704476 0.289036 0.290293 0.362707 1.521100 1.304262 1.574411 0.403502 0.679502 0.912196 0.768451 -0.228414 1.165144 -0.002504 0.192891 -0.008333 1.486868 0.521089 1.841885 0.782814 1.135864 0.781862 1.760412 0.845117 1.561555 1.830193 1.728594 0.742328 1.405522 1.236687 1.358773 1.669091 1.583907 1.669160 1.734839 1.772542 0.737573 1.594004 1.362367 1.553450 1.491666 1.921385 0.654218 1.213782 1.624464 1.591433 0.050218 1.193480 0.750234 0.370099 1.464359 0.516885 0.244885 1.452762 1.381716 1.379144 0.089280 0.979482 0.528695 0.407297 0.227080 1.406188 1.606603 1.113373 0.943713 1.950426 1.566786 1.348013 1.522129 0.269965 1.829776 1.480217 0.736791 0.844511 -0.041620 0.852114 -0.216851 0.489534 0.284771 1.968568 0.355390 1.515971 0.154211 0.941086 1.653785 0.474360 1.653068 1.000893 0.578652 0.974586 1.261473)
      )

;;; 111 even --------------------------------------------------------------------------------
#(111 14.983455708572 #(0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.470418444168 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.043108609984 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

      12.812802 #(0.000000 1.347823 1.327493 0.845640 1.890817 0.184423 0.373859 1.084586 1.500910 1.532916 0.096214 1.632191 0.590216 1.327334 1.057966 1.652877 0.936953 1.119842 0.625621 1.799691 0.619050 0.440782 0.612435 0.666288 0.344970 0.320601 0.110419 1.105089 1.134433 0.413366 1.401909 1.114781 0.079650 1.114075 0.262779 1.395675 0.996008 0.113818 1.726331 1.643950 0.341273 0.275652 1.777723 -0.006890 0.325220 0.940786 1.239837 0.117019 1.000877 1.355496 1.442201 0.383194 0.645238 1.784017 0.810577 1.456858 1.039939 -0.079671 0.307319 1.967281 0.127136 0.644388 1.983314 1.247260 1.221295 0.429911 0.129489 0.014948 1.739758 1.109328 0.580506 0.332884 0.783245 0.253511 0.260773 0.479216 0.436580 0.257032 1.745045 0.540456 0.187000 0.844237 0.696145 1.770380 0.428998 1.436437 0.045814 0.333676 0.177764 0.648983 1.687723 0.765861 1.025768 0.906637 1.639333 0.921212 0.611113 0.145004 1.629641 1.553947 0.080119 0.749058 1.477080 0.344325 0.696119 0.546649 0.670112 1.238428 1.640219 -0.095453 1.814269)
      )

;;; 112 even --------------------------------------------------------------------------------
#(112 14.939 #(0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0)
      14.53456401825 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

      12.816717 #(0.000000 0.056023 0.796820 0.591620 1.407761 1.282014 0.838139 0.772972 1.469635 1.265876 0.127893 1.054941 0.928861 0.984236 0.362321 1.206110 1.105243 -0.347207 -0.251520 1.616883 1.291875 0.425399 0.428841 0.546307 1.923564 1.456001 1.012774 0.418963 0.017962 -0.020241 1.812141 1.299220 0.326916 0.772727 1.197175 0.679375 -0.024208 0.672853 1.136947 1.402616 1.035751 1.918494 0.861517 1.680506 1.475977 1.012016 1.116188 0.905765 -0.185977 1.100761 0.294222 1.518699 1.386957 1.202441 0.204052 -0.141471 1.350438 0.616526 1.725905 0.209822 0.136117 1.557710 0.950555 1.193828 0.700482 0.789319 1.805508 1.694813 -0.006474 0.010927 1.707287 1.545228 0.150258 1.827454 0.004575 0.351227 1.444643 1.652867 1.909374 0.932224 1.720972 0.093238 0.225332 0.558343 0.944623 1.730338 0.960300 1.432445 -0.035678 0.320236 1.176509 1.506111 0.698570 1.441872 1.863132 0.889382 -0.418811 1.799124 1.877754 1.043452 0.538272 0.838463 1.159106 0.931993 0.157215 0.764363 0.063011 1.088653 1.493792 1.493539 1.688525 0.855055)
      )

;;; 113 even --------------------------------------------------------------------------------
#(113 15.33184168793 #(0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.840950350147 #(0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.699631659332 #(0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      12.776963 #(0.000000 0.144921 1.561205 0.676320 1.181102 0.704348 0.511862 1.599077 -0.202476 1.119437 1.638282 1.428152 1.002471 1.657285 1.314684 1.783967 0.353410 -0.017131 0.983021 0.732943 0.019783 -0.116011 0.521112 1.772205 1.255345 1.478112 0.443331 0.848766 1.557346 0.240757 0.367223 0.708948 0.596401 1.046314 1.409987 0.746579 0.271064 1.714960 1.382022 1.030703 0.216190 -0.076530 -0.111344 0.860675 0.386736 0.532895 0.451278 0.627761 1.233648 0.019465 1.831831 0.505988 1.747227 0.175513 0.449029 1.405769 1.668457 1.416702 1.341756 0.059844 0.107319 1.564071 0.721627 0.904570 0.098007 1.179248 1.866216 1.395309 0.523065 1.355449 0.511707 0.525611 1.388720 0.096360 1.176396 0.650159 0.653266 0.206594 0.576887 0.145408 0.351491 -0.002384 0.456450 0.660805 0.621857 1.148356 0.414253 0.350720 0.945815 0.106680 1.193207 1.435982 0.089722 0.563084 0.822759 1.250099 0.310291 1.053338 1.774259 1.914313 0.880359 0.734053 1.411179 1.295606 0.254315 0.959122 0.558098 0.012641 1.851239 0.084875 1.828076 1.583186 0.781253)
      )

;;; 114 even --------------------------------------------------------------------------------
#(114 14.84645338611 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.794 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.492 #(0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

      12.978682 #(0.000000 0.131975 0.769954 0.608946 -0.113318 0.769744 0.726968 0.121462 1.520547 1.234432 0.867520 1.941486 0.109225 1.774659 0.589784 -0.008473 1.621972 1.280892 0.257893 0.597058 1.962248 0.319557 0.383620 1.909741 0.102367 0.078636 0.032177 1.034453 0.670535 0.448302 1.251684 1.406994 0.623688 1.536773 1.592248 1.271677 1.463153 1.505307 1.762827 1.353736 1.267740 0.649390 0.600846 1.443145 1.765013 0.074135 1.845580 0.792960 0.941740 0.704920 1.049278 0.983518 0.368560 1.749326 0.857040 0.110315 1.038800 0.251504 -0.208810 0.106186 0.451726 1.464740 0.637459 1.199563 0.159869 1.412223 0.317110 0.885114 1.106583 0.260619 0.362874 1.097398 0.949586 0.973351 1.768745 -0.046061 0.279342 0.494383 0.161687 0.385813 1.746246 1.010912 0.963056 1.413638 0.388957 0.789902 0.732289 1.231747 0.573665 0.679366 1.322494 0.197171 1.157059 0.347734 0.862348 0.970978 1.180287 0.296588 1.115067 1.100244 1.185630 0.844822 0.202126 0.375495 1.722757 0.606029 1.394111 0.694675 1.662865 0.786123 1.750859 1.271864 1.182864 0.010113)
      )

;;; 115 even --------------------------------------------------------------------------------
#(115 14.597 #(0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)
      14.568 #(0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

      13.045143 #(0.000000 0.818112 0.963082 0.560386 0.964859 0.595628 0.448476 1.135055 0.709886 0.931602 0.540315 0.125722 1.765607 0.143139 1.592983 0.375635 0.497981 -0.157655 1.803324 1.813461 1.504293 1.801038 1.029827 0.910699 0.614824 0.150969 0.927747 1.299476 0.627597 -0.152048 1.321040 1.269926 0.793374 1.509081 0.451354 0.746597 1.474625 0.479921 1.147684 0.711199 1.446423 0.366788 0.055522 0.883638 0.358049 1.449376 -0.266474 1.618692 0.639073 1.489698 -0.119052 -0.024228 0.601696 1.295293 0.020074 -0.067282 0.499357 1.492906 0.372681 1.013093 0.746426 1.174724 0.708987 0.822775 0.536415 0.141724 1.515428 1.352475 0.422367 0.687934 1.457680 0.316912 0.393102 1.309378 0.348308 1.932361 1.309293 0.782701 0.767502 -0.243424 0.886224 0.882686 1.847445 0.480372 1.175548 1.812339 1.337495 0.023046 1.829139 1.822020 0.072280 0.841809 0.895801 1.806166 -0.063353 0.217613 0.378103 1.589077 0.924147 1.833081 1.836190 -0.139499 -0.124712 1.062184 0.303995 0.267167 0.400549 0.440225 1.092070 1.002366 1.901586 1.456000 -0.177250 0.048003 1.044548)
      )

;;; 116 even --------------------------------------------------------------------------------
#(116 15.190026349904 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)
      15.016979484255 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

      13.073015 #(0.000000 1.539931 1.546118 0.068018 0.631846 1.519892 1.369364 1.904117 0.378186 1.767460 0.467990 0.629306 1.773192 1.195646 0.340549 1.557411 1.294491 0.497496 0.976454 1.630010 1.238236 1.834868 1.083935 -0.143259 0.035664 1.499716 1.572094 1.169578 -0.035130 1.975756 0.968883 1.997266 1.048206 0.737713 1.026899 1.536443 1.895489 0.298817 1.208198 1.123246 0.796807 0.480289 0.846816 -0.076603 0.623143 0.276497 1.373886 1.104129 1.233668 1.668012 0.650267 0.313185 1.412331 0.175362 -0.066131 0.096026 0.232168 0.738520 1.672487 0.781233 1.047197 1.365895 0.699290 1.800821 1.819052 1.598055 -0.100015 0.358545 0.530644 0.073287 0.976247 1.260310 0.290731 -0.227740 0.587142 0.891617 0.141894 -0.087822 1.428322 1.253683 0.448360 1.627315 1.457962 0.363838 1.150530 1.716748 1.575920 1.745866 1.950921 0.360500 0.598248 0.405441 1.718264 0.152576 1.590572 0.581345 -0.054270 1.856076 0.372284 0.096004 0.480707 0.046410 1.557142 1.531872 1.309610 0.010768 0.635636 1.528529 0.888128 0.950129 1.074597 0.700114 0.516656 1.237222 0.257042 1.214819)
      )

;;; 117 even --------------------------------------------------------------------------------
#(117 15.56056534994 #(0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0)
      15.070538411179 #(0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)
      14.875072951405 #(0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

      12.993791 #(0.000000 1.857244 0.600672 0.598193 0.603314 1.729749 1.381371 1.479901 0.709634 1.052055 0.469689 0.281811 1.474690 0.737745 1.765800 1.553845 1.401463 1.768462 0.037042 1.321940 0.536671 0.813225 -0.134015 1.484786 0.101734 0.493454 1.194782 0.438475 0.012563 0.639677 0.050503 1.066931 1.576429 1.370970 0.589733 0.707160 0.186321 0.936164 0.775032 0.460623 0.618548 1.903774 0.799839 1.204170 1.624415 1.356474 1.457074 -0.148180 1.491198 0.604121 0.427117 0.678460 0.029201 1.639051 1.731917 -0.021241 0.030310 0.174122 0.682372 0.090774 1.028408 0.202816 0.110174 0.744012 1.445233 1.803283 1.253174 0.291830 1.027631 0.549313 0.187057 0.343626 -0.062496 0.107146 1.826985 0.308080 0.038680 0.173066 1.059485 0.281844 1.900757 1.321515 0.138323 1.399864 0.832251 1.822001 0.652684 1.346458 1.457344 1.002144 1.535180 0.609113 0.549323 0.796362 0.863988 1.037182 1.324229 0.306490 0.481211 1.299097 1.743940 0.232008 0.401297 0.908410 0.019134 0.572614 0.977276 0.758947 0.081057 1.617380 1.375475 0.795251 1.035003 0.260127 1.132033 1.821226 0.420800)
      )

;;; 118 even --------------------------------------------------------------------------------
#(118 15.425480892646 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1)
      14.841081077183 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1)
      14.774983755641 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

      13.175323 #(0.000000 1.417710 1.551406 0.153828 0.489738 0.986851 0.189614 0.068644 0.203993 1.498119 1.915883 1.523456 0.490531 0.583030 0.831442 0.885118 1.917420 1.184515 1.196049 0.074148 0.971814 0.422403 0.576325 0.371815 1.491724 0.064755 0.793689 0.077907 0.106063 0.191560 1.227365 0.123790 -0.185798 0.859784 0.362861 -0.083959 0.913236 0.767370 1.975676 1.475368 0.105422 0.985731 1.277851 0.818089 0.487357 0.091466 0.066756 1.454835 1.562748 -0.052411 0.589134 1.571185 -0.161613 -0.003722 1.266131 1.510305 1.165113 1.133254 1.292617 1.369676 0.221186 0.637838 1.707091 0.781528 0.885589 1.663037 1.529435 0.779831 1.649686 0.688617 1.537202 1.299553 0.937644 1.631404 0.106354 0.158038 1.646459 0.769968 1.916306 0.237123 1.390210 0.605679 1.648120 1.185688 1.238740 0.559314 1.645546 1.179755 1.364604 1.449046 0.053781 1.701461 0.695697 0.815918 0.460833 0.643876 1.418931 0.627864 1.151357 0.045708 -0.030109 1.706765 1.389628 1.562059 0.013861 0.250204 0.620883 0.697898 1.822762 -0.001605 -0.105874 0.096508 0.392443 -0.117540 0.305893 1.522837 0.914891 0.743187)
      )

;;; 119 even --------------------------------------------------------------------------------
#(119 15.519069915733 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
      14.971 #(0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

      13.307452 #(0.000000 1.496424 1.499603 0.909790 0.451124 0.725265 -0.005345 0.017335 0.081963 0.966319 1.468038 1.312226 1.862333 0.897724 -0.025157 -0.020996 -0.151927 0.325859 0.839538 -0.014343 1.128904 1.364737 1.700222 0.787568 0.621036 1.833049 0.718036 0.793822 0.265045 1.685735 0.993711 0.504788 1.225077 0.318081 0.016549 -0.126707 0.048819 0.566368 0.500697 1.380436 1.668009 0.026720 0.482077 0.398216 1.071911 1.611752 0.960632 1.140316 0.381885 0.593955 1.034285 1.094512 1.888312 1.380843 0.616366 1.548761 0.297643 1.040220 0.279415 -0.060585 -0.032805 1.092185 0.528741 1.063360 0.912704 0.549398 0.800125 1.275543 1.730212 0.973065 0.474356 0.426116 0.571927 1.353335 0.414578 1.633241 1.549171 -0.072403 0.219803 1.435148 0.346574 0.819946 1.036487 0.709586 1.891908 0.312552 0.917182 0.470097 0.179462 1.494354 0.254943 0.252985 0.376386 0.176375 1.076249 0.845192 0.569153 1.252603 0.824939 0.759995 1.851115 0.230140 1.551064 1.366581 1.380766 1.810585 1.151268 0.099809 1.655248 0.991012 1.091287 1.244964 0.473818 0.800121 1.591368 1.514304 1.710628 1.278705 0.349884)
      )

;;; 120 even --------------------------------------------------------------------------------
#(120 15.824793168635 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.350 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.153992567168 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

      13.124158 #(0.000000 0.547953 0.046683 1.223808 0.287087 -0.275093 0.168020 1.119600 0.913398 0.673233 0.317519 1.677375 0.155002 1.827251 1.328636 1.289517 0.825556 1.170002 1.118040 0.315906 1.921854 0.628112 0.340287 0.647367 0.782948 0.542971 1.109080 0.220169 0.246461 1.886641 1.257076 1.318011 -0.232385 0.012095 -0.081932 0.196776 1.615833 1.390286 1.464601 0.092305 0.586606 0.639259 0.449609 1.071232 0.863690 -0.003934 1.256400 1.265688 -0.237284 1.414773 -0.038640 1.610934 0.361979 0.854476 1.304803 0.161381 0.788161 0.959907 0.834637 -0.098392 1.543953 0.106258 0.296301 1.199521 0.182585 0.288718 0.056573 1.642208 1.040521 0.125013 1.596063 0.315585 1.416039 1.726354 0.476434 0.270144 0.392591 0.593221 1.947982 0.393511 1.077068 1.424545 1.017453 0.393890 1.280350 0.741421 0.760590 0.356389 1.046316 0.858776 0.683258 1.395090 1.871044 0.515412 0.785729 1.133116 0.771994 1.263638 0.628176 1.697075 0.195336 0.574758 1.134866 0.332290 0.639021 0.107243 1.636674 1.717494 1.148656 0.257161 0.716444 -0.068908 0.948318 0.630187 0.802813 1.095008 0.455545 0.009691 0.332455 0.996102)
      )

;;; 121 even --------------------------------------------------------------------------------
#(121 15.507 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      15.168510014453 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      14.652157793709 #(0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

      13.103152 #(0.000000 0.029736 1.741460 1.209924 0.853299 0.187340 1.000862 1.677247 0.756789 0.797190 0.371416 1.294182 0.896462 0.403396 1.996483 0.977173 1.219024 0.395887 0.895145 1.431085 0.325100 1.105736 1.429317 0.920732 0.930927 1.553815 0.602614 1.279600 1.544790 0.907478 1.167325 1.994833 0.472678 1.040885 0.771181 1.155147 0.134932 0.872221 1.845922 0.371256 1.967838 1.662082 1.185358 1.981547 1.783586 0.528525 1.942336 1.921715 1.586317 1.521927 0.825483 0.103576 0.485372 0.391082 0.587483 0.101771 0.932761 1.880563 1.536603 1.973973 1.373997 0.978788 1.086150 0.956165 1.891444 1.102826 1.351603 1.937551 1.508084 1.056609 0.280021 0.338827 0.460887 1.624541 0.351687 1.089700 1.294475 1.424574 0.421347 1.615706 1.076660 1.876917 1.371922 1.238960 1.234059 1.389485 1.373193 1.982381 0.549083 1.476057 0.655216 1.745803 0.921346 0.980054 1.884876 1.390068 1.652340 1.654284 0.613291 0.431961 0.714080 0.260461 1.547477 0.468591 0.113203 0.941233 1.457943 1.575422 0.890004 0.997056 1.198915 1.721240 0.059618 0.014224 1.127630 0.633323 1.519531 1.514925 1.391740 1.921804 1.267315)
      )

;;; 122 even --------------------------------------------------------------------------------
#(122 16.162 #(0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.305 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.057187309653 #(0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      13.452919 #(0.000000 0.289408 0.605170 0.312253 0.027275 1.054736 0.421411 -0.111818 1.102083 0.042961 0.233263 1.347722 0.877522 0.170643 1.788993 1.253348 1.686868 0.603984 1.771509 1.022156 1.545908 0.575735 0.722954 0.851797 -0.011977 0.208426 1.468928 0.771409 0.536023 1.176112 0.398312 0.776671 1.285031 0.682709 0.054546 1.354019 1.804755 -0.042278 0.404458 0.730075 1.225156 1.264985 1.315948 0.409637 0.444562 0.179620 0.790162 1.879834 1.559112 1.454717 0.441886 0.335698 1.028403 1.397169 0.144249 0.591925 0.332993 1.640973 0.579611 0.402800 1.205674 1.214354 0.678981 -0.021289 -0.119261 1.819404 0.671380 0.663993 0.273752 0.276981 1.141117 0.161764 0.340782 1.802451 1.017709 -0.315475 0.580488 0.016302 1.143367 0.196741 1.336589 0.344578 0.537901 1.128036 0.921223 1.361566 0.214141 1.574000 1.666745 1.258249 1.449843 0.656873 1.257668 1.230650 0.435490 1.694108 0.182875 0.611440 0.925675 -0.004600 0.397361 1.679190 1.284995 1.192360 -0.398376 0.138794 1.671426 1.535985 1.560782 1.179257 0.928031 -0.033935 0.176794 0.451560 0.273917 1.841382 0.515561 1.528822 0.372913 0.639368 0.992686 0.144845)
      )

;;; 123 even --------------------------------------------------------------------------------
#(123 15.443287674437 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.448 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.332496766406 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.156582832336 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

      13.569543 #(0.000000 0.018661 1.806656 0.620205 1.670760 0.987131 0.867463 -0.052138 1.566954 1.697642 0.310280 0.973212 0.897203 1.327427 -0.047421 1.016788 1.272445 0.927523 0.410758 1.076157 1.124221 1.682171 1.559533 0.573212 1.718873 0.545170 0.480505 0.892112 0.159181 1.578708 0.802237 1.629756 0.683727 0.038451 1.674790 1.715026 1.234636 1.317475 1.030931 1.410619 1.460340 0.675234 0.974604 1.015956 1.351739 1.858861 -0.045167 1.328491 0.450364 0.758366 0.611662 0.468439 0.264889 0.156844 0.785644 0.172019 0.921909 -0.072127 0.086601 0.782781 0.304007 0.991987 0.899040 0.373769 0.920655 0.615632 0.777844 1.557293 0.546245 0.155758 1.645931 1.021596 0.575255 0.434563 0.196965 1.186024 0.407550 0.969406 0.309011 1.901112 0.291414 1.177653 0.265280 1.549842 0.836372 1.053241 1.985014 0.283569 1.267125 1.569428 0.516726 1.471020 0.137246 0.559191 0.335900 -0.076704 0.818358 0.868227 -0.001532 1.496465 1.398800 0.998983 1.561768 1.161876 0.789513 0.744871 0.803860 0.131167 0.394405 0.562512 1.578284 0.959831 0.402533 0.680772 0.858222 0.791811 1.382551 1.643272 1.209728 1.112779 0.847445 1.645563 0.341156)
      )

;;; 124 even --------------------------------------------------------------------------------
#(124 15.877207326383 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
      15.399996153183 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)
      15.192802705519 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

      13.052667 #(0.000000 0.568970 1.174257 0.030011 1.058475 0.400853 1.303902 1.768040 1.954473 1.665828 1.480449 1.160668 0.589133 1.276583 0.026583 1.502644 0.855382 0.549420 1.310436 1.886825 1.021847 1.925505 0.394017 1.596740 0.559164 0.202076 0.743149 0.141579 0.796809 1.157955 0.621022 1.254258 1.963247 0.121857 0.048423 0.889235 0.393933 1.360689 0.914747 1.891466 0.949691 0.822213 1.076430 0.741669 0.645162 0.767649 0.660809 1.370809 1.216244 1.466256 0.980516 1.562337 0.268679 1.730598 0.542085 0.066689 0.221108 1.892214 0.935388 1.827769 1.837197 0.369687 0.282515 0.741419 0.119411 1.878628 1.614114 1.902688 0.516186 1.048144 1.408165 1.891341 0.595838 0.048603 0.032105 0.050291 0.483088 0.443350 1.785371 1.658696 -0.003724 1.701823 1.346748 0.478567 1.331838 1.159122 0.473767 0.350504 1.945255 0.895037 0.730572 0.745607 0.099733 0.613479 1.390948 1.463568 0.814376 0.385404 0.335778 1.887557 0.752747 1.844646 1.416863 0.899104 0.019464 0.450661 1.011929 0.789114 0.168302 0.108058 0.049255 1.345997 0.638850 0.348139 0.161927 0.782327 0.324940 1.125169 1.587089 0.224277 0.901694 1.376665 0.387232 0.784496)
      )

;;; 125 even --------------------------------------------------------------------------------
#(125 15.872031899268 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.743360519409 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.340427254326 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

      13.475117 #(0.000000 1.548491 1.151018 0.804055 1.288848 0.745562 0.119600 1.816640 0.489444 0.797927 -0.009889 0.603724 1.228261 0.224209 1.700944 0.558029 0.401926 0.678870 1.672569 0.206204 1.639950 0.207313 1.090655 1.731445 1.061924 1.204303 1.283384 0.596323 0.755197 0.840430 1.695795 1.068996 0.112442 0.629411 1.082678 0.178862 1.407494 1.596376 0.661679 1.646026 0.679033 0.910146 1.385029 1.645495 1.558900 0.402989 1.507360 0.715613 0.653396 1.185464 0.459365 1.081595 1.310356 0.134590 1.753770 1.160861 1.616366 0.292710 0.690644 1.567784 1.516765 0.815440 0.559268 1.472195 1.816365 0.438005 0.926342 1.080767 0.176681 1.263601 1.558824 0.269544 1.531077 0.799051 1.559178 1.198673 1.527753 1.046000 1.031478 1.381426 0.384881 1.162175 0.461678 1.754249 1.331102 1.470367 0.720340 1.211468 1.102450 0.834035 0.094053 0.215219 0.273972 0.510535 1.077240 1.269369 0.522016 1.924982 1.803219 0.279774 1.930560 0.125255 0.083727 0.861845 0.832709 0.150597 0.885757 0.351995 1.000263 0.775299 1.647657 1.798792 1.363952 1.321611 1.695013 1.205781 0.585519 0.121724 1.596687 1.484212 0.956521 0.440848 0.313981 0.032275 0.197878)
      )

;;; 126 even --------------------------------------------------------------------------------
#(126 15.964 #(0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.680 #(0 1 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.28212621738 #(0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

      13.522083 #(0.000000 1.322470 0.683491 0.754777 0.991259 -0.122058 1.218326 0.490886 1.265175 -0.191956 1.705575 1.574470 0.115109 1.066110 1.440966 1.826253 1.011295 1.713833 0.257654 0.677908 1.083608 0.483300 1.147819 0.195552 1.732532 1.465772 0.953129 1.027878 0.897881 1.781518 0.392978 0.567709 0.176865 0.573967 0.076034 -0.028967 1.231376 1.416341 1.368774 -0.074748 1.670955 1.928101 1.019811 0.663581 1.601522 0.136645 0.732235 0.973492 0.636007 0.821336 1.108393 0.208576 0.548469 1.697703 0.759181 1.735090 1.408515 0.453528 0.686387 0.554923 0.572268 0.642397 0.903986 1.321089 0.057811 -0.143926 1.072661 0.642649 0.269445 1.065556 0.196909 1.232191 0.557845 1.468212 0.973973 0.361673 0.135892 0.586797 0.555639 1.295742 0.619596 0.638161 1.638237 0.921394 0.969759 0.325328 1.573314 0.537578 1.374682 1.436892 0.836052 0.329568 0.210608 1.373798 0.288709 -0.094527 1.593534 0.257928 0.774082 -0.004230 1.706491 0.009223 0.985249 1.778229 -0.281221 0.865751 0.612054 0.201682 0.015410 0.419232 1.402833 1.368093 1.140702 0.201744 -0.034377 0.892889 1.153071 0.650530 0.900940 0.928177 1.053617 1.665260 1.217975 1.212493 0.947890 1.003744)
      )

;;; 127 even --------------------------------------------------------------------------------
#(127 15.857031822205 #(0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.609939955803 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.237931718393 #(0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      13.738306 #(0.000000 0.628176 0.618579 0.424274 1.761293 1.576801 0.228919 1.027812 1.283100 1.573422 0.345209 -0.040843 0.921738 0.396407 -0.150421 0.995923 1.300164 -0.008006 0.415799 0.918858 0.272038 1.194042 1.875993 1.744829 0.756663 -0.005747 1.450105 0.087543 0.340255 1.145741 0.962289 1.461563 0.038054 0.558610 1.628871 1.444924 1.428871 1.163782 0.555547 0.830895 1.422609 1.243079 1.318786 1.075038 0.603913 0.493864 -0.242322 1.739580 0.046822 1.840055 1.207298 0.992546 0.923677 1.077533 1.383213 0.662536 1.672621 1.181372 -0.316993 0.691006 0.007940 0.862247 1.202226 -0.034956 0.615117 1.465983 1.354442 0.775927 0.563202 0.990400 0.710320 1.890670 0.146249 -0.070016 1.740742 -0.013705 1.133273 1.887844 1.639096 0.017785 1.004679 0.248216 -0.140885 0.749671 0.494719 1.153640 0.108170 0.558383 1.017766 0.512604 1.385405 0.536638 0.350475 0.474748 0.462574 1.289351 1.213049 0.795691 1.230539 1.559109 1.678387 0.475836 0.078689 0.332253 0.738064 1.283808 0.663609 1.855759 0.120527 1.678617 0.585861 0.983336 1.950663 1.490878 1.363046 1.592579 0.237127 0.975767 -0.096561 0.590219 0.126815 0.738587 0.402133 0.317176 0.848711 0.643449 0.255835)
      )

;;; 128 even --------------------------------------------------------------------------------
#(128 16.159544533014 #(0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0)
      15.889096531102 #(0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0)
      15.651492555885 #(0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      13.621503 #(0.000000 1.388735 1.565658 1.415623 1.598145 1.952085 0.662120 1.268851 1.347401 1.732810 1.400077 1.401126 0.338529 1.249706 0.843747 1.731886 1.825451 1.635073 0.133301 0.219202 1.092559 0.282923 1.915514 1.056384 1.743658 1.122531 1.990888 1.809783 0.654452 0.004784 0.696855 1.026404 0.920400 1.494009 0.292286 0.417230 1.391870 1.738228 0.604440 0.554970 0.675461 0.688982 0.615045 0.971590 1.829409 0.929745 1.794269 1.346018 1.906627 0.569656 0.224062 1.187664 1.926770 1.967457 1.838363 0.758896 0.968700 0.637966 0.674862 0.095204 0.045387 1.118725 0.411212 1.276274 0.239589 1.192936 0.234256 0.053543 1.798851 1.040359 1.083316 0.588986 0.255407 1.150223 0.760846 1.860319 1.415595 0.258565 1.776794 1.580588 0.483365 1.903378 0.457665 1.968255 1.893609 1.389158 0.863873 0.300860 1.933388 1.367877 1.159834 0.508996 0.081444 0.298712 1.832025 1.515144 1.999658 1.384057 0.736750 1.662196 0.185331 1.256558 0.028349 0.630271 1.362875 0.022547 0.792109 1.098648 0.970491 0.835036 0.587393 0.391414 1.032059 0.368578 0.410331 1.509224 1.534201 0.205313 1.510131 0.107032 1.009997 1.132961 1.934430 1.935820 0.631985 1.810874 0.141926 0.345881)
      )

;;; 256 even --------------------------------------------------------------------------------
#(256 24.437111537992 #(0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

      21.673156 #(0.000000 0.015817 0.952196 0.230828 0.680323 1.421185 1.868775 0.826167 -0.056786 1.245060 1.755665 0.547109 0.470472 1.377724 -0.114534 0.420766 0.106493 0.428104 -0.008767 1.590842 1.414661 0.260649 0.699430 0.825568 0.729805 0.011252 0.745854 0.507499 -0.110088 0.030446 1.476169 0.682498 0.856399 0.081407 -0.117033 1.032013 0.583497 1.489397 0.373681 1.478732 1.274675 0.712834 -0.220141 1.059818 0.313111 1.670566 1.354192 0.154773 0.893873 -0.002217 1.356660 1.629084 -0.190890 1.291517 0.436193 0.313929 1.662405 0.791895 0.671823 1.200079 1.005618 0.942289 0.267355 0.578423 0.011807 0.189509 0.450132 0.116706 0.245147 1.117576 -0.085007 0.916230 0.281874 1.518758 -0.061734 1.302223 0.952999 0.216153 1.895744 0.403130 1.914634 1.146337 -0.000515 0.380060 0.172348 0.985877 0.874773 1.218010 1.408207 1.516156 0.442619 1.611479 1.398900 1.162670 0.337437 -0.078803 1.387853 1.064446 1.096354 0.682532 0.366955 -0.077272 1.574684 1.470052 0.740962 1.088702 0.878685 0.708488 0.721778 0.623992 1.180215 1.170139 0.260325 0.765303 0.285710 1.196341 1.930238 1.669884 1.878672 0.020138 0.325799 1.174507 1.087348 0.929457 1.181804 1.332768 1.502330 1.193560 1.814196 0.287824 1.618060 0.646619 1.452791 0.007830 1.585521 0.235189 0.300203 0.981327 1.633083 0.213189 1.161171 1.238161 1.373607 0.680257 1.957645 -0.079382 0.777706 1.865361 0.640380 0.966726 0.387067 0.924185 0.152860 0.617450 0.476247 0.328002 1.303003 0.686084 1.384398 1.108014 0.359950 0.248768 0.616304 0.700760 1.971914 0.607386 0.611436 0.912557 0.958871 0.736334 0.655215 0.305907 0.878048 1.566395 1.549227 0.271069 0.349038 0.219710 1.447036 1.091621 0.300122 1.428878 1.298413 0.370801 0.700845 1.410190 -0.085764 0.578756 1.360288 1.499854 0.903008 1.058866 1.655774 0.273680 1.650769 0.145302 0.327765 1.207384 0.480558 1.516528 0.019899 1.252336 -0.274303 1.660678 0.449417 0.888544 0.203782 0.446492 0.718147 1.650580 1.186442 0.357614 0.983492 1.489148 1.750137 1.719325 1.266057 0.928023 0.208843 1.273584 -0.060864 1.452481 1.351947 1.730519 0.237000 0.545824 1.454447 0.612746 0.175901 0.534550 0.381886 0.984140 0.341307 0.077367 -0.276388 1.285115 1.390326 1.674197 0.387948 1.082976 0.868096 1.802324 0.275019 1.328837 1.934294 -0.187544 0.113547 1.433571 1.333613 1.849051 0.681097 0.252360 -0.207267 0.405898 0.301042 0.529285)
      )

;;; 512 even --------------------------------------------------------------------------------
#(512 35.776 #(0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      32.512123 #(0.000000 0.211782 0.866260 1.700198 0.453991 0.014753 0.106280 1.296644 1.574948 0.714250 0.769213 0.245881 0.549126 0.904130 0.314153 1.454814 0.910893 1.373673 1.792272 0.554890 0.209341 0.658725 0.608835 1.034924 0.533335 0.246071 1.406433 0.589790 0.795890 1.366097 0.493842 1.753401 0.020173 1.800386 1.144047 1.639086 0.714934 1.669833 0.186893 1.213601 1.392125 1.815180 0.206833 0.481774 -0.058161 0.965742 0.947083 0.890392 1.906279 1.297929 -0.088873 0.669320 0.074624 -0.071580 0.556448 0.406765 1.198934 1.516094 0.877460 1.399263 1.578275 0.852163 1.013902 1.605034 1.507677 0.932332 0.196725 0.370279 1.206527 1.374718 0.741825 1.750265 1.003967 1.290124 1.743594 1.090817 0.614767 1.787879 1.233533 0.130079 0.834465 1.197392 0.094668 0.843674 0.695885 1.433856 0.156489 0.458659 0.884883 1.592180 1.093067 1.849010 1.185812 0.123093 1.113335 1.935699 -0.083549 1.574227 0.300194 0.059746 1.515980 1.278936 1.359358 1.456672 1.566344 0.033080 1.864330 1.634893 1.522988 1.648984 0.045782 1.717554 0.108817 1.253262 0.697207 1.375459 1.277238 0.386082 1.185766 0.152010 1.285766 1.570609 0.311639 1.564131 0.463266 0.882448 0.505868 0.843292 1.878156 1.158260 1.566868 1.941600 0.053436 1.596808 0.564366 0.299555 1.916618 1.814449 0.347998 0.017388 1.646228 1.624761 1.692579 0.281561 0.979036 1.440081 1.488760 0.897390 0.313542 0.382367 1.655746 1.309158 1.142521 1.008750 0.276285 1.159685 0.631953 1.550753 1.609921 0.196908 0.896080 -0.020231 0.425217 1.474422 0.930098 0.091472 0.750996 0.701589 0.961629 0.668155 1.309930 1.036714 0.453760 0.872533 0.916448 0.991650 1.202119 1.514052 0.812807 0.938948 0.621551 0.260965 1.253044 1.031536 -0.042384 0.849294 0.012533 0.944763 1.066157 -0.009607 1.862096 1.098755 0.239133 1.308048 1.233220 0.329968 0.668281 1.083705 1.337131 1.492671 0.222047 -0.066905 0.024203 1.520856 0.240298 0.688591 1.149896 0.426638 1.089820 1.814182 0.429260 0.792755 0.153661 0.790121 0.886817 0.572332 0.765717 0.845769 0.743697 1.502052 1.247512 0.606363 1.805391 1.825084 -0.018818 0.538741 1.078331 1.085885 1.021733 0.249748 1.354300 0.354917 0.921756 1.146276 1.136034 0.004274 0.182291 0.420455 1.113097 0.142361 0.883827 1.244553 0.270522 0.297732 0.663326 0.117069 1.038253 1.182441 0.753783 0.598449 0.476248 0.621579 1.776199 1.715812 0.003005 1.822011 0.507441 0.082483 0.745061 1.156135 1.393014 0.391073 1.022490 1.587865 1.872053 0.970707 -0.057450 1.934941 0.721459 1.462383 1.725909 1.893592 1.345514 0.197426 0.465041 0.810717 1.221288 -0.053216 1.007052 1.044767 0.911022 1.574023 1.732175 1.306462 0.542821 -0.220348 0.800852 0.261800 0.400366 1.566150 0.991659 0.496914 1.316835 0.559835 1.712947 1.520133 0.862746 1.010876 1.035591 1.200157 1.681774 1.210229 1.089999 1.437105 0.204136 1.591157 0.416288 1.584732 1.009884 1.297450 -0.111916 1.178459 0.880841 0.948170 0.053559 0.898931 0.221259 0.249868 1.705123 0.127844 0.100716 0.390264 0.325976 0.881204 0.237593 0.953874 0.527109 0.612929 0.327279 -1.950573 0.758873 1.335377 1.132238 0.679149 0.619264 1.392153 1.880738 1.311800 1.116211 1.484074 0.578029 0.135580 0.709755 0.874511 0.093381 1.376200 0.069985 0.357296 1.448276 1.273466 0.866131 -0.075377 0.945015 1.109156 1.654528 -0.056100 0.056973 0.203012 0.882269 1.474850 0.356522 1.281964 1.028050 1.584914 0.026415 0.316954 1.584410 1.173261 1.728309 1.396005 1.473569 0.851921 0.291071 1.663656 1.754893 0.933115 1.751630 0.939956 0.174872 1.434753 1.961837 0.732724 0.414019 1.170636 1.572415 0.571395 1.025743 0.342853 -0.167801 0.063591 0.409294 0.847933 0.461358 1.568815 0.744299 0.458491 1.494409 1.219862 -1.872566 -0.075310 1.145974 0.047122 1.023590 1.041911 0.408934 0.318739 0.666270 0.447095 1.534805 1.489234 0.390453 1.611656 0.937849 0.728349 0.198856 1.330660 1.909526 0.295199 1.003136 1.541366 0.084910 0.059739 1.640361 -0.005926 1.239698 1.572506 0.268634 1.171788 1.345623 1.171979 1.095808 0.445817 0.752268 0.724671 0.337991 1.778454 0.039223 1.414053 0.628437 0.034229 0.837630 0.740790 1.373040 0.299573 -1.934752 1.840487 1.710459 1.775163 1.660747 0.836340 1.593233 0.002409 0.094011 1.220821 0.678649 0.230744 0.081147 1.603206 1.403892 0.381972 0.131038 0.945849 0.021808 0.600709 0.584897 1.114359 -0.062493 0.536808 1.188972 0.289812 1.327304 1.762768 1.373557 1.555849 1.345541 0.056752 0.217273 0.808136 0.548422 -1.937746 0.489656 0.751406 1.696301 0.506109 1.509694 0.428410 0.397529 0.531779 1.503252 0.723021 1.065292 0.042128 1.329621 1.707989 1.225822 1.631856 1.633454 1.652930 1.597213 0.967452 0.673417 0.215258 1.697674 0.712306 1.113540 1.491755 0.399395 1.433136 0.200495 1.294483 1.858153 1.435534)
      )

;;; 1024 even --------------------------------------------------------------------------------
#(1024 51.895 #(0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)
       )

;;; 2048 even --------------------------------------------------------------------------------
#(2048 87.300233499882 #(0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       81.821476 #(0.000000 1.054494 -0.027439 0.346842 0.661170 1.133415 1.069592 1.563138 0.111303 1.325434 0.040238 -0.075138 0.800637 1.782396 0.476865 0.172496 1.374132 0.119844 1.661343 1.015211 0.354777 1.375191 0.185409 0.946157 1.731483 1.659185 1.801695 0.461325 0.224022 1.759338 1.839777 0.602448 1.277924 1.734303 0.144138 1.895222 0.279797 -0.062002 1.483072 0.189157 1.196315 0.129921 0.971922 1.741638 0.264504 0.435861 1.453052 1.240929 1.268146 0.502037 0.745095 1.587083 1.061705 1.739963 0.410284 0.816896 1.121251 1.911008 0.234039 0.075113 1.698978 0.777554 0.131273 0.717741 1.104678 1.477885 1.846638 1.657721 0.825962 1.337420 1.334526 1.058671 0.214958 1.729283 1.679406 1.709695 -0.063129 1.860505 0.092255 1.196561 1.791623 0.534178 0.011833 0.970633 0.204779 0.371902 0.314375 1.437766 1.304221 1.953821 1.508309 0.926378 1.885620 0.755020 0.528645 0.903984 0.259848 1.170772 1.797611 1.061031 1.714432 1.833932 1.805157 0.640566 0.401516 0.267664 0.563877 0.560503 1.433559 0.916887 1.842587 0.976090 0.194763 1.500586 0.403047 0.103553 0.700045 1.936469 1.855438 0.539509 1.613342 -0.114540 1.418468 0.842475 1.421507 1.382850 0.342480 0.721503 1.397777 0.442090 0.224220 0.169902 0.646223 0.449991 -0.061078 0.931973 1.758359 0.361760 0.208770 1.298954 0.092755 1.357324 1.249038 1.650848 0.255277 0.329432 1.506719 0.960734 0.199577 0.212236 0.305721 0.572984 1.563693 1.055743 1.378907 1.311320 0.240255 0.861016 1.214778 1.603346 1.321991 0.819800 0.216147 1.833974 1.547528 0.122200 0.684674 0.169827 0.673251 0.974300 0.713659 0.082191 1.788842 0.041146 0.240746 0.429316 0.258893 0.716448 1.764756 0.422672 0.908412 1.663987 1.555829 1.650692 0.804732 0.194077 1.568213 0.000729 1.285570 0.693552 1.962242 1.189546 0.333042 0.543562 1.416532 1.063945 0.291095 1.736553 1.628085 1.708776 0.573042 1.743168 0.278192 1.161824 0.076547 1.143654 0.828791 0.716845 0.046639 1.178121 1.693161 0.879702 1.603002 0.664279 0.832661 -0.006659 -0.090385 1.552641 1.911312 0.105700 0.561789 0.253754 0.419189 1.297914 1.285846 0.328682 1.576025 0.270557 0.844141 0.516789 1.514224 1.496705 1.262537 -0.087919 1.667063 1.061551 0.015419 1.116482 0.596012 1.104737 1.833117 0.805074 0.291714 1.242743 1.372205 0.685589 0.910475 1.135619 1.256499 0.986379 1.705094 0.349765 1.337360 0.030509 1.720413 1.423944 1.470994 0.578186 1.497346 1.401230 1.624437 0.502511 0.886901 -0.103347 0.745114 1.219022 0.913568 1.795008 1.345661 0.398205 0.167347 0.725869 0.290010 0.726393 -0.043647 1.650834 0.279711 0.303189 0.049367 1.671423 0.568307 1.232991 1.474113 0.529459 1.735629 0.566021 0.972279 0.320067 1.268197 0.882813 1.880451 1.607027 1.131381 1.123626 1.534162 0.129801 1.220852 1.620183 0.404553 1.787302 1.163579 1.188488 0.921049 0.218073 1.714358 0.603089 1.779009 0.585841 -0.149328 0.296725 1.858791 0.450904 1.036970 1.302940 1.268655 0.419994 0.185192 0.380876 0.158844 0.318063 1.164699 1.419895 1.210515 1.225111 0.632705 1.779657 0.493692 1.837987 1.163681 0.133458 0.538772 0.818423 1.431042 -0.000775 -0.001813 0.911182 1.022956 -0.080688 0.151975 0.085520 1.817086 0.701336 0.906707 0.294152 1.273180 0.373481 0.197559 1.001145 1.148662 1.248775 0.530878 1.583527 0.438632 0.688063 1.503274 0.100070 1.731362 1.374457 1.181468 1.255550 0.281696 0.401411 0.212174 1.570027 1.773034 -0.225645 0.653521 0.472548 1.680667 0.558829 0.166062 1.578921 1.442715 1.857551 1.018365 0.278616 1.832954 0.430303 1.545094 0.392212 0.274173 1.744790 0.773156 0.378196 0.213349 1.116079 0.936793 1.310646 0.782183 0.924508 1.889463 0.814656 1.204756 0.078804 1.560757 1.721874 0.726772 1.679631 1.029140 0.892762 0.234539 0.334660 0.400324 1.744547 1.619200 1.362376 1.715051 0.408584 0.500772 0.123274 1.879029 0.539459 1.571237 1.133824 1.313681 0.840751 1.412997 1.497631 -0.049886 0.355985 0.476523 1.057019 1.343136 0.780021 0.304035 1.384349 1.458441 0.996143 0.311843 1.794338 1.623824 0.007401 0.594295 0.942146 1.720587 0.402450 1.242496 1.276538 0.736797 0.049169 0.869030 0.235459 1.687523 0.484825 0.376134 0.983613 1.331226 0.946422 -0.070235 0.517337 0.910587 1.810216 -0.177710 1.650735 1.542570 0.279370 0.731437 1.098749 1.056929 1.506964 1.522039 1.799688 0.295206 0.342237 0.310041 0.183234 -0.168766 0.054333 1.709048 1.110636 1.059434 1.177649 1.163858 1.662906 1.038326 1.084117 1.009702 1.307988 0.473925 1.296567 1.202546 1.253179 0.433854 1.163432 1.568392 0.112247 0.129464 0.630263 1.511108 1.480881 0.714179 1.211723 0.255239 1.743018 0.850802 1.379380 0.626232 0.619485 0.056113 0.394098 1.767320 1.858084 0.531734 0.318691 0.792690 0.034626 0.775957 1.820231 0.504597 1.089795 1.458885 1.010098 1.006708 0.678773 0.709935 1.246025 0.905997 0.392494 0.685170 1.266381 1.143517 1.444388 -0.032904 1.287611 0.267743 0.134752 0.728544 0.187844 0.517562 0.967478 0.078661 1.751267 1.164138 1.665047 0.911923 1.817820 0.902707 1.350234 1.210278 1.133105 -0.003282 0.110470 1.620150 1.197947 1.450235 1.789124 -0.187130 1.496304 1.104550 1.874378 1.752275 0.010880 0.004668 0.199421 0.010687 1.562957 1.622139 1.386212 1.059023 1.594840 0.830908 0.342055 1.278369 1.041542 1.324390 0.490944 0.413414 0.943292 0.375542 0.410191 0.558180 0.754601 1.433754 0.448779 0.450801 1.882789 1.395886 1.554056 0.917286 1.663676 1.831234 1.385306 0.952537 0.104193 0.241553 1.746219 0.372921 0.376010 0.483912 1.149731 0.304156 0.082027 0.417323 1.832884 0.238509 -0.066507 -0.062683 0.064540 1.171119 0.353229 0.178002 0.217553 1.065409 0.168089 0.884488 0.860076 0.343970 0.426638 0.096932 0.181950 0.049317 0.167584 0.397701 0.510895 0.250565 0.913964 1.193627 1.853936 0.969809 0.983659 1.664573 0.772560 1.279058 -0.023915 0.205228 0.247629 1.188461 0.656959 1.236722 1.725341 0.940115 -0.113209 0.849819 0.249819 1.581041 1.814607 1.362897 1.547528 1.686984 1.815889 1.285237 1.789822 1.132911 0.066447 -0.023167 1.203245 0.674930 0.403607 1.424795 1.455826 1.126019 0.511531 0.918644 0.681264 1.777915 1.658689 1.037654 1.495687 1.930063 1.648452 1.691207 0.644866 1.597940 1.090672 0.802574 1.662024 0.693104 0.262561 0.132147 0.161381 0.902677 0.118139 1.209328 1.181639 0.932247 1.679859 0.969346 1.936446 0.402738 1.460798 0.098801 1.424042 0.533864 0.383439 0.268746 0.774104 1.359468 0.551837 1.072551 1.042980 1.187151 0.047706 0.475799 0.777237 1.508583 1.518390 0.624320 1.803609 -0.030146 1.428704 1.310937 0.200692 0.052979 0.248842 0.649311 1.390948 1.226773 0.627202 0.781465 1.281153 1.239400 0.074232 0.416931 1.280024 1.789310 0.371491 1.751863 1.011841 0.492815 1.050730 1.800313 0.950130 0.055134 0.624454 1.728356 1.204405 1.157013 1.556977 -0.053824 0.341297 1.557961 0.476700 0.850933 0.904239 1.687309 0.426984 1.284031 1.932629 0.705526 0.156329 1.808172 0.579194 1.000874 -0.065769 0.042011 1.229956 1.150937 -0.021819 1.496948 0.443659 0.756699 1.017917 0.251346 1.030963 1.700245 1.522355 1.033941 0.199053 0.895824 0.077681 -0.189464 1.138611 0.482469 0.670557 0.776398 0.101988 1.722452 1.772080 0.177376 1.142171 0.934923 1.481127 0.086983 0.577707 0.938725 0.850275 0.563872 1.225982 0.685952 1.482226 1.334215 0.509273 0.746348 0.969863 0.425234 0.193057 1.126319 1.717756 1.528837 0.488432 1.443764 1.714937 1.155149 1.167378 1.613967 1.199146 1.181773 0.344569 1.419134 -0.071949 1.346424 1.006446 -0.131152 0.728654 0.579173 -0.045896 0.845056 0.643214 1.617764 0.308222 1.103985 1.198293 0.615149 1.494940 -0.035825 0.670860 1.445170 1.159345 0.355670 0.735478 0.464210 0.913633 1.219473 1.118765 1.055292 1.056281 0.163639 1.133798 1.563215 1.723323 0.260017 1.605864 1.770955 0.668745 1.337320 1.007358 1.425833 0.777384 1.237103 1.006016 1.193298 1.651320 1.151617 1.880150 -0.057676 0.789706 1.276991 1.375810 0.824803 1.238859 0.916547 1.672716 1.688012 0.387565 0.255608 1.573682 1.496643 0.977599 0.563576 0.074656 1.141253 0.719343 1.223403 0.992610 1.858696 1.161425 0.070041 -0.125686 0.366133 0.548001 0.029832 0.966137 0.040605 0.859124 0.796007 -0.028757 1.503146 1.000712 0.350997 0.675359 1.657961 0.160716 1.364976 0.809508 1.465379 1.502419 1.664453 1.346214 0.980484 0.056425 0.582571 0.449384 0.964774 1.453345 0.957981 0.502063 1.649071 0.712283 0.618742 0.565175 1.143455 0.489376 1.817579 1.159323 0.148678 0.333064 0.709037 1.481181 1.547696 0.428397 0.156549 0.695465 1.356751 1.680722 0.615155 0.117992 0.510780 1.176860 1.354240 1.517559 0.636368 1.302311 0.451684 1.264346 1.556310 1.471008 0.581828 0.535059 1.663929 1.202044 0.264646 1.656255 0.805087 0.901536 1.636656 1.660890 0.213781 0.532407 1.704614 0.396471 0.287874 1.912406 0.959872 1.366158 0.497154 0.113127 0.757324 1.951120 1.684558 1.585973 1.115695 0.078984 1.961626 0.432344 1.383665 1.839506 0.464197 1.382403 0.427107 0.162841 1.778107 1.281058 0.089942 1.697933 1.210648 1.608672 0.966474 1.127034 1.183479 0.015244 1.307273 0.500341 0.137936 1.174736 1.112224 1.723755 1.678383 0.186904 1.574722 0.043220 0.423928 0.904505 -0.084123 0.123149 1.017494 0.182180 0.845663 0.909297 1.899427 1.571011 1.855999 0.411109 1.430036 0.198897 1.262293 1.525746 0.617827 0.342433 0.400577 0.534487 1.565876 1.105658 0.753026 1.729575 0.238258 0.074101 -0.033772 1.568523 1.717343 1.918595 1.704326 1.329853 1.746013 0.559256 0.907430 0.303341 0.114160 0.419704 1.407176 0.917726 1.385385 0.309901 1.271882 0.991233 0.626687 1.503739 1.761445 0.249662 1.036228 1.154024 0.122831 0.878665 1.019549 0.418872 1.249494 1.648187 0.685065 0.809468 1.459645 0.223209 1.276202 0.249098 1.107719 0.756455 0.675855 1.099504 1.821182 0.439342 1.136479 0.991788 1.806393 1.229819 0.775871 0.730021 0.103406 0.954714 1.373034 0.766770 0.226914 0.042385 0.357251 1.110782 0.706130 0.818954 0.663311 1.394411 -0.002333 0.170522 0.982526 1.134855 1.429460 0.958902 0.104769 1.363562 0.183401 0.987942 1.297404 0.781306 0.237651 1.387529 0.451936 1.135925 0.034323 1.467075 1.733686 0.672139 0.194562 1.712838 0.199073 0.397457 1.211235 1.873323 0.593680 0.689795 1.666389 1.387596 0.393157 0.109486 0.039271 0.574404 0.448900 0.858254 1.646605 1.150831 0.976483 0.383055 1.187262 1.496789 1.030500 1.504707 0.225431 1.104803 1.142124 0.650019 -0.056910 1.284387 1.214574 1.318027 0.132885 1.566739 0.508778 1.657481 0.736366 0.104613 0.353614 -0.078214 0.391782 1.885340 1.027024 0.057797 1.217778 0.929840 1.028350 0.705000 -0.149722 -0.066493 1.889044 0.110325 0.983042 0.309869 0.453933 0.387086 0.075846 1.905796 1.865389 1.918858 1.603983 0.713841 0.209720 -0.006643 1.339545 1.283096 0.518808 1.727901 1.695347 0.166260 1.729079 0.596249 0.598788 1.459050 1.373434 1.059808 0.263405 0.787598 0.750878 1.859223 1.455721 1.057228 1.880949 0.490826 0.480814 0.731423 1.269127 1.477368 1.452725 1.658583 0.898012 -0.206350 0.726186 0.876052 0.601006 1.099717 1.704079 0.115881 1.711472 1.701603 0.090876 0.469167 0.329196 1.694134 0.609674 0.296971 1.420592 0.588171 0.798695 0.492937 1.362363 1.705138 0.953363 0.715777 1.187715 0.137005 0.861354 1.278804 1.691238 0.220098 1.450682 1.274154 0.506599 0.486114 1.317070 1.042439 1.031173 0.076177 1.371313 1.525164 1.391698 0.168870 0.990807 1.712722 0.349662 1.188065 1.689867 0.623727 0.810052 1.266993 1.756572 0.585363 1.155258 1.207120 0.340125 1.095115 0.373453 0.746548 0.798746 0.695648 0.480037 1.665283 0.187718 0.509859 1.459411 0.159039 0.480744 0.197403 1.309059 0.183238 0.141461 0.932954 1.385194 1.874995 0.421847 0.592535 1.213160 1.324877 1.115619 0.602293 1.165930 0.736350 1.345151 0.567362 1.724476 1.314449 -0.009822 1.740175 1.330920 0.462556 0.337968 0.690692 0.949365 0.528224 1.732295 0.627916 1.770706 1.808990 0.600269 0.507826 1.049136 0.007882 0.548083 0.233717 0.687788 1.750769 1.212254 1.336601 0.608126 0.763179 1.792711 0.829391 1.853624 1.338781 0.328698 0.313930 0.134059 0.078374 0.860094 1.177784 -0.170272 0.423271 1.531652 1.545534 0.946297 0.938882 0.827107 0.385199 0.804432 0.376896 1.680737 0.493869 1.054621 1.482109 0.276807 0.370412 0.130379 0.560208 0.307767 0.707311 1.168701 1.246370 0.459097 1.577499 0.778623 1.185364 1.820826 0.376895 -0.000279 1.660466 0.738767 0.679051 1.835358 1.128161 1.234483 1.686015 0.237152 1.570322 0.733097 1.056685 0.190270 1.651412 1.552403 0.100049 0.352363 0.510500 1.032232 1.338133 0.354700 1.446166 1.135327 1.162009 1.692449 1.233326 1.283040 1.062653 -0.032844 0.988846 0.560990 0.673509 1.907780 0.753844 0.213662 0.480313 1.114457 1.359602 1.856622 0.714410 1.521015 0.348264 0.531203 1.026578 1.298369 0.582097 -0.047209 0.864510 -0.049426 1.724088 1.451930 1.621492 0.684612 1.460721 1.235916 0.350349 1.154146 -0.050896 0.957761 0.545640 1.540301 0.937733 -0.092039 1.753334 -0.001745 1.423253 1.604824 0.501983 1.477163 0.488951 1.367156 0.581784 1.432247 0.574524 1.566697 1.784857 1.142234 -0.035944 1.358074 -0.084439 1.920717 0.281090 0.027105 1.112695 -0.069333 1.977502 1.022351 1.316712 1.837822 1.617951 0.145384 0.678330 0.780838 0.759306 1.579814 0.881591 0.028800 1.747779 0.217846 0.093847 1.541383 1.432880 0.804262 0.001652 0.496141 0.763184 0.350024 0.247830 0.556581 0.841680 1.239333 0.677414 1.853240 0.734235 1.761778 0.476423 1.751026 0.001537 1.297088 1.748363 0.436992 0.875558 0.656917 0.941074 0.822806 0.918297 0.892341 0.860078 1.620482 1.119641 1.528123 0.215215 0.694822 1.690116 0.651795 1.943137 1.072341 1.220955 1.379944 1.274276 0.492791 1.340891 1.613371 0.968325 1.712829 1.504321 1.740625 0.897578 1.223557 1.705815 0.573395 0.287496 0.600183 1.147131 1.476049 0.427869 1.436897 1.027432 1.566185 0.979730 1.675041 0.920354 -0.071571 1.942315 1.074526 0.545908 1.136159 1.890089 0.764227 1.831111 1.497595 1.693648 1.911185 1.023122 0.894721 0.578201 0.817917 0.520745 -0.010085 1.709161 0.069394 0.531077 1.778656 0.180270 0.143816 0.075060 -0.038020 1.828685 1.277648 1.718003 1.189702 1.366040 0.095047 1.540029 0.387511 1.535264 1.655455 0.814800 1.275265 0.520247 1.081943 0.918219 0.980301 0.960761 1.392365 1.226648 0.388476 1.268976 0.739344 0.299357 1.754431 1.200979 0.202246 1.056121 1.001164 0.340510 0.676315 0.807485 0.049607 0.451875 1.723692 0.669496 1.183757 1.048577 0.881410 0.924945 0.117855 0.972391 0.941164 1.362251 0.339816 1.187981 1.112739 1.946142 1.477010 0.900141 0.981500 0.690820 0.718612 1.287409 0.885780 0.085941 0.458644 1.035331 0.426282 0.612089 1.539389 0.603918 0.299374 1.528677 1.738841 0.916787 1.854694 1.544844 1.050674 0.819370 1.727307 1.188322 0.010972 1.467338 1.766927 0.802593 0.235669 0.766034 0.026472 1.198388 1.774251 0.130888 1.053176 1.481141 0.876218 1.456495 0.160397 1.391821 -0.234549 0.260571 1.636519 0.506373 0.037763 0.218949 1.014687 1.029256 1.073816 0.012628 1.464141 1.524001 1.944582 1.903671 1.341401 1.030917 0.183264 0.178082 0.776502 1.094608 1.339629 -0.058755 0.052841 -0.057590 1.313235 0.981607 0.229605 0.845026 0.836394 0.374607 1.694997 0.169561 0.362408 0.339472 1.029029 0.036834 1.443566 1.837048 1.352074 0.267991 1.640185 1.275760 0.218946 1.378808 0.820591 1.639380 1.658848 0.891354 0.120570 1.057970 1.524787 0.697563 0.290652 0.159045 1.157871 0.031524 0.048413 1.571253 1.726466 1.587306 -0.003323 0.985464 0.669289 0.911367 1.710427 1.444792 1.194553 1.916283 0.183050 0.428781 0.244411 0.825053 0.563277 0.581047 -0.158092 1.195266 1.603912 0.974984 1.795356 1.456798 1.154876 0.231344 0.691063 0.896697 1.104758 0.695115 1.086653 1.467499 0.240808 0.286875 -0.092886 -0.081143 0.921049 0.467830 1.584461 0.380149 1.124185 1.374049 1.062798 0.776117 1.078021 0.364915 1.634267 0.189509 0.453520 0.558514 0.593987 0.098480 1.678891 0.758512 0.444710 1.105264 0.074450 1.858431 1.062728 1.705809 1.204568 1.806762 0.565446 0.116994 1.899748 1.219432 1.040399 0.409827 1.092242 0.655367 0.628939 1.558310 -0.132349 0.960474 0.968625 1.600722 1.592598 1.293226 1.485132 1.403506 0.121673 0.156185 1.033860 1.465363 1.355537 1.131408 -0.332607 1.107295 0.514580 0.514027 -0.018422 1.700284 0.519983 0.931010 0.493968 0.681690 1.430799 1.787347 0.904664 1.499430 0.455450 0.933801 0.850726 0.432495 0.660660 -0.004954 0.655136 -0.148773 1.400357 0.267471 1.548428 1.792653 0.562751 1.706703 0.864919 0.048679 1.187539 0.346654 0.772860 0.193614 0.168501 1.050210 0.042807 1.181518 0.173962 1.637858 1.358068 0.769190 1.828873 0.678251 0.521468 -0.063886 0.315508 0.638270 0.000364 1.579419 0.789250 0.657127 1.203771 0.129719 0.681799 1.190778 0.894287 1.336344 1.788463 1.846398 1.607135 1.455095 1.767751 1.068955 1.271427 1.103560 1.799002 0.229493 1.513569 0.231110 1.051375 1.781330 1.718417 1.579801 0.662031 1.600575 0.720245 0.042416 1.686871 0.680986 0.709878 0.903091 1.408359 0.002925 0.744556 0.738793 1.813141 1.075793 1.734703 1.682875 1.118770 0.649169 1.253302 0.219739 0.765513 0.362778 1.124432 1.483219 1.210938 1.334907 1.947989 1.414494 0.096360 -0.147788 0.750155 0.306400 1.121717 0.371162 -0.145257 1.612715 1.274266 0.522524 0.320913 1.100279 0.987903 0.400348 0.608101 1.842391 0.692877 0.181716 0.113519 0.307760 1.548623 0.236764 1.432256 0.278623 1.785585 0.189840 0.393200 0.401979 1.307402 1.156180 0.376371 -0.137312 1.084279 0.334683 0.637341 0.321475 1.550001 0.773735 1.878487 0.470924 1.743676 1.247417 1.412610 0.453632 0.952996 0.603634 0.223839 1.468667 0.623231 0.692795 1.971190 0.916854 0.275567 1.492615 1.212276 0.779810 0.179111 0.368239 0.935091 1.027977 0.130672 0.034555 0.911475 1.276506 1.891716 1.485403 0.987569 1.688898 0.672758 1.248824 1.356252 0.481907 0.915560 1.209030 1.208082 0.110653 0.939625 0.668513 0.639433 1.084344 0.556776 0.665675 1.721594 0.160860 0.467349 0.836020 0.266590 0.145044 0.970886 0.877130 0.758603 0.818682 0.994847 1.550458 1.130237 1.844679 0.595736 1.709610 1.641269 -0.126034 0.239840 1.514469 0.413112 0.548712 1.197128 0.470456 1.260206 1.416600 0.962967 0.464707 1.782023 0.680816 -0.068522 1.515998 0.905404 1.825158 0.878572 1.286928 1.777582 1.176578 0.504100 0.153432 0.236354 1.572845 1.072440 1.225102 1.468949 1.147936 0.060847 0.677911 0.958862 0.563111 1.729938 1.089984 0.392951 0.168868 1.132775 1.031074 1.166083 0.063334 1.108227 0.512278 1.680383 1.603508 0.165709 1.630714 0.620600 0.080639 1.835039 1.891068 0.337558 0.284989 1.806024 1.702499 1.797501 0.180551 -0.098669 0.542253 0.416139 1.267309 0.272434 0.869017 1.670141 0.434986 1.169876 0.778976 1.563237 0.004143 0.630692 0.038661 0.209223 0.366363 0.296521 0.792475 1.689937 0.043722 0.120064 0.331935 0.897717 1.570899 1.805204 0.128369 0.534772 1.584364 -0.142217 1.447133 0.065015 1.501032 1.174583 1.571049 1.201595 0.446026 0.559027 0.513681 1.861344 0.964408 1.174899 0.345088 1.307907 0.313322 0.372117 0.251941 1.059719 0.741984 1.382242 1.325610)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


#|
  (with-sound (:channels 2 :clipped #f)
    (let* ((n 24)
	   (c-phases (vct 1/2 1/2 1/2 1/2 1/2 3/2 1/2 1/2 1/2 3/2 1/2 1/2 1/2 3/2 3/2 3/2 3/2 3/2 1/2 3/2 1/2 1/2 3/2 1/2))
	   (s-phases (vct 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1))
	   
	   ;; n amp phase

	   (cos-phases (make-vct 72))
	   (sin-phases (make-vct 72)))

      (do ((i 0 (+ i 3))
	   (j 0 (+ j 1)))
	  ((= i 72))
	(vct-set! cos-phases i (+ j 1))
	(vct-set! sin-phases i (+ j 1))
	(vct-set! cos-phases (+ i 1) 1.0)
	(vct-set! sin-phases (+ i 1) 1.0)
	(vct-set! cos-phases (+ i 2) (* pi (vct-ref c-phases j)))
	(vct-set! sin-phases (+ i 2) (* pi (vct-ref s-phases j))))

      (let ((gen1 (make-polyoid 100.0 cos-phases))
	    (gen2 (make-polyoid 100.0 sin-phases)))
	(run 
	 (lambda ()
	   (do ((i 0 (1+ i)))
	       ((= i 88200))
	     (outa i (polyoid gen1 0.0))
	     (outb i (polyoid gen2 0.0))))))))

(set! (mus-rand-seed) (current-time))
(set! (print-length) 1000000)

(define (vector-find-if func vect)
  (let ((len (vector-length vect))
	(result #f))
    (do ((i 0 (+ i 1)))
	((or (= i len)
	     result)
	 result)
      (set! result (func (vector-ref vect i))))))
|#

(define primes (vector 1
       2       3       5       7      11      13      17      19      23 
      29      31      37      41      43      47      53      59      61 
      67      71      73      79      83      89      97     101     103 
     107     109     113     127     131     137     139     149     151 
     157     163     167     173     179     181     191     193     197 
     199     211     223     227     229     233     239     241     251 
     257     263     269     271     277     281     283     293     307 
     311     313     317     331     337     347     349     353     359 
     367     373     379     383     389     397     401     409     419 
     421     431     433     439     443     449     457     461     463 
     467     479     487     491     499     503     509     521     523 
     541     547     557     563     569     571     577     587     593 
     599     601     607     613     617     619     631     641     643 
     647     653     659     661     673     677     683     691     701 
     709     719     727     733     739     743     751     757     761 
     769     773     787     797     809     811     821     823     827 
     829     839     853     857     859     863     877     881     883 
     887     907     911     919     929     937     941     947     953 
     967     971     977     983     991     997    1009    1013    1019 
    1021    1031    1033    1039    1049    1051    1061    1063    1069 
    1087    1091    1093    1097    1103    1109    1117    1123    1129 
    1151    1153    1163    1171    1181    1187    1193    1201    1213 
    1217    1223    1229    1231    1237    1249    1259    1277    1279 
    1283    1289    1291    1297    1301    1303    1307    1319    1321 
    1327    1361    1367    1373    1381    1399    1409    1423    1427 
    1429    1433    1439    1447    1451    1453    1459    1471    1481 
    1483    1487    1489    1493    1499    1511    1523    1531    1543 
    1549    1553    1559    1567    1571    1579    1583    1597    1601 
    1607    1609    1613    1619    1621    1627    1637    1657    1663 
    1667    1669    1693    1697    1699    1709    1721    1723    1733))

#|
(define (get-fft-size choice n1)
  (let ((n (if (eq? choice :all) n1
	       (if (not (eq? choice :prime)) (* 2 n1)
		   (vector-ref primes n1)))))
    (min (expt 2 16) 
	 (expt 2 (ceiling (/ (log (* n 64)) (log 2)))))))

(define (random n)
  (if (exact? n)
      (mus-irandom n)
      (mus-frandom n)))

(define pi2 (/ pi 2))
(define data-file "test.data")

(define (save-case n choice peak phases)
  (let ((fd (open-output-file data-file "a")))
    (format fd "~%;~A: ~A ~A #(" n choice peak)
    (do ((m 0 (1+ m)))
	((= m n))
      (if (zero? (vct-ref phases m))
	  (format fd "0")
	  (format fd "1"))
      (if (< m (- n 1))
	  (format fd " ")))
    (format fd ")~%")
    (close-output-port fd)))

(define (try-any)
  (let ((choice (let ((v (random 4)))
		  (case v
		    ((0) :all)
		    ((1) :even)
		    ((2) :odd)
		    (else :prime))))
	(n (+ 24 (random 104))))
    (let* ((size (get-fft-size choice n))
	   (tries (if (not (eq? choice :prime)) 2500000 500000))
	   (fft-rl (make-vct size))
	   (fft-im (make-vct size)))

      (format #t ";~D ~A~%" n choice)

      (let* ((cur-min 1000.0)
	     (phases (make-vct n 0.0)))
	(let ((min-val (vector-find-if (lambda (val)
					 (and val
					      (vector? val)
					      (= (vector-ref val 0) n)
					      (let ((a-val (vector-ref val 1))
						    (a-len (vector-length val)))
						(do ((k 2 (1+ k)))
						    ((= k a-len))
						  (if (and (number? (vector-ref val k))
							   (< (vector-ref val k) a-val))
						      (set! a-val (vector-ref val k))))
						a-val)))
				       (if (eq? choice :all)
					   noid-min-peak-phases
					   (if (eq? choice :odd)
					       nodd-min-peak-phases
					       (if (eq? choice :even)
						   neven-min-peak-phases
						   primoid-min-peak-phases))))))
	  (if (and (number? min-val)
		   (< min-val cur-min))
	      (set! cur-min min-val)))

	(let ((nc (if (eq? choice :all) 0
		      (if (eq? choice :odd) 1
			  (if (eq? choice :even) 2 3)))))

	  (run 
	   (lambda ()

	     (do ((try 0 (1+ try)))
		 ((= try tries))
	       (do ((i 1 (1+ i)))
		   ((= i n))
		 (if (> (random 1.0) 0.5)
		     (vct-set! phases i pi)
		     (vct-set! phases i 0.0)))
	       (clear-array fft-rl)
	       (clear-array fft-im)
	       
	       (do ((k 0 (+ k 1)))
		   ((= k n))
		 (let ((phi (+ (vct-ref phases k) pi2))
		       (bin (if (= nc 0) (+ k 1)
				(if (= nc 1) (+ 1 (* k 2))
				    (if (= nc 2) (max 1 (* k 2))
					(vector-ref primes k))))))
		   (vct-set! fft-rl bin (cos phi))
		   (vct-set! fft-im bin (sin phi))))
	       
	       (let ((peak (vct-peak (mus-fft fft-rl fft-im size -1))))
		 (if (< peak cur-min)
		     (begin
		       (save-case n choice peak phases)
		       (format #t ";~A: ~A ~A #(" n choice peak)
		       (do ((m 0 (1+ m)))
			   ((= m n))
			 (if (zero? (vct-ref phases m))
			     (format #t "0")
			     (format #t "1"))
			 (if (< m (- n 1))
			     (format #t " ")))
		       (format #t ")~%")
		       (set! cur-min peak))))
	       )))))))

  (set! (mus-rand-seed) (current-time))
  (try-any))

(define* (try-all (num-threads 2) (data "test.data"))
  (set! data-file data)
  (let ((threads '()))
    (do ((i 0 (+ i 1)))
	((= i num-threads))
      (set! threads (cons (make-thread try-any) threads)))
    (for-each 
     (lambda (thread) 
       (join-thread thread))
     threads)))

;;; then once a new local minimum is found,
(define (optit choice n)
  (let* ((size (get-fft-size choice n))
	 (fft-rl (make-vct size))
	 (fft-im (make-vct size)))

      (let* ((phases (make-vct n 0.0))
	     (min-phase 0.0)
	     (min-phases (make-vector n 0)))
	(let* ((min-val (vector-find-if (lambda (val)
					  (and val
					       (vector? val)
					       (= (vector-ref val 0) n)
					       (let ((a-val (vector-ref val 1))
						     (a-len (vector-length val))
						     (a-data (vector-ref val 2)))
						 (do ((k 3 (1+ k)))
						     ((= k a-len))
						   (if (and (number? (vector-ref val k))
							    (< (vector-ref val k) a-val))
						       (begin
							 (set! a-val (vector-ref val k))
							 (set! a-data (vector-ref val (+ k 1))))))
						 (list a-val a-data))))
					(if (eq? choice :all)
					    noid-min-peak-phases
					    (if (eq? choice :odd)
						nodd-min-peak-phases
						(if (eq? choice :even)
						    neven-min-peak-phases
						    primoid-min-peak-phases)))))
	       (cur-min (car min-val))
	       (cur-phases (cadr min-val)))

	  (set! min-phase cur-min)
	  ;(format #t "~A ~A: ~A~%" choice n cur-min)

	  (let ((nc (if (eq? choice :all) 0
			(if (eq? choice :odd) 1
			    (if (eq? choice :even) 2 3))))
		(inc 1))

	    (do ()
		((> inc 1))

	      (do ((i 1 (+ i 1)))
		  ((= i n))
		(let ((old-val (vector-ref cur-phases i)))
		  (do ((k 0 (+ k 1)))
		      ((> k inc))
		    (if (not (= old-val (/ k inc)))
			(begin
			  (vector-set! cur-phases i (/ k inc))

			  (clear-array fft-rl)
			  (clear-array fft-im)
	       
			  (do ((m 0 (+ m 1)))
			      ((= m n))
			    (let ((phi (+ (* pi (vector-ref cur-phases m)) pi2))
				  (bin (if (= nc 0) (+ m 1)
					   (if (= nc 1) (+ 1 (* m 2))
					       (if (= nc 2) (max 1 (* m 2))
						   (vector-ref primes m))))))
			      (vct-set! fft-rl bin (cos phi))
			      (vct-set! fft-im bin (sin phi))))
	       
			  (let ((peak (vct-peak (mus-fft fft-rl fft-im size -1))))
			    (if (< peak min-phase)
				(begin
				  (do ((m 0 (1+ m)))
				      ((= m n))
				    (vector-set! min-phases m (vector-ref cur-phases m)))
				  (set! min-phase peak))))

			  (vector-set! cur-phases i old-val))))))

	      ;(format #t "~D: ~A~%" inc min-phase)

	      (if (< min-phase (- cur-min .001))
		  (begin
		    (do ((m 0 (+ m 1)))
			((= m n))
		      (vector-set! cur-phases m (vector-ref min-phases m)))
		    (set! cur-min min-phase)
		    (if (= inc 1)
			(format #t ";~A: ~A ~A ~A~%" n choice cur-min cur-phases)))
		  (begin
		    (set! inc (* inc 2))))))


	  ;(format #t ";~A: ~A ~A ~A~%" n choice cur-min cur-phases)
	  ))))
|#



(define (tstodd phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 2)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstoddderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 2)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (tstall phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallf mult phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (if (= k (- len 1))
	      (set! val (+ val (* mult (sin (+ (* j x) (* pi (phs k)))))))
	      (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tsteven phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstprime phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (vector-ref primes k) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 1)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (get-best choice n)

  (define (vector-find-if func vect)
    (let ((len (vector-length vect))
	  (result #f))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       result)
	   result)
	(set! result (func (vector-ref vect i))))))

  (vector-find-if (lambda (val)
		    (and val
			 (vector? val)
			 (= (vector-ref val 0) n)
			 (let ((a-val (vector-ref val 1))
			       (a-len (vector-length val))
			       (a-data (vector-ref val 2)))
			   (do ((k 3 (1+ k)))
			       ((= k a-len))
			     (if (and (number? (vector-ref val k))
				      (< (vector-ref val k) a-val))
				 (begin
				   (set! a-val (vector-ref val k))
				   (set! a-data (vector-ref val (+ k 1))))))
			   (list a-val a-data))))
		  (if (eq? choice :all)
		      noid-min-peak-phases
		      (if (eq? choice :odd)
			  nodd-min-peak-phases
			  (if (eq? choice :even)
			      neven-min-peak-phases
			      primoid-min-peak-phases)))))

(define (get-worst-overall choice choices)
  (let ((diffs (make-vector 116))
	(total 0.0)
	(this 0.0)
	(last 0.0)
	(next 0.0)
	(choice-list '())
	(first (car (get-best choice 11))))
    (set! this first)
    (set! next (car (get-best choice 12)))
    (do ((i 12 (+ i 1)))
	((= i 128))
      (set! last this)
      (set! this next)
      (set! next (car (get-best choice (+ i 1))))
      (vector-set! diffs (- i 12) (cons i (+ (- this last) (- this next))))
      (set! total (+ total (abs (- this last)))))
    (sort! diffs (lambda (a b)
		   (> (cdr a) (cdr b))))
    (do ((i (- choices 1) (- i 1)))
	((< i 0))
      (let ((c (vector-ref diffs i)))
	(set! choice-list (cons (vector-ref diffs i) choice-list))))

    (list choice-list (- (+ total first) this)))) ; first to this would be a straight line



(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results '()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall #(0.0 0.1 0.2 0.3))) #(0.0 0.1 0.2 0.3))
;;; 3.49630991 #(0.0 1.1 0.2 1.3)
;;; 3.49630680 #(0.0 1.9 1.8 1.7)
;;; 3.49630979 #(0.0 0.9 1.8 0.7)

(set! (print-length) 123123)

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadr (car other-mins)))
	    (pk3 (cadr (cadr other-mins)))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (car (car other-mins)) (car data))) .001)
		(> (abs (- (car (cadr other-mins)) (car data))) .001)
		(> (abs (- (car (caddr other-mins)) (car data))) .001))
	    (format #t "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (vector-ref a 1) (vector-ref b 1))))))
	  (format #t "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (car data)
		  (list-ref phases 0)
		  (list-ref phases 1)
		  (list-ref phases 2)
		  (list-ref phases 3)
		  ))))))

;;; is it heading for (sqrt (* 2 n))?



;; 1 Mar 5446.42,  0.576  
;; 1 Apr 5405.890, 0.575
;; 1 May 5138.261, 0.562
;; 1 Jun 5061.829, 0.558
;; 1 Jul 4669.101, 0.540
;; 1 Aug 4633.454, 0.539
;; 1 Sep 4616.517, 0.538
;; 1 Oct 4592.994, 0.537
;; 1 Nov 4560.903, 0.536

;all peaks... Fri 06-Nov-2009 11:51
;(0.0029939404030834 87)
;odd peaks... Fri 06-Nov-2009 14:54
;odd 1024: peak-phases value: 51.239994, current: 51.223308942004, diff: -0.016685057995865
;odd 2048: peak-phases value: 83.108, current: 83.104896182737, diff: -0.0031038172633231
;(0.016685057995865 1024)
;even peaks... Fri 06-Nov-2009 18:09
;even 2048: peak-phases value: 87.300233499882, current: 87.471149563312, diff: 0.17091606342971
;(0.17091606342971 2048)
;prime peaks... Fri 06-Nov-2009 21:08
;prime 1024: peak-phases value: 70.14, current: 70.135034607593, diff: -0.0049653924066604
;prime 2048: peak-phases value: 102.619, current: 102.51726365169, diff: -0.10173634830561
;(0.10173634830561 2048)
;all done! Fri 06-Nov-2009 23:48

