# smtpf.plot : input file for gnuplot

# Usage: gnuplot smtpf.plot

set term x11
#set term latex
#set term postscript portrait "Times-Roman"
#set term postscript "Times-Roman"
#set term tgif
#set term pbm color

#set tics out
set grid
set xrange [1:]
set yrange [1:]
set logscale x
set logscale y

set xlabel "Recipients"
set ylabel "Time (Sec)"
#set label "label" at 100,150 center
#set key 80,150

set title "Performance of delivery with smtpfeed"

#set output "out-1.pbm"

plot \
	x notitle with line 6, \
	x / 100 title "y = x / 100" with line 5, \
	'gp-data.1' using 1:3 title "MX" with points 1, \
	'gp-data.1' using 1:4 title "90%SMTP" with points 2, \
	'gp-data.1' using 1:6 title "90%Total" with points 3, \
	'gp-data.1' using 1:7 title "Total" with points 4

#plot \
#	'gp-data.1' using 1:2 title "sendmail" with points 1, \
#	'gp-data.1' using 1:3 title "MX" with points 2, \
#	'gp-data.1' using 1:4 title "90%SMTP" with points 3, \
#	'gp-data.1' using 1:5 title "SMTP" with points 4, \
#	'gp-data.1' using 1:6 title "90%Total" with points 5, \
#	'gp-data.1' using 1:7 title "Total" with points 6

pause -1 "Hit return to continue"

set xlabel "Transactions"

#set output "out-2.pbm"

plot \
	x notitle with line 6, \
	x / 100 title "y = x / 100" with line 5, \
	'gp-data.2' using 1:3 title "MX" with points 1, \
	'gp-data.2' using 1:4 title "90%SMTP" with points 2, \
	'gp-data.2' using 1:6 title "90%Total" with points 3, \
	'gp-data.1' using 1:7 title "Total" with points 4

#plot \
#	'gp-data.2' using 1:2 title "sendmail" with points 1, \
#	'gp-data.2' using 1:3 title "MX" with points 2, \
#	'gp-data.2' using 1:4 title "90%SMTP" with points 3, \
#	'gp-data.2' using 1:5 title "SMTP" with points 4, \
#	'gp-data.2' using 1:6 title "90%Total" with points 5, \
#	'gp-data.2' using 1:7 title "Total" with points 6

pause -1 "Hit return to continue"

#set nologscale y
#set yrange [0:0.1]
set logscale y
set yrange [0.001:]

set xlabel "Recipients"
set ylabel "Time/Recipients (Sec/Rec)"

#set output "out-3.pbm"

plot \
	'gp-data.3' using 1:3 title "MX" with points 1, \
	'gp-data.3' using 1:4 title "90%SMTP" with points 2, \
	'gp-data.3' using 1:6 title "90%Total" with points 3, \
	'gp-data.3' using 1:7 title "Total" with points 4

pause -1 "Hit return to continue"

set xlabel "Transactions"
set ylabel "Time/Recipients (Sec/Trans)"

#set output "out-4.pbm"

plot \
	'gp-data.4' using 1:3 title "MX" with points 1, \
	'gp-data.4' using 1:4 title "90%SMTP" with points 2, \
	'gp-data.4' using 1:6 title "90%Total" with points 3, \
	'gp-data.4' using 1:7 title "Total" with points 4

pause -1 "Hit return to continue"

set nologscale x
set logscale y
set xrange [*:*]
set yrange [0.001:]

set xlabel "Time"
set ylabel "Time/Recipients (Sec/Rec)"

#set output "out-5.pbm"

plot \
	'gp-data.5' using 1:3 title "MX" with points 1, \
	'gp-data.5' using 1:4 title "90%SMTP" with points 2, \
	'gp-data.5' using 1:6 title "90%Total" with points 3, \
	'gp-data.5' using 1:7 title "Total" with points 4

pause -1 "Hit return to continue"

set ylabel "Time/Recipients (Sec/Trans)"

#set output "out-6.pbm"

plot \
	'gp-data.6' using 1:3 title "MX" with points 1, \
	'gp-data.6' using 1:4 title "90%SMTP" with points 2, \
	'gp-data.6' using 1:6 title "90%Total" with points 3, \
	'gp-data.6' using 1:7 title "Total" with points 4

pause -1 "Hit return to continue"

#set nolabel
