#include <stdlib.h>
#include "mr_pcre/mr_pcre.h"
#include "orangembox.h"

using namespace std;

OrangemboxSMS::OrangemboxSMS(Config &config) : GenericSMS(config)
{
	orangembox_user = config["orangembox_login"];
	orangembox_pass = config["orangembox_pass"];
}

bool OrangemboxSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	Curl_Result result;
	FormParser f_parser;
	string url;
	int remainingCounter, remainingAfterSend;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.UserAgent("Mozilla/5.0 Galeon/1.2.7 (X11; Linux i686; U;) Gecko/20021216");
	curl.SetOpt(CURLOPT_COOKIEFILE, "");
	
	while (true) {
		status = curl.PerformGet("http://www.orange.pl/portal/map/map/signin");
		if (status) throw Exception("[1] - get http://www.orange.pl/portal/map/map/signin");

		form.AddField("_dyncharset", "UTF-8");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginErrorURL", 
			"http://www.orange.pl/portal/map/map/signin");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginErrorURL", 
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginSuccessURL",
			"http://www.orange.pl/portal/map/map/pim");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginSuccessURL",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.login",
			orangembox_user);
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.login",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.password",
			orangembox_pass);
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.password",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login.x",
			"0");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login.y",
			"0");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login",
			" ");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login",
			" ");
		form.AddField("_DARGS", "/gear/static/signIn.jsp");
		
		status = curl.PerformPost("https://www.orange.pl/portal/map/map/signin?_DARGS=/gear/static/signIn.jsp",
			form.PostFields());
		if (status) throw Exception("[2] - https://www.orange.pl/portal/map/map/signin?_DARGS=/gear/static/signIn.jsp");

		ok = curl.Body().find("zalogowany jako") != string::npos;
		if (!ok) throw Exception("[2] - błąd podczas logowania");

		status = curl.PerformGet("http://www.orange.pl/portal/map/map/message_box");
        if (status) throw Exception("[3] - get http://www.orange.pl/portal/map/map/message_box");
		
		PcreWrap::Array match;
		if (PcreWrap::pcre_match_all("<span class=\"label\">darmowe:</span>.*<span class=\"value\">([0-9]+)</span>", 
			curl.Body(), "mis", match)) {
			long int remaining = strtol(match[0][0].c_str(), NULL, 10);
			if (remaining == 0)
				throw Exception("[4] - limit wiadomości na ten miesiąc przekroczony");
			else if (remaining < 0)
				throw Exception("[4] - nie można odczytać limitu wiadomości");
			remainingCounter = remaining;
		} else if (PcreWrap::pcre_match_all("<span class=\"label\">darmowe:.*>([0-9]+)<.*?z do..adowa..:.*>([0-9]+)<",
			curl.Body(), "mis", match)) {
			long int remainingFree = strtol(match[0][0].c_str(), NULL, 10);
			long int remainingNonFree = strtol(match[0][1].c_str(), NULL, 10);
			if (remainingFree == 0 && remainingNonFree == 0)
				throw Exception("[4] - limit wiadomości na ten miesiąc przekroczony");
			else if (remainingFree < 0 || remainingNonFree < 0)
				throw Exception("[4] - nie można odczytać limitu wiadomości");
			remainingCounter = remainingFree + remainingNonFree;
		} else
			throw Exception("[4] - brak informacji o pozostałych sms-ach");

		status = curl.PerformGet("http://www.orange.pl/portal/map/map/message_box?mbox_view=newsms&mbox_edit=new");
		if (status) 
			throw Exception("[5] - get http://www.orange.pl/portal/map/map/message_box?mbox_view=newsms&mbox_edit=new");

		form.Reset();
		form.AddField("_dyncharset", "UTF-8");
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.type",
			"sms");
		form.AddField("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.type",
			" ");
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.errorURL",
			"/portal/map/map/message_box?mbox_view");
		form.AddField("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.errorURL",
			" ");
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.successURL",
			"/portal/map/map/message_box?mbox_view");
		form.AddField("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.successURL",
			" ");
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.to",
			phone_no.substr(3));
		form.AddField("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.to",
			" ");
		form.AddField("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.body",
			" ");
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.body",
			message);
		form.AddField("counter", 640 - message.length());
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.create.x", 
			"0");
		form.AddField("/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.create.y",
			"0");
		form.AddField("_D:/amg/ptk/map/messagebox/formhandlers/MessageFormHandler.create",
			" ");
		form.AddField("_DARGS", "/gear/mapmessagebox/smsform.jsp");
		
		status = curl.PerformPost("http://www.orange.pl/portal/map/map/message_box??_DARGS=/gear/mapmessagebox/smsform.jsp",
			form.PostFields());
		if (status) 
			throw Exception("[6] - http://www.orange.pl/portal/map/map/message_box??_DARGS=/gear/mapmessagebox/smsform.jsp");
	
		if (PcreWrap::pcre_match_all("<span class=\"label\">darmowe:.*>([0-9]+)<.*?z do..adowa..:.*>([0-9]+)<", 
			curl.Body(), "mis", match)) {
			long int remainingFree = strtol(match[0][0].c_str(), NULL, 10);
			long int remainingNonFree = strtol(match[0][1].c_str(), NULL, 10);
			if (remainingFree < 0 || remainingNonFree < 0)
				throw Exception("[7] - nie można odczytać ilości dostępnych sms-ów");
			remainingAfterSend = remainingFree + remainingNonFree;
		} else if (PcreWrap::pcre_match_all("<span class=\"label\">darmowe:</span>.*<span class=\"value\">([0-9]+)</span>",
			curl.Body(), "mis", match)) {
			long int remaining = strtol(match[0][0].c_str(), NULL, 10);
			remainingAfterSend = remaining;
			if (remaining < 0)
				throw Exception("[7] - nie można odczytać ilości dostępnych sms-ów");
		}
		
		if (remainingAfterSend >= remainingCounter)
			throw Exception("[7] - STATUS NIEZNANY, nie wiadomo czy wiadomość została wysłana");
		
		form.Reset();
		form.AddField("_dyncharset", "UTF-8");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutSuccessURL", 
			"/portal/map/map");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutSuccessURL",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutErrorURL",
			"/portal/map/map");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutErrorURL",
			" ");
		form.AddField("enabled", "true");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logout",
			"logout");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logout",
			" ");
		form.AddField("_DARGS", "/portal/layoutTemplates/html/user_status.jsp");
		
		status = curl.PerformPost("http://www.orange.pl/portal/map/map?_DARGS=/portal/layoutTemplates/html/user_status.jsp",
			form.PostFields());
	
		break;
	}
	
	return ok;
}

bool OrangemboxSMS::ShowStats()
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	Curl_Result result;
	FormParser f_parser;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.UserAgent("Mozilla/5.0 Galeon/1.2.7 (X11; Linux i686; U;) Gecko/20021216");
	curl.SetOpt(CURLOPT_COOKIEFILE, "");
	
	while (true) {
		status = curl.PerformGet("http://www.orange.pl/portal/map/map/signin");
		if (status) throw Exception("[1] - get http://www.orange.pl/portal/map/map/signin");

		form.AddField("_dyncharset", "UTF-8");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginErrorURL", 
			"http://www.orange.pl/portal/map/map/signin");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginErrorURL", 
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginSuccessURL",
			"http://www.orange.pl/portal/map/map/pim");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.loginSuccessURL",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.login",
			orangembox_user);
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.login",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.password",
			orangembox_pass);
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.value.password",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login.x",
			"0");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login.y",
			"0");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login",
			" ");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.login",
			" ");
		form.AddField("_DARGS", "/gear/static/signIn.jsp");
		
		status = curl.PerformPost("https://www.orange.pl/portal/map/map/signin?_DARGS=/gear/static/signIn.jsp",
			form.PostFields());
		if (status) throw Exception("[2] - https://www.orange.pl/portal/map/map/signin?_DARGS=/gear/static/signIn.jsp");

		ok = curl.Body().find("zalogowany jako") != string::npos;
		if (!ok) throw Exception("[2] - błąd podczas logowania");

		status = curl.PerformGet("http://www.orange.pl/portal/map/map/message_box");
        if (status) throw Exception("[3] - get http://www.orange.pl/portal/map/map/message_box");
		
		PcreWrap::Array match;
		if (PcreWrap::pcre_match_all("<span class=\"label\">darmowe:</span>.*<span class=\"value\">([0-9]+)</span>", 
			curl.Body(), "mis", match)) {
			cout << "Darmowe: " << match[0][0] << endl;
		} else if (PcreWrap::pcre_match_all("<span class=\"label\">darmowe:.*>([0-9]+)<.*?z do..adowa..:.*>([0-9]+)<",
			curl.Body(), "mis", match)) {
			cout << "Darmowe: " << match[0][0] << ", płatne: " << match[0][1] << endl;
		} else
			throw Exception("[4] - brak informacji o pozostałych sms-ach");

		form.Reset();
		form.AddField("_dyncharset", "UTF-8");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutSuccessURL", 
			"/portal/map/map");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutSuccessURL",
			" ");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutErrorURL",
			"/portal/map/map");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logoutErrorURL",
			" ");
		form.AddField("enabled", "true");
		form.AddField("/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logout",
			"logout");
		form.AddField("_D:/amg/ptk/map/core/formhandlers/AdvancedProfileFormHandler.logout",
			" ");
		form.AddField("_DARGS", "/portal/layoutTemplates/html/user_status.jsp");
		
		status = curl.PerformPost("http://www.orange.pl/portal/map/map?_DARGS=/portal/layoutTemplates/html/user_status.jsp",
			form.PostFields());

		break;
	}
	
	return ok;
}

