#include <config.h>
#include <fstream>
#include <iostream>
#include <string>

using std::string;
using std::cerr;
using std::endl;

#include "ExtendedPlayList.h"

/** Append a smil or media object to the current playlist.
*/

bool ExtendedPlayList::Append( string name )
{
	bool result = false;
	PlayList newlist;
	string filename = directory_utils::get_absolute_path_to_file( "", name );

	// Try reading a few bytes from the file ...
	std::ifstream file( filename.c_str( ) );
	std::vector<char> buffer(22, '\0');
	file.read( &buffer[0], buffer.size() );
	
	// Check if the file is a smil or can be loaded as a media object
	if( !file.bad( ) )
	{
		const std::string smil_magic("<?xml version=\"1.0\"?>");
		if(std::string(buffer.begin(), buffer.begin() + smil_magic.size()) == smil_magic)
		{
			result = newlist.LoadPlayList( (char *)filename.c_str( ) );
		}
		else
		{
			newlist.LoadMediaObject( (char *)filename.c_str( ) );
			result = newlist.GetNumFrames( ) != 0;
		}

		// Close the file
		file.close( );
	}

	// Insert newlist into this
	if ( result )
		result = InsertPlayList( newlist, GetNumFrames( ) );
	else
		cerr << "Error: No file handler available for " << filename << endl;

	return result;
}

