/*
 * BufferReader.h -- Buffered Input
 * Copyright (C) 2003 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_BUFFER_READER_
#define _KINO_BUFFER_READER_

#include <stdint.h>
#include <pthread.h>

/** Buffer reader class.
*/

class BufferReader
{
	protected:
		pthread_mutex_t mutex;
		int size;
		uint8_t *buffer;
		int used;
	
	public:
		BufferReader( int size );
		virtual ~BufferReader( );
		virtual int Read( uint8_t *data, int size ) = 0;
		int GetBuffer( uint8_t *data, int length );
		int GetBuffer( uint8_t &byte );
		int GetBuffer( uint32_t &value );
		int GetBuffer( int16_t &value );
		int GetBuffer( int16_t values[], int );
};

#endif
