/***************************************************************************
    smb4kmounter_p  -  This is a private helper class for Smb4KMounter.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// application specific includes
#include "smb4kmounter_p.h"

Smb4KMounterPrivate::Smb4KMounterPrivate()
{
  timerTicks = 0;
  clearData();
}


Smb4KMounterPrivate::~Smb4KMounterPrivate()
{
}


void Smb4KMounterPrivate::clearData()
{
  m_share = Smb4KShare();
}


void Smb4KMounterPrivate::setShare( const Smb4KShare &share )
{
  m_share = share;
}


Smb4KMounterQueueContainer::Smb4KMounterQueueContainer( int todo, const Smb4KShare &share )
: m_todo( todo ), m_share( share ), m_force( false ), m_no_message( false )
{
}


Smb4KMounterQueueContainer::Smb4KMounterQueueContainer( int todo, const Smb4KShare &share, bool force, bool no_msg )
: m_todo( todo ), m_share( share ), m_force( force ), m_no_message( no_msg )
{
}


Smb4KMounterQueueContainer::Smb4KMounterQueueContainer( int todo )
: m_todo( todo ), m_share( Smb4KShare() ), m_force( false ), m_no_message( false )
{
}


Smb4KMounterQueueContainer::~Smb4KMounterQueueContainer()
{
}
