static variable window = NULL;
static variable FOLLOW_CLICK = 0;
static variable FOLLOW_MOTION  = 1;
static variable current_follow_mode = FOLLOW_CLICK;
static variable sigids = Integer_Type[2];

static define set_follow(rb,layout,follow_mode)
{
   if (follow_mode == current_follow_mode)
      return;
   current_follow_mode = follow_mode;
   switch(follow_mode)
	{ case FOLLOW_CLICK:
	   g_signal_handler_unblock(layout,sigids[FOLLOW_CLICK]);
	   g_signal_handler_block(layout,sigids[FOLLOW_MOTION]);
	}
	{ case FOLLOW_MOTION:
	   g_signal_handler_block(layout,sigids[FOLLOW_CLICK]);
	   g_signal_handler_unblock(layout,sigids[FOLLOW_MOTION]);
	}
}

static define add_child(layout)
{
   variable child = gtk_image_new_from_stock(GTK_STOCK_EXECUTE,
   					GTK_ICON_SIZE_BUTTON);
   gtk_layout_put(layout,child,20,20);
   return child;
}

static define move_child(layout,event,child)
{
   gtk_layout_move(layout,child,event.x,event.y);
   return TRUE;
}

define create_layout(test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window, "destroy",
				&gtk_widget_destroyed,
				&window);

	gtk_window_set_title(window, "GtkLayout");
	gtk_window_set_default_size(window, 350, 250);

	variable vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,vbox);

	variable rhbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(vbox,rhbox);

	variable frame = gtk_frame_new("Layout");
	gtk_container_add(rhbox,frame);
	variable layout = gtk_layout_new(NULL,NULL);
	gtk_container_add(frame,layout);
	variable child = add_child(layout);

	gtk_widget_add_events(layout,GDK_POINTER_MOTION_MASK);
	sigids[FOLLOW_CLICK] = g_signal_connect(layout,
	      			"button-press-event",&move_child,child);

	sigids[FOLLOW_MOTION] = g_signal_connect(layout,
	      			"motion-notify-event",&move_child,child);
	g_signal_handler_block(layout,sigids[FOLLOW_MOTION]);

	frame = gtk_frame_new("Movement Control");
	gtk_container_add(rhbox,frame);
	variable align = gtk_alignment_new(.5,.5,0.1,0.1);
	gtk_container_add(frame,align);
	variable rvbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(align,rvbox);

	variable rb1 = gtk_radio_button_new_with_label(NULL, "Follow Click");
	variable rb2 = gtk_radio_button_new_with_label(
			gtk_radio_button_get_group(rb1),"Follow Motion");
	gtk_toggle_button_set_active(rb1,TRUE);

	() = g_signal_connect(rb1,"clicked",&set_follow,layout,FOLLOW_CLICK);
	gtk_container_add(rvbox,rb1);
	() = g_signal_connect(rb2,"clicked",&set_follow,layout,FOLLOW_MOTION);
	gtk_container_add(rvbox,rb2);

	variable separator = gtk_hseparator_new();
	gtk_box_pack_start (vbox, separator, FALSE, TRUE, 0);

	variable comment = gtk_label_new("Drag or click mouse within layout"+
		"\nto move its child image around.");
	gtk_box_pack_start (vbox, comment, FALSE, FALSE, 20);

	variable hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(vbox,hbox,FALSE,FALSE,10);

	variable button = gtk_button_new_with_label("    Close    ");
	() = g_signal_connect_swapped(button, "clicked",
					&gtk_widget_destroy,window);
	gtk_box_pack_end(hbox,button,FALSE,FALSE,20);
	test.lower = button;
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
