
% Original C Code Author: Owen Taylor
% Original C Code Copyright (C) 2005  Red Hat, Inc.
% Based on cairo-demo/X11/cairo-knockout.c
% Converted to S-Lang by Michael S. Noble (2005)

private variable window = NULL;

private define oval_path (cr, xc, yc, xr, yr) % {{{
{
  cairo_save (cr);

  cairo_translate (cr, xc, yc);
  cairo_scale (cr, 1.0, yr / xr);
  cairo_move_to (cr, xr, 0.0);
  cairo_arc (cr, 0, 0, xr, 0, 2 * PI);
  cairo_close_path (cr);

  cairo_restore (cr);
} % }}}

private define fill_checks (cr, x, y, width, height) % {{{
% Create a path that is a circular oval with radii xr, yr at xc, yc.
%
% Fill the given area with checks in the standard style for showing
% compositing/transparency effects.
{
  variable CHECK_SIZE=32;

  cairo_rectangle (cr, x, y, width, height);
  cairo_set_source_rgb (cr, 0.4, 0.4, 0.4);
  cairo_fill (cr);

  % Only works for CHECK_SIZE a power of 2 */
  variable j = x & (-CHECK_SIZE);
  
  for (; j < height; j += CHECK_SIZE)
    {
      variable i = y & (-CHECK_SIZE);
      for (; i < width; i += CHECK_SIZE)
	if ((i / CHECK_SIZE + j / CHECK_SIZE) mod 2 == 0)
	  cairo_rectangle (cr, i, j, CHECK_SIZE, CHECK_SIZE);
    }

  cairo_set_source_rgb (cr, 0.7, 0.7, 0.7);
  cairo_fill (cr);
} % }}}

private define draw_3circles (cr, xc, yc, radius, alpha) % {{{
{
  % Draw a red, green, and blue circle equally spaced inside
  % the larger circle of radius r at (xc, yc)

  variable subradius = radius * (2 / 3. - 0.1);
    
  cairo_set_source_rgba (cr, 1., 0., 0., alpha);
  oval_path (cr,
	     xc + radius / 3. * cos (PI * (0.5)),
	     yc - radius / 3. * sin (PI * (0.5)),
	     subradius, subradius);
  cairo_fill (cr);
    
  cairo_set_source_rgba (cr, 0., 1., 0., alpha);
  oval_path (cr,
	     xc + radius / 3. * cos (PI * (0.5 + 2/.3)),
	     yc - radius / 3. * sin (PI * (0.5 + 2/.3)),
	     subradius, subradius);
  cairo_fill (cr);
    
  cairo_set_source_rgba (cr, 0., 0., 1., alpha);
  oval_path (cr,
	     xc + radius / 3. * cos (PI * (0.5 + 4/.3)),
	     yc - radius / 3. * sin (PI * (0.5 + 4/.3)),
	     subradius, subradius);
  cairo_fill (cr);
} % }}}

private define draw (cr, width, height) % {{{
{
  % Fill the background 
  variable xc = width / 2., yc = height / 2., radius;
  if (width < height)
     radius = 0.5* (width - 10);
  else
     radius = 0.5* (height - 10);

  variable target = cairo_get_target(cr);
  variable overlay = cairo_surface_create_similar (target,
					  CAIRO_CONTENT_COLOR_ALPHA,
					  width, height);
  if (overlay == NULL) return;

  variable punch = cairo_surface_create_similar (target,
					CAIRO_CONTENT_ALPHA,
					width, height);
  if (punch == NULL) return;

  variable circles = cairo_surface_create_similar (target,
					  CAIRO_CONTENT_COLOR_ALPHA,
					  width, height);
  if (circles == NULL) return;
    
  fill_checks (cr, 0, 0, width, height);

  % Draw a black circle on the overlay

  variable overlay_cr = cairo_create (overlay);
  cairo_set_source_rgb (overlay_cr, 0., 0., 0.);
  oval_path (overlay_cr, xc, yc, radius, radius);
  cairo_fill (overlay_cr);

  % Draw 3 circles to the punch surface, then cut
  % that out of the main circle in the overlay

  variable punch_cr = cairo_create (punch);
  draw_3circles (punch_cr, xc, yc, radius, 1.0);
  cairo_destroy (punch_cr);

  cairo_set_operator (overlay_cr, CAIRO_OPERATOR_DEST_OUT);
  cairo_set_source_surface (overlay_cr, punch, 0, 0);
  cairo_paint(overlay_cr);

  % Now draw the 3 circles in a subgroup again
  % at half intensity, and use OperatorAdd to join up
  % without seams.

  variable circles_cr = cairo_create (circles);
  
  cairo_set_operator (circles_cr, CAIRO_OPERATOR_OVER);
  draw_3circles (circles_cr, xc, yc, radius, 0.5);
  cairo_destroy (circles_cr);

  cairo_set_operator (overlay_cr, CAIRO_OPERATOR_ADD);
  cairo_set_source_surface (overlay_cr, circles, 0, 0);
  cairo_paint(overlay_cr);

  cairo_destroy (overlay_cr);

  cairo_set_source_surface (cr, overlay, 0, 0);
  cairo_paint(cr);
  cairo_show_page(cr);

  cairo_surface_destroy (overlay);
  cairo_surface_destroy (punch);
  cairo_surface_destroy (circles);
} % }}}

private define expose(widget, event) % {{{
{
  variable cr = gdk_cairo_create (gtk_widget_get_window(widget));
  variable alloc = gtk_widget_get_allocation(widget);

  draw (cr, alloc.width, alloc.height);

  cairo_destroy (cr);
  return FALSE;
} % }}}

#ifexists CAIRO_HAS_PDF_SURFACE % {{{
private define save(widget, event) % {{{
{
  variable file = _input_dialog("File name: ", "Save To File");
  variable cs = cairo_pdf_surface_create(file, 400, 400);
  variable cr = cairo_create(cs);

  draw (cr, 400, 400);

  cairo_destroy (cr);
  cairo_surface_flush(cs);
  cairo_surface_destroy(cs);
} % }}}
#endif % }}}

public define create_cairo(test) % {{{
{
  if (window != NULL) { gtk_widget_destroy (window); window = NULL; return; }

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size (window, 400, 400);
  gtk_window_set_title (window, "cairo: Knockout Groups");

  variable vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add ( window, vbox);

  variable darea = gtk_drawing_area_new ();
  gtk_box_pack_start(vbox, darea, TRUE, TRUE, 0);
  () = g_signal_connect (darea, "expose-event", &expose);
  () = g_signal_connect (window, "destroy-event", &gtk_main_quit);
  () = g_signal_connect(window,"destroy",&gtk_widget_destroyed,&window);

  variable bbox = gtk_hbox_new(TRUE, 0);
  variable button = gtk_button_new_with_label("Save");
#ifexists CAIRO_HAS_PDF_SURFACE
  () = g_signal_connect_swapped(button, "clicked", &save, darea, 1);
#else
   gtk_widget_set_sensitive(button, FALSE);
   vmessage("Cairo PDF support not available, disabling Save button.");
#endif
  gtk_box_pack_start(bbox, button, FALSE, FALSE, 0);

  gtk_box_pack_end(vbox, bbox, FALSE, FALSE, 5);

  button = gtk_button_new_with_label("Quit");
  () = g_signal_connect_swapped(button, "clicked", &gtk_widget_destroy,window);
  gtk_box_pack_end(bbox, button, FALSE, FALSE, 20);
  test.lower = button;

  gtk_widget_show_all (window);
} % }}}
