%  SLgtk: S-Lang language bindings for GTK+ widget set
%
%  Copyright (c) 2003 Massachusetts Institute of Technology
%  Copyright (C) 2002 Michael S. Noble <mnoble@cfa.harvard.edu>
%
%  This software was partially developed by the MIT Center for Space
%  Research under contract SV1-61010 from the Smithsonian Institution.
%  
%  Permission to use, copy, modify, distribute, and sell this software
%  and its documentation for any purpose is hereby granted without fee,
%  provided that the above copyright notice appear in all copies and
%  that both that copyright notice and this permission notice appear in
%  the supporting documentation, and that the name of the Massachusetts
%  Institute of Technology not be used in advertising or publicity
%  pertaining to distribution of the software without specific, written
%  prior permission.  The Massachusetts Institute of Technology makes
%  no representations about the suitability of this software for any
%  purpose.  It is provided "as is" without express or implied warranty.
%  
%  THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
%  WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%  MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
%  INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
%  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
%  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
%  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
%  WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

static variable window = NULL;

define create_textview (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window, "destroy",
				&gtk_widget_destroyed,
				&window);

	gtk_window_set_title(window, "TextView");
	gtk_window_set_default_size(window, 350, 550);

	variable vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,vbox);

	variable scrwin  = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (scrwin, 10);
	gtk_scrolled_window_set_policy (scrwin,
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);

	gtk_box_pack_start(vbox,scrwin,TRUE,TRUE,5);
	variable view = gtk_text_view_new ();
	variable buffer = gtk_text_view_get_buffer (view);

 	variable iter = gtk_text_buffer_get_iter_at_offset(buffer,0);

	variable i, text, tabs = "";
	for (i=0; i < 3; i++) {
	   text = tabs+"TextView example: line "+string(i)+"\n";
	   gtk_text_buffer_insert(buffer,iter,text,-1);
	   tabs = tabs + "\t\t";
	}

	gtk_text_buffer_insert(buffer,iter,"\n"+"Superscripted text:",-1);

	% Note that, unlike in the C api, it is unnecessary (and wrong, even)
	% to terminate the tags name/value property list with NULL
	variable tag = gtk_text_buffer_create_tag (buffer, NULL,
			"rise", 10 * PANGO_SCALE, % 10 pixels
			"size", 8 * PANGO_SCALE  % 8 points
			);
	gtk_text_buffer_insert_with_tags(buffer,iter,"SuPerScriPt",-1,tag);
	tag = gtk_text_buffer_create_tag (buffer, NULL,
			"rise", -10 * PANGO_SCALE, % 10 pixels
			"size", 8 * PANGO_SCALE  % 8 points
			);
	gtk_text_buffer_insert(buffer,iter,"\nSubscripted text:",-1);
	gtk_text_buffer_insert_with_tags(buffer,iter,"subSCRIPT\n\n\n",-1,tag);

	text = "Now for some embedded images.  First, the Gtk logo:\n\n\t\t\t";
	gtk_text_buffer_insert(buffer,iter,text,-1);

	% Notice that it is not necessary to initialize the gerr here, as
	% it is guaranteed to have a legal value (possibly NULL) upon return
	variable gerr;
	variable pixbuf = gdk_pixbuf_new_from_file(
		path_concat(SLGTK_IMAGES_DIR,"gtk-logo-rgb.gif"),&gerr);
	if (pixbuf != NULL) gtk_text_buffer_insert_pixbuf(buffer,iter,pixbuf);

	gtk_text_buffer_insert(buffer,iter,"\nNow a FITS image:\n",-1);
	pixbuf = gdk_pixbuf_new_from_file(
	      	path_concat(SLGTK_IMAGES_DIR,"stars.fits"),&gerr);

	if (pixbuf != NULL)
	   gtk_text_buffer_insert_pixbuf(buffer,iter,pixbuf);
	else
	   vmessage(struct2string(gerr));

	text = sprintf("\nDirectly above you should see a field of bright\n"+
			"stars against a black background.  If not, then\n"+
			"the FITS gdk-pixbuf module must not have been\n"+
			"compiled into Gtk (check terminal for a message).\n"+
			"To compile it, change to the ../contrib/gdk-pixbuf\n"+
			"directory and do a make install."+
			"\n\nNow"+
			"lets try an X pixmap that looks like a \'folder "+
			"open\':\n\t\t\t\t\t\t\t\t");
	gtk_text_buffer_insert(buffer,iter,text,-1);
	pixbuf = gdk_pixbuf_new_from_file(
	      	path_concat(SLGTK_IMAGES_DIR, "test.xpm"),&gerr);

	if (pixbuf != NULL) gtk_text_buffer_insert_pixbuf(buffer,iter,pixbuf);

	text = sprintf("\n\nNow let's try to load a non-existent image:\n");
	gtk_text_buffer_insert(buffer,iter,text,-1);

	pixbuf = gdk_pixbuf_new_from_file("/Yummy/Yummy/In/My.Tummy",&gerr);
	if (pixbuf == NULL)

	   text = strcat("  GOOD: gdk_pixbuf_new_from_file returned NULL.\n"+
			 "  Here's the GError that was returned:\n", 
	   						struct2string(gerr));
	else 
	   text = sprintf("Error: gdk_pixbuf_new_from_file should have\n"+
	   		  "       returned a NULL, but didn't!!!!!!!!!!");

	gtk_text_buffer_insert(buffer,iter,text+"\n\n",-1);

	tag = gtk_text_buffer_create_tag (buffer, "named_tag_with_no_props");
	text = sprintf("\n\nCreate a named tag, without assigning properties:"+
			       "\n    This is legitimate, and as above the "+
			       "\n    tag will be created <%S>, but again"+
			       "\n    produces only normal-looking text.",tag);
	gtk_text_buffer_insert_with_tags(buffer,iter,text,-1,tag);

	gtk_container_add(scrwin,view);
	test.lower = generic_close_button(vbox,window);
  }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
