static variable window = NULL;
static variable selected = 0;

define draw_markers(d,gc,bb)
{
   gdk_draw_rectangle(d,gc,TRUE,bb.x - 1, bb.y - 1, 3, 3);
   gdk_draw_rectangle(d,gc,TRUE,bb.x - 1, bb.y + bb.height - 1, 3, 3);
   gdk_draw_rectangle(d,gc,TRUE,bb.x + bb.width - 1, bb.y - 1, 3, 3);
   gdk_draw_rectangle(d,gc,TRUE,bb.x + bb.width - 1, bb.y + bb.height - 1,3,3);
}

define toggle_selection(darea,event,data)
{
   variable drawable = gtk_widget_get_window(darea);
   variable gc = gdk_gc_new(drawable);
   variable bbox = gdk_rectangle_new(5,5,20,20);

   gdk_gc_set_line_attributes(gc,1,GDK_LINE_ON_OFF_DASH,0,0);
   gdk_gc_set_subwindow(gc,GDK_INCLUDE_INFERIORS);
   selected = not selected;
   !if (selected)
	gdk_gc_set_function(gc,GDK_XOR);

   gdk_draw_rectangle(drawable,gc,FALSE,bbox.x,bbox.y,bbox.width,bbox.height);
   draw_markers(drawable,gc,bbox);

   return TRUE;
}

define draw_graphic(widget,event,data)
{
   variable drawable = gtk_widget_get_window(widget);
   variable gc = gdk_gc_new(drawable);
   gdk_draw_rectangle(drawable,gc,TRUE,5,5,20,20);
   gdk_gc_unref(gc);
   return TRUE;
}

define add_child(layout)
{
   variable darea = gtk_drawing_area_new();
   gtk_drawing_area_size(darea,30,30);
   gtk_widget_set_events (darea,
	 	gtk_widget_get_events(darea) | GDK_BUTTON_PRESS_MASK);

   () = g_signal_connect(darea,"expose-event",&draw_graphic,NULL);
   () = g_signal_connect(darea,"button-press-event",&toggle_selection,NULL);

   gtk_layout_put(layout,darea,20,20);
   return darea;
}
