/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGINTERESTBOARDWIDGET_H
#define SKGINTERESTBOARDWIDGET_H
/** @file
* This file is Skrooge plugin for interest computation.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skginterestpluginwidget_board.h"
#include "skgwidget.h"

class KAction;

/**
 * This file is Skrooge plugin for interest computation
 */
class SKGInterestBoardWidget : public SKGWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    explicit SKGInterestBoardWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGInterestBoardWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

private Q_SLOTS:
    void dataModified(const QString& iTableName = "", int iIdTransaction = 0);

private:
    Q_DISABLE_COPY(SKGInterestBoardWidget);

    Ui::skginterestplugin_board ui;
};

#endif // SKGINTERESTBOARDWIDGET_H
