/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgaccountobject.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"

#include <kaction.h>

#include <QDomDocument>

SKGBankBoardWidget::SKGBankBoardWidget(SKGDocument* iDocument)
    : SKGWidget(iDocument)
{
    SKGTRACEIN(10, "SKGBankBoardWidget::SKGBankBoardWidget");

    ui.setupUi(this);

    //Refresh
    connect((const QObject*) getDocument(), SIGNAL(tableModified(QString,int)), this, SLOT(dataModified(QString,int)), Qt::QueuedConnection);
    connect(ui.kLabel, SIGNAL(linkActivated(QString)), SKGMainPanel::getMainPanel(), SLOT(openPage(QString)));

    dataModified("", 0);
}

SKGBankBoardWidget::~SKGBankBoardWidget()
{
    SKGTRACEIN(10, "SKGBankBoardWidget::~SKGBankBoardWidget");
}

void SKGBankBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEIN(10, "SKGBankBoardWidget::dataModified");
    Q_UNUSED(iIdTransaction);

    if (iTableName == "v_bank" || iTableName.isEmpty()) {
        SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(getDocument());
        if (doc) {
            SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();
            bool exist = false;
            SKGError err = doc->existObjects("account", "", exist);
            if (!err) {
                QString html;
                if (!exist) {
                    html = "<html><body>" % i18nc("Message", "First, you have to create at least one account<br>from <a href=\"skg://Skrooge_bank_plugin/\">\"Bank and Account\"</a> page or <a href=\"skg://import_operation/\">import</a> operations.") % "</body></html>";
                } else {
                    //Build display
                    SKGStringListList listTmp;
                    err = doc->executeSelectSqliteOrder(
                              "SELECT t_name, f_CURRENTAMOUNT  from v_bank ORDER BY t_name",
                              listTmp);
                    if (!err) {
                        html += "<html><body><table>";
                        double sumV1 = 0;
                        int nb = listTmp.count();
                        for (int i = 1; i < nb; ++i) { //Ignore header
                            QString name = listTmp.at(i).at(0);
                            double v1 = SKGServices::stringToDouble(listTmp.at(i).at(1));
                            if (qAbs(v1) > 0.1) {
                                html += QString("<tr><td>") % SKGServices::stringToHtml(name) % "</td>"
                                        "<td align=\"right\">";
                                html += doc->formatMoney(v1, primary);
                                html += "</td></tr>";
                                sumV1 += v1;
                            }
                        }

                        html += "<tr><td><b>" % SKGServices::stringToHtml(i18nc("Noun, the numerical total of a sum of values", "Total")) % "</b></td>"
                                "<td align=\"right\"><b>" % doc->formatMoney(sumV1, primary) % "</b></td>"
                                "</tr>";
                        html += "</table></html>";
                    }
                }
                ui.kLabel->setText(html);
            }
        }
    }
}
#include "skgbankboardwidget.moc"
