/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A collection of widgets for skrooge (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbkwidgetcollectiondesignerplugin.h"
#include "skgquerycreatordesignerplugin.h"
#include "skgpredicatcreatordesignerplugin.h"
#include "skgunitcomboboxdesignerplugin.h"

#include <QtPlugin>

SKGBKWidgetCollectionDesignerPlugin::SKGBKWidgetCollectionDesignerPlugin(QObject *parent)
    : QObject(parent)
{
    m_widgets.append(new SKGQueryCreatorDesignerPlugin(this));
    m_widgets.append(new SKGPredicatCreatorDesignerPlugin(this));
    m_widgets.append(new SKGUnitComboBoxDesignerPlugin(this));
}

QList<QDesignerCustomWidgetInterface*> SKGBKWidgetCollectionDesignerPlugin::customWidgets() const
{
    return m_widgets;
}

Q_EXPORT_PLUGIN2(skroogebkui, SKGBKWidgetCollectionDesignerPlugin)

