/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Scheduled Operations Skroogoid
*
* @author Siddharth SHARMA
*/
#include "scheduledoperationskroogoid.h"

#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgrecurrentoperationobject.h"
#include "skgmainpanel.h"

#include <QGraphicsLinearLayout>

ScheduledOperationSkroogoid::ScheduledOperationSkroogoid(QObject *parent, const QVariantList &args)
    : Plasma::PopupApplet(parent, args)
{

    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300, 300);
    displayLabel = new Plasma::Label();
    QString html;

    gl_layout = new QGraphicsLinearLayout();
    this->setLayout(gl_layout);
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(panel->getDocument());
    SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();
    SKGObjectBase::SKGListSKGObjectBase objs;
    SKGError err = panel->getDocument()->getObjects("v_recurrentoperation_display", "1=1 ORDER BY d_date LIMIT 5", objs);
    if(!err) {
        html = "<html><body>";
        int nb = objs.count();
        if(nb) {
            for(int i = 0; i < nb; ++i) {
                SKGRecurrentOperationObject obj = objs.at(i);
                html += SKGServices::stringToHtml(obj.getDisplayName()) % "<br>";
            }
        } else {
            html += i18nc("Message", "No operation scheduled<br>on the <a href=\"___\">\"Operations\"</a> page.");
        }
        html += "</body></html>";
        displayLabel->setText(html);
        gl_layout->addItem(displayLabel);
    }


}

ScheduledOperationSkroogoid::~ScheduledOperationSkroogoid()
{
}


#include "scheduledoperationskroogoid.moc"
