/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDASHBOARDPLUGINWIDGET_H
#define SKGDASHBOARDPLUGINWIDGET_H
/** @file
 * A dashboard
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgdashboardpluginwidget_base.h"
#include "skgtabpage.h"
#include "skgflowlayout.h"

#include <QList>
#include <QStringList>
#include <QTimer>

class KMenu;
class SKGInterfacePlugin;
class SKGZoomSelector;

/**
 * A dashboard
 */
class SKGDashboardPluginWidget : public SKGTabPage
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGDashboardPluginWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGDashboardPluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject *object, QEvent *event);

public Q_SLOTS:
    /**
    * Refresh the content.
     */
    virtual void refresh();

private Q_SLOTS:
    void showHeaderMenu(const QPoint& pos);
    void onAddWidget();
    void onRemoveWidget();
    void onZoomWidget(int iValue);
    void onMoveAfterWidget();
    void onMoveBeforeWidget();
    void onZoomInWidget();
    void onZoomOutWidget();
    void onShowFloatingPanel();

private:
    Q_DISABLE_COPY(SKGDashboardPluginWidget);

    void addItem(SKGInterfacePlugin* iDashboard, int iIndex, int iZoom = 0, const QString& iState = "");

    Ui::skgdashboardplugin_base ui;
    SKGFlowLayout* m_flowLayout;

    QStringList m_items;
    QList<SKGWidget*> m_itemsPointers;
    QList<int> m_itemsSizes;
    KMenu* m_menu;
    QMenu* m_addMenu;
    QWidget* m_floatingPanel;
    SKGZoomSelector* m_kZoom;
    QTimer m_timer;

    QPoint m_clickedPoint;
    QPoint m_lastPoint;
    int m_currentIndex;
};

#endif // SKGDASHBOARDPLUGINWIDGET_H
