/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a proxy model with better filter mechanism.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgsortfilterproxymodel.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgobjectmodelbase.h"

#include <QRegExp>

SKGSortFilterProxyModel::SKGSortFilterProxyModel ( QObject * parent )
        : QSortFilterProxyModel ( parent )
{
    _SKGTRACEIN ( 10, "SKGSortFilterProxyModel::SKGSortFilterProxyModel" );

    setSortCaseSensitivity ( Qt::CaseInsensitive );
    setSortLocaleAware ( true );
    setFilterKeyColumn ( 0 );
}

SKGSortFilterProxyModel::~SKGSortFilterProxyModel()
{
    _SKGTRACEIN ( 10, "SKGSortFilterProxyModel::~SKGSortFilterProxyModel" );

}

bool SKGSortFilterProxyModel::lessThan(const QModelIndex &left,
                                       const QModelIndex &right) const
{
    //Initialisation
    bool output=QSortFilterProxyModel::lessThan(left, right);

    //Get source
    SKGObjectModelBase* model=dynamic_cast<SKGObjectModelBase*>(this->sourceModel());
    if ( model )
    {
        QVariant leftData = model->data(left, Qt::UserRole);
        QVariant rightData = model->data(right, Qt::UserRole);
        if (leftData==rightData)
        {
            SKGObjectBase leftObj=model->getObject(left);
            SKGObjectBase rightObj=model->getObject(right);
            return (leftObj.getID()<rightObj.getID());
        }
    }
    return output;
}

bool SKGSortFilterProxyModel::filterAcceptsRow ( int source_row, const QModelIndex & source_parent ) const
{
    _SKGTRACEIN ( 10, "SKGSortFilterProxyModel::filterAcceptsRow" );

    //Initialisation
    bool output= ( filterRegExp().isEmpty() );

    if ( !output )
    {
        //Get source
        QAbstractItemModel* model=this->sourceModel();
        if ( model )
        {
            //Correction bug 214097 vvvv
            QStringList words=SKGServices::splitCSVLine ( filterRegExp().pattern(), ' ', true );
            int nbwords=words.count();

            output=true;
            for ( int w=0; output && w<nbwords; ++w )
            {
                QString word=words.at ( w );

                int nbcol=model->columnCount();
                output=false;
                for ( int i=0; !output && i<nbcol; ++i )
                {
                    QModelIndex index0 = model->index ( source_row, i, source_parent );
                    if ( index0.isValid() )
                    {
                        output=model->data ( index0 ).toString().contains ( word , Qt::CaseInsensitive );
                        if ( !output )  output=model->data ( index0, Qt::UserRole ).toString().contains ( word , Qt::CaseInsensitive );
                    }
                }
            }
            //Correction bug 214097 ^^^^

            /*QRegExp regexp(filterRegExp());
            int nbcol=model->columnCount();
            for (int i=0; !output && i<nbcol; ++i) {
                QModelIndex index0 = model->index(source_row, i, source_parent);
                if (index0.isValid()) {
            	    output=(regexp.indexIn(model->data(index0).toString())!=-1);
            	    if (!output)  output=(regexp.indexIn(model->data(index0, Qt::UserRole).toString())!=-1);
                }
            }*/
        }
    }
    return output;
}

