/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"

#include <kglobal.h>
#include <KStandardDirs>

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);

    {
        //Test unit et unitvalue
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        SKGTEST("UNIT:getNbTransaction", document1.getNbTransaction(), 0);
        //Scope of the transaction
        SKGBEGINTRANSACTION(document1, "BANK_T1", err);

        //Create unit
        SKGUnitObject unit1(&document1);
        SKGTESTERROR("UNIT:setName", unit1.setName("UNIT1"), true);
        SKGTESTERROR("UNIT:setSymbol", unit1.setSymbol("F"), true);
        SKGTEST("UNIT:getSymbol", unit1.getSymbol(),"F");
        SKGTESTERROR("UNIT:setCountry", unit1.setCountry("France"), true);
        SKGTEST("UNIT:getSymbol", unit1.getCountry(),"France");
        SKGTESTERROR("UNIT:setInternetCode", unit1.setInternetCode("code Internet"), true);
        SKGTEST("UNIT:getInternetCode", unit1.getInternetCode(),"code Internet");
        SKGTESTERROR("UNIT:setType", unit1.setType(SKGUnitObject::OBJECT), true);
        SKGTEST("UNIT:getType", unit1.getType(),SKGUnitObject::OBJECT);
        SKGTESTERROR("UNIT:setNumberDecimal", unit1.setNumberDecimal(4), true);
        SKGTEST("UNIT:getNumberDecimal", unit1.getNumberDecimal(),4);
        SKGTESTERROR("UNIT:save", unit1.save(), true);

        //Create unit value
        SKGUnitValueObject unitvalue1;
        SKGTESTERROR("UNIT:addUnitValue", unit1.addUnitValue(unitvalue1), true);

        SKGTESTERROR("UNITVALUE:setQuantity", unitvalue1.setQuantity(119999.11), true);
        SKGTESTERROR("UNITVALUE:setDate", unitvalue1.setDate(SKGServices::stringToTime("1970-07-16").date()), true);
        SKGTESTERROR("UNITVALUE:save", unitvalue1.save(), true);

        SKGUnitValueObject unitvalue1bis=SKGUnitValueObject(unitvalue1);
        SKGUnitValueObject unitvalue1ter=SKGUnitValueObject((SKGObjectBase) unitvalue1);

        SKGUnitObject unit_get;
        SKGTESTERROR("UNITVALUE:getUnit", unitvalue1.getUnit(unit_get), true);
        SKGTEST("UNIT:comparison", (unit_get==unit1),true);

        SKGUnitValueObject unitvalue2;
        SKGTESTERROR("UNIT:addUnitValue", unit1.addUnitValue(unitvalue2), true);

        SKGTESTERROR("UNITVALUE:setQuantity", unitvalue2.setQuantity(34.12), true);
        SKGTESTERROR("UNITVALUE:setDate", unitvalue2.setDate(SKGServices::stringToTime("1973-02-04").date()), true);
        SKGTESTERROR("UNITVALUE:save", unitvalue2.save(), true);

        //Retrieve unit
        SKGNamedObject unit2Named;
        SKGTESTERROR("UNIT:getObjectByName", SKGNamedObject::getObjectByName(&document1, "unit", "UNIT1", unit2Named), true);
        SKGUnitObject unit2(unit2Named);

        //Retrieve unit value
        SKGUnitValueObject unitvalue3;
        SKGTESTERROR("UNIT:getLastUnitValue", unit2.getLastUnitValue(unitvalue3), true);

        SKGUnitValueObject unitvalue19700101;
        SKGTESTERROR("UNIT:getUnitValue", unit2.getUnitValue(SKGServices::stringToTime("1970-01-01").date(), unitvalue19700101), true);
        SKGUnitValueObject unitvalue19700716;
        SKGTESTERROR("UNIT:getUnitValue", unit2.getUnitValue(SKGServices::stringToTime("1970-07-16").date(), unitvalue19700716), true);
        SKGUnitValueObject unitvalue19720716;
        SKGTESTERROR("UNIT:getUnitValue", unit2.getUnitValue(SKGServices::stringToTime("1972-07-16").date(), unitvalue19720716), true);
        SKGUnitValueObject unitvalue19730204;
        SKGTESTERROR("UNIT:getUnitValue", unit2.getUnitValue(SKGServices::stringToTime("1973-02-04").date(), unitvalue19730204), true);
        SKGUnitValueObject unitvalue19750204;
        SKGTESTERROR("UNIT:getUnitValue", unit2.getUnitValue(SKGServices::stringToTime("1975-02-04").date(), unitvalue19750204), true);

        //Check unit value
        SKGTEST("UNITVALUE:==", (unitvalue3==unitvalue2), true);
        SKGTEST("UNITVALUE:==", (unitvalue19700101==unitvalue1), true);
        SKGTEST("UNITVALUE:==", (unitvalue19700716==unitvalue1), true);
        SKGTEST("UNITVALUE:==", (unitvalue19720716==unitvalue1), true);
        SKGTEST("UNITVALUE:==", (unitvalue19730204==unitvalue2), true);
        SKGTEST("UNITVALUE:==", (unitvalue19750204==unitvalue2), true);

        SKGTEST("UNITVALUE:getQuantity", unitvalue1.getQuantity()-119999.11,0);
        SKGTEST("UNITVALUE:getQuantity", unitvalue3.getQuantity()-34.12,0);
        SKGTEST("UNITVALUE:getDate", SKGServices::dateToSqlString(QDateTime(unitvalue3.getDate())), "1973-02-04");

        //Check cascading delete
        SKGTESTERROR("UNIT:delete", unit2.remove(), true);

        QStringList oResult;
        SKGTESTERROR("UNIT:getDistinctValues", SKGServices::getDistinctValues(&document1, "unit", "id", oResult), true);
        SKGTEST("UNIT:oResult.size", oResult.size(), 0);

        SKGTESTERROR("UNITVALUE:getDistinctValues", SKGServices::getDistinctValues(&document1, "unitvalue", "rd_unit_id", oResult), true);
        SKGTEST("UNITVALUE:oResult.size", oResult.size(), 0);

    }

    {
        //Test unit et unitvalue
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        SKGTEST("DOC:getPrimaryUnit", document1.getPrimaryUnit().Symbol, "");
        SKGTEST("DOC:getSecondaryUnit", document1.getSecondaryUnit().Symbol, "");
        SKGUnitObject franc(&document1);
        {
            SKGBEGINTRANSACTION(document1, "UNIT_1", err);

            //Create unit
            SKGTESTERROR("FRANC:setName", franc.setName("F"), true);
            SKGTESTERROR("FRANC:setSymbol", franc.setSymbol("F"), true);
            SKGTESTERROR("FRANC:setType", franc.setType(SKGUnitObject::PRIMARY), true);
            SKGTEST("FRANC:getType", franc.getType(),SKGUnitObject::PRIMARY);
            SKGTESTERROR("FRANC:save", franc.save(), true);

            SKGTEST("DOC:getPrimaryUnit", document1.getPrimaryUnit().Symbol, "F");
        }

        SKGTEST("DOC:getPrimaryUnit", document1.getPrimaryUnit().Symbol, "F");
        SKGTEST("DOC:getSecondaryUnit", document1.getSecondaryUnit().Symbol, "");
        SKGTEST("DOC:getSecondaryUnit", document1.getSecondaryUnit().Value, 1);

        {
            SKGBEGINTRANSACTION(document1, "UNIT_2", err);

            SKGUnitObject euro(&document1);
            SKGTESTERROR("EURO:setName", euro.setName("E"), true);
            SKGTESTERROR("EURO:setSymbol", euro.setSymbol("E"), true);
            SKGTESTERROR("EURO:setType", euro.setType(SKGUnitObject::PRIMARY), true);
            SKGTEST("EURO:getType", euro.getType(),SKGUnitObject::PRIMARY);
            SKGTESTERROR("EURO:save", euro.save(), true);

            SKGTESTERROR("FRANC:load", franc.load(), true);
            SKGTEST("FRANC:getType", franc.getType(),SKGUnitObject::SECONDARY);

            SKGTEST("EURO:getType", euro.getType(),SKGUnitObject::PRIMARY);
            SKGTESTERROR("EURO:save", euro.save(), true);
        }

        SKGTEST("DOC:getPrimaryUnit", document1.getPrimaryUnit().Symbol, "E");
        SKGTEST("DOC:getSecondaryUnit", document1.getSecondaryUnit().Symbol, "F");

    }

    {
        //Test unit et unitvalue
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            QStringList units=SKGUnitObject::getListofKnownCurrencies(true);
            foreach(const QString& unit, units) {
                SKGBEGINTRANSACTION(document1, "UNIT_1", err);
                SKGUnitObject unitObj;
                SKGTESTERROR("UNIT:createCurrencyUnit", SKGUnitObject::createCurrencyUnit(&document1, unit, unitObj), true);
            }
            SKGBEGINTRANSACTION(document1, "UNIT_1", err);
            SKGUnitObject unitObj;
            SKGTESTERROR("UNIT:createCurrencyUnit", SKGUnitObject::createCurrencyUnit(&document1, "ZZZZZZZ", unitObj), false);
        }
        document1.dump(DUMPUNIT);
    }

    {
        //Compute unit amount at a date
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        SKGUnitObject unit1(&document1);
        SKGUnitObject unit2(&document1);
        {
            SKGBEGINTRANSACTION(document1, "UNIT", err);
            SKGTESTERROR("UNIT:setName", unit1.setName("U1"), true);
            SKGTESTERROR("UNIT:setSymbol", unit1.setSymbol("U1"), true);
            SKGTESTERROR("UNIT:save", unit1.save(), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2001-01-01").date(), 1), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2006-01-01").date(), 6), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2007-01-01").date(), 7), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2008-01-01").date(), 8), true);

            SKGTESTERROR("UNIT:setName", unit2.setName("U2"), true);
            SKGTESTERROR("UNIT:setSymbol", unit2.setSymbol("U2"), true);
            SKGTESTERROR("UNIT:removeUnit", unit2.removeUnit(), true);
            SKGTESTERROR("UNIT:save", unit2.save(), true);
            SKGTESTERROR("UNIT:setUnit", unit2.setUnit(unit2), false);
            SKGTESTERROR("UNIT:setUnit", unit2.setUnit(unit1), true);
            SKGTESTERROR("UNIT:save", unit2.save(), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U2", SKGServices::stringToTime("2001-02-01").date(), 10), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U2", SKGServices::stringToTime("2006-01-01").date(), 60), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U2", SKGServices::stringToTime("2007-02-01").date(), 70), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U2", SKGServices::stringToTime("2008-01-01").date(), 80), true);
        }

        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2001-01-01").date()), 1);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2001-02-01").date()), 1);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2006-01-01").date()), 6);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2006-02-01").date()), 6);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2007-01-01").date()), 7);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2007-02-01").date()), 7);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2008-01-01").date()), 8);
        SKGTEST("DOC:getAmount", unit1.getAmount(SKGServices::stringToTime("2008-02-01").date()), 8);

        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2001-01-01").date()), 1*10);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2001-02-01").date()), 1*10);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2006-01-01").date()), 6*60);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2006-02-01").date()), 6*60);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2007-01-01").date()), 7*60);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2007-02-01").date()), 7*70);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2008-01-01").date()), 8*80);
        SKGTEST("DOC:getAmount", unit2.getAmount(SKGServices::stringToTime("2008-02-01").date()), 8*80);

        SKGTESTERROR("UNIT:load", unit1.load(), true);
        SKGTESTERROR("UNIT:load", unit2.load(), true);
        SKGTEST("DOC:convert", SKGUnitObject::convert(100 ,unit1, unit1), 100);
        SKGTEST("DOC:convert", SKGUnitObject::convert(100 ,unit1, unit2), 1.25);

        document1.dump(DUMPUNIT);
    }

    {
        //Split unit
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        SKGUnitObject unit1(&document1);
        {
            SKGBEGINTRANSACTION(document1, "UNIT", err);
            SKGTESTERROR("UNIT:setName", unit1.setName("U1"), true);
            SKGTESTERROR("UNIT:setSymbol", unit1.setSymbol("U1"), true);
            SKGTESTERROR("UNIT:save", unit1.save(), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2001-01-01").date(), 100), true);
        }
        {
            SKGBEGINTRANSACTION(document1, "UNIT-SPLIT", err);
            SKGTESTERROR("DOC:getAmount", unit1.split(-2), false);
            SKGTESTERROR("DOC:getAmount", unit1.split(2), true);
        }

        SKGTESTERROR("UNIT:load", unit1.load(), true);
        SKGTEST("UNIT:getAmount", unit1.getAmount(SKGServices::stringToTime("2001-01-01").date()), 50);

    }

    {
        //Unit Daily change
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        SKGUnitObject unit1(&document1);
        {
            SKGBEGINTRANSACTION(document1, "UNIT", err);
            SKGTESTERROR("UNIT:setName", unit1.setName("U1"), true);
            SKGTESTERROR("UNIT:setSymbol", unit1.setSymbol("U1"), true);
            SKGTESTERROR("UNIT:save", unit1.save(), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2009-01-01").date(), 100), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2009-01-02").date(), 105), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", document1.addOrModifyUnitValue("U1", SKGServices::stringToTime("2009-02-01").date(), 110), true);
        }

        SKGTEST("UNIT:getDailyChange", SKGServices::intToString(365*unit1.getDailyChange(SKGServices::stringToTime("2009-01-02").date())), "1825");
        SKGTEST("UNIT:getDailyChange", SKGServices::intToString(365*unit1.getDailyChange(SKGServices::stringToTime("2009-02-01").date())), "80");
    }

    {
        //Unit download
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        SKGUnitObject unit1(&document1);
        {
            SKGBEGINTRANSACTION(document1, "UNIT", err);
            SKGTESTERROR("UNIT:setName", unit1.setName("DS"), true);
            SKGTESTERROR("UNIT:setSymbol", unit1.setSymbol("DS"), true);
            SKGTESTERROR("UNIT:setInternetCode", unit1.setSymbol("DSY.PA"), true);
            SKGTESTERROR("UNIT:save", unit1.save(), true);
            SKGTESTERROR("UNIT:addOrModifyUnitValue", unit1.downloadUnitValue(SKGUnitObject::ALL_DAILY, 20), true);
        }
    }
    //End test
    SKGENDTEST();
}
