/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for SKGDateEdit component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestdateedit.h"
#include "skgdateedit.h"

#include <qtestkeyboard.h>
#include <QTestEventList>

void SKGTESTDateEdit::Test_data()
{
        QTest::addColumn<QTestEventList>("events");
        QTest::addColumn<QDate>("expected");

        //Day
        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Plus);
                list.addKeyClick(Qt::Key_Plus);
                QTest::newRow("++") << list << QDate(1970, 7, 18);
        }

        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Plus);
                list.addKeyClick(Qt::Key_Minus);
                QTest::newRow("+-") << list << QDate(1970, 7, 16);
        }

        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Minus);
                list.addKeyClick(Qt::Key_Minus);
                QTest::newRow("--") << list << QDate(1970, 7, 14);
        }

        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Minus);
                list.addKeyClick(Qt::Key_Plus);
                QTest::newRow("-+") << list << QDate(1970, 7, 16);
        }

        //Month
        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Plus, Qt::ControlModifier);
                list.addKeyClick(Qt::Key_Plus, Qt::ControlModifier);
                QTest::newRow("++ctrl") << list << QDate(1970, 9, 16);
        }

        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Plus, Qt::ControlModifier);
                list.addKeyClick(Qt::Key_Minus, Qt::ControlModifier);
                QTest::newRow("+-ctrl") << list << QDate(1970, 7, 16);
        }

        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Minus, Qt::ControlModifier);
                list.addKeyClick(Qt::Key_Minus, Qt::ControlModifier);
                QTest::newRow("--ctrl") << list << QDate(1970, 5, 16);
        }

        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Minus, Qt::ControlModifier);
                list.addKeyClick(Qt::Key_Plus, Qt::ControlModifier);
                QTest::newRow("-+ctrl") << list << QDate(1970, 7, 16);
        }

        //Today
        {
                QTestEventList list;
                list.addKeyClick(Qt::Key_Equal);
                QTest::newRow("=") << list << QDate::currentDate ();
        }
}

void SKGTESTDateEdit::Test()
{
        QFETCH(QTestEventList, events);
        QFETCH(QDate, expected);

        SKGDateEdit dateEditor;
        dateEditor.setDate(QDate(1970, 7, 16));
        events.simulate(&dateEditor);

        QCOMPARE(dateEditor.date(), expected);
}

QTEST_KDEMAIN( SKGTESTDateEdit, GUI )
#include "skgtestdateedit.moc"
