/* Public domain. */

#include "avltree.h"

struct avltree_iter_s
{
  avlnode_ref s ;
  int (*f) (unsigned int, unsigned int, void *) ;
  void *p ;
} ;

static int avltree_iter_rec (struct avltree_iter_s const *blah, unsigned int r, unsigned int h)
{
  return r ? (!avltree_iter_rec(blah, blah->s[r].left, h+1)
           || !blah->f(blah->s[r].data, h, blah->p)
           || !avltree_iter_rec(blah, blah->s[r].right, h+1)) ? 0 : 1 : 1 ;
}

int avltree_iter (avltree_ref t, int (*f)(unsigned int, unsigned int, void *), void *p)
{
  struct avltree_iter_s blah = { t->x.x.s, f, p } ;
  return avltree_iter_rec(&blah, avltree_root(t), 0) ;
}
