/* Public domain. */

/* MT-unsafe if not HASWAITPID */

#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include "sysdeps.h"
#include "djbunix.h"

#ifdef HASWAITPID

int wait_nohang (int *wstat)
{
  register int r ;
  do
    r = waitpid(-1, wstat, WNOHANG) ;
  while ((r == -1) && (errno == EINTR)) ;
  return r ;
}

int wait_pid (int *wstat, int pid)
{
  register int r ;
  do
    r = waitpid(pid, wstat, 0) ;
  while ((r == -1) && (errno == EINTR)) ;
  return r ;
}

#else

#include "diuint.h"
#include "diuintalloc.h"

static diuintalloc zombies = GEN_ALLOC_ZERO ;

int wait_nohang (int *wstat)
{
  if (!zombies.len) return wait3(wstat, WNOHANG, 0) ;
  *wstat = zombies.s[--zombies.len].right ;
  return (int)zombies.s[zombies.len].left ;
}

int wait_pid (int *wstat, int pid)
{
  int r ;
  {
    register unsigned int i = 0 ;
    for (; i < zombies.len ; i++)
    {
      if ((unsigned int)pid == zombies.s[i].left)
      {
        *wstat = (int)zombies.s[i].right ;
        if (--zombies.len) zombies.s[i] = zombies.s[zombies.len] ;
        return pid ;
      }
    }
  }

  for (;;)
  {
    int w ;
    r = wait(&w) ;
    if (r == pid)
    {
      *wstat = w ;
      break ;
    }
    else if (r == -1)
      if (errno == EINTR) continue ;
      else break ;
    else
    {
      diuint blah = { (unsigned int)r, (unsigned int)w } ;
      if (!diuintalloc_catb(&zombies, &blah, 1)) return -1 ;
    }
  }
  return r ;
}

#endif
