# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: summary of generated outputs and metadata

=end
module SiSU_XML_metadata
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/param"
  include SiSU_Param
  class OAI_PMH
    def initialize(opt)
      @md=SiSU_Param::Parameters.new(opt).get
      @oai_pmh=[]
    end
    def read
      output
    end
    def pre
<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<oai_dc:dc
  xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/
  http://www.openarchives.org/OAI/2.0/oai_dc.xsd">
WOK
    end
    def body
      if @md.full_title                                                            # DublinCore 1 - title
        @oai_pmh << %{  <dc:title xml:lang="en">#{@md.full_title}</dc:title>\n}
        #@oai_pmh << %{  <dc:title xml:lang="en">#{seg_name}#{@md.title}</dc:title>\n}
      end
      if @md.author                                                          # DublinCore 2 - author/creator (author)
        txt=meta_content_clean(@md.author)
        @oai_pmh << %{  <dc:author>#{txt}</dc:author>\n}
      end
      if @md.subject                                                          # DublinCore 3 - subject (us library of congress, eric or udc, or schema???)
        txt=meta_content_clean(@md.subject)
        @oai_pmh << %{  <dc:subject>#{txt}</dc:subject>\n}
      end
      if @md.description                                                      # DublinCore 4 - description
        txt=meta_content_clean(@md.description)
        @oai_pmh << %{  <dc:description>#{txt}</dc:description>\n}
      end
      if @md.publisher                                                        # DublinCore 5 - publisher (current copy published by)
        txt=meta_content_clean(@md.publisher)
        @oai_pmh << %{  <dc:publisher>#{txt}</dc:publisher>\n}
      end
      if @md.contributor                                                      # DublinCore 6 - contributor
        txt=meta_content_clean(@md.contributor)
        @oai_pmh << %{  <dc:contributor>#{txt}</dc:contributor>\n}
      end
      if @md.date                                                             # DublinCore 7 - date year-mm-dd
        @oai_pmh << %{  <dc:date>#{@md.date}</dc:date>\n}
      end
      if @md.date_created                                                     # DublinCore 7 - date.created
        @oai_pmh << %{  <dc:date_created>#{@md.date_created}</dc:date_created>\n}
      end
      if @md.date_issued                                                      # DublinCore 7 - date.issued
        @oai_pmh << %{  <dc:date_issued>#{@md.date_issued}</dc:date_issued>\n}
      end
      if @md.date_available                                                   # DublinCore 7 - date.available
        @oai_pmh << %{  <dc:date_available>#{@md.date_available}</dc:date_available>\n}
      end
      if @md.date_valid                                                       # DublinCore 7 - date.valid
        @oai_pmh << %{  <dc:date_valid>#{@md.date_valid}</dc:date_valid>\n}
      end
      if @md.date_modified                                                    # DublinCore 7 - date.modified
        @oai_pmh <<  %{  <dc:date_modified>#{@md.date_modified}</dc:date_modified>\n}
      end
      if @md.type                                                             # DublinCore 8 - type
        txt=meta_content_clean(@md.type)
        @oai_pmh << %{  <dc:type>#{txt}</dc:type>\n}
      end
      if @md.format                                                           # DublinCore 9 - format
        txt=meta_content_clean(@md.format)
        @oai_pmh << %{  <dc:format>#{txt}</dc:format>\n}
      end
      if @md.identifier                                                       # DublinCore 10 - identifier
        txt=meta_content_clean(@md.identifier)
        @oai_pmh << %{  <dc:identifier>#{txt}</dc:identifier>\n}
      end
      if @md.source                                                           # DublinCore 11 - source
        txt=meta_content_clean(@md.source)
        @oai_pmh << %{  <dc:source>#{txt}</dc:source>\n}
      end
      if @md.language[:name]                                                  # DublinCore 12 - language (English)
        @oai_pmh << %{  <dc:language>#{@md.language[:name]}</dc:language>\n}
      end
      if @md.language_original[:name]
        @oai_pmh << %{  <dc:language>#{@md.language_original[:name]}</dc:language>\n}
      end
      if @md.relation                                                         # DublinCore 13 - relation
        txt=meta_content_clean(@md.relation)
        @oai_pmh << %{  <dc:relation>#{txt}</dc:relation>\n}
      end
      if @md.coverage                                                         # DublinCore 14 - coverage
        txt=meta_content_clean(@md.coverage)
        @oai_pmh << %{  <dc:coverage>#{txt}</dc:coverage>\n}
      end
      if @md.rights                                                           # DublinCore 15 - rights
        txt=meta_content_clean(@md.rights)
        @oai_pmh << %{  <dc:rights>#{txt}</dc:rights>\n}
      end
      if @md.keywords
        txt=meta_content_clean(@md.keywords)
        @oai_pmh << %{  <dc:keywords>#{txt}</dc:keywords>\n}
      end
      @oai_pmh
    end
    def meta_content_clean(content='')
      unless content.nil?
        content.tr!('"',"'")
      end
      content
    end
    def post
      '</oai_dc:dc>'
    end
    def output
      SiSU_Env::SiSU_file.new(@md).mkdir
      oai_pmh=SiSU_Env::SiSU_file.new(@md,@md.fn[:oai_pmh]).mkfile #implement in param
      oai_pmh << pre
      body.each do |x|
        oai_pmh << x
      end
      oai_pmh << post
    end
  end
end
__END__
http://www.openarchives.org/pmh/
http://www.openarchives.org/OAI/2.0/openarchivesprotocol.htm#dublincore
http://es.dublincore.org/documents/usageguide/elements.shtml
http://dublincore.org/documents/dces/
see also http://dublincore.org/documents/dcmes-xml/
#http://www.openarchives.org/OAI/2.0/openarchivesprotocol.htm#dublincore
#sample implementation, e.g. 2
<?xml version="1.0" encoding="UTF-8"?>
<oai_dc:dc
    xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/
    http://www.openarchives.org/OAI/2.0/oai_dc.xsd">
  <dc:title xml:lang="en">Grassmann's space analysis</dc:title>
  <dc:author>Hyde, E. W. (Edward Wyllys)</dc:author>
  <dc:subject>LCSH:Ausdehnungslehre; LCCN QA205.H99</dc:subject>
  <dc:publisher>J. Wiley &amp; Sons</dc:publisher>
  <dc:date>Created: 1906; Available: 1991</dc:date>
  <dc:type>text</dc:type>
  <dc:identifier>http://resolver.library.cornell.edu/math/1796949
     </dc:identifier>
  <dc:language>english</dc:language>
  <dc:rights xml:lang="en">Public Domain</dc:rights>
</oai_dc:dc>
