# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: LaTeX formatting template, unicode utf-8 version, used for pdf

=end
module SiSU_TeX_Pdf
  @@table_pg_break_counter=1
  include SiSU_Viz
  class Format_text_object
    require 'iconv'
    require "#{SiSU_lib}/defaults"
    attr_accessor :string,:string1,:orientation,:url,:dir,:tex
    @@sys=SiSU_Env::System_call.new
    @@tex_backslash="\\\\"
    @@tilde='\\\\\\~' #?? debug crazy
    @@tex_pattern_margin_number=/\\begin\{tiny\}\\hspace\{0mm\}\\end\{tiny\}\{\\marginpar.+?\}\}\}/
    @@tableheader={
      'a4' => { :p => 0, :l => 0 },
      'a5' => { :p => 0, :l => 0 },
      'b5' => { :p => 0, :l => 0 },
      'letter' => { :p => 0, :l => 0 },
      'legal' => { :p => 0, :l => 0 }
    }
    @@sys=SiSU_Env::System_call.new
    @@dp=nil
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class == Hash
        @txt =t_o[:txt]            || nil
        @title =t_o[:title]        || nil
        @subtitle =t_o[:subtitle]  || nil
        @ps =t_o[:paper_size]      || nil
        @ocn =t_o[:ocn]            || nil
        @words =t_o[:words]        || nil
      #elsif t_o.class == Array
      #  @txt =txt[0]
      #elsif t_o.class == String
      #  @txt =txt
      else
        p t_o.class
        p caller
      end
      if defined? @md.image \
      and @md.image =~/center/
        @center_begin,@center_end='\begin{center}','\end{center}'
      else @center_begin,@center_end='',''
      end
      @start_table=''
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      @tx=SiSU_Env::Get_init.instance.tex
      @url_brace=SiSU_Viz::Skin.new.url_decoration
      @tex2pdf=@@tex3pdf ||=SiSU_Env::System_call.new.tex2pdf_engine
    end
    def longtable_landscape
      @end_table='\end{longtable}'
      @row_break='\\\\\\'
      if @txt[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:tc_p]}\\~(\d+;\w\d+;\w\d+)#{Mx[:gr_c]}/u]
        no_of_cols,cols_width,ocn=$1,$2,$3
        tw=case @ps
        when /a4/i;      @tx.a4.landscape.w     #European default, SiSU default
        when /letter/i;  @tx.letter.landscape.w #U.S. default
        when /legal/i;   @tx.legal.landscape.w  #U.S. alternative
        when /book|b5/i; @tx.b5.landscape.w     #book default - larger
        when /a5/i;      @tx.a5.landscape.w
        else             @tx.a4.landscape.w     #default currently A4
        end
        textwidth=(tw.to_i/2) - 24
        @@tableheader[@ps][:l]=1 if @txt =~/#{Mx[:gr_o]}Th/
        w=cols_width.split(/;\s*/)
        @@number_of_cols=no_of_cols ||=@@number_of_cols
        @colW=[]
        @colW << '{'
        w.each  do |x|
          x.strip!
          x=(x.to_i * textwidth)/100
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "p{#{col_w}mm}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @start_table="#{Mx[:id_o]}~#{ocn}#{Mx[:id_c]}\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{tiny}\n\\begin{longtable}#@colW\n"
        @txt.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:tc_p]}\\~\d+;\w\d+;\w\d+#{Mx[:gr_c]}/u,"#@start_table")
      end
      if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @txt.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/," #@end_table\n\\end{tiny}")
      end
      @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
      if @@tableheader[@ps][:l] == 1
        if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_p]})/u
          tablefoot=@txt[/\<!f(.+?)!\>/,1]
          @txt.gsub!(/\<!f(.+?)!\>/,'')
          @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_c]})/u,'\bfseries \1&')
          @txt.gsub!(/&\s*$/," #@row_break \\hline\\endhead #@row_break")
          @txt="#@txt \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader[@ps][:l]=0
        end
      else
        if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_c]})/u
          @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_c]})/u,'\1&')
          @txt.gsub!(/&\s*$/," #@row_break")
        end
      end
      @txt=if ocn; "#{Mx[:id_o]}~#{ocn}#{Mx[:id_c]}" + @txt
      else @txt
      end
    end
    def longtable_portrait
      @end_table='\end{longtable}'
      @row_break='\\\\\\'
      if @txt[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:tc_p]}\\~(\d+;\w\d+;\w\d+)#{Mx[:gr_c]}/u]
        no_of_cols,cols_width,ocn=$1,$2,$3
        tw=case @ps
        when /a4/i;      @tx.a4.portrait.w     #European default, SiSU default
        when /letter/i;  @tx.letter.portrait.w #U.S. default
        when /legal/i;   @tx.legal.portrait.w  #U.S. alternative
        when /book|b5/i; @tx.b5.portrait.w     #book default - larger
        when /a5/i;      @tx.a5.portrait.w
        else             @tx.a4.portrait.w     #default currently A4
        end
        textwidth=tw.to_i - 20
        @@tableheader[@ps][:p]=1 if @txt =~/#{Mx[:gr_o]}Th/
        w=cols_width.split(/;\s*/)
        @@number_of_cols=no_of_cols ||=@@number_of_cols
        @colW=[]
        @colW << '{'
        w.each  do |x|
          x.strip!
          x=(x.to_i * textwidth)/100 #x=(x.to_i/100.0 * 160)
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "p{#{col_w}mm}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @start_table="#{Mx[:id_o]}~#{ocn}#{Mx[:id_c]}\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{tiny}\n\\begin{longtable}#@colW\n"
        @txt.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:tc_p]}\\~\d+;\w\d+;\w\d+#{Mx[:gr_c]}/u,@start_table)
      end
      if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @txt.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/," #@end_table\n\\end{tiny}")
      end
      @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
      if @@tableheader[@ps][:p] == 1
        if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_p]})/u
          tablefoot=@txt[/\<!f(.+?)!\>/,1]
          @txt.gsub!(/\<!f(.+?)!\>/,'')
          @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_c]})/u,'\bfseries \1&')
          @txt.gsub!(/&\s*$/," #@row_break \\hline\\endhead #@row_break")
          @txt="#@txt \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader[@ps][:p]=0
        end
      else
        if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_c]})/u
          @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_c]})/u,'\1&')
          @txt.gsub!(/&\s*$/," #@row_break")
        end
      end
      @txt=if ocn; "#{Mx[:id_o]}~#{ocn}#{Mx[:id_c]}" + @txt
      else @txt
      end
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable that are not included yet here,
      # so until synced is broken on some input files, work needs to be done if is to work as before
      @end_table="\\end{tabular}"
      @row_break='\\\\\\\\'
      @break_page="#@row_break\n#@row_break \n"
      if @txt[/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c(\d+);(.+?)#{Mx[:gr_c]}/u]
        no_of_cols,cols_width=$1,$2
        @w=cols_width.split(/;\s*/)
        @colW=[]
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @start_table="\\begin{tabular}{#@colW}\n"
        @txt.gsub!(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s+c\d+?;.+#{Mx[:gr_c]}/u,"#@start_table}")
      end
      if @txt =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        @txt.gsub!(/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/,"#@end_table")
        @@table_pg_break_counter=1
      end
      if @txt =~/#{Mx[:tc_o]}#{Mx[:tc_p]}/u
        if @@table_pg_break_counter == 28 # taken from 34 ideal for portrait to 28 which suits landscape
          @txt="\n\n#@end_table \n#@break_page#@start_table\n"
          @@table_pg_break_counter=1
        else
          @txt.gsub!(/#{Mx[:tc_o]}#{Mx[:tc_p]}/u,'')
          @@table_pg_break_counter+=1
          tablefoot=@txt[/\<!f(.+?)!\>/,1]
          @txt.gsub!(/\<!f(.+?)!\>/,'')
        end
      end
      if @txt =~/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_p]})/u
        @txt.gsub!(/#{Mx[:tc_p]}\d+?#{Mx[:tc_p]}(.+?)(?:#{Mx[:tc_p]}|#{Mx[:tc_p]})/u,"\\1&")
        @txt.gsub!(/&\s*$/,"#@row_break")
      end
      @txt
    end
    def heading_major(para,lev) #\emph{
      title=@md.title
      para.strip! if para
      para.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=para.dup
      cont_ln.gsub!(@@tex_pattern_margin_number,'')
      cont_ln.gsub!(/#{Mx[:lv_o]}#{lev}:\S*?#{Mx[:lv_c]}\s*/,'')
      if para =~/\\[Ff]ootnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      para.gsub!(/(#{@md.lev}.*)\n?$/m, #apparently not used @md.lev does not exist
        "\\part*{\\1}
\\addcontentsline{toc}{section}{#{cont_ln}}
\\markboth{#{title}}\n") if (para !~/#{Mx[:lv_o]}#{lev}:/)
      para.gsub!(/^#{Mx[:lv_o]}#{lev}:\S*?#{Mx[:lv_c]}\s*(.*)\n?$/m,
        "\\part*{\\1}
\\addcontentsline{toc}{section}{#{cont_ln}}
\\markboth{#{title}}\n")
para
    end
    def level1
      heading_major(@txt,1)
    end
    def level2
      heading_major(@txt,2)
    end
    def level3
      heading_major(@txt,3)
    end
    def level4
      @txt.strip! if @txt
      @txt.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@txt.dup
      cont_ln.gsub!(@@tex_pattern_margin_number,'')
      cont_ln.gsub!(/#{@@tex_backslash*2}/,"#{@@tex_backslash*4}") # added w42
      cont_ln.gsub!(/#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}\s*/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      title=@md.title
      @txt.gsub!(/#{@md.lv4}\s+(#{@md.lv4})/m,'\1')
      if @txt =~/#{Mx[:lv_o]}4:endnotes#{Mx[:lv_c]}|<:4-endnotes>/
        # watch exclusion removes endnotes marker from pdf 2003w03
        @txt.gsub!(/.+/m,'')
      end
      if @txt =~/\\footnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      if @txt !~/#{Mx[:lv_o]}4:/
        @txt.gsub!(/(#{@md.lv4}.*)\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsection}{#{cont_ln}}
\\markright{#{title}}")
      else
        @txt.gsub!(/^\s*#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}\s*(.*)?\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsection}{#{cont_ln}}
\\markright{#{title}}")
      end
      @txt.gsub!(/#{@md.lv4}\s*(.marginpar)/m,'\1')
    end
    def level5
      # there is a problem here with creation of headers does not do what you would want it to header starts with a * and is not in bold work on \\@txt*, same for next section 2002w46
      @txt.strip! if @txt
      @txt.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@txt.dup
      cont_ln.gsub!(@@tex_pattern_margin_number,'')
      cont_ln.gsub!(/#{Mx[:lv_o]}5:\S*?#{Mx[:lv_c]}\s*/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\\&/,' and ') #revisit: tmp bugfix 200507, substitutes & with 'and' in toc, needed e.g. for AT&T, see ffa
      @txt.gsub!(/#{@md.lv5}\s+(#{@md.lv5})/m,'\1')
      if @txt =~/\\footnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      if @txt !~/#{Mx[:lv_o]}5:/
        @txt.gsub!(/(#{@md.lv5}.*?)\n?$/m,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsubsection}{#{cont_ln} \\\\
}")
      else
        @txt.gsub!(/^\s*#{Mx[:lv_o]}5:\S*?#{Mx[:lv_c]}\s*(.*)?\n?$/m,
          "\\subsubsection*{\\1}
\\addcontentsline{toc}{subsubsection}{#{cont_ln} \\\\
}")
      end
      @txt.gsub!(/#{@md.lv5}\s*(.marginpar)/m,'\1')
    end
    def level6
      # there is a problem here with creation of headers does not do what you would want it to header starts with a * and is not in bold work on \\sub@txt*, same for previous section 2002w46
      @txt.strip! if @txt
      @txt.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@txt.dup
      cont_ln.gsub!(@@tex_pattern_margin_number,'')
      cont_ln.gsub!(/#{Mx[:lv_o]}6:\S*?#{Mx[:lv_c]}\s*/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      @txt.gsub!(/#{@md.lv6}\s+(#{@md.lv6})/m,'\1')
      if @txt =~/\\footnote/ #and para =~/^[1-6]#{@@tilde}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ')
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\d*\}\{%\n .+? \}\s*/,' ')
      end
      @txt.gsub!(/(#{@md.lv6}.*)\n?$/m,
        "\\subsubsection*{\\1}") if (@txt !~/#{Mx[:lv_o]}6:/)
      @txt.gsub!(/^\s*#{Mx[:lv_o]}6:\S*?#{Mx[:lv_c]}\s*(.*)?\n?$/m,
        '\subsubsection*{\1}')
      @txt.gsub!(/#{@md.lv6}\s*(.marginpar)/m,'\1')
      #end BUGWATCH
    end
    def indent(lev)
      indent=case lev
      when /1/; '0mm'
      when /2/; '10mm'
      when /3/; '20mm'
      when /4/; '30mm'
      when /5/; '40mm'
      when /6/; '50mm'
      when /7/; '60mm'
      when /8/; '70mm'
      when /9/; '80mm'
      end
      @txt.gsub!(/#{Mx[:pa_o]}:i#{lev}#{Mx[:pa_c]}\s*(.*)/m,
        "\\begin{ParagraphIndent}{#{indent}}\\1
\\end{ParagraphIndent}}")
    end
    def symbol_graphic
      dir=SiSU_Env::Info_env.new(@md.fns)
      image='c_' + /<:=\s*(\S+?)\s*>/m.match(@txt).captures.join + '.png' #watch
      if FileTest.file?("#{dir.path.image_source_tex}/#{image}")
        @txt.gsub!(/<:=\s*(\S+?)\s*>/,
          "\\includegraphics*[width=11pt]{#{dir.path.image_source_tex}/c_\\1.png}")
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search path: #{dir.path.image_source_tex}")
        tell.error2 unless @md.cmd =~/q/
        @txt.gsub!(/#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+/,'') # fragile match operator\\ fragile !
      end
    end
    def image
      dir=SiSU_Env::Info_env.new(@md.fns)
      image,m=/#{Mx[:lnk_o]}\s*(\S+)\s+.+?width=``(\d+)''.+?#{Mx[:lnk_c]}/m.match(@txt).captures
      width=m[1] || '100'
      width=width.to_i*0.4
      image_source=if @md.fns =~/\.(?:ssm\.)?sst$/ \
      and FileTest.file?("#{dir.path.image_source_local_tex}/#{image}")
        dir.path.image_source_local_tex
      elsif @md.fns =~/\.-ss[tm]$/ \
      and FileTest.file?("#{dir.path.image_source_remote_tex}/#{image}")
        dir.path.image_source_remote_tex
      elsif FileTest.file?("#{dir.path.image_source_tex}/#{image}")
        dir.path.image_source_tex
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search locations: #{dir.path.image_source_local_tex},#{dir.path.image_source_remote_tex} and #{dir.path.image_source_tex}")
        tell.error2 unless @md.cmd =~/q/
        nil
      end
      if image_source
        @txt.gsub!(/#{Mx[:lnk_o]}\s*((?:https?|file|ftp):\/\/\S+)\s+(\S+).+?#{Mx[:lnk_c]}/,
          @center_begin + "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{image_source}/\\2}}" + @center_end )
        @txt.gsub!(/#{Mx[:lnk_o]}\s*(\S+)\s+.+?#{Mx[:lnk_c]}/,
          @center_begin + "\\includegraphics*[width=#{width}pt]{#{image_source}/\\1}" + @center_end )
      else @txt.gsub!(/#{Mx[:lnk_o]}\s*(\S+)\s+.+?#{Mx[:lnk_c]}/,'\1}')
      end
    end
    def png #fc missing image check
      dir=SiSU_Env::Info_env.new(@md.fns)
      # messy clean up
      z=@txt[/#{Mx[:lnk_o]}(\S.+?)#{Mx[:lnk_c]}(?:image|png)/,1].strip if @txt =~ /#{Mx[:lnk_o]}\S.+?#{Mx[:lnk_c]}(?:image|png)/ # match operator for z \\ fragile !
      if z #debug 2004w14
        image=z[/(\S+?\.(?:png|jpg|gif)\b)/m]
        image.gsub!(/\\/,'')
        width=if z =~ /\d+x\d*/
          w=(z[/(\d+)x\d*/,1]).to_i
          w*0.8
        else '100' #revisit, is bug for small images/icons
        end
        width='380' if width.to_i > 380
        c=z[/``(.+?)''/m]
      end
      hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
      caption="{\\\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}" if c
      image_source=if @md.fns =~/\.(?:ssm\.)?sst$/ \
      and FileTest.file?("#{dir.path.image_source_local_tex}/#{image}")
        dir.path.image_source_local_tex
      elsif @md.fns =~/\.-ss[tm]$/ \
      and FileTest.file?("#{dir.path.image_source_remote_tex}/#{image}")
        dir.path.image_source_remote_tex
      elsif FileTest.file?("#{dir.path.image_source_tex}/#{image}")
        dir.path.image_source_tex
      else
        unless image.nil? \
        or image.length < 2
          tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search locations: #{dir.path.image_source_local_tex},#{dir.path.image_source_remote_tex} and #{dir.path.image_source_tex}")
          tell.error2 unless @md.cmd =~/q/
        end
        nil
      end
      if image_source
        @txt.gsub!(/#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}(image|png)/, # fragile match operator\\ fragile !
          "#@center_begin\n\\includegraphics*[width=#{width}pt]{#{image_source}/#{image}}#{caption}#@center_end")
      else @txt.gsub!(/#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}(image|png)/,'')
      end
    end
    def http_word_mode #(orientation='')
      # clean up ! - work area, testing
      dir=SiSU_Env::Info_env.new(@md.fns)
      @w=[]
      @url_generic_rgx=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+/
      @words.each do |word|
        @w << if word=~@url_generic_rgx
          if word =~/#{Mx[:lnk_o]}(?:.+?)#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?(?:[;.,]?(?:\s|$)|(?:\s|$))/
            regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)(?:[;.,]?(?:\s|$)|(?:\s|$))/
            punctuate=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?([;.,]?(?:\s|$))/.match(word).captures.join
          else
            regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}((?:https?|file|ftp):\S+)/
            punctuate=''
          end
          z,url=regx_url.match(word).captures if word =~regx_url
          url=url.strip
          if word =~/#{Mx[:lnk_o]}\s*\S+\.?(?:png|jpg|gif)/ \
          and word=~/\s+\d+x\d+(\s+|\s*#{Mx[:lnk_c]})/
            image,x,y=z.scan(/\S+/)
            image.gsub!(/\\/,'')
            width=if z =~/(\d+)x\d*/
              z[/(\d+)x\d*/,1]
            else 200
            end
            dm=case @ps # @md.papersize
            when /a4/;     @tx.a4.landscape.img_px
            when /letter/; @tx.letter.landscape.img_px
            when /legal/;  @tx.legal.landscape.img_px
            when /b5/;     @tx.b5.landscape.img_px
            when /a5/;     @tx.a5.landscape.img_px
            else           @tx.a4.landscape.img_px
            end
            width=if width.to_i > dm
              dm
            else width
            end
            c=z[/``(.+?)''/m,1]
            hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
            caption=if c
              "{\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}"
            else ''
            end
          elsif word =~/#{Mx[:lnk_o]}\s*(\S+\.?\.(?:png|jpg|gif))/
            tell=SiSU_Screen::Ansi.new(@md.cmd,%{document built without image: "#{$1}" as image dimensions not provided (& librmagick-ruby is not installed)?\n})
            tell.print_grey #unless @opt.cmd =~/q/
          end
          word=if image #most images fc etc. #% clean up !
            word=if @md.fns =~/\.(?:ssm\.)?sst$/ \
            and FileTest.file?("#{dir.path.image_source_local_tex}/#{image}")
              word=if word =~ /(#{Mx[:lnk_o]}[a-zA-Z0-9_\\]+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+)/
                "#@center_begin\\\n\\href{#{url}}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_local_tex}/#{image}}}#{caption} #@center_end"
              end
              word
            elsif @md.fns =~/\.-ss[tm]$/ \
            and FileTest.file?("#{dir.path.image_source_remote_tex}/#{image}")
              word=if word =~ /(#{Mx[:lnk_o]}[a-zA-Z0-9_\\]+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+)/
                "#@center_begin\\\n\\href{#{url}}{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_remote_tex}/#{image}}}#{caption}#@center_end"
              end
              word
            elsif FileTest.file?("#{dir.path.image_source_tex}/#{image}")
              word=if word =~/(#{Mx[:lnk_o]}[a-zA-Z0-9_\\]+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+)/
                "#@center_begin\\\n\\href{#{url}}\n{\\includegraphics*[width=#{width}pt]{#{dir.path.image_source_tex}/#{image}}}#{caption}#@center_end"
              end
              word
            else
              tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{image}" missing},"search locations: #{dir.path.image_source_local_tex},#{dir.path.image_source_remote_tex} and #{dir.path.image_source_tex}")
              tell.error2 unless @md.cmd =~/q/
              word='' if word =~ /#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+/
              word
            end
          else
            link=z.strip #[/(.+?)\\/m,1]
            word="\\href{#{url}}{#{link}}#{punctuate}" if word =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:https?|file|ftp):\/\/\S+/
            word
          end
        else word
        end
      end
      @txt=@w.join
      @txt
    end
    def http
      wm=@txt.dup.scan(/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\S+|image)|\w+\s*|./m)
      txt_obj={:words =>wm,:paper_size =>@ps}
      @txt=SiSU_TeX_Pdf::Format_text_object.new(@md,txt_obj).http_word_mode #GET PAPER SIZE AND USE IT
    end
    def title
      @txt=SiSU_TeX_Pdf::Special_characters.new(@md,@title).special_characters_safe
      if @subtitle
        @subtitle=SiSU_TeX_Pdf::Special_characters.new(@md,@subtitle).special_characters_safe
        @subtitle.gsub!(/\$/,"\\$")
        "\n\\title{#@title#{@@tex_backslash*2} \\textbf{\\normalsize #@subtitle}\\normalsize}"
      else "\n\\title{#@txt}"
      end
    end
    def title_landscape
      title
    end
    def title_portrait
      title
    end
    def para_num
      paranumber_display=if @md.markup.inspect =~/no_ocn/ \
      or @md.mod.inspect =~/--no-ocn/
        ''
      else "\\begin{tiny}\\hspace{0mm}\\end{tiny}{\\marginpar{\\begin{tiny}#@ocn\\end{tiny}}}" #ocn object citation numbering
      end
      if @txt !~/^(?:#{Mx[:lv_o]}[1-6a-z-]:|#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]}|<:.+?>|#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6})/
        @txt.gsub!(/^\s*(.+)/m,"#{paranumber_display}\\1\n") #watch - in 1-6 is suspect
      else
        if (@txt =~/^(?:#{Mx[:lv_o]}[1-6a-z-]:|#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})/) #watch - in 1-6 is suspect
          @txt.gsub!(/^(#{Mx[:lv_o]}[1-6a-z-]:\S*?#{Mx[:lv_c]})\s*(.+)/m,"\\1 #{paranumber_display}\\2\n") #watch - in 1-6 is suspect
          #@txt.gsub!(/^(#{Mx[:lv_o]}[1-6a-z-]:\S*?#{Mx[:lv_c]})\s*(.+)/m,"\\1 #{paranumber_display} \\begin{bfseries}\\2 \\end{bfseries}\n") #watch - in 1-6 is suspect
          #@txt.gsub!(/^(#{Mx[:lv_o]}[1-6a-z-]:\S*?#{Mx[:lv_c]})\s*(.+)/m,"\\1 #{paranumber_display} \\emph{\\2}\n") #watch - in 1-6 is suspect
          @txt.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})\s*(.+)/m,"\\1 #{paranumber_display}\\2\n") #WHAT?
          #@txt.gsub!(/^(<:.+?>)\s*(.+)/m,"\\1 #{paranumber_display}\\2\n") #WHAT?
        else
          @txt.gsub!(/((#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6}).+)$/,"\\2 #{paranumber_display} \\1\n")
          #@txt.gsub!(/((#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6}).+)$/,"\\2 #{paranumber_display} \\begin{bfseries}\\1 \\end{bfseries}\n")
          #@txt.gsub!(/((#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6}).+)$/,"\\2 #{paranumber_display}\\emph{\\1}\n")
        end
      end
      @txt
    end
  end
  class Format_head
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class==Hash
        @txt =t_o[:txt]            || nil
        #@title =t_o[:title]        || nil
        @subtitle=t_o[:subtitle]   || nil
        @ps=t_o[:paper_size]       || nil
        @ocn=t_o[:ocn]             || nil
        @layout=t_o[:orientation]  || nil
      #elsif t_o.class == Array
      #  @txt =txt[0]
      #elsif t_o.class == String
      #  @txt =txt
      else
        p t_o.class
        p caller
      end
      @tx=SiSU_Env::Get_init.instance.tex
      @url_brace=SiSU_Viz::Skin.new.url_decoration
      @tex2pdf=@@tex3pdf ||=SiSU_Env::System_call.new.tex2pdf_engine
      @ps=@txt if @txt=~/(?:a4|letter|legal|book|a5|b5)/i
    end
    def language
      @lang=if @md.language[:code]
        case @md.language[:code]
        when 'en'; 'english'
        when 'us'; 'USenglish' # depreciated, see iso-639-2
        when 'fr'; 'french'
        when 'de'; 'ngerman'
        when 'it'; 'italian'
        when 'es'; 'spanish'
        when 'pt'; 'portuges'
        #when 'br'; 'brazilian' # depreciated, see iso-639-2
        when 'sv'; 'swedish'
        when 'da'; 'danish'
        when 'fi'; 'finnish'
        when 'no'; 'norske,nynorsk'
        when 'is'; 'icelandic'
        when 'nl'; 'dutch'
        when 'et'; 'estonian'
        when 'hu'; 'magyar'
        when 'pl'; 'polish'
        when 'ro'; 'romanian'
        when 'ru'; 'russian'
        when 'gl'; 'greek'
        when 'uk'; 'ukrainian'
        when 'tr'; 'turkish'
        when 'sk'; 'slovak'
        when 'sl'; 'slovenian'
        when 'hr'; 'croatian'
        when 'cs'; 'czech'
        when 'bg'; 'bulgarian'
        else       'english'
        end
      else         'english'
      end
    end
    def tex_head_lang #babel 18n
      language
      #@md.language[:name]
      lang=if @lang =~/^(?:en)$/; @lang
      else "#@lang,english"
      end
    end
    def tex_head_encode
      case @tex2pdf
      when /xe/
        <<WOK
\\usepackage{babel}
\\usepackage{ucs}
\\usepackage{fontspec}
\\usepackage{xunicode}
WOK
      when /pdf/
        if @md.file_encoding =~ /iso-?8859/i                                                         #% iso8859
        <<WOK
% \\usepackage[latin1]{inputenc}
\\usepackage{fontspec}
WOK
        else                                                                      #% utf-8 assumed
        <<WOK
\\usepackage{babel}
\\usepackage{ucs}
\\usepackage[utf8x]{inputenc}
WOK
        end
      end
    end
    def tex_head_info
      generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
      lastdone="Last Generated on: #{Time.now}"
      rubyv="Ruby version: #{@md.ruby_version}"
      <<WOK
%% SiSU (Linux & Ruby - \"better ways\") LaTeX output
%% #{generator}
%% #{rubyv}
%% LaTeX output
%% #{lastdone}
%% SiSU http://www.jus.uio.no/sisu
WOK
    end
    def tex_head_paper_portrait(d)
      <<WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},#{tex_head_lang},titlepage]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm}  \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}}  \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}}  \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
WOK
    end
    def tex_head_paper_landscape(d)
      <<WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},#{tex_head_lang},landscape,titlepage,twocolumn]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm}  \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}}  \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}}  \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\columnsep}{#{d[:columnsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
WOK
    end
    def tex_head_paper_portrait_dvi(d)
      <<WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},#{tex_head_lang},titlepage]{scrartcl}      %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm}  \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}}  \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}}  \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
WOK
    end
    def tex_head_paper_dimensions
      d={}
      case @layout
      when /portrait/
        #textheight,textwidth=@tx.a4.portrait.h,@tx.a4.portrait.w
        d[:papertype],d[:fontsize]='a4paper','11pt'
        d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='0mm','0mm','-12pt'
        d[:headheight],d[:headsep],d[:columnsep]='12pt','35pt',''
        d[:marginparsep],d[:marginparwidth]='4mm','8mm'
        case @ps #@md.papersize
        when /a4/i           #European default, SiSU default
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.portrait.h,@tx.a4.portrait.w
        when /letter/i   #U.S. default
          d[:papertype],d[:fontsize]='letterpaper','12pt'
          d[:textheight],d[:textwidth]=@tx.letter.portrait.h,@tx.letter.portrait.w
        when /legal/i     #U.S. alternative
          d[:papertype],d[:fontsize]='legalpaper','12pt'
          d[:textheight],d[:textwidth]=@tx.legal.portrait.h,@tx.legal.portrait.w
        when /book|b5/i   #book default - larger
          d[:papertype],d[:fontsize]='b5paper','11pt'
          d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='-4mm','-4mm','-36pt'
          d[:headheight],d[:headsep],d[:columnsep]='12pt','20pt',''
          d[:textheight],d[:textwidth]=@tx.b5.portrait.h,@tx.b5.portrait.w
        when /a5/i
          d[:papertype],d[:fontsize]='a5paper','11pt'
          d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='-4mm','-4mm','-36pt'
          d[:headheight],d[:headsep],d[:columnsep]='8pt','12pt',''
          d[:marginparsep],d[:marginparwidth]='4mm','6mm'
          d[:textheight],d[:textwidth]=@tx.a5.portrait.h,@tx.a5.portrait.w
        else           #default currently A4
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.portrait.h,@tx.a4.portrait.w
        end
      when /landscape/
        #d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        d[:papertype],d[:fontsize]='a4paper','11pt'
        d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='6mm','6mm','-12mm'
        d[:headheight],d[:headsep],d[:columnsep]='12pt','20pt','40pt'
        d[:marginparsep],d[:marginparwidth]='4mm','8mm'
        case @ps #@md.papersize
        when /a4/i                            #European default, SiSU default
          d[:papertype],d[:fontsize]='a4paper','11pt'
          d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        when /letter/i                    #U.S. default
          d[:papertype],d[:fontsize]='letterpaper','11pt'
          d[:textheight],d[:textwidth]=@tx.letter.landscape.h,@tx.letter.landscape.w
        when /legal/i #U.S. alternative
          d[:papertype],d[:fontsize],d[:columnsep]='legalpaper','11pt','48pt'
          d[:textheight],d[:textwidth]=@tx.legal.landscape.h,@tx.legal.landscape.w
        when /book|b5/i       #book default - larger
          d[:papertype],d[:fontsize],d[:columnsep]='b5paper','11pt','35pt'
          d[:textheight],d[:textwidth]=@tx.b5.landscape.h,@tx.b5.landscape.w
        when /a5/i
          d[:papertype],d[:fontsize],d[:columnsep]='a5paper','10pt','32pt'
          d[:textheight],d[:textwidth]=@tx.a5.landscape.h,@tx.a5.landscape.w
        else                            #default currently A4
          d[:papertype],d[:fontsize]='a4paper','12pt'
          d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        end
      end
      d
    end
    def tex_head_paper
      case @layout
      when /portrait/
        tex_head_paper_portrait(tex_head_paper_dimensions)
      when /landscape/
        tex_head_paper_landscape(tex_head_paper_dimensions)
      end
    end
    def tex_head_pdftex_dvi
      color=case @layout
      when /portrait/
      <<WOK
  colorlinks=true,
  urlcolor=myblack,
  filecolor=myblack,
  linkcolor=myblack,
WOK
      when /landscape/
      <<WOK
  colorlinks=true,
  urlcolor=myblue,    % \\href{...}{...}   external url
  filecolor=mygreen,  % \\href{...}     local file
  linkcolor=myred,    % \\href{...} and \\pageref{...}
WOK
      end
      if @layout =~/portrait|landscape/
      <<WOK
\\usepackage{alltt}
\\usepackage{thumbpdf}
\\usepackage[#{@tex2pdf},
  #{color.strip}
  pdftitle={#{@txt}},
%  pdftitle={Untitled},
  pdfauthor={LM-sisu-scribe},
  pdfsubject={law},
  pdfkeywords={law},
  pageanchor=true,
  plainpages=true,
  pdfpagelabels=true,
  pagebackref,
  bookmarks=true,
  bookmarksopen=true,
  pdfmenubar=true,
  pdfpagemode=UseOutline,
  pdffitwindow=true,
  pdfwindowui=true,
  plainpages=false,
%  pdfusetitle=true,
%  pdfpagelayout=SinglePage,
%  pdfpagelayout=TwoColumnRight,
%  pdfpagelayout=TwoColumnLeft,
%  pdfstartpage=3,
  pdfstartview=FitH
]
{hyperref}
%% trace lost characters
% \\tracinglostchars = 1
% \\tracingonline = 1
\\usepackage[usenames]{color}
\\definecolor{myblack}{rgb}{0,0,0}
\\definecolor{myred}{rgb}{0.75,0,0}
\\definecolor{mygreen}{rgb}{0,0.5,0}
\\definecolor{myblue}{rgb}{0,0,0.5}
\\definecolor{mywhite}{rgb}{1,1,1}
\\usepackage{url}
%\\usepackage{breakurl}
WOK
      elsif @txt =~/dvi/
      <<WOK
\\usepackage{alltt}
  #{color.strip}
  pageanchor=true,
  plainpages=true,
  pagebackref,
  bookmarks=true,
  bookmarksopen=true,
  plainpages=false,
]
{hyperref}
\\usepackage[usenames]{color}
\\definecolor{myblack}{rgb}{0,0,0}
\\definecolor{myred}{rgb}{0.75,0,0}
\\definecolor{mygreen}{rgb}{0,0.5,0}
\\definecolor{myblue}{rgb}{0,0,0.5}
\\definecolor{mywhite}{rgb}{1,1,1}
\\usepackage{url}
%\\usepackage{breakurl}
WOK
      end
    end
    def tex_head_misc
      <<WOK
\\usepackage{textcomp}
\\usepackage[parfill]{parskip}
\\usepackage[normalem]{ulem}
\\usepackage{soul}
\\usepackage{longtable}
\\usepackage{graphicx}
\\makeatletter
\\parindent0pt
%\\usepackage{mathptmx}
\\usepackage{amssymb}
% amssymb used for backslash
WOK
    end
    def document_head_with_orientation
      endnotes=("\\usepackage{endnotes}" if @txt =~/endnotes?/)||'' #not implemented see also def endnotes
      language
      <<WOK
#{tex_head_paper}
#{tex_head_encode}
#{tex_head_pdftex_dvi}
#{tex_head_misc}
\\setcounter{secnumdepth}{2}
\\setcounter{tocdepth}{4}
\\makeatletter
#{endnotes}
\\usepackage[multiple,ragged]{footmisc}
\\setlength\\footnotemargin{12pt}
\\usepackage[para]{manyfoot}
\\DeclareNewFootnote{A}
%\\DeclareNewFootnote[para]{A}
\\newenvironment{ParagraphIndent}[1]%
{
\\begin{list}{}{%
\\setlength\\topsep{0pt}%
\\addtolength{\\leftmargin}{#1}
\\setlength\\parsep{0pt plus 1pt}%
}
\\item[]
}
{\\end{list}}
\\usepackage{fancyhdr}
\\lhead{}
\\renewcommand{\\part}{\\\@startsection
  {part}{1}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\bfseries\\large\\upshape\\raggedright}}
\\renewcommand{\\section}{\\\@startsection
  {section}{2}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\bfseries\\large\\upshape\\raggedright}}
\\renewcommand{\\subsection}{\\\@startsection
  {subsection}{3}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\bfseries\\large\\upshape\\raggedright}}
\\renewcommand{\\subsubsection}{\\\@startsection
  {subsubsection}{4}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\normalfont\\normalsize\\bfseries\\raggedright}}
\\renewcommand{\\paragraph}{\\\@startsection
  {paragraph}{5}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\normalfont\\normalsize\\itshape\\raggedright}}
\\renewcommand{\\subparagraph}{\\\@startsection
  {subparagraph}%{6}%{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\normalfont\\normalsize\\itshape\\raggedright}}
% \\makeatother
\\selectlanguage{#{language}}
WOK
    end
    def a4generic
    end
  end
  class Special_characters
    @@flag_code=false
    @@tex_backslash="\\\\"
    def initialize(md,string)
      @md,@txt=md,string
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      #@tx=SiSU_Env::Get_init.instance.tex
      @url_brace=SiSU_Viz::Skin.new.url_decoration
      @tex2pdf=@@tex3pdf ||=SiSU_Env::System_call.new.tex2pdf_engine
    end
    def pdftex_special_characters_1(string)             # ~ ^ $ & % _ { }  #LaTeX special characters - KEEP list
      #p @@utf_8.list
      #@txt=Iconv.conv('ISO-8859-1', 'UTF-8', @txt)
      word=string.scan(/#{Mx[:mk_o]}\S+?#{Mx[:mk_c]}|\S+|\n/) #unless line =~/^(?:0~\S|%+\s)/
      para_array=[]
      string=if word
        word.each do |w| # _ - / # | : ! ^ ~
          unless string =~/^(?:#{Rx[:meta]}|%+ |#{Mx[:gr_o]}Th?#{Mx[:tc_p]} )/um
            unless w=~/^#{Mx[:lv_o]}[1-6]:|~\{|\}~|~\[|\]~|^\^~\s|~\^|\*~\S+|~#|\{t~|#{Mx[:id_o]}~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}/
              w.gsub!(/[\\]?~/,'<=tilde>')
              #if w !~/^(\s*<:image|\}:image\s)|/
              #  w.gsub!(/_/,'\_')
              #end
            end
            w.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'<=tilde>') #126 usual
            #w.gsub!(/&#(?:126|152);/,'<=tilde>') unless w=~/https?:\/\/\S+/ #126 usual
            w.gsub!(/\\?\||#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'<=pipe>') #unless w=~/<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/ # | SiSU not really special sisu character but done, also LaTeX
          end
          para_array << w
        end
        string=para_array.join(' ')
        string=string.strip
        string
      else ''
      end
      string.gsub(/\s*#{Mx[:mk_o]}:name#\S+?#{Mx[:mk_c]}\s*/,' ')
      string.gsub!(/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;[umdv]\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
      string.gsub!(/.+?<-#>/,'')
      string.gsub!(/#{Mx[:br_eof]}|#{Mx[:br_endnotes]}/,'')
      #problem sequence ->
      string.gsub!(/&(?:nbsp);|#{Mx[:nbsp]}/,'<=hardspace>')                                 # < SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#nbsp#{Mx[:gl_c]}/,'<=hardspace>')                                 # < SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}(?:#lt|#060)#{Mx[:gl_c]}/,'<=lt>')                                     # < SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}(?:#gt|#062)#{Mx[:gl_c]}/,'<=gt>')                                     # > SiSU special character also LaTeX
      #string.gsub!(/#{Mx[:gl_o]}(#[a-z]+|#[0-9]+)#{Mx[:gl_c]}/,'\1') #i don't think so
      string.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'<=curlyopen>')                                     # { SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'<=curlyclose>')                                    # } SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'<=tilde>')                                 # ~ SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'\#')                                               # # SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!')                                                # ! SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*')                                                # * should you wish to escape astrisk e.g. describing \*{bold}*
      string.gsub!(/#{Mx[:gl_o]}#045#{Mx[:gl_c]}/,'-')                                                # - SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#043#{Mx[:gl_c]}/,'+')                                                # + SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#044#{Mx[:gl_c]}/,',')                                                # + SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#038#{Mx[:gl_c]}/,'<=amp>') #unless @txt=~/<:code>/                   # / SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'<=slash>')                                         # / SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#092#{Mx[:gl_c]}/,'<=backslash>')                                     # \ SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'<=underscore>')                                    # _ SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'|')                                                # | SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#058#{Mx[:gl_c]}/,':')                                                # : SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#094#{Mx[:gl_c]}|\^/,'<=caret>')                                      # ^ SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/\#/,'<=hash>')
      ##watch placement, problem sequence ^
      string.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ')
      string.gsub!(/#{Mx[:br_page]}/,'\newpage')
      string.gsub!(/#{Mx[:br_page_new]}/,'\clearpage')
      string.gsub!(/\\copy(right|mark)?/,'<=copymark>') # ok problem with superscript
      string
    end
    def pdftex_special_characters_2(string)
      string.gsub!(/#{Mx[:gl_o]}#156#{Mx[:gl_c]}/,'\oe ')
      string.gsub!(/\$/,'\$')
      string.gsub!(/\#/,'\#')
      string.gsub!(/\%/,'\%')
      string.gsub!(/\~/,'\~') #revist, should not be necessary to mark remaining tildes
      if string !~/^\s*#{Mx[:lnk_o]}|#{Mx[:lnk_c]}image\s/
        string.gsub!(/_/,'\_')
      end
      string.gsub!(/\{/,'\{')
      #string.gsub!(/\}/,'\}')
      string.gsub!(/&nbsp;|#{Mx[:nbsp]}/,'~') # ~ character for hardspace
      # sequence important must appear after removal of { and }
      string.gsub!(/&\S+?;/,'') #hmmm
      # sequence imortant place before removal of &
      if string=~/#{Mx[:gr_o]}code#{Mx[:gr_c]}/;        @@flag_code=true
      elsif string=~/#{Mx[:gr_o]}code-end#{Mx[:gr_c]}/; @@flag_code=false
      end
      if @@flag_code; string.gsub!(/&/,'{\\\&}')
      else string.gsub!(/(\s+&\s+)/,' and ')
      end
      string.gsub!(/§/u,'\S') #latex: space between next character not preserved? #string.gsub!(/§ /,'\S ')
      string.gsub!(/£/u,'\pounds')
      string.gsub!(/&\S+?;/,' ')
      string.gsub!(/<a href=".+?">/,' ')
      string.gsub!(/<\/a>/,' ')
      string.gsub!(/((?:^|\s)#{Mx[:lnk_c]})((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)([;.,]?(?:\s|$))/,
        '\1\begin{scriptsize}\url{\2}\end{scriptsize}\3') #special case \{ e.g. \}http://url
      string.gsub!(/[^\}>_]((?:https?|file|ftp):\/\/\S+?)(<\/\S>)/,
        ' \begin{scriptsize}\url{\1} \end{scriptsize}\2') #special case
      string.gsub!(/\B(?:\\_|\\)((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/,
        '\begin{scriptsize}\\url{\1}\end{scriptsize}\2') #specially escaped url no decoration
      unless @@flag_code
        string.gsub!(/(^|#{Mx[:gl_c]}|\s)((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)([;.,]?(?=\s|$))/,
          "\\1#{@url_brace.tex_open}\\begin{scriptsize}\\url{\\2}\\end{scriptsize}#{@url_brace.tex_close}\\3") #url matching with decoration <url> positive lookahead, sequence issue with { linked }http://url cannot use \b at start
      else #code-block: angle brackets special characters, note _ already escaped
        string.gsub!(/\\_</,'{\UseTextSymbol{OML}{<}}')
        string.gsub!(/\\_>/,'{\UseTextSymbol{OML}{>}}')
      end
      string.gsub!(/<:ee>/,'')
      string.gsub!(/<!>/,' ')
      #proposed change, insert, but may be redundant
      string.gsub!(/ \/>#{Mx[:pa_o]}:i[12]#{Mx[:pa_c]}(.+?)(?:\}~|<br)/,
        ' \begin{ParagraphIndent}{0.01\columnwidth}\1\end{ParagraphIndent} ') # footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      string.gsub!(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ") # Work Area
      string.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'\begin{bfseries}\1 \end{bfseries}')
      #string.gsub!(/<em>(.+?)<\/em>/,'\begin{bfseries}\1 \end{bfseries}')
      #string.gsub!(/<(bold|strong)>(.+?)<\/(bold|strong)>/,'\begin{bfseries}\1 \end{bfseries}')
      string.gsub!(/<h\d+>(.+?)<\/h\d+>/,'\begin{bfseries}\1 \end{bfseries}')
      string.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'\emph{\1}')
      #string.gsub!(/<italic>(.+?)<\/italic>/,'\emph{\1}')
      string.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'\uline{\1}') # ulem
      string.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,"``\\1''") # quote #CHECK
      string.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'\uline{\1}') # ulem
      string.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'\sout{\1}') # ulem
      string.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,"\$^{\\textrm{\\1}}\$")
      string.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,"\$_{\\textrm{\\1}}\$")
      unless @@flag_code
        string.gsub!(/"(.+?)"/,'“\1”')  # quote marks / quotations open & close " need condition exclude for code
        string.gsub!(/\s+"/,' “')                                # open "
        string.gsub!(/^(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*"/,'\1“')  # open "
        string.gsub!(/"(\s|\.|,|:|;)/,'”\1')                     # close "
        string.gsub!(/"(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*$/,'”\1')  # close "
        string.gsub!(/"(\.|,)/,'”')                              # close "
        string.gsub!(/\s+'/,' `')                                # open '
        string.gsub!(/^(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*'/,'\1`')  # open '
      end
      string.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})?\s*#{Mx[:gl_bullet]}\s*/,
        '\1 $\txtbullet$~~') #bullets - defined 2008w49 temporary absence of bullet in debian texlive \\_
        #'\1 \begin{math} \bullet \end{math}~~') #bullets - added 2004w17 watch \\_
      string.gsub!(/(<font.*?>|<\/font>)/,'')
      string.gsub!(/\s*#{Mx[:fa_superscript_o]}(\S+?)#{Mx[:fa_superscript_c]}/,'^\1')
      #string.gsub!(/\s*(?:#{Mx[:br_line]}|#{Mx[:br_paragraph]}|\n)\*/,' \\\\ ')
      #string.gsub!(/(<sup>|<\/sup>)/,'')
      string
    end
    def pdftex_special_characters_3(string)
      string.gsub!(/<br(\s*[^\/][^>])/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      string.gsub!(/([^<][^b][^r]\s+)\/>/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      #problem sequence (another kludge) ->
      string.gsub!(/<=lt>/,'{\UseTextSymbol{OML}{<}}')
      string.gsub!(/<=gt>/,'{\UseTextSymbol{OML}{>}}')
      #string.gsub!(/<=lt>/,'\<')
      #string.gsub!(/<=gt>/,'\>')
      string.gsub!(/<=underscore>/,'\_')
      while string =~/(http:\/\/\S+?)(?:<=tilde>\S+)+/ #tilde in urls \href treated differently from text
        string.gsub!(/(http:\/\/\S+?)(?:<=tilde>(\S+))+/,'\1~\2')
      end
      string.gsub!(/<=tilde>/,'{$\tilde$}')
      #string.gsub!(/<=tilde>/,'{$\sim$}')
      string.gsub!(/<=pipe>/,'{\textbar}')
      string.gsub!(/<=caret>/,'{\^{~}}')
      #string.gsub!(/<=caret>/,'\^{}')
      string.gsub!(/<=exclaim>/,'\Verbatim{!}')
      string.gsub!(/(http:\/\/\S+?)(?:(?:<=hash>)(\S+))+/,'\1#\2') #hash in urls \href treated differently from text
      string.gsub!(/<=hash>/,'{\#}')
      #string.gsub!(/<=hash>/,'{\UseTextSymbol{OT1}{#}}')
      #string.gsub!(/<=slash>/,'{\slash}')
      string.gsub!(/<=hardspace>/,'{~}') #changed ... 2005
      while string =~/(http:\/\/\S+?)(?:<=amp>\S+)+/ #amp in urls \href treated differently from text
        string.gsub!(/(http:\/\/\S+?)(?:<=amp>(\S+))+/,'\1&\2')
      end
      string.gsub!(/<=amp>/,'{\\\&}') #changed ... 2005
      #string.gsub!(/<=amp>/,'{\UseTextSymbol{OT1}{&}}')
      string.gsub!(/<=slash>/,'{/}')
      string.gsub!(/<=backslash>/,'{\textbackslash}')
      #string.gsub!(/<=asterisk>/,'*')
      #string.gsub!(/<=exclaim>/,'!')
      #string.gsub!(/<=asterisk>/,'{\ast}')
      #string.gsub!(/<=copymark>/,"^{\\copyright} ") # watch has been problematic
      #copymark='{\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
      string.gsub!(/<=copymark>\s*(.+)?\s+(#{Mx[:id_o]}\\~\d+;\w(?:[0-6]:)?\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})/,
        '^\copyright \textnormal{\1} \2') # watch likely to be problematic
      string
    end
    def xetex_special_characters_1(string)             # ~ ^ $ & % _ { }  #LaTeX special characters - KEEP list
      #p @@utf_8.list
      #string=Iconv.conv('ISO-8859-1', 'UTF-8', @txt)
      word=string.scan(/\S+|\n/) #unless line =~/^(?:0~\S|%+\s)/
      para_array=[]
      string=if word
        word.each do |w| # _ - / # | : ! ^ ~
          unless string =~/^(?:#{Rx[:meta]}|%+ |#{Mx[:gr_o]}Th?#{Mx[:tc_p]} )/um
            unless w=~/^#{Mx[:lv_o]}[1-6]:|~\{|\}~|~\[|\]~|^\^~\s|~\^|\*~\S+|~#|\{t~|#{Mx[:id_o]}~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}/
              w.gsub!(/[\\]?~/,'<=tilde>')
              #if w !~/^(\s*<:image|\}:image\s)/
              #  w.gsub!(/_/,'\_')
              #end
            end
            w.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'<=tilde>') #126 usual
            #w.gsub!(/&#(?:126|152);/,'<=tilde>') unless w=~/https?:\/\/\S+/ #126 usual
            w.gsub!(/\\?\||#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'<=pipe>') #unless w=~/<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/ # | SiSU not really special sisu character but done, also LaTeX
          end
          para_array << w
        end
        string=para_array.join(' ')
        string=string.strip
        string
      else ''
      end
      string.gsub(/\s*#{Mx[:mk_o]}:name#\S+?#{Mx[:mk_c]}\s*/,' ')
      string.gsub!(/#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;[umdv]\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
      string.gsub!(/.+?<-#>/,'')
      string.gsub!(/#{Mx[:br_eof]}/,'')
      string.gsub!(/#{Mx[:br_endnotes]}/,'')
      #string.gsub!(/<ENDNOTES?>/,'')
      #problem sequence ->
      string.gsub!(/&(?:nbsp);|#{Mx[:nbsp]}/,'<=hardspace>')                                 # < SiSU special character also LaTeX
      string.gsub!(/&(?:lt|#060);/,'<=lt>')                                     # < SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#(?:gt|062)#{Mx[:gl_c]}/,'<=gt>')                                     # > SiSU special character also LaTeX
      #string.gsub!(/#{Mx[:gl_o]}(&#(?:[a-z]+|[0-9]+);)#{Mx[:gl_c]}/,'\1')
      string.gsub!(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'<=curlyopen>')                                     # { SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'<=curlyclose>')                                    # } SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'<=tilde>')                                 # ~ SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'\#')                                               # # SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!')                                                # ! SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*')                                                # * should you wish to escape astrisk e.g. describing \*{bold}*
      string.gsub!(/#{Mx[:gl_o]}#045#{Mx[:gl_c]}/,'-')                                                # - SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#043#{Mx[:gl_c]}/,'+')                                                # + SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#044#{Mx[:gl_c]}/,',')                                                # + SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#038#{Mx[:gl_c]}/,'<=amp>') #unless @txt=~/<:code>/                   # / SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'<=slash>')                                         # / SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#092#{Mx[:gl_c]}/,'<=backslash>')                                     # \ SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'<=underscore>')                                    # _ SiSU special character also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'|')                                                # | SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#058#{Mx[:gl_c]}/,':')                                                # : SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/#{Mx[:gl_o]}#094#{Mx[:gl_c]}|\^/,'<=caret>')                                      # ^ SiSU not really special sisu character but done, also LaTeX
      string.gsub!(/\#/,'<=hash>')
      ##watch placement, problem sequence ^
      string.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ')
      string.gsub!(/#{Mx[:br_page]}/,'\newpage')
      string.gsub!(/#{Mx[:br_page_new]}/,'\clearpage')
      string.gsub!(/\\copy(right|mark)?/,'<=copymark>') # ok problem with superscript
      string
    end
    def xetex_special_characters_2(string)
      string.gsub!(/#{Mx[:gl_o]}#156#{Mx[:gl_c]}/,'\oe ')
      string.gsub!(/\$/,'\$')
      string.gsub!(/\#/,'\#')
      string.gsub!(/\%/,'\%')
      string.gsub!(/\~/,'\~') #revist, should not be necessary to mark remaining tildes
      if string !~/^\s*#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}image\s/
        string.gsub!(/_/,'\_')
      end
      string.gsub!(/\{/,'\{')
      string.gsub!(/\}/,'\}')
      string.gsub!(/&nbsp;|#{Mx[:nbsp]}/,'~') # ~ character for hardspace
      # sequence important must appear after removal of { and }
      string.gsub!(/&\S+?;/,'') #hmmm
      # sequence imortant place before removal of &
      if string=~/#{Mx[:gr_o]}code#{Mx[:gr_c]}/;        @@flag_code=true
      elsif string=~/#{Mx[:gr_o]}code-end#{Mx[:gr_c]}/; @@flag_code=false
      end
      if @@flag_code; string.gsub!(/&/,'{\\\&}')
      else string.gsub!(/&/,'<=amp>')
      #else string.gsub!(/(\s+&\s+)/,' and ')
      end
      if @@flag_code;
        string.gsub!(/\\~(\\\{)/,'{$\tilde$}\1')
        string.gsub!(/(\\\})\\~/,'\1{$\tilde$}')
        string.gsub!(/\\~(\[)/,'{$\tilde$}\1')
        string.gsub!(/(\])\\~/,'\1{$\tilde$}')
      end
      string.gsub!(/§/u,'\S') #latex: space between next character not preserved? #string.gsub!(/§ /,'\S ')
      string.gsub!(/£/u,'\pounds')
      string.gsub!(/&\S+?;/,' ')
      string.gsub!(/<a href=".+?">/,' ')
      string.gsub!(/<\/a>/,' ')
      string.gsub!(/((?:^|\s)#{Mx[:lnk_c]})((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)([;.,]?(?:\s|$))/,
        '\1\begin{scriptsize}\url{\2}\end{scriptsize}\3') #special case \{ e.g. \}http://url
      string.gsub!(/[^\}>_]((?:https?|file|ftp):\/\/\S+?)(<\/\S>)/,
        ' \begin{scriptsize}\url{\1} \end{scriptsize}\2') #special case
      string.gsub!(/\B(?:\\_|\\)((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)([;.,]?(?:\s|$))/,
        '\begin{scriptsize}\\url{\1}\end{scriptsize}\2') #specially escaped url no decoration
      unless @@flag_code
        string.gsub!(/(^|#{Mx[:gl_c]}|\s)((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)([;.,]?(?=\s|$))/,
          "\\1#{@url_brace.tex_open}\\begin{scriptsize}\\url{\\2}\\end{scriptsize}#{@url_brace.tex_close}\\3") #url matching with decoration <url> positive lookahead, sequence issue with { linked }http://url cannot use \b at start
      else #code-block: angle brackets special characters, note _ already escaped
        string.gsub!(/\\_</,'{\UseTextSymbol{OML}{<}}')
        string.gsub!(/\\_>/,'{\UseTextSymbol{OML}{>}}')
      end
      string.gsub!(/<:ee>/,'')
      string.gsub!(/<!>/,' ')
      #proposed change, insert, but may be redundant
      string.gsub!(/ \/>#{Mx[:pa_o]}:i[12]#{Mx[:pa_c]}(.+?)(?:\}~|<br)/,
        ' \begin{ParagraphIndent}{0.01\columnwidth}\1\end{ParagraphIndent} ') # footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      string.gsub!(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>/," #{@@tex_backslash*2} ") # Work Area
      string.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'\begin{bfseries}\1 \end{bfseries}')
      #string.gsub!(/<em>(.+?)<\/em>/,'\begin{bfseries}\1 \end{bfseries}')
      #string.gsub!(/<(bold|strong)>(.+?)<\/(bold|strong)>/,'\begin{bfseries}\1 \end{bfseries}')
      string.gsub!(/<h\d+>(.+?)<\/h\d+>/,'\begin{bfseries}\1 \end{bfseries}')
      string.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'\emph{\1}')
      #string.gsub!(/<italic>(.+?)<\/italic>/,'\emph{\1}')
      string.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'\uline{\1}') # ulem
      string.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,"``\\1''") # quote #CHECK
      string.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'\uline{\1}') # ulem
      string.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'\sout{\1}') # ulem
      string.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,"\$^{\\textrm{\\1}}\$")
      string.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,"\$_{\\textrm{\\1}}\$")
      unless @@flag_code
        string.gsub!(/"(.+?)"/,'“\1”')  # quote marks / quotations open & close " need condition exclude for code
        string.gsub!(/\s+"/,' “')                                # open "
        string.gsub!(/^(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*"/,'\1“')  # open "
        string.gsub!(/"(\s|\.|,|:|;)/,'”\1')                     # close "
        string.gsub!(/"(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*$/,'”\1')  # close "
        string.gsub!(/"(\.|,)/,'”')                              # close "
        string.gsub!(/\s+'/,' `')                                # open '
        string.gsub!(/^(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*'/,'\1`')  # open '
      end
      string.gsub!(/^\s*#{Mx[:gl_bullet]}\s*/,'$\txtbullet$~~')
      string.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})?\s*#{Mx[:gl_bullet]}\s*/,'\1 $\txtbullet$~~')
      #string.gsub!(/^\s*#{Mx[:gl_bullet]}\s*/,'\begin{math} \bullet \end{math}~~')
      #string.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})?\s*#{Mx[:gl_bullet]}\s*/,'\1 \begin{math} \bullet \end{math}~~')
      #string.gsub!(/^\s*#{Mx[:gl_bullet]}\s*/,'● ~~')
      #string.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})?\s*#{Mx[:gl_bullet]}\s*/,'\1 ● ~~')
      ##string.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})?\s*\\_\*\s*/,'\1 ● ~~')
      ##string.gsub!(/^\\_\*\s*/,'● ~~')
      string.gsub!(/(<font.*?>|<\/font>)/,'')
      string.gsub!(/\s*#{Mx[:fa_superscript_o]}(\S+?)#{Mx[:fa_superscript_c]}/,'^\1')
      #string.gsub!(/\s*(?:#{Mx[:br_line]}|#{Mx[:br_paragraph]}|\n)\*/,' \\\\ ')
      #string.gsub!(/(<sup>|<\/sup>)/,'')
      string
    end
    def xetex_special_characters_3(string)
      string.gsub!(/<br(\s*[^\/][^>])/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      string.gsub!(/([^<][^b][^r]\s+)\/>/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      #problem sequence (another kludge) ->
      string.gsub!(/<=lt>/,'{\UseTextSymbol{OML}{<}}')
      string.gsub!(/<=gt>/,'{\UseTextSymbol{OML}{>}}')
      #string.gsub!(/<=lt>/,'\<')
      #string.gsub!(/<=gt>/,'\>')
      string.gsub!(/<=underscore>/,'\_')
      while string =~/(http:\/\/\S+?)(?:<=tilde>\S+)+/ #tilde in urls \href treated differently from text
        string.gsub!(/(http:\/\/\S+?)(?:<=tilde>(\S+))+/,'\1~\2')
      end
      string.gsub!(/<=tilde>/,'{$\tilde$}')
      #string.gsub!(/<=tilde>/,'{$\sim$}')
      string.gsub!(/<=pipe>/,'{\textbar}')
      string.gsub!(/<=caret>/,'{\^{~}}')
      #string.gsub!(/<=caret>/,'\^{}')
      string.gsub!(/<=exclaim>/,'\Verbatim{!}')
      string.gsub!(/(http:\/\/\S+?)(?:(?:<=hash>)(\S+))+/,'\1#\2') #hash in urls \href treated differently from text
      string.gsub!(/<=hash>/,'{\#}')
      #string.gsub!(/<=hash>/,'{\UseTextSymbol{OT1}{#}}')
      #string.gsub!(/<=slash>/,'{\slash}')
      string.gsub!(/<=hardspace>/,'{~}') #changed ... 2005
      while string =~/(http:\/\/\S+?)(?:<=amp>\S+)+/ #amp in urls \href treated differently from text
        string.gsub!(/(http:\/\/\S+?)(?:<=amp>(\S+))+/,'\1&\2')
      end
      string.gsub!(/<=amp>/,'{\\\&}') #changed ... 2005
      #string.gsub!(/<=amp>/,'{\UseTextSymbol{OT1}{&}}')
      string.gsub!(/<=slash>/,'{/}')
      string.gsub!(/<=backslash>/,'{\textbackslash}')
      #string.gsub!(/<=asterisk>/,'*')
      #string.gsub!(/<=exclaim>/,'!')
      #string.gsub!(/<=asterisk>/,'{\ast}')
      #string.gsub!(/<=copymark>/,"^{\\copyright} ") # watch has been problematic
      #copymark='{\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
      string.gsub!(/<=copymark>\s*(.+)?\s+(#{Mx[:id_o]}\\~\d+;\w(?:[0-6]:)?\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})/,
        '^\copyright \textnormal{\1} \2') # watch likely to be problematic
      string
    end
    def special_characters_curly(string)
      string.gsub!(/<=curlyopen>/,'\{')
      string.gsub!(/<=curlyclose>/,'\}')
      string
    end
    def special_characters_unsafe_1(string) #depreciated, make obsolete
      # some substitutions are sequence sensitive, rearrange with care.
      string.gsub!(/\\backslash (copyright|clearpage|newpage)/,"\\\\\\1")  #kludge bad solution, find out where tail is sent through specChar !
      string
    end
    def special_characters                                                       #special characters - some substitutions are sequence sensitive, rearrange with care.
      string=@txt
      case @tex2pdf
      when /pdf/
        string=pdftex_special_characters_1(string) unless string.nil?
        string=special_characters_unsafe_1(string) unless string.nil? #pdftex_special_characters_unsafe_1(@txt)
        string=pdftex_special_characters_2(string) unless string.nil?
        string=pdftex_special_characters_3(string) unless string.nil?
      when /xe/
        string=xetex_special_characters_1(string) unless string.nil?
        string=special_characters_unsafe_1(string) unless string.nil? #xetex_special_characters_unsafe_1(@txt)
        string=xetex_special_characters_2(string) unless string.nil? #issues with xetex
        string=xetex_special_characters_3(string) unless string.nil?
      end
      @txt=string
    end
    def special_characters_safe                                                  #special characters - some substitutions are sequence sensitive, rearrange with care.
      string=@txt
      case @tex2pdf
      when /pdf/
        string=pdftex_special_characters_1(@txt) unless string.nil?
        string=pdftex_special_characters_2(@txt) unless string.nil?
        #special_characters_3(@txt)
      when /xe/
        string=xetex_special_characters_1(@txt) unless string.nil?
        string=xetex_special_characters_2(@txt) unless string.nil? # remove this to start with, causes issues
      end
      @txt=string
    end
  end
  class Use_TeX
    attr_accessor :url,:txt,:date
    def initialize(md)
      @md=md
      @vz=SiSU_Env::Get_init.instance.skin
      @date=SiSU_Env::Info_date.new # #{@date.year}
      @copymark='{\\begin{footnotesize}\\raisebox{1ex}{\\copyright}\\end{footnotesize}}'
      @url_brace=SiSU_Viz::Skin.new.url_decoration
    end
    def skip
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def paraskip_normal
      '\setlength{\parskip}{1ex plus0.5ex minus0.2ex}'
    end
    def paraskip_small
      '\setlength{\parskip}{0.5ex plus0.2ex minus0.1ex}'
    end
    def skip_small
      #"\\smallskip{}"
    end
    def skip_small_vspace
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def skip_small_footnote
      #"\n\\smallskip{}\n"
    end
    def skip_medium
      "\n\\medskip{}\n\n"
    end
    def skip_dummy
      "\n"
    end
    def header
      "\\lhead[ ]{ }\n" +
      "\\chead[ \\fancyplain{} \\bfseries \\footnotesize  \\leftmark ]{ \\fancyplain{} \\bfseries \\footnotesize \\rightmark }\n" +
      "\\rhead[ ]{ }\n"
    end
    def footer
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i; " \\\\ \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert}"
        else ''
        end
      else ''
      end
      "\\lfoot[\\textrm{\\thepage}]{\\tiny \\href{#{@vz.url_sisu}}{#{@vz.txt_signature}}#{base_prog_txt}}\n" +
      "\\cfoot[\\href{#{@vz.url_home}}{#{@vz.url_txt}}]{\\href{#{@vz.url_home}}{#{@vz.url_txt}}}\n" +
      "\\rfoot[\\tiny \\href{#{@vz.url_sisu}}{#{@vz.txt_signature}}]{\\textrm{\\thepage}}\n"
    end
    def site
      "\\href{#{@vz.url_home}}{#{@vz.url_txt}}"
    end
    def sitename                                   #owners site, eg freeculture, free.for.all, gutenberg etc.
      "\\href{#{@vz.url_home}}{#{@vz.txt_home}}"
    end
    def owner_chapter
      "Contact Details for Original Promulgating Authority"
    end
    #BOOK standard dimensions - 229x156
    def newpage(orientation)
      case orientation
      when /landscape/ # using longtable latex package
<<WOK
\\clearpage
WOK
      when /portrait/
<<WOK
\\newpage
WOK
      end
    end
    def sisu_rights
      v=SiSU_Env::Info_version.instance.get_version
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i; "\n\\\\ This document prepared using \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert \\ http://freehackers.org/~tnagy/kdissert/ } \\\\ Kdissert is Document Mapping software by Thomas Nagy"
        else ''
        end
      else ''
      end
<<WOK
\\\\ ~
{\\begin{footnotesize}#{base_prog_txt}
\\\\ Generated by \\href{http://www.jus.uio.no/sisu}{SiSU} \\begin{tiny}[ #{v[:project]} #{v[:version]} of #{v[:date_stamp]} ]\\end{tiny} \\href{http://www.jus.uio.no/sisu}{www.jus.uio.no/sisu}
\\\\ Copyright #@copymark 1997, current #{@date.year_static} Ralph Amissah, All Rights Reserved.
\\\\ SiSU is software for document structuring, publishing and search (with object citation numbering), \\href{http://www.sisudoc.org}{www.sisudoc.org}
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 3 } or later, #{@url_brace.tex_open}\\href{http://www.fsf.org/licenses/gpl.html}{http://www.fsf.org/licenses/gpl.html}#{@url_brace.tex_close}.
{\\end{footnotesize}
\\\\
WOK
    end
    def doc_sc_info_footnote_full
<<WOK
\\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU \\ www.jus.uio.no/sisu }\\ \\newline \\scriptsize{Document version information: \\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}}}}
WOK
    end
    def doc_sc_info_footnote_brief
      " \\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU} \\ \\href{http://www.jus.uio.no/sisu}{www.jus.uio.no/sisu} \\newline \\href{http://www.sisudoc.org}{www.sisudoc.org} \\\n}"
    end
    def doc_sc_info
      v=SiSU_Env::Info_version.instance.get_version
<<WOK
\\\\
{\\begin{footnotesize}
Document version information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu }\\- version information: \\\\
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}
\\end{footnotesize}}&
WOK
    end
    def doc_no_sc_info
      v=SiSU_Env::Info_version.instance.get_version
<<WOK
\\\\
{\\begin{small}
Document information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu } \\\\ version information: \\
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}

\\end{small}}&
WOK
    end
    def manifest_info
      url=@md.fnb.gsub(/(?:\\)*([$&~%_#}{^])/,'\\\\\1')
      fn=@md.fn[:manifest].gsub(/(?:\\)*([$&~%_#}{^])/,'\\\\\1')
<<WOK
{\\begin{footnotesize}
\\\\ For alternative output formats of this document check:
\\\\ #{@url_brace.tex_open}\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{fn}}{#{@vz.url_root_http}/#{url}/#{fn}}\\end{scriptsize}#{@url_brace.tex_close}
\\end{footnotesize}}&
WOK
    end
    def endnotes #not used should be inserted before MetaData section which preceeds doc_tail, but is "part of document"
<<WOK
\\subsection*{Endnotes}
\\addcontentsline{toc}{section}{Endnotes}
\\
\\listofendnotes
WOK
    end
    def doc_tail
      dir=SiSU_Env::Info_env.new(@md.fns)
      base_html="#{dir.url.root}/#{@md.fnb}"
      v=SiSU_Env::Info_version.instance.get_version
      sisu_ico=if FileTest.file?("#{dir.path.image_source_tex}/sisu.png")
        "\\includegraphics*[width=60pt]{#{dir.path.image_source_tex}/sisu.png}"
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,'WARNING - image directory or image(s) missing:', %{"#{dir.path.image_source_tex}"} )
        tell.warn unless @md.cmd =~/q/
        " SiSU "
      end
      url=@md.fnb.gsub(/(?:\\)*([$&~%_#}{^])/,'\\\\\1')
<<WOK
\\subsection*{Information on this document copy and an unofficial List of Some web related information and sources}
\\addcontentsline{toc}{section}{Information on this document copy and an unofficial List of Some web related information and sources}
\\\\
\"Support Open Standards and Software Libré for the Information Technology Infrastructure\" RA\\subsubsection*{Information on this document copy #{site}}
\\addcontentsline{toc}{subsection}{Information on this document copy}
{\\begin{footnotesize}
\\\\ Generated by \\href{http://www.jus.uio.no/sisu/}{SiSU} found at \\href{http://www.jus.uio.no/sisu/}{www.jus.uio.no/sisu} \\begin{tiny}[ #{v[:project]} #{v[:version]} #{v[:date_stamp]} ]\\end{tiny}  \\href{http://www.sisudoc.org}{www.sisudoc.org}. SiSU is software for document structuring, publishing and search (using SiSU: object citation numbering, markup, meta-markup, and system) Copyright #@copymark 1997, current #{@date.year_static} Ralph Amissah, All Rights Reserved.
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 3 } or later (\\href{http://www.fsf.org/licenses/gpl.html}{www.fsf.org/licenses/gpl.html}). {\\end{footnotesize}
{\\begin{small}
\\\\ W3 since October 3 1993 \\href{http://www.jus.uio.no/sisu/}{#{sisu_ico}}SiSU 1997, current #{@date.year_static}. \\\\ #{sitename} presentations at \\begin{bfseries}#{site}\\end{bfseries} \\\\ \\\\ #{@md.title} \\textbf{pdf} versions can be found at:  \\\\
{\\end{small}
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_p]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_p]}}\\end{scriptsize}  \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_l]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:pdf_l]}}\\end{scriptsize}  \\\\
\\\\\n#{@md.title} \\textbf{html} versions may be found at: \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:toc]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:toc]}}\\end{scriptsize} or \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:doc]}}{#{@vz.url_root_http}/#{url}/#{@md.fn[:doc]}}\\end{scriptsize}
\\\\
\\\\
\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:manifest]}}{SiSU Manifest} of document output and metadata may be found at: \\\\
\\begin{scriptsize}\\href{#{@vz.url_root_http}/#{url}/#{@md.fn[:manifest]}}{#{@vz.url_root_http}/#{url}/#{@md.fnl[:pre]}sisu\\_manifest#{@md.fnl[:mid]}.html#{@md.fnl[:post]}}\\end{scriptsize}
\\\\
\\\\
 #{sitename} found at: \\begin{bfseries}#{site}\\end{bfseries}\\subsubsection*{Links that may be of interest at #{@vz.txt_home} and elsewhere:}
\\addcontentsline{toc}{subsection}{Links that may be of interest}
WOK
    end
    def mail_tail #not retested, the old mail_tail is commented out and appended to this program
      dir=SiSU_Env::Info_env.new(@md.fns)
<<WOK
\\subsection*{Mail sender details}
\\addcontentsline{toc}{subsection}{Mail sender details}
\\\\
Mail from: ralph@amissah.com\\\\
44 20 8789 3452\\\\
44 77 9669 4448
\\\\
 \"Support Open Standards and Open Sources for the Information Technology Infrastructure\" RA
\\subsubsection*{Information on this document copy #{site}\\copyright}
Presentations' look and feel generated by \\href{http://www.jus.uio.no/sisu/}{SiSU Scribe} \\href{http://www.jus.uio.no/sisu/}{http://www.jus.uio.no/sisu/} programmed in Ruby on Debian/Gnu/Linux by Copyright \\copyright Ralph Amissah, W3 since October 3 1993 \\href{http://www.jus.uio.no/sisu/}{\\includegraphics*[width=35pt]{#{dir.path.image_source_tex}/sisu.png}}for #{sitename}. SiSU Scribe (sisu information structuring unit) produces Electronic Documents, i.e. it generates structured output for use in a number of file formats, including the pdf file produced here.
WOK
    end
  end
end
__END__
