/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.MessageInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateEventListener
implements PreInsertEventListener,
PreUpdateEventListener,
Initializable {
    private boolean isInitialized;
    private Map<Class, ValidatableElement> validators = new HashMap<Class, ValidatableElement>();

    public synchronized void initialize(Configuration cfg) {
        if (!this.isInitialized) {
            String interpolatorString = cfg.getProperty("hibernate.validator.message_interpolator_class");
            MessageInterpolator interpolator = null;
            if (StringHelper.isNotEmpty((String)interpolatorString)) {
                try {
                    Class interpolatorClass = ReflectHelper.classForName((String)interpolatorString);
                    interpolator = (MessageInterpolator)interpolatorClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new HibernateException("Unable to find message interpolator: " + interpolatorString, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new HibernateException("Unable to instanciate message interpolator: " + interpolatorString, (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new HibernateException("Unable to instanciate message interpolator: " + interpolatorString, (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new HibernateException("Class does not implement " + MessageInterpolator.class.getName() + ": " + interpolatorString, (Throwable)e);
                }
            }
            Iterator classes = cfg.getClassMappings();
            while (classes.hasNext()) {
                PersistentClass clazz = (PersistentClass)classes.next();
                Class mappedClass = clazz.getMappedClass();
                ClassValidator validator = new ClassValidator(mappedClass, interpolator);
                ValidatableElement element = new ValidatableElement(mappedClass, validator);
                this.addSubElement(clazz.getIdentifierProperty(), element);
                Iterator properties = clazz.getPropertyIterator();
                while (properties.hasNext()) {
                    this.addSubElement((Property)properties.next(), element);
                }
                if (element.subElements.size() == 0 && !element.validator.hasValidationRules()) continue;
                this.validators.put(mappedClass, element);
            }
            this.isInitialized = true;
        }
    }

    private void addSubElement(Property property, ValidatableElement element) {
        if (property != null && property.isComposite() && !property.isBackRef()) {
            Component component = (Component)property.getValue();
            if (component.isEmbedded()) {
                return;
            }
            PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor((Property)property, (EntityMode)EntityMode.POJO);
            Getter getter = accessor.getGetter(element.clazz, property.getName());
            ClassValidator validator = new ClassValidator(getter.getReturnType());
            ValidatableElement subElement = new ValidatableElement(getter.getReturnType(), validator, getter);
            Iterator properties = component.getPropertyIterator();
            while (properties.hasNext()) {
                this.addSubElement((Property)properties.next(), subElement);
            }
            if (subElement.getSubElements().size() != 0 || subElement.validator.hasValidationRules()) {
                element.addSubElement(subElement);
            }
        }
    }

    protected void validate(Object entity, EntityMode mode) {
        InvalidValue[] invalidValues;
        if (entity == null || !EntityMode.POJO.equals(mode)) {
            return;
        }
        if (!this.isInitialized) {
            throw new AssertionFailure("Validator event not initialized");
        }
        ValidatableElement element = this.validators.get(entity.getClass());
        if (element == null) {
            return;
        }
        ArrayList<InvalidValue> consolidatedInvalidValues = new ArrayList<InvalidValue>();
        this.validateSubElements(element, entity, consolidatedInvalidValues);
        consolidatedInvalidValues.size();
        InvalidValue[] invalidValueArray = invalidValues = element.validator == null ? null : element.validator.getInvalidValues(entity);
        if (invalidValues != null) {
            for (InvalidValue invalidValue : invalidValues) {
                consolidatedInvalidValues.add(invalidValue);
            }
        }
        if (consolidatedInvalidValues.size() > 0) {
            throw new InvalidStateException(consolidatedInvalidValues.toArray(new InvalidValue[consolidatedInvalidValues.size()]), entity.getClass().getName());
        }
    }

    private void validateSubElements(ValidatableElement element, Object entity, List<InvalidValue> consolidatedInvalidValues) {
        if (element != null) {
            for (ValidatableElement subElement : element.subElements) {
                InvalidValue[] invalidValues;
                Object component = subElement.getter.get(entity);
                for (InvalidValue invalidValue : invalidValues = subElement.validator.getInvalidValues(component)) {
                    consolidatedInvalidValues.add(invalidValue);
                }
                this.validateSubElements(subElement, component, consolidatedInvalidValues);
            }
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        this.validate(event.getEntity(), event.getSource().getEntityMode());
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        this.validate(event.getEntity(), event.getSource().getEntityMode());
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidatableElement
    implements Serializable {
        private Class clazz;
        private ClassValidator validator;
        private Getter getter;
        private Collection<ValidatableElement> subElements = new ArrayList<ValidatableElement>();

        public ValidatableElement(Class clazz, ClassValidator validator) {
            this.clazz = clazz;
            this.validator = validator;
        }

        public ValidatableElement(Class clazz, ClassValidator validator, Getter getter) {
            this(clazz, validator);
            this.getter = getter;
        }

        public void addSubElement(ValidatableElement subValidatableElement) {
            this.subElements.add(subValidatableElement);
        }

        public Collection<ValidatableElement> getSubElements() {
            return this.subElements;
        }
    }
}

