/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.FSDirectoryProvider;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryProviderFactory {
    public List<DirectoryProvider<?>> providers = new ArrayList();
    private static String LUCENE_PREFIX = "hibernate.search.";
    private static String LUCENE_DEFAULT = LUCENE_PREFIX + "default.";
    private static String DEFAULT_DIRECTORY_PROVIDER = FSDirectoryProvider.class.getName();

    public DirectoryProvider<?> createDirectoryProvider(XClass entity, Configuration cfg, SearchFactory searchFactory) {
        String directoryProviderName = DirectoryProviderFactory.getDirectoryProviderName(entity, cfg);
        Properties indexProps = DirectoryProviderFactory.getDirectoryProperties(cfg, directoryProviderName);
        String className = indexProps.getProperty("directory_provider");
        if (StringHelper.isEmpty((String)className)) {
            className = DEFAULT_DIRECTORY_PROVIDER;
        }
        DirectoryProvider provider = null;
        try {
            Class directoryClass = ReflectHelper.classForName((String)className, DirectoryProviderFactory.class);
            provider = (DirectoryProvider)directoryClass.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instanciate directory provider: " + className, (Throwable)e);
        }
        try {
            provider.initialize(directoryProviderName, indexProps, searchFactory);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to initialize: " + directoryProviderName, (Throwable)e);
        }
        int index = this.providers.indexOf(provider);
        if (index != -1) {
            return this.providers.get(index);
        }
        this.providers.add(provider);
        return provider;
    }

    private static Properties getDirectoryProperties(Configuration cfg, String directoryProviderName) {
        Properties props = cfg.getProperties();
        String indexName = LUCENE_PREFIX + directoryProviderName;
        Properties indexProps = new Properties();
        Properties indexSpecificProps = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(LUCENE_DEFAULT)) {
                indexProps.setProperty(key.substring(LUCENE_DEFAULT.length()), (String)entry.getValue());
                continue;
            }
            if (!key.startsWith(indexName)) continue;
            indexSpecificProps.setProperty(key.substring(indexName.length()), (String)entry.getValue());
        }
        indexProps.putAll((Map<?, ?>)indexSpecificProps);
        return indexProps;
    }

    private static String getDirectoryProviderName(XClass clazz, Configuration cfg) {
        ReflectionManager reflectionManager = SearchFactory.getReflectionManager(cfg);
        PersistentClass pc = cfg.getClassMapping(clazz.getName());
        XClass rootIndex = null;
        do {
            XClass currentClazz;
            Indexed indexAnn;
            if ((indexAnn = (Indexed)(currentClazz = reflectionManager.toXClass(pc.getMappedClass())).getAnnotation(Indexed.class)) == null) continue;
            if (indexAnn.index().length() != 0) {
                return indexAnn.index();
            }
            rootIndex = currentClazz;
        } while ((pc = pc.getSuperclass()) != null);
        if (rootIndex != null) {
            return rootIndex.getName();
        }
        throw new HibernateException("Trying to extract the index name from a non @Indexed class: " + clazz.getName());
    }
}

