/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.util.ContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJMSHibernateSearchController
implements MessageListener {
    private static Log log = LogFactory.getLog(AbstractJMSHibernateSearchController.class);

    protected abstract Session getSession();

    protected abstract void cleanSessionIfNeeded(Session var1);

    public void onMessage(Message message) {
        List queue;
        if (!(message instanceof ObjectMessage)) {
            log.error((Object)("Incorrect message type: " + message.getClass()));
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            queue = (List)((Object)objectMessage.getObject());
        }
        catch (JMSException e) {
            log.error((Object)("Unable to retrieve object from message: " + message.getClass()), (Throwable)e);
            return;
        }
        catch (ClassCastException e) {
            log.error((Object)"Illegal object retrieved from message", (Throwable)e);
            return;
        }
        Runnable worker = this.getWorker(queue);
        worker.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getWorker(List<LuceneWork> queue) {
        Session session = this.getSession();
        Runnable processor = null;
        try {
            SearchFactory factory = ContextHelper.getSearchFactory(session);
            processor = factory.getBackendQueueProcessorFactory().getProcessor(queue);
        }
        finally {
            this.cleanSessionIfNeeded(session);
        }
        return processor;
    }

    @PostConstruct
    public void initialize() {
    }

    @PreDestroy
    public void shutdown() {
    }
}

