/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.mapper;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.mapper.DefaultActionMapper;

public class PrefixBasedActionMapper
extends DefaultActionMapper
implements ActionMapper {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected Container container;
    protected Map<String, ActionMapper> actionMappers = new HashMap<String, ActionMapper>();

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.mapper.prefixMapping")
    public void setPrefixBasedActionMappers(String list) {
        if (list != null) {
            String[] mappers;
            for (String mapper : mappers = list.split(",")) {
                String[] thisMapper = mapper.split(":");
                if (thisMapper == null || thisMapper.length != 2) continue;
                String mapperPrefix = thisMapper[0].trim();
                String mapperName = thisMapper[1].trim();
                Object obj = this.container.getInstance(ActionMapper.class, mapperName);
                if (obj != null) {
                    this.actionMappers.put(mapperPrefix, (ActionMapper)obj);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("invalid PrefixBasedActionMapper config entry: " + mapper));
            }
        }
    }

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        String uri = this.getUri(request);
        int lastIndex = uri.lastIndexOf(47);
        while (lastIndex > -1) {
            ActionMapper actionMapper = this.actionMappers.get(uri.substring(0, lastIndex));
            if (actionMapper != null) {
                ActionMapping actionMapping = actionMapper.getMapping(request, configManager);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Using ActionMapper " + actionMapper));
                }
                if (actionMapping != null) {
                    if (this.log.isDebugEnabled() && actionMapping.getParams() != null) {
                        this.log.debug((Object)("ActionMapper found mapping. Parameters: " + actionMapping.getParams()));
                        for (Map.Entry<String, Object> mappingParameterEntry : actionMapping.getParams().entrySet()) {
                            Object paramValue = mappingParameterEntry.getValue();
                            if (paramValue == null) {
                                this.log.debug((Object)(mappingParameterEntry.getKey() + " : null!"));
                                continue;
                            }
                            if (paramValue instanceof String[]) {
                                this.log.debug((Object)(mappingParameterEntry.getKey() + " : (String[]) " + Arrays.toString((String[])paramValue)));
                                continue;
                            }
                            if (paramValue instanceof String) {
                                this.log.debug((Object)(mappingParameterEntry.getKey() + " : (String) " + (String)paramValue));
                                continue;
                            }
                            this.log.debug((Object)(mappingParameterEntry.getKey() + " : (Object) " + paramValue.toString()));
                        }
                    }
                    return actionMapping;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ActionMapper " + actionMapper + " failed to return an ActionMapping"));
                }
            }
            lastIndex = uri.lastIndexOf(47, lastIndex - 1);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"no ActionMapper found");
        }
        return null;
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        String namespace = mapping.getNamespace();
        int lastIndex = namespace.length();
        while (lastIndex > -1) {
            ActionMapper actionMapper = this.actionMappers.get(namespace.substring(0, lastIndex));
            if (actionMapper != null) {
                String uri = actionMapper.getUriFromActionMapping(mapping);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Using ActionMapper " + actionMapper));
                }
                if (uri != null) {
                    return uri;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ActionMapper " + actionMapper + " failed to return an ActionMapping (null)"));
                }
            }
            lastIndex = namespace.lastIndexOf(47, lastIndex - 1);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ActionMapper failed to return a uri");
        }
        return null;
    }
}

