/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AnnotationValueInfo;
import com.google.doclava.ClassInfo;
import com.google.doclava.ClearPage;
import com.google.doclava.Converter;
import com.google.doclava.DocInfo;
import com.google.doclava.Errors;
import com.google.doclava.FieldInfo;
import com.google.doclava.MemberInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.ParameterInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TypeInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stubs {
    private static HashSet<ClassInfo> notStrippable;

    public static void writeStubsAndXml(String stubsDir, File xmlFile, HashSet<String> stubPackages) {
        if (stubsDir == null && xmlFile == null) {
            return;
        }
        notStrippable = new HashSet();
        ClassInfo[] all = Converter.allClasses();
        PrintStream xmlWriter = null;
        if (xmlFile != null) {
            ClearPage.ensureDirectory(xmlFile);
            try {
                xmlWriter = new PrintStream(new BufferedOutputStream(new FileOutputStream(xmlFile)));
            }
            catch (FileNotFoundException e) {
                Errors.error(Errors.IO_ERROR, new SourcePositionInfo(xmlFile.getAbsolutePath(), 0, 0), "Cannot open file for write.");
            }
        }
        for (ClassInfo cl : all) {
            if (!cl.checkLevel() || !cl.isDefinedLocally()) continue;
            Stubs.cantStripThis(cl, notStrippable, "0:0");
        }
        for (ClassInfo cl : notStrippable) {
            if (!cl.isHidden()) {
                TypeInfo t;
                ParameterInfo[] params;
                ClassInfo returnClass;
                MethodInfo[] methods;
                for (MethodInfo m : methods = cl.selfMethods()) {
                    if (m.isHidden()) {
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Reference to hidden method " + m.name());
                    } else if (m.isDeprecated()) {
                        Errors.error(Errors.DEPRECATED, m.position(), "Method " + cl.qualifiedName() + "." + m.name() + " is deprecated");
                    }
                    returnClass = m.returnType().asClassInfo();
                    if (returnClass != null && returnClass.isHidden()) {
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Method " + cl.qualifiedName() + "." + m.name() + " returns unavailable type " + returnClass.name());
                    }
                    for (ParameterInfo p : params = m.parameters()) {
                        t = p.type();
                        if (t.isPrimitive() || !t.asClassInfo().isHidden()) continue;
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Parameter of hidden type " + t.fullName() + " in " + cl.qualifiedName() + "." + m.name() + "()");
                    }
                }
                for (MethodInfo m : methods = cl.annotationElements()) {
                    if (m.isHidden()) continue;
                    returnClass = m.returnType().asClassInfo();
                    if (returnClass != null && returnClass.isHidden()) {
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Annotation '" + m.name() + "' returns unavailable type " + returnClass.name());
                    }
                    for (ParameterInfo p : params = m.parameters()) {
                        t = p.type();
                        if (t.isPrimitive() || !t.asClassInfo().isHidden()) continue;
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, p.position(), "Reference to unavailable annotation class " + t.fullName());
                    }
                }
                continue;
            }
            if (!cl.isDeprecated()) continue;
            Errors.error(Errors.DEPRECATED, cl.position(), "Class " + cl.qualifiedName() + " is deprecated");
        }
        if (stubPackages != null) {
            for (ClassInfo cl : notStrippable) {
                if (stubPackages.contains(cl.containingPackage().name())) continue;
                notStrippable.remove(cl);
            }
        }
        Stubs.writeStubsAndXml(stubsDir, xmlWriter, notStrippable);
    }

    public static void writeStubsAndXml(String stubsDir, PrintStream xmlWriter, Set<ClassInfo> classes) {
        HashMap<PackageInfo, List<ClassInfo>> packages = new HashMap<PackageInfo, List<ClassInfo>>();
        for (ClassInfo cl : classes) {
            if (cl.isDocOnly()) continue;
            if (stubsDir != null) {
                Stubs.writeClassFile(stubsDir, cl);
            }
            if (xmlWriter == null || !cl.isDefinedLocally()) continue;
            if (packages.containsKey(cl.containingPackage())) {
                ((List)packages.get(cl.containingPackage())).add(cl);
                continue;
            }
            ArrayList<ClassInfo> adding = new ArrayList<ClassInfo>();
            adding.add(cl);
            packages.put(cl.containingPackage(), adding);
        }
        if (xmlWriter != null) {
            Stubs.writeXML(xmlWriter, packages, classes);
            xmlWriter.close();
        }
    }

    public static void cantStripThis(ClassInfo cl, HashSet<ClassInfo> notStrippable, String why) {
        ClassInfo supr;
        if (!notStrippable.add(cl)) {
            return;
        }
        cl.setReasonIncluded(why);
        if (cl.allSelfFields() != null) {
            for (FieldInfo fInfo : cl.allSelfFields()) {
                if (fInfo.type() == null) continue;
                if (fInfo.type().asClassInfo() != null) {
                    Stubs.cantStripThis(fInfo.type().asClassInfo(), notStrippable, "2:" + cl.qualifiedName());
                }
                if (fInfo.type().typeArguments() == null) continue;
                for (TypeInfo tTypeInfo : fInfo.type().typeArguments()) {
                    if (tTypeInfo.asClassInfo() == null) continue;
                    Stubs.cantStripThis(tTypeInfo.asClassInfo(), notStrippable, "3:" + cl.qualifiedName());
                }
            }
        }
        if (cl.asTypeInfo() != null && cl.asTypeInfo().typeArguments() != null) {
            for (TypeInfo tInfo : cl.asTypeInfo().typeArguments()) {
                if (tInfo.asClassInfo() == null) continue;
                Stubs.cantStripThis(tInfo.asClassInfo(), notStrippable, "4:" + cl.qualifiedName());
            }
        }
        Stubs.cantStripThis(cl.allSelfMethods(), notStrippable);
        Stubs.cantStripThis(cl.allConstructors(), notStrippable);
        if (cl.containingClass() != null) {
            Stubs.cantStripThis(cl.containingClass(), notStrippable, "5:" + cl.qualifiedName());
        }
        if ((supr = cl.realSuperclass()) != null) {
            if (supr.isHidden()) {
                cl.init(cl.asTypeInfo(), cl.realInterfaces(), cl.realInterfaceTypes(), cl.innerClasses(), cl.allConstructors(), cl.allSelfMethods(), cl.annotationElements(), cl.allSelfFields(), cl.enumConstants(), cl.containingPackage(), cl.containingClass(), null, null, cl.annotations());
                Errors.error(Errors.HIDDEN_SUPERCLASS, cl.position(), "Public class " + cl.qualifiedName() + " stripped of unavailable superclass " + supr.qualifiedName());
            } else {
                Stubs.cantStripThis(supr, notStrippable, "6:" + cl.realSuperclass().name() + cl.qualifiedName());
            }
        }
    }

    private static void cantStripThis(MethodInfo[] mInfos, HashSet<ClassInfo> notStrippable) {
        if (mInfos != null) {
            for (MethodInfo mInfo : mInfos) {
                if (mInfo.getTypeParameters() != null) {
                    for (TypeInfo tInfo : mInfo.getTypeParameters()) {
                        if (tInfo.asClassInfo() == null) continue;
                        Stubs.cantStripThis(tInfo.asClassInfo(), notStrippable, "8:" + mInfo.realContainingClass().qualifiedName() + ":" + mInfo.name());
                    }
                }
                if (mInfo.parameters() != null) {
                    for (ParameterInfo pInfo : mInfo.parameters()) {
                        if (pInfo.type() == null || pInfo.type().asClassInfo() == null) continue;
                        Stubs.cantStripThis(pInfo.type().asClassInfo(), notStrippable, "9:" + mInfo.realContainingClass().qualifiedName() + ":" + mInfo.name());
                        if (pInfo.type().typeArguments() == null) continue;
                        for (TypeInfo tInfoType : pInfo.type().typeArguments()) {
                            if (tInfoType.asClassInfo() == null) continue;
                            ClassInfo tcl = tInfoType.asClassInfo();
                            if (tcl.isHidden()) {
                                Errors.error(Errors.UNAVAILABLE_SYMBOL, mInfo.position(), "Parameter of hidden type " + tInfoType.fullName() + " in " + mInfo.containingClass().qualifiedName() + '.' + mInfo.name() + "()");
                                continue;
                            }
                            Stubs.cantStripThis(tcl, notStrippable, "10:" + mInfo.realContainingClass().qualifiedName() + ":" + mInfo.name());
                        }
                    }
                }
                for (ClassInfo thrown : mInfo.thrownExceptions()) {
                    Stubs.cantStripThis(thrown, notStrippable, "11:" + mInfo.realContainingClass().qualifiedName() + ":" + mInfo.name());
                }
                if (mInfo.returnType() == null || mInfo.returnType().asClassInfo() == null) continue;
                Stubs.cantStripThis(mInfo.returnType().asClassInfo(), notStrippable, "12:" + mInfo.realContainingClass().qualifiedName() + ":" + mInfo.name());
                if (mInfo.returnType().typeArguments() == null) continue;
                for (TypeInfo tyInfo : mInfo.returnType().typeArguments()) {
                    if (tyInfo.asClassInfo() == null) continue;
                    Stubs.cantStripThis(tyInfo.asClassInfo(), notStrippable, "13:" + mInfo.realContainingClass().qualifiedName() + ":" + mInfo.name());
                }
            }
        }
    }

    static String javaFileName(ClassInfo cl) {
        String dir = "";
        PackageInfo pkg = cl.containingPackage();
        if (pkg != null) {
            dir = pkg.name();
            dir = dir.replace('.', '/') + '/';
        }
        return dir + cl.name() + ".java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeClassFile(String stubsDir, ClassInfo cl) {
        if (cl.containingClass() != null) {
            return;
        }
        if (cl.containingPackage() != null && cl.containingPackage().name().equals("default package")) {
            return;
        }
        String filename = stubsDir + '/' + Stubs.javaFileName(cl);
        File file = new File(filename);
        ClearPage.ensureDirectory(file);
        PrintStream stream = null;
        try {
            stream = new PrintStream(file);
            Stubs.writeClassFile(stream, cl);
        }
        catch (FileNotFoundException e) {
            System.err.println("error writing file: " + filename);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static void writeClassFile(PrintStream stream, ClassInfo cl) {
        PackageInfo pkg = cl.containingPackage();
        if (pkg != null) {
            stream.println("package " + pkg.name() + ";");
        }
        Stubs.writeClass(stream, cl);
    }

    static void writeClass(PrintStream stream, ClassInfo cl) {
        int period;
        Stubs.writeAnnotations(stream, cl.annotations());
        stream.print(cl.scope() + " ");
        if (cl.isAbstract() && !cl.isAnnotation() && !cl.isInterface()) {
            stream.print("abstract ");
        }
        if (cl.isStatic()) {
            stream.print("static ");
        }
        if (cl.isFinal() && !cl.isEnum()) {
            stream.print("final ");
        }
        HashSet<String> classDeclTypeVars = new HashSet<String>();
        String leafName = cl.asTypeInfo().fullName(classDeclTypeVars);
        int bracket = leafName.indexOf(60);
        if (bracket < 0) {
            bracket = leafName.length() - 1;
        }
        if ((period = leafName.lastIndexOf(46, bracket)) < 0) {
            period = -1;
        }
        leafName = leafName.substring(period + 1);
        String kind = cl.kind();
        stream.println(kind + " " + leafName);
        TypeInfo base = cl.superclassType();
        if (!"enum".equals(kind) && base != null && !"java.lang.Object".equals(base.qualifiedTypeName())) {
            stream.println("  extends " + base.fullName(classDeclTypeVars));
        }
        TypeInfo[] interfaces = cl.realInterfaceTypes();
        ArrayList<TypeInfo> usedInterfaces = new ArrayList<TypeInfo>();
        for (TypeInfo iface : interfaces) {
            if (!notStrippable.contains(iface.asClassInfo()) || iface.asClassInfo().isDocOnly()) continue;
            usedInterfaces.add(iface);
        }
        if (usedInterfaces.size() > 0 && !cl.isAnnotation()) {
            if (cl.isInterface() || cl.isAnnotation()) {
                stream.print("  extends ");
            } else {
                stream.print("  implements ");
            }
            String comma = "";
            for (TypeInfo iface : usedInterfaces) {
                stream.print(comma + iface.fullName(classDeclTypeVars));
                comma = ", ";
            }
            stream.println();
        }
        stream.println("{");
        FieldInfo[] enumConstants = cl.enumConstants();
        int N = enumConstants.length;
        for (int i = 0; i < N; ++i) {
            FieldInfo field = enumConstants[i];
            if (!field.constantLiteralValue().equals("null")) {
                stream.println(field.name() + "(" + field.constantLiteralValue() + (i == N - 1 ? ");" : "),"));
                continue;
            }
            stream.println(field.name() + "(" + (i == N - 1 ? ");" : "),"));
        }
        for (ClassInfo classInfo : cl.getRealInnerClasses()) {
            if (!notStrippable.contains(classInfo) || classInfo.isDocOnly()) continue;
            Stubs.writeClass(stream, classInfo);
        }
        for (DocInfo docInfo : cl.constructors()) {
            if (docInfo.isDocOnly()) continue;
            Stubs.writeMethod(stream, (MethodInfo)docInfo, true);
        }
        boolean fieldNeedsInitialization = false;
        boolean staticFieldNeedsInitialization = false;
        for (FieldInfo fieldInfo : cl.allSelfFields()) {
            if (fieldInfo.isDocOnly()) continue;
            if (!fieldInfo.isStatic() && fieldInfo.isFinal() && !Stubs.fieldIsInitialized(fieldInfo)) {
                fieldNeedsInitialization = true;
            }
            if (!fieldInfo.isStatic() || !fieldInfo.isFinal() || Stubs.fieldIsInitialized(fieldInfo)) continue;
            staticFieldNeedsInitialization = true;
        }
        if (!(cl.constructors().length != 0 || cl.getNonWrittenConstructors().length == 0 && !fieldNeedsInitialization || cl.isAnnotation() || cl.isInterface() || cl.isEnum())) {
            stream.println(cl.leafName() + "() { " + Stubs.superCtorCall(cl, null) + "throw new" + " RuntimeException(\"Stub!\"); }");
        }
        for (MemberInfo memberInfo : cl.allSelfMethods()) {
            if (cl.isEnum() && ("values".equals(memberInfo.name()) && "()".equals(((MethodInfo)memberInfo).signature()) || "valueOf".equals(memberInfo.name()) && "(java.lang.String)".equals(((MethodInfo)memberInfo).signature())) || memberInfo.isDocOnly()) continue;
            Stubs.writeMethod(stream, (MethodInfo)memberInfo, false);
        }
        for (MemberInfo memberInfo : cl.getHiddenMethods()) {
            MethodInfo overriddenMethod = ((MethodInfo)memberInfo).findRealOverriddenMethod((MethodInfo)memberInfo, notStrippable);
            ClassInfo classContainingMethod = ((MethodInfo)memberInfo).findRealOverriddenClass(memberInfo.name(), ((MethodInfo)memberInfo).signature());
            if (overriddenMethod == null || overriddenMethod.isHidden() || overriddenMethod.isDocOnly() || !overriddenMethod.isAbstract() && !overriddenMethod.containingClass().isInterface()) continue;
            ((MethodInfo)memberInfo).setReason("1:" + classContainingMethod.qualifiedName());
            cl.addMethod((MethodInfo)memberInfo);
            Stubs.writeMethod(stream, (MethodInfo)memberInfo, false);
        }
        for (MemberInfo memberInfo : cl.annotationElements()) {
            if (memberInfo.isDocOnly()) continue;
            Stubs.writeAnnotationElement(stream, (MethodInfo)memberInfo);
        }
        for (MemberInfo memberInfo : cl.allSelfFields()) {
            if (memberInfo.isDocOnly()) continue;
            Stubs.writeField(stream, (FieldInfo)memberInfo);
        }
        if (staticFieldNeedsInitialization) {
            stream.print("static { ");
            for (MemberInfo memberInfo : cl.allSelfFields()) {
                if (memberInfo.isDocOnly() || !memberInfo.isStatic() || !memberInfo.isFinal() || Stubs.fieldIsInitialized((FieldInfo)memberInfo) || ((FieldInfo)memberInfo).constantValue() != null) continue;
                stream.print(memberInfo.name() + " = " + ((FieldInfo)memberInfo).type().defaultValue() + "; ");
            }
            stream.println("}");
        }
        stream.println("}");
    }

    static void writeMethod(PrintStream stream, MethodInfo method, boolean isConstructor) {
        String n;
        int pos;
        stream.print(method.scope() + " ");
        if (method.isStatic()) {
            stream.print("static ");
        }
        if (method.isFinal()) {
            stream.print("final ");
        }
        if (method.isAbstract()) {
            stream.print("abstract ");
        }
        if (method.isSynchronized()) {
            stream.print("synchronized ");
        }
        if (method.isNative()) {
            stream.print("native ");
        }
        stream.print(method.typeArgumentsName(new HashSet<String>()) + " ");
        if (!isConstructor) {
            stream.print(method.returnType().fullName(method.typeVariables()) + " ");
        }
        if ((pos = (n = method.name()).lastIndexOf(46)) >= 0) {
            n = n.substring(pos + 1);
        }
        stream.print(n + "(");
        String comma = "";
        int count = 1;
        int size = method.parameters().length;
        for (ParameterInfo param : method.parameters()) {
            stream.print(comma + Stubs.fullParameterTypeName(method, param.type(), count == size) + " " + param.name());
            comma = ", ";
            ++count;
        }
        stream.print(")");
        comma = "";
        if (method.thrownExceptions().length > 0) {
            stream.print(" throws ");
            for (ClassInfo thrown : method.thrownExceptions()) {
                stream.print(comma + thrown.qualifiedName());
                comma = ", ";
            }
        }
        if (method.isAbstract() || method.isNative() || method.containingClass().isInterface()) {
            stream.println(";");
        } else {
            stream.print(" { ");
            if (isConstructor) {
                stream.print(Stubs.superCtorCall(method.containingClass(), method.thrownExceptions()));
            }
            stream.println("throw new RuntimeException(\"Stub!\"); }");
        }
    }

    static void writeField(PrintStream stream, FieldInfo field) {
        stream.print(field.scope() + " ");
        if (field.isStatic()) {
            stream.print("static ");
        }
        if (field.isFinal()) {
            stream.print("final ");
        }
        if (field.isTransient()) {
            stream.print("transient ");
        }
        if (field.isVolatile()) {
            stream.print("volatile ");
        }
        stream.print(field.type().fullName());
        stream.print(" ");
        stream.print(field.name());
        if (Stubs.fieldIsInitialized(field)) {
            stream.print(" = " + field.constantLiteralValue());
        }
        stream.println(";");
    }

    static boolean fieldIsInitialized(FieldInfo field) {
        return field.isFinal() && field.constantValue() != null || !field.type().dimension().equals("") || field.containingClass().isInterface();
    }

    static boolean methodIsOverride(MethodInfo mi) {
        if (mi.isAbstract() || mi.isStatic() || mi.isFinal()) {
            return false;
        }
        MethodInfo om = mi.findSuperclassImplementation(notStrippable);
        return om != null && mi.mIsPrivate == om.mIsPrivate && mi.mIsPublic == om.mIsPublic && mi.mIsProtected == om.mIsProtected && !om.isAbstract() && !om.isHidden() && !mi.mContainingClass.equals(om.mContainingClass);
    }

    static boolean canCallMethod(ClassInfo from, MethodInfo m) {
        String pkg;
        String fromPkg;
        if (m.isPublic() || m.isProtected()) {
            return true;
        }
        return m.isPackagePrivate() && (fromPkg = from.containingPackage().name()).equals(pkg = m.containingClass().containingPackage().name());
    }

    static String superCtorCall(ClassInfo cl, ClassInfo[] thrownExceptions) {
        ClassInfo base = cl.realSuperclass();
        if (base == null) {
            return "";
        }
        HashSet<String> exceptionNames = new HashSet<String>();
        if (thrownExceptions != null) {
            for (ClassInfo thrown : thrownExceptions) {
                exceptionNames.add(thrown.name());
            }
        }
        MethodInfo[] ctors = base.constructors();
        MethodInfo ctor = null;
        Boolean badException = false;
        for (MethodInfo m : ctors) {
            if (!Stubs.canCallMethod(cl, m)) continue;
            if (m.thrownExceptions() != null) {
                for (ClassInfo thrown : m.thrownExceptions()) {
                    if (exceptionNames.contains(thrown.name())) continue;
                    badException = true;
                }
            }
            if (badException.booleanValue()) {
                badException = false;
                continue;
            }
            if (m.parameters().length == 0) {
                return "";
            }
            ctor = m;
        }
        if (ctor != null) {
            String result = "";
            result = result + "super(";
            ParameterInfo[] params = ctor.parameters();
            int N = params.length;
            for (int i = 0; i < N; ++i) {
                String n;
                TypeInfo t = params[i].type();
                result = t.isPrimitive() && t.dimension().equals("") ? (("byte".equals(n = t.simpleTypeName()) || "short".equals(n) || "int".equals(n) || "long".equals(n) || "float".equals(n) || "double".equals(n)) && t.dimension().equals("") ? result + "0" : ("char".equals(n) ? result + "'\\0'" : ("boolean".equals(n) ? result + "false" : result + "<<unknown-" + n + ">>"))) : result + (!t.isTypeVariable() ? "(" + t.qualifiedTypeName() + t.dimension() + ")" : "") + "null";
                if (i == N - 1) continue;
                result = result + ",";
            }
            result = result + "); ";
            return result;
        }
        return "";
    }

    static void writeAnnotations(PrintStream stream, AnnotationInstanceInfo[] annotations) {
        for (AnnotationInstanceInfo ann : annotations) {
            if (ann.type().isHidden()) continue;
            stream.println(ann.toString());
        }
    }

    static void writeAnnotationElement(PrintStream stream, MethodInfo ann) {
        stream.print(ann.returnType().fullName());
        stream.print(" ");
        stream.print(ann.name());
        stream.print("()");
        AnnotationValueInfo def = ann.defaultAnnotationElementValue();
        if (def != null) {
            stream.print(" default ");
            stream.print(def.valueString());
        }
        stream.println(";");
    }

    static void writeXML(PrintStream xmlWriter, Map<PackageInfo, List<ClassInfo>> allClasses, Set<ClassInfo> notStrippable) {
        Set<PackageInfo> allClassKeys = allClasses.keySet();
        PackageInfo[] allPackages = allClassKeys.toArray(new PackageInfo[allClassKeys.size()]);
        Arrays.sort(allPackages, PackageInfo.comparator);
        xmlWriter.println("<api>");
        for (PackageInfo pack : allPackages) {
            Stubs.writePackageXML(xmlWriter, pack, allClasses.get(pack), notStrippable);
        }
        xmlWriter.println("</api>");
    }

    static void writePackageXML(PrintStream xmlWriter, PackageInfo pack, List<ClassInfo> classList, Set<ClassInfo> notStrippable) {
        ClassInfo[] classes = classList.toArray(new ClassInfo[classList.size()]);
        Arrays.sort(classes, ClassInfo.comparator);
        if (pack.name().equals("default package")) {
            return;
        }
        xmlWriter.println("<package name=\"" + pack.name() + "\"\n" + ">");
        for (ClassInfo cl : classes) {
            Stubs.writeClassXML(xmlWriter, cl, notStrippable);
        }
        xmlWriter.println("</package>");
    }

    static void writeClassXML(PrintStream xmlWriter, ClassInfo cl, Set<ClassInfo> notStrippable) {
        String scope = cl.scope();
        String deprecatedString = "";
        String declString = cl.isInterface() ? "interface" : "class";
        deprecatedString = cl.isDeprecated() ? "deprecated" : "not deprecated";
        xmlWriter.println("<" + declString + " name=\"" + cl.name() + "\"");
        if (!cl.isInterface() && !cl.qualifiedName().equals("java.lang.Object")) {
            xmlWriter.println(" extends=\"" + (cl.realSuperclass() == null ? "java.lang.Object" : cl.realSuperclass().qualifiedName()) + "\"");
        }
        xmlWriter.println(" abstract=\"" + cl.isAbstract() + "\"\n" + " static=\"" + cl.isStatic() + "\"\n" + " final=\"" + cl.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        ClassInfo[] interfaces = cl.realInterfaces();
        Arrays.sort(interfaces, ClassInfo.comparator);
        for (ClassInfo iface : interfaces) {
            if (!notStrippable.contains(iface)) continue;
            xmlWriter.println("<implements name=\"" + iface.qualifiedName() + "\">");
            xmlWriter.println("</implements>");
        }
        MethodInfo[] constructors = cl.constructors();
        Arrays.sort(constructors, MethodInfo.comparator);
        for (MethodInfo mi : constructors) {
            Stubs.writeConstructorXML(xmlWriter, mi);
        }
        MethodInfo[] methods = cl.allSelfMethods();
        Arrays.sort(methods, MethodInfo.comparator);
        for (MethodInfo mi : methods) {
            if (Stubs.methodIsOverride(mi)) continue;
            Stubs.writeMethodXML(xmlWriter, mi);
        }
        FieldInfo[] fields = cl.allSelfFields();
        Arrays.sort(fields, FieldInfo.comparator);
        for (FieldInfo fi : fields) {
            Stubs.writeFieldXML(xmlWriter, fi);
        }
        xmlWriter.println("</" + declString + ">");
    }

    static void writeMethodXML(PrintStream xmlWriter, MethodInfo mi) {
        String scope = mi.scope();
        String deprecatedString = "";
        deprecatedString = mi.isDeprecated() ? "deprecated" : "not deprecated";
        xmlWriter.println("<method name=\"" + mi.name() + "\"\n" + (mi.returnType() != null ? " return=\"" + Stubs.makeXMLcompliant(Stubs.fullParameterTypeName(mi, mi.returnType(), false)) + "\"\n" : "") + " abstract=\"" + mi.isAbstract() + "\"\n" + " native=\"" + mi.isNative() + "\"\n" + " synchronized=\"" + mi.isSynchronized() + "\"\n" + " static=\"" + mi.isStatic() + "\"\n" + " final=\"" + mi.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        int numParameters = mi.parameters().length;
        int count = 0;
        for (ParameterInfo pi : mi.parameters()) {
            Stubs.writeParameterXML(xmlWriter, mi, pi, ++count == numParameters);
        }
        ClassInfo[] exceptions = mi.thrownExceptions();
        Arrays.sort(exceptions, ClassInfo.comparator);
        for (ClassInfo pi : exceptions) {
            xmlWriter.println("<exception name=\"" + pi.name() + "\" type=\"" + pi.qualifiedName() + "\">");
            xmlWriter.println("</exception>");
        }
        xmlWriter.println("</method>");
    }

    static void writeConstructorXML(PrintStream xmlWriter, MethodInfo mi) {
        String scope = mi.scope();
        String deprecatedString = "";
        deprecatedString = mi.isDeprecated() ? "deprecated" : "not deprecated";
        xmlWriter.println("<constructor name=\"" + mi.name() + "\"\n" + " type=\"" + mi.containingClass().qualifiedName() + "\"\n" + " static=\"" + mi.isStatic() + "\"\n" + " final=\"" + mi.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        int numParameters = mi.parameters().length;
        int count = 0;
        for (ParameterInfo pi : mi.parameters()) {
            Stubs.writeParameterXML(xmlWriter, mi, pi, ++count == numParameters);
        }
        ClassInfo[] exceptions = mi.thrownExceptions();
        Arrays.sort(exceptions, ClassInfo.comparator);
        for (ClassInfo pi : exceptions) {
            xmlWriter.println("<exception name=\"" + pi.name() + "\" type=\"" + pi.qualifiedName() + "\">");
            xmlWriter.println("</exception>");
        }
        xmlWriter.println("</constructor>");
    }

    static void writeParameterXML(PrintStream xmlWriter, MethodInfo method, ParameterInfo pi, boolean isLast) {
        xmlWriter.println("<parameter name=\"" + pi.name() + "\" type=\"" + Stubs.makeXMLcompliant(Stubs.fullParameterTypeName(method, pi.type(), isLast)) + "\">");
        xmlWriter.println("</parameter>");
    }

    static void writeFieldXML(PrintStream xmlWriter, FieldInfo fi) {
        String scope = fi.scope();
        String deprecatedString = "";
        deprecatedString = fi.isDeprecated() ? "deprecated" : "not deprecated";
        String value = Stubs.makeXMLcompliant(fi.constantLiteralValue());
        String fullTypeName = Stubs.makeXMLcompliant(fi.type().qualifiedTypeName()) + fi.type().dimension();
        xmlWriter.println("<field name=\"" + fi.name() + "\"\n" + " type=\"" + fullTypeName + "\"\n" + " transient=\"" + fi.isTransient() + "\"\n" + " volatile=\"" + fi.isVolatile() + "\"\n" + (Stubs.fieldIsInitialized(fi) ? " value=\"" + value + "\"\n" : "") + " static=\"" + fi.isStatic() + "\"\n" + " final=\"" + fi.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        xmlWriter.println("</field>");
    }

    static String makeXMLcompliant(String s) {
        String returnString = "";
        returnString = s.replaceAll("&", "&amp;");
        returnString = returnString.replaceAll("<", "&lt;");
        returnString = returnString.replaceAll(">", "&gt;");
        returnString = returnString.replaceAll("\"", "&quot;");
        returnString = returnString.replaceAll("'", "&pos;");
        return returnString;
    }

    static String fullParameterTypeName(MethodInfo method, TypeInfo type, boolean isLast) {
        String fullTypeName = type.fullName(method.typeVariables());
        if (isLast && method.isVarArgs()) {
            fullTypeName = type.fullNameNoDimension(method.typeVariables()) + "...";
        }
        return fullTypeName;
    }
}

