/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.DocInfo;
import com.google.doclava.Doclava;
import com.google.doclava.Scoped;
import com.google.doclava.SourcePositionInfo;

public abstract class MemberInfo
extends DocInfo
implements Comparable,
Scoped {
    ClassInfo mContainingClass;
    ClassInfo mRealContainingClass;
    String mName;
    String mSignature;
    boolean mIsPublic;
    boolean mIsProtected;
    boolean mIsPackagePrivate;
    boolean mIsPrivate;
    boolean mIsFinal;
    boolean mIsStatic;
    boolean mIsSynthetic;
    String mKind;
    private AnnotationInstanceInfo[] mAnnotations;

    public MemberInfo(String rawCommentText, String name, String signature, ClassInfo containingClass, ClassInfo realContainingClass, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isFinal, boolean isStatic, boolean isSynthetic, String kind, SourcePositionInfo position, AnnotationInstanceInfo[] annotations) {
        super(rawCommentText, position);
        this.mName = name;
        this.mSignature = signature;
        this.mContainingClass = containingClass;
        this.mRealContainingClass = realContainingClass;
        this.mIsPublic = isPublic;
        this.mIsProtected = isProtected;
        this.mIsPackagePrivate = isPackagePrivate;
        this.mIsPrivate = isPrivate;
        this.mIsFinal = isFinal;
        this.mIsStatic = isStatic;
        this.mIsSynthetic = isSynthetic;
        this.mKind = kind;
        this.mAnnotations = annotations;
    }

    public abstract boolean isExecutable();

    public String anchor() {
        if (this.mSignature != null) {
            return this.mName + this.mSignature;
        }
        return this.mName;
    }

    public boolean isDefinedLocally() {
        return this.mContainingClass.isDefinedLocally();
    }

    public String relativePath() {
        return this.mContainingClass.relativePath() + "#" + this.anchor();
    }

    public int compareTo(Object that) {
        return this.htmlPage().compareTo(((MemberInfo)that).htmlPage());
    }

    public String name() {
        return this.mName;
    }

    public String signature() {
        return this.mSignature;
    }

    public ClassInfo realContainingClass() {
        return this.mRealContainingClass;
    }

    public ClassInfo containingClass() {
        return this.mContainingClass;
    }

    public boolean isPublic() {
        return this.mIsPublic;
    }

    public boolean isProtected() {
        return this.mIsProtected;
    }

    public boolean isPackagePrivate() {
        return this.mIsPackagePrivate;
    }

    public boolean isPrivate() {
        return this.mIsPrivate;
    }

    public String scope() {
        if (this.isPublic()) {
            return "public";
        }
        if (this.isProtected()) {
            return "protected";
        }
        if (this.isPackagePrivate()) {
            return "";
        }
        if (this.isPrivate()) {
            return "private";
        }
        throw new RuntimeException("invalid scope for object " + this);
    }

    public boolean isStatic() {
        return this.mIsStatic;
    }

    public boolean isFinal() {
        return this.mIsFinal;
    }

    public boolean isSynthetic() {
        return this.mIsSynthetic;
    }

    public ContainerInfo parent() {
        return this.mContainingClass;
    }

    public boolean checkLevel() {
        return Doclava.checkLevel(this.mIsPublic, this.mIsProtected, this.mIsPackagePrivate, this.mIsPrivate, this.isHidden());
    }

    public String kind() {
        return this.mKind;
    }

    public AnnotationInstanceInfo[] annotations() {
        return this.mAnnotations;
    }
}

