/* Validating XML processor for src/xbt/graphxml.dtd.
 *
 * This program was generated with the FleXML XML processor generator.
 * FleXML is Copyright (C) 1999-2005 Kristoffer Rose.  All rights reserved.
 * FleXML is Copyright (C) 2003-2006 Martin Quinson.  All rights reserved.
 * (Id: flexml.pl,v 1.62 2007/10/11 10:00:14 mquinson Exp).
 * 
 * There are two, intertwined parts to this program, part A and part B.
 *
 * Part A
 * ------
 * 
 * Some parts, here collectively called "Part A", are found in the 
 * FleXML package.  They are Copyright (C) 1999-2005 Kristoffer Rose
 * and Copyright (C) 2003-2006 Martin Quinson. All rights reserved.
 *
 * You can redistribute, use, perform, display and/or modify "Part A"
 * provided the following two conditions hold:
 *
 * 1. The program is distributed WITHOUT ANY WARRANTY from the author of
 *    FleXML; without even the implied warranty of MERCHANTABILITY or
 *    FITNESS FOR A PARTICULAR PURPOSE.
 *
 * 2. The program distribution conditions do not in any way affect the
 *    distribution conditions of the FleXML system used to generate this
 *    file or any version of FleXML derived from that system.
 *
 * Notice that these are explicit rights granted to you for files
 * generated by the FleXML system.  For your rights in connection with
 * the FleXML system itself please consult the GNU General Public License.
 * 
 * Part B
 * ------
 * 
 * The other parts, here collectively called "Part B", and which came 
 * from the DTD used by FleXML to generate this program, can be 
 * distributed (or not, as the case may be) under the terms of whoever
 * wrote them, provided these terms respect and obey the two conditions 
 * above under the heading "Part A".
 *
 * The author of and contributors to FleXML specifically disclaim
 * any copyright interest in "Part B", unless "Part B" was written 
 * by the author of or contributors to FleXML.
 * 
 */

%{

/* Version strings. */
const char rcs_graphxml_flexml_skeleton[] =
 "$" "Id: skel,v 1.40 2007/10/11 09:57:24 mquinson Exp $";
const char rcs_graphxml_flexml[] =
 "$" "Id: flexml.pl,v 1.62 2007/10/11 10:00:14 mquinson Exp $";

/* ANSI headers. */
#include <stdlib.h> /* for realloc() -- needed here when using flex 2.5.4 */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdarg.h>
#include <ctype.h>
     
#if defined(_XBT_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(__TOS_WIN__)
# ifndef __STRICT_ANSI__
#  include <io.h>
#  include <process.h>
# endif
#else
# include <unistd.h>
#endif
     
#ifndef FLEXML_INDEXSTACKSIZE
#define FLEXML_INDEXSTACKSIZE 1000
#endif

/* Generated definitions. */
#define FLEXML_yylineno
#ifndef FLEXML_BUFFERSTACKSIZE
#define FLEXML_BUFFERSTACKSIZE 1000000
#endif
#define FLEXML_NEED_BUFFERLIT

/* XML processor api. */
/* FleXML-provided data. */
int graphxml_pcdata_ix;
extern char *graphxml_bufferstack;
#define graphxml_pcdata (graphxml_bufferstack + graphxml_pcdata_ix)
AT_graphxml_node_name AX_graphxml_node_name;
#define A_graphxml_node_name (graphxml_bufferstack + AX_graphxml_node_name)
AT_graphxml_edge_source AX_graphxml_edge_source;
#define A_graphxml_edge_source (graphxml_bufferstack + AX_graphxml_edge_source)
AT_graphxml_node_position_y AX_graphxml_node_position_y;
#define A_graphxml_node_position_y (graphxml_bufferstack + AX_graphxml_node_position_y)
AT_graphxml_node_position_x AX_graphxml_node_position_x;
#define A_graphxml_node_position_x (graphxml_bufferstack + AX_graphxml_node_position_x)
AT_graphxml_edge_data AX_graphxml_edge_data;
#define A_graphxml_edge_data (graphxml_bufferstack + AX_graphxml_edge_data)
AT_graphxml_edge_target AX_graphxml_edge_target;
#define A_graphxml_edge_target (graphxml_bufferstack + AX_graphxml_edge_target)
AT_graphxml_graph_isDirected AX_graphxml_graph_isDirected;
#define A_graphxml_graph_isDirected AX_graphxml_graph_isDirected
AT_graphxml_node_label AX_graphxml_node_label;
#define A_graphxml_node_label (graphxml_bufferstack + AX_graphxml_node_label)
AT_graphxml_node_data AX_graphxml_node_data;
#define A_graphxml_node_data (graphxml_bufferstack + AX_graphxml_node_data)
AT_graphxml_edge_label AX_graphxml_edge_label;
#define A_graphxml_edge_label (graphxml_bufferstack + AX_graphxml_edge_label)
AT_graphxml_edge_length AX_graphxml_edge_length;
#define A_graphxml_edge_length (graphxml_bufferstack + AX_graphxml_edge_length)
AT_graphxml_edge_name AX_graphxml_edge_name;
#define A_graphxml_edge_name (graphxml_bufferstack + AX_graphxml_edge_name)

/* XML state. */
#ifdef FLEX_DEBUG
# define ENTER(state)	debug_enter(state,#state)
# define LEAVE		debug_leave()
# define SET(state)	debug_set(state,#state)
  static void debug_enter(int, const char*);
  static void debug_leave(void);
  static void debug_set(int, const char*);
#else
# define ENTER(state)	(yy_push_state(state))
# define LEAVE		(yy_pop_state())
# define SET(state)	BEGIN(state)
#endif

/* Generic actions. */
#define SKIP	/*skip*/
#define SUCCEED        CLEANUP; return 0

#define FAIL	return fail
static int fail(const char*, ...);

enum {flexml_max_err_msg_size = 512};
static char flexml_err_msg[flexml_max_err_msg_size];
const char * graphxml_parse_err_msg()
{
    return flexml_err_msg;
}
static void reset_graphxml_parse_err_msg()
{
    flexml_err_msg[0] = '\0';
}

/* Cleanup */
static void cleanup(void);
#define CLEANUP  cleanup()

/* Text buffer stack handling. */
char *graphxml_bufferstack = NULL;
static int blimit = FLEXML_BUFFERSTACKSIZE;
static int bnext = 1;

static int *indexstack = NULL;
static int ilimit = FLEXML_INDEXSTACKSIZE;
static int inext = 1;

#define BUFFERSET(P)  (P = bnext)
#define BUFFERPUTC(C) (ck_blimit(), graphxml_bufferstack[bnext++] = (C))
#define BUFFERDONE    (BUFFERPUTC('\0'))

#define BUFFERLITERAL(C, P) graphxml_bufferliteral(C, &(P), yytext)

/* after this is called, there are at least 2 slots left in the stack */
static int ck_blimit()
{
     if (bnext >= blimit) {
	 blimit += FLEXML_BUFFERSTACKSIZE + 2;
	 {
	     char *temp = (char *) realloc(graphxml_bufferstack, blimit);
	     assert(temp);
	     graphxml_bufferstack = temp;
	 }
     }
     return 0;
}

/* after this is called, there are at least 2 slots left in the stack */
static int ck_ilimit()
{
     if (inext >= ilimit) {
	 ilimit += FLEXML_INDEXSTACKSIZE + 2;
	 {
	     int *temp = (int *) realloc(indexstack, ilimit);
	     assert(temp);
	     indexstack = temp;
	 }
     }
     return 0;
}

#ifdef FLEXML_NEED_BUFFERLIT
static void graphxml_bufferliteral(char c, int* pp, const char* text)
{
  const char *s = (c ? strchr(text,c) : text-1), *e = strrchr(text,c);
  assert(s <= e); BUFFERSET(*pp);
  while (++s<e) {
    if (isspace(*s) && c) { BUFFERPUTC(' '); while (isspace(*s)) ++s; }
    else BUFFERPUTC(*s);
  }
  BUFFERDONE;
}
#endif

static void pushbuffer(int p)
{
    ck_ilimit();
    indexstack[inext++] = p;
    indexstack[inext++] = bnext;    
}

static int popbuffer(void)
{
    assert(inext >= 2);
    bnext = indexstack[--inext];
    return indexstack[--inext];
}

/* General internal entities are `unput' back onto the input stream... */
#define ENTITYTEXT(T) \
  { char *s = (T), *e = s+strlen(s);\
    while (--e >= s) { unput(*e); }}


%}

/* Flex standard options. */
%option stack
%option noyy_top_state
%option noinput
%option noreject
%option noyymore
%option noyywrap

/* Flex user-requested options. */
%option yylineno
%option nounput

/* XML character classes (currently restricted to ASCII). */

/* "Common syntactic structures." */
S		[ \t\n\r\f]+
s		[ \t\n\r\f]*

/* "Names and Tokens." */
NameChar	[A-Za-z0-9.:_-]
Name		[A-Za-z_:]{NameChar}*
Names 		{Name}({S}{Name})*
Nmtoken		({NameChar})+
Nmtokens 	{Nmtoken}({S}{Nmtoken})*

/* Miscellaneous. */
VersionNum	[a-zA-Z0-9_.:-]+
Eq		{s}"="{s}
Literal		\'[^'']*\'|\"[^""]*\"

/* Parser states (flex `exclusive start conditions'):
 *
 * PROLOG	the XML prolog of the document before <?xml...>
 * DOCTYPE	the XML prolog of the document after <?xml...>
 * EPILOG	after the root element
 * INCOMMENT	inside an XML comment <!--....-->
 * INPI		inside an XML PI <?...?>
 * VALUE1	inside a '...'-delimited literal
 * VALUE2	inside a "..."-delimited literal
 * CDATA	inside a <![CDATA[...] ]> section.
 * ROOT_<tag>	expect root element <tag>
 * AL_<tag>	inside the attribute list for <tag>
 * IN_<tag>	inside a <tag> with element contents (ready for end tag)
 * IMPOSSIBLE	dummy to permit disabling rules; must be last
 */
%x PROLOG DOCTYPE EPILOG INCOMMENT INPI VALUE1 VALUE2 CDATA
%x ROOT_graphxml_graph AL_graphxml_graph S_graphxml_graph S_graphxml_graph_1 S_graphxml_graph_2 S_graphxml_graph_3 S_graphxml_graph_4 S_graphxml_graph_5 E_graphxml_graph
%x ROOT_graphxml_node AL_graphxml_node E_graphxml_node
%x ROOT_graphxml_edge AL_graphxml_edge E_graphxml_edge
%x IMPOSSIBLE

%{
/* State names. */
const char* *graphxml_statenames=NULL;
%}

%%

 /* Bypass Flex's default INITIAL state and begin by parsing the XML prolog. */
 SET(PROLOG);
 reset_graphxml_parse_err_msg();
 graphxml_bufferstack = (char *) malloc(FLEXML_BUFFERSTACKSIZE);
 assert(graphxml_bufferstack);
 #ifdef FLEX_DEBUG
 {
     int i;
     for (i = 0; i < blimit; i++) {
         graphxml_bufferstack[i] = '\377';
     }
 }
 #endif
 graphxml_bufferstack[0] = '\0';
 indexstack = (int *) malloc(FLEXML_INDEXSTACKSIZE * sizeof(int));
 assert(indexstack);
 indexstack[0] = 0;

  /* FleXML_init */
  bnext = inext = 1;
  graphxml_bufferliteral('\0', &bnext, "-1.0");
  graphxml_bufferliteral('\0', &bnext, "-1.0");
  graphxml_bufferliteral('\0', &bnext, "-1.0");
  if(!graphxml_statenames) {graphxml_statenames= (const char **)calloc(IMPOSSIBLE,sizeof(char*));
  graphxml_statenames[PROLOG] = NULL;
  graphxml_statenames[DOCTYPE] = NULL;
  graphxml_statenames[EPILOG] = NULL;
  graphxml_statenames[INCOMMENT] = NULL;
  graphxml_statenames[INPI] = NULL;
  graphxml_statenames[VALUE1] = NULL;
  graphxml_statenames[VALUE2] = NULL;
  graphxml_statenames[CDATA] = NULL;
  graphxml_statenames[ROOT_graphxml_graph] = NULL;
  graphxml_statenames[AL_graphxml_graph] = NULL;
  graphxml_statenames[S_graphxml_graph] = "graph";
  graphxml_statenames[S_graphxml_graph_1] = "graph";
  graphxml_statenames[S_graphxml_graph_2] = "graph";
  graphxml_statenames[S_graphxml_graph_3] = "graph";
  graphxml_statenames[S_graphxml_graph_4] = "graph";
  graphxml_statenames[S_graphxml_graph_5] = "graph";
  graphxml_statenames[E_graphxml_graph] = "graph";
  graphxml_statenames[ROOT_graphxml_node] = NULL;
  graphxml_statenames[AL_graphxml_node] = NULL;
  graphxml_statenames[E_graphxml_node] = "node";
  graphxml_statenames[ROOT_graphxml_edge] = NULL;
  graphxml_statenames[AL_graphxml_edge] = NULL;
  graphxml_statenames[E_graphxml_edge] = "edge";
  }

 /* COMMENTS and PIs: handled uniformly for efficiency. */

<ROOT_graphxml_graph,AL_graphxml_graph,S_graphxml_graph,S_graphxml_graph_1,S_graphxml_graph_2,S_graphxml_graph_3,S_graphxml_graph_4,S_graphxml_graph_5,E_graphxml_graph,ROOT_graphxml_node,AL_graphxml_node,E_graphxml_node,ROOT_graphxml_edge,AL_graphxml_edge,E_graphxml_edge,PROLOG,DOCTYPE,EPILOG>{
 "<!--" ENTER(INCOMMENT);
 "<?" ENTER(INPI);
}
<INCOMMENT>{
 "-->"		LEAVE;
 "--"		|
 .		|
 \n		SKIP;
 <<EOF>>	FAIL("EOF in comment.");
}
<INPI>{
 "?>"		LEAVE;
 .		|
 \n		SKIP;
 <<EOF>>	FAIL("EOF in PI (processing instruction).");
}

 /* SPACES: skipped uniformly */

<ROOT_graphxml_graph,AL_graphxml_graph,S_graphxml_graph,S_graphxml_graph_1,S_graphxml_graph_2,S_graphxml_graph_3,S_graphxml_graph_4,S_graphxml_graph_5,E_graphxml_graph,ROOT_graphxml_node,AL_graphxml_node,E_graphxml_node,ROOT_graphxml_edge,AL_graphxml_edge,E_graphxml_edge,PROLOG,DOCTYPE,EPILOG>{S} SKIP;

 /* PROLOG: determine root element and process it. */

<PROLOG>{
 "<?xml"({S}version{Eq}(\'{VersionNum}\'|\"{VersionNum}\"))?({S}encoding{Eq}(\'[^']*\'|\"[^"]*\"))?"?>" SET(DOCTYPE); 
 "<?xml"[^>]*">" FAIL("Bad declaration %s.",yytext);
}

<PROLOG,DOCTYPE>{
 "<!DOCTYPE"{S}"edge"{S}SYSTEM{S}("'graphxml.dtd'"|"\"graphxml.dtd\""){s}">" SET(ROOT_graphxml_edge);
 "<!DOCTYPE"{S}"node"{S}SYSTEM{S}("'graphxml.dtd'"|"\"graphxml.dtd\""){s}">" SET(ROOT_graphxml_node);
 "<!DOCTYPE"{S}"graph"{S}SYSTEM{S}("'graphxml.dtd'"|"\"graphxml.dtd\""){s}">" SET(ROOT_graphxml_graph);
 "<!"[^>-][^>]*">" FAIL("Bad declaration %s.",yytext);
 . 		FAIL("Unexpected character `%c' in prolog.", yytext[0]);
 <<EOF>> 	FAIL("EOF in prolog.");
}

 /* RULES DERIVED FROM DTD. */

 /* <!-- Small DTD for xbt graphs. -->  */

 /*     isDirected (true|false) "true"
  * >  */

<S_graphxml_graph,S_graphxml_graph_3,S_graphxml_graph_1,S_graphxml_graph_5,S_graphxml_graph_2,S_graphxml_graph_4,E_graphxml_graph>"<graph"{s} FAIL("Starting tag <graph> is not allowed here.");

<ROOT_graphxml_graph>"<graph"{s} {
  AX_graphxml_graph_isDirected = A_graphxml_graph_isDirected_true;
  ENTER(AL_graphxml_graph); pushbuffer(0);
  }

<AL_graphxml_graph>{
 "isDirected"{Eq}"'true'" |
 "isDirected"{Eq}"\"true\"" A_graphxml_graph_isDirected = A_graphxml_graph_isDirected_true;
 "isDirected"{Eq}"'false'" |
 "isDirected"{Eq}"\"false\"" A_graphxml_graph_isDirected = A_graphxml_graph_isDirected_false;

 ">" {
  LEAVE; STag_graphxml_graph();graphxml_pcdata_ix = 0; ENTER(S_graphxml_graph);
 }
 "/>" {
  LEAVE; STag_graphxml_graph(); graphxml_pcdata_ix = 0; ETag_graphxml_graph(); popbuffer(); /* attribute */
  switch (YY_START) {
   case ROOT_graphxml_graph: SET(EPILOG); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of graph element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `graph' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `graph' element.");
}

<S_graphxml_graph_1,E_graphxml_graph,S_graphxml_graph_3,S_graphxml_graph_5,S_graphxml_graph>{
 "</graph"{s}">" {
  LEAVE;
  ETag_graphxml_graph();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case ROOT_graphxml_graph: SET(EPILOG); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</graph>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</graph>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</graph>' expected.");
}

 /*     label           CDATA                ""
  *     name            CDATA                #REQUIRED
  *     data            CDATA                ""
  *     position_x	    CDATA		 "-1.0"
  *     position_y	    CDATA		 "-1.0"
  * >  */

<S_graphxml_graph_1,S_graphxml_graph_5,S_graphxml_graph_4,E_graphxml_graph>"<node"{s} FAIL("Starting tag <node> is not allowed here.");

<ROOT_graphxml_node,S_graphxml_graph_2,S_graphxml_graph_3,S_graphxml_graph>"<node"{s} {
  AX_graphxml_node_label = 0;
  AX_graphxml_node_name = 0;
  AX_graphxml_node_data = 0;
  AX_graphxml_node_position_x = 1;
  AX_graphxml_node_position_y = 6;
  ENTER(AL_graphxml_node); pushbuffer(0);
  }

<AL_graphxml_node>{
 "label"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_node_label);
 "label"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_node_label);

 "name"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_node_name);
 "name"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_node_name);

 "data"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_node_data);
 "data"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_node_data);

 "position_x"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_node_position_x);
 "position_x"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_node_position_x);

 "position_y"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_node_position_y);
 "position_y"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_node_position_y);

 ">" {
  if (!AX_graphxml_node_name) FAIL("Required attribute `name' not set for `node' element.");
  LEAVE; STag_graphxml_node();graphxml_pcdata_ix = 0; ENTER(E_graphxml_node);
 }
 "/>" {
  if (!AX_graphxml_node_name) FAIL("Required attribute `name' not set for `node' element.");
  LEAVE; STag_graphxml_node(); graphxml_pcdata_ix = 0; ETag_graphxml_node(); popbuffer(); /* attribute */
  switch (YY_START) {
   case S_graphxml_graph_2: case S_graphxml_graph_3: case S_graphxml_graph: SET(S_graphxml_graph_3); break;
   case ROOT_graphxml_node: SET(EPILOG); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of node element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `node' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `node' element.");
}

<E_graphxml_node>{
 "</node"{s}">" {
  LEAVE;
  ETag_graphxml_node();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case S_graphxml_graph_2: case S_graphxml_graph_3: case S_graphxml_graph: SET(S_graphxml_graph_3); break;
   case ROOT_graphxml_node: SET(EPILOG); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</node>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</node>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</node>' expected.");
}

 /*     label           CDATA                ""
  *     name            CDATA               #IMPLIED
  *     source          CDATA               #REQUIRED
  *     target          CDATA               #REQUIRED
  *     length          CDATA               "-1.0"
  *     data            CDATA               ""
  * >  */

<E_graphxml_graph,S_graphxml_graph_2>"<edge"{s} FAIL("Starting tag <edge> is not allowed here.");

<ROOT_graphxml_edge,S_graphxml_graph_1,S_graphxml_graph_3,S_graphxml_graph_5,S_graphxml_graph_4,S_graphxml_graph>"<edge"{s} {
  AX_graphxml_edge_label = 0;
  AX_graphxml_edge_name = 0;
  AX_graphxml_edge_source = 0;
  AX_graphxml_edge_target = 0;
  AX_graphxml_edge_length = 11;
  AX_graphxml_edge_data = 0;
  ENTER(AL_graphxml_edge); pushbuffer(0);
  }

<AL_graphxml_edge>{
 "label"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_edge_label);
 "label"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_edge_label);

 "name"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_edge_name);
 "name"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_edge_name);

 "source"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_edge_source);
 "source"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_edge_source);

 "target"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_edge_target);
 "target"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_edge_target);

 "length"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_edge_length);
 "length"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_edge_length);

 "data"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_graphxml_edge_data);
 "data"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_graphxml_edge_data);

 ">" {
  if (!AX_graphxml_edge_source) FAIL("Required attribute `source' not set for `edge' element.");
  if (!AX_graphxml_edge_target) FAIL("Required attribute `target' not set for `edge' element.");
  LEAVE; STag_graphxml_edge();graphxml_pcdata_ix = 0; ENTER(E_graphxml_edge);
 }
 "/>" {
  if (!AX_graphxml_edge_source) FAIL("Required attribute `source' not set for `edge' element.");
  if (!AX_graphxml_edge_target) FAIL("Required attribute `target' not set for `edge' element.");
  LEAVE; STag_graphxml_edge(); graphxml_pcdata_ix = 0; ETag_graphxml_edge(); popbuffer(); /* attribute */
  switch (YY_START) {
   case S_graphxml_graph_1: case S_graphxml_graph_3: case S_graphxml_graph_5: case S_graphxml_graph_4: case S_graphxml_graph: SET(S_graphxml_graph_5); break;
   case ROOT_graphxml_edge: SET(EPILOG); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of edge element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `edge' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `edge' element.");
}

<E_graphxml_edge>{
 "</edge"{s}">" {
  LEAVE;
  ETag_graphxml_edge();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case S_graphxml_graph_1: case S_graphxml_graph_3: case S_graphxml_graph_5: case S_graphxml_graph_4: case S_graphxml_graph: SET(S_graphxml_graph_5); break;
   case ROOT_graphxml_edge: SET(EPILOG); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</edge>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</edge>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</edge>' expected.");
}

 /* EPILOG: after the root element. */

<EPILOG>{
 . {SET(PROLOG); yyless(0); CLEANUP; return -1;}
 <<EOF>> 	SUCCEED;
}

 /* CHARACTER DATA. */

<IMPOSSIBLE,VALUE1,VALUE2>{
 /* Non-defined standard entities... */
"&amp;"  BUFFERPUTC('&');
"&lt;"   BUFFERPUTC('<');
"&gt;"   BUFFERPUTC('>');
"&apos;" BUFFERPUTC('\'');
"&quot;" BUFFERPUTC('"');

 /* Character entities. */
 "&#"[[:digit:]]+";"	BUFFERPUTC((unsigned char)atoi(yytext+2));
 "&#x"[[:xdigit:]]+";"	BUFFERPUTC((unsigned char)strtol(yytext+3,NULL,16));
}

<IMPOSSIBLE,VALUE1,VALUE2,CDATA>{
 "\n"		|
 "\r"		|
 "\r\n"		|
 "\n\r"		BUFFERPUTC('\n');
}

<IMPOSSIBLE>{
 "<![CDATA["	ENTER(CDATA);
 "]""]>"		FAIL("Unexpected `]""]>' in character data.");
}

<VALUE1>{
 \'		BUFFERDONE; LEAVE;
 <<EOF>>	FAIL("EOF in literal (\"'\" expected).");
}

<VALUE2>{
 \"		BUFFERDONE; LEAVE;
 <<EOF>>	FAIL("EOF in literal (`\"' expected).");
}

<IMPOSSIBLE,VALUE1,VALUE2>{
 [^<&]		BUFFERPUTC(yytext[0]);
 [<&]		FAIL("Spurious `%c' in character data.",yytext[0]);
}

<CDATA>{
 "]""]>"		LEAVE;
 /* "]""]"		BUFFERPUTC(yytext[0]); BUFFERPUTC(yytext[1]); */
 .		BUFFERPUTC(yytext[0]);
 <<EOF>>	FAIL("EOF in CDATA section.");
}

 /* Impossible rules to avoid warnings from flex(1). */
 /* Ideally, this should be replaced by code in flexml.pl that
    generates just the states not covered by other rules. */
<*>{
 .|[\n] FAIL("Syntax error on character `%c'.", yytext[0]);
}

%%

/* Element context stack lookup. */
int graphxml_element_context(int i)
{
  return (0<i && i<yy_start_stack_depth
	  ? yy_start_stack[yy_start_stack_ptr - i]
	  : 0);
}

#ifdef FLEX_DEBUG
void print_yy_stack(char* fmt, ...)
{
  int i = 0; va_list ap; va_start(ap, fmt);
  vfprintf(stderr, fmt, ap);
  if (graphxml_statenames) {
      for (i=1; i<yy_start_stack_ptr; i++) {
          fprintf(stderr, "%s/", graphxml_statenames[yy_start_stack[i] ]);
      }
      fprintf(stderr,"%s\n", graphxml_statenames[YY_START]);
  }
  va_end(ap);
}

void print_graphxml_bufferstack()
{
    int i;
    fputs("Buffer: ", stderr);
    for (i = 0; i < blimit; i++) {
       if ( graphxml_bufferstack[i] == '\377' ) break;
         putc(graphxml_bufferstack[i], stderr);
    }
    putc('\n', stderr);
}

static void debug_enter(int state, const char* statename) {
  yy_push_state(state);
  if (yy_flex_debug) {
       print_yy_stack("--ENTER(%s) : ",statename);
       print_graphxml_bufferstack();
  }
}

static void debug_leave(void) {
    if (yy_flex_debug) {
        print_yy_stack("--LEAVE : ");
	print_graphxml_bufferstack();
    }
  yy_pop_state();
}

static void debug_set(int state, const char* statename) {
  BEGIN(state);
  if (yy_flex_debug) print_yy_stack("--SET(%s) : ",statename);
}
#endif


static void cleanup(void)
{
    if (graphxml_statenames) {
        free(graphxml_statenames);
	graphxml_statenames = NULL;
    }
    free(graphxml_bufferstack);
    graphxml_bufferstack = NULL;

    free(indexstack);
    indexstack = NULL;
}


static int fail(const char* fmt, ...)
{
    int chars_left, used;
    va_list ap; va_start(ap, fmt);
#ifdef FLEXML_yylineno
    used = sprintf(flexml_err_msg,
		   "Invalid XML (XML input line %d, state %d): ",
		   yylineno, YY_START);
#else
    used = sprintf(flexml_err_msg,
		   "Invalid XML (state %d): ",
		   YY_START);
#endif
    chars_left = flexml_max_err_msg_size - used - 1;
    vsnprintf(flexml_err_msg + used, chars_left, fmt, ap);
    va_end(ap);

#ifndef FLEXML_quiet_parser
    /* print directly to sdterr */
    fprintf(stderr, "%s\n", flexml_err_msg);
    flexml_err_msg[0] = '\0';
#endif

    cleanup();

    return 1;
}
