if(enable_memcheck)
	exec_program("valgrind --version " OUTPUT_VARIABLE "VALGRIND_VERSION")
	if(VALGRIND_VERSION)
		string(REGEX MATCH "[0-9].[0-9].[0-9]" NEW_VALGRIND_VERSION "${VALGRIND_VERSION}")
		if(NEW_VALGRIND_VERSION)
			exec_program("${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/generate_memcheck_tests.pl ${CMAKE_HOME_DIRECTORY} ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/AddTests.cmake > ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/memcheck_tests.cmake")
		else(NEW_VALGRIND_VERSION)
			set(enable_memcheck false)
			message("Command valgrind not found --> enable_memcheck autoset to false.")
		endif(NEW_VALGRIND_VERSION)
	else(VALGRIND_VERSION)
		set(enable_memcheck false)
		message(FATAL_ERROR "Command valgrind not found --> enable_memcheck autoset to false.")
	endif(VALGRIND_VERSION)
endif(enable_memcheck)

### For code coverage
### Set some variables
SET(UPDATE_TYPE "svn")
SET(DROP_METHOD "http")
SET(DROP_SITE "cdash.inria.fr/CDash")
SET(DROP_LOCATION "/submit.php?project=${PROJECT_NAME}")
SET(DROP_SITE_CDASH TRUE)
SET(TRIGGER_SITE "http://cdash.inria.fr/CDash/cgi-bin/Submit-Random-TestingResults.cgi")
set(MEMORYCHECK_COMMAND_OPTIONS "--trace-children=yes --leak-check=full --show-reachable=yes --track-origins=yes --read-var-info=no")
SET(VALGRIND_COMMAND "${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/my_valgrind.pl")
SET(MEMORYCHECK_COMMAND "${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/my_valgrind.pl")
#If you use the --read-var-info option Memcheck will run more slowly but may give a more detailed description of any illegal address.

INCLUDE(CTest)
ENABLE_TESTING()

ADD_TEST(tesh-msg-get-sender	            perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite msg/get_sender.tesh)
ADD_TEST(tesh-simdag-reinit-costs	        perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/test_reinit_costs.tesh)
ADD_TEST(tesh-simdag-parser		            perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms basic_parsing_test.tesh)

IF(enable_debug)
ADD_TEST(tesh-simdag-parser-bogus-symmetric perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms two_hosts_asymetric.tesh)
ENDIF(enable_debug)

ADD_TEST(tesh-simdag-parser-sym-full		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms basic_parsing_test_sym_full.tesh)
ADD_TEST(tesh-simdag-flatifier		        perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms flatifier.tesh)
ADD_TEST(tesh-simdag-full-links		        perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms get_full_link.tesh)
ADD_TEST(tesh-simdag-basic0	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic0.tesh)
ADD_TEST(tesh-simdag-basic1	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic1.tesh)
ADD_TEST(tesh-simdag-basic2	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic2.tesh)
ADD_TEST(tesh-simdag-basic3	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic3.tesh)
ADD_TEST(tesh-simdag-basic4	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic4.tesh)
ADD_TEST(tesh-simdag-basic5	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic5.tesh)
ADD_TEST(tesh-simdag-basic6	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/basic6.tesh)
ADD_TEST(tesh-simdag-p2p-1	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/p2p/test_latency1.tesh)
ADD_TEST(tesh-simdag-p2p-2	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/p2p/test_latency2.tesh)
ADD_TEST(tesh-simdag-p2p-3	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/p2p/test_latency3.tesh)
ADD_TEST(tesh-simdag-p2p-4	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/p2p/test_latency_bound.tesh)
ADD_TEST(tesh-simdag-mxn-1	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/mxn/test_intra_all2all.tesh)
ADD_TEST(tesh-simdag-mxn-2	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/mxn/test_intra_independent_comm.tesh)
ADD_TEST(tesh-simdag-mxn-3	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/network/mxn/test_intra_scatter.tesh)
ADD_TEST(tesh-simdag-par-1	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/partask/test_comp_only_seq.tesh)
ADD_TEST(tesh-simdag-par-2	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/teshsuite simdag/partask/test_comp_only_par.tesh)

# MSG examples
ADD_TEST(msg-suspend		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg suspend/suspend.tesh)
ADD_TEST(msg-masterslave	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave.tesh)
ADD_TEST(msg-masterslave-forwarder	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave_forwarder.tesh)
ADD_TEST(msg-masterslave-failure	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave_failure.tesh)
ADD_TEST(msg-masterslave-bypass	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave_bypass.tesh)
ADD_TEST(msg-masterslave-mailbox	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave_mailbox.tesh)
ADD_TEST(msg-masterslave-vivaldi	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave_vivaldi.tesh)
ADD_TEST(msg-migration		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg migration/migration.tesh)
ADD_TEST(msg-ptask		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg parallel_task/parallel_task.tesh)
ADD_TEST(msg-priority		${CMAKE_HOME_DIRECTORY}/examples/msg/priority/priority.exe ${CMAKE_HOME_DIRECTORY}/examples/msg/small_platform.xml  ${CMAKE_HOME_DIRECTORY}/examples/msg/priority/deployment_priority.xml)
ADD_TEST(msg-properties		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg properties/msg_prop.tesh)
ADD_TEST(msg-trace		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg trace/trace.tesh)
ADD_TEST(msg-masterslave-cpu-ti	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg masterslave/masterslave_cpu_ti.tesh)
ADD_TEST(msg-icomms perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms peer.tesh)
ADD_TEST(msg-icomms-waitany ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/peer3 ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer05.xml)

IF(HAVE_TRACING)
  ADD_TEST(tracing-ms perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg tracing/ms.tesh)
  ADD_TEST(tracing-categories perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg tracing/categories.tesh)
  ADD_TEST(tracing-tasks perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg tracing/tasks.tesh)
  ADD_TEST(tracing-process-migration perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg tracing/procmig.tesh)
ENDIF(HAVE_TRACING)

IF(${ARCH_32_BITS})
  ADD_TEST(gras-ping-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/ping test_sg_32.tesh)
  ADD_TEST(gras-rpc-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc test_sg_32.tesh)
  ADD_TEST(gras-spawn-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn test_sg_32.tesh)
  ADD_TEST(gras-timer-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/timer test_sg_32.tesh)
  ADD_TEST(gras-chrono-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono test_sg_32.tesh)
  ADD_TEST(gras-simple-token-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple-token test_sg_32.tesh)
  ADD_TEST(gras-mmrpc-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc test_sg_32.tesh)
  ADD_TEST(gras-all2all-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all test_sg_32.tesh)
  ADD_TEST(gras-pmm-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm test_sg_32.tesh)
  ADD_TEST(gras-synchro-sg-32	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro test_sg_32.tesh)
ELSE(${ARCH_32_BITS})
  ADD_TEST(gras-ping-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/ping test_sg_64.tesh)
  ADD_TEST(gras-rpc-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/rpc test_sg_64.tesh)
  ADD_TEST(gras-spawn-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/spawn test_sg_64.tesh)
  ADD_TEST(gras-timer-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/timer test_sg_64.tesh)
  ADD_TEST(gras-chrono-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/chrono test_sg_64.tesh)
  ADD_TEST(gras-simple-token-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/mutual_exclusion/simple_token test_sg_64.tesh)
  ADD_TEST(gras-mmrpc-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/mmrpc test_sg_64.tesh)
  ADD_TEST(gras-all2all-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/all2all test_sg_64.tesh)
  ADD_TEST(gras-pmm-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/pmm test_sg_64.tesh)
  ADD_TEST(gras-synchro-sg-64	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/synchro test_sg_64.tesh)
ENDIF(${ARCH_32_BITS})
ADD_TEST(gras-properties-sg	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/gras/properties test_sg.tesh)

# simdag examples
ADD_TEST(simdag-test-simdag	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/simdag test_simdag.tesh)
ADD_TEST(simdag-test-simdag2	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/simdag test_simdag2.tesh)
ADD_TEST(simdag-test-simdag-seq-access	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/simdag test_simdag_seq_access.tesh)
ADD_TEST(simdag-test-prop	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/simdag properties/test_prop.tesh)
ADD_TEST(simdag-metaxml-test	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/simdag metaxml/metaxml_test.tesh)
set_tests_properties(simdag-metaxml_test PROPERTIES WILL_FAIL true)
ADD_TEST(simdag-minmin-test	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/simdag/scheduling test_minmin.tesh)

if(enable_smpi)
# smpi examples
ADD_TEST(smpi-bcast 	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_BINARY_DIR}/examples/smpi ${CMAKE_HOME_DIRECTORY}/examples/smpi/bcast.tesh)
ADD_TEST(smpi-reduce 	perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_BINARY_DIR}/examples/smpi ${CMAKE_HOME_DIRECTORY}/examples/smpi/reduce.tesh)
if(HAVE_TRACING)
  ADD_TEST(smpi-tracing-ptp perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_BINARY_DIR}/examples/smpi ${CMAKE_HOME_DIRECTORY}/examples/smpi/smpi_traced.tesh)
endif(HAVE_TRACING)
endif(enable_smpi)
								
# examples/msg/mc
if(HAVE_MC)
ADD_TEST(mc-bugged1			perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg/mc bugged1.tesh)
ADD_TEST(mc-bugged2			perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg/mc bugged2.tesh)
ADD_TEST(mc-centralized		perl ${CMAKE_HOME_DIRECTORY}/buildtools/Cmake/tesh.pl ${CMAKE_HOME_DIRECTORY}/examples/msg/mc centralized.tesh)
endif(HAVE_MC)

ADD_TEST(tesh-simdag-full-links01		${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/basic_parsing_test ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/two_clusters.xml FULL_LINK)
ADD_TEST(tesh-simdag-full-links02		${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/basic_parsing_test ${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/two_clusters_one_name.xml FULL_LINK)
ADD_TEST(tesh-simdag-one-link-g5k		${CMAKE_HOME_DIRECTORY}/teshsuite/simdag/platforms/basic_parsing_test ${CMAKE_HOME_DIRECTORY}/examples/platforms/g5k.xml ONE_LINK)
ADD_TEST(msg-icomms-waitany 			${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/peer3 ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/small_platform.xml ${CMAKE_HOME_DIRECTORY}/examples/msg/icomms/deployment_peer05.xml)

# testsuite directory
add_test(test-xbt-log		${CMAKE_HOME_DIRECTORY}/testsuite/xbt/log_usage)
add_test(test-xbt-graphxml	${CMAKE_HOME_DIRECTORY}/testsuite/xbt/graphxml_usage ${CMAKE_HOME_DIRECTORY}/testsuite/xbt/graph.xml)
add_test(test-xbt-heap		${CMAKE_HOME_DIRECTORY}/testsuite/xbt/heap_bench)

add_test(test-surf-lmm		${CMAKE_HOME_DIRECTORY}/testsuite/surf/lmm_usage)
add_test(test-surf-maxmin	${CMAKE_HOME_DIRECTORY}/testsuite/surf/maxmin_bench)
add_test(test-surf-usage	${CMAKE_HOME_DIRECTORY}/testsuite/surf/surf_usage  --cfg=path:${CMAKE_HOME_DIRECTORY}/testsuite/surf/ platform.xml)
add_test(test-surf-usage2	${CMAKE_HOME_DIRECTORY}/testsuite/surf/surf_usage2  --cfg=path:${CMAKE_HOME_DIRECTORY}/testsuite/surf/ platform.xml)
add_test(test-surf-trace	${CMAKE_HOME_DIRECTORY}/testsuite/surf/trace_usage --cfg=path:${CMAKE_HOME_DIRECTORY}/testsuite/surf/)

add_test(testall		${CMAKE_HOME_DIRECTORY}/src/testall)


