/*
 *  Part of the shrinkta program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <bonobo.h>
#include <gnome.h>

#include <dvd.h>

#include "preferences.h"
#include "app.h"
#include "dialogs.h"
#include "pipe.h"
#include "multiplex.h"


static void
child_setup_func		(gpointer	 data)
{
	PipeHandle *handle;

	handle = (PipeHandle *) data;
}

gboolean
multiplx_streams	(const gchar	*path,
			 const gchar	*video_path,
			 gint32		 video_sync,
			 const gchar	*audio1_path,
			 const gchar	*audio2_path,
			 guint		 size_mb,
			 progress_func	 func)
{
	PipeHandle mplex_handle;
	gchar *args[16];
	gboolean ok;
	struct stat filestat;
	gdouble percent = 0.0;
	
	g_assert (path != NULL);
	g_assert (video_path != NULL);
	g_assert (audio1_path != NULL);
	
	func ("Combining video and audio tracks", 0.0);
	
	/* ToDo - speed things up by removing a 4.3gb disk write -: */
	/* Try to open a fifo and let mplex write to that */
	/* then run dvdauthor to read mpg file from the fifo ?? */
	
	/*mplex -f 8 -o "movie%d.mpg" shrink.m2v movie.ac3 */
	
	/* why isn't the args param of g_spawn_async_with_pipes () a constant? */
	args[0] = "mplex";
	args[1] = "-v";
	args[2] = "1";
	args[3] = "-f";
	args[4] = "8";
	args[5] = "-M";
	args[6] = "-S0";
	args[7] = "-O";
	args[8] = g_strdup_printf ("%umpt", video_sync);
	args[9] = "-o";
	args[10] = g_strdup (path);
	args[11] = g_strdup (video_path);
	args[12] = g_strdup (audio1_path);
	
	
	if (audio2_path != NULL) {
		args[13] = g_strdup (audio2_path);
		args[14] = NULL;
	} else {
		args[13] = NULL;
	}
	
	mplex_handle.func = func;
	ok = g_spawn_async_with_pipes (NULL,
				       args,
				       NULL,
				       G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD,
				       child_setup_func,
				       &mplex_handle,
				       &mplex_handle.child,
				       NULL,
				       NULL,
				       NULL,
				       NULL);
	g_free (args[8]);
	g_free (args[10]);
	g_free (args[11]);
	g_free (args[12]);
	g_free (args[13]);
	if (ok == FALSE) {
		g_warning ("can't spawn mplex process");
		return FALSE;
	}
	
	while (1) {
		pid_t retpid;
		gint status = 0;
		
		retpid = waitpid (mplex_handle.child, &status, WNOHANG);
		
		if (status > 0) {
			if (WIFEXITED (status)) {
				g_message ("mplex normal exit");
				break;
			} else if (WIFSIGNALED (status)) {
				g_warning ("mplex signaled to death");
				break;
			}
		}
		if (retpid >= 0) {
			gdouble movie_size;
			
			if (stat (path, &filestat) == 0) {
				gdouble done;
				
				movie_size = filestat.st_size / 0x100000;
				done = movie_size / size_mb;
				if (done >= percent + 0.01) {
					percent = done;
					if (percent > 1.0) percent = 1.0;
					func (NULL, percent);
				}
			}
		} else if (retpid < 0) {
			if (errno != ECHILD) {
				perror ("mplex_mpg");
			}
			break;
		}
		g_usleep (200);
	}
	g_message ("movie mixing done");
	return TRUE;
}
