/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-time.h DvdTime header file
 * @ingroup core
 *
 * libdvd
 */
#ifndef __DVD_TIME_H__
#define __DVD_TIME_H__

guint32	 dvd_read_time_to_time_stamp	 (gpointer	 dvd_read_time);
DvdTime* dvd_time_new_from_time_stamp	 (guint32	 ts);
DvdTime* dvd_time_new_from_dvd_read_time (gpointer	 dvd_read_time);
DvdTime* dvd_time_set_from_time_stamp	 (DvdTime	*time,
					  guint32	 ts);
DvdTime* dvd_time_set_from_dvd_read_time (DvdTime	*time,
					  gpointer	 dvd_read_time);

#endif /* __DVD_TIME__ */
