/*
  File autogenerated by gengetopt version 2.18
  generated with the following command:
  gengetopt --unamed-opts=REALM [PRINCIPAL] --no-handle-help --no-handle-error --input shisa.ggo --file-name shisa_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "shisa_cmd.h"

const char *gengetopt_args_info_purpose = "Manipulate information stored in the Shisa user database.";

const char *gengetopt_args_info_usage = "Usage: shisa [OPTIONS]... [REALM [PRINCIPAL]]...";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nOperations:",
  "  -a, --add                     Add realm or principal to database.",
  "  -d, --dump                    Dump entries in database.",
  "  -n, --key-add                 Add new key to a principal in database.",
  "      --key-remove              Remove a key from a principal in database.",
  "  -l, --list                    List entries in database.",
  "  -m, --modify                  Modify principal entry in database.",
  "  -r, --remove                  Remove realm or principal from database.",
  "\nParameters:",
  "  -f, --force                   Allow removal of non-empty realms.\n                                    (default=off)",
  "      --enabled                 Only dump or list enabled principals.\n                                    (default=off)",
  "      --disabled                Only dump or list disabled principals.\n                                    (default=off)",
  "      --keys                    Print cryptographic key and password in hostkey \n                                  format.  (default=off)",
  "\nValues:",
  "  -E, --encryption-type=STRING  Override default key encryption type.  Valid \n                                  values include 'aes128', 'aes256', 'aes' \n                                  (same as 'aes256'), '3des', 'des-md5', \n                                  'des-md4', 'des-crc', 'des' (same as \n                                  'des-md5'), and 'arcfour'.",
  "      --key-version=NUMBER      Version of key.",
  "      --password[=STRING]       Derive key from this password.",
  "      --priority=NUMBER         Specify key priority, used to differentiate \n                                  between keys when multiple keys are eligible \n                                  for use.  Higher value means higher priority. \n                                   (default is 0, which mean a random key of \n                                  the best etype is chosen)",
  "      --random                  Use a random key.  (default)",
  "      --salt=STRING             Use specified salt for deriving key.  Defaults \n                                  to concatenation of realm and (unwrapped) \n                                  principal name.",
  "      --string-to-key-parameter=HEX\n                                Encryption algorithm specific parameter for \n                                  password derivation.  Currently only the AES \n                                  algorithm can utilize this, where it is \n                                  interpreted as the iteration count of the \n                                  PKCS#5 PBKDF2 key deriver.",
  "\nOther options:",
  "  -c, --configuration-file=FILE Use specified configuration file.",
  "  -o, --library-options=STRING  Parse string as configuration file statement.",
  "  -v, --verbose                 Produce verbose output.\n                                    (default=off)",
  "  -q, --quiet                   Don't produce any diagnostic output.\n                                    (default=off)",
    0
};

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->add_given = 0 ;
  args_info->dump_given = 0 ;
  args_info->key_add_given = 0 ;
  args_info->key_remove_given = 0 ;
  args_info->list_given = 0 ;
  args_info->modify_given = 0 ;
  args_info->remove_given = 0 ;
  args_info->force_given = 0 ;
  args_info->enabled_given = 0 ;
  args_info->disabled_given = 0 ;
  args_info->keys_given = 0 ;
  args_info->encryption_type_given = 0 ;
  args_info->key_version_given = 0 ;
  args_info->password_given = 0 ;
  args_info->priority_given = 0 ;
  args_info->random_given = 0 ;
  args_info->salt_given = 0 ;
  args_info->string_to_key_parameter_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->library_options_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->force_flag = 0;
  args_info->enabled_flag = 0;
  args_info->disabled_flag = 0;
  args_info->keys_flag = 0;
  args_info->encryption_type_arg = NULL;
  args_info->encryption_type_orig = NULL;
  args_info->key_version_orig = NULL;
  args_info->password_arg = NULL;
  args_info->password_orig = NULL;
  args_info->priority_orig = NULL;
  args_info->salt_arg = NULL;
  args_info->salt_orig = NULL;
  args_info->string_to_key_parameter_arg = NULL;
  args_info->string_to_key_parameter_orig = NULL;
  args_info->configuration_file_arg = NULL;
  args_info->configuration_file_orig = NULL;
  args_info->library_options_arg = NULL;
  args_info->library_options_orig = NULL;
  args_info->verbose_flag = 0;
  args_info->quiet_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->add_help = gengetopt_args_info_help[3] ;
  args_info->dump_help = gengetopt_args_info_help[4] ;
  args_info->key_add_help = gengetopt_args_info_help[5] ;
  args_info->key_remove_help = gengetopt_args_info_help[6] ;
  args_info->list_help = gengetopt_args_info_help[7] ;
  args_info->modify_help = gengetopt_args_info_help[8] ;
  args_info->remove_help = gengetopt_args_info_help[9] ;
  args_info->force_help = gengetopt_args_info_help[11] ;
  args_info->enabled_help = gengetopt_args_info_help[12] ;
  args_info->disabled_help = gengetopt_args_info_help[13] ;
  args_info->keys_help = gengetopt_args_info_help[14] ;
  args_info->encryption_type_help = gengetopt_args_info_help[16] ;
  args_info->key_version_help = gengetopt_args_info_help[17] ;
  args_info->password_help = gengetopt_args_info_help[18] ;
  args_info->priority_help = gengetopt_args_info_help[19] ;
  args_info->random_help = gengetopt_args_info_help[20] ;
  args_info->salt_help = gengetopt_args_info_help[21] ;
  args_info->string_to_key_parameter_help = gengetopt_args_info_help[22] ;
  args_info->configuration_file_help = gengetopt_args_info_help[24] ;
  args_info->library_options_help = gengetopt_args_info_help[25] ;
  args_info->verbose_help = gengetopt_args_info_help[26] ;
  args_info->quiet_help = gengetopt_args_info_help[27] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  printf("\n%s\n\n", gengetopt_args_info_usage);
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->encryption_type_arg)
    {
      free (args_info->encryption_type_arg); /* free previous argument */
      args_info->encryption_type_arg = 0;
    }
  if (args_info->encryption_type_orig)
    {
      free (args_info->encryption_type_orig); /* free previous argument */
      args_info->encryption_type_orig = 0;
    }
  if (args_info->key_version_orig)
    {
      free (args_info->key_version_orig); /* free previous argument */
      args_info->key_version_orig = 0;
    }
  if (args_info->password_arg)
    {
      free (args_info->password_arg); /* free previous argument */
      args_info->password_arg = 0;
    }
  if (args_info->password_orig)
    {
      free (args_info->password_orig); /* free previous argument */
      args_info->password_orig = 0;
    }
  if (args_info->priority_orig)
    {
      free (args_info->priority_orig); /* free previous argument */
      args_info->priority_orig = 0;
    }
  if (args_info->salt_arg)
    {
      free (args_info->salt_arg); /* free previous argument */
      args_info->salt_arg = 0;
    }
  if (args_info->salt_orig)
    {
      free (args_info->salt_orig); /* free previous argument */
      args_info->salt_orig = 0;
    }
  if (args_info->string_to_key_parameter_arg)
    {
      free (args_info->string_to_key_parameter_arg); /* free previous argument */
      args_info->string_to_key_parameter_arg = 0;
    }
  if (args_info->string_to_key_parameter_orig)
    {
      free (args_info->string_to_key_parameter_orig); /* free previous argument */
      args_info->string_to_key_parameter_orig = 0;
    }
  if (args_info->configuration_file_arg)
    {
      free (args_info->configuration_file_arg); /* free previous argument */
      args_info->configuration_file_arg = 0;
    }
  if (args_info->configuration_file_orig)
    {
      free (args_info->configuration_file_orig); /* free previous argument */
      args_info->configuration_file_orig = 0;
    }
  if (args_info->library_options_arg)
    {
      free (args_info->library_options_arg); /* free previous argument */
      args_info->library_options_arg = 0;
    }
  if (args_info->library_options_orig)
    {
      free (args_info->library_options_orig); /* free previous argument */
      args_info->library_options_orig = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->add_given) {
    fprintf(outfile, "%s\n", "add");
  }
  if (args_info->dump_given) {
    fprintf(outfile, "%s\n", "dump");
  }
  if (args_info->key_add_given) {
    fprintf(outfile, "%s\n", "key-add");
  }
  if (args_info->key_remove_given) {
    fprintf(outfile, "%s\n", "key-remove");
  }
  if (args_info->list_given) {
    fprintf(outfile, "%s\n", "list");
  }
  if (args_info->modify_given) {
    fprintf(outfile, "%s\n", "modify");
  }
  if (args_info->remove_given) {
    fprintf(outfile, "%s\n", "remove");
  }
  if (args_info->force_given) {
    fprintf(outfile, "%s\n", "force");
  }
  if (args_info->enabled_given) {
    fprintf(outfile, "%s\n", "enabled");
  }
  if (args_info->disabled_given) {
    fprintf(outfile, "%s\n", "disabled");
  }
  if (args_info->keys_given) {
    fprintf(outfile, "%s\n", "keys");
  }
  if (args_info->encryption_type_given) {
    if (args_info->encryption_type_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "encryption-type", args_info->encryption_type_orig);
    } else {
      fprintf(outfile, "%s\n", "encryption-type");
    }
  }
  if (args_info->key_version_given) {
    if (args_info->key_version_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "key-version", args_info->key_version_orig);
    } else {
      fprintf(outfile, "%s\n", "key-version");
    }
  }
  if (args_info->password_given) {
    if (args_info->password_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "password", args_info->password_orig);
    } else {
      fprintf(outfile, "%s\n", "password");
    }
  }
  if (args_info->priority_given) {
    if (args_info->priority_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "priority", args_info->priority_orig);
    } else {
      fprintf(outfile, "%s\n", "priority");
    }
  }
  if (args_info->random_given) {
    fprintf(outfile, "%s\n", "random");
  }
  if (args_info->salt_given) {
    if (args_info->salt_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "salt", args_info->salt_orig);
    } else {
      fprintf(outfile, "%s\n", "salt");
    }
  }
  if (args_info->string_to_key_parameter_given) {
    if (args_info->string_to_key_parameter_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "string-to-key-parameter", args_info->string_to_key_parameter_orig);
    } else {
      fprintf(outfile, "%s\n", "string-to-key-parameter");
    }
  }
  if (args_info->configuration_file_given) {
    if (args_info->configuration_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "configuration-file", args_info->configuration_file_orig);
    } else {
      fprintf(outfile, "%s\n", "configuration-file");
    }
  }
  if (args_info->library_options_given) {
    if (args_info->library_options_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "library-options", args_info->library_options_orig);
    } else {
      fprintf(outfile, "%s\n", "library-options");
    }
  }
  if (args_info->verbose_given) {
    fprintf(outfile, "%s\n", "verbose");
  }
  if (args_info->quiet_given) {
    fprintf(outfile, "%s\n", "quiet");
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "add",	0, NULL, 'a' },
        { "dump",	0, NULL, 'd' },
        { "key-add",	0, NULL, 'n' },
        { "key-remove",	0, NULL, 0 },
        { "list",	0, NULL, 'l' },
        { "modify",	0, NULL, 'm' },
        { "remove",	0, NULL, 'r' },
        { "force",	0, NULL, 'f' },
        { "enabled",	0, NULL, 0 },
        { "disabled",	0, NULL, 0 },
        { "keys",	0, NULL, 0 },
        { "encryption-type",	1, NULL, 'E' },
        { "key-version",	1, NULL, 0 },
        { "password",	2, NULL, 0 },
        { "priority",	1, NULL, 0 },
        { "random",	0, NULL, 0 },
        { "salt",	1, NULL, 0 },
        { "string-to-key-parameter",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 'c' },
        { "library-options",	1, NULL, 'o' },
        { "verbose",	0, NULL, 'v' },
        { "quiet",	0, NULL, 'q' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVadnlmrfE:c:o:vq", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          cmdline_parser_free (&local_args_info);
          return 0;

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'a':	/* Add realm or principal to database..  */
          if (local_args_info.add_given)
            {
              fprintf (stderr, "%s: `--add' (`-a') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->add_given && ! override)
            continue;
          local_args_info.add_given = 1;
          args_info->add_given = 1;
          break;

        case 'd':	/* Dump entries in database..  */
          if (local_args_info.dump_given)
            {
              fprintf (stderr, "%s: `--dump' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->dump_given && ! override)
            continue;
          local_args_info.dump_given = 1;
          args_info->dump_given = 1;
          break;

        case 'n':	/* Add new key to a principal in database..  */
          if (local_args_info.key_add_given)
            {
              fprintf (stderr, "%s: `--key-add' (`-n') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->key_add_given && ! override)
            continue;
          local_args_info.key_add_given = 1;
          args_info->key_add_given = 1;
          break;

        case 'l':	/* List entries in database..  */
          if (local_args_info.list_given)
            {
              fprintf (stderr, "%s: `--list' (`-l') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->list_given && ! override)
            continue;
          local_args_info.list_given = 1;
          args_info->list_given = 1;
          break;

        case 'm':	/* Modify principal entry in database..  */
          if (local_args_info.modify_given)
            {
              fprintf (stderr, "%s: `--modify' (`-m') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->modify_given && ! override)
            continue;
          local_args_info.modify_given = 1;
          args_info->modify_given = 1;
          break;

        case 'r':	/* Remove realm or principal from database..  */
          if (local_args_info.remove_given)
            {
              fprintf (stderr, "%s: `--remove' (`-r') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->remove_given && ! override)
            continue;
          local_args_info.remove_given = 1;
          args_info->remove_given = 1;
          break;

        case 'f':	/* Allow removal of non-empty realms.\n.  */
          if (local_args_info.force_given)
            {
              fprintf (stderr, "%s: `--force' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->force_given && ! override)
            continue;
          local_args_info.force_given = 1;
          args_info->force_given = 1;
          args_info->force_flag = !(args_info->force_flag);
          break;

        case 'E':	/* Override default key encryption type.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
          if (local_args_info.encryption_type_given)
            {
              fprintf (stderr, "%s: `--encryption-type' (`-E') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->encryption_type_given && ! override)
            continue;
          local_args_info.encryption_type_given = 1;
          args_info->encryption_type_given = 1;
          if (args_info->encryption_type_arg)
            free (args_info->encryption_type_arg); /* free previous string */
          args_info->encryption_type_arg = gengetopt_strdup (optarg);
          if (args_info->encryption_type_orig)
            free (args_info->encryption_type_orig); /* free previous string */
          args_info->encryption_type_orig = gengetopt_strdup (optarg);
          break;

        case 'c':	/* Use specified configuration file..  */
          if (local_args_info.configuration_file_given)
            {
              fprintf (stderr, "%s: `--configuration-file' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->configuration_file_given && ! override)
            continue;
          local_args_info.configuration_file_given = 1;
          args_info->configuration_file_given = 1;
          if (args_info->configuration_file_arg)
            free (args_info->configuration_file_arg); /* free previous string */
          args_info->configuration_file_arg = gengetopt_strdup (optarg);
          if (args_info->configuration_file_orig)
            free (args_info->configuration_file_orig); /* free previous string */
          args_info->configuration_file_orig = gengetopt_strdup (optarg);
          break;

        case 'o':	/* Parse string as configuration file statement..  */
          if (local_args_info.library_options_given)
            {
              fprintf (stderr, "%s: `--library-options' (`-o') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->library_options_given && ! override)
            continue;
          local_args_info.library_options_given = 1;
          args_info->library_options_given = 1;
          if (args_info->library_options_arg)
            free (args_info->library_options_arg); /* free previous string */
          args_info->library_options_arg = gengetopt_strdup (optarg);
          if (args_info->library_options_orig)
            free (args_info->library_options_orig); /* free previous string */
          args_info->library_options_orig = gengetopt_strdup (optarg);
          break;

        case 'v':	/* Produce verbose output.\n.  */
          if (local_args_info.verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->verbose_given && ! override)
            continue;
          local_args_info.verbose_given = 1;
          args_info->verbose_given = 1;
          args_info->verbose_flag = !(args_info->verbose_flag);
          break;

        case 'q':	/* Don't produce any diagnostic output.\n.  */
          if (local_args_info.quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->quiet_given && ! override)
            continue;
          local_args_info.quiet_given = 1;
          args_info->quiet_given = 1;
          args_info->quiet_flag = !(args_info->quiet_flag);
          break;


        case 0:	/* Long option with no short option */
          /* Remove a key from a principal in database..  */
          if (strcmp (long_options[option_index].name, "key-remove") == 0)
          {
            if (local_args_info.key_remove_given)
              {
                fprintf (stderr, "%s: `--key-remove' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->key_remove_given && ! override)
              continue;
            local_args_info.key_remove_given = 1;
            args_info->key_remove_given = 1;
            break;
          }
          /* Only dump or list enabled principals.\n.  */
          else if (strcmp (long_options[option_index].name, "enabled") == 0)
          {
            if (local_args_info.enabled_given)
              {
                fprintf (stderr, "%s: `--enabled' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->enabled_given && ! override)
              continue;
            local_args_info.enabled_given = 1;
            args_info->enabled_given = 1;
            args_info->enabled_flag = !(args_info->enabled_flag);
          }
          /* Only dump or list disabled principals.\n.  */
          else if (strcmp (long_options[option_index].name, "disabled") == 0)
          {
            if (local_args_info.disabled_given)
              {
                fprintf (stderr, "%s: `--disabled' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->disabled_given && ! override)
              continue;
            local_args_info.disabled_given = 1;
            args_info->disabled_given = 1;
            args_info->disabled_flag = !(args_info->disabled_flag);
          }
          /* Print cryptographic key and password in hostkey format..  */
          else if (strcmp (long_options[option_index].name, "keys") == 0)
          {
            if (local_args_info.keys_given)
              {
                fprintf (stderr, "%s: `--keys' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->keys_given && ! override)
              continue;
            local_args_info.keys_given = 1;
            args_info->keys_given = 1;
            args_info->keys_flag = !(args_info->keys_flag);
          }
          /* Version of key..  */
          else if (strcmp (long_options[option_index].name, "key-version") == 0)
          {
            if (local_args_info.key_version_given)
              {
                fprintf (stderr, "%s: `--key-version' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->key_version_given && ! override)
              continue;
            local_args_info.key_version_given = 1;
            args_info->key_version_given = 1;
            args_info->key_version_arg = strtol (optarg, &stop_char, 0);
            if (!(stop_char && *stop_char == '\0')) {
              fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
              goto failure;
            }
            if (args_info->key_version_orig)
              free (args_info->key_version_orig); /* free previous string */
            args_info->key_version_orig = gengetopt_strdup (optarg);
          }
          /* Derive key from this password..  */
          else if (strcmp (long_options[option_index].name, "password") == 0)
          {
            if (local_args_info.password_given)
              {
                fprintf (stderr, "%s: `--password' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->password_given && ! override)
              continue;
            local_args_info.password_given = 1;
            args_info->password_given = 1;
            if (optarg)
              {
                if (args_info->password_arg)
                  free (args_info->password_arg); /* free previous string */
                args_info->password_arg = gengetopt_strdup (optarg);
                if (args_info->password_orig)
                  free (args_info->password_orig); /* free previous string */
                args_info->password_orig = gengetopt_strdup (optarg);
              }
          }
          /* Specify key priority, used to differentiate between keys when multiple keys are eligible for use.  Higher value means higher priority.  (default is 0, which mean a random key of the best etype is chosen).  */
          else if (strcmp (long_options[option_index].name, "priority") == 0)
          {
            if (local_args_info.priority_given)
              {
                fprintf (stderr, "%s: `--priority' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->priority_given && ! override)
              continue;
            local_args_info.priority_given = 1;
            args_info->priority_given = 1;
            args_info->priority_arg = strtol (optarg, &stop_char, 0);
            if (!(stop_char && *stop_char == '\0')) {
              fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
              goto failure;
            }
            if (args_info->priority_orig)
              free (args_info->priority_orig); /* free previous string */
            args_info->priority_orig = gengetopt_strdup (optarg);
          }
          /* Use a random key.  (default).  */
          else if (strcmp (long_options[option_index].name, "random") == 0)
          {
            if (local_args_info.random_given)
              {
                fprintf (stderr, "%s: `--random' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->random_given && ! override)
              continue;
            local_args_info.random_given = 1;
            args_info->random_given = 1;
            break;
          }
          /* Use specified salt for deriving key.  Defaults to concatenation of realm and (unwrapped) principal name..  */
          else if (strcmp (long_options[option_index].name, "salt") == 0)
          {
            if (local_args_info.salt_given)
              {
                fprintf (stderr, "%s: `--salt' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->salt_given && ! override)
              continue;
            local_args_info.salt_given = 1;
            args_info->salt_given = 1;
            if (args_info->salt_arg)
              free (args_info->salt_arg); /* free previous string */
            args_info->salt_arg = gengetopt_strdup (optarg);
            if (args_info->salt_orig)
              free (args_info->salt_orig); /* free previous string */
            args_info->salt_orig = gengetopt_strdup (optarg);
          }
          /* Encryption algorithm specific parameter for password derivation.  Currently only the AES algorithm can utilize this, where it is interpreted as the iteration count of the PKCS#5 PBKDF2 key deriver..  */
          else if (strcmp (long_options[option_index].name, "string-to-key-parameter") == 0)
          {
            if (local_args_info.string_to_key_parameter_given)
              {
                fprintf (stderr, "%s: `--string-to-key-parameter' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->string_to_key_parameter_given && ! override)
              continue;
            local_args_info.string_to_key_parameter_given = 1;
            args_info->string_to_key_parameter_given = 1;
            if (args_info->string_to_key_parameter_arg)
              free (args_info->string_to_key_parameter_arg); /* free previous string */
            args_info->string_to_key_parameter_arg = gengetopt_strdup (optarg);
            if (args_info->string_to_key_parameter_orig)
              free (args_info->string_to_key_parameter_orig); /* free previous string */
            args_info->string_to_key_parameter_orig = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
