#include "log.h"

#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>

#define LOGSIZE 10*1024

extern volatile int daemon_proc;
extern volatile int log_level;

// drivers/scsi/ncr53c8xx.c
void log_info(int level, char *fmt, ...)
{
	va_list args;
	char buf[LOGSIZE];

	if( level>log_level ) return;

	va_start(args, fmt);
	vsnprintf(buf, LOGSIZE-1, fmt, args);
	va_end(args);

	syslog(LOG_INFO|LOG_DAEMON, "%s", buf);
	if( daemon_proc==0 && stderr ) {
		fprintf(stderr, "%s\n", buf);
		fflush(stderr);
	}
}
