/***************************************************************************
                          song.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "song.h"

Song::Song(){

	version.major=SHAKETRACKER_VERSION_MAJOR;
	version.minor=SHAKETRACKER_VERSION_MINOR;
	version.revision=SHAKETRACKER_VERSION_REVISION;
	tracks=0;
        order.resize(200);
	reset();
	new_track_counter=0;
}


Song::~Song(){

	reset();
}

void Song::reset() {

	int i;
	speed.rpq=4;
	speed.tempo=150;
	while(tracks>0) delete_track(0);
	pattern_data.clear();
	pattern_data.resize(50);
	info.current_filename="";
	info.author="";
	info.comments="";
	while(user_devices.get_device_count()>0) user_devices.delete_device(0);
	regenerate_track_cache();
	regenerate_pattern_cache();
	for (i=0;i<order.size();i++) order[i]=ORDER_CLEAR;
}

/* TRACK MANAGING */

void Song::add_track(int p_columns=1){
        char name[3]={'0','0',0};
	string rname;

	track.resize(tracks+1);
	track[tracks] = new Track(&pattern_data);
	track[tracks]->set_width(p_columns);
	tracks++;
	regenerate_track_cache();
	regenerate_pattern_cache();


	track[tracks-1]->instrument.midi.channel=find_unused_channel(tracks-1);	
        name[0]='0'+((new_track_counter) /10) %10;
        name[1]='0'+(new_track_counter)%10;
        rname="New track ";
	rname=rname+name;
	track[tracks-1]->instrument.name=rname;

	new_track_counter++;
}

void Song::delete_track(int p_track){
	
	if ((p_track<0) || (p_track>=tracks)) ERROR("Request deletion of inexistent track: " << p_track);
	else {
		int i;
		delete track[p_track];
		for (i=p_track;i<tracks-1;i++) track[i]=track[i+1];
		tracks--;
		track.resize(tracks);
		regenerate_track_cache();
		regenerate_pattern_cache();
	}
}

void Song::clone_track(int p_track) {

	if ((p_track<0) || (p_track>=tracks)) ERROR("Request of cloning inexistent track: " << p_track);
	else {
		int i;
                p_track++;
		track.resize(tracks+1);
		tracks++;
		for (i=tracks-1;i>p_track;i--) track[i]=track[i-1];
		track[p_track]=new Track(&pattern_data);
		track[p_track]->instrument=track[p_track-1]->instrument;
		track[p_track]->instrument.midi.channel=find_unused_channel(p_track);			
		regenerate_track_cache();
	}
	
		
}

void Song::add_track_column(int p_track) {

	if ((p_track<0) || (p_track>=tracks)) {

		ERROR("Request add_track_column of inexistent track: " << p_track);
		return;
	}
		
	track[p_track]->add_column();

	regenerate_track_cache();
}
void Song::remove_track_column(int p_track) {

	if ((p_track<0) || (p_track>=tracks)) {

		ERROR("Request remove_track_column of inexistent track: " << p_track);
		return;
	}

	if (track[p_track]->get_width()>1) {

		track[p_track]->delete_column();
		regenerate_track_cache();
	}
}

int Song::get_track_width(int p_track) {

	if ((p_track<0) || (p_track>=tracks)) {

		ERROR("Request get_track_width of inexistent track: " << p_track);
		return 0;
	}

	return track[p_track]->get_width();
}


Instrument* Song::get_instrument(int p_track) {

	if ((p_track<0) || (p_track>=tracks)) {

		ERROR("Request get_instrument of inexistent track: " << p_track);
		return NULL;
	}

	return &track[p_track]->instrument;
}


bool Song::move_track_up(int p_track){
	

	if ((p_track<1) || (p_track>=tracks)) return false;

	Track *aux_track;

	aux_track=track[p_track];
	track[p_track]=track[p_track-1];
	track[p_track-1]=aux_track;

	regenerate_track_cache();

	return true;
}

bool Song::move_track_down(int p_track){ //move one track to the previous slot
	

	if ((p_track<0) || (p_track>=tracks-1)) return false;

	Track *aux_track;

	aux_track=track[p_track];
	track[p_track]=track[p_track+1];
	track[p_track+1]=aux_track;

	regenerate_track_cache();

	return true;
}

Track* Song::get_track(int p_track) {

	if ((p_track>=tracks)  || (p_track<0)) ERROR("Request for inexistent track" << p_track);

	return track[p_track];
}

/* PATTERN HANDLING */

void Song::set_pattern_length(int p_pattern,int p_length) {
        int i;

        if ((p_pattern<0) || (p_pattern>=pattern_data.size())) return;

	pattern_data[p_pattern].rowlength=p_length;
	for (i=0;i<tracks;i++) track[i]->adjust_pattern_data();	
	regenerate_pattern_cache();

}

int Song::get_pattern_length(int p_pattern) {

        if ((p_pattern<0) || (p_pattern>=pattern_data.size())) return 0;

	return pattern_data[p_pattern].rowlength;
}

void Song::set_pattern_hl_minor(int p_pattern,int p_hl) {

        if ((p_pattern<0) || (p_pattern>=pattern_data.size())) return;

	pattern_data[p_pattern].hlminor=p_hl;
}
int Song::get_pattern_hl_minor(int p_pattern) {

        if ((p_pattern<0) || (p_pattern>=pattern_data.size())) return 0;

	return pattern_data[p_pattern].hlminor;
}

void Song::set_pattern_hl_major(int p_pattern,int p_hl) {

        if ((p_pattern<0) || (p_pattern>=pattern_data.size())) return;

	pattern_data[p_pattern].hlmajor=p_hl;

}
int Song::get_pattern_hl_major(int p_pattern) {

        if ((p_pattern<0) || (p_pattern>=pattern_data.size())) return 0;

	return pattern_data[p_pattern].hlmajor;
}
int Song::get_patterns() {



	return pattern_data.size(); 	
}
/* NOTE GETTING */

Note Song::get_note(int p_track,int p_pattern,int p_column,int p_row) {

	return get_track(p_track)->get_pattern(p_pattern)->get_note(p_column,p_row);
}
                                       	
Note& Song::get_note_ref(int p_track,int p_pattern,int p_column,int p_row) {

	return get_track(p_track)->get_pattern(p_pattern)->get_note_ref(p_column,p_row);
}

Note Song::abs_note(int p_column,int p_row) {

	return get_track(track_cache[p_column].track)->get_pattern(pattern_cache[p_row].pattern)->get_note(track_cache[p_column].column,pattern_cache[p_row].row);
}

Note& Song::abs_note_ref(int p_column,int p_row) {

	return get_track(track_cache[p_column].track)->get_pattern(pattern_cache[p_row].pattern)->get_note_ref(track_cache[p_column].column,pattern_cache[p_row].row);
}

/* ORDERLIST */	


int Song::get_order(int p_position) {

	return order[p_position];

}

int Song::find_order(int p_pattern) {

	int i;
	for (i=0;i<order.size();i++) {

		if (order[i]==p_pattern) return i;		
	}
		
	return -1;
}

void Song::set_order(int p_position, int p_order) {

	order[p_position]=p_order;

}
int Song::get_max_order() {

	return order.size();
}

int Song::get_next_order(int p_position) {

        int baseorder,order_counter;

        order_counter=-1;

        baseorder=p_position;

        do {

                baseorder++;
                if ( baseorder>(order.size()-1) ) baseorder=0;
                order_counter++;
	
        } while ( (order[baseorder]<0) && ( order[baseorder]>pattern_data.size()-1 ) && (order_counter<order.size()) );


        if (order_counter==order.size()) {

                return -1;

        } else {

                return baseorder;
        }

}


void Song::regenerate_track_cache() {

	int i,j,count=0;

	for (i=0;i<tracks;i++) count+=track[i]->get_width();

	track_cache.resize(count);
	
	count=0;

	for (i=0;i<tracks;i++) {

		for (j=0;j<track[i]->get_width();j++) {

			track_cache[count].track=i;
			track_cache[count].column=j;
			count++;
		}
	}
}

void Song::regenerate_pattern_cache() {

	int i,j,count=0;

	for (i=0;i<pattern_data.size();i++) count+=pattern_data[i].rowlength;

	pattern_cache.resize(count);
	
	count=0;

	for (i=0;i<pattern_data.size();i++) {

		for (j=0;j<pattern_data[i].rowlength;j++) {

			pattern_cache[count].pattern=i;
			pattern_cache[count].row=j;
			count++;
		}
	}
}

int Song::get_abs_pattern(int p_row) {

	return pattern_cache[p_row].pattern;
}
int Song::get_abs_row(int p_row) {

	return pattern_cache[p_row].row;
}

int Song::get_global_row(int p_row,int p_pattern) {

	int i,count=0;;

	for (i=0;i<p_pattern;i++) {

         	count+=pattern_data[i].rowlength;
	}

	count+=p_row;

	return count;
		
}

int Song::get_abs_column(int p_column) {

	return track_cache[p_column].column;	
}
int Song::get_abs_track(int p_column) {

	return track_cache[p_column].track;	
}
int Song::get_abs_width() {

	return track_cache.size();
}
int Song::get_abs_height() {

	return pattern_cache.size();
}

int Song::find_unused_channel(int p_track) {

	bool used_channel[16];
	int i,dev;

	dev=track[p_track]->instrument.midi.device.get();
	for (i=0;i<16;i++) used_channel[i]=false;
	for (i=0;i<tracks;i++) {
        	
	        if (i==p_track) continue;

		if (track[i]->instrument.midi.device.get()==dev) {

			used_channel[track[i]->instrument.midi.channel.get()]=true;
		}
	}
	
	for (i=0;i<16;i++) {

		if (!used_channel[i]) return i;
	}

	return 0;
}

string Song::get_version_string() {

	char aux_str[20];
	sprintf(aux_str,"%i.%i.%i",version.major,version.minor,version.revision);
	return aux_str;
}