/***************************************************************************
                          player.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player.h"

Player::Play_Mode Player::get_play_mode() {

	switch (data.parameters.mode) {
	
		case PLAY_SONG: {
			
			return PLAY_SONG;
		} break;
		case PLAY_PATTERN: {
			
			return PLAY_PATTERN;
		} break;
                default: {
			return PLAY_NOTHING;		
		}
	}

}

void Player::reset_internal() {

	data.parameters.mode=PLAY_NOTHING;
	midiout->stop_notify();
	queue.clear();
	runner.reset();
	parser.reset();
}

void Player::stop_internal() {

	data.parameters.mode=PLAY_NOTHING;
	midiout->stop_notify();
	queue.clear();
	runner.stop();
	parser.reset();
}

void Player::set_song(Song *p_song) {

	song=p_song;
	parser.set_song(song);
	runner.set_song(song);
	data.song=song;
}

void Player::set_midiout(MidiOutDeviceManager *p_midiout) {

	midiout=p_midiout;
	runner.set_midiout(midiout);

}

void Player::set_lock(Mutex_Lock *p_lock) {

	lock=p_lock;
}

int Player::get_playing_row() {

	if (data.parameters.mode==PLAY_NOTHING) return -1;

	return data.position.row;
}
int Player::get_playing_pattern() {

	if (data.parameters.mode==PLAY_NOTHING) return -1;

	return data.position.pattern;
}
int Player::get_playing_order() {

	if (data.parameters.mode!=PLAY_SONG) return -1;

	return data.position.order;
}

int Player::get_playing_rpq() {


	return data.variables.rpq;
}
int Player::get_playing_tempo() {

	return data.variables.tempo;

}

Player::Player(){
        lock=NULL;
	parser.set_data(&data);
	parser.set_queue(&queue);
	queue.set_event_runner(&runner);
	old_mode=data.parameters.mode=PLAY_NOTHING;
	data.tmp.event_delay=0;
}
Player::~Player(){

}

bool Player::finished_playing() {

	return finished;
}