// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_GRAPH_TYPES_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_TYPES_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator_

struct AdjacencyIterator_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(196)

//____________________________________________________________________________
// Alphabet

template <typename T> struct Alphabet;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(99)

//____________________________________________________________________________
// Automaton

template <typename TAlphabet , typename TCargo , typename TSpec > struct Automaton;       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(53)

//____________________________________________________________________________
// AutomatonEdgeArray

template <typename TEdge, typename TAlphabet> class AutomatonEdgeArray;       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(46)

//____________________________________________________________________________
// BfsIterator_

struct BfsIterator_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(205)

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(68)

//____________________________________________________________________________
// DfsPreorder_

struct DfsPreorder_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(214)

//____________________________________________________________________________
// Directed

template <typename TCargo , typename TSpec > struct Directed;       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(41)

//____________________________________________________________________________
// EdgeDescriptor

template <typename T> struct EdgeDescriptor;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(58)

//____________________________________________________________________________
// EdgeIdHandler

template <typename T> struct EdgeIdHandler;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(117)

//____________________________________________________________________________
// EdgeIterator_

struct EdgeIterator_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(178)

//____________________________________________________________________________
// EdgeStump

template <typename TCargo , bool TList , bool TSource , bool TId , typename TSpec > class EdgeStump;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(228)

//____________________________________________________________________________
// EdgeType

template <typename T> struct EdgeType;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(84)

//____________________________________________________________________________
// ExactFragment

template <typename TSpec > struct ExactFragment;       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(58)

//____________________________________________________________________________
// ExactReversableFragment

template <typename TSpec > struct ExactReversableFragment;       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(77)

//____________________________________________________________________________
// Fragment

template <typename TSize , typename TSpec > class Fragment;       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(100)

//____________________________________________________________________________
// Graph

template <typename TSpec > class Graph;       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(75)

//____________________________________________________________________________
// GraphIterator

template <typename TSpec> struct GraphIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(46)

//____________________________________________________________________________
// Hmm

template <typename TAlphabet , typename TCargo , typename TSpec > struct Hmm;       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(57)

//____________________________________________________________________________
// IdManager

template <typename TIdType, typename TSpec> class IdManager;       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(58)
template <typename TIdType , typename TSpec > class IdManager;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(258)

//____________________________________________________________________________
// InternalAdjacencyIterator

template <typename TSpec > struct InternalAdjacencyIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(62)

//____________________________________________________________________________
// InternalBfsIterator

template <typename TSpec > struct InternalBfsIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(66)

//____________________________________________________________________________
// InternalDfsIterator

template <typename TSpec > struct InternalDfsIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(70)

//____________________________________________________________________________
// InternalEdgeIterator

template <typename TSpec > struct InternalEdgeIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(54)

//____________________________________________________________________________
// InternalMap

template <typename TContainer, unsigned int const MemberId > struct InternalMap;       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(254)

//____________________________________________________________________________
// InternalOutEdgeIterator

template <typename TSpec > struct InternalOutEdgeIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(58)

//____________________________________________________________________________
// InternalPointerMap

template <typename TPropmap, TPropmap const Instance> struct InternalPointerMap;       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(515)

//____________________________________________________________________________
// InternalVertexIterator

template <typename TSpec > struct InternalVertexIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_iterator.h"(50)

//____________________________________________________________________________
// OutEdgeIterator_

struct OutEdgeIterator_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(187)

//____________________________________________________________________________
// Tree

template <typename TCargo , typename TSpec > struct Tree;       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(49)

//____________________________________________________________________________
// TreeTag_

struct TreeTag_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(145)

//____________________________________________________________________________
// Undirected

template <typename TCargo , typename TSpec > struct Undirected;       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(45)

//____________________________________________________________________________
// VertexIdHandler

template <typename T> struct VertexIdHandler;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(131)
template <typename T> struct VertexIdHandler;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(279)

//____________________________________________________________________________
// VertexIterator_

struct VertexIterator_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(169)

//____________________________________________________________________________
// WithoutEdgeId_

struct WithoutEdgeId_;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(140)

//____________________________________________________________________________
// WordGraph

template <typename TSpec > struct WordGraph;       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(40)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdjacencyIterator

typedef Tag<AdjacencyIterator_> const AdjacencyIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(197)

//____________________________________________________________________________
// BfsIterator

typedef Tag<BfsIterator_> const BfsIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(206)

//____________________________________________________________________________
// DfsPreorder

typedef Tag<DfsPreorder_> const DfsPreorder;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(215)

//____________________________________________________________________________
// EdgeIterator

typedef Tag<EdgeIterator_> const EdgeIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(179)

//____________________________________________________________________________
// OutEdgeIterator

typedef Tag<OutEdgeIterator_> const OutEdgeIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(188)

//____________________________________________________________________________
// TreeTag

typedef Tag<TreeTag_> const TreeTag;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(146)

//____________________________________________________________________________
// VertexIterator

typedef Tag<VertexIterator_> const VertexIterator;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(170)

//____________________________________________________________________________
// WithoutEdgeId

typedef Tag<WithoutEdgeId_> const WithoutEdgeId;       	// "seqan-1.3.1/seqan/graph_types/graph_base.h"(141)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _addEdge

template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TNodeAttributes, typename TEdgeAttributes, typename TStatement> inline void _addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor sourceV, TVertexDescriptor targetV, TNodeAttributes&, TEdgeAttributes& edgeMap, TStatement& attr_list);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(623)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TNodeAttributes, typename TEdgeAttributes, typename TStatement> inline void _addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor sourceV, TVertexDescriptor targetV, TNodeAttributes&, TEdgeAttributes& edgeMap, TStatement& attr_list);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(641)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TNodeAttributes, typename TEdgeAttributes, typename TStatement> inline void _addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor sourceV, TVertexDescriptor targetV, TNodeAttributes&, TEdgeAttributes& edgeMap, TStatement& attr_list);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(659)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TNodeAttributes, typename TEdgeAttributes, typename TStatement> inline void _addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor sourceV, TVertexDescriptor targetV, TNodeAttributes&, TEdgeAttributes& edgeMap, TStatement& attr_list);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(697)
template <typename TSpec, typename TStatement, typename TNodeAttributes, typename TEdgeAttributes, typename TNodeIdMap> inline void _addEdge(Graph<TSpec>& g, TStatement& left_node_id, TStatement& right_node_id, TStatement& attr_list, TNodeAttributes& nodeMap, TEdgeAttributes& edgeMap, TNodeIdMap& nodeIdMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(739)

//____________________________________________________________________________
// _addLetterToOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TPropertyMap, typename TChar> inline void _addLetterToOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TPropertyMap& supplyState, TChar const c);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_oracle.h"(80)

//____________________________________________________________________________
// _addNode

template <typename TSpec, typename TStatement, typename TNodeAttributes, typename TEdgeAttributes, typename TNodeIdMap> inline void _addNode(Graph<TSpec>& g, TStatement& node_id, TStatement& attr_list, TNodeAttributes& nodeMap, TEdgeAttributes&, TNodeIdMap& nodeIdMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(601)

//____________________________________________________________________________
// _addStringToTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeyword, typename TPos> inline void _addStringToTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeyword const& str, TPos const& keywordIndex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_trie.h"(84)

//____________________________________________________________________________
// _assignId

template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es, TId2 const id);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(953)
template <typename TCargo, bool TList, bool TSource, typename TSpec, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TSpec>*, TId2 const);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(964)
template <typename TCargo, bool TList, bool TSource, typename TId2> void _assignId(EdgeStump<TCargo, TList, TSource, false, TreeTag>*, TId2 const);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(974)

//____________________________________________________________________________
// _copyGraph

template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest, bool transpose);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(171)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(217)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest, bool);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(151)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(197)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest, bool transp);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(159)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(183)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest, bool transpose);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(190)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(231)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest, bool transpose);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(152)
template <typename TCargo, typename TSpec> inline void _copyGraph(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(195)

//____________________________________________________________________________
// _createEdgeAttributes

template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Directed<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(224)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Undirected<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(235)
template <typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(246)
template <typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Tree<TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(257)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(279)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(301)

//____________________________________________________________________________
// _createEmptyEdgeAttributes

template <typename TSpec, typename TEdgeAttributes> inline void _createEmptyEdgeAttributes(Graph<TSpec> const& g, TEdgeAttributes& edgeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(205)

//____________________________________________________________________________
// _createNodeAttributes

template <typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(154)
template <typename TSpec, typename TNodeAttributes, typename TNameMap> inline void _createNodeAttributes(Graph<TSpec> const& g, TNodeAttributes& nodeMap, TNameMap const& nameMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(181)

//____________________________________________________________________________
// _createTrieNodeAttributes

template <typename TAlphabet, typename TCargo, typename TSpec, typename TPosition, typename TNodeMap> inline void _createTrieNodeAttributes(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, String<String<TPosition> > pos, TNodeMap& nodeMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(117)

//____________________________________________________________________________
// _createVertices

template <typename TSpec, typename TVertexDescriptor> inline void _createVertices(Graph<TSpec>& g, TVertexDescriptor const maxId);       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(406)

//____________________________________________________________________________
// _getEdgeIdManager

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(156)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(137)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(145)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(146)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getEdgeIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(154)
template <typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(137)

//____________________________________________________________________________
// _getId

template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> const>::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(983)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, true, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, true, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(993)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> const>::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(1003)
template <typename TCargo, bool TList, bool TSource> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TreeTag> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TreeTag>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(1014)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(1025)
template <typename TCargo, bool TList, bool TSource, typename TSpec> inline typename Id<EdgeStump<TCargo, TList, TSource, false, TSpec> >::Type _getId(EdgeStump<TCargo, TList, TSource, false, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(1036)
template <typename TId> inline TId _getId(TId const id);       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(395)

//____________________________________________________________________________
// _getInfinity

template <typename T> inline T _getInfinity();       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(356)
template <> inline double _getInfinity();       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(366)

//____________________________________________________________________________
// _getInfinityDistance

template <typename TWeightMap> inline typename Value<TWeightMap>::Type _getInfinityDistance(TWeightMap const&);       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(375)
template <typename T> inline T _getInfinityDistance();       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(385)

//____________________________________________________________________________
// _getInternalLabel

template <typename TAlphabet, typename TCargo, typename TSpec, typename TString> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type _getInternalLabel(Graph<Automaton<TAlphabet, TCargo, TSpec> >&, TString& str);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(673)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TString> inline String<TAlphabet> _getInternalLabel(Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > >&, TString& str);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(683)

//____________________________________________________________________________
// _getVertexIdManager

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(145)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Undirected<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Undirected<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(126)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(134)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> const & _getVertexIdManager(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(130)
template <typename TCargo, typename TSpec> inline IdManager<typename Id<Graph<Tree<TCargo, TSpec> > >::Type, Default> & _getVertexIdManager(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(138)
template <typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Directed<TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Directed<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(126)

//____________________________________________________________________________
// _getVertexString

template <typename TAlphabet, typename TCargo, typename TSpec> inline String<AutomatonEdgeArray<typename EdgeType<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type, TAlphabet> >& _getVertexString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(134)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Undirected<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Undirected<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(115)
template <typename TAlphabet, typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(123)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Tree<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(119)
template <typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Directed<TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Directed<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(115)

//____________________________________________________________________________
// _goNextInternal

template <typename TGraph, typename TSpec> inline void _goNextInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(283)

//____________________________________________________________________________
// _goPreviousInternal

template <typename TGraph, typename TSpec> inline void _goPreviousInternal(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(354)

//____________________________________________________________________________
// _loadSequences

template <typename TPath, typename TStringSet, typename TNames> inline unsigned int _loadSequences(TPath const& in_path, TStringSet& origStrSet, TNames& names);       	// "seqan-1.3.1/seqan/graph_types/graph_utility_parsing.h"(55)

//____________________________________________________________________________
// _markRootVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(66)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Directed<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(80)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Undirected<TCargo, TSpec> > const&, TVertexDescriptor const&, TAttributes&);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(91)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TAttributes> inline void _markRootVertex(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const& v, TAttributes& str);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(103)

//____________________________________________________________________________
// _processEdgeStatement

template <typename TSpec, typename TStatement, typename TNodeAttributes, typename TEdgeAttributes, typename TPosition, typename TNodeIdMap> inline void _processEdgeStatement(Graph<TSpec>& g, TStatement& stmt, TNodeAttributes& nodeMap, TEdgeAttributes& edgeMap, TPosition pos, TNodeIdMap& nodeIdMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(808)

//____________________________________________________________________________
// _processNodeStatement

template <typename TSpec, typename TStatement, typename TNodeAttributes, typename TEdgeAttributes, typename TNodeIdMap> inline void _processNodeStatement(Graph<TSpec>& g, TStatement& stmt, TNodeAttributes& nodeMap, TEdgeAttributes& edgeMap, TNodeIdMap& nodeIdMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(769)

//____________________________________________________________________________
// _processStatement

template <typename TSpec, typename TStatement, typename TNodeAttributes, typename TEdgeAttributes, typename TNodeIdMap> inline void _processStatement(Graph<TSpec>& g, TStatement& stmt, TNodeAttributes& nodeMap, TEdgeAttributes& edgeMap, TNodeIdMap& nodeIdMap);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(850)

//____________________________________________________________________________
// _rebuildParentMap

template <typename TCargo, typename TSpec> inline void _rebuildParentMap(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(163)

//____________________________________________________________________________
// _writeEdgeType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(425)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(437)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(449)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(461)

//____________________________________________________________________________
// _writeGraphFooter

template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(332)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(343)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(354)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile &, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(366)

//____________________________________________________________________________
// _writeGraphType

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(377)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Directed<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(389)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Undirected<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(401)
template <typename TFile, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Tree<TCargo, TSpec> > const&, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(413)

//____________________________________________________________________________
// addChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor parent);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(911)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TCargo const cargo);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(926)

//____________________________________________________________________________
// addEdge

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(411)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label, TEdgeCargo const cargo);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(433)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor source, TVertexDescriptor target);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(405)
template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(442)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(409)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(422)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(471)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child, TCargo const cargo);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(500)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const & label);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(114)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TChars> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, TChars const* chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(141)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TLabel, typename TEdgeCargo> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type addEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& , TVertexDescriptor const , TVertexDescriptor const , TLabel const , TEdgeCargo const );       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(155)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(573)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo const cargo);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(602)

//____________________________________________________________________________
// addEdges

template <typename TSpec, typename TEdgeArray, typename TSize> inline void addEdges(Graph<TSpec>& dest, TEdgeArray const & edges, TSize const size);       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(436)

//____________________________________________________________________________
// addVertex

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(375)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type addVertex(Graph<Undirected<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(373)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, bool silent);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(321)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(344)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEmission> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, String<TEmission> const& emis);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(355)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEmission> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type addVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TEmission const& emis, bool silent);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(381)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type addVertex(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(421)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type addVertex(Graph<Directed<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(501)

//____________________________________________________________________________
// assignBeginState

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignBeginState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(642)

//____________________________________________________________________________
// assignCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TCargo2 const& t);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(467)
template <bool TList, bool TSource, bool TId, typename TSpec, typename TCargo2> inline void assignCargo(EdgeStump<void, TList, TSource, TId, TSpec>*, TCargo2 const&);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(478)

//____________________________________________________________________________
// assignEmissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TEmisProb> inline void assignEmissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state, TAlphabet const symbol, TEmisProb const eProb);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(965)

//____________________________________________________________________________
// assignEndState

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignEndState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(668)

//____________________________________________________________________________
// assignNextS

template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, true, TId, TSpec>* es, EdgeStump<TCargo, true, true, TId, TSpec>* es2);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(832)
template <typename TCargo, bool TId, typename TSpec> inline void assignNextS(EdgeStump<TCargo, true, false, TId, TSpec>*, EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(844)

//____________________________________________________________________________
// assignNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline void assignNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es, EdgeStump<TCargo, true, TSource, TId, TSpec>* es2);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(739)

//____________________________________________________________________________
// assignProperty

template <typename TPropertyMap, typename TDescriptor, typename TValue> inline void assignProperty(TPropertyMap& pm, TDescriptor const d, TValue const val);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(151)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor const e, TValue const val);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(337)
template <typename T1, typename T2, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor const e, TValue const val);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(349)
template <typename T, typename TEdgeDescriptor, typename TValue> inline void assignProperty(InternalMap<T, 0>&, TEdgeDescriptor const e, TValue const val);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(361)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline void assignProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e, TValue const val);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(570)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline void assignProperty(TValue TClass:: * ptr_to_member, TEdgeDescriptor const e, TValue const val);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(686)

//____________________________________________________________________________
// assignRoot

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(732)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignRoot(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(760)

//____________________________________________________________________________
// assignSilentStatus

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void assignSilentStatus(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex, bool const silent);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(995)

//____________________________________________________________________________
// assignSource

template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es, TVertexDescriptor const s);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(598)
template <typename TCargo, bool TList, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignSource(EdgeStump<TCargo, TList, false, TId, TSpec>*, TVertexDescriptor const);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(609)

//____________________________________________________________________________
// assignTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec, typename TVertexDescriptor> inline void assignTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es, TVertexDescriptor const t);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(504)

//____________________________________________________________________________
// assignTransitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TTransProb> inline void assignTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state1, TVertexDescriptor const state2, TTransProb const t);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(864)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor, typename TTransProb> inline void assignTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >&, TEdgeDescriptor e, TTransProb const t);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(879)

//____________________________________________________________________________
// atBegin

template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(283)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(219)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(209)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(212)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(629)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(639)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(649)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(660)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(670)
template <typename TGraph, typename TSpec> inline bool atBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(238)

//____________________________________________________________________________
// atEnd

template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(330)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(239)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(226)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(229)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(730)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(740)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(750)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(760)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(770)
template <typename TGraph, typename TSpec> inline bool atEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(262)

//____________________________________________________________________________
// beginState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& beginState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(691)

//____________________________________________________________________________
// canParseString

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const & g, TVertexDescriptor const vertex, TCharacters const & chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(965)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const & g, TVertexDescriptor const vertex, TCharacters const * chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(978)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > & g, TCharacters const & chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(991)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TCharacters> inline bool canParseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > & g, TCharacters const * chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(1000)

//____________________________________________________________________________
// cargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(407)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& cargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(417)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(428)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type cargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(439)

//____________________________________________________________________________
// childVertex

template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type childVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(1020)

//____________________________________________________________________________
// clear

template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(308)
template <typename TCargo, typename TSpec> inline void clear(Graph<Undirected<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(318)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clear(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(277)
template <typename TCargo, typename TSpec> inline void clear(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(351)
template <typename TCargo, typename TSpec> inline void clear(Graph<Directed<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(372)

//____________________________________________________________________________
// clearEdges

template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(284)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Undirected<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(262)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(249)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(313)
template <typename TCargo, typename TSpec> inline void clearEdges(Graph<Directed<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(319)

//____________________________________________________________________________
// clearVertices

template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(296)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Undirected<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(306)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(259)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(338)
template <typename TCargo, typename TSpec> inline void clearVertices(Graph<Directed<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(350)

//____________________________________________________________________________
// collectLeaves

template <typename TCargo, typename TSpec, typename TVertexDescriptor, typename TGroup> inline void collectLeaves(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const root, TGroup& group);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(1082)

//____________________________________________________________________________
// createOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_oracle.h"(127)

//____________________________________________________________________________
// createOracleOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TText> inline void createOracleOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TText const text);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_oracle.h"(161)

//____________________________________________________________________________
// createRoot

template <typename TAlphabet, typename TCargo, typename TSpec> inline void createRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(704)
template <typename TCargo, typename TSpec> inline void createRoot(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(775)

//____________________________________________________________________________
// createSetOracle

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createSetOracle(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_oracle.h"(185)

//____________________________________________________________________________
// createSetSuffixTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TTexts> inline void createSetSuffixTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TTexts const& texts);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_trie.h"(250)

//____________________________________________________________________________
// createSuffixTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TText> inline void createSuffixTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TText const& text);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_trie.h"(226)

//____________________________________________________________________________
// createTrie

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrie(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_trie.h"(140)

//____________________________________________________________________________
// createTrieOnReverse

template <typename TAlphabet, typename TCargo, typename TSpec, typename TTerminalStateMap, typename TKeywords> inline void createTrieOnReverse(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TTerminalStateMap& terminalStateMap, TKeywords const& keywords);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_trie.h"(179)

//____________________________________________________________________________
// degree

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(365)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type degree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(364)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type degree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(310)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type degree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(411)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type degree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(478)

//____________________________________________________________________________
// emissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo& emissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state, TAlphabet const symbol);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(934)

//____________________________________________________________________________
// empty

template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(274)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Undirected<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(252)
template <typename TAlphabet, typename TCargo, typename TSpec> inline bool empty(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(239)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(303)
template <typename TCargo, typename TSpec> inline bool empty(Graph<Directed<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(296)

//____________________________________________________________________________
// endState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type& endState(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(711)

//____________________________________________________________________________
// findEdge

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v, TLabel const c);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(622)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline typename EdgeDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TLabel const c);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(636)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type findEdge(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(728)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type findEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(511)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type findEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(679)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Directed<TCargo, TSpec> > >::Type findEdge(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(941)

//____________________________________________________________________________
// fragmentBegin

template <typename TSize, typename TSpec, typename TVal> inline TSize& fragmentBegin(Fragment<TSize, TSpec> const& f, TVal const seqId);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(254)

//____________________________________________________________________________
// fragmentLength

template <typename TSize, typename TSpec, typename TVal> inline TSize& fragmentLength(Fragment<TSize, TSpec> const& f, TVal const);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(266)
template <typename TSize, typename TSpec> inline TSize& fragmentLength(Fragment<TSize, TSpec> const& f);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(283)

//____________________________________________________________________________
// getAdjacencyMatrix

template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(587)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Undirected<TCargo, TSpec> > const& g, TMatrix& mat);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(691)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(500)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Tree<TCargo, TSpec> > const& g, TMatrix& mat);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(648)
template <typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Directed<TCargo, TSpec> > const& g, TMatrix& mat);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(884)

//____________________________________________________________________________
// getBeginState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type getBeginState(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(731)

//____________________________________________________________________________
// getCargo

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(350)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& getCargo(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(360)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> const>::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(370)
template <bool TList, bool TSource, bool TId, typename TSpec> inline typename Cargo<EdgeStump<void, TList, TSource, TId, TSpec> >::Type getCargo(EdgeStump<void, TList, TSource, TId, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(381)

//____________________________________________________________________________
// getEmissionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo getEmissionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const state, TAlphabet const symbol);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(905)

//____________________________________________________________________________
// getEndState

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type getEndState(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(751)

//____________________________________________________________________________
// getIdLowerBound

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type getIdLowerBound(IdManager<TIdType, TSpec> const& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(270)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type getIdLowerBound(IdManager<void, TSpec> const&);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(450)

//____________________________________________________________________________
// getIdUpperBound

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type getIdUpperBound(IdManager<TIdType, TSpec> const& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(248)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type getIdUpperBound(IdManager<void, TSpec> const& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(438)

//____________________________________________________________________________
// getNextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* getNextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(922)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* getNextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(932)

//____________________________________________________________________________
// getNextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(795)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* getNextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(806)

//____________________________________________________________________________
// getNil

template <typename T> inline T getNil(T *);       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(332)
template <typename T> inline T getNil();       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(341)

//____________________________________________________________________________
// getProjectedPosition

template <typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactFragment<TSpec> > const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(314)
template <typename TSize, typename TSpec, typename TValue, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactFragment<TSpec> > const& f, TValue seg_num, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(344)
template <typename TSize, typename TSpec, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactReversableFragment<TSpec> > const& f, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(376)
template <typename TSize, typename TSpec, typename TValue, typename TId1, typename TPosition1, typename TId2, typename TPosition2> inline void getProjectedPosition(Fragment<TSize, ExactReversableFragment<TSpec> > const& f, TValue seg_num, TId1 const seqId, TPosition1 const pos, TId2& seqId2, TPosition2& pos2);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(408)

//____________________________________________________________________________
// getProperty

template <typename TPropertyMap, typename TDescriptor> inline typename GetValue<TPropertyMap const>::Type getProperty(TPropertyMap const& pm, TDescriptor const d);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(224)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type getProperty(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(438)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type getProperty(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(449)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type getProperty(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(460)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type getProperty(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(471)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type getProperty(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(482)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type getProperty(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(493)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(603)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type getProperty(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(615)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue getProperty(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(709)

//____________________________________________________________________________
// getRoot

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(784)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type getRoot(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(795)

//____________________________________________________________________________
// getSource

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(678)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(688)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> const>::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(698)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type getSource(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(709)

//____________________________________________________________________________
// getSuccessor

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TChar> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type getSuccessor(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor vertex, TChar const c);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(848)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const& chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(224)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type getSuccessor(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor vertex, TCharacters const* chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(245)

//____________________________________________________________________________
// getTarget

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> const>::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(560)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type getTarget(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(570)

//____________________________________________________________________________
// getTransitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo getTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const state1, TVertexDescriptor const state2);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(779)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline TCargo getTransitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(794)

//____________________________________________________________________________
// getValue

template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(200)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(179)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(177)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(179)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(503)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(513)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(523)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(533)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(543)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type getValue(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(198)

//____________________________________________________________________________
// goBegin

template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(306)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(229)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(218)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(221)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(680)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(690)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(700)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(710)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(720)
template <typename TGraph, typename TSpec> inline void goBegin(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(249)

//____________________________________________________________________________
// goEnd

template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(352)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(249)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(234)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(237)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(780)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(790)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(800)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(811)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(821)
template <typename TGraph, typename TSpec> inline void goEnd(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(272)

//____________________________________________________________________________
// goNext

template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(375)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(259)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(242)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(245)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(831)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(841)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(851)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(861)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(874)
template <typename TGraph, typename TSpec> inline void goNext(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(305)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(315)

//____________________________________________________________________________
// goPrevious

template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(420)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(292)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(915)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(929)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(943)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(957)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(980)
template <typename TGraph, typename TSpec> inline void goPrevious(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(380)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(390)

//____________________________________________________________________________
// hostGraph

template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(259)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(209)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(201)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(204)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(619)
template <typename TGraph, typename TSpec> inline typename Host<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type const& hostGraph(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(228)

//____________________________________________________________________________
// idCount

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type idCount(IdManager<TIdType, TSpec> const& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(295)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type idCount(IdManager<void, TSpec> const& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(461)

//____________________________________________________________________________
// idInUse

template <typename TIdType, typename TSpec, typename TId> inline bool idInUse(IdManager<TIdType, TSpec> const& idm, TId const id);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(319)
template <typename TSpec, typename TId> inline bool idInUse(IdManager<void, TSpec> const&, TId const);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(473)

//____________________________________________________________________________
// inDegree

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(338)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type inDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(352)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type inDegree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(299)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type inDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(384)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type inDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(435)

//____________________________________________________________________________
// isLeaf

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isLeaf(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(830)

//____________________________________________________________________________
// isReversed

template <typename TSize, typename TSpec> inline bool isReversed(Fragment<TSize, ExactReversableFragment<TSpec> > const& f);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(445)

//____________________________________________________________________________
// isRoot

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(812)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isRoot(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(806)

//____________________________________________________________________________
// isSilent

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool isSilent(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(1043)

//____________________________________________________________________________
// label

template <typename TSize, typename TSpec, typename TStringSet, typename TVal> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Fragment<TSize, TSpec> const& f, TStringSet& str, TVal const seqId);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(214)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1165)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Alphabet<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type label(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(473)

//____________________________________________________________________________
// nextS

template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(868)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, true, TId, TSpec>* & nextS(EdgeStump<TCargo, true, true, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(878)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(887)
template <typename TCargo, bool TId, typename TSpec> inline EdgeStump<TCargo, true, false, TId, TSpec>* nextS(EdgeStump<TCargo, true, false, TId, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(898)

//____________________________________________________________________________
// nextT

template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(762)
template <typename TCargo, bool TSource, bool TId, typename TSpec> inline EdgeStump<TCargo, true, TSource, TId, TSpec>* & nextT(EdgeStump<TCargo, true, TSource, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(772)

//____________________________________________________________________________
// numChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numChildren(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(880)

//____________________________________________________________________________
// numEdges

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(254)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numEdges(Graph<Undirected<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(232)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type numEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(219)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(269)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numEdges(Graph<Directed<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(257)

//____________________________________________________________________________
// numTreeEdges

template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numTreeEdges(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(855)

//____________________________________________________________________________
// numVertices

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(264)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type numVertices(Graph<Undirected<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(242)
template <typename TAlphabet, typename TCargo, typename TSpec> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type numVertices(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(229)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type numVertices(Graph<Tree<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(293)
template <typename TCargo, typename TSpec> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type numVertices(Graph<Directed<TCargo, TSpec> > const& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(279)

//____________________________________________________________________________
// obtainId

template <typename TIdType, typename TSpec> inline typename Value<IdManager<TIdType, TSpec> >::Type obtainId(IdManager<TIdType, TSpec>& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(156)
template <typename TSpec> inline typename Value<IdManager<void, TSpec> >::Type obtainId(IdManager<void, TSpec>& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(406)

//____________________________________________________________________________
// operator!=

template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(466)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(337)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(293)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(296)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1082)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1094)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1106)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1118)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1130)
template <typename TGraph, typename TSpec> inline bool operator!=(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(442)

//____________________________________________________________________________
// operator*

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(233)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(199)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(193)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(196)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(609)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type operator* (Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(218)

//____________________________________________________________________________
// operator++

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(386)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(397)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(269)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(280)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(262)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(271)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(265)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(274)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(892)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(903)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(331)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator++(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(342)

//____________________________________________________________________________
// operator--

template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(431)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(442)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(302)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(313)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(998)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1009)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(406)
template <typename TGraph, typename TSpec> inline Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > operator--(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it, int);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(417)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & target, Graph<TSpec> const& source);       	// "seqan-1.3.1/seqan/graph_types/graph_interface.h"(458)

//____________________________________________________________________________
// operator==

template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(455)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(326)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(282)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(285)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1022)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1034)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1046)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1058)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1070)
template <typename TGraph, typename TSpec> inline bool operator==(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it1, Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it2);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(430)

//____________________________________________________________________________
// outDegree

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(319)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Undirected<TCargo, TSpec> > >::Type outDegree(Graph<Undirected<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(329)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type outDegree(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(288)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Tree<TCargo, TSpec> > >::Type outDegree(Graph<Tree<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(362)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Directed<TCargo, TSpec> > >::Type outDegree(Graph<Directed<TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(398)

//____________________________________________________________________________
// parentVertex

template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename EdgeDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(1045)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type parentVertex(Graph<Tree<TCargo, TSpec> > const& g, typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(1056)

//____________________________________________________________________________
// parseString

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TIterator & beginIt, TIterator const & endIt);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(889)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TIterator const & beginIt, TIterator const & endIt);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(909)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const& chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(922)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCharacters> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type parseString(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex, TCharacters const* chars);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(934)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor, typename TIterator> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > >::Type parseString(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > > const& g, TVertexDescriptor const vertex, TIterator beginIt, TIterator endIt);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(258)

//____________________________________________________________________________
// property

template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap>::Type property(TPropertyMap& pm, TDescriptor const d);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(182)
template <typename TPropertyMap, typename TDescriptor> inline typename Reference<TPropertyMap const>::Type property(TPropertyMap const& pm, TDescriptor const d);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(193)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> >::Type& property(InternalMap<Pair<T1, T2>, 2>&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(372)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 2> const>::Type& property(InternalMap<Pair<T1, T2>, 2> const&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(383)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> >::Type& property(InternalMap<Pair<T1, T2>, 1>&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(394)
template <typename T1, typename T2, typename TEdgeDescriptor> inline typename Value<InternalMap<Pair<T1, T2>, 1> const>::Type& property(InternalMap<Pair<T1, T2>, 1> const&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(405)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> >::Type& property(InternalMap<T, 0>&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(416)
template <typename T, typename TEdgeDescriptor> inline typename Value<InternalMap<T, 0> const>::Type& property(InternalMap<T, 0> const&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(427)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> >::Type& property(InternalPointerMap<TValue TClass::*, TPMember>&, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(581)
template <typename TClass, typename TValue, TValue TClass:: * TPMember, typename TEdgeDescriptor> inline typename Value<InternalPointerMap<TValue TClass::*, TPMember> const>::Type& property(InternalPointerMap<TValue TClass::*, TPMember> const&, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(592)
template <typename TClass, typename TValue, typename TEdgeDescriptor> inline TValue& property(TValue TClass:: * const ptr_to_member, TEdgeDescriptor const e);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(698)

//____________________________________________________________________________
// read

template <typename TFile, typename TSpec, typename TNodeAttributes, typename TEdgeAttributes> void read(TFile & file, Graph<TSpec>& g, TNodeAttributes& nodeMap, TEdgeAttributes& edgeMap, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(900)
template <typename TFile, typename TSpec> void read(TFile & file, Graph<TSpec>& g, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(928)

//____________________________________________________________________________
// releaseAll

template <typename TIdType, typename TSpec> inline void releaseAll(IdManager<TIdType, TSpec>& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(225)
template <typename TSpec> inline void releaseAll(IdManager<void, TSpec>& idm);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(428)

//____________________________________________________________________________
// releaseId

template <typename TIdType, typename TSpec, typename TId> inline void releaseId(IdManager<TIdType, TSpec>& idm, TId const id);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(192)
template <typename TSpec, typename TId> inline void releaseId(IdManager<void, TSpec>& idm, TId const);       	// "seqan-1.3.1/seqan/graph_types/graph_idmanager.h"(418)

//____________________________________________________________________________
// removeAllChildren

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeAllChildren(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(986)

//____________________________________________________________________________
// removeChild

template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeChild(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(958)

//____________________________________________________________________________
// removeEdge

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TLabel> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TLabel const label);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(454)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(469)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(460)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Undirected<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(548)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(434)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(445)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const parent, TVertexDescriptor const child);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(516)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Tree<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(552)
template <typename TAlphabet, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Automaton<TAlphabet, String<TAlphabet>, WordGraph<TSpec> > >& g, TVertexDescriptor const source, TVertexDescriptor const target, String<TAlphabet> const& label);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(169)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(641)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Directed<TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(677)

//____________________________________________________________________________
// removeInEdges

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(508)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(657)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(467)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(581)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(759)

//____________________________________________________________________________
// removeOutEdges

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(485)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(639)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(456)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(563)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(727)

//____________________________________________________________________________
// removeVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(394)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Undirected<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(390)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(396)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Tree<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(446)
template <typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeVertex(Graph<Directed<TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(532)

//____________________________________________________________________________
// resizeEdgeMap

template <typename TSpec, typename TPropertyMap> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(116)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec> const&, InternalMap<TContainer, MemberId>&);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(318)
template <typename TSpec, typename TContainer, unsigned int const MemberId> inline void resizeEdgeMap(Graph<TSpec>&, InternalMap<TContainer, MemberId>&);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(327)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec>&, InternalPointerMap<TPropmap, Instance>&);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(550)
template <typename TSpec, typename TPropmap, TPropmap const Instance> inline void resizeEdgeMap(Graph<TSpec> const&, InternalPointerMap<TPropmap, Instance>&);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(560)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec> const&, TValue TClass:: *);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(666)
template <typename TSpec, typename TClass, typename TValue> inline void resizeEdgeMap(Graph<TSpec>&, TValue TClass:: *);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(675)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeEdgeMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(746)

//____________________________________________________________________________
// resizeVertexMap

template <typename TSpec, typename TPropertyMap> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(86)
template <typename TSpec, typename TPropertyMap, typename TProperties> inline void resizeVertexMap(Graph<TSpec> const& g, TPropertyMap& pm, TProperties const& prop);       	// "seqan-1.3.1/seqan/graph_types/graph_property.h"(728)

//____________________________________________________________________________
// root

template <typename TAlphabet, typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type& root(Graph<Automaton<TAlphabet, TCargo, TSpec> > & g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(758)
template <typename TCargo, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type& root(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(785)

//____________________________________________________________________________
// sequenceId

template <typename TSize, typename TSpec, typename TVal> inline typename Id<Fragment<TSize, TSpec> >::Type sequenceId(Fragment<TSize, TSpec> const& f, TVal const seqId);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_fragment.h"(235)

//____________________________________________________________________________
// silentStatus

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline bool& silentStatus(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const vertex);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(1019)

//____________________________________________________________________________
// source

template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type& source(EdgeStump<TCargo, TList, true, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(619)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, true, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, true, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(629)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec>*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(640)
template <typename TCargo, bool TList, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, false, TId, TSpec> >::Type source(EdgeStump<TCargo, TList, false, TId, TSpec> const*);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(652)

//____________________________________________________________________________
// sourceVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(552)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1141)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type sourceVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(679)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type sourceVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(489)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type sourceVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(453)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type sourceVertex(Graph<Tree<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(623)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type sourceVertex(Graph<Directed<TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(846)

//____________________________________________________________________________
// target

template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type& target(EdgeStump<TCargo, TList, TSource, TId, TSpec>* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(527)
template <typename TCargo, bool TList, bool TSource, bool TId, typename TSpec> inline typename VertexDescriptor<EdgeStump<TCargo, TList, TSource, TId, TSpec> >::Type target(EdgeStump<TCargo, TList, TSource, TId, TSpec> const* es);       	// "seqan-1.3.1/seqan/graph_types/graph_edgestump.h"(537)

//____________________________________________________________________________
// targetVertex

template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Automaton<TAlphabet, TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(540)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Directed<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Directed<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1174)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1184)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Tree<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Tree<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1194)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Undirected<TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Undirected<TCargo, TGraphSpec> > , GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1204)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(1218)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Undirected<TCargo, TSpec> > >::Type targetVertex(Graph<Undirected<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(668)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Hmm<TAlphabet, TCargo, TSpec> > >::Type targetVertex(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(478)
template <typename TGraph, typename TSpec> inline typename VertexDescriptor<TGraph>::Type targetVertex(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(463)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Tree<TCargo, TSpec> > >::Type targetVertex(Graph<Tree<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(612)
template <typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Directed<TCargo, TSpec> > >::Type targetVertex(Graph<Directed<TCargo, TSpec> > const&, TEdgeDescriptor const edge);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(812)

//____________________________________________________________________________
// transitionProbability

template <typename TAlphabet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline TCargo& transitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g, TVertexDescriptor const state1, TVertexDescriptor const state2);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(822)
template <typename TAlphabet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline TCargo& transitionProbability(Graph<Hmm<TAlphabet, TCargo, TSpec> >&, TEdgeDescriptor e);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(836)

//____________________________________________________________________________
// transpose

template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> > const& source, Graph<Automaton<TAlphabet, TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(232)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Automaton<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(242)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const& source, Graph<Undirected<TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(211)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Undirected<TCargo, TSpec> > const&);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(223)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Hmm<TAlphabet, TCargo, TSpec> > const& source, Graph<Hmm<TAlphabet, TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(197)
template <typename TAlphabet, typename TCargo, typename TSpec> inline void transpose(Graph<Hmm<TAlphabet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(207)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> > const& source, Graph<Tree<TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(246)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(257)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> > const& source, Graph<Directed<TCargo, TSpec> >& dest);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(223)
template <typename TCargo, typename TSpec> inline void transpose(Graph<Directed<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(233)

//____________________________________________________________________________
// value

template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalVertexIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_vertex.h"(223)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalAdjacencyIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_adjacency.h"(189)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalBfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_bfs.h"(185)
template <typename TGraph, typename TSpec> inline typename GetValue<Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalDfsIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_dfs.h"(187)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Directed<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(555)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Hmm<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(566)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Tree<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(576)
template <typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Undirected<TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(587)
template <typename TAlphabet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Automaton<TAlphabet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_outedge.h"(597)
template <typename TGraph, typename TSpec> inline typename Reference<Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > > >::Type value(Iter<TGraph, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "seqan-1.3.1/seqan/graph_types/graph_iterator_edge.h"(208)

//____________________________________________________________________________
// write

template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_automaton.h"(652)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Undirected<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_undirected.h"(759)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Hmm<TAlphabet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_hmm.h"(524)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Tree<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_tree.h"(711)
template <typename TFile, typename TAlphabet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Automaton<TAlphabet, TCargo, WordGraph<TSpec> > > const& g, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_wordgraph.h"(187)
template <typename TFile, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Directed<TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "seqan-1.3.1/seqan/graph_types/graph_impl_directed.h"(965)
template <typename TFile, typename TSpec, typename TNodeAttributes, typename TEdgeAttributes> void write(TFile & file, Graph<TSpec> const& g, TNodeAttributes const& nodeMap, TEdgeAttributes const& edgeMap, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(491)
template <typename TFile, typename TSpec, typename TNodeAttributes> inline void write(TFile & file, Graph<TSpec> const& g, TNodeAttributes const& nodeMap, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(554)
template <typename TFile, typename TSpec> inline void write(TFile & file, Graph<TSpec> const& g, DotDrawing);       	// "seqan-1.3.1/seqan/graph_types/graph_drawing.h"(574)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

