 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_ALGORITHMS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_ALGORITHMS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// HeapTree

template <typename TValue , typename TPredicate , typename TSpec > class HeapTree;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(46)

//____________________________________________________________________________
// KeyedHeap

template <typename TSpec > struct KeyedHeap;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(36)

//____________________________________________________________________________
// KeylessHeap

template <typename TSpec > struct KeylessHeap;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(32)

//____________________________________________________________________________
// __MyHeapCompare

template <typename TKey, typename TValue, typename TPredicate> struct __MyHeapCompare;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(329)

//____________________________________________________________________________
// __callLessPair

template <typename TWeight, typename TPair> struct __callLessPair;       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(601)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __backwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TBackwardMatrix> inline TProbability __backwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq, TBackwardMatrix& bMat);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(335)

//____________________________________________________________________________
// __baumWelchAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TSize> inline TProbability __baumWelchAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec > >& hmm, StringSet<TSequence> const& seqSet, TSize maxIter, TProbability epsilon);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(793)

//____________________________________________________________________________
// __fillHmmRandom

template <typename TAlphabet, typename TProbability, typename TSpec> inline void __fillHmmRandom(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(735)

//____________________________________________________________________________
// __fillHmmUniform

template <typename TAlphabet, typename TProbability, typename TSpec> inline void __fillHmmUniform(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(706)

//____________________________________________________________________________
// __forwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TForwardMatrix> inline TProbability __forwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq, TForwardMatrix& fMat);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(216)

//____________________________________________________________________________
// __parameterEstimator

template <typename TAlphabet, typename TProbability, typename TSpec,typename TEmissionCounter, typename TTransitionCounter> inline void __parameterEstimator(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm, TEmissionCounter const& emission, TTransitionCounter const& transition);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(610)

//____________________________________________________________________________
// __weighted_bipartite_matching

template <typename TSpec, typename TVertexMap, typename TWeightMap, typename TEdges> inline typename Value<TWeightMap>::Type __weighted_bipartite_matching(Graph<TSpec>& g, TVertexMap& vertMap, TWeightMap& weightMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1711)

//____________________________________________________________________________
// _bipartite_matching

template <typename TSpec, typename TVertexMap, typename TEdges> inline typename Size<Graph<TSpec> >::Type _bipartite_matching(Graph<TSpec>& g, TVertexMap& vertMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1657)

//____________________________________________________________________________
// _build_residual_graph

template <typename TSpec, typename TCapMap, typename TFlowMap, typename TResidualGraph> void _build_residual_graph(Graph<TSpec> const& g, TCapMap const& capacity, TFlowMap const& flow, TResidualGraph& rG);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1389)

//____________________________________________________________________________
// _cc_visit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TComponents, typename TVal> void _cc_visit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TComponents& components, TVal& label);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(390)

//____________________________________________________________________________
// _collect_Edges

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor1, typename TVertexDescriptor2, typename TEdgeSet> inline bool _collect_Edges(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor1 const source, TVertexDescriptor2 const v, TEdgeSet& edgeSet);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(750)
template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor, typename TEdgeSet> inline bool _collect_Edges(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor const source, TEdgeSet& edgeSet);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(769)

//____________________________________________________________________________
// _dfs_visit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap, typename TVal> void _dfs_visit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish, TVal& time);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(152)

//____________________________________________________________________________
// _extend_shortest_paths

template <typename TMatrix, typename TPredecessor, typename TInfDist> void _extend_shortest_paths(TMatrix& local, TMatrix& w, TPredecessor& predecessor, TInfDist const infDist);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1187)

//____________________________________________________________________________
// _get_minimum_aug

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor> inline typename Size<Graph<TSpec> >::Type _get_minimum_aug(Graph<TSpec> const& rG, TPredecessorMap& predecessor, TVertexDescriptor const source, TVertexDescriptor sink);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1429)

//____________________________________________________________________________
// _initialize_all_pairs

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void _initialize_all_pairs(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& matrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1143)

//____________________________________________________________________________
// _initialize_single_source

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> inline void _initialize_single_source(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(791)

//____________________________________________________________________________
// _insertObject

template <typename TValue, typename TPredicate, typename TSpec, typename TIndex, typename TObject> inline void _insertObject(HeapTree<TValue, TPredicate, KeylessHeap<TSpec> >& mHeap, TIndex i, TObject obj);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(258)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TIndex, typename TObject> inline void _insertObject(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TIndex i, TObject obj);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(420)

//____________________________________________________________________________
// _left

template <typename TSize> inline TSize _left(TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(116)

//____________________________________________________________________________
// _nextInSortedSequence

template <typename TSortedSequence, typename TIterator> inline typename TSortedSequence::const_iterator _nextInSortedSequence(TSortedSequence const& list, TIterator const& prev);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(64)

//____________________________________________________________________________
// _parent

template <typename TSize> inline TSize _parent(TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(132)

//____________________________________________________________________________
// _previousInSortedSequence

template <typename TSortedSequence, typename TKey> inline typename TSortedSequence::const_iterator _previousInSortedSequence(TSortedSequence const& list, TKey const key);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(35)

//____________________________________________________________________________
// _print_all_pairs_shortest_path

template <typename TSpec, typename TPredecessor, typename TVertexDescriptor> inline void _print_all_pairs_shortest_path(Graph<TSpec> const& g, TPredecessor& predecessor, TVertexDescriptor const i, TVertexDescriptor const j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1121)

//____________________________________________________________________________
// _print_path

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor, typename TNameMap> inline void _print_path(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor const source, TVertexDescriptor const v, TNameMap const& nameMap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(711)
template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor1, typename TVertexDescriptor2> inline void _print_path(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor1 const source, TVertexDescriptor2 const v);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(730)

//____________________________________________________________________________
// _relax

template <typename TSpec, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap, typename TVertexDescriptor, typename TEdgeDescriptor> inline void _relax(Graph<TSpec> const& g, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance, TVertexDescriptor const u, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(817)

//____________________________________________________________________________
// _right

template <typename TSize> inline TSize _right(TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(124)

//____________________________________________________________________________
// _swapObjects

template <typename TValue, typename TPredicate, typename TSpec, typename TIndex1, typename TIndex2> inline void _swapObjects(HeapTree<TValue, TPredicate, KeylessHeap<TSpec> >& mHeap, TIndex1 i, TIndex2 j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(244)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TIndex1, typename TIndex2> inline void _swapObjects(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TIndex1 i, TIndex2 j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(394)

//____________________________________________________________________________
// all_pairs_shortest_path

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void all_pairs_shortest_path(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1244)

//____________________________________________________________________________
// backwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence> inline TProbability backwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(484)

//____________________________________________________________________________
// baumWelchAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence> inline TProbability baumWelchAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec > >& hmm, StringSet<TSequence> const& seqSet);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(908)

//____________________________________________________________________________
// bellman_ford_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> bool bellman_ford_algorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(922)

//____________________________________________________________________________
// breadth_first_search

template <typename TSpec, typename TVertexDescriptor, typename TPredecessorMap, typename TDistanceMap> void breadth_first_search(Graph<TSpec> const& g, TVertexDescriptor const source, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(90)

//____________________________________________________________________________
// buildHeap

template <typename TValue, typename TPredicate, typename TSpec, typename TITBegin, typename TITEnd> inline void buildHeap(HeapTree<TValue, TPredicate, TSpec>& mHeap, TITBegin itBeg, TITEnd itEnd);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(222)

//____________________________________________________________________________
// clear

template <typename TValue, typename TPredicate, typename TSpec> inline void clear(HeapTree<TValue, TPredicate, TSpec>& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(282)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec> inline void clear(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(492)

//____________________________________________________________________________
// connected_components

template <typename TSpec, typename TComponents> typename Size<Graph<TSpec> >::Type connected_components(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(424)

//____________________________________________________________________________
// dag_shortest_path

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dag_shortest_path(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(859)

//____________________________________________________________________________
// depth_first_search

template <typename TSpec, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap> void depth_first_search(Graph<TSpec> const& g, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(201)

//____________________________________________________________________________
// dijkstra

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dijkstra(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(994)

//____________________________________________________________________________
// empty

template <typename TValue, typename TPredicate, typename TSpec> inline bool empty(HeapTree<TValue, TPredicate, TSpec> const& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(142)

//____________________________________________________________________________
// estimationWithStates

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequenceSet, typename TStateSeqSet> inline void estimationWithStates(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm, TSequenceSet& sequences, TStateSeqSet& states);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(647)

//____________________________________________________________________________
// floyd_warshall

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void floyd_warshall(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1293)

//____________________________________________________________________________
// ford_fulkerson

template <typename TSpec, typename TVertexDescriptor, typename TCapMap, typename TFlowMap> typename Value<TFlowMap>::Type ford_fulkerson(Graph<TSpec> const& g, TVertexDescriptor const source, TVertexDescriptor const sink, TCapMap const& capacity, TFlowMap& flow);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1488)

//____________________________________________________________________________
// forwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence> inline TProbability forwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(322)

//____________________________________________________________________________
// generateSequence

template <typename TAlphabet, typename TProbability, typename TSpec,typename TSequenceSet, typename TStateSeqSet, typename TSize> inline void generateSequence(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequenceSet& sequences, TStateSeqSet& states, TSize numSeq, TSize maxLength);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(516)
template <typename TAlphabet, typename TProbability, typename TSpec,typename TSequenceSet, typename TSize> inline void generateSequence(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequenceSet& sequences, TSize numSeq, TSize maxLength);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(588)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TStringSet> inline int globalAlignment(TAlign& align, TStringSet const& str, Lcs);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(228)

//____________________________________________________________________________
// heapChangeValue

template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TKey1, typename TValue2> inline void heapChangeValue(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TKey1 key, TValue2 val);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(455)

//____________________________________________________________________________
// heapExtractRoot

template <typename TValue, typename TPredicate, typename TSpec> inline TValue heapExtractRoot(HeapTree<TValue, TPredicate, KeylessHeap<TSpec> >& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(268)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec> inline Pair<TKey, TValue> heapExtractRoot(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(435)

//____________________________________________________________________________
// heapGetValue

template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TKey1> inline TValue heapGetValue(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TKey1 key);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(479)

//____________________________________________________________________________
// heapInsert

template <typename TValue, typename TPredicate, typename TSpec, typename TObject> inline void heapInsert(HeapTree<TValue, TPredicate, TSpec>& mHeap, TObject object);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(181)

//____________________________________________________________________________
// heapRoot

template <typename TValue, typename TPredicate, typename TSpec> inline TValue heapRoot(HeapTree<TValue, TPredicate, TSpec>& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(162)
template <typename TValue, typename TPredicate, typename TSpec> inline TValue heapRoot(HeapTree<TValue, TPredicate, TSpec> const& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(171)

//____________________________________________________________________________
// heapSort

template <typename TITBegin, typename TITEnd, typename TPredicate> inline void heapSort(TITBegin itBeg, TITEnd itEnd, TPredicate);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(294)
template <typename TITBegin, typename TITEnd> inline void heapSort(TITBegin itBeg, TITEnd itEnd);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(317)

//____________________________________________________________________________
// heapify

template <typename TValue, typename TPredicate, typename TSpec, typename TSize> inline void heapify(HeapTree<TValue, TPredicate, TSpec>& mHeap, TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(202)

//____________________________________________________________________________
// heaviestIncreasingSubsequence

template <typename TString, typename TWeightMap, typename TPositions> inline typename Value<TWeightMap>::Type heaviestIncreasingSubsequence(TString const& str, TWeightMap const& weights, TPositions& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(308)

//____________________________________________________________________________
// kruskals_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TEdges> void kruskals_algorithm(Graph<TSpec> const& g, TVertexDescriptor const, TWeightMap const& weight, TEdges& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(629)

//____________________________________________________________________________
// length

template <typename TValue, typename TPredicate, typename TSpec> inline typename Size<HeapTree<TValue, TPredicate, TSpec> >::Type length(HeapTree<TValue, TPredicate, TSpec> const& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(152)

//____________________________________________________________________________
// longestCommonSubsequence

template <typename TString1, typename TString2, typename TNeighborhoodSize, typename TFinalPos> inline void longestCommonSubsequence(TString1 const& str1, TString2 const& str2, TNeighborhoodSize nSize, TFinalPos& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(173)

//____________________________________________________________________________
// longestIncreasingSubsequence

template <typename TString, typename TPositions> inline void longestIncreasingSubsequence(TString const& str, TPositions& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(92)

//____________________________________________________________________________
// path_growing_algorithm

template <typename TSpec, typename TWeightMap, typename TEdgeMap> typename Value<TWeightMap>::Type path_growing_algorithm(Graph<TSpec>& g, TWeightMap const& weightMap, TEdgeMap& edgeMap1);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1579)

//____________________________________________________________________________
// prims_algorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap> void prims_algorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(487)

//____________________________________________________________________________
// prims_algorithm_spaceEfficient

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap> void prims_algorithm_spaceEfficient(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(544)

//____________________________________________________________________________
// randomizeHmm

template <typename TAlphabet, typename TProbability, typename TSpec> inline void randomizeHmm(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(780)

//____________________________________________________________________________
// strongly_connected_components

template <typename TSpec, typename TComponents> void strongly_connected_components(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(311)

//____________________________________________________________________________
// topological_sort

template <typename TSpec, typename TVertexDescriptor> void topological_sort(Graph<TSpec> const& g, String<TVertexDescriptor>& topSort);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(258)

//____________________________________________________________________________
// transitive_closure

template <typename TSpec, typename TMatrix> void transitive_closure(Graph<TSpec> const& g, TMatrix& closure);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1343)

//____________________________________________________________________________
// viterbiAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TPath> inline TProbability viterbiAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq, TPath& path);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(53)

//____________________________________________________________________________
// weighted_bipartite_matching

template <typename TSpec, typename TVertexMap, typename TWeightMap, typename TEdges> inline typename Value<TWeightMap>::Type weighted_bipartite_matching(Graph<TSpec>& g, TVertexMap& vertMap, TWeightMap& weightMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1877)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

