/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/


#ifndef SRKVIDEOPANEL_H
#define SRKVIDEOPANEL_H

#include "srkvideopanelbase.h"

#include <libinstrudeo/isdcommentbox.h>

#include "srkerror.h"

//number of millisecs to poll for changes
#define TIMER_TIMEOUT 40

class QTimer;
class ISDRecording;

class SRKVideoPanel : public SRKVideoPanelBase
{
    Q_OBJECT

 public:
    //-----CONSTRUCTORS-----
    SRKVideoPanel(QWidget* parent = 0, const char* name = 0);
    
    virtual ~SRKVideoPanel();

    /**
     * Loads a recording-file from disk and extracts initial data.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode loadRecording(ISDRecording* recording);

    /**
     * Closes the current recording.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode closeRecording();

    /**
     * Change the zoom factor of the displayed video.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode changeZoomFactor(int factor);

    /**
     * Change the language in which the comments are made.
     *
     * @param lang The new language.
     */
    SRKError::SRKErrorCode changeCommentsLanguage(QString& lang);

    /**
     * Adds a commentbox to the recording at this position.
     *
     * @param type The type of the commentbox.
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode addComment(ISDCommentbox::commentboxType type);
    
    /**
     * Deletes the currently active commentbox. If none is active, nothing happens.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode deleteActiveComment();

    /**
     * Edit the properties of the currently active commentbox. If none is active, nothing happens.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode editActiveCommentProperties();

    /**
     * End the currently active commentbox on the current position. If none is active, nothing happens.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode endActiveCommentHere();

    /**
     * Tell the videocontainer something has changed and it needs to update itself.
     * This updates both the canvas and the comments.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode update();

 signals:
    void firePopupMenu(QString& name, QPoint& pos);
    void fireMarkDirty();

 public slots:
     /**
      * Stops the video, this slot is called when the Stop-button is pressed.
      */
     virtual void stop();

     /**
      * Pauses the video, this slot is called when the Stop-button is pressed.
      */
     virtual void pause();

     /**
      * Starts the video, this slot is called when the Stop-button is pressed.
      */
     virtual void play();

     /**
      * Use this function to aggregate back a popup-call to the main window.
      *
      * @param name The name of the menu in the XMLUI file.
      * @param pos The global position of the mouseclick.
      */
     void popupMenu(QString& name, QPoint& pos);

     /**
      * Callback function for the other widgets to signal a dirty-action.
      */
     void markDirty();

 protected slots:
     /**
      * Increment the videostream with one "position". The smallest gap between two
      * rects is used for this position-unit.
      */
     virtual void incPosition();
     /**
      * Use this function for random access to the video stream.
      *
      * @param position The position to go to (time in milliseconds)
      */
     virtual void updateImage(int position);

 protected:
     //-----METHODS-----
     /**
      * enables/disables the buttons and slider
      */
     void setEnableControls(bool b);
     
     //-----VARIABLES------
     int timerCount;
     bool playing;
     int position;
     QTimer* timer;
     ISDRecording* recording;
     QString currentCommentsLanguage;
};

#endif

