/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef SRKVIDEOCANVAS_H
#define SRKVIDEOCANVAS_H

/**
 * The main video canvas in OpenGL.
 * Depends heavily on the Instrudeo GL-drawing routines.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <string>

#include <qgl.h>

#include "srkerror.h"

using namespace std;

class ISDRecording;

class SRKVideoCanvas : public QGLWidget
{
    Q_OBJECT

 public:
    enum zoomFactor {
	AUTO_ZOOM_FACTOR = -1,
	DEFAULT_ZOOM_FACTOR = -1
    };

    //-----CONSTRUCTORS-----
    SRKVideoCanvas(QWidget* parent = 0, const char* name = 0);

    virtual ~SRKVideoCanvas();

    //-----METHODS-----
    /**
     * Loads a recording-file from disk and extracts initial data.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode loadRecording(ISDRecording* recording);

    /**
     * Closes the current recording.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode closeRecording();    
    
    /**
     * Tell the canvas something has changed and it needs to update itself.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode update();

    /**
     * Change the zoom factor of the displayed video.
     *
     * @return Returns a code that indicates success or failure.
     */
    SRKError::SRKErrorCode changeZoomFactor(int);

 protected:
    //-----OVERLOADED GL METHODS-----
    virtual void initializeGL();
    virtual void resizeGL(int w, int h);
    virtual void paintGL();

    //-----METHODS-----
    /**
     * Calculates the scale factor, according to the current video dimensions,
     * zoomFactor and available space.
     *
     * @return The calculated scale factor.
     */
    float calcScaleFactor();

    //-----VARIABLES-----
    ISDRecording* recording;
    float scaleFactor;
    int zoomFactor;
    bool checkResize;
};

#endif
