/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.5:
 *   smidump -f scli TUNNEL-MIB
 *
 * Derived from TUNNEL-MIB:
 *   The MIB module for management of IP Tunnels,
 *   independent of the specific encapsulation scheme in
 *   use.
 *   
 *   Copyright (C) The Internet Society (2005).  This
 *   version of this MIB module is part of RFC 4087;  see
 *   the RFC itself for full legal notices.
 *
 * Revision 2005-05-16 00:00:
 *   IPv4-specific objects were deprecated, including
 *   tunnelIfLocalAddress, tunnelIfRemoteAddress, the
 *   tunnelConfigTable, and the tunnelMIBBasicGroup.
 *   
 *   Added IP version-agnostic objects that should be used
 *   instead, including tunnelIfAddressType,
 *   tunnelIfLocalInetAddress, tunnelIfRemoteInetAddress,
 *   the tunnelInetConfigTable, and the
 *   tunnelIMIBInetGroup.
 *   
 *   The new tunnelIfLocalInetAddress and
 *   tunnelIfRemoteInetAddress objects are read-write,
 *   rather than read-only.
 *   
 *   Updated DESCRIPTION clauses of existing version-
 *   agnostic objects (e.g., tunnelIfTOS) that contained
 *   IPv4-specific text to cover IPv6 as well.
 *   
 *   Added tunnelIfFlowLabel for tunnels over IPv6.
 *   
 *   The encapsulation method was previously an INTEGER
 *   type, and is now an IANA-maintained textual
 *   convention.
 *   
 *   Published as RFC 4087.
 *
 * Revision 1999-08-24 12:00:
 *   Initial version, published as RFC 2667.
 *
 * $Id: tunnel-mib.c 1996 2006-08-22 22:13:26Z schoenw $
 */

#include "tunnel-mib.h"

GNetSnmpEnum const tunnel_mib_enums_tunnelIfSecurity[] = {
    { TUNNEL_MIB_TUNNELIFSECURITY_NONE,  "none" },
    { TUNNEL_MIB_TUNNELIFSECURITY_IPSEC, "ipsec" },
    { TUNNEL_MIB_TUNNELIFSECURITY_OTHER, "other" },
    { 0, NULL }
};


static guint16 tunnelIfLocalAddress_constraints[] = {4U, 4U, 0, 0};
static guint16 tunnelIfRemoteAddress_constraints[] = {4U, 4U, 0, 0};
static gint32 tunnelIfHopLimit_constraints[] = {0L, 255L, 0, 0};
static gint32 tunnelIfTOS_constraints[] = {-2L, 63L, 0, 0};
static gint32 tunnelIfFlowLabel_constraints[] = {-1L, 1048575L, 0, 0};
static guint16 tunnelIfLocalInetAddress_constraints[] = {0U, 255U, 0, 0};
static guint16 tunnelIfRemoteInetAddress_constraints[] = {0U, 255U, 0, 0};
static gint32 tunnelIfEncapsLimit_constraints[] = {-1L, 255L, 0, 0};
static gint32 tunnelConfigIfIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 tunnelInetConfigIfIndex_constraints[] = {0L, 2147483647L, 0, 0};


static guint32 const tunnelIfEntry_oid[] = {1, 3, 6, 1, 2, 1, 10, 131, 1, 1, 1, 1};

static GNetSnmpAttribute tunnelIfEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_IPADDRESS,
      TUNNEL_MIB_TUNNELIFLOCALADDRESS, "tunnelIfLocalAddress",
       tunnelIfLocalAddress_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfLocalAddress),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_IPADDRESS,
      TUNNEL_MIB_TUNNELIFREMOTEADDRESS, "tunnelIfRemoteAddress",
       tunnelIfRemoteAddress_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfRemoteAddress),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFENCAPSMETHOD, "tunnelIfEncapsMethod",
       NULL,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfEncapsMethod),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFHOPLIMIT, "tunnelIfHopLimit",
       tunnelIfHopLimit_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfHopLimit),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFSECURITY, "tunnelIfSecurity",
       NULL,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfSecurity),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFTOS, "tunnelIfTOS",
       tunnelIfTOS_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfTOS),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFFLOWLABEL, "tunnelIfFlowLabel",
       tunnelIfFlowLabel_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfFlowLabel),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFADDRESSTYPE, "tunnelIfAddressType",
       NULL,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfAddressType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      TUNNEL_MIB_TUNNELIFLOCALINETADDRESS, "tunnelIfLocalInetAddress",
       tunnelIfLocalInetAddress_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfLocalInetAddress),
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, _tunnelIfLocalInetAddressLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      TUNNEL_MIB_TUNNELIFREMOTEINETADDRESS, "tunnelIfRemoteInetAddress",
       tunnelIfRemoteInetAddress_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfRemoteInetAddress),
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, _tunnelIfRemoteInetAddressLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELIFENCAPSLIMIT, "tunnelIfEncapsLimit",
       tunnelIfEncapsLimit_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelIfEntry_t, tunnelIfEncapsLimit),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const tunnelConfigEntry_oid[] = {1, 3, 6, 1, 2, 1, 10, 131, 1, 1, 2, 1};

static GNetSnmpAttribute tunnelConfigEntry_attr[] = {
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELCONFIGIFINDEX, "tunnelConfigIfIndex",
       tunnelConfigIfIndex_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelConfigEntry_t, tunnelConfigIfIndex),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELCONFIGSTATUS, "tunnelConfigStatus",
       NULL,
      G_STRUCT_OFFSET(tunnel_mib_tunnelConfigEntry_t, tunnelConfigStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const tunnelInetConfigEntry_oid[] = {1, 3, 6, 1, 2, 1, 10, 131, 1, 1, 3, 1};

static GNetSnmpAttribute tunnelInetConfigEntry_attr[] = {
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELINETCONFIGIFINDEX, "tunnelInetConfigIfIndex",
       tunnelInetConfigIfIndex_constraints,
      G_STRUCT_OFFSET(tunnel_mib_tunnelInetConfigEntry_t, tunnelInetConfigIfIndex),
      0,
      0 },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELINETCONFIGSTATUS, "tunnelInetConfigStatus",
       NULL,
      G_STRUCT_OFFSET(tunnel_mib_tunnelInetConfigEntry_t, tunnelInetConfigStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      TUNNEL_MIB_TUNNELINETCONFIGSTORAGETYPE, "tunnelInetConfigStorageType",
       NULL,
      G_STRUCT_OFFSET(tunnel_mib_tunnelInetConfigEntry_t, tunnelInetConfigStorageType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};


tunnel_mib_tunnelIfEntry_t *
tunnel_mib_new_tunnelIfEntry()
{
    tunnel_mib_tunnelIfEntry_t *tunnelIfEntry;

    tunnelIfEntry = (tunnel_mib_tunnelIfEntry_t *) g_malloc0(sizeof(tunnel_mib_tunnelIfEntry_t) + sizeof(gpointer));
    return tunnelIfEntry;
}

static inline int
unpack_tunnelIfEntry(GNetSnmpVarBind *vb, tunnel_mib_tunnelIfEntry_t *tunnelIfEntry)
{
    guint8 idx = 13;

    if (vb->oid_len < idx) return -1;
    tunnelIfEntry->ifIndex = vb->oid[idx++];
    if ((tunnelIfEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_tunnelIfEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 13;

    base[idx++] = ifIndex;
    return idx;
}

static inline tunnel_mib_tunnelIfEntry_t *
assign_tunnelIfEntry(GList *vbl)
{
    tunnel_mib_tunnelIfEntry_t *tunnelIfEntry;
    char *p;

    tunnelIfEntry = tunnel_mib_new_tunnelIfEntry();
    p = (char *) tunnelIfEntry + sizeof(tunnel_mib_tunnelIfEntry_t);
    * (GList **) p = vbl;

    if (unpack_tunnelIfEntry((GNetSnmpVarBind *) vbl->data, tunnelIfEntry) < 0) {
        g_warning("%s: invalid instance identifier", "tunnelIfEntry");
        g_free(tunnelIfEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, tunnelIfEntry_oid, G_N_ELEMENTS(tunnelIfEntry_oid),
                      tunnelIfEntry_attr, tunnelIfEntry);

    return tunnelIfEntry;
}

void
tunnel_mib_get_tunnelIfTable(GNetSnmp *s, tunnel_mib_tunnelIfEntry_t ***tunnelIfEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 10, 131, 1, 1, 1, 1, 0};

    *tunnelIfEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 13, 12, tunnelIfEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *tunnelIfEntry = (tunnel_mib_tunnelIfEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(tunnel_mib_tunnelIfEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*tunnelIfEntry)[i] = assign_tunnelIfEntry(row->data);
        }
    }
}

void
tunnel_mib_get_tunnelIfEntry(GNetSnmp *s, tunnel_mib_tunnelIfEntry_t **tunnelIfEntry, gint32 ifIndex, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, tunnelIfEntry_oid, sizeof(tunnelIfEntry_oid));
    len = pack_tunnelIfEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "tunnelIfEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *tunnelIfEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 12, tunnelIfEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *tunnelIfEntry = assign_tunnelIfEntry(out);
    }
}

void
tunnel_mib_set_tunnelIfEntry(GNetSnmp *s, tunnel_mib_tunnelIfEntry_t *tunnelIfEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, tunnelIfEntry_oid, sizeof(tunnelIfEntry_oid));
    len = pack_tunnelIfEntry(base, tunnelIfEntry->ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "tunnelIfEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 12, tunnelIfEntry_attr, mask, tunnelIfEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
tunnel_mib_free_tunnelIfEntry(tunnel_mib_tunnelIfEntry_t *tunnelIfEntry)
{
    GList *vbl;
    char *p;

    if (tunnelIfEntry) {
        p = (char *) tunnelIfEntry + sizeof(tunnel_mib_tunnelIfEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(tunnelIfEntry);
    }
}

void
tunnel_mib_free_tunnelIfTable(tunnel_mib_tunnelIfEntry_t **tunnelIfEntry)
{
    int i;

    if (tunnelIfEntry) {
        for (i = 0; tunnelIfEntry[i]; i++) {
            tunnel_mib_free_tunnelIfEntry(tunnelIfEntry[i]);
        }
        g_free(tunnelIfEntry);
    }
}

tunnel_mib_tunnelConfigEntry_t *
tunnel_mib_new_tunnelConfigEntry()
{
    tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry;

    tunnelConfigEntry = (tunnel_mib_tunnelConfigEntry_t *) g_malloc0(sizeof(tunnel_mib_tunnelConfigEntry_t) + sizeof(gpointer));
    return tunnelConfigEntry;
}

static inline int
unpack_tunnelConfigEntry(GNetSnmpVarBind *vb, tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry)
{
    guint8 idx = 13;
    guint16 i, len;

    len = 4;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        tunnelConfigEntry->tunnelConfigLocalAddress[i] = vb->oid[idx++];
    }
    len = 4;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        tunnelConfigEntry->tunnelConfigRemoteAddress[i] = vb->oid[idx++];
    }
    if (vb->oid_len < idx) return -1;
    tunnelConfigEntry->tunnelConfigEncapsMethod = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    tunnelConfigEntry->tunnelConfigID = vb->oid[idx++];
    if ((tunnelConfigEntry->tunnelConfigID < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_tunnelConfigEntry(guint32 *base, guchar *tunnelConfigLocalAddress, guchar *tunnelConfigRemoteAddress, gint32 tunnelConfigEncapsMethod, gint32 tunnelConfigID)
{
    guint8 idx = 13;
    guint16 i, len;

    len = 4;
    if (len != 4) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = tunnelConfigLocalAddress[i];
        if (idx >= 128) return -1;
    }
    len = 4;
    if (len != 4) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = tunnelConfigRemoteAddress[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = tunnelConfigEncapsMethod;
    base[idx++] = tunnelConfigID;
    return idx;
}

static inline tunnel_mib_tunnelConfigEntry_t *
assign_tunnelConfigEntry(GList *vbl)
{
    tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry;
    char *p;

    tunnelConfigEntry = tunnel_mib_new_tunnelConfigEntry();
    p = (char *) tunnelConfigEntry + sizeof(tunnel_mib_tunnelConfigEntry_t);
    * (GList **) p = vbl;

    if (unpack_tunnelConfigEntry((GNetSnmpVarBind *) vbl->data, tunnelConfigEntry) < 0) {
        g_warning("%s: invalid instance identifier", "tunnelConfigEntry");
        g_free(tunnelConfigEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, tunnelConfigEntry_oid, G_N_ELEMENTS(tunnelConfigEntry_oid),
                      tunnelConfigEntry_attr, tunnelConfigEntry);

    return tunnelConfigEntry;
}

void
tunnel_mib_get_tunnelConfigTable(GNetSnmp *s, tunnel_mib_tunnelConfigEntry_t ***tunnelConfigEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 10, 131, 1, 1, 2, 1, 0};

    *tunnelConfigEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 13, 12, tunnelConfigEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *tunnelConfigEntry = (tunnel_mib_tunnelConfigEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(tunnel_mib_tunnelConfigEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*tunnelConfigEntry)[i] = assign_tunnelConfigEntry(row->data);
        }
    }
}

void
tunnel_mib_get_tunnelConfigEntry(GNetSnmp *s, tunnel_mib_tunnelConfigEntry_t **tunnelConfigEntry, guchar *tunnelConfigLocalAddress, guchar *tunnelConfigRemoteAddress, gint32 tunnelConfigEncapsMethod, gint32 tunnelConfigID, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, tunnelConfigEntry_oid, sizeof(tunnelConfigEntry_oid));
    len = pack_tunnelConfigEntry(base, tunnelConfigLocalAddress, tunnelConfigRemoteAddress, tunnelConfigEncapsMethod, tunnelConfigID);
    if (len < 0) {
        g_warning("%s: invalid index values", "tunnelConfigEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *tunnelConfigEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 12, tunnelConfigEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *tunnelConfigEntry = assign_tunnelConfigEntry(out);
    }
}

void
tunnel_mib_set_tunnelConfigEntry(GNetSnmp *s, tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, tunnelConfigEntry_oid, sizeof(tunnelConfigEntry_oid));
    len = pack_tunnelConfigEntry(base, tunnelConfigEntry->tunnelConfigLocalAddress, tunnelConfigEntry->tunnelConfigRemoteAddress, tunnelConfigEntry->tunnelConfigEncapsMethod, tunnelConfigEntry->tunnelConfigID);
    if (len < 0) {
        g_warning("%s: invalid index values", "tunnelConfigEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 12, tunnelConfigEntry_attr, mask, tunnelConfigEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
tunnel_mib_free_tunnelConfigEntry(tunnel_mib_tunnelConfigEntry_t *tunnelConfigEntry)
{
    GList *vbl;
    char *p;

    if (tunnelConfigEntry) {
        p = (char *) tunnelConfigEntry + sizeof(tunnel_mib_tunnelConfigEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(tunnelConfigEntry);
    }
}

void
tunnel_mib_free_tunnelConfigTable(tunnel_mib_tunnelConfigEntry_t **tunnelConfigEntry)
{
    int i;

    if (tunnelConfigEntry) {
        for (i = 0; tunnelConfigEntry[i]; i++) {
            tunnel_mib_free_tunnelConfigEntry(tunnelConfigEntry[i]);
        }
        g_free(tunnelConfigEntry);
    }
}

tunnel_mib_tunnelInetConfigEntry_t *
tunnel_mib_new_tunnelInetConfigEntry()
{
    tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry;

    tunnelInetConfigEntry = (tunnel_mib_tunnelInetConfigEntry_t *) g_malloc0(sizeof(tunnel_mib_tunnelInetConfigEntry_t) + sizeof(gpointer));
    return tunnelInetConfigEntry;
}

static inline int
unpack_tunnelInetConfigEntry(GNetSnmpVarBind *vb, tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry)
{
    guint8 idx = 13;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    tunnelInetConfigEntry->tunnelInetConfigAddressType = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 115) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        tunnelInetConfigEntry->tunnelInetConfigLocalAddress[i] = vb->oid[idx++];
    }
    tunnelInetConfigEntry->_tunnelInetConfigLocalAddressLength = len;
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 115) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        tunnelInetConfigEntry->tunnelInetConfigRemoteAddress[i] = vb->oid[idx++];
    }
    tunnelInetConfigEntry->_tunnelInetConfigRemoteAddressLength = len;
    if (vb->oid_len < idx) return -1;
    tunnelInetConfigEntry->tunnelInetConfigEncapsMethod = vb->oid[idx++];
    if (vb->oid_len < idx) return -1;
    tunnelInetConfigEntry->tunnelInetConfigID = vb->oid[idx++];
    if ((tunnelInetConfigEntry->tunnelInetConfigID < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_tunnelInetConfigEntry(guint32 *base, gint32 tunnelInetConfigAddressType, guchar *tunnelInetConfigLocalAddress, guint16 _tunnelInetConfigLocalAddressLength, guchar *tunnelInetConfigRemoteAddress, guint16 _tunnelInetConfigRemoteAddressLength, gint32 tunnelInetConfigEncapsMethod, gint32 tunnelInetConfigID)
{
    guint8 idx = 13;
    guint16 i, len;

    base[idx++] = tunnelInetConfigAddressType;
    len = _tunnelInetConfigLocalAddressLength;
    base[idx++] = len;
    if (len > 115) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = tunnelInetConfigLocalAddress[i];
        if (idx >= 128) return -1;
    }
    len = _tunnelInetConfigRemoteAddressLength;
    base[idx++] = len;
    if (len > 115) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = tunnelInetConfigRemoteAddress[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = tunnelInetConfigEncapsMethod;
    base[idx++] = tunnelInetConfigID;
    return idx;
}

static inline tunnel_mib_tunnelInetConfigEntry_t *
assign_tunnelInetConfigEntry(GList *vbl)
{
    tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry;
    char *p;

    tunnelInetConfigEntry = tunnel_mib_new_tunnelInetConfigEntry();
    p = (char *) tunnelInetConfigEntry + sizeof(tunnel_mib_tunnelInetConfigEntry_t);
    * (GList **) p = vbl;

    if (unpack_tunnelInetConfigEntry((GNetSnmpVarBind *) vbl->data, tunnelInetConfigEntry) < 0) {
        g_warning("%s: invalid instance identifier", "tunnelInetConfigEntry");
        g_free(tunnelInetConfigEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, tunnelInetConfigEntry_oid, G_N_ELEMENTS(tunnelInetConfigEntry_oid),
                      tunnelInetConfigEntry_attr, tunnelInetConfigEntry);

    return tunnelInetConfigEntry;
}

void
tunnel_mib_get_tunnelInetConfigTable(GNetSnmp *s, tunnel_mib_tunnelInetConfigEntry_t ***tunnelInetConfigEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 base[] = {1, 3, 6, 1, 2, 1, 10, 131, 1, 1, 3, 1, 0};

    *tunnelInetConfigEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, 13, 12, tunnelInetConfigEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *tunnelInetConfigEntry = (tunnel_mib_tunnelInetConfigEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(tunnel_mib_tunnelInetConfigEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*tunnelInetConfigEntry)[i] = assign_tunnelInetConfigEntry(row->data);
        }
    }
}

void
tunnel_mib_get_tunnelInetConfigEntry(GNetSnmp *s, tunnel_mib_tunnelInetConfigEntry_t **tunnelInetConfigEntry, gint32 tunnelInetConfigAddressType, guchar *tunnelInetConfigLocalAddress, guint16 _tunnelInetConfigLocalAddressLength, guchar *tunnelInetConfigRemoteAddress, guint16 _tunnelInetConfigRemoteAddressLength, gint32 tunnelInetConfigEncapsMethod, gint32 tunnelInetConfigID, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, tunnelInetConfigEntry_oid, sizeof(tunnelInetConfigEntry_oid));
    len = pack_tunnelInetConfigEntry(base, tunnelInetConfigAddressType, tunnelInetConfigLocalAddress, _tunnelInetConfigLocalAddressLength, tunnelInetConfigRemoteAddress, _tunnelInetConfigRemoteAddressLength, tunnelInetConfigEncapsMethod, tunnelInetConfigID);
    if (len < 0) {
        g_warning("%s: invalid index values", "tunnelInetConfigEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *tunnelInetConfigEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 12, tunnelInetConfigEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *tunnelInetConfigEntry = assign_tunnelInetConfigEntry(out);
    }
}

void
tunnel_mib_set_tunnelInetConfigEntry(GNetSnmp *s, tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry, gint64 mask)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, tunnelInetConfigEntry_oid, sizeof(tunnelInetConfigEntry_oid));
    len = pack_tunnelInetConfigEntry(base, tunnelInetConfigEntry->tunnelInetConfigAddressType, tunnelInetConfigEntry->tunnelInetConfigLocalAddress, tunnelInetConfigEntry->_tunnelInetConfigLocalAddressLength, tunnelInetConfigEntry->tunnelInetConfigRemoteAddress, tunnelInetConfigEntry->_tunnelInetConfigRemoteAddressLength, tunnelInetConfigEntry->tunnelInetConfigEncapsMethod, tunnelInetConfigEntry->tunnelInetConfigID);
    if (len < 0) {
        g_warning("%s: invalid index values", "tunnelInetConfigEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 12, tunnelInetConfigEntry_attr, mask, tunnelInetConfigEntry);

    out = gnet_snmp_sync_set(s, in);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
tunnel_mib_free_tunnelInetConfigEntry(tunnel_mib_tunnelInetConfigEntry_t *tunnelInetConfigEntry)
{
    GList *vbl;
    char *p;

    if (tunnelInetConfigEntry) {
        p = (char *) tunnelInetConfigEntry + sizeof(tunnel_mib_tunnelInetConfigEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(tunnelInetConfigEntry);
    }
}

void
tunnel_mib_free_tunnelInetConfigTable(tunnel_mib_tunnelInetConfigEntry_t **tunnelInetConfigEntry)
{
    int i;

    if (tunnelInetConfigEntry) {
        for (i = 0; tunnelInetConfigEntry[i]; i++) {
            tunnel_mib_free_tunnelInetConfigEntry(tunnelInetConfigEntry[i]);
        }
        g_free(tunnelInetConfigEntry);
    }
}


