// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2009-2010 - DIGITEO - Allan CORNET
// Copyright (C) 2010 - DIGITEO - Pierre MARECHAL
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt

// Generate a cleaner.sce script for the toolbox

function tbx_build_cleaner(name,path)

    rhs = argn(2);

    // Number of input arguments

    if and(rhs <> [1 2]) then
        error(msprintf(gettext("%s: Wrong number of input arguments: %d to %d expected.\n"),"tbx_build_cleaner",1,2));
    end

    // Input argument N°1
    // → name

    if type(name) <> 10 then
        error(msprintf(gettext("%s: Wrong type for input argument #%d: A string expected.\n"),"tbx_build_cleaner",1));
    end

    if size(name,"*") <> 1 then
        error(msprintf(gettext("%s: Wrong size for input argument #%d: A string expected.\n"),"tbx_build_cleaner",1));
    end

    // Input argument N°2
    // → path

    if rhs < 2 then
        path = pwd();

    else
        if type(path) <> 10 then
            error(msprintf(gettext("%s: Wrong type for input argument #%d: A string expected.\n"),"tbx_build_cleaner",2));
        end

        if size(path,"*") <> 1 then
            error(msprintf(gettext("%s: Wrong size for input argument #%d: A string expected.\n"),"tbx_build_cleaner",2));
        end

        if ~isdir(path) then
            error(msprintf(gettext("%s: The directory ''%s'' doesn''t exist or is not read accessible.\n"),"tbx_build_cleaner",path));
        end
    end

    // build the cleaner file

    mprintf(gettext("Generating cleaner.sce...\n"));

    cleanertxt = [
        "// This file is released under the 3-clause BSD license. See COPYING-BSD.",
        "// Generated by builder.sce: Please, do not edit this file",
        "",
        "try",
        "    getversion(""scilab"");",
        "catch",
        "    error(""Scilab 5.0 or more is required."");",
        "end",
        "",
        "root_tlbx = get_absolute_file_path(''cleaner.sce'');",
        "",
        "if isfile(root_tlbx + ''/macros/cleanmacros.sce'') then",
        "    exec(root_tlbx+''/macros/cleanmacros.sce'');",
        "end",
        "",
        "if isfile(root_tlbx + ''/src/cleaner_src.sce'') then",
        "    exec(root_tlbx+''/src/cleaner_src.sce'');",
        "end",
        "",
        "if isfile(root_tlbx + ""/sci_gateway/cleaner_gateway.sce"") then",
        "    exec(root_tlbx + ""/sci_gateway/cleaner_gateway.sce"");",
        "    mdelete(root_tlbx + ""/sci_gateway/cleaner_gateway.sce"");",
        "end",
        "",
        "if isfile(root_tlbx + ""/loader.sce"") then",
        "    mdelete(root_tlbx + ""/loader.sce"");",
        "end",
        "",
        "clear root_tlbx;",
        "clear mdelete;"];

    cleanerfile = pathconvert(path+"/cleaner.sce",%F);

    if ~mputl(cleanertxt,cleanerfile) then
        error(msprintf(gettext("%s: The file %s cannot been created, please check if you have write access on this file.\n"),"tbx_build_cleaner",cleanerfile));
    end

endfunction
