/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_options(char * fname)
{
  int * sql_pointer_in = NULL;
  int * option = NULL;
  int m_arg = 0, n_arg = 0, * arg = NULL;
  MYSQL * mysql_ptr_in = NULL;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double result, doption, * darg = NULL;
  char * carg = NULL;
  unsigned int * cuint = NULL;
  int i;

  CheckRhs(3,3);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
  mysql_ptr_in = (MYSQL *)ptr_in;

  if (mysql_ptr_in==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &option);
  getScalarDouble(pvApiCtx, option, &doption);

  switch((enum mysql_option)doption)
    {
    case MYSQL_INIT_COMMAND:
      // MYSQL_INIT_COMMAND (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    case MYSQL_OPT_COMPRESS:
      // MYSQL_OPT_COMPRESS (argument: not used)

      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, NULL);
      break;
    case MYSQL_OPT_CONNECT_TIMEOUT:
      // MYSQL_OPT_CONNECT_TIMEOUT (argument type: unsigned int *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, cuint);
      FREE(cuint);
      break;
    case MYSQL_OPT_GUESS_CONNECTION:
      // MYSQL_OPT_GUESS_CONNECTION (argument: not used)

      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, NULL);
      break;
    case MYSQL_OPT_LOCAL_INFILE:
      // MYSQL_OPT_LOCAL_INFILE (argument type: optional pointer to unsigned int)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, cuint);
      FREE(cuint);
      break;
    case MYSQL_OPT_NAMED_PIPE:
      // MYSQL_OPT_NAMED_PIPE (argument: not used)

      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, NULL);
      break;
    case MYSQL_OPT_PROTOCOL:
      // MYSQL_OPT_PROTOCOL (argument type: unsigned int *)
      // Type of protocol to use. Should be one of the enum values of mysql_protocol_type defined in mysql.h.

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, cuint);
      FREE(cuint);
      break;
    case MYSQL_OPT_READ_TIMEOUT:
      // MYSQL_OPT_READ_TIMEOUT (argument type: unsigned int *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, cuint);
      FREE(cuint);
      break;
    case MYSQL_OPT_RECONNECT:
      // MYSQL_OPT_RECONNECT (argument type: my_bool *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, (my_bool*)cuint);
      FREE(cuint);
      break;
    case MYSQL_SET_CLIENT_IP:
      // MYSQL_SET_CLIENT_IP (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    case MYSQL_OPT_SSL_VERIFY_SERVER_CERT:
      // MYSQL_OPT_SSL_VERIFY_SERVER_CERT (argument type: my_bool *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, (my_bool *)cuint);
      FREE(cuint);
      break;
    case MYSQL_OPT_USE_EMBEDDED_CONNECTION:
      // MYSQL_OPT_USE_EMBEDDED_CONNECTION (argument: not used)

      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, NULL);
      break;
    case MYSQL_OPT_USE_REMOTE_CONNECTION:
      // MYSQL_OPT_USE_REMOTE_CONNECTION (argument: not used)

      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, NULL);
      break;
    case MYSQL_OPT_USE_RESULT:
      // MYSQL_OPT_USE_RESULT (argument: not used)

      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, NULL);
      break;
    case MYSQL_OPT_WRITE_TIMEOUT:
      // MYSQL_OPT_WRITE_TIMEOUT (argument type: unsigned int *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, cuint);
      FREE(cuint);
      break;
    case MYSQL_READ_DEFAULT_FILE:
      // MYSQL_READ_DEFAULT_FILE (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    case MYSQL_READ_DEFAULT_GROUP:
      // MYSQL_READ_DEFAULT_GROUP (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    case MYSQL_REPORT_DATA_TRUNCATION:
      // MYSQL_REPORT_DATA_TRUNCATION (argument type: my_bool *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, (my_bool *)cuint);
      FREE(cuint);
      break;
    case MYSQL_SECURE_AUTH:
      // MYSQL_SECURE_AUTH (argument type: my_bool *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      _SciErr = getMatrixOfDouble(pvApiCtx, arg, &m_arg, &n_arg, &darg);
      cuint = (unsigned int *)MALLOC(m_arg*n_arg*sizeof(unsigned int));
      for(i=0;i<m_arg*n_arg;i++) cuint[i] = (unsigned int)darg[i];
      result = mysql_options(mysql_ptr_in, (enum mysql_option)doption, (my_bool *)cuint);
      FREE(cuint);
      break;
    case MYSQL_SET_CHARSET_DIR:
      // MYSQL_SET_CHARSET_DIR (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    case MYSQL_SET_CHARSET_NAME:
      // MYSQL_SET_CHARSET_NAME (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    case MYSQL_SHARED_MEMORY_BASE_NAME:
      // MYSQL_SHARED_MEMORY_BASE_NAME (argument type: char *)

      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &arg);
      getAllocatedSingleString(pvApiCtx, arg, &carg);
      result = (double)mysql_options(mysql_ptr_in, (enum mysql_option)doption, carg);
      freeAllocatedSingleString(carg);
      break;
    default:
      sciprint("%s: wrong option: %d\n", fname, (int)doption);
    }

  createScalarDouble(pvApiCtx, Rhs+1, result);

  LhsVar(1) = Rhs+1;

  return 0;
}
