//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

path_macros = get_absolute_file_path("buildmacros.sce");
listed = listfiles(path_macros); // liste des sous-repertoires du repertoire 'demos'
macros_rep = []; // liste des sous-repertoires contenant des demos (.sce) (ne commencant pas par '.')

for d = listed'
  if isempty(strindex(d,'.')) & length(findfiles(path_macros+filesep()+d, "*.sci")) <> 0
     macros_rep = [macros_rep; d];
  end
end

directories = path_macros + filesep() + macros_rep;
for i=1:size(directories,"*")
	chdir(directories(i));
	exec("buildmacros.sce");
end
