//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function CL_g_stdaxes(a, colg, ft, fl, fg)
// Sets 'standard' graphic properties
//
// Calling Sequence
// CL_g_stdaxes(a, colg, ft, fl, fg)
//
// Description
// <itemizedlist>
// <listitem>
// Sets some commonly used graphic properties: grid (present), subticks, size of texts, box ("on"). The subticks values are recomputed as the default values don't always seem well chosen. 
// </listitem>
// </itemizedlist>
// <para><emphasis role="bold">( Last updated: 2010-02-17 )</emphasis></para>
//
// Parameters
// a: (optional) Handle of axes. Default is current axes (gca()).
// colg: (optional) Color index of grid. Default is 0 (black).
// ft: (optional) Title size. Default is 3.
// fl: (optional) Size of x-axis and y-axis labels. Default is 2.
// fg: (optional) Size of text (font_size). Default is 2.
//
// Authors
// CNES - DCT/SB (AL)
//
// Examples
// f=scf();
// a=gca();
// x = 0:0.1:5;
// y = x;
// plot2d(x, y);
// CL_g_stdaxes(a);

// Declarations:


// Code:

  if (~exists('a', 'local'))
     a=gca();
  end

  if exists('colg', "local")
    a.grid = [colg,colg];
  else
    a.grid = [0,0];
  end

  if ~exists('ft', "local"); ft = 3; end
  if ~exists('fl', "local"); fl = 2; end
  if ~exists('fg', "local"); fg = 2; end

  //size_ref = a.parent.axes_size(1); // figure size (x) 
  //ft = ft * (size_ref/600);
  //fl = fl * (size_ref/600);
  //fg = fg * (size_ref/600);
  //a.fractional_font = "on"; 

  function [subticks] = Subticks(val1)
    val = gsort(val1, option = 'g', direction='i');
    pas = mean(val(2:$)-val(1:$-1));
    [vmin, vmax, nb] = graduate(0, pas, 3, 6);
    subticks = nb-1;
  endfunction

  a.box="on";
  a.sub_ticks = [ Subticks(a.x_ticks.locations), Subticks(a.y_ticks.locations)]
  a.grid_position = "foreground";
  a.title.font_size = ft;
  a.title.font_style = 8;
  a.x_label.font_size = fl;
  a.y_label.font_size = fl;
  a.font_size = fg;

  //a.x_label.fractional_font = "on"; 
  //a.y_label.fractional_font = "on"; 
  //a.title.fractional_font = "on"; 

endfunction
