//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [kep,jacob] = CL__oe_car2kepHyperb(pos_car,vit_car,parametre,eccentricite,norme_vect_pos,norme_vect_vit,moment_cinetique,...
                                          norme_moment_cinetique,un_sur_a,pos_fois_vit,mu)


// Declarations:
global %CL_epsilon %CL_mu;

// Code:

[lhs,rhs] = argn();
if rhs==2 then mu=%CL_mu; end
if lhs==2
  compute_jacob=%t
  jacob=[];
else
  compute_jacob=%f
end

N = size(pos_car,2)

kep = zeros(6,N)

deuxpi = 2*%pi
r = norme_vect_pos       // norme vecteur position
v = norme_vect_vit       // norme vecteur vitesse

rxv1 = moment_cinetique(1,:)  //
rxv2 = moment_cinetique(2,:)  //produit vectoriel (position x vitesse)
rxv3 = moment_cinetique(3,:)  //

rxv  = norme_moment_cinetique //norme du vecteur produit vectoriel (position x vitesse)

rxvn2 = rxv.^2

nrxv1 = rxv1 ./ rxv
nrxv2 = rxv2 ./ rxv
nrxv3 = rxv3 ./ rxv

p = parametre    //parametre p=(rxv*rxv)/mu=parametre ( donc > 0 )

// demi-grand axe

kep(1,:) = 1.0 ./ un_sur_a

// eccentricite
kep(2,:) = eccentricite

// inclinaison sur le plan equatorial
rxvsxi = sqrt(rxv1.^2 + rxv2.^2)  //avec rxvsxi non nul si inclinaison non nulle
sxi = rxvsxi./rxv //sinus(inclinaison)

eps_equa = %CL_epsilon.equa
if find(sxi < eps_equa)~=[] then CL__error('equatorial orbit'); end

cxi = nrxv3                   //cosinus(inclinaison)
kep(3,:) = CL__sc2angle(cxi,sxi)  //calcul de l'inclinaison par appel a mu_angle2
                              //(resultat dans [0,pi] car sin(inclinaison) > 0)

// longitude du noeud ascendant
rsicgo = - rxv2
rsisgo =   rxv1
kep(5,:) = CL__sc2angle(rsicgo,rsisgo)

// argument du perigee
// perigee + anomalie vraie
aspov = pos_car(3,:)
acpov = nrxv1.*pos_car(2,:) - nrxv2.*pos_car(1,:)
pov = CL__sc2angle(acpov,aspov)
recav = p - r

resav = pos_fois_vit.*sqrt(p./mu)

av = CL__sc2angle(recav,resav)  //anomalie vraie

po = pov - av
kep(4,:) = pmodulo(po,deuxpi) //d'ou l'argument du perigee

//anomalie moyenne
//calculs intermediaires
rusamu = sqrt(un_sur_a./mu)

bux = sqrt(rxvn2 + mu./un_sur_a)  //rxvn2 est non nul et (mu et un_sur_a) sont > 0 donc bux non nul
unsbux = 1.0./bux

cux = pos_fois_vit.*unsbux //sinus hyperbolique de l'anomalie eccentrique hyperbolique: sinh(h)
                          //remarque: pos_fois_vit peut etre <= 0

dux = (1 + r.*un_sur_a) ./ eccentricite //cosinus hyperbolique de l'anomalie eccentrique hyperbolique: cosh(h)
                                        //remarque: e > 1 et a non nul donc division possible
                                        //de plus cosh(h) > 0 compte tenu des parametres de calcul

somme = cux + dux
kep(6,:) = pos_fois_vit .* rusamu - log(somme)//   calcul de l'anomalie moyenne


// Jacobienne
if compute_jacob

   //calcul derivees

   // calcul derivees intermediaires

   // derivees normes vecteurs position, vitesse, et r x v
   drdx = zeros(6,N)
   dvdx = zeros(6,N)
   drdx (1:3,:) = pos_car./(r.*.ones(3,1))
   dvdx (1:3,:) = 0
   drdx (4:6,:) = 0
   dvdx (4:6,:) = vit_car./(v.*.ones(3,1))

   drxv1 = zeros(6,N)
   drxv1(1,:) = 0
   drxv1(2,:) =  vit_car(3,:)
   drxv1(3,:) = -vit_car(2,:)
   drxv1(4,:) = 0
   drxv1(5,:) = -pos_car(3,:)
   drxv1(6,:) =  pos_car(2,:)

   drxv2 = zeros(6,N)
   drxv2(1,:) = -vit_car(3,:)
   drxv2(2,:) = 0
   drxv2(3,:) =  vit_car(1,:)
   drxv2(4,:) =  pos_car(3,:)
   drxv2(5,:) = 0
   drxv2(6,:) = -pos_car(1,:)

   drxv3 = zeros(6,N)
   drxv3(1,:) =  vit_car(2,:)
   drxv3(2,:) = -vit_car(1,:)
   drxv3(3,:) = 0
   drxv3(4,:) = -pos_car(2,:)
   drxv3(5,:) =  pos_car(1,:)
   drxv3(6,:) = 0

   drxv = drxv1.*(nrxv1.*.ones(6,1)) + drxv2.*(nrxv2.*.ones(6,1)) + drxv3.*(nrxv3.*.ones(6,1))

   // derivees produit rscalaire
   dpos_fois_vit = zeros(6,N)
   dpos_fois_vit(1:3,:)= vit_car
   dpos_fois_vit(4:6,:)= pos_car

   // derivees du parametre p
   rxvsmu = 2.0 .* rxv ./ mu
   dpdx = rxvsmu.*.ones(6,1) .*drxv

   // calcul derivees demi-grand axe a
   cof = -2.0./(un_sur_a.^2)
   cof1 = cof./(r.^2)
   cof2 = cof.*v./mu
   dadx = zeros(6,N)
   dadx(1:3,:) = cof1.*.ones(3,1) .*drdx(1:3,:)
   dadx(4:6,:) = cof2.*.ones(3,1) .*dvdx(4:6,:)

   // calcul derivees de l'eccentricite e
   sur2ea = 0.5.*un_sur_a./eccentricite
   //avec eccentricite > 1.
   psura = p.*un_sur_a
   dedx = (dpdx - psura.*.ones(6,1) .*dadx).*(sur2ea.*.ones(6,1))

   // calcul derivees inclinaison
   dxidx = (cxi.*.ones(6,1) .*drxv - drxv3)./(rxvsxi.*.ones(6,1))

   // calcul derivees noeud ascendant
   rxvsi2 = rxvsxi.^2
   dgodx = (rxv1.*.ones(6,1) .*drxv2 - rxv2.*.ones(6,1) .*drxv1)./(rxvsi2.*.ones(6,1))


   // calcul derivees perigee
   //     po = pov - av --> dpodx(i)=dpovdx(i)-davdx(i)
   //     r*sxi * spov = aspov = pos_car(3)
   //     r*sxi * cpov = acpov
   rsxi2 = (r.*sxi).^2   //avec rsxi2 non nul si inclinaison non nulle et r non nul
   dacpov = (drxv1.*(pos_car(2,:).*.ones(6,1)) - drxv2.*(pos_car(1,:).*.ones(6,1)) - ...
            acpov.*.ones(6,1) .* drxv ) ./ (rxv.*.ones(6,1))
   dacpov(1,:)  = dacpov(1,:) - nrxv2
   dacpov(2,:)  = dacpov(2,:) + nrxv1

   dpovdx = -pos_car(3,:).*.ones(6,1) .*dacpov ./ (rsxi2.*.ones(6,1))
   dpovdx(3,:) = dpovdx(3,:) + acpov./rsxi2

   //r*eccentricite*cav = recav = p - r
   //r*eccentricite*sav = resav = pos_fois_vit*sqrt(p/mu) = pos_fois_vit*rxv/mu

   re2 = (r.*eccentricite).^2 //avec eccentricite > 1 et r non nul
   dresav = (dpos_fois_vit.*(rxv.*.ones(6,1)) + pos_fois_vit.*.ones(6,1) .*drxv) ./mu
   davdx = (-resav.*.ones(6,1) .*(dpdx-drdx) + recav.*.ones(6,1) .*dresav)./(re2.*.ones(6,1))

   dpodx = dpovdx - davdx


   // calcul derivees anomalie moyenne
   //     derivees de termes intermediaires utilises dans le calcul de xm
   scal2a = 0.5.*pos_fois_vit.*un_sur_a
   demimu = 0.5.*mu
   scasbu = pos_fois_vit.*unsbux
   daux = rusamu.*.ones(6,1) .*(dpos_fois_vit - scal2a.*.ones(6,1) .*dadx)
   dbux = (demimu.*dadx + rxv.*.ones(6,1) .*drxv) .* (unsbux.*.ones(6,1))
   dcux = (dpos_fois_vit - scasbu.*.ones(6,1) .*dbux) .* (unsbux.*.ones(6,1))

   dxmdx = daux - dcux./(dux.*.ones(6,1))

   // affectation de la jacobienne de la transformation
  jacob = hypermat([6 6 N])
  for i=1:N
    jacob(:,:,i) = [dadx(:,i)'; dedx(:,i)'; dxidx(:,i)'; dpodx(:,i)'; dgodx(:,i)'; dxmdx(:,i)'];
  end

  if N==1 then jacob=jacob(:,:,1); end

end

endfunction
