//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [kep,jacob]=CL__oe_car2kepEllip(pos_car,vel_car,eccentricity,norm_pos,norm_vel,one_over_a,...
                                      kinetic_moment,pos_vel,mu)
// Authors
// CNES - DCT/SB
//
// Bibliography
// MSLIB 90
//

// Declarations:
global %CL_epsilon %CL_mu;

// Code:

[lhs,rhs] = argn();
if rhs==2 then mu=%CL_mu; end
if lhs==2
  compute_jacob=%t
  jacob=[];
else
  compute_jacob=%f
end

N = size(pos_car,2)

kep = zeros(6,N)

unsmu = 1.0 / mu

r  = norm_pos
r2 = r.^2

unsurr = 1.0 ./ r
v  = norm_vel
v2 = v.^2

a = 1.0 ./ one_over_a       // calcul du demi-grand axe

rmua = sqrt(mu.*a)
unrmua = 1.0 ./ rmua

ecose = r.*v2.*unsmu-1
esine = pos_vel.*unrmua

anome = CL__sc2angle(ecose,esine)  //calcul de l'anomalie eccentrique

cose = ecose./eccentricity
sine = esine./eccentricity

xmoy = anome-esine // calcul de l'anomalie moyenne


//calcul de l'inclinaison
//calculs intermediaires
unsna = sqrt(a.*unsmu)
unme2 = 1-eccentricity.^2
unsrac = 1.0 ./ sqrt(unme2)
rec6ua = vel_car(3,:).*unsna
rec3sr = pos_car(3,:).*unsurr

pz = cose.*rec3sr-sine.*rec6ua      //  sin(inclinaison)*sin(petit omega)
cqz = sine.*rec3sr+(cose-eccentricity).*rec6ua
qz = unsrac.*cqz                   //  sin(inclinaison)*cos(petit omega)
crz = unrmua.*unsrac

cosi = crz.*kinetic_moment(3,:)    //  cos(inclinaison)
sini = sqrt(pz.^2+qz.^2)          //  sin(inclinaison)

if find(sini<%CL_epsilon.equa)~=[] then CL__error('equatorial orbit'); end

unsini = 1.0 ./ sini
coti = cosi.*unsini

//calcul de l'inclinaison par appel a mu_angle2
//    (resultat dans [0,pi] car sin(inclinaison) > 0)
xi = CL__sc2angle(cosi,sini)

sino = pz.*unsini
coso = qz.*unsini

om = CL__sc2angle(coso,sino)   // calcul de l'argument du perigee

rx = crz.*kinetic_moment(1,:)
ry = crz.*kinetic_moment(2,:)

sig = rx.*unsini
cog = -ry.*unsini

gom = CL__sc2angle(cog,sig)  // calcul de l'ascension droite du noeud ascendant

// affectation des parametres osculateurs
kep(1,:) = a;
kep(2,:) = eccentricity;
kep(3,:) = xi;
kep(4,:) = om;
kep(5,:) = gom;
kep(6,:) = xmoy;

//JACOB
if compute_jacob

  drdx = zeros(6,N)
  drdx(1:3,:) = pos_car.* (unsurr.*.ones(3,1))
  drdx(4:6,:) = 0

  cof0 = 2 .* a.^2
  cof1 = cof0./(r2.*r)
  cof2 = cof0.*unsmu

  dadx = zeros(6,N)
  dadx(1:3,:) = (cof1.*.ones(3,1)).*pos_car   //     derivees du demi-grand axe a
  dadx(4:6,:) = (cof2.*.ones(3,1)).*vel_car   //

  cof1 = v2.*unsmu.*unsurr
  cof2 = 2.0 .* r .* unsmu

  f1 = zeros(6,N)
  f1(1:3,:) = (cof1.*.ones(3,1)).*pos_car
  f1(4:6,:) = (cof2.*.ones(3,1)).*vel_car

  dpos_vel = zeros(6,N)
  dpos_vel(1:3,:) = vel_car
  dpos_vel(4:6,:) = pos_car

  cof0 = 0.5 .* pos_vel .* one_over_a

  f2 = ( dpos_vel-(cof0.*.ones(6,1)).*dadx ) .* (unrmua.*.ones(6,1))

  cosese = cose./eccentricity
  sinese = sine./eccentricity
  dedx = (cose.*.ones(6,1)).*f1 + (sine.*.ones(6,1)).*f2      // derivees de l'eccentricity
  danedx = (cosese.*.ones(6,1)).*f2 - (sinese.*.ones(6,1)).*f1 // derivees de l'anomalie eccentrique

  dusna = 0.5 .* unrmua
  dusra = eccentricity.*unsrac./unme2
  dusna2 = -dusna.*one_over_a

  cosesr = cose.*unsurr
  sinesr = sine.*unsurr

  dpz = danedx.*((-sine.*rec3sr-cose.*rec6ua).*.ones(6,1)) + ...
        drdx.*((-cosesr.*rec3sr).*.ones(6,1)) + ...
        dadx.*((-sine.*dusna.*vel_car(3,:)).*.ones(6,1));

  dqz = ((dusra.*cqz).*.ones(6,1)).*dedx + ...
        (unsrac.*.ones(6,1)).*( ...
        danedx.*((cose.*rec3sr-sine.*rec6ua).*.ones(6,1)) + ...
        drdx.*((-sinesr.*rec3sr).*.ones(6,1)) + ...
        dadx.*(((cose-eccentricity).*dusna.*vel_car(3,:)).*.ones(6,1)) + ...
        dedx.*(-rec6ua.*.ones(6,1)) ...
        );

  dcr = ((dusna2.*unsrac).*.ones(6,1)).*dadx + ((unrmua.*dusra).*.ones(6,1)).*dedx
  drz = dcr.*(kinetic_moment(3,:).*.ones(6,1))

  dpz(3,:) = dpz(3,:)+cosesr
  dpz(6,:) = dpz(6,:)-sine.*unsna
  dqz(3,:) = dqz(3,:)+unsrac.*sinesr
  dqz(6,:) = dqz(6,:)+unsrac.*(cose-eccentricity).*unsna
  drz(1,:) = drz(1,:)+vel_car(2,:).*crz
  drz(2,:) = drz(2,:)-vel_car(1,:).*crz
  drz(4,:) = drz(4,:)-pos_car(2,:).*crz
  drz(5,:) = drz(5,:)+pos_car(1,:).*crz

  didx = (coti.*.ones(6,1)).*((pz.*.ones(6,1)).*dpz + (qz.*.ones(6,1)).*dqz) - (sini.*.ones(6,1)).*drz      //     derivees de l'inclinaison

  css = coso.*unsini
  sss = sino.*unsini
  domdx = (css.*.ones(6,1)).*dpz - (sss.*.ones(6,1)).*dqz   //     derivees de l'argument du perigee

  drx = dcr.*(kinetic_moment(1,:).*.ones(6,1))
  dry = dcr.*(kinetic_moment(2,:).*.ones(6,1))

  drx(2,:) = drx(2,:)+vel_car(3,:).*crz
  dry(3,:) = dry(3,:)+vel_car(1,:).*crz
  drx(3,:) = drx(3,:)-vel_car(2,:).*crz
  dry(1,:) = dry(1,:)-vel_car(3,:).*crz
  drx(5,:) = drx(5,:)-pos_car(3,:).*crz
  dry(6,:) = dry(6,:)-pos_car(1,:).*crz
  drx(6,:) = drx(6,:)+pos_car(2,:).*crz
  dry(4,:) = dry(4,:)+pos_car(3,:).*crz

  css = cog.*unsini
  sss = sig.*unsini
  dgodx = (css.*.ones(6,1)).*drx + (sss.*.ones(6,1)).*dry   //     derivees de l'ascension droite

  cof0 = 1 - ecose
  dmdx = danedx.*(cof0.*.ones(6,1)) - (sine.*.ones(6,1)).*dedx   //     derivees de l'anomalie moyenne

  // affectation de la jacobienne de la transformation
  jacob = hypermat([6 6 N])
  for i=1:N
    jacob(:,:,i) = [dadx(:,i)'; dedx(:,i)'; didx(:,i)'; domdx(:,i)'; dgodx(:,i)'; dmdx(:,i)'];
  end

  if N==1 then jacob=jacob(:,:,1); end
end

endfunction
