# coding=UTF8
#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2009 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Unit tests for schooltool.intervention.generations.evolve2
"""

from datetime import datetime
import unittest
import doctest

from zope.app.generations.utility import getRootFolder

from schooltool.generations.tests import ContextStub
from schooltool.intervention.generations.tests import provideAdapters
from schooltool.intervention.generations.evolve2 import evolve
from schooltool.intervention.intervention import InterventionMessage
from schooltool.intervention.intervention import InterventionGoal


def doctest_evolve2():
    """Evolution to generation 2.

    First, we'll set up the app object:

        >>> provideAdapters()
        >>> context = ContextStub()
        >>> app = getRootFolder(context)

    We'll set up our test with data that will be effected by running the
    evolve script:

        >>> root = app[u'schooltool.interventions'] = {}
        >>> year = root['2009'] = {}
        >>> student = year['jdoe'] = {}

        >>> messages = student['messages'] = {}
        >>> message1 = messages['1'] = InterventionMessage('', '', '')
        >>> message1.created = datetime.now()

        >>> goals = student['goals'] = {}
        >>> goal1 = goals['1'] = InterventionGoal('', '', '', '', '', '', '', 
        ...                                       '')
        >>> goal1.created = datetime.now()

    Finally, we'll run the evolve script, testing the effected values before and
    after:

        >>> message1.created.tzinfo is None
        True
        >>> goal1.created.tzinfo is None
        True

        >>> evolve(context)

        >>> message1.created.tzinfo is None
        False
        >>> goal1.created.tzinfo is None
        False

    What if the intervention container doesn't exist yet in the
    application:

        >>> context = ContextStub()
        >>> app = getRootFolder(context)
        >>> evolve(context)

    """


def test_suite():
    return unittest.TestSuite([
        doctest.DocTestSuite(optionflags=doctest.ELLIPSIS
                                         | doctest.NORMALIZE_WHITESPACE
                                         | doctest.REPORT_NDIFF
                                         | doctest.REPORT_ONLY_FIRST_FAILURE),
        ])

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')

