# coding=UTF8
#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2009 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Unit tests for schooltool.intervention.generations.evolve5
"""

import unittest
import doctest

from zope.app.testing import setup
from zope.catalog.interfaces import ICatalog
from zope.component import queryUtility, provideUtility
from zope.component.hooks import getSite, setSite
from zope.interface import implements
from zope.intid import IntIds
from zope.intid.interfaces import IIntIds
from zope.site.folder import Folder

from schooltool.app.interfaces import ISchoolToolApplication
from schooltool.generations.tests import ContextStub
from schooltool.intervention.generations.evolve5 import evolve


class AppStub(Folder):
    implements(ISchoolToolApplication)


def doctest_evolve5():
    """Evolution to generation 5.

    We'll need int ids.

        >>> provideUtility(IntIds(), IIntIds)

    We need an app.

        >>> context = ContextStub()
        >>> context.root_folder['app'] = app = AppStub()
        >>> manager = setup.createSiteManager(app)

    Let's evolve now.

        >>> evolve(context)

    Site was restored after evolution.

        >>> print getSite()
        None

    Contact catalog was registered for ISchoolToolApplication sites.

        >>> catalog = queryUtility(ICatalog, 'schooltool.intervention')
        >>> print catalog
        None

        >>> setSite(app)

        >>> catalog = queryUtility(ICatalog, 'schooltool.intervention')
        >>> catalog
        <zc.catalog.extentcatalog.Catalog object ...>

    Catalog indexes were set up properly.

        >>> sorted(i.__name__ for i in catalog.values())
        [u'created', u'first_name', u'intervention_type', u'last_name',
         u'persons_responsible', u'schoolYearId']

    """


def setUp(test):
    setup.placefulSetUp()
    setSite()

def tearDown(test):
    setup.placefulTearDown()
    setSite()


def test_suite():
    return unittest.TestSuite([
        doctest.DocTestSuite(setUp=setUp, tearDown=tearDown,
                             optionflags=doctest.ELLIPSIS
                             | doctest.NORMALIZE_WHITESPACE
                             | doctest.REPORT_NDIFF
                             | doctest.REPORT_ONLY_FIRST_FAILURE),
        ])

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')

